/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;

public class ErrorPacket
extends ResultPacket {
    private final short errorNumber;
    private final byte sqlStateMarker;
    private final byte[] sqlState;
    private final String message;

    public ErrorPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        reader.readByte();
        this.errorNumber = reader.readShort();
        this.sqlStateMarker = reader.readByte();
        if (this.sqlStateMarker == 35) {
            this.sqlState = reader.readRawBytes(5);
            this.message = reader.readString("UTF-8");
        } else {
            byte[] msgBuf = new byte[reader.getRemainingSize() + 1];
            msgBuf[0] = this.sqlStateMarker;
            int cnt = 1;
            while (reader.getRemainingSize() > 0) {
                byte b = reader.readByte();
                if (b == 0) break;
                msgBuf[cnt++] = b;
            }
            this.message = new String(msgBuf, "UTF-8");
            this.sqlState = "HY000".getBytes("UTF-8");
        }
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.ERROR;
    }

    @Override
    public byte getPacketSeq() {
        return 0;
    }

    public short getErrorNumber() {
        return this.errorNumber;
    }

    public String getSqlState() {
        return new String(this.sqlState);
    }

    public byte getSqlStateMarker() {
        return this.sqlStateMarker;
    }
}

