<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    '_shared.webstatDomainIsSuspended' => 'Website %%domainName%% is suspended.',
    '_shared.webstatHostingNotConfigured' => 'There is no hosting configured on %%domainName%%.',
    '_shared.webstatNotSelected' => 'You did not select a web statistics program to be used for website at %%domainName%%.',
    '_shared.domainDisabled' => 'This domain (website) was disabled by hosting provider.',
    '_shared.domainSuspended' => 'This domain (website) was suspended by hosting provider.',
    '_shared.operationSelectorHint' => 'To proceed with the operation, please select a webspace.',
    '_shared.operationSelectorTitle' => 'Webspace',

    'change-hosting.title' => 'Change Hosting Type',

    'change-status-alias.activated' => 'The domain alias %%domainAliasName%% was successfully activated.',
    'change-status-alias.deactivated' => 'The domain alias %%domainAliasName%% was disabled.',
    'change-status-alias.notActivated' => 'The domain alias %%domainAliasName%% cannot be activated because it was disabled by your hosting provider.',

    'change-status.title' => 'Change Website Status',

    'delete.sitesNotSpecified' => 'No sites specified for removal',
    'delete.domainDeletionNotAllowed' => 'Domain deletion is not allowed.',
    'delete.subdomainDeletionNotAllowed' => 'Subdomain deletion is not allowed.',
    'delete.aliasDeletionNotAllowed' => 'Alias deletion is not allowed',
    'delete.domainDeletedSuccessfully' => 'The domain was removed.',
    'delete.subdomainDeletedSuccessfully' => 'The subdomain was removed.',
    'delete.aliasDeletedSuccessfully' => 'The alias was removed.',

    'download-web-deploy-publish-settings.hostingNotConfigured' => 'There is no hosting configured on %%domainName%%.',
    'download-web-deploy-publish-settings.webDeployNotSupported' => 'Web Deploy is not supported.',
    'download-web-deploy-publish-settings.webDeployNotInstalled' => 'Web Deploy is not installed.',
    'download-web-deploy-publish-settings.webDeployNotConfigured' => 'There is no Web Deploy publishing configured on %%domainName%%.',

    'index.title' => 'Websites & Domains',
    'index.home' => 'Home',

    'overview.title' => 'Domain overview',
    'overview.suspended' => 'Suspended',
    'overview.disabled' => 'Disabled',

    'php-settings.title' => 'PHP Settings for %%domainName%%',
    'php-settings.updatedSuccessfully' => 'The settings were successfully updated.',
    'php-settings.showPhpInfoError' => 'Unable to retrieve information about the PHP configuration.',

    'seo-settings.title' => 'SEO settings',
    'seo-settings.description' => 'Set search engine specific settings for your site.',
    'seo-settings.successSaved' => 'SEO setting saved successfully.',

    'settings.title' => 'Hosting Settings',
    'settings.titleForObject' => 'Hosting Settings for %%name%%',
    'settings.updatedSuccessfully' => 'The settings were successfully updated.',

    'site-copy.title' => 'Copy %%siteName%% Files',
    'site-copy.description' => 'Copy the website files to another site of yours hosted under this account or to an FTP storage. Such copying is useful if this is a production website and you are planning to make major site changes. In such a case, you can clone the site to a staging environment and let your designers and programmers work on the clone without interrupting operations of the production site. Copying the site files is a part of cloning the site: You will also need to copy databases used by the site to complete the cloning. If you do not have another site to use as a staging environment, you can add a domain or a subdomain for that purpose.',
    'site-copy.siteCopiedSuccessfully' => 'Files of the site %%sourceName%% were copied to %%destinationName%%.',

    'site-select.domain-aliases-title' => 'Domain Aliases',
    'site-select.domain-aliases-areaDescription' => 'To set up additional domain names for a website, select the website below and click the corresponding Manage link.',
    'site-select.logs-title' => 'Logs Management',
    'site-select.logs-areaDescription' => 'To view the error and access log files for a site, select the website below and click the corresponding View link.',
    'site-select.ssl-certificates-title' => 'SSL/TLS Certificates',
    'site-select.ssl-certificates-areaDescription' => 'To manage SSL/TLS certificates for a website, select the website below and click the corresponding Manage link.',
    'site-select.dns-title' => 'DNS Settings',
    'site-select.dns-areaDescription' => 'DNS is an Internet system which translates a website\'s human-friendly domain name, like example.com, to a computer-friendly IP address, like 192.0.2.13. Such translation is done based on the content of DNS zone files which associate domains with IPs. The zone files of your domains can be stored on this server and you can change their content, or they can be stored on another server. To configure DNS zone for a website, select the website and click the corresponding Manage link.',
    'site-select.databases-title' => 'Databases',
    'site-select.databases-areaDescription' => 'To manage databases used by a website, select the website below and click the corresponding Manage link.',
    'site-select.web-users-title' => 'Web Users',
    'site-select.web-users-areaDescription' => 'To set up user accounts that can host personal web pages under one of your sites, select the website below and click the corresponding Manage link.',
    'site-select.protected-dirs-title' => 'Protected Directories',
    'site-select.protected-dirs-areaDescription' => 'To protect access to a site area with a password, select the website below and click the corresponding Manage link.',
    'site-select.cron-title' => 'Scheduled Tasks',
    'site-select.cron-areaDescription' => 'To automate execution of scripts or programs on the server, select the website below and click the corresponding Manage link.',
    'site-select.bandwidth-limit-title' => 'Bandwidth Limiting',
    'site-select.bandwidth-limit-areaDescription' => 'To view or limit bandwidth usage by a website, select the website below and click the corresponding Manage link.',
    'site-select.hotlink-protection-title' => 'Hotlink Protection',
    'site-select.hotlink-protection-areaDescription' => 'To protect your website files from unauthorized direct linking (hotlinking) from other websites, select the website below and click the corresponding Manage link.',
    'site-select.web-dirs-title' => 'Virtual Directories',
    'site-select.web-dirs-areaDescription' => 'To create and manage virtual directories for a website, select the website below and click the corresponding Manage link.',
    'site-select.iis-app-pool-title' => ' IIS Application Pool',
    'site-select.rdesktop-title' => 'Remote Desktop',
    'site-select.asp-net-settings-title' => 'ASP.NET Setting',
    'site-select.asp-net-settings-areaDescription' => 'To configure ASP.NET framework settings, select the website below and click the corresponding Manage link.',
    'site-select.odbc-data-sources-title' => 'ODBC Data Sources',
    'site-select.odbc-data-sources-areaDescription' => 'To configure ODBC data source names, select the website below and click the corresponding Manage link.',
    'site-select.sitebuilder-title' => 'Presence Builder',
    'site-select.sitebuilder-areaDescription' => 'To create or edit a website with Presence Builder, select the website below and click the corresponding Manage link.',
    'site-select.copy-title' => 'Make Copy of Website',
    'site-select.copy-areaDescription' => 'To copy a website, select the website and click the corresponding Manage link.',
    'site-select.web-deploy-publish-settings-title' => 'Web Deploy Publishing Settings',
    'site-select.web-deploy-publish-settings-areaDescription' => 'When publishing your code to a website using Microsoft WebMatrix, you are asked to specify different settings such as a domain name or a data transfer protocol to set up the connection to your website. You can provide these parameters either manually or as an XML file. Here you can download such file for a certain website by clicking the corresponding Download link.',

    'statistics.show' => 'Show',
    'statistics.webStatistics' => 'Web Statistics',
    'statistics.sslWebStatistics' => 'SSL/TLS Web Statistics',
    'statistics.ftpStatistics' => 'FTP Statistics',
    'statistics.anonymousFtpStatistics' => 'Anonymous FTP Statistics',
    'statistics.hostingNotConfigured' => 'There is no web hosting configured on domain %%domainName%%',
    'statistics.webstatNotSelected' => 'You did not select a web statistics program to be used on domain %%domainName%%',

    'subscription-delete.infoSubscriptionDeleted' => 'The selected webspaces were removed.',
    'subscription-delete.infoSubscriptionNotDeleted' => 'Some of the selected webspaces were not removed.',

    'subscriptions.title' => 'Webspace',
    'subscriptions.buttonRemove' => 'Remove',
    'subscriptions.buttonRemoveDescription' => 'Remove the selected webspaces.',
    'subscriptions.confirmOnDelete' => 'Do you want to remove the selected webspaces?',
    'subscriptions.buttonAddNew' => 'Add Webspace',
    'subscriptions.buttonAddNewDescription' => 'Create a webspace.',
    'subscriptions.buttonMyResources' => 'My Resources',
    'subscriptions.buttonMyResourcesDescription' => 'View available resources.',
    'subscriptions.subscriptionsHintTitle' => 'Webspace Summary',
    'subscriptions.subscriptionsHintWaitMessage' => 'Loading...',

    'view.title' => 'Websites & Domains',
    'view.suspended' => 'Suspended',
    'view.disabled' => 'Disabled',
    'view.buttonDeleteDomain' => 'Remove Website',
    'view.buttonDeleteDomainHint' => 'Removing this website will also delete all related files, directories, and web applications from the server.',
    'view.buttonDeleteSubdomain' => 'Remove Subdomain',
    'view.buttonDeleteSubdomainHint' => 'Removing this website will also delete all related files, directories, and web applications from the server.',
    'view.buttonDeleteAlias' => 'Remove Domain Alias',
    'view.buttonDeleteAliasHint' => 'Remove this alias.',
    'view.warningSubscriptionUsesSNWithoutLicense' => 'Hosting management operations are not allowed for this subscription: %%reason%%. Please contact your service provider.',
    'view.warningSubscriptionIsSuspended' => 'Subscription was suspended. All your sites are not available.',
    'view.warningSubscriptionIsSuspendedByBackupRestore' => 'The subscription is temporarily unavailable because the data backup or restoration is in progress. Please try again later.',
    'view.warningSubscriptionIsSuspended_powerUser' => 'The webspace was suspended. All sites hosted within the webspace are not available.',
    'view.buttonIssAppPoolHint_powerUser' => 'Set up a dedicated IIS application pool for serving websites hosted within the currently selected webspace.',
    'view.buttonSitebuilder' => 'Presence Builder',
    'view.buttonSitebuilderHint' => 'Build instant websites from business and personal templates with the intuitive Presence Builder editor.',
    'view.buttonMobileSites' => 'Mobile Websites',
    'view.buttonMobileSitesHint' => 'Create mobile versions for your websites, and edit their content.',
    'view.buttonApplications' => 'Applications',
    'view.buttonApplicationsHint' => 'Install and manage web apps on your websites. Forums, photo galleries, collaboration tools, and many more installed in several clicks.',
    'view.buttonGoogleServicesForWebsites' => 'Google Services For Websites',
    'view.buttonGoogleServicesForWebsitesHint' => 'Configure Google services to enhance your websites, increase traffic, retain users and generate revenues.',
    'view.buttonConnectionInfo' => 'Connection Info',
    'view.buttonConnectionInfoDesc' => 'for FTP, Database',
    'view.buttonConnectionInfoLabelNew' => 'NEW',
    'view.buttonFileManager' => 'File Manager',
    'view.buttonFileManagerHint' => 'Upload new files and work with current files and directories of your websites.',
    'view.buttonWebStatistics' => 'Web Statistics',
    'view.buttonWebStatisticsHint' => 'View the reports on how your websites are visited: See how many people visited a site and which webpages they viewed.',
    'view.buttonWebStatisticsSsl' => 'Web Statistics SSL/TLS',
    'view.buttonWebStatisticsSslHint' => 'View the reports on how your websites are visited over SSL/TLS.',
    'view.buttonFtpAccess' => 'FTP Access',
    'view.buttonFtpAccessHint' => 'Set up access to files of your websites over FTP protocol.',
    'view.buttonDnsSettings' => 'DNS Settings',
    'view.buttonDnsSettingsHint' => 'Manage DNS zones for your domain names.',
    'view.domainNotResolvedComment' => 'Domain is not resolvable',
    'view.buttonWhoisInfo' => 'Whois Information',
    'view.buttonWhoisInfoHint' => 'View the information about your registered domain name.',
    'view.buttonSslCertificates' => 'SSL/TLS Certificates',
    'view.buttonSslCertificatesHint' => 'Secure connections to your websites using SSL/TLS certificates.',
    'view.buttonWebAppFirewall' => 'Web Application Firewall',
    'view.buttonWebAppFirewallHint' => 'Configure protection from a range of attacks against web applications used by your website.',
    'view.buttonBackup' => 'Backup & Restore',
    'view.buttonBackupHint' => 'Back up and restore your domains, including settings and content of websites and mail accounts.',
    'view.buttonHostingSettings' => 'Web Hosting Access',
    'view.buttonHostingSettingsHint' => 'Change settings of the system user account used for remote access to Plesk over SSH or RDP and working with files and folders in File Manager.',
    'view.buttonHostingSettingsDesc' => 'IP address, system user, webspace access over SSH or RDP.',
    'view.buttonWebScripting' => 'Hosting Settings',
    'view.buttonWebScriptingHint' => 'This is where you configure website hosting settings and select the features available for your site.',
    'view.buttonWebScriptingDesc' => 'Domain name, document root, SSL certificate, web scripting, and more.',
    'view.buttonEmailAddresses' => 'Mail Accounts',
    'view.buttonEmailAddressesHint' => 'Create and manage email accounts associated with this website.',
    'view.buttonMailSettings' => 'Mail Settings',
    'view.buttonMailSettingsHint' => 'Change mail settings for this domain.',
    'view.buttonMailLists' => 'Mailing Lists',
    'view.buttonMailListsHint' => 'Create and manage mailing lists - a means to send an email message to multiple recipients at once.',
    'view.buttonOutgoingSpamSettings' => 'Limit Outgoing Messages',
    'view.buttonOutgoingSpamSettingsHint' => 'Set up the limit on the number of outgoing messages for this domain. It will not be possible to send more messages than you specify.',
    'view.buttonPhpSettings' => 'PHP Settings',
    'view.buttonPhpSettingsVersion' => 'Version',
    'view.buttonPhpSettingsHint' => 'Change PHP settings for this website.',
    'view.buttonWebServerSettingsUnix' => 'Apache & nginx Settings',
    'view.buttonWebServerSettingsUnixHint' => 'Change Apache & nginx settings for this website.',
    'view.buttonWebServerSettingsWindows' => 'IIS Settings',
    'view.buttonWebServerSettingsWindowsHint' => 'Change IIS settings for this website.',
    'view.buttonProtectedDirectories' => 'Password-Protected Directories',
    'view.buttonProtectedDirectoriesHint' => 'Restrict access to selected areas of your websites with password protection.',
    'view.buttonSeoSettings' => 'SEO Settings',
    'view.buttonSeoSettingsHint' => 'Set search engine specific settings for your site.',
    'view.buttonSsh' => 'SSH/Shell Access',
    'view.buttonSshHint' => 'Access files and directories under your account using the integrated SSH terminal web application.',
    'view.buttonSheduledTasks' => 'Scheduled Tasks',
    'view.buttonSheduledTasksHint' => 'View and manage scheduled tasks.',
    'view.buttonDatabases' => 'Databases',
    'view.buttonDatabasesHint' => 'Create and remove databases used by your websites, and manage them using integrated administrative web application.',
    'view.buttonLogs' => 'Logs',
    'view.buttonLogsHint' => 'View logs and configure recycling of log files.',
    'view.buttonFailedRequests' => 'Failed Request Tracing',
    'view.buttonFailedRequestsHint' => 'Trace failed HTTP requests to your website.',
    'view.buttonHotlinkProtection' => 'Hotlink Protection',
    'view.buttonHotlinkProtectionHint' => 'Protect content of your websites from hotlinking.',
    'view.buttonVirtualFolder' => 'Virtual Directories',
    'view.buttonVirtualFolderHint' => 'Create and manage virtual directories for your websites.',
    'view.buttonBandwidthLimiting' => 'Bandwidth Limiting',
    'view.buttonBandwidthLimitingHint' => 'Adjust the limit on bandwidth usage and connections to your websites.',
    'view.buttonDomainAliases' => 'Domain Aliases',
    'view.buttonDomainAliasesHint' => 'View and manage alternative domain names for your websites.',
    'view.buttonIpAddresses' => 'IP Addresses',
    'view.buttonIpAddressesHint' => 'Manage IP addresses.',
    'view.buttonWebUsers' => 'Web Users',
    'view.buttonWebUsersHint' => 'Set up accounts for users who can host personal web pages on your websites.',
    'view.buttonRdesktop' => 'Remote Desktop',
    'view.buttonRdesktopHint' => 'Access the server through a Remote Desktop connection.',
    'view.buttonJavaApps' => 'Java Applications',
    'view.buttonJavaAppsHint' => 'Install and manage Java applications.',
    'view.buttonOdbcDataSources' => 'ODBC Data Sources',
    'view.buttonOdbcDataSourcesHint' => 'Set up ODBC data sources.',
    'view.buttonAspNetSettings' => 'ASP.NET Settings',
    'view.buttonAspNetSettingsHint' => 'Configure the settings of ASP.NET framework.',
    'view.buttonCustomerIisAppPool' => 'Dedicated IIS Application Pool for Your Account',
    'view.buttonCustomerIisAppPoolHint' => 'Set up a dedicated IIS application pool for serving all websites hosted under your account.',
    'view.buttonIssAppPool' => 'Dedicated IIS Application Pool for Website',
    'view.buttonIssAppPoolHint' => 'Set up a dedicated IIS application pool for serving this website.',
    'view.buttonSiteCopy' => 'Website Copying',
    'view.buttonSiteCopyHint' => 'Copy website files to another site or external FTP storage.',
    'view.buttonWebDeploy' => 'Web Deploy Publishing Settings',
    'view.buttonWebDeployHint' => 'Download Web Deploy publishing settings.',
    'view.buttonSubscriptions' => 'Webspaces',
    'view.buttonSubscriptionsHint' => 'View and manage webspaces.',
    'view.buttonOutgoingMailControl' => 'Outgoing Mail Control',
    'view.buttonOutgoingMailControlHint' => 'View and manage outgoing mail.',
    'view.forceUpdateApplicationsNotification' => 'Now your applications can be updated automatically. Use this setting with care because updates can significantly affect the app functionality. For example, app extensions may stop working with another version of the app. %%link%%.',
    'view.forceUpdateAllApplicationsNotificationLink' => 'Switch on automatic updates for all applications',
    'view.unnotifiedApplicationsUpdatesMessage' => 'Updates are available for the following applications: ',
    'view.updatedAutomaticallyApplicationsMessage' => 'The following applications were automatically updated: ',
    'view.activeStateComponentsWarning' => 'You have ActivePython and/or ActivePerl components installed on your server. Plesk no longer licenses them from ActiveState. To avoid violating the license agreement, %%link%%.',
    'view.activeStateComponentsWarningLink' => 'you need to take action',
    'view.toSecurePasswordsGoTo' => 'To improve Plesk security, we recommend that you turn on the enhanced security mode on this %%link%%.',
    'view.securePasswords' => 'page',
    'view.upgradeDnsSyncSkip' => 'Note that after the upgrade, all existing DNS zones are considered as user-modified. This means that you can apply DNS template changes to such zones only by using the \'Apply the changes to all zones\' option during the %%link%%. %%learnMoreLink%%.',
    'view.serverDns' => 'sync',
    'view.learnMore' => 'Learn more',
    'view.backEncryptionRequired' => 'For security reasons, we recommend that you protect data contained in backups. Please go to %%link%% and update backup security settings.',
    'view.backupSettingPage' => 'Backup Settings',
    'view.ipAddress' => 'IP address: %%ipAddress%%',
    'view.ipv4Address' => 'IPv4 address: %%ipAddress%%',
    'view.ipv6Address' => 'IPv6 address: %%ipAddress%%',
    'view.subscriptionNotExist' => 'The subscription does not exist',
    'view.ftpLogin' => 'FTP login: %%ftpLogin%%',
    'view.phpVersion' => 'PHP version: %%phpVersion%%',
    'view.phpHandlerOutdated' => '(Outdated)',
    'view.resellerDescription' => 'Reseller',
    'view.ownerDescription' => 'Customer',
    'view.buttonDescriptionEdit' => 'Edit Description',
    'view.buttonDescriptionRemove' => 'Remove Description',
    'view.popupDescriptionTitle' => '%%descriptionType%% of %%name%%',
    'view.confirmOnDeleteDescription' => 'Do you want to remove this description?',
    'view.buttonDescription' => 'Description',
    'view.updatesAvailable' => 'Updates are available',
    'view.apsInstall' => 'Install',
    'view.apsApplicationInstall' => 'Install %%app%%',
    'view.apsInstallAll' => 'Install all',
    'view.apsChangelog' => 'Changelog',
    'view.apsApplicationChangelog' => '%%app%% Changelog',
    'view.apsInstances' => '%%total%% installations',
    'view.loading' => 'Loading...',
    'view.close' => 'Close',
    'view.viewMore' => 'View %%number%% more updates',
    'view.unableGetChangelog' => 'Unable to retrieve the changelog. Please refresh the page and try again.',

    'web-server-settings.titleUnix' => 'Apache & nginx Settings for %%domainName%%',
    'web-server-settings.titleWindows' => 'IIS Settings for %%domainName%%',
    'web-server-settings.updatedSuccessfully' => 'The settings were successfully updated.',

    'setup.title' => 'Websites & Domains',
    'setup.noDomainTitle' => 'All set for launching websites',
    'setup.description' => 'Add a new domain to start creating your website.',
    'setup.openTutorial' => 'If you need help, read our %%link%%.',
    'setup.openTutorialLink' => 'website creation tutorial',
    'setup.addDomain' => 'Add Domain',
];
