<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => '서브넷 또는 IP 주소',
    'access-network.subnetOrIpAddressHint' => '예, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => '뉴스레터',
    'admin.announcement-settings.getConsentLoading' => '뉴스레터 정보를 가져오는 중...',
    'admin.announcement-settings.getConsentWarning' => '구독 상태를 가져오지 못했습니다.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Plesk의 뉴스레터를 수신하고 싶습니다. 보안과 관련된 기술적이고 일반적인 제품 정보가 포함될 수 있습니다. 본인은 Plesk가 뉴스레터를 직접 또는 제3자 서비스를 통해 본인에게 전송할 때 적용되는 데이터 보호법에 따라 외국에서의 처리 등 내 개인 데이터(이메일)를 수집하고, 처리하고, 이용하는 데 동의합니다. 이 확인란을 취소하면 동의가 철회되고 Plesk에서 이메일을 나에게 전송하지 않으며, 내 개인 데이터를 시스템에서 영구적으로 제거합니다.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => '예, 본인은 맞춤형 Plesk 뉴스레터를 받아 보고 싶습니다. Plesk International GmbH 및 그 계열사는 본인이 제공하는 정보를 %%privacyPolicy%%에 따라 뉴스레터를 제공하는 목적으로 저장하고 처리할 수 있습니다. Plesk는 메시지와 제품을 본인에게 맞춤형으로 제공하기 위해 이용 및 행동 정보 등 프로파일링을 위한 추가 정보도 이용할 수 있습니다. 본인은 언제든지 메일링 리스트에서 구독을 취소할 수 있습니다.',
    'admin.announcement-settings.privacyPolicy' => 'Plesk 개인정보 보호정책',
    'admin.announcement-settings.noConsent' => 'Plesk 뉴스레터의 구독을 취소합니다.',
    'admin.announcement-settings.reportConsentError' => 'Plesk에서 정보를 가져오는 설정을 저장하지 못했습니다. %%error%%.',
    'admin.announcement-settings.profileUpdateError' => '죄송합니다, 현재 귀하의 프로필을 업데이트할 수 없습니다. 나중에 다시 시도하십시오.',
    'admin.announcement-settings.invalidConsentType' => "알 수 없는 콘텐츠 유형: '%%type%%'",
    'admin.announcement-settings.retry' => '다시 시도',
    'admin.announcement-settings.consentGivenInfo' => '일반 Plesk 뉴스레터가 마음에 드셨기를 바랍니다. 이제 귀하의 니즈에 맞는 유용한 정보와 간편한 팁이 포함된 맞춤형 뉴스레터를 제공할 수 있습니다. 맞춤형 Plesk 뉴스레터를 받아 보시려면 아래의 첫 번째 항목을 선택하고 확인을 클릭하십시오.',
    'admin.announcement-settings.consentNotGivenInfo' => '고객 님은 일반 뉴스레터를 구독하고 있지 않는 것으로 판단됩니다. 귀하의 니즈에 맞는 유용한 정보와 팁이 포함된 맞춤형 뉴스레터를 제공할 수 있습니다.',

    'admin.personal-info.title' => '관리자 프로필 편집',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Plesk 상세정보',
    'admin.personal-info.settingsSectionLegend' => '설정',

    'admin-alias.login' => '사용자 이름',
    'admin-alias.password' => '암호',
    'admin-alias.passwordConfirmation' => '암호 확인',
    'admin-alias.email' => '이메일',
    'admin-alias.contact' => '연락처 이름',
    'admin-alias.comments' => '주석',
    'admin-alias.emptyLogin' => '사용자 이름을 입력하십시오.',
    'admin-alias.loginTooLong' => '사용자 이름 길이가 20자를 초과합니다.',
    'admin-alias.emptyEmail' => '이메일 주소를 입력하십시오.',
    'admin-alias.emptyContactName' => '연락처 이름을 입력하십시오.',
    'admin-alias.contactNameTooLong' => '연락처 이름 길이가 255개 기호를 초과합니다.',
    'admin-alias.emptyPassword' => '암호를 입력하십시오.',
    'admin-alias.commentsTooLong' => '주석 길이가 255개 기호를 초과합니다.',
    'admin-alias.emailActivation' => '이메일로 계정 활성화',
    'admin-alias.simplePanel' => '제한 모드 활성화',
    'admin-alias.simplePanelHint' => '추가 관리자가 Plesk에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오. 사용할 수 있는 작업을 변경하려면 %%link%%(으)로 이동하십시오.',
    'admin-alias.simplePanelLink' => '도구 & 설정> 제한 모드 설정',
    'admin-alias.lockPowerUser' => '추가 관리자를 위해 고급 사용자 보기로 제한',
    'admin-alias.lockPowerUserHint' => '추가 Plesk 관리자를 위해 보기를 제한하는 기능입니다(고객, 대리점, 서비스 계획에 액세스 없음).',

    'admin-info.plesk-settings.multiplyLogin' => '이 계정 아래 여러 세션 허용',
    'admin-info.plesk-settings.adminLanguage' => '관리자의 인터페이스 언어',
    'admin-info.plesk-settings.password' => '암호',
    'admin-info.plesk-settings.passwordConfirmation' => '암호 확인',

    'admin-panel.form.contact-info.contactName' => '연락처 이름',
    'admin-panel.form.contact-info.emptyContactName' => '연락처 이름을 입력하십시오.',
    'admin-panel.form.contact-info.contactNameTooLong' => '연락처 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.email' => '이메일 주소',
    'admin-panel.form.contact-info.emptyEmail' => '이메일 주소를 입력하십시오.',
    'admin-panel.form.contact-info.companyName' => '회사 이름',
    'admin-panel.form.contact-info.longCompanyName' => '이 회사 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.phone' => '전화 번호',
    'admin-panel.form.contact-info.longPhone' => '이 전화 번호가 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.fax' => '팩스 번호',
    'admin-panel.form.contact-info.imNumber' => '인스턴트 메신저',
    'admin-panel.form.contact-info.longFax' => '이 팩스 번호가 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => '잘못된 전화 번호를 지정했습니다.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => '잘못된 팩스 번호입니다.',
    'admin-panel.form.contact-info.address' => '주소',
    'admin-panel.form.contact-info.longAddress' => '이 주소가 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'admin-panel.form.contact-info.city' => '도시',
    'admin-panel.form.contact-info.longCity' => '이 도시 이름이 너무 깁니다.',
    'admin-panel.form.contact-info.shortCity' => '이 도시 이름이 너무 짧습니다.',
    'admin-panel.form.contact-info.state' => '시/도',
    'admin-panel.form.contact-info.postalCode' => '우편 번호',
    'admin-panel.form.contact-info.country' => '국가',
    'admin-panel.form.contact-info.additionalInfo' => '추가 정보',
    'admin-panel.form.contact-info.additionalInfoHint' => '일반 텍스트만: 모든 HTML 태그는 무시됩니다.',
    'admin-panel.form.contact-info.duplicateEmail' => '해당 이메일 주소를 가진 사용자가 시스템에 이미 있습니다.',

    'admin-panel.form.domain-info-section.domainInfoSection' => '구독',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => '구독과 함께 제공된 웹 사이트의 속성.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => '구독과 함께 제공된 웹 사이트의 속성.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => '구독과 함께 제공된 웹 사이트의 속성.',
    'admin-panel.form.domain-info-section.createSubscription' => '고객에 대한 구독 만들기',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => '지금 호스팅 서비스 구독을 만들거나 고객의 웹 사이트를 설정하지 않으려면 이 확인란을 선택 해제합니다. 구독하지 않은 고객은 고객 패널에 로그인할 수 없습니다.',
    'admin-panel.form.domain-info-section.domainName' => '도메인 이름',
    'admin-panel.form.domain-info-section.emptyDomainName' => '도메인 이름을 입력해야 합니다.',
    'admin-panel.form.domain-info-section.shared' => '공유',
    'admin-panel.form.domain-info-section.exclusive' => '전용',
    'admin-panel.form.domain-info-section.userName' => '사용자 이름',
    'admin-panel.form.domain-info-section.userNameHint' => '구독 내에서 만들어진 웹 사이트의 파일 및 폴더를 관리하는 데 사용되는 시스템 사용자 계정.',
    'admin-panel.form.domain-info-section.emptyLogin' => '사용자 이름을 입력해야 합니다.',
    'admin-panel.form.domain-info-section.password' => '암호',
    'admin-panel.form.domain-info-section.emptyPassword' => '암호를 입력해야 합니다.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => '암호 확인',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4 주소',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6 주소',
    'admin-panel.form.domain-info-section.noIpAddressHint' => '없음',
    'admin-panel.form.domain-info-section.subscriptionSettings' => '추가 구독 설정',
    'admin-panel.form.domain-info-section.credentials' => '시스템 사용자 자격 증명',
    'admin-panel.form.domain-info-section.credentialsHint' => 'FTP 및 SSH를 통해 호스팅된 파일에 엑세스하려면',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'FTP 및 RDP를 통해 호스팅된 파일에 액세스하려면',

    'admin-panel.form.login-info.userName' => '사용자 이름',
    'admin-panel.form.login-info.emptyUserName' => '사용자 이름을 입력하십시오.',
    'admin-panel.form.login-info.password' => '암호',
    'admin-panel.form.login-info.emptyPassword' => '암호를 입력하십시오.',
    'admin-panel.form.login-info.passwordConfirmation' => '암호 반복',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => '비밀번호를 변경하면 내부 이메일 주소 비밀번호도 변경됩니다',
    'admin-panel.form.login-info.emailActivation' => '이메일로 계정 활성화',
    'admin-panel.form.login-info.emailActivationHint' => '생성된 계정은 사용자가 이메일에 포함된 링크로 활성화하거나 관리자가 수동으로 계정을 활성화하기 전까지 비활성 상태로 유지됩니다.',

    'admin-panel.form.subscription-info-section.subscription' => '구독',
    'admin-panel.form.subscription-info-section.servicePlan' => '서비스 플랜',
    'admin-panel.form.subscription-info-section.oldServicePlan' => '현재 서비스 플랜',
    'admin-panel.form.subscription-info-section.newServicePlan' => '새 서비스 플랜',
    'admin-panel.form.subscription-info-section.adminPlan' => '단순 플랜',
    'admin-panel.form.subscription-info-section.none' => '없음',
    'admin-panel.form.subscription-info-section.addonPlans' => '추가 기능',
    'admin-panel.form.subscription-info-section.customizeSubscription' => '플랜 연결이 변경된 후 구독 매개 변수를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => '구독 매개 변수를 만든 후 사용자 지정을 진행합니다.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "고객이 생성된 다음 구독 변수 사용자 정의를 진행하십시오.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => '구독 매개 변수가 만들어진 후에 계속해서 이를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => '이렇게 하면 동기화를 위해 구독이 잠깁니다.',
    'admin-panel.form.subscription-info-section.buttonOk' => '구독 추가',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'app.configure.otherSettings' => '기타',
    'app.configure.passwordConfirmation' => '암호 확인',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => '모든 설치 응용 프로그램에 대한 강제 업데이트',
    'app.update-settings.forceUpdatesHint' => '업데이트가 제공되는 즉시 고객의 모든 응용 프로그램이 자동으로 업데이트됩니다. 고객은 해당 응용 프로그램에 대한 자동 업데이트를 끌 수 없습니다. 경고: 업데이트는 응용 프로그램 기능에 큰 영향을 미칠 수 있으므로 이 옵션을 주의하여 사용하십시오. 예를 들어 응용 프로그램 확장자가 다른 응용 프로그램 버전에서 더 이상 작동하지 않을 수도 있습니다.',
    'app.update-settings.suggestUpdates' => '다음 옵션 "이 응용 프로그램을 자동으로 업데이트"를 기본적으로 선택',
    'app.update-settings.suggestUpdatesHint' => '새로 설치한 응용 프로그램의 경우, 응용 프로그램 설정에서 "이 응용 프로그램을 자동으로 업데이트" 옵션이 켜집니다.',

    'backup.server-settings.rotation' => '저장할 전체 백업 파일의 최대 수(예정된 백업과 수동 백업 모두 포함)',
    'backup.server-settings.rotationDescription' => '사용자는 서버 스토리지에 이 숫자만큼 전체 백업을 저장할 수 있습니다. 스토리지에 이미 있는 전체 백업 수가 제한치를 초과할 경우 가장 최근의 백업만 보관됩니다.  증분 백업은 영향을 받지 않습니다.',
    'backup.server-settings.maxProcesses' => '동시에 실행 가능한 예약된 백업 프로세스의 최대 수',
    'backup.server-settings.niceScheduled' => '우선 순위가 낮은 예약된 백업 프로세스 실행',
    'backup.server-settings.niceScheduledPriority' => '우선 순위',
    'backup.server-settings.niceScheduledPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 1에서 19 사이의 값을 입력합니다.',
    'backup.server-settings.niceScheduledIoPriority' => 'IO 우선 순위',
    'backup.server-settings.niceScheduledIoPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 0에서 7 사이의 값을 입력합니다.',
    'backup.server-settings.niceAlways' => '우선 순위가 낮은 모든 백업 프로세스 실행',
    'backup.server-settings.niceAlwaysPriority' => '우선 순위',
    'backup.server-settings.niceAlwaysPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 1에서 19 사이의 값을 입력합니다.',
    'backup.server-settings.niceAlwaysIoPriority' => 'IO 우선 순위',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => '높은 숫자일수록 낮은 우선 순위로 0에서 7 사이의 값을 입력합니다.',
    'backup.server-settings.compressionLevel' => '압축 수준',
    'backup.server-settings.compressionLevelNoCompression' => '압축 안 함',
    'backup.server-settings.compressionLevelFastest' => '가장 빠름',
    'backup.server-settings.compressionLevelFast' => '고속',
    'backup.server-settings.compressionLevelNormal' => '보통',
    'backup.server-settings.compressionLevelMaximum' => '최대',
    'backup.server-settings.freeSpaceRequired' => '서버에 지정한 양의 사용 가능한 디스크 공간(MB)이 있는 경우에만 백업 시작',
    'backup.server-settings.checkBackupDiskSpace' => '서버에 충분한 여유 디스크 공간이 있는 경우에만 백업 시작',
    'backup.server-settings.mssqlNativeBackupEnabled' => '원시 MS SQL 백업 기능 사용(원격 데이터베이스의 경우, 도구 & 설정> 데이터베이스 서버에서 원격 MS SQL 서버의 백업 설정이 구성되어 있는지 확인하십시오)',
    'backup.server-settings.localFtpRestriction' => '로컬 서버에 개인 FTP 백업 스토리지 설정 허용',
    'backup.server-settings.backupSecuritySettings' => '보안 설정 백업',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => '원격 저장소로 업로드할 수 없는 경우 서버 저장소에 백업 저장',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => '원격 저장소로 업로드할 수 없는 경우 원격 저장소에 대한 수동 및 예약된 백업은 로컬 서버 저장소에 저장됩니다. 사용자는 서버 저장소에 백업을 저장할 수 있는 권한이 있어야 합니다.',

    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupLabel' => '관리자가 소유한 고객',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupDescription' => 'Plesk 이전 버전에서 관리자에 속한 모든 클라이언트 계정이 관리자가 소유하는 고객 계정으로 변환되었습니다. (1) 각 클라이언트의 레거시 리소스가 보존되었고(고객의 구독 목록 상단에 있는 \'내 리소스\' 라벨 아래에서 확인할 수 있음), 전환이 완료되면 제거됩니다; (2) 모든 도메인이 구독으로 변환되었습니다(각 도메인이 하나의 새 구독으로 변환); (3) 도메인 관리자가 해당 도메인을 포함한 구독에만 액세스할 수 있는 고객 사용자로 변환되었습니다.',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupSettingsLabel' => '이전 클라이언트 상태',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupNumberLabel' => '고객 수',
    'business-model-upgrade.bunch.hosterCustomersSolutions-GroupMethodLabel' => '전환 방식',
    'business-model-upgrade.bunch.t1s1-settingsDescription' => '하나의 도메인; 제한 조정이 금지되었습니다.',
    'business-model-upgrade.bunch.t1s1-solutionDescription' => '새 구독 리소스는 이전 클라이언트 또는 도메인 제한의 최소와 같습니다.',
    'business-model-upgrade.bunch.t1s1-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.t1s2-settingsDescription' => '하나의 도메인; 제한 조정이 허용되었습니다.',
    'business-model-upgrade.bunch.t1s2-solutionDescription' => '새 구독 리소스는 이전 클라이언트 제한과 같습니다.',
    'business-model-upgrade.bunch.t1s2-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.t1s3-settingsDescription' => '여러 도메인; 도메인 만들기 및 제한 조정이 금지되었습니다.',
    'business-model-upgrade.bunch.t1s3-solutionDescription' => '새 구독 리소스는 이전 도메인 제한에서 상속됩니다.',
    'business-model-upgrade.bunch.t1s3-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.t1s6-settingsDescription' => '여러 도메인; 도메인 만들기 및 제한 조정이 허용되었습니다.',
    'business-model-upgrade.bunch.t1s6-solutionDescription' => '다음으로 전환:',
    'business-model-upgrade.bunch.t1s6r-solutionDescription' => '리셀러. 이전 클라이언트가 리셀러로 업그레이드됩니다. 리셀러 구독 리소스가 이전 클라이언트 제한에서 상속됩니다. 이전 도메인에 대해 도메인 관리자 계정이 활성화된 경우, 이 계정이 고객 계정으로 업그레이드되고 여기에 해당 구독이 연결됩니다. 그렇지 않은 경우, 구독은 리셀러에게 직접 속합니다.',
    'business-model-upgrade.bunch.t1s6c-solutionDescription' => '고객: 이전 클라이언트가 고객으로 유지됩니다. 클라이언트 리소스가 구독 간에 균등하게 배포됩니다.',
    'business-model-upgrade.bunch.t1s6r-solutionName' => '리셀러',
    'business-model-upgrade.bunch.t1s6c-solutionName' => '고객',
    'business-model-upgrade.bunch.t1s6-apply' => '이들 고객을 다음으로 전환',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupLabel' => '리셀러가 소유한 고객',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupDescription' => 'Plesk 9에서 리셀러에 속한 모든 클라이언트 계정이 해당 리셀러가 소유하는 고객 계정으로 변환되었습니다. (1) 각 클라이언트의 레거시 리소스가 보존되었고(고객의 구독 목록 상단에 있는 \'내 리소스\' 라벨 아래에서 확인할 수 있음), 전환이 완료되면 제거됩니다; (2) 모든 도메인이 구독으로 변환되었습니다(각 도메인이 하나의 새 구독으로 변환); (3) 도메인 관리자가 해당 도메인을 포함한 구독에만 액세스할 수 있는 고객 사용자로 변환되었습니다.',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupSettingsLabel' => '이전 클라이언트 상태',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupNumberLabel' => '고객 수',
    'business-model-upgrade.bunch.resellerCustomersSolutions-GroupMethodLabel' => '전환 방식',
    'business-model-upgrade.bunch.t2s1-settingsDescription' => '하나의 도메인; 제한 조정이 금지되었습니다.',
    'business-model-upgrade.bunch.t2s1-solutionDescription' => '새 구독 리소스는 이전 클라이언트 또는 도메인 제한의 최소와 같습니다.',
    'business-model-upgrade.bunch.t2s1-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.t2s2-settingsDescription' => '하나의 도메인; 제한 조정이 허용되었습니다.',
    'business-model-upgrade.bunch.t2s2-solutionDescription' => '새 구독 리소스는 이전 클라이언트 제한과 같습니다.',
    'business-model-upgrade.bunch.t2s2-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.t2s3-settingsDescription' => '여러 도메인; 도메인 만들기 및 제한 조정이 금지되었습니다.',
    'business-model-upgrade.bunch.t2s3-solutionDescription' => '새 구독 리소스는 이전 도메인 제한에서 상속됩니다.',
    'business-model-upgrade.bunch.t2s3-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.t2s6-settingsDescription' => '여러 도메인; 도메인 만들기 및 제한 조정이 허용되었습니다.',
    'business-model-upgrade.bunch.t2s6-solutionDescription' => '클라이언트 리소스가 구독 간에 균등하게 배포됩니다.',
    'business-model-upgrade.bunch.t2s6-apply' => '이러한 고객 전환',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupLabel' => '관리자가 소유한 구독',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupDescription' => 'Plesk 이전 버전에서 관리자에 속한 모든 도메인이 관리자의 구독으로 변환되었습니다.  도메인 관리자가 고객 패널 사용자로 변환되었으며 해당 도메인을 포함하는 구독에만 액세스할 수 있습니다. 권장 작업을 사용하여 이러한 구독을 전환하거나 \'선택적 구독 전환\' 탭에서 각각에 대한 사용자 지정 전환 방식을 선택합니다.',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupSettingsLabel' => '이전 도메인 상태',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupNumberLabel' => '구독 수',
    'business-model-upgrade.bunch.administratorSubscriptionsSolutions-GroupMethodLabel' => '전환 방식',
    'business-model-upgrade.bunch.subscriptionAdministrator-settingsDescription' => '관리자에 속한 도메인; 도메인 관리자 계정이 활성화되었습니다.',
    'business-model-upgrade.bunch.subscriptionAdministrator-solutionDescription' => '이전 도메인 관리자가 고객으로 업그레이드되고 구독자가 됩니다. 즉, 이들에게 구독이 할당됩니다.',
    'business-model-upgrade.bunch.subscriptionAdministrator-apply' => '이러한 구독 전환',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupLabel' => '리셀러가 소유한 구독',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupDescription' => 'Plesk 이전 버전에서 리셀러에 속한 모든 도메인이 소유권이 유지되면서 리셀러의 구독으로 변환되었습니다. 도메인 관리자가 고객 패널 사용자로 변환되었으며 해당 도메인을 포함하는 구독에만 액세스할 수 있습니다. 권장 작업을 사용하여 이러한 구독을 전환하거나 \'선택적 구독 전환\' 탭에서 각각에 대한 사용자 지정 전환 방식을 선택합니다.',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupSettingsLabel' => '이전 도메인 상태',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupNumberLabel' => '구독 수',
    'business-model-upgrade.bunch.resellerSubscriptionsSolutions-GroupMethodLabel' => '전환 방식',
    'business-model-upgrade.bunch.subscriptionReseller-settingsDescription' => '리셀러에 속한 도메인; 도메인 관리자 계정이 활성화되었습니다.',
    'business-model-upgrade.bunch.subscriptionReseller-solutionDescription' => '이전 도메인 관리자가 고객으로 업그레이드되고 구독자가 됩니다. 즉, 이들에게 구독이 할당됩니다.',
    'business-model-upgrade.bunch.subscriptionReseller-apply' => '이러한 구독 전환',
    'business-model-upgrade.bunch.thereWereSomeErrors' => '선택한 고객 및 구독 중 일부가 전환되지 않았습니다.',

    'change-current-subscription.hint' => '여기서 구독과 서비스 플랜 간 연결을 변경합니다. 새 서비스 플랜으로 \'없음\'을 선택하면 구독과 서비스 플랜 간 연결이 해제되고 구독이 \'사용자 지정\'이 됩니다.',
    'change-current-subscription.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'change-password.oldPassword' => '이전 암호',
    'change-password.password' => '새 암호',
    'change-password.passwordConfirmation' => '암호 확인',
    'change-password.oldPasswordIsIncorrect' => '이전 암호가 잘못되었습니다. 다시 시도하십시오.',
    'change-password.unableToFindAdditionalAdminAccount' => '추가 관리자 계정을 찾을 수 없습니다.',
    'change-password.warningAboutAdminPasswordSyntax' => "암호는 길이가 %%min%% - %%max%%자여야 하며 사용자 이름을 포함할 수 없습니다.\n암호에 인용 부호, 공백 및 자국 문자를 사용하지 마십시오.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "암호에 인용 부호, 공백, 세미콜론 및 자국 문자를 사용하지 마십시오.\n암호는 길이가 %%min%% - %%max%%자여야 하며 사용자 이름을 포함할 수 없습니다.",

    'change-reseller-oversell-policy.oversellPolicy' => '초과 판매 정책',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => '초과 판매가 허용됩니다.',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => '초과 판매를 통해 리셀러는 플랜에 의해 자신에게 할당된 리소스보다 많은 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => '초과 판매가 허용되지 않습니다.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => '초과 판매가 허용되지 않는 경우, 리셀러는 실제로 이러한 리소스의 사용량에 관계 없이 처음에 플랜에 의해 자신에게 할당된 리소스만큼만 판매할 수 있습니다.',

    'change-reseller-subscription.hint' => '여기서 리셀러 구독과 서비스 플랜 간 연결을 변경합니다. 새 서비스 플랜으로 \'없음\'을 선택하면 구독과 서비스 플랜 간 연결이 해제되고 구독이 \'사용자 지정\'이 됩니다.',
    'change-reseller-subscription.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',
    'change-reseller-subscription.servicePlan' => '새 플랜',
    'change-reseller-subscription.oldSubscription' => '현재 플랜',
    'change-reseller-subscription.none' => '없음',
    'change-reseller-subscription.infoSubscriptionChanged' => '구독과 서비스 플랜 간 연결이 업데이트되었습니다.',
    'change-reseller-subscription.customizeSubscription' => '서비스 플랜과의 연결이 업데이트된 후 구독 매개 변수를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',

    'change-subscription.hint' => '여기서 선택한 구독과 서비스 플랜 간 연결을 변경합니다.',
    'change-subscription.selectPlanLegend' => '서비스 플랜',
    'change-subscription.selectPlanDescription' => '다른 서비스 플랜으로 전환하려면 목록에서 새 플랜을 선택합니다. \'없음\'을 선택하면 구독과 서비스 플랜 간 연결이 해제되고 구독이 \'사용자 지정\'이 됩니다.',
    'change-subscription.servicePlan' => '새 서비스 플랜',
    'change-subscription.selectAddonPlansLegend' => '추가 기능 플랜',
    'change-subscription.selectAddonPlansDescription' => '추가 기능 플랜을 추가하거나 제거합니다.',
    'change-subscription.noChange' => '변경 사항 없음',
    'change-subscription.none' => '없음',
    'change-subscription.add' => '추가',
    'change-subscription.del' => '제거',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => '서브넷 또는 IP 주소',
    'control-panel-access.network.subnetOrIpAddressHint' => '예, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => '관리자 권한으로 Plesk 접속',
    'control-panel-access.settings.policyAllow' => '목록의 네트워크를 제외하고 허용됨.',
    'control-panel-access.settings.policyDeny' => '나열되지 않은 네트워크로부터 거부됨.',

    'create-subscription.title' => '구독 추가',
    'create-subscription.titleOwn' => '자체 구독 추가',
    'create-subscription.poolIsEmpty' => 'Plesk에 공유된 IP 주소와 무료 전용 IP 주소가 없기 때문에 구독을 만들 수 없습니다.',
    'create-subscription.infoNewSubscriptionCreated' => '구독 %%name%%이(가) 만들어졌습니다.',
    'create-subscription.createBeforeAppInstall' => '응용 프로그램을 설치할 구독이 있어야 합니다.',

    'customer.hint' => '여기서 새 고객을 호스팅 서비스에 등록합니다. 이러한 등록을 통해 Plesk에서 고객 계정을 만들고 호스팅 플랜 중 하나와 선택적으로 추가 기능에 대한 구독을 만듭니다. 또한 구독은 어떤 플랜에도 연결되지 않은 리소스 및 서비스의 완벽한 사용자 지정 집합을 제공할 수 있습니다. 이를 위해서는 서비스 플랜 옆의 \'없음\'을 선택합니다.',
    'customer.contactInfoSection' => '연락처 정보',
    'customer.additionalInfoSection' => '추가 고객 정보',
    'customer.accessToPanelSection' => 'Plesk에 액세스',
    'customer.contactInfoSectionHint' => '고객 연락처 정보를 입력하십시오',
    'customer.accessToPanelSectionHint' => '고객이 고객 패널에 액세스하는 데 사용할 자격 증명.',
    'customer.unableCreateSubscription' => '구독을 만들 수 없습니다. %%reason%%',
    'customer.poolIsEmpty' => 'IP 풀이 비어 있습니다.',
    'customer.buttonOk' => '고객 추가',

    'database-settings.dbPrefixRadio' => '데이터베이스 이름 시작 부분에 접두사와 밑줄을 추가합니다.',
    'database-settings.dbPrefixNone' => '없음',
    'database-settings.dbPrefixUsername' => '사용자 이름',
    'database-settings.dbPrefixExternalId' => '구독 외부 ID',
    'database-settings.dbUserPrefix' => '사용자 이름과 밑줄을 데이터베이스 사용자 이름 맨 앞에 추가',
    'database-settings.dbUserPrefixHint' => '데이터베이스 사용자 이름은 <plesk_username>_<database_user_name>과(와) 같은 형태입니다. 사용자 이름 길이에 대한 데이터베이스 제한으로 인해 <plesk_username>은(는) 축약될 수 있습니다.',
    'database-settings.grantAlterDatabase' => '모든 Microsoft SQL Server 데이터베이스 사용자에게 ALTER DATABASE 권한 부여',
    'database-settings.grantAlterDatabaseHint' => '신규 및 기존 사용자에게 이 권한이 부여됩니다.',
    'database-settings.enableBackupOperator' => '모든 Microsoft SQL Server 데이터베이스 사용자에 대한 db_backupoperator 역할 멤버 자격 활성화',
    'database-settings.enableBackupOperatorHint' => '신규 및 기존 사용자는 이 역할의 구성원이 됩니다.',
    'database-settings.aclRadio' => '데이터베이스 사용자의 원격 액세스에 대한 기본 설정',
    'database-settings.aclLocalhost' => '로컬 연결만 허용',
    'database-settings.aclAny' => '모든 호스트로부터 원격 연결 허용',
    'database-settings.aclCustom' => '다음으로부터 원격 연결 허용',
    'database-settings.aclExample' => "thomas.loc.gov \n%.loc.gov \nx.y.% \n144.155.166.177 \n144.155.166.% \n144.155.166.0/255.255.255.0 \n\n지정된 호스트는 이 사용자를 대신하여 데이터베이스에 액세스가 허용되었습니다.",
    'database-settings.aclDescription' => '이 설정은 사용자의 권한만 수정합니다. 로컬 MySQL 서버로의 원격 액세스를 활성화하려면 <a href="/server/db_server_edit.php?db_server_id=%d">로컬 MySQL 설정</a>에서 해당 옵션을 선택하십시오.',
    'database-settings.example' => "예: \n%%example%%",

    'dns.template.synchronize-done' => 'DNS 영역 템플릿이 적용되었습니다.',
    'dns.template.synchronize-error' => 'DNS 영역 템플릿이 일부 DNS 영역에 적용되지 않았습니다.',
    'dns.template.synchronize-progress' => 'DNS 영역 템플릿을 적용하는 중입니다.',

    'domain-restriction.name' => '도메인 이름',
    'domain-restriction.nameDescription' => '별표 기호(*)를 사용하여 와일드카드 패턴을 지정할 수 있습니다. 예: *.example.com',
    'domain-restriction.domainAlreadyExists' => '지정된 도메인 이름이 이미 목록에 있습니다.',

    'event-handler.eventLabel' => '이벤트',
    'event-handler.priorityLabel' => '우선 순위',
    'event-handler.userLabel' => '사용자',
    'event-handler.commandLabel' => '명령',
    'event-handler.commandHint' => '최고의 결과를 얻으려면 \'command\' 필드에 스크립트 파일의 전체 경로를 입력하십시오. 시스템 명령을 입력하면 작동하지 않을 수 있으므로 권장하지 않습니다. 예를 들어 출력 리디렉션 연산자  /&gt; 또는 &lt;이(가) 포함된 명령은 작동하지 않습니다.',
    'event-handler.priorityHighestText' => '가장 높음',
    'event-handler.priorityHighText' => '높음',
    'event-handler.priorityNormalText' => '보통',
    'event-handler.priorityLowText' => '낮음',
    'event-handler.priorityLowestText' => '가장 낮음',
    'event-handler.priorityCustomText' => '사용자 지정',
    'event-handler.priorityHighestOption' => '가장 높음(%%value%%)',
    'event-handler.priorityHighOption' => '높음(%%value%%)',
    'event-handler.priorityNormalOption' => '보통(%%value%%)',
    'event-handler.priorityLowOption' => '낮음(%%value%%)',
    'event-handler.priorityLowestOption' => '가장 낮음(%%value%%)',

    'extension.upload.fileUpload' => '확장 프로그램에 대한 파일 경로',

    'external-webmail.hint' => 'Plesk에서 추가 웹 메일을 등록하면 고객에게 제공됩니다. 추가된 웹 메일은 호스팅 플랜 및 구독의 \'Mail\' 속성에서 옵션으로 나타납니다. 웹 메일 이름이 웹 메일 옵션 목록에 표시되며, 고객 패널에서 사서함 옆의 웹 메일 아이콘을 클릭하면 URL이 열립니다.',
    'external-webmail.name' => '웹 메일 서비스 이름',
    'external-webmail.url' => '웹 메일 서비스 URL',
    'external-webmail.enabled' => '사용 가능함',

    'ftp-settings.generalSection' => '일반',
    'ftp-settings.portRange' => '수동 FTP 모드 연결을 위한 포트 또는 포트 범위',
    'ftp-settings.hintPortRange' => '(기본값: %%defaultPortRange%%)',

    'health.upload.hint' => '상태 서버 모니터의 구성을 업로드합니다. 이러한 구성은 업로드되는 즉시 적용됩니다.',
    'health.upload.selectFile' => '구성 파일',

    'install-local-package.selectUploadType' => '다음 중 한 가지 선택:',
    'install-local-package.uploadAsFile' => 'APS 패키지 업로드',
    'install-local-package.downloadFromCatalog' => '응용 프로그램 카탈로그에서 응용 프로그램 선택',
    'install-local-package.formInfo' => "새 응용 프로그램을 업로드하여 사용 가능한 응용 프로그램의 목록을 확장하거나, 응용 프로그램 카탈로그에서 추가 구성할 응용 프로그램을 추가합니다.",
    'install-local-package.invalidFileExtension' => '업로드된 응용 프로그램은 .zip 확장명이 있는 ZIP 아카이브여야 합니다.',
    'install-local-package.packagesNotSelected' => '패키지를 선택하지 않았습니다.',
    'install-local-package.visible' => '고객이 사용할 수 있도록 함',
    'install-local-package.isCommercial' => '이 앱은 상업용이며 라이센스 키 구매가 필요합니다.',
    'install-local-package.visibleDescription' => '응용 프로그램을 고객이 설치할 수 있도록 합니다.',

    'ip-address.generalSection' => '일반',
    'ip-address.interface' => '인터페이스',
    'ip-address.addressAndSubnetPrefixLength' => 'IP 주소 및 서브넷 마스크',
    'ip-address.publicIp' => '공용 IP 주소',
    'ip-address.hintPublicIp' => 'Plesk 서버가 NAT 뒤에 있다면 공용 IP 주소를 사용할 수 있습니다.',
    'ip-address.distributionType' => 'IP 주소가 다음으로 배포됨',
    'ip-address.distributionTypeShared' => '공유',
    'ip-address.distributionTypeExclusive' => '전용',
    'ip-address.certificate' => 'SSL/TLS 인증서',
    'ip-address.defaultSite' => '기본 사이트',
    'ip-address.ftpOverSslNotSupportedByServer' => '설치된 FTP 서버가 FTPS를 지원하지 않습니다.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => '설치된 FTP 서버가 IPv6 주소를 지원하지 않습니다.',
    'ip-address.interfaceDHCPEnabled' => 'IP 주소를 추가할 수 없습니다. 이 네트워크 인터페이스는 자동으로 IP 주소를 가져옵니다.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => '참고: 모든 알 수 없는 도메인에서 사용자 지정 Plesk URL이 활성화됩니다. "https://%%ip%%/"에 기본 사이트 대신 Plesk 인터페이스가 표시됩니다.',

    'ip-ban.filter.name' => '이름',
    'ip-ban.filter.content' => '내용',
    'ip-ban.filter.filterExistsError' => '해당 이름의 필터가 이미 있습니다.',

    'ip-ban.jail.name' => '이름',
    'ip-ban.jail.filter' => '필터',
    'ip-ban.jail.filterDescription' => '필터를 선택합니다.',
    'ip-ban.jail.action' => '동작',
    'ip-ban.jail.actionDescription' => '동작을 선택하고 버튼을 클릭하여 해당 동작을 추가합니다.',
    'ip-ban.jail.logPath' => '로그 경로',
    'ip-ban.jail.banTime' => 'IP 주소 금지 기간',
    'ip-ban.jail.maxRetry' => '최대 로그인 시도 실패 횟수',
    'ip-ban.jail.timeUnit' => '초',
    'ip-ban.jail.addAction' => '추가',
    'ip-ban.jail.chooseAction' => '선택:',
    'ip-ban.jail.apache-auth-filter-description' => 'Apache 인증 실패(파일에 로그인할 경우)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Apache 인증 실패(로깅할 경우)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Apache 인증 실패(syslog에 로그인할 경우)',
    'ip-ban.jail.apache-badbots-filter-description' => '스팸 봇 및 악성 웹 크롤러',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Courier IMAP 및 POP3 인증 실패',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Dovecot IMAP, POP3, Sieve 인증 실패',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Dovecot IMAP, POP3, Sieve 인증 실패(적극적인 모드)',
    'ip-ban.jail.plesk-horde-filter-description' => 'Horde 웹 메일 인증 실패',
    'ip-ban.jail.plesk-modsecurity-filter-description' => '웹 애플리케이션 방화벽(ModSecurity) 보안 및 액세스 제어 위반',
    'ip-ban.jail.plesk-panel-filter-description' => 'Plesk 인증 실패',
    'ip-ban.jail.plesk-qmail-filter-description' => 'QMail SMTP 인증 실패',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'Roundcube 웹 메일 인증 실패',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'WordPress 인증 실패',
    'ip-ban.jail.postfix-filter-description' => 'Postfix SMTP 클라이언트 오류(RBL 포함)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Postfix SMTP 클라이언트 오류, 인증 실패, DDoS 공격',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Postfix SMTP 및 SASL 인증 실패',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'Postfix SMTP DDoS 공격',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Postfix SMTP 클라이언트 오류 및 인증 실패',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Postfix SMTP 클라이언트 오류(RBL 포함)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Postfix SMTP 클라이언트 오류(RBL만)',
    'ip-ban.jail.proftpd-filter-description' => 'ProFTPD 로그인 실패',
    'ip-ban.jail.recidive-filter-description' => '호스트가 Fail2Ban에 의해 반복적으로 금지됨',
    'ip-ban.jail.sshd-filter-description' => 'SSH 로그인 실패',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'SSH 로그인 실패, 협상 실패, DDoS 공격',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'SSH 로그인 실패 및 DDoS 공격',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'SSH 로그인 실패 및 협상 실패',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'firewalld 방화벽을 통한 차단, 모든 포트에서',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'firewalld 방화벽을 통한 차단, 여러 포트에서',
    'ip-ban.jail.firewallcmd-new-action-description' => 'firewalld 방화벽을 통한 차단, 단일 포트에서',
    'ip-ban.jail.iptables-action-description' => '단일 포트에서 iptables 방화벽을 통해 금지',
    'ip-ban.jail.iptables-allports-action-description' => '모든 포트에서 iptables 방화벽을 통해 금지',
    'ip-ban.jail.iptables-multiport-action-description' => '다수의 포트에서 iptables 방화벽을 통해 금지',
    'ip-ban.jail.sendmail-action-description' => 'Sendmail을 통해 이메일 알림 보내기',
    'ip-ban.jail.jailExistsError' => '해당 이름의 jail이 이미 있습니다.',
    'ip-ban.jail.invalidInteger' => '유효하지 않은 값이 지정되었습니다. 정수를 지정하십시오.',

    'ip-ban.settings.pageHint' => '여기서 IP 주소 금지를 설정하여 서버와 호스트된 웹 사이트를 악성 트래픽으로부터 보호할 수 있습니다.',
    'ip-ban.settings.detectionEnabled' => '침입 감지 사용',
    'ip-ban.settings.banPeriod' => 'IP 주소 금지 기간',
    'ip-ban.settings.banTimeWindow' => '이후 공격 감지를 위한 시간 간격',
    'ip-ban.settings.maxRetries' => 'IP 주소가 금지되기 전의 실패 횟수',
    'ip-ban.settings.timeUnit' => '초',
    'ip-ban.settings.invalidInteger' => '잘못된 값을 입력했습니다. 양의 정수를 입력하십시오.',

    'ip-ban.trusted-ip.ipAddress' => 'IP 주소',
    'ip-ban.trusted-ip.hintIpAddress' => 'IP 주소, CIDR 마스크 또는 DNS 호스트 이름을 제공합니다.',
    'ip-ban.trusted-ip.specialCharactersInIpAddress' => '제공된 IP 주소, 네트워크 주소 또는 호스트 이름이 잘못되었습니다.',

    'login-info.hint' => '여기서 고객이 고객 패널에 액세스하는 데 사용하는 사용자 이름과 암호를 변경합니다.',
    'login-info.resellerHint' => '여기서 리셀러가 Plesk에 액세스하는 데 사용하는 사용자 이름 및/또는 암호를 변경합니다.',
    'login-info.myProfileHint' => '여기서 Plesk에 액세스하는 데 사용하는 암호를 변경합니다.',

    'mail.lists-server-settings.email' => "메일링 리스트 관리자의 이메일",
    'mail.lists-server-settings.emptyEmail' => '이메일 주소를 입력하십시오.',
    'mail.lists-server-settings.newPassword' => '새 암호',
    'mail.lists-server-settings.emptyPassword' => '암호를 입력하십시오.',
    'mail.lists-server-settings.passwordConfirmation' => '암호 확인',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => '메일링 리스트 소프트웨어가 구성되었습니다.',

    'mail.outgoing-messages.hint' => '여기서 사서함으로부터 나가는 메시지에 제한을 지정할 수 있습니다.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => '나가는 이메일 메시지의 최대 수',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => '기본값(시간당 %%domainOutgoingMessages%% 메시지)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => '이 사서함에 대한 사용자 지정 값',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => '시간당 메시지 수',

    'mail-gate-settings.host' => '호스트 이름 또는 IP 주소',
    'mail-gate-settings.port' => '포트',
    'mail-gate-settings.login' => '사용자 이름',
    'mail-gate-settings.password' => '암호',
    'mail-gate-settings.encryption' => 'SMTP 서버에 암호화된 연결 필요',
    'mail-gate-settings.allowUsers' => '이 SMTP 서버를 통해 메일 전송 허용(지정된 로그인 및 암호 사용)',
    'mail-gate-settings.useDefaultSettings' => 'Plesk와 함께 설치된 메일 서버와 Plesk에 의해 생성된 기본 메일 계정 사용',

    'mail-gate.hint' => '여기서 Plesk 메일 서버가 설치되지 않았거나 나가는 메일 전송이 금지된 경우 사용할 SMTP 서버를 지정할 수 있습니다. 이 서버는 Plesk에 의한 SMTP 릴레이와 이메일 알림과 같은 나가는 메일 전송을 위한 사용자 스크립트로 사용됩니다.',
    'mail-gate.enableMailGate' => '이 SMTP 서버를 통해 Plesk로부터 메일 알림 전송 허용',
    'mail-gate.notifications' => '외부 SMTP 서버에 의한 메일 알림',
    'mail-gate.smtpSettings' => '외부 SMTP 서버 설정',

    'optimization-settings.apacheModulesSection' => 'Apache 모듈',
    'optimization-settings.apacheSettingsSection' => '일반 설정',
    'optimization-settings.additionalPageHint' => '동작 결과를 완전히 이해하는 경우에만 모듈을 설정/해제합니다. 수정 내용에 따라 Apache 성능이 저하되거나 심지어 작동하지 않을 수도 있습니다.',
    'optimization-settings.pageHint' => '여기서 사용하지 않는 Apache 모듈을 해제하여 Plesk를 최적화할 수 있습니다. 이러한 최적화를 통해 메모리 사용률을 향상시키고 더 많은 호스팅 고객을 서비스할 수 있습니다. 일부 모듈은 상호 종속적이어서 종속된 모듈이 켜지거나 꺼지는 경우에만 켜고 끌 수 있습니다.',
    'optimization-settings.advancedUsersOnlyWarning' => '이 기능은 고급 사용자 전용입니다.',
    'optimization-settings.apacheRestartInterval' => 'Apache 재시작 간격(초)',
    'optimization-settings.apacheRestartIntervalHint' => '지정된 간격에 있게 되면 Plesk가 도메인 및 하위 도메인의 변경 내용을 확인합니다. 웹 서버를 재시작해야 하는 변경이 있는 경우 Plesk가 Apache를 다시 시작합니다.',
    'optimization-settings.gracefulRestart' => 'Apache 점잖은 재시작',
    'optimization-settings.gracefulRestartHint' => '서버에 호스팅된 모든 웹 사이트의 작동 중단을 예방하려면 선택, 호스팅 설정을 변경할 때마다.',
    'optimization-settings.pipedLog' => '파이핑된 로그',
    'optimization-settings.mpmMode' => 'MPM 모드',
    'optimization-settings.moduleDeprecated' => '(사용되지 않음)',

    'personal-info.contactInfoSection' => '연락처 정보',
    'personal-info.hint' => '여기서 사용자 연락처 정보를 편집합니다.',
    'personal-info.hintMyProfile' => '여기서 연락처 정보를 편집합니다.',

    'php-handler.ini.formHint' => '이 php.ini 파일은 이 처리기에 의해서만 사용됩니다.',
    'php-handler.ini.formHintSharedIni' => '이 php.ini 파일은 다음과 같은 PHP 처리기에 의해서도 사용됩니다: %%handlers%%. 이 처리기를 사용하는 모든 웹 사이트에 설정을 적용합니다.',
    'php-handler.ini.incorrectTextForIniFile' => "지정한 설정은 올바르지 않으며 php.ini 파일로 저장될 수 없습니다. 오류: %%message%%.",

    'php-handler.modules.formHint' => '이 PHP 확장 설정은 이 처리기에만 적용됩니다.',
    'php-handler.modules.formHintSharedModules' => '이 설정은 다음과 같은 PHP 처리기에서 공통입니다: %%handlers%%. 이 처리기를 사용하는 모든 웹 사이트에 설정을 적용합니다.',

    'plan-item-custom.planItemName' => '서비스 이름',
    'plan-item-custom.buttonLabel' => '이 이름은 사용자 지정 버튼의 레이블로도 사용됩니다.',
    'plan-item-custom.planItemDescription' => '서비스 설명',
    'plan-item-custom.buttonTooltip' => '이 텍스트는 사용자 지정 버튼의 도구 설명으로도 사용됩니다.',
    'plan-item-custom.url' => '사용자 지정 버튼에 연결된 URL',
    'plan-item-custom.backgroundImage' => '사용자 지정 버튼의 배경 이미지',
    'plan-item-custom.emptyItemName' => '서비스 레이블을 입력하십시오.',
    'plan-item-custom.emptyItemDescription' => '서비스 도구 설명 텍스트를 입력하십시오.',
    'plan-item-custom.emptyUrl' => 'URL을 지정하십시오.',
    'plan-item-custom.longItemName' => '이 서비스 레이블이 너무 깁니다. 허용되는 최대 길이는 %max% 기호입니다.',
    'plan-item-custom.longItemDescription' => '이 서비스 텍스트가 너무 깁니다. 허용되는 최대 길이는 %max% 기호입니다.',
    'plan-item-custom.longUrl' => '이 URL이 너무 깁니다. 허용되는 최대 길이는 %max% 기호입니다.',
    'plan-item-custom.useCustomButton' => '서비스에 대한 사용자 지정 버튼 사용',
    'plan-item-custom.useCustomButtonHint' => '사용자 홈 페이지 및 웹 사이트 페이지에 사용자 지정 버튼을 배치합니다.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Plesk에서 URL 열기',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Plesk 페이지와 새 브라우저 창 중 어디서 URL을 열지 지정합니다.',
    'plan-item-custom.openCustomButtonWithoutFrame' => '프레임을 사용하지 않음',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => '고객 패널의 Plesk 확장 또는 응용 프로그램으로 이어지는 사용자 지정 버튼을 추가하는 경우, 이 확장/응용 프로그램이 표시되는 방식을 지정할 수 있습니다. 즉, 프레임으로 표시하거나 Plesk GUI의 일부로 표시합니다.',
    'plan-item-custom.includeDomId' => '구독 ID 포함',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => '주 도메인 이름 포함',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'FTP 사용자 이름 포함',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'FTP 암호 포함',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => '고객 ID 포함',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "고객 회사명 포함",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "고객 연락처 이름 포함",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "고객 이메일 포함",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',

    'preview-domain-settings.previewType' => '웹 사이트 미리 보기 방법 선택',
    'preview-domain-settings.previewQuick' => '제한된 미리 보기',
    'preview-domain-settings.previewDisabled' => '빠른 미리 보기 비활성화',
    'preview-domain-settings.previewQuickDescription' => '제안 옵션은 바로 작동됩니다.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Plesk에서 도메인 이름의 빠른 미리 보기',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Plesk에서 서비스하는 웹 사이트 중 하나에 미리 보기 기능을 사용합니다.',
    'preview-domain-settings.previewZoneDomainCreate' => '이 기능을 사용하려면 하나 이상의 도메인을 %%link%%합니다.',
    'preview-domain-settings.subscriptionCreateLink' => '만들기',
    'preview-domain-settings.previewZoneTypeExternal' => '외부 도메인 이름의 빠른 미리 보기',
    'preview-domain-settings.previewZoneDomainNameDescription' => '외부 도메인 이름(DNS 영역)을 사용합니다. 이 옵션을 사용하는 경우 다음 DNS 레코드(유형 A)를 외부 도메인 영역에 추가합니다. *.<Plesk_IP>.external.dom. 여기서 <Plesk_IP>은(는) Plesk 서버 IP이며, IPv4용 점(.) 또는 IPv6용 콜론(:)은 대시(-)로 대체됩니다 (예: *.192-0-2-12.external.dom). Plesk에 등록된 IP가 둘 이상 있는 경우 각 주소에 레코드를 추가합니다.',
    'preview-domain-settings.sitePreviewProtection' => '인증 필요',
    'preview-domain-settings.sitePreviewProtectionDescription' => '미리 보기에 액세스하려면 FTP 로그인 및 암호가 필요합니다.',
    'preview-domain-settings.nginxNotInstalled' => 'nginx 웹 서버가 설치되지 않아 Default Quick Preview를 사용할 수 없습니다.',
    'preview-domain-settings.nginxDisabled' => 'nginx 웹 서버가 비활성화되어 Default Quick Preview를 사용할 수 없습니다.',

    'reseller-preferences.settingsSection' => '설정',
    'reseller-preferences.multiLogin' => '다중 세션 허용',
    'reseller-preferences.language' => '인터페이스 언어',
    'reseller-preferences.interfaceView' => '인터페이스 선택',
    'reseller-preferences.serviceProviderView' => '서비스 공급자 보기',
    'reseller-preferences.serviceProviderViewHint' => '이 보기는 고객을 가진 리셀러를 대상으로 합니다. 이 보기에서 고객뿐 아니라 자체 웹 사이트와 호스팅 서비스를 관리할 수 있습니다.',
    'reseller-preferences.powerUserView' => '고급 사용자 보기',
    'reseller-preferences.powerUserViewHint' => '이 보기는 리셀러가 자체 웹 사이트, 이메일 계정 및 기타 호스팅 서비스를 관리하기 위한 단순한 인터페이스를 제공합니다. 이 보기에서는 고객을 관리할 수 없습니다.',

    'reseller.hint' => '여기서 새 리셀러를 호스팅 서비스에 등록합니다.',
    'reseller.contactInfoSection' => '연락처 정보',
    'reseller.contactInfoSectionHint' => '리셀러 연락처 정보를 입력하십시오.',
    'reseller.accessToPanelSection' => 'Plesk에 액세스',
    'reseller.accessToPanelSectionHint' => '리셀러가 Plesk에 액세스하여 등록된 서비스를 관리하는 데 사용할 자격 증명.',
    'reseller.subscription' => '구독',
    'reseller.subscriptionSectionHint' => '리셀러가 구독할 서비스 플랜을 선택합니다.',
    'reseller.servicePlan' => '서비스 플랜',
    'reseller.none' => '없음',
    'reseller.customizeSubscription' => '리셀러가 만들어진 후 구독 매개 변수를 사용자 지정하십시오. 이렇게 하면 동기화를 위해 구독이 잠기게 됩니다.',
    'reseller.subscriptionNotSynchronized' => '구독을 서비스 플랜과 동기화할 수 없습니다. 다음 구독 설정이 서비스 플랜과 충돌합니다. %%problems%%.',

    'security-policy.encryptionSection' => '향상된 보안 모드',
    'security-policy.encryptionSectionHint' => '향상된 보안 모드는 Plesk에서 민감한 데이터를 더욱 강력하게 보호하는 기능이 적용되었습니다. 이 모드에서 Plesk는 Plesk 사용자에게 완전히 공개된 여러 개의 보안 메커니즘을 사용합니다. Plesk는 보안을 개선하기 위해 이 모드를 사용할 것을 권장합니다.',
    'security-policy.encryptionEnable' => '향상된 보안 모드',
    'security-policy.securePassword' => '향상된 보안 모드',
    'security-policy.strengthSection' => '암호 길이',
    'security-policy.strengthSectionHint' => '사용자가 시스템에서 새 암호를 설정하는 경우(새 암호 생성 또는 기존 암호 변경) 이 페이지에 지정된 최소 암호 강도 요구에 따라 암호를 조정해야 합니다. 암호의 보안 수준은 전반적인 길이와 복잡성(숫자, 대소문자, 특정 문자의 사용)을 기준으로 계산됩니다. 사용자가 강력한 암호의 채택을 요구할 것을 권장합니다.',
    'security-policy.passwordStrength' => '최소 암호 길이',
    'security-policy.passwordStrengthVeryWeakHint' => '이러한 암호는 대개 길이가 짧으며 한 가지 유형의 문자(소문자/대문자, 숫자 또는 특수 기호)만 포함합니다. 예: password. 가장 간단한 암호 추측 공격을 차단하는 보안 수준입니다.',
    'security-policy.passwordStrengthWeakHint' => '이 암호는 일반적으로 짧고 주로 한 종류의 문자(소문자 또는 대문자 또는 숫자)를 다른 종류의 문자 2~3개와 함께 사용합니다. 예: password12. 이 암호는 암호를 예측하지 못하도록 기본적인 수준에서 보호합니다.',
    'security-policy.passwordStrengthMediocreHint' => '이러한 암호는 대개 길이가 짧으며 최소 두 가지 유형의 문자(소문자/대문자, 숫자 또는 특수 문자)를 포함합니다. 예: Password12. 이러한 암호는 암호 캡처 공격으로부터 안전합니다.',
    'security-policy.passwordStrengthStrongHint' => '이러한 암호는 길이가 8자 이상이며 소문자/대문자, 숫자 및 특수 문자를 각각 한 개 이상 포함합니다. 예: P@ssw0rd12. 이러한 암호는 무제한(Brute-force) 공격으로부터 안전합니다.',
    'security-policy.passwordStrengthStrongerHint' => '이러한 암호는 길이가 16자 이상이며 소문자/대문자, 숫자 및 특수 문자를 각각 여러 개 포함합니다. 예: ~!my_P@$$w0rD123. 이러한 암호는 기억하기가 어렵지만 가장 안전합니다.',
    'security-policy.secureFtpSection' => '보안 FTP',
    'security-policy.ftpOverSsl' => 'FTPS 사용 정책',
    'security-policy.ftpOverSslHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다. 여기서 허용되는 통신 종류를 선택할 수 있습니다.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다. 여기서 허용되는 통신 종류를 선택할 수 있습니다. 선택한 옵션은 서버의 모든 IP 주소에 적용됩니다. IP 주소별로 사용자 지정 FTPS 설정을 사용하려면 해당 옵션을 선택한 후 도구 & 설정> IP 주소에서 FTPS 정책을 변경합니다.',
    'security-policy.ftpOverSslCustomHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS는 SSL/TLS 프로토콜을 사용하여 FTP 서버와 외부 FTP 클라이언트 간 통신을 보호합니다. IP 주소별로 FTPS 설정을 조정하려면 먼저 도구 & 설정 > 보안 정책 > 보안 FTP에서 "IP 주소별로 사용자 지정 FTPS 설정 사용" 옵션을 선택합니다.',
    'security-policy.ftpOverSslOptionRequired' => '보안 FTPS 연결만 허용',
    'security-policy.ftpOverSslOptionEnabled' => '보안 FTPS 및 비보안 FTP 연결 모두 허용',
    'security-policy.ftpOverSslOptionDisabled' => '비보안 FTP 연결만 허용 FTPS 사용 안 함',
    'security-policy.ftpOverSslOptionCustom' => 'IP 주소별로 사용자 지정 FTPS 설정 사용',
    'security-policy.prohibitWebConfigHandlersSection' => '사용자 지정 핸들러 정책',
    'security-policy.prohibitWebConfigHandlersSectionHint' => '고객이 web.config file을 통해 서버 수준에서 정의된 IIS 처리기를 무시하는 것을 방지하려면 이 옵션을 활성화합니다.',
    'security-policy.prohibitWebConfigHandlers' => 'web.config를 통한 핸들러 재정의 기능 금지',

    'service-instance.setup-instance.resourcesSection' => '서비스 리소스',
    'service-instance.setup-instance.requiredServiceAlreadyInstalled' => '이미 설치됨',
    'service-instance.setup-instance.requirementsSection' => '요청된 서비스',
    'service-instance.setup-instance.requiredServiceNotSelected' => '선택되지 않음',

    'service-node.ipAddress' => '서비스 노드 IP 주소',
    'service-node.ipAddressLocal' => '로컬 서비스 노드',
    'service-node.description' => '서비스 노드 설명',
    'service-node.accessKey' => '암호',
    'service-node.useAccessKey' => '인증 사용',
    'service-node.useAccessKeyDescription' => '인증 사용 관련 힌트.',
    'service-node.oldAccessKey' => '이전 암호',
    'service-node.newAccessKey' => '새 암호',
    'service-node.noAccessKeySpecified' => '암호가 지정되지 않았습니다',

    'service-plan.admin-plan.subscription_section' => '일반',
    'service-plan.admin-plan.tools_section' => '도구 및 리소스',
    'service-plan.admin-plan.apps_section' => '응용 프로그램 및 데이터베이스',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Plesk 모양',
    'service-plan.admin-plan.statistics_section' => '통계',
    'service-plan.admin-plan.general_section' => '일반',
    'service-plan.admin-plan.mail_section' => '메일',
    'service-plan.admin-plan.server_section' => '서버',
    'service-plan.admin-plan.modules_section' => '확장 프로그램',
    'service-plan.admin-plan.simplePanel' => '제한 모드',
    'service-plan.admin-plan.enabled' => '제한 모드 활성화',
    'service-plan.admin-plan.enabledDescription' => '관리자가 Plesk에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오.',
    'service-plan.admin-plan.aliasEnabledDescription' => '추가 관리자가 Plesk에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오.',

    'service-plan.applications-subscription.useFilterLabel' => '내가 선택하는 응용 프로그램만 제공',
    'service-plan.applications-subscription.useFilterDescription' => '구독자에게 제공할 응용 프로그램을 선택하려면 이 옵션을 사용합니다.',
    'service-plan.applications-subscription.applications' => '응용 프로그램',
    'service-plan.applications-subscription.isCommercial' => '이 응용 프로그램은 상업용이므로 사용하기 위해 라이센스 키를 구입해야 합니다.',

    'service-plan.applications.useFilterLabel' => '내가 선택하는 응용 프로그램만 제공',
    'service-plan.applications.useFilterDescription' => '구독자에게 제공할 응용 프로그램을 선택하려면 이 옵션을 사용합니다.',
    'service-plan.applications.applications' => '응용 프로그램',
    'service-plan.applications.isCommercial' => '이 응용 프로그램은 상업용이므로 사용하기 위해 라이센스 키를 구입해야 합니다.',

    'service-plan.dns.dnsZoneType' => '도메인 DNS 영역',
    'service-plan.dns.dnsZoneTypeMaster' => '마스터',
    'service-plan.dns.dnsZoneTypeSlave' => '슬레이브',

    'service-plan.extras.groupOtherServices' => '기타 서비스',
    'service-plan.extras.none' => '없음',

    'service-plan.hosting.enablePhysicalHosting' => '호스팅 활성화',
    'service-plan.hosting.sectionCoreHosting' => '일반 속성',
    'service-plan.hosting.sectionScripting' => '스크립팅',
    'service-plan.hosting.defaultDatabaseServer' => '기본 데이터베이스 서버',
    'service-plan.hosting.versionCut' => 'v%%version%%',
    'service-plan.hosting.sectionAdvanced' => '고급',
    'service-plan.hosting.phpSettingsHelpLink' => '가장 적합한 PHP 설정 선택 방법 알아보기',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => '이 구독이 일시 중단되는 경우 웹 사이트의 상태',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => '웹 사이트가 일시 중단된 구독 상태임',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => '구독이 일시 중단되는 경우(예를 들어 만료되거나 유료 기간이 종료됨) 플랜 구독이 적용되는 모든 웹 사이트에 선택 상태가 적용됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => '구독이 일시 중단되는 경우(예를 들어 만료되거나 유료 기간이 종료됨) 웹 사이트에 선택 상태가 적용됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => '비활성화됨',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => '웹 사이트 방문자는 웹 서버의 기본 페이지로 리디렉션됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => '일시 중단됨',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => '웹 사이트 방문자는 검색 엔진에 친화적인 HTTP 301 코드를 통해 사용자 지정 오류 문서 페이지로 리디렉션됩니다.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => '활성',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => '인터넷을 통해 웹 사이트에 계속 액세스할 수 있습니다.',

    'service-plan.ip.sharedIpAddresses' => '공유 IP 주소 할당',
    'service-plan.ip.allocateExclusiveIp' => '전용 IP 주소 할당',
    'service-plan.ip.allocateExclusiveIpV4' => '전용 IPv4 주소 할당',
    'service-plan.ip.allocateExclusiveIpV6' => '전용 IPv6 주소 할당',

    'service-plan.mail.mailService' => '메일 서비스 사용',
    'service-plan.mail.webMail' => '웹 메일',
    'service-plan.mail.mailingLists' => '메일링 리스트 활성화',
    'service-plan.mail.mailToNonExistentUser' => '존재하지 않는 사용자에 대한 메일 정책',
    'service-plan.mail.mailToNonExistentUserBounce' => '메시지를 포함하여 바운스',
    'service-plan.mail.mailToNonExistentUserRedirect' => '주소로 전달',
    'service-plan.mail.mailToNonExistentUserReject' => '거부',
    'service-plan.mail.mailAutodiscovery' => '메일 자동 검색 활성화',
    'service-plan.mail.mailAutodiscoveryDescription' => '기술 자료에서 적용되는 <a href="%%link%%" target="_blank">방법 확인</a>',
    'service-plan.mail.bounceMessage' => '이 주소는 더 이상 메일을 수신하지 않습니다.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'IP 주소를 사용하여 외부 메일 서버로 리디렉션',
    'service-plan.mail.webmailDisabled' => '%%webmail%% - 사용 안 함',

    'service-plan.misc.retainEnabled' => '다음에 대한 웹 및 트래픽 통계 유지',
    'service-plan.misc.logRotation' => '로그 순환',
    'service-plan.misc.logRotationCondition' => '로그 순환 조건',
    'service-plan.misc.logRotationBySize' => '크기 기준',
    'service-plan.misc.logRotationByTime' => '시간 기준',
    'service-plan.misc.logRotationDaily' => '매일',
    'service-plan.misc.logRotationWeekly' => '주간',
    'service-plan.misc.logRotationMonthly' => '월별',
    'service-plan.misc.logRotationSizeDescription' => '크기 값은 %%min%%~%%max%%KB 사이여야 합니다.',
    'service-plan.misc.maximumNumberOfFiles' => '로그 파일 최대 수',
    'service-plan.misc.compress' => '로그 파일 압축',
    'service-plan.misc.sendLogToEmail' => 'Plesk가 웹 및 FTP 서버의 로그 파일에서 데이터를 검색하면 이 주소에 로그를 이메일로 보내기',
    'service-plan.misc.kb' => 'KB',
    'service-plan.misc.months' => '월',
    'service-plan.misc.logRotationPeriodGreater' => '로그 회전 기간은 서버 전체의 제한값 %%max%%보다 길 수 없습니다.',

    'service-plan.performance.iisAppPoolAddonsHint' => '이 기능을 끄면 구독의 모든 웹 사이트가 구독의 전용 IIS 응용 프로그램 풀을 사용합니다.',

    'service-plan.permissions-subscription.permissionsTabDescription' => '구독에 제공되는 서비스 및 권한을 선택합니다.',
    'service-plan.permissions-subscription.showMorePermissions' => '더 많은 권한 표시',
    'service-plan.permissions-subscription.hideMorePermissions' => '더 적은 권한 표시',
    'service-plan.permissions-subscription.noShellManagement' => '허용되지 않음',
    'service-plan.permissions-subscription.systemAccessLabel' => 'SSH를 통한 서버 액세스 관리',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => '시스템 사용자에 대한 SSH를 고객이 활성화할 수 있도록 허용합니다. 호스팅 매개 변수 "구독\\ 시스템 사용자의 서버 셸에 SSH 액세스"를 사전 설정으로 사용합니다.',

    'service-plan.permissions.permissionsTabDescription' => '계획과 함께 제공된 서비스 및 권한을 선택하십시오.',
    'service-plan.permissions.permissionsAddonTabDescription' => '이 추가 기능 플랜에서 구독에 추가할 서비스 및 권한을 선택합니다. 추가 기능에서 선택하지 않은 권한으로는 구독 매개 변수를 수정할 수 없습니다.',
    'service-plan.permissions.permissionsBehaviorDescription' => '권한을 통해 고객은 구독의 특정 설정을 변경할 수 있습니다. 구독이 생성되면 Plesk는 고객이 변경할 수 있는 설정에 계획의 사전 설정값을 적용합니다. 이후에 계획을 업데이트하거나 추가 계획을 적용해도 고객이 변경한 사항은 무시되지 않습니다.',
    'service-plan.permissions.showMorePermissions' => '더 많은 권한 표시',
    'service-plan.permissions.hideMorePermissions' => '더 적은 권한 표시',
    'service-plan.permissions.noShellManagement' => '허용되지 않음',
    'service-plan.permissions.systemAccessLabel' => 'SSH를 통한 서버 액세스 관리',
    'service-plan.permissions.systemAccessLabel_hint' => '호스팅 매개 변수 "구독 시스템 사용자의 서버 셸에 SSH 액세스"를 사전 설정으로 사용합니다.',

    'service-plan.resources-subscription.overusePolicy' => '초과 사용 정책',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => '초과 사용이 허용되지 않습니다.',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => '리소스의 초과 사용을 허용하지 않습니다. 리소스 사용량이 제한 값을 초과하면 구독이 자동으로 일시 중단됩니다.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => '디스크 공간과 트래픽의 초과 사용이 허용됩니다.',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => '디스크 공간과 트래픽의 초과 사용을 허용합니다. 다른 리소스의 초과 사용을 허용하지 않습니다.',
    'service-plan.resources-subscription.overusePolicyAllowed' => '초과 사용이 허용됨(권장하지 않음)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => '구독자가 구독을 통해 처음에 제공된 것보다 많은 양의 리소스를 사용하도록 허용합니다.',
    'service-plan.resources-subscription.overuseNotify' => '초과 사용 시 이메일로 알림을 받겠습니다.',
    'service-plan.resources-subscription.oversellPolicy' => '초과 판매 정책',
    'service-plan.resources-subscription.oversellPolicyAllowed' => '초과 판매가 허용됩니다.',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => '초과 판매를 통해 리셀러는 구독을 통해 할당받은 것보다 많은 양의 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => '초과 판매가 허용되지 않습니다.',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => '초과 판매가 허용되지 않는 경우, 리셀러는 해당 리소스의 실제 사용량에 관계 없이 처음에 구독을 통해 할당받은 양만큼만 리소스를 판매할 수 있습니다.',
    'service-plan.resources-subscription.mainGroupTitle' => '구독에 제공되는 리소스 사용량의 제한을 정의합니다.',
    'service-plan.resources-subscription.additionalGroupTitle' => '더 많은 사용 가능 리소스 표시',
    'service-plan.resources-subscription.hideMoreResources' => '더 적은 리소스 표시',

    'service-plan.resources.overusePolicy' => '초과 사용 정책',
    'service-plan.resources.overusePolicyNotAllowed' => '초과 사용이 허용되지 않습니다.',
    'service-plan.resources.overusePolicyNotAllowedHint' => '리소스의 초과 사용을 허용하지 않습니다. 리소스 사용량이 제한 값을 초과하면 구독이 자동으로 일시 중단됩니다.',
    'service-plan.resources.overusePolicySoftAllowed' => '디스크 공간과 트래픽의 초과 사용이 허용됩니다.',
    'service-plan.resources.overusePolicySoftAllowedHint' => '디스크 공간과 트래픽의 초과 사용을 허용합니다. 다른 리소스의 초과 사용을 허용하지 않습니다.',
    'service-plan.resources.overusePolicyAllowed' => '초과 사용이 허용됨(권장하지 않음)',
    'service-plan.resources.overusePolicyAllowedHint' => '고객이 플랜을 통해 처음에 제공된 것보다 많은 양의 리소스를 사용하도록 허용합니다.',
    'service-plan.resources.overuseNotify' => '초과 사용 시 이메일로 알림을 받겠습니다.',
    'service-plan.resources.oversellPolicy' => '초과 판매 정책',
    'service-plan.resources.oversellPolicyAllowed' => '초과 판매가 허용됩니다.',
    'service-plan.resources.oversellPolicyAllowedHint' => '초과 판매를 통해 리셀러는 플랜에 의해 자신에게 할당된 리소스보다 많은 리소스를 판매할 수 있습니다. 초과 판매가 허용된 경우, 리셀러는 초기 리소스 할당 대신 실제 리소스 사용에 따른 관리를 받습니다.',
    'service-plan.resources.oversellPolicyNotAllowed' => '초과 판매가 허용되지 않습니다.',
    'service-plan.resources.oversellPolicyNotAllowedHint' => '초과 판매가 허용되지 않는 경우, 리셀러는 실제로 이러한 리소스의 사용량에 관계 없이 처음에 플랜에 의해 자신에게 할당된 리소스만큼만 판매할 수 있습니다.',
    'service-plan.resources.mainGroupTitle' => '플랜에 제공되는 리소스를 정의합니다.',
    'service-plan.resources.additionalGroupTitle' => '더 많은 사용 가능 리소스 표시',
    'service-plan.resources.hideMoreResources' => '더 적은 리소스 표시',
    'service-plan.resources.allowSitebuilderUpsell' => '고객이 평가판 Web Presence Builder 웹 사이트를 만들도록 허용합니다.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => '이 설정을 통해 고객이 서비스 플랜에서 제공한 것보다 많은 양의 Presence Builder 웹 사이트를 만들도록 허용합니다. 고객은 이러한 웹 사이트를 게시하려면 웹 사이트를 구입해야 합니다.',

    'service-plan.servicePlanName' => '서비스 플랜 이름',
    'service-plan.resellerPlanName' => '리셀러 플랜 이름',
    'service-plan.addonPlanName' => '추가 기능 플랜 이름',
    'service-plan.adminPlanPermissionsTab' => '관리자 도구',
    'service-plan.adminPlanPermissionsTabDescription' => '제한 모드가 활성화된 경우 관리자가 사용할 수 있는 기능을 선택합니다.',
    'service-plan.hostingPermissionsTab' => '호스팅 도구',
    'service-plan.hostingPermissionsTabDescription' => '제한 모드가 활성화된 경우 관리자가 사용할 수 있는 웹 호스팅 도구 및 설정을 선택합니다.',
    'service-plan.resourcesTab' => '리소스',
    'service-plan.resourcesTabDescription' => '플랜에 제공되는 리소스와 리소스 사용량에 대한 정책을 정의합니다.',
    'service-plan.subscriptionResourcesTabDescription' => '구독에 제공되는 리소스와 리소스 사용량에 대한 정책을 정의합니다.',
    'service-plan.hostingTab' => '호스팅 매개 변수',
    'service-plan.hostingTabDescription' => '플랜에 제공되는 호스팅 서비스의 매개 변수를 지정합니다. 추가 기능 플랜에 지정된 호스팅 설정은 서비스 플랜 또는 추가 기능 플랜에 의해 "호스팅 설정 관리" 권한이 부여된 구독에는 적용되지 않습니다.',
    'service-plan.secureSettingsDescription' => '제공되는 호스팅의 보안을 극대화하려면 %%link%%합니다. 부여된 일부 권한을 통해 구독자가 이러한 설정을 변경할 수 있습니다. %%helpLink%%.',
    'service-plan.secureSettingsLink' => '적용 보안 설정 사전 설정',
    'service-plan.secureSettingsHelpLink' => '보안 호스팅 설정에 대해 알아보기',
    'service-plan.mailTab' => '메일',
    'service-plan.mailTabDescription' => '플랜에 제공되는 메일 서비스의 매개 변수를 지정합니다.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => '플랜에 제공되는 DNS 서비스의 매개 변수를 지정합니다.',
    'service-plan.performanceTab' => '성능',
    'service-plan.performanceTabDescription' => '플랜에 제공되는 모든 서비스의 성능에 영향을 미치는 시스템 매개 변수를 지정합니다.',
    'service-plan.permissionsTab' => '권한',
    'service-plan.miscTab' => '로그 및 통계',
    'service-plan.miscTabDescription' => '플랜 구독의 통계 및 로그 저장 방법을 지정합니다. 이러한 설정은 구독에서 동기화되지 않습니다.',
    'service-plan.miscTabAdminPlanDescription' => '구독의 통계 및 로그 저장 방법을 지정합니다.',
    'service-plan.extrasTab' => '추가 서비스',
    'service-plan.extrasTabDescription' => '웹 호스팅, DNS 및 메일 서비스와 함께 플랜에 포함할 서비스를 선택합니다.',
    'service-plan.ipTab' => 'IP 주소',
    'service-plan.ipTabDescription' => '플랜에 제공되는 IP 리소스의 매개 변수를 정의합니다.',
    'service-plan.applicationsTab' => '응용 프로그램',
    'service-plan.applicationsTabDescription' => '플랜에 제공할 응용 프로그램을 선택합니다. 서버에 업로드한 응용 프로그램 외에도 응용 프로그램 카탈로그에 있는 모든 응용 프로그램을 제공할 수 있으며, 응용 프로그램을 수동으로 선택할 수도 있습니다. 사용 가능한 모든 응용 프로그램을 제공하려는 경우, 이 탭에서 아무 작업도 할 필요가 없으며 간단히 ‘권한’ 탭으로 이동하여 ‘응용 프로그램 카탈로그에 액세스’ 옵션을 선택하면 됩니다. 응용 프로그램을 수동으로 선택하려면 이 탭에서 하면 됩니다.',
    'service-plan.applicationsTabDescription-addon' => '추가 기능에서 사용할 응용 프로그램을 선택하십시오.',
    'service-plan.applicationsTabDescription-subscription' => '구독에 제공할 응용 프로그램을 선택합니다. 서버에 업로드한 응용 프로그램 외에도 응용 프로그램 카탈로그에 있는 모든 응용 프로그램을 제공할 수 있으며, 응용 프로그램을 수동으로 선택할 수도 있습니다. 사용 가능한 모든 응용 프로그램을 제공하려는 경우, 이 탭에서 아무 작업도 할 필요가 없으며 간단히 ‘권한’ 탭으로 이동하여 ‘응용 프로그램 카탈로그에 액세스’ 옵션을 선택하면 됩니다. 응용 프로그램을 수동으로 선택하려면 이 탭에서 하면 됩니다.',
    'service-plan.planSyncSubsriptionWarning' => '일부 구독이 플랜과 동기화되지 않았습니다. 해당 구독이 구독 목록에 \'Unsynced\'로 표시됩니다. 동기화를 다시 시도하려면 구독 개요 페이지로 이동한 후 동기화 버튼을 클릭합니다.',
    'service-plan.planSyncResellerWarning' => '일부 리셀러가 플랜과 동기화되지 않았습니다. 해당 리셀러가 리셀러 목록에 \'Unsynced\'로 표시됩니다. 동기화를 다시 시도하려면 리셀러 개요 페이지로 이동한 후 동기화 버튼을 클릭합니다.',
    'service-plan.planSyncAdminWarning' => '이러한 변경 사항에 영향을 받는 서비스 또는 리소스 중 일부를 Plesk에서 제공하지 않기 때문에 변경 사항을 구독에 적용할 수 없습니다. 이유: %%reason%%',
    'service-plan.duplicateName' => '해당 이름을 가진 플랜이 이미 있습니다.',
    'service-plan.phpSettingsTab' => 'PHP 설정',
    'service-plan.phpSettingsTabDescription' => '여기서 서버 전체 php.ini 파일에 정의된 설정을 무시하는 구독별 PHP 설정을 지정할 수 있습니다. 이는 예를 들어 고객의 PHP 스크립의 시스템 리소스 사용을 제한하려는 경우에 유용할 수 있습니다. 고객(허용된 경우)이 자신의 도메인별 구성으로 이 PHP 구성을 무시할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서버 전체 PHP 구성의 매개 변수 값을 사용합니다. 다음 자리 표시자가 지원됩니다. {DOCROOT} 및 {WEBSPACEROOT}는 도메인의 문서 루트 디렉터리 및 사용자 지정 PHP 구성을 가져오는 구독의 루트 디렉터리를 의미하고, {TMP}는 임시 파일을 저장하는 디렉터리를 의미합니다.',
    'service-plan.phpSettingsTabDescriptionAddon' => '여기서 주 서비스 플랜에 정의된 설정을 무시하는 구독별 PHP 설정을 지정할 수 있습니다. 이는 예를 들어 주 서비스 플랜에 설정된 일부 PHP 제한을 제거하려는 경우에 유용할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서비스 플랜 PHP 구성의 매개 변수 값을 사용합니다. 다음 자리 표시자가 지원됩니다. {DOCROOT} 및 {WEBSPACEROOT}는 도메인의 문서 루트 디렉터리 및 사용자 지정 PHP 구성을 가져오는 구독의 루트 디렉터리를 의미하고, {TMP}는 임시 파일을 저장하는 디렉터리를 의미합니다.',
    'service-plan.phpSettingsPhpVersion' => '귀하의 현재 PHP 버전은 %%version%%입니다.',
    'service-plan.phpSettingsTabAdminPlanDescription' => '여기서 서버 전체 php.ini 파일에 정의된 설정을 무시하는 구독별 PHP 설정을 지정할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서버 전체 PHP 구성의 매개 변수 값을 사용합니다.',
    'service-plan.webServerSettingsTab' => '웹 서버',
    'service-plan.webServerSettingsTabDescription' => '여기서 이 서비스 플랜에 대한 Apache 웹 서버 설정을 지정할 수 있습니다. Apache가 프런트 엔드 서버로 nginx를 이용하여 실행되는 경우, 이 페이지에서 nginx 설정도 지정할 수 있습니다. 새롭게 만들어지는 모든 도메인에 지정된 설정이 보내집니다. 그러나 이러한 설정을 변경하는 경우 기존 도메인에 변경 내용이 보내지지 않습니다.',
    'service-plan.servicesTab' => '서비스',
    'service-plan.servicesTabDescription' => '여기서 서비스 플랜에 할당된 서비스를 지정할 수 있습니다.',
    'service-plan.servicePropertiesTab' => '%%serviceName%% 속성',
    'service-plan.servicePropertiesTabDescription' => '여기서 서비스 플랜에 할당된 %%serviceName%% 서비스의 속성을 지정할 수 있습니다.',
    'service-plan.longTaskWarning' => '이 플랜에 %%subscriptionsCount%% 구독이 존재합니다. 동기화 작업에는 많은 시간이 필요할 수 있으며 배경에서 실행됩니다.',
    'service-plan.hostingParametersTab' => '호스팅 매개 변수',
    'service-plan.adminInfoSection' => '관리자를 위한 정보',
    'service-plan.descriptionInPanel' => '설명',
    'service-plan.longDescription' => '지정한 설명이 너무 깁니다.',
    'service-plan.conflictPermissions' => '리셀러 플랜과 충돌하므로 다음 권한을 부여할 수 없습니다: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => '시작 유형',
    'services.change-startup-type.autoStartupTypeLabel' => '자동',
    'services.change-startup-type.manualStartupTypeLabel' => '수동',
    'services.change-startup-type.disabledStartupTypeLabel' => '끄기',
    'services.change-startup-type.autoActionError' => '시작 유형을 \'auto\'로 설정할 수 없음: %%error%%',
    'services.change-startup-type.manualActionError' => '시작 유형을 \'manual\'로 설정할 수 없음: %%error%%',
    'services.change-startup-type.disableActionError' => '시작 유형을 \'disabled\'로 설정할 수 없음: %%error%%',

    'sessions.settings.restoreDefaultButton' => '모두 기본값으로 재설정',
    'sessions.settings.restoreDefaultButtonDescription' => '세션 매개 변수를 기본값으로 복원합니다.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => '세션 매개 변수가 기본값입니다.',
    'sessions.settings.idleTime' => '세션 유휴 시간',
    'sessions.settings.disableCheckSessionIp' => '한 세션 중 IP 주소 변경 허용',
    'sessions.settings.minuteShortTitle' => '최소',

    'settings-ui.controls.title' => '제어',

    'settings-ui.interface-views.description' => "다양한 제품 UI 보기가 제공됩니다. 사용 중인 보기에 따라 기능과 설정을 다른 곳에 위치하거나 활성화/비활성화할 수도 있습니다. 다양한 유형의 사용자에 맞도록 서로 다른 보기를 조정할 수 있습니다.",
    'settings-ui.interface-views.panelSimpleLink' => '도구 & 설정> 제한 모드 설정',
    'settings-ui.interface-views.useCustomView' => '제한 모드 활성화',
    'settings-ui.interface-views.useCustomViewHint' => '관리자가 Plesk Panel에서 수행할 수 있는 작업 수를 제한하려면 이 옵션을 선택하십시오. 작업 사용 가능 여부를 변경하려면 %%customViewSettingsLink%%(으)로 이동하십시오.',
    'settings-ui.interface-views.powerUserViewHint' => "이 보기는 서버 관리자에게 자체 웹 사이트, 이메일 계정 및 기타 서비스를 관리하기 위한 간소화된 단일 인터페이스를 제공하려는 목적입니다.",
    'settings-ui.interface-views.selectUiModeTitle' => "인터페이스 선택",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "고급 사용자 보기",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "서비스 공급자 보기",
    'settings-ui.interface-views.uiModeHintServiceProvider' => "이 보기는 서버 관리자, 리셀러 및 호스팅 최종 사용자가 사용하기 위한 인터페이스를 제공합니다.",

    'sitebuilder.trial.description' => '이 페이지에서 사용 후 구매 모드를 구성할 수 있습니다(이전의 고객 유치 시나리오). 이 모드에서 고객은 포함된 Presence Builder 응용 프로그램에 제공된 모든 기능을 사용하여 웹 사이트를 만들 수 있습니다. 단, 호스팅 서비스 플랜 또는 플랜 추가 기능을 구입할 때까지 고객은 평가판 웹 사이트를 게시할 수 없습니다. 사용 후 구매 모드를 호스팅 플랜 또는 플랜 추가 기능을 통해 기존 고객에게 제공할 수도 있습니다. %%link%%',
    'sitebuilder.trial.descriptionLink' => '자세한 내용은 문서를 참조하십시오.',
    'sitebuilder.trial.lifetimeLabel' => '평가판 웹 사이트 수명',
    'sitebuilder.trial.lifetimeUnits' => '일',
    'sitebuilder.trial.lifetimeDescription' => '이 시간이 지나면 고객이 구입하지 않은 평가판 웹 사이트가 서버에서 제거됩니다.',
    'sitebuilder.trial.signupLabel' => '평가 모드에 대한 공용 액세스 활성화',
    'sitebuilder.trial.signupDescription' => 'Presence Builder를 통한 호스팅을 광고하고 Presence Builder 데모를 고객에게 제공하여 고객을 유치하려면 평가 모드에 대한 공용 액세스를 활성화하고 평가 모드 액세스 URL을 웹 사이트에 게시합니다.',
    'sitebuilder.trial.signupLinkLabel' => '평가 모드 액세스 URL',
    'sitebuilder.trial.signupLinkDescription' => '이 URL을 클릭하면 Presence Builder가 평가 모드로 열립니다. 이 URL을 웹 사이트에 게시하여 Presence Builder를 통한 호스팅을 광고하고 고객을 유치합니다.',
    'sitebuilder.trial.promotionLabel' => 'Presence Builder 편집기에 평가 모드 알림 표시',
    'sitebuilder.trial.promotionDescription' => '평가 모드로 작동 중인 Presence Builder에 대한 추가 알림을 표시하려면 이 옵션을 사용합니다.',

    'update-settings.policyHintForPum' => '여기에서 업데이트 자동 설치를 설정할 수 있습니다. 업데이트의 수동 설치가 가능하거나 자동으로 설치되어 있는 경우 알림 이메일을 전송합니다.',
    'update-settings.policyHint' => '업데이트의 수동 설치가 가능하거나 자동으로 설치되어 있는 경우 알림 이메일을 전송합니다.',
    'update-settings.branchDisabledDescription' => '사용 가능한 업데이트에 대해 알리지 않음',
    'update-settings.automaticPatchesInstallation' => 'Plesk 업데이트 자동 설치(권장)',
    'update-settings.automaticPatchesInstallationHint' => '중요 보안 업데이트는 항상 자동으로 설치됩니다.',
    'update-settings.automaticPatchesThirdParty' => 'Plesk가 제공하는 타사 구성 요소에 대한 업데이트 자동 설치',
    'update-settings.automaticSystemPackageUpdates' => '시스템 패키지 업데이트 자동 설치',
    'update-settings.automaticSystemPackageUpdatesHint' => '이 작업을 실행하면 Plesk가 배송하는 타사 구성 요소에 대한 업데이트도 자동으로 설치된다는 점에 주의하십시오.',
    'update-settings.automaticPatchesNotification' => '사용 가능 또는 설치된 시스템 패키지 업데이트 알림',
    'update-settings.systemPackageUpdatesNotificationsEmail' => '이메일 주소',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => '알림 이메일 빈도',
    'update-settings.daily' => '매일',
    'update-settings.weekly' => '매주',
    'update-settings.generalSection' => '일반',
    'update-settings.notificationsSection' => '알림',
    'update-settings.safeUpdatesSection' => '안전 업데이트',
    'update-settings.safeUpdatesSectionHint' => 'Plesk는 시스템 패키지 업데이트는 패키지가 설치된 곳과 동일한 리포지토리에 설치합니다. 이와 같이 설치된 업데이트는 안전하다고 간주됩니다. 안전 업데이트를 비활성화하면 시스템의 모든 리포지토리에서 시스템 패키지 관리자가 업데이트를 설치할 수 있습니다.',
    'update-settings.safeUpdatesSectionWarn' => '고급 사용자인 경우를 제외하고 안전 업데이트의 활성화를 유지하는 것이 좋습니다. 다른 리포지토리를 이용한 무분별한 시스템 패키지 업데이트는 서버 기능에 부정적인 영향을 미칠 수 있습니다.',
    'update-settings.allowSafeUpdates' => '시스템 패키지의 안전 업데이트 활성화',

    'requiredFields' => '필수 필드',
];