<?php
// Copyright 1999-2021. Plesk International GmbH. All rights reserved.
// This file contains Plesk Command Line Utility (CLI) locale keys

$GLOBALS['lmsg_arr'] += [
    'cu__error' => "ERROR: %1",

    // P9 CLI

    'cu_res_pref__create_domains' => 'Allow reseller to create domains',
    'cu_client_convert_to_reseller' => 'Convert customer account to a reseller account',
    'cu_client_change_owner' => 'Change the owner of the customer account',
    'cu_client_owner_login' => 'Username of the new customer account owner',
    'cu__create_clients' => 'Allows to create customers',
    'cu__allow_oversell' => 'Allows to manage oversell',
    'cu__oversell' => 'Allow overselling',
    'cu__overuse' => 'Set overuse policy',
    'cu__disk_space_soft' => 'sends the notification upon reaching the specified amount of disk space used',
    'cu__max_traffic_soft' => 'sends the notification upon reaching the specified amount of traffic used',
    'cu__max_clients' => 'limits the maximum number of customer accounts',

    // customer  (updated)
    'cu_client__passwd_type' => 'Plesk password type [not recommended. See the note below for details]',
    'cu_client__passwd' => 'Plesk password (required for creation) [not recommended. See the note below for details]',
    'cu_client__suc_subscription_locked' => 'The subscription of customer %1 was locked.',
    'cu_client__suc_subscription_unlocked' => 'The subscription of customer %1 was unlocked.',
    'cu_client__suc_unsubscribed' => 'The customer %1 was unsubscribed from the service plan.',
    'cu_client__suc_subscribed' => 'The customer %1 was subscribed to the service plan %2.',
    'cu_client__lock_subscription' => 'Locks customer\'s subscription for syncing with a plan.',
    'cu_client__unlock_subscription' => 'Unlocks subscription and enables synchronization with associated service plans.',
    'cu_client__unsubscribe' => 'Unbinds a customer\'s subscription from service plan and makes it a custom subscription.',
    'cu_client__subscribe' => 'Subscribes a customer to the specified plan. This command is for internal use only.',
    'cu_client__unable_subscribe' => "Unable to subscribe the customer to the service plan: %1",
    'cu_client__unable_sync' => "Unable to synchronize customer subscription with service plan: %1",
    'cu_client__suc_sync' => 'Customer subscription %1 was synchronized with the service plan.',
    'cu_client__sync' => 'Synchronizes customer subscription with a plan.',

    'cu_cln_pref_info_not_subscribed' => 'The customer is not subscribed to service plans.',
    'cu_cln_pref_info_subscribed' => 'The customer is subscribed to the service plan "%1".',
    'cu_client__subscription_problems_not_applied_list' => 'The following properties are editable by customer and, therefore, are not applied:',

    'cu_client__template' => 'Service plan for customer creation. For internal use only',
    'cu_client__force' => 'Force the usage of service plan',
    'cu_cl_tpl__create' => "Create service plan",
    'cu_cl_tpl__update' => "Update existing service plan",
    'cu_cl_tpl__remove' => "Remove service plan",
    'cu_cl_tpl__info' => "Show the settings of service plan",
    'cu_cl_tpl__new_name' => "Change the name of service plan",
    'cu_cl_tpl__unable_create' => "Unable to create service plan: %1",
    'cu_cl_tpl__success_create' => "Creation of service plan '%1' completed.\n",
    'cu_cl_tpl__unable_update' => "Unable to update service plan: %1",
    'cu_cl_tpl__success_update' => "Update of service plan '%1' completed.\n",
    'cu_cl_tpl__unable_remove' => "Unable to remove service plan: %1",
    'cu_cl_tpl__success_remove' => "Removal of service plan '%1' completed.\n",
    'cu_cl_tpl__unable_info' => "An error occurred on attempt to retrieve service plan information: %1",
    'cu_cl_tpl__xml_info' => 'Displays the contents of the service plan in XML format',
    'cu_dom_tpl__clogin' => "Username of the reseller who will own this hosting plan (do not use if the plan owner should be admin)",
    'cu_cl_tpl__create_default' => 'Creates the default service plan.',
    'cu_dom_addon_tpl__clogin' => "Username of the reseller who will own the hosting plan add-on (do not use if the add-on owner should be admin)",
    'cu__template_opts_conflict' => 'the options -service-plan and -service-plan-guid cannot be specified together',
    'cu_dom_tpl__xml_info' => 'Output the contents of the domain service plan in XML format',
    'cu_cl_tpl__owner' => 'Username of an existing reseller or administrator to whom the service plan will belong',



    'cu__note' => 'Note:',
    'cu__note_password_plain' => "For security reasons, we recommend that you pass non-encrypted passwords using the environment variable %1. To do so, specify an empty value in the command line for the argument(s) %2 (like %3) and specify the password in the variable %4.",
    'cu__note_password_encrypted' => "Similarly, we recommend that you pass encrypted passwords using the environment variable %1. To do so, specify an empty value in the command line for argument(s) %2 (like %3) and specify the password value in the variable %4.",
    'cu__parse_number_error' => 'Cannot extract value from string "%1"',
    'cu_client__sb_user' => 'Create corresponding user in Presence Builder',
    'cu_client__creation_date' => 'Specifies customer account creation date',

    // skeleton
    'cu_skeleton_command_description_install' => 'Installs the specified virtual host file template for given user\'s account',
    'cu_skeleton_command_description_reset' => 'Installs the default virtual host file template for given user',
    'cu_skeleton_command_description_help' => 'Displays this help page',
    'cu_skeleton_option_description_filename' => 'Name of virtual host file template archive (required for "--install" command)',
    'cu_skeleton_option_description_force_type' => 'Makes specifying of the archive type required',
    'cu_skeleton_command_install_success' => "Virtual host file template was successfully installed.\n",
    'cu_skeleton_command_reset_success' => "Default virtual host file template was successfully installed.\n",

    // server-wide DNS
    'cu_server_dns_command_description_add' => 'Adds a resource record to the DNS zone template. If such record exists, error code 2 will be returned',
    'cu_server_dns_command_description_set' => 'Adds all resource records to DNS zone template. Old records will be removed. Record format is "<type>,<host>,<ip>[,<option>]". Examples: "NS,,ns.<domain>.", "MX,,mail.<domain>.,10"',
    'cu_server_dns_command_description_update_server' => 'Updates server-wide DNS settings',
    'cu_server_dns_command_description_update_soa' => 'Updates DNS SOA settings',
    'cu_server_dns_command_description_info' => 'Displays information about server-wide DNS settings',
    'cu_server_dns_command_description_enable_custom_backend' => 'Switches on Plesk integration with a third-party DNS and uses the specified script for the integration',
    'cu_server_dns_command_description_disable_custom_backend' => 'Switches off Plesk integration with a third-party DNS and restores the default settings',
    'cu_server_dns_command_description_help' => 'Displays this help page',
    'cu_server_dns_option_description_status' => 'Switches on or off the DNS zone. Required for "update-server" command',
    'cu_server_dns_option_description_add_acl' => 'Adds the list of IP addresses to ACL template of the DNS zone. Required for "update-server" command',
    'cu_server_dns_option_description_a' => 'A resource record',
    'cu_server_dns_option_description_ns' => 'NS resource record',
    'cu_server_dns_option_description_mx' => 'MX resource record',
    'cu_server_dns_option_description_cname' => 'CNAME resource record',
    'cu_server_dns_option_description_ptr' => 'PTR resource record',
    'cu_server_dns_option_description_txt' => 'TXT resource record',
    'cu_server_dns_option_description_caa' => 'CAA resource record',
    'cu_server_dns_option_description_ip' => 'Specifies IP address for creating an A record',
    'cu_server_dns_option_description_nameserver' => 'Specifies nameserver for creating a NS record',
    'cu_server_dns_option_description_mailexchanger' => 'Specifies mail exchange server for creating a MX record',
    'cu_server_dns_option_description_priority' => 'Specifies mail exchange server priority for a MX record',
    'cu_server_dns_option_description_canonical' => 'Specifies canonical name for creating a CNAME record',
    'cu_server_dns_option_description_subnet' => 'Specifies subnet for creating a PTR record (for example, 123.123.123.123/8 or <ip>/8)',
    'cu_server_dns_option_description_domain' => 'Specifies domain name for creating TXT/CAA record',
    'cu_server_dns_option_description_soa_ttl' => 'Specifies TTL value for server-wide SOA settings template',
    'cu_server_dns_option_description_ttl' => 'Specifies TTL value for DNS records settings',
    'cu_server_dns_option_description_soa_refresh' => 'Specifies Refresh value for server-wide SOA settings template',
    'cu_server_dns_option_description_soa_retry' => 'Specifies Retry value for server-wide SOA settings template',
    'cu_server_dns_option_description_soa_expire' => 'Specifies Expire value for server-wide SOA settings template',
    'cu_server_dns_option_description_soa_minimum' => 'Specifies Minimum value for server-wide SOA settings template',
    'cu_server_dns_option_description_soa_rname_admin' => 'Website owner email address for server-wide SOA records template',
    'cu_server_dns_option_description_soa_rname_domain' => 'Domain email address for server-wide SOA records template',
    'cu_server_dns_option_description_soa_rname_external' => 'External email address for server-wide SOA records template',
    'cu_server_dns_option_description_soa_rname_enforce' => 'Prohibit changes of this parameter on a per domain basis, use this email for all domains in server-wide SOA records template',
    'cu_server_dns_command_update_server_success' => "Server-wide DNS settings were successfully updated.\n",
    'cu_server_dns_command_add_success' => "DNS record was successfully created in the server-wide DNS zone template.\n",
    'cu_server_dns_command_set_success' => "DNS record was successfully updated in the server-wide DNS zone template.\n",
    'cu_server_dns_command_update_soa_success' => "Server-wide SOA records were successfully updated.\n",
    'cu_server_dns_option_description_soa_serial_format' => 'Updates serial format of SOA record',
    'cu_dns_option_description_soa_serial_format' => 'Updates serial format of SOA record',
    'cu_server_dns_command_disable_custom_backend_success' => "The Plesk integration with a third-party DNS was switched off.\n",
    'cu_server_dns_command_enable_custom_backend_success' => "The Plesk integration with a third-party DNS was successfully switched on.\n",
    'cu_server_dns_command_enable_custom_backend_failed_invalid_script' => "Unable to enable Custom DNS backend: invalid DNS backend script.\n",

    // SSL/TLS certificate
    'cu_certificate_command_description_create' => 'Creates SSL/TLS certificate',
    'cu_certificate_command_description_update' => 'Updates SSL/TLS certificate',
    'cu_certificate_command_description_remove' => 'Removes SSL/TLS certificate',
    'cu_certificate_command_description_assign_cert' => 'Assigns SSL/TLS certificate to an IP address',
    'cu_certificate_command_description_list' => 'Displays the list of SSL/TLS certificates stored in the repository',
    'cu_certificate_command_description_help' => 'Displays this help page',
    'cu_certificate_option_description_domain' => "Domain repository",
    'cu_certificate_option_description_admin' => "Administrator repository",
    'cu_certificate_option_description_default' => "Set SSL/TLS certificate as the default one. Can be used only for Plesk administrator's certificates",
    'cu_certificate_option_description_new_name' => 'New name for the certificate',
    'cu_certificate_option_description_key_file' => 'Private key file (required for creation)',
    'cu_certificate_option_description_cert_file' => 'Certificate file',
    'cu_certificate_option_description_cacert_file' => 'CA certificate file',
    'cu_certificate_option_description_csr_file' => 'CSR certificate file',
    'cu_certificate_option_description_ip' => 'Assigns certificate to specified IP address (only for "--assign-cert" command)',
    'cu_certificate_create_object_error' => 'Unable to create object %1: %2',
    'cu_certificate_update_object_error' => 'Unable to update object %1: %2',
    'cu_certificate_save_object_error' => 'Unable to save object %1: %2',
    'cu_certificate_repository_not_specified' => "Certificate repository ('-domain' or '-admin') is not specified\n",
    'cu_certificate_option_domain_params_wrong' => "Wrong syntax for parameter of option \"-domain\"\n",
    'cu_certificate_command_create_success' => "SSL/TLS certificate '%1' was successfully created\n",
    'cu_certificate_command_update_success' => "SSL/TLS certificate '%1' was successfully updated\n",
    'cu_certificate_command_remove_success' => "SSL/TLS certificate '%1' was successfully removed\n",
    'cu_certificate_command_list_success' => "Listing of SSL/TLS certificates repository was successful\n",
    'cu_certificate_command_assign_cert_success' => "SSL/TLS certificate '%1' was successfully assigned to IP address %2\n",
    'cu_certificate_command_unknown' => "Unknown command: '%1'",
    'cu_certificate_command_toip_option_ip_empty' => "Option '-ip' must be specified\n",
    'cu_certificate_command_toip_ip_error' => "Unable to assign certificate for the following IP address: %1",
    'cu_certificate_command_toip_ip_not_exists' => "IP address '%1' does not exist in user's IP pool",
    'cu_certificate_command_setcertip_error_semaphore' => 'Unable to acquire semaphore: %1',
    'cu_certificate_command_setcertip_error_ip_alias' => 'Unable to update IP alias values: %1',
    'cu_certificate_clientip_nodomain' => "Domain %1 does not exist\n",
    'cu_certificate_clientip_error_noip' => "IP address %1 does not exist in user's IP pool",
    'cu_certificate_command_list_error' => "Unable to get the list of certificates: %1",
    'cu_certificate_wrong_option_ip' => "Option '-ip' can only be used with command '--assign-cert'\n",
    'cu_certificate_command_remove_error' => 'Unable to remove certificate %1: %2',
    'cu_certificate_not_found' => 'Certificate does not exist.',
    'cu_certificate_cert_remove_error_delete' => 'Unable to remove certificates: %1',
    'cu_certificate_command_update_error' => 'Unable to update certificate %1: %2',
    'cu_certificate_no_file' => 'File %1 does not exists',
    'cu_certificate_file_not_readable' => 'File %1 not readable',
    'cu_certificate_command_update_error_check' => '%1 failed: %2',
    'cu_certificate_wrong_option_key_file' => "Parameter for option '-key-file' must be specified\n",
    'cu_certificate_cannot_make_default' => "Certificate '%1' cannot be set as default one: private key is missing.",

    // database
    'cu_database_registrar__command_add_db_user' => 'Adds user name to database.',
    'cu_database_registrar__command_drop_db_user' => 'Removes user from database.',
    'cu_database_registrar__command_get_credentials' => 'Gets credentials for accessing remote database server (requires -type)',
    'cu_database_registrar__command_get_default_credentials' => 'Gets credentials for accessing default database server (requires -type)',
    'cu_database_registrar__command_get_default_server' => 'Get default server. Format host:port. (requires -type)',
    'cu_database_registrar__command_help' => 'Help page',
    'cu_database_registrar__option_passwd' => 'Specifies database user password',
    'cu_database_registrar__command_get_db_server_info' => 'Retrieves database server information (requires the -type option)',

    // site app
    'cu_siteapp__command_install_on_server' => 'Install specified package to Plesk.',
    'cu_siteapp__command_remove_from_server' => 'Deinstall specified package from Plesk.',
    'cu_siteapp__command_add_to_vault' => 'Add specified packages to customer\'s application pool[deprecated since 8.3].',
    'cu_siteapp__command_info_packages_xml' => 'Print XML description of available packages in server application vault.',
    'cu_siteapp__command_help' => 'Help page',
    'cu_siteapp__option_sapp_name' => 'Web application\'s name.',
    'cu_siteapp__option_sapp_version' => 'Web application\'s version number.',
    'cu_siteapp__option_sapp_release' => 'Web application\'s release number.',
    'cu_siteapp__option_file' => 'Path to file with distrib of SiteApllication',
    'cu_siteapp__add_to_vault_success' => "Operation with application pool successfully completed.\n",
    'cu_siteapp__install_on_server_error' => 'Unable to install package %1',
    'cu_siteapp__install_on_server_success' => "Package installation successfully completed",
    'cu_siteapp__remove_from_server_error' => 'Unable to remove package %1',
    'cu_siteapp__remove_from_server_success' => "Package removing successfully completed",
    'cu_siteapp_item__remove_success' => 'Web application was removed.',
    'cu_siteapp_item__does_not_exist' => 'Web application does not exist: %1-%2',
    'cu_siteapp_item__add_to_pool_success' => 'Web application was added to web application pool.',
    'cu_siteapp_item__remove_from_pool_success' => 'Web application was removed from web application pool.',

    // site app item
    'cu_siteapp_item__command_create' => 'Creates application item',
    'cu_siteapp_item__command_add_to_pool' => 'Adds application item to customer\'s pool',
    'cu_siteapp_item__command_remove_from_pool' => 'Removes application item from customer\'s pool',
    'cu_siteapp_item__command_list' => 'Prints list application items defined on server',
    'cu_siteapp_item__command_remove' => 'Remove application item',
    'cu_siteapp_item__option_sapp_name' => 'Web application\'s name.',
    'cu_siteapp_item__option_sapp_version' => 'Web application\'s version number.',
    'cu_siteapp_item__option_release' => 'Web application\'s release number.',
    'cu_siteapp_item__option_license_type' => 'License type',
    'cu_siteapp_item__option_description' => 'Application item description',
    'cu_siteapp_item__option_shared' => 'Application item access',
    'cu_siteapp_item__option_instances_limit' => 'Allowed installations for application item',
    'cu_siteapp_item__option_enabled' => 'Application item mode',

    // site app license
    'cu_siteapp_license__command_add' => 'Adds license on server',
    'cu_siteapp_license__command_remove' => 'Removes license from server',
    'cu_siteapp_license__command_list' => 'Prints the list of installed licenses on server',
    'cu_siteapp_license__command_set' => 'Sets license options. i.e. grace period',
    'cu_siteapp_license__command_update' => 'Start update procedure for all installed licenses',
    'cu_siteapp_license__option_source_file' => 'File to take new license from',
    'cu_siteapp_license__option_activation_code' => 'Activation code',
    'cu_siteapp_license__option_grace_period' => 'Specifies time when update license start',

    // admin alias
    'cu_admin_alias_command_description_create' => 'Creates additional administrator account',
    'cu_admin_alias_command_description_update' => 'Sets settings of additional administrator account',
    'cu_admin_alias_command_description_remove' => 'Removes additional administrator account',
    'cu_admin_alias_command_description_info' => 'Shows information about additional administrator account',
    'cu_admin_alias_command_description_xml_info' => 'additional administrator account in XML format',
    'cu_admin_alias_command_description_list' => 'Displays the list of additional administrator accounts',
    'cu_admin_alias_command_description_help' => 'Displays this help page',
    'cu_admin_alias_option_description_lgon' => 'Sets new username for additional administrator account',
    'cu_admin_alias_option_description_passwd' => 'Sets new password for additional administrator account',
    'cu_admin_alias_option_description_email' => 'Sets new email address for additional administrator account',
    'cu_admin_alias_option_description_enabled' => 'Allows or forbids access to Plesk for additional administrator account',
    'cu_admin_alias_option_description_contact' => 'Sets contact name of additional administrator account',
    'cu_admin_alias_option_description_comment' => 'Sets comment for additional administrator account',
    'cu_admin_alias_option_description_restrictions' => 'Enables Restricted Mode for the additional administrator account',
    'cu_admin_alias_option_description_power_user' => 'Forces Power User view for the additional administrator account',
    'cu_admin_alias_command_create_success' => 'Additional administrator account was successfully created',
    'cu_admin_alias_command_update_success' => 'Additional administrator account was successfully updated',
    'cu_admin_alias_command_remove_success' => 'Additional administrator account was successfully removed',


    // event handler
    'cu_event_handler_command_description_create' => 'Creates an event handler',
    'cu_event_handler_command_description_update' => 'Updates event handler (handler ID required)',
    'cu_event_handler_command_description_delete' => 'Removes event handler (handler ID required)',
    'cu_event_handler_command_description_list' => 'Displays the list of event handlers and their IDs',
    'cu_event_handler_command_description_list_events' => 'Displays available events and their parameters',
    'cu_event_handler_command_description_list_users' => 'Shows user accounts which can be used for handlers',
    'cu_event_handler_command_description_help' => 'Displays this help page',
    'cu_event_handler_option_description_priority' => 'Specifies event handler priority (0 - lowest, 100 - highest)',
    'cu_event_handler_option_description_user' => 'Specifies user account used for event handler execution',
    'cu_event_handler_option_description_command' => 'Specifies command with parameters or path to script to execute on event',
    'cu_event_handler_option_description_event' => 'Specifies event which should trigger the execution of command',

    // server pref
    'cu_servpref__templates_list' => 'Shows the list of installed interface customization templates.',
    'cu_servpref__templates_enumeration' => "Interface customization templates:\n%1\n",
    'cu_servpref__set_def_locale' => 'Sets default locale [deprecated].',
    'cu_servpref__locales_list' => 'Shows the list of supported locales.',
    'cu_servpref__set_def_skin' => 'Sets default skin [deprecated].',
    'cu_servpref__file_not_exist_or_invalid' => 'File "%1" does not exist or contains invalid data.',
    'cu_servpref__skins_list' => 'Shows list of installed skins.',
    'cu_servpref__unable_set_def_locale' => 'Unable to set default locale: specified locale "%1" is not supported.',
    'cu_servpref__locales_available' => "Available locales:\n%1\n",
    'cu_servpref__skin_not_exist' => 'Skin "%1" does not exist.',
    'cu_servpref__skins_installed' => "Skins installed:\n%1\n",
    'cu_servpref__blog_and_photo_subdomains' => 'Creates blog and photo gallery subdomains by default [deprecated]',
    'cu_servpref__success_update' => "SUCCESS: Server settings are successfully updated\n",
    'cu_servpref__command_description_set_default' => 'Sets default server-wide parameters.',
    'cu_serverpref__option_description_locale' => 'Sets default interface language (for "set-default" command only. Example: "it-IT" for Italian)',
    'cu_serverpref__option_description_skin' => 'Sets default interface skin (for "set-default" command only. Example: "WinXP Reloaded")',
    'cu_serverpref__option_description_template' => 'Sets default interface customization template (for "set-default" command only)',
    'cu_serverpref__option_description_multiple_sessions' => "Allows multiple sessions for server administrator [deprecated, use 'admin' utility instead]",
    'cu_serverpref__option_description_max_button_length' => "Sets button label length for server administrator [deprecated, use 'admin' utility instead]",
    'cu_serverpref__option_description_loc_screen' => "Prevents users from working with Plesk until interface screens are completely loaded [deprecated, use 'admin' utility instead]",
    'cu_serverpref__option_description_hide_top_advertisement' => 'Hide top advertisement',
    'cu_serverpref__option_description_hostname' => 'Full server hostname.',
    'cu_serverpref__option_description_include_logs' => 'Includes log files in the disk space usage calculation.',
    'cu_serverpref__option_description_include_mysql_databases' => 'Includes MySQL databases in the disk space usage calculation.',
    'cu_serverpref__option_description_include_mssql_databases' => 'Includes Microsoft SQL databases in the disk space usage calculation.',

    'cu_serverpref__option_description_include_mailboxes' => 'Includes mailboxes in the disk space usage calculation.',
    'cu_serverpref__option_description_maillists' => 'Includes mailing lists in the disk space usage calculation.',
    'cu_serverpref__option_description_domain_dumps' => 'Includes domain backup files in the disk space usage calculation.',
    'cu_serverpref__option_description_admin_dumps' => 'Includes backup files created by the administrator in the disk space usage calculation.',
    'cu_serverpref__option_description_stat_keep' => 'Retains traffic statistics (in months).',
    'cu_serverpref__option_description_traffic_direction' => 'Includes only certain type of traffic in the traffic calculation (inbound and outbound traffic, only inbound traffic, only outbound traffic).',
    'cu_serverpref__option_description_force_db_prefix' => 'Forces the usage of database name prefixes. Set \'true\' to use <plesk_username>_ as the prefix. Set \'external_id\' to use a subscription\'s external ID as the prefix. If a subscription has no external ID, no prefix will be added.',
    'cu_serverpref__option_description_forbid_create_dns_subzone' => "Forbids users from creating DNS subzones in other users' DNS superzones.",
    'cu_serverpref__option_description_forbid_subscription_rename' => 'Forbids customers to change the name of the main domain on a subscription.',
    'cu_serverpref__option_description_force_db_user_prefix' => 'Forces the use of <plesk_username>_ database user prefix.',
    'cu_serverpref__option_description_db_user_length' => 'Limits database user name length.',
    'cu_serverpref__option_apache_restart_interval' => 'Sets the Apache restart interval.',
    'cu_serverpref__option_description_autoupdates_third_party' => 'Sets automatic installation of updates for third-party components.',
    'cu_serverpref__option_description_use_ftps' => 'Sets up FTPS for accessing the backup storage. Use \'true\' for FTPS and \'false\' for FTP. By default, the FTP protocol is used. This option is used with the "set-backup-node-settings" command.',
    'cu_serverpref__option_description_ftr_over_ssl' => 'Sets up FTPS to protect communication between the FTP server and external FTP clients using SSL/TLS protocol. (Use `required` to allow only secure FTPS connections.)',
    'cu_serverpref__option_description_ftr_over_ssl_with_custom' => 'Sets up FTPS to protect communication between the FTP server and external FTP clients using SSL/TLS protocol. (Use `required` to allow only secure FTPS connections. Use `custom` to use custom FTPS settings per IP address.)',
    'ftpOverSslNotSupportedCustomMode' => 'Linux service nodes do not support custom FTPS settings per IP address.',
    'cu_serverpref__option_description_forbid_ftp_user_rename' => 'Forbids customers to change the user name of the system users associated with their subscriptions. Use \'false\' to allow customers to change the name of the system user. Use \'true\' to prohibit changing the name of the system user by all customers except those who have the \'Hosting Management\' permission. Use \'forced\' if you want to prohibit all customers from changing the name of their system user.',
    'cu_serverpref__option_description_piped_log' => 'Enables piped logs.',
    'cu_serverpref__option_description_aps_force_updates' => 'Forces automatic updates for all installed apps',
    'cu_serverpref__option_description_aps_suggest_updates' => 'Turns on automatic updates for newly installed apps. Users will be able to turn the updates off unless the force updates are turned on.',
    'cu_serverpref__option_description_support_url' => 'Sets the URL that opens when clicking the Support button.',
    'cu_serverpref__option_description_grant_alter_database_to_mssql_users' => 'Grants the ALTER DATABASE permission to all Microsoft SQL Server database users or revokes it from them.',
    'cu_serverpref__option_description_allow_local_ftp_backup' => 'Allows users to specify the local Plesk server as the location of their FTP storage for storing backups.',
    'cu_serverpref__option_description_enable_backup_operator_role_for_mssql_users' => 'Switches on or off the db_backupoperator role membership for all Microsoft SQL Server database users.',
    'cu_serverpref__option_description_ssl_protocols' => 'Sets up SSL/TLS protocols to all services.',
    'cu_serverpref__option_description_ssl_ciphers' => 'Sets up SSL/TLS ciphers to all services.',

    'cu_serverpref__option_description_panel_certificate' => 'The name of the certificate to secure Plesk.',
    'cu_serverpref__option_description_mail_server_certificate' => 'The name of the certificate to secure the mail server.',
    'cu_serverpref__option_description_certificate_repository' => 'The domain where the certificate repository is located (server repository by default)',
    'cu_serverpref__error_domain_not_found' => 'Unable to find the domain %1',
    'cu_serverpref__error_certificate_not_found' => 'Unable to find the certificate %1',
    'cu_serverpref__certificate_none' => 'none',
    'cu_serverpref__certificate_name_repository' => '%1 (%2)',

    // traffic
    'cu_traffic_command_description_add' => 'Registers a specific amount of traffic as if already being used up by domain',
    'cu_traffic_command_description_sub' => 'Subtracts a specific amount of traffic from the amount of traffic registered as used up for domain',
    'cu_traffic_command_description_add_batch' => 'Registers a specific amount of traffic from STDIN as if already being used up by domain [batch mode].',
    'cu_traffic_command_description_del' => 'Resets the amount of traffic registered for this domain to zero.',
    'cu_traffic_command_description_help' => 'Displays this help page',
    'cu_traffic_option_description_date' => 'Sets the date when traffic statistics were updated',
    'cu_traffic_option_description_type' => 'Specifies traffic type',
    'cu_traffic_option_description_value' => 'Specifies the amount of traffic',
    'cu_traffic_option_description_direction' => 'Specifies the traffic direction',
    'cu_traffic_command_add_success' => 'Specified amount of traffic was successfully registered.',
    'cu_traffic_command_del_success' => 'Specified amount of traffic was successfully reset.',
    'cu_traffic_command_add_error' => 'Unable to register the specified amount of traffic.',
    'cu_traffic_command_add_batch_success' => 'Specified amount of traffic was successfully registered.',

    // interface template
    'cu_interface_template_command_description_export' => 'Exports interface template in a file or STDOUT',
    'cu_interface_template_command_description_import' => 'Imports interface template from a file or STDIN',
    'cu_interface_template_command_description_preferences' => 'Updates interface preferences',
    'cu_interface_template_command_description_help' => 'Displays this help page',
    'cu_interface_template_option_description_file' => "Sets path to desired file for 'export' and 'import' commands",
    'cu_interface_template_option_description_from_stdin' => "Reads XML from STDIN for 'import' command",
    'cu_interface_template_option_description_to_stdin' => "Puts XML in STDIN for 'export' command",
    'cu_interface_template_option_description_domain_registration' => "Hides buttons for domain registration (used with the '--preferences' command)",
    'cu_interface_template_option_description_cert_purchasing' => "Hides buttons for SSL/TLS certificate purchasing (used with the '--preferences' command)",
    'cu_interface_template_option_description_extras' => "Hides buttons for extra services (used with the '--preferences' command)",
    'cu_interface_template_option_description_domain_registration_url' => "Sets a custom URL for domain name registration (used with the '--preferences' command)",
    'cu_interface_template_option_description_domain_management_url' => "Sets a custom URL for purchased domain names management (used with the '--preferences' command)",
    'cu_interface_template_option_description_cert_purchasing_url' => "Sets a custom URL for SSL/TLS certificates purchasing (used with the '--preferences' command)",
    'cu_interface_template_option_description_mpc_portal_url' => "Sets a custom URL for the Provider Services link (used with the '--preferences' command)",
    'cu_interface_template_option_description_mail_bounce' => "Hides controls for bounce messages for non-existent mail addresses (used with the '--preferences' command)",

    // OLD CLI (up to 7.x.)

    //    'cu__help' => 'Displays this help page.',
    'cu__company' => 'Company name',
    'cu__phone' => 'Phone number',
    'cu__fax' => 'Fax',
    'cu__email' => 'Email address',
    'cu__addr' => 'Street',
    'cu__city' => 'City',
    'cu__state' => 'State or province',
    'cu__pcode' => 'Postal or ZIP code',
    'cu__country' => "Country codes (2 symbols). These codes are described in the ISO-3166 standard, which can be retrieved from the Internet.",
    'cu__unable_create_object' => 'Unable to create %1 object: %2',
    'cu__unable_define_attribute' => "cannot define attribute method for '%1' argument",
    'cu__method_not_exist' => 'Method "%1" does not exist',
    'cu__unable_set_value' => "Unable to set '%1' argument's value ('%2'): %3",
    'cu__client_not_exist' => 'Customer account with username "%1" does not exist',
    'cu__iis_app_pool' => 'Use a dedicated IIS application pool (default: %1)',
    'cu__iis_app_pool_addons' => 'Use a dedicated IIS application pool for each website (default: %1)',
    'cu__enable_32bit_app_on_win64' => 'Enable IIS to run 32-bit applications on 64-bit Windows (default: %1)',
    'cu__cpu_usage' => 'Define maximum CPU usage',
    'cu__wrong_syntax' => "Wrong syntax for command's '-%1' parameter\n",
    'cu__opt1_required_opt2' => '"%1" option is required for "%2" option',
    'cu__command_options_error' => 'Command options error: %1',
    'cu__unable_send_notification' => 'Unable to send notification: %1',
    'cu__unable_get_report' => "Unable to get default report: %1\n",
    'cu__error_cpu_usage' => 'Unable to set maximum CPU usage: %1',
    'cu__unable_dedicated_iis_app_pool' => 'Unable to use dedicated IIS Application Pool: %1',
    'cu__unable_shared_iis_app_pool' => 'Unable to use shared IIS Application Pool: %1',
    'cu__unable_feature_iis_app_pool' => 'this feature is currently unavailable due to IIS Application Pool mode policy.',
    'cu__error_dedicated_iis_app_pool' => 'dedicated IIS Application Pool is currently unavailable by IIS Application Pool mode policy.',
    'cu__improper_values' => "the following fields contains improper values:\n",
    'cu__unable_update_object' => 'Unable to update "%1" object: %2',
    'cu__max_dom_aliases' => 'Limits the number of available domain aliases (-1 for unlimited).',
    'cu__disk_space' => 'Limits the amount of available disk space to the specified value (in megabytes) (-1 for unlimited).',
    'cu__max_traffic' => 'Limits the amount of available traffic to the specified value (in megabytes per month) (-1 for unlimited).',
    'cu__max_box' => 'Limits the allowed number of mailboxes to the specified value (-1 is unlimited).',
    'cu__mbox_quota' => 'Limits the mailbox quota to the specified size (in kilobytes) (-1 for unlimited).',
    'cu__total_mbox_quota' => 'Limits the total domain mail quota to the specified size (in megabytes) (-1 for unlimited).',
    'cu__max_wu' => 'Limits the number of web users (-1 for unlimited).',
    'cu__max_db' => 'Limits the number of MySQL databases (-1 for unlimited).',
    'cu__max_mssql_db' => 'Limits the number of MSSQL databases (-1 for unlimited).',
    'cu__mysql_db_space' => 'Limits the disk space of all MySQL databases on a subscription to the specified value (in megabytes) (-1 for unlimited).',
    'cu__mssql_db_space' => 'Limits the disk space of all Microsoft SQL Server databases on a subscription to the specified value (in megabytes) (-1 for unlimited).',
    'cu__mssql_db_filesize' => 'Limits the file size of a Microsoft SQL Server database to the specified value (in megabytes) (-1 for unlimited).',
    'cu__mssql_db_log_filesize' => 'Limits the log file size of a Microsoft SQL Server database to the specified value (in megabytes) (-1 for unlimited).',
    'cu__max_maillists' => 'Limits the number of mailing lists (-1 for unlimited).',
    'cu__max_subdom' => 'Limits the number of subdomains (-1 for unlimited).',
    'cu__unable_update_domain' => "Cannot update domain:\n%1",
    'cu__unable_update_domain_preferences' => 'An error occurred while updating domain settings: %1',
    'cu__success_update_domain' => "SUCCESS: Update of domain '%1' completed.\n",
    'cu__error_domain_info' => 'An error occurred while getting domain information: %1',
    'cu__cgroups_cpu_usage' => 'Limits the CPU usage for a subscription\'s system user, in percent (-1 for Unlimited).',
    'cu__cgroups_cpu_usage_soft' => 'Sends a notification when the specified limit on CPU usage is reached (-1 to disable notifications).',
    'cu__cgroups_cpu_period' => 'Sets the period of time (in seconds) to gather statistics for calculating CPU usage over that period. Allowed values: 300, 3600, 86400.',
    'cu__cgroups_ram_usage' => 'Limits the RAM usage of a subscription, in Bytes (-1 for Unlimited).',
    'cu__cgroups_ram_usage_soft' => 'Sends a notification when the specified limit on RAM usage is reached (-1 to disable notifications).',
    'cu__cgroups_ram_period' => 'Sets the period of time (in seconds) to gather statistics for calculating RAM usage over that period. Allowed values: 300, 3600, 86400.',
    'cu__cgroups_disk_read_usage' => 'Limits the disk read bandwidth for a subscription, in Bytes/s (-1 for Unlimited).',
    'cu__cgroups_disk_read_usage_soft' => 'Sends a notification when the specified limit on disk read bandwidth is reached (-1 to disable notifications).',
    'cu__cgroups_disk_read_period' => 'Sets the period of time (in seconds) to gather statistics for calculating Disk read speed over that period. Allowed values: 300, 3600, 86400.',
    'cu__cgroups_disk_write_usage' => 'Limits the disk write bandwidth of a subscription, in Bytes/s (-1 for Unlimited).',
    'cu__cgroups_disk_write_usage_soft' => 'Sends a notification when the specified limit on disk write bandwidth is reached (-1 to disable notifications).',
    'cu__cgroups_disk_write_period' => 'Sets the period of time (in seconds) to gather statistics for calculating Disk write speed over that period. Allowed values: 300, 3600, 86400.',

    'cu__domain_not_exist' => "Domain with name '%1' does not exist\n",
    'cu__domain_not_belong' => "Domain '%1' does not belong to any customer\n",
    'cu__limit_val_big' => "Value of limit '%1' is too big (%2), it was set to the maximum allowed value: %3\n",
    'cu__unable_set_www' => 'Unable to set www prefix: %1',
    'cu__conflicting_options' => 'Conflicting options',
    'cu__unable_query' => 'Unable to query: %1',
    'cu__domain_req' => 'Domain name (required)',
    'cu__php_isapi' => 'Run PHP as ISAPI extention (default: %1)',
    'cu__hard_quota' => 'hard disk quota (0 for unlimited)',
    'cu__unable_reconfigure_web' => 'Unable to reconfigure web server: %1',
    'cu__unable_restart_dns' => 'Unable to restart DNS service: %1',
    'cu__unable_restart_web' => 'Unable to restart web server: %1',
    'cu__unable_activate_aftp' => 'Unable to activate Anonymous FTP: %1',
    'cu__shared_ip' => 'shared IP address type',
    'cu__ip_already_used' => 'IP address is used in another domain for Anonymous FTP',
    'cu__argv_not_found' => "%1: Cannot read arguments: Cannot find argv\n",
    'cu__not_array' => "%1 - \$allowed_commands or \$command_line is not an array\n",
    'cu__usage' => "Usage: %1\n",
    'cu__cmd_required' => "Command is required\n",
    'cu__not_cmd' => "'%1' is not a command\n",
    'cu__cmd_req_parameter' => "Command -%1 requires parameters\n",
    'cu__unable_recognize_option' => "Unknown option '%1': %2\n",
    'cu__option_req_parameter' => "Option -%1 requires parameters\n",
    'cu__invalid_option' => "Unrecognized option: '%1'\n",
    'cu__req_option_not_set' => "Required option -%1 is not set\n",
    'cu__option_should_not_be_spec' => "Option -%1 should not be specified\n",
    'cu__option_not_suitable_for_command' => 'The option "%1" is not suitable for the "%2" command.',
    'cu__unable_init_admin_session' => "Cannot initialize admin's session: %1\n",
    'cu__unable_register_admin_session' => "Cannot register admin's session: %1\n",
    'cu__available_cmd' => "    Available commands:\n",
    'cu__available_opt' => "    Available options:\n",
    'cu__version' => "Version: %1\n",
    'cu__arg_not_array' => 'argument is not array',
    'cu__unable_output' => '(Cannot write output to stderr) %1',
    'cu__unable_define_version' => 'failed to define product version: %1',
    'cu__siteapp_unable_sync' => "Cannot synchronize packages: %1\n",
    'cu__opt1_required_for_opt2_and_opt3' => '%1 option is required for %2 and %3 options',
    'cu_client__create' => 'Creates a customer account.',
    'cu_client__update' => 'Updates a customer account.',
    'cu_client__remove' => 'Removes a customer account.',
    'cu_client__info' => 'Retrieves customer account information.',
    'cu_client__on' => 'Activates a customer account.',
    'cu_client__off' => 'Suspends a customer account.',
    'cu_client__status' => 'Suspends or activates a customer account (default: %1)',
    'cu_client__name' => 'Contact name (required for creation)',
    'cu_client__login' => 'Account username for access to Plesk (may be used only with the update command)',
    'cu_client__notify' => 'Switches on or off notifying of customer account creation',
    'cu_client__unable_create' => "Cannot create customer account: %1",
    'cu_client__error_create' => 'An error occurred during customer account creation: %1',
    'cu_client__success_create' => "SUCCESS: Creation of customer account for '%1' completed.\n",
    'cu_client__unable_update' => "Cannot update customer account: %1",
    'cu_client__error_update' => 'An error occurred while updating customer account: %1',
    'cu_client__success_update' => "SUCCESS: Update of customer account '%1' completed.\n",
    'cu_client__error_remove' => 'An error occurred during removal of customer account: %1',
    'cu_client__unable_remove' => 'Unable to remove customer accounts: %1',
    'cu_client__success_remove' => "SUCCESS: Removal of customer account '%1' completed\n",
    'cu_client__error_info' => 'An error occurred while getting customer information: %1',
    'cu_client__error_on_off' => 'An error occurred while suspending or activating customer account: %1',
    'cu_client__success_on_off' => "SUCCESS: Changing status of customer account '%1' completed.\n",
    'cu_client__success_info' => "SUCCESS: Information about customer account '%1' was retrieved.\n",
    'cu_client__unknown_country' => 'unknown country code "%1"',
    'cu_client__key_limit' => "Your license key limits do not allow customer account creation.",
    'cu_client__already_exists' => 'A customer account with username "%1" already exists.',
    'cu_client__unable_iis_app_pool_on' => 'Unable to turn on IIS Application Pool: %1',
    'cu_client__unable_change_status' => "Unable to change customer account status: %1",
    'cu_client__unable_update_data' => 'Unable to update customer data: %1',
    'cu_client__unable_switch_iis_app_pool' => 'Unable to switch IIS Application Pool status: %1',
    'cu_client__unable_generate_report' => "Cannot generate report for customer: %1",
    'cu_client__unable_print_report' => "Cannot print report for customer: %1",
    'cu_client__unable_rename_iis_pool' => "Unable to rename IIS Aplication Pool: %1",
    'cu_client__list' => 'Displays the list of customers.',
    'cu_client__convert_to_reseller' => 'Converts a customer account to a reseller account.',
    'cu_client__convert_to_reseller_reseller_plan' => 'Specifies the reseller plan that will be used for a converted reseller.',
    'convert_customer_to_reseller_subscription_not_synchronized' => 'The subscription is not synced with the associated service plan.',
    'cu_client__convert_to_customer' => 'Converts a reseller account to a customer account.',
    'cu_client__convert_to_customer_plan' => 'Specifies the service plan that will be used for a customer.',

    'cu_client__change_owner' => 'Moves the customer to another owner.',
    'cu_client__change_owner_plan' => "Specifies a reseller plan that will be assigned to the customer's subscriptions after moving to another owner.",
    'cu_client__change_owner_ip_list' => "Specifies the list of IP addresses that will be assigned to the customer's subscriptions after moving the customer to another owner.",
    'cu_client__admin_plan_can_not_be_assigned' => "The plan cannot be assigned to the customer's subscription # %1 because this is not a reseller plan, it belongs to the administrator.",
    'cu_client__wrong_ip_list' => 'You can specify only one IPv4 and one IPv6 address.',
    'cu_client__ip_not_exist' => 'The IP address \'%1\' does not exist.',
    'cu_client__description' => 'Specifies a description of the customer to be displayed in Plesk.',
    'cu_reseller__description' => 'Specifies a description of the reseller to be displayed in Plesk.',


    'cu_domain__create' => 'Creates a subscription.',
    'cu_domain__warning_log_bysize_value' => 'The log size could not be less than %1 MB. The log size was automatically set to %1 MB.',
    'cu_subscription__create' => 'Creates a subscription.',
    'cu_site__create' => 'Creates a domain.',
    'cu_domain__create_powerUser' => 'Creates a subscription, or a domain if used with the \'-webspace-name\' option that denotes the target subscription.',
    'cu_domain__update' => 'Updates an existing subscription.',
    'cu_subscription__update' => 'Updates an existing subscription.',
    'cu_site__update' => 'Updates an existing domain.',
    'cu_domain__update_powerUser' => 'Updates an existing subscription, or a domain if used with the \'-webspace-name\' option that denotes the target subscription.',
    'cu_domain__remove' => 'Removes an existing subscription. If specified name is the name of default subscription domain, then removes WHOLE subscription.',
    'cu_subscription__remove' => 'Removes an existing subscription.',
    'cu_site__remove' => 'Removes an existing domain.',
    'cu_domain__remove_powerUser' => 'Removes an existing subscription, or a domain if used with the \'-webspace-name\' option that denotes the target subscription.',
    'cu_domain__info' => 'Retrieves information on a subscription.',
    'cu_subscription__info' => 'Retrieves information on a subscription.',
    'cu_site__info' => 'Retrieves information on a domain.',
    'cu_domain__info_powerUser' => 'Retrieves information on a subscription, or a domain if used with the \'-webspace-name\' option that denotes the target subscription.',
    'cu_domain__on' => 'Activates the domain.',
    'cu_domain__off' => 'Disables the domain.',
    'cu_domain__suspend' => 'Suspends the domain.',
    'cu_domain__webspace_status' => "Suspends or activates a whole subscription. Requires the '-status <enabled|disabled>' option.",
    'cu_domain__webspace_status_powerUser' => "Suspends or activates a whole subscription. Requires the '-status <enabled|disabled>' option.",
    'cu_domain__webspace_on' => 'Activates a whole subscription.',
    'cu_domain__webspace_off' => 'Suspends a whole subscription.',
    'cu_domain__webspace_on_powerUser' => 'Activates a whole subscription.',
    'cu_domain__webspace_off_powerUser' => 'Suspends a whole subscription.',
    'cu_domain__status' => 'Switches the domain on/off (default: %1)',
    'cu_domain__new_name' => 'Specifies a new domain name (may be used only with "%1" command).',
    'cu_site__new_name' => 'Specifies a new site name (may be used only with "%1" command).',
    'cu_subscription__new_name' => 'Specifies a new subscription name (may be used only with "%1" command).',
    'cu_domain__dom_user' => 'switches the domain administrator account on/off (default: %1)',
    'cu_domain__du_passwd' => 'sets up password for domain administator',
    'cu_domain__du_pname' => 'sets up personal name for domain administator',
    'cu_domain__du_email' => 'sets up email address for domain administator',
    'cu_domain__du_language' => 'set interface language for domain administrator (for example, "it" for Italian)',
    'cu_domain__dns' => 'Switches on/off the domain DNS zone (default: DNS template status).',
    'cu_domain__www' => 'Adds www prefix (default: %1).',
    'cu_domain__hosting' => 'Switches on/off web hosting for domain (default: %1).',
    'cu_domain__hst_type' => 'Sets up the specified hosting type (default: %1).',
    'cu_domain__target_url' => 'Sets up target URL (required if %1 is "%2" or "%3").',
    'cu_domain__ip' => 'Sets IP address.',
    'cu_domain__login' => 'Username of system user account associated with the subscription (required if web hosting is configured)',
    'cu_domain__passwd' => 'Password of system user account associated with the subscription (no password is set by default)',
    'cu_domain__shell' => 'System shell access',
    'cu_domain__sb_publish' => 'Creates website using Presence Builder',
    'cu_domain__unable_sb_publish' => 'Unable to create website using Presence Builder: %1',
    'cu_domain__ssi' => 'SSI support (default: %1)',
    'cu_domain__ssi_html' => 'SSI support for *.html, *.htm (default: %1)',
    'cu_domain__php' => 'PHP support (default: %1)',
    'cu_domain__cgi' => 'CGI support (default: %1)',
    'cu_domain__perl' => 'Perl support (default: %1)',
    'cu_domain__asp' => 'ASP support (default: %1)',
    'cu_domain__python' => 'Python support (default: %1)',
    'cu_domain__ssl' => 'SSL/TLS support (default: %1)',
    'cu_domain__ssl_redirect' => 'Redirection to HTTPS (default: %1)',
    'cu_domain__webstat' => 'Statistics support (default: %1)',
    'cu_domain__err_docs' => 'Custom error documents support (default: %1)',
    'cu_domain__log_rotate' => 'Log rotation status (default: %1)',
    'cu_domain__log_bysize' => 'Log rotation by size',
    'cu_domain__log_bytime' => 'Log rotation by time (default: %1)',
    'cu_domain__log_max_num' => 'Maximum number of log file instances (default: %1)',
    'cu_domain__log_compress' => 'Log files compression (default: %1)',
    'cu_domain__log_email' => 'Switches on sending log files to email',
    'cu_domain__clogin' => 'Login of an existing user the subscription will belong to (required for domain creation) [deprecated, use -owner option]',
    'cu_domain__mail_service' => 'Switches on/off the mail service (default: %1)',
    'cu_domain__mail_autodiscover' => 'Switches mail autodiscover on/off (default: %1).',
    'cu_domain__notify' => 'Switches on/off notification of domain creation',
    'cu_domain__aftp' => 'Switches on/off the anonymous FTP service (default: %1) [deprecated, use anonftp.exe]',
    'cu_domain__aftp_inc' => 'Switches on/off the anonymous FTP service allow uploading to incoming directory (default: %1) [deprecated, use anonftp.exe]',
    'cu_domain__aftp_inc_disk_limit' => 'Limit disk space in the incoming directory for anonymous FTP service (-1 for unlimited) [deprecated, use anonftp.exe]',
    'cu_domain__aspnet' => 'ASP.NET support (default: %1)',
    'cu_domain__aspnet_version' => 'ASP.NET version (default: %1)', // to check
    'cu_domain__unable_create' => "Unable to create the domain: %1",
    'cu_domain__options_required_phisical' => 'the following options are required to turn on web hosting: %1',
    'cu_domain__options_required_webspace' => 'no subscription specified. Use the %1 option to specify a subscription.',
    'cu_domain__error_create' => 'An error occurred during domain creation: %1',
    'cu_domain__success_create' => "SUCCESS: Creation of domain '%1' completed.\n",
    'cu_domain__error_update' => 'An error occurred during domain update: %1',
    'cu_domain__error_remove' => 'An error occurred during domain removal: %1',
    'cu_domain__success_remove' => "SUCCESS: Removal of '%1' completed.\n",
    'cu_domain__error_on_off' => 'An error occurred during turning domain on/off: %1',
    'cu_domain__success_status' => "SUCCESS: Changing status of domain '%1' completed.\n",
    'cu_domain__already_exists' => 'Domain with name "%1" already exists',
    'cu_domain__ip_not_defined' => 'IP address is not defined',
    'cu_domain__unable_get_ip' => 'unable to get IP address from database',
    'cu_domain__unable_check_ip' => 'unable to check IP address existing in IP pool: %1',
    'cu_domain__ip_not_in_pool' => 'IP address "%1" is not present in customer IP pool',
    'cu_domain__error_update_hosting' => 'An error occurred during changing of hosting settings: %1',
    'cu_domain__unknown_hosting_type' => 'unknown hosting type',
    'cu_domain__error_du_update' => 'An error occurred while updating domain level user settings: %1',
    'cu_domain__error_log_update' => 'An error occurred while updating log rotation settings: %1',
    'cu_domain__mail_service_not_exist' => "Domain mail service does not exist or cannot be initialized: %1",
    'cu_domain__unable_disable_mail_service' => "Cannot switch off domain mail service: %1",
    'cu_domain__unable_define_client' => "Cannot define customer ID by domain name '%1'",
    'cu_domain__unable_update_dns' => 'Unable to update DNS zone for domain: %1',
    'cu_domain__unable_operate_mail_service' => "Cannot operate domain mail service: %1",
    'cu_domain__unable_generate_report' => "Cannot generate report for domain: %1\n",
    'cu_domain__unable_print_report' => "Cannot print report for domain: %1\n",
    'cu_domain__hosting_not_exist' => 'Unable to update hosting settings: hosting does not exist for this domain (use %1 option).',
    'cu_domain__unable_manage_hosting' => "Cannot manage hosting: %1 You should look on domain's DNS settings (domain seems to be improperly created)",
    'cu_domain__unable_set_ip' => 'Unable to set IP address for hosting: %1',
    'cu_domain__error_hosting_remove' => 'An error occurred during hosting removal: %1',
    'cu_domain__options_required_forwarding' => 'the following options are required for creating forwarding: %1',
    'cu_domain__unable_apply_filter' => 'unable to apply update filter for hosting: %1',
    'cu_domain__unable_update_forwarding' => 'unable to update forwarding: %1',
    'cu_domain__unable_log_on' => 'unable to turn on logrotate because domain does not have physical hosting',
    'cu_domain__options_required_du' => 'the following options are required for domain level user creation: %1',
    'cu_domain__error_du_passwd' => 'An error occurred during domain level user password setting: %1',
    'cu_domain__unable_set_language' => 'unable to set language',
    'cu_domain__unable_get_card' => 'Unable to get Card ID: %1',
    'cu_domain__unable_define_ip_pool' => 'Unable to define customer IP pool',
    'cu_domain__unable_fetch_ip' => 'Unable to fetch IP addresses list from pool: %1',
    'cu_domain__unable_check_element' => 'Unable to check element existing in list: %1',
    'cu_domain__sb_subdomains_create' => 'create Blog and Photo Gallery subdomains (obsolete)',
    'cu_domain__unable_change_hst_type' => 'Domain already has hosting enabled and hosting type differs from specified one. Use option "-hosting false" to remove current hosting first.',
    'cu_domain__change_owner' => 'Changes a subscription owner.',
    'cu_domain__owner' => 'Specifies login of an existing user to whom the subscription should belong (required for domain creation and domain owner change, default: admin).',
    'cu_domain__error_change_owner_update' => "Unable to change the subscription owner: %1.",
    'cu_domain__error_change_owner' => "An error occurred when changing the subscription owner: %1",
    'cu_domain__success_change_owner' => "SUCCESS: Owner of subscription '%1' was changed.\n",
    'cu_domain__client_not_exist' => "Customer '%1' does not exist",
    'cu_domain__domain_not_exist' => "Domain '%1' does not exist",
    'cu_domain__ip_not_exist' => "IP address '%1' does not exist",
    'cu_domain__ip_not_in_client_pool' => "IP address '%1' is not present in the provider\'s IP pool",
    'cu_domain__ip_not_available' => "IP address '%1' is not available",
    'cu_domain__parent_domain_name' => "Set parent domain name(default: null)",
    'cu_domain__has_no_mail_service' => "The domain '%1' has no mail service.",
    'cu_domain__creation_date' => 'Specifies arbitrary creation date',
    'cu_domain__max_connections' => 'Specifies HTTP connections limit',
    'cu_domain__traffic_bandwidth' => 'Specifies maximum network usage',

    'cu_domain__publish_sb_site' => 'Publish site with Presence Builder',
    'cu_domain__unable_sync_hosting_on_addon_site' => 'Unable to sync web hosting settings for a site with hosting plan',
    'cu_domain__unable_set_ip_it_used_by_another_account' => 'Unable to set IP address %1 for hosting: it is already used by another account.',
    'cu_domain__mail_service_node_ip' => 'Specifies a service node which will provide mail services for a subscription. Allowed values: IP address or "local" if the service is provided by the Plesk server.',
    'cu_domain__subdomain_name_is_invalid' => 'The specified subdomain name is invalid. The example of a correct name: "mysubdomain.mydomain.com".',
    'cu_domain__unpaid_website_status_desc' => "Sets the status of websites if the subscription is suspended (default: %1).",
    'cu_domain__unpaid_website_status' => "Status of websites if the subscription is suspended",
    'cu_domain__forwarding_http_code' => 'Specifies the HTTP response status code to be used for standard forwarding.',
    'cu_domain__seo_redirect' => "Turns on the search engine-friendly HTTP 301 redirection. Use 'non-www' to redirect from www.domain to domain, 'www' to redirect from domain to www.domain, and 'none' to turn off the redirection (default: %1).",
    'cu_domain__list' => 'Displays the list of subscriptions.',
    'hst_def__forwarding_http_code' => "HTTP redirection code for forwarding",
    'cu_domain__icp_status' => 'ICP status (true if the domain name is approved).',
    'cu_domain__icp_permit' => 'ICP permit for the domain name.',
    'cu_domain__empty_document_root' => 'Creates a domain with the document root directory empty (skips promo pages creation).',
    'cu_domain_restriction_command_description_add' => 'Adds a domain name to the list of prohibited domain names.',
    'cu_domain_restriction_command_description_add_list' => 'Adds several domain names to the list of prohibited domain names. Used with the "-list" option.',
    'cu_domain_restriction_command_description_remove_list' => 'Removes all domain names from the list of prohibited domain names.',
    'cu_domain_restriction_command_description_rename' => 'Renames a prohibited domain name.',
    'cu_domain_restriction_command_description_remove' => 'Removes a domain name from the list of prohibited domain names.',
    'cu_domain_restriction_command_description_enable_list' => 'Turns on the checking for prohibited domain names.',
    'cu_domain_restriction_command_description_disable_list' => 'Turns off the checking for prohibited domain names.',
    'cu_domain_restriction_command_description_list' => 'Displays the list of prohibited domain names.',
    'cu_domain_restriction_command_description_help' => 'Displays this help page.',
    'cu_domain_restriction_option_description_new_name' => 'Specifies a new name for a domain. Used with the "--rename" command.',
    'cu_domain_restriction_option_description_name' => 'Specifies a domain name.',
    'cu_domain_restriction_option_description_add_list' => 'Specifies a list of domain names. Used with the "--add-list" command.',
    'cu_domain_restriction_command_add_success' => 'The domain was successfully added to the list of prohibited domain names.',
    'cu_domain_restriction_command_rename_success' => 'The domain was successfully renamed.',
    'cu_domain_restriction_command_remove_success' => 'The domain was successfully removed from the list of prohibited domain names.',
    'cu_domain_restriction_command_add_list_success' => 'The domains were successfully added to the list of prohibited domain names.',
    'cu_domain_restriction_command_add_list_success_with_errors' => 'Domains were added to the list of prohibited domain names, but some errors occurred.',
    'cu_domain_restriction_command_remove_list_success' => 'The domains were successfully removed from the list of prohibited domain names.',
    'cu_domain_restriction_command_enable_list_success' => 'The checking for prohibited domain names was successfully enabled.',
    'cu_domain_restriction_command_disable_list_success' => 'The checking for prohibited domain names was successfully disabled.',
    'cu_domain_restriction_command_list_is_disabled' => 'The checking for prohibited domain names is disabled.',
    'cu_domain_restriction_save_error' => 'Unable to apply changes to the domain.',
    'cu_domain_restriction_not_found' => 'The specified domain name was not found.',
    'cu_domain_restriction_domain_already_exists' => 'The specified domain name is already in the list.',
    'cu_domain__merge' => 'Merges a subscription into another subscription specified with the "-webspace-name" option.',
    'cu_domain__success_merge' => "The subscription '%1' was merged with the subscription '%2'.\n",
    'cu_domain__move' => 'Moves a domain to the subscription specified with the "-webspace-name" option.',
    'cu_domain__success_move' => "The domain '%1' was moved to another subscription. Check the domain's configuration.\n",
    'cu_domain__success_move_related_domains' => "The following related domains were also moved:\n%1\n",
    'cu_domain__success_split' => "The domain '%1' was moved to a new subscription. Check the domain's configuration.\n",
    'cu_domain__db_list' => 'Specifies databases to be moved with the domain to the target subscription (goes with the "move" command).',
    'cu_domain__protdir_on_webstat_off' => "Unable to allow access to web statistics through a protected directory: Web statistics is turned off.",
    'cu_domain__description' => 'Specifies a description of the subscription to be displayed in Plesk.',
    'cu_domain__admin_description' => 'Specifies a description of the subscription for the administrator. It is displayed in Plesk only to the administrator.',
    'cu_domain__reseller_description' => 'Specifies a description of the subscription for the reseller. It is displayed in Plesk to the reseller and administrator.',
    'report__domain_description' => 'Description',
    'report__domain_admin_description' => 'Description for the administrator',
    'report__domain_reseller_description' => 'Description for the reseller',
    'report__domain_external_id' => 'External ID',
    'cu_subscription__status_still_off_with_parent' => 'The subscription \'%1\' cannot be activated because it was suspended together with its owner by the Plesk administrator.',

    'cu_cl_pref__update' => 'Customizes a reseller subscription.',
    'cu_cl_pref__info' => 'Retrieves information about a reseller.',
    'cu_cl_pref__skin_list' => 'Displays a list of all skins.',
    'cu_cl_pref__create_domains' => 'Domain creation.',
    'cu_cl_pref__manage_phosting' => 'Hosting parameters management.',
    'cu_cl_pref__change_limits' => 'Allows changing domain limits.',
    'cu_cl_pref__manage_dns' => 'DNS management',
    'cu_cl_pref__manage_log' => 'Log rotation management.',
    'cu_cl_pref__manage_crontab' => 'Allows managing the scheduler.',
    'cu_cl_pref__manage_aftp' => 'Anonymous FTP management.',
    'cu_cl_pref__manage_maillists' => 'Mailing lists management.',
    'cu_cl_pref__manage_sh_access' => 'System access management.',
    'cu_cl_pref__manage_subdomains' => 'Subdomain management.',
    'cu_cl_pref__manage_quota' => 'Hard disk quota management.',
    'cu_cl_pref__make_dumps' => 'Backup and restoration functions management.',
    'cu_cl_pref__manage_virusfilter' => 'Antivirus management.',
    'cu_cl_pref__site_builder' => 'Presence Builder management.',
    'cu_cl_pref__cp_access' => 'Allows access to Plesk (deprecated).',
    'cu_cl_pref__manage_subftp' => 'Additional FTP accounts management.',
    'cu_cl_pref__manage_domain_aliases' => 'Domain aliases management.',
    'cu_cl_pref__manage_performance' => 'Hosting performance management.',
    'cu_cl_pref__manage_iis_app_pool' => 'IIS application pool management.',
    'cu_cl_pref__max_dom' => 'Limits the number of available domains (-1 for "unlimited").',
    'cu_cl_pref__max_iis_app_pool' => 'Limits the number of IIS application pools (-1 for "unlimited")',
    'cu_cl_pref__expiration' => 'Limits the validity period of customer account.',
    'cu_cl_pref__ip_pool' => "Adds or deletes IP addresses in a customer's IP pool.",
    'cu_cl_pref__language' => 'Sets interface language (for example, "it" for Italian) [deprecated].',
    'cu_cl_pref__skin' => 'Sets interface skin (for example, "WinXP Reloaded")',
    'cu_cl_pref__error_update_prefs' => 'An error occurred during updating of customer settings: %1',
    'cu_cl_pref__success_update' => "SUCCESS: Update of '%1' settings completed\n",
    'cu_cl_pref__error_info' => 'An error occurred while retrieving customer information: %1',
    'cu_cl_pref__success_skin_list' => "\nSUCCESS: Gathering skin list completed.\n",
    'cu_cl_pref__illegal_perm_val' => "You have improper '%1' permission value ('%2'): It must be either true or false\n",
    'cu_cl_pref__unable_get_limit' => 'Unable to get summary domains limit: %1',
    'cu_cl_pref__illegal_date_val' => 'The specified date is invalid  ("%1")',
    'cu_cl_pref__illegal_date_greater' => 'This value is greater than the upper limit for the allowed timestamp range. The greatest date you can specify is "%1"',
    'cu_cl_pref__illegal_date_greater_less' => 'Enter a year from "%1" to "%2"',
    'cu_cl_pref__illegal_date_expiration_future' => "An expiration date should be in the future. You cannot specify a date earlier than '%1'",
    'cu_cl_pref__illegal_date_expiration_later' => 'The customer already has a later expiration date ("%1") set for hosted domains.\n',
    'cu_cl_pref__illegal_limit_val' => "You have incorrect '%1' limit value (%2): The customer already has more resources (%3) used for hosted domains.\n",
    'cu_cl_pref__unable_set_language' => 'Unable to set an interface language for a customer: %1',
    'cu_cl_pref__unable_set_perm' => 'Unable to set permissions ID for customer: %1',
    'cu_cl_pref__error_update_perm' => 'An error occurred while updating permissions: %1',
    'cu_cl_pref__unable_set_limit' => 'Unable to set limits ID for a customer: %1',
    'cu_cl_pref__error_update_limit' => 'An error occurred while updating resource limits: %1',
    'cu_cl_pref__error_update_ip_pool' => "An error occurred while updating IP pool:\n%1\n",
    'cu_cl_pref__error_unknown_params_type' =>  '%1 error: Unknown parameter type (%2).',
    'cu_cl_pref__unable_get_params_type' => 'Unable to get "%1" ID',
    'cu_cl_pref__empty_ip_list' => 'IP addresses list is empty.',
    'cu_cl_pref__ip_not_exist' => 'The specified IP addresses were not found.',
    'cu_cl_pref__unable_fetch_pool' => "Unable to retrieve customer IP pool ID from the database.",
    'cu_cl_pref__error_add_ip' => 'An error occurred while adding IP addresses to IP pool: %1',
    'cu_cl_pref__error_remove_ip' => 'An error occurred while deleting IP addresses from the IP pool: %1',
    'cu_cl_pref__unable_put_ip_pool' => 'Unable to put customer IP pool ID: %1',
    'cu_cl_pref__unable_set_ip_pool' => 'Unable to set IP pool ID for a customer: %1',
    'cu_cl_pref__manage_site_builder' => 'Allows managing Presence Builder.',
    'cu__max_mysql_db' => 'Limits the number of MySQL databases (Specify -1 for "unlimited").',
    'cu_cl_pref_multiple_sessions' => 'Allows multiple sessions.',
    'cu_cl_pref_max_button_length' => 'Sets button label length.',
    'cu_cl_pref_lock_screen' => 'Prevents users from working with Plesk until interface screens are completely loaded.',
    'cu_cl_pref_desktop_preset' => 'Sets Home Page preset.',
    'cu_cl_pref__locale' => 'Set an interface language (for example, "it-IT" for Italian)',
    'cu_cl_pref__illegal_overuse_val' => "Incorrect overuse policy value was specified. Valid values are: block, normal, or notify\n",
    'cu_cl_pref__access_appcatalog' => 'Provides access to the Application Catalog. ',
    'cu_cl_pref__allow_insecure_sites' => "Allows setting up of potentially insecure web scripting options that override provider's policy.",
    'cu_cl_pref_power_user' => 'Switches to Power User mode.',
    'cu_cl_pref__remote_db_connection' => 'Allows or prohibits setting up custom remote access settings for database users.',

    'cu__manage_ftp_password' => "Allows FTP password management.",

    'cu_dom_pref__update' => 'Customizes subscription: changes services, privileges, and resources, updates expiration date.',
    'cu_dom_pref__info' => 'Retrieves subscription info.',
    'cu_dom_pref__assign_database' => 'Assigns database to domain.',
    'cu_dom_pref__show_assigned_database' => 'Show database ID assigned to domain.',
    'cu_dom_pref__database' => 'Database ID (to be used with the "assign-database" command).',
    'cu_dom_pref__success_assign_database' => 'Database was assigned to domain.',
    'cu_dom_pref__success_unassign_database' => 'Database was unassigned from domain.',
    'cu_dom_pref__err_database_not_found' => 'Database with ID %1 is not found.',
    'cu_dom_pref__err_database_not_belong' => 'Database does not belong to subscription %1.',
    'cu_dom_pref__expiration' => 'Sets the subscription expiration date (-1 is for no expiration).',
    'cu_dom_pref__www' => 'WWW prefix for the websites.',
    'cu_dom_pref__wuscripts' => 'Switches on/off scripting support for web users.',
    'cu_dom_pref__webmail' => 'Allows the use of webmail.',
    'cu_dom_pref__webmail_certificate' => 'Secures webmail with an SSL/TLS certificate.',
    'cu_dom_pref__mail_certificate' => 'Secures mail with an SSL/TLS certificate.',
    'cu_dom_pref__mail_certificate_server_certificate_required' => "The certificate was assigned, but mail for the domain was not secured. To finish securing mail for the domain, secure the mail server by running the following command: \"plesk bin mail_server --set-certificate <certificate name>\"",
    'cu_dom_pref__no_usr' => 'Sets up bounce or catch-all for nonexisting user mail (obsolete).',
    'cu_dom_pref__keep_traf_stat' => 'Sets the system to retain traffic statistics for N months (specify 0 if you do not wish to delete statistics).',
    'cu_dom_pref__invalid_date_format' => "Cannot recognize date format: '%1'\n",
    'cu_dom_pref__invalid_year' => "Invalid year: '%1'\n",
    'cu_dom_pref__unable_set_time_less' => "Cannot set time less than current: '%1'\n",
    'cu_dom_pref__invalid_disk_space_val' => "Invalid disk space value: '%1'\n",
    'cu_dom_pref__unable_set_limit_val' => "Cannot set limit '%1' value to '%2': %3\n",
    'cu_dom_pref__unable_limit' => "Unable to update domain limits: %1\n",
    'cu_dom_pref__unable_set_wuscripts' => "Cannot set wuscripts prefix: %1\n",
    'cu_dom_pref__unable_manage_webmail' => "Cannot manage webmail settings: domain has subdomain 'webmail'\n",
    'cu_dom_pref__unable_set_webmail' => "Cannot set webmail: %1\n",
    'cu_dom_pref__unable_set_no_usr' => "Cannot set non-existing mail user handling: %1\n",
    'cu_dom_pref__unable_set_keep_traf_stat' => "Cannot set traffic logging period: %1\n",
    'cu_dom_pref__invalid_expiration_date' => 'Invalid expiration date: %1',
    'cu_domain_pref__success_set_default' => 'Domain was set as default for IP address',
    'cu_domain_pref__error_set_default' => "Cannot set domain as default for IP address: '%1'\n",
    'cu_domain_pref__site_preview' => 'Website preview URL',

    // P9
    'cu_dom_pref__set_default' => 'Sets domain as default for IP address',
    'cu_dom_pref__overuse' => 'Allows or prohibits overuse for a website',

    'cu_db__create' => 'Creates a database.',
    'cu_db__update' => 'Updates a database: Adds, edits, or removes a database user.',
    'cu_db__remove' => 'Deletes a database.',
    'cu_db__domain' => 'Sets a domain name (required for database creation).',
    'cu_db__type' => 'Sets the type of database.',
    'cu_db__passwd' => 'Sets a user password.',
    'cu_db__add_user' => 'Adds a user with the specified name.',
    'cu_db__update_user' => 'Updates a user with the specified name.',
    'cu_db__remove_user' => 'Removes a user with the specified name.',
    'cu_db__user_name' => 'Sets a username (can be specified with "%1" option).',
    'cu_db__success_create' => "SUCCESS: Creation of database '%1' completed.\n",
    'cu_db__success_remove' => "SUCCESS: Remove of database '%1' completed.\n",
    'cu_db__success' => "SUCCESS: %1 in database '%2' completed.\n",
    'cu_db__user_not_exist' => 'Database user with the name "%1" does not exist.',
    'cu_db__error_remove_user' => 'An error occurred during database user removal: %1',
    'cu_db__unable_update_user_preferences' => 'An error occurred while updating database user settings: %1',
    'cu_db__unable_add_user' => 'Unable to add database user: %1',
    'cu_db__unable_disable_user' => 'Unable to prohibit access for user to database: %1',
    'cu_db__db_not_exist' => 'Database with name "%1" does not exist',
    'cu_db__unable_remove_linked' => 'Unable to remove linked resource.',
    'cu_db__error_remove_db' => 'An error occurred during database removal: %1',
    'cu_db__unable_create_db' => 'Unable to create database: %1',
    'cu_db__error_pgsql' => 'PostgreSQL is not installed or configured.',
    'cu_db__error_type' => 'type is not supported',
    'cu_db__not_installed' => 'The following required Plesk components are not installed: %1',
    'cu_db__upload' => 'Upload database dump.',
    'cu_db__dump_file' => 'Sets the path to the file with database dump.',
    'cu_db__recreate_on_upload' => 'Recreate database on dump upload.',
    'cu_db__success_upload' => 'SUCCESS: Uploading of dump \'%1\' to database \'%2\' is completed.',
    'cu_db__error_upload' => 'Unable to upload database dump: %1',

    'cu_pdir__create' => 'Create protected URL',
    'cu_pdir__update' => 'Update protected URL: change URL, manage users',
    'cu_pdir__remove' => 'Delete protected URL',
    'cu_pdir__subdomain' => 'Subdomain name without the domain part',
    'cu_pdir__title' => 'Protected URL\'s realm access text',
    'cu_pdir__type' => 'Access Types',
    'cu_pdir__passwd' => 'Set user password',
    'cu_pdir__passwd_type' => 'Type of password (default: %1)',
    'cu_pdir__add_user' => 'Add user with given name',
    'cu_pdir__update_user' => 'Update user with given name',
    'cu_pdir__remove_user' => 'Remove user with given name',
    'cu_pdir__user_name' => 'Set username (may be specified with "%1" option)',
    'cu_pdir__dir_name' => 'Set protected URL (may be specified with "%1" option)',
    'cu_pdir__success_create' => "SUCCESS: Creation of protected URL '%1' completed.\n",
    'cu_pdir__success_update' => "SUCCESS: Update of protected URL '%1' completed.\n",
    'cu_pdir__success_remove' => "SUCCESS: Remove of protected URL '%1' completed.\n",
    'cu_pdir__unable_remove_user' => 'Unable to remove protected URL user: %1',
    'cu_pdir__user_not_found' => "Cannot find protected URL user with the name %1",
    'cu_pdir__unable_update_user' => 'Unable to update protected URL user settings %1',
    'cu_pdir__unable_set_passwd' => 'Invalid password',
    'cu_pdir__unable_add_user' => 'Unable to add protected URL user %1',
    'cu_pdir__unable_remove_dir' => 'Unable to remove protected URL: ',
    'cu_pdir__dir_not_found' => "Cannot find protected URL with given name %1.",
    'cu_pdir__unable_update_dir' => 'Unable to update protected URL settings: ',
    'cu_pdir__unable_create_dir' => 'Unable to create protected URL: ',

    'cu_ip__create' => 'Creates the specified IP address.',
    'cu_ip__update' => 'Updates the specified IP address.',
    'cu_ip__remove' => 'Deletes the specified IP address.',
    'cu_ip__list' => 'Displays the list of IP addresses.',
    'cu_ip__ssl_list' => 'Displays the list of available SSL/TLS certificates.',
    'cu_ip__inter_list' => 'Displays the list of available interfaces.',
    'cu_ip__type' => 'IP address type (required for creation).',
    'cu_ip__cert_name' => 'SSL/TLS certificate name.',
    'cu_ip__mask' => 'Subnet mask.',
    'cu_ip__inter_name' => 'Interface name.',
    'cu_ip__success_create' => "SUCCESS: Creation of IP '%1' completed.\n",
    'cu_ip__success_update' => "SUCCESS: Update '%1' completed.\n",
    'cu_ip__success_remove' => "SUCCESS: Removal of IP '%1' completed.\n",
    'cu_ip__unable_update' => 'Unable to update IP address: %1',
    'cu_ip__cert_not_exist' => 'Certificate does not exist.',
    'cu_ip__unable_remove_ip_from_pool' => 'Unable to remove the IP address from the customer\'s IP pool: %1',
    'cu_ip__unable_remove_pool' => 'Unable to remove the customer\'s IP pool: %1',
    'cu_ip__mul_aftp' => 'Multiple Anonymous FTP on IP detected',
    'cu_ip__unable_set_alias' => 'Unable to set IP alias values: %1',
    'cu_ip__unable_update_ip' => 'Unable to update IP address values: %1',
    'cu_ip__unable_remove_ip' => 'Unable to remove IP address: %1',
    'cu_ip__ip_not_exist' => 'The IP address does not exist',
    'cu_ip__unable_create' => 'Unable to create the IP address: %1',
    'cu_ip__inter_not_exist' => 'The interface does not exist',
    'cu_ip__unable_get_ip_list' => 'Unable to retrieve the list of IP addresses: %1',
    'cu_ip__unable_add_ip' => 'Unable to add the IP address to web server configuration: %1',
    'cu_ip__unable_set_action' => 'Unable to set the DNS action: %1',
    'cu_ip__unable_get_inter_list' => 'Unable to retrieve the list of interfaces: %1',
    'cu_ip__unable_get_cert_list' => 'Unable to retrieve the list of certificates: %1',
    'cu_ip__reset_ssl_certificate' => 'Sets the default SSL/TLS certificate for all IP addresses.',
    'cu_ip__success_reset_ssl_certificate' => 'The default SSL/TLS certificate for all IP addresses was set',
    'cu_ip__xml_info' => 'Displays the list of IP addresses in XML format.',
    'cu_ip__public_ip_name' => 'Public IP address.',
    'cu_ip__change_ip' => 'Reassigns the IP address.',
    'cu_ip__success_change_ip' => "IP address '%1' was reassigned.",
    'cu_ip__error_change_ip' => "Cannot reassign IP address '%1': %2",
    'cu_ip__ip_name' => 'IP address.',
    'cu_ip__error_change_ip_same_ips' => 'IP addresses are the same.',
    'cu_ip__error_change_ip_ip_exists' => 'The IP address %1 already exists.',
    'cu_ip__error_change_ip_ip_not_found' => 'The IP address %1 was not found.',
    'cu_ip__reread' => 'Rereads the IP addresses.',
    'cu_ip__success_reread' => 'IP addresses were reread from the system.',
    'cu_ip__ftps' => 'allow FTP over SSL/TLS.',
    'cu_ip__auto_remap' => 'Defines whether to perform the automatic mapping of IP addresses on Plesk startup. Use the option in cases when the registered IP addresses are changed (for example, when cloning a VPS with Plesk).',
    'cu_ip__repair' => 'Repairs IP address: synchronize with system.',
    'cu_ip__repair_blacklist' => 'This IP address is blacklisted.',
    'cu_ip__repair_operational' => 'This IP address is already operational.',
    'cu_ip__repair_success' => 'The IP address %1 was synchronized with the system.',

    'cu_mail__create' => 'Creates an email account.',
    'cu_mail__update' => 'Updates the email account parameters.',
    'cu_mail__remove' => 'Removes the email account.',
    'cu_mail__info' => 'Retrieves the email account information.',
    'cu_mail__on' => 'Switches on the mail service for a subscription.',
    'cu_mail__off' => 'Switches off the mail service for a subscription.',
    'cu_mail__cp_access' => 'Switches access to Plesk on or off (default: %1).',
    'cu_mail__mailbox' => 'Creates or removes a mailbox.',
    'cu_mail__delivery' => 'Enables or disables messages delivery to mailbox.',
    'cu_mail__passwd' => 'Sets a mailbox password.',
    'cu_mail__boxpass' => 'An obsolete alias for the option "%1" (this option might be removed from future releases).',
    'cu_mail__mbox_quota' => 'Limits the mailbox size.',
    'cu_mail__boxquota' => 'An obsolete alias for the option "%1" (this option might be removed from future releases).',
    'cu_mail__aliases' => 'Adds or deletes an aliases for a mail account.',
    'cu_mail__mgroups' => 'Adds a mail account to or removes it from a mail group.',
    'cu_mail__redirect' => 'Switches the mail forwarding on or off.',
    'cu_mail__rediraddr' => 'Sets the email address to which to forward mail. Required when mail forwarding is switched on.',
    'cu_mail__group' => 'Switches a mail group on or off.',
    'cu_mail__groupmem' => 'Adds and removes addresses in a mail group.',
    'cu_mail__repo' => 'Adds and removes files in the repository of auto-reply attachments.',
    'cu_mail__autorsp' => 'Switches auto-replying on all addresses on or off.',
    'cu_mail__autoname' => 'Sets the auto-reply name (required for all auto-reply options).',
    'cu_mail__autostatus' => 'Switches on or off the auto-reply with the specified name (default: %1).',
    'cu_mail__autoreq' => 'Defines the condition for the auto-reply to be activated whether the specified pattern is encountered in the subject or body, or to respond always.',
    'cu_mail__autosubj' => 'Sets the auto-reply message subject ("Re: <incoming subject>") or defines a custom string.',
    'cu_mail__auto_replyto' => "Sets an email address to which auto-reply messages will be forwarded.",
    'cu_mail__autotext' => 'Sets the text (in plain text) of an auto-reply message.',
    'cu_mail__autoatch' => 'Adds or removes files attached to an auto-reply message.',
    'cu_mail__autofrq' => 'Defines the maximum number of responses to a unique email address per day.',
    'cu_mail__autostor' => 'Defines the number of unique addresses to be stored for auto-reply.',
    'cu_mail__autored' => 'Defines the email address to which to forward all incoming mail.',
    'cu_mail__antivirus' => 'Manages antivirus checking for mail traffic: Switches it off, sets it for both incoming and outgoing mail, for incoming mail only, or for outgoing mail only.',
    'cu_mail__antivirus_incoming' => 'Manages antivirus checking for incoming mail traffic. You can switch it on and off for the whole server and for individual mailboxes.',
    'cu_mail__antivirus_outgoing' => 'Manages antivirus checking for outgoing mail traffic. You can switch it on and off for the whole server and for individual mailboxes.',
    'cu_mail__error_create' => 'An error occurred during mail account creation: %1',
    'cu_mail__success_create' => "SUCCESS: Creation of mail account '%1' completed\n",
    'cu_mail__error_update' => 'An error occurred while updating mail account: %1',
    'cu_mail__success_update' => "SUCCESS: Update of mail account '%1' completed\n",
    'cu_mail__success_rename' => "Mail account '%1' was renamed successfully",
    'cu_mail__error_rename' => 'An error occurred during mail account renaming: %1',
    'cu_mail__error_remove' => 'An error occurred during mail account removal: %1',
    'cu_mail__success_remove' => "SUCCESS: Removal of '%1' completed\n",
    'cu_mail__error_info' => 'An error occurred while retrieving mail account information: %1',
    'cu_mail__success_info' => "SUCCESS: Gathering information for '%1' completed\n",
    'cu_mail__error_on_off' => 'An error occurred while turning mail service for domain on or off: %1',
    'cu_mail__success_on_off' => "SUCCESS: Turning mail service for domain '%1' on/off completed.\n",
    'cu_mail__unable_create_mailname' => "Cannot create mail account:\n%1",
    'cu_mail__mailname_already_exist' => 'Mail account "%1" already exists',
    'cu_mail__key_limit_create' => "Your key limits do not allow mail account creation",
    'cu_mail__unable_create_autoresp' => "Cannot create auto-reply for this mail account",
    'cu_mail__unable_update_mailname' => "Cannot update mail account:\n%1",
    'cu_mail__mailname_not_exist' => "Mail account '%1' does not exist\n",
    'cu_mail__alias_not_exist' => 'Alias "%1" does not exist',
    'cu_mail__unable_remove_alias' => "Cannot remove mail alias '%1': %2",
    'cu_mail__unable_get_mailname_acc_id' => "Cannot fetch mail account's '%1' ID",
    'cu_mail__unable_set_cp_access' => "Cannot set access to Plesk: %1",
    'cu_mail__unable_get_cp_state' => "Cannot fetch Plesk state\n",
    'cu_mail__unable_set_postbox' => "Cannot set postbox: %1",
    'cu_mail__unable_get_mailbox_status' => "Cannot get current mailbox status",
    'cu_mail__unable_add_alias' => "Cannot add mail alias '%1': %2",
    'cu_mail__mg_not_exist' => "Mailgroup '%1' does not exist",
    'cu_mail__unable_get_mg_state' => "Cannot fetch current mailgroup state",
    'cu_mail__unable_add_to_mg' => "Cannot add email '%1' to mailgroup: %2",
    'cu_mail__unable_remove_from_mg' => "Cannot delete mail account '%1' from mailgroup: %2",
    'cu_mail__unknown_cmd_mg_opt' => 'unknown operation in %1 option',
    'cu_mail__unable_on_off_mg' => "Cannot switch on/off mailgroups for '%1': %2",
    'cu_mail__unable_add_file' => "Cannot add file '%1' to attachments repository: Cannot read the file.",
    'cu_mail__unable_place_file' => "Cannot place file '%1' in repository: %2",
    'cu_mail__unable_remove_file' => "Cannot delete file '%1' from repository: %2",
    'cu_mail__unable_change_autoresp_status' => "Cannot change auto-replies status: %1",
    'cu_mail__autoresp_not_spec' => 'Auto-reply name should be specified',
    'cu_mail__unable_recogn_filter' => "Cannot recognize request filter '%1'",
    'cu_mail__unable_modify_autoresp' => "Cannot modify auto-reply: %1",
    'cu_mail__unable_modify_autoresp_subj' => "Cannot modify auto-reply subject: %1",
    'cu_mail__unable_set_autoresp_reply' => "Cannot set reply to address for auto-reply: %1",
    'cu_mail__unable_set_autoresp_text' => "Cannot set auto-reply text: %1",
    'cu_mail__no_files_in_rep' => "\nThere are currently no files in repository\n",
    'cu_mail__files_in_rep' => "\nFiles currently placed in repository:\n",
    'cu_mail__unable_add_file_to_autoresp' => "Cannot add file '%1' to auto-reply attachments: %2",
    'cu_mail__file_not_in_rep' => 'File is not in attachments repository %1',
    'cu_mail__file_already_in_rep' => 'file already there',
    'cu_mail__unable_remove_file_from_autoresp' => "Cannot remove file '%1' from auto-reply attachments: %2",
    'cu_mail__file_not_attached' => 'file is not attached currently',
    'cu_mail__unable_set_frq' => "Cannot set responder frequency: %1",
    'cu_mail__unable_set_resp_addr_limit' => "Cannot set responder address limit: %1",
    'cu_mail__unable_set_resp_redir' => "Unable to set up forwarding address for the auto-reply: %1",
    'cu_mail__unable_handle_drweb' => 'Cannot handle Odin Premium Antivirus settings: %1',
    'cu_mail__unable_define_mail_service' => 'unable to define mail domain service ID',
    'cu_mail__update_service' => 'Update mail service for domain',
    'cu_mail__create_service' => 'Create mail service for the domain',
    'cu_mail__remove_service' => 'Remove mail service from the domain',
    'cu_mail__rename' => 'Rename mail account',
    'cu_mail__manage_virusfilter' => 'Allows or prohibits managing antivirus',
    'cu_mail__manage_spamfilter' => 'Allows or prohibits managing spam filter',
    'cu_mail__multiple_sessions' => 'Allows/prohibits concurrent Plesk sessions for a mail account owner',
    'cu_mail__locale' => 'Sets interface language (for example, "it-IT" for Italian)',
    'cu_mail__max_button_length' => 'Sets button label length',
    'cu_mail__skin' => 'Sets Plesk interface skin (for example, "WinXP Reloaded")',
    'cu_mail__lock_screen' => 'Prevents users from working with Plesk until interface screens are completely loaded',
    'cu_mail__status' => 'Enables or disables domain mail service status',
    'cu_mail__new' => 'Creates an email',
    'cu_mail__success_update_service' => 'Updated mail service status.',
    'cu_mail__success_create_service' => 'Created mail service.',
    'cu_mail__success_remove_service' => 'Removed mail service.',
    'cu_mail__error_update_service' => 'Could not update mail service status.',
    'cu_mail__error_create_service' => 'Could not create mail service status.',
    'cu_mail__error_remove_service' => 'Could not remove mail service status.',
    'cu_mail__wrong_skin' => 'Specified skin does not exist',
    'cu_mail__invalid_autoresponder_subject' => 'Invalid auto-reply subject.',
    'cu_mail__invalid_autoresponder_replyto' => 'Invalid auto-reply message subject.',
    'cu_mail__invalid_autoresponder_text' => 'Invalid auto-reply message text.',
    'cu_mail__invalid_autoresponder_mem_limit' => 'Invalid value of number of unique addresses to be stored for auto-reply.',
    'cu_mail__autoresponder_invalid_forward_address' => 'Invalid forwarding address.',
    'cu_mail__unable_restore_user_link' => 'Unable to restore a link with the Plesk user. The specified user does not exist.',
    'cu_mail__login_as_user' => "If 'true', allows logging in to the Customer Panel with the specified email address as a username. If 'false', prohibits the corresponding user from logging in to the Customer Panel.",
    'cu_mail_service_not_supported' => 'Mail service is not installed in Plesk.',
    'cu_mail_email_address_invalid' => 'The specified email address is invalid. Please specify a valid address like user@example.com',
    'cu_mail_external_email_invalid' => 'The specified external email address is invalid. Please specify a valid address like user@example.com',
    'cu_mail_external_email_same' => 'The specified external email address matches the primary one. Please specify a different external email address',
    'cu_mail_domain_name_invalid' => 'The specified domain name is invalid. A domain name can contain only alphanumeric characters and a hyphen (-).',
    'cu_mail__description' => 'Specifies a description of an email address to be displayed in Plesk.',
    'cu_mail__external_email' => 'External email address that will be used to restore access to this account',
    'cu_mail_restore__operation_not_supported_by_node' => 'This operation is not supported by the service node.',
    'cu_mail_restore__option_fast' => 'Skips resource-consuming operations.',
    'cu_mail_restore__option_handlers_only' => 'Restores only mail handlers (if any).',
    'cu_mail_restore__option_no_restart_service' => 'Prohibits restarting or reloading of service (if applicable).',
    'cu_mail_email_address_long_mail_server' => "The username part of the email address is too long for this mail server. Please specify a username no longer than %1 symbols.",
    'cu_mail_email_full_address_long_mail_server' => "The email address is too long for this mail server. Please specify an address no longer than %1 symbols.",
    'cu_mail__list' => 'Retrieves the email accounts list.',
    'cu_mail__list_mailname' => 'Mail name',
    'cu_mail__list_alias' => 'Alias',
    'cu_mail__json' => 'Displays the output in the JSON format. Used with the --list command.',

    'cu_mlist__create' => 'Create mailing list',
    'cu_mlist__update' => 'Update mailing list properties',
    'cu_mlist__remove' => 'Delete mailing list',
    'cu_mlist__info' => 'Print mailing list members',
    'cu_mlist__passwd' => "Set mailing list administrator's password (may be specified only with a '%1' command)",
    'cu_mlist__email' => "Set mailing lists administrator's email (may be specified only with a '%1' command)",
    'cu_mlist__notify' => 'Notify mailing list administrator about mailing list creation (default: %1, may be specified only with a "%2" command)',
    'cu_mlist__status' => 'Turns mailing list on/off (default: %1)',
    'cu_mlist__members' => 'Mailing list members:',
    'cu_mlist__success' => "SUCCESS: operation with mailing list '%1' completed.\n",
    'cu_mlist__plesk_not_configured' => 'Plesk is not configured. You should go to the Plesk for postinstall server configuration.',
    'cu_mlist__not_configured' => 'Mailing list support is not installed or properly configured.',
    'cu_mlist__unable_create' => 'Cannot create a mailing list: %1',
    'cu_mlist__not_exist' => 'Mailing list "%1" does not exist',
    'cu_mlist__unable_update' => 'Cannot update mailing list: %1"',
    'cu_mlist__unable_remove' => 'Cannot remove mailing list "%1": %2',
    'cu_mlist__no_members' => "There are no mailing list members\n",
    'cu_mlist__unable_add_email' => 'Unable to add email address "%1" to mailing list: %2',
    'cu_mlist__unable_remove_email' => 'Cannot delete email "%1" from mailing list: %2',
    'cu_mlist__unknown_mem_cmd' => 'Unknown command in members processing: %1',
    'cu_mlist__unable_change_status' => "Cannot change mailing list status: %1",
    'cu_mlist__unable_create_incorrect_param' => 'Cannot create a mailing list, incorrect parameter: %1',
    'cu_mlist__unable_create_incorrect_maillist_name' => 'Cannot create a mailing list, incorrect mailing list name',

    'cu_subdomain__create' => 'creates a subdomain for domain specified with %1 option',
    'cu_subdomain__update' => 'updates an existing subdomain for domain specified with %1 option',
    'cu_subdomain__remove' => 'removes subdomains specified with %1 option for domain specified with %2 option',
    'cu_subdomain__info' => 'retrieves information on subdomains',
    'cu_subdomain__domain' => 'use to specify the main (parent) domain for creating the subdomain for',
    'cu_subdomain__new_name' => 'change the subdomain\'s name to the specified one (the option cannot be used when creating new subdomains)',
    'cu_subdomain__ftp_user' => 'Use a separate FTP user account for this subdomain (native) or the same FTP user as that of the main domain (main). By default the FTP account of the main (parent) domain is used for managing the subdomain',
    'cu_subdomain__login' => 'FTP account username (can be specified if separate FTP account is used)',
    'cu_subdomain__passwd' => 'FTP password (no password is set by default, and it may be specified when separate FTP account is used)',
    'cu_subdomain__hard_quota' => 'hard disk quota (use 0 for "unlimited", which is set by default. You can specify this option when using a separate FTP account)',
    'cu_subdomain__ssi' => 'SSI support on subdomain (default: %1)',
    'cu_subdomain__ssi_html' => 'SSI support *.html, *.htm on subdomain (default: %1)',
    'cu_subdomain__php' => 'PHP support on subdomain (default: %1)',
    'cu_subdomain__cgi' => 'CGI support on subdomain (default: %1)',
    'cu_subdomain__perl' => 'Perl support on subdomain (default: %1)',
    'cu_subdomain__asp' => 'ASP support on subdomain (default: %1)',
    'cu_subdomain__python' => 'Python support on subdomain (default: %1)',
    'cu_subdomain__subdomains' => 'Used for specifying the subdomains to be removed or for retrieving subdomain information (-remove and -info commands respectively). By default, the -info command outputs information on all existing subdomains',
    'cu_subdomain__aspnet' => 'ASP.NET support on subdomain (default: %1)',
    'cu_subdomain__aspnet_version' => 'selects ASP.NET version on subdomain (default: %1)', // to check
    'cu_subdomain__error_create' => "An error occurred during subdomain creation: %1\n",
    'cu_subdomain__success_create' => "SUCCESS: Creation of subdomain '%1' completed.\n",
    'cu_subdomain__error_update' => "An error occurred while updating subdomain configuration: %1\n",
    'cu_subdomain__success_update' => "SUCCESS: Update of subdomain '%1' completed.\n",
    'cu_subdomain__error_remove' => "An error occurred during subdomain removal: %1\n",
    'cu_subdomain__success_remove' => "SUCCESS: Removal of '%1' completed.\n",
    'cu_subdomain__error_info' => "An error occurred while retrieving subdomain information: %1\n",
    'cu_subdomain__success_info' => "SUCCESS: Completed gathering information for subdomains.\n",
    'cu_subdomain__unable_spec' => "You cannot specify username or password or set up hard disk quota when using the '%1' option\n",
    'cu_subdomain__req_login' => "You should specify a username to create a separate FTP user account for the subdomain\n",
    'cu_subdomain__already_exists' => 'Subdomain with name "%1" already exists',
    'cu_subdomain__no_hosting' => "Subdomains are not supported on domains without hosting\n",
    'cu_subdomain__not_exist' => "Subdomain with name '%1' does not exist\n",
    'cu_subdomain__unable_recognize_remove' => "Unable to find the subdomains selected for removing\n",
    'cu_subdomain__unable_recognize_info' => "Unable to find the selected subdomains\n",
    'cu_subdomain__unable_fetch_from_submit' => 'Unable to fetch from submit of %1: %2',
    'cu_subdomain__invalid_password' => 'wrong password syntax',
    'cu_subdomain__webstat' => 'Web statistic support on subdomain (default: none)',

    'cu_webuser__create' => 'Create web user',
    'cu_webuser__update' => 'Update web user',
    'cu_webuser__remove' => 'Delete web user',
    'cu_webuser__info' => 'Web user info',
    'cu_webuser__passwd' => 'Set web user password',
    'cu_webuser__domain' => 'Domain name',
    'cu_webuser__php' => 'switches on PHP for web user (default: %1)',
    'cu_webuser__ssi' => 'switches on SSI for web user (default: %1)',
    'cu_webuser__cgi' => 'switches on CGI for web user (default: %1)',
    'cu_webuser__perl' => 'switches on Perl for web user (default: %1)',
    'cu_webuser__python' => 'switches on Python for the web user (default: %1)',
    'cu_webuser__asp' => 'switches on ASP for the web user (default: %1)',
    'cu_webuser__aspnet' => 'switches on ASP.NET for the web user (default: %1)',
    'cu_webuser__unable_create' => "Unable to create a web user:\n%1",
    'cu_webuser__success_create' => "The web user '%1' was successfully created.\n",
    'cu_webuser__success_update' => "The web user '%1' was successfully updated.\n",
    'cu_webuser__success_remove' => "The web user '%1' was removed.\n",
    'cu_webuser__not_exist' => "The web user with the name '%1' does not exist\n",
    'cu_webuser__unable_remove' => "Unable to remove a web user:\n%1",
    'cu_webuser__unable_update' => "Unable to update a web user:\n%1",
    'cu_webuser__unable_set_login' => "Unable to set a username for the web user:\n%1",
    'cu_webuser__unable_set_domain' => "Unable to set a domain for the web user:\n%1",
    'cu_webuser__unable_add' => "Unable to add a web user:\n%1",
    'cu_webuser__unable_set_quota' => "Unable to set a quota for the web user:\n%1",
    'cu_webuser__unable_set_option' => "Unable to set %1 option for the web user:\n%2",
    'cu_webuser__scripting_disabled_on_domain' => 'Unable to set the scripting support for the web user: The scripting %1 is turned off in the domain\'s hosting settings',

    'cu_initconf__init' => 'initialize Plesk (can be specified only for non-configured Plesk)',
    'cu_initconf__update' => "update administrator's contact information",
    'cu_initconf__ips' => 'mark IP addresses as shared IPs (can be specified only with the init command)',
    'cu_initconf__hostname' => 'sets the hostname (can be specified only with the init command)',
    'cu_initconf__company' => "administrator's company name",
    'cu_initconf__name' => "administrator's contact name (required for creation)",
    'cu_initconf__passwd' => "Plesk administrator's password (required for creation) [see the note below for details]",
    'cu_initconf__phone' => "administrator's phone number",
    'cu_initconf__fax' => "administrator's fax number",
    'cu_initconf__email' => "administrator's email address",
    'cu_initconf__addr' => "administrator's address",
    'cu_initconf__city' => "administrator's city",
    'cu_initconf__state' => "administrator's state/province",
    'cu_initconf__pcode' => "administrator's postal/ZIP code [deprecated]",
    'cu_initconf__country' => "administrator's country code (two alphabetic characters)",
    'cu_initconf__def_client' => 'create default customer',
    'cu_initconf__check_configured' => 'Checks whether Plesk is already configured. Returns 0 if true, 1 otherwise',
    'cu_initconf__zip' => "Administrator's postal/zip code",
    'cu_initconf__addr_deprecated' => "Administrator's address [deprecated]",

    'cu_initconf__already_configured' => 'This utility is for initial Plesk configuration. Your installation is already configured. You should log in to Plesk to complete configuration.',
    'cu_initconf__unable_init' => "Cannot initialize Plesk: %1",
    'cu_initconf__success_init' => "SUCCESS: Plesk initialization is completed.\n",
    'cu_initconf__unable_update' => "Cannot update administrator's contact information: %1",
    'cu_initconf__success_update' => "SUCCESS: Completed updating administrator's information.\n",
    'cu_initconf__unable_remove_ips' => 'You cannot delete shared IPs during Plesk initialization',
    'cu_initconf__unable_recognize_ips' => 'Cannot recognize shared IPs you have specified',
    'cu_initconf__unable_check_components' => 'Unable to check components: %1',
    'cu_initconf__unable_exec' => 'Unable to execute "%1" on object "%2"',
    'cu_initconf__unable_update_perm' => 'Unable to update permissions: %1',
    'cu_initconf__unable_create_def_client' => 'Unable to create default customer: %1',
    'cu_initconf__unable_get_ips' => 'Unable to getFreeCustomerIP: %1',
    'cu_initconf__invalid_passwd' => 'Password is incorrect',
    'cu_initconf__unable_get_passwd' => 'Unable to get current admin password: %1 failed: %2',
    'cu_initconf__unable_change_passwd' => "Unable to change administrator's password: %1",
    'cu_initconf__invalid_email' => 'Wrong email specified',
    'cu_initconf__unable_determ_hostname' => "Unable to determine hostname",
    'cu_initconf__unable_fetch_ip_list' => 'Unable to fetch IP addresses list: ifmng failed: %1',
    'cu_initconf__unable_set_ip_alias_type' => 'Unable to set IP alias type: %1',
    'cu_initconf__unable_ip' => 'Unable to update IP address: %1',
    'cu_initconf__unable_' => 'Unable to restart DNS server: dnsmng failed: %1',
    'cu_initconf__unable_report_consent' => 'Could not save your settings for receiving information from Plesk: %1.',

    'cu_anonftp__update' => 'update anonymous FTP settings',
    'cu_anonftp__info' => 'get information on anonymous FTP settings',
    'cu_anonftp__status' => 'turns on/off the anonymous FTP service',
    'cu_anonftp__message' => 'Display login message',
    'cu_anonftp__message_text' => 'Login message text',
    'cu_anonftp__incoming' => 'turns on/off uploading to incoming directory (default: %1)',
    'cu_anonftp__incoming_dirs' => 'Allows creation of directories in the incoming directory',
    'cu_anonftp__incoming_downloads' => 'Allows downloading from the incoming directory',
    'cu_anonftp__incoming_limit' => 'Limits disk space in the incoming directory (-1 for unlimited)',
    'cu_anonftp__max_connects' => 'Limits number of simultaneous connections (-1 for unlimited)',
    'cu_anonftp__bandwidth' => 'Limits download bandwidth (-1 for unlimited)',
    'cu_anonftp__success_update' => "SUCCESS: Updating of anonymous FTP account for the domain '%1' completed.\n",
    'cu_anonftp__unable_get_info' => 'Unable to get information about anonymous FTP account for domain "%1": ',
    'cu_anonftp__unable_update' => 'Unable to update anonymous FTP account for domain "%1": ',
    'cu_anonftp__no_physical' => 'domain does not have physical hosting',
    'cu_anonftp__unable_set_max_connections' => 'unable to set maximum connection number: %1',
    'cu_anonftp__unable_set_bandwidth' => 'unable to set bandwidth: %1',
    'cu_anonftp__unable_set_login_message' => 'unable to set login message: %1',

    'cu_spam__update' => 'updates the spam filter configuration for existing mail user',
    'cu_spam__info' => 'retrieves spam filter settings for given mail account',
    'cu_spam__serv_conf' => 'use server-wide settings',
    'cu_spam__hits' => 'hits required for marking letter as spam',
    'cu_spam__action' => 'what to do with spam mail',
    'cu_spam__modify_subj' => 'modify spam mail subject',
    'cu_spam__modify_subj_text' => 'modify spam mail subject text',
    'cu_spam__blacklist' => 'adds or deletes email(s) pattern to black list',
    'cu_spam__whitelist' => 'adds or deletes email(s) pattern to white list',
    'cu_spam__unable_get_info' => 'Unable to get info on SpamAssassin settings for mail account "%1": ',
    'cu_spam__mailname_ignored' => 'mail account "%1" is ignored in %2.',
    'cu_spam__unable_update' => 'Unable to update SpamAssassin settings for mail account "%1": ',
    'cu_spam__unable_fetch_data' => 'unable to fetch data: %1',
    'cu_spam__invalid_option' => 'option "%1" is incorrect',
    'cu_spam__unable_action' => 'Unable to %1 pattern in %2 list: ',
    'cu_spam__unable_add_pattern' => 'unable to add pattern "%1": %2',
    'cu_spam__unable_remove_pattern' => 'Unable to delete pattern "%1".',
    'cu_spam__unable_parse' => 'unable to parse pattern list: ',
    'cu_spam__unknown_action' => 'unknown action in list "%1"',
    'cu_spam__invalid_pattern' => 'incorrect pattern "%1"',
    'cu_spam__unable_get_options' => "Cannot get options:\n%1",
    'cu_spam__success_update' => "SUCCESS: Updating of mail account '%1' completed.\n",
    'cu_spam__success_update_server' => 'Server-wide spam filtering settings were updated',

    // P9
    'cu_spam__update_server' => 'Updates server-wide spam filter settings',
    'cu_spam__info_server' => 'Retrieves server-wide spam filter settings',
    'cu_spam__status' => 'Switches on/off the spam filter',
    'cu_spam__personal_conf' => 'Allows to use personal spam filtering settings',
    'cu_spam__max_proc' => 'Sets maximum number of worker spamd processes to run',
    'cu_spam__reject_spam' => 'Removes spam mail when it arrives in mailboxes',
    'cu_spam__trusted_languages' => 'Sets trusted languages',
    'cu_spam__trusted_locales' => 'Sets trusted locales',
    'cu_spam__trusted_networks' => "Sets trusted networks (allowed only for '--update' command)",

    'cu__sb_sync' => "Create a corresponding user account in Presence Builder (default: %1)",

    'cu_subdomain__hst_type' => 'Hosting type for subdomain (default: %1)',
    'cu_subdomain__www_root' => 'Site home directory for subdoman on subfolder (default %1)',

    'cu_spam__enable_filtering' => "Switch on spam filtering",
    'cu_spam__turn_off_srv' => "Individual spam filtering settings are not allowed by server administrator",

    'cu_initconf__sb_sync' => "create a Presence Builder user for default customer (default: %1)",

    'cu_vdir__create' => "Creates virtual directory",
    'cu_vdir__update' => "Updates virtual directory",
    'cu_vdir__remove' => "Removes virtual directory",
    'cu_vdir__info' => "Virtual directory info",
    'cu_vdir__vhost' => "Virtual host name (required)",
    'cu_vdir__create_phys' => "Creates physical directory (default: %1)",
    'cu_vdir__name' => "Relative virtual directory name",
    'cu_vdir__path' => "Relative path to physical directory (default: %1)",
    'cu_vdir__access_source' => "Script source access (default: %1)",
    'cu_vdir__access_read' => "Read permission (default: %1)",
    'cu_vdir__access_write' => "Write permission (default: %1)",
    'cu_vdir__dir_browsing' => "Directory browsing (default: %1)",
    'cu_vdir__log_visits' => "Log visits (default: %1)",
    'cu_vdir__create_app' => "Create application (default: %1)",
    'cu_vdir__execute_perm' => "Execute permissions (default: %1)",
    'cu_vdir__error_create' => "Unable to create virtual directory: %1",
    'cu_vdir__success_create' => "SUCCESS: Creation of virtual directory '%1' completed.\n",
    'cu_vdir__error_update' => "Unable to update virtual directory settings: %1",
    'cu_vdir__success_update' => "SUCCESS: Update of virtual directory '%1' settings completed.\n",
    'cu_vdir__error_remove' => "Unable to remove virtual directory: %1",
    'cu_vdir__success_remove' => "SUCCESS: Removal of virtual directory '%1' completed\n",
    'cu_vdir__error_info' => "An error occurred while getting virtual directory information: %1",
    'cu_vdir__unable_create_root' => "Unable to create root virtual directory",
    'cu_vdir__vdir_already_exists' => "Virtual directory already exists",
    'cu_vdir__parent_vdir_not_exists' => "Parent virtual directory does not exist",
    'cu_vdir__invalid_xml' => "Invalid XML",
    'cu_vdir__not_relative_home' => "Parent virtual directory path is not relative to home directory",
    'cu_vdir__path_not_exists' => "Path to physical directory does not exist",
    'cu__opt1_required_for_opt2' => "%1 option is required for %2 option",
    'cu_vdir__unable_create_phys' => "Unable to create physical directory: %1",
    'cu_vdir__unable_update_root_path' => "Unable to change path for root virtual directory",
    'cu_vdir__unable_off_root_app' => "Unable to remove application for root virtual directory",
    'cu_vdir__vdir_not_exists' => "Virtual directory does not exist",
    'cu_vdir__vdir_not_editable' => "Virtual directory is not editable",
    'cu_vdir__unable_remove_root' => "Unable to remove root virtual directory",
    'cu_vdir__unable_remove_reserved' => "Unable to remove reserved virtual directory",
    'cu_vdir__vhost_not_exists' => "Virtual host does not exist",
    'cu_vdir__invalid_aspnet_version' => 'Invalid version of ASP.NET specified',

    'cu_vdir__ip_restrictions_only_for_root' => 'You can set custom IP Allow and Deny directives only for the root virtual directory.',
    'cu_vdir__mime_types_only_for_root' => 'You can set custom MIME types only for the root virtual directory.',

    'cu_vdir__dynamic_ip_security_only_for_root' => 'Dynamic IP restriction directives can be set only for the root virtual directory.',
    'cu_vdir__is_deny_by_concurrent_requests' => 'Sets dynamic denying of IP addresses based on the number of concurrent requests.',
    'cu_vdir__max_concurrent_requests' => 'Sets the maximum number of concurrent requests. Used with the -ip_deny_by_concurrent_requests option.',
    'cu_vdir__is_deny_by_request_rate' => 'Sets dynamic denying of IP addresses based on the number of requests over a period of time.',
    'cu_vdir__max_requests' => 'Sets the maximum number of requests. Used with the -ip_deny_by_request_rate option.',
    'cu_vdir__request_interval' => 'Sets a time period (in milliseconds). Used with the -ip_deny_by_request_rate option.',
    'cu_vdir__dynamic_ip_security_legend' => 'Dynamic IP Restriction',
    'cu_vdir__info_is_deny_by_concurrent_requests' => 'Deny IP addresses based on the number of concurrent requests',
    'cu_vdir__info_max_concurrent_requests' => 'Maximum number of concurrent requests',
    'cu_vdir__info_is_deny_by_request_rate' => 'Deny IP address based on the number of requests over a period of time',
    'cu_vdir__info_max_requests' => 'Maximum number of requests',
    'cu_vdir__info_request_interval' => 'Time period (in milliseconds)',

    'virtualdir__ip_restrictions' => 'Access restrictions by IP addresses',
    'virtualdir__ip_restrictions_deny' => 'Deny access',
    'virtualdir__ip_restrictions_allow' => 'Excluding',
    'virtualdir__mime_types' => 'MIME types',
    'cu__mime_types' => 'MIME types',

    'cu_spam_server__update' => "Update server-wide spam filter configuration",
    'cu_spam_server__info' => "Retrieve server-wide spam filter settings",
    'cu_spam_server__max_size' => "Do not filter if mail size exceeds specified size (-1 for unlimited)",
    'cu_spam_server__error_update' => "Unable to update server-wide spam filter settings: %1",
    'cu_spam_server__success_update' => "SUCCESS: Updating of server-wide spam filter settings completed.",
    'cu_spam_server__error_info' => "Unable to retrieve information about server-wide spam filter settings: %1",
    'cu_spam_server__success_info' => "SUCCESS: Gathering information about server-wide spam filter settings completed.",
    'cu_spam_server__usr_cfg_not_allowed' => "Current mail server does not support spam filter settings on the mailbox level",
    'cu_spam_server__max_threads_not_allowed' => "Current spam filter does not support changing the limit on the number of threads",

    'cu_vdir__aspnet_version' => 'Selects ASP.NET version',
    'cu_vdir__aspnet_support_required' => 'ASP.NET support is switched off',

    // Plesk 8 new keys

    // CU virtdir.exe
    'cu_vdir__unable_rename_root' => "Cannot rename root virtual directory",
    'cu_vdir__domain_disabled' => "Domain is suspended",
    'cu_vdir__create_app_req' => "no application present for virtual directory",
    'cu_vdir__unable_set_parent_paths' => "Cannot allow using parent paths: %1",
    'cu_vdir__unable_set_run_in_mta' => "Cannot allow application execution in MTA mode: %1",
    'cu_vdir__unable_set_aspnet_version' => "Cannot set ASP.NET version: %1",
    'cu_vdir__unable_set_default_doc_order' => "Cannot set default documents search order: %1",
    'cu_vdir__default_doc_req' => "default documents usage is switched off",

    // CU clientprefs.exe & domainprefs.exe

    'cu__max_subftp_users' => "Limits the number of FTP accounts (-1 for unlimited)",

    // CU client_template.exe
    'cu_cl_pref__manage_dashboard' => "Allow or prohibit customer to manage Home page",
    'cu_cl_pref__use_dashboard' => "Allow or prohibit customer to use Home page [deprecated]",
    'cu_cl_pref__stdgui' => "Allow or prohibit customer to use standard interface",
    'cu_cl_tpl__ip_pool' => "Adds/removes IP addresses to/from customer's IP pool",
    'cu_cl_tpl__excl_ip_num' => "Number of dedicated IP addresses to allocate to the user",
    'cu_cl_tpl__unable_set_ip_pool' => "Unable to add/remove IP addresses to/from IP pool: wrong values specified",
    'cu_cl_tpl__ip_already_exist' => "IP address '%1' already exists",
    'cu_cl_tpl__ip_not_exist' => "IP address '%1' does not exist",
    'cu_cl_pref__use_sbnet' => "Create Presence Builder User",
    'cu_cl_tpl__use_dashboard_req' => "permission to manage Home page cannot be granted to customer because Home page is not available",
    'cu_cl_tpl__dashboard_or_stdgui_req' => "cannot switch off both Home page and standard interface",
    'cu_cl_tpl__force_permissions' => 'Ignore subscribed customer account permissions',

    // Home page CU
    'cu_dt__set_admin' => "Select Home page preset for administrator",
    'cu_dt__update_preset' => "Update Home page preset properties",
    'cu_dt__preset_list' => "Show the list of available Home page presets",
    'cu_dt__add_preset' => "Add Home page preset to repository",
    'cu_dt__remove_preset' => "Remove Home page preset from repository",
    'cu_dt__set_preset' => "Select current Home page preset",
    'cu_dt__default' => "Make Home page preset default for Plesk users of a certain level (set with option -type)",
    'cu_dt__overwrite' => "Overwrite Home page presets with same names",
    'cu_dt__type' => "Select the level of Plesk users for default Home page preset",
    'cu_dt__success_set_admin' => "SUCCESS: New Home page preset for administrator is set",
    'cu_dt__unable_set_admin' => "Unable to set new Home page preset for administrator: %1",
    'cu_dt__unable_preset_list' => "Unable to show the list of existing Home page presets: %1",
    'cu_dt__success_update_preset' => "SUCCESS: Home page preset properties updated",
    'cu_dt__unable_update_preset' => "Unable to update Home page preset properties: %1",
    'cu_dt__success_add_preset' => "SUCCESS: Home page preset added to repository",
    'cu_dt__unable_add_preset' => "Unable to add Home page preset to repository: %1",
    'cu_dt__success_remove_preset' => "SUCCESS: Home page preset removed from repository",
    'cu_dt__unable_remove_preset' => "Unable to remove Home page preset from repository: %1",
    'cu_dt__preset_not_found' => 'Home page preset "%1" of type "%2" was not found in repository',
    'cu_dt__preset_file_not_readable' => "Home page preset file '%1' cannot be read",

    'cu_subdomain__sb_publish' => "Create and publish site using SiteBuilder (default: %1)",
    'cu_subdom__sb_publish' => "Create and publish site using Presence Builder (default: %1)",

    // domain_template.exe
    'cu_dom_tpl__no_usr' => "Specify what to do with mail to non-existent users: bounce, catch all, or discard.",
    'cu_dom_tpl__expiration' => "Limits domain validity period.",
    'cu_dom_tpl__maillist' => "Allows or prohibits mailing lists (default: %1).",
    'cu_dom_tpl__mail_autodiscovery' => "Enable mail autodiscover (default: %1).",
    'cu_dom_tpl__hosting' => "Switches physical hosting on or off (default: %1).",
    'cu_dom_tpl__sb_subdomains_create' => "Creates Blog and Photo Gallery subdomains (obsolete).",
    'cu_dom_tpl__bandwidth' => "Specifies maximum network use (-1 for unlimited).",
    'cu_dom_tpl__max_connections' => "Limits the number of simultaneous web connections (-1 for unlimited).",
    'cu_dom_tpl__log_max_num' => "Defines the maximum number of log file instances.",
    'cu_dom_tpl__unable_set_php_version' => "Unable to set PHP version: PHP support is switched off",
    'cu_dom_tpl__unable_set_pdir_plesk_stat' => "Currently selected web statistics package does not support secure access through the /plesk-stat/ protected directory",
    'cu_dom_tpl__aspnet_req' => "Unable to set ASP.NET version: ASP.NET support required",
    'cu_dom_tpl__unable_set_php_isapi' => "Unable to run PHP as ISAPI extension: PHP support required",
    'cu_dom_tpl__unable_set_ssi_html' => "Unable to use SSI for HTML files: SSI support required",
    'cu_dom_tpl__iis_app_pool_req' => "Unable to limit CPU usage: dedicated IIS application pool required",
    'cu_dom_tpl__wuscripts' => "Switches on scripting support for web users (default: %1)",
    'cu_dom_tpl__apache_additional_settings' => 'Apache settings for HTTP',
    'cu_dom_tpl__apache_additional_settings_description' => 'Specifies the full path to the file with Apache settings for HTTP.',
    'cu_dom_tpl__apache_additional_ssl_settings' => 'Apache settings for HTTPS',
    'cu_dom_tpl__apache_additional_ssl_settings_description' => 'Specifies the full path to the file with Apache settings for HTTPS.',
    'cu_dom_tpl__apache_additional_nginx_settings' => 'nginx settings',
    'cu_dom_tpl__apache_additional_nginx_settings_description' => 'Specifies the full path to the file with nginx settings.',
    'cu_dom_tpl__nginx_settings' => 'Nginx settings',
    'cu_dom_tpl__nginx_proxy_mode' => 'Turns on/off the proxy mode for the nginx reverse proxy server.',
    'cu_dom_tpl__additional_settings_file_not_found' => 'Unable to read the file: %1',
    'cu_dom_tpl__unpaid_website_status_desc' => "Sets the status of websites in suspended subscriptions (default: %1).",
    'cu_dom_tpl__unpaid_website_status' => "Status of websites in suspended subscriptions",
    'cu_dom_tpl__mailservice' => "Switches on the mail service (default: %1).",
    'cu_dom_tpl__template_already_exist' => "A service plan with the name '%1' already exists.",

    'cu_domain__php_version' => "PHP version (default: %1)",
    'cu_subdomain__php_version' => "Select PHP version on subdomain (default: %1)",
    'cu_vdir__php_version' => "Select PHP version",
    'cu_vdir__unable_set_php_version' => "Unable to set PHP version: %1",
    'cu_vdir__php_support_required' => "PHP support is switched off",
    'cu_vdir__invalid_php_version' => "Invalid PHP version",
    'cu_vdir__invalid_php_handler_type' => "Invalid PHP handler type. Valid PHP handler type: %1.",
    'cu_vdir__invalid_php_handler_type_for_version' => 'PHP handler type %1 is not supported for version %2.',


    ///PPP10: domain_service_plan
    'cu__php_safe_mode' => 'Enable PHP safe mode [deprecated]',


    // domalias.exe
    'cu_da__create' => "Creates a domain alias",
    'cu_da__update' => "Updates domain alias properties",
    'cu_da__remove' => "Removes domain alias [deprecated]",
    'cu_da__remove_all' => "Removes all domain aliases for specified domain [deprecated]",
    'cu_da__delete' => 'Removes domain alias',
    'cu_da__delete_all' => 'Removes all domain aliases for specified domain',
    'cu_da__info' => "Displays domain alias information",
    'cu_da__on' => "Turns on domain alias",
    'cu_da__off' => "Turns off domain alias",
    'cu_da__rename' => "Renames domain alias",
    'cu_da__new_name' => "New domain alias name (required for renaming)",
    'cu_da__mail' => "Turns domain alias for mail service on or off",
    'cu_da__web' => "Turns domain alias for web service on or off",
    'cu_da__domain' => "Domain name (required for creation)",
    'cu_da__status' => "Turns domain alias on or off",
    'cu_da__invalid_param_val' => "the value of %1 parameter is invalid",
    'cu_da__success_create' => "The domain alias %1 was successfully created.",
    'cu_da__unable_create' => "Unable to create domain alias: %1",
    'cu_da__success_update' => "The domain alias %1 properties were successfully updated.",
    'cu_da__unable_update' => "Unable to update domain alias properties: %1",
    'cu_da__success_remove' => "The domain alias %1 was removed.",
    'cu_da__unable_remove' => "Unable to remove domain alias: %1",
    'cu_da__unable_info' => "Unable to display domain alias information: %1",
    'cu_da__success_remove_all' => "All domain aliases for domain %1 were removed.",
    'cu_da__unable_remove_all' => "Unable to remove all domain aliases for domain %1: %1",
    'cu_da__success_on' => "The domain alias %1 was successfully switched on.",
    'cu_da__unable_on' => "Cannot switch on domain alias: %1",
    'cu_da__success_off' => "The domain alias %1 was successfully switched off.",
    'cu_da__unable_off' => "Cannot switch off the domain alias: %1",
    'cu_da__success_rename' => "Domain alias %1 was successfully renamed.",
    'cu_da__unable_rename' => "Cannot rename domain alias: %1",
    'cu_da__dns' => 'Turns domain alias for DNS service on or off.',
    'cu_da__seo_redirect' => "Turns on the search engine-friendly HTTP 301 redirection. Use 'true' to turn on the redirection from the domain alias's URL to the primary domain's URL, and 'false' to turn the redirection off (default: %1).",
    'cu_da__icp_status' => 'ICP status (true if the domain name is approved).',
    'cu_da__icp_permit' => 'ICP permit for the domain name.',

    // domadmin.exe
    'cu_du__update' => "Update domain administrator account",
    'cu_du__passwd' => "Specify domain administrator's password",
    'cu_du__pname' => "Specify domain administrator's personal name",
    'cu_du__multiple_sessions' => "Allow multiple sessions",
    'cu_du__max_lock_screen' => "Prevent working with Plesk until page is completely loaded",
    'cu_du__set_desktop_preset' => "Set Home page preset for domain administrator",
    'cu_du__desktop_preset' => "Home page preset",
    'cu_du__unable_update' => "Unable to update domain administrator account: %1",
    'cu_du__unable_info' => "Unable to display domain administrator's account information: %1",
    'cu_du__info' => "Display domain administrator's account information",
    'cu_du__success_update' => "SUCCESS: Account of '%1' domain administrator updated.\n",
    'cu_du__req_opts_not_set' => "the following options are required to create a domain administrator account: %1",
    'cu_du__invalid_option_parameter' => "Wrong syntax for '%1' option's parameter",
    'cu_du__success_convert_to_client' => "Administrator account of domain '%1' was successfully converted to a customer account.",
    'cu_du__convert_to_client' => 'Converts domain administrator account to a customer account',

    // custombutton.exe
    'cu_cb__create' => "Create custom button",
    'cu_cb__info' => "Display custom button properties (button's database ID required)",
    'cu_cb__remove' => "Remove custom button (button's database ID required)",
    'cu__man' => "Display detailed help page with examples",
    'cu_cb__owner' => "Specify custom button owner's username (default: Administrator)",
    'cu_cb__sort_key' => "Specify custom button priority (default: 100)",
    'cu_cb__place' => "Specify custom button location: customer\'s home page, domain administrator home page, Tools & Settings page, navigation frame (default: customer\'s home page)",
    'cu_cb__text' => "Custom button name (required for creation)",
    'cu_cb__url' => "URL to which the custom button will point to (required for creation)",
    'cu_cb__url_comp' => "Components which should be included in the URL for custom button",
    'cu_cb__conhelp' => "Contextual help text",
    'cu_cb__file' => "Path to file which should be used as custom button icon",
    'cu_cb__public' => "Specify whether the custom button should be visible to sub-level users (default: %1)",
    'cu_cb__internal' => "Specify whether the button URL should be opened in Plesk frame or in the new window (default: %1)",
    'cu_cb__print_id' => "Display ID of created button (actual for creation)",
    'cu_cb__siteapp_link' => "Link custom button with web application",
    'cu_cb__siteapp_domain' => "Link custom button with web application installed on specified domain (required for -siteapp-link option)",
    'cu_cb__siteapp_id' => "Specify web application database ID",
    'cu_cb__siteapp_name' => "Specify web application name",
    'cu_cb__siteapp_version' => "Specify web application version",
    'cu_cb__siteapp_release' => "Specify web application release build number",
    'cu_cb__siteapp_prefix' => "Specify web application installation prefix",
    'cu_cb__siteapp_subdomain' => "Specify subdomain prefix if web application was installed on subdomain",
    'cu_cb__unable_create' => "Unable to create custom button: %1",
    'cu_cb__success_create' => "SUCCESS: Creation of custom button completed.\n",
    'cu_cb__unable_remove' => "Unable to remove custom button: %1",
    'cu_cb__success_remove' => "SUCCESS: Removal of custom button completed.\n",
    'cu_cb__no_siteapps_on_domain' => "There are no web applications installed on domain %1",
    'cu_cb__siteapps_not_exist' => "Web application with such parameters doesn't exist",
    'cu_cb__unable_determine_siteapps' => "Not enough parameters to determine exact web application instance",
    'cu_cb__unable_modify_url' => "You cannot modify URL of custom button linked to web application",
    'cu_cb__unable_set_owner' => "You cannot change the owner of custom button linked to web application",
    'cu_cb__unable_info' => "Unable to get information about custom button: %1",
    'cu_cb__unable_update' => "Unable to update custom button information: %1",
    'cu_cb__already_linked' => "Custom button is already linked to a web application",
    'cu_cb__unable_link_to_siteapp' => "Unable to link custom button to web application: %1",
    'cu_cb__not_linked' => "Custom button is not linked to web application",
    'cu_cb__unable_unlink' => "Unable to remove custom button link to web application: %1",
    'cu_cb__unable_set_property' => "Unknown custom button property: %1",
    'cu_cb__unable_plase_on_client_page' => "Unable to place custom button owned by domain administrator on customer\'s home page",
    'cu_cb__list' => 'Display the list of all custom buttons',

    // database-server.exe

    'cu_dbsrv__update_server' => 'Update the properties of a specified database server',
    'cu_dbsrv__type' => 'Set database server type. It is required for create-server/set-defaut-server-local commands',
    'cu_dbsrv__set' => 'Set database server host and/or port',
    'cu_dbsrv__admin' => "Set database server administrator's username (required for creation)",
    'cu_dbsrv__passwd' => "Set database server administrator's password (required for creation)",
    'cu_dbsrv__reset_passwd' => "Change database server administrator's password",
    'cu_dbsrv__success_update_server' => "SUCCESS: Database server properties were updated successfully.\n",

    'cu_cl_pref__manage_webstat' => 'allows changing web statistics type',

    'cu_cl_pref__allow_ftp_backups' => 'Allows or prohibits performing subscription backup to a personal FTP storage',
    'cu_cl_pref__allow_local_backups' => 'Allows or prohibits performing subscription backup to the server storage',
    'cu_cl_pref__allow_account_ftp_backups' => 'Allows or prohibits performing account backup to a personal FTP storage',
    'cu_cl_pref__allow_account_local_backups' => 'Allows or prohibits performing account backup to the server storage',

    'cu_cl_pref__manage_additional_permissions' => 'Allows managing additional write/modify permissions',
    'cu_domain__write_modify' => "Additional write/modify permissions (default: %1)",
    'cu_dom_tpl__write_modify' => "Additional write/modify permissions (default: %1)",
    'cu_subdomain__write_modify' => 'Additional write/modify permissions for subdomain (default: %1)',
    'cu_webuser__write_modify' => 'Additional write/modify permissions for web user (default: %1)',

    'cu_cl_pref__manage_spamfilter' => 'allows managing spam filter',

    'cu_dbsrv__create_server' => 'Creates a database server entry',
    'cu_dbsrv__remove_server' => 'Removes a database server entry. Only remote database server entries can be removed. The default database server cannot be removed. A database server which has Plesk databases hosted on it cannot be removed either.',
    'cu_dbsrv__set_default' => 'Selects a database server entry as the default for its database type',
    'cu_dbsrv__success_create_server' => "SUCCESS: Server %1 is successfully added.\n",
    'cu_dbsrv__success_remove_server' => "SUCCESS: Server %1 is successfully removed.\n",
    'cu_dbsrv__success_set_default' => "SUCCESS: Server %1 was set as default.\n",

    'cu_db__server' => 'Specifies the database server.',
    'cu_db_set_default_user' => 'Makes the specified user default for the database. The option is used with the commands add_user and update_user.',
    'cu_db_set_database_collation' => 'Sets the collation for MySQL databases.',
    'cu_db__allow_access_from' => 'Allows remote connections to the database from the specified IP addresses.',
    'cu_database__charset' => 'Sets the character set for a newly created database.',
    'cu_db_set_database_collation' => 'Sets the collation for the specified database.',

    'cu_dbsrv__set_sandbox_mssql_server' => 'Registers a sandbox Microsoft SQL server which will be used for checking databases.',
    'cu_dbsrv__remove_sandbox_mssql_server' => 'Removes a sandbox Microsoft SQL server.',
    'cu_dbsrv__success_create_sandbox_server' => 'The sandbox Microsoft SQL server was registered successfully.',
    'cu_dbsrv__success_remove_sandbox_server' => 'The sandbox Microsoft SQL server was removed successfully.',
    'sandbox_mssql_server_unable_to_register' => 'Unable to register a sandbox MS SQL server: Unable to log in to the MS SQL server. Please specify correct credentials to the Microsoft SQL server.',
    'sandbox_mssql_server_login_is_not_sysadmin' => 'The specified user name does not belong to the system administrator. Please specify correct credentials to the MS SQL server.',
    'sandbox_mssql_server_unable_to_register_incorrect_network_params' => 'Unable to register a sandbox Microsoft SQL server: Incorrect credentials to the network share were specified.',
    'sandbox_mssql_server_is_not_registered' => 'Unable to remove the sandbox Microsoft SQL server because there is no registered sandbox Microsoft SQL server.',
    'sandbox_mssql_server_is_inaccessible' => 'Plesk was not set up for importing databases. Contact your hosting provider for assistance.',

    'cu_db_add_access' => 'Adds an access record to MySQL ACL for the specified database user.(*)',
    'cu_db_remove_access' => 'Removes an access record from MySQL ACL for the specified database user.(*)',
    'cu_db_set_acl' => 'Sets the MySQL access control list (all access records) for the specified database user.(*)',
    'cu_db__assign_to_subscription' => 'Moves the database to the specified subscription.',

    'cu_db_footnote' => '* Hosts can be specified by either a host name or IP address with an optional netmask. Separate the hosts with commas. MySQL wildcard symbols (_ and %) are allowed. (See also http://dev.mysql.com/doc/refman/5.0/en/connection-access.html)',

    'cu_initconf__admin_info_not_req' => "Make entering the Plesk administrator's contact information optional. This will also make Plesk skip initial configuration screens shown upon the first login to Plesk. (default: %1)",

    'cu_sitebuilder__migrate' => 'Migrates users from SiteBuilder 2.0.5 to SiteBuilder 3.x and newer',
    'cu_sitebuilder__update' => 'Updates internal links between Plesk and Presence Builder users when updating from Plesk 7.6.1',
    'cu_sitebuilder__domain_name' => 'Specifies the domain that should be processed',

    'cu_sitebuilder__ssomigrate' => 'Migrate all Presence Builder users to single sign-on accounts, binding them to corresponding Plesk users',
    'cu_sitebuilder__ssoenable' => 'Switch on Single Sign-On in Presence Builder and use Plesk SSO server',
    'cu_sitebuilder__sso_server_url' => 'URL of remote Single Sign-On server (optional)',

    'cu_servpref__update' => 'Sets server settings.',
    'cu_servpref__show' => 'Shows the values of server settings.',

    'cu_sitebuilder__fix' => 'Restore Presence Builder Reseller and Site Owner accounts',
    'cu_sitebuilder__ssodisable' => 'Switch off Single Sign-On in Presence Builder',
    'cu_sitebuilder__client_login' => 'Customer account username',

    // firewall cu

    'cu_firewall__disable' => 'Switch off firewall',
    'cu_firewall__enable' => 'Switch on firewall',
    'cu_firewall__set' => 'Reset firewall rules to default values',
    'cu_firewall__id' => 'Rule identifier', //to review this message and below!
    'cu_firewall__description' => 'Rule description',
    'cu_firewall__action' => 'Rule action (allow or block)',
    'cu_firewall__port' => 'Comma-separated list of port numbers or port number ranges (443,943,8443-8445)',
    'cu_firewall__remote_addresses' => "Comma-separated list of IP addresses, subnets or ranges of IP addresses (192.168.0.1,192.168.10.0/24,10.55.62.101-10.55.62.105)",
    'cu_firewall__profiles' => "Comma-separated list of profiles (public,private,domain)",

    'cu__php_handler_type' => 'PHP support mode (default: %1)',

    ///// mail server

    'cu_mailserver__domain_keys_sign' => 'Switches on/off signing of outgoing mail by DKIM spam protection',
    'cu_mailserver__domain_keys_verify' => 'Switches on/off checking of incoming mail by DKIM spam protection',
    'cu_dom_pref__domain_keys_sign' => 'Switches on/off DKIM spam protection service',
    'cu__mailserver_update_webmail_command' => "Specifies a webmail client you want to enable or disable",
    'cu__mailserver_webmail_state' => "Specifies the state of the selected webmail client (true enables the client, false disables it)",
    'cu_mailserver__success_domain_keys_sign' => "Signing of outgoing mail by DKIM spam protection was successfully switched on/off.\n",
    'cu_mailserver__unable_domain_keys_sign' => 'Unable to change the settings for the DKIM spam protection service',
    'cu_mailserver__unable_domain_keys_verify' => "Unable to switch on/off checking of incoming mail by DKIM spam protection: %1",
    'cu_mailserver__success_domain_keys_verify' => "Checking of incoming mail by DKIM spam protection was switched on/off.\n",
    'cu_mailserver__error_set_maps_zone' => 'An error occurred while setting DNSBL zones: %1',
    'cu_mailserver__success_set_maps_zone' => 'DNSBL zones were set successfully.',
    'cu_mailserver__set_maps_zone' => 'Sets zones for DNSBL protection (comma separated list).',

    'cu_mailserver__add_external_webmail' => 'Registers an additional webmail service. Required options: webmail-name and webmail-url.',
    'cu_mailserver__update_external_webmail' => 'Updates settings of an additional webmail service.',
    'cu_mailserver__remove_external_webmail' => 'Removes registration of an additional webmail service.',
    'cu_mailserver__webmail_name' => 'Webmail service name.',
    'cu_mailserver__webmail_url' => 'Webmail service URL.',
    'cu_mailserver__webmail_status' => 'Webmail service availability.',

    'cu_mailserver__outgoing_antispam' => 'Limits on outgoing email messages',
    'cu_mailserver__enable_outgoing_antispam' => 'Switches on limits on outgoing email messages.',
    'cu_mailserver__disable_outgoing_antispam' => 'Switches off limits on outgoing email messages.',
    'cu_mailserver__outgoing_messages_mbox_limit' => 'The number of outgoing messages from a mailbox (per hour).',
    'cu_mailserver__outgoing_messages_domain_limit' => 'The number of outgoing messages from a domain (per hour).',
    'cu_mailserver__outgoing_messages_subscription_limit' => 'The number of outgoing messages from a subscription (per hour).',
    'cu_mailserver__success_enable_outgoing_antispam' => 'The limit on outgoing email messages was successfully switched on.',
    'cu_mailserver__success_disable_outgoing_antispam' => 'The limit on outgoing email messages was switched off.',
    'cu_mailserver__success_set_outgoing_messages_mbox_limit' => 'The limit on outgoing email messages from a mailbox was updated.',
    'cu_mailserver__success_set_outgoing_messages_domain_limit' => 'The limit on outgoing email messages from a domain was updated.',
    'cu_mailserver__success_set_outgoing_messages_subscription_limit' => 'The limit on outgoing email messages from a subscription was updated.',
    'mailserver__outgoing_antispam_is_disabled' => 'The limits on outgoing email messages are switched off.',
    'mailserver__outgoing_antispam_not_supported_by_license' => 'The limits on the number of outgoing email messages are not supported by the license key.',
    'mailservice_not_supported' => 'The mail service is not supported.',
    'outgoing_messages_domain_limit_is_not_supported' => 'The limit on outgoing email messages from a domain is not supported.',
    'outgoing_messages_mbox_limit_is_not_supported' => 'The limit on outgoing email messages from a mailbox is not supported.',
    'outgoing_messages_subscription_limit_is_not_supported' => 'The limit on outgoing email messages from a subscription is not supported.',
    'outgoing_messages_enable_sendmail_is_not_supported' => 'Sendmail for scripts and system users of subscriptions is not supported.',
    'outgoing_messages_overlimit_percent_limit_is_not_supported' => 'Unable to set the percentage of email messages to be put in a queue and sent in the next hour: This operation is not supported by the mail server.',
    'outgoing_messages_domain_limit_is_not_supported_by_subdomains' => 'The limit on outgoing messages for the domain is not supported by its subdomains.',
    'outgoing_messages_mbox_limit_unable_set_up' => 'Unable to set up the specified limit on outgoing messages from a mailbox.',
    'outgoing_messages_domain_limit_unable_set_up' => 'Unable to set up the specified limit on outgoing messages from a domain.',
    'outgoing_messages_subscription_limit_unable_set_up' => 'Unable to set up the specified limit on outgoing messages from a subscription.',
    'cu_mailserver__option_description_smtp_use_default_settings' => 'Uses the mail server installed with Plesk as an external SMTP server, and uses the default mail account to access this SMTP server. Use this option with the --update-smtp-settings command.',
    'cu_mailserver__error_smtp_default_settings_not_supported' => 'Unable to update the external SMTP server settings: the default mail account cannot be used.',
    'cu_mailserver__set_enable_sendmail' => 'Turns Linux Sendmail for PHP scripts on or off. Scripts will be able to send mail even when the limits on outgoing messages are reached for the corresponding mailbox and domain.',
    'cu_mailserver__set_outgoing_messages_fix_sender' => 'Fix incorrectly set sender for outgoing mail. Automatically set valid email headers and sender envelope address for outgoing mail from domains to reduce chances of being treated as spam.',
    'cu_mailserver__success_enable_outgoing_messages_fix_sender' => 'Fix incorrectly set sender for outgoing mail was turned on.',
    'cu_mailserver__success_disable_outgoing_messages_fix_sender' => 'Fix incorrectly set sender for outgoing mail was turned off.',
    'cu_mailserver__outgoing_messages_fix_sender_is_not_supported' => 'Fix incorrectly set sender for outgoing mail is not supported.',
    'cu_mailserver__success_set_enable_sendmail' => 'The availability of Sendmail for PHP scripts was changed.',
    'cu_mailserver__enable_sendmail' => 'Turn on Linux Sendmail for PHP scripts',
    'cu_mailserver__set_report_period' => 'Sets the period of time for the alert on the Home page about attempts to exceed limits on outgoing mail (the last day, week, two weeks, or month).',
    'cu_mailserver__success_set_report_period' => 'The period of time for the alert about attempts to exceed limits on outgoing mail was updated.',
    'cu_mailserver__report_period' => 'Show the alert on the Home page about attempts to exceed limits based on statistics for the last',
    'cu_mailserver__set_notification_period' => 'Sets the period of time for email notifications about attempts to exceed limits on outgoing mail.',
    'cu_mailserver__success_set_notification_period' => 'The period of time for notifications was updated.',
    'cu_mailserver__notification_period' => 'Send a notification about attempts to exceed limits on outgoing mail every',
    'cu_mailserver__set_outgoing_messages_mbox_limit' => 'Sets the maximum number of outgoing messages from a mailbox (per hour).',
    'cu_mailserver__set_outgoing_messages_domain_limit' => 'Sets the maximum number of outgoing messages from a domain (per hour).',
    'cu_mailserver__set_outgoing_messages_subscription_limit' => 'Sets the maximum number of outgoing messages from a subscription (per hour).',
    'cu_mailserver__sfdk_sign_outgoing_mail' => 'DKIM spam protection. Turns on/off signing of outgoing mail.',
    'cu_mailserver__sfdk_verify_incoming_mail' => 'DKIM spam protection. Turns on/off checking of incoming mail',
    'cu_mailserver__enable_dmarc' => 'DMARC spam protection. Turns on DMARC validation for incoming mail.',
    'cu_mailserver__disable_dmarc' => 'DMARC spam protection. Turns off DMARC validation for incoming mail.',

    'cu_common_success_operation' => 'SUCCESS: Operation was successfully completed.',

    'cu__max_odbc' => 'Limit the number of ODBC connections',
    'cu_dom_tpl__log_rotate_type_conflict' => 'Conflicting log rotation settings were selected. Please set up log rotation either by size or by time.',

    'cu_cl_pref__select_db_server' => 'Ability to select a database server',

    // creation utilities
    'cu_db__remove_dbs' => 'Delete databases specified with their IDs',
    'cu_db__remove_dbus' => 'Delete database users specified with their IDs',
    'cu_db_unable_removedbs' => 'Unable to remove database with ID "%1": %2',
    'cu_db_unable_removedbus' => 'Unable to remove database user with ID "%1": %2',
    'cu_db__print_id' => 'Print IDs of created objects (actual for "create" command and "add_user" option)',
    'cu_db__success_remove_dbs' =>  'The databases were deleted successfully.',
    'cu_db__success_remove_dbus' => 'The database users were deleted successfully.',
    'cu_mlist__update_service' => 'Update mailing list service for domain',
    'cu_mlist__update_service_failed' => 'Unable to update mailing list service status: %1',
    'cu_mlist__create_service_failed' => 'Domain mailing list service does not exist and cannot be initialized: %1',
    'cu_mlist__on' =>  'Enable mailing list service for domain',
    'cu_mlist__off' =>  'Disable mailing list service for domain',
    'cu_mlist__onoff_failed' =>  'An error occurred during turning on/off the mailing list service for domain: %1',
    'cu_mlist__service_success' => 'The operation with mailing list service for domain "%1" completed successfully.',
    'cu_mlist__secure_failed' => 'An error occurred while setting secure links status for mailman: %1',
    'cu_mlist__secure_links_not_supported' => 'Securing links in mailing lists is not supported on this server',
    'cu_cannot_parse_limit' => 'Cannot parse limit value from string "%1"',
    'cu_cannot_parse_size' => 'Cannot parse size from string "%1"',
    'cu_dbsrv__set_default_local' => 'Select the local database server of the specified type as the default.',
    'cu_hotlink__update' => 'Update hotlink protection settings',
    'cu_hotlink__info' => 'Retrieve hotlink protection settings',
    'cu_hotlink__enabled' => 'Enable/disable hotlink protection',
    'cu_hotlink__externsion' => 'Set protected file extensions',
    'cu_hotlink__friend_domains' => 'Set friendly domains',
    'cu_hotlink__unable_update' => 'Unable to update hotlink protection settings: %1',
    'cu_hotlink__unable_info' => 'Unable to retrieve hotlink protection settings: %1',
    'cu_hotlink_invalid_extension' => 'Invalid extension value "%1"',
    'cu_hotlink_invalid_friend_domain' => 'Invalid friendly domain value "%1"',
    'cu_hotlink_unable_update_option' => 'Unable to update option "%1" with value "%2": %3',
    'cu_mailserver__set_relay' => 'Set relaying type',
    'cu_mailserver__set_max_letter_size' => 'Set maximum message size (in Kbytes|Mbytes|Gbytes|Tbytes)',
    'cu_mailserver__set_message_submission' => 'Set message submission',
    'cu_mailserver__set_auth_type' => 'Types of authorization (required for --set-relay auth)',
    'cu_mailserver__set_locktime' => 'Set lock time for "pop3" or "both"',
    'cu_mailserver__set_submission_ip' => 'Set IP address for message submission',
    'cu_mailserver__unable_set_relay' =>  'Unable to update relaying type: %1',
    'cu_mailserver__success_set_relay' => 'Relaying type updated successfully',
    'cu_mailserver__unable_set_maxlettersize' => 'Unable to set maximum message size: %1',
    'cu_mailserver__success_set_maxlettersize' => 'Maximum message size updated successfully',
    'cu_mailserver__unable_set_message_submission' => 'Unable to set message submission: %1',
    'cu_mailserver__success_set_message_submission' => 'Message submission updated successfully',

    'cu_mailserver__set_maps_status' => 'Set DNSBL spam protection status.',
    'cu_mailserver__add_maps_zone' => 'Adds zone(s) to DNSBL protection. (Comma separated list)',
    'cu_mailserver__remove_maps_zone' => 'Removes zone(s) from DNSBL protection. (Comma separated list)',
    'cu_mailserver__success_set_maps_status' => 'SUCCESS: DNSBL protection status is successfully set.',
    'cu_mailserver__error_set_maps_status' => "Unable to set DNSBL protection status: %1",
    'cu_mailserver__success_add_maps_zone' => 'SUCCESS: DNSBL zones are successfully added',
    'cu_mailserver__error_add_maps_zone' => 'An error occurred while adding DNSBL zones: %1',
    'cu_mailserver__success_remove_maps_zone' => 'SUCCESS: DNSBL zones are successfully removed',
    'cu_mailserver__error_remove_maps_zone' => 'An error occurred while removing DNSBL zones: %1',
    'cu_mailserver__unable_init_mailmainp' => 'Unable to init the Mail Manipulator: %1',
    'cu_mailserver__unable_turn_on_maps' => 'Impossible to turn on DNSBL protection: %1',
    'cu_mailserver__unable_turn_off_maps' => 'Impossible to turn off DNSBL protection: %1',
    'cu_mailserver__domain_name_invalid' => 'Domain name %1 is invalid',
    'cu_mailserver__unable_update_db' => 'Unable to update database: %1',
    'cu_mailserver__unable_add_maps_zone' => 'Unable to add zone to DNSBL protection: %1',
    'cu_mailserver__maps_zone_not_exists' => 'Nothing to remove. Zones do not exist',

    // reseller_template.exe
    'cu_res_tpl__ip_pool' => "Adds/removes IP addresses to/from reseller's IP pool",
    'cu_res_tpl__excl_ip_num' => "Number of dedicated IP addresses to allocate to the reseller",
    'cu_res_tpl__ip_already_exist' => "IP address '%1' already exists",
    'cu_res_tpl__ip_not_exist' => "IP address '%1' does not exist",


    // autoresponder.exe
    'cu_autoresponder_command_description_create' => 'Creates auto-reply',
    'cu_autoresponder_command_description_update' => 'Updates auto-reply properties',
    'cu_autoresponder_command_description_remove' => 'Removes auto-reply',
    'cu_autoresponder_command_description_info' => 'Displays auto-reply properties',
    'cu_autoresponder_command_description_attachments' => 'Adds and removes files to and from attachment repository',
    'cu_autoresponder_command_description_on' => 'Switches all auto-replies on',
    'cu_autoresponder_command_description_off' => 'Switches all auto-replies off',
    'cu_autoresponder_command_description_help' => 'Displays this help page',
    'cu_autoresponder_option_description_mail' => 'Specifies the mail account for which the auto-reply is created (required)',
    'cu_autoresponder_option_description_status' => 'Switches auto-reply on and off',
    'cu_autoresponder_option_description_requires' => 'Sets reply conditions for auto-reply - patterns found in subject line and message body',
    'cu_autoresponder_option_description_subject' => "Specifies subject line used in auto-reply messages (default: 'Re: <incoming_message_subject>')",
    'cu_autoresponder_option_description_replyto' => "Return address used in auto-reply's messages",
    'cu_autoresponder_option_description_format' => 'Auto-reply message format',
    'cu_autoresponder_option_description_text' => 'Auto-reply message text',
    'cu_autoresponder_option_description_forward_to' => 'Sets email address where incoming messages should be forwarded to',
    'cu_autoresponder_option_description_attach' => 'Adds and removes auto-reply attachment files (used by --update and --create commands)',
    'cu_autoresponder_option_description_frq' => 'Defines the maximum number of responses to a unique email address per day',
    'cu_autoresponder_option_description_store' => 'Defines the number of unique addresses to be stored for auto-reply',
    'cu_autoresponder_option_description_redirect' => 'Defines email address to forward all incoming mail to',
    'cu_autoresponder_option_description_forward_files' => 'Adds and removes files to and from attachment repository (used by --attachments command)',

    // dns.exe
    'cu_dns_command_description_add' => "Adds a resource record to domain's DNS zone or a primary DNS server IP address. If such record exists, code 2 will be returned",
    'cu_dns_command_description_set' => "Adds all resource records to DNS zone. Old records will be removed. Records should be listed by option 'list'",
    'cu_dns_command_description_del' => "Removes a resource record from the domain's DNS zone",
    'cu_dns_command_description_del_all' => "Removes all resource records from domain's DNS zone",
    'cu_dns_command_description_reset' => 'Restores the default DNS zone by the template',
    'cu_dns_command_description_on' => 'Switches on DNS service for domain',
    'cu_dns_command_description_off' => 'Switches off DNS service for domain',
    'cu_dns_command_description_set_master' => 'Switches DNS zone type to master',
    'cu_dns_command_description_set_slave' => 'Switches DNS zone type to slave',
    'cu_dns_command_description_update_soa' => 'Updates SOA settings for domain',
    'cu_dns_command_description_info' => 'Displays information about DNS records for domain or domain alias',
    'cu_dns_command_description_sync' => 'Synchronizes the zone information on the DNS server with the information in the Plesk database.',
    'cu_dns_command_description_sync_all_zones' => 'Synchronizes all zones information on the DNS server with the information in the Plesk database.',
    'cu_dns_command_description_help' => 'Displays this help page',
    'cu_dns_option_description_a' => 'A resource record',
    'cu_dns_option_description_ns' => 'NS resource record',
    'cu_dns_option_description_mx' => 'MX resource record',
    'cu_dns_option_description_cname' => 'CNAME resource record',
    'cu_dns_option_description_txt' => 'TXT resource record',
    'cu_dns_option_description_ip' => "Specifies IP address for creating A record or restoring the default domain's DNS zone",
    'cu_dns_option_description_nameserver' => 'Specifies nameserver for creating NS record',
    'cu_dns_option_description_mailexchanger' => 'Specifies mail exchange server for creating MX record',
    'cu_dns_option_description_priority' => 'Specifies mail exchange server priority MX record',
    'cu_dns_option_description_canonical' => 'Specifies canonical name for creating CNAME record',
    'cu_dns_option_description_subnet' => 'Specifies IP address and subnet mask for creating PTR record (i.e. 123.123.123.123/8)',
    'cu_dns_option_description_domain' => 'Specifies domain name for creating TXT, DS or CAA record',
    'cu_dns_option_description_www' => 'Enables or disables WWW-prefixed alias support for canonical domain names. It is used with the "reset" command',
    'cu_dns_option_description_primary' => 'Specifies IP of primary DNS server',
    'cu_dns_option_description_soa_ttl' => 'Specifies TTL value for SOA settings',
    'cu_dns_option_description_soa_refresh' => 'Specifies Refresh value for SOA settings',
    'cu_dns_option_description_soa_retry' => 'Specifies Retry value for SOA settings',
    'cu_dns_option_description_soa_expire' => 'Specifies Expire value for SOA settings',
    'cu_dns_option_description_soa_minimum' => 'Specifies Minimum value for SOA settings',
    'cu_dns_option_description_soa_serial' => 'Specifies Serial value of SOA record',
    'cu_dns_option_description_soa_rname_admin' => 'Website owner email address for SOA settings',
    'cu_dns_option_description_soa_rname_domain' => 'Domain email address for SOA settings',
    'cu_dns_option_description_soa_rname_external' => 'External email address for SOA settings',
    'cu_dns_option_description_list' => "Specifies a records list for the command 'set'. Record formats for different record types: MX,<subdomain_name>,<mailexchanger_name>,<priority>; NS,<subdomain_name>,<name_server_name>; A,<subdomain_name>,<IP_address>; PTR,<IP_address/subnet_mask>,<subdomain_name>; CNAME,<subdomain_name>,<canonical_domain_name>; TXT,<subdomain_name>,<text>; DS,<subdomain_name>,\"<key-tag> <algorithm> <digest-type> <digest>\"; CAA,<subdomain_name>,<value>,<tag>",
    'cu_dns_option_description_ds' => 'DS resource record',
    'cu_dns_option_description_caa' => 'DNS Certification Authority Authorization (CAA) record',
    'cu_dns_option_description_tag' => 'Tag for CAA record: issue, issuewild or iodef',
    'cu_dns_service_not_supported' => 'The DNS service is not installed.',


    // mail server (new)
    'cu_mailserver__add_to_blacklist' => "Adds a list of addresses to the server black list. Both email addresses and domains can be specified. Wildcards (? and *) are allowed. Separate entries with comma followed by space, for example: mail@example.com, spam?@spamdomain?.*, *domain.com",
    'cu_mailserver__option_action_required' => "'add-to-black-list' command requires '-action' option",
    'cu_mailserver__unable_add_to_black_list' => "Unable to add to the server black list: %1",
    'cu_mailserver__success_add_to_black_list' => "SUCCESS: Addition to the server black list was successful\n",
    'cu_mailserver__remove_from_blacklist' => "Removes a list of addresses from the server black list. Both email addresses and domains can be specified. Wildcards (? and *) are allowed. Separate entries with comma followed by space, for example: mail@example.com, spam?@spamdomain?.*, *domain.com",
    'cu_mailserver__unable_remove_from_black_list' => "Unable to remove from the server black list: %1",
    'cu_mailserver__success_remove_from_black_list' => "SUCCESS: Removal from the black list was successful\n",
    'cu_mailserver__add_to_whitelist' => "Adds a list of addresses to the server white list. Both email addresses and domains can be specified. Wildcards (? and *) are allowed. Separate entries with comma followed by space, for example: mail@example.com, notspam?@notspamdomain?.*, *domain.com, 123.123.123.123/32",
    'cu_mailserver__unable_add_to_white_list' => "Unable to add to the server white list: %1",
    'cu_mailserver__success_add_to_white_list' => "SUCCESS: Addition to the white list was successful\n",
    'cu_mailserver__remove_from_whitelist' => "Removes a list of addresses from the server white list. Both email addresses and domains can be specified. Wildcards (? and *) are allowed. Separate entries with comma followed by space, for example: mail@example.com, notspam?@notspamdomain?.*, *domain.com, 123.123.123.123/32",
    'cu_mailserver__unable_remove_from_white_list' => "Unable to remove from the server white list: %1",
    'cu_mailserver__success_remove_from_white_list' => "SUCCESS: Removal from the server white list was successful\n",
    'cu_mailserver__update_virus_filter' => "Updates antivirus settings.",
    'cu_mailserver__update_virusfilter_options_required' => "'update-virusfilter' command requires '-server-wide' and '-allow-personal' options",
    'cu_mailserver__unable_update_virus_filter' => "Unable to apply antivirus settings: %1",
    'cu_mailserver__success_update_virus_filter' => "SUCCESS: Antivirus settings were applied\n",
    'cu_mailserver__info' => "Displays options or black/white list properties.",
    'cu_mailserver__unable_get_info' => "Unable to get options or black/white list properties: %1",
    'cu_mailserver__unable_set_no_relay_networks' => 'Unable to set networks excluded from relay restrictions: %1',
    'cu_mailserver__action' => "Specifies action for mail messages which satisfy the address pattern. Required for adding an address to the server black list.",
    'cu_mailserver__server_wide' => "Sets server-wide antivirus scanning policy. Required for changing antivirus settings.",
    'cu_mailserver__allow_personal' => "Allows to override antivirus scanning policy for separate mail accounts. Required for changing antivirus settings.",
    'cu_mailserver__excluded_nets' => "Sets networks that should be excluded from relay restrictions. Used with '--set-relay' command.",
    'cu_mailserver__clean_mail_queue' => 'Removes all the messages from the mail queue.',
    'cu_mailserver__command_description_update_smtp_settings' => 'Updates the external SMTP server settings',
    'cu_mailserver__option_description_mail_notifications' => 'Enables Plesk to send email notifications through the specified SMTP server (used with the --update-smtp-settings command)',
    'cu_mailserver__option_description_smtp_host' => 'Sets the host name or IP address of the external SMTP server (used with the --update-smtp-settings command)',
    'cu_mailserver__option_description_smtp_port' => 'Sets the port for the external SMTP server (used with the --update-smtp-settings command)',
    'cu_mailserver__option_description_smtp_login' => 'Sets the username for accessing the external SMTP server (used with the --update-smtp-settings command)',
    'cu_mailserver__option_description_smtp_password' => 'Sets the password for accessing the external SMTP server (used with the --update-smtp-settings command)',
    'cu_mailserver__option_description_smtp_tls' => 'The external SMTP server requires encrypted connections (used with the --update-smtp-settings command)',
    'cu_mailserver__option_description_smtp_allow_users' => 'Allows users\' scripts to send mail through the external SMTP server (used with the --update-smtp-settings command, username and password should be specified)',
    'cu_mailserver__error_msmtp_is_not_installed' => 'Could not update the external SMTP server settings: the MSMTP server must be installed using Plesk Installer.',

    'cu_mailserver__max_connections_courier' => 'The maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS).',
    'cu_mailserver__max_connections_dovecot' => 'The maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS).',
    'cu_mailserver__error_set_max_connections' => 'Unable to update the maximum number of connections: \'%1\'',
    'cu_mailserver__success_set_max_connections' => 'The maximum number of connections was updated.',

    'cu_mailserver__max_connections_per_ip_courier' => 'The maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) per IP address.',
    'cu_mailserver__max_connections_per_ip_dovecot' => 'The maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) per IP address for a specific mail user.',
    'cu_mailserver__error_set_max_connections_per_ip' => 'Unable to update the maximum number of connections per IP address: \'%1\'',
    'cu_mailserver__success_set_max_connections_per_ip' => 'The maximum number of connections per IP address was updated.',

    'cu_mailserver__set_max_connections' => 'Maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS)',
    'cu_mailserver__set_max_connections_per_ip' => 'Maximum number of connections (IMAP, POP3, IMAP over SSL/TLS, or POP3 over SSL/TLS) per IP address (for Courier-IMAP) or per IP address for a specific mail user (for Dovecot)',

    'cu_mailserver__mail_autodiscovery' => 'Mail Autodiscover',
    'cu_mailserver__set_mail_autodiscover' => 'Turns Mail Autodiscover on/off',
    'cu_mailserver__autodiscover_domain_name' => 'Specify a custom domain name for mail autodiscover. Custom domain name can be unset by specifying empty string',
    'cu_mailserver__autodiscover_reconfigure_dns' => 'Reconfigure autodiscover DNS records',
    'cu_mailserver__success_set_mail_autodiscover' => "Mail Autodiscover was switched on/off.\n",
    'cu_mailserver__success_set_mail_autodiscover_domain_name' => "Custom domain name for mail autodiscover was set\n",

    // backup
    'cu__allow_local_backups' => "allows or prohibits subscription data backup and restoration using the Plesk storage",
    'cu__allow_ftp_backups' => 'allows or prohibits subscription data backup and restoration using an FTP storage',
    'cu__allow_account_local_backups' => "allows or prohibits account data backup and restoration using the Plesk storage",
    'cu__allow_account_ftp_backups' => 'allows or prohibits account data backup and restoration using an FTP storage',

    // key info
    'cu_keyinfo_command_description_info' => 'Displays license key property value',
    'cu_keyinfo_command_description_list' => 'Displays the list of license key properties and values',
    'cu_keyinfo_command_description_test_key' => 'Tests whether the license key is suitable for current Plesk version',

    // ODBC DSN connections
    'cu_dsn_command_description_command' => 'Retrieves information about data source name',
    'cu_dsn_command_description_create' => 'Creates data source name',
    'cu_dsn_command_description_help' => 'Displays this help page',
    'cu_dsn_command_description_list' => 'Displays the list of data source names',
    'cu_dsn_command_description_list_types' => 'Displays the list of allowed data source name types',
    'cu_dsn_command_description_remove' => 'Removes data source name',
    'cu_dsn_command_description_update' => 'Updates data source name properties',
    'cu_dsn_command_description_xmlinfo' => 'Retrieves information about data source name in XML format',
    'cu_dsn_option_description_connection_string' => 'Specifies connection string for data source name',
    'cu_dsn_option_description_description' => 'Specifies description for data source name',
    'cu_dsn_option_description_domain' => 'Specifies domain for data source name or domain for the list of data source names',
    'cu_dsn_option_description_name' => 'Specifies data source name',
    'cu_dsn_option_description_server' => 'Displays the list of all data source names registered in Plesk',
    'cu_dsn_option_description_type' => 'Specifies the type of data source names',
    'cu_dsn_command_create_success' => 'SUCCESS: ODBC data source name was created.',
    'cu_dsn_command_update_success' => 'SUCCESS: ODBC data source name was updated.',
    'cu_dsn_command_remove_success' => 'SUCCESS: ODBC data source name was removed.',
    'cu_dsn_unknown_type_of_list' => 'Unknown type of ODBC data source list specified.',

    // Web application registrar
    'cu_siteapp_registrar__command_register' => 'Registers a specified web application installation. Requires XML description of installation, which may be specified directly as a parameter of command, as a filename, or read from STDIN. If "-" is used, it reads XML from STDIN.',
    'cu_siteapp_registrar__option_domain' => 'Specifies domain name where web application will be installed.',
    'cu_siteapp_registrar__option_linked_cbs' => 'Specifies a comma-separated list of linked custom button IDs.',
    'cu_siteapp_registrar__option_linked_dbs' => 'Specifies a comma-separated list of linked database IDs.',
    'cu_siteapp_registrar__option_linked_dbus' => 'Specifies a comma-separated list of linked database user IDs.',
    'cu_siteapp_registrar__option_linked_files_cgi' => 'Registers cgi-bin filelist.',
    'cu_siteapp_registrar__option_linked_files_htdocs' => 'Registers htdocs filelist.',
    'cu_siteapp_registrar__option_linked_license_type' => 'Specifies web application license type',
    'cu_siteapp_registrar__option_subdomain' => 'Specifies full subdomain name where web application will be installed.',
    'cu_siteapp_registrar__register_success' => 'Web application installation was registered',

    // various
    'cu__manage_dashboard' => "Allows or prohibits managing Home page",
    'cu__max_odbc_dsn' => 'Limits the number of ODBC DSN connections',
    'cu_database_registrar__option_db_name' => 'Specifies target database name',
    'cu_database_registrar__option_address' => 'Specifies database server address',
    'cu_database_registrar__option_type' => 'Specifies target database type',
    'cu_apshelper__catalog_download' => 'Download applications from APS Catalog',
    'cu_apshelper__transaction' => 'Download transaction ID',

    // 9.0.1

    'cu_traffic_command_description_add_user' => 'Registers a specific amount of traffic as if already being used by customer/reseller',
    'cu_traffic_command_description_sub_user' => 'Subtracts a specific amount of traffic from the amount registered for customer/reseller',
    'cu_traffic_command_description_add_batch_user' => 'Registers a specific amount of traffic as if already being used by customer/reseller (batch mode)',
    'cu_traffic_command_description_del_user' => 'Resets the amount of traffic registered for this customer/reseller to zero',
    'cu_aps_catalog_install_aps_bundle' => 'Installs specified APS bundle. 1 - Most Popular. 2 - Less Popular. 3 - All',
    'cu_aps_catalog_update_prefs' => 'Updates APS Catalog settings',
    'cu_aps_catalog_apply_bundle_config' => 'Applies custom configuration to applications bundles',
    'cu_aps_catalog_get_bundle_install_progress' => 'Gets current state of installation progress',
    'cu_aps_catalog_info' => 'Displays information about APS Catalog settings',
    'cu_aps_catalog_help' => 'Displays this help page',
    'cu_aps_catalog_url' => "APS Catalog URL\n",
    'cu_aps_catalog_success_prefs_update' => "APS Catalog settings were updated\n",
    'cu_aps_catalog_success_bundle_install' => "APS bundle installation was started\n",
    'cu_aps_catalog_success_conf_apply' => "Custom configuration was applied\n",
    'cu_aps_catalog_errmes_file_not_found' => "File not found\n",
    'cu_aps_catalog_errmes_unable_to_use_config_file' => "Unable to use specified file as the configuration file\n",
    'cu_aps_catalog_message_no_install' => "There is no installation task at the moment\n",
    'cu_aps_catalog_message_finish_install' =>    "Current installation task is finished\n",
    'cu_aps_catalog_message_install_progress' =>    "Progress of installation:\n",
    'cu_aps_catalog_message_aps_catalog' => "APS application catalog information:\n\n",
    'cu_aps_catalog_message_total' => "Total:%1\n",
    'cu_aps_catalog_message_completed' => "Completed:%1\n",
    'cu_aps_catalog_message_package' => "Package:%1\n",
    'cu_aps_catalog_errmes_error_occured' => "An error occurred during the updating of APS catalog settings:%1\n",
    'cu_aps_catalog_message_address' => "APS catalog address:%1\n",

    // 9.2
    'cu_serverpref__option_description_low_priority' => "Sets the option to run scheduled backup processes with low priority",
    'cu_serverpref__option_description_do_not_compress' => "Sets the option to not compress backup files",
    'cu_serverpref__option_description_max_backup_processes' => "Sets maximum number of simultaneously running scheduled backup processes",
    'cu_serverpref__option_description_max_backup_files' => "Sets the maximum number of backup files to store",
    'cu_serverpref__option_description_keep_local_backup' => 'Saves backups in the server storage if the upload to FTP fails.',
    'cu_servpref__set_ftp_passive_port_range' => 'Sets port or port range for passive FTP mode connections',
    'cu_servpref__set_iis_app_pool_settings' => 'Sets IIS application pool settings',
    'cu_serverpref__option_description_iis_app_pool_mode' => 'IIS Application pool assignment and placement policy',
    'cu_serverpref__option_description_cpu_usage_state' => 'Switches on/off IIS application pool CPU usage monitoring',
    'cu_serverpref__option_description_cpu_usage_value' => 'IIS Application pool maximum CPU use (%)',
    'cu_resellerpref__option_lock_screen' => 'Prevents users from working with Plesk until interface screens are completely loaded',

    'cu_domain__set_iis_app_pool_settings' => 'Sets IIS application pool settings',
    'cu_domain__iis_app_pool_turned_on' => 'Turns on/off IIS application pool',
    'cu_domain__cpu_usage_state' => 'Switches on/off IIS application pool CPU usage monitoring',
    'cu_domain__cpu_usage_value' => 'IIS Application pool maximum CPU use (%)',

    'cu_cl_pref__set_iis_app_pool_settings' => 'Sets IIS application pool settings',
    'cu_cl_pref__option_description_iis_app_pool_turned_on' => 'Turns on/off IIS application pool',
    'cu_cl_pref__option_description_cpu_usage_state' => 'Switches on/off IIS application pool CPU usage monitoring',
    'cu_cl_pref__option_description_cpu_usage_value' => 'IIS Application pool maximum CPU use (%)',

    'cu_dns_option_description_axfr' => "Specifies IP address for creating AXFR record",

    //Additional FTP Accounts (ftpsubaccount utility)

    'cu__help' => 'Displays this help page.',
    'cu_ftpuser__create' => "Creates additional FTP account",
    'cu_ftpuser__update' => "Updates additional FTP account",
    'cu_ftpuser__remove' => "Deletes additional FTP account",
    'cu_ftpuser__info' => "Gets FTP account information",
    'cu_ftpuser__login' => "Sets FTP account login name",
    'cu_ftpuser__passwd' => "Sets FTP account password (required for creation)",
    'cu_ftpuser__passwd_type' => "Defines password type (default: plain) [see the note below for details]",
    'cu_ftpuser__home' => "Sets the Home directory path (default: %1)",
    'cu_ftpuser__perm_read' => "Sets Read permission (default: %1)",
    'cu_ftpuser__perm_write' => "Sets Write permission (default: %1)",
    'cu_ftpuser__unable_create' => "Unable to create FTP account: %1",
    'cu_ftpuser__success_create' => "SUCCESS: Creation of FTP account '%1' completed.\n",
    'cu_ftpuser__unable_update' => "Unable to update FTP account settings: %1",
    'cu_ftpuser__success_update' => "SUCCESS: Update of FTP account '%1' completed.\n",
    'cu_ftpuser__unable_remove' => "Unable to remove FTP account: %1",
    'cu_ftpuser__success_remove' => "SUCCESS: Removal of FTP account '%1' completed.\n",
    'cu_ftpuser__unable_info' => "An error occurred while getting FTP account information: %1",
    'cu_ftpuser__user_not_exist' => "FTP account does not exist",
    'cu_fpseuser__domain' => "Sets domain name (required for creation)",
    'cu__success_info' => "\nSUCCESS: Gathering information for '%1' completed.\n",

    // cuAddonDomainTemplate
    'cu_dom_addon_tpl__owner_not_exist' => "The owner with username %1 does not exist",
    'cu_dom_addon_tpl__unable_update_webmail' => "Can't set webmail: there are no supported webmail components\n",
    'cu_dom_addon_tpl__only_one_lr_condition' => "You can specify only one log rotation condition",
    'cu_dom_addon_tpl__wrong_opt_parameter' => "Wrong syntax for option\'s '%1' parameter",
    'cu_dom_addon_tpl__no_usr' => "Specify what to do with mail to non-existent users: bounce, catch all, or discard.",
    'cu_dom_addon_tpl__maillist' => "Allow or prohibit mailing lists (default: %1)",
    'cu_dom_addon_tpl__wuscripts' => "Switches on scripting support for web users (default: %1)",
    'cu_dom_addon_tpl__hosting' => "Switch physical hosting on or off (default: %1)",
    'cu_dom_addon_tpl__webstat_protdir' => "Allow or prohibit access to web statistics through the /plesk-stat/ protected directory (default: %1)",
    'cu_dom_addon_tpl__dns_zone_type' => "Specify whether the Plesk's DNS server should act as master or slave for domain's DNS zone (default: %1)",
    'cu_dom_addon_tpl__bandwidth' => "Specify maximum network use (-1 for unlimited)",
    'cu_dom_addon_tpl__max_connections' => "Limit the number of simultaneous web connections (-1 for unlimited)",
    'cu_dom_addon_tpl__log_max_num' => "Define the maximum number of log file instances",


    'cu_domain__unable_set_subscription' => 'Unable to set specified service plans',
    'cu_domain__suc_set_subscription' => 'SUCCESS: All service plans are successfully set',

    //// Plesk 10 CU updates
    'cu_domain__www_root' => 'Website home directory (default value is /httpdocs)',

    'cu_res_suc_subscription_locked' => 'The reseller subscription of %1 was locked.',
    'cu_res_suc_subscription_unlocked' => 'The reseller subscription of %1 was unlocked.',
    'cu_res_suc_unsubscribed' => 'Reseller %1 was unsubscribed from the service plan.',
    'cu_res_suc_subscribed' => 'Reseller %1 is subscribed to the service plan %2.',
    'cu_res__unable_subscribe' => "Unable to subscribe the reseller to the service plan: %1",
    'cu_res__unable_sync' => "Unable to synchronize reseller subscription with service plan: %1",
    'cu_res_suc_synced' => 'Reseller subscription %1 was synchronized with the service plan.',

    'cu__force_lock' => 'Forces creating the subscription even if the actual system state does not correspond to the service plan properties. This will create the subscription and lock it for syncing.',
    'cu__force_lock_conflict' => 'options -force and -force-lock cannot be specified together.',
    'cu_res_pref_info_not_subscribed' => 'The reseller is not subscribed to any service plan.',
    'cu_res_pref_info_subscribed' => 'The reseller is subscribed to service plan "%1".',

    'cu_domain__lock_subscription' => "Locks the subscription for syncing, the subscription properties will not change when an associated plan is modified.",
    'cu_domain__unlock_subscription' => "Unlocks the subscription and enables synchronization with the associated service plans.",
    'cu_domain__unsubscribe' => "Unbinds the subscription from the associated service plans and makes it custom.",
    'cu_domain__subscribe' => 'Associates the subscription with the specified hosting plan.',
    'cu_domain__subscribe_addon' => 'Associates the subscription with the specified hosting plan add-on.',
    'cu_domain__unsubscribe_addon' => 'Removes the subscription association with the specified hosting plan add-on.',

    'cu_domain__suc_subscription_locked' => "The subscription %1 was locked.",
    'cu_domain__suc_subscription_unlocked' => "The subscription %1 was unlocked.",
    'cu_domain__suc_unsubscribed' => 'The subscription %1 association with the service plan was removed.',
    'cu_domain__suc_subscribed' => 'The subscription %1 is now associated with the service plan %2.',

    'cu_domain__not_subscribed' => 'The subscription %1 is not associated with any service plan.',
    'cu_domain__unable_subscribe' => "Unable to associate the subscription with the service plan: %1.",
    'cu_domain__unable_unsubscribe' => "Unable to remove the subscription association with the service plans: %1.",
    'cu_domain__unable_sync' => "Unable to synchronize the subscription with service plans: %1.",
    'cu_domain__suc_sync' => 'Subscription %1 was synchronized with the associated service plans.',
    'cu_domain__sync' => 'Synchronizes a subscription with the associated plans.',

    'cu_domain__wrong_utility' => 'Specified domain is the %1. Use utility %1 for removing',

    'cu_domain__display_available_shells' => 'Displays the list of available system shells.',
    'cu_domain__parent_domain_name' => 'Use to specify the parent domain when creating a subdomain',
    'cu_domain__shell_unix' => 'The shell that a subscriber can use for SSH access to the server. Use the --shells command to see available shells',
    'cu_domain__webstat_protdir_access' => 'Allows accessing web statistics through the password protected directory "/plesk-stat/" (default: %1)',
    'cu_domain__iis_web_hosting_required' => 'This operation is available only for domains managed by IIS.',
    'cu_domain__web_hosting_required' => 'Web hosting is not configured on this domain. This operation is available only for domains with web hosting.',

    'cu_dom_tpl__force_permissions' => 'Ignore subscribed domain owner account permissions',
    'cu_dom__info_not_subscribed' => 'The domain is not subscribed to a service plan.',
    'cu_dom__info_subscribed' => 'The domain is subscribed to the service plan "%1" of %2.',

    'cu__subscription_locked' => 'The subscription is locked for syncing.',
    'cu__subscription_not_locked' => 'The subscription is not locked for syncing.',
    'cu__subscription_locked_warning' => 'WARNING: The subscription was locked for syncing.',

    'cu_domain__subscription_problems_not_applied_list' => 'The following subscription properties are editable by the subscriber and, therefore, are not applied:',

    'cu_res__subscription_problems_not_applied_list' => 'The following susbcription properties are editable by reseller and, therefore, are not applied:',
    'cu_res__info_not_subscribed' => 'The reseller is not subscribed to a service plan.',
    'cu_res__info_subscribed' => 'The reseller is subscribed to the service plan "%1" of %2.',

    'cu_cl__info_not_subscribed' => 'The customer has no subscriptions.',
    'cu_cl__info_subsription_not_locked' => 'The customer has the subscription "%1" associated with the service plan "%2".',
    'cu_cl__info_subsription_locked' => 'The customer has the locked subscription "%1" associated with the service plan "%2".',
    'cu_cl__plan_custom' => 'Custom',

    'cu__warning' => 'WARNING: %1',
    'cu_dom_tpl__unable_apply_opt_without_hosting' => 'Unable to apply the "-%1" option without web hosting.',

    'cu_domain__vendor' => 'Specifies the login of the subscription provider - an existing user (admin or reseller) whose resources will be used.',
    'cu_domain__invalid_vendor' => 'The user "%1" cannot be a provider.',

    'cu_common__www_root' => 'Specifies website home directory (relative to the subscription root).',
    'cu_domain__webspace_name' => 'Specifies the name of the target subscription (the same as the name of the main domain in the subscription).',
    'cu_domain__webspace_name_powerUser' => 'Specifies the name of the target subscription (the same as the name of the main domain in the subscription).',

    'cu__webspace_not_exist' => 'Subscription with name %1 does not exist.',
    'cu__webspace_addon_domain_vendor_conflict' => 'options -webspace-name and -vendor cannot be specified together.',
    'cu__webspace_addon_domain_owner_conflict' => 'options -webspace-name and -owner cannot be specified together.',
    'cu__webspace_addon_domain_template_conflict' => 'options -webspace-name and -service-plan cannot be specified together.',
    'cu__webspace_addon_domain_external_id_conflict' => 'options -webspace-name and -external-id cannot be specified together.',
    'cu__webspace_without_physical_hosting' => "The specified subscription is not used for website hosting.",
    'cu_domain__unable_set_webspace' => 'Unable to set a subscription: %1.',

    'cu_ftpuser__system_area' => 'Creates an FTP account in the system area.',


    'cu__max_site' => 'Limits the number of sites (-1 for unlimited) that can be hosted.',
    'cu__webspace_option_only' => 'The following option is applicable to subscriptions only: %1',

    'cu_res_tpl__create' => 'Creates a reseller plan.',
    'cu_res_tpl__update' => 'Updates an existing reseller plan.',
    'cu_res_tpl__remove' => 'Removes a reseller plan.',
    'cu_res_tpl__info' => 'Shows information about a reseller plan.',
    'cu_res_tpl__xml_info' => 'Retrieves information about a reseller plan in the XML format.',
    'cu_res_tpl__new_name' => 'Renames a reseller plan.',

    'cu_domain__unable_apply_template' => 'unable to apply service plan: %1',
    'cu_domain__template' => 'Specifies service plan for subscription creation (can be used only with the "--create" or "--*-subsription" command).',
    'cu_domain__force' => 'Forces creating subscription to the specified hosting plan even if the actual system state does not correspond to the plan properties.',

    'cu_cl_tpl__template_not_exist' => "service plan does not exist",
    'cu_cl_tpl__template_already_exist' => "service plan with name '%1' already exists",

    'cu_dom_tpl__create' => "Creates a hosting plan.",
    'cu_dom_tpl__duplicate' => "Duplicates a hosting plan by making its copy with the name specified in the '-duplicate-name' option.",
    'cu_dom_tpl__update' => "Updates an existing hosting plan.",
    'cu_dom_tpl__remove' => "Removes a hosting plan.",
    'cu_dom_tpl__info' => "Displays information about a hosting plan.",
    'cu_dom_tpl__new_name' => "Renames a hosting plan.",
    'cu_dom_tpl__duplicate_name' => "Sets the name of the copy of the specified hosting plan.",
    'cu_dom_tpl__webstat_protdir' => "Allows or prohibits access to web statistics through the /plesk-stat/ protected directory (default: %1).",
    'cu_dom_tpl__dns_zone_type' => "Specifies whether the Plesk's DNS server should act as master or slave for the domains' DNS zones (default: %1).",

    'cu_dom_tpl__unable_create' => "Unable to create a hosting plan: %1",
    'cu_dom_tpl__success_create' => "The hosting plan '%1' was successfully created.\n",
    'cu_dom_tpl__unable_duplicate' => "Unable to duplicate the hosting plan: %1",
    'cu_dom_tpl__success_duplicate' => "The hosting plan '%1' was successfully duplicated.\n",
    'cu_dom_tpl__unable_update' => "Unable to update the hosting plan: %1",
    'cu_dom_tpl__success_update' => "The hosting plan '%1' was successfully updated.\n",
    'cu_dom_tpl__unable_remove' => "Unable to remove the hosting plan: %1",
    'cu_dom_tpl__success_remove' => "The hosting plan '%1' was successfully removed.\n",
    'cu_dom_tpl__unable_info' => "An error occurred while getting the hosting plan information: %1",
    'cu_res_tpl__unable_create' => "Unable to create a reseller plan: %1",
    'cu_res_tpl__success_create' => "The reseller plan '%1' was successfully created.\n",
    'cu_res_tpl__unable_update' => "Unable to update the reseller plan: %1",
    'cu_res_tpl__success_update' => "The reseller plan '%1' was successfully updated.\n",
    'cu_res_tpl__success_duplicate' => "The reseller plan '%1' was successfully duplicated.\n",
    'cu_res_tpl__unable_duplicate' => "Unable to duplicate the reseller plan: %1",
    'cu_res_tpl__unable_remove' => "Unable to remove the reseller plan: %1",
    'cu_res_tpl__success_remove' => "The reseller plan '%1' was successfully removed.\n",
    'cu_res_tpl__unable_info' => "An error occurred while getting the reseller plan information: %1",
    'cu_res_tpl__create_default' => 'Creates a default reseller plan.',
    'cu_dom_tpl__create_default' => 'Creates a default hosting plan.',
    'cu_dom_addon_tpl__create' => "Creates a hosting plan add-on.",
    'cu_dom_addon_tpl__update' => "Updates a hosting plan add-on.",
    'cu_dom_addon_tpl__remove' => "Removes a hosting plan add-on.",
    'cu_dom_addon_tpl__info' => "Displays information on the specified add-on.",
    'cu_dom_addon_tpl__xml_info' => "Retrieves information on the specified add-on in XML format.",
    'cu_dom_addon_tpl__success_create' => "The hosting plan add-on '%1' was successfully created.\n",
    'cu_dom_addon_tpl__success_update' => "The hosting plan add-on '%1' was successfully updated.\n",
    'cu_dom_addon_tpl__success_duplicate' => "The hosting plan add-on '%1' was successfully duplicated.\n",
    'cu_dom_addon_tpl__success_remove' => "The hosting plan add-on '%1' was successfully removed.\n",
    'cu_dom_addon_tpl__unable_duplicate' => "Unable to duplicate the hosting plan add-on: %1",
    'cu_dom_addon_tpl__unable_xml_info' => "Unable to create XML description of the hosting plan add-on.",
    'cu_dom_addon_tpl__unable_create' => "Unable to create the hosting plan add-on: %1",
    'cu_dom_addon_tpl__new_name' => "Renames a hosting plan add-on.",
    'cu__owner_not_reseller_or_admin' => "The owner of a hosting plan must be a reseller or administrator, but the specified owner '%1' is a customer.",

    'cu_domain__status_still_off_with_parent' => 'The domain is suspended because the subscription is still suspended.',
    'cu_mail__invalid_autoresponder_frequency' => 'Invalid value for the maximum number of responses to a unique email address per day.',
    'cu_mail__unable_switch_mailgroup_on' => 'Cannot switch on mailgroup: no mailgroup users.', // already exists in PfW

    'cu_server_dns_option_description_recursion' => 'Allows recursive DNS queries for any hosts, for hosts from local network, or for none. Required for the "update-server" command.', // PfW has 3 recursion states: 'on' - any host, 'local' - local nets and 'off' - none.
    'cu__pre10converter_source' => 'Path to the source XML file.',
    'cu__pre10converter_destination' => 'Path to the destination directory.',
    'cu__pre10converter_convert' => 'Convert dump to the Plesk 11 format.',
    'cu_cl_pref__manage_php_settings' => 'Common PHP settings management.',
    'cu_cl_pref__manage_php_version' => 'PHP version and handler management.',
    'cu_cl_pref__manage_not_chroot_shell' => 'Non-chrooted shell management.',
    'cu_cl_pref__manage_anonftp' => 'Anonymous FTP management.',
    'cu_cl_pref__remote_access_interface' => 'Remote access interface management.',

    'cu_do_not_use_obsolete_utility' => 'Please do not use this utility. It is intended only for internal use by Plesk.',

    //// Password Strength at Mail Acc

    'cmd_mail__mail_passwd_incorrect' => "\n This password is not strong enough according to the server security policy. Improve the password strength by using numbers, upper and lower-case characters, and special characters !,@,#,$,%,^,&,*,?,_,~",
    'cmd_mail__mail_use_vocab_info_description' => "Minimum password strength",
    'cu_mailserver__use_vocabulary' => 'Sets the requirement for the minimum password strength.',
    'cu_mailserver__unable_use_vocabulary' => "Unable to set the minimum password strength: %1",
    'cu_mailserver__success_use_vocabulary' => "The minimum password strength option was successfully set.\n",

    ///repair configuration utility

    'cu_panel__repair_run' => 'Restores configuration files of web, mail and DNS servers.',
    'cu_panel__repair_run_success' => 'The configuration files were successfully restored.',
    'cu_panel__repair_run_failed' => 'Failed to fully restore the configuration files.',
    'cu_panel__repair_run_mail' => 'Restoring mail server configuration...',
    'cu_panel__repair_run_web' => 'Restoring web server configuration...',
    'cu_panel__repair_run_dns' => 'Restoring DNS server configuration...',
    'cu_panel__repair_run_dns_sync_zones_confirm' => 'Synchronize DNS zones with the DNS server?',
    'cu_panel__repair_run_dns_sync_zones_in_progress' => 'Synchronizing DNS zones with the DNS server',
    'cu_panel__repair_run_dns_sync_zones_error' => "Unable to sync DNS zones for domain '%1': %2",
    'cu_panel__repair_run_dns_conf' => 'Checking the DNS configuration file',
    'cu_panel__repair_run_dns_conf_absent' => 'The NS configuration file \'%1\' is absent.',
    'cu_panel__repair_run_dns_restore_conf_confirm' => 'Restore the DNS configuration file from \'%1\'?',
    'cu_panel__repair_run_dns_restore_conf_in_progress' => 'Restoring the DNS configuration file \'%1\'',
    'cu_repair__command_description_update_vhost_structure_unix' => "Updates the structure of the home directory on each virtual host on the specified service node and updates virtual hosts configuration on all service nodes. To skip reconfiguration of virtual hosts, use the -no-reconfigure option. To reconfigure virtual hosts on all nodes at once, run the command without the -service-node option.",
    'cu_repair__success_update_vhosts_structure' => "The structure of the home directory was successfully updated on virtual hosts.\n",
    'cu_repair__service_node_not_found' => 'Unable to find the specified service node.',
    'cu_repair__error_update_vhosts_structure' => 'Unable to update the structure of the home directory: an unexpected error has occurred.',
    'cu_repair__option_description_no_reconfigure' => 'Skips virtual hosts reconfiguration when executing the --update-vhosts-structure command.',

    'cu_repair__command_description_restore_vhost_permissions' => 'Restores the default permissions for the virtual host directories on the specified service node. If no service node was specified, the management node will be used.',
    'cu_repair__success_restore_vhosts_permissions' => "Directory permissions were successfully updated.\n",
    'cu_repair__error_restore_vhosts_permissions' => 'Unable to update directory permissions: an unexpected error has occurred.',

    'cu_repair__command_description_convert_mailboxes_to_lowercase' => 'Converts mail account names to lowercase on the specified service node. If no service node was specified, the management node is used. To skip execution of the mchk utility, use the -no-mchk option.',
    'cu_repair__option_description_no_mchk' => 'Skips execution of the mchk utility when executing the --convert-mailboxes-to-lowercase command.',
    'cu_repair__failed_mchk' => 'Failed to restore the mail server configuration. Please run /usr/local/psa/admin/sbin/mchk manually.',

    'cu__documentRootHintDisabledDueApplications' => 'Unable to change the document root directory because there are web applications installed on the website.',

    //cli power user
    'cu_poweruser__turn_on_power_mode' => 'Enables Power User View',
    'cu_poweruser__turn_off_power_mode' => 'Disables Power User View',
    'cu_poweruser__set_power_mode' => 'Enables Restricted Mode',

    /// cli for business logic upgrade

    'cu_blupgrade_subscriptions_list' => 'Returns a list of subscriptions that need to undergo transition to fit in the new business model.',
    'cu_blupgrade_customers_list' => 'Returns a list of customers that need to undergo transition to fit in the new business model.',
    'cu_blupgrade_apply_solution' => 'Transitions customers or subscriptions to the new model using the specified transition scheme.',
    'cu_blupgrade_detect_targets' => 'Detects business model objects that need to undergo a transition.',
    'cu_blupgrade__no_targets_found' => "SUCCESS: Switching to the new business model is complete, no additional transitions are required.\n",
    'cu_blupgrade__targets_found' => "WARNING: It is required to complete switching to the new business model, there are customers or subscriptions that need a transition.\n",
    'cu_blupgrade__success' => "SUCCESS: The objects were successfully transitioned.\n",

    ///// VPS-Optimized
    'cu__vps_optimized_default_aspects_help' => 'If an aspect is not specified, the default set of aspects will be used.',
    'cu__vps_optimized_default_aspects_list' => 'The following can be specified as an aspect:',
    'cu__vps_optimized_aspect_status' => 'VPS Optimized %1: %2',
    'cu__vps_optimized_status' => 'Gets status of the VPS-optimized mode settings',
    'cu__vps_optimized_turn_on' => 'Enables the VPS-optimized mode for the specified aspect',
    'cu__vps_optimized_turn_off' => 'Disables the VPS-optimized mode for the specified aspect',
    'cu__vps_optimized_aspect' => 'Specifies aspects to be affected. See a list of available aspects below',
    'cu_option__wrong_vps_optimized_aspect' => 'The specified aspect of VPS-optimized mode is incorrect: %1',
    'vps_optimized__configuration_not_allowed__init_conf' => 'Configuring of VPS-optimized mode is not possible now. You can configure VPS-optimized mode only before initial configuration of new Plesk instances.',

    ///Pre 10 Converter
    'cu__pre10converter_destination_does_not_exist' => 'Destination directory %1 does not exist.',
    'cu__pre10converter_destination_is_not_readable' => 'Destination directory %1 is not accessible.',
    'cu__pre10converter_destination_is_file' => 'Destination %1 should be a directory.',
    'cu__pre10converter_source_does_not_exist' => 'Source file %1 does not exist.',
    'cu__pre10converter_source_is_not_readable' => 'Source file %1 is not accessible.',
    'cu__pre10converter_source_is_not_file' => 'Source %1 should be a file.',



    //cli
    'gch__hosting_php_safe_mode' => 'PHP safe mode',

    'sfdk_domain_sign__private_generation_failed' => 'Generating SSL/TLS certificate for DKIM failed.',

    'cu_common__maintenance_mode' => 'Turns on/off the maintenance mode.',

    // cuSecretKey
    'cu__secret_key_create' => 'Creates a secret key.',
    'cu__secret_key_list_keys' => 'Prints a list of existing secret keys.',
    'cu__secret_key_ip_address' => 'IP address',
    'cu__secret_key_description' => 'Description',
    'cu__secret_key_delete' => 'Removes specified key.',
    'cu__secret_key_key' => 'Secret key',

    'cu__site_copy_helper_task_started' => 'Copying the website %1 to %2. You will be notified of the progress by email (%3).',

    'cu_server_dns_option_description_srv' => 'SRV resource record',
    'cu_server_dns_option_description_srv_priority' => 'Specifies priority for SRV record.',
    'cu_server_dns_option_description_srv_weight' => 'Specifies a relative weight for SRV records with the same priority.',
    'cu_server_dns_option_description_srv_port' => 'Specifies a target port for SRV record.',
    'cu_server_dns_option_description_srv_target_host' => 'Specifies a target host for SRV record.',
    'cu_server_dns_option_description_srv_protocol' => 'Specifies a protocol for SRV record.',
    'cu_server_dns_option_description_srv_service' => 'Specifies a service for SRV record.',

    'cu_server_dns_option_description_caa_tag' => 'Tag for CAA record: issue, issuewild or iodef',

    'cu_add_aps_filter_info_absent' => 'APS applications filter is not set up.',
    'cu_add_aps_filter_info_filter_items' => 'APS applications filter items',
    'cu_add_aps_filter_info_filter_item_name_value' => 'Item identifier: %1 Value: %2',
    'cu_add_aps_filter_item' => 'Adds an APS applications filter item.',
    'cu_remove_aps_filter_item' => 'Removes an APS applications filter item.',
    'cu_show_aps_filter_info' => 'Shows information on the active APS applications filter.',
    'cu_aps_filter_item_name' => 'Specifies identifier of APS applications filter item: whether the filtered app is identified by name or URI.',
    'cu_aps_filter_item_value' => 'Specifies the actual name or URI of the filtered APS app.',
    'cu_disable_aps_filter' => 'Disables the APS applications filter and removes all its items.',
    'cu_enable_aps_filter' => 'Enables the APS applications filter for the specified hosting plan or subscription.',
    'cu_aps_filter_unable_to_update_disabled_list' => 'APS applications filter is disabled, it is impossible to add a filter item to a disabled filter.',
    'cu_add_aps_filter_info_filter_disabled' => 'APS applications filter is disabled.',

    'cu_custom_plan_items__add' => 'Adds a hosting plan item for an additional service.',
    'cu_custom_plan_items__update' => 'Updates a service plan item.',
    'cu_custom_plan_items__remove' => 'Removes a service plan item.',
    'cu_custom_plan_items__list' => 'Shows a list of service plan items.',
    'cu_custom_plan_items__item_uuid' => 'Service plan item UUID.',
    'cu_custom_plan_items__item_visible' => 'Service plan item visibility.',
    'cu_custom_plan_items__item_url' => 'Service URL.',
    'cu_custom_plan_items__item_label' => 'Service button label.',
    'cu_custom_plan_items__item_tooltip' => 'Text of the service button tooltip.',
    'cu_custom_plan_items__item_image' => 'Background image of the service button.',
    'cu_custom_plan_items__list_title' => 'A list of plan items for additional services:',
    'cu_custom_plan_items__list_item' => 'Custom plan item.',
    'cu_custom_plan_items__list_item_name' => 'Item name: %1',
    'cu_custom_plan_items__list_item_class_name' => 'Item class name: %1',
    'cu_custom_plan_items__list_item_description' => 'Item description: %1',
    'cu_custom_plan_items__list_item_hint' => 'Item hint: %1',
    'cu_custom_plan_items__list_item_uuid' => 'Item UUID: %1',
    'cu_custom_plan_items__list_item_visible' => 'Item visibility: %1',
    'cu_custom_plan_items__list_item_url' => 'Item URL: %1',
    'cu_custom_plan_items__list_item_image' => 'Item image: %1',
    'cu_custom_plan_items__list_item_internal' => 'Custom button opens in the same browser window.',
    'cu_custom_plan_items__list_item_url_components' => 'Item URL components: %1',
    'cu_custom_plan_items__list_item__class_name' => 'Item class name: %1',
    'cu_custom_plan_items__item_url_components' => 'Components that should be included in URL of the custom button.',
    'cu_custom_plan_items__err_name_already_exists' => 'Custom plan item with name %1 already exists.',
    'cu_custom_plan_items__err_uuid_already_exists' => 'Custom plan item with UUID %1 already exists.',
    'cu_custom_plan_items__err_not_found' => 'Custom plan item with name %1 does not exist.',
    'cu_custom_plan_items__err_not_editable' => 'Custom plan item with name %1 is not editable.',

    'cu_add_custom_plan_item' => 'Adds a hosting plan item for an additional service.',
    'cu_remove_custom_plan_item' => 'Removes a service plan item.',
    'cu_remove_all_custom_plan_items' => 'Removes all service plan items.',
    'cu_show_custom_plan_items' => 'Shows a list of service plan items.',
    'cu_custom_plan_item_name' => 'Service plan item name.',
    'cu_custom_plan_items' => 'Allowed items:',
    'cu_custom_plan_item' => 'Item name: %1',

    'cu_mail__disable_mail_ui' => 'Hide all mail-related controls in Customer Panel.',

    'cu_domain__certificate_name' => 'SSL/TLS certificate name',
    'cu_subdomain__certificate_name' => 'SSL/TLS certificate name',
    'cu_domain__ip_list' => 'Sets list of IPv4 and IPv6 addresses.',
    'cu_domain__wrong_ip_list' => 'You can specify only one IPv4 and one IPv6 address.',

    'cu_dns_option_description_aaaa' => 'AAAA resource record',
    'cu_server_dns_option_description_aaaa' => 'AAAA resource record',
    'cu_domain__ftp_ipv6_not_supported' => 'FTP server does not support IPv6 addresses.',
    'cu__pre10converter_non_xml_dump' => "Backup format conversion failed. Unable to load the XML file %1.%2 Check that the file does not contain invalid characters and it matches conventions for XML documents.\nCorrect any XML mistakes and try uploading the file again. If you supplied an archive file containing a backup from Plesk version 9 or later, then extract the contents of this archive, and process the extracted XML file with the converter.",
    'cu__pre10converter_error_at_line' => " Error at line %1.",
    'cu_res_tpl__excl_ipv6_num' => 'Number of dedicated IPv6 addresses to allocate to the reseller',

    'cu_initconf__passwd_encrypted' => 'Forces Plesk to store the Plesk administrator\'s password in the encrypted form.',
    'cu_initconf__passwd_plain' => 'Forces Plesk to store the Plesk administrator\'s password in plain text.',

    'cu_domain__map_ip' => 'Specifies new IP addresses that should be assigned to a subscription after a subscriber is changed.',

    'cu__php_not_installed' => 'PHP %1 is not installed.',
    'cu__pre10converter_validate' => 'Validate the resulting backup file after conversion.',
    'cu__pre10converter_validation_success' => 'The resulting backup file is valid.',
    'cu__pre10converter_validation_invalid_dump' => 'The resulting backup file is not valid.',
    'cu__pre10converter_convert_done' => 'Conversion finished.',
    'cu__pre10converter_verbose' => 'Show information about backup conversion. Even if you do not use this option, you can still view the conversion report in the following file: %1',
    'cu__pre10converter_dump_is_archive' => "The converter expects an XML source file, but an archive file was specified.\nIf you are sure that this archive file contains a backup from Plesk version 9 or later, then extract the contents of this archive, and process the extracted XML file with the converter.",
    'cu_aps_install' => 'Installs an application on a website. Installation of an application on a site requires that you specify installation settings by providing them in an XML file. You can generate this file by issuing the command "--get-install-settings-template", and then specify the path to it with the "--install <file name>". You can also input these settings from stdin by using "-" instead of file name.',
    'cu_aps_get_install_settings_template' => 'Creates a settings template for installing applications with the "--install" command. To save the template to a file, use the command "--get-install-settings-template <file name>". If you want to output the generated template to the screen, use the "--get-install-settings-template -" command.',
    'cu_aps_get_install_settings_template__finished' => 'The settings template was created.',
    'cu_aps_update_package' => 'Changes settings for an APS package in the Application Vault.',
    'cu_aps_update_package__finished' => 'The APS package settings were changed.',
    'cu_aps_visible' => 'Specifies whether an APS package must be available to customers.',
    'cu_aps_error__package_does_not_exist' => 'The APS package you specified is not present in the Application Vault.',
    'cu_aps_clear_cache' => 'Clears the Application Vault cache.',
    'cu_aps_clear_cache__finished' => 'The Application Vault cache was cleared.',
    'cu_aps_reconfigure_failed' => 'An error occurred during reconfiguration of applications.',
    'cu_license_key_expired' => "The specified key is expired and cannot be imported.",
    'cu_license_install_product_consent' => 'I authorize Plesk to collect, store, process, and use my personal data (name and email), including cross-border processing, in accordance with the applicable data protection laws currently in effect, for issuing my license as a part of a licensing contract between me and Plesk company.',

    'cu_service_node_operation_success' => "The operation was successfully completed.\n",
    'cu_service_node_name_not_registered' => 'Unable to find a service node with the specified name.',
    'cu_service_node_command_description_add' => 'Register a new service node.',
    'cu_service_node_command_description_update' => 'Update service node properties.',
    'cu_service_node_command_description_help' => 'Display this help page.',
    'cu_service_node_command_description_register_ip' => 'Register an IP address. If the option "-interface" is not provided, the IP address will be created on the service node.',
    'cu_service_node_option_description_remote_ip_address' => 'Remote IP address',
    'cu_service_node_option_description_transport' => 'Transport type',
    'cu_service_node_remote_ip_address_undefined' => 'The remote IP address was not specified.',
    'cu_service_node_access_key_not_specified' => 'Specify either \'-access-key\' or \'-no-access-key\'.',
    'cu_service_node_command_description_list' => 'Display the list of registered service nodes.',
    'cu_service_node_option_description_access_key' => 'Password for authentication with an agent.',
    'cu_service_node_option_description_no_access_key' => 'Do not use authentication with an agent.',
    'cu_service_node_option_description_external_id' => 'Only for use with the --add command.  If specified, the external ID will be assigned to the service node.',

    'cu_service__service_nodes_not_found' => 'Unable to find service nodes with the following IP addresses: %1.',

    'cu_registration_service_node_successfully' => "The service node '%1' was successfully registered.",
    'cu_updating_service_node_successfully' => "The service node '%1' was successfully updated.",
    'cu_removing_service_node_successfully' => "The service node '%1' was successfully removed.",
    'cu_registration_ip_to_service_node_successfully' => "The IP address was successfully registered.",

    'cu__parent_domain_is_subdomain' => 'The parent domain does not exist.',
    'cu__parent_domain_without_physical_hosting' => 'The specified parent domain is not used for website hosting.',

    'cu_poweruser__switch_simple_mode' => 'Use this option to limit the number of actions the administrator can take in the Plesk Panel. The actions availability is set up in Tools & Settings > Restricted Mode Settings',
    'cu_poweruser__lock_simple_mode' => 'If true, the administrator cannot disable Restricted Mode via the Plesk interface.',
    'cu_serverpref__option_description_preview_domain' => 'The domain name for the site preview function. Your customers can preview their websites during domain names propagation. For example, customer-site.tld will be available for preview as customer-site.tld.192-0-2-12.your-site.tld. Here, 192-0-2-12 is the site\'s IP address where dots are replaced with dashes.',
    'cu_serverpref__option_description_preview_protection' => 'Enables site preview protection by requiring FTP username and password to access the site preview.',

    'cu_optimization_settings__bad_module_names' => 'The following modules were not found: %1',
    'cu_optimization_settings__enable_module' => 'Turn on an Apache module',
    'cu_optimization_settings__disable_module' => 'Turn off an Apache module',
    'cu_optimization_settings__status' => 'Display the module status',
    'cu_optimization_settings__module_name_required' => 'Module name is required',
    'cu_optimization_settings__read_only_module' => 'The following modules cannot be managed via Plesk: %1. Their modification may affect certain Plesk functions or lead to Apache failure.',
    'cu_optimization_settings__set_mpm' => 'Set the MPM mode for Apache',
    'cu_optimization_settings__get_mpm' => 'Display the current MPM mode',
    'cu_optimization_settings__unknown_mpm_mode' => 'The "%1" MPM mode is not supported by Apache.',
    'cu_optimization_settings__unsupported_mpm_management' => 'MPM management is not supported by the Apache version installed on the server.',

    'cu_nginx__enable_module' => 'Turn on a dynamic module',
    'cu_nginx__disable_module' => 'Turn off a dynamic module',
    'cu_nginx__status' => 'Display status of dynamic modules',
    'cu_nginx__not_installed' => 'nginx component is not installed',
    'cu_nginx__unknown_module' => 'Unsupported module "%1"',
    'cu_nginx__enable_failed' => 'Module cannot be enabled: %1',
    'cu_nginx__disable_failed' => 'Module cannot be disabled: %1',
    'cu_nginx__inconsistent_config' => 'WARNING: Inconsistent nginx configuration detected, it is unsafe to restart nginx',

    'cu_serverpref__option_description_autoupdates' => 'Automatically download and install updates for the currently installed version',
    'cu_serverpref__option_description_webdeploy_include_password' => 'Include users\' passwords into the file with Web Deploy publication settings',
    'cu_serverpref__option_description_min_password_strength' => 'Minimum password strength',
    'cu_serverpref__option_description_disable_upgrade_extensions' => 'Switches off automatic upgrade of Plesk extensions.',
    'cu_serverpref__option_description_autoupdates_email_notification' => 'Send notifications about installed updates to the specified email address.',

    'cu_user__subscription_not_found_access_to_panel_denied' => 'Unable to find the subscription %1. Access to Plesk for this user is denied.',
    'cu_user__opt_subscription_name' => 'Allows a user to access only the specified subscription within a hosting account.',
    'cu_user__opt_email' => 'User\'s email address in Plesk.',
    'cu_user__opt_external_email' => 'User\'s external email address.',
    'cu_user__opt_for_all_subscription' => 'Allows a user to access all subscriptions within a hosting account.',
    'cu_user__owner_not_found' => 'The Plesk account %1 does not exist',
    'cu_user__user_not_found' => 'User %1 does not exist',

    'cu_option__service_node' => 'Service node.',
    'cu_option__service_node_not_found' => 'Unable to find a service node with the following IP address: %1.',
    'cu_option__cpu_usage_action_description' => 'Specifies the action that IIS takes when a worker process exceeds the specified CPU usage limit.',
    'cu_option__cpu_usage_interval_description' => 'Specifies the reset interval for monitoring the CPU usage on an application pool.',
    'cu_option__managed_pipeline_mode_description' => 'Configures ASP.NET to run in classic mode as an ISAPI extension or in integrated mode where managed code is integrated into the request-processing pipeline.',
    'cu_option__cpu_usage_action_not_supported' => 'The specified action is not supported by the web server.',
    'cu_option__invalid_cpu_usage_interval' => "The limit interval must be a number between %1 and %2.",

    'cu_clone__update' => 'Updates the server cloning settings.',
    'cu_clone__status' => 'Displays the current server cloning status.',
    'cu_clone__info' => 'Displays the current server cloning settings.',
    'cu_clone__prepare_public_image' => 'If set to "true", Plesk will reset all of its unique parameters (like GUIDS, passwords, certificates, and so on) to the default state on next server boot. If you plan to deploy VPSes based on the image of this Plesk server, turn this option on before creating the image.',
    'cu_clone__reset_license' => 'If you turn this option on the Plesk license key will not be copied during cloning. The default license key will be used instead.',
    'cu_clone__reset_init_conf' => 'The "true" value is used by default, meaning that cloning this Plesk server resets the Plesk configuration. To avoid this, use "false".',
    'cu_clone__success_update' => "Server cloning settings were successfully updated.\n",
    'cu_clone__skip_update' => 'If you turn this option on Plesk updates will not be installed during cloning. Note that Plesk updates will be installed later if automatic updates are turned on in Update Settings.',
    'cu_clone__maintenance' => 'The "true" value is used by default, meaning that the maintenance mode will be enabled during cloning. To avoid this, use "false".',

    'cu_module__create' => 'Creates an extension based on the extension template.',
    'cu_module__register' => 'Registers the specified extension.',
    'cu_module__install' => 'Installs an extension from the Extensions Catalog or from a ZIP file.',
    'cu_module__uninstall' => 'Removes the specified extension from Plesk.',
    'cu_module__pack' => 'Exports the specified extension to a ZIP file for further distribution.',
    'cu_module__destination' => 'A path to the directory where the exported extension should be located.',
    'cu_module__no_ui' => 'Do not add resource files defined by the extension template to the created extension. The new extension will contain a meta file and installation scripts only.',
    'cu_module__no_scripts' => 'Do not add installation scripts defined by the extension template to a created extension. The new extension will contain a meta file and resource files only.',
    'cu_module__no_var' => 'Do not add resource files defined by the extension template to a created extension.',
    'cu_module__force' => 'Do not fail when attempting to remove not installed extensions (just ignore them).',
    'cu_module__create_done' => 'The extension was successfully created.',
    'cu_module__register_done' => 'The extension was successfully registered.',
    'cu_module__install_done' => 'The extension was successfully installed.',
    'cu_module__uninstall_done' => 'The extension was successfully removed.',
    'cu_module__pack_done' => 'The extension was successfully exported to %1',
    'cu_module__list' => 'Displays the list of installed extensions.',
    'cu_module__enable' => 'Makes the extension active and accessible to users.',
    'cu_module__disable' => 'Makes the extension inactive and inaccessible to users.',
    'cu_module__status_wrong_module' => 'The extension %1 was not found. Use the --list command to get extension names.',
    'cu_module__status_error' => 'Failed to change the status of the extension %1.',
    'cu_module__status_done' => 'The extension\'s status was successfully updated.',
    'cu_module__dir_htdocs' => 'The path to extension\'s entry points: %1',
    'cu_module__dir_plib' => 'The path to PHP classes: %1',
    'cu_module__dir_scripts' => 'The path to installation scripts:  %1',
    'cu_module__dir_var' => 'The path to the directory with run-time data: %1',
    'cu_module__exec' => 'Executes the specified script from an extension.',
    'cu_module__upgrade' => 'Installs the extension or upgrades the currently installed extension to a newer version.',
    'cu_module__upgrade_done' => 'The extension was successfully upgraded.',
    'cu_module__call' => 'Calls a command-line interface of the specified extension.',
    'cu_module__call_help' => 'Specify the extension name followed by a command (such as --help) and options.',
    'cu_module__install_skip_newer' => 'The extension was not upgraded: The version to upgrade to (%2) is lower than the previously installed version (%1).',
    'cu_module__not_installed' => "The extension %1 is not installed.",
    'cu_module__no_api_rpc_support' => "The XML API support is not implemented in %1.",
    'cu_module__no_forwarded_api_rpc_support' => "The support for processing XML API requests to Plesk is not implemented in %1.",
    'cu_module__no_api_cli_support' => "The support for the command-line interface is not implemented in %1.",
    'cu_module__invalid_package_name_or_path' => "'%1' neither a valid package name or a path",
    'cu_module__package_requirements_not_met' => "Extension '%1' was found, but could not be installed: it requires %2, but current version is '%3'",
    'cu_module__package_requirements_above' => "Plesk version to be above '%1'",
    'cu_module__package_requirements_below' => "Plesk version to be below '%1'",
    'cu_module__package_requirements_between' => "Plesk version to be between '%1' and '%2'",

    'cu_dns_command_zone_off' => 'The DNS zone for this domain is switched off.',
    'cu_dom_tpl__syncing' => 'Unable to update the service plan settings: The plan is currently syncing with its subscriptions.',

    'cu_product_info__updates_info_desc' => 'Displays the information about installed and available updates',
    'cu_product_info__installed_update' => 'Installed update',
    'cu_product_info__installed_update_no_updates' => 'No installed updates',
    'cu_product_info__available_update' => 'Available update',
    'cu_product_info__install_updates_automatically' => 'Automatic Plesk updates',
    'cu_product_info__install_system_package_updates_automatically' => 'Automatic system package updates',
    'cu_product_info__install_updates_automatically_enabled' => 'On',
    'cu_product_info__install_updates_automatically_disabled' => 'Off',

    'cu_dom_pref__default_server_mssql' => 'Set the default MS SQL Server database server. Websites within a subscription will use it for storing MS SQL Server databases.',
    'cu_dom_pref__default_server_mysql' => 'Set the default MySQL database server. Websites within a subscription will use it for storing MySQL databases.',
    'cu_dom_pref__default_server_postgresql' => 'Set the default PostgreSQL database server. Websites within a subscription will use it for storing PostgreSQL databases.',
    'cu_dom_pref__default_server_suppported_by_subscription_only' => 'You can set the default database server parameter for subscriptions with physical hosting only.',
    'cu_dom_pref__db_server_not_found' => 'Unable to find the %1 database server.',
    'cu_dom_tpl__default_server_mssql' => 'Set the default MS SQL Server database server. Websites within the plan\'s subscriptions will use it for storing MS SQL Server databases.',
    'cu_dom_tpl__default_server_mysql' => 'Set the default MySQL database server. Websites within the plan\'s subscriptions will use it for storing MySQL Server databases.',
    'cu_dom_tpl__default_server_postgresql' => 'Set the default PostgreSQL database server. Websites within the plan\'s subscriptions will use it for storing PosgreSQL Server databases.',
    'cu_dom_tpl__db_server_not_found' => 'Unable to find the %1 database server.',

    'cu__isapi_not_supported' => 'The ISAPI handler type is not supported by the installed PHP version.',

    //repair utility PFW and Linux
    'cu_repair__reconfigure_ftp_sites' => 'Reconfigures the FTP service for all registered websites.',
    'cu_repair__success_reconfigure_ftp_sites' => "The FTP service was successfully reconfigured.\n",
    'cu_repair__reconfigure_ftp_site' => 'Reconfigures the FTP service for the specified website.',
    'cu_repair__success_reconfigure_ftp_site' => "The FTP service for the %1 website was successfully reconfigured.\n",
    'cu_repair__reconfigure_web_site' => 'Reconfigures the web server for the specified website.',
    'cu_repair__web_site_name' => 'Specifies a domain name.',
    'cu_repair__domain_no_hosting' => 'There are no hosted websites associated with the specified domain name.',
    'cu_repair__success_reconfigure_web_site' => "The web server for the %1 website was successfully reconfigured.\n",
    'cu_repair__regenerate_web_server_users_password' => "Generates new passwords for the built-in IIS users.",
    'cu_repair__operation_not_supported_by_node' => 'This operation is not supported by the service node.',
    'cu_repair__operation_not_supported_by_management_node' => 'This operation is not supported by the management node.',
    'cu_repair__success_regenerate_web_server_users_password' => "New passwords for the built-in IIS users were successfully generated.\n",
    'cu_repair__reconfigure_web_mail_sites' => 'Reconfigures webmail services.',
    'cu_repair__success_reconfigure_web_mail_sites' => "Webmail services were successfully reconfigured.\n",
    'cu_repair__reconfigure_mssql_webadmin_site' => 'Reconfigures database web administration services.',
    'cu_repair__success_reconfigure_mssql_webadmin_site' => "Database web administration services were successfully reconfigured.\n",

    'cu_repair__synchronize_protected_directories_storage' => 'Syncs password-protected directories data between a service node and the management node.',
    'cu_repair__success_synchronize_protected_directories_storage' => "Password-protected directories data were successfully synced.\n",
    'cu_repair__synchronize_impersonation_storage' => 'Syncs system user databases between a service node and the management node.',
    'cu_repair__success_synchronize_impersonation_storage' => "System user databases were successfully synced.\n",

    'cu_repair__reconfigure_ssl_certificates' => 'Reinstalls SSL/TLS certificates.',
    'cu_repair__success_reconfigure_ssl_certificates' => "SSL/TLS certificates were successfully reinstalled.\n",
    'cu_repair__error_reconfigure_ssl_certificates' => "Unable to reinstall SSL/TLS certificates.\n",
    'cu_repair__show_lock_manager_status' => 'Show lock manager status.',

    'cu_repair__directory_permissions' => 'Fixes permissions for the specified directory.',
    'cu_repair__plesk_directory_permissions' => 'Fixes permissions for Plesk directories.',
    'cu_repair__option_directory' => 'The full path to the directory. Used with the --directory-permissions command.',
    'cu_repair__option_fix_parent_dirs' => 'Applies the directory permissions to each directory within the path. Used with the --directory-permissions command.',
    'cu_repair__success_directory_permissions' => 'Permissions were fixed for directory "%1".',
    'cu_repair__error_directory_permissions' => 'Failed to fix directory permissions for directory "%1": %2',
    'cu_repair__success_plesk_directory_permissions' => 'Permissions for Plesk directories were fixed.',
    'cu_repair__error_plesk_directory_permissions' => 'Failed to fix directory permissions for Plesk directories: %1',

    'cu_repair__configure_plesk_website' => 'Sets up PleskControlPanel site and pool in web server.',
    'cu_repair__error_configure_plesk_website' => 'Failed to set up PleskControlPanel: "%1".',
    'cu_repair__success_configure_plesk_website' => 'Created PleskControlPanel site and pool.',

    'cu_repair__configure_acme_challenge' => 'Configures common challenge directory for ACME.',
    'cu_repair__error_configure_acme_challenge' => 'Failed to configure common challenge directory: "%1".',
    'cu_repair__success_configure_acme_challenge' => 'Created and configured a common challenge directory.',

    'cu_repair__configure_https_redirect' => 'Sets up HTTPS redirect helper for web server.',
    'cu_repair__error_configure_https_redirect' => 'Failed to set up HTTPS redirect helper: "%1".',
    'cu_repair__success_configure_https_redirect' => 'Configured HTTPS redirect helper.',

    'cu_repair__sync_accounts_passwords' => 'Syncs passwords for Application Pool users with the web server.',
    'cu_repair__error_sync_accounts_passwords' => 'Failed to sync passwords: "%1".',
    'cu_repair__success_sync_accounts_passwords' => 'Actualized passwords for Application Pool users.',

    'cu_repair__output_statistics' => 'Error messages: %1; Warnings: %2; Errors resolved: %3',
    'cu_repair__output_row' => 'row',
    'cu_repair__check_use_verbose_mode' => 'To see more details, run the command in the verbose mode: %1',
    'cu_repair__check' => 'Runs the Plesk data consistency checking tool.',
    'cu_repair__check_db' => 'Runs the Plesk database checking tool.',
    'cu_repair__check_db_title' => 'Checking the Plesk database',
    'cu_repair__check_db_status_in_progress' => 'Checking the Plesk database using the native database server tools',
    'cu_repair__check_db_structure_in_progress' => 'Checking the structure of the Plesk database',
    'cu_repair__check_db_consistency_in_progress' => 'Checking the consistency of the Plesk database',
    'cu_repair__check_db_broken_table' => 'Broken table %1: %2',
    'cu_repair__check_db_broken_table_unable_to_repair' => 'Cannot repair InnoDB tables. Use the following KB article: %1 or restore daily dumps stored in %2',
    'cu_repair__check_db_broken_table_failed_to_repair' => 'Try to restore automatic daily dumps stored in %1',
    'cu_repair__check_db_broken_database' => 'Broken database: %1',
    'cu_repair__check_db_extra_table' => 'Extra table: %1',
    'cu_repair__check_db_missing_table' => 'The table %1 is absent',
    'cu_repair__check_db_missing_not_recreatable_table' => 'The table %1 is absent. Try to restore it from automatic daily dumps stored in %2.',
    'cu_repair__check_db_extra_columns_title' => 'Extra columns in the table %1:',
    'cu_repair__check_db_missing_column' => 'Column %1 is absent in the table %2',
    'cu_repair__check_db_column_attribute_errors' => "Wrong attributes for the column '%1' in the table '%2':",
    'cu_repair__check_db_column_attribute_missing' => 'Missing attribute: %1.',
    'cu_repair__check_db_column_attribute_extra' => 'Extra attribute: %1.',
    'cu_repair__check_db_column_attribute_mismatch' => "The attribute '%1' value mismatch: %2 in the original schema and %3 in the Plesk database.",
    'cu_repair__check_db_index_uniqueKey' => 'unique key',
    'cu_repair__check_db_index_indexes' => 'index',
    'cu_repair__check_db_table_index_missing' => 'Missing %1 in the table %2:',
    'cu_repair__check_db_table_index_extra' => 'Extra %1 in the table %2:',
    'cu_repair__check_db_table_index_mismatch' => "%1 values mismatch in the table '%2': %3 in the original schema and %4 in the Plesk database",
    'cu_repair__check_db_inconsistent_table' => "Inconsistency in the table '%1' for the column %2: %3",
    'cu_repair__check_db_inconsistent_row' => "No rows in the table '%1' with %2 = %3",
    'cu_repair__check_db_inconsistent_row_count' => "No rows in the table '%1' with %2 = %3 (%4 broken references)",
    'cu_repair__check_db_inconsistent_broken_references_title' => "Broken references in table '%1':",
    'cu_repair__check_db_inconsistent_suggest_fix_warning' => "Remove unnecessary rows from the table '%1'?",
    'cu_repair__check_db_inconsistent_fix_warning_in_progress' => "Removing unnecessary rows",
    'cu_repair__check_db_inconsistent_suggest_fix_nullable' => "Fix broken references in the table '%1'?",
    'cu_repair__check_db_inconsistent_fix_nullable_in_progress' => "Fixing broken references",
    'cu_repair__check_db_inconsistent_addondomain_domain' => 'Wrong customer ID for the additional domain with ID %1',
    'cu_repair__check_db_inconsistent_client_ippool' => 'There is no IP pool with ID %1',
    'cu_repair__check_db_inconsistent_client_ippool_suggest_fix' => 'Create an IP pool?',
    'cu_repair__check_db_inconsistent_client_ippool_fix_in_progress' => 'Creating an IP pool',
    'cu_repair__check_db_inconsistent_domain_client_suggest_fix_assign' => 'Assign domains %1 to client %2?',
    'cu_repair__check_db_inconsistent_domain_client_fix_in_progress_assign' => 'Assigning domains %1 to client %2',
    'cu_repair__check_db_inconsistent_domain_client_suggest_fix_remove' => 'Remove domains %1?',
    'cu_repair__check_db_inconsistent_domain_client_fix_in_progress_remove' => 'Removing domains %1',

    'cu_repair__check_db_inconsistent_domain_log_rotation' => "Log rotation preferences with ID = %1 are not found.",
    'cu_repair__check_db_inconsistent_domain_log_rotation_suggest_fix' => "Create default log rotation preferences for the domain '%1'?",
    'cu_repair__check_db_inconsistent_domain_log_rotation_fix_in_progress' => "Creating default log rotation preferences...",
    'cu_repair__check_db_inconsistent_domain_log_rotation_no_domains' => "No domain found for log rotation preferences with ID %1",

    'cu_repair__check_db_inconsistent_domain_domainalias_dns' => 'The domain alias with ID %1 uses the same DNS zone as its main domain',
    'cu_repair__check_db_inconsistent_apscontext_subscription' => 'The installed application with ID %1 is not associated with any subscription.',
    'cu_repair__check_db_inconsistent_apscontext_subscription_suggest_fix' => "Associate the application with ID '%1' with a subscription?",
    'cu_repair__check_db_inconsistent_apscontext_subscription_fix_in_progress' => "Associating application with a subscription",
    'cu_repair__check_db_inconsistent_reseller_subscription_suggest_fix' => "Create a custom reseller's subscription?",
    'cu_repair__check_db_inconsistent_reseller_subscription_fix_in_progress' => "Creating a custom reseller's subscription",
    'cu_repair__check_db_inconsistent_addondomain_webspace' => 'The domain with ID %1 does not belong to any subscription: It is associated with a domain that is not the main domain of a subscription',
    'cu_repair__check_db_inconsistent_plesk_apsc' => "There is no object in the 'apsc' database in the table 'aps_registry_object' with UID = %1",
    'cu_repair__check_db_inconsistent_plesk_apsc_suggest_fix' => "Remove the corresponding rows from the table '%1'?",
    'cu_repair__check_db_inconsistent_plesk_apsc_fix_in_progress' => "Removing rows",
    'cu_repair__check_db_inconsistent_serviceinstallationpleskfilesystem' => "No property 'root' for the service instance 'PleskFileSystem' with ID = %1. An error will appear when users change the hosting type of the domain.",
    'cu_repair__check_db_inconsistent_serviceinstallationpleskfilesystem_suggest_fix' => "Create the property 'root' using the subscription's home directory?",
    'cu_repair__check_db_inconsistent_serviceinstallationpleskfilesystem_fix_in_progress' => "Creating the property 'root' for service instance",
    'cu_repair__check_db_inconsistent_serviceinstallationpleskfilesystem_no_package' => "Unable to find the service package with ID = %1",
    'cu_repair__check_db_inconsistent_apsc_user_access_denied' => 'Unable to connect to the APS database with the credentials stored in Plesk.',
    'cu_repair__check_db_inconsistent_apsc_user_connection_failed' => 'Unable to connect to the APS database.',
    'cu_repair__check_db_inconsistent_apsc_user_wrong_configuration' => 'Wrong APS database configuration.',
    'cu_repair__check_db_inconsistent_apsc_user_suggest_fix' => 'Recreate the APS database user account?',
    'cu_repair__check_db_inconsistent_apsc_user_fix_in_progress' => 'Recreating the APS database user account and registering it in Plesk',
    'cu_repair__check_db_inconsistent_apscapplicationinstance' => "An APS application for the APS database entry with ID = %1 was not found.",
    'cu_repair__check_db_inconsistent_apscapplicationinstance_suggest_fix' => "Remove the APS entry?",
    'cu_repair__check_db_inconsistent_apscapplicationinstance_fix_in_progress' => "Removing the APS entry",
    'cu_repair__check_db_inconsistent_hosting_subscription_suggest_fix' => "Create a custom subscription with default properties?",
    'cu_repair__check_db_inconsistent_hosting_subscription_fix_in_progress' => "Creating a custom subscription",
    'cu_repair__check_db_inconsistent_ipaddresssslcertificate_suggest_fix' => "Assign the default SSL/TLS certificate to the IP address?",
    'cu_repair__check_db_inconsistent_ipaddresssslcertificate_fix_in_progress' => "Assigning the default SSL/TLS certificate to the IP address",
    'cu_repair__check_db_inconsistent_smbuserowner_suggest_fix_assign' => 'Assign users %1 to the customer %2?',
    'cu_repair__check_db_inconsistent_smbuserowner_fix_in_progress_assign' => 'Assigning users %1 to the customer %2',
    'cu_repair__check_db_inconsistent_smbuserowner_suggest_fix_remove' => 'Remove users %1?',
    'cu_repair__check_db_inconsistent_smbuserowner_fix_in_progress_remove' => 'Removing users %1',
    'cu_repair__check_db_inconsistent_domainserviceipaddresscollection' => "Web service cannot operate: the IP address list with ID %1 is empty.",
    'cu_repair__check_db_inconsistent_domainserviceipaddresscollection_suggest_fix' => "Generate an IP address list based on DNS records?",
    'cu_repair__check_db_inconsistent_domainserviceipaddresscollection_fix_in_progress' => "Generating an IP address list",
    'cu_repair__check_db_inconsistent_domainserviceipaddresscollection_no_ip_addresses' => "No IP addresses found in DNS records.",
    'cu_repair__check_db_inconsistent_domainipaddress' => "The following domains are assigned to already removed IP addresses. Reassign the domains to existing IP addresses:\n%1",
    'cu_repair__check_db_inconsistent_domainwebspace_suggest_fix' => 'Assign domains %1 to subscription %2?',
    'cu_repair__check_db_inconsistent_domainwebspace_suggest_fix_in_progress' => 'Assigning domains to the subscription',
    'cu_repair__check_db_inconsistent_domainwebspace_suggest_remove' => 'Remove domains %1?',
    'cu_repair__check_db_inconsistent_domainwebspace_suggest_remove_in_progress' => 'Removing domains',
    'cu_repair__check_db_inconsistent_auto_increment' => 'Wrong AUTO_INCREMENT values in the following tables: %1',
    'cu_repair__check_db_inconsistent_auto_increment_suggest_fix' => 'Set correct AUTO_INCREMENT values?',
    'cu_repair__check_db_inconsistent_auto_increment_fix_in_progress' => 'Updating AUTO_INCREMENT values',
    'cu_repair__check_db_inconsistent_auto_increment_failed' => 'Updating AUTO_INCREMENT failed for tables: %1',
    'cu_repair__check_db_inconsistent_misc' => "Inconsistency in the table 'misc' for the parameter '%1': %2",
    'cu_repair__check_db_inconsistent_misc_default_cert' => "No rows in the table 'certificates' with id = %1",
    'cu_repair__check_db_inconsistent_outgoing_email_ip' => "Inconsistency in the table 'ServiceNodeConfiguration' for the parameter '%1': No rows in the table 'IP_Addresses' with id = %2",
    'cu_repair__check_db_inconsistent_outgoing_email_ips' => "Inconsistency in the table 'ServiceNodeConfiguration' for the parameters '%1' and '%2': No rows in the table 'IP_Addresses' with id = %3 and id = %4",
    'cu_repair__check_db_inconsistent_outgoing_email_no_ips' => "Inconsistency in the table 'ServiceNodeConfiguration' for the parameters '%1' and '%2': At least one of the IP addresses is required to be assigned",
    'cu_repair__check_db_inconsistent_outgoing_email_ip_suggest_fix' => 'Stop using this IP address for outgoing mail?',
    'cu_repair__check_db_inconsistent_outgoing_email_ip_suggest_switch' => 'Switch Outgoing mail mode to send from domain IP addresses?',

    'cu_repair__resolve_db_create_table_question' => "Create table '%1'?",
    'cu_repair__resolve_db_create_table_in_progress' => "Creating table '%1'",
    'cu_repair__resolve_db_drop_table_question' => "Delete table '%1'?",
    'cu_repair__resolve_db_drop_table_in_progress' => "Deleting table '%1'",
    'cu_repair__resolve_db_fix_table_question' => "Repair table '%1'?",
    'cu_repair__resolve_db_fix_table_in_progress' => "Repairing table '%1'",
    'cu_repair__resolve_db_fix_database_question' => "Repair the database?",
    'cu_repair__resolve_db_fix_database_in_progress' => "Repairing the database",
    'cu_repair__resolve_db_dump_in_progress' => 'Creating a database dump',
    'cu_repair__resolve_db_created_dump' => 'A dump of the database was created before an attempt to repair the database: %1',
    'cu_repair__resolve_db_failed_create_dump' => 'Unable to create a dump of the database before attempting to repair it: %1',

    'cu_repair__label_success' => 'OK',
    'cu_repair__label_warning' => 'WARNING',
    'cu_repair__label_error' => 'ERROR',
    'cu_repair__label_fixed' => 'FIXED',
    'cu_repair__label_failed' => 'FAILED',
    'cu_repair__label_info' => 'INFO',

    'cu_repair__option_description_yes_answer' => 'Resolve all issues (Every prompt of the tool will be automatically answered with \'yes\').',
    'cu_repair__option_description_no_answer' => 'Only check (Every prompt of the tool will be automatically answered with \'no\').',
    'cu_repair__option_description_no_answer_not_supported' => 'This aspect does not support the option \'-n\'.',
    'cu_repair__option_description_verbose' => 'Displays extra information.',
    'cu_repair__option_description_treat_warnings_as_errors' => 'Makes this utility return code 1 when there are no error messages, but only warnings produced during its execution. Code 1 corresponds to errors. By default, if there are only warnings, or neither warnings nor errors, the utility returns code 0. You can use this option in a script.',

    'cu_repair__option_description_json_output' => 'Return data in JSON format.',

    'cu_repair__update_webspace_security' => 'Updates permissions for the specified subscription.',
    'cu_repair__success_update_webspace_security' => 'Permissions for the specified subscription have been updated.',
    'cu_repair__repair_webspace_security' => 'Repairs permissions for the specified subscription.',
    'cu_repair__success_repair_webspace_security' => 'Permissions for the specified subscription have been repaired.',
    'cu_repair__error_check_webspace_security' => "Incorrect permissions on the following files:\n%1",
    'cu_repair__error_repair_webspace_security' => 'Could not repair permissions for the following subscription: %1.',
    'cu_repair__repair_all_webspaces_security' => 'Repairs permissions for all subscriptions.',
    'cu_repair__success_repair_all_webspaces_security' => 'Permissions for all subscriptions have been repaired.',
    'cu_repair__error_repair_all_webspaces_security' => 'Unable to repair permissions for all subscriptions.',

    'cu_repair__start_plesk_website' => 'Starts the Plesk web interface.',
    'cu_repair__success_start_plesk_website' => 'The Plesk web interface was successfully started.',
    'cu_repair__stop_plesk_website' => 'Stops the Plesk web interface.',
    'cu_repair__success_stop_plesk_website' => 'The Plesk web interface was successfully stopped.',

    'cu_repair__update_mssql_users_permissions' => "Updates permissions and roles of Microsoft SQL Server database users. Can be used with the -database-server and -database-name options. If no server and database are specified, the permissions are updated on all servers and databases.",
    'cu_repair__success_update_mssql_users_permissions' => "Permissions and roles of Microsoft SQL Server database users were successfully updated.\n",
    'cu_repair__option_database_server' => 'Specifies a database server host name. Used with the --update-mssql-users-permissions command.',
    'cu_repair__option_database_name' => 'Specifies a database name. Used with the --update-mssql-users-permissions command.',
    'cu_repair__option_all_filesystem_objects' => 'Updates permissions for all file system objects of the specified subscription. Used with the --update-webspace-security and --repair-webspace-security commands. If no subscription is specified, updates permissions on all subscriptions.',

    'cu_repair__recreate_horde_database' => 'Creates a clean database for the Horde webmail',
    'cu_repair__success_recreate_horde_database' => "The new clean database for Horde was successfully created.\n",
    'cu_repair__upgrade_horde_database' => 'Upgrades the Horde webmail database (preserving the existing data).',
    'cu_repair__success_upgrade_horde_database' => "The Horde webmail database was successfully upgraded.\n",
    'cu_repair__horde_not_installed' => 'The Horde webmail is not installed.',

    'cu_repair__repair_webspace_system_users' => 'Repairs subscription system user accounts: Restores missing main FTP user accounts.',
    'cu_repair__success_repair_webspace_system_users' => "The subscription '%1' system user accounts were successfully repaired.",
    'cu_repair__error_repair_webspace_system_users' => "Unable to repair subscription '%1' system users.",
    'cu_repair__repair_all_webspaces_system_users' => 'Repairs system user accounts on all subscriptions: Restores missing main FTP user accounts on all subscriptions.',
    'cu_repair__success_repair_all_webspaces_system_users' => 'System user accounts on all subscriptions were successfully repaired.',
    'cu_repair__error_repair_all_webspaces_system_users' => 'Unable to repair system user accounts on all subscriptions.',

    'cu_repair__reconfigure_site_preview' => 'Reconfigures site preview settings.',
    'cu_repair__success_reconfigure_site_preview' => 'Site preview settings were reconfigured.',

    'cu_repair__reconfigure_failed_requests_tracing' => 'Reconfigures the settings of failed request tracing on the web server.',
    'cu_repair__success_reconfigure_failed_requests_tracing' => 'Failed request tracing settings were successfully reconfigured.',
    'cu_repair__error_reconfigure_failed_requests_tracing' => 'Unable to reconfigure failed request tracing settings.',

    'cu_repair__reconfigure_php_errors_logging' => 'Reconfigures PHP error logging.',
    'cu_repair__success_reconfigure_php_errors_logging' => 'PHP error logging was successfully reconfigured.',
    'cu_repair__error_reconfigure_php_errors_logging' => 'Unable to reconfigure PHP error logging.',

    'cu_repair__check_mysql' => 'Runs the MySQL servers checking tool.',
    'cu_repair__check_mssql' => 'Runs the MS SQL servers checking tool.',
    'cu_repair__option_connection' => 'Checks the connection to a database server.',
    'cu_repair__option_databases' => 'Checks databases on a database server.',
    'cu_repair__option_database_users' => 'Checks database users on a database server.',
    'cu_repair__check_web' => 'Runs the web server checking tool.',
    'cu_repair__option_php_handlers_title' => 'Checking the usage of PHP handlers',
    'cu_repair__option_php_handlers' => 'Checks the usage of unregistered PHP handlers in service plans and domains.',
    'cu_repair__check_php_handlers_domain_error' => '%1 domains with unregistered PHP handlers were found.',
    'cu_repair__check_php_handlers_domain_error_verbose' => 'The following domains have unregistered PHP handlers:',
    'cu_repair__check_php_handlers_plan_error' => '%1 service plans with unregistered PHP handlers were found.',
    'cu_repair__check_php_handlers_plan_error_verbose' => 'The following service plans have unregistered PHP handlers:',
    'cu_repair__check_php_handlers_non_interactive' => 'The issue could be resolved only in the interactive mode (without -y and -n options).',
    'cu_repair__check_php_handlers_suggest_fix' => 'Use the following PHP handler to fix the issue:',
    'cu_repair__check_php_handlers_disable' => 'Disable PHP support',
    'cu_repair__check_php_handlers_skip' => 'Do not fix',
    'cu_repair__check_php_handlers_disable_in_progress' => 'Disabling PHP support',
    'cu_repair__check_php_handlers_in_progress' => 'Applying PHP handler %1',
    'cu_repair__check_php_handlers_failed' => 'Could not apply PHP handler: %1',
    'cu_repair__option_apache_modules' => 'Checks the configuration of Apache modules.',
    'cu_repair__option_apache_modules_title' => 'Checking the configuration of Apache modules',
    'cu_repair__check_apache_modules_error' => 'There is a broken Apache module.',
    'cu_repair__check_apache_modules_repair_confirm' => 'Disable the broken Apache module?',
    'cu_repair__check_apache_modules_repair_in_progress' => 'Disabling the broken Apache module',
    'cu_repair__check_apache_modules_repair_error' => 'Could not disable the broken Apache module.',
    'cu_repair__choose_option' => 'Type the number of the necessary option:',
    'cu_repair__option_php_fpm_configs_title' => 'Checking for obsolete PHP-FPM configuration files',
    'cu_repair__option_php_fpm_configs' => 'Checks for the obsolete PHP-FPM configuration files.',
    'cu_repair__check_php_fpm_configs_suggest_fix' => "Delete obsolete configuration file?",
    'cu_repair__check_php_fpm_configs_in_progress' => 'Deleting',
    'cu_repair__check_php_fpm_configs_error' => 'Domain %1',
    'cu_repair__check_php_fpm_configs_no_domain_error' => 'Non existing domain %1 has obsolete PHP-FPM configuration file %2',
    'cu_repair__check_php_fpm_configs_no_hosting_error' => 'Domain %1 without physical hosting has obsolete PHP-FPM configuration file %2',
    'cu_repair__check_php_fpm_configs_no_php_error' => 'Domain %1 without PHP support has obsolete PHP-FPM configuration file %2',
    'cu_repair__check_php_fpm_configs_wrong_handler_error' => 'Domain %1 with PHP handler %2 has obsolete PHP-FPM configuration file %3',

    'cu_repair__reconfigure' => 'Reconfigures all services (mail, web, DNS, FTP, Plesk database, file server, database servers, and other Plesk services).',
    'cu_repair__reconfigure_dns' => 'Reconfigures the DNS server.',
    'cu_repair__reconfigure_dns_title' => 'Reconfiguring the DNS server',
    'cu_repair__option_sync_zones' => 'Synchronizes DNS zones with the DNS server.',

    'cu_repair__reconfigure_web_aspect_title' => "Checking web server configuration",
    'cu_repair__reconfigure_web_wait_aspect_title' => "Checking web server configuration. Please wait...",
    'cu_repair__reconfigure_web_domain_confirm' => "Repair web server configuration for domains %1?",
    'cu_repair__reconfigure_web_domains_confirm' => "Repair web server configuration for all domains?",
    'cu_repair__reconfigure_web_domains' => "Repairing web server configuration for all domains. This aspect can be used with individual domains (\"plesk repair web example.com\"), and on the server level (\"plesk repair web\").",
    'cu_repair__reconfigure_web_domains_error' => "Repairing domain '%1' failed: %2",
    'cu_repair__reconfigure_web_domain_not_exists' => "Domain '%1' does not exist.",
    'cu_repair__reconfigure_web_domain' => "Repairing web server configuration for the domain %1.",
    'cu_repair__reconfigure_web_filesharing_confirm' => "Update the file of sharing passwords and permissions of users according to actual information?",
    'cu_repair__reconfigure_web_filesharing' => "Updating the file of sharing passwords and permissions of users according to actual information.",
    'cu_repair__reconfigure_web_server_confirm' => "Repair server-wide configuration parameters for web servers?",
    'cu_repair__reconfigure_web_server' => "Repairing server-wide configuration parameters for web servers.",
    'cu_repair__reconfigure_web_sslcerts_confirm' => "Reinstall SSL/TLS certificates and set the default certificate for all IP addresses?",
    'cu_repair__reconfigure_web_sslcerts_reinstall' => "Reinstalling SSL/TLS certificates.",
    'cu_repair__reconfigure_web_sslcerts_reset' => "Applying the default SSL/TLS certificate to all IP addresses.",
    'cu_repair__reconfigure_web_webmail_confirm' => "Reconfigure webmail services?",
    'cu_repair__reconfigure_web_webmail' => "Reconfiguring webmail services.",

    'cu_repair__option_description_domain' => 'Repairs web server configuration for the specified domain.',
    'cu_repair__option_description_domains' => 'Repairs web server configuration for all domains.',
    'cu_repair__option_description_file_sharing' => 'Updates the file of sharing passwords and permissions of users according to actual information.',
    'cu_repair__option_description_server' => 'Repairs server-wide configuration parameters for web servers.',
    'cu_repair__option_description_sslcerts' => 'Reinstalls SSL/TLS certificates and sets the default certificate for all IP addresses.',

    'cu_repair__check_php_handlers_domain_success' => 'Checks PHP handlers for domains.',
    'cu_repair__check_php_handlers_scheduler_error' => 'Scheduled tasks with unregistered PHP handlers: %1',
    'cu_repair__check_php_handlers_scheduler_error_verbose' => '%1 scheduled tasks with unregistered PHP handlers on the following domains and system users:',
    'cu_repair__check_connection_title' => 'Checking %1 database servers',
    'cu_repair__check_connection_title_mysql' => 'MySQL',
    'cu_repair__check_connection_title_mssql' => 'MS SQL',
    'cu_repair__check_connection' => 'Connecting to %1',
    'cu_repair__check_connection_error' => 'Unable connect to %1: %2',
    'cu_repair__repair_databases_in_progress' => 'Repair databases on available servers',
    'cu_repair__repair_databases_error' => 'Unable to check %1 database: %2',
    'cu_repair__repair_databases_existence_error' => 'The database %1 on the subscription %2 is absent from the database server.',
    'cu_repair__repair_databases_existence_fix' => 'Recreate the database %1 on the subscription %2?',
    'cu_repair__repair_databases_recreate' => 'Recreating the database %1 on the subscription %2',
    'cu_repair__repair_databases_user_in_progress' => 'Repair database users on available servers',
    'cu_repair__repair_databases_user_error' => 'Unable to check the database user %1: %2',
    'cu_repair__repair_databases_user_existence_error' => 'The user %1 on the subscription %2 is absent from the database server.',
    'cu_repair__repair_databases_user_existence_fix_acl' => 'Recreate the user %1 on the subscription %2 with the default permissions and the default hosts?',
    'cu_repair__repair_databases_user_existence_fix' => 'Recreate the user %1 on the subscription %2?',
    'cu_repair__repair_databases_user_recreate' => 'Recreating the user %1 on the subscription %2',
    'cu_repair__repair_databases_user_password_error' => 'The user %1 on the subscription %2 is unable to connect to the database server.',
    'cu_repair__repair_databases_user_password_fix' => 'Reset the password for the user %1 on the subscription %2',
    'cu_repair__repair_databases_user_password_reset' => 'Resetting the password for the user %1 on the subscription %2',
    'cu_repair__check_db_inconsistent_www_root_out_of_webspace' => 'The home directory of the domain %1 does not match the system user\'s default home directory.',
    'cu_repair__check_db_inconsistent_www_root_out_of_webspace_suggest_fix' => 'Replace "%1" with "%2"?',
    'cu_repair__check_db_inconsistent_www_root_out_of_webspace_fix_in_progress' => 'Replacing the home directory for the domain',

    'cu_repair__check_ftp' => "Runs the FTP service checking tool. This aspect can be used with individual domains (\"plesk repair ftp example.com\"), and on the server level (\"plesk repair ftp\").",
    'cu_repair__check_ftp_title' => "Running the FTP service checking tool",
    'cu_repair__check_ftp_hostname_too_long' => "The name cannot be longer than %1 characters",
    'cu_repair__check_ftp_hostname_in_progress' => "Checking host name",
    'cu_repair__check_ftp_root_dir_failed_should_not_include_spaces' => "The path must not include the space character",
    'cu_repair__check_ftp_root_dir_in_progress' => "Checking FTP root directory",
    'cu_repair__check_ftp_domains_resolving_warning' => "The domain name %1 resolves to another IP address (%2)",
    'cu_repair__check_ftp_domains_resolving_no_records' => "The domain name %1 does not have public %2 records",
    'cu_repair__check_ftp_domains_resolving_error' => "Cannot check the domain name %1 resolving: %2",
    'cu_repair__check_ftp_domains_resolving_in_progress' => "Checking all domain names resolve to appropriate IP addresses",
    'cu_repair__check_ftp_home_dir_warning' => "The home directory of the additional FTP user %1 does not exist",
    'cu_repair__check_ftp_home_dir_in_progress' => "Checking home directories of additional FTP users",
    'cu_repair__check_ftp_sys_users_in_progress' => "Checking system users",
    'cu_repair__check_ftp_sys_users_absent_warning' => "The system user '%1' belongs to the Plesk group or is associated with a home directory at a virtual host but is absent in Plesk.",
    'cu_repair__check_ftp_sys_users_orphaned_warning' => "The system user '%1' is orphaned in Plesk.",
    'cu_repair__check_ftp_sys_users_prompt_fix' => "Remove the system user '%1'? Note that the user's home directory %2 will be preserved.",
    'cu_repair__check_ftp_sys_users_fix_failed' => "Failed to remove the system user '%1': %2",
    'cu_repair__check_ftp_sys_users_fix_in_progress' => "Removing the system user '%1'",
    'cu_repair__check_ftp_junctions_in_progress' => 'Checking FTP home junctions',
    'cu_repair__check_ftp_junctions_not_found_base_dir' => "The server base directory '%1' does not exist",
    'cu_repair__check_ftp_junctions_ftp_service_broken' => 'The FTP service is broken. You can try to repair it with "%1".',
    'cu_repair__check_ftp_junctions_prompt_fix_base_dirs' => "Recreate the server base directory '%1'?",
    'cu_repair__check_ftp_junctions_fix_base_dirs_in_progress' => "Reconfiguring the FTP service",
    'cu_repair__check_ftp_junctions_fix_base_dirs_failed' => "Failed to reconfigure the FTP service: %1",
    'cu_repair__check_ftp_junctions_not_found' => "The junction '%1' does not exist",
    'cu_repair__check_ftp_junctions_not_junction' => "The junction '%1' is broken",
    'cu_repair__check_ftp_junctions_wrong_target' => "The junction '%1' points to the wrong directory",
    'cu_repair__check_ftp_junctions_prompt_fix' => "Repair the junction '%1'?",
    'cu_repair__check_ftp_junctions_fix_in_progress' => "Recreating the junction '%1'",
    'cu_repair__check_ftp_junctions_fix_failed' => "Failed to recreate the junction: %1",
    'cu_repair__option_description_sys_users' => "Checks the consistency of system users.",
    'cu_repair__option_description_host_name' => "Checks the host name length.",
    'cu_repair__option_description_root_dir' => "Checks that the FTP root path does not contain any white space characters.",
    'cu_repair__option_description_domains_resolving' => "Checks that domain names resolve to the appropriate IP addresses.",
    'cu_repair__option_description_home_dir' => "Checks the home directories of additional FTP users.",
    'cu_repair__option_description_junctions' => 'Checks that FTP home junctions exist and point to home directories of corresponding users.',
    'cu_repair__option_description_used_with' => 'Used with the %1 command.',

    'cu_repair__check_fs' => 'Runs the tool for checking the file system. This aspect can be used with individual domains ("plesk repair fs example.com"), and at the server level ("plesk repair fs").',
    'cu_repair__check_fs_title' => 'Checking the file system',
    'cu_repair__check_fs_in_progress' => 'Checking virtual hosts\' file system',
    'cu_repair__check_fs_domain_not_webspace' => 'The domain \'%1\' is not a webspace. Run this command against the following domain to check permissions: \'%2\'.',
    'cu_repair__check_fs_domain_successfully_checked' => 'The domain \'%1\' was checked and no issues were found.',
    'cu_repair__check_fs_domain_checked_with_unresolved_issues' => 'The domain \'%1\' was checked but some issues were not resolved.',
    'cu_repair__check_fs_domain_confirm_repair_permissions' => 'Do you want to repair incorrect permissions?',
    'cu_repair__check_fs_domain_confirm_repair_permissions_in_progress' => 'Repairing incorrect permissions',
    'cu_repair__check_fs_domain_incorrect_permissions_error_title' => 'There are incorrect permissions on some items: %1',
    'cu_repair__check_fs_domain_root_dir_error_title' => 'There are incorrect permissions on some items in the root directory of the domain \'%1\'.',
    'cu_repair__check_fs_domain_wwwroot_dir_error_title' => 'There are incorrect permissions on some items in the WWW root directory of the domain \'%1\'.',
    'cu_repair__check_fs_domain_system_dir_error_title' => 'There are incorrect permissions on some items in the system directory for the domain \'%1\'.',
    'cu_repair__check_fs_domain_no_hosting_error' => 'The specified domain \'%1\' does not have web hosting, so its files cannot be checked.',
    'cu_repair__check_fs_domain_confirm_repair_wwwroot_owner' => 'Do you want to repair incorrect ownership?',
    'cu_repair__check_fs_domain_wwwroot_owner_fix_in_progress' => 'Repairing incorrect ownership',
    'cu_repair__check_fs_domain_wwwroot_owner_error_title' => 'There is incorrect ownership on some items in the WWW root directory of the domain \'%1\'.',
    'cu_repair__check_fs_domain_suspicious_files_and_dirs_error_title' => 'One or more files or directories in the root directory of the domain \'%1\' are either writable by anyone or neither readable nor writable by the owner. Such permissions are insecure and may result in or indicate a security breach.',
    'cu_repair__check_fs_domain_not_found_error' => 'The domain \'%1\' is not found. Please enter a correct domain name.',
    'cu_repair__check_fs_system_in_progress' => 'Checking Linux system files',
    'cu_repair__check_fs_system_confirm_repair_permissions' => 'Do you want to repair incorrect permissions?',
    'cu_repair__check_fs_system_confirm_repair_permissions_in_progress' => 'Repairing incorrect permissions',
    'cu_repair__check_fs_system_incorrect_permissions_error_title' => 'There are incorrect permissions on some items: %1',
    'cu_repair__check_fs_system_incorrect_permissions_webspace_error_title' => 'There are incorrect permissions on some items in the root directory of the domain \'%1\'.',
    'cu_repair__option_description_system' => 'Checks only system files (at the server level).',
    'cu_repair__option_description_vhosts' => 'Checks only virtual hosts\' files (at the server level).',
    'cu_repair__option_plesk_file_consistency' => 'Checks only Plesk files consistency.',
    'cu_repair__mailname_not_found' => 'The mailbox %1 was not found.',
    'cu_repair__domain_not_found' => 'The domain %1 was not found.',
    'cu_repair__only__one_domain_allowed' => 'Only one domain can be repaired at a time.',
    'cu_repair__reconfigure_installation' => 'Reconfigures the Plesk installation.',
    'cu_repair__reconfigure_installation_confirm' => 'Reconfigure the Plesk installation?',
    'cu_repair__reconfigure_installation_title' => 'Reconfiguring the Plesk installation',
    'cu_repair__reconfigure_installation_in_progress' => 'Reconfiguring the Plesk installation',
    'cu_repair__reconfigure_mail' => 'Reconfigures the mail service. This aspect can be used with individual mailboxes ("plesk repair mail johndoe@example.com"), with individual domains ("plesk repair mail example.com"), and on the server level ("plesk repair mail").',
    'cu_repair__reconfigure_mail_title' => 'Reconfiguring the mail service',
    'cu_repair__option_description_only_domain_settings' => 'Reconfigure only domain settings.',
    'cu_repair__option_description_dont_restore_password' => 'Do not restore the password.',
    'cu_repair__option_description_restore_configuration' => 'Restore the configuration files.',
    'cu_repair__option_description_validate_configuration' => 'Validate configuration files.',
    'cu_repair__domain_required' => 'Specify a domain name.',
    'cu_repair__update_php_curl_certificates' => 'Updates the PHP cURL certificates file.',
    'cu_repair__success_update_php_curl_certificates' => 'The PHP cURL certificates file was successfully updated.',
    'cu_repair__restore_configuration_arguments_not_allowed' => 'Arguments are not allowed for the option -%1',
    'cu_repair__mail_reconfigure_all_title' => 'Repairing the mail server configuration',
    'cu_repair__mail_reconfigure_all' => 'Reconfiguring all domains and mailboxes',
    'cu_repair__mail_reconfigure_all_confirm' => 'Reconfigure all domains and mailboxes?',
    'cu_repair__mail_dsmail_inconsistency_warning' => 'We have found the database inconsistency. We strongly recommend that you run "plesk repair db" after the current command is finished or stopped. Once "plesk repair db" fixes the inconsistency, run "plesk repair mail" once again.',
    'cu_repair__mail_dsmail_inconsistency_confirm' => 'Continue with repair mail?',
    'cu_repair__restore_configuration_another_options_not_allowed' => 'No other options can be used with the option -%1',
    'cu_repair__restore_configuration_select_file' => 'Select a configuration file:',
    'cu_repair__restore_configuration_select_revision' => 'Select a revision for %1:',
    'cu_repair__restore_configuration_select_action' => 'Select an action for %1 revision %2',
    'cu_repair__restore_configuration_action_show' => 'Show',
    'cu_repair__restore_configuration_action_write' => 'Restore',
    'cu_repair__restore_configuration_action_quit' => 'Quit',
    'cu_repair__restore_configuration_action_write_success' => 'The file %1 was successfully restored in revision %2',
    'cu_repair__restore_configuration_no_files' => 'No configuration files were found.',
    'cu_repair__mail_reconfigure_domain_confirm' => 'Reconfigure mail on the domains?',
    'cu_repair__mail_reconfigure_mailboxes_confirm' => 'Reconfigure mailboxes on the domains?',
    'cu_repair__mail_reconfigure_domain' => 'Reconfiguring the settings of domains: %1',
    'cu_repair__mail_reconfigure_domains_and_mailboxes' => 'Reconfiguring the domains',
    'cu_repair__mail_reconfigure_mailnames' => 'Reconfiguring the mailboxes',
    'cu_repair__mail_reconfigure_mailname' => 'Reconfiguring %1',
    'cu_repair__mail_service_not_supported' => 'The mail service is not installed in Plesk.',
    'cu_repair__database_structure_corrupted_unix' => 'The database structure is corrupted. You can try to repair it with "%1" and "%2".',
    'cu_repair__database_structure_corrupted_win' => 'The database structure is corrupted. You can try to repair it with "%1".',
    'cu_repair__database_inconsistency' => 'The database is inconsistent. You can try to repair it with "%1".',
    'cu_repair__reconfigure_web_mail_site' => 'Reconfigures the webmail service.',
    'cu_repair__success_reconfigure_web_mail_site' => "The webmail %1 service was successfully reconfigured.\n",
    'cu_repair__reconfigure_packages_success' => 'Installed last available patch.',
    'cu_repair__option_webmail_type' => 'Specifies a webmail service type. Used with the --reconfigure-webmail-site command.',
    'cu_repair__upgrade_mysql_odbc51_dsn' => 'Upgrade all MySQL ODBC 5.1 driver data sources to MySQL ODBC 5.3 Unicode driver.',
    'cu_repair__success_upgrade_mysql_odbc51_dsn' => 'All MySQL ODBC 5.1 driver data sources were successfully upgraded.',
    'cu_repair__json_output_in_the_interactive_mode' => 'JSON output could not be worked in the interactive mode (without -y and -n options)',
    'cu_repair__yes_or_no_answer' => 'The -y and the -n options cannot be specified at the same time. Specify either -y for "yes" or -n for "no".',

    'cu_service_node_option_description_service_node_type' => 'Only for use with the --add command. Specifies the type of the created service node.',
    'cu_service_node_option_description_netmask' => 'Only for use with the --register-ip command. If specified, the IP address with the specified netmask will be created on the service node.',
    'cu_service_node_option_description_ip_type' => 'Only for use with the --register-ip command. If specified, the IP address of the specified type will be registered in Plesk.',
    'cu_service_node_option_description_interface' => 'Only for use with the --register-ip command. If specified, the IP address will be created on the specified interface of the service node.',

    'cu_admin_alias__not_found' => 'Unable to find the additional administrator account %1.',
    'cu_admin_alias__login_too_long' => 'The username length exceeds 20 characters.',
    'cu_admin_alias__save_error' => 'Unable to apply changes to the administrator account.',

    'cu_initconf__send_announce' => 'I would like to receive newsletters from Plesk. They may contain security-related, technical, and general product information. I consent and authorize Plesk to collect, process and use my personal data (email), including cross-border processing, in accordance with the applicable data protection laws currently in effect for sending me newsletters either directly or through a 3rd party service. Unchecking this checkbox revokes my consent and orders Plesk to stop sending me emails and permanently remove my personal data from its systems. (default: %1)',
    'cu_initconf__send_announce_consent' => 'I would like to receive newsletters from Plesk. They may contain security-related, technical, and general product information. I consent and authorize Plesk to collect, process and use my personal data (email), including cross-border processing, in accordance with the applicable data protection laws currently in effect for sending me newsletters either directly or through a 3rd party service. Unchecking this checkbox revokes my consent and orders Plesk to stop sending me emails and permanently remove my personal data from its systems.',
    'cu_initconf__send_personalized_announce' => 'Yes, please, I agree to receiving my personalized Plesk Newsletter. Plesk International GmbH and its affiliates may store and process the data I provide for the purpose of delivering the newsletter according to the %1. In order to tailor its messages and offers to me, Plesk may also use additional information for profiling, like usage and behavior data. I can unsubscribe from the mailing list(s) at any time. (default: %2)',
    'cu_initconf__send_personalized_announce_consent' => 'Yes, please, I agree to receiving my personalized Plesk Newsletter. Plesk International GmbH and its affiliates may store and process the data I provide for the purpose of delivering the newsletter according to the privacyPolicy. In order to tailor its messages and offers to me, Plesk may also use additional information for profiling, like usage and behavior data. I can unsubscribe from the mailing list(s) at any time.',
    'cu_initconf__install_trial' => 'To issue a trial license, Plesk International GmbH will use and process the provided information in its internal systems according to the Plesk Privacy Policy (%1). (default: %2)',
    'cu_initconf__install_trial_consent' => 'To issue a trial license, Plesk International GmbH will use and process the provided information in its internal systems according to the Plesk Privacy Policy (%1).',
    'cu_initconf__install_trial_license_credentials_needed' => 'In order to install trial license you have to provide your email',

    'cu_cl_pref__access_service_users' => 'Ability to manage additional user accounts',

    'cu_passwords__secure' => 'The enhanced security mode is turned on.',
    'cu_passwords__unsecure' => 'The enhanced security mode is turned off.',
    'cu_passwords__encrypt' => 'Turns on the enhanced security mode',
    'cu_passwords__decrypt' => 'Turns off the enhanced security mode',
    'cu_passwords__status' => 'Shows the current state of the mode',

    'cu_backup_encrypt_command_encrypt' => 'Decrypts user passwords in a backup with a specified key and encrypts them again with the Plesk key',
    'cu_backup_encrypt_command_decrypt' => 'Decrypts user passwords in a backup with the Plesk key and encrypts them again with a specified key. If the key is not specified, passwords are decrypted to plain text',

    'cu_pleskrestore_backup_password_opt' => 'If you used password protection for a backup, use this option to specify the password. You can also set the password with the environment variable PLESK_BACKUP_PASSWORD.',
    'cu_pleskrestore_ignore_backup_password_opt' => 'Allows you to restore a backup without providing the backup password. Note that in this case, some sensitive data will not be restored properly. For example, user passwords will be replaced with random ones, the information about already installed APS apps will be lost, and so on.',
    'cu_pleskbackup_backup_password_opt' => 'You can use a password to encrypt users\' passwords contained in the Plesk database in a backup. Restoring a password-protected backup without providing the password will make Plesk generate the users\' passwords randomly. You can provide a password either with this option or with the PLESK_BACKUP_PASSWORD environment variable. Note that Plesk does not protect all sensitive data in a backup. We recommend you store backups in remote cloud storage and enable backup encryption on the cloud storage side.',
    'cu_pleskrestore_async' => 'Restores the backup asynchronously, which means it returns the restoration task\'s identifier, which you can use to retrieve the task\'s status. Used with the --restore command.',

    'cu__pleskrestore_check_dump_backup_file_is_valid' => 'The backup file is valid.',
    'cu__pleskrestore_check_dump_wrong_format' => 'Incorrect format of the backup file.',
    'cu__pleskrestore_check_dump_power_user_forbidden' => 'The backup of Plesk in Service Provider view cannot be restored to Plesk running in Power User view.',
    'cu__pleskrestore_check_dump_not_suitable_key' => 'Unable to decrypt the backup: The specified key is not suitable.',
    'cu__pleskrestore_check_dump_content_corrupted' => 'The following content files were corrupted: ',

    'cu__pleskrestore_check_dump_wrong_signature' => 'The specified backup file is corrupted, modified, created on another server or in an earlier Plesk version. To restore it, use the -ignore-sign option.',
    'cu_pleskrestore_ignore_sign_opt' => 'Restores a backup file despite a corrupted signature.',
    'cu_pleskrestore_configuration_only_opt' => 'Restores configuration only (without content). Used with the -level, -only-mailnames, -only-databases, -only-sites and -only-maillists options.',
    'cu_pleskrestore_content_only_opt' => 'Restores content only (without configuration). Used with the -only-mailnames, -only-databases, -only-sites and -only-maillists options.',
    'cu_pleskrestore_content_options_conflict_error' => 'Only one of the options (-configuration-only or -content-only) can be used. To restore both configuration and content, omit both these options.',

    'cu_pleskrestore_only_mailnames_opt' => 'Specifies a list of mailboxes for restoration. The list can be read from a file or specified in a comma-separated list. The format of a list item is <mailbox>@<domain_name>. Use the additional option -domain-name to specify the subscription for which you want to restore the mailboxes.',
    'cu_pleskrestore_only_mailnames_opt_empty_error' => 'The list of mailboxes provided for the option -only-mailnames must not be empty.',
    'cu_pleskrestore_only_databases_opt' => 'Specifies a list of databases for restoration. The list can be read from a file or specified in a comma-separated list. The format of a list item is [<server_type>:[<server_host>:[<server_port>:]]]<database_name>, where server_type is mysql, mssql, or postgresql. Use the additional option -domain-name to specify the subscription for which you want to restore the databases.',
    'cu_pleskrestore_only_databases_opt_empty_error' => 'The list of databases provided for the option -only-databases must not be empty.',
    'cu_pleskrestore_only_databases_opt_ambiguous_error' => "The specified list of databases is ambiguous. Specify database names in the following format: <server_type>:<server_host>:[<server_port>:]<database_name>.\nError: %1\n\nTo retrieve the list of databases from a backup, use the --info parameter with the -only-databases option, for example:\npleskrestore --info <path to dump> -only-databases [-domain-name <domain name>]",
    'cu_pleskrestore_only_web_content_opt' => 'Specifies a list of files or directories for restoration. The list can be read from a file or specified in a comma-separated list. Paths to files and directories should be relative to the subscription root. Use the additional option -domain-name to specify the subscription for which you want to restore the files.',
    'cu_pleskrestore_only_web_content_opt_empty_error' => 'The list of files provided for the option -only-web-content must not be empty.',
    'cu_pleskrestore_domain_name_opt' => 'Specifies the domain name. Used with the -only-mailnames, -only-maillists, -only-databases, -only-web-content, -only-dns-zones, -only-sites or -only-certificates options.',
    'cu_pleskrestore_domain_name_opt_required_error' => 'The option -domain-name is required.',
    'cu_pleskrestore_level_opt_conflict_error' => 'More than one of the following options were specified: -level, -only-mailnames, -only-maillists, -only-databases, -only-web-content, -only-dns-zones, -only-sites or -only-certificates. Use only one option.',
    'cu_pleskrestore_level_opt_required_error' => 'One of the following options is required: -level, -only-mailnames, -only-maillists, -only-databases, -only-web-content, -only-dns-zones, -only-sites or -only-certificates.',
    'cu_pleskrestore_configuration_only_option_inapplicable_error' => 'The option -configuration-only can be used only with the -level, -only-mailnames, -only-databases, -only-sites, or -only-maillists options.',
    'cu_pleskrestore_content_only_option_inapplicable_error' => 'The option -content-only can be used only with -only-mailnames, -only-databases, -only-sites, or -only-maillists options.',
    'cu_pleskrestore_only_sites_opt' => 'Specifies a list of sites for restoration. The list can be read from a file or specified in a comma-separated list. The format of a list item is <domain_name>. Use the additional option -domain-name to specify the subscription for which you want to restore the sites.',
    'cu_pleskrestore_only_sites_opt_empty_error' => 'The list of sites provided for the option -only-sites must not be empty.',
    'cu_pleskrestore_only_dns_opt' => 'Specifies a list of DNS zones for restoration. The list can be read from a file or specified in a comma-separated list. The format of a list item is <domain_name>. Use the additional option -domain-name to specify the subscription for which you want to restore the DNS zones.',
    'cu_pleskrestore_only_dns_opt_empty_error' => 'The list of sites provided for the option -only-dns-zones must not be empty.',
    'cu_pleskrestore_only_maillists_opt' => 'Specifies a list of mailing lists for restoration. The list can be read from a file or specified in a comma-separated list. The format of a list item is <mailing list>@<domain_name>. Use the additional option -domain-name to specify the subscription for which you want to restore the mailing lists.',
    'cu_pleskrestore_only_maillists_opt_empty_error' => 'The list of mailing lists provided for the option -only-maillists must not be empty.',
    'cu_pleskrestore_only_certificates_opt' => 'Specifies a list of SSL/TLS certificates for restoration. The list can be read from a file or specified in a comma-separated list. The format of a list item is <certificate_name>[:<domain_name>]. Use the additional option -domain-name to specify the subscription for which you want to restore the certificates. Use the additional option -server-pool to specify that restored certificates are in the server pool.',
    'cu_pleskrestore_only_certificates_opt_empty_error' => 'The list of certificates provided for the option -only-certificates must not be empty.',
    'cu_pleskrestore_server_pool_opt' =>  'Specifies that SSL/TLS certificates are from the server pool. Use with the -only-certificates option.',
    'cu_pleskrestore_domain_name_does_not_exist_in_backup' => 'The subscription %1 specified by the -domain-name option does not exist in the backup.',
    'cu_pleskrestore_subscription_not_found_error' => 'The subscription %1 is not found in Plesk.',
    'cu_pleskrestore_subscription_not_found_in_dump_error' => 'The subscription %1 is not found in the backup file.',
    'cu_pleskbackup_unable_to_parse_url' => 'Unable to determine the URL of the output file. If you provided an FTP password as part of the URL and the password contains special symbols (:/@\\), consider using the -ftp-password option or FTP_PASSWORD environment variable instead. Call pleskbackup --help for more information.',
    'cu_pleskbackup_invalid_ext_url' => 'The specified value is invalid: %1. A valid value must follow the pattern ext://{extension-name}/{server|reseller|client|domain}/[object ID/].',
    'cu_pleskbackup_incremental_creation_date_opt' => 'Specifies the creation date of the full (initial) backup that corresponds to an incremental backup. The date must be in the YYMMDDHHMM format. Used with --prefix to create an incremental backup.',
    'cu_pleskbackup_incremental_opt' => 'Creates an incremental backup. If no suitable full backup is available, this option will be skipped.',

    // Please notify mtrishchenkov@ after translating these messages because it is needed to write similar one
    // in another place where lmsg is not available.
    'cu_pleskrestore_not_available_in_hg_mode' => 'The pleskrestore utility is not available in multi-server mode.',
    'cu_pleskbackup_not_available_in_hg_mode' => 'The pleskbackup utility is not available in multi-server mode.',

    'cu_cb__noframe' => "If a custom button leads to a Plesk extension or an app in the Customer Panel, this parameter specifies how the extension/app should be displayed: in a frame (true) or as a part of the Plesk GUI (false). (Default: %1)",
    'cu_custom_plan_items__list_item_noframe' => 'If a custom button leads to a Plesk extension or an app, this parameter specifies how the extension/app should be displayed: in a frame (true) or as a part of the Plesk GUI (false).',

    'cu__license_command_install' => "If a file name is provided, installs the license key from the file. If a code is provided, installs the license key that is associated with the code.",
    'cu__license_command_get_instance_id' => "Returns the instance ID of a license key.",
    'cu__license_option_check_updates' => "Do not install a license key if an update for the already installed key is available (false by default).",
    'cu__license_option_instance_id' => "The instance ID of a license key.",
    'cu__license_option_not_check_limits' => "Do not check the resource usage limits defined by the key.",
    'cu__license_option_additional_key' => "Specifies whether the provided code activates an additional license key. You can omit this option if you are installing the primary Plesk license key.",
    'cu__license_install_bad_value' => "The value specified with the --install command is neither a file nor an activation code.",
    'cu__license_install_success' => "The license key was successfully installed.",
    'cu__license_install_file_not_exist' => 'The file "%1" does not exist.',
    'cu__license_install_file_not_readable' => 'Unable to read the file "%1".',
    'cu__license_install_zip_no_key_file' => "Unable to find a license key in the uploaded .ZIP file.",
    'cu__license_install_invalid_key_file' => "The license key file is invalid: %1.",
    'cu__license_install_check_updates_fail' => "An update for the installed license key is found. The new key will not be installed.",
    'cu__license_update_failed' => 'Unable to update the product license.',
    'cu__license_server_request_error' => 'Could not update the license. Make sure that connections to the license server ka.plesk.com on TCP port %1 are not blocked. To fix the issue, follow the instructions described in KB https://support.plesk.com/hc/en-us/articles/213383529.',
    'cu__license_command_retrieve' => "Retrieves license keys.",
    'cu__license_retrieve_invalid_main_key' => "Unable to read Plesk license key.",
    'cu__license_retrieve_update_main_key' => "Updating Plesk license key:",
    'cu__license_retrieve_update_additional_key' => "Updating license key %1:",
    'cu__license_retrieve_failed' => "Failed (%1)",
    'cu__license_retrieve_success' => "Done",

    'cu__php_settings__command_update_all' => "Update per-domain PHP settings of all domains in accordance with the server-wide php.ini file.",
    'cu__php_settings__update_all_done' => "Per-domain PHP settings of all domains were successfully updated.",

    'cu_role__opt_subscription_name' => 'Allow users to access a specified subscription only',
    'cu_role__opt_for_all_subscription' => 'Allow users to access all subscriptions within a hosting account',
    'cu_role__subscription_not_found_role_is_not_limited' => 'Unable to apply changes to the role: The subscription %1 was not found.',

    'cu_db__success_create_dbuser' => 'The database user was successfully created.',
    'cu_db__create_dbuser' => 'Creates a database user with the specified name.',
    'cu_db__success_update_dbuser' => 'The database user was successfully updated.',
    'cu_db__update_dbuser' => 'Updates a database user with the specified name.',
    'cu_db__success_remove_dbuser' => 'The database user was successfully removed.',
    'cu_db__remove_dbuser' => 'Removes a database user with the specified name.',
    'cu_db__dbuser_already_exist' => 'A database user with the name "%1" already exists.',
    'cu_db__register' => 'Registers an existing database in Plesk.',
    'cu_db__register_dbuser' => 'Registers an existing database user in Plesk.',
    'cu_db__success_register_database' => 'The database was successfully registered.',
    'cu_db__success_register_dbuser' => 'The database user was successfully registered.',
    'cu_db__success_check_connect_database' => 'Connection to the database is successfully established.',
    'cu_db__update_dbuser_remote_access_rules' => 'Updates the remote access rules for the database user with the specified ID.',
    'cu_db__success_update_database_user_remote_access_rules' => 'The remote access rules were successfully updated.',
    'cu_db__unable_update_database_user_remote_access_rules' => 'Unable to update the remote access rules: %1.',
    'cu_db__database' => 'Sets the database to which a database user will have access. Used with the --create-dbuser and --update-dbuser commands.',
    'cu_db__any_database' => 'Grants a database user access to all databases within the corresponding hosting account. Used with the --create-dbuser and --update-dbuser commands.',
    'cu_db_set_privileges' => "Sets privileges for the specified MySQL database user on the specified database: 'Select', 'Insert', 'Update', 'Delete', 'Create', 'Drop', 'References', 'Alter', 'Index', 'Create Temporary Tables', 'Lock Tables', 'Create View', 'Show View', 'Create Routine', 'Alter Routine', 'Execute', 'Event' (starting from MySQL 5.1), 'Trigger' (starting from MySQL 5.1). Sets global privileges for the specified user (on all databases within the hosting account): 'File'.",
    'cu_db_invalid_privileges_error' => 'The following privilege names are invalid: %1. The allowed names are %2.',
    'cu_db__user_role' => 'Sets the database user\'s role. Used with the --create-dbuser and --update-dbuser commands.',

    'cu__command_update_web_server_settings' => 'Updates the web server settings.',
    'cu__command_show_web_server_settings' => 'Shows the current web server settings.',

    'cu__apache_mime_types' => "Sets MIME types for the specified website replacing the currently configured MIME types. For example: 'text/plain .txt image/jpeg .jpeg'.",
    'cu__mime-type' => "Sets MIME types for the specified website replacing the currently configured MIME types. For example: 'text/plain .txt; image/jpeg .jpeg'.",
    'cu__apache_handlers' => "Sets Apache handlers for the specified website. For example: 'php-script .html cgi-script .cgi'.",
    'cu__apache_directory_index' => "Sets index pages for the specified website. For example: 'index.html index.htm index.text /cgi-bin/index.pl'.",
    'cu__ip_deny' => "Sets a list of IP addresses that will be denied access to the specified website. Use spaces to separate IP addresses. For example: '10.1.0.0/16 192.168.1.110'.",
    'cu__ip_allow' => "Sets a list of IP addresses that will be allowed access to the specified website. Use spaces to separate IP addresses. For example: '192.168.0.0/16 10.1.1.21'.",
    'cu__php_handler_id' => "Associates the PHP handler with the site. Specify the handler's identifier (default: %1).",
    'cu__php_served_by_nginx' => "PHP served by nginx",
    'cu__nginx_proxy_mode' => 'Turns on/off proxy mode for the nginx reverse proxy server.',
    'cu__nginx_transparent_mode' => 'Turns on/off transparent mode for the nginx reverse proxy server. In this mode, Apache handles both static and dynamic content, while nginx only passes HTTP requests and responses without modification.',
    'cu__nginx_serve_static' => 'Turns on/off serving static content by the nginx reverse proxy server.',
    'cu__nginx_static_extensions' => 'Sets static files extensions that should be served directly by nginx. If you specify an empty value, the static files extensions from the default nginx configuration (/var/www/vhosts/domain1.tld/.plesk/conf/last_nginx.conf) will be used. Use this option with the -nginx-serve-static command.',
    'cu__nginx_serve_php' => 'Turns on/off processing PHP files by the nginx reverse proxy server.',
    'cu__web_server_expires' => 'Sets "Expires" response headers. The time is computed as a sum of the request time and the specified in the directive. For example: 86400 (1 day)',
    'cu__web_server_expires_static_only' => 'Turns on/off response with "Expires" headers for static files only.',
    'cu__web_server_headers' => 'Sets a list of additional HTTP response headers.',
    'cu__add_web_server_header' => 'Adds a header to the list of additional HTTP response headers.',
    'cu__web_server_no_hosting' => 'Unable to set web server settings for a domain without the web hosting service.',
    'cu__nginx_cache_enabled' => 'Enable nginx caching. Caching may reduce website response time and server load, but should be used with care.',
    'cu__nginx_cache_size' => 'Cache size (in bytes).',
    'cu__nginx_cache_timeout' => 'Cache timeout (in seconds).',
    'cu__nginx_cache_key' => 'Cache key.',
    'cu__nginx_cache_cookies' => 'Cache requests with cookies.',
    'cu__nginx_cache_bypass_locations' => 'Disable caching for locations.',
    'cu__nginx_cache_bypass_header_nocache' => 'Bypass cache when HTTP no-cache headers are received in request.',
    'cu__nginx_cache_bypass_header_auth' => 'Bypass cache when HTTP authorization headers are received in request.',
    'cu__nginx_cache_bypass_get_nocache' => 'Bypass cache when GET nocache parameter is received in request.',
    'cu__nginx_cache_use_stale_5xx' => 'Return stale cached records when upstream returns 5xx server error.',
    'cu__nginx_cache_use_stale_4xx' => 'Return stale cached records when upstream returns 4xx client error.',
    'cu__nginx_cache_use_stale_updating' => 'Return stale cached records when cache is being updated.',

    'cu_admin__set_password' => "Updates the Plesk administrator's password.",
    'cu_admin__passwd' => "The Plesk administrator's password. For security details, see the note below all the options.",
    'cu_admin__success_set_password' => "The Plesk administrator's password was successfully updated.\n",
    'cu_admin__custom_view_option' => "(applicable only to Restricted Mode)",
    'cu_admin__get_login_link' => 'Generates a link with a secret token which allows logging in to Plesk without username and password.',
    'cu_admin__user' => 'Specifies the user name to generate a one-time login link. Used with \'--get-login-link\' and \'--get-reset-link\'.',
    'cu_admin__relative_url' => 'Generates a relative URL for a one-time login link. Used with \'--get-login-link\'.',
    'cu_admin__support' => 'Generates a one-time login link for support usage. Used with \'--get-login-link\'.',
    'cu_admin__get_reset_link' => 'Generates a link with a secret token to reset a user\'s password.',
    'cu_admin__get_reset_link_not_allowed_admin' => 'The password reset link cannot be used to reset a Plesk administrator\'s password.',
    'cu_admin__show_password_deprecated' => 'Due to security reasons the option \'-show-password\' is no longer supported. Use \'--get-login-link\' to generate a one-time login link.',
    'cu_admin__enable_access_domain' => 'Enable access to Plesk over the TCP port 443 (HTTPS) using one of domains, or subdomains, or an empty value for the default domain.',
    'cu_admin__disable_access_domain' => 'Disable access to Plesk over the TCP port 443 (HTTPS).',
    'cu_admin__access_domain_enabled' => 'Plesk is now accessible over the TCP port 443 (HTTPS) using the domain: %1.',
    'cu_admin__access_domain_disabled' => 'Plesk is now accessible only over the port %1.',
    'cu_admin__cannot_change_password_while_cloning' => 'The Plesk administrator password cannot be changed until the server cloning is finished.',
    'cu_admin__set_login_secret_length' => 'The secret token length cannot be shorter than %1 and longer than %2.',
    'cu_admin__set_login_secret_used' => 'The secret token is already registered.',

    'cu__limit_val_is_not_percentage' => "The limit '%1' must be between 1% and 100%. Because the specified value was incorrect, it was converted to %2\n",
    'cu__bytes' => "bytes",
    'cu__mbytes' => "MB",

    'cu__php_handler__command_add' => 'Registers a new PHP handler.',
    'cu__php_handler__command_update' => 'Updates an existing PHP handler.',
    'cu__php_handler__command_remove' => 'Removes a PHP handler.',
    'cu__php_handler__command_enable' => 'Enables a PHP handler.',
    'cu__php_handler__command_disable' => 'Disables a PHP handler.',
    'cu__php_handler__command_get_usage' => 'Shows the usage of a PHP handler.',
    'cu__php_handler__command_get_usage_unused' => 'The PHP handler with ID "%1" is not used.',
    'cu__php_handler__command_list' => 'Displays the list of all PHP handlers registered in Plesk.',
    'cu__php_handler__command_list_note' => "The --list command displays registered PHP handlers in the list that contains the following data:\nid: Automatically created handler's identifier\ndisplay name: Displayed as the \"PHP version\" in the Plesk UI\nfull version: Full PHP version\nversion: Short PHP version\ntype: Displayed as the \"Run PHP as\" in the Plesk UI\ncgi-bin: Path to PHP\nphp.ini: Path to php.ini\ncustom: Whether the handler is default or custom",
    'cu__php_handler__command_reread' => 'Refreshes information about PHP handlers in Plesk. Use after you changed PHP handlers not through Plesk.',
    'cu__php_handler__command_replace' => 'Replaces a certain PHP handler with another one for all service plans and websites in Plesk.',
    'cu__php_handler__command_add_done' => 'The new PHP handler with the id "%1" was successfully registered.',
    'cu__php_handler__command_update_done' => 'The PHP handler was successfully updated.',
    'cu__php_handler__command_remove_done' => 'The PHP handler was successfully removed.',
    'cu__php_handler__command_enable_done' => 'The PHP handler with ID "%1" was successfully enabled.',
    'cu__php_handler__command_disable_done' => 'The PHP handler with ID "%1" was successfully disabled.',
    'cu__php_handler__command_reread_done' => 'The information about PHP handlers was successfully updated.',
    'cu__php_handler__command_replace_done' => 'The PHP handler was successfully replaced.',
    'cu__php_handler__option_displayname' => 'Sets the name for the PHP handler to be displayed in the GUI (use with the "add" and "update" commands).',
    'cu__php_handler__option_path' => 'Sets the path to the php-cgi binary file (use with the "add" and "update" commands).',
    'cu__php_handler__option_clipath' => 'Sets the path to the php-cli binary file (use with the "add" and "update" commands).',
    'cu__php_handler__option_phpini' => 'Sets the path to the php.ini file (use with the "add" and "update" commands).',
    'cu__php_handler__option_type' => 'Sets the PHP handler type (use with the "add" and "update" commands).',
    'cu__php_handler__option_service' => 'Sets the service name (use with the "add" and "update" commands for "fpm" types).',
    'cu__php_handler__option_poold' => 'Sets the path to the pool.d directory (use with the "add" and "update" commands for "fpm" types).',
    'cu__php_handler__option_id' => 'Sets the PHP handler identifier (use with the "add", "update", "remove", "enable", "disable", and "get-usage" commands). To view the identifiers of registered handlers, use the "list" command.',
    'cu__php_handler__option_old_id' => 'Specifies the PHP handler you want to replace (use with the "replace" command).',
    'cu__php_handler__option_new_id' => 'Specifies the PHP handler with which you want to replace the existing one (use with the "replace" command).',
    'cu__php_handler__option_json' => 'Displays the result of command in JSON format (use with the "list" and "get-usage" commands). Use this to pass information about PHP handlers to scripts.',
    'cu__php_handler__option_service_node' => 'Sets service node for setting PHP handler (use in all commands).',
    'cu__php_handler__error_service_node_is_not_web_node' => 'The service node must be a web server node.',
    'cu__php_handler__error_service_node_is_not_unix' => 'The service node must be a Linux node.',

    'phpManager__php_handler_register_error' => 'Unable to register the PHP handler: %1',
    'phpManager__php_handler_update_error' => 'Unable to update the PHP handler: %1',
    'phpManager__php_handler_remove_error' => 'Unable to remove the PHP handler: %1',
    'phpManager__php_handler_not_found' => 'The PHP handler "%1" is not found.',
    'phpManager__php_handler_module_turned_off' => 'Cannot enable the Apache module handler because the corresponding Apache module is turned off.',
    'phpManager__php_handler_already_used_in_plans' => 'The PHP handler is used in service plans.',
    'phpManager__php_handler_already_used_in_sites' => 'The PHP handler is used in site configurations.',
    'phpManager__php_handler_already_used_in_scheduled_tasks' => 'The PHP handler is used in scheduled tasks.',
    'phpManager__php_handler_displayname_wrong_encoding' => 'The encoding of "displayname" must be UTF-8.',
    'phpManager__only_custom_handlers_removing_allowed' => 'You can remove only custom handlers.',
    'phpManager__site_update_error' => 'Failed to update configuration of the site %1: %2',
    'phpManager__php_handler_wrong_value' => 'An incorrect PHP handler ID was specified. The following values are possible for php_handler_id: %1',
    'phpManager__php_handler_apache_fpm_not_available' => 'PHP-FPM cannot work with Apache on this operating system. To use PHP-FPM with nginx, set the option %1 to "true".',
    'phpManager__php_handler_nginx_without_fpm_not_available' => 'PHP scripts cannot be processed by nginx if the Plesk CGI or FastCGI handler is selected. Either omit the "-nginx-serve-php" option, or select the PHP-FPM handler.',

    'phpHandlerSettings_by_os_vendor' => '%1 by OS vendor',

    'cu__lengthInvalid' => "'%1' cannot be shorter than %2 or longer than %3 characters.",
    'cu__regexNotMatch' => "'%1' does not match the pattern '%2'.",

    'cu_mailserver__error_set_max_connections_driver_not_supported' => 'The "set-max-connections" option is not supported.',
    'cu_mailserver__error_set_max_connections_driver_not_supported_api' => '"max_connections" is not supported',
    'cu_mailserver__error_set_max_connections_per_ip_driver_not_supported' => 'The "set-max-connections-per-ip" option is not supported.',
    'cu_mailserver__error_set_max_connections_per_ip_driver_not_supported_api' => '"max_connections_per_ip" is not supported',

    'cu_ip_ban__enable' => 'Enable IP address banning.',
    'cu_ip_ban__disable' => 'Disable IP address banning.',
    'cu_ip_ban__update' => 'Updates IP address banning settings.',
    'cu_ip_ban__info' => 'Displays information about IP address banning settings.',
    'cu_ip_ban__ban_period' => 'Sets IP address ban period.',
    'cu_ip_ban__ban_period_title' => 'IP address ban period',
    'cu_ip_ban__ban_time_window' => 'Sets time interval for detection of subsequent attacks.',
    'cu_ip_ban__ban_time_window_title' => 'Time interval for detection of subsequent attacks',
    'cu_ip_ban__max_retries' => 'Sets the maximum number of failed login attempts.',
    'cu_ip_ban__max_retries_title' => 'The maximum number of failed login attempts',
    'cu_ip_ban__status' => 'Status',
    'cu_ip_ban__enabled' => 'active',
    'cu_ip_ban__disabled' => 'inactive',
    'cu_ip_ban__time_unit' => 'seconds',
    'cu_ip_ban__not_installed' => 'The Fail2Ban component is not installed.',
    'cu_ip_ban__settings_updated' => 'The settings were updated.',
    'cu_ip_ban__trusted' => 'The list of trusted IP addresses.',
    'cu_ip_ban__trusted_ips_title' => 'Trusted IP addresses:',
    'cu_ip_ban__banned' => 'The list of banned IP addresses.',
    'cu_ip_ban__banned_ips_title' => 'Banned IP addresses:',
    'cu_ip_ban__add_trusted' => 'Adds IP addresses to the list of trusted addresses.',
    'cu_ip_ban__remove_trusted' => 'Removes the selected IP addresses from the list of trusted addresses.',
    'cu_ip_ban__jails' => 'The list of jails.',
    'cu_ip_ban__jails_title' => 'Jails:',
    'cu_ip_ban__jail_enabled' => 'active',
    'cu_ip_ban__jail_disabled' => 'inactive',
    'cu_ip_ban__enable_jails' => 'Switches on the selected jails.',
    'cu_ip_ban__disable_jails' => 'Switches off the selected jails.',
    'cu_ip_ban__unban' => 'Unbans IP addresses.',
    'cu_ip_ban__ips_unbanned' => 'The selected IP addresses were unbanned.',
    'cu_ip_ban__enable_firts' => 'To be able to activate a jail, switch on Fail2Ban first.',

    'cu_migrate__list_subscriptions' => 'Displays the list of subscriptions available for transfer.',
    'cu_migrate__list_clients' => 'Displays the list of clients available for transfer.',
    'cu_migrate__list_resellers' => 'Displays the list of resellers available for transfer.',
    'cu_migrate__source_host' => 'Host name or IP address of the source server',
    'cu_migrate__source_port_unix' => 'SSH port at the source server, by default 22',
    'cu_migrate__source_login_unix' => 'The username used to access the source server over SSH, by default "root"',
    'cu_migrate__source_login_win' => 'The username of the source server\'s administrator, by default "Administrator"',
    'cu_migrate__source_password' => 'The password of the source server\'s administrator',
    'cu_migrate__source_cache_path' => 'Path to the Migration & Transfer Agent directory on the source server',
    'cu_migrate__local_cache_path' => 'Path to the temporary location of all downloads on the target server',

    'cu_migrate_subscription_command' => 'Migrates the specified subscriptions.',
    'cu_migrate__mail_only_option' => 'Migrates only mail configuration and content.',
    'cu_migrate__web_only_option' => 'Migrates configuration and content except mail.',
    'cu_migrate__replace_existing_objects' => 'Replaces (overwrites) existing objects.',
    'cu_migrate__only_one_content_type_allowed' => 'Only one of the options can be used: -mail-only or -web-only.',
    'cu_migrate_reseller_command' => 'Migrates the specified resellers.',
    'cu_migrate_client_command' => 'Migrates the specified customers.',
    'cu_migrate__report_migration_started' => 'Migration started at: %1',
    'cu_migrate__report_migration_finished' => 'Migration finished at: %1',
    'cu_migrate__report_objects_to_migrate' => 'Data to transfer: %1 accounts, %2 subscriptions.',
    'cu_migrate__migration_finished_success' => 'Migration was finished successfully.',
    'cu_migrate__migration_finished_failed' => 'Migration failed.',
    'cu_migrate__migration_finished_warnings' => 'Migration was finished successfully with several warnings. See log files for more information.',
    'cu_migrate__migration_finished_info' => 'Migration was finished successfully. See log files for more information.',
    'cu_migrate__migration_additional_log_files' => 'You can view additional information in the log file located in the %1 directory. This directory will be removed automatically in 30 days after the migration.',
    'cu_migrate__ip_mapping' => 'Path to the file with IP address mapping. Records in the file must be in the following format: <source IP address> at least one space <destination IP address>. Each record must be on a new line.',
    'cu_migrate__ip_does_not_exist' => 'IP address %1 does not exist in the system. Please specify another address.',
    'cu_migrate__check_subscriptions' => 'Checks the specified subscriptions for potential problems that might occur after transfer.',
    'cu_migrate__check_clients' => 'Checks the specified customers for potential problems that might occur after transfer.',
    'cu_migrate__check_resellers' => 'Checks the specified resellers for potential problems that might occur after transfer.',
    'cu_migrate__check_ip_mapping' => 'IP address mapping:',
    'cu_migrate__check_ip_mapping_manual' => 'You need to map the following IP addresses manually because they have not been mapped automatically:',
    'cu_migrate__check_migration_issues' => 'The following migration issues have been found:',
    'cu_migrate__owner_login' => 'Specifies a new owner for migrated Plesk objects. If not specified, then all objects will be owned by the administrator.',
    'cu_migrate__owner_not_found' => 'The specified owner %1 does not exist in Plesk.',
    'cu_migrate_server_command' => 'Migrates the entire server.',
    'cu_migrate__accounts_only' => 'Do not migrate server settings, migrate only business objects. Used only with the --migrate-server command. ',
    'cu_migrate__skip_license' => 'Do not migrate the license key. Used only with the --migrate-server command.',
    'cu_migrate_from_cache_command' => 'Repeats data restoration from the files created during the last migration.',
    'cu_migrate_skipped_options' => 'The following options are not allowed and their values will be skipped: %1',
    'cu_migrate__absent_shared_ips' => 'Unable to perform migration: There are no vacant shared IP addresses for mapping. Please add at least one shared IP address.',
    'cu_migrate__migration_details' => 'Migration details:',
    'cu_migrate__error_reseller_is_customer' => '%1 is not a customer, but a reseller. Please specify customer accounts.',
    'cu_migrate__error_customer_is_reseller' => '%1 is not a reseller, but a customer. Please specify reseller accounts.',
    'cu_migrate__error_session_not_found' => 'Unable to find any open migration sessions to retry migration.',

    'cu__command_update_web_app_firewall' => 'Updates the web application firewall settings.',
    'cu__command_show_web_app_firewall' => 'Shows the current web application firewall settings.',
    'cu__web_app_firewall_rule_engine' => 'Sets the web application firewall mode.',
    'cu__web_app_firewall_rule_engine_invalid' => 'Unable to change the web application firewall mode to %1. Allowed values are %2.',
    'cu__web_app_firewall_rule_set_invalid' => 'Unable to change the web application firewall rule set to %1. Allowed values are %2.',
    'cu__web_app_firewall_web_server' => 'Run the rule set on the given web server.',
    'cu__web_app_firewall_web_server_invalid' => 'Unable to change the web application firewall web server to \'%1\'. Allowed values are: %2.',
    'cu__web_app_firewall_web_server_rule_invalid' => 'The \'%1\' rule set cannot be run on \'%2\'. Allowed values are: %3.',
    'cu__web_app_firewall_nginx_switched_off' => 'Reverse Proxy Server (nginx) is switched off and cannot be used to process requests.',
    'cu__web_app_firewall_not_installed' => 'ModSecurity is not installed on the server.',
    'cu__web_app_firewall_disabled' => 'ModSecurity is turned off on the server.',
    'cu__web_app_firewall_no_hosting' => 'Unable to enable the web application firewall for a domain without the web hosting service.',
    'cu__web_app_firewall_rule_set' => 'Sets the web application firewall rule set.',
    'cu__web_app_firewall_tortix_not_installed' => 'The Tortix rule set is not installed.',
    'cu__web_app_firewall_rule_set_requires_credentials' => '%1 rule set requires credentials in the environment: %2 and %3.',
    'cu__web_app_firewall_archive_path' => 'Sets the path to a custom archive.',
    'cu__web_app_firewall_custom_need_archive' => 'The option -waf-archive-path should be specified.',
    'cu__web_app_firewall_archive_not_found' => "Custom rule set file '%1' not found.",
    'cu__web_app_firewall_preset' => 'Select predefined set of values.',
    'cu__web_app_firewall_update_period' => 'Sets update frequency.',

    'cu_dom_tpl__apache_settings' => 'Apache settings',
    'cu_dom_tpl__apache_restrict_follow_sym_links' => 'Restricts the ability to follow symbolic links.',
    'cu__apache_restrict_follow_sym_links' => 'Restricts the ability to follow symbolic links.',

    'cu__max_worker_processes' => 'The maximum number of worker processes permitted to service requests for IIS application pool.',
    'cu__max_worker_processes_numa' => 'On NUMA-based systems, if you set this number to 0, IIS will start as many worker processes as there are NUMA nodes, for optimal performance.',
    'cu__invalid_max_worker_processes' => "The maximum number of worker processes must be a number between %1 and %2.",
    'cu__idle_timeout' => 'The amount of time a worker process will remain idle before it shuts down.',
    'cu__invalid_idle_timeout' => "The idle timeout value must be a number between %1 and %2.",
    'cu__idle_timeout_action' => 'The action that IIS performs when the idle timeout value has been reached.',
    'cu__idle_timeout_action_not_supported' => 'The specified idle timeout action is not supported by the web server.',
    'cu__recycling_by_time' => 'The period of time after which IIS application pool recycles.',
    'cu__invalid_recycling_by_time' => "The time interval must be -1 (unlimited) or a number between %1 and %2.",
    'cu__recycling_by_requests' => 'The maximum number of requests IIS application pool can process before it recycles.',
    'cu__invalid_recycling_by_requests' => "The request limit must be -1 (unlimited) or a number between %1 and %2.",
    'cu__recycling_by_virtual_memory' => 'The maximum amount of virtual memory a worker process can consume before causing IIS application pool to recycle.',
    'cu__invalid_recycling_by_virtual_memory' => "The virtual memory limit must be -1 (unlimited) or a number between %1 and %2.",
    'cu__recycling_by_private_memory' => 'The maximum amount of private memory a worker process can consume before causing IIS application pool to recycle.',
    'cu__invalid_recycling_by_private_memory' => "The private memory limit must be -1 (unlimited) or a number between %1 and %2.",

    'cu__locales__command_set_default' => 'Sets the default locale.',
    'cu__locales__command_enable' => 'Enables the locale.',
    'cu__locales__command_enable_done' => 'The locale %1 was successfully enabled.',
    'cu__locales__command_disable' => 'Disables the locale.',
    'cu__locales__command_disable_done' => 'The locale %1 was successfully disabled.',
    'cu__locales__command_set_default_done' => 'The locale %1 was successfully set as default.',
    'cu__locales__command_list' => 'Shows the list of locales.',
    'cu__locales__command_status' => 'Shows information about locales.',
    'cu__locales__command_status_note' => "The --status command displays information about locales.",
    'cu__locales__option_locale_code' => 'Sets the locales (use with the "enable", "disable" and "set-default" commands).',
    'cu__locales__print_status_enabled' => '[Enabled]',
    'cu__locales__print_status_disabled' => '[Disabled]',
    'cu__locales__print_status_installed_count' => 'Installed: %1.',
    'cu__locales__print_status_available_count' => 'Available for users: %1.',
    'cu__locales__print_status_disable_count' => 'Disabled: %1.',
    'cu__locales__print_status_available_license_count' => 'Allowed by license: %1.',
    'cu__locales__print_status_default_locale' => 'Default: %1.',
    'cu__locales__print_status_admin_locale' => 'Admin: %1.',

    'localeManager_locales__error_locale_does_not_exist' => 'The locale "%1" does not exist.',
    'localeManager_locales__error_locale_not_allow_in_license' => 'The locale "%1" is not allowed by the license.',
    'localeManager_locales__error_cannot_disable_default_locale' => 'Cannot disable the locale: "%1" is the default locale.',

    'panel_branding__insecure_filetype' => 'The file %1 was not copied to the server because this file type is not allowed in Plesk themes.',

    'cu_keyinfo_testkey_file_does_not_exist' => "The specified file '%1' does not exist.",

    'cu_db__set_custom_host' => 'Specifies a custom host for a database.',
    'cu_db__custom_host' => 'Specifies a custom host name that will be shown to users in the connection details instead of the real one.',
    'cu_db_unable_to_set_custom_host' => 'Unable to set the custom host: ',
    'cu_db__success_set_custom_host' => 'The custom host for the database was saved.',

    'cu_grey_listing__domain_is_in_black_list_already' => 'The domain \'%1\' is blacklisted. You should remove the domain from the black list before using this command.',
    'cu_grey_listing__domain_is_in_white_list_already' => 'The domain \'%1\' is in the white list. You should remove the domain from the white list before using this command.',

    'cu_http2_pref__enable' => 'Enables HTTP/2 support.',
    'cu_http2_pref__disable' => 'Disables HTTP/2 support.',
    'cu_http2_pref__status' => 'Displays the status of HTTP/2 support.',
    'cu_http2_pref__support_enabled' => 'HTTP/2 support was successfully activated.',
    'cu_http2_pref__support_disabled' => 'HTTP/2 support was successfully deactivated.',
    'cu_http2_pref__status_enabled' => 'Enabled',
    'cu_http2_pref__status_disabled' => 'Disabled',
    'cu_http2_pref__wrong_openssl_version' => 'The OpenSSL version is outdated. Please install OpenSSL >= 1.0.1 to enable HTTP/2 support.',
    'cu_http2_pref__nginx_not_installed' => 'The nginx service is not installed.',

    'cu_service__start' => 'Starts a service',
    'cu_service__stop' => 'Stops a service',
    'cu_service__restart' => 'Restarts a service',
    'cu_service__status' => 'Displays the current status of a service',
    'cu_service__list' => 'Displays information about available services',
    'cu_service__help' => 'Displays this help page',
    'cu_service__include' => 'Specifies a comma-separated list of services to be included in the --list command output.',
    'cu_service__exclude' => 'Specifies a comma-separated list of services to be excluded from the --list command output.',
    'cu_service__detail' => 'Sets the detailed format for the --list command output (equivalent to -format "%k\t%N\t%S\t%I\t%p\n").',
    'cu_service__format' => "Specifies the information to be included in the detailed output and the display parameters of the --list command.\n\n%k - service key\n%N - service name\n%s - service status code\n%S - service status\n%i - available code\n%I - information about available code\n%p - package name\n%% - %\n\\n - new line\n\\t - tab\n\nIs set to \"%k\" by default.\n",

    'cu_notification__update' => 'Updates notifications about system events.',
    'cu_notification__expiration' => 'Sets how many days in advance users receive expiration warnings.',
    'cu_notification__code' => 'Notification code',
    'cu_notification__send2admin' => 'Send notification to administrators.',
    'cu_notification__send2reseller' => 'Send notification to resellers.',
    'cu_notification__send2client' => 'Send notification to customers.',
    'cu_notification__send2email' => 'Send notification to a custom email.',
    'cu_notification__subject' => 'Notification subject',
    'cu_notification__subject_set_default' => 'Set notification subject to default value',
    'cu_notification__email' => 'Custom email',
    'cu_notification__text' => 'Notification text',
    'cu_notification__text_set_default' => 'Set notification text to default value',

    'cu_fstools__compare' => 'Compare filesystem',
    'cu_fstools__compare_to' => 'Target path to compare filesystem',
    'cu_repair__check_fs_system_corrupted_files' => 'ERROR: There are corrupted files in %1',
    'cu_repair__check_fs_system_missing_files' => 'ERROR: There are missing files in %1',
    'cu_repair__start_check_fs_consistency_in_progress' => 'Checking Plesk files consistency (it may take several minutes)...',
    'cu_repair__check_fs_consistency' => 'Checking Plesk files consistency',

    'cu_email_subaddressing_enable_error' => 'Due to security reasons, it\'s not possible to enable email subaddressing option. To fix this, remove or rename the following mailboxes: %1',

    'cu_dmarc_policy' => 'DMARC Policy',
    'cu_dkim_sign_out' => 'DKIM Sign Outgoing Mail',
    'cu_dkim_verify_in' => 'DKIM Verify Incoming Mail',

    'cu_serverpref__option_description_ccs' => 'Switches on/off Central Certificate Store support, which allows certificates to be stored on a central location like a file share.',
    'cu_serverpref__option_description_ccs_path' => 'Path where located Central Certificate Store.',
    'cu_serverpref__option_description_ccs_user_login' => 'If store path is network, it\'s user name with write access to store.',
    'cu_serverpref__option_description_ccs_user_password' => 'If store path is network, it\'s user\'s password.',
    'cu_serverpref__option_description_ccs_private_key_password' => 'Password for encryption certificates in Central Certificate Store.',
    'cu_serverpref__error_ccs_not_configured' => 'Central Certificate Store isn\'t configured. Please configure it by options: "-central-cert-store-path" and "-central-cert-store-private-key-password"',
    'cu_serverpref__warning_ccs_cert_not_removed' => 'WARNING: Certificates were not removed from store, please remove them manually.',
    'cu_serverpref__error_ccs_incorrect_settings' => 'Can\'t setup certificate to Centralized Certificate Store. Please check settings.',

    'cu_repair__check_fs_backup_manager_confirm_repair_permissions' => 'Do you want to repair incorrect permissions?',
    'cu_repair__check_fs_backup_manager_confirm_repair_permissions_in_progress' => 'Repairing incorrect permissions',
    'cu_repair__check_fs_backup_manager_incorrect_permissions_error_title' => 'There are incorrect permissions on some items in directories used by Backup Manager',

    'cu_repair__check_fs_panel_log_confirm_repair_permissions' => 'Do you want to repair incorrect permissions?',
    'cu_repair__check_fs_panel_log_confirm_repair_permissions_in_progress' => 'Repairing incorrect permissions',
    'cu_repair__check_fs_panel_log_incorrect_permissions_error_title' => 'There are incorrect permissions on Plesk log file',

    'cu_repair__check_configuration_file_not_found' => 'File not found: %1',
    'cu_repair__check_configuration_link_target_not_found' => 'Link target not found: %1',
    'cu_repair__check_orphaned_config' => 'Unknown file: %1',
    'cu_repair__check_orphaned_config_delete_confirm' => 'Do you want to delete the configuration file?',
    'cu_repair__check_orphaned_config_delete_in_progress' => 'Deleting file %1',

    'cu_dom_pref__cant_initialize_domain_services' => 'can\'t initialize domain service: %1',
    'cu_dom_pref_option_not_supported_by_server' => 'option is not supported by mail server',

    'cu_serverpref__option_description_ad' => 'Switches on/off Active Directory mode support, which allows creating Plesk users in Active Directory.',
    'cu_serverpref__option_description_ad_admin_login' => 'The login of a user allowed to manage Active Directory (for example, an Active Directory administrator).',
    'cu_serverpref__option_description_ad_admin_password' => 'The password of a user allowed to manage Active Directory (for example, an Active Directory administrator).',
    'cu_serverpref__error_ad_not_configured' => 'You need to configure the Active Directory mode first. Run the utility with the "-active-directory-admin-login" and "-active-directory-admin-password" options.',

    'cu_repair__temp_dir_absent' => 'Missing temporary file folder for domain: %1',
    'cu_repair__creating_temp_dir' => 'Creating temporary file folder for domain: %1',
    'cu_repair__asp_net_temp_dir_absent' => 'Missing ASP.net compilation temporary directory for domain: %1',
    'cu_repair__creating_asp_net_temp_dir' => 'Creating ASP.net compilation temporary directory for domain: %1',
    'cu_repair__broken_binding_for_domain' => 'Broken binding for domain: %1',
    'cu_repair__broken_ip' => 'IP address not found on interface(s): %1',
    'cu_repair__unlinked_domains' => "One or more IP addresses registered in Plesk (%1) are missing from the server's network interfaces. Domains assigned these IP addresses (%2) are unreachable. Assign valid IP addresses to these domains and rebuild the server configuration files.",
    'cu_repair__has_app_pools_impersonate_privilege' => 'Get status of IIS App pools impersonation privilege',
    'cu_repair__revoke_app_pools_impersonate_privilege' => 'Revoke IIS App pools impersonation privilege',

    'cu_spam_server__move_action_not_allowed' => 'Current mail server does not support moving spam to the "Junk E-mail" folder',

    'cu_pleskbackup_output_file_opt' => '<fullpath>\\ - directory to back up to (filename is generated automatically), <fullpath>\\<filename> - regular file, stdout - use stdout for output, [ftp|ftps]://[<login>[:<password>]@]<server>/<dirpath>/[<filename>] - storing the backup to ftp server. You can specify ftps protocol, instead of ftp, to use FTP over SSL. Implicit FTPS supported only on 990 port, so if you want to use implicit FTPS specify 990 port too, otherwise explicit FTPS will be used. FTP option \'-ftp-server\' can be used for setting server. FTP option \'-ftp-path\' can be used for setting file path. FTP option \'-ftp-login\' can be used for setting login. FTP option \'-ftp-password\' (with \'-ftp-login\') can be used for setting password.',
    'cu_pleskrestore_restore_cmd_win' => 'Restore from a backup file.',
    'cu_pleskrestore_restore_cmd_unix' => 'Restore from a backup file. If you used password protection for the backup, use the environment variable PLESK_BACKUP_PASSWORD to specify the password or use the option \'-ignore-backup-password\' to ignore it.',

    'cu_mailserver__quota_warning_enable' => 'Send a notification to mail users when their mailbox quota usage exceeds 95%',

    'cu_serverpref__option_description_ssl_cipher_server_order' => 'Allows the server to choose the TLS cipher suite order itself.',
];
