<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'app.instances.title' => 'Установленные приложения',
    'app.instances.buttonCheckForUpdates' => 'Проверить наличие обновлений',
    'app.instances.buttonScan' => 'Сканировать',
    'app.instances.hintButtonScan' => 'Проверить наличие приложений в вашей подписке.',
    'app.instances.taskScan' => 'Идет поиск приложений...',
    'app.instances.undefinedApp' => 'Неизвестно',
    'app.instances.name' => 'Название',
    'app.instances.installedTo' => 'Путь установки',
    'app.instances.uninstall' => 'Удалить',
    'app.instances.update' => 'Доступно обновление',
    'app.instances.noUpdates' => 'Не найдено ни одного обновления. Все приложения в актуальном состоянии.',
    'app.instances.foundUpdates' => 'Доступные обновления:',
    'app.instances.noInstallationUrlAvailable' => 'Нет',

    'app.packages.title' => 'Доступные приложения',
    'app.packages.name' => 'Название',
    'app.packages.version' => 'Версия',
    'app.packages.summary' => 'Описание',
    'app.packages.install' => 'Установить',

    'app.services.title' => 'Доступные службы',
    'app.services.serviceID' => 'Код службы',
    'app.services.name' => 'Название',
    'app.services.summary' => 'Краткое описание',
    'app.services.instantiate' => 'Создать экземпляр',

    'app.subserviceinstances.remove' => 'Удалить',
    'app.subserviceinstances.hintRemove' => 'Удалить выбранные объекты.',
    'app.subserviceinstances.confirmOnDelete' => 'Вы действительно хотите удалить выбранные объекты?',
    'app.subserviceinstances.serviceName' => 'Название услуги',
    'app.subserviceinstances.userName' => 'Пользователь',

    'contentfiles.name' => 'Имя',
    'contentfiles.changeDate' => 'Дата последнего изменения',
    'contentfiles.size' => 'Размер',
    'contentfiles.permissions' => 'Права',
    'contentfiles.user' => 'Пользователь',
    'contentfiles.group' => 'Группа',
    'contentfiles.buttonUploadFiles' => 'Загрузить файл',
    'contentfiles.buttonUploadDirectory' => 'Загрузить папку',
    'contentfiles.buttonImportFileViaUrl' => 'Импорт файла по URL',
    'contentfiles.hintUploadFiles' => 'Загрузить файлы в текущую папку.',
    'contentfiles.buttonDeleteFile' => 'Удалить',
    'contentfiles.hintDeleteFile' => 'Удалить выбранные файлы.',
    'contentfiles.buttonPurgeFile' => 'Удалить',
    'contentfiles.hintPurgeFile' => 'Окончательно удалить выбранные файлы.',
    'contentfiles.buttonPurgeAll' => 'Очистить корзину',
    'contentfiles.buttonRotationSettings' => 'Настройки ротации',
    'contentfiles.hintRotationSettings' => 'Изменить настройки ротации',
    'contentfiles.hintPurgeAll' => 'Окончательно удалить все файлы и папки из корзины.',
    'contentfiles.buttonCopyFiles' => 'Копировать',
    'contentfiles.hintCopyFiles' => 'Копировать выбранные файлы в другую папку.',
    'contentfiles.buttonMoveFiles' => 'Переместить',
    'contentfiles.hintMoveFiles' => 'Переместить выбранные файлы в другую папку.',
    'contentfiles.buttonMoreActions' => 'Ещё',
    'contentfiles.buttonCalculateSize' => 'Размер',
    'contentfiles.hintCalculateSize' => 'Определить общий размер выбранных файлов.',
    'contentfiles.buttonChangeTimestamp' => 'Изменить временную метку',
    'contentfiles.hintChangeTimestamp' => 'Изменить временную метку выбранных файлов.',
    'contentfiles.buttonArchiveActions' => 'Архив',
    'contentfiles.buttonExtractArchive' => 'Извлечь файлы',
    'contentfiles.hintExtractArchive' => 'Извлечь файлы из выбранных архивов в текущую папку.',
    'contentfiles.buttonCreateArchive' => 'Добавить в архив',
    'contentfiles.hintCreateArchive' => 'Добавить выбранные файлы в архив.',
    'contentfiles.buttonNewActions' => 'Создать',
    'contentfiles.buttonNewFile' => 'Создать файл',
    'contentfiles.hintNewFile' => 'Создать файл.',
    'contentfiles.buttonNewDirectory' => 'Создать папку',
    'contentfiles.hintNewDirectory' => 'Создать папку.',
    'contentfiles.rootDirectory' => 'Домашняя папка',
    'contentfiles.buttonView' => 'Посмотреть опции',
    'contentfiles.hintView' => 'Изменить настройки Менеджера файлов.',
    'contentfiles.confirmOnDelete' => 'Вы уверены, что хотите окончательно удалить {count, plural, =1 {{name}} one {# выбранный файл или папку} few {# выбранных файла или папки} many {# выбранных файлов или папок} other {# выбранных файлов или папок}}?',
    'contentfiles.confirmOnDeleteToTrash' => 'Переместить {count, plural, =1 {{name}} one {# выбранный файл или папку} few {# выбранных файла или папки} many {# выбранных файлов или папок} other {the # выбранных файлов или папок}} в корзину?',
    'contentfiles.deleteWithForce' => 'Окончательно удалить, не сохраняя в корзине, {count, plural, =1 {{name}} one {# выбранный файл или папку} few {# выбранных файла или папки} many {# выбранных файлов или папок} other {# выбранных файлов или папок}}.',
    'contentfiles.confirmOnPurge' => 'Окончательно удалить {count, plural, =1 {{name}} one {# выбранный файл или папку} few {# выбранных файла или папки} many {# выбранных файлов или папок} other {# выбранных файлов или папок}}?',
    'contentfiles.confirmOnPurgeAll' => 'Окончательно удалить все файлы и папки из корзины?',
    'contentfiles.waitMessage' => 'Пожалуйста, подождите...',
    'contentfiles.readonlyHint' => 'Эта папка доступна только для чтения: вы не можете создавать в ней файлы или папки.',
    'contentfiles.directoryNotFound' => 'Невозможно найти папку %%directory%%: %%error%%',
    'contentfiles.symlinksOutOfWebspaceProhibited' => 'Запрещено использовать символьные ссылки на объекты, находящиеся не в веб-пространстве, %%symlink%%: %%error%%',
    'contentfiles.dragAndDropArea' => 'Перетащите сюда файлы или папки для загрузки',
    'contentfiles.nonUTF8' => 'Менеджер файлов не позволяет открывать файлы и папки, имена которых содержат символы в кодировке, отличной от UTF-8.',
    'contentfiles.non4ByteChar' => 'Менеджер файлов не позволяет открывать файлы и папки, имена которых содержат четырехбайтные символы.',
    'contentfiles.searchInFilename' => 'Искать по имени файла',
    'contentfiles.searchInFilenameAndContent' => 'Искать по имени файла и содержимому',
    'contentfiles.searchInContent' => 'Искать по содержимому',
    'contentfiles.menuItemFilename' => 'Только имя файла',
    'contentfiles.menuItemFilenameAndContent' => 'Имя файла и содержимое',
    'contentfiles.menuItemContent' => 'Только содержимое',
    'contentfiles.noEntriesFound' => 'Не найдено ни одного элемента.',
    'contentfiles.loadingTitle' => 'Поиск...',
    'contentfiles.searchError' => 'Не удалось выполнить поиск файлов в текущей папке.',
    'contentfiles.searchErrorTimeout' => 'Поиск занял слишком много времени и был отменен.',
    'contentfiles.item-action-view' => 'Просмотреть',
    'contentfiles.item-action-textCodeEditor' => 'Редактировать как код',
    'contentfiles.item-action-visualEdit' => 'Редактировать как HTML',
    'contentfiles.item-action-textEdit' => 'Редактировать как текст',
    'contentfiles.item-action-browse' => 'Открыть в браузере',
    'contentfiles.item-action-logBrowser' => 'Открыть в браузере журналов',
    'contentfiles.item-action-download' => 'Скачать',
    'contentfiles.item-action-permissions' => 'Изменить права',
    'contentfiles.item-action-rename' => 'Переименовать',
    'contentfiles.item-action-extractArchive' => 'Извлечь файлы',
    'contentfiles.item-action-imageView' => 'Просмотреть',
    'contentfiles.imageViewer' => 'Просмотр изображений',
    'contentfiles.tooltipReadOnly' => 'Текущая папка доступна только для чтения: вы не можете создавать в ней файлы или папки.',

    'database.issues.type' => 'Тип',
    'database.issues.table' => 'Таблица',
    'database.issues.code' => 'Код',
    'database.issues.problem' => 'Проблема',
    'database.issues.icon-title-att' => 'Предупреждение',
    'database.issues.icon-title-warning' => 'Ошибка',

    'database.users.login' => 'Имя',
    'database.users.server' => 'Сервер баз данных',
    'database.users.database' => 'База данных',
    'database.users.remove' => 'Удалить',
    'database.users.hintRemove' => 'Удалить выбранных пользователей базы данных.',
    'database.users.confirmOnDelete' => 'Вы уверены, что хотите удалить {count, plural, =1 {пользователя базы данных {login}} one {# выбранного пользователя базы данных} few {# выбранных пользователей базы данных} many {# выбранных пользователей базы данных} other {# выбранных пользователей базы данных}}?',
    'database.users.disabledSelectHint' => 'Используется установленным веб-приложением',
    'database.users.orphanedHint' => 'Потерян после восстановления, пожалуйста, %%orphanedRepairLink%% этого пользователя.',
    'database.users.orphanedRepairLink' => 'восстановите',
    'database.users.anyDatabase' => 'Любая база данных',
    'database.users.serverTypeMysql' => 'MySQL',
    'database.users.serverTypeMariadb' => 'MariaDB',
    'database.users.serverTypePercona' => 'Percona',
    'database.users.serverTypePostgresql' => 'PostgreSQL',
    'database.users.serverTypeMssql' => 'MS SQL',

    'databases.assignToSubscription' => 'Перенести в подписку',
    'databases.assignToSubscription_powerUser' => 'Перенести в веб-пространство',
    'databases.assignToSubscriptionPopupTitle' => 'Перенести базы данных в другую подписку',
    'databases.assignToSubscriptionPopupTitle_powerUser' => 'Перенести базы данных в другое веб-пространство',
    'databases.assignToSubscriptionPopupDesc' => 'Выбранные базы данных будут перенесены в выбранную подписку. Пользователи баз данных также будут пенесены, за исключением имеющих доступ к другим базам данных.',
    'databases.assignToSubscriptionPopupDesc_powerUser' => 'Выбранные базы данных будут перенесены в выбранное веб-пространство. Пользователи баз данных также будут пенесены, за исключением имеющих доступ к другим базам данных. Обратите внимание, что после перемещения бывшие пользователи не смогут использовать ссылку в Plesk, чтобы открывать базу данных для редактирования ее содержимого.',
    'databases.loading' => 'Загрузка',
    'databases.name' => 'Имя',
    'databases.type' => 'Тип',
    'databases.server' => 'Сервер баз данных',
    'databases.users' => 'Пользователи',
    'databases.remove' => 'Удалить',
    'databases.hintRemove' => 'Удалить выбранные базы данных.',
    'databases.confirmOnDelete' => 'Вы уверены, что хотите удалить {count, plural, =1 {базу данных {name}} one {# выбранную базу данных} few {# выбранных базы данных} many {# выбранных баз данных} other {# выбранных баз данных}}?',
    'databases.typeMysql' => 'MySQL',
    'databases.typeMariadb' => 'MariaDB',
    'databases.typePercona' => 'Percona',
    'databases.typePostgresql' => 'PostgreSQL',
    'databases.typeMssql' => 'MS SQL Server',
    'databases.serverMysql' => 'Локальный сервер MySQL',
    'databases.serverPostgresql' => 'Локальный сервер PostgreSQL',
    'databases.serverMssql' => 'Локальный сервер MS SQL',
    'databases.disabledSelectHint' => 'Используется установленным веб-приложением',
    'databases.buttonMakeCopy' => 'Копировать',
    'databases.buttonMakeCopyHint' => 'Создать точную копию базы данных или скопировать ее содержимое в существующую базу данных.',
    'databases.buttonWebadmin' => 'Webadmin',
    'databases.buttonWebadminHint' => 'Перейти к управлению базой данных через веб-интерфейс.',
    'databases.buttonConnectionInfo' => 'Информация о подключении',
    'databases.buttonConnectionInfoHint' => 'Такая информация, как имя сервера и учетные данные пользователя базы данных, необходимая для соединения с этой базой данных.',
    'databases.buttonPhpMyAdmin' => 'phpMyAdmin',
    'databases.buttonMyLittleAdmin' => 'myLittleAdmin',
    'databases.buttonDownloadDump' => 'Экспортировать дамп',
    'databases.buttonDownloadDumpHint' => 'Экспортировать копию этой базы данных.',
    'databases.buttonUploadDump' => 'Импортировать дамп',
    'databases.buttonUploadDumpHint' => 'Импортировать вашу копию этой базы данных.',
    'databases.buttonDelete' => 'Удалить базу данных',
    'databases.buttonDeleteHint' => 'Удалить эту базу данных',
    'databases.buttonDeleteDisabledHint' => 'Невозможно удалить базу данных. Она используется установленным веб-приложением.',
    'databases.buttonDeleteConfirmationText' => 'Вы уверены, что хотите удалить базу данных %%name%%?',
    'databases.buttonActiveList' => 'Активный список',
    'databases.buttonActiveListHint' => 'Переключить режим просмотра',
    'databases.buttonCheckAndFix' => 'Проверить и исправить',
    'databases.buttonCheckAndFixHint' => 'Проверить на наличие ошибок, таких как поврежденная структура таблиц, и устранить их.',
    'databases.buttonAssignToSubscription' => 'Перенести в подписку',
    'databases.buttonAssignToSubscriptionHint' => 'Перенести базы данных в другую подписку',
    'databases.buttonAssignToSubscription_powerUser' => 'Перенести в веб-пространство',
    'databases.buttonAssignToSubscriptionHint_powerUser' => 'Перенести базы данных в другое веб-пространство',
    'databases.promptPassword' => 'Введите пароль, чтобы войти как пользователь базы данных %%login%%.',
    'databases.promptPasswordPopupTitle' => 'Укажите пароль',
    'databases.taskCheckDatabase' => 'Проверить базу данных',
    'databases.taskRepairDatabase' => 'Исправить базу данных',
    'databases.downloadTask' => 'Дамп базы данных %%database%% готовится к экспорту...',
    'databases.downloadPopupTitle' => 'Экспортировать дамп',
    'databases.downloadHint' => 'Вы собираетесь создать дамп базы данных %%database%% и скачать его.',
    'databases.downloadRelativePath' => 'Сохранить дамп в следующей папке',
    'databases.downloadDumpName' => 'Имя файла дампа',
    'databases.downloadDumpAutomatically' => 'Автоматически скачать дамп после создания',
    'databases.errorDumpNameEmpty' => 'Пожалуйста, укажите имя дампа.',
    'databases.errorDumpNameInvalid' => 'В имени дампа не могут содержаться следующие символы: %%chars%%.',
    'databases.errorDumpNameTooLong' => 'Слишком длинное название файла дампа. Полный путь к дампу должен быть не длиннее %%maxLength%% символов.',
    'databases.uploadTask' => 'Импортируется дамп %%database%%...',
    'databases.uploadPopupTitle' => 'Импортировать дамп базы данных',
    'databases.uploadHint' => 'Загрузить дамп с вашего локального компьютера или импортировать дамп, хранящийся на вашем хостинговом сервере.',
    'databases.uploadFromFile' => 'Загрузить',
    'databases.uploadFromWebspace' => 'Импортировать',
    'databases.recreateDatabase' => 'Заново создать базу данных',
    'databases.uploading' => 'Импортируется...',
    'databases.waitMessage' => 'Пожалуйста, подождите...',
    'databases.rootDirectory' => 'Корневая папка',
    'databases.connectionInfoTitle' => 'Параметры соединения для %%database%%',
    'databases.connectionInfoDesc' => 'Вы можете использовать эти параметры соединения с базой данных, например, когда вам нужно ввести эти параметры во время установки веб-приложения.',
    'databases.connectionInfoServerAddress' => 'Хост',
    'databases.connectionInfoDatabaseName' => 'Имя базы данных',
    'databases.connectionInfoUserLogin' => 'Имя пользователя',
    'databases.connectionInfoUserPassword' => 'Пароль',
    'databases.connectionInfoNoUserLogin' => 'Не назначено пользователя по умолчанию',
    'databases.buttonClose' => 'Закрыть',
    'databases.nothingFound' => "Совпадения не найдены",
    'databases.moreObjectsAvailable' => 'Доступно еще %%count%% объектов.',

    'dnsaclrecords.value' => 'IP-адрес',
    'dnsaclrecords.add' => 'Добавить IP-адрес',
    'dnsaclrecords.remove' => 'Удалить',
    'dnsaclrecords.hintRemove' => 'Удалить выбранные адреса.',
    'dnsaclrecords.confirmOnDelete' => 'Удалить выбранные IP-адреса?',
    'dnsaclrecords.emptyViewTitle' => 'Передача зоны запрещена',
    'dnsaclrecords.emptyViewDescription1' => 'Из соображений безопасности вы можете разрешить передачу зоны DNS только на серверы, указанные в NS-записях зоны.',
    'dnsaclrecords.emptyViewDescription2' => 'Чтобы указать один или несколько серверов, на которые вы разрешаете передачу, нажмите "Добавить IP-адрес".',

    'dnsrecords.host' => 'Хост',
    'dnsrecords.type' => 'Тип записи',
    'dnsrecords.value' => 'Значение',
    'dnsrecords.nameServer' => 'Сервер имен',
    'dnsrecords.ipAddress' => 'IP-адрес',
    'dnsrecords.ttl' => 'TTL',
    'dnsrecords.buttonCheckHint' => 'Проверить зону DNS на сервере имен.',
    'dnsrecords.remove' => 'Удалить',
    'dnsrecords.removeRecord' => 'Удалить %%selectedRowTitle%%? Это действие необратимо.',
    'dnsrecords.removeRecords' => 'Удалить %%selectedRows%% записей? Это действие необратимо.',
    'dnsrecords.hintRemove' => 'Удалить выбранные записи DNS.',
    'dnsrecords.confirmOnDelete' => 'Вы уверены, что хотите удалить {count, plural, =1 {запись DNS {host}} one {# выбранную запись DNS} few {# выбранные записи DNS} many {# выбранных записей DNS} other {# выбранные записи DNS}}?',
    'dnsrecords.turnOff' => 'Отключить',
    'dnsrecords.hintTurnOff' => 'Отключить локальную службу DNS для зоны DNS %%name%%',
    'dnsrecords.turnOn' => 'Включить',
    'dnsrecords.hintTurnOn' => 'Включить локальную службу DNS для зоны DNS %%name%%',
    'dnsrecords.toggleTypeToSlave' => 'Переключиться на вторичный сервер',
    'dnsrecords.toggleTypeToMaster' => 'Переключиться на первичный сервер',
    'dnsrecords.hintToggleTypeToMaster' => 'Сделать этот сервер первичным сервером имен для зоны %%name%%.',
    'dnsrecords.hintToggleTypeToSlave' => 'Изменить режим обслуживания зоны DNS %%name%% на вторичный.',
    'dnsrecords.hintToggleTypeDisabled' => 'Не удалось изменить режим обслуживания зоны DNS, так как зона DNS %%name%% обслуживается другим сервером.',
    'dnsrecords.addRecord' => 'Добавить запись',
    'dnsrecords.hintSpecifyNameServer' => 'Указать новый сервер имен для %%name%%',
    'dnsrecords.hintAddPrimaryDns' => 'Добавить основной сервер DNS для %%name%%',
    'dnsrecords.hintAddRecord' => 'Создать ресурсную запись в зоне DNS %%name%%',
    'dnsrecords.restoreDefault' => 'Вернуться к значениям по умолчанию',
    'dnsrecords.hintRestoreDefault' => 'Заново создать зону DNS с помощью глобального шаблона DNS. Все персональные записи ресурсов будут удалены, и все совершенные пользователем изменения будут утеряны.',
    'dnsrecords.syncZone' => 'Применить шаблон DNS',
    'dnsrecords.hintSyncZone' => 'Применить изменения, внесенные в глобальный шаблон DNS, к этой зоне. При этом в ней могут быть добавлены новые записи ресурсов и удалены существующие. Это не повлияет на записи ресурсов, добавленные или измененные пользователем.',
    'dnsrecords.applyChanges' => 'Ваши изменения еще не сохранены. Измененные записи отмечены значком. Чтобы применить изменения, нажмите "Обновить". Чтобы откатить изменения, нажмите "Отменить".',
    'dnsrecords.updateButtonTitle' => 'Обновить',
    'dnsrecords.updateButtonDescription' => 'Сохранить изменения, внесенные в записи DNS.',
    'dnsrecords.revertButtonTitle' => 'Отменить',
    'dnsrecords.revertButtonDescription' => 'Отменить изменения, внесенные в записи DNS.',
    'dnsrecords.syncZoneFrom' => 'Применить изменения шаблона DNS',
    'dnsrecords.moreActions' => 'Другие действия',
    'dnsrecords.search' => 'Поиск...',
    'dnsrecords.templateNotSynchronized' => 'Шаблон зоны DNS был изменен и будет применен ко всем вновь созданным доменам. Вы также можете %%link%%',
    'dnsrecords.templateNotSynchronizedLinkText' => 'применить изменения ко всем доменам',
    'dnsrecords.soaTemplateNotSynchronized' => 'Шаблон SOA был изменен и будет применен ко всем вновь созданным доменам. Вы также можете %%link%%',

    'emails.name' => 'Адрес электронной почты',
    'emails.owner' => 'Пользователь',
    'emails.remove' => 'Удалить',
    'emails.addNewEmail' => 'Создать адрес электронной почты',
    'emails.hintAddNewEmail' => 'Создайте адрес электронной почты и назначьте его пользователю.',
    'emails.recalculateUsage' => 'Обновить статистику',
    'emails.hintRecalculateUsage' => 'Узнайте, сколько дискового пространства используется почтовыми ящиками на данный момент.',
    'emails.outgoingSpamSettings' => 'Ограничить исходящие',
    'emails.hintOutgoingSpamSettings' => 'Установите ограничение на количество исходящих сообщений для выбранных почтовых ящиков. Это ограничение определяет максимальное число сообщений, которое можно отправить с каждого почтового ящика.',
    'emails.searchByEmail' => 'Адрес электронной почты',
    'emails.hintRemove' => 'Удалить выбранные адреса электронной почты.',
    'emails.webMailDisabledHint' => 'Не установлено ни одной программы для работы с электронной почтой через веб-интерфейс.',
    'emails.webMailHint' => 'Открыть панель управления этим почтовым ящиком в новом окне браузера.',
    'emails.editHint' => 'Как создать почтовую учетную запись в программах Microsoft Outlook, Outlook Express, Thunderbird и Apple Mail.',
    'emails.confirmOnDelete' => 'Вы уверены, что хотите удалить {count, plural, =1 {почтовый адрес {name}} one {# выбранный почтовый адрес} few {# выбранных почтовых адреса} many {# выбранных почтовых адресов} other {# выбранных почтовых адресов}}?',
    'emails.redirectDetailsSingle' => '%%firstAddress%%',
    'emails.redirectDetailsMultiple' => '%%firstAddress%% (и еще %%countLeft%%)',
    'emails.autoresponderEnabled' => 'Автоответчик включен.',
    'emails.autoresponderEnabledTill' => 'Автоответчик включен до %%endDate%%.',
    'emails.spaceUsage' => 'Использование',
    'emails.noMailbox' => 'Почтовый ящик отсутствует',
    'emails.statusNotOperable' => 'Почтовая служба отключена.',

    'failedrequestfiles.downloadZip' => 'Скачать ZIP',
    'failedrequestfiles.downloadZipHint' => 'Скачать выбранные файлы в виде ZIP-архива.',
    'failedrequestfiles.name' => 'Имя',
    'failedrequestfiles.modificationDate' => 'Дата изменения',
    'failedrequestfiles.remove' => 'Удалить',
    'failedrequestfiles.hintRemove' => 'Удалить выбранные файлы невыполненных запросов.',
    'failedrequestfiles.confirmOnDelete' => 'Удалить выбранные файлы невыполненных запросов?',
    'failedrequestfiles.viewHint' => 'Нажмите для просмотра файла невыполненного запроса.',
    'failedrequestfiles.buttonChangeTracing' => 'Изменить настройки отслеживания',
    'failedrequestfiles.buttonChangeTracingHint' => 'Изменить текущие настройки отслеживания невыполненных запросов.',
    'failedrequestfiles.buttonDisableTracing' => 'Остановить отслеживание',
    'failedrequestfiles.buttonDisableTracingHint' => 'Остановить отслеживание',
    'failedrequestfiles.buttonEnableTracing' => 'Начать отслеживание',
    'failedrequestfiles.buttonEnableTracingHint' => 'Начать отслеживание',
    'failedrequestfiles.buttonRefresh' => 'Обновить',
    'failedrequestfiles.buttonRefreshHint' => 'Нажмите, чтобы просмотреть все невыполненные запросы, соответствующие указанным критериям. Имейте в виду, что вновь регистрируемые невыполненные запросы не показываются автоматически.',

    'files.name' => 'Имя',
    'files.modificationDate' => 'Дата последнего изменения',
    'files.size' => 'Размер',
    'files.share' => 'Открыть доступ',
    'files.shareHint' => 'Переместить выбранные файлы в папку "Общие файлы" и сделать их доступными всем сотрудникам, зарегистрированным в Plesk.',
    'files.publish' => 'Опубликовать',
    'files.publishHint' => 'Скопировать выбранные файлы в папку "Опубликованные файлы", чтобы сделать их доступными для клиентов и посетителей сайта. Вы можете защитить доступ к этим файлам паролем.',
    'files.email' => 'Отправить ссылку',
    'files.emailHint' => 'Отправить ссылку на выбранные файлы другим сотрудникам и клиентам.',
    'files.delete' => 'Удалить',
    'files.deleteHint' => 'Удалить выбранные файлы',
    'files.moreActions' => 'Другие действия',
    'files.createFolder' => 'Создать новую папку',
    'files.createFolderHint' => 'Создать папку в текущей папке',
    'files.copy' => 'Копировать',
    'files.copyHint' => 'Копировать выбранные файлы или папки.',
    'files.move' => 'Переместить',
    'files.moveHint' => 'Переместить выбранные файлы или папки.',
    'files.protectedDescription' => 'Доступ к файлам в этой папке защищен паролем. Для просмотра этих файлов пользователям будет необходимо указать этот пароль.',
    'files.nothingSelected' => 'Ни одного файла и ни одной папки не выбрано.',

    'gitrepositories.lastCommitInfo' => 'Информация о последнем коммите в репозиторий:',
    'gitrepositories.deploymentActions' => 'Дополнительные действия развертывания:',

    'logfiles.name' => 'Имя',
    'logfiles.path' => 'Путь',
    'logfiles.modificationDate' => 'Дата изменения',
    'logfiles.fileSize' => 'Размер',
    'logfiles.logRotation' => 'Ротация журналов',
    'logfiles.logRotationHint' => 'Настроить ротацию журналов для сайта.',
    'logfiles.logRotationTitle' => 'Настройка ротации журналов',
    'logfiles.remove' => 'Удалить',
    'logfiles.hintRemove' => 'Удалить выбранные журналы. Удалить можно только обработанные журналы.',
    'logfiles.confirmOnDelete' => 'Удалить выбранные журналы?',
    'logfiles.viewHint' => 'Посмотреть содержимое журнала.',
    'logfiles.buttonDownloadHint' => 'Скачать журнал.',
    'logfiles.buttonViewHint' => 'Посмотреть содержимое журнала в новом окне.',
    'logfiles.addCustomLog' => 'Добавить персональный журнал',
    'logfiles.addCustomLogHint' => 'Открывать любой файл в браузере журналов.',
    'logfiles.customLogPopupTitle' => 'Добавить персональный журнал',
    'logfiles.invalidLogFormat' => 'Формат файла журнала не поддерживается.',
    'logfiles.buttonUnlinkHint' => 'Нажмите, чтобы прекратить отслеживать обновления этого файла в браузере журналов',
    'logfiles.buttonUnlinkConfirmationDescription' => 'Вы уверены, что хотите прекратить отслеживать обновления этого файла в браузере журналов?',
    'logfiles.buttonUnlinkConfirmationYes' => 'Да',
    'logfiles.buttonUnlinkConfirmationNo' => 'Нет',
    'logfiles.accessLog' => 'Доступ к Apache',
    'logfiles.accessLogProcessed' => 'Доступ к Apache (обрабатываемый)',
    'logfiles.accessSslLog' => 'Доступ к Apache SSL/TLS',
    'logfiles.accessSslLogProcessed' => 'Доступ к Apache SSL/TLS (обрабатываемый)',
    'logfiles.errorLog' => 'Ошибки Apache',
    'logfiles.proxyAccessLog' => 'Доступ к nginx',
    'logfiles.proxyAccessSslLog' => 'Доступ к nginx по SSL/TLS',
    'logfiles.proxyErrorLog' => 'Ошибки nginx',
    'logfiles.phpErrorLog' => 'Ошибки PHP',
    'logfiles.iisAccessLog' => 'Доступ к IIS',
    'logfiles.iisLog' => 'IIS (%%name%%)',
    'logfiles.audit' => 'ModSecurity',
    'logfiles.passenger' => 'Node.js',
    'logfiles.iisnode' => 'Node.js',
    'logfiles.laravel' => 'Laravel',
    'logfiles.dotnetcore' => '.NET Core',

    'maillists.title' => 'Рассылки',
    'maillists.remove' => 'Удалить',
    'maillists.name' => 'Адрес',
    'maillists.subscribers' => 'Адресаты',
    'maillists.hintRemove' => 'Удалить выбранные рассылки.',
    'maillists.confirmOnDelete' => 'Удалить выбранные рассылки?',
    'maillists.openWebPanel' => 'Управление списком',
    'maillists.statusNotEnabled' => 'Отключено.',
    'maillists.statusNotOperable' => 'Услуга почтовых рассылок отключена.',

    'mailsettings.name' => 'Имя домена',
    'mailsettings.mailService' => 'Почтовая служба',
    'mailsettings.webmail' => 'Веб-почта',
    'mailsettings.nonexist' => 'Почта с несуществующим адресатом',
    'mailsettings.webmailNone' => 'Нет',
    'mailsettings.nonExistBounce' => 'Возвращать с уведомлением',
    'mailsettings.nonExistCatch' => 'Пересылать на %%catchAddress%%',
    'mailsettings.nonExistCatchDescription' => 'Этот адрес должен принадлежать выбранному домену. Только администратор может указать внешний адрес или один адрес для нескольких доменов',
    'mailsettings.nonExistExternal' => 'Перенаправлять на %%catchIp%%',
    'mailsettings.nonExistReject' => 'Отклонять',
    'mailsettings.nonExistDiscard' => 'Отклонять',
    'mailsettings.statusEnabled' => 'Включена',
    'mailsettings.statusDisabled' => 'Отключена',
    'mailsettings.searchByName' => 'Имя домена',
    'mailsettings.editOutgoingSpamSettings' => 'Изменить ограничение',
    'mailsettings.numberOutgoingMessages' => 'Количество исходящих сообщений',

    'roles.title' => 'Роли пользователей',
    'roles.name' => 'Название роли',
    'roles.description' => 'Описание',
    'roles.remove' => 'Удалить',
    'roles.numberOfUsers' => 'Пользователи',
    'roles.hintRemove' => 'Удалить выбранные роли пользователей. Роль может быть удалена, только если она не присвоена ни одному пользователю.',
    'roles.disabledSelectHint' => 'Эта роль присвоена одному или нескольким пользователям. Роль может быть удалена, только если она не присвоена ни одному пользователю.',
    'roles.builtInItemHint' => 'Эта роль не можеть быть изменена или удалена.',
    'roles.confirmOnDelete' => 'Удалить выбранные роли пользователей?',

    'sites.selectdns.domain' => 'Домен',
    'sites.selectdns.dnsStatus' => 'Статус',
    'sites.selectdns.statusOff' => 'Управление DNS-зоной отключено.',
    'sites.selectdns.statusMaster' => 'DNS-зона находится в главном режиме.',
    'sites.selectdns.statusSlave' => 'DNS-зона находится в подчиненном режиме.',
    'sites.selectdns.linkManage' => 'Управление',

    'sites.selectfrontpage.domain' => 'Домен',
    'sites.selectfrontpage.linkManage' => 'Управление',

    'sites.selectsimple.domain' => 'Домен',
    'sites.selectsimple.linkManage' => 'Управление',
    'sites.selectsimple.linkView' => 'Просмотреть',

    'sites.selectstatistics.domain' => 'Домен',
    'sites.selectstatistics.linkView' => 'Показать',

    'sites.selecttrafficstatistics.domain' => 'Домен',
    'sites.selecttrafficstatistics.linkView' => 'Просмотр',

    'sites.selectwebdeploy.domain' => 'Домен',
    'sites.selectwebdeploy.linkDownload' => 'Скачать',

    'sites.unitymobile.website' => 'Веб-сайт',
    'sites.unitymobile.mobileSite' => 'Имя мобильного сайта',
    'sites.unitymobile.createSite' => 'Создать мобильный сайт',
    'sites.unitymobile.launchEditor' => 'Редактировать сайт',
    'sites.unitymobile.changeSiteName' => 'Изменить имя сайта',
    'sites.unitymobile.delete' => 'Удалить',
    'sites.unitymobile.confirmDeleteTitle' => 'Вы действительно хотите удалить этот мобильный сайт?',
    'sites.unitymobile.confirmDeleteDescription' => 'Всё содержимое сайта будет потеряно.',

    'sites.domainHeader' => 'Домен',
    'sites.hostingHeader' => 'Хостинг',
    'sites.diskUsage' => 'Использование диска',
    'sites.traffic' => 'Трафик',
    'sites.buttonAddDomain' => 'Добавить домен',
    'sites.buttonAddDomainHint' => 'Вы можете разместить сайт на этом сервере, настроить перенаправление на другой сайт или просто настроить DNS-зону домена, если хотите использовать домен только для электронной почты.',
    'sites.buttonAddSubdomain' => 'Добавить субдомен',
    'sites.buttonAddSubdomainHint' => 'Создать сайт с доменным именем третьего уровня, например, shop.example.com.',
    'sites.buttonAddDomainAlias' => 'Добавить псевдоним домена',
    'sites.buttonAddDomainAliasHint' => 'Создать псевдоним домена для вашего сайта.',
    'sites.buttonRemove' => 'Удалить',
    'sites.buttonRemoveHint' => 'Удалить выбранные сайты и все их содержимое, включая приложения и почтовые данные.',
    'sites.buttonActivate' => 'Активировать',
    'sites.buttonSuspend' => 'Приостановить',
    'sites.buttonClassicList' => 'Классический список',
    'sites.buttonClassicListHint' => 'Переключить режим просмотра',
    'sites.buttonActiveList' => 'Активный список',
    'sites.buttonActiveListHint' => 'Переключить режим просмотра',
    'sites.buttonDynamicList' => 'Динамический список',
    'sites.buttonDynamicListHint' => 'Переключить режим просмотра',
    'sites.buttonFileManager' => 'Менеджер файлов',
    'sites.buttonMail' => 'Почта',
    'sites.buttonDatabases' => 'Базы данных',
    'sites.buttonDatabasesCreate' => 'Добавить базу данных',
    'sites.buttonDatabasesTogglerText' => 'или',
    'sites.buttonDatabasesToggle' => 'выбрать существующую',
    'sites.buttonDatabasesEdit' => 'Открыть',
    'sites.buttonDatabasesPromptPassword' => 'Введите пароль, чтобы войти как пользователь базы данных %%login%%.',
    'sites.removeConfirmation' => 'Вы уверены, что хотите удалить {count, plural, =1 {сайт {name}} one {# выбранный сайт} few {# выбранных сайта} many {# выбранных сайтов} other {# выбранных сайтов}}?',
    'sites.removeConfirmationSubscription' => "Следующие сайты также будут удалены:\n%%domains%%",
    'sites.manageFilesHint' => 'Перейти в папку сайта для управления его файлами.',
    'sites.sitebuilderHint' => 'Редактировать сайт в Presence Builder.',
    'sites.sitebuilderOldHint' => 'Редактировать сайт в SiteBuilder 4 или Редакторе сайтов.',
    'sites.webstatisticsHint' => 'Просмотр статистики посещений веб-сайта.',
    'sites.webstatisticsSslHint' => 'Просмотр статистики посещения сайтов по SSL/TLS.',
    'sites.certificatesHint' => 'Управляйте SSL/TLS-сертификатами.',
    'sites.logsHint' => 'Просмотр журналов.',
    'sites.previewHint' => 'Предварительный просмотр сайта в браузере.',
    'sites.dnsHint' => 'Изменить настройки DNS-зоны.',
    'sites.disabledSelectHint' => 'Этот домен не может быть удален.',
    'sites.websiteAt' => 'Папка сайта:',
    'sites.noHosting' => 'Нет веб-хостинга',
    'sites.forwardingTo' => 'Перенаправлять на',
    'sites.add' => 'Добавить',
    'sites.name' => 'Имя домена',
    'sites.inactive' => 'Неактивный',
    'sites.disabled' => 'Отключен',
    'sites.suspended' => 'Приостановлен',
    'sites.moreActions' => 'Другие действия',
    'sites.domainAliasDescription' => 'Псевдоним для %%siteDisplayName%% %%servicesDescription%%',
    'sites.domainAliasServiceDescription' => '(Активированные услуги: %%service%%)',
    'sites.domainAliasServicesDescription' => '(Активированные услуги: %%services%%)',
    'sites.web' => 'Веб',
    'sites.mail' => 'Почта',
    'sites.dns' => 'DNS',
    'sites.tomcat' => 'Java-приложения',
    'sites.seoRedirect' => 'Перенаправление',
    'sites.sitebuilder' => 'Presence Builder',
    'sites.sitebuilderLegacy' => 'SiteBuilder 4 или Site Editor',
    'sites.sitebuilderLink' => 'Редактировать сайт',
    'sites.error503PageLink' => 'Редактировать страницу ошибки',
    'sites.modeTitle' => 'Режим просмотра',
    'sites.quickStart' => 'Создайте свой сайт одним из следующих способов:',
    'sites.quickStartSitebuilderName' => 'Используйте Presence Builder',
    'sites.quickStartSitebuilderDescription' => 'Создайте свой сайт с помощью нашего профессионального конструктора сайтов.',
    'sites.quickStartSitebuilderLink' => 'Создать сайт',
    'sites.quickStartApplicationsName' => 'Установите приложение',
    'sites.quickStartApplicationsDescription' => 'Создайте сайт, установив веб-приложение, например, Joomla или Drupal.',
    'sites.quickStartApplicationsLink' => 'Установить приложения',
    'sites.quickStartCustomName' => 'Создайте свой сайт',
    'sites.quickStartCustomDescription' => 'Загрузите свой веб-контент и добавьте базы данных.',
    'sites.quickStartCustomFilesLink' => 'Файлы',
    'sites.quickStartCustomDatabasesLink' => 'Базы данных',
    'sites.resellerDescription' => 'Реселлер',
    'sites.ownerDescription' => 'Клиент',

    'sslcertificates.name' => 'Имя',
    'sslcertificates.used' => 'Используется',
    'sslcertificates.csrHint' => 'Запрос на сертификат предоставлен.',
    'sslcertificates.noCsrHint' => 'Запрос на сертификат отсутствует.',
    'sslcertificates.privateKeyHint' => 'Закрытый ключ предоставлен.',
    'sslcertificates.noPrivateKeyHint' => 'Закрытый ключ отсутствует.',
    'sslcertificates.certificateHint' => 'Сертификат предоставлен.',
    'sslcertificates.noCertificateHint' => 'Сертификат отсутствует.',
    'sslcertificates.caCertificateHint' => 'Корневой сертификат предоставлен.',
    'sslcertificates.noCaCertificateHint' => 'Корневой сертификат отсутствует.',
    'sslcertificates.buttonDownloadHint' => 'Скачать все компоненты сертификата.',
    'sslcertificates.webmail' => 'Защитить веб-почту',
    'sslcertificates.hintWebmail' => 'Использовать выбранный SSL/TLS-сертификат для защиты веб-почты на домене.',
    'sslcertificates.remove' => 'Удалить',
    'sslcertificates.hintRemove' => 'Удалить выбранные SSL/TLS-сертификаты из хранилища домена.',
    'sslcertificates.confirmOnDelete' => 'Удалить выбранные SSL/TLS-сертификаты?',
    'sslcertificates.addCertificate' => 'Добавить SSL/TLS-сертификат',
    'sslcertificates.hintAddCertificate' => 'Добавить SSL/TLS-сертификат.',
    'sslcertificates.viewCertificates' => 'Посмотреть сертификаты',
    'sslcertificates.hintViewCertificates' => 'Посмотреть список SSL/TLS-сертификатов, которые вы купили у своего провайдера.',
    'sslcertificates.webmailCertificate' => 'Защищает веб-почту',
    'sslcertificates.mailCertificate' => 'Защищает почту',
    'sslcertificates.mailAndWebmailCertificate' => 'Защищает почту и веб-почту одновременно',
    'sslcertificates.mail' => 'Защитить почту',
    'sslcertificates.hintMail' => 'Используйте выбранный SSL/TLS-сертификат для защиты почты на домене.',

    'subscriptions.subscription' => 'Подписка',
    'subscriptions.price' => 'Плата',
    'subscriptions.renewalDate' => 'Срок действия',
    'subscriptions.setupDate' => 'Дата создания',
    'subscriptions.domains' => 'Веб-сайты',
    'subscriptions.systemUser' => 'Системный пользователь',
    'subscriptions.ipAddress' => 'IP-адрес',
    'subscriptions.addonDomains' => 'Дополнительные домены',
    'subscriptions.diskSpace' => 'Диск',
    'subscriptions.moreDomains' => '... и еще %%count%%',
    'subscriptions.buy' => 'Купить новую подписку',
    'subscriptions.create' => 'Создать подписку',
    'subscriptions.create_powerUser' => 'Создать веб-пространство',
    'subscriptions.renew' => 'Продлить',
    'subscriptions.confirmOnCancel' => 'Отменить подписку?',
    'subscriptions.subscriptionSuspended' => 'Пристановлена',
    'subscriptions.myResources' => 'Мои ресурсы',
    'subscriptions.planName' => 'Тарифные план',
    'subscriptions.switchToLink' => 'Переключиться на подписку',
    'subscriptions.switchToLinkHint' => 'Переключиться на эту подписку',
    'subscriptions.switchToLinkPowerUser' => 'Переключиться на веб-пространство',
    'subscriptions.switchToLinkHintPowerUser' => 'Переключиться на это веб-пространство',
    'subscriptions.buttonRemove' => 'Удалить',
    'subscriptions.buttonRemoveDescription' => 'Удалить выбранные веб-пространства',
    'subscriptions.confirmOnDelete' => 'Удалить выбранные веб-пространства?',
    'subscriptions.buttonAddNew' => 'Добавить веб-пространство',
    'subscriptions.buttonAddNewDescription' => 'Создать веб-пространство.',
    'subscriptions.subscription_powerUser' => 'Веб-пространство',
    'subscriptions.subscriptionPowerUser' => 'Веб-пространство',
    'subscriptions.confirmOnCancel_powerUser' => 'Отменить веб-пространство?',
    'subscriptions.subscriptionSuspended_powerUser' => 'Пристановлена',
    'subscriptions.switchToLink_powerUser' => 'Переключиться на веб-пространство',
    'subscriptions.switchToLinkHint_powerUser' => 'Переключиться на это веб-пространство',
    'subscriptions.primaryDomain' => 'Основной домен',
    'subscriptions.ftpAccess' => 'FTP-доступ',

    'users.contactName' => 'Контактное имя',
    'users.email' => 'Адрес электронной почты',
    'users.role' => 'Роль',
    'users.contacts' => 'Контакты',
    'users.phone' => 'Телефон',
    'users.roleFilter' => 'Роль пользователя',
    'users.filterAnyRole' => 'Все',
    'users.activate' => 'Активировать',
    'users.deactivate' => 'Приостановить',
    'users.remove' => 'Удалить',
    'users.status' => 'Статус',
    'users.statusBlocked' => 'Неактивный',
    'users.buttonAddNewUser' => 'Создать учетную запись',
    'users.hintAddNewUser' => 'Создать учетную запись пользователя.',
    'users.hintRemove' => 'Удалить выбранные учетные записи.',
    'users.disabledSelectHint' => 'Эта учетная запись не может быть удалена, так как является либо системной, либо вашей собственной.',
    'users.confirmOnDelete' => 'Удалить выбранные учетные записи?',

    'webusers.name' => 'Имя',
    'webusers.add' => 'Добавить веб-пользователя',
    'webusers.hintAdd' => 'Добавить учетную запись веб-пользователя. %%resourceUsage%%',
    'webusers.settings' => 'Настройки',
    'webusers.hintSettings' => "Настройки веб-пользователя.",
    'webusers.remove' => 'Удалить',
    'webusers.hintRemove' => 'Удалить выбранных веб-пользователей.',
    'webusers.confirmOnDelete' => 'Удалить выбранных веб-пользователей?',
    'webusers.buttonOpenHomepageHint' => "Нажмите, чтобы открыть домашнюю страницу пользователя в веб-браузере.",
];