<?php
// Copyright 1999-2022. Plesk International GmbH. All rights reserved.
$messages = [
    'backup.title' => 'Back Up the Server',
    'backup.domainTitle' => 'Back Up the Subscription',
    'backup.clientTitle' => 'Back Up Your Data',
    'backup.extensionTitle' => "Back Up Extension's Data",
    'backup.ftpRepositoryNotConfigured' => 'You can only store backups in a remote storage, but no remote storage is currently configured. Configure remote storage in Remote Storage Settings.',
    'backup.error' => 'The backup process failed: %%message%%',
    'backup.success' => 'The backup process has started.',

    'common.dumpInvalidType' => 'Invalid type of a backup file.',
    'common.dumpNotFound' => 'Unable to find a backup file.',
    'common.failedToOpenDump' => 'Failed to open the dump %%name%%: %%error%%',
    'common.taskNotFound' => 'The task with ID %%id%% was not found.',
    'common.downloadFailed' => 'Unable to download a backup file.',

    'conflict-database.title' => 'Define Database Servers Mapping',

    'conflict-ip.title' => 'Define IP Addresses Mapping',

    'copy-to-server.title' => 'Copy the Backup Created on %%backup%% to Server Storage',

    'delete.success' => 'The selected backups were removed from the storage.',
    'delete.fail' => 'Unable to remove the backup %%name%% from the storage.',

    'download-local.title' => 'Download the Backup File',

    'download-log.unfinishedTask' => 'The log file is not available until the task is finished.',
    'download-log.unableOpenLog' => 'Unable to open the log file.',

    'ftp-settings.title' => 'FTP(S) Storage Settings',
    'ftp-settings.success' => 'FTP(S) storage settings were updated.',

    'remote-storages.title' => 'Remote Storage Settings',
    'remote-storages.configured' => 'Ready for use',
    'remote-storages.notConfigured' => 'Not configured',
    'remote-storages.ftpSettings' => 'FTP(S)',
    'remote-storages.securitySettingsTitle' => 'Backup security settings',
    'remote-storages.securitySettingsDescription' => 'You can use a password to encrypt users\' passwords contained in the Plesk database in a backup. Restoring a password-protected backup without providing the password will make Plesk generate the users\' passwords randomly. Note that Plesk does not protect all sensitive data in a backup. We recommend you store backups in remote cloud storage and enable backup encryption on the cloud storage side.',
    'remote-storages.passwordProtection' => 'Password Protection',
    'remote-storages.enabled' => 'Enabled',
    'remote-storages.disabled' => 'Disabled',
    'remote-storages.change' => 'change',

    'remote-settings.success' => 'The storage settings were updated.',
    'remote-settings.notAuthorized' => 'Unable to authorize %%extName%%: %%error%%. The storage cannot be used until authorization is completed. %%authLink%%.',
    'remote-settings.notAuthorizedLinkTitle' => 'Authorize',

    'security-settings.title' => 'Backup Security Settings',
    'security-settings.success' => 'Backup security settings were updated.',

    'list.title' => 'Backup Manager',
    'list.titleForObject' => 'Backup Manager for %%name%%',
    'list.successCopyDumpToServer' => 'The selected files were moved to the server storage.',

    'restore-status.statusRestoreProgress' => 'Restoring %%name%%.',
    'restore-status.statusRestoreSuccess' => 'Restoration of the backup %%name%% completed.',
    'restore-status.statusRemoteRestoreSuccess' => 'The remote backup %%name%% was imported to the server storage and restored.',
    'restore-status.statusRemoteRestoreSuccessAnotherStorage' => 'The remote backup %%name%% was imported to %%storageLink%% and restored.',
    'restore-status.statusRestoreWarning' => 'Restoration of the backup %%name%% completed, though some problems occurred.',
    'restore-status.statusRemoteRestoreWarning' => 'The remote backup %%name%% was imported to the server storage and restored with issues.',
    'restore-status.storageLink' => 'another storage',
    'restore-status.statusRemoteRestoreWarningAnotherStorage' => 'The remote backup %%name%% was imported to %%storageLink%% and restored with issues.',
    'restore-status.statusRestoreError' => 'Restoration of the backup %%name%% failed.',
    'restore-status.statusRestoreStopping' => 'Stopping restoration of the backup %%name%%.',
    'restore-status.statusRestoreStop' => 'Restoration of the backup %%name%% was stopped.',
    'restore-status.statusBackupInfo' => 'The backup %%name%% was created and can be restored, although some minor issues might occur with the way the data is stored.',
    'restore-status.statusBackupWarning' => 'The backup %%name%% was created and can be restored, although some minor issues occurred.',
    'restore-status.statusBackupError' => 'The backup %%name%% was not created.',
    'restore-status.statusBackupErrorWithDump' => 'The backup %%name%% was created, although some issues occurred and the backup might not be entirely valid.',
    'restore-status.statusBackupStopped' => 'The backup %%name%% was stopped.',
    'restore-status.downloadLog' => 'Download the log file',
    'restore-status.viewLog' => 'View the log',
    'restore-status.closeMessage' => 'Close this message',
    'restore-status.stop' => 'Stop',

    'restore.title' => 'Restore the Backup Created on %%backup%%',
    'restore.shortTitle' => 'Restore',
    'restore.unknownOwner' => 'Unknown',

    'schedule.title' => 'Scheduled Backup Settings',
    'schedule.ftpRepositoryNotConfigured' => 'Only the remote storages are allowed for backups but their settings are not specified. Configure a remote storage first.',
    'schedule.success' => 'The backup task was scheduled.',

    'schedule.cloudBackupRestrictionHint' => 'Storing scheduled subscription backups in a remote cloud storage is a premium feature that can be unlocked by your hosting provider. Store backups in the server storage, in the FTP storage, or use manual backups.',
    'schedule.cloudBackupRestrictionHintWithBuy' => 'Storing scheduled subscription backups in a remote cloud storage is a premium feature.',
    'schedule.cloudBackupRestrictionDescription' => 'Storing scheduled subscription backups in a remote cloud storage is a premium feature. Contact your hosting provider to unlock it. You can also store backups in the server storage, in the FTP storage, or use manual backups.',
    'schedule.cloudBackupRestrictionDescriptionWithBuy' => 'Storing scheduled subscription backups in a remote cloud storage is a premium feature. Click "Buy Now" to purchase it from the Plesk Online Store (a single purchase unlocks the ability to use all cloud storages), and then return here to finish setting up your scheduled backup.',
    'schedule.cloudBackupRestrictionBuyButton' => 'Buy Now',
    'schedule.cloudBackupRestrictionCloseButton' => 'Close',

    'settings.title' => 'Backup Settings',
    'settings.settingsUpdated' => 'Server-wide backup settings were updated.',

    'size-hint.title' => 'Details',
    'size-hint.waitMessage' => 'Calculating...',
    'size-hint.thisSize' => 'This addition:',
    'size-hint.prevSize' => 'Previous additions:',
    'size-hint.baseSize' => 'Initial backup:',
    'size-hint.totalSize' => 'Total size:',

    'task-details.title' => 'Backup Details',
    'task-details.detailsSection' => 'Details',
    'task-details.propertyStartDate' => 'Creation date',
    'task-details.propertyBackupName' => 'Backup name',
    'task-details.propertyCreatedBy' => 'Created by',
    'task-details.propertyCurrentOperation' => 'Current operation',
    'task-details.propertyProgress' => 'Overall progress',
    'task-details.errorLogSection' => 'Error Log',
    'task-details.unknownOwner' => 'Unknown',
    'task-details.ok' => 'Ok',
    'task-details.stop' => 'Stop',
    'task-details.statusStopping' => 'The backup task is stopping.',

    'upload.title' => 'Upload Backup Files from Your Local Computer to the Server Storage',
    'upload.success' => 'The selected backup files were uploaded to the server storage.',

    'view-log.restoreTitle' => 'Restoration Task %%name%% Details',
    'view-log.backupTitle' => 'Backup Task %%name%% Details',
    'view-log.unfinishedTask' => 'The log file is not available until the task is finished.',
    'view-log.unableOpenLog' => 'Unable to open the log file.',
];
