<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Gateway non valido: upstream ha inviato un\'intestazione troppo grande durante la lettura dell\'intestazione della risposta"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Pronto a breve.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Errore interno del server: opzione FollowSymLinks non consentita qui"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Pronto a breve.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "il server ha raggiunto il parametro max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Sintomi</h4><ul><li><p>I siti che hanno un gestore PHP impostato come <strong>Applicazione FPM fornita da Apache</strong> o <strong>Applicazione FPM fornita da nginx</strong> in <strong>Domini</strong> &gt; <strong>example.com</strong> &gt; <strong>Impostazioni PHP</strong> incorrono in uno di questi problemi:</p><ul><li><p>caricamento lento</p></li><li><p>non accessibile (in modo permanente o temporaneo) con un errore 50x nel browser web:</p><pre>502 Gateway non valido</pre><hr><pre>503 Servizio temporaneamente non disponibile</pre><hr><pre>504 Time-out del gateway</pre></li></ul></li><li><p>Il seguente messaggio appare nel file di registro degli errori PHP-FPM<code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (dove <em>XX</em> è la versione PHP usata dai siti):</p><pre>ATTENZIONE: [pool esempio.com] il server ha raggiunto il parametro max_children (*), considerare la possibilità di aumentarlo</pre><ul><li><p>Il messaggio su indicato è accompagnato di solito da questo errore:</p><pre>impossibile leggere ciò che dice il processo figlio: descrittore file non valido (9)</pre></li></ul></li><li><p>Se nginx è attivo sul server, potrebbe apparire uno dei seguenti messaggi di errore nel file di registro degli errori del dominio<code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connessione() a unix:///var/www/vhosts/system/example.com/php-fpm.sock fallita (11: Risorsa temporaneamente non disponibile) durante la connessione a upstream, client: 203.0.113.2, server: example.com, richiesta: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "esempio.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream ha chiuso prematuramente la connessione durante la lettura dell\'intestazione della risposta da upstream, client: 203.0.113.2, server: esempio.com, richiesta: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>Il PHP-FPM <code>pm.max_children</code> è stato raggiunto dal sito/i.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Aumenta il limite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Aumenta il limite <code>pm.max_children</code> per i domini interessati:</p><ol><li><p>Connessione al server Plesk via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Trova i domini interessati utilizzando questo comando:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Nota:</strong> il numero a sinistra indica quante volte il limite <code>pm.max_children</code> è stato raggiunto dal sito.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 esempio.com<br>50 esempio.net<br>25 esempio.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Accedi a Plesk</a>.</p></li><li><p>Vai in <strong>Domini</strong> &gt; <strong>esempio.com</strong> &gt; <strong>Impostazioni PHP</strong> &gt; <strong>Impostazioni PHP-FPM</strong>.</p></li><li><p>Aumenta il valore <code>pm.max_children</code> per il dominio e applica le modifiche. Aumenta questo valore per tutti i domini elencati nel passaggio 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Troppi file aperti"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx non si avvia/ricarica su un server Plesk: troppi file aperti</p><h4>Sintomi</h4><ul><li><p>Il servizio nginx non si avvia/ricarica col seguente errore nel file <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/esempio.com/logs/proxy_access_ssl_log" failed (24: Troppi file aperti)</pre></li><li><p>Alcuni o tutti i siti non sono accessibili</p></li><li><p>Avviso mostrato in <strong>Strumenti e impostazioni &gt; Diagnostica e ripara</strong>:</p><pre style="white-space: pre-wrap;">Durante la verifica del valore nginx ULIMIT, sono stati trovati N domini sul server. È possibile che ci sia un problema con il limite predefinito di nginx per i file aperti</pre></li><li><p>Le applicazioni web NodeJS e Ruby mostrano un errore 502 Gateway non valido quando eseguono alcuni task di Plesk come la creazione di domini, abbonamenti, modifiche ad Apache o Nginx, ecc.:</p><pre style="white-space: pre-wrap;">Errore del server<br>502 Gateway non valido<br>Il server web ha ricevuto una risposta non valida mentre fungeva da gateway o server proxy.</pre></li><li><p>Dopo <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">aver installato un nuovo certificato per il dominio</a>, quello vecchio appare ancora in un browser. Tuttavia, il certificato corretto è selezionato nella pagina <strong>Domini &gt; esempio.com &gt; Impostazioni di hosting</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>L\'host virtuale di Nginx apre 4 file di registro per ogni host virtuale con hosting fisico:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Di conseguenza, il numero massimo di file aperti è stato superato dal server nginx a causa dell\'elevato numero di domini (solitamente più di 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Aumenta il limite di file aperti',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Attenzione:</strong> l\'esecuzione dell\'utility <code>websrv_ulimits</code> senza l\'opzione <strong>--no-restart</strong> avvia la ricostruzione dei file di configurazione web per tutti i domini e può causare interruzioni significative in presenza di un elevato numero di siti ospitati.<br><br>Eseguire il comando durante la manutenzione.</div><p>È buona pratica impostare il limite di file aperti ad un numero almeno superiore al <strong>numero di domini in Plesk * 16</strong>. L\'esempio riportato mostra le azioni da compiere per impostare il limite a 4096:</p><ol><li><p>Connettiti al server via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Imposta il limite di file aperti a 4096 per Apache e Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Riavvia i servizi Apache e nginx in <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Strumenti e impostazioni &gt; Gestione di servizi</strong> per applicare le modifiche.</p></li><li><p>Verifica che \'Limite file aperti\' sia impostato correttamente dopo il riavvio dei servizi web:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Limite file aperti 4096 4096 file</pre></li><li><p>Se la soluzione indicata non ha risolto il problema, imposta il imite usando l\'utility <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corpo risposta troppo grande"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Pronto a breve.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Accesso negato con codice 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Sintomi</h4><ul><li><p>ModSecurity è installato e attivato in <strong>Strumenti e impostazioni > Firewall dell\'applicazione web (ModSecurity) > Modalità del firewall dell\'applicazione web > Attivato</strong>.</p></li><li>Non è stato possibile caricare un sito ospitato in Plesk. Non è possibile eseguire le operazioni sul sito, come gestire WordPress, accedere alla webmail o accedere al file <code>robots.txt</code>. Il browser può mostrare uno dei seguenti errori: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Un messaggio di errore di ModSecurity come quello più sotto appare nel file di registro <code>/var/log/modsec_audit.log</code> o nella pagina Registri di Plesk (<strong>Domini</strong> &gt; <strong>example.com</strong> &gt; <strong>Registri</strong>): <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Il firewall dell\'applicazione web (ModSecurity) è attivo con un set di regole molto restrittivo come OWASP, Comodo o un set di regole personalizzato come Imunify360. I set di regole restrittive possono bloccare alcune operazioni sul sito.</p><p><Strong>Nota:</strong> l\'errore ModSecurity potrebbe indicare un attacco al tuo server. Usa la soluzione più sotto solo se hai la certezza che ModSecurity blocchi l\'uso valido del tuo sito.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Disattiva il set di regole ModSecurity per ID o Tag',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Trova l\'ID della regola che blocca l\'uso legittimo del tuo sito. Puoi trovare gli ID nei messaggi d\'errore nel file di registro <code>/var/log/modsec_audit.log</code>. L\'ID è un numero intero tra virgolette col prefisso <code>id</code> tra parentesi quadre, ad esempio, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Disattiva specifici set di regole in Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Passa a un altro set di regole di ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Passa a un set di regole ModSecurity meno restrittivo, ad esempio, "Atomic ModSecurity Ruleset". Per farlo, vai in <strong>Strumenti e impostazioni</strong> > <strong>Firewall di Applicazione Web (ModSecurity)</strong> > <strong>Settings</strong>, seleziona <strong>Atomic Standard</strong> e clicca <strong>OK</strong> per applicare le modifiche.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Errore interno server 500: esaurita dimensione memoria consentita di XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Sintomi</h4><ul><li><p>Un sito ospitato in Plesk non è accessibile:</p><pre>500 Internal Server Error</pre></li><li><p>Il seguente errore è presente nel registro del sito:</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Il sito non ha sufficiente memoria allocata per essere elaborato.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Aumenta memory_limit del sito',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "Restrizione open_basedir in vigore"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Sintomi</h4><ul><li><p>Un sito non è accessibile con uno dei seguenti errori nel browser web:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Il seguente messaggio d\'errore appare nella pagina Registri del dominio (<strong>Domini</strong> > <strong>example.com</strong> > <strong>Registri</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Lo script PHP sta cercando di accedere alla directory alla quale non è concesso l\'accesso. Questa restrizione è definita dalla direttiva PHP <code>open_basedir</code> individualmente per ogni dominio. Per impostazione predefinita, <code>open_basedir</code> consente l\'accesso a <code>tmp</code> e alle directory radice dei documenti del dominio, oltre al percorso delle sessioni predefinite del sistema.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Aggiungi il percorso aggiuntivo alla direttiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Disattiva la direttiva open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Vai alla pagina <strong>Domini &gt example.com &gt Impostazioni PHP</strong> e imposta la direttiva <code>open_basedir</code> in "nessuna".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Proibito AH01797: client proibito dalla configurazione del server"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Sintomi</h4><ul><li><p>Il sito mostra un errore simile al seguente:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Il file di registro <code>/var/www/vhosts/system/example.com/logs/error_log</code> contiene errori come il seguente:</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>La configurazione personalizzata di Apache non consente l\'accesso al sito.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Controlla la configurazione del server e i file .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Impossibile accedere alla directory di un sito in Plesk: 403 Proibito"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Sintomi</h4><ul><li><p>Impossibile accedere alla posizione specifica di un sito, ad esempio, <code>http://example.com/some_folder</code>. Si è verificato il seguente errore:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Il seguente errore appare nel file <code>/var/www/vhosts/example.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>La directory richiesta non contiene i file indice o l\'esplorazione della directory non è attivato.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Aggiungi un file indice alla directory',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Attiva esplorazione di directory',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Impossibile accedere alla directory di un sito in Plesk: 403 Proibito"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Sintomi</h4><ul><li><p>Impossibile accedere alla posizione specifica di un sito, ad esempio, <code>http://example.com/some_folder</code>. Si è verificato il seguente errore:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Il seguente errore appare nel file <code>/var/www/vhosts/example.com/logs/error_log</code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>La directory richiesta non contiene i file indice o l\'esplorazione della directory non è attivato.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Aggiungi un file indice alla directory',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Attiva esplorazione directory',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "Il server ha raggiunto l\'impostazione MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Pronto a breve.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP limite corpo richiesta "Il client voleva inviare un corpo troppo grande"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Pronto a breve.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP limite corpo richiesta "Il client voleva inviare un corpo troppo grande"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Pronto a breve.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP Sessioni "503 Errore interno server" o "Impossibile leggere dati sessione"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Pronto a breve.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: impossibile verificare il file htaccess, assicurarsi che sia leggibile"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Sintomi</h4><ul><li><p>Un sito ospitato in Plesk non funziona:</p><pre>Non hai il permesso di accesso / su questo server. <br> Inoltre, si è verificato un errore 403 Forbidden mentre si tentava di usare un ErrorDocument per gestire la richiesta.</pre><p>Invece dell\'errore su indicato, potresti anche vedere una pagina vuota.</p></li><li><p>Il registro dell\'errore del dominio in <strong>Domini &gt example.com &gt Registri</strong> contiene quanto segue:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Permessi errati per i file o le cartelle del dominio.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Ripara i permessi per il contenuto del sito',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Leggi l\'articolo della Base di conoscenza e segui le istruzioni</a>.</p></li></ol>',
];