<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Arxius de registre",
    'action-log.fromDate' => "Des de:",
    'action-log.toDate' => "Fins a:",
    'action-log.clearLog' => "Esborrar registre",
    'action-log.downloadLog' => "Descarregar",
    'action-log.loggedActions' => "Acciones registrades",
    'action-log.storeLogsInDb' => "Guardar registres a la base de dades",
    'action-log.storeNumber' => "Entrades",
    'action-log.dontRemoveRecs' => "No eliminar registres",
    'action-log.confirmCleanLog' => "¿Està segur que desitja eliminar els registres del registre d'accions seleccionats?",
    'action-log.incorrectDate' => "La data especificada no es vàlida.",
    'action-log.incorrectNumPeriods' => "El període de rotació indicat no és vàlid.",
    'action-log.incorrectNumRecords' => "El número de registres indicat no és vàlid.",
    'action-log.yes' => "Sí",
    'action-log.no' => "No",
    'action-log.mixed' => "(combinat)",
    'action-log.period' => "Període",
    'action-log.invalidDatePeriod' => "Període de data no vàlid",
    'action-log.submitDone' => "Els canvis realitzats en relació a la configuració del registre d'accions han estat desats.",
    'action-log.clearDone' => "Registre d'accions eliminat.",
    'action-log.periodDay' => "dies",
    'action-log.periodWeek' => "setmanes",
    'action-log.periodMonth' => "mesos",

    'admin-info.adminInfoSection' => 'Informació per l\'administrador',
    'admin-info.description-admin' => 'Descripció de l\'administrador',
    'admin-info.description-reseller' => 'Descripció del revenedor',
    'admin-info.description-owner' => 'Descripció del propietari',
    'admin-info.description' => 'Descripció',
    'admin-info.descriptionSuccess' => 'La descripció ha estat actualitzada.',
    'admin-info.longDescription' => 'La descripció indicada és massa llarga. Aquesta no pot tenir més de %%max%% símbols.',
    'admin-info.add' => 'Afegir descripció',
    'admin-info.edit' => 'Editar',
    'admin-info.remove' => 'Eliminar',
    'admin-info.confirmOnRemove' => 'Desitja eliminar aquesta descripció?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% del client %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% del revenedor %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% de la subscripció %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% de %%name%%',
    'admin-info.popupHint-admin' => 'Aquesta descripció només la pot veure l\'administrador.',
    'admin-info.popupHint-reseller' => 'Aquesta descripció només la pot veure el revenedor i l\'administrador.',
    'admin-info.popupHint-owner' => 'Aquesta descripció només la pot veure la persona que l\'ha escrita i el proveïdor de hosting d\'aquesta.',
    'admin-info.customerDescriptionHint' => 'Els clients no poden veure aquesta descripció.',
    'admin-info.subscriptionDescriptionHint' => "Aquesta informació només la pot veure el proveïdor de hosting (l'administrador de Plesk o el revenedor).",

    'apache-settings.formGeneralHint' => 'Aquí pot especificar la configuració del servidor web Apache per aquest lloc web. La configuració personalitzada d\'Apache resulta útil si per exemple desitja utilitzar un nou tipus d\'arxius d\'índex al seu lloc web o si vol associar un determinat tipus MIME amb determinades extensions de nom d\'arxiu. El valor predeterminat significa que Apache farà servir la directiva corresponent de la seva configuració a nivell del servidor. Si Apache s\'executa amb nginx com a servidor frontend, aquí també pot especificar la configuració de nginx.',
    'apache-settings.general' => 'Configuració comuna d\'Apache',
    'apache-settings.example' => "Per exemple:\n%%example%%",
    'apache-settings.settingOn' => 'Activat',
    'apache-settings.settingOff' => 'Desactivat (Per defecte)',
    'apache-settings.settingDefault' => 'Predeterminat',
    'apache-settings.settingCustom' => 'Introdueixi un valor personalitzat',
    'apache-settings.mimeTypes' => 'Tipus MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Els tipus MIME associen les extensions d\'arxiu amb tipus d\'arxiu. Generalment això es fa servir per a crear una extensió d\'arxiu personalitzada per tipus d\'arxius comuns.',
    'apache-settings.handlers' => 'Controladors',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Els controladors d'Apache defineix la forma en què el servidor web processa els arxius amb determinades extensions quan aquestes són sol·licitades. Per exemple, l'string 'php-script .script' significa que Apache gestionarà els arxius .script com a scripts php.",
    'apache-settings.deny' => 'Denegar accés al lloc',
    'apache-settings.allow' => 'A excepció de',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nLes xarxes i els hosts indicats no poden accedir al lloc. Si desitja denegar totes les connexions, faci servir '*'.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nLes xarxes i els hosts indicats poden accedir al lloc.",
    'apache-settings.directoryIndex' => 'Arxius d\'índex',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache buscarà els arxius indicats quan es sol·liciti la pàgina d'índex del lloc.",
    'apache-settings.expires' => 'Expira',
    'apache-settings.expiresStaticOnly' => 'respondre amb capçaleres Expira únicament en el cas d\'arxius estàtics',
    'apache-settings.expiresFullDescription' => 'El servidor web afegirà les capçaleres de resposta "Expira" a les pàgines web. La data i hora d\'expiració s\'obté afegint la quantitat de temps especificada a dalt a l\'hora en que es sol·licita una pàgina web.',
    'apache-settings.expiresStaticOnlyDescription' => 'La capçalera "Expira" únicament s\'afegirà als arxius estàtics. Les opcions "Processament intuïtiu d\'arxius estàtics" i "Servir arxius estàtics directament a través de nginx" regeixen els arxius que es gestionen com a estàtics.',
    'apache-settings.expiresUnitDays' => 'dies',
    'apache-settings.expiresUnitHours' => 'hores',
    'apache-settings.expiresUnitMinutes' => 'minuts',
    'apache-settings.expiresUnitSeconds' => 'segons',
    'apache-settings.headers' => 'Capçaleres addicionals',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "El servidor web afegirà les capçaleres de resposta HTTP especificades.",
    'apache-settings.restrictFollowSymLinks' => 'Restringir l\'habilitat per a seguir enllaços simbòlics',
    'apache-settings.restrictFollowSymLinksDescription' => "Seleccioni aquesta opció si desitja que els usuaris no puguin utilitzar la directiva FollowSymLink a .htaccess per tal de millorar la seguretat del servidor.",
    'apache-settings.nginx' => 'Configuració de nginx',
    'apache-settings.nginxProxyMode' => 'Mode proxy',
    'apache-settings.nginxProxyModeDescription' => 'Peticions de proxis Nginx a Apache. Desactivi-ho per a deixar de fer servir Apache.',
    'apache-settings.nginxTransparentMode' => 'Processament intuïtiu d\'arxius estàtics',
    'apache-settings.nginxTransparentModeDescription' => 'D\'estar desactivat, Apache processarà totes les peticions d\'arxius estàtics. nginx només analitzarà les peticions i les respostes sense efectuar cap modificació. Li recomanem desactivar aquesta opció únicament si desitja resoldre alguna incidència',
    'apache-settings.nginxServeStatic' => 'Servir arxius estàtics directament a través de nginx',
    'apache-settings.nginxStaticExtensions' => 'Indiqui les extensions d\'arxiu separades per espais o pel símbol "|". Les peticions d\'aquests arxius seran gestionades per nginx i mai no arribaran a Apache. Atenció! No s\'aplicaran les regles rewrite d\'Apache.',
    'apache-settings.nginxServePhp' => 'Processar PHP mitjançant nginx',
    'apache-settings.nginxServePhpDescription' => 'Els arxius PHP (.php) seran gestionats per nginx i PHP-FPM. D\'estar desactivat, els arxius PHP seran processats per Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Tamany màxim permès del cos de la petició HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Les peticions amb un cos superior al límit seran descartades amb HTTP 413 Payload Too Large (configura el valor de la directiva "client_max_body_size" de nginx).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'L\'opció està desactivada globalment mitjançant un valor buit/cero de la directiva "clientMaxBodySize" a panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Activar copia en memòria cau nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'La copia a la memòria cau pot reduir el temps de resposta del lloc web i la càrrega del servidor, si bé cal utilitzar-se amb precaució.',
    'apache-settings.nginxCacheSize' => 'Tamany de memòria cau',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Temps d\'espera de memòria cau',
    'apache-settings.nginxCacheTimeoutDays' => 'dies',
    'apache-settings.nginxCacheTimeoutHours' => 'hores',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minuts',
    'apache-settings.nginxCacheTimeoutSeconds' => 'segons',
    'apache-settings.nginxCacheKey' => 'Clau de memòria cau',
    'apache-settings.nginxCacheCookies' => 'Peticions de memòria cau amb cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Desactivar copia a la memòria cau per ubicacions',
    'apache-settings.nginxCacheBypass' => 'Ometre la memòria cau quan',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'Es rebin capçaleres HTTP no-cache a la petició',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'Es rebin capçaleres d\'autorització HTTP a la petició',
    'apache-settings.nginxCacheBypassGetNocache' => 'Es rebi el paràmetre GET nocache a la petició',
    'apache-settings.nginxCacheUseStale' => 'Tornar registres d\'estat en memòria cau',
    'apache-settings.nginxCacheUseStale5xx' => 'La pujada retorna un error de servidor 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'La pujada retorna un error de client 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'La memòria cau s\'està actualitzant',
    'apache-settings.additional' => 'Directives Apache addicionals',
    'apache-settings.additionalSettingsDescription' => 'Si no pot trobar una opció determinada, afegeixi-la als camps que pot veure a continuació. Aquestes opcions substituiran les directives Apache a nivell del servidor. Les directives del primer camp s\'utilitzen quan un visitant accedeix al lloc mitjançant HTTP. El segon camp conté les directives per HTTPS. Normalment hauria d\'afegir les seves directives a ambdós camps. Utilitzi la mateixa sintaxi que la utilitzada per httpd.include. Per exemple, si desitja establir una pàgina d\'error personalitzada, afegeixi la línia: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Directives addicionals per HTTP',
    'apache-settings.additionalSslSettings' => 'Directives addicionals per HTTPS',
    'apache-settings.additionalSettingsError' => 'La configuració d\'Apache no és vàlida: %%error%%',
    'apache-settings.rollbackFailed' => 'No ha estat possible utilitzar l\'arxiu de configuració actual d\'Apache ni revertir a la versió anterior de l\'arxiu perquè presenten una configuració que no és vàlida.',
    'apache-settings.additionalNginx' => 'Directives nginx addicionals',
    'apache-settings.additionalNginxSettingsDescription' => 'Aquí pot especificar la configuració del servidor nginx com a proxy invers d\'Apache. Les seves directives substituiran la configuració de nginx a nivell del servidor. Per exemple, pot ser que desitgi canviar el temps d\'espera de la connexió o bé comprimir les peticions amb gzip. Utilitzi la mateixa sintaxi que la utilitzada per nginx.conf. Per exemple, si desitja comprimir totes les peticions autoritzades amb gzip, afegeixi la següent línia: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Directives nginx addicionals',
    'apache-settings.additionalNginxSettingsError' => 'La configuració de nginx no és vàlida: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'No ha estat possible utilitzar l\'arxiu de configuració actual de nginx ni revertir a la versió anterior de l\'arxiu perquè ambdós presenten una configuració que no és vàlida.',
    'apache-settings.clearCache' => 'Esborrar memòria cau',
    'apache-settings.clearCacheHint' => 'Esborrar memòria cau per %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'La memòria cau s\'ha esborrat correctament',

    'backup.backup-password-protection.securitySettingsSection' => 'Configuració de seguretat dels backups',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Obtenir la contrasenya de la configuració de l\'emmagatzematge remot',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Introduir contrasenya manualment',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Indiqui la contrasenya',
    'backup.backup-password-protection.backupPassword' => 'Contrasenya',
    'backup.backup-password-protection.inputPasswordType' => 'Tipus de contrasenya',
    'backup.backup-password-protection.confirmBackupPassword' => 'Confirmi la contrasenya',
    'backup.backup-password-protection.backupPasswordHint' => 'Si ha oblidat la contrasenya, deseleccioni aquesta opció. En aquest cas algunes dades confidencials no es podran restaurar correctament. Per exemple, les contrasenyes d\'usuari es substituiran per contrasenyes aleatòries o es perdrà la informació sobre les aplicacions APS instal·lades.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Si va protegir aquest backup amb una contrasenya, indiqui-la als camps que pot veure a continuació. Tingui en compte que si indica una contrasenya incorrecta Plesk no podrà restaurar el backup. En aquest cas, el backup es copiarà a l\'emmagatzematge local',

    'backup.conflict-database.dbMappingLegend' => 'Assignació de servidor de base de dades',
    'backup.conflict-database.serverType' => 'Tipus de servidor',
    'backup.conflict-database.hostName' => 'Nom del host',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Servidor de base de dades de destí',
    'backup.conflict-database.mysql' => 'MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'La base de dades no es pot restaurar. No existeix cap servidor de base de dades apropiat',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Carregar arxiu d\'assignació d\'IP',
    'backup.conflict-ip.ipMappingLegend' => 'Assignació d\'IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Desar arxiu d\'assignació d\'IP actual a l\'arxiu',
    'backup.conflict-ip.ipAddressNotFound' => 'No hi ha cap adreça IP lliure d\'aquest tipus.',
    'backup.conflict-ip.sharedIp' => 'compartida',
    'backup.conflict-ip.dedicatedIp' => 'dedicada',
    'backup.conflict-ip.fileNotFound' => 'L\'arxiu no pot estar buit.',
    'backup.conflict-ip.invalidIpToMap' => 'S\'ha indicat un valor no vàlid per a una adreça IP anterior: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'S\'ha indicat un valor no vàlid per a una adreça IP nova: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'L\'adreça IP %%ip%% no s\'ha trobat a la base de dades.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Carregar un arxiu d\'assignació d\'IP',
    'backup.conflict-ip.ipMappingFileHint' => 'Un arxiu d\'assignació d\'IP és un arxiu de text sense format. Cada línia d\'aquest arxiu conté l\'assignació d\'IP en el següent format: <adreça IP antiga> <adreça IP nova>',
    'backup.conflict-ip.oldIp' => 'Adreces IP antigues',
    'backup.conflict-ip.newIp' => 'Adreces IP noves',

    'backup.copy-to-server.ignoreBackupSign' => 'Carregar arxius de backup sense una signatura vàlida',
    'backup.copy-to-server.wrongPassword' => 'La contrasenya indicada no és correcta. Durant la restauració del backup, Plesk li sol·licitarà que torni a indicar la contrasenya.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'L\'arxiu de backup carregat %%fileName%% s\'ha modificat, està malmès, s\'ha creat en un altre servidor o bé en una versió anterior de Plesk que no suporta la signatura de backups. Abans de restaurar les dades d\'aquest arxiu de backup, comprovi que confia en l\'origen d\'aquest arxiu.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'No ha estat possible carregar l\'arxiu de backup %%fileName%%. L\'arxiu conté dades modificades o malmeses o bé es va crear en un altre servidor o en una versió anterior de Plesk. Per tal de restaurar les dades d\'aquest arxiu, posi\'s en contacte amb el seu proveïdor de hosting.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'No ha estat possible carregar l\'arxiu de backup %%fileName%%. L\'arxiu s\'ha modificat, està malmès, s\'ha creat en un altre servidor o bé en una versió anterior de Plesk que no suporta la signatura de backups. Si confia en aquest backup, seleccioni l\'opció "Carregar arxius de backup sense signatures vàlides" i torni\'l a carregar.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "No ha estat possible moure el backup seleccionat %%fileName%% a l'emmagatzematge del servidor. Error: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "No s'han copiat les següents parts del backup incremental:%%endl%%%%missedParts%%%%endl%%Copiï les parts pendents.",

    'backup.ftp-settings.isActive' => 'Utilitzar emmagatzematge FTP(S)',
    'backup.ftp-settings.host' => 'IP o nom de host del servidor FTP',
    'backup.ftp-settings.directory' => 'Directori on guardar els arxius de backup',
    'backup.ftp-settings.directoryHint' => 'Per exemple, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Nom d\'usuari FTP',
    'backup.ftp-settings.ftpPassword' => 'Contrasenya FTP',
    'backup.ftp-settings.usePassiveMode' => 'Utilitzar mode passiu',
    'backup.ftp-settings.useFtps' => 'Utilitzar FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'No es permet l\'ús del servidor FTP local de Plesk com a emmagatzematge remot. Indiqui una ubicació remota.',
    'backup.ftp-settings.warningHostIsLocal' => 'La configuració de l\'emmagatzematge FTP(S) estableix que els backups es guardin al servidor on es troben els arxius de les seves subscripcions. No recomanem aquesta configuració, ja que aquesta augmenta el risc de pèrdua de dades i pot ocasionar un sobreús de l\'espai al disc.',
    'backup.ftp-settings.enterFtpLogin' => 'Indiqui un nom d\'usuari correcte.',
    'backup.ftp-settings.enterFtpPassword' => 'Indiqui una contrasenya correcta.',

    'backup.remote-settings.isActive' => 'Utilitzar l\'emmagatzematge',
    'backup.remote-settings.initError' => 'No ha estat possible inicialitzar la pàgina de configuració de %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Configuració de seguretat dels backups',

    'backup.restore.detailsSection' => 'Detalls',
    'backup.restore.contentInfoSection' => 'Contingut del backup',
    'backup.restore.restorationOptionsSection' => 'Opcions de restauració',
    'backup.restore.emailNotification' => 'Un cop finalitzada la restauració, enviar una notificació a',
    'backup.restore.comments' => 'Comentaris',
    'backup.restore.creationDate' => 'Data de creació',
    'backup.restore.systemNotes' => 'Notes del sistema',
    'backup.restore.ownerAdmin' => 'Creat per l\'administrador.',
    'backup.restore.ownerReseller' => 'Creat per un revenedor.',
    'backup.restore.ownerCustomer' => 'Creat pel client.',
    'backup.restore.ownerServiceUser' => 'Creat per un usuari addicional.',
    'backup.restore.partOfParentBackup' => 'Part del backup %%type%%.',
    'backup.restore.server' => 'servidor',
    'backup.restore.reseller' => 'revenedor',
    'backup.restore.client' => 'client',
    'backup.restore.incremental' => 'Incremental.',
    'backup.restore.multiVolume' => 'Diversos volums.',
    'backup.restore.backupSize' => 'Tamany del backup',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (aquesta addició) + %%base%% (backup inicial) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (aquesta addició) + %%prev%% (addicions anteriors) + %%base%% (backup inicial) = %%total%%',
    'backup.restore.download' => 'Descarregar',
    'backup.restore.downloadHint' => 'Descarregui l\'arxiu de backup al seu ordinador local.',
    'backup.restore.downloadDisabled' => 'En aquest moment no es poden descarregar arxius de backup. Torni-ho a provar en uns minuts o posi\'s en contacte amb el seu proveïdor de serveis.',
    'backup.restore.copy' => 'Copiar a l\'emmagatzematge del servidor',
    'backup.restore.copyHint' => 'Copiï els arxius de backup seleccionats a l\'emmagatzematge del servidor.',
    'backup.restore.contentInfo' => 'El backup conté',
    'backup.restore.restoreButton' => 'Restaurar',
    'backup.restore.mail' => 'Correu',
    'backup.restore.domainConfiguration' => 'Configuració del domini',
    'backup.restore.virtualHost' => 'Contingut del host virtual',
    'backup.restore.database' => 'Bases de dades',
    'backup.restore.serverConfiguration' => 'Configuració del servidor',
    'backup.restore.serverConfigurationLicense' => 'Clau de llicència',
    'backup.restore.serverPersonalConfiguration' => 'Configuració del compte d\'administrador',
    'backup.restore.serverPersonalDomains' => 'Dominis de l\'administrador',
    'backup.restore.serverPersonalClients' => 'Clients de l\'administrador',
    'backup.restore.resellers' => 'Revenedors',
    'backup.restore.resellerPersonalConfiguration' => 'Configuració del compte de revenedor',
    'backup.restore.resellerPersonalDomains' => 'Dominis del revenedor',
    'backup.restore.resellerPersonalClients' => 'Clients del revenedor',
    'backup.restore.clientPersonalConfiguration' => 'Configuració del compte de client',
    'backup.restore.clientPersonalDomains' => 'Dominis del client',
    'backup.restore.restoreModifiedSection' => 'Restaurar l\'arxiu de backup encara que la signatura estigui malmesa',
    'backup.restore.restoreModifiedDump' => 'Restaurar aquest backup encara que no presenti una signatura vàlida',
    'backup.restore.resolutionPolicy' => 'Directiva de resolució',
    'backup.restore.resolutionPolicyDescription' => 'Els conflictes de sincronització apareixen quan l\'objecte restaurat ja existeix al sistema amb una data de modificació més recent o bé quan l\'objecte restaurat no està present al sistema.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'La contrasenya indicada no és correcta. L\'arxiu de backup es copiarà a l\'emmagatzematge local del servidor.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'No ha estat possible restaurar el backup. La contrasenya indicada no és correcta.',
    'backup.restore.serverContentAndConfiguration' => 'Configuració i contingut del servidor',
    'backup.restore.serverConfigurationOnly' => 'Configuració del servidor',
    'backup.restore.resellerContentAndConfiguration' => 'Contingut i configuració del compte de revenedor',
    'backup.restore.resellerConfigurationOnly' => 'Configuració del compte de revenedor',
    'backup.restore.clientContentAndConfiguration' => 'Contingut i configuració del compte de client',
    'backup.restore.clientConfigurationOnly' => 'Configuració del compte de client',
    'backup.restore.domainContentAndConfiguration' => 'Contingut i configuració del domini',
    'backup.restore.domainConfigurationOnly' => 'Configuració del domini',
    'backup.restore.restoreType' => 'Què desitja restaurar?',
    'backup.restore.restoreTypeFull' => 'Tots els objectes (tot el sistema)',
    'backup.restore.restoreTypeGranular' => 'Objectes seleccionats',
    'backup.restore.restoreObjectType' => 'Tipus d\'objecte a restaurar',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Subscripció',
    'backup.restore.restoreObjectTypeCustomers' => 'client',
    'backup.restore.restoreObjectTypeResellers' => 'Revenedor',
    'backup.restore.restoreObjectTypeMailUsers' => 'compte de correu',
    'backup.restore.restoreObjectTypeDatabases' => 'base de dades',
    'backup.restore.restoreObjectTypeCertificates' => 'Certificats SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'llocs',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zona DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Llistes de correu',
    'backup.restore.restoreObjectTypeWebContent' => 'Arxius de dominis',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Arxius seleccionats',
    'backup.restore.restoreSubscriptionLookup' => 'Subscripció',
    'backup.restore.restoreComponents' => 'Components a restaurar',
    'backup.restore.errorLog' => 'Registre d\'errors',
    'backup.restore.backupDetailsLogDoesntExist' => 'El registre del backup no està disponible.',
    'backup.restore.dumpFailedSection' => 'Registre d\'errors',
    'backup.restore.dumpFailed' => 'No ha estat possible restaurar les dades. L\'arxiu de backup no és vàlid.',
    'backup.restore.granularNotSupported' => 'Pot seleccionar els objectes a restaurar únicament quan es restaurin backups creats a Plesk 12.0 o una versió posterior.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'En el mode de visualització de Power User del revenedor no es suporta la restauració de totes les dades dels backups. Seleccioni els objectes que desitja restaurar. Pot canviar el mode de visualització de la interfície a %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Preferències de la interfície',
    'backup.restore.contentRestoreType' => 'Restaurar',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Només la configuració dels objectes seleccionats',
    'backup.restore.contentRestoreTypeFull' => 'Configuració i contingut dels objectes seleccionats',
    'backup.restore.errorWrongFormat' => 'No ha estat possible restaurar el backup. L\'arxiu conté un format que no és correcte.',
    'backup.restore.errorContentError' => 'És possible que no es restaurin totes les dades: el backup presenta errors de contingut.',
    'backup.restore.warningSignError' => 'No ha estat possible validar la signatura del backup. És possible que l\'arxiu de backup s\'hagi modificat, estigui malmès o bé s\'hagi creat en un altre servidor o en una versió anterior de Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Aquest backup només pot ser restaurat per l\'administrador de Plesk.',
    'backup.restore.warningPartial' => "No s'han trobat les següents parts del backup incremental:%%endl%%%%missedParts%%%%endl%%És possible que no es restaurin tots els arxius. Carregui les parts restants i provi a tornar a efectuar la restauració.",
    'backup.restore.warningDeprecatedBackupVersion' => 'L\'arxiu de backup que està intentant restaurar es va crear en una versió no suportada de Plesk, motiu pel que no es pot restaurar. Utilitzi l\'extensió Plesk Migrator per a transferir les dades de versions anteriors de Plesk.',
    'backup.restore.encryptionKeyError' => 'Aquest backup inclou contrasenyes d\'un o més comptes que no poden ser restaurades i es tornaran a establir. Probablement, aquest backup es va crear en un altre servidor Plesk i es va xifrar amb la seva clau de xifratge.',
    'backup.restore.errorCorruptedContent' => 'Els arxius detallats a continuació no s\'han pogut trobar o bé es troben malmesos: ',
    'backup.restore.statusSection' => 'Estat del backup',
    'backup.restore.statusDetails' => 'Detalls de l\'estat',
    'backup.restore.restoreBlocked' => 'El backup no es pot restaurar.',
    'backup.restore.restoreBlockedDescription' => 'En aquests moments no es pot restaurar el backup de tipus %%backupType%%. Per a restaurar-lo, iniciï sessió com a propietari del backup i faci clic al nom d\'aquest backup a l\'administrador de backups.',

    'backup.schedule.scheduleSection' => 'Programació',
    'backup.schedule.backupEnable' => 'Activar aquesta tasca de backup',
    'backup.schedule.backupPeriod' => 'Executar aquesta tasca de backup',
    'backup.schedule.on' => 'activat',
    'backup.schedule.at' => 'a les',
    'backup.schedule.useIncremental' => 'Utilitzar backup incremental',
    'backup.schedule.fullBackupPeriod' => 'Realitzar backup complet',
    'backup.schedule.daily' => 'Cada dia',
    'backup.schedule.weekly' => 'Cada setmana',
    'backup.schedule.monthly' => 'Cada mes',
    'backup.schedule.yearly' => 'Cada any',
    'backup.schedule.days' => 'dies',
    'backup.schedule.weeks' => 'setmanes',
    'backup.schedule.months' => 'mesos',
    'backup.schedule.years' => 'anys',
    'backup.schedule.backupTimeDescription' => 'Zona horària: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Zona horària del sistema predeterminada',
    'backup.schedule.first' => 'Primera',
    'backup.schedule.last' => 'Última',
    'backup.schedule.dayOfMonth' => 'dia',
    'backup.schedule.email' => 'Si durant l\'execució d\'aquesta tasca de backup experimenta algun error, enviar una notificació per email a',
    'backup.schedule.invalidFields' => 'Alguns camps estan buits o contenen valors que no són vàlids: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Número màxim d\'arxius de backup complet a emmagatzemar (incloent tant els backups programats com els backups manuals)',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Deixi aquest camp buit si no desitja eliminar els backups complets automàticament.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'El límit especificat pel proveïdor de hosting pel que fa a l\'emmagatzematge del servidor és %%max%%. El seu límit ha de ser igual o inferior a %%max%%.',
    'backup.schedule.backupToCloudIsNotAllowed' => 'L\'emmagatzematge de backups programats de la subscripció en un emmagatzematge cloud remot és una funció premium que es pot contractar a la botiga online de Plesk.',

    'backup.secure-backup.hint' => 'Pot utilitzar una contrasenya per xifrar les contrasenyes dels usuaris presents a la base de dades de Plesk en un backup. Tingui en compte que si es restaura un backup protegir amb contrasenya sense indicar la contrasenya, Plesk generarà les contrasenyes dels usuaris de manera aleatòria.',
    'backup.secure-backup.hintAdmin' => 'Pot xifrar les contrasenyes de la base de dades de Plesk presents en backups amb la clau xifratge de Plesk o bé amb una contrasenya. La clau és única per cadascuna de les instal·lacions de Plesk. Tingui en compte que els backups xifrats amb la clau només es poden restaurar a la instal·lació de Plesk on es van crear, no podent-se restaurar a cap altra instal·lació de Plesk. Tanmateix, tingui en compte que Plesk no protegeix totes les dades confidencials presents en un backup. Li recomanem emmagatzemar els backups en un emmagatzematge cloud remot i activar el xifratge de backups a nivell de l\'emmagatzematge cloud.',
    'backup.secure-backup.usePasswordProtection' => 'Utilitzar protecció amb contrasenya (recomanat)',
    'backup.secure-backup.backupPasswordSource' => 'Tipus de contrasenya',
    'backup.secure-backup.pleskKey' => 'Clau de xifratge de Plesk',
    'backup.secure-backup.userPassword' => 'Contrasenya indicada',
    'backup.secure-backup.password' => 'Contrasenya',
    'backup.secure-backup.passwordConfirmation' => 'Confirmi la contrasenya',

    'backup.subform.settingsSection' => 'Configuració de backup',
    'backup.subform.prefix' => 'Afegir un prefix al nom del backup',
    'backup.subform.comment' => 'Comentaris',
    'backup.subform.splitSize' => 'Crear un backup multi volum, tamany del volum (MB)',
    'backup.subform.repository' => 'On emmagatzemar-lo',
    'backup.subform.repositoryDescription' => 'No ha indicat la configuració de l\'emmagatzematge FTP(S). %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Tant l\'emmagatzematge al servidor com %%name%%',
    'backup.subform.remoteRepository' => 'emmagatzematge remot',
    'backup.subform.remoteRepositoryText' => 'Seleccioni l\'emmagatzematge remot al núvol',
    'backup.subform.configureRemoteRepositories' => 'Si desitja conservar els seus backups al núvol, pot <a href="%%url%%">configurar emmagatzematges remots</a>',
    'backup.subform.configureFtpRepository' => 'Pot <a href="%%url%%">configurar un emmagatzematge FTP</a> per a desar els backups allà',
    'backup.subform.repositoryConfigure' => 'Configurar',
    'backup.subform.email' => 'Un cop finalitzada la tasca de backup, enviar una notificació a',
    'backup.subform.contentSection' => 'Contingut del backup',
    'backup.subform.domainConfiguration' => 'Configuració',
    'backup.subform.domainConfigurationVhost' => 'Bases de dades i arxius de l\'usuari',
    'backup.subform.domainConfigurationMail' => 'Missatges de correu',
    'backup.subform.content' => 'Crear backup',
    'backup.subform.backupAll' => 'Tot el contingut i la configuració',
    'backup.subform.backupConfiguration' => 'Només configuració',
    'backup.subform.backupVhost' => 'Tot el contingut i la configuració excepte els missatges de correu',
    'backup.subform.backupMail' => 'Només configuració i missatges de correu',
    'backup.subform.mssqlNativeBackup' => 'Si és possible, utilitzar la funcionalitat de backups nativa de MS SQL',
    'backup.subform.mssqlNativeBackupAdmin' => 'Utilitzar la funcionalitat de backups nativa de MS SQL. En el cas de bases de dades remotes, comprovi que ha configurat les opcions de backup del servidor MS SQL remot a Eines i configuració> Servidors de base de dades)',
    'backup.subform.localRepository' => 'Emmagatzematge del servidor',
    'backup.subform.localRepositoryPath' => 'Emmagatzematge del servidor a %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Emmagatzematge FTP(S) a %%uri%% <a href="%%link%%">Canviar configuració</a>',
    'backup.subform.ftpRepositoryText' => 'Emmagatzematge FTP(S) a %%uri%%',
    'backup.subform.type' => 'Tipus',
    'backup.subform.typeFullBackup' => 'Complet',
    'backup.subform.typeIncremental' => 'Incremental',
    'backup.subform.typeIncrementalDescription' => 'Copiï les dades de hosting de correu i web que hagin canviat des de la creació del darrer backup. Tingui en compte que les dades de la base de dades sempre es copien de forma completa.',
    'backup.subform.incrementalNotAvailable' => 'Per a crear backups incrementals, primer ha de crear un backup complet.',
    'backup.subform.excludeLogs' => 'Excloure arxius de registre',
    'backup.subform.excludeFiles' => 'Excloure determinats arxius del backup',
    'backup.subform.excludeFilesDescription' => 'Només pot excloure arxius presents a espais web. Especifiqui la ruta o rutes relatives a l\'arrel de l\'espai web, separant els arxius individuals amb comes. Es permet l\'ús del símbol de màscara (per exemple /somedir/log*).',

    'backup.upload.uploadHint' => 'Aquí pot carregar arxius de backup a l\'emmagatzematge de Plesk. El tamany màxim d\'arxiu permès és de 2 GB.',
    'backup.upload.backupFile' => 'Arxiu de backup',
    'backup.upload.removeLink' => 'Eliminar',
    'backup.upload.addFileLink' => 'Carregar més arxius',
    'backup.upload.backupSecuritySettings' => 'Configuració de seguretat dels backups',
    'backup.upload.signatureHint' => 'Plesk examina els arxius de backup per comprovar que la seva estructura i signatura són correctes. No es confia en aquells arxius que hagin estat modificats, malmesos o creats en un altre servidor. L\'opció que es mostra a continuació li permet restaurar dades d\'aquest tipus d\'arxius. Només seleccioni aquesta opció si confia en l\'origen del backup, ja que la càrrega d\'aquest tipus d\'arxiu pot posar en risc la seva seguretat o fins i tot interrompre el funcionament del servidor. Nota: no es confia en aquells arxius de backup creats amb versions de Plesk anteriors a la versió 11.5, ja que aquests no tenen signatures. Només restauri aquests arxius si realment confia en el seu origen.',
    'backup.upload.ignoreSign' => 'Carregar arxius de backup sense una signatura vàlida',
    'backup.upload.passwordHint' => 'Si va protegir aquest backup amb una contrasenya, indiqui-la als camps que pot veure a continuació. Tingui en compte que si indica una contrasenya incorrecta Plesk li mostrarà una advertència però carregarà igualment el backup al servidor. Durant la restauració del backup, se li demanarà que torni a indicar la contrasenya.',
    'backup.upload.alreadyExistsWarning' => 'A l\'emmagatzematge local del servidor ja existeix l\'arxiu de backup %%fileName%%.',
    'backup.upload.incorrectPasswordWarning' => 'La contrasenya indicada no és correcta. Durant la restauració del backup, Plesk li sol·licitarà que torni a indicar la contrasenya.',
    'backup.upload.deprecatedDumpError' => 'L\'arxiu de backup que està intentant carregar es va crear en una versió no suportada de Plesk, motiu pel que no es pot importar. Utilitzi l\'extensió Plesk Migrator per a transferir les dades de versions anteriors de Plesk.',
    'backup.upload.mailFormatWarning' => 'L\'arxiu de backup %%fileName%% s\'ha carregat a l\'emmagatzematge. Important: l\'arxiu de backup %%fileName%% inclou contingut de correu que no es restaurarà perquè no es suporta el seu format (Plesk 8.3 - 8.6). Per tal de poder restaurar aquest contingut, copiï\'l mitjançant l\'eina de backup de Plesk, seleccioni l\'opció Copiar contingut de les bústies de correu i seleccioni l\'opció amb el buidatge restaurat a qualsevol servidor de correu.',
    'backup.upload.corruptedSignatureAdminWarning' => 'L\'arxiu de backup carregat (%%fileName%%) s\'ha modificat, està malmès, s\'ha creat en un altre servidor o bé en una versió anterior de Plesk que no suporta la signatura de backups. Abans de restaurar les dades d\'aquest arxiu de backup, comprovi que confia en l\'origen d\'aquest arxiu.',
    'backup.upload.corruptedSignatureAdminError' => 'No ha estat possible carregar l\'arxiu de backup (%%fileName%%). L\'arxiu s\'ha modificat, està malmès, s\'ha creat en un altre servidor o bé en una versió anterior de Plesk que no suporta la signatura de backups. Si confia en aquest backup, seleccioni l\'opció "Carregar arxius de backup sense signatures vàlides" i torni\'l a carregar.',
    'backup.upload.corruptedSignatureUserWarning' => 'L\'arxiu de backup carregat (%%fileName%%) conté dades modificades o malmeses o bé es va crear en un altre servidor o en una versió anterior de Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'No ha estat possible carregar l\'arxiu de backup (%%fileName%%). L\'arxiu conté dades modificades o malmeses o bé es va crear en un altre servidor o en una versió anterior de Plesk. Per tal de restaurar les dades d\'aquest arxiu, posi\'s en contacte amb el seu proveïdor de hosting.',
    'backup.upload.uploadError' => 'No ha estat possible carregar %%fileName%% a l\'emmagatzematge del servidor: %%error%%',
    'backup.upload.fileNotSelected' => 'No s\'ha seleccionat cap arxiu a carregar. Seleccioni almenys un arxiu.',
    'backup.upload.missedPartsWarning' => "No s'han carregat les següents parts del backup incremental:%%endl%%%%missedParts%%%%endl%%Carregui les parts pendents.",
    'backup.upload.unknownType' => 'Tipus d\'objecte desconegut',
    'backup.upload.storageLink' => 'un altre emmagatzematge',
    'backup.upload.anotherStorage' => 'El buidatge s\'ha carregat a %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'No s\'ha trobat el revenedor %%name%%. Per tal de restaurar el buidatge carregat, creï el client.',
    'backup.upload.clientNotFound' => 'No s\'ha trobat el client %%name%%. Per tal de restaurar el buidatge carregat, creï el client.',
    'backup.upload.domainNotFound' => 'No s\'ha trobat el domini %%name%%. Per tal de restaurar el buidatge carregat, creï el client.',

    'backup.web-content-dynamic.addButtonTitle' => 'Afegir arxius',
    'backup.web-content-dynamic.noItems' => 'No ha seleccionat cap arxiu',
    'backup.web-content-dynamic.hint' => 'Utilitzi caselles per a seleccionar arxius i carpetes.',
    'backup.web-content-dynamic.title' => 'Seleccionar arxius',
    'backup.web-content-dynamic.columnName' => 'Nom',
    'backup.web-content-dynamic.columnChangeDate' => 'Modificat',
    'backup.web-content-dynamic.columnSize' => 'Tamany',
    'backup.web-content-dynamic.columnPermissions' => 'Permisos',
    'backup.web-content-dynamic.columnUser' => 'Usuari',
    'backup.web-content-dynamic.columnGroup' => 'Grup',
    'backup.web-content-dynamic.waitButtonTitle' => 'Esperi',
    'backup.web-content-dynamic.loadingTitle' => 'Agraïm esperi. Carregant...',

    'backup.invalidFields' => 'Alguns camps estan buits o contenen valors que no són vàlids.',
    'backup.notEnoughDiskSpace' => 'A %%path%% no hi ha suficient espai al disc per crear un backup. Es necessita un mínim de %%required%% GB (es disposa de %%available%% GB)',

    'change-subscriptions-owner.infoTitle' => 'Informació',
    'change-subscriptions-owner.infoDescription' => '%%total%% subscripcions, %%active%% subscripcions actives, %%diskSpace%% espai al disc utilitzat, %%traffic%% trànsit utilitzat',
    'change-subscriptions-owner.possibleOwnersTitle' => 'Possibles nous propietaris de les subscripcions',
    'change-subscriptions-owner.selectedSubscriptions' => 'Subscripcions seleccionades',
    'change-subscriptions-owner.subscriptionName' => 'Nom de la subscripció',
    'change-subscriptions-owner.ownerName' => 'Nom del propietari',
    'change-subscriptions-owner.currentIpAddress' => 'Adreça IP actual',
    'change-subscriptions-owner.newIpAddress' => 'Adreça IP nova',
    'change-subscriptions-owner.submit' => 'Reassignar',

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, E/S disc',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Defineixi límits de consum del recursos del sistema per part d\'una subscripció. Per tal de garantir que no s\'excedeixen els límits establerts, Plesk utilitza una funció del kernel de Linux anomenada grups de control (cgroups).',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => 'Limiti les subscripcions individuals a la quantitat especificada d\'ús de CPU.',
    'cgroups-settings.cpuPeriodLimit' => 'Període durant el que es verifica l\'ús de la CPU',
    'cgroups-settings.percentUsageDescription' => 'La quantitat total de temps de la CPU pel seu servidor és de %%total%%%%units%%',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limiti les subscripcions individuals a la quantitat especificada d\'ús de RAM. Si una subscripció excedeix aquest límit, s\'aturarà el procés que consumeixi més RAM.',
    'cgroups-settings.ramPeriodLimit' => 'Període durant el que es verifica l\'ús de la RAM',
    'cgroups-settings.diskSettings' => 'E/S disc',
    'cgroups-settings.diskReadSettings' => 'Lectura del disc',
    'cgroups-settings.diskReadSettingsDescription' => 'Permeti a les subscripcions individuals utilitzar l\'amplada de banda de lectura del disc únicament dins del límit especificat.',
    'cgroups-settings.diskReadPeriodLimit' => 'Període durant el que es verifica l\'ús de la lectura del disc',
    'cgroups-settings.diskWriteSettings' => 'Escriptura del disc',
    'cgroups-settings.diskWriteSettingsDescription' => 'Permeti a les subscripcions individuals utilitzar l\'amplada de banda d\'escriptura del disc únicament dins del límit especificat.',
    'cgroups-settings.diskWritePeriodLimit' => 'Període durant el que es verifica l\'ús de l\'escriptura del disc',
    'cgroups-settings.limit' => 'Límit',
    'cgroups-settings.threshold' => 'Notificar a l\'excedir',
    'cgroups-settings.limitNotificationEnabled' => 'Notificació activada',
    'cgroups-settings.periodFiveMinutes' => '5 minuts',
    'cgroups-settings.periodHour' => '1 hora',
    'cgroups-settings.periodDay' => '1 dia (24 hores)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/seg',

    'custom-button.privateLabel' => 'Només mostrar-m\'ho a mi',
    'custom-button.textLabel' => 'Etiqueta de botó',
    'custom-button.tooltipLabel' => 'Text de l\'indicador de funció',
    'custom-button.iconLabel' => 'Imatge de fons',
    'custom-button.priorityLabel' => 'Prioritat',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Afegir paràmetres a l\'URL',
    'custom-button.placeLabel' => 'Ubicació',
    'custom-button.internalLabel' => 'Obrir l\'URL a Plesk',
    'custom-button.internalDescription' => 'Indiqui si desitja que l\'URL s\'obri en una pàgina de Plesk o bé en una nova finestra del navegador.',
    'custom-button.noFrameLabel' => 'No utilitzar marcs',
    'custom-button.noFrameDescription' => 'Si afegeix un botó personalitzat que redirecciona a una extensió de Plesk o a una aplicació present al panell del client, pot indicar com s\'hauria de mostrar aquesta extensió o aplicació: en un marc o com a part del GUI de Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Incloure ID de la subscripció, ID del domini i ID de l\'àlies de domini',
    'custom-button.urlParamLabel_dom_name' => 'Incloure nom del domini principal',
    'custom-button.urlParamLabel_ftp_user' => 'Incloure nom d\'usuari FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Incloure contrasenya FTP',
    'custom-button.urlParamLabel_cl_id' => 'Incloure ID del client',
    'custom-button.urlParamLabel_cname' => 'Incloure nom de l\'empresa del client',
    'custom-button.urlParamLabel_pname' => 'Incloure nom de contacte del client',
    'custom-button.urlParamLabel_email' => 'Incloure email del client',
    'custom-button.buttonPlace_navigation' => 'Accés comú',
    'custom-button.buttonPlace_admin' => 'Pàgina inicial de l\'administrador',
    'custom-button.buttonPlace_admin-settings' => 'Pàgina d\'eines i configuració de l\'administrador',
    'custom-button.buttonPlace_reseller' => "Pàgina inicial del revenedor",
    'custom-button.buttonPlace_reseller-settings' => 'Pàgina Eines i utilitats del revenedor',
    'custom-button.buttonPlace_client' => 'Pàgina inicial del client',
    'custom-button.buttonPlace_domain' => "Pàgina Llocs web i dominis de la subscripció",
    'custom-button.buttonPlace_domain_powerUser' => "Pàgina Llocs web i dominis de l'espai web",
    'custom-button.buttonPlace_domain-properties' => 'Eines per a llocs web',

    'database-server-change-password.adminPassword' => 'Contrasenya de l\'administrador',
    'database-server-change-password.success' => 'La contrasenya de l\'administrador s\'ha actualitzat correctament.',

    'database-server-create.general' => 'General',
    'database-server-create.type' => 'Tipus de servidor de base de dades',
    'database-server-create.unixSocket' => '(connexió local)',
    'database-server-create.host' => 'Nom del host o adreça IP',
    'database-server-create.port' => 'Número de port',
    'database-server-create.portDescription' => 'Deixi-ho en blanc si desitja utilitzar el número de port predeterminat',
    'database-server-create.version' => 'Versió del servidor de base de dades',
    'database-server-create.default' => 'Utilitzar aquest servidor com a predeterminat per %%type%%',
    'database-server-create.externalConnections' => 'Permetre que el servidor MySQL local accepti connexions externes',
    'database-server-create.externalConnectionsDescription' => 'De canviar aquest paràmetre, es reiniciarà el servidor MySQL local. Si desitja activar l\'accés remot a d\'altres servidors MySQL registrats a Plesk, modifiqui la seva configuració de forma manual.',
    'database-server-create.authentication' => 'Autenticació',
    'database-server-create.authenticationAddDescription' => 'Indique les credencials de l\'administrador de la base de dades que farà servir Plesk per a accedir al servidor de base de dades. Tingui en compte que al servidor de base de dades hi ha d\'haver un compte d\'administrador amb aquestes credencials.',
    'database-server-create.authenticationEditDescription' => 'Aquí pot canviar les credencials que Plesk fa servir per a accedir al servidor de base de dades. Aquestes credencials han de ser les mateixes que les de l\'administrador de la base de dades. Per exemple, un cop hagi canviat les credencials de l\'administrador al servidor de base de dades, també les haurà de canviar a Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Aquí pot canviar les credencials que Plesk fa servir per a accedir al servidor de base de dades. Si canvia el nom d\'usuari o la contrasenya a continuació, s\'actualitzarà el compte d\'usuari de la base de dades amb drets d\'administrador tant a Plesk com al servidor de base de dades.',
    'database-server-create.adminLogin' => 'Nom d\'usuari',
    'database-server-create.adminPassword' => 'Contrasenya',
    'database-server-create.createSuccess' => 'El servidor de base de dades s\'ha creat correctament.',
    'database-server-create.createError' => 'El servidor de base de dades s\'ha creat amb un error: %%error%%',
    'database-server-create.updateSuccess' => 'El servidor de base de dades s\'ha actualitzat correctament.',
    'database-server-create.updateError' => 'El servidor de base de dades s\'ha actualitzat amb un error: %%error%%.',
    'database-server-create.backupSettings' => 'Backup',
    'database-server-create.backupTempDir' => 'Directori temporal',
    'database-server-create.backupTempDirDescription' => 'La ruta a una carpeta física al servidor remot on hi ha el servidor MS SQL. El servidor MS SQL ha de poder accedir a aquesta carpeta per llegir i escriure als arxius de backup temporals. Per exemple, C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Directori de xarxa temporal',
    'database-server-create.backupNetworkTempDirDescription' => 'La ruta al recurs compartit de xarxa assignada a la carpeta física indicada a sobre. Plesk accedirà a la carpeta compartida per a descarregar i carregar arxius de backup. Per exemple, \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Nom d\'usuari',
    'database-server-create.backupNetworkUserDescription' => 'El nom d\'usuari d\'un usuari de la xarxa creat al servidor remot. Per exemple, ServerName\\UserName. L\'usuari ha de tenir accés a la carpeta compartida indicada a dalt.',
    'database-server-create.backupNetworkPassword' => 'Contrasenya',

    'domain.connection-info.title' => 'Informació de la connexió',
    'domain.connection-info.systemUserCredentials' => 'Credencials de l\'usuari del sistema',
    'domain.connection-info.systemUserCredentialsHint' => 'L\' accés FTP sempre es troba activat, accés a través de SSH o Escriptori Remot — només si %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 's\'ha concedit el permís',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'El seu accés a través de SSH o Escriptori Remot es troba activat i no pot gestionar el seu estat.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'El seu accés a través de SSH o Escriptori Remot es troba desactivat i no pot gestionar el seu estat.',
    'domain.connection-info.ipAddress' => 'Adreça IP',
    'domain.connection-info.copyToClipboard' => 'Copiar al porta-retalls',
    'domain.connection-info.username' => 'Nom d\'usuari',
    'domain.connection-info.password' => 'Contrasenya',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Canvi de contrasenya de l\'usuari del sistema',
    'domain.connection-info.changePasswordTooltip' => 'Canviar contrasenya',
    'domain.connection-info.newPassword' => 'Contrasenya nova',
    'domain.connection-info.manageAccess' => 'Gestionar accés',
    'domain.connection-info.additionalFtpAccounts' => 'Comptes FTP addicionals',
    'domain.connection-info.database' => 'base de dades',
    'domain.connection-info.databaseHint' => '1 de %%number%% bases de dades pertanyents a la subscripció.',
    'domain.connection-info.databaseNotCreatedHint' => 'Base de dades no creada.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Servidor MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Host',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Nom de la base de dades',
    'domain.connection-info.addDatabase' => 'Afegir base de dades',
    'domain.connection-info.manageDatabases' => 'Gestioni bases de dades',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Canvi de contrasenya de l\'usuari de la base de dades',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'No oblidi actualitzar la contrasenya als arxius de configuració de la seva aplicació un cop canviada aquí.',
    'domain.connection-info.buttonSave' => 'Desar',
    'domain.connection-info.buttonSaving' => 'Desant...',
    'domain.connection-info.buttonCancel' => 'Cancel·lar',

    'domain.move.title' => 'Transferir el domini %%name%%',
    'domain.move.hint' => 'El domini es transferirà a la nova subscripció juntament amb el seu contingut, arxius de configuració, arxius de registre i aplicacions APS.',
    'domain.move.hintMain' => 'El domini es transferirà a una nova subscripció amb el seu contingut, arxius de configuració i de registre, bases de dades, usuaris de bases de dades, usuaris FTP addicionals, tasques programades, usuaris smb i aplicacions APS.',
    'domain.move.hintSubdomains' => 'Els subdominis %%subdomains%% es transferiran juntament amb el domini principal.',
    'domain.move.hintAliases' => 'Els àlies de domini %%aliases%% es transferiran juntament amb el domini principal.',
    'domain.move.hintSubdomainsAndAliases' => 'Els subdominis %%subdomains%% i els àlies de domini %%aliases%% es transferiran juntament amb el domini principal.',
    'domain.move.labelDatabases' => 'Un cop mogut el domini, obri la pestanya "Bases de dades" per a transferir les bases de dades associades.',
    'domain.move.hintDatabases' => 'Si és necessari, mogui les bases de dades d\'una en una.',

    'domain.move.Form.submitButton' => 'Transferir',
    'domain.move.Form.cancelButton' => 'Cancel·lar',

    'domain.move.selectTarget' => 'Subscripcions disponibles',
    'domain.move.nothingFound' => 'No s\'ha trobat res',
    'domain.move.targetIsRequred' => 'Seleccioni la subscripció a la qual desitja transferir el domini.',
    'domain.move.selectNewSubscription' => 'Crear una nova subscripció',
    'domain.move.ipv4Address' => 'Adreça IPv4',
    'domain.move.ipv4AddressHint' => 'L\'adreça IP on s\'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.',
    'domain.move.ipv6Address' => 'Adreça IPv6',
    'domain.move.ipv6AddressHint' => 'L\'adreça IP on s\'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.',
    'domain.move.ipAddressIsNotSelected' => 'Seleccioni com a mínim una adreça IP.',
    'domain.move.username' => 'Nom d\'usuari',
    'domain.move.usernameHint' => 'El compte d\'usuari del sistema associat amb l\'espai web. S\'utilitza per a accedir als arxius allotjats a través de FTP i SSH.',
    'domain.move.usernameIsRequred' => 'Indiqui un nom d\'usuari.',
    'domain.move.password' => 'Contrasenya',
    'domain.move.passwordIsRequred' => 'Indiqui una contrasenya.',
    'domain.move.noAvailableSubscriptions' => 'Cap subscripció disponible',
    'domain.move.noWebHosting' => 'En aquest moment no es crearà cap usuari del sistema perquè el domini no disposa de hosting web.',

    'domain.rename.title' => 'Canviar nom de domini',
    'domain.rename.titleAlias' => 'Canviar nom d\'àlies de domini',
    'domain.rename.hint' => 'Ara està canviant el nom de domini %%domainName%%',
    'domain.rename.hintAlias' => 'Ara està canviant el nom de l\'àlies de domini %%domainName%%',
    'domain.rename.name' => 'Nom de domini nou',
    'domain.rename.nameAlias' => 'Nom d\'àlies de domini nou',
    'domain.rename.domainNameIsRequired' => 'Aquest camp obligatori està buit. Indiqui algun valor.',
    'domain.rename.submitButton' => 'Canviar',
    'domain.rename.submitButtonProgress' => 'Canviant',
    'domain.rename.successMessage' => 'El nom de domini %%oldName%% s\'ha canviat a %%newName%%.',
    'domain.rename.successMessageAlias' => 'El nom de l\'àlies de domini %%oldName%% s\'ha canviat a %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Cancel·lar',

    'domain.outgoing-messages.hint' => 'Aquí pot modificar el límit màxim de correus sortints per aquest domini. Un cop assolit aquest limit no es podran enviar més correus.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Predeterminat (%%domainOutgoingMessages%% correus/hora)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'correus/hora',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Límit de correus sortints',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Valor personalitzat per aquest domini',

    'domain.tech-domain-name.title' => 'Seleccioni el seu nom de domini',
    'domain.tech-domain-name.techDomainTitle' => 'Nom de domini temporal',
    'domain.tech-domain-name.customDomainTitle' => 'Nom de domini registrat',
    'domain.tech-domain-name.techDomainText' => 'Encara no he registrat cap nom de domini',
    'domain.tech-domain-name.customDomainText' => 'Ja he registrat un nom de domini',
    'domain.tech-domain-name.techDomain' => 'El seu nom de domini temporal',
    'domain.tech-domain-name.customDomain' => 'Nom de domini registrat',
    'domain.tech-domain-name.domainName' => 'Nom del domini',
    'domain.tech-domain-name.techDomainDesc' => 'Els noms de domini temporals s\'utilitzen per accedir al seu lloc abans que registri i compri un nom de domini apropiat. Aquests es proporcionen de forma gratuïta amb les següents condicions:',
    'domain.tech-domain-name.techDomainRandom' => 'Els noms es generen de forma aleatòria',
    'domain.tech-domain-name.techDomainDns' => 'Aquests s\'allotgen a la zona DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Pot passar a un nom de domini registrat més endavant canviant el nom del seu domini a la configuració del domini.',
    'domain.tech-domain-name.error' => 'S\'ha produït un error inesperat.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Seleccioni l\'adreça IP.',
    'domain.tech-domain-name.generating' => 'Generant...',

    'domain-alias.name' => 'Nom de l\'àlies de domini',
    'domain-alias.domainName' => 'Pel domini',
    'domain-alias.sectionSettings' => 'Configuració',
    'domain-alias.dns' => 'Sincronitzar la zona DNS amb el domini principal',
    'domain-alias.mail' => 'Servei de correu',
    'domain-alias.web' => 'Servei web',
    'domain-alias.seoRedirect' => 'Redireccionament amb el codi HTTP 301',
    'domain-alias.seoRedirectDesc' => "Quan els visitants obrin l'URL de l'àlies, se'ls redireccionarà a l'URL del domini principal. Plesk utilitza el redireccionament HTTP 301 compatible amb els navegadors, el que significa que el posicionament als buscadors no es dividirà entre les diferents URLs.",
    'domain-alias.on' => 'Activat',
    'domain-alias.off' => 'Desactivat',

    'get-password.label' => 'Restablir la contrasenya',
    'get-password.text' => 'Indiqui la seva adreça de correu o el nom d\'usuari registrat a Plesk i li enviarem un email per a restablir la contrasenya.',
    'get-password.emailLabel' => 'Adreça de correu',
    'get-password.loginLabel' => 'Nom d\'usuari',
    'get-password.send' => 'Enviar',
    'get-password.cancel' => 'Cancel·lar',
    'get-password.errorInvalidEmail' => 'No s\'ha reconegut l\'adreça de correu electrònic. Comprovi-ho i torni-ho a provar.',
    'get-password.messageSend' => "L'email de restabliment de la contrasenya s'ha enviat a l'adreça de correu electrònic associada.\nSi no el rep, posi's en contacte amb el seu administrador de Plesk.",

    'iis-settings.formGeneralHint' => 'Aquí pot especificar la configuració del servidor web IIS pel seu lloc web canviant els valors predeterminats. La configuració personalitzada d\'IIS resulta útil si per exemple desitja utilitzar un nou tipus d\'arxius d\'índex al seu lloc web o si vol associar un determinat tipus MIME amb determinades extensions de nom d\'arxiu. Els valors predeterminats són definits pel seu proveïdor de hosting.',
    'iis-settings.formGeneralHint_powerUser' => 'Aquí pot especificar la configuració del servidor web IIS per aquest lloc web. La configuració personalitzada d\'IIS resulta útil si per exemple desitja utilitzar un nou tipus d\'arxius d\'índex al seu lloc web o si vol associar un determinat tipus MIME amb determinades extensions de nom d\'arxiu. Els valors predeterminats signifiquen que IIS utilitzarà les directives corresponents de la seva configuració per defecte.',
    'iis-settings.virtualDirectoryLoadError' => 'No ha estat possible obtenir les propietats del directori virtual indicat: %%errorMessage%%',
    'iis-settings.general' => 'Configuració comuna',
    'iis-settings.example' => "Per exemple:\n%%example%%",
    'iis-settings.settingOn' => 'Activat',
    'iis-settings.settingOff' => 'Desactivat (Per defecte)',
    'iis-settings.settingDefault' => 'Predeterminat',
    'iis-settings.settingCustom' => 'Introdueixi un valor personalitzat',
    'iis-settings.mimeTypes' => 'Tipus MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Els tipus MIME associen les extensions d\'arxiu amb tipus d\'arxiu. Generalment això es fa servir per a crear una extensió d\'arxiu personalitzada per tipus d\'arxius comuns.',
    'iis-settings.documents' => 'Documents predeterminats',
    'iis-settings.documentsOff' => 'Desactivat',
    'iis-settings.documentsCustom' => 'Especifiqui els valors',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Quan els navegadors no proporcionen el nom d\'un document del seu lloc, IIS buscarà els documents predeterminats especificats i servirà el primer que trobi. Si no especifica els documents predeterminats però activa la navegació pels directoris, als navegadors no es mostrarà la pàgina d\'índex sinó la llista de directoris.',
    'iis-settings.expires' => 'Expira',
    'iis-settings.expiresFullDescription' => 'El servidor web afegirà les capçaleres de resposta "Expira" a les pàgines web. La data i hora d\'expiració s\'obté afegint la quantitat de temps especificada a dalt a l\'hora en que es sol·licita una pàgina web.',
    'iis-settings.expiresUnitDays' => 'dies',
    'iis-settings.expiresUnitHours' => 'hores',
    'iis-settings.expiresUnitMinutes' => 'minuts',
    'iis-settings.expiresUnitSeconds' => 'segons',
    'iis-settings.headers' => 'Capçaleres addicionals',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'El servidor web afegirà les capçaleres de resposta HTTP especificades.',
    'iis-settings.directoryBrowsing' => 'Navegació pels directoris',
    'iis-settings.directoryBrowsingDescription' => 'Permet als usuaris veure la llista de directoris del lloc als seus navegadors web, com per exemple quan la pàgina d\'índex predeterminada no està disponible.',
    'iis-settings.securityTabDirectory' => 'Configuració de seguretat del directori',
    'iis-settings.allowAnonymous' => 'Autenticació anònima',
    'iis-settings.allowAnonymousDescription' => 'L\'autenticació anònima permet als usuaris accedir al contingut públic del seu lloc. Els usuaris anònims no podran accedir als continguts del seu lloc que hagin estat protegits amb una contrasenya, ni tampoc al contingut protegit a nivell del sistema d\'arxius.',
    'iis-settings.allowWindows' => 'Autenticació de Windows',
    'iis-settings.allowWindowsDescription' => 'L\'autenticació de Windows (anteriorment denominada NTLM) protegeix el contingut del seu lloc a nivell del sistema d\'arxius.',
    'iis-settings.requireSsl' => 'Requerir SSL/TLS',
    'iis-settings.requireSslDescription' => 'Si ha activat el suport per a SSL/TLS pel seu lloc, aquesta opció forçarà als clients web (navegadors) a utilitzar únicament connexions HTTPS segures.',
    'iis-settings.securityTabIpDeny' => 'Configuració de restricció d\'accés',
    'iis-settings.deny' => 'Denegar accés al lloc',
    'iis-settings.denyOff' => 'Predeterminat',
    'iis-settings.denyCustom' => 'Indiqui un valor personalitzat',
    'iis-settings.allow' => 'A excepció de',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nLes xarxes i els hosts indicats no poden accedir al lloc. Si desitja denegar totes les connexions, faci servir '*'.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nLes xarxes i els hosts indicats poden accedir al lloc.",
    'iis-settings.dynamicIpSecurity' => 'Prevenció d\'atacs DoS mitjançant la restricció dinàmica d\'adreces IP d\'IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Denegar adreces IP en funció del número de peticions concurrents des d\'una adreça IP única',
    'iis-settings.maxConcurrentRequests' => 'Número màxim de peticions concurrents',
    'iis-settings.isDenyByRequestRate' => 'Denegar adreces IP en funció del número de peticions durant un període de temps',
    'iis-settings.maxRequests' => 'Número màxim de peticions',
    'iis-settings.requestInterval' => 'Període de temps (en mil·lisegons)',

    'ip-addresses-selector.ipAddress' => 'Adreça IP',
    'ip-addresses-selector.ipv4Address' => 'Adreça IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.",
    'ip-addresses-selector.ipv6Address' => 'Adreça IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.",
    'ip-addresses-selector.noIpAddressHint' => 'Cap',
    'ip-addresses-selector.shared' => 'compartida',
    'ip-addresses-selector.exclusive' => 'dedicada',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'El servidor FTP no suporta IPv6. Assigni almenys una adreça IPv4, ja que sinó l\'usuari no podrà carregar arxius al servidor mitjançant FTP.',

    'license-key-revert.description' => 'Es restaurarà la clau de llicència amb les següents propietats:',
    'license-key-revert.submitButton' => 'Revertir',

    'license-key-upload.description' => 'Instal·li la seva clau de llicència indicant un codi d\'activació.',
    'license-key-upload.descriptionWithFileUpload' => 'Instal·li la seva clau de llicència introduint el codi d\'activació o bé carregant un arxiu de clau de llicència.',
    'license-key-upload.type' => 'Seleccioni una de les següents opcions:',
    'license-key-upload.code' => 'Introdueixi el codi d\'activació',
    'license-key-upload.codeDescription' => 'Enganxi el codi d\'activació rebut.',
    'license-key-upload.file' => 'Carregar un arxiu de clau de llicència',
    'license-key-upload.fileDescription' => 'Indiqui la ruta a l\'arxiu que conté la clau de llicència.',
    'license-key-upload.submitButton' => 'Instal·lar',

    'log-rotation.customLogsDescription' => 'Tingui en compte que els seus registres personalitzats no es roten.',
    'log-rotation.logRotation' => 'Rotació de registres',
    'log-rotation.logRotationCondition' => 'Condició de rotació de registres',
    'log-rotation.logRotationBySize' => 'per tamany',
    'log-rotation.logRotationByTime' => 'per hora',
    'log-rotation.logRotationDaily' => 'Cada dia',
    'log-rotation.logRotationWeekly' => 'Cada setmana',
    'log-rotation.logRotationMonthly' => 'Cada mes',
    'log-rotation.logRotationSizeDescription' => 'El valor de tamany ha de ser %%min%% - %%max%% KB.',
    'log-rotation.maximumNumberOfFiles' => 'Número màxim d\'arxius de registre',
    'log-rotation.compress' => 'Comprimir arxius de registre',
    'log-rotation.sendLogToEmail' => 'Un cop Plesk hagi recuperat les dades dels arxius de registre dels servidors FTP i web, enviar els arxius de registre per email a aquesta adreça',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'El període no pot ser superior al límit a nivell del servidor de %%max%%.',

    'login.loginLabel' => 'Nom d\'usuari',
    'login.passwdLabel' => 'Contrasenya',
    'login.localeLabel' => 'Idioma de la interfície',
    'login.defaultLocale' => 'Predeterminat',
    'login.loginButtonLabel' => 'Iniciar sessió',
    'login.enterUsername' => 'Indiqui el seu nom d\'usuari.',
    'login.enterPassword' => 'Indiqui la seva contrasenya.',
    'login.whatUsernamePassword' => 'Quin nom d\'usuari i contrasenya cal utilitzar?',
    'login.forgotPasswordLabel' => 'Ha oblidat la seva contrasenya?',
    'login.cookies' => 'Directiva de cookies a Plesk',
    'login.avoidSSLWarningsMsg' => 'Per tal d\'evitar l\'aparició d\'advertències SSL quan s\'accedeixi a Plesk, utilitzi %%link%%',
    'login.digitalOceanMsg' => 'Acaba d\'arribar a Plesk a DigitalOcean? Utilitzi "root" i la contrasenya introduïda quan crei aquest droplet per iniciar sessió. %%link%%',
    'login.amazonLightsailMsg' => 'Acaba d\'arribar a Plesk a Lightsail? Per accedir a Plesk, accedeixi al servidor a través de SSH i utilitzi l\'ordre "plesk login". %%link%%',
    'login.readGuide' => 'Llegeixi la guia completa.',
    'login.mobileApplicationMessage' => 'Per tal de gaudir d\'una millor experiència, li recomanem instal·lar l\'aplicació %%name%%.',
    'login.mobileApplicationInstall' => 'Instal·lar ara',
    'login.mobileApplicationHide' => 'No, gràcies',

    'force-reset-password.saveButton' => 'Desar',
    'force-reset-password.title' => 'Canvi de la seva contrasenya',
    'force-reset-password.passwordLabel' => 'Contrasenya nova',

    'panel-access.title' => 'Personalització de l\'URL de Plesk',
    'panel-access.hint' => 'Seleccioni URLs personalitzades per a iniciar sessió a Plesk. Això no farà que ja no es pugui accedir a Plesk a través del port %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Més informació',
    'panel-access.proxyEnabled' => 'Tots els dominis i subdominis que resolen a l\'adreça IP del servidor però que no s\'utilitzen pel hosting',
    'panel-access.proxyDomain' => 'El domini o subdomini indicat que resol a l\'adreça IP del servidor però que no s\'utilitza pel hosting',
    'panel-access.proxyDisabled' => 'No hi ha cap URL personalitzada. Només https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Desar',
    'panel-access.Form.cancelButton' => 'Cancel·lar',

    'panel-access.domainNameIsRequired' => 'Indiqui un nom de domini.',
    'panel-access.successMessage' => 'S\'ha aplicat la manera seleccionada d\'iniciar sessió.',
    'panel-access.notSupported' => 'El seu Plesk no suporta la manera seleccionada d\'inici de sessió.',
    'panel-access.notViaDomainName' => 'Per a aplicar aquesta manera d\'inici de sessió, seleccioni la primera opció ("Tots els dominis i subdominis..."), accedeixi a Plesk a través de https://%%domainName%% i trii la segona opció.',
    'panel-access.notViaPort' => 'Per a aplicar aquesta manera d\'inici de sessió, accedeixi primer a Plesk a través de https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Configuració de seguretat i rendiment',
    'php-settings.settings' => 'Configuració comuna',
    'php-settings.fastCgiSettings' => 'Configuració de FastCGI',
    'php-settings.fpmSettings' => 'Configuració de PHP-FPM',
    'php-settings.enableFastcgi' => 'Activar la configuració de FastCGI',
    'php-settings.plainTextEditing' => 'Directives addicionals',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Pot definir qualsevol paràmetre PHP introduint-lo al camp que pot veure a continuació. Les directives s\'inclouran a la configuració de PHP. Utilitzi la mateixa sintaxi que la que utilitzaria per php.ini. Per exemple, si desitja carregar l\'extensió mSQL de forma automàtica, afegeixi la següent línia: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Si no pot trobar algun paràmetre de PHP, afegeixi\'l al camp que pot veure a continuació. Aquestes directives addicionals es combinaran amb les directives del pla de serveis principal. Utilitzi la mateixa sintaxi que la utilitzada per php.ini. Per exemple, si desitja carregar l\'extensió mSQL de forma automàtica, afegeixi la següent línia: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Pot definir qualsevol paràmetre PHP introduint-lo al camp que pot veure a continuació. Les directives s\'inclouran a la configuració de PHP. Utilitzi la mateixa sintaxi que la que utilitzaria per php.ini. Per exemple, si desitja carregar l\'extensió mSQL de forma automàtica, afegeixi la següent línia: extension=msql.so. Per a personalitzar la configuració del grup PHP-FPM, afegeixi el separador [php-fpm-pool-settings] i indiqui a continuació la configuració desitjada.',
    'php-settings.additionalConfigurationDirectives' => 'Directives de configuració addicionals',
    'php-settings.defaultValue' => 'Predeterminat',
    'php-settings.predefinedValue' => 'Seleccioni un valor',
    'php-settings.customValue' => 'Introdueixi un valor personalitzat',
    'php-settings.phpSettingDescription_memory_limit' => 'La quantitat màxima de memòria en bytes que pot assignar un script.',
    'php-settings.phpSettingDescription_max_execution_time' => 'El temps màxim en segons durant el qual pot executar-se un script abans que es finalitzi.',
    'php-settings.phpSettingDescription_max_input_time' => 'El temps màxim en segons durant el qual un script pot analitzar dades d\'entrada.',
    'php-settings.phpSettingDescription_post_max_size' => 'El tamany màxim de dades en bytes que poden publicar-se amb el mètode POST. Generalment hauria de ser superior a upload_max_filesize i inferior a memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'El tamany màxim en bytes d\'un arxiu carregat.',
    'php-settings.phpSettingDescription_safe_mode' => 'El mode segur de PHP imposa vàries restriccions relacionades amb l\'execució d\'scripts, principalment per motius de seguretat.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Quan la directiva safe_mode està activa, és possible accedir als arxius presents al directori indicat mitjançant scripts PHP. El directori també ha d\'estar a include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Quan la directiva safe_mode està activa, els programes presents al directori indicat poden executar-se mitjançant scripts PHP.',
    'php-settings.phpSettingDescription_include_path' => 'La llista de directoris on els scripts cerquen arxius (similar a la variable PATH del sistema). Per separar directoris, faci servir dos punts (:) a Linux i punt i coma (;) a Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'El directori on s\'emmagatzemen els arxius de sessió de PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Paràmetres addicionals per la funció mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Registri els continguts de les variables EGPCS (Environment, GET, POST, Cookie, Server) com variables globals.',
    'php-settings.phpSettingDescription_open_basedir' => 'Els scripts PHP poden accedir als arxius als directoris indicats. Per separar directoris, faci servir dos punts (:) a Linux i punt i coma (;) a Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'El nivell d\'informació de l\'error.',
    'php-settings.phpSettingDescription_display_errors' => 'Determina si s\'haurien de mostrar els errors com a part de la sortida.',
    'php-settings.phpSettingDescription_log_errors' => 'Activi el registre d\'errors de PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Permet a les funcions d\'arxiu PHP recuperar dades d\'ubicacions remotes mitjançant FTP o HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Permet carregar arxius mitjançant HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Permet la forma breu ( ) de l\'etiqueta oberta de PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Estableix l\'estat magic_quotes per les operacions GPC (Get/Post/Cookie). Si activa magic_quotes, tots els caràcters especials NULL, cometes simples o dobles i barres invertides s\'escapen automàticament amb una barra invertida.',
    'php-settings.phpSettingDescription_disable_functions' => 'Aquesta directiva li permet desactivar algunes funcions. Aquesta recull una llista de noms de funcions separats per comes',
    'php-settings.phpSupport' => 'Suport de PHP',
    'php-settings.phpRunAs' => 'executar PHP com a',
    'php-settings.phpVersion' => 'Versió de PHP',
    'php-settings.phpHandlerOutdated' => '(Obsolet)',
    'php-settings.phpHandlerDeprecated' => '(En desús)',
    'php-settings.phpServedByApache' => 'servit per Apache',
    'php-settings.phpServedByNginx' => 'servit per nginx',
    'php-settings.phpSettingsPhpVersion' => 'La seva versió de PHP és %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP està desactivat.',
    'php-settings.phpHandlerTypeHint' => 'A continuació pot veure la informació sobre la configuració de PHP del lloc web. Pot canviar-la sempre que el proveïdor de hosting li hagi concedit el permís corresponent.',
    'php-settings.fpmDedicatedHandlerHint' => 'L\'ús d\'aquest controlador augmenta l\'estabilitat d\'un lloc web, si bé també consumeix més memòria.',
    'php-settings.phpHandlerChangeHint' => 'Ha modificat la configuració de controladors de PHP. Si desa els canvis, és possible que els scripts de PHP presents al seu lloc web s\'aturin durant %%interval%% segons a causa de la configuració del seu servidor.',
    'php-settings.phpHandlerOutdatedHint' => 'Per comprovar si la nova versió de PHP està disponible, %%link%% i examini la categoria "Hosting Web" dels components de producte.',
    'php-settings.phpHandlerOutdatedHintLink' => 'obri Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Descobreixi com escollir la configuració de PHP més apropiada per vostè',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'No és possible activar el suport de PHP perquè la configuració de hosting actual no inclou cap versió de PHP disponible per aquest domini.',
    'php-settings.phpHandlersNotAvailableHint' => 'El suport de PHP no es pot activar perquè la configuració vigent de Plesk no inclou cap versió disponible de PHP.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Descobreixi com activar altres versions de PHP.',
    'php-settings.phpSupportEditable' => '(Versió de PHP %%version%%, executar PHP com a %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(versió: %%version%%; controlador: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(no registrat) %%link%%',
    'php-settings.showPhpInfo' => 'Veure la pàgina phpinfo()',
    'php-settings.phpSettingsFormError' => 'No ha estat possible recuperar la configuració de PHP perquè no s\'han trobat les dades necessàries.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'No ha estat possible recuperar la configuració de PHP perquè aquesta versió de PHP no està instal·lada. Per continuar, instal·li la versió seleccionada de PHP o seleccioni una altra versió pel domini.',
    'php-settings.showPhpInfoTitle' => 'Veure phpinfo()',
    'php-settings.showPhpInfoDescription' => 'S\'han canviat alguns dels seus paràmetres de configuració de PHP però els canvis encara no s\'han desat. Si desitja veure els nous valors a la pàgina phpinfo(), apliqui primer els canvis. Si no ho fa, veurà els valors actuals.',
    'php-settings.showPhpInfoButton' => 'Veure phpinfo()',
    'php-settings.onState' => 'Activat',
    'php-settings.offState' => 'Desactivat',

    'pmm.agent.sync.check' => 'L\'agent de migracions i transferències està cercant actualitzacions.',
    'pmm.agent.sync.updating' => 'Sincronitzant i descarregant l\'agent de migracions i transferències',
    'pmm.agent.sync.done' => 'L\'agent de migracions i transferències s\'ha sincronitzat correctament.',
    'pmm.agent.sync.downloadLink' => 'Faci clic per a descarregar l\'arxiu de l\'agent de migracions i transferències que caldria instal·lar al host d\'origen abans d\'iniciar la migració.',
    'pmm.agent.sync.error' => 'L\'agent de migracions i transferències no ha pogut obtenir les actualitzacions. Torni-ho a provar en uns minuts.',

    'restore-password.title' => 'Canvi de la seva contrasenya',
    'restore-password.passwordLabel' => 'Contrasenya nova',
    'restore-password.buttonRestore' => 'Desar',
    'restore-password.buttonCancel' => 'Cancel·lar',
    'restore-password.isEmpty' => 'El camp obligatori està buit. Indiqui algun valor.',
    'restore-password.errorInvalidSecret' => 'El codi secret no és vàlid',
    'restore-password.errorNotFoundSecret' => 'Sol·liciti un nou codi secret',
    'restore-password.restoreSuccess' => 'La seva contrasenya ha estat actualitzada. Utilitzi la nova contrasenya per a accedir a Plesk o a la seva adreça de correu electrònic.',

    'scheduler.settings.schedulerNotification' => 'Notificació del planificador',
    'scheduler.settings.notificationOff' => "Desactivat",
    'scheduler.settings.notificationDefault' => "Enviar a l'adreça de correu predeterminada (%%email%%)",
    'scheduler.settings.notificationCustom' => "Enviar a l'adreça de correu que especifiqui",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => 'Mostrar planificació de tasques utilitzant una zona horària',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Utilitzar la zona horària predeterminada del sistema (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Utilitzar la zona horària predeterminada del sistema',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Utilitzar la zona horària que especifiqui',

    'scheduler.task.active' => 'Activa',
    'scheduler.task.subscription' => 'Subscripció',
    'scheduler.task.subscription_powerUser' => 'Espai web',
    'scheduler.task.type' => 'Tipus de tasca',
    'scheduler.task.typeCommand' => 'Executar una ordre',
    'scheduler.task.typeUrl' => 'Obtenir una URL',
    'scheduler.task.typeScript' => 'Executar un script PHP',
    'scheduler.task.command' => 'Ordre',
    'scheduler.task.arguments' => 'amb arguments',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Indiqui una URL absoluta, com per exemple http://example.com. Si el codi d\'estat de la resposta és 2xx o 3xx, es considerarà que la tasca s\'ha executat correctament.',
    'scheduler.task.script' => 'Ruta de la seqüència d\'ordres',
    'scheduler.task.scriptRelativePathDescription' => 'Exemple: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Indiqui la ruta completa a l\'script. Exemple: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Utilitzar la versió de PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Ruta de la seqüència d\'ordres',
    'scheduler.task.run' => 'Executar',
    'scheduler.task.on' => 'el',
    'scheduler.task.at' => 'a les',
    'scheduler.task.sysUser' => 'Usuari del sistema',
    'scheduler.task.hourly' => 'Cada hora',
    'scheduler.task.daily' => 'Cada dia',
    'scheduler.task.weekly' => 'Cada setmana',
    'scheduler.task.monthly' => 'Cada mes',
    'scheduler.task.yearly' => 'Cada any',
    'scheduler.task.cronStyle' => 'Estilo cron',
    'scheduler.task.cronStyleError' => 'La sintaxi crontab no és vàlida.',
    'scheduler.task.cronStyleErrorWin' => 'No es permet l\'ús de barres (/) ni guions (-).',
    'scheduler.task.cronStyleHint' => 'Utilitzi el format crontab UNIX "minut hora dia del mes dia de la setmana". Per exemple, "0 22 * * 1-5". Plesk farà servir la zona horària predeterminada del sistema per a executar la tasca.',
    'scheduler.task.cronStyleWinHint' => 'Utilitzi el format crontab UNIX "minut hora dia del mes dia de la setmana", com per exemple "0 22 * * 6,7". Plesk farà servir la zona horària predeterminada del sistema per a executar la tasca.',
    'scheduler.task.notify' => 'Notificar',
    'scheduler.task.notifyIgnore' => 'No notificar',
    'scheduler.task.notifyErrors' => 'Només errors',
    'scheduler.task.notifyAlways' => 'Sempre',
    'scheduler.task.notifyErrorsHint' => 'Les notificacions inclouen la seqüència estàndard de l\'error de l\'ordre. Si la seqüència està buida, no s\'enviarà cap notificació.',
    'scheduler.task.notifyErrorsHintWin' => 'Les notificacions inclouen la sortida de l\'ordre i només s\'envien si el codi de sortida no és zero.',
    'scheduler.task.notifyAlwaysHint' => 'Les notificacions inclouen la sortida de l\'ordre. Si la sortida està buida, no s\'enviarà cap notificació.',
    'scheduler.task.notifyAlwaysHintWin' => 'Les notificacions inclouen la sortida de l\'ordre i s\'envien sigui quin sigui el codi de sortida de l\'ordre.',
    'scheduler.task.emailType' => 'Enviar notificacions a',
    'scheduler.task.emailTypeDefault' => 'Usuari predeterminat del sistema (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Propietari de la subscripció (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Administrador (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Altres usuaris',
    'scheduler.task.emailTypeCustomDescription' => 'Pot indicar més d\'una adreça separant-les amb comes.',
    'scheduler.task.minute' => 'minut',
    'scheduler.task.shortMinute' => 'min',
    'scheduler.task.dayOfMonth' => 'dia',
    'scheduler.task.description' => 'Descripció',
    'scheduler.task.scheduleTimezoneHint' => 'La zona horària per l\'execució de la tasca és %%timezone%%',
    'scheduler.task.runTaskNow' => 'Executar ara',
    'scheduler.task.runningTask' => 'Executant la tasca "%%task%%"...',

    'server-settings.submitDone' => "La configuració del servidor ha estat modificada.",
    'server-settings.systemSettings' => "Configuració del sistema",
    'server-settings.fullHostName' => "Nom del host complet",
    'server-settings.trafficStatisticsPeriod' => "Conservar estadístiques web i de trànsit durant",
    'server-settings.trafficStatisticsPeriodUnit' => "mesos",
    'server-settings.diskSpaceUsageCalculation' => "Què incloure al càlcul de l'ús de l'espai al disc",
    'server-settings.includeLogs' => "arxius de registre i informes estadístics",
    'server-settings.includeMysqlDatabases' => "Bases de dades MySQL",
    'server-settings.includeMssqlDatabases' => "Bases de dades Microsoft SQL",
    'server-settings.includeDatabases' => "Bases de dades",
    'server-settings.includeRemoteDatabases' => "Bases de dades remotes",
    'server-settings.includeMailboxes' => "Bústies de correu",
    'server-settings.includeMailLists' => "llistes de correu",
    'server-settings.includeDomainDumps' => "arxius de backup del domini",
    'server-settings.includeAdminDumps' => "arxius de backup creats per l'administrador",
    'server-settings.calculatingDiskSpaceUsage' => "Al calcular l'ús de l'espai al disc, comptabilitzar",
    'server-settings.typeByte' => "el tamany de l'arxiu",
    'server-settings.typeBlock' => "la quantitat d'espai al disc utilitzada",
    'server-settings.trafficCalculation' => "Què incloure al càlcul del trànsit",
    'server-settings.inboundAndOutbound' => "trànsit entrant i sortint",
    'server-settings.onlyInbound' => "només el trànsit entrant",
    'server-settings.onlyOutbound' => "només el trànsit sortint",
    'server-settings.forbidCreateDnsSubZone' => "No permetre als usuaris crear subzones DNS a les super zones DNS dels demés usuaris",
    'server-settings.webDeployIncludePassword' => "Incloure la contrasenya de l'usuari a l'arxiu amb la configuració de publicació de Web Deploy",
    'server-settings.forbidSysUserRename' => "Els clients poden canviar el nom dels seus usuaris del sistema",
    'server-settings.alwaysAllowSysUserRename' => "sempre",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "només si s'ha concedit el permís de gestió del hosting",
    'server-settings.neverAllowSysUserRename' => "mai",
    'server-settings.forbidSubscriptionRename' => "Prohibir als clients i revenedors modificar el seu nom de domini principal",
    'server-settings.preferredDomain' => "Domini preferit pels llocs web",
    'server-settings.preferredDomainNone' => "Cap",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Registre d'IPs",
    'server-settings.disableIpLogging' => "Desactivar registre d'IPs a IIS, FTP i registres de correu",
    'server-settings.disableIpLoggingDescription' => "Si es selecciona, IIS i MailEnable ja no escriuran adreces IP als arxius de registre",
    'server-settings.anonymizeIps' => "Anonimitzar adreces IP",
    'server-settings.logrotateAnonymizeIps' => "Anonimitzi les adreces IP durant la rotació de registres i la recopilació d'estadístiques web",
    'server-settings.logrotateAnonymizeIpsDescription' => 'L\'script postrotate substitueix el darrer octet de les adreces IPv4 al arxius de registre rotats per "0" abans de l\'arxivament. En el cas d\'adreces IPv6, l\'script substitueix la darrera secció de l\'adreça (els dos octets després dels darrers dos punts) per "0000" (a la forma completa) o per "0" (a la forma abreujada)',
    'server-settings.logrotate' => "Rotació de registres",
    'server-settings.logrotateForce' => "Forçar la rotació de registres diària per tots els dominis",
    'server-settings.allowToStoreLogs' => "Permetre l'emmagatzematge de registres de lloc web durant",
    'server-settings.logrotatePeriod' => "dies",
    'server-settings.configureUpdatePolicy' => "Configurar directiva d'actualització",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Valor predeterminat a nivell del servidor (%%default%% correus/hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Valor personalitzat pel pla',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Valor personalitzat per la subscripció',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'correus',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Correus sortints des d\'una bústia de correu (per hora)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Correus sortints des d\'un domini (per hora)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Correus sortints des d\'una subscripció (per hora)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'El percentatge de correus per sobre del límit per hora que s\'hauria d\'enviar durant la propera hora',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Si el límit de correus sortints des d\'una bústia de correu cada hora és de 100 i el percentatge és del 10 %, l\'usuari pot enviar 110 correus cada hora. S\'enviaran 100 correus durant una hora i els 10 correus restants es posaran a la cua de correu i s\'enviaran durant la propera hora.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Directiva d\'ús de Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Configuració predeterminada a nivell del servidor (es permet l\'ús de Sendmail)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Configuració predeterminada a nivell del servidor (no es permet l\'ús de Sendmail)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Configuració personalitzada pel pla',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Configuració personalitzada per la subscripció',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Permetre l\'ús de Sendmail als scripts i usuaris d\'aquesta subscripció',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Els scripts i usuaris podran enviar correus en nom de l\'usuari del sistema de la subscripció mitjançant Sendmail, fins i tot en el cas que s\'hagin excedit els límits d\'una bústia de correu o d\'un domini. El número màxim de correus que es poden enviar a través de Sendmail serà definit pel límit de tota una subscripció.',

    'setup.hint' => 'Benvingut a Plesk, un panell de control que l\'ajudarà a gestionar el seu servidor. Plesk proporciona un entorn preparat per a codi i li ofereix un conjunt de potents extensions a través de les quals podrà crear aplicacions i llocs web. Finalitzi el procés de configuració per així poder començar a utilitzar Plesk. Tingui en compte que això tardarà un minut.',
    'setup.contactInfoSection' => 'Informació de contacte',
    'setup.contactInfoSectionHint' => 'Introdueixi el seu nom i la seva adreça de correu per tal d\'identificar-se com a propietari del servidor i així rebre notificacions importants sobre el servidor. Si és l\'administrador d\'un servidor corporatiu, no indiqui el seu nom ni la seva adreça d\'email personal. Utilitzi el seu càrrec i l\'adreça d\'email corporativa per així evitar possibles infraccions de la llei de protecció de dades.',
    'setup.contactName' => 'El seu nom de contacte',
    'setup.emptyContactName' => 'Indiqui un nom de contacte.',
    'setup.contactNameTooLong' => 'El nom de contacte és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'setup.email' => 'Email',
    'setup.emptyEmail' => 'Proporcioni una adreça de correu.',
    'setup.passwordSection' => 'Contrasenya',
    'setup.passwordSectionHint' => 'La propera vegada que accedeixi a Plesk, utilitzi el nom d\'usuari \'admin\' i la contrasenya que pot veure a continuació.',
    'setup.password' => 'Contrasenya',
    'setup.licenseSection' => 'Llicència',
    'setup.licenseSectionHint' => 'Per a començar a utilitzar Plesk és necessari instal·lar una llicència.',
    'setup.licenseType' => 'Seleccioni el tipus de llicència',
    'setup.licenseTypePaid' => 'Procedir amb una llicència de pagament',
    'setup.onlineStoreLink' => 'botiga online',
    'setup.licenseTypeTrial' => 'Procedir amb una llicència de prova totalment funcional',
    'setup.activationCodeHint' => 'Si ja ha comprat una llicència de Plesk, enganxi aquí el codi d\'activació que ha rebut. Si no n\'ha comprat cap, pot comprar-la a la nostra %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Directiva de privacitat de Plesk',
    'setup.trialLicenseAgreement' => 'Per tal de poder emetre una llicència de prova, Plesk International GmbH emprarà i processarà la informació proporcionada als seus sistemes internes conforme a la %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Confirmo que he llegit i que accepto el %%link%%',
    'setup.eula' => 'Contracte de llicència de l\'usuari final',
    'setup.invalidEulaAgreementValue' => 'Accepti el contracte de llicència de l\'usuari final',
    'setup.sendButton' => 'Accedir a Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Restablir la contrasenya admin al proper inici de sessió',

    'ssl-certificate.add.name' => 'Nom del certificat',
    'ssl-certificate.add.longName' => 'El nom del certificat indicat és massa llarg, ja que es permet un màxim de %max% símbols.',
    'ssl-certificate.add.certificateNameUsed' => 'Ja existeix un certificat anomenat %%name%%.',
    'ssl-certificate.add.certificateAdded' => 'El certificat SSL/TLS ha estat emès. Per tal que funcioni correctament, assigni el certificat per a protegir un domini, correu o webmail.',
    'ssl-certificate.add.certificateUpdated' => 'El certificat SSL/TLS s\'ha actualitzat correctament.',
    'ssl-certificate.add.settings' => 'Configuració',
    'ssl-certificate.add.settingsHint' => 'Faci servir aquest formulari per a generar una petició d\'un certificat, per comprar un certificat al seu proveïdor o per generar un certificat signat automàticament.',
    'ssl-certificate.add.settingsHint2' => 'Una petició és un arxiu CSR que conté la informació sobre el seu domini especificada al formulari. Pot enviar la petició a una autoritat de certificació per tal que li emetin un certificat. Posteriorment podrà carregar-lo mitjançant un dels formularis de càrrega mostrats a continuació.',
    'ssl-certificate.add.settingsHint3' => 'Un certificat signat automàticament és un certificat d\'identitat signat pel seu creador. L\'ús d\'aquest tipus de certificat implica que vostè verifica la identitat dels seus llocs. Si bé aquests certificats permeten l\'ús d\'SSL/TLS, no es confia tant en ells i es consideren menys segurs.',
    'ssl-certificate.add.bits' => 'Bits',
    'ssl-certificate.add.country' => 'País',
    'ssl-certificate.add.state' => 'Estat o província',
    'ssl-certificate.add.longState' => 'El nom de l\'estat o província indicat és massa llarg.',
    'ssl-certificate.add.city' => 'Lloc (ciutat)',
    'ssl-certificate.add.longCity' => 'El nom de la ciutat indicat és massa llarg.',
    'ssl-certificate.add.shortCity' => 'El nom de la ciutat indicat és massa curt.',
    'ssl-certificate.add.companyName' => 'Nom de l\'empresa',
    'ssl-certificate.add.longCompanyName' => 'El nom de l\'empresa indicat és massa llarg.',
    'ssl-certificate.add.companyUnitName' => 'Nom de la divisió o departament de l\'empresa',
    'ssl-certificate.add.longCompanyUnitName' => 'El nom del departament indicat és massa llarg, ja que es permet un màxim de %max% símbols.',
    'ssl-certificate.add.domainName' => 'Nom de domini',
    'ssl-certificate.add.email' => 'Email',
    'ssl-certificate.add.request' => 'Sol·licitar',
    'ssl-certificate.add.buyCertificate' => 'Comprar certificat SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Signat automàticament',
    'ssl-certificate.add.invalidCertificateParams' => 'Alguns camps estan buits o contenen valors incorrectes. La longitud màxima dels valors és de 64 caràcters. Si fa servir un nom de domini internacionalitzat, comprovi que no hi ha cap part del nom del domini entre punts que tingui més de 63 símbols quan es converteixi al format ASCII. Comprovi els següents camps:',
    'ssl-certificate.add.unableCreateCsr' => 'No ha estat possible crear una CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'No ha estat possible crear un certificat signat automàticament: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'No s\'han pogut establir les dades del certificat: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'No ha estat possible desar el certificat a la base de dades: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Càrrega dels arxius del certificat',
    'ssl-certificate.add.uploadFilesHint' => 'Utilitzi aquest formulari per a carregar els components d\'un certificat com arxius constituents.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "Clau privada (*.key)",
    'ssl-certificate.add.certificate' => "Certificat (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certificat CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Carregar certificat",
    'ssl-certificate.add.fileNotUploaded' => 'No ha estat possible carregar l\'arxiu del certificat: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'No ha estat possible establir la clau privada: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'No ha estat possible establir el certificat: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'No ha estat possible establir el certificat CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'No ha estat possible verificar si el certificat CA signa el certificat: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Eliminar',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Desitja eliminar el certificat CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'No ha estat possible esborrar el certificat CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'La part CA del certificat ha estat eliminada.',
    'ssl-certificate.add.rename' => 'Canviar el nom',
    'ssl-certificate.add.unableRenameCertificate' => 'No ha estat possible canviar el nom del certificat: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Ara el certificat s\'anomena %%name%%.',
    'ssl-certificate.add.uploadText' => "Càrrega d'un certificat com a text",
    'ssl-certificate.add.uploadTextHint' => 'Utilitzi aquest formulari per a carregar els components d\'un certificat com text. Copiï els continguts d\'un arxiu i enganxi\'ls al camp corresponent.',
    'ssl-certificate.add.sendText' => "Carregar certificat",
    'ssl-certificate.add.componentIsMissing' => 'No s\'ha pogut trobar el component.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Carregui el certificat aquí',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Si ha creat una petició de signatura de certificat en aquest servidor i ha rebut l\'arxiu del certificat, carregui\'l aquí. Si desitja carregar un certificat i un parell de claus privades generat en un altre servidor o bé desitja generar un certificat signat automàticament, faci clic a <b>Afegir certificat SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Un cop afegit un certificat SSL/TLS a un domini, caldrà que activi el suport per SSL/TLS i que seleccioni aquest certificat a la configuració de hosting de llocs web: <b>Llocs web i dominis</b>> <b>Configuració de hosting</b> d\'aquest domini> <b>Seguretat</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certificat (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Carregar certificat',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'No ha estat possible carregar l\'arxiu del certificat.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Format del certificat no vàlid.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'No ha estat possible trobar la clau privada apropiada pel certificat.',

    'ssl-certificate.secure.certificate' => 'Seleccionar certificat',
    'ssl-certificate.secure.serverPool' => 'grup de servidors',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Data",
    'system-time.dateAndTime' => "Data i hora",
    'system-time.daylight' => "Ajustar el rellotge automàticament segons l'horari d'estiu",
    'system-time.dayMonthYear' => "Dia-Mes-Any",
    'system-time.domainNameOrIp' => "Nom del domini o IP",
    'system-time.hoursMinutesSeconds' => "Hores:Minuts:Segons",
    'system-time.networkTime' => "Temps de xarxa",
    'system-time.submitDone' => "La configuració de l'hora del sistema ha estat modificada.",
    'system-time.synchronizedSystemTime' => "Sincronitzar l'hora del sistema",
    'system-time.title' => "Data i hora del sistema",
    'system-time.timezone' => "Zona horària",
    'system-time.time' => "Hora",
    'system-time.updateSystemTime' => "Actualitzar l'hora del sistema",
    'system-time.yourTimezone' => "La seva zona horària",

    'web-app-firewall.pageHint' => 'El firewall per aplicacions web protegeix les aplicacions web davant de possibles atacs verificant i filtrant les peticiones HTTP entrants basant-se en regles definides pels usuaris.',
    'web-app-firewall.webSitePageHint' => 'Aquí pot configurar el firewall per a aplicacions web (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Mode de firewall per a aplicacions web',
    'web-app-firewall.ruleEngineOn' => 'Activat',
    'web-app-firewall.ruleEngineOnDescription' => 'Cadascuna de les peticions HTTP entrants i la resposta relacionada es verifiquen amb un conjunt de regles. Si la comprovació és correcta, la petició HTTP s\'envia al contingut del lloc web. Si no ho és, es registra l\'event, s\'envia una notificació i es proporciona la resposta HTTP amb un codi d\'error.',
    'web-app-firewall.ruleEngineOff' => 'Desactivat',
    'web-app-firewall.ruleEngineOffDescription' => 'Les peticions HTTP entrants i les respostes relaciones no es verifiquen.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Només detecció',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Cadascuna de les peticions HTTP entrants i la resposta relacionada es verifiquen amb un conjunt de regles. Si la comprovació és correcta, la petició HTTP s\'envia al contingut del lloc web. Si no ho és, es registra l\'event i ModSecurity no duu a terme cap altra acció. D\'altres serveis (com per exemple Fail2ban) poden seguir realitzant les seves pròpies accions amb aquelles peticions HTTP que han experimentat errors a la comprovació.',
    'web-app-firewall.ruleSetsSection' => 'Conjunts de regles',
    'web-app-firewall.ruleSetsSectionHint' => 'Seleccioni el conjunt de regles (un paquet d\'arxius que inclou regles de seguretat) a emprar per verificar les peticions HTTP entrants.',
    'web-app-firewall.ruleSet' => 'Conjunt de regles',
    'web-app-firewall.ruleSetCrs' => 'OWASP (gratuït)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity Core Rule Set és molt restrictiu i és possible que bloquegi algunes funcions (com per exemple la compartició d\'arxius o el webmail) i algunes prestacions de les aplicacions web (com per exemple els plugins de WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Desitja aplicar els canvis?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Les regles d\'OWASP poden ser massa restrictives i conseqüentment bloquejar algunes funcions, com per exemple la compartició d\'arxius, el servei de webmail i algunes aplicacions web.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (gratuït, pot actualitzar-se a Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Versió inicial de ModSecurity Rules de Atomicorp. Proporciona protecció bàsica i s\'actualitza cada mes.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Si desitja actualitzar aquest conjunt de regles a Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Compri %%linkPleskStore%% al lloc web de Plesk i %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Regles ModSecurity avançades d\'Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'Instal·li la clau de llicència addicional adquirida',
    'web-app-firewall.ruleSetTortixSelect' => 'Seleccioni aquest conjunt de regles, que canviarà el seu nom a “Atomic Advanced (adquirit a través de Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (adquirit a través de Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Advanced ModSecurity Rules d\'Atomicorp inclou les regles d\'Atomic Standard, a més de diverses prestacions avançades.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (adquirit a través d\'Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Advanced ModSecurity Rules d\'Atomicorp inclou les regles d\'Atomic Standard, a més de diverses prestacions avançades.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Canviï a un altre compte d\'Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'El conjunt de regles es troba activat.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Si ja disposa d\'un compte d\'Atomicorp amb les regles Atomic Advanced adquirides, indiqui les credencials del compte a continuació per tal d\'activar aquest conjunt de regles.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Si ja disposa d\'un compte d\'Atomicorp amb regles avançades d\'Atomic, introdueixi les credencials del compte a continuació per tal de canviar de compte.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Nom d\'usuari',
    'web-app-firewall.ruleSetAtomicPassword' => 'Contrasenya',
    'web-app-firewall.ruleSetComodo' => 'Comodo (subscripció gratuïta)',
    'web-app-firewall.ruleSetComodoDescription' => 'ModSecurity Rules gratuït de Comodo. Proporciona protecció bàsica.',
    'web-app-firewall.ruleSetComodoInstall' => 'Canviï a un altre compte de Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'El conjunt de regles es troba activat.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Per tal d\'activar aquest conjunt de regles:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Per canviar a un altre compte:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registri\'s al lloc web de Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Indiqui el seu nom d\'usuari i la seva contrasenya per a la pàgina web en qüestió.',
    'web-app-firewall.ruleSetComodoLogin' => 'Nom d\'usuari',
    'web-app-firewall.ruleSetComodoPassword' => 'Contrasenya',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (gratuït)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'ModSecurity Rules gratuït de Comodo. Proporciona protecció bàsica.',
    'web-app-firewall.ruleSetCustom' => 'Conjunt de regles personalitzat',
    'web-app-firewall.ruleSetCustomDescription' => 'Carregui un conjunt de regles de firewall per a aplicacions web personalitzat. Es suporten els següents formats: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Seleccionar un altre arxiu',
    'web-app-firewall.ruleSetError' => 'No ha estat possible instal·lar el conjunts de regles ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'No es troba el conjunt de regles OWASP. Torni a instal·lar ModSecurity emprant Plesk Installer.',
    'web-app-firewall.ruleSetCustomMissingError' => 'No es troba el conjunt de regles personalitzat. Torni\'l a instal·lar.',
    'web-app-firewall.ruleSetAuthError' => 'El nom d\'usuari o la contrasenya especificats no són vàlids.',
    'web-app-firewall.ruleSetInvalid' => 'El conjunt de regles seleccionat no pot executar-se a %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'El conjunt de regles seleccionat no pot executar-se al servidor web seleccionat.',
    'web-app-firewall.webServer' => 'Executar regles el',
    'web-app-firewall.webServerHint' => 'Seleccioni la combinació desitjada de servidor web i versió de ModSecurity per veure els conjunts de regles compatibles.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'El servidor proxy invers (nginx) es troba desactivat i no es pot emprar per processar peticions. Seleccioni <a href="%%serverUrl%%">un altre servidor web</a> o desactivi el servidor proxy invers a la <a href="%%servicesUrl%%">pàgina de gestió de serveis</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'De seleccionar una altra versió de ModSecurity, és possible que algunes opcions ja no siguin vàlides (per exemple, no pot emprar expressions regulars per desactivar regles de seguretat amb ModSecurity3). Comprovi que les seves opcions de configuració funcionen correctament un cop aplicats els canvis. D\'altra banda, pot restablir les opcions que desactiven les regles de seguretat als valors predeterminats.',
    'web-app-firewall.nginxResetCustomizations' => 'Restableixi la configuració de domini i de servidor que desactiva les regles de seguretat als valors predeterminats.',
    'web-app-firewall.ruleSetUpdate' => 'Actualitzar conjunts de regles',
    'web-app-firewall.ruleSetUpdateDaily' => 'Cada dia',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Cada setmana',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Cada mes',
    'web-app-firewall.currentRuleSet' => 'Conjunt de regles',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% executant-se a %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Canviar conjunt de regles',
    'web-app-firewall.ruleSetRollbackFailed' => 'No ha estat possible utilitzar el conjunt de regles actual de ModSecurity ni revertir a la versió anterior perquè presenten unes regles que no són vàlides.',
    'web-app-firewall.configurationSection' => 'Configuració',
    'web-app-firewall.configurationSectionHint' => 'Configuri el firewall per aplicacions web utilitzant un conjunt predefinit de paràmetres o bé les seves directives personalitzades de ModSecurity.',
    'web-app-firewall.configPreset' => 'Conjunt de valors predefinits',
    'web-app-firewall.configPresetFast' => 'Ràpid',
    'web-app-firewall.configPresetFastDescription' => 'S\'analitzaran les parts de les capçaleres i l\'URI de la petició HTTP.',
    'web-app-firewall.configPresetTradeOff' => 'Equilibrat',
    'web-app-firewall.configPresetTradeOffDescription' => 'S\'analitzaran les capçaleres, l\'URI de la petició HTTP i les dades POST de la petició.',
    'web-app-firewall.configPresetThrough' => 'Exhaustiu',
    'web-app-firewall.configPresetThroughDescription' => 'S\'analitzaran les capçaleres completes de la petició HTTP, les dades POST de la petició i el contingut del cos de la resposta HTTP.',
    'web-app-firewall.configCustom' => 'Directives personalitzades',
    'web-app-firewall.configCustomDescription' => "Introdueixi aquí una directiva de ModSecurity. Aquesta substituirà les directives especificades anteriorment (conjunt de regles, regles específiques, el conjunt de valors predefinits, etc).\nPer exemple: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'La configuració de ModSecurity no és vàlida: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'No ha estat possible utilitzar l\'arxiu de configuració actual de ModSecurity ni revertir a la versió anterior de l\'arxiu perquè presenten una configuració que no és vàlida.',
    'web-app-firewall.rulesSection' => 'Desactivar regles de seguretat',
    'web-app-firewall.rulesSectionHint' => 'Aquí pot desactivar regles de seguretat, el que resulta útil si troba que una regla de seguretat és massa restrictiva per alguns llocs web. Si desitja desactivar regles de seguretat, indiqui les seves IDs (per exemple, 340003 o 340005-340007), etiquetes (per exemple, CVE-2011-4898) o expressions regulars utilitzades en missatges de regla (per exemple, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Aquí pot desactivar regles de seguretat, el que resulta útil si troba que una regla de seguretat és massa restrictiva per alguns llocs web. Si desitja desactivar regles de seguretat, indiqui les seves IDs (per exemple, 340003 o 340005-340007), etiquetes (per exemple, CVE-2011-4898) o missatges de regla (per exemple, Found User-Agent associat amb l\'analitzador de seguretat).',
    'web-app-firewall.filterById' => 'IDs de regles de seguretat',
    'web-app-firewall.filterByIdInvalid' => 'Els següents valors no són vàlids: %%values%%. L\'ID de la regla ha d\'estar format per dígits o un interval de dígits com 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Els següents intervals no són vàlids: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Etiquetes',
    'web-app-firewall.filterByTagActive' => 'Actives:',
    'web-app-firewall.filterByTagDeactivated' => 'Desactivades:',
    'web-app-firewall.filterByTagInvalid' => 'Els següents valors seleccionats no són vàlids: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Expressions regulars en missatges de regla',
    'web-app-firewall.filterByRegexpInvalid' => 'Els següents valors no són vàlids: %%values%%. No haurien d\'incloure caràcters \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Missatges de regla',
    'web-app-firewall.filterByRegexpNginxHint' => 'Només es suporten coincidències estrictes.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Els següents valors no són vàlids: %%values%%. El missatge de regla ha d\'estar format per lletres, dígits, espais o caràcters -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Registre d\'auditoria de ModSecurity',
    'web-app-firewall.auditLogHint1' => 'L\'arxiu de registre d\'auditoria de ModSecurity és la informació més útil al sistema. Quan ModSecurity detecta que es produeix qualsevol event, aquest genera una entrada a l\'arxiu de registre d\'auditoria.',
    'web-app-firewall.auditLogHint2' => 'Un cop canviat el mode del firewall per a aplicacions web de desactivat a activat o només detecció, pot ser que un lloc web deixi de funcionar com s\'esperava. En aquest cas, examini el registre d\'auditoria de ModSecurity per descobrir què està passant. També pot desactivar aquelles regles de seguretat que siguin massa restrictives o bé ajustar el lloc web.',
    'web-app-firewall.auditLogHint3' => 'Si desitja descobrir per què una petició HTTP no pot completar-se per un lloc web:',
    'web-app-firewall.auditLogPoint1' => 'Faci clic a l\'enllaç Arxiu de registre de ModSecurity que es mostra a continuació per obrir el registre d\'auditoria en una nova finestra del navegador.',
    'web-app-firewall.auditLogPoint2' => 'Utilitzi la combinació de tecles de cerca (Ctrl+F a la majoria de navegadors web) per a trobar events pel lloc web (el nom de domini) que experimenta els problemes. Per exemple, your_domain.tld. El navegador destacarà entrades com HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'A les tres línies anteriors a l\'entrada destacada, busqui una cadena de text com --eece5138-B--. Els vuit símbols entre guionets (al nostre exemple eece5138) són l\'ID de l\'event desencadenat per la petició HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Busqui altres entrades amb el mateix ID d\'event. Busqui una entrada amb la lletra H després de l\'ID de l\'event (al nostre exemple eece5138-H--). Aquesta entrada conté l\'ID i la descripció de la regla de seguretat desencadenada mentre es verificava la petició HTTP. L\'ID de la regla de seguretat és un número enter que comença per 3, entre cometes i amb el prefix de l\'ID entre claudàtors. Per exemple, [id "340003"].',
    'web-app-firewall.auditLogPoint5' => 'Busqui l\'ID d\'una regla de seguretat mitjançant una subcadena [id "3.',
    'web-app-firewall.auditLogPoint6' => 'Desactivi la regla de seguretat amb aquest ID a la secció Regles de seguretat que es mostra a continuació. Introdueixi l\'ID de la regla de seguretat (només els dígits) al camp IDs de regles de seguretat i faci clic a ACCEPTAR.',
    'web-app-firewall.auditLogViewLink' => 'Arxiu de registre de ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Arxiu comprimit de registres',
    'web-app-firewall.errorLogSection' => 'Registre d\'errors',
    'web-app-firewall.errorLogSectionHint' => 'Un cop canviat el mode del firewall per a aplicacions web de desactivat a activat o només detecció, pot ser que un lloc web deixi de funcionar com s\'esperava. En aquest cas, examini el registre d\'errors per descobrir què està passant. També pot desactivar aquelles regles de seguretat que siguin massa restrictives o bé ajustar el lloc web.',
    'web-app-firewall.errorLogViewLink' => 'Arxiu de registre d\'errors',
    'web-app-firewall.notificationStateEnabled' => 'Les notificacions a l\'IU de Plesk sobre actualitzacions de conjunts de regles es troben activades. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Les notificacions a l\'IU de Plesk sobre actualitzacions de conjunts de regles es troben desactivades. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Administrar-les a la pàgina de notificacions',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'La selecció de les opcions "Equilibrat" o "Exhaustiu" pot ocasionar un mal funcionament dels llocs WordPress, entre d\'altres efectes col·laterals no desitjats, a causa de la següent <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">incidència de ModSecurity</a>.',
];