<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Propiedades de la llave adicional',
    'additional-key-info.update' => 'Recuperar llave adicional',
    'additional-key-info.updateDescription' => 'Recupere la llave adicional e instálela.',
    'additional-key-info.download' => 'Descargar llave',
    'additional-key-info.downloadDescription' => 'Descargar la llave de licencia actual.',
    'additional-key-info.install' => 'Instalar llave',
    'additional-key-info.installDescription' => 'Instale la llave de licencia actual.',
    'additional-key-info.revert' => 'Revertir llave',
    'additional-key-info.revertDescription' => 'Revierta a la llave de licencia instalada anteriormente.',
    'additional-key-info.revertNotAvailableDescription' => 'Ninguna llave instalada.',
    'additional-key-info.installSuccess' => 'Instalación de la llave de licencia iniciada.',

    'additional-key-revert.title' => 'Reversión de llave adicional',
    'additional-key-revert.success' => 'La llave adicional ha sido revertida.',

    'additional-key-upload.title' => 'Instalar una llave de licencia',
    'additional-key-upload.success' => 'La llave nueva adicional ha sido cargada.',

    'additional-keys.title' => 'Llaves de licencia adicionales',

    'change-owner.title' => 'Reasignando las suscripciones seleccionadas',

    'customers.hint' => 'Aquí puede administrar las cuentas de los clientes de su servicio de hosting: crear cuentas junto con suscripciones de servicio, gestionar los clientes existentes y eliminar cuentas. Para administrar sitios web, correo o cualquier otro servicio proporcionado a un cliente, vaya a su panel del cliente haciendo clic en el enlace que aparece en la columna derecha de la lista.',

    'customer-domains.hint' => 'Aquí puede crear y administrar sitios web.',

    'customer-subscriptions.hint' => 'Aquí es donde usted puede administrar las suscripciones del cliente.',

    'domains.hint' => 'Aquí puede ver la información de todos los nombres de dominio registrados en el sistema, así como gestionar los servicios de hosting Si desea añadir un dominio para usted o para sus clientes de hosting, haga clic en Añadir dominio. Se le preguntará si desea crear un cliente o una suscripción nueva durante la creación del dominio o bien si desea seleccionar un cliente o una suscripción ya existente.',

    'database-servers.title' => 'Servidores de bases de datos',

    'database-server-create.title' => 'Servidor de bases de datos nuevo',

    'database-server-properties.title' => 'Servidor de bases de datos',

    'database-server-upgrade.title' => 'Actualización del servidor de base de datos',
    'database-server-upgrade.currentVersion' => 'Versión actual',
    'database-server-upgrade.selectVersion' => 'Seleccionar versión',
    'database-server-upgrade.information' => 'Información',
    'database-server-upgrade.releaseNotes' => 'Notas de la versión',
    'database-server-upgrade.releaseDate' => 'Fecha de la versión',
    'database-server-upgrade.unable' => 'No pudo actualizarse',
    'database-server-upgrade.endOfLifeDate' => 'Fecha EOL',
    'database-server-upgrade.description' => 'MySQL/MariaDB es un sistema relacional de gestión de bases de datos ampliamente usado a la par que un servicio principal en la mayoría de sistemas Plesk. Esta interfaz le permite actualizar su servidor MySQL/MariaDB a una versión 10.6. Plesk actualizará automáticamente su instalación de MySQL/MariaDB a versiones relacionales más nuevas (el tercer dígito en la cadena de versión), puesto que estas actualizaciones implican poco riesgo sobre los datos de sus usuarios. Las actualizaciones a nuevas versiones principales (los primeros dos dígitos en la cadena de versión) implican un riesgo substancial de pérdida de datos. Esta interfaz le guiará por el proceso de actualización de versión principal.',
    'database-server-upgrade.warning' => 'Si bien las actualizaciones insitu suelen ser seguras, le recomendamos encarecidamente crear un backup completo de la base de datos antes de iniciar la actualización. No se soportan las degradaciones a versiones anteriores. Es posible que no pueda llevarse a cabo la reversión a una versión anterior tras la actualización del servidor de base de datos. El reemplazo de MariaDB por MySQL 8 se considera una degradación, motivo por el cual no se soporta.',

    'database-server-databases.title' => 'Bases de datos',

    'database-server-change-password.title' => 'Contraseña del administrador',

    'home.title' => 'Inicio',

    'license.title' => 'Información de la licencia',

    'primary-key-info.title' => 'Llave de licencia de Plesk',
    'primary-key-info.update' => 'Recuperar llaves',
    'primary-key-info.updateDescription' => 'Recupere e instale las llaves de licencia compradas.',
    'primary-key-info.upload' => 'Instalar llave',
    'primary-key-info.uploadDescription' => 'Cargue e instale una llave de licencia nueva.',
    'primary-key-info.revert' => 'Revertir llave',
    'primary-key-info.revertDescription' => 'Revierta a la llave de licencia instalada anteriormente.',

    'primary-key-revert.title' => 'Reversión de la llave de licencia',
    'primary-key-revert.success' => 'La llave de Plesk ha sido revertida.',

    'primary-key-upload.title' => 'Instalar una llave de licencia',
    'primary-key-upload.success' => 'La nueva llave de Plesk ha sido cargada.',

    'resellers.hint' => 'Aquí puede administrar cuentas de revendedores — aquellos de sus clientes que revenden servicios de hosting y que alojan sus propios sitios web. Aquí también puede crear cuentas junto con suscripciones de servicio, gestionar los revendedores existentes y eliminar cuentas.',

    'reseller-customers.hint' => 'Desde aquí puede configurar y administrar las cuentas de sus clientes.',

    'reseller-domains.hint' => 'Aquí puede crear y administrar sitios web.',

    'reseller-subscriptions.hint' => 'Aquí es donde gestiona las suscripciones del revendedor.',

    'subscriptions.hint' => 'Los clientes obtienen los servicios de hosting ofrecidos por usted suscribiéndose a un plan de hosting. Aquí puede administrar estas suscripciones así como sus propias suscripciones, que usted crea para alojar sus sitios web. Si desea administrar sitios web, servicios de mensajería o cualquier otro servicio proporcionado con una suscripción, vaya al panel del cliente del suscriptor haciendo clic en la columna a la derecha de la lista.',

    'server-mail-settings.title' => 'Configuración',
    'server-mail-spam-filter.title' => 'Filtración de spam',
    'server-mail-antivirus.title' => 'Antivirus',
    'server-mail-black-list.title' => 'Lista negra',
    'server-mail-white-list.title' => 'Lista blanca',
    'server-mail-queue.title' => 'Cola de correo',
    'server-mail-statistics.title' => 'Estadísticas',

    'firewall.title' => 'Administración del firewall',
    'firewall-general.title' => 'General',
    'firewall-general.toggleStatus' => 'Protección con firewall',
    'firewall-general.buttonDefault' => 'Restablecer a predeterminado',
    'firewall-general.buttonPanic' => 'Modo pánico',
    'firewall-general.confirmationDefault' => '¿Está seguro de que desea restablecer la configuración predeterminada del firewall?',
    'firewall-general.confirmationPanic' => '¿Está seguro de que desea activar el modo pánico? Los usuarios no podrán acceder a sus dominios y es posible que algunos servicios de red dejen de funcionar.',
    'firewall-general.successDefault' => 'La configuración de firewall se ha restablecido a los valores predeterminados.',
    'firewall-general.successPanic' => 'El modo pánico ha sido activado.',
    'firewall-general.info' => 'Por motivos de seguridad, el firewall bloquea todas las conexiones excepto las explícitamente permitidas. Puede permitir una conexión creando una regla. Si desea más información, consulte la documentación',
    'firewall-general.interfaces' => 'Interfaces de red',
    'firewall-icmp.title' => 'Protocolo ICMP',
    'firewall-rules.title' => 'Reglas del firewall',

    'dns.title' => 'Configuración DNS',
    'dns-records.title' => 'Plantilla de registros de zona',
    'dns-soa-record.title' => 'Plantilla de configuración de zona',

    'php-handler.title' => 'Configuración para %%name%%',
    'php-handler.extensions.title' => 'Extensiones',
    'php-handler.extensions.description' => 'La configuración de estas extensiones PHP es únicamente aplicable a este controlador.',
    'php-handler.extensions.descriptionShared' => 'Esta configuración es aplicable a los siguientes controladores PHP: %%handlers%%. La configuración se aplica a todos aquellos sitios web que utilicen estos controladores.',
    'php-handler.extensions.buttonManage' => 'Administrar paquetes PECL',
    'php-handler.extensions.manage.title' => 'Administrar paquetes PECL',
    'php-handler.extensions.manage.risks' => 'Las extensiones PHP son proporcionadas por paquetes PECL de terceros. Instálelas bajo su propia cuenta y riesgo.',
    'php-handler.extensions.manage.description' => 'Instale, actualice y desinstale paquetes PECL. Los cambios se aplicarán a todos los sitios web que se ejecuten en %%handlers%%.',
    'php-handler.extensions.manage.notFound' => '¿Por qué el paquete deseado no aparece en la lista?',
    'php-handler.extensions.manage.limitations' => 'Las extensiones PHP proporcionadas por el proveedor del panel de control y los proveedores del SO no se muestran en la lista.',
    'php-handler.php-ini.title' => 'php.ini',

    'ServerAbout.copyright' => '© 2023 Plesk International GmbH. Todos los derechos reservados.',
    'ServerAbout.linkLicenseManagement' => 'Ir a la información de la licencia',
    'ServerAbout.panelVersion' => 'Versión',
    'ServerAbout.installedPatchVersion' => 'Actualización #%%patch%%',
    'ServerAbout.licenseKey' => 'Llave de licencia',
    'ServerAbout.productDescription' => 'Plesk es la plataforma líder que permite a los WebOps ejecutar, automatizar y escalar aplicaciones, sitios web y negocios de hosting.',
    'ServerAbout.readEula' => 'Lea %%link%%.',
    'ServerAbout.linkEula' => 'Contrato de licencia del usuario final',
    'ServerAbout.visitForum' => 'Visite %%link%%',
    'ServerAbout.linkForum' => 'Foro de Plesk',
    'ServerAbout.followUs' => 'Síganos',
    'ServerAbout.visitSite' => 'Obtenga más información en %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Inspírese en %%link%%',
    'ServerAbout.linkBlog' => 'Blog de Plesk',

    'ServerAbout.darkThemePromoTitle' => '¡Felicidades!',
    'ServerAbout.darkThemePromoDescription' => 'Ha encontrado un gatito mágico añadido durante el aniversario de Plesk Obsidian 18.0.50.',
    'ServerAbout.darkThemePromoButton' => '¡Hala! Venga al lado oscuro',
    'ServerAbout.darkThemeTourDescription' => 'Cambie a esta opción para activar o desactivar el tema oscuro para su interfaz.',
    'ServerAbout.darkThemeTourButton' => 'Entendido',

    'ts-sessions.title' => 'Sesiones de servidor de terminales',
    'ts-sessions-properties.title' => 'Propiedades de sesión',

    'BandwidthLimiting.title' => 'Limitación de ancho de banda para %%domainName%%',
    'BandwidthLimiting.bandwidthThrottling' => 'No puede controlar la limitación de ancho de banda porque QoS no está instalado.',
    'BandwidthLimiting.virtualHostingRequired' => 'La limitación de ancho de banda solo está disponible para dominios con hosting web.',
    'BandwidthLimiting.bandwidthLabel' => 'Uso máximo de ancho de banda',
    'BandwidthLimiting.bandwidthHint' => 'El límite de uso de ancho de banda solo se aplica a datos transferidos mediante el protocolo HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Conexiones limitadas a',
    'BandwidthLimiting.maxConnectionHint' => 'Si limita el ancho de banda, le recomendamos que también limite el número de conexiones simultáneas al sitio web. De lo contrario, en caso de experimentar peticiones frecuentes al sitio web, los procesos del servidor web aumentarán la carga del servidor.',
    'BandwidthLimiting.kbps' => 'KB/s',
    'BandwidthLimiting.success' => 'La configuración de limitación de ancho de banda ha sido modificada.',
    'BandwidthLimiting.unlimited' => 'Ilimitada',

    'ip-address-domains.title' => 'Sitios web que usan la dirección IP %%ipAddress%% %%type%%',
    'ip-address-domains.site' => 'Sitio',
    'ip-address-domains.setAsDefault' => 'Predeterminado',
    'ip-address-domains.type-SHARED' => 'compartida',
    'ip-address-domains.type-EXCLUSIVE' => 'dedicada',

    'HotlinkProtection.title' => 'Protección hotlink para %%domainName%%',
    'HotlinkProtection.virtualHostingRequired' => 'La protección hotlink solo está disponible para dominios con hosting web.',
    'HotlinkProtection.enabledLabel' => 'Activar protección hotlink',
    'HotlinkProtection.extensionsLabel' => 'Extensiones de archivos protegidas',
    'HotlinkProtection.friendsLabel' => 'Direcciones de sitios web conocidos',
    'HotlinkProtection.success' => 'La configuración de protección hotlink ha sido actualizada.',

    'Odbc.serverTitle' => 'Conexiones ODBC DSN',
    'Odbc.domainTitle' => 'Conexiones ODBC DSN para %%domainName%%',
    'Odbc.add' => 'Añadir DSN ODBC',
    'Odbc.resourceUsage' => '%%used%% creados / %%allowed%% permitidos.',
    'Odbc.limitExceeded' => 'Se ha excedido el límite de la conexión DSN ODBC.',
    'Odbc.unlimited' => 'Ilimitado',
    'Odbc.addTooltip' => 'Añada un origen de datos ODBC.',
    'Odbc.status' => 'Estado',
    'Odbc.name' => 'Nombre de la conexión',
    'Odbc.driver' => 'Controlador',
    'Odbc.description' => 'Descripción de la conexión',
    'Odbc.hostname' => 'Nombre de host',
    'Odbc.statusSystem' => 'Es un DSN de sistema.',
    'Odbc.statusConfigured' => 'DSN configurado.',
    'Odbc.statusNotConfigured' => 'DSN no configurado.',
    'Odbc.noSelectionText' => 'Seleccione uno o más elementos a eliminar.',
    'Odbc.removeConfirmation' => '¿Desea eliminar {count, plural, one {}=1 {la conexión {name}} other {las # conexiones seleccionadas}}?',
    'Odbc.removeSuccess' => 'Las conexiones seleccionadas han sido eliminadas.',

    'DomainAliasSettings.title' => 'Configuración de alias de dominio',
    'DomainAliasSettings.updateSuccess' => 'Las propiedades del alias de dominio %%name%% han sido modificadas. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'La configuración del sitio web se aplicará en %%restartInterval%% minutos.',

    'HostingSettings.title' => 'Configuración de hosting',
    'HostingSettings.updateSuccess' => 'La configuración ha sido actualizada.',
    'HostingSettings.emptyLogin' => 'Debe especificar un nombre de usuario.',
    'HostingSettings.emptyPassword' => 'Debe especificar una contraseña.',
    'HostingSettings.ipV6OnlyNotSupported' => 'El servidor FTP no soporta IPv6. Asigne al menos una dirección IPv4, ya que de lo contrario el usuario no podrá cargar archivos al servidor vía FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Configuración del dominio',
    'HostingSettings.domainSettingsSection.domainName' => 'Nombre de dominio',
    'HostingSettings.domainSettingsSection.description' => 'Por ejemplo, example.com ',

    'HostingSettings.submitPopover.title' => 'Eliminar el contenido de %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'De cambiar el tipo de hosting "Sitio web" a "%%type%%", el contenido de todo el sitio web será eliminado de forma permanente, incluyendo los siguientes directorios:',
    'HostingSettings.submitPopover.descriptionSubDomain' => '¿Desea cambiar el tipo de hosting para su sitio web?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Para acceder a más opciones de configuración, indique las credenciales del usuario del sistema y haga clic en "Crear espacio web".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Para acceder a más opciones de configuración, haga clic en "Siguiente" para crear hosting.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Tipo de hosting',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Tipo',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Sitio web',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Redireccionamiento',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Sin hosting web',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Use la zona DNS del dominio para tener buzones de correo bajo este nombre de dominio',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'La ruta al directorio principal del sitio web',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Dominio preferido',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Los visitantes serán redireccionados aquí mediante un redireccionamiento HTTP 301 respetuoso con el SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Reenviar visitantes a',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Tipo de redireccionamiento',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Movido permanentemente (código 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Redireccione los visitantes del sitio web a otro sitio y muéstreles la dirección de destino. Dicho redireccionamiento no alterará en modo alguno al ranking de búsqueda del sitio',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Movido temporalmente (código 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Redireccione los visitantes del sitio web a una copia temporal del sitio cuando no desee que los buscadores indicen este sitio temporal.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Redireccionamiento por marcos',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Redireccione los visitantes del sitio web a otro sitio, pero no mostrarles la dirección de destino, por lo que estos no serán conscientes de esta redirección.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Dominio preferido',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Ninguno',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Raíz del documento',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'No se puede cambiar la raíz de documento porque en este sitio se han instalado aplicaciones web.',
    'HostingSettings.domainSettingsSection.save' => 'Guardar',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => '¿Cambiar esta opción?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'El cambio de esta opción contradice la directiva de seguridad del servidor y puede impactar negativamente en el rendimiento o exponer el servidor a ataques.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Cambiar',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Revertir',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Se aplica la configuración de seguridad predeterminada',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Si desea una mejor seguridad, aplique la configuración de seguridad predeterminada. Tenga en cuenta que algunos permisos permiten a los suscriptores modificar estas opciones.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Aplicar configuración segura',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Más información acerca de la configuración de hosting segura',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Soporte para SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Activado',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Cifre las conexiones entre el sitio web y el navegador del visitante.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Certificado',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Para activar HTTPS, cargue un certificado SSL/TLS al repositorio del dominio y selecciónelo aquí.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Redireccionar los visitantes de HTTP a HTTPS mediante un redireccionamiento 301 respetuoso con el SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'En su repositorio no dispone de ningún certificado SSL/TLS. Si desea añadir un certificado, visite %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'esta página',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (otro repositorio)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'No seleccionado',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Scripting web',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Seleccione los lenguajes de scripting y programación que debe interpretar el servidor web.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'el directorio cgi-bin se encuentra en %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Usar SSI para archivos *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Versión de Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Documentos de error personalizados',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'el directorio cgi-bin se encuentra en',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'la raíz de documento de este dominio',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'el directorio raíz de espacio web',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'la raíz de este dominio en el estilo anterior',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Documentos de error personalizados',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Permisos adicionales de escritura/modificación',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Publicación de despliegue web',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Estadísticas web',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Herramienta',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Proteger el acceso a sus estadísticas web con sus credenciales FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Desactivado',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Configuración del espacio web',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'Direcciones IP',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Cuota de espacio en disco',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Activado',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Prohíba operaciones sobre los archivos del sitio web en caso de que se exceda la cuota de espacio en disco definida en la configuración de la suscripción (de estarlo).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'No se soporta la cuota de disco duro debido a la configuración del sistema de archivos del servidor.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'MB',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% MB',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Credenciales del usuario del sistema',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Gestione carpetas y archivos del sitio web mediante FTP o el administrador de archivos. Acceda al servidor mediante SSH, de permitirse.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Gestione carpetas y archivos del sitio web mediante FTP o el administrador de archivos. Acceda al servidor mediante Escritorio Remoto, de permitirse.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Nombre de usuario',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Contraseña',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Indique aquí una contraseña nueva para cambiar la contraseña del usuario del sistema.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Acceso SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Acceso a Escritorio remoto',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Activado',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Acceda al servidor con las credenciales del usuario del sistema.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Tipo',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Desactivado',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Para {count, plural, one {}other {# dominios}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Las siguientes opciones son mutuas para {count, plural, one {}other {todos los # dominios en el espacio web {name}}}:',

    'OdbcAdd.title' => 'Añadir un DSN ODBC',
    'OdbcAdd.nameLabel' => 'Nombre de la conexión',
    'OdbcAdd.descriptionLabel' => 'Descripción de la conexión',
    'OdbcAdd.driver' => 'Controlador',
    'OdbcAdd.submit' => 'Crear DSN ODBC',

    'OdbcEdit.title' => 'Configuración de una conexión ODBC',
    'OdbcEdit.saveSuccess' => 'La configuración de conexión ha sido guardada.',
    'OdbcEdit.test' => 'Comprobar la conexión',
    'OdbcEdit.connectSuccess' => 'Conexión correcta.',

    'OdbcEdit.excel.driver.label' => 'Controlador',
    'OdbcEdit.excel.dbq.label' => 'Ruta al archivo de base de datos',
    'OdbcEdit.excel.defaultdir.label' => 'Directorio de datos predeterminado',
    'OdbcEdit.excel.fil.label' => 'Versión de base de datos',
    'OdbcEdit.excel.maxbuffersize.label' => 'Tamaño máximo de búfer',
    'OdbcEdit.excel.pagetimeout.label' => 'Tiempo de espera de la página',

    'OdbcEdit.access.driver.label' => 'Controlador',
    'OdbcEdit.access.dbq.label' => 'Ruta al archivo de base de datos',
    'OdbcEdit.access.uid.label' => 'ID de acceso',
    'OdbcEdit.access.pwd.label' => 'Contraseña',
    'OdbcEdit.access.pagetimeout.label' => 'Tiempo de espera de la página',
    'OdbcEdit.access.pagetimeout.description' => 'El periodo de tiempo, en decenas de segundos, que una página no usada se mantiene en un búfer. Esta opción se aplica a todos los orígenes de datos que usen el controlador Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Tamaño máximo de búfer',
    'OdbcEdit.access.maxbuffersize.description' => 'El tamaño del búfer interno, en KB, alineado en bloques de 256 KB.',
    'OdbcEdit.access.readonly.label' => 'Solo lectura',
    'OdbcEdit.access.readonly.description' => 'Designa la base de datos como solo-lectura para prohibir cualquier actualización.',
    'OdbcEdit.access.exclusive.label' => 'Exclusiva',
    'OdbcEdit.access.exclusive.description' => 'Designa la base de datos como exclusiva para prohibir actualizaciones compartidas.',
    'OdbcEdit.access.safetransactions.label' => 'Transacciones seguras',
    'OdbcEdit.access.safetransactions.description' => 'De ser 0 (la opción predeterminada), todas las transacciones se aplican de inmediato. De ser 1, todas las transacciones se guardan al disco una vez finalizada la operación, pero tenga en cuenta que el rendimiento se degrada ligeramente.',
    'OdbcEdit.access.threads.label' => 'Hilos',
    'OdbcEdit.access.threads.description' => 'El número de subprocesos en segundo plano que usará el motor.',
    'OdbcEdit.access.maxscanrows.label' => 'Nº máximo de filas a analizar',
    'OdbcEdit.access.maxscanrows.description' => 'El número de filas a analizar cuando se define el tipo de datos de una columna basándose en los datos existentes.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Especifica cuántos cambios efectuados fuera de una transacción se escriben en la base de datos.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Especifica si el controlador de MS Access realizará transacciones explícitas definidas por el usuario de forma asincrónica.',

    'OdbcEdit.mssql.driver.label' => 'Controlador',
    'OdbcEdit.mssql.server.label' => 'Servidor',
    'OdbcEdit.mssql.uid.label' => 'ID de acceso',
    'OdbcEdit.mssql.pwd.label' => 'Contraseña',
    'OdbcEdit.mssql.database.label' => 'Base de datos predeterminada',
    'OdbcEdit.mssql.app.label' => 'Nombre de la aplicación',
    'OdbcEdit.mssql.wsid.label' => 'ID de Workstation',
    'OdbcEdit.mssql.language.label' => 'Idioma predeterminado',
    'OdbcEdit.mssql.oemtoansi.label' => 'Conversión de caracteres extendidos a valores OEM',

    'OdbcEdit.mysql.driver.label' => 'Controlador ODBC de MySQL',
    'OdbcEdit.mysql.server.label' => 'Servidor',
    'OdbcEdit.mysql.server.description' => 'El nombre de host del servidor MySQL',
    'OdbcEdit.mysql.database.label' => 'Base de datos predeterminada',
    'OdbcEdit.mysql.user.label' => 'Nombre de usuario',
    'OdbcEdit.mysql.user.description' => 'El nombre de usuario usado para conectarse a MySQL',
    'OdbcEdit.mysql.password.label' => 'Contraseña',
    'OdbcEdit.mysql.password.description' => 'La contraseña para la cuenta de usuario en el servidor',
    'OdbcEdit.mysql.port.label' => 'Puerto',
    'OdbcEdit.mysql.port.description' => 'El puerto TCP/IP a usar si el servidor no es el host local',
    'OdbcEdit.mysql.socket.label' => 'Socket',
    'OdbcEdit.mysql.socket.description' => 'Canalización con nombre de a conectar si el servidor es el host local',
    'OdbcEdit.mysql.option.label' => 'Opción',
    'OdbcEdit.mysql.option.description' => 'Opciones que especifican cómo debe funcionar MyODBC. Examine la <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">documentación</a>',

    'ProtectedDirectoryList.title' => 'Directorios protegidos de %%domainName%%',
    'ProtectedDirectoryList.add' => 'Añadir directorio protegido',
    'ProtectedDirectoryList.addTooltip' => 'Cree un directorio protegido.',
    'ProtectedDirectoryList.name' => 'Nombre',
    'ProtectedDirectoryList.realmTitle' => 'Nombre del área protegida',
    'ProtectedDirectoryList.noSelectionText' => 'Seleccione uno o más elementos a eliminar.',
    'ProtectedDirectoryList.edit' => 'Editar',
    'ProtectedDirectoryList.remove' => 'Eliminar protección',
    'ProtectedDirectoryList.removeTooltip' => 'Elimine la protección de los directorios seleccionados.',
    'ProtectedDirectoryList.removeConfirmation' => 'Como resultado de esta operación, se eliminará la protección {count, plural, one {}=1 {del directorio {name}} other {de los # directorios seleccionados}}. {count, plural, one {}=1 {Los usuarios de Internet podrán acceder a este directorio} other {Los usuarios de Internet podrán acceder a estos directorios}}.',
    'ProtectedDirectoryList.removeSuccess' => 'Los directorios seleccionados han sido eliminados.',

    'ProtectedDirectoryAdd.title' => 'Crear directorio protegido',
    'ProtectedDirectoryAdd.submit' => 'Crear',
    'ProtectedDirectoryAdd.success' => 'El directorio protegido %%path%% se creó correctamente',

    'ProtectedDirectoryEdit.title' => 'Configuración de directorio protegido',
    'ProtectedDirectoryEdit.success' => 'Se cambió la configuración del directorio protegido',

    'SummaryReport.Layout.title' => 'Propiedades del diseño de informe',
    'SummaryReport.Layout.success' => 'El diseño de informe %%name%% ha sido actualizado.',

    'SummaryReport.Layout.Add.title' => 'Crear diseño de informe',
    'SummaryReport.Layout.Add.success' => 'El diseño de informe %%name%% ha sido creado.',
];