<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Přístup odepřen. Váš účet byl pozastaven.",
    'login_up__login_has_been_locked' => "Učinili jste příliš mnoho pokusů o přihlášení pomocí nesprávného hesla. Z bezpečnostních důvodů se po nějakou dobu nebudete moci přihlásit pod tímto přihlašovacím jménem.",
    'login_up__unable_to_check_pass' => "Nelze zkontrolovat heslo: %1",
    'login_up__warning_limits_licence_key' => "Jedna z následujících položek překročila limit definovaný vaším licenčním klíčem: počet uživatelských účtů, domén, e-mailových účtů nebo uživatelů webu hostovaných na serveru.\nChcete-li zakoupit klíč, který vám umožní hostit požadovaný počet uživatelů a domén, kontaktujte obchodní oddělení Plesk. Pokud máte dojem, že jste tuto zprávu obdrželi omylem, kontaktujte technickou podporu Plesk.\nLimit daný licencí pro uživatelské účty/domény/e-mailové účty/uživatele webu/jazykové sady. %2.\nPočet momentálně hostovaných uživatelských účtů/domén/e-mailových účtů/uživatelů webu/jazykových sad: %3", // PFW
    'login_up__short_warning_limits_licence_key' => "Počet prostředků, s nimiž pracujete, překročil omezení určené vaší licencí k produktu. Kontaktujte obchodní oddělení společnosti Plesk a zakupte si nový licenční klíč.",
    'login_up__grace_period' => 'Právě pracujete v rámci bezplatného období vaší licence na produkt. Chcete-li svou licenci na produkt aktualizovat, na stránce %1Informace o licencích%2 vyberte možnost Získat klíče.',
    'login_up__partner_license_message' => 'Právě pracujete s omezenou licencí produktu, která před aktivací plně funkční verze vyžaduje registraci. Chcete-li svou licenci na produkt aktualizovat, na stránce %1Informace o licencích%2 vyberte možnost Získat klíče.',
    'login_up__system_admin_disabled' => 'Superuživatel (root nebo účet správce) má zákaz přihlášení do prostředí Plesk z bezpečnostních důvodů.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Příručka pro správce prostředí Plesk",
    'plesk_guide_reseller' => "Příručka prodejce Plesk",
    'plesk_guide_client' => "Příručka pro zákazníky Plesk",
    'plesk_guide_domain_admin' => "Příručka pro správce domény prostředí Plesk",
    'plesk_guide_mailuser' => "Příručka pro uživatele e-mailu prostředí Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Hledat', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Zákazníci',
    'ui__reseller_unknown__quick-search' => 'Distributoři',
    'ui__client/domain_unknown__quick-search' => 'Domény',
    'nav__general' => 'Hlavní nabídka',
    '__home' => 'Domů',
    '__resellers' => 'Distributoři',
    '__clients' => 'Zákazníci',
    '__domains' => 'Domény',
    '__applications' => 'Aplikace',
    '__settings' => 'Nastavení',
    'nav__system' => 'Systém',
    '__master' => 'Hlavní',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Horní úroveň',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Odebrat',
    'bt_make_default' => 'Nastavit jako výchozí',

    // common list object operation errors
    'class_cList__empty_selection' => 'Nejsou vybrány žádné objekty.',

    // common list object search keys
    'clist__search_show' => 'Zobrazit hledání',
    'clist__search_hide' => 'Skrýt hledání',

    'bt_show_all' => "Resetovat hledání",

    // common object list info keys
    'clist__first' => 'První',
    'clist__last' => 'Poslední',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Stránky',
    'clist__page_size' => 'Položek na stránku',
    'clist__info' => 'Celkem %1: %4',
    'clist__info_empty' => 'Č %1',
    'clist__info_filter' => 'Nalezeno %5 %1 (celkem %4)',
    'clist__info_paging' => '%2-%3 %1 z celkem %4',
    'clist__info_paging_filter' => 'Nalezeno %2-%3 %1 z %5 (celkem %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktivní',
    '__object_off' => 'Pozastaveno',

    '__home_description' => 'Zpět na domovskou stránku.',
    'indicator_title' => '%1% použito, %2% volné', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Byla vyžádána neplatná adresa URL.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Účty prodejce",
    'ui__reseller_unknown__title' => "Účty prodejce",
    'ui__reseller_unknown__description' => "Spravovat účty prodejce.",
    'ui__reseller/client_unknown__short-title' => 'Zákaznické účty',
    'ui__reseller/client_unknown__title' => 'Zákaznické účty',
    'ui__reseller/client_unknown__description' => 'Spravovat zákaznické účty.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Další účty správce", // PFW
    'ui__admin-alias_unknown__short-title' => "Další účty správce", // PFW
    'ui__admin-alias_unknown__description' => "Zobrazit a spravovat další účty správce.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Nastavení pošty pro celý server",
    'ui__server/mail__title' => "Nastavení pošty pro celý server",
    'ui__server/mail__description' => "Nastavte svůj poštovní server a nakonfigurujte nastavení pošty pro celý server.",
    'ui__server/dns__short-title' => 'Nastavení DNS',
    'ui__server/dns__title' => 'Nastavení DNS',
    'ui__server/dns__description' => 'Zkontrolovat a aktualizovat nastavení DNS na celém serveru.',
    'ui__server/services__title' => 'Správa služeb',
    'ui__server/services__description' => 'Spuštění, zastavení nebo restart služeb prostředí Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Naplánované úlohy',
    'ui__server/crontab/task_unknown__title' => 'Naplánované úlohy',
    'ui__server/crontab/task_unknown__description' => 'Přidat a odebrat naplánované úlohy pro celý server.',
    'ui__server/ip-address_unknown__short-title' => 'IP adresy',
    'ui__server/ip-address_unknown__title' => 'IP adresy',
    'ui__server/ip-address_unknown__description' => 'Zobrazit, přidat a odebrat IP adresy, přiřadit IP adresy prodejcům.',
    // dropdowns
    'ui__server/time__title' => 'Systémový čas',
    'ui__server/time__short-title' => 'Systémový čas',
    'ui__server/time__description' => 'Změnit systémový datum/čas, synchronizovat se serverem NTP.',
    'ui__server/maillists__title' => 'Nastavit server seznamu adresátů', // PFU
    'ui__server/maillists__short-title' => 'Nastavit server seznamu adresátů', // PFU
    'ui__server/maillists__description' => 'Nastavit server seznamu adresátů aplikace Mailman.', // PFU
    'ui__mass-email__short-title' => "Hromadné e-mailové zprávy", // PFW
    'ui__mass-email__title' => "Hromadné e-mailové zprávy", // PFW
    'ui__mass-email__description' => "Odeslat e-mailovou zprávu několika uživatelům současně.", // PFW
    'ui__mass-mail__title' => 'Hromadné e-mailové zprávy', // PFU
    'ui__mass-mail__short-title' => 'Hromadné e-mailové zprávy', // PFU
    'ui__mass-mail__description' => 'Odeslat e-mailovou zprávu několika uživatelům současně.', // PFU
    'ui__server/spam-filter__title' => 'Nastavení filtru nevyžádané pošty',
    'ui__server/spam-filter__short-title' => 'Nastavení filtru nevyžádané pošty',
    'ui__server/spam-filter__description' => 'Nastavit filtr nevyžádané pošty pro celý server.',
    'ui__server/preferences__title' => "Nastavení serveru",
    'ui__server/preferences__short-title' => "Nastavení serveru",
    'ui__server/preferences__description' => "Nastavit statistické výpočty po celém serveru, změnit název hostitele serveru a změnit další nastavení serveru.",

    // help & support
    // icons
    'ui__support__short-title' => 'Podpora',
    'ui__support__title' => 'Podpora',
    'ui__support__description' => 'Odeslat žádost o odbornou pomoc nebo zkontrolovat vstupenky, které vytvořili vaši zákazníci.',
    'ui__license__short-title' => 'Informace o licencích',
    'ui__license__title' => 'Informace o licencích Plesk',
    'ui__license__description' => 'Zobrazit informace o vaší licenci Plesk a objednat nové licenční klíče.',
    'ui__help__short-title' => 'Nápověda',
    'ui__help__title' => 'Online nápověda',
    'ui__help__description' => 'Zobrazit nápovědu online.',
    'ui__news__short-title' => "Co je nového",
    'ui__news__title' => "Co je nového",
    'ui__news__description' => "Podívejte se na seznam změn v této verzi prostředí Plesk.",
    'ui__server/autoinstaller__short-title' => 'Aktualizace',
    'ui__server/autoinstaller__title' => 'Aktualizace',
    'ui__server/autoinstaller__description' => 'Aktualizovat Plesk a jeho součásti.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domény',
    'ui__client/domain_unknown__title' => 'Domény',
    'ui__client/domain_unknown__description' => 'Spravovat domény.',
    'ui__server/skeleton__short-title' => 'Šablona virtuálního hostitele',
    'ui__server/skeleton__title' => 'Šablona virtuálního hostitele',
    'ui__server/skeleton__description' => 'Zadejte soubory a složky, které by se měly vložit do adresářů nově vytvořených domén.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Přiřadit nového vlastníka k předplaceným službám',
    'ui__client/domain/chowner_multi-select__short-title' => 'Přiřadit nového vlastníka předplacené služby',
    'ui__client/domain/chowner_multi-select__description' => 'Přiřadit nového vlastníka k vybraným předplaceným službám',
    'ui__client/domain/disable_multi__title' => 'Pozastavit domény',
    'ui__client/domain/disable_multi__short-title' => 'Pozastavit domény',
    'ui__client/domain/disable_multi__description' => 'Pozastavit vybrané domény',
    'ui__client/domain/enable_multi__title' => 'Aktivovat domény',
    'ui__client/domain/enable_multi__short-title' => 'Aktivovat domény',
    'ui__client/domain/enable_multi__description' => 'Aktivovat vybrané domény',

    // icons
    'ui__admin/extras-domain__short-title' => 'Nástroje z MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Nástroje z MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Nastavení ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Nastavení ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Konfigurovat nastavení ASP.NET celého serveru.', // PFW
    'ui__server/sitebuilder__short-title' => 'Nastavení systému Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Nastavení systému Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Nastavit systém Presence Builder na úpravu webů hostovaných na tomto serveru.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Registrovat doménu',
    'ui__admin/register-domain__short-title' => 'Registrovat doménu',
    'ui__admin/register-domain__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Spravovat doménu',
    'ui__admin/manage-domain__short-title' => 'Spravovat doménu',
    'ui__admin/manage-domain__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',
    'ui__server/register__title' => 'Registrovat server',
    'ui__server/register__short-title' => 'Registrovat server',
    'ui__server/register__description' => 'Pokud se chcete připojit k přidruženému programu, registrujte svůj server',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Protokol akcí',
    'ui__actionlog__title' => 'Protokol akcí',
    'ui__actionlog__description' => 'Stáhnout protokol akcí a spravovat nastavení protokolu akcí.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Informace o serveru',
    'ui__server/statistics__title' => 'Informace o serveru',
    'ui__server/statistics__description' => 'Statistiky služeb spravovaných prostředím Plesk.',
    'ui__admin/report__title' => 'Souhrnné hlášení',
    'ui__admin/report__short-title' => 'Souhrnné hlášení',
    'ui__admin/report__description' => 'Zobrazit sestavu využití přenosu dat a prostředků pro prodejce, zákazníky a domény.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Doba nečinnosti relace',
    'ui__sessions/properties__title' => 'Doba nečinnosti relace',
    'ui__sessions/properties__description' => 'Nastavit časový limit nečinnosti relace pro relace prostředí Plesk.',
    'ui__cp-access__short-title' => 'Přístup k prostředí Plesk',
    'ui__cp-access__title' => 'Přístup k prostředí Plesk',
    'ui__cp-access__description' => 'Omezit přístup k prostředí Plesk.',
    'ui__sessions__short-title' => 'Aktivní relace',
    'ui__sessions__title' => 'Aktivní relace',
    'ui__sessions__description' => 'Zobrazit aktivní relace Plesk.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Certifikáty SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Certifikáty SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Seznam certifikátů SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Osobní údaje',
    'ui__admin-info__title' => 'Osobní údaje',
    'ui__admin-info__description' => 'Změnit osobní údaje pro váš účet.',
    'ui__admin-password__short-title' => 'Změnit heslo',
    'ui__admin-password__title' => 'Změnit heslo',
    'ui__admin-password__description' => 'Změnit heslo pro váš účet.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Virtuální adresáře', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Virtuální adresáře', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Na webu pracujte s fyzickými a virtuálními soubory a adresáři.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Využití prostředků',
    'ui__reseller/limits__title' => 'Využití prostředků',
    'ui__reseller/limits__description' => 'Zobrazovat a spravovat využití prostředků prodejce %1.',
    'ui__reseller/limits_unknown__short-title' => 'Využití prostředků',
    'ui__reseller/limits_unknown__title' => 'Využití prostředků',
    'ui__reseller/limits_unknown__description' => 'Zobrazit a spravovat využití prostředků prodejce.',
    'ui__reseller/limits_self__short-title' => 'Využití prostředků',
    'ui__reseller/limits_self__title' => 'Využití prostředků',
    'ui__reseller/limits_self__description' => "Zobrazit a spravovat vaše využití prostředků.",
    'ui__reseller/limits_readonly-self__short-title' => 'Využití prostředků',
    'ui__reseller/limits_readonly-self__title' => 'Využití prostředků',
    'ui__reseller/limits_readonly-self__description' => "Zobrazit využití vašich prostředků.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Využití přenosu dat podle zákazníků',
    'ui__reseller/client/traffic_unknown__title' => 'Zobrazit využití přenosu dat zákazníky',
    'ui__reseller/client/traffic_unknown__description' => 'Zobrazit sestavy využití přenosu dat na zákaznické účty.',
    'ui__client/traffic_unknown__short-title' => "Využití přenosu dat podle zákazníků", // temporary for presets
    'ui__client/traffic_unknown__title' => "Zobrazit využití přenosu dat zákazníky", // temporary for presets
    'ui__client/traffic_unknown__description' => "Zobrazit sestavy využití přenosu dat na zákaznické účty.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Správce souborů protokolu',
    'ui__client/domain/hosting/logs_unknown__title' => 'Správce souborů protokolu',
    'ui__client/domain/hosting/logs_unknown__description' => 'Zobrazit protokoly a konfigurovat rotaci souborů protokolu.',
    // dropdowns
    'ui__reseller/report__title' => 'Souhrnné hlášení',
    'ui__reseller/report__short-title' => 'Souhrnné hlášení',
    'ui__reseller/report__description' => 'Zobrazit sestavu využití přenosu dat a prostředků pro tohoto prodejce.',
    'ui__reseller/report_unknown__title' => 'Souhrnné hlášení',
    'ui__reseller/report_unknown__short-title' => 'Souhrnné hlášení',
    'ui__reseller/report_unknown__description' => 'Zobrazit sestavu využití přenosu dat a prostředků pro prodejce.',
    'ui__reseller/report_self__title' => 'Souhrnné hlášení',
    'ui__reseller/report_self__short-title' => 'Souhrnné hlášení',
    'ui__reseller/report_self__description' => 'Zobrazit sestavu vašeho využití přenosu dat a prostředků.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Branding prostředí Plesk',
    'ui__client/logo_reseller__short-title' => 'Branding prostředí Plesk',
    'ui__client/logo_reseller__description' => 'Změnit značku Plesk pro prodejce %1.',
    'ui__client/logo_unknown__title' => 'Branding prostředí Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Branding prostředí Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Změnit značku prostředí Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Branding prostředí Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Branding prostředí Plesk',
    'ui__client/logo_self-reseller__description' => 'Změnit značku vašeho prostředí Plesk.',
    'ui__reseller/permissions__title' => 'Oprávnění',
    'ui__reseller/permissions__short-title' => 'Oprávnění',
    'ui__reseller/permissions__description' => "Zobrazit či změnit akce, které může prodejce %1 uskutečnit v prostředí Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Oprávnění',
    'ui__reseller/permissions_unknown__title' => 'Oprávnění',
    'ui__reseller/permissions_unknown__description' => "Zobrazit či změnit akce, které může prodejce uskutečnit v prostředí Plesk.",
    'ui__reseller/permissions_self__title' => 'Oprávnění',
    'ui__reseller/permissions_self__short-title' => 'Oprávnění',
    'ui__reseller/permissions_self__description' => 'Zobrazit seznam akcí, které lze uskutečnit v prostředí Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Oprávnění',
    'ui__reseller/permissions_readonly-self__short-title' => 'Oprávnění',
    'ui__reseller/permissions_readonly-self__description' => 'Zobrazit seznam akcí, které lze uskutečnit v prostředí Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Šablona virtuálního hostitele',
    'ui__client/skeleton__short-title' => 'Šablona virtuálního hostitele',
    'ui__client/skeleton__description' => 'Zadejte soubory a složky, které by se měly vložit do adresářů nově vytvořených domén.',
    'ui__client/skeleton_unknown__short-title' => 'Šablona virtuálního hostitele',
    'ui__client/skeleton_unknown__title' => 'Šablona virtuálního hostitele',
    'ui__client/skeleton_unknown__description' => 'Zadejte soubory a složky, které by se měly vložit do adresářů nově vytvořených domén.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Doménové aliasy',
    'ui__client/domain/domain-alias_unknown__title' => 'Doménové aliasy',
    'ui__client/domain/domain-alias_unknown__description' => 'Zobrazit seznam alternativních názvů pro vaši doménu.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Nastavení DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_unknown__description' => 'Spravovat nastavení zóny DNS pro doménu.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Zobrazit nastavení zóny DNS pro doménu.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Nástroje z MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Nástroje z MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Nástroje z MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Nástroje z MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Nástroje z MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Nástroje z MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Registrovat doménu',
    'ui__reseller/register-domain__title' => 'Registrovat doménu',
    'ui__reseller/register-domain__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Registrovat doménu',
    'ui__reseller/register-domain_unknown__title' => 'Registrovat doménu',
    'ui__reseller/register-domain_unknown__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Registrovat doménu',
    'ui__reseller/register-domain_self__title' => 'Registrovat doménu',
    'ui__reseller/register-domain_self__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Spravovat doménu',
    'ui__reseller/manage-domain__short-title' => 'Spravovat doménu',
    'ui__reseller/manage-domain__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Spravovat doménu',
    'ui__reseller/manage-domain_unknown__short-title' => 'Spravovat doménu',
    'ui__reseller/manage-domain_unknown__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Spravovat doménu',
    'ui__reseller/manage-domain_self__short-title' => 'Spravovat doménu',
    'ui__reseller/manage-domain_self__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP adresy',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP adresy',
    'ui__client/ipaddress_unknown-reseller__description' => 'Spravovat IP adresy.',
    'ui__client/domain/certificate_unknown__short-title' => 'Certifikáty SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Certifikáty SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Nainstalovat a spravovat TLS certifikáty SSL/TLS.',
    'ui__reseller/sessions__short-title' => 'Aktivní relace',
    'ui__reseller/sessions__title' => 'Aktivní relace',
    'ui__reseller/sessions__description' => 'Zobrazit aktivní relace Plesk.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktivní relace',
    'ui__reseller/sessions_unknown__title' => 'Aktivní relace',
    'ui__reseller/sessions_unknown__description' => 'Zobrazit aktivní relace Plesk.',
    'ui__reseller/sessions_self__short-title' => 'Aktivní relace',
    'ui__reseller/sessions_self__title' => 'Aktivní relace',
    'ui__reseller/sessions_self__description' => 'Zobrazit aktivní relace Plesk.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'E-mailové účty pod uživatelským účtem %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Šablona virtuálního hostitele',
    'ui__client/skeleton_self__title' => 'Šablona virtuálního hostitele',
    'ui__client/skeleton_self__description' => 'Zadejte soubory a složky, které by se měly vložit do adresářů nově vytvořených domén.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Využití prostředků',
    'ui__client/limits__title' => 'Využití prostředků',
    'ui__client/limits__description' => "Zobrazit a spravovat využití prostředků zákazníka %1.",
    'ui__client/limits_unknown__short-title' => 'Využití prostředků',
    'ui__client/limits_unknown__title' => 'Využití prostředků',
    'ui__client/limits_unknown__description' => 'Zobrazit a spravovat využití prostředků zákazníka.',
    'ui__client/limits_readonly__short-title' => 'Využití prostředků',
    'ui__client/limits_readonly__title' => 'Využití prostředků',
    'ui__client/limits_readonly__description' => 'Zobrazit využití prostředků zákazníka %1.',
    'ui__client/limits_self__short-title' => 'Využití prostředků',
    'ui__client/limits_self__title' => 'Využití prostředků',
    'ui__client/limits_self__description' => "Zobrazit a spravovat vaše využití prostředků.",
    'ui__client/limits_readonly-self__short-title' => 'Využití prostředků',
    'ui__client/limits_readonly-self__title' => 'Využití prostředků',
    'ui__client/limits_readonly-self__description' => "Zobrazit využití vašich prostředků.",
    'ui__client/domain/traffic_unknown__short-title' => "Využití přenosu dat prostřednictvím domén %1",
    'ui__client/domain/traffic_unknown__title' => "Zobrazit využití přenosu dat podle domén",
    'ui__client/domain/traffic_unknown__description' => "Zobrazit sestavy využití přenosu dat pro domény.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Souhrnné hlášení',
    'ui__client/report__short-title' => 'Souhrnné hlášení',
    'ui__client/report__description' => 'Zobrazit sestavu využití přenosu dat a prostředků pro tohoto zákazníka.',
    'ui__client/report_unknown__short-title' => 'Souhrnné hlášení',
    'ui__client/report_unknown__title' => 'Souhrnné hlášení',
    'ui__client/report_unknown__description' => 'Zobrazit sestavu využití přenosu dat a prostředků pro zákazníka.',
    'ui__client/report_self__short-title' => 'Souhrnné hlášení',
    'ui__client/report_self__title' => 'Souhrnné hlášení',
    'ui__client/report_self__description' => 'Zobrazit sestavu využití přenosu dat a prostředků.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Předvolby rozhraní',
    'ui__client/preferences__title' => 'Předvolby rozhraní',
    'ui__client/preferences__description' => 'Nastavit předvolby rozhraní Plesk pro zákazníka %1.',
    'ui__client/preferences_unknown__short-title' => 'Předvolby rozhraní',
    'ui__client/preferences_unknown__title' => 'Předvolby rozhraní',
    'ui__client/preferences_unknown__description' => "Nastavit předvolby rozhraní pro prostředí Plesk zákazníka.",
    'ui__client/preferences_self__short-title' => 'Předvolby rozhraní',
    'ui__client/preferences_self__title' => 'Předvolby rozhraní',
    'ui__client/preferences_self__description' => 'Nastavit předvolby rozhraní pro vaše prostředí Plesk.',
    'ui__client/logo__title' => 'Branding prostředí Plesk',
    'ui__client/logo__short-title' => 'Branding prostředí Plesk',
    'ui__client/logo__description' => "Změna značky Plesk pro zákazníka %1.",
    'ui__client/logo_self__title' => 'Branding prostředí Plesk',
    'ui__client/logo_self__short-title' => 'Branding prostředí Plesk',
    'ui__client/logo_self__description' => 'Změna značky Plesk, změna grafiky loga a titulní lišty prohlížeče.',
    'ui__client/permissions__title' => 'Oprávnění',
    'ui__client/permissions__short-title' => 'Oprávnění',
    'ui__client/permissions__description' => "Zobrazit či změnit akce, které může zákazník %1 uskutečnit v prostředí Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Oprávnění',
    'ui__client/permissions_unknown__title' => 'Oprávnění',
    'ui__client/permissions_unknown__description' => "Zobrazit či změnit akce, které může zákazník uskutečnit v prostředí Plesk.",
    'ui__client/permissions_self__title' => 'Oprávnění',
    'ui__client/permissions_self__short-title' => 'Oprávnění',
    'ui__client/permissions_self__description' => "Zobrazit seznam akcí, které lze uskutečnit v prostředí Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Oprávnění',
    'ui__client/permissions_readonly-self__short-title' => 'Oprávnění',
    'ui__client/permissions_readonly-self__description' => "Zobrazit seznam akcí, které lze uskutečnit v prostředí Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Nástroje z MyPlesk.com',
    'ui__client/extras-domain__title' => 'Nástroje z MyPlesk.com',
    'ui__client/extras-domain__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Nástroje z MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Nástroje z MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Nástroje z MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Nástroje z MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Registrovat doménu',
    'ui__client/register-domain__short-title' => 'Registrovat doménu',
    'ui__client/register-domain__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Registrovat doménu',
    'ui__client/register-domain_unknown__short-title' => 'Registrovat doménu',
    'ui__client/register-domain_unknown__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Registrovat doménu',
    'ui__client/register-domain_self__short-title' => 'Registrovat doménu',
    'ui__client/register-domain_self__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Spravovat doménu',
    'ui__client/manage-domain__short-title' => 'Spravovat doménu',
    'ui__client/manage-domain__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Spravovat doménu',
    'ui__client/manage-domain_unknown__short-title' => 'Spravovat doménu',
    'ui__client/manage-domain_unknown__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Spravovat doménu',
    'ui__client/manage-domain_self__short-title' => 'Spravovat doménu',
    'ui__client/manage-domain_self__description' => 'Spravovat názvy domén prostřednictvím MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP adresy',
    'ui__client/ipaddress_unknown__short-title' => "IP adresy",
    'ui__client/ipaddress_unknown__description' => "Spravovat IP adresy.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Doménové aliasy',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Doménové aliasy',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Zobrazit seznam alternativních názvů pro vaši doménu.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Aktivní relace',
    'ui__client/sessions__title' => 'Aktivní relace',
    'ui__client/sessions__description' => 'Zobrazit aktivní relace Plesk.',
    'ui__client/sessions_unknown__short-title' => 'Aktivní relace',
    'ui__client/sessions_unknown__title' => 'Aktivní relace',
    'ui__client/sessions_unknown__description' => 'Zobrazit aktivní relace Plesk.',
    'ui__client/sessions_self__short-title' => 'Aktivní relace',
    'ui__client/sessions_self__title' => 'Aktivní relace',
    'ui__client/sessions_self__description' => 'Zobrazit aktivní relace Plesk.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'Virtuální adresáře', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Virtuální adresáře', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Na webu %1 pracujte s fyzickými a virtuálními soubory a adresáři.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Virtuální adresáře', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Virtuální adresáře', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Na svém webu pracujte s fyzickými a virtuálními soubory a adresáři.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 využití přenosu dat',
    'ui__client/domain/traffic__title' => 'Statistiky přenosu dat pro <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Zobrazit statistiky přenosu dat pro doménu %1.',
    'ui__client/domain/traffic_self__short-title' => 'Využití přenosu dat',
    'ui__client/domain/traffic_self__title' => 'Zobrazit využití přenosu dat pro vaši doménu',
    'ui__client/domain/traffic_self__description' => 'Zobrazit sestavu využití přenosu dat pro vaši doménu.',
    'ui__client/domain/hosting/logs__short-title' => 'Správce souborů protokolu',
    'ui__client/domain/hosting/logs__title' => 'Správce souborů protokolu',
    'ui__client/domain/hosting/logs__description' => 'Zobrazit protokoly a konfigurovat rotaci souborů protokolu.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Správce souborů protokolu',
    'ui__client/domain/hosting/logs_self__title' => 'Správce souborů protokolu',
    'ui__client/domain/hosting/logs_self__description' => 'Zobrazit protokoly a konfigurovat rotaci souborů protokolu.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Přejmenovat doménu',
    'ui__client/domain/rename__short-title' => 'Přejmenovat doménu',
    'ui__client/domain/rename__description' => 'Přejmenovat doménu %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Přejmenovat doménu',
    'ui__client/domain/rename_unknown__title' => 'Přejmenovat doménu',
    'ui__client/domain/rename_unknown__description' => 'Přejmenovat doménu',
    'ui__client/domain/chowner_select__title' => 'Přiřadit nového vlastníka k doméně',
    'ui__client/domain/chowner_select__short-title' => 'Přiřadit nového vlastníka k předplacené službě',
    'ui__client/domain/chowner_select__description' => 'Přiřadit nového vlastníka k předplacené službě',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Přiřadit nového vlastníka k předplacené službě',
    'ui__client/domain/chowner_unknown-select__title' => 'Přiřadit nového vlastníka k předplacené službě',
    'ui__client/domain/chowner_unknown-select__description' => 'Přiřadit nového vlastníka k předplacené službě.',
    'ui__client/domain/toggle__title' => 'Pozastavit nebo aktivovat doménu', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Pozastavit nebo aktivovat doménu', // for HP customization
    'ui__client/domain/toggle__description' => 'Pozastavit nebo aktivovat doménu %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Pozastavit nebo aktivovat doménu', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Pozastavit nebo aktivovat doménu', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Pozastavit nebo aktivovat doménu.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktivovat doménu',
    'ui__client/domain/toggle_enable__short-title' => 'Aktivovat doménu',
    'ui__client/domain/toggle_enable__description' => 'Aktivovat doménu %1.',
    'ui__client/domain/toggle_disable__title' => 'Pozastavit doménu',
    'ui__client/domain/toggle_disable__short-title' => 'Pozastavit doménu',
    'ui__client/domain/toggle_disable__description' => 'Pozastavit doménu %1',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Nastavení DNS',
    'ui__client/domain/dns__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns__description' => 'Spravovat nastavení zóny DNS pro doménu %1.',
    'ui__client/domain/dns_self__title' => 'Nastavení DNS',
    'ui__client/domain/dns_self__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_self__description' => 'Spravovat nastavení zóny DNS pro vaši doménu.',
    'ui__client/domain/dns_disabled__title' => 'Nastavení DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_disabled__description' => 'Spravovat nastavení zóny DNS pro doménu %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Nastavení DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Spravovat nastavení zóny DNS pro vaši doménu.',
    'ui__client/domain/dns_readonly__title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly__description' => 'Zobrazit nastavení zóny DNS pro doménu %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Zobrazit nastavení zóny DNS pro vaši doménu.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Zobrazit nastavení zóny DNS pro vaši doménu.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Zobrazit nastavení zóny DNS pro vaši doménu.',
    'ui__client/domain/dns_slave__title' => 'Nastavení DNS',
    'ui__client/domain/dns_slave__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_slave__description' => 'Spravovat nastavení zóny DNS pro doménu %1.',
    'ui__client/domain/dns_self-slave__title' => 'Nastavení DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Nastavení DNS',
    'ui__client/domain/dns_self-slave__description' => 'Spravovat nastavení zóny DNS pro vaši doménu.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Nástroje z MyPlesk.com',
    'ui__client/domain/extras__title' => 'Nástroje z MyPlesk.com',
    'ui__client/domain/extras__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Nástroje z MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Nástroje z MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Nástroje z MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Nástroje z MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Získat další nástroje a služby ze serveru MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Registrovat doménu',
    'ui__client/domain/register__title' => 'Registrovat doménu',
    'ui__client/domain/register__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Registrovat doménu',
    'ui__client/domain/register_unknown__title' => 'Registrovat doménu',
    'ui__client/domain/register_unknown__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Registrovat doménu',
    'ui__client/domain/register_self__title' => 'Registrovat doménu',
    'ui__client/domain/register_self__description' => 'Registrovat název domény prostřednictvím MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Nástroje",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Zobrazit statistiku',
    'ui__client/domain-summary-report_unknown__title' => 'Zobrazit statistiku',
    'ui__client/domain-summary-report_unknown__description' => 'Zobrazit informace o využití prostředků doménami.',
    'ui__client/domain-summary-report__short-title' => "Zobrazit statistiku",
    'ui__client/domain-summary-report__title' => "Zobrazit statistiku",
    'ui__client/domain-summary-report__description' => "Zobrazit informace o využití prostředků doménami.",
    'ui__client/domain-summary-report_self__short-title' => "Zobrazit statistiku",
    'ui__client/domain-summary-report_self__title' => "Zobrazit statistiku",
    'ui__client/domain-summary-report_self__description' => "Zobrazit informace o využití prostředků vašimi doménami.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domény", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Musíte vybrat domény, které chcete odebrat',
    'ui__client/domain/chowner__empty_selection' => 'Musíte vybrat domény, které chcete přiřadit novému vlastníkovi',

    // list objects filtering
    'domains_list__name__filter_title' => 'Jméno',
    'domains_list__state__filter_title' => 'Využití prostředků',
    'domains_list__filter_state_any' => 'Každý',
    'domains_list__filter_state_overuse' => 'Překročení limitu',
    'domains_list__filter_state_normal' => 'V rozsahu',
    'domains_list__status__filter_title' => 'Stav',
    'domains_list__filter_status_any' => 'Každý',
    'domains_list__filter_status_blocked' => 'Pozastaveno',
    'domains_list__filter_status_active' => 'Aktivní',
    'domains_list__ownership__filter_title' => 'Vlastnictví',
    'domains_list__filter_ownership_all' => 'Všechny domény',
    'domains_list__filter_ownership_personal' => 'Pouze mé domény',
    'domains_list__filter_owner_pname__filter_title' => 'Jméno vlastníka',
    'domains_list__subrows__filter_title' => 'Zobrazit',
    'domains_list__subrows_off' => 'Pouze domény',
    'domains_list__subrows_subdomain_domainaliases' => 'Se subdoménami a aliasy',
    'domains_list__subrows_subdomain' => 'Se subdoménami',
    'domains_list__subrows_domainaliases' => 'S aliasy',

    // objects list
    'domains_list__owner__title' => 'Vlastník',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Hledat aplikace",
    'site_apps__promo_main_text' => "Katalog balíčků standardních aplikací (APS) obsahuje seznam aplikací, které lze zajistit pro doménu nebo webový prostor. Pokud byste chtěli zajistit aplikace, které momentálně nejsou v katalogu, můžete tak snadno učinit podle následujících pokynů pro APS na adrese www.apsstandard.com",
    'site_apps__promo_download_now' => "Stáhnout aplikace:",
    'site_apps__promo_close' => "Zavřít tento blok",
    'site_apps__promo_preset__mostused' => '%1 Nejoblíbenější',
    'site_apps__promo_preset__lessused' => 'Další %1 nejoblíbenější',
    'site_apps__promo_preset__all' => "Všechno",
    'site_apps__promo_disclaimer_note' => 'Pamatujte si, že aplikace nainstalované z katalogu APS zajišťuje třetí strana a společnost Plesk je nepodporuje.',
    'site_apps__promo_preset__page_title' => '%1 aplikace APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Přidávání aplikací...',

    // Errors
    'site_apps__no_applications_for_update' => 'V aplikačním trezoru nemáte nainstalované žádné aplikace.',
    'site_apps__incorrect_download_preset_configuration' => 'V konfiguraci předvolby stažení katalogu APS byly zjištěny chyby.',
    'site_apps__aps_catalog_url_is_invalid' => 'Zadaná adresa URL není platná.',
    'site_apps__no_updates_at_the_moment' => 'Momentálně nejsou k dispozici žádné aktualizace aplikací.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Z katalogu aplikací APS byly přijaty nesprávné informace. Opakujte akci později.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Nastavení katalogu APS bylo uloženo, ale Plesk nemohl vytvořit připojení ke katalogu APS specifikovaném v nastavení katalogu APS (%1). Ověřte si, zda je katalog adres APS správný a katalog APS na této adrese aktivní.',
    'site_apps__cannot_retrieve_updates' => 'Momentálně nelze stáhnout aktualizace aplikace: nelze navázat spojení s katalogem APS (%1). Ověřte si, zda je katalog adres APS správný a katalog APS na této adrese aktivní.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Nejsou dostupné žádné webové aplikace k instalaci.',
    'site_apps__site_applications_already_installed_in_root' => 'Ostatní webové aplikace jsou již nainstalované v kořenovém adresáři těchto virtuálních hostitelů',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Na platformě Unix/Linux nejsou podporovány webové aplikace .NET",
    'site_apps__server_wide_packages_not_supported' => 'Webové aplikace pro celý server nejsou podporovány',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 více webových aplikací je naplánováno k přidání do aplikačního trezoru.",
    'site_apps__applications_all_in_vault' => "Vybrané webové aplikace jsou již obsaženy v aplikačním trezoru.",
    'site_apps__applications_already_in_download_queue' => "%1 vybraných webových aplikací se právě přidává do aplikačního trezoru.",
    'site_apps__applications_already_in_valut' => "%1 vybraných webových aplikací je již v aplikačním trezoru.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Další (nezařazeno do kategorií)',

    // Errors
    'site_apps__no_applications_in_category' => 'V této kategorii nejsou žádné dostupné aplikace. Vyberte jinou kategorii.',
    'site_apps__no_category_selected__please_specify' => 'Vybrat kategorii z levé nabídky. V tomto okně budou uvedeny všechny aplikace dostupné ve vybrané kategorii.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Účet správce',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Obecné',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Změnit název hostitele',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Zabezpečení',
    'bt_setup_firewall' => 'Nastavit bránu firewall',
    'bt_manage_firewall_rules' => 'Spravovat pravidla brány firewall',
    'cu_firewall__rule' => 'Vytvořit pravidlo pro bránu firewall',
    'cu_firewall__protocol' => 'Nastavit protokol pro pravidlo (\\&amp;apos;tcp\\&amp;apos; nebo \\&amp;apos;udp\\&amp;apos;)',
    'cu_firewall__name' => "Nastavit název pravidla",
    'cu_firewall__disabled' => 'Pokud platí \\&amp;apos;true\\&amp;apos;, pravidlo je po vytvoření vypnuto',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Vybrat DNS server', // PFW
    'bt_soa_records_template' => 'Šablona záznamů SOA',
    'bt_restrict_creation_of_subzones' => 'Omezit vytváření subzón',

    'databases' => 'Databáze',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Aplikace',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Pošta',
    'bt_select_mailserver' => 'Vybrat e-mailový server', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Vybrat antivirus', // PFW
    'bt_virus_protection_settings' => 'Nastavení antivirové ochrany',
    'bt_select_spamfilter' => 'Vybrat filtr nevyžádané pošty', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Vybrat webové rozhraní pošty',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Protokoly a statistiky',
    'bt_server_statistics_settings' => 'Nastavení statistik serveru',
    'bt_select_web_statistics' => 'Dostupný software webové statistiky', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Rozhraní Plesk',

    'components_and_modules' => 'Součásti a moduly',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Nastavit sledovací zařízení', // PFU
    'bt_setup_vpn' => 'Nastavit VPN', // PFU
    'bt_setup_samba' => 'Nastavit prostředí samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Nastavení',
    'ui__client/domain/settings_self__short-title' => 'Nastavení',
    'ui__client/domain/settings_self__description' => 'Zobrazit a změnit nastavení domény.',

    'domain_administrator_account' => 'Účet správce domény',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Nastavení účtu',

    'domain' => 'Doména',
    'bt_dns_soa_records' => 'Záznamy DNS SOA',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Nastavení plánovače úloh',

    'website' => 'Webové stránky',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Skriptování pro uživatele webu',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Vybrat certifikát SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Webová statistika',
    'bt_log_rotation_settings' => 'Nastavení rotace souborů protokolu',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Limity", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Zásady nadměrného využití a překročení nabídky",
    'limits__overuse_policy_legend' => "Překročení limitu",
    'limits__oversell_policy_legend' => "Nabídka",
    'limits__reseller_overuse_description' => "Zásady nadměrného využití řeknou prostředí Plesk co dělat, pokud jsou prostředky využívány nadměrně.",
    'limits__overuse_text' => "Zásady nadměrné využití",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Místo na disku a přenos',
    'limit__disk_space' => 'Místo na disku',
    'limit__max_traffic' => 'Provoz',
    'limit_group__client' => 'Zákazníci',
    'limit__max_cl' => 'Zákazníci',
    'limit_group__domain' => 'Domény',
    'limit__max_dom' => 'Domény',
    'limit__max_dom_powerUser' => 'Předplacené služby',
    'limit__max_subdom' => 'Subdomény',
    'limit__max_dom_aliases' => 'Doménové aliasy',
    'limit__max_wu' => 'Uživatelé webu',
    'limit__max_subftp_users' => 'Další účty FTP', // PFW
    'limit_group__mail' => 'Pošta',
    'limit__max_box' => 'Poštovní schránky',
    'limit__mbox_quota' => 'Velikost poštovní schránky',
    'limit__total_mboxes_quota' => 'Celková kvóta poštovních schránek', // PFW
    'limit__max_maillists' => 'Seznamy adresátů',
    'limit_group__database' => 'Databáze',
    'limit__max_mssql_db' => 'Databáze Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Celková kvóta databází MS SQL', // PFW
    'limit__max_odbc' => 'Připojení ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Kvóta databází MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Kvóta databází PostgreSQL', // PFW
    'limit_group__application' => 'Aplikace',
    'limit__max_iis_app_pools' => 'Fondy aplikací IIS', // PFW
    'limit_group__security' => 'Zabezpečení',
    'limit_group__validity' => 'Datum vypršení platnosti',
    'limit__expiration' => 'Datum vypršení platnosti',
    'limit__validity' => 'Období platnosti',
    'limit__max_site_builder' => 'Weby publikované prostřednictvím systému Presence Builder',
    'limit__max_site' => 'Domény',
    'limit__mssql_dbase_filesize' => 'Velikost souboru databáze MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Velikost souboru protokolu databáze MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Maximální velikost souboru databáze Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Maximální velikost souboru protokolu databáze Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Neplatný limit domén. Minimální hodnota je 1.',

    'property__has_wrong_value' => 'Vlastnost %1 obsahuje neplatnou hodnotu.',
    'property__name_outgoing_messages_domain_limit' => 'Nastaví limit odchozích zpráv z domény (za hodinu). Chcete-li nastavit hodnotu Neomezené, zadejte "-1". Chcete-li nastavit hodnotu specifikovanou v nastavení celého serveru, zadejte "výchozí".',
    'property__name_outgoing_messages_mbox_limit' => 'Nastaví limit odchozích zpráv z poštovní schránky (za hodinu). Chcete-li nastavit hodnotu Neomezené, zadejte "-1". Chcete-li nastavit hodnotu specifikovanou v nastavení celého serveru, zadejte "výchozí".',
    'property__name_outgoing_messages_subscription_limit' => 'Nastaví limit odchozích zpráv z předplatného (za hodinu) Chcete-li nastavit hodnotu Neomezené, zadejte "-1". Chcete-li nastavit hodnotu specifikovanou v nastavení celého serveru, zadejte "výchozí".',

    // for CLI report & email notifications
    '__resource_notify' => 'Oznámit',
    '__general' => 'Obecné',
    '__template_shared' => 'Sdílená šablona',
    'limit__overuse' => 'Zásady nadměrné využití',
    'limit__max_traffic_soft' => 'Upozornit při dosažení přenosu dat',
    'limit__disk_space_soft' => 'Upozornit, když využití místa na disku dosáhne',
    '__overuse' => 'Zásady nadměrné využití',
    'performance__title' => 'Výkon',
    'performance__bandwidth' => 'Maximální využití šířky pásma (kB/s)',
    'performance__max_connections' => 'Připojení omezena na',

    'gch__hosting_php_isapi' => 'Spustit PHP jako rozšíření ISAPI',
    'gch__hosting_ssi_html' => 'Použít SSI na soubory *.htm, *.html',
    'gch__hosting_php_handler_type' => 'Spustit PHP jako',
    'gch__hosting_php_handler_id' => 'Spustit PHP jako',
    'gch__hosting_php_served_by_nginx' => 'PHP obsluhovaný prostřednictvím nginx',
    'gch__hosting_unpaid_website_status' => 'Stav webů v pozastavených předplacených službách',
    'gch__mn_no_autoresponder' => 'Pro e-mailový účet nejsou nastaveny žádné automatické odpovědi.',
    'gch__no_clients_selected' => "Nejsou vybrány žádné zákaznické účty",
    'gch__no_domains_selected' => "Nebyly vybrány žádné domény",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/měsíc",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Název prostředku',
    '__resource_usage' => 'Využito',
    '__resource_limit' => 'Limit',

    '__used' => 'Využito',
    '__limit' => 'Limit',

    '__never_expires' => 'Bez časového omezení',
    '__resource_free' => '%1 volných z %2',
    '__resource_unlimited' => '%1% použito z Neomezené',

    '__unlimited' => 'Neomezeno',
    '__increment' => "Zvýšit (+)",
    '__decrement' => "Snížit (-)",
    '__pt' => 'jednotky',
    '__procent' => '%',
    '__overused' => 'Nadměrně využito',
    '__left' => 'vlevo',
    '__available' => 'dostupný',
    '__not_available' => 'Nezahrnuto',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Plán doručení',
    'ui__admin/report/layout/auto_unknown__title' => 'Plán doručení sestavy',
    'ui__admin/report/layout/auto_unknown__description' => 'Vybrat plán doručení pro rozvržení sestavy.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Přidat plán doručení sestavy',
    'ui__admin/report/layout/auto/properties_new__title' => 'Přidat plán doručení sestavy',
    'ui__admin/report/layout/auto/properties_new__description' => 'Vybrat plán doručení pro sestavu %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Plán doručení sestavy',
    'ui__admin/report/layout/auto/properties__title' => 'Plán doručení sestavy',
    'ui__admin/report/layout/auto/properties__description' => 'Zobrazit a změnit vlastnosti plánu doručení sestavy.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Odebrat plány doručení sestavy.',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Odebrat plány doručení sestavy.',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Odebrat vybrané plány doručení sestav.',

    'ui__admin/report/layout_unknown__short-title' => 'Rozvržení sestav',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Zobrazit využití provozu pro <b>%1</b>',
    'ui__reseller/traffic__description' => 'Zobrazit sestavy využití přenosu dat na účet prodejce %1.',
    'ui__reseller/traffic_self__short-title' => 'Moje',
    'ui__reseller/traffic_self__title' => 'Zobrazit využití přenosu dat zákazníky',
    'ui__reseller/traffic_self__description' => 'Zobrazit sestavy využití přenosu dat na vaše zákaznické účty.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Název prodejce', // reseller report
    'report__full_client_name' => 'Jméno zákazníka', // customer report
    'report__full_domain_name' => 'Název domény', // domain report
    'report__full_owner' => 'Vlastník', // customer & domain reports
    'report__full_creation_date' => 'Datum vytvoření',
    'report__full_size' => 'Velikost',
    'report__full_traffic' => 'Provoz',
    'report__full_active_clients' => 'Aktivní zákazníci', // reseller report
    'report__full_clients' => 'Zákazníci', // reseller report
    'report__full_active_domains' => 'Aktivní domény', // reseller & customer reports
    'report__full_domains' => 'Domény', // reseller & customer reports
    'report__full_subdomains' => 'Subdomény',
    'report__full_mboxes' => 'Schránky',
    'report__full_disk_space' => 'Místo na disku',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Seznam adresátů',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'Databáze PostgreSQL',

    // common summary report
    'report__section_general' => 'Obecné',
    'report__version' => 'Verze produktu',
    'report__build' => 'Sestavení produktu',
    'report__status' => 'Stav',
    'report__company_name' => 'Název společnosti',
    'report__personal_name' => 'Jméno a příjmení',
    'report__login' => 'Uživatelské jméno',
    'report__phone' => 'Telefon',
    'report__fax' => 'Fax',
    'report__email' => 'E-mail',
    'report__address' => 'Adresa',
    'report__city' => 'Město',
    'report__state' => 'Stát/Oblast',
    'report__zip_code' => 'PSČ',
    'report__country' => 'Země',
    'report__creation_date' => 'Datum vytvoření',
    'report__expiration_date' => 'Datum vypršení platnosti',
    'report__dumps_total_size' => 'Celková velikost záložních souborů.',
    'report__section_resellers' => 'Distributoři',
    'report__active_resellers' => 'Prodejci s aktivními předplacenými službami',
    'report__resellers' => 'Distributoři',
    'report__section_full_resellers' => 'Distributoři',
    'report__section_clients' => 'Zákazníci',
    'report__active_clients' => 'Zákazníci s aktivními předplacenými službami',
    'report__clients' => 'Zákazníci',
    'report__section_full_clients' => 'Zákazníci',
    'report__section_personal_clients' => 'Vlastní zákazníci',
    'report__active_personal_clients' => 'Vaši vlastní zákazníci s aktivními předplacenými službami',
    'report__personal_clients' => 'Vlastní zákazníci',
    'report__section_full_personal_clients' => 'Vlastní zákazníci',
    'report__section_domains' => 'Domény',
    'report__disk_usage' => 'Využití disku',
    'report__traffic' => 'Provoz',
    'report__active_domains' => 'Aktivní domény',
    'report__domains' => 'Domény',
    'report__subdomains' => 'Subdomény',
    'report__mboxes' => 'Poštovní schránky',
    'report__mail_groups' => 'Předávání e-mailů',
    'report__mail_autoresp' => 'Automatické odpovědi',
    'report__mail_lists' => 'Seznamy adresátů',
    'report__web_users' => 'Uživatelé webu',
    'report__mysql_databases' => 'Databáze MySQL',
    'report__mssql_databases' => 'Databáze MSSQL',
    'report__pgsql_databases' => 'Databáze PostgreSQL',
    'report__section_full_domains' => 'Domény',
    'report__section_personal_domains' => 'Osobní domény',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Osobní domény',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Weby publikované prostřednictvím systému Presence Builder',
    'report__invalid_email' => 'Zadejte platnou e-mailovou adresu.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Uživatelé webu',
    'report__section_mailnames' => 'Poštovní účty',
    'report__section_maillists' => 'Seznamy adresátů',
    'report__section_databases' => 'Databáze',
    'report__section_siteapps' => 'Webové aplikace',
    'report__section_aspnetapps' => 'Aplikace ASP.NET', // PFW
    'report__owner_pname' => "Osobní jméno poskytovatele",
    'report__owner_login' => "Přihlašovací jméno poskytovatele",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Plán doručení',
    'ui__reseller/report/layout/auto_unknown__title' => 'Plán doručení sestavy',
    'ui__reseller/report/layout/auto_unknown__description' => 'Vybrat plán doručení pro rozvržení sestavy.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Přidat plán doručení sestavy',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Přidat plán doručení sestavy',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Vybrat plán doručení pro sestavu %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Plán doručení sestavy',
    'ui__reseller/report/layout/auto/properties__title' => 'Plán doručení sestavy',
    'ui__reseller/report/layout/auto/properties__description' => 'Zobrazit a změnit vlastnosti plánu doručení sestavy.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Odebrat plány doručení sestavy.',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Odebrat plány doručení sestavy.',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Odebrat vybrané plány doručení sestav.',

    'ui__reseller/report/layout_unknown__short-title' => 'Rozvržení sestav',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Zobrazit využití provozu pro <b>%1</b>',
    'ui__client/traffic__description' => 'Zobrazit sestavy využití přenosu dat na účet zákazníka %1.',
    'ui__client/traffic_self__short-title' => 'Využití přenosu dat',
    'ui__client/traffic_self__title' => 'Využití přenosu dat podle domén',
    'ui__client/traffic_self__description' => 'Zobrazit sestavy využití přenosu dat pro vaše domény.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Zadaná jazyková sada je nainstalována, ale v systému nebyla zapnuta.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Odstranit relace',
    'ui__sessions/delete__title' => 'Odstranit relace',
    'ui__sessions/delete__description' => 'Odstranit vybrané relace.',
    'ui__ftp-sessions__short-title' => 'Relace FTP',
    'ui__ftp-sessions__title' => 'Relace FTP',
    'ui__ftp-sessions__description' => 'Zobrazit relace FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Odstranit relace FTP',
    'ui__ftp-sessions/delete__title' => 'Odstranit relace FTP',
    'ui__ftp-sessions/delete__description' => 'Odstranit vybrané relace FTP.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Odstranit relace',
    'ui__reseller/sessions/delete__title' => 'Odstranit relace',
    'ui__reseller/sessions/delete__description' => 'Odstranit vybrané relace.',
    'ui__reseller/sessions/delete_self__short-title' => 'Odstranit relace',
    'ui__reseller/sessions/delete_self__title' => 'Odstranit relace',
    'ui__reseller/sessions/delete_self__description' => 'Odstranit vybrané relace.',
    'ui__reseller/ftp-sessions__short-title' => 'Relace FTP',
    'ui__reseller/ftp-sessions__title' => 'Relace FTP',
    'ui__reseller/ftp-sessions__description' => 'Zobrazit relace FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Relace FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Relace FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Zobrazit relace FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Odstranit relace FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Odstranit relace FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Odstranit vybrané relace FTP.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Odstranit relace FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Odstranit relace FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Odstranit vybrané relace FTP.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Odstranit relace',
    'ui__client/sessions/delete__title' => 'Odstranit relace',
    'ui__client/sessions/delete__description' => 'Odstranit vybrané relace.',
    'ui__client/sessions/delete_self__short-title' => 'Odstranit relace',
    'ui__client/sessions/delete_self__title' => 'Odstranit relace',
    'ui__client/sessions/delete_self__description' => 'Odstranit vybrané relace.',

    // domain administrator

    'forgery_token_expired' => 'Platnost tokenu relace vypršela.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Následující účty prodejce budou převedeny na zákaznické účty',
    'downgradeResellers__downgrade' => 'Účty prodejce, které budou převedeny',
    // controls
    'downgradeResellers__submit_downgrade' => 'Uskutečnit převod účtu.',
    'downgradeResellers__cancel_downgrade' => 'Zrušit převod účtu.',
    'downgradeResellers__confirm' => 'Potvrdit převod',
    'downgradeResellers__confirm_message' => 'Potvrdit pokračování převodu účtu',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Vybrat zákaznické účty',
    'upgradeClients__upgrade_clients' => 'Následující zákaznické účty budou převedeny na účty prodejce',
    'upgradeClients__upgrade' => 'Zákaznické účty, které budou převedeny',
    // controls
    'upgradeClients__submit_upgrade' => 'Uskutečnit převod účtu.',
    'upgradeClients__cancel_upgrade' => 'Zrušit převod účtu.',
    'upgradeClients__confirm' => 'Potvrdit převod',
    'upgradeClients__confirm_message' => 'Potvrdit pokračování převodu účtu',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Účet \\&amp;apos;%1\\&amp;apos; nelze převést na účet prodejce: \\&amp;apos;%1\\&amp;apos; je již prodejcem.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Následující účty správce domény budou převedeny na zákaznické účty',
    'upgradeDomainUser__upgrade' => 'Účty správce domény, které budou převedeny',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Uskutečnit převod účtu.',
    'upgradeDomainUser__cancel_upgrade' => 'Zrušit převod účtu.',
    'upgradeDomainUser__confirm' => 'Potvrdit převod',
    'upgradeDomainUser__confirm_message' => 'Potvrdit pokračování převodu účtu',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Účty správce domény, které nelze převést',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Následující účty správce domény nebyly převedeny na zákaznické účty:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Několik účtů správce domény nebylo převedeno na zákaznické účty. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Účet správce domény neexistuje',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Doména musí patřit přímo správci serveru nebo prodejci.",
    'upgradeDomainUser__all_logins_already_used' => 'Pro výsledného zákazníka nelze vytvořit účet.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Účet správce domény byl převeden',
    'upgradeDomainUser__upgrade_notification_body' => 'Účet správce vaší domény byl převeden na účet zákazníka s přihlašovacím jménem \\&amp;apos;%%login%%\\&amp;apos; a heslem \\&amp;apos;%%password%%\\&amp;apos;.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Vybrat zákaznické účty',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Vybraný prodejce nemá oprávnění \\&amp;apos;%1\\&amp;apos;, ale někteří zákazníci mají toto oprávnění.',
    'clientOwnerChanger__application_not_allowed' => 'Aplikace \\&amp;apos;%1\\&amp;apos; není k dispozici pro vybraného prodejce ale je dostupná některým zákazníkům.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Změna přiřazení vybraných předplacených služeb',
    // errors
    'domain_chown__empty_selection' => 'Musíte vybrat nového vlastníka vybraných domén',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maximální využití šířky pásma (%1)',
    'hosting_performance__max_connection_label' => 'Připojení omezena na',
    'performance__invalid_value' => "Hodnota je neplatná. Musí být v rozsahu %1 až %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Dostupní klienti pro webové rozhraní pošty',
    'webmail__none' => 'Žádné',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Fond IP adres serveru',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Databáze nebude obnovena: neexistuje vhodný databázový server',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Záloha serveru.",
    '__default_backup_comment_reseller' => "Záloha účtu prodejce vytvořená prostřednictvím %1.",
    '__default_backup_comment_client' => "Záloha účtu zákazníka vytvořená prostřednictvím %1.",
    '__default_backup_comment_domain' => "Záloha předplatného vytvořená prostřednictvím %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Fond IP adres zákazníka %1",
    'backup__ip_mapping__resellers_ip' => "Fond IP adres prodejce %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtuální hostitel',
    'backup__restore__object_plesk_admin' => 'Správce prostředí Plesk',
    'backup__restore__object_ftpuser' => 'Účet FTP',
    'backup__restore__object_frontpageuser' => 'Účet Frontpage',
    'backup__restore__object_webuser' => 'uživatel webu',
    'backup__restore__object_domain' => 'doména',
    'backup__restore__object_subdomain' => 'subdoména',
    'backup__restore__object_domainalias' => 'alias domény',
    'backup__restore__object_client' => 'zákazník',
    'backup__restore__object_reseller' => 'prodejce',
    'backup__restore__object_autoresponder' => 'Automatická odpověď',
    'backup__restore__object_mailalias' => 'e-mailový alias',
    'backup__restore__object_database' => 'databáze',
    'backup__restore__object_mailname' => 'poštovní účet',
    'backup__restore__object_db_user' => 'uživatel databáze',
    'backup__restore__object_ssl_certificate' => 'Certifikát SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Tyto prodejce nelze obnovit, protože byli převedeni na zákazníky: \\&amp;apos;%1\\&amp;apos;.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Tyto zákazníky nelze obnovit, protože byli převedeni na prodejce: \\&amp;apos;%1\\&amp;apos;.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Tyto zákazníky nelze obnovit, protože se přesunuli k jinému vlastníkovi: \\&amp;apos;%1\\&amp;apos;.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Nedostatek místa na disku na cílovém serveru pro přenos všech vybraných předplatných. K dispozici: %1 MB. Požadováno: %2 MB. Pamatujte si, že požadované místo se vypočítá jako součet webu, e-mailu a obsahu databáze domény. Požadované místo se vypočítá jednou za den a uloží do mezipaměti, takže skutečná velikost domény se může od vypočítané velkosti lišit. Pokud se ujistíte, že vybrané domény nezaberou více místa, než je k dispozici, můžete pokračovat v přenosu.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Uvolněte místo na disku na cílovém serveru.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Nedostatek místa na disku na zdrojovém serveru k ukládání dočasných souborů pro přenos. K dispozici: %1 MB. Požadováno: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Uvolněte místo na disku na zdrojovém serveru.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Informace o serveru',

    'backup__restore__capability_not_installed_component_text' => 'Součást %1 není na cílovém serveru registrována. %1 bude pro všechny obnovené objekty nedostupná.',
    'backup__restore__capability_not_installed_component_resolution' => 'Nainstalujte %1. Pamatujte si, že tato operace může trvat několik minut.',
    'backup__restore__capability_existing_sys_user_text' => 'Na cílovém serveru již existuje uživatel systému s názvem %1.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Na cílovém serveru přejmenujte stávajícího uživatele systému.',
    'backup__restore__capability_license_usage_text' => 'Následující limity prostředků (definované licenčním klíčem) budou po přenosu dat na cílovém serveru překročeny:',
    'backup__restore__capability_license_usage_resolution' => 'Na cílovém serveru nainstalujte další licenční klíč, který poskytuje požadované množství prostředků.',
    'backup__restore__capability_max_allowed_packet_text' => "Parametr \\&amp;apos;max_allowed_packet\\&amp;apos; na serveru zdrojové databáze je %1, což je vyšší než na serveru cílovém, kde je %2. Obnovení některých objektů databáze pro níže specifikovanou doménu nemusí být možné.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Na serveru cílové databáze zvyšte hodnotu \\&amp;apos;max_allowed_packet\\&amp;apos;.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Nelze předat databáze PostgreSQL, protože verze PostgreSQL na cílovém serveru je starší, než na zdrojovém serveru. Aktuální verze je %1, požadovaná verze je %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Na cílový server nainstalujte požadovanou verzi PostgreSQL.',
    'backup__restore__capability_db_server_connection_problems' => 'Nelze se připojit k cílovému databázovému serveru PostgreSQL. Databáze nebudou přeneseny, dokud nebude obnoveno připojení.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Zkontrolujte nastavení připojení na serveru cílové databáze.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Součást %1 je na cílovém serveru vypnuta.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Zapněte %1 na cílovém serveru.',
    'backup__restore__capability_not_configured_component_text' => 'Součást %1 není nakonfigurována na cílovém serveru.',
    'backup__restore__capability_not_configured_component_resolution' => 'Na stránce Nástroje a nastavení proveďte konfiguraci %1.',

    'backup__restore__capability_webmail_is_not_available' => 'Webové rozhraní pošty %1 není na cílovém serveru k dispozici. Plesk místo toho použije následující webové rozhraní pošty: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Chcete-li použít stejné webové rozhraní pošty jako na zdrojovém serveru, měli byste ho nainstalovat na tento server.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Chcete-li použít stejné webové rozhraní pošty jako na zdrojovém serveru, měli byste ho nainstalovat na cílový server.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Webové rozhraní pošty \\&amp;apos;%1\\&amp;apos; není na cílovém serveru k dispozici. Místo toho v následujícím předplatném: %3 Plesk použije následující webové rozhraní pošty: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Na cílový server nainstalujte požadované webové rozhraní pošty',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Nastavení webového rozhraní pošty',

    'backup__restore__capability_shell_is_not_available' => 'Prostředí %1 je na cílovém serveru nedostupné. Místo něj se použije jedno z dostupných prostředí.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Chcete-li použít stejné prostředí jako na zdrojovém serveru, měli byste jej zapnout (pod položkou /etc/shells) nebo nainstalovat na cílovém serveru.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Cílový server DNS nepodporuje sítě v šabloně omezení přenosu. Záznamy se síťovými IP adresami v omezení přenosu DNS nebudou obnoveny.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Cílový server DNS nepodporuje sítě v šabloně omezení přenosu, ale některé předplacené služby mají sítě v omezení přenosu DNS. Záznamy se síťovými IP adresami v omezení přenosu DNS nebudou obnoveny.',

    'backup__restore__capability_wrong_php_handler_text' => 'Obslužná rutina PHP %1 není na cílovém serveru k dispozici. Plesk místo toho použije následující obslužnou rutinu PHP: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Chcete-li použít stejnou obslužnou rutinu PHP jako na zdrojovém serveru, měli byste ji zapnout nebo nainstalovat na cílový server.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Obslužná rutina PHP %1 není k dispozici. Plesk místo toho použije %2 pro následující plány služeb: {{objekty}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Obslužná rutina PHP %1 není k dispozici. Plesk místo toho použije %2 pro následující weby: {{objekty}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Obslužný program PHP %1 není k dispozici. Nebude k dispozici pro následující weby: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 není na cílovém serveru k dispozici. Místo toho se použije výchozí verze.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Chcete-li použít stejné %1 jako na zdrojovém serveru, měli byste jej zapnout nebo nainstalovat na cílovém serveru.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Zásady použití antiviru na cílovém serveru nepovolují osobní (podle e-mailové adresy) nastavení antiviru pro odchozí poštu. Tato nastavení nebudou přenesena.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Zásady použití antiviru na cílovém serveru nepovolují osobní (podle e-mailové adresy) nastavení antiviru pro příchozí poštu. Tato nastavení nebudou přenesena.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Zásady použití antiviru na cílovém serveru neumožňují osobní (podle e-mailové adresy) nastavení antiviru. Tato nastavení nebudou přenesena.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Chcete-li přenést osobní (podle e-mailové adresy) nastavení antiviru, pod položkou Nástroje a nastavení> Nastavení antivirové ochrany zapněte odpovídající možnosti.",
    'backup__restore__capability_antivirus_not_active_text' => 'Není zapnutý žádný antivirový software. Veškerá nastavení antiviru ze zdrojového serveru nebudou funkční, dokud na cílovém serveru nevyberete antivirový software.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Antivirový software vyberte v části Nástroje a nastavení > Nastavení antivirové ochrany > Nastavení antiviru.',

    'backup__restore__capability_antivirus_another_active_text' => 'Antivirový software %2 není na cílovém serveru k dispozici. Místo něj se použije %1.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Chcete-li použít stejný antivirus jako na zdrojovém serveru, nainstalujte ho a vyberte pod položkou Nástroje a nastavení> Nastavení antivirové ochrany> Nastavení antiviru.',
    'backup__restore__capability_not_available_sni_text' => 'Na cílovém serveru není k dispozici SN. Weby, které mají stejnou IP adresu, nebudou moci použít individuální  certifikáty SSL/TLS.',
    'backup__restore__capability_not_available_sni_resolution' => "Ověřte si, zda operační systém na cílovém serveru podporuje SNI a v prostředí Plesk je zapnuta podpora pro SNI (zaškrtávací políčko 'Zapnout podporu SNI, která umožňuje použití individuálních certifikátů SSL/TLS na webech se stejnou IP adresou' pod položkou Nástroje a nastavení> Nastavení serveru).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Nastavení serveru',

    'backup__restore__capability_vhost_already_exists_text' => 'Web %1 nelze přenést: na cílovém serveru již existuje web se stejným názvem.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Web se stejným názvem přejmenujte nebo odeberte ze serveru.',
    'backup__restore__capability_removed_vhosts' => 'Následující předplacené služby nebudou obnoveny, protože obsahují názvy domén, které již existují na cílovém serveru: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Na zdrojovém serveru jsou %3 rozdílné obslužné rutiny PHP typu %1 a verze %2. Místo nich se na cílovém serveru použijte jedna obslužná rutina odpovídajícího typu a verze. Pamatujte si, že nastavení PHP na zdrojovém a cílovém serveru se může lišit.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Instalační program Plesk nepodporuje Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Instalační program Plesk nepodporuje Python. Nainstalujte Python ručně.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Nastavení e-mailového serveru',

    'backup__restore__capability_ftps_disabled' => 'Použití zabezpečeného FTPS je dovoleno na zdrojovém serveru, ale zakázáno na cílovém. Uživatelské aplikace používající FTP nemusí pracovat správně.',
    'backup__restore__capability_ftps_required' => 'Použití nezabezpečeného FTP je dovoleno na zdrojovém serveru, ale zakázáno na cílovém. Uživatelské aplikace používající FTP nemusí pracovat správně.',
    'backup__restore__capability_ftps_policy_resolution' => 'Změnit Zásady zabezpečení FTP pod položkou Nástroje a nastavení> Zásady zabezpečení.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabajtů dat se přesune ze zdrojového serveru na cílový během %2 hodin.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Kvůli rychlejšímu přenosu zkontrolujte síťové připojení mezi zdrojovým a cílovým serverem a vyřešte problémy (pokud existují).',
    'backup__restore__too_low_download_speed' => "Méně než 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Kvůli rychlejšímu přenosu zkontrolujte síťové připojení mezi zdrojovým a cílovým serverem a vyřešte problémy (pokud existují).',
    'backup__restore__capability_zero_download_speed_text' => 'Minimální přijatelná rychlost stahování je %1 Mb/s. Rychlost stahování mezi zdrojovým a cílovým serverem je 0 MB/s. Příčinou mohou být problémy se síťovým připojením. Přenos není možný.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Zkontrolujte síťové připojení mezi zdrojovým a cílovým serverem a vyřešte problémy.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Minimální přijatelná rychlost stahování je %2 Mb/s. Rychlost stahování mezi zdrojovým a cílovým serverem je %1 MB/s. To může dobu přenosu prodloužit. V aktuálním prostředí zabere migrace %3 MB %4 hodiny.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Minimální přijatelná rychlost stahování je %2 Mb/s. Rychlost stahování mezi zdrojovým a cílovým serverem je %1 MB/s. To může dobu přenosu prodloužit.',

    'backup__restore__capability_remote_database_migration' => "Následující domény používají vzdálené databáze: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Pokud je na zdrojovém serveru verze Plesk starší než 11.5, neodebírejte tyto domény ze zdrojového serveru! Místo toho je pozastavte. Pokud domény odeberete, databáze budou ze vzdáleného serveru odebrány. Poznámka: Soubory výpisu vzdálených databází budou uloženy na zdrojovém serveru v adresáři %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Záložní soubory databázového serveru MySQL předcházející verzi 5.1 (%1) nemusí být obnoveny na MySQL 5.1.x, protože MySQL 5.1.x zpracovává znaky Unicode odlišně.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Čtěte související článek znalostní báze #136850',

    'backup__restore__capability_courier_not_installed_text' => 'Na cílovém serveru není nainstalován Courier-IMAP.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Pomocí instalačního programu Plesk nainstalujte Courier-IMAP.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Na cílovém serveru není nainstalován Dovecot.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Pomocí instalačního programu Plesk nainstalujte Dovecot.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Doba uchování statistik přenosu v konfiguraci následujících objektů je kratší, než hodnota na cílovém serveru (platná pro celý server).',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Změňte hodnotu (platnou pro celý server) doby uchování statistik na cílovém serveru. Tuto dobu nastavte stejnou nebo kratší, než je nejmenší hodnota v konfiguraci domény\\&amp;apos;.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Doba pro uchování statistik přenosu na některých doménách je kratší, než hodnota platná pro celý server (%1). Hodnota se pro tyto domény změní na %1.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Doba pro uchování statistik přenosu na některých plánech služeb je kratší, než hodnota platná pro celý server (%1). Hodnota se pro tyto plány služeb změní na %1.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Mapováním výhradní IP adresy na sdílenou se vypne anonymní přístup FTP a HTTPS (dokud se nezapne podpora SNI).',

    'backup__restore__no_postgresql_commands_text' => 'Předplatné používá vzdálenou databázi PostgreSQL a její dočasný soubor zálohy nelze vygenerovat, protože příkazy pg_dump a psql na zdrojovém serveru chybí.',
    'backup__restore__no_postgresql_commands_resolution' => 'Nainstalujte klientský balíček PostgreSQL, který tyto příkazy podporuje.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Následující moduly Apache jsou na cílovém serveru %1 vypnuty.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Povolte tyto moduly, abyste zabránili možným problémům.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Následující moduly Apache nejsou na cílovém serveru %1 nainstalovány.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Nainstalujte a povolte tyto moduly, abyste zabránili možným problémům.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Omezení odchozích zpráv není podporováno vaší licencí. Odpovídající nastavení konfigurace nebudou přenesena.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Na cílovém serveru nainstalujte další licenční klíč, který poskytuje požadované funkce.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Omezení odchozích zpráv je na cílovém serveru vypnuto. Odpovídající nastavení konfigurace nebudou přenesena.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Na cílovém serveru zapněte omezení odchozích zpráv.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Nastavení pošty pro celý server',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Omezení odchozích zpráv z poštovní schránky domény není podporováno e-mailovým serverem, který se používá na cílovém serveru. Hodnota tohoto omezení nebude přenesena.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Změňte e-mailový server stejným způsobem, jako používáte na zdrojovém serveru.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Nastavení pošty pro celý server',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Omezení odchozích zpráv z domény není podporováno e-mailovým serverem, který se používá na cílovém serveru. Hodnota tohoto omezení nebude přenesena.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Změňte e-mailový server stejným způsobem, jako používáte na zdrojovém serveru.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Nastavení pošty pro celý server',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Omezení odchozích zpráv z předplatného není podporováno e-mailovým serverem, který se používá na cílovém serveru. Hodnota tohoto omezení nebude přenesena.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Změňte e-mailový server stejným způsobem, jako používáte na zdrojovém serveru.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Nastavení pošty pro celý server',

    'bu_conflict_resolver_absent_phosting' => 'Nelze obnovit zadané soubory, protože fyzický hosting pro jejich obnovení neexistuje. Nejprve vytvořte doménu s fyzickým hostingem a poté znovu spusťte obnovu zálohy?',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Data prodejce nelze obnovit, protože správa prodejců není podporována.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Součást ModSecurity není nainstalována na cílovém serveru.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Pokud chcete uchovat webovou aplikační bránu firewall v činnosti pro přenesené weby, nainstalujte režim ModSecurity. Pamatujte si, že instalace může trvat několik minut.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Pokud chcete přenést nastavení webové aplikační brány firewall, nainstalujte režim ModSecurity. Pamatujte si, že instalace může trvat několik minut.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Součást ModSecurity není nakonfigurována na cílovém serveru.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Pokud chcete uchovat webovou aplikační bránu firewall v činnosti pro přenesené weby, nakonfigurujte režim ModSecurity.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Webová aplikační brána firewall (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'Režim ModSecurity je na cílovém serveru vypnutý.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Pokud chcete uchovat webovou aplikační bránu firewall v činnosti pro přenesené weby, aktivujte režim ModSecurity.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Webová aplikační brána firewall (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Součást ModSecurity není nainstalována. Nastavení webové aplikační brány firewall se neobnoví pro následující objekty {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Weby nelze obnovit, protože patří k předplatnému %1, které nebylo nalezeno v prostředí Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Součást %1 není na cílovém serveru registrována. Služba DNS bude nedostupná a nastavení DNS bude ztraceno. Všechny weby zákazníků\\&amp;apos; budou vypnuty.',
    'bu_conflict_resolver_dns_not_installed' => 'Služba DNS není nainstalována. Nastavení DNS se neobnoví pro následující objekty {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Tyto předplacené služby nelze obnovit, protože byly přesunuty k jiným vlastníkům: \\&amp;apos;%1\\&amp;apos;',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Tyto předplacené služby nelze obnovit, protože byly přesunuty k jiným poskytovatelům: \\&amp;apos;%1\\&amp;apos;',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Nelze najít nástroj 0 k obnovení dat z aplikace Web Presence Builder. Zdá se, že Web Presence Builder není nainstalován.',
    'backup__restore__capability_renamed_db' => 'Název databáze "%1" již používá jiné předplatné. Název obnovené databáze se změní na "%2".',
    'backup__restore__capability_renamed_db_user' => 'Jméno uživatele databáze "%1" již používá jiné předplatné. Jméno uživatele obnovené databáze se změní na "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Instalační program Plesk nepodporuje jazyk Perl. Nainstalujte ActiveState Perl ručně.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% obsluhovaná prostřednictvím Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% obsluhovaná prostřednictvím nginx (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Antivirus Kaspersky',
    '__drweb' => 'Antivirus Odin Premium',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Konflikty využití prostředků',
    'backup__restore__hint_resource_usage_conflicts' => 'Konflikty využití prostředků nastanou, pokud při obnovení dojde k překročení limitů využití prostředků obnoveného objektu.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Povolit nadměrné využití',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Obnovte objekt a umožněte mu, aby využil více prostředků, než bylo původně poskytnuto.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Neobnovovat',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Neobnovujte objekty, které mají konflikty využití prostředků.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konflikty konfigurace',
    'backup__restore__hint_configuration_conflicts' => 'Konflikty konfigurace nastanou, když má obnovený objekt nastavení a webové aplikace, které nejsou k dispozici nebo jsou aktuálním serverem nebo zásadami vlastníka objektu zakázány. Konflikty konfigurace například nastanou, pokud mají obnovené e-mailové účty individuální nastavení filtrování nevyžádané pošty, zatímco aktuální zásady platné pro celý server tato nastavení e-mailovým účtům zakazují.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automaticky',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Obnovte objekt a automaticky zapněte všechny možnosti konfliktní konfigurace, k jejichž správě máte oprávnění.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Neobnovovat',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Neobnovujte objekty, které mají konflikty konfigurace.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Vyhrazené fondy aplikací služby IIS nejsou povoleny v nastavení fondu aplikací služby IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Nastavení fondu aplikací služby IIS změňte v nabídce Nástroje a nastavení> Fond aplikací služby IIS> Globální nastavení.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Sdílené fondy aplikací služby IIS nejsou povoleny v nastavení fondu aplikací služby IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Nastavení fondu aplikací služby IIS změňte v nabídce Nástroje a nastavení> Fond aplikací služby IIS> Globální nastavení.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Na cílovém serveru nejsou povoleny krátké názvy e-mailových účtů POP3/IMAP.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Po obnovení dat nebudou pro e-mailové účty k dispozici krátké názvy.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Nelze otevřít soubor protokolu.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Nelze obnovit předplatné %1: bylo odebráno z vašeho účtu a vy nemáte oprávnění vytvářet předplatné. Pokud ho potřebujete obnovit, kontaktujte poskytovatele služby.',

    'backup__error11' => 'Na disku není dostatek místa pro zálohu.',
    'backup__error3011' => 'Spojení bylo odmítnuto: na specifikované adrese a portu neposlouchají žádné programy.',
    'backup__error3012' => 'Časový limit připojení.',
    'backup__error3013' => 'Síť je nedosažitelná.',
    'backup__error3014' => 'Žádná cesta k hostiteli.',
    'backup__error3015' => 'Připojení selhalo.',
    'backup__error3016' => 'Nelze rozpoznat název hostitele.',
    'backup__error3017' => 'Nesprávné uživatelské jméno nebo heslo',
    'backup__error3018' => 'Připojení SSH se nezdařilo.',

    'backup__error3110' => 'Ke vzdálenému migračnímu agentu se nelze připojit: Připojení k hostiteli není k dispozici.',
    'backup__error3111' => 'Migrační agent je uzamčen nezdařenou úlohou migrace nebo se používá při dalším migračním procesu. Restartujte migračního agenta na zdrojovém serveru.',
    'backup__error3112' => 'Připojení k hostiteli není k dispozici nebo migrační agent není na hostiteli zdroje spuštěn.',
    'backup__error3113' => 'Na hostitele Linux nelze nasadit migračního agenta. Zkontrolujte připojení SSH na hostiteli zdroje.',
    'backup__error3114' => 'Na hostitele Linux nelze nasadit migračního agenta. Připojení SSH se nezdařilo.',
    'backup__error3115' => 'Nesprávné uživatelské jméno nebo heslo',
    'backup__error3116' => 'Zadaný uživatel nemá oprávnění pro správu.',

    'dns_t__unable_to_remove_ns_record' => 'Nelze odebrat záznam NS ze šablony DNS: Každá zóna DNS musí mít nejméně jeden záznam NS.',
    'dns__unsupported_server_zone_transfer' => 'Kvůli konfiguraci domény DNS pro celý server nelze předat šablonu omezení přenosu: Na zdrojovém serveru jsou následující síťové adresy povoleny pro přenos zóny, ale tyto adresy zakázal server Microsoft DNS: %1',
    'dns__unsupported_domain_zone_transfer' => 'Kvůli konfiguraci domény \\&amp;apos; DNS nelze předat šablonu omezení přenosu: Na některých doménách jsou následující síťové adresy povoleny pro přenos zóny, ale tyto adresy zakázal server Microsoft DNS: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Sdílený dočasný síťový adresář pro soubory zálohy není přístupný. Zkontrolujte nastavení síťového adresáře, přihlašovacího jména a hesla. Chyba: %1.',

    'migration_select_exist_db_server' => 'Vyberte server cílové databáze',

    'dbbackup__temp_dir_wrong_value' => 'Byla zadána neplatná hodnota pro dočasný adresář.',
    'dbbackup__network_temp_dir_wrong_value' => 'Byla zadána neplatná hodnota pro dočasný síťový adresář.',
    'dbbackup__server_backup_not_configured' => 'Nastavení zálohování databáze není na serveru nakonfigurováno.',
    'dbbackup__temp_dir' => 'Dočasná složka',
    'dbbackup__temp_dir_hint' => 'Cesta k fyzické složce na vzdáleném serveru, kde je umístěn server MS SQL. Server MS SQL musí mít přístup k této složce ke čtení a zápis dočasných záložních souborů. Například C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Cesta ke sdílení sítě namapována na výše zadanou fyzickou složku. Plesk bude přistupovat ke sdílené složce kvůli stahování a nahrávání souborů zálohy. Například \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Uživatelské jméno uživatele sítě vytvořené na vzdáleném serveru. Například ServerName\\UserName. Uživatel musí mít přístup do výše zadané sdílené složky.',
    'dbbackup__network_password_hint' => 'Heslo uživatele sítě',

    'dbbackup__success_import_without_dublicate_users' => 'Následující uživatelé nebyli importováni: %1. Již existují na databázovém serveru.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Komprimovat soubory protokolu",
    'log_rot__log_rot_status' => "Stav rotace protokolů",
    'log_rot__log_rot_period' => "Podmínka rotace souboru protokolu",
    'log_rot__log_rot_size' => "podle velikosti",
    'log_rot__log_rot_time' => "podle času",
    'log_rot__logrotation_enable' => "Zapnout rotaci souborů protokolu",
    'log_rot__mail' => "Odeslat zpracované soubory protokolu na e-mail",
    'log_rot__max_number_of_logfiles' => "Maximální počet souborů protokolu",
    'log_rot__time_period' => "interval",
    'log_rot__unable_turn_off' => 'Nelze vypnout rotaci souboru protokolu, protože je vynucena na úrovni serveru',
    'log_rot__unable_set_period' => 'Nelze nastavit interval rotace souboru protokolu odlišný od \'daily\', protože je vynucen na úrovni serveru',
    'log_rot__unable_set_max_log_files' => 'Nelze nastavit maximální počet souborů protokolu vyšší než je limit celého serveru %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Očekáváno číslo: %1",
    'actionlog__incorrect_rotation' => "Byly zadány neplatné parametry rotace souborů protokolu: %1",
    'actionlog__unknown_rot_period' => "Neznámý interval rotace: %1",
    'actionlog__unknown_rot_type' => "Neznámý typ rotace: %1",
    'actionlog__session_preferences' => 'Nastavení relace',
    // items (PFU schema)
    'actionlog__admin_info' => 'Informace správce',
    'actionlog__admin_preferences' => "Předvolby správce",
    'actionlog__service' => 'Služba',
    'actionlog__ip_addr' => 'IP adresa',
    'actionlog__client' => 'Účet zákazníka',
    'actionlog__client_status' => 'Stav účtu zákazníka',
    'actionlog__client_preferences' => "Předvolby rozhraní zákazníka",
    'actionlog__client_ip_pool' => "Fond IP adres zákazníka",
    'actionlog__client_siteapp' => "Fond webových aplikací zákazníka",
    'actionlog__client_guid' => "Identifikátor GUID zákazníka",
    'actionlog__domain' => 'Výchozí doména (první doména přidaná do předplatného)',
    'actionlog__domain_owner' => 'Vlastník předplacené služby',
    'actionlog__domain_plan' => 'Plán předplacené služby',
    'actionlog__domain_status' => 'Výchozí doména, stav',
    'actionlog__domain_dns' => 'Výchozí doména, zóna DNS',
    'actionlog__subdomain' => 'Subdoména výchozí domény',
    'actionlog__domain_alias' => 'Výchozí doména, alias',
    'actionlog__domain_alias_dns' => 'Výchozí doména, alias zóny DNS',
    'actionlog__site' => 'Doména',
    'actionlog__site_status' => 'Stav domény',
    'actionlog__site_dns' => 'Zóna DNS domény',
    'actionlog__site_guid' => 'Identifikátor GUID domény',
    'actionlog__site_subdomain' => 'Subdoména',
    'actionlog__site_alias' => 'Alias domény',
    'actionlog__site_alias_dns' => 'Zóna DNS aliasu domény',
    'actionlog__domain_limits' => 'Limity odebírání',
    'actionlog__domain_limit_size' => 'Limit prostoru na disku pro předplacenou službu',
    'actionlog__domain_limit_traffic' => 'Limit přenosu dat pro předplacenou službu',
    'actionlog__domain_limits_powerUser' => 'Limity odebírání',
    'actionlog__domain_limit_size_powerUser' => 'Limit prostoru na disku pro předplacenou službu',
    'actionlog__domain_limit_traffic_powerUser' => 'Limit přenosu dat pro předplacenou službu',
    'actionlog__domain_guid' => "Výchozí doména, GUID",
    'actionlog__cp_user' => 'Uživatel Plesk',
    'actionlog__mailname' => 'Poštovní účet',
    'actionlog__maillist' => 'Seznam adresátů',
    'actionlog__phosting' => 'Nastavení hostování',
    'actionlog__forwarding' => 'Standardní hosting nebo hosting s rámcovým přesměrováním',
    'actionlog__webuser' => 'Účet webového uživatele',
    'actionlog__site_application' => 'Webová aplikace',
    'actionlog__license' => 'Licenční klíč',
    'actionlog__additional_license' => 'Další licenční klíč',
    'actionlog__template_domain' => "Plán služby prodejce",
    'actionlog__template_admin' => "Plán služby správce",
    'actionlog__template_reseller' => 'Plán prodejce',
    'actionlog__admin_alias' => 'Další účet správce', // PFW
    'actionlog__ftpuser' => 'Další účet FTP', // PFW
    'actionlog__db_server' => 'Databázový server',
    'actionlog__db' => 'Databáze',
    'actionlog__db_user' => 'Účet uživatele databáze',
    'actionlog__client_sapppkg_pool' => "Webová aplikace uživatele", // PFW, not used?
    'actionlog__remote_dns' => 'Stav vzdáleného DNS serveru', // PFW
    'actionlog__reseller' => 'Účet prodejce',
    'actionlog__reseller_guid' => 'Identifikátor GUID prodejce',
    'actionlog__reseller_ip_pool' => "Fond IP adres prodejce",
    'actionlog__reseller_limit_size' => 'Limitu prostoru na disku pro účet prodejce',
    'actionlog__reseller_limit_traffic' => 'Limit přenosu dat pro účet prodejce',
    'actionlog__reseller_limits' => 'Limity účtu prodejce',
    'actionlog__reseller_permissions' => 'Oprávnění prodejce',
    'actionlog__reseller_preferences' => "Předvolby rozhraní prodejce",
    'actionlog__reseller_siteapp' => "Webové aplikace ve fondu prodejce",
    'actionlog__reseller_status' => 'Stav účtu prodejce',
    'actionlog__health_status' => 'Stav serveru',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'dosaženo',
    'actionlog__added' => 'přidáno',
    'actionlog__removed' => 'odebráno',
    'actionlog__change' => 'změněno',
    'actionlog__update' => 'aktualizováno',
    'actionlog__move' => 'přesunuto',
    'actionlog__upgrade' => 'upgradováno', // PFU?
    'actionlog__update_or_add' => 'aktualizováno nebo přidáno',
    'actionlog__expired' => 'platnost vypršela',
    'actionlog__create' => 'vytvořeno',
    'actionlog__delete' => 'odstraněno',
    'actionlog__service_stop' => 'zastavena',
    'actionlog__service_restart' => 'restartována',
    'actionlog__service_start' => 'spuštěna',
    'actionlog__login' => 'přihlášen',
    'actionlog__logout' => 'odhlášen',
    'actionlog__install' => 'nainstalováno',
    'actionlog__uninstall' => 'odinstalováno',
    'actionlog__reconfigure' => 'rekonfigurováno',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Požadavek na resetování hesla',
    'actionlog__event_admin_update' => 'Údaje správce byly aktualizovány',
    'actionlog__event_admin_preferences_update' => "Předvolby správce byly aktualizovány",
    'actionlog__event_service_restart' => 'Služba byla restartována',
    'actionlog__event_service_start' => 'Služba je spuštěna',
    'actionlog__event_service_stop' => 'Služba je zastavena',
    'actionlog__event_ip_address_create' => 'IP adresa byla vytvořena',
    'actionlog__event_ip_address_delete' => 'IP adresa byla odstraněna',
    'actionlog__event_ip_address_update' => 'IP adresa byla aktualizována',
    'actionlog__event_client_create' => 'Vytvořen účet zákazníka',
    'actionlog__event_client_delete' => 'Odstraněn účet zákazníka',
    'actionlog__event_client_update' => 'Aktualizován účet zákazníka',
    'actionlog__event_client_status_update' => 'Aktualizován stav účtu zákazníka',
    'actionlog__event_client_preferences_update' => "Aktualizovány předvolby rozhraní zákazníka",
    'actionlog__event_client_siteapp_added' => "Webová aplikace přidána k fondu aplikací účtu zákazníka",
    'actionlog__event_client_siteapp_removed' => "Webová aplikace odebrána z fondu aplikací účtu zákazníka",
    'actionlog__event_domain_limit_size_reached' => 'Bylo dosaženo limitu prostoru na disku pro předplacenou službu',
    'actionlog__event_domain_limit_traffic_reached' => 'Bylo dosaženo limitu přenosu dat pro předplacenou službu',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Bylo dosaženo limitu prostoru na disku pro předplacenou službu',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Bylo dosaženo limitu přenosu dat pro předplacenou službu',

    'actionlog__domain_limit_database' => 'Kvóta databází pro předplacenou službu',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Bylo dosaženo kvóty databází MySQL pro předplacenou službu',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Bylo dosaženo doporučené kvóty databáze MySQL pro předplacenou službu',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Bylo dosaženo kvóty databází serveru Microsoft SQL pro předplacenou službu',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Bylo dosaženo doporučené kvóty databáze serveru Microsoft SQL pro předplacenou službu',
    'actionlog__event_plesk_component_upgrade' => 'Součást prostředí Plesk byla aktualizována',
    'actionlog__event_plesk_component_install' => 'Byla nainstalována součást prostředí Plesk',
    'actionlog__event_plesk_component_uninstall' => 'Byla odinstalována součást prostředí Plesk',
    'actionlog__event_domain_create' => 'Výchozí doména (první doména přidaná do předplatného) vytvořena',
    'actionlog__event_domain_delete' => 'Výchozí doména (první doména přidaná do předplatného) vytvořena',
    'actionlog__event_domain_update' => 'Výchozí doména (první doména přidaná do předplatného) aktualizována',
    'actionlog__event_domain_owner_change' => 'Změnil se vlastník předplacené služby',
    'actionlog__event_domain_plan_change' => 'Plán předplacené služby se změnil',
    'actionlog__event_domain_status_update' => 'Výchozí doména, aktualizován stav',
    'actionlog__event_domain_dns_update' => 'Výchozí doména, aktualizována zóna DNS',
    'actionlog__event_subdomain_create' => 'Vytvořena subdoména výchozí domény',
    'actionlog__event_subdomain_delete' => 'Odstraněna subdoména výchozí domény',
    'actionlog__event_subdomain_update' => 'Aktualizována subdoména výchozí domény',
    'actionlog__event_domain_alias_create' => 'Výchozí doména, vytvořen alias',
    'actionlog__event_domain_alias_delete' => 'Výchozí doména, odstraněn alias',
    'actionlog__event_domain_alias_update' => 'Výchozí doména, aktualizován alias',
    'actionlog__event_domain_limits_update' => 'Aktualizovány limity předplacené služby',
    'actionlog__event_cp_user_login' => 'Uživatel Plesk je přihlášen',
    'actionlog__event_cp_user_logout' => 'Uživatel Plesk je odhlášen',
    'actionlog__event_mailname_create' => 'Vytvořen e-mailový účet',
    'actionlog__event_mailname_delete' => 'Odstraněn e-mailový účet',
    'actionlog__event_mailname_update' => 'Aktualizován e-mailový účet',
    'actionlog__event_maillist_create' => 'Byl vytvořen seznam adresátů',
    'actionlog__event_maillist_delete' => 'Seznam adresátů byl odstraněn',
    'actionlog__event_maillist_update' => 'Seznam adresátů byl aktualizován',
    'actionlog__event_phys_hosting_create' => 'Byl vytvořen fyzický hosting',
    'actionlog__event_phys_hosting_delete' => 'Fyzický hosting byl odstraněn',
    'actionlog__event_phys_hosting_update' => 'Fyzický hosting byl aktualizován',
    'actionlog__event_forwarding_create' => 'Byl vytvořen standardní hosting nebo hosting s rámcovým přesměrováním',
    'actionlog__event_forwarding_delete' => 'Standardní hosting nebo hosting s rámcovým přesměrováním byl odstraněn',
    'actionlog__event_forwarding_update' => 'Standardní hosting nebo hosting s rámcovým přesměrováním byl aktualizován',
    'actionlog__event_webuser_create' => 'Byl vytvořen účet webového uživatele',
    'actionlog__event_webuser_delete' => 'Účet webového uživatele byl odstraněn',
    'actionlog__event_webuser_update' => 'Účet webového uživatele byl aktualizován',
    'actionlog__event_siteapp_install' => 'Webová aplikace nainstalována',
    'actionlog__event_siteapp_reconfigure' => 'Nová konfigurace webové aplikace',
    'actionlog__event_siteapp_uninstall' => 'Webová aplikace odinstalována',
    'actionlog__event_license_update' => 'Licenční klíč byl aktualizován',
    'actionlog__event_admin_alias_create' => 'Byl vytvořen další účet správce',
    'actionlog__event_admin_alias_delete' => 'Další účet správce byl odstraněn',
    'actionlog__event_admin_alias_update' => 'Další účet správce byl aktualizován',
    'actionlog__event_ftpuser_create' => 'Vytvořen další účet FTP',
    'actionlog__event_ftpuser_update' => 'Aktualizován další účet FTP',
    'actionlog__event_ftpuser_delete' => 'Odstraněn další účet FTP',
    'actionlog__event_template_domain_create' => "Vytvořen plán služby prodejce",
    'actionlog__event_template_domain_update' => "Aktualizován plán služby prodejce",
    'actionlog__event_template_domain_delete' => "Odstraněn plán služby prodejce",
    'actionlog__event_template_admin_create' => "Vytvořen plán služby správce",
    'actionlog__event_template_admin_update' => "Aktualizován plán služby správce",
    'actionlog__event_template_admin_delete' => "Odstraněn plán služby správce",
    'actionlog__event_database_server_create' => 'Databázový server byl vytvořen',
    'actionlog__event_database_server_update' => 'Databázový server byl aktualizován',
    'actionlog__event_database_server_delete' => 'Databázový server byl odstraněn',
    'actionlog__event_remote_dns_status_update' => 'Stav vzdáleného DNS serveru byl aktualizován',
    'actionlog__event_session_preferences_update' => 'Nastavení relace bylo aktualizováno',
    'actionlog__event_domain_alias_dns_update' => 'Výchozí doména, aktualizována zóna DNS aliasu domény',
    'actionlog__event_domain_move' => 'Výchozí doména byla přesunuta na nové předplatné',
    'actionlog__event_site_move' => 'Doména byla přesunuta na nové předplatné',
    'actionlog__event_site_subdomain_move' => 'Subdoména byla přesunuta na nové předplatné',
    'actionlog__event_subdomain_move' => 'Subdomény výchozí domény byla přesunuta na nové předplatné',
    'actionlog__event_license_expired' => 'Licence Plesk vypršela',
    'actionlog__event_database_create' => 'Vytvořena databáze',
    'actionlog__event_database_delete' => 'Odebrána databáze',
    'actionlog__event_database_user_create' => 'Byl vytvořen účet uživatele databáze',
    'actionlog__event_database_user_update' => 'Bylo aktualizováno nastavení účet uživatele databáze',
    'actionlog__event_database_user_delete' => 'Byl odebrán účet uživatele databáze',
    'actionlog__event_client_guid_update' => "Aktualizován identifikátor GUID zákazníka",
    'actionlog__event_domain_guid_update' => 'Výchozí doména, aktualizován identifikátor GUID',
    'actionlog__event_reseller_create' => 'Vytvořen účet prodejce',
    'actionlog__event_reseller_delete' => 'Odstraněn účet prodejce',
    'actionlog__event_reseller_update' => 'Aktualizován účet prodejce',
    'actionlog__event_reseller_guid_update' => 'Aktualizován identifikátor GUID prodejce',
    'actionlog__event_reseller_ip_pool_update' => "Aktualizován fond IP adres prodejce",
    'actionlog__event_reseller_limit_size_reached' => 'Bylo dosaženo limitu prostoru na disku pro účet prodejce',
    'actionlog__event_reseller_limit_traffic_reached' => 'Bylo dosaženo limitu přenosu dat pro účet prodejce',
    'actionlog__event_reseller_limits_update' => 'Aktualizovány limity účtu prodejce',
    'actionlog__event_reseller_permissions_update' => 'Aktualizována oprávnění účtu prodejce',
    'actionlog__event_reseller_preferences_update' => "Aktualizovány předvolby rozhraní prodejce",
    'actionlog__event_reseller_siteapp_added' => "Aplikace přidána k fondu aplikací účtu prodejce",
    'actionlog__event_reseller_siteapp_removed' => "Aplikace odebrána z fondu aplikací účtu prodejce",
    'actionlog__event_reseller_status_update' => 'Aktualizován stavu účtu prodejce',
    'actionlog__event_template_reseller_create' => 'Vytvořen plán prodejce',
    'actionlog__event_template_reseller_delete' => 'Odstraněn plán prodejce',
    'actionlog__event_template_reseller_update' => 'Aktualizován plán prodejce',
    'actionlog__event_health_status_change' => 'Změnil se stav serveru',
    'actionlog__event_siteapp_upgrade' => 'Webová aplikace byla aktualizována na vyšší verzi',
    'actionlog__event_extension_install' => 'Rozšíření nainstalováno',
    'actionlog__event_extension_uninstall' => 'Rozšíření odinstalováno',
    'actionlog__event_extension_upgrade' => 'Rozšíření upgradováno',
    'actionlog__event_extension_status_update' => 'Stav rozšíření aktualizován',
    'actionlog__event_additional_license_expired' => 'Platnost další licence vypršela',
    'actionlog__event_hostname_changed' => 'Název hostitele serveru se změnil',
    'actionlog__event_smb_user_create' => 'Vytvořen další uživatel',
    'actionlog__event_smb_user_delete' => 'Další uživatel odstraněn',
    'actionlog__event_smb_user_update' => 'Další uživatel aktualizován',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Na vzdáleném hostiteli není nainstalováno rozhraní API RPC. Obraťte se na svého poskytovatele služeb s žádostí o pomoc.",
    'rsession_no_account_errmsg' => "Nelze získat přístup ke vzdálené službě pod vaším účtem.  Nejobvyklejší příčinou je, že služba není pro váš účet dosud aktivována.  Počkejte několik minut a poté akci zopakujte. Pokud k této chybě dojde znovu, obraťte se na správce systému.",
    'rsession_no_domain_errmsg' => "Nelze získat přístup ke vzdálené službě pro tuto doménu. Nejobvyklejší příčinou je, že služba pro tuto doménu není dosud aktivována. Počkejte několik minut a poté akci zopakujte. Pokud k této chybě dojde znovu, obraťte se na správce systému.",
    'rsession_unknown_errmsg' => "Vzdálený server zamítl pokus o uskutečnění relace. O podporu požádejte svého správce systému. Chyba byla: %1",
    'rsession_unknown2_errmsg' => "Neznámá chyba při navazování vzdálené relace. Vzdálený server s největší pravděpodobností neodpovídá správně nebo neodpovídá vůbec. Požádejte svého správce systému o kontrolu podrobností týkajících se chyby v protokolu chyb webového serveru.",
    'rsession_no_connect_errmsg' => "Nelze získat přístup ke vzdálené službě : připojení ke vzdálené relaci selhalo. O podporu požádejte svého správce systému.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Povolit přenos do příchozího adresáře",
    'anonftp__allow_create_dirs' => 'Povolit vytvoření adresářů v příchozím adresáři',
    'anonftp__allow_download_incoming' => 'Povolit stahování z příchozího adresáře',
    'anonftp__display_login' => 'Zobrazit přihlašovací zprávu',
    'anonftp__login_text' => 'Text zprávy',
    'anonftp__limit_incoming_disk_space' => "Omezit prostor na disku v příchozím adresáři",
    'anonftp__limit_maximum_bandwidth' => "Omezit šířku pásma stahování pro tuto virtuální FTP doménu",
    'anonftp__limit_maximum_connections' => "Omezit počet souběžných připojení",
    'anonftp__unable_init' => "Nelze inicializovat anonymní FTP účet: %1",
    'anonftp__unable_set_quota' => "Nelze nastavit limit diskového prostoru v příchozím adresáři: %1",
    'anonftp__unable_update' => "Nelze aktualizovat vlastnosti anonymního FTP účtu: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Certifikáty SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "Certifikát CA nepodepíše certifikát.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Nekompatibilní pár soukromý klíč/certifikát.",
    'class_sslcertificate__invalid_cert_format' => "Neplatný formát certifikátu.",
    'class_sslcertificate__invalid_private_key_format' => "Neplatný formát soukromého klíče.",
    'class_sslcertificate__prob_invalid_priv_key' => "Formát soukromého klíče je nejspíše neplatný.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Vytvořit virtuální adresář',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Vytvořit virtuální adresář',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Vytvořit virtuální adresář.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Vytvořit virtuální adresář',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Vytvořit virtuální adresář',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Vytvořit virtuální adresář.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Vytvořit adresář',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Vytvořit adresář',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Vytvořit adresář.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Vytvořit adresář',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Vytvořit adresář',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Vytvořit adresář.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Vlastnosti adresáře',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Vlastnosti virtuálního adresáře',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Zobrazit a změnit vlastnosti virtuálního adresáře.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Vlastnosti adresáře',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Vlastnosti virtuálního adresáře',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Zobrazit a změnit vlastnosti virtuálního adresáře.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Přístupová oprávnění k adresáři',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Přístupová oprávnění k adresáři',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Nastavit přístupová oprávnění k adresáři.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Přístupová oprávnění k adresáři',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Přístupová oprávnění k adresáři',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Nastavit přístupová oprávnění k adresáři.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Nastavení ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Nastavení ASP.NET pro %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Konfigurovat nastavení ASP.NET pro virtuální adresář %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Nastavení ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Nastavení ASP.NET pro %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Konfigurovat nastavení ASP.NET pro virtuální adresář %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Nastavení PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Nastavení PHP pro %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Konfigurovat nastavení PHP pro virtuální adresář %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Nastavení PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Nastavení PHP pro %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Konfigurovat nastavení PHP pro virtuální adresář %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Odebrat',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Odebrat virtuální adresáře',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Odebrat vybrané virtuální adresáře.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Odebrat',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Odebrat virtuální adresáře',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Odebrat vybrané virtuální adresáře.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Následující virtuální adresáře budou odebrány:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Musíte vybrat adresáře, které chcete odebrat.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Zobrazit seznam registrovaných typů MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Přidat typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Přidat typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Registrovat nový typ MIME.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Chybové dokumenty',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Chybové dokumenty',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Zobrazit a změnit chybové dokumenty.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Ochrana',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Ochrana adresáře',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Omezit práva pro přístup k adresáři ochranou heslem.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Ochrana',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Ochrana adresáře',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Omezit práva pro přístup k adresáři ochranou heslem.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Nastavení',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Zobrazit umístění adresáře a zadat titul pro chráněnou oblast.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Uživatelská nastavení',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Přidat uživatele',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Přidat uživatele',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Přidat uživatelský účet umožňující přístup do chráněného adresáře.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Bylo použito nové nastavení.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Byl přidán uživatelský účet.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Odebrat',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Odebrat uživatele chráněného adresáře.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Odebrat uživatelské účty',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Potvrdit odebrání uživatelských účtů.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Uživatelské účty byly odebrány.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Operace byla úspěšně dokončena.',
    'ui__admin/extras-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__admin/report/layout/delete_multi__done' => 'Vybraná rozvržení sestav sestavy byla odebrána.',
    'ui__admin/report/traffic-history__done' => 'Operace byla úspěšně dokončena.',
    'ui__admin/report__done' => 'Operace byla úspěšně dokončena.',
    'ui__admin-alias/delete_multi__done' => "Vybrané další účty správce byly odebrány.",
    'ui__admin-alias/properties__done' => "Vlastnosti dalšího účtu správce byly aktualizovány.",
    'ui__admin-alias/properties_new__done' => "Byl vytvořen další účet správce.",
    'ui__admin-alias/properties_unknown__done' => "Vlastnosti dalšího účtu správce byly aktualizovány.",
    'ui__admin-alias__done' => "Informace o dalším účtu správce byly úspěšně aktualizovány.",
    'ui__admin/manage-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__admin/register-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Vybrané plány doručení sestav byla odebrány.',
    'ui__admin/report/layout/auto/properties__done' => 'Plán doručení sestavy bylo aktualizován.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Byl vytvořen plán doručení sestavy.',
    'ui__client/domain/certificate/properties__done' => 'Vlastnosti certifikátu SSL/TLS byly aktualizovány.',
    'ui__client/domain/certificate/properties_new__done' => 'Byl přidán nový certifikát SSL/TLS. Aby byla zaručena činnost, nezapomeňte ho vybrat v nastavení hostování webu (záložka Weby a domény> název domény).',
    'ui__client/domain/certificate__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/certificate_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/chowner__done' => 'Předplatné %1 nyní patří jinému uživateli.',
    'ui__client/domain/chowner_multi__done' => 'Vlastnictví předplatného se změnilo.',
    'ui__client/domain/chowner_multi-select__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/chowner_select__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/dbbackup/create__done' => "Databáze byla úspěšně zálohována.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Databáze byla úspěšně zálohována.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Osamocený uživatel byl úspěšně opraven.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Soubory zálohy byly úspěšně odebrány.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Obsah databáze byl úspěšně obnoven.", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operace byla úspěšně dokončena.", // PFW
    'ui__client/domain/dbbackup__done' => "Operace byla úspěšně dokončena.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operace byla úspěšně dokončena.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operace byla úspěšně dokončena.", // PFW
    'ui__client/domain/delete__done' => "Doména %1 byla odebrána.",
    'ui__client/domain/delete_multi__done' => "Domény byly odebrány.",
    'ui__client/domain/disable__done' => 'Doména %1 byla pozastavena.',
    'ui__client/domain/disable_multi__done' => 'Vybrané domény byly pozastaveny.',
    'ui__client/domain/enable__done' => 'Webové stránky %1 byly aktivovány.',
    'ui__client/domain/enable_multi__done' => 'Vybrané weby byly aktivovány.',
    'ui__client/domain/extras__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/domain/extras_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Nastavení rotace souborů protokolu se změnilo.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Nastavení rotace souborů protokolu se změnilo.',
    'ui__client/domain/hosting/logs__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/hosting/logs_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/hosting/setup__done' => 'Byl nakonfigurován hosting pro %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Verze ASP.NET se změnila.', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operace byla úspěšně dokončena.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operace byla úspěšně dokončena.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Nastavení ASP.NET pro %1 se změnilo.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Virtuální adresář byl vytvořen pod webem %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Virtuální adresář byl vytvořen.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Vybrané adresáře byly odebrány.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Vybrané adresáře byly odebrány.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Vlastní chybové dokumenty byly aktualizovány.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Vybrané typy MIME byly odebrány', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Byl zaregistrován nový typ MIME.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operace byla úspěšně dokončena.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Přístupová oprávnění k adresáři byla aktualizována.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Přístupová oprávnění k adresáři byla aktualizována.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Nastavení PHP pro %1 bylo aktualizováno.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Nastavení PHP pro %1 bylo aktualizováno.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Vlastnosti adresáři byly aktualizovány.', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Vlastnosti adresáři byly aktualizovány.', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Nastavení ochrany adresáře bylo aktualizováno.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Nastavení ochrany adresáře bylo aktualizováno.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operace byla úspěšně dokončena.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Operace byla úspěšně dokončena.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Certifikáty SSL/TLS jsou k dispozici v online obchodě',
    'ui__client/domain/mpc-certificates_self__done' => 'Certifikáty SSL/TLS jsou k dispozici v online obchodě',
    'ui__client/domain/register__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/domain/register_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/domain/rename__done' => 'Název domény se změnil.',
    'ui__client/domain/rename_self__done' => "Název domény byl úspěšně změněn.",
    'ui__client/domain/settings_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/toggle_disable__done' => "Doména %1 byla pozastavena.",
    'ui__client/domain/toggle_enable__done' => "Doména %1 byla aktivována.",
    'ui__client/domain/traffic__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/traffic_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain/traffic_unknown__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain-summary-report__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain-summary-report_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/domain-summary-report_unknown__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/extras-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/extras-domain_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/ipaddress/delete_multi__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/ipaddress/properties__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/ipaddress/properties_new__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/ip-pool/properties__done' => "Fond IP adres zákazníka %1 byl aktualizován.",
    'ui__client/ip-pool/properties_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/limits__done' => "Limity prostředků pro zákazníka %1 byly změněny.",
    'ui__client/limits_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/logo__done' => 'Pro zákazníka %1 bylo použito nové nastavení brandingu.',
    'ui__client/logo_reseller__done' => 'Byl použit nový panel nastavení brandingu.',
    'ui__client/logo_self__done' => 'Bylo použito nastavení brandingu.',
    'ui__client/logo_self-reseller__done' => 'Byl použit váš panel nastavení brandingu.',
    'ui__client/manage-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/manage-domain_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/permissions__done' => "Oprávnění zákazníka %1 se změnilo.",
    'ui__client/permissions_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/preferences__done' => "Předvolby pro zákazníka %1 byly změněny.",
    'ui__client/preferences_self__done' => "Vaše předvolby se změnily.",
    'ui__client/register-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/register-domain_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__client/report/traffic-history__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/report/traffic-history_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/report__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/report_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/sessions/delete__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/sessions/delete_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/sessions__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/sessions_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/skeleton__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/skeleton_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__client/traffic__done' => "Operace byla úspěšně dokončena.",
    'ui__client/traffic_unknown__done' => 'Operace byla úspěšně dokončena.',
    'ui__cp-access__done' => 'Operace byla úspěšně dokončena.',
    'ui__cp-session/properties__done' => 'Operace byla úspěšně dokončena.',
    'ui__cp-session__done' => 'Operace byla úspěšně dokončena.',
    'ui__ftp-sessions__done' => 'Operace byla úspěšně dokončena.',
    'ui__license__done' => 'Operace byla úspěšně dokončena.',
    'ui__logo__done' => "Vlastnosti brandingu prostředí Plesk se změnily.",
    'ui__longtasks/longtask/properties__done' => "Nastavení úloh na pozadí bylo úspěšně změněno.",
    'ui__mass-email/delete__done' => "Šablona zpráv %1 byla odebrána.", // PFW
    'ui__mass-email/delete_multi__done' => "Šablony zpráv byly odebrány.",  // PFW
    'ui__mass-email/send_main__done' => "Operace byla úspěšně dokončena.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Zákaznické účty byly úspěšně vybrány.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Účty správce domény byly úspěšně vybrány.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Účty prodejce byly úspěšně vybrány.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Změny šablony hromadných e-mailových zpráv byly uloženy.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Byla vytvořena šablona hromadných e-mailových zpráv.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Byly vybrány zákaznické účty pro šablonu hromadných e-mailových zpráv.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Byly vybrány účty správce domény pro šablonu hromadných e-mailových zpráv.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Byly vybrány účty prodejce pro šablonu hromadných e-mailových zpráv.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Šablona hromadných e-mailových zpráv se změnila.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Byly zadány neplatné hodnoty.', // PFW
    'ui__mass-email__done' => "Operace byla úspěšně dokončena.", // PFW
    'ui__mass-mail__done' => "Operace byla úspěšně dokončena.", // PFU
    'ui__mass-mail/delete__done' => 'Šablona zpráv %1 byla odebrána.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Šablony zpráv byly odebrány.', // PFU
    'ui__mass-mail/properties__done' => 'Šablona %1 se změnila.', // PFU
    'ui__mass-mail/properties_new__done' => 'Šablona %1 byla vytvořena.', // PFU
    'ui__mass-mail/send__done' => 'Zprávy byly odeslány.', // PFU
    'ui__mass-mail/send_new__done' => 'Zprávy byly odeslány.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Zprávy byly odeslány.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Zprávy byly odeslány.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Byla vytvořena nová šablona zprávy.', // PFU
    'ui__mass-mail/template/properties__done' => 'Šablona zpráv se změnila.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Bylo použito nové nastavení sledování disku.', // PFU
    'ui__modules__done' => 'Operace byla úspěšně dokončena.',
    'ui__modules__short-title' => 'Rozšíření',
    'ui__modules__title' => 'Rozšíření',
    'ui__reseller/client/traffic_unknown__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/extras-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__reseller/extras-domain_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__reseller/ftp-sessions_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/limits__done' => "Limity prostředků prodejce a zásady využití prostředků se změnily.",
    'ui__reseller/limits_readonly-self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/limits_self__done' => 'Vaše limity prostředků a zásady využití prostředků se změnily.',
    'ui__reseller/manage-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__reseller/manage-domain_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__reseller/permissions__done' => 'Oprávnění prodejce %1 se změnilo.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/register-domain__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__reseller/register-domain_self__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Vybrané plány doručení sestav byla odebrány.',
    'ui__reseller/report/layout/auto/properties__done' => 'Plán doručení sestavy bylo aktualizován.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Byl přidán plán doručení sestavy.',
    'ui__reseller/report/traffic-history__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/report/traffic-history_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/report__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/report_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/sessions/delete__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/sessions/delete_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/sessions__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/sessions_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/traffic__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/traffic_self__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/traffic_unknown__done' => 'Operace byla úspěšně dokončena.',
    'ui__reseller/logo_self__title' => 'Branding prostředí Plesk',
    'ui__reseller/logo_self__done' => 'Bylo použito vaše nastavení brandingu Plesk.',
    'ui__server/aspdotnet__done' => 'Nastavení ASP.NET celého serveru se změnilo.', // PFW
    'ui__server/certificate/default_multi__done' => 'Vybraný certifikát SSL/TLS byl nastaven tak, aby se dal použít k zabezpečení připojení k nově hostovaným webům.',
    'ui__server/certificate/delete_multi__done' => 'Vybrané certifikáty SSL/TLS byly odebrány.',
    'ui__server/certificate/download__done' => 'Certifikát SSL/TLS byl stažen.',
    'ui__server/certificate/properties__done' => 'Vlastnosti certifikátu SSL/TLS byly aktualizovány.',
    'ui__server/certificate/properties_new__done' => 'Vytvořen certifikát SSL/TLS %1.',
    'ui__server/certificate/setup_multi__done' => 'Vybraný certifikát SSL/TLS byl nastaven, aby se dal použít k zabezpečení připojení k prostředí Plesk.',
    'ui__server/certificate__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/cp-certificate-download__done' => "Plesk certifikát SSL/TLS byl stažen.",
    'ui__server/crontab/properties__done' => 'Naplánované úlohy z %1 byly změněny.',
    'ui__server/crontab/task/delete__done' => 'Úloha byla odebrána.',
    'ui__server/crontab/task/delete_multi__done' => 'Úlohy byly odebrány.',
    'ui__server/crontab/task/properties__done' => 'Naplánované úlohy byly aktualizovány.',
    'ui__server/crontab/task/properties_new__done' => 'Nová úloha byla naplánována.',
    'ui__server/crontab/task/toggle_disable__done' => 'Naplánovaná úloha %1 byla zakázána.',
    'ui__server/crontab/task/toggle_enable__done' => 'Naplánovaná úloha %1 byla povolena.',
    'ui__server/crontab__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/dns__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/ip-address/client/delete__done' => "IP adresa byla odebrána z fondu IP adres uživatele.",
    'ui__server/ip-address/client/delete_multi__done' => "IP adresa byla odebrána z fondů IP adres uživatelů.",
    'ui__server/ip-address/client/properties_new__done' => 'IP adresa byla přiřazena uživatelům.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP adresa %1 byla přiřazena k vybraným zákazníkům.',
    'ui__server/ip-addresses__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/spam/summary__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/spam__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/virus/summary__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics/virus__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail/statistics__done' => "Operace byla úspěšně dokončena.",
    'ui__server/mail__done' => 'Nastavení e-mailového serveru se změnilo.',
    'ui__server/maillists__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/mpc-certificates__done' => 'Byla otevřena stránka online obchodu uvádějící dostupné certifikáty SSL/TLS.',
    'ui__server/pmm__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/preferences__done' => "Nastavení serveru se změnilo.",
    'ui__server/register__done' => 'Stránka MyPlesk.com byla otevřena.',
    'ui__server/services__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/sitebuilder__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/skeleton__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Adresa %1 byla odebrána z černé listiny pro celý server.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Adresy byly odebrány z černé listiny pro celý server.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adresy byly přidány na černou listinu.',
    'ui__server/spam-filter/black-list/address__done' => 'Adresy byly přidány na černou listinu.',
    'ui__server/spam-filter/black-list__done' => 'Operace byla úspěšně dokončena.', // PFU
    'ui__server/spam-filter/properties__done' => 'Nastavení filtru nevyžádané pošty se změnilo.',
    'ui__server/spam-filter/toggle_disable__done' => 'Filtrování nevyžádané pošty bylo v celém systému zakázáno.',
    'ui__server/spam-filter/toggle_enable__done' => 'Filtrování nevyžádané pošty bylo v celém systému povoleno.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Adresa %1 byla odebrána z bílé listiny pro celý server.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Adresy byly odebrány z bílé listiny pro celý server.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adresy byly přidány na bílou listinu.',
    'ui__server/spam-filter/white-list/address__done' => 'Adresy byly přidány na bílou listinu.',
    'ui__server/spam-filter/white-list__done' => 'Operace byla úspěšně dokončena.', // PFU
    'ui__server/spam-filter__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/statistics__done' => 'Operace byla úspěšně dokončena.',
    'ui__server/time__done' => "Systémový datum a čas se změnily.",
    'ui__server__done' => "Operace byla úspěšně dokončena.",
    'ui__sessions/properties__done' => 'Operace byla úspěšně dokončena.',
    'ui__sessions__done' => 'Operace byla úspěšně dokončena.',
    'ui__sessions/delete__done' => 'Vybrané relace byly odstraněny.',
    'ui__support__done' => 'Formulář žádosti o pomoc byl otevřen v novém okně prohlížeče nebo záložky.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Žádné soubory k odeslání.',
    'login_up__access_denied_no_permission' => "Přístup odepřen. K přihlášení nemáte oprávnění.",
    'mail__unable_remove_pattern' => "Nelze odebrat adresu z černé listiny serveru: %1", // PFW
    'mail__incorrect_network_format' => 'Nesprávný formát sítě: %1', // PFW
    'initconf__unable_change_passwd' => "Nelze změnit heslo správce: %1",
    'initconf__unable_get_passwd' => 'Nelze získat aktuální heslo správce: %1 se nezdařilo: %2',
    'initconf__invalid_hostname' => 'Chyba v názvu hostitele "%1"',
    'initconf__unable_reconfig' => 'Nelze konfigurovat prostředí Plesk: reconfig se nezdařila: %1',
    'initconf__unable_update_admin' => 'Nelze aktualizovat informace o kontaktech správce: %1',
    '__refresh' => 'Obnovit',
    '__dalias_not_exist' => 'Alias domény neexistuje.',
    '__bug146523_explanation' => 'Předchozí verze prostředí Plesk umožňovaly použít pro přihlašovací jména FTP až 16 znaků. Tato verze prostředí Plesk omezuje maximální počet povolených znaků pro přihlašovací jména FTP na 15. Chcete-li tento problém vyřešit, omezte přihlašovací jméno FTP na 15 znaků a v ovlivněných přihlašovacích jménech FTP změňte nejméně jeden znak, aby nedocházelo ke kolizím. Omlouváme se za možné nepříjemnosti způsobené touto změnou.',
    'domain__cannot_change_webmail' => 'Nelze změnit webové rozhraní pošty pro doménu: %1',
    'sb_publish_disable_warning' => 'Pokud v systému Presence Builder vypnete vytváření webové stránky, dříve vytvořený web v systému Presence Builder bude odebrán a všechny data webu budou ztracena. Klikněte na OK, pokud chcete pokračovat.',
    '__sbnet_client_use_sbnet' => "Vytvořit odpovídající účet uživatele v systému Presence Builder",
    'mail_resp_activate' => 'Aktivovat automatickou odpověď',
    'limitsManger__limit_available_error' => 'Nelze alokovat požadované množství prostředků ("%%limitName%%"): pro váš účet je dostupné pouze %%available%%.',
    'limitsManger__limit_reserved_error' => 'Nelze alokovat méně prostředků ("%%limitName%%") než se již používá.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Nelze přejmenovat doménu: virtuální adresář se zadaným názvem již existuje.',
    'domain_unable_to_rename' => 'Nelze přejmenovat doménu.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Obecné',
    'spamfilter__spamassassin_status_legend' => 'Filtrování nevyžádané pošty SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Nastavení SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Zapnout filtrování nevyžádané pošty SpamAssassin na celém serveru",
    'spamfilter__spamassassin_user_status_legend' => 'Zapnout filtrování nevyžádané pošty SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Zapnout antispamovou ochranu Greylisting na celém serveru',
    'spamfilter__personal_settings_not_allowed' => 'Použití individuálního nastavení filtru nevyžádané pošty není podle zásad serveru povoleno.',
    'spamfilter__required_score' => 'Výsledek, který musí zpráva obdržet, aby byla kvalifikována jako nevyžádaná',
    'spamfilter__rewrite_header_subject' => 'Přidat následující text na začátek předmětu každé zprávy vyhodnocené jako nevyžádaná',
    'spamfilter__use_mailuser_prefs' => 'Použít individuální nastavení pro filtrování nevyžádané pošty',
    'spamfilter__score_error' => 'Výsledek měl by neměl být záporný, část před desetinnou tečkou musí být menší než 100 a nesmí obsahovat více než dvě číslice za desetinnou čárkou.',
    'spamfilter__rewrite_header_error' => 'Předmět zprávy může obsahovat veškeré tisknutelné znaky kromě symbolu čísla (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Vrátit',
    'nonexistent_mail__mode_discard' => 'Zahodit',
    'nonexistent_mail__mode_catch_addr' => 'Předat na e-mailovou adresu',
    'nonexistent_mail__mode_catch_ip' => 'Předat na IP',
    'nonexistent_mail__bounce_not_supported' => 'Režim nedoručitelnost pošty není podporován.',
    'nonexistent_mail__discard_not_supported' => 'Režim Zahodit není podporován.',
    'nonexistent_mail__catch_not_supported' => 'Předávání na e-mailovou adresu není podporováno',
    'nonexistent_mail__redirect_not_supported' => 'Předávání na IP není podporováno',
    'nonexistent_mail__ip_used_on_this_host' => 'IP adresa přeložena na localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Protože je zabezpečení odchozí pošty zapnuto, e-mailová adresa %1 pro neexistující příjemce by měla patřit na vybranou doménu. Pokud ne, místo předávání se použije zásada "Zamítnout".',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Protože je zabezpečení odchozí pošty zapnuto, e-mailová adresa zadaná pro předávání pošty (%1) by měla patřit na vybranou doménu. Pokud ne, potom se zprávy odeslané na tuto adresu nebudou započítávat do Zabezpečení odchozí pošty.',
    // mail acc extras
    '__antivirus' => "AntiVirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Nejsou k dispozici žádné další účty správce.', // PFW
    'ui__client/domain/certificate__none-available' => 'Zákazník nemá certifikáty SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Zákazník nemá domény s certifikáty SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Doména nemá žádné certifikáty SSL/TLS.',
    'ui__reseller/client__none-available' => 'Žádní prodejci se zákazníky.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Musíte vybrat IP adresy, které chcete odebrat z fondu IP adres.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Musíte vybrat účty prodejce, z jejichž fondů IP adres chcete odvolat IP adresu.',
    'ui__server/crontab/task/delete__empty_selection' => 'Musíte vybrat úkol, který chcete zrušit.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Podpora PHP je pro tento web vypnuta.',
    'phosting__aspdotnet_not_enabled' => 'Podpora ASP.NET je pro tento web vypnuta.',
    'phosting__php_forced_by_site_isolation' => 'Nelze změnit nastavení PHP: oprávnění k přepisu zásad zabezpečení pro celý server není uděleno.',
    'phosting__option_forced_by_site_isolation' => 'Nelze změnit nastavení %1: oprávnění k přepisu zásad zabezpečení pro celý server není uděleno.',
    'phosting__php_handler_id_not_registered' => 'V nastavení izolace webu není povolena obslužná rutina PHP. Použije se výchozí obslužná rutina PHP.',
    'phosting__php_served_by_nginx_is_not_available' => 'Obslužná rutina PHP (aplikace FPM obsluhovaná prostřednictvím nginx) není povolena v nastavení izolace webu. Použije se výchozí obslužná rutina PHP.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Zobrazit seznam IP adres',
    'ui__client/ipaddress/properties_readonly__title' => 'Zobrazit seznam IP adres',
    'ui__client/ipaddress/properties_readonly__description' => 'Zobrazit seznam IP adres dostupných pro tohoto uživatele.',
    'ui__server/certificate__short-title' => 'Certifikáty SSL/TLS',
    'ui__server/certificate__title' => 'Certifikáty SSL/TLS',
    'ui__server/certificate__description' => 'Zobrazit a spravovat certifikáty SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Odebrat typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Odebrat typy MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Odebrat vybrané typy MIME.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Přidat typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Přidat typ MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registrovat typ MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Odebrat IP adresy',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Vybrat IP adresy, které chcete odebrat z fondu IP adres zákazníka %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP adresa',
    'ui__client/ipaddress__title' => 'IP adresa',
    'ui__client/ipaddress__description' => 'Zobrazit informace o IP adrese.',
    'ui__server/ip-address__short-title' => 'IP adresa',
    'ui__server/ip-address__title' => 'IP adresa',
    'ui__server/ip-address__description' => 'Zobrazit informace o IP adrese.',
    'ui__client/domain/hosting/setup__short-title' => 'Nastavení webhostingu',
    'ui__client/domain/hosting/setup__title' => 'Nastavení webhostingu',
    'ui__client/domain/hosting/setup__description' => 'Nastavení webhostingu pro web %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Typ MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Vlastnosti typu MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Zobrazit vlastnosti typu MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Chybový dokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Chybový dokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Vlastnosti chybového dokumentu.', // PFW

    // tooltips

    'b_get_password_cancel' => 'Návrat na předchozí obrazovku bez odesílání e‑mailu.',
    'b_get_password_send' => 'Kliknutím na OK odešlete zprávu pro obnovení hesla na e-mailovou adresu zaregistrovanou v systému.',



    'b_personaltrafficlist_search' => 'Zadejte parametry vyhledávání a kliknutím spusťte vyhledávání domén.',
    'b_personaltrafficlist_show_all' => 'Zobrazit všechny domény.',

    'b_back' => 'Návrat na předchozí stránku',
    'b_next' => 'Přejít na další stránku.',

    'b_dnsnstemplatelist_remove' => 'Odstranit vybrané názvové servery.',
    'b_dnsnstemplatelist_search' => 'Zadejte parametry vyhledávání a kliknutím spusťte vyhledávání názvových serverů.',
    'b_dnsnstemplatelist_show_all' => 'Zobrazit všechny názvové servery.',

    'l_dnsnstemplatelist_ns' => 'Seřadit záznamy šablony DNS podle názvového serveru.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Vytvořit zabezpečené odkazy na soubory a složky',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Povolit veřejné soubory',
    'cu__serverfilesharing_fsPublicFolder' => 'Složka k ukládání veřejných souborů',
    'cu__serverfilesharing_fsPublicUrl' => 'Adresa URL pro přístup návštěvníka k veřejným souborům',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Povolit ochranu heslem veřejných souborů',
    'cu__serverfilesharing_fsPartnerFolder' => 'Složka k ukládání souborů chráněných heslem',
    'cu__serverfilesharing_fsPartnersLogin' => 'Přihlašovací jméno pro přístup k souboru',
    'cu__serverfilesharing_fsPartnersPassword' => 'Heslo pro přístup k souboru',
    'cu__serverfilesharing_fsDomain' => 'Kořenová adresa URL webové složky. Název domény',
    'cu__serverfilesharing_fsPrefix' => 'Kořenová adresa URL webové složky. Předpona',
    'cu__serverfilesharing_commandUpdate' => 'Aktualizovat nastavení sdílení souborů',
    'cu__serverfilesharing_commandInfo' => 'Zobrazit aktuální nastavení sdílení souborů',
    'subscription_rename_is_forbidden' => 'Přejmenování předplacených služeb je podle zásad platných pro celý server zakázáno.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Spravovat naplánované úlohy na serveru',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Vyberte uživatele systému, jehož naplánované úlohy chcete spravovat.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Naplánovaná úloha %1',
    'ui__server/crontab/task__description' => 'Zobrazit vlastnosti naplánované úlohy %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Uživatelé systému',
    'ui__server/crontab_unknown__title' => 'Uživatelé systému',
    'ui__server/crontab_unknown__description' => 'Uživatelé systému, kteří mohou být vlastnící naplánovaných úloh.',


    'ui__server/crontab__none-available' => 'Nemáte žádné účty uživatele systému.',
    'ui__server/crontab_readonly-unknown__description' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Naplánované úlohy',
    'ui__server/crontab_readonly-unknown__title' => 'Zobrazit naplánované úlohy',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab_readonly__description' => 'Zobrazit naplánované úlohy %1.',
    'ui__server/crontab_readonly__short-title' => 'Naplánovaná úloha z %1',
    'ui__server/crontab_readonly__title' => 'Zobrazit naplánované úlohy %1',
    'ui__server/crontab_unknown__wizard-title' => 'Spravovat naplánované úlohy',

    'ui__server/crontab/properties__description' => 'Upravit naplánované úlohy z %1.',

    'ui__server/crontab/properties__short-title' => 'Nastavení',
    'ui__server/crontab/properties__title' => 'Upravit naplánované úlohy z %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Nastavení',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Zobrazit naplánované úlohy',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab/properties_readonly__description' => 'Zobrazit naplánované úlohy %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Nastavení',
    'ui__server/crontab/properties_readonly__title' => 'Zobrazit naplánované úlohy %1',
    'ui__server/crontab/properties_unknown__description' => 'Upravit naplánované úlohy.',
    'ui__server/crontab/properties_unknown__short-title' => 'Vlastnosti',
    'ui__server/crontab/properties_unknown__title' => 'Upravit naplánované úlohy',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Upravit naplánované úlohy.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Vyberte uživatele systému, jehož úlohy chcete vidět.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Vyberte uživatele systému, jehož úlohy chcete změnit.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Kliknutím na Dokončit proveďte změny a ukončete průvodce.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klepnutím na tlačítko Dokončit průvodce ukončíte.',

    'ui__server/crontab/task__none-available' => 'Nemáte žádné naplánované úlohy.',
    'ui__server/crontab/task__none-available__2' => 'Uživatel systému %1 nemá žádné naplánované úlohy.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Naplánované úlohy.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Úlohy',
    'ui__server/crontab/task_readonly-unknown__title' => 'Naplánované úlohy',

    'ui__server/crontab/task/delete__description' => 'Odebrat naplánovanou úlohu %1',

    'ui__server/crontab/task/delete__short-title' => 'Odebrat',
    'ui__server/crontab/task/delete__title' => 'Odebrat naplánovanou úlohu %1',
    'ui__server/crontab/task/delete_multi__description' => 'Odebrat naplánované úlohy.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Odebrat',
    'ui__server/crontab/task/delete_multi__title' => 'Odebrat naplánované úlohy',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Odebrat naplánované úlohy.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Vyberte uživatele systému, jehož úlohy chcete odebrat.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Vybrat úlohy, které chcete odebrat.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Zaškrtnutím políčka potvrďte odebrání úlohy a kliknutím na Dokončit ukončete průvodce.',
    'ui__server/crontab/task/delete_unknown__description' => 'Odebrat naplánovanou úlohu.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Odebrat',
    'ui__server/crontab/task/delete_unknown__title' => 'Odebrat naplánovanou úlohu',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Odebrat naplánovanou úlohu.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Vyberte uživatele systému, jehož úkol chcete odebrat.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Vybrat úlohu, kterou chcete odebrat.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Zaškrtnutím políčka potvrďte odebrání úlohy a kliknutím na Dokončit ukončete průvodce.',

    'ui__server/crontab/task/properties__description' => 'Upravit naplánované úlohy.',

    'ui__server/crontab/task/properties__short-title' => 'Upravit úlohu %1',
    'ui__server/crontab/task/properties__title' => 'Upravit naplánované úlohy',
    'ui__server/crontab/task/properties_new__description' => 'Vytvořit naplánované úlohy z %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Přidat úkol',
    'ui__server/crontab/task/properties_new__title' => 'Vytvořit naplánované úlohy z %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Vytvořit naplánovanou úlohu.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Vybrat uživatele systému, pro kterého chcete vytvořit naplánovanou úlohu.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Kliknutím na Dokončit proveďte změny a ukončete průvodce.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Vlastnosti',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Zobrazit naplánované úlohy',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab/task/properties_readonly__description' => 'Zobrazit naplánované úlohy.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Zobrazit úlohu %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Zobrazit naplánované úlohy',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Vytvořit naplánované úlohy.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Přidat úkol',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Vytvořit naplánované úlohy',
    'ui__server/crontab/task/properties_unknown__description' => 'Upravit naplánované úlohy.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Vlastnosti',
    'ui__server/crontab/task/properties_unknown__title' => 'Upravit naplánované úlohy',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Upravit naplánované úlohy.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Vyberte uživatele systému, jehož úlohy chcete vidět.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Vyberte uživatele systému, jehož úlohy chcete změnit.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Vybrat naplánovanou úlohu.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Vyberte naplánovanou úlohu, kterou chcete změnit.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Kliknutím na Dokončit proveďte změny a ukončete průvodce.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klepnutím na tlačítko Dokončit průvodce ukončíte.',

    'ui__server/crontab/task/toggle_disable__description' => 'Zakázat naplánovanou úlohu %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Zakázat',
    'ui__server/crontab/task/toggle_disable__title' => 'Zakázat naplánovanou úlohu %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Povolit naplánovanou úlohu %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Povolit',
    'ui__server/crontab/task/toggle_enable__title' => 'Povolit naplánovanou úlohu %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Povolit nebo zakázat naplánované úlohy.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Povolit či zakázat',
    'ui__server/crontab/task/toggle_unknown__title' => 'Povolit nebo zakázat naplánované úlohy',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Povolit nebo zakázat naplánované úlohy',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Vyberte účet uživatele systému, jehož úlohy chcete povolit nebo zakázat.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Vyberte úlohu, kterou chcete povolit či zakázat.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Zákaznické účty', // not used on HP?
    'ui__client_unknown__title' => 'Zákaznické účty', // not used on HP?
    'ui__client_unknown__description' => 'Spravovat zákaznické účty.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Pozastavit doménu', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Pozastavit doménu', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Pozastavit doménu.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktivovat doménu', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktivovat doménu', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktivovat doménu.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Účty FTP pod doménou %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Účty FTP",
    'ftp__user_name' => "Název účtu FTP",
    'ftp__user_home' => "Domovský adresář",
    'ftp__invalid_path' => "Byla zadána neplatná cesta",
    'i_ftp_ses_sub_user' => 'Relace účtu FTP.',
    '__new_passwd' => "Nové heslo %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Nelze konfigurovat webový server na hostiteli <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Nelze vytvořit konfigurační soubor webového serveru na hostiteli <%%host%%> kvůli následujícím chybám: %%error%% Vyřešte chyby v šablonách konfigurace webového serveru a vygenerujte soubor znovu.",

    'apacheConfigurationMessageAdminTitle' => 'Generování konfigurace webového serveru se nezdařilo',
    'apacheConfigurationMessageClientTitle' => 'Varování',

    'apacheConfigurationFailedAdminHomeMessage' => 'Nový konfigurační soubor nebyl vytvořen kvůli chybám v šablonách konfigurace. Podrobná chybová zpráva byla odeslána na váš e-mail. Zkontrolujte ji, opravte chyby a kliknutím na %1 zopakujte vytváření konfigurace.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'zde', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Nová konfigurace pro doménu %1 nebyla vytvořena kvůli chybám v šablonách konfigurace. Podrobná chybová zpráva byla odeslána na váš e-mail. Zkontrolujte ji, opravte chyby a kliknutím na %2 zopakujte vytváření konfigurace.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'zde', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Konfigurace webového serveru pro doménu %1 může být nekonzistentní. Požádejte správce serveru o vyřešení tohoto problému.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Nová konfigurace pro některé z domén nebyla vytvořena kvůli chybám v šablonách konfigurace. Podrobná chybová zpráva byla odeslána na váš e-mail. Zkontrolujte ji, opravte chyby a kliknutím na %1 zopakujte vytváření konfigurace.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'zde', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Konfigurace webového serveru pro některé z vašich domén může být nekonzistentní. Požádejte správce serveru o vyřešení tohoto problému.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Vlastní chybové dokumenty",
    'dom_pref__webusers_script' => "Povolit webovým uživatelům použití skriptů",
    '__seoRedirect' => 'Konfigurovat upřednostňovanou doménu jako',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Žádné',

    '__sites' => 'Domény',
    'domain_plan__perm_denied_manage_phosting' => 'Nemáte oprávnění spravovat nastavení hostingu.',
    '__owned_by_client' => 've vlastnictví zákazníka',
    'ui__client/permissions_readonly__description' => "Zobrazit akce, které může zákazník %1 uskutečnit v prostředí Plesk.",
    'backup__restore__object_client_template' => 'Šablona zákazníka',
    '__template_name' => 'Název plánu služeb',
    'template__not_exists' => 'Takový plán služeb neexistuje',
    'template__exists' => 'Plán s názvem %1 již existuje.',
    'clientOwnerChanger__ip_not_in_pool' => 'Zadaná IP adresa není ve fondu prodejce.',

    //// Change owner of subscription
    'chown__select_title' => "Vybrat nového odběratele",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Vyberte nového vlastníka pro vybrané předplacené služby a klikněte na Další>>.',
    'domains__client_info' => "%1 předplatné, %2 aktivní předplatné, %3 použité místo na disku, %4 využitý provoz",
    '__possible_owners' => 'Možní noví vlastníci předplatného',

    'clients_list__filter_owner__filter_title' => 'Poskytovatel',
    'clients_list__filter_owner_any' => 'Všichni uživatelé',
    'clients_list__filter_owner_my' => 'Pouze moji odběratelé',
    'clients_list__filter_owner_name__filter_title' => 'Jméno poskytovatele',

    '__owner' => "Poskytovatel",
    'l_clientslist_owner' => 'Seřadit uživatelské účty podle poskytovatele.',
    'l_clientslist_date' => 'Seřadit uživatelské účty podle data vytvoření.',
    'l_clientslist_name' => 'Seřadit uživatelské účty podle názvu.',
    'l_clientslist_domains' => 'Seřadit uživatelské účty podle domén.',
    'l_clientslist_cname' => 'Seřadit uživatelské podle názvu společnosti.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Změna přiřazení vybraných předplacených služeb',
    'chown__check_title' => 'Změnit účastníka',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Kliknutím na Dokončit uzavřete opětovné přiřazení. Po dokončení budou vybrané předplacené služby přiřazeny novému vlastníku, jejich poskytovatel se změní na poskytovatele nového vlastníka a budou odhlášeny od svých plánů služeb a přejdou do stavu \\&amp;apos;Custom\\&amp;apos;.",

    'chown__error_check' => 'Při pokusu přiřadit některé předplacené služby novému uživateli se vyskytly problémy.',
    'domain_chown_subscription_will_be_anonymous' => "Předplacené služby budou odhlášeny od svých aktuálních plánů služeb a přejdou do stavu \\&amp;apos;Custom\\&amp;apos;.",
    'chown__error_domains_exclude' => "Při pokusu přiřadit některé předplacené služby novému uživateli se vyskytly problémy. Tyto předplacené služby jsou zvýrazněny.",
    'chown__ip_not_in_client_pool' => "IP adresa přidružená k tomuto předplatnému nebyla přidána k fondu IP adres nového uživatele.",
    'chown__already_owned_by_client' => "Toto předplatné již patří tomuto uživateli.",

    '__redirect_hint' => 'Během 15 sekund budete přesměrováni na novou adresu... Pokud automaticky nepřejdete na nové umístění, zapněte JavaScript nebo klikněte na odkaz %%link%%.',

    'backup__restore__object_maillist' => 'Seznam adresátů',
    'backup__restore__object_site' => 'Web',
    'backup__restore__object_user' => 'Uživatel',
    'backup__restore__object_role' => 'Role',

    'limit__name_max_site' => 'weby',

    'iis_pool__unable_rename_client' => "Fond aplikací IIS nelze přejmenovat: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Služba anonymního FTP je podporována pouze pro hlavní doménu předplatného.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Služba anonymního FTP je podporována pouze pro hlavní doménu předplatného.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/měsíc',
    '__tb_month' => 'TB/měsíc',

    '__customers' => 'Zákazníci',
    '__customer_name' => 'Jméno zákazníka',
    '__customer_total' => 'Součet zákazníka',
    '__site' => 'Web',
    '__def_site' => 'Výchozí pracoviště',
    '__subscription_name' => 'Název předplacené služby',
    '__subscription_name_powerUser' => 'Název předplacené služby',

    'limit__units_max_traffic_suffix' => '/měsíc',

    'dom_pref__discard' => "Zamítnout",

    'mail__pattern_already_exists' => 'Šablona "%1" se již nachází na černé listině.',

    '__not_supported' => 'Není podporováno',

    'plesk_key__sitebuilder' => 'Weby publikované prostřednictvím systému Presence Builder',
    'limit__name_max_site_builder' => 'Weby publikované prostřednictvím systému Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Podpora pro vícejazyčné weby v systému Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Statistiky přenosu dat pro <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Statistiky přenosu dat pro <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Přenos dat prostřednictvím služeb",

    'login_up__access_denied_no_subscriptions' => "Přístup odepřen. Pro tento účet nejsou dostupné žádné předplacené služby.",

    'interval__day' => '%1 den(dny,dnů)',
    'interval__hour' => '%1 hodina (hodiny)',
    'interval__minute' => '%1 minuta (minuty)',
    'interval__second' => '%1 sekunda (y)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Zkoušíte použít licenční klíč vytvořený pro jinou verzi prostředí Plesk. Chcete-li získat správný licenční klíč, kontaktujte obchodní zástupce společnosti Plesk.',
    //Standalone or virtualization
    'virtualization_any' => "Fyzický server nebo jakékoli virtualizační řešení",
    'virtualization_pvc' => "Kontejnery Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Technologie Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Server Virtuozzo",
    'plesk_key__virtualization' => "Platí pro následující prostředí:",
    'plesk_key__virtualization_only_key' => 'Licenční klíč je určen pouze pro použití v prostředí Plesk v rámci virtuálních prostředí %1',
    'plesk_key__virtualizations_only_key' => 'Licenční klíč je určen pouze pro použití v prostředí Plesk v rámci následujících virtuálních prostředí: %1',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Použití vlastního jazykového balíčku je zakázáno.',
    'plesk_key__allowed-locales' => 'Dostupné jazyky',
    'plesk_key__allowed-locales-any' => 'Kterýkoli jazyk',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'adresář cgi-bin je umístěn v',
    '_cgi_bin_mode_webspace' => 'kořenový adresář předplacené služby',
    '_cgi_bin_mode_www_root' => 'kořen dokumentu této domény',

    /// Custom buttons
    'custom_button__sort_key' => 'Priorita',
    'custom_button__place' => 'Umístění',
    'custom_button__place_navigation' => 'Obecný přístup',
    'custom_button__place_admin' => 'Domovská stránka správce',
    'custom_button__place_admin-settings' => 'Stránka Nástroje a nastavení správce',
    'custom_button__place_reseller' => "Domovská stránka prodejce",
    'custom_button__place_reseller-settings' => 'Stránka Nástroje a pomůcky prodejce',
    'custom_button__place_client' => 'Domovská stránka zákazníka',
    'custom_button__place_domain' => "Stránka Weby a domény předplacené služby",
    'custom_button__place_domain_powerUser' => "Stránka Weby a domény předplacené služby",
    'custom_button__place_domain-properties' => 'Nástroje webu',
    'custom_button__private' => 'Zobrazit pouze pro mě',
    'custom_button__image' => 'Obrázek na pozadí',
    'custom_button__conhelp' => "Text popisu",
    'custom_button__edit' => "Nastavení odkazu pro další službu",
    'custom_button__include_client_cname' => "Zahrnout název společnosti zákazníka",
    'custom_button__include_client_email' => "Zahrnout e-mail zákazníka",
    'custom_button__include_client_id' => "Zahrnout ID zákazníka",
    'custom_button__include_client_pname' => "Zahrnout název kontaktu zákazníka",
    'custom_button__include_domain_id' => "Zahrnout ID předplatného, ID domény a ID aliasu domény",
    'custom_button__include_domain_id_powerUser' => "Zahrnout ID předplatného, ID domény a ID aliasu domény",

    'custom_button__include_domain_name' => "Zahrnout primární název domény",
    'custom_button__include_ftp_user' => "Zahrnout přihlašovací jméno FTP",
    'custom_button__include_ftp_pass' => "Zahrnout heslo FTP",
    'custom_button__internal_open' => "Otevřít adresu URL v prostředí Plesk",
    'custom_button__text' => "Popisek tlačítka",
    'custom_button__url' => "Adresa URL",

    'custom_button__not_image' => 'Nejedná se o soubor obrázku.',
    'custom_button__big_image' => 'Velikost souboru nesmí přesáhnout 100 kB.',
    'custom_button__failed_copy_image' => 'Nelze zkopírovat soubor: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'V režimu zobrazení Power User (Zkušený uživatel) nelze obnovit zálohu běžného uživatele.',
    '__unknown_network_interface' => 'Neznámé síťové rozhraní',

    'init_conf__ip_address' => 'IP adresa',

    //Confirmation page
    'bt_confirm' => 'Potvrdit',
    'b_confirm' => 'Potvrdit vlastnictví webů.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Nastavení vyhrazeného fondu aplikací služby IIS se provádí podle zásad zabezpečení celého serveru (konfigurace izolace webu).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Nastavení vyhrazeného fondu aplikací služby IIS se provádí podle nastavení výkonu celého serveru.',

    '__current' => 'Současný',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Byly aktualizovány vlastnosti uživatele.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Použili jste téměř všechny weby, které vám byly poskytnuty s licencí Plesk (90 % nebo ještě více).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Využili jste téměř všechny domény.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Použili jste téměř všechny weby systému Presence Builder, které vám byly poskytnuty s Licencí Plesk (90 % nebo ještě více).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Použili jste téměř všechny weby systému Presence Builder.',
    'promo__button_hide' => 'Skrýt',
    'promo__button_next' => 'Další>>',
    'promo__button_prev' => '<< Předchozí',
    'promo__button_license' => 'Aktualizovat licenci',

    'promo__google_integration_title' => 'Integrace se službami Google',
    'promo__google_integration' => 'Konfigurovat integraci se službami Google, například AdSense, Google Apps, nástroje Webmaster.',
    'promo__google_integration_button' => 'Konfigurovat',

    'promo__button_learn_more' => 'Další info',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Vzhled rozhraní a nastavení brandingu lze přizpůsobit prostřednictvím vlastních motivů. Pokyny týkající se přizpůsobení motivů prostředí Plesk, viz %1.',
    'panel_branding__description_link' => 'následující dokument',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Extrahovat soubory',
    'b_filemanager__extract' => 'Extrahovat soubory z vybraných archivů do aktuálního adresáře. Pamatujte si, že pokud názvy souborů obsahují národní znaky, mohou se po extrakci zobrazovat nesprávně.',
    'filemanager_error_extracting_files' => 'Při extrahování souborů archivu došlo k chybě: %1',
    'filemanager_no_archive_files_specified' => 'Zadejte archiv, který chcete rozbalit.',
    'filemanager_not_zip_archive_specified' => '%1 nelze rozbalit, nejedná se o ZIP archív.',
    'filemanager_files_successfully_extracted' => 'Soubory archivu byly rozbaleny.',
    'filemanager_error_file_download' => 'Stažení souboru se nezdařilo: %1',
    'filemanager__user_poolgrp' => 'Skupina fondů aplikací',

    'loading' => 'Načítání...',
    'bt_create_archive' => 'Přidat do archivu',
    'filemanager__pack' => "Cesta k archivu: %1",
    'filemanager__archive_name' => 'Název souboru archivu',
    'filemanager__empty_filename' => 'Zadejte název souboru archivu.',
    'filemanager_archive_created' => 'Archív byl úspěšně vytvořen.',
    'filemanager_error_creating_archive' => 'Nelze vytvořit archiv: %1.',

    'cmd_dns__aaaa_dns_record_already_exist' => "Tento záznam způsobí konflikt se záznamem AAAA pro zónu.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Server FTP nepodporuje adresy IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Tento záznam způsobí konflikt se spojovacím záznamem pro zónu \\&amp;apos;%1\\&amp;apos;.',
    '__ftp_ipv6_not_supported' => "(Server FTP nepodporuje adresy IPv6.)",
    '__ipv6_not_supported' => 'Protokol IPv6 není podporován.',
    'mail__ipv6_not_supported' => 'Protokol IPv6 není podporován e-mailovým serverem.',
    'mail__relay_while_list_ipv6_not_supported' => 'Bílá listina přenosu IPv6 není podporován e-mailovým serverem.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Hodnota masky musí být dělitelná číslem 16.',
    'mail__ip_or_mask_is_invalid' => 'IP adresa nebo maska není platná.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Přesměrování na adresy IPv6 není podporováno.',
    'sa__invalid_trusted_networks' => 'Nesprávně zadané důvěryhodné sítě: %1',
    'dns_add__enter_ipv6_address' => "Adresa IPv6",
    'license_trial_days_left' => 'Váš Plesk pracuje se zkušební licencí, která vyprší za %1 dní.',
    'excl_ipv6_num' => 'Vyhrazená adresa IPv6',
    '__ip_mask' => "Maska podsítě",
    '__ipv4_addr' => 'Adresa IPv4',
    '__ipv6_addr' => 'Adresa IPv6',
    'template__num_excl_ipv6s' => 'Přidělit vyhrazené adresy IPv6 prodejci',
    'anonftp__exclusive_ipv4_required' => 'K nastavení a využití služby anonymního FTP se vyžaduje vyhrazená adresa IPv4.',
    'anonftp__ipv4_already_used' => 'Na tomto webu nelze nastavit službu anonymního FTP, protože je již nakonfigurována na jiné doméně pod stejnou adresou IPv4.',


    'restart__kav' => "Antivirus Kaspersky",
    '__view_migration_log_detailed_info' => 'Zobrazit protokol',

    'chown__ip_address_warn' => 'Před přesunem předplatného na nového uživatele musíte pro toto předplatné vybrat novou IP adresu.',
    'chown__no_ip_address' => 'Žádné',
    'chown__no_ipv4_address' => 'Žádná adresa IPv4',
    'chown__no_ipv6_address' => 'Žádná adresa IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Předplatné %1 již patří tomuto uživateli.',
    'chown__error_ip_absent_in_ip_pool' => 'IP adresa %1 není přítomna ve fondu IP adres cílového uživatele.',
    'chown__error_ip_not_exist' => 'IP adresa s ID \\&amp;apos;%1\\&amp;apos; neexistuje.',
    'chown__error_domain_ip_not_selected' => 'Musí být vybrána alespoň jedna IP adresa pro doménu %1. Zkontrolujte hodnoty vybrané pro mapování IP.',

    '__new_passwd_single' => "Heslo",
    '__confirm_passwd_single' => "Potvrdit heslo",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Adresa IPv6 nebo maska je neplatná: IP adresa by měla být platná adresa jednosměrového vysílání.',

    '__subscriptions' => 'Předplacené služby',

    '__owned_by_reseller' => 've vlastnictví prodejce',
    '__owned_by_provider' => 've vlastnictví poskytovatele',

    'service_plan__anonymous' => 'Vlastní',
    'subscription_not_locked__change_limits_warning' => 'Toto předplatné není uzamčeno: Limity využití prostředků se během synchronizace s plánem služeb změní.',
    'subscription_not_locked__change_permissions_warning' => 'Toto předplatné není uzamčeno: Oprávnění se během synchronizace s plánem služeb změní.',

    'subscription__conflict_resolution_policy' => 'Zásady řešení konfliktu',
    'subscription__conflict_resolution_policy_lock' => "Zamknout předplatné",

    'backup__list__backup_warnings' => 'Varování',
    'backup__list__backup_info' => 'Informace',
    'backup__restore__object_reseller_template' => 'Šablona prodejce',
    'backup__restore__object_domain_template' => 'Šablona domény',

    'ui__client/permissions_readonly__title' => 'Oprávnění',
    'ui__client/permissions_readonly__short-title' => 'Oprávnění',

    'subscription__unable_lock_anonymous' => 'Toto předplatné není navázáno na plán služeb a proto jej nelze odemknout.',
    'subscription__unable_sync_anonymous' => 'Toto předplatné není navázáno na plán služeb a proto jej nelze synchronizovat.',
    'subscription__unable_sync_locked' => 'Předplatné je uzamčeno a proto jej nelze synchronizovat.',
    'subscription__locked' => 'Předplatné je uzamčeno.',
    'component_name__urlrewrite' => "Přepisovač URL",
    '__quantity' => 'Množství',
    'hst__www_root_dir_absent' =>  'Varování: adresář zadaný jako kořen dokumentu neexistuje.',
    'object_creation__domain_is_not_a_webspace' => 'Tento objekt lze vytvořit pouze v předplatném.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Předplacená služba obsahuje weby, proto nelze změnit ani odstranit typ hostování.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Chyba: Aktualizace IP adresy se nezdařila. Domény doplňků nelze přiřadit IP adrese bez přiřazení k hlavní doméně předplacené služby.',
    'domain_plan__unable_change' => 'Nelze změnit plán služeb: %1.',
    'domain_plan__different_hosting_type' => 'Aktuální typ hostingu se liší od typu specifikovaného v revizním plánu',
    'domain_plan__addon_text' => 'Rozšířený plán',
    'domain_plan__addon_description' => 'Rozšířený plán slouží jako dodatek plánu hostování.',
    'asp_net__managed_runtime_version' => 'Verze runtime řízená ASP.NET',
    'plan__can_not_change_hosting_type' => 'Při úpravě plánu nelze změnit typ hostingu.',
    'plan__apply_problems' => 'Plán nebyl použit kvůli problémům s následující funkčností: %1',
    'plan_save__subscription_update_problem' => 'Změny kódu nelze aplikovat na %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Předplacená služba je dočasně pozastavena, dokud nebude dokončeno zálohování nebo obnovení. Vraťte se později.",
    '__login_incorrect_plain_shadow_password' => 'Na účet správce jste zadali nesprávné heslo. Použijte pověření správce systému (root) nebo získejte správné heslo. Chcete-li získat další informace o heslu, čtěte soubor /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Nemůžete poslat IP adresu, kterou nevlastníte',

    'dns__dns_zone_not_synchronized' => 'Zóna DNS byla upravena. Pokud byste chtěli použít na tuto zónu změny šablony DNS, klikněte buď na tlačítko \\&apos;Použít změny šablony DNS\\&apos; na této stránce nebo na panelu Správa serveru> Nástroje a nastavení> Nastavení šablony DNS> Použít změny šablony DNS vyberte možnost \\&apos;Použít změny na všechny zóny\\&apos;.',
    'dns__dns_zone_synchronize_link' => 'Klikněte',
    'dns__dns_zone_synchronize_done' => 'Zóna DNS byla úspěšně synchronizována.',

    'dns__dns_zone_template_error' => 'Při synchronizaci zón DNS se šablonou zóny DNS se vyskytly potíže.%1',

    'dns__soa_rname_type_owner' => 'E-mailová adresa vlastníka webu',
    'dns__soa_rname_type_domain' => 'E-mailová adresa domény',
    'dns__soa_rname_type_external' => 'Externí e-mailová adresa',
    'dns__soa_rname_enforce_email' => 'Zakázat změnu e‑mailové adresy RNAME za doménu',
    'dns__soa_rname_label' => 'E-mail (RNAME)',
    'dns__soa_rname_hint' => 'E‑mailová adresa osoby odpovědného za zónu DNS domény. Vráceno serverem DNS v reakci na dotazy SOA.',

    'dns__dns_zone_soa_sync_title' => 'Přepsat nastavení SOA pro všechny existující domény',
    'dns__dns_zone_soa_sync_legend' => 'Požaduje se potvrzení',
    'dns__dns_zone_soa_sync_text' => 'Chcete aktualizovat záznamy SOA všech hostovaných domén použitím změn provedených na šabloně SOA?',

    'cu_db__repair_mysql_dbus' => "Opravit uživatelská hesla MySQL. Tato operace je nutná, pokud jste upgradovali na verzi Plesk 11 z předchozích verzí.",

    'cu_scheduled_backup_comment' => 'Naplánované zálohování',
    'cu_scheduled_backup_error' => 'Během zálohování došlo k chybě: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Během naplánovaného zálohování došlo k chybě.',
    'cu_scheduled_backup_mail_message' => "%1\nbod zadávání Plesk: %2\n\nBěhem naplánovaného zálohování došlo k následujícím chybám: \n\n%3",

    'cu_scheduled_backup_hourly' => 'Zálohování po hodinách',
    'cu_scheduled_backup_daily' => 'Denní zálohování',
    'cu_scheduled_backup_weekly' => 'Týdenní zálohování',
    'cu_scheduled_backup_monthly' => 'Měsíční zálohování',
    'cu_scheduled_backup_comment_backup_all' => '%1. Veškerá konfigurace a obsah.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Veškerá konfigurace a obsah kromě e-mailových zpráv.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Pouze konfigurace a e-mailové zprávy.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Veškerá konfigurace a obsah kromě databází uživatelů.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Veškerá konfigurace a obsah kromě souborů uživatelů.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Jen konfigurace a databáze uživatelů.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Jen konfigurace a soubory uživatelů',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Konfigurace domény.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Ukládání naplánovaných záloh ve vzdáleném cloudovém úložišti je prémiovou funkcí. S žádostí o její odemčení se obraťte na poskytovatele hostingu.',

    'i_backup_invalid_file' => 'Toto není platná záloha. Z tohoto souboru nelze načíst data. Podrobnosti získáte kliknutím na název zálohy.',

    'ui__server/migration/download-agent__short-title' => 'Stáhnout agenta Migrace a přenos',
    'ui__server/migration/download-agent__title' => 'Stáhnout agenta Migrace a přenos',
    'ui__server/migration/download-agent__description' => 'Nejnovější dostupnou verzi agenta Migrace a přenos si stáhněte z webu Plesk.',

    'filemanager_resulting_archive_exists' => 'Soubor %1 již existuje v cílovém adresáři.',

    'agent_unable_to_connect' => 'Nelze se připojit k agentu \\&amp;apos;%2\\&amp;apos;. Ověřte si, že je agent nainstalován a spuštěn a hostitel \\&amp;apos;%2\\&amp;apos; nemá žádné problémy s připojením.',
    'agent_test_connection_failed' => 'Připojení k agentu na \\&amp;apos;%2\\&amp;apos; se nezdařilo.',

    'agent_unable_to_resolve_host' => 'Nelze najít vzdáleného hostitele \\&amp;apos;%1\\&amp;apos;. Ověřte si, že hostitel nemá žádné problémy s připojením.',
    'agent_unknown_curl_error' => 'Během připojení k agentu na \\&amp;apos;%2\\&amp;apos; se vyskytla chyba \\&amp;apos;%1\\&amp;apos;.',
    'agent_unexpected_htp_code' => 'Na požadavek HTTP pro agenta na \\&amp;apos;%2\\&amp;apos; byl přijat neočekávaný kód HTTP \\&amp;apos;%1\\&amp;apos;.',
    'agent_unable_to_auth' => 'Nelze ověřit na hostiteli \\\\&amp;amp;apos;%1\\\\&amp;amp;apos;. Chcete-li vyřešit tento problém, postupujte podle pokynů na webu http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Během provádění příkazu na vzdáleném hostiteli \\&amp;apos;%1\\&amp;apos; došlo k vnitřní chybě serveru.',
    'agent_response_is_empty' => 'Na požadavek HTTP pro agenta na \\&amp;apos;%1\\&amp;apos; byla přijata prázdná odpověď.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'V místní mezipaměti nelze najít agenta Migrace a přenos. Chcete-li problém vyřešit, znovu otevřete správce Migrace a přenos.',

    '__hosting_webdeploy' => "Nástroj pro publikování na webu Web Deploy",
    'cu_domain__webdeploy' => "Publikování na webu Web Deploy (výchozí:%1)",
    'cu_dom_tpl__webdeploy' => "Publikování na webu Web Deploy (výchozí:%1)",
    'cu_subdomain__webdeploy' => "Publikování na webu Web Deploy (výchozí:%1)",
    'webdeploy__not_installed' => "Nástroj pro publikování na webu Microsoft Web Deploy není na serveru nainstalován.",
    'webdeploy__forced_by_site_isolation' => "Nelze změnit nastavení nástroje pro publikování na webu Web Deploy: nemáte oprávnění k přepisu zásad zabezpečení pro celý server. O podrobnosti požádejte svého poskytovatele.",



    'backup__restore_options__admin__server_configuration_license' => 'Licenční klíč',
    'migration_start_migrate_server_license' => 'Přenést licenční klíč',

    'defaultcomponents__delegation_rule_not_exist' => '(požadované pravidlo delegování \\&amp;apos;appPoolPipeline, appPoolNetFx\\&amp;apos; neexistuje)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Zálohu vytvořil správce.',
    'i_backup_created_by_reseller' => 'Zálohu vytvořil prodejce.',
    'i_backup_created_by_client' => 'Zálohu vytvořil zákazník.',

    'migration__object_exists_on_target_host' => '(již existují na cílovém hostiteli)',

    '__customers_total' => 'Celkem podle zákazníků',
    '__resellers_total' => 'Celkem podle prodejců',
    '__reseller_total' => 'Prodejce celkem',


    'cu_cl_pref__manage_website_maintenance' => 'Upřesnit operace: Kopírování webu',
    'cu_cl_pref__manage_protected_dirs' => 'Správa heslem chráněných adresářů',
    'cu_cl_pref__manage_mail_settings' => 'Schopnost změnit nastavení e-mailu',


    'cu__command_update_php_settings' => 'Aktualizuje nastavení PHP.',
    'cu__php_settings_option' => 'Nastaví cestu k souboru s nastavením PHP.',

    'cu__additional_php_settings_option' => 'Nastaví cestu k souboru s dalšími direktivami PHP.',
    'cu__command_show_php_settings' => 'Zobrazí aktuální nastavení PHP.',
    'cu__general_settings' => 'Obecné nastavení:',
    'cu__performance_settings' => 'Nastavení výkonu:',
    'cu__php_fpm_settings' => 'Nastavení PHP-FPM:',
    'cu__additional_directives' => 'Další direktivy:',

    'php_settings_permission_required' => 'Společná správa nastavení PHP',
    'php_settings_performance_permission_required' => 'Správa nastavení výkonu hostování',
    'php_settings_customized' => 'Nastavení PHP bylo individuálně upraveno.',
    'php_settings_synchronized_with_plan' => 'Nastavení PHP se musí synchronizovat s plánem.',
    'phosting__unknown_shell_type' => 'Nedostupné prostředí',

    'login_up__access_denied_subscription_deleted' => 'Přístup odepřen: Vaše předplatné bylo odebráno.',

    'role_restricted_to_subscription' => '(předáno s předplatným: %1)',

    'filemanager__extract' => "Rozbalit soubory do: %1",

    'cu__license_command_check_installed_license' => 'Zkontrolujte platnost nainstalovaného licenčního klíče (pokud je platný, vrací kód ukončení 0, pokud je neplatný, vrací 1).',

    'promo__mobile_manager_title' => 'Správce Plesk Server Mobile Manager',
    'promo__mobile_manager' => "Rozšiřte funkčnost prostředí Plesk o možnost kontroly a monitorování serveru z mobilních zařízení (BlackBerry, iPhone a Android).",
    'promo__mobile_monitor_title' => 'Plesk Server Mobile Monitor',
    'promo__mobile_monitor' => 'Získejte nejdůležitější informace o serverech Plesk kdykoli a odkudkoli z mobilních zařízení (BlackBerry, iPhone a Android).',
    'promo__mobile_button' => 'Další info',

    'ui__server/migration/video__short-title' => 'Výuková videa',
    'ui__server/migration/video__title' => 'Sledovat výuková videa',
    'ui__server/migration/video__description' => 'Sledovat výuková videa.',

    'subDomainNameHint' => 'Chcete-li vytvořit subdoménu se zástupným znakem, zadejte jako název subdomény *. Návštěvníci webu budou přesměrováni na tuto subdoménu bez ohledu na název subdomény zadaný do prohlížeče.',
    'subdomains__wildcard_name_invalid' => "Název subdomény je neplatný. V názvech subdomén lze použít pouze alfanumerické znaky, pomlčku (-) a hvězdičku (*).",
    'subdomains__name_invalid' => "Název subdomény je neplatný. V názvech subdomén lze použít pouze alfanumerické znaky a pomlčku (-).",

    'domain__wildcard_no_www_prefix' => 'Nelze použít předponu www pro subdomény se zástupnými znaky.',

    '__service_title__milter' => "Filtr Plesk Postfix milter",
    '__service_description__milter' => "Filtr pošty Plesk Postfix",
    '__milter' => "Filtr Postfix milter",
    'restart__milter' => "Filtr Plesk (%1)",
    'restart__pop3' => "Server Courier POP3",
    'restart__pop3s' => "Server Courier POP3 s podporou SSL/TLS",
    'restart__imap' => "Server Courier IMAP",
    'restart__imaps' => "Server Courier IMAP s podporou SSL/TLS",
    'restart__authdaemon' => "Démon ověřování Courier IMAP",
    'restart__imap-pop3' => "Server Dovecot IMAP a POP3",


    'addon_packages_not_supported' => 'Doplňky pro zabalené webové aplikace APS nejsou podporovány.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Nelze automaticky přiřadit IP adresu na doménu. Specifikujte IP adresu pomocí možnosti -ip.',

    'plesk_key__mb_accounts' => 'Uživatelské účty (prodejci a zákazníci) v modulu Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Zóna DNS subdomény',
    'actionlog__site_subdomain_dns' => 'Zóna DNS subdomény pod další doménou',

    // PfW only
    'actionlog__event_site_create' => 'Doména byla vytvořena',
    'actionlog__event_site_delete' => 'Doména odstraněna',
    'actionlog__event_site_update' => 'Aktualizována doména',

    'actionlog__event_site_status_update' => 'Aktualizován stav domény',
    'actionlog__event_site_dns_update' => 'Aktualizována zóna DNS domény',
    'actionlog__event_site_guid_update' => 'Aktualizován identifikátor GUID domény',

    'actionlog__event_site_subdomain_create' => 'Vytvořena subdoména',
    'actionlog__event_site_subdomain_delete' => 'Odstraněna subdoména',
    'actionlog__event_site_subdomain_update' => 'Aktualizována subdoména',

    'actionlog__event_site_alias_create' => 'Vytvořen alias domény',
    'actionlog__event_site_alias_delete' => 'Odstraněn alias domény',
    'actionlog__event_site_alias_update' => 'Aktualizován alias domény',

    'actionlog__event_site_alias_dns_update' => 'Aktualizována zóna DNS aliasu domény',
    'actionlog__event_subdomain_dns_update' => 'Byla aktualizována zóna DNS subdomény pod výchozí doménou',
    'actionlog__event_site_subdomain_dns_update' => 'Aktualizována zóna DNS subdomény',
    // End of PfW only

    'win_policy__bad_password' => 'Ověření se nezdařilo. Heslo je neplatné.',
    'win_policy__password_too_short' => 'Ověření se nezdařilo. Heslo nesplňuje požadavky zásad pro hesla, protože je příliš krátké.',
    'win_policy__password_too_long' => 'Ověření se nezdařilo. Heslo nesplňuje požadavky zásad pro hesla, protože není dost dlouhé.',
    'win_policy__password_not_complex_enough' => 'Ověření se nezdařilo. Heslo není dostatečně komplexní a nesplňuje požadavky zásad pro tvorbu hesel. Silná hesla musí splňovat nejméně všechny tyto náležitosti: osm znaků, jedno velké nebo jedno malé písmeno, tři čísla a jeden speciální znak (!, @, #, $, %, ^, &, *, ?, _, ~), nebo jedno číslo a dva speciální znaky.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Nelze aktualizovat licenci produktu.',


    'filemanager__error_path_is_not_allowed' => 'Cesta není povolena',
    'filemanager__error_path_is_invalid' => 'Cesta není platná',
    'filemanager__error_path_not_found' => 'Cesta nebyla nalezena: %1',
    'filemanager__error_path_already_exists' => 'Cesta již existuje',
    'filemanager__error_access_is_denied' => 'Přístup byl odepřen',
    'filemanager__error_directory_not_empty' => 'Složka není prázdná',
    'filemanager__error_sharing_violation' => 'Narušení sdílení',
    'filemanager__error_not_same_device' => 'Cílová cesta není na stejném zařízení',
    'filemanager__binary_data_access' => 'Tento soubor může být binární soubor. Chcete jej otevřít?',
    'filemanager__unable_to_resolve_realpath' => "Na určeném místě nelze nalézt soubor %1",
    'filemanager__access_to_realpath_denied' => "Přístup k realpath je odepřen: %1 až %2.",
    'bt_exit' => 'Výjezd',

    'filemanager__chdir_error__' => "Nelze změnit adresář na %1: %2",
    'filemanager__chmod_dir' => "Změnit oprávnění pro adresář %1",
    'filemanager__chmod_error__' => "Nelze změnit oprávnění pro soubor %1: %2",
    'filemanager__chmod_file' => "Změnit oprávnění pro soubor %1",
    'filemanager__copy_error__' => "Nelze kopírovat %1 do %2: %3",
    'filemanager__copy_move' => "Kopírovat (přesunout) soubory z %1",
    'filemanager__count_size__' => 'Velikost výběru: %1',
    'filemanager__count_size_error__' => 'Nelze vypočítat velikost pro %1: %2',
    'filemanager__create_dir' => "Vytvoření adresáře",
    'filemanager__create_dir_error__' => "Nelze vytvořit adresář %1: %2",
    'filemanager__dir_not_exists' => "Adresář %1 neexistuje.",
    'filemanager__dirname' => "Název adresáře",
    'filemanager__filename' => "Název souboru",
    'filemanager__is_no_such' => "Neexistuje žádný soubor či adresář s názvem %1",
    'filemanager__empty_selection' => "Žádný(é) soubor(y) nebyly vybrány.",
    'filemanager__file_exists' => "Soubor %1 již existuje.",
    'filemanager__move_error__' => "Nelze přesunout %1 do %2: %3",
    'filemanager__new_dir' => "Název adresáře",
    'filemanager__not_allowed' => "Změna oprávnění pro tento soubor není povolena.",
    'filemanager__r_perm_dir' => "Vypsat adresář",
    'filemanager__r_perm_file' => "Číst data",
    'filemanager__remove' => "Odstranit soubory z%1",
    'filemanager__remove_error__' => "Nelze odstranit soubor %1: %2",
    'filemanager__rename_dir' => "Přejmenovat adresář %1",
    'filemanager__rename_error__' => "Nelze přejmenovat %1 na %2: %3",
    'filemanager__rename_file' => "Přejmenovat soubor %1",
    'filemanager__set_win_permissions_dir' => "Nastavit oprávnění pro složku %1",
    'filemanager__set_win_permissions_file' => "Nastavit oprávnění pro soubor %1",
    'filemanager__touch_confirm' => "Opravdu chcete změnit časové razítko vybraných souborů?",
    'filemanager__upload_error__' => "Nelze nahrát %1 do %2: %3",
    'filemanager__upload_file' => "Nahrát soubor",
    'filemanager__upload_file_src' => "Cesta k souboru",
    'filemanager__username' => "Uživatel",
    'filemanager__w_perm_dir' => "Vytvořit soubory",
    'filemanager__w_perm_file' => "Zapsat data",
    'filemanager__x_perm_dir' => "Procházet adresářem",
    'filemanager__x_perm_file' => "Spustit soubor",
    'filemanager__max_image_size_exceeded' => 'Nelze zobrazit obrázek. Velikost obrázku nemůže být větší než %2 bajtů.',

    '__fastcgi_unix_support' => 'Podpora FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Záznamy DNS této subdomény se ukládají do nadřazené zóny DNS. Můžete změnit nadřazenou zónu %1 nebo vytvořit samostatnou zónu pro subdoménu.',
    'dns__subdomain_dns_zone_parent_link' => 'zde',
    'dns__no_dns_zone' => 'K doméně není přiřazena žádná zóna DNS. Chcete-li spravovat zónu DNS pro svou doménu, musíte stisknout tlačítko \\&amp;apos;Obnovit výchozí\\&amp;apos;.',
    'dns__unable_turn_on_subdomain_zone' => 'Nelze přepnout na zónu subdomény, protože záznam CNAME pro tuto subdoménu je v zóně nadřazené domény.',

    '__hosting_write_modify' => 'Další oprávnění pro zápis/úpravy',

    'aspdotnet__group_framework_version' => "Verze Frameworku",
    'aspdotnet__param_version' => "Verze",

    'bt_restore_default' => "Nastavit výchozí",
    'b_aspdotnet' => 'Upravit nastavení konfigurace nastavení pro ASP.NET',
    'b_aspdotnet__restore_default' => 'Obnovit výchozí nastavení ASP.NET.',
    'b_aspdotnet__restore_wdir_default' => "Obnovit nastavení nadřazeného adresáře ASP.NET pro tento virtuální adresář.",
    'b_aspdotnet__restore_default_disabled' => 'Obnovení výchozí konfigurace ASP.NET není k dispozici: Konfigurace ASP.NET je porušena buď na serveru nebo na úrovni nadřazeného adresáře.',
    'b_autoinstaller' => 'Aktualizovat Plesk nebo jeho součásti.',
    'b_autoinstaller_configure' => 'Aktualizovat nastavení.',
    'b_autoinstaller_install' => 'Nainstalovat vybrané součásti.',

    '__iis_app_pool__use_dedicated' => 'Vyhrazený fond aplikací služby IIS',
    '__iis_app_pool__use_dedicated_addons' => 'Vyhrazený fond aplikací služby IIS pro každý web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Povolit 32bitové aplikace',
    '__iis_app_pool__load_user_profile' => 'Načíst uživatelský profil',
    'bt_iis_app_pool' => "Fond aplikací IIS",

    'performance__cpu_usage' => 'Maximální využití procesoru (%)',
    'performance__cpu_usage_action' => 'Omezení akce',
    'performance__cpu_usage_interval' => 'Interval omezení (minuty)',
    'performance__cpu_usage_action_not_supported' => 'Webový server nepodporuje zadanou akci.',

    'performance__idle_timeout_action_not_supported' => 'Webový server nepodporuje zadanou akci při časovém limitu nečinnosti.',
    'performance__max_worker_processes' => 'Maximální počet pracovních procesů',
    'performance__idle_timeout' => 'Časový limit nečinnosti (minuty)',
    'performance__idle_timeout_action' => 'Akce při časovém limitu nečinnosti',
    'performance__recycling_by_time' => 'Recyklování v pravidelných časových intervalech (minuty)',
    'performance__recycling_by_requests' => 'Recyklování při dosažení maximálního počtu žádostí',
    'performance__recycling_by_virtual_memory' => 'Recyklování při použití maximálního množství virtuální paměti',
    'performance__recycling_by_private_memory' => 'Recyklování při použití maximálního množství soukromé paměti',
    'performance__managed_pipeline_mode' => 'Spravovaný režim kanálů',
    'performance__managed_pipeline_mode_not_supported' => 'Zadaný ovládací prvek není podporován webovým serverem.',

    'iis_app_pool' => 'Správa fondu aplikací služby IIS.',
    'b_iis_app_pool' => 'Správa fondu aplikací služby IIS.',
    'iis_app_pool_cl_dom' => 'Správa fondu aplikací služby IIS.',

    'i_webdirs_not_protected' => 'Tento adresář není chráněný.',
    'i_webdirs_protected' => 'Tento adresář je chráněný.',
    'i_webdirs_manage_protection' => 'Spravovat ochranu.',
    'i_webdirs_open' => 'Otevřít adresář/soubor v prohlížeči.',
    'i_webdirs_preferences_disabled' => 'Tento adresář není virtuální adresář.',
    'i_webdirs_permissions' => 'Spravovat oprávnění.',
    'i_webdirs_permissions_disabled' => 'Správa oprávnění adresáře není k dispozici.',
    'i_webdirs_type_dir' => 'Fyzický adresář',
    'i_webdirs_type_vdir' => 'Virtuální adresář',
    'i_webdirs_browse' => 'Procházet obsahem adresáře.',
    'i_webdirs_preferences' => 'Správa nastavení webového adresáře.',

    'l_webdirslist_type' => 'Seřadit adresáře podle typu.',
    'l_webdirslist_protected' => 'Seřadit adresáře podle stavu ochrany.',
    'l_webdirslist_name' => 'Seřadit adresáře podle názvu.',

    'b_webdirslist_remove' => 'Odstranit vybrané virtuální adresáře.',
    'b_webdirslist_search' => 'Zadejte parametry vyhledávání a kliknutím spusťte vyhledávání virtuálních adresářů.',
    'b_webdirslist_show_all' => 'Zobrazit všechny adresáře.',

    'l_webdirerrordocslist_code' => 'Seřadit chybové dokumenty podle čísla kódu chyby.',
    'l_webdirerrordocslist_name' => 'Seřadit chybové dokumenty podle popisu chyby.',
    'l_webdirerrordocslist_type' => 'Seřadit chybové dokumenty podle typu chybového dokumentu.',
    'l_webdirerrordocslist_location' => 'Seřadit chybové dokumenty podle umístění chybového dokumentu.',

    'b_webdirerrordocslist_search' => 'Zadejte parametry vyhledávání a kliknutím vyhledejte chybové dokumenty.',
    'b_webdirerrordocslist_remove' => 'Odstranit vybrané chybové dokumenty.',
    'b_webdirerrordocslist_show_all' => 'Zobrazit všechny chybové dokumenty.',

    'l_webdirmimetypeslist_name' => 'Seřadit typy MIME podle rozšíření.',
    'l_webdirmimetypeslist_content' => 'Seřadit typy MIME podle obsahu.',

    'b_webdirmimetypeslist_remove' => 'Odstranit vybrané typy MIME.',
    'b_webdirmimetypeslist_search' => 'Zadejte parametry vyhledávání a kliknutím spusťte vyhledávání typů MIME.',
    'b_webdirmimetypeslist_show_all' => 'Zobrazit všechny typy MIME.',

    'b_webdir_preferences' => "Nastavení virtuálního adresáře.",
    'b_webdir_permissions' => "Oprávnění virtuálního adresáře.",
    'b_webdir_permissions_disabled' => "Správa oprávnění adresáře není k dispozici.",
    'b_to_webdirs' => 'Návrat na správu adresářů.',
    'b_to_webdir_mime_types' => 'Návrat na správu typů MIME.',
    'b_to_webdir_error_docs' => 'Návrat na správu chybových dokumentů.',
    'b_to_webdir_protection' => 'Návrat na správu ochrany virtuálního adresáře.',

    'webdirs__title' => 'Virtuální adresář %1',
    'webdirs__preferences_title' => 'Nastavení virtuálního adresáře',
    'webdirs__list_legend' => 'Virtuální adresáře',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Jméno',
    'webdirs__list_header' => 'Položek: %1',
    'webdirs__tabs_general' => 'Obecné',
    'webdirs__tabs_mime_types' => 'Typy MIME',
    'webdirs__tabs_error_docs' => 'Chybové dokumenty',

    'webdirs__tabs_permissions' => 'Oprávnění',
    'webdir__remove_vdirs' => 'Následující virtuální adresáře budou odstraněny:',
    'webdir__remove_mime_types' => 'Následující typy MIME budou odstraněny:',
    'webdir__mime_types_title' => 'Typy MIME',
    'webdir__protection_disable_confirm' => 'Opravdu chcete odebrat ochranu adresáře?',
    'webdir__protect_title' => 'Uživatelé chráněné adresy URL',
    'webdirs__permissions_title' => 'Oprávnění virtuálního adresáře',
    'webdirs__browse_content_permission_denied' => 'Nemáte oprávnění prohlížet obsah tohoto adresáře.',
    'error_doc__list_code' => 'Chyba',
    'error_doc__list_code_description' => 'Popis',
    'error_doc__list_type' => 'Typ',
    'error_doc__list_location' => 'Umístění',
    'error_doc__code' => 'Chyba',
    'error_doc__type' => 'Typ',
    'error_doc__type_file' => 'Soubor',
    'error_doc__type_url' => 'Adresa URL',
    'error_doc__location' => 'Umístění',
    'error_doc__legend' => 'Chybový dokument',
    'error_doc__edit_title' => 'Upravit chybový dokument',
    'error_doc_erorr_invalid_url_location' => 'Adresa URL není platná. Zadejte správnou adresu URL.',
    'error_doc_erorr_invalid_file_location' => 'Cesta k souboru je neplatná. Zadejte správnou cestu k souboru.',
    'error_doc__type_default' => 'Výchozí',

    'webdirs__tabs_protection' => 'Ochrana',
    'pb_webdirs' => 'Virtuální adresáře',

    'webdirs_remove_title' => 'Následující virtuální adresáře budou odebrány:',
    'webdirs_mime_types_remove_title' => 'Následující typy MIME budou odebrány:',
    'webdirs_preferences_title' => 'Nastavení virtuálního adresáře',
    'webdirs_permissions_title' => 'Zvláštní oprávnění pro soubory a složky',
    'webdi_protection_disable_confirm' => 'Opravdu chcete odebrat ochranu z virtuálního adresáře? Při této akci budou odebráni všichni uživatelé chráněných adresářů a nastavení ochrany adresáře.',
    'bt_protect' => 'Ochránit',
    'bt_unprotect' => 'Odstranit ochranu',
    'bt_show_additional_users' => 'Zobrazit více uživatelů',
    'bt_hide_additional_users' => 'Zobrazit méně uživatelů',
    'error_doc__list_title' => 'Chybové dokumenty',
    'error_doc__list_header' => 'Chybové dokumenty',
    'error_doc__code_400' => 'Chybný požadavek',
    'error_doc__code_401' => 'Neoprávněný',
    'error_doc__code_401.1' => 'Neověřeno - Přihlášení se nezdařilo',
    'error_doc__code_401.2' => 'Neověřeno - Přihlášení se nezdařilo kvůli konfiguraci serveru',
    'error_doc__code_401.3' => 'Neověřeno - Neověřeno kvůli seznamu řízení přístupu (ACL) na prostředku',
    'error_doc__code_401.4' => 'Neověřeno - Ověření se nezdařilo kvůli filtru',
    'error_doc__code_401.5' => 'Neověřeno - Ověření se nezdařilo kvůli aplikaci ISAPI/CGI',
    'error_doc__code_401.7' => 'Neověřeno - Odmítnuto kvůli zásadám ověřování adres URL',
    'error_doc__code_403' => 'Zakázáno',
    'error_doc__code_403.1' => 'Zakázáno - Přístup s právem spouštět byl odepřen.',
    'error_doc__code_403.2' => 'Zakázáno - Přístup pro čtení byl odepřen',
    'error_doc__code_403.3' => 'Zakázáno - Přístup pro zápis byl odepřen',
    'error_doc__code_403.4' => 'Zakázáno - Požadováno SSL',
    'error_doc__code_403.5' => 'Zakázáno - Požadováno SSL 128',
    'error_doc__code_403.6' => 'Zakázáno - IP adresa odmítnuta',
    'error_doc__code_403.7' => 'Zakázáno - Je požadován klientský certifikát',
    'error_doc__code_403.8' => 'Zakázáno - Přístup k webu odepřen',
    'error_doc__code_403.9' => 'Zakázáno - Příliš mnoho uživatelů',
    'error_doc__code_403.10' => 'Zakázáno - Neplatná konfigurace',
    'error_doc__code_403.11' => 'Zakázáno - Změna hesla',
    'error_doc__code_403.12' => 'Zakázáno - Mapovač odmítl přístup',
    'error_doc__code_403.13' => 'Zakázáno - Odvolán klientský certifikát',
    'error_doc__code_403.14' => 'Zakázáno - Výpis adresáře byl odepřen',
    'error_doc__code_403.15' => 'Zakázáno - Překročeny licence pro klientský přístup',
    'error_doc__code_403.16' => 'Zakázáno - Klientský certifikát není důvěryhodný nebo je poškozen',
    'error_doc__code_403.17' => 'Zakázáno - Platnost klientského certifikátu vypršela nebo tento klientský certifikát není dosud platný',
    'error_doc__code_403.18' => 'Zakázáno - Žádost z tohoto fondu aplikací nelze spustit',
    'error_doc__code_403.19' => 'Zakázáno - Přístup pro CGI byl odepřen',
    'error_doc__code_403.20' => 'Zakázáno - Přihlášení ke službě Passport se nezdařilo',
    'error_doc__code_404' => 'Nenalezeno',
    'error_doc__code_404.2' => 'Nenalezeno - Odmítnuto kvůli zásadám uzamčení',
    'error_doc__code_404.3' => 'Nenalezeno - Odmítnuto kvůli zásadám MIMEMAP',
    'error_doc__code_405' => 'Metoda není povolena',
    'error_doc__code_406' => 'Nepřijatelné',
    'error_doc__code_407' => 'Vyžadováno ověření proxy',
    'error_doc__code_412' => 'Předběžná podmínka selhala',
    'error_doc__code_414' => 'Identifikátor URI požadavku je příliš dlouhý',
    'error_doc__code_415' => 'Nepodporovaný typ médií',
    'error_doc__code_500' => 'Vnitřní chyba serveru',
    'error_doc__code_500.12' => 'Vnitřní chyba serveru - Restart aplikace',
    'error_doc__code_500.13' => 'Vnitřní chyba serveru - Server je příliš zaneprázdněn',
    'error_doc__code_500.15' => 'Vnitřní chyba serveru - Přímé požadavky na GLOBAL.ASA jsou zakázány',
    'error_doc__code_500.16' => 'Vnitřní chyba serveru - Chyba přístupu UNC',
    'error_doc__code_500.17' => 'Vnitřní chyba serveru - Úložiště ověření adres URL nelze najít',
    'error_doc__code_500.18' => 'Vnitřní chyba serveru - Úložiště ověření adres URL nelze otevřít',
    'error_doc__code_500.19' => 'Vnitřní chyba serveru - Chybná metadata souboru',
    'error_doc__code_500.100' => 'Vnitřní chyba serveru - Chyba ASP',
    'error_doc__code_501' => 'Nerealizováno',
    'error_doc__code_502' => 'Chybná brána',
    'error_doc__code_503' => 'Služba je dočasně nedostupná',

    'mimetype__extension' => 'Rozšíření',
    'mimetype__content' => 'Obsah',
    'mimetypeslist__title' => 'Typy MIME',
    'mimetypes__title' => 'Typy MIME',
    'mimetypes__select_to_remove' => 'Vybrat typy MIME, které chcete odebrat.',
    'mimetypes__select_for_remove' => "Vybrat typy MIME, které se mají odebrat.",
    'mimetypes_remove__title' => 'Odebrat typ MIME',
    'mimetype__legend' => 'Typ MIME',
    'mimetype_edit__title' => 'Upravit typ MIME',
    'mimetype_edit__already_exists' => 'Typ MIME je pro tuto příponu již definován.',
    'mimetype_edit__not_exists' => 'Typ MIME neexistuje.',
    'mimetype__content_type_other' => 'Vlastní…',

    'b_webdir_protection_enable' => 'Vytvořte adresu URL odpovídající adresáři, který je chráněn heslem.',
    'b_webdir_protection_disable' => 'Vytvořte adresu URL odpovídající adresáři, který je přístupný všem.',
    'b_webdir_protection_disabled' => 'Ochrana virtuálního adresáře je zakázána.',

    'b_pd_usr_create' => 'Kliknutím vytvořte tuto chráněnou adresu URL uživatele.',
    'php__changeversion_title' => "Vybrat verzi PHP",
    'php__group_php_version' => "Verze PHP",

    'virtualdir__name' => 'Jméno',
    'virtualdir__path' => 'Cesta',
    'virtualdir__read' => 'Oprávnění ke čtení',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Oprávnění k zápisu',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Přístup ke zdroji skriptu',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Procházení adresářů',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Oprávnění ke spouštění',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Protokolovat návštěvy',
    'virtualdir__app_create' => 'Vytvořit aplikaci',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Přepnutí na anonymní ověřování.',
    'virtualdir__auth_windows' => 'Přepnutí na ověřování Windows.',
    'virtualdir__auth_not_enabled' => 'Anonymní ověřování nebo ověřování systému Windows musí být zapnuto.',
    'virtualdir__require_ssl' => 'Požadovat protokol SSL/TLS',
    'virtualdir__enable_default_doc' => 'Použít výchozí dokumenty',
    'virtualdir__default_doc' => 'Výchozí pořadí vyhledávání dokumentů',
    'virtualdir__enable_parent_paths' => 'Povolit používání nadřazených cest',
    'virtualdir__execute_in_mta' => 'Povolit spuštění aplikace v prostředí MTA (vícenásobný objekt)',
    'virtualdir_create__title' => 'Vytvořit virtuální adresář v %1',
    'virtualdir_edit__title' => 'Vlastnosti virtuálního adresáře %1',
    'virtualdir_edit__legend' => 'Virtuální adresář',
    'virtualdir_edit__application_legend' => 'Nastavení aplikace',
    'virtualdir_edit__security_legend' => 'Zabezpečení adresáře',
    'virtualdir_edit__documents_legend' => 'Doklady',
    'virtualdir_edit__list_legend' => 'Vnořené virtuální adresáře',
    'virtualdir_error__path_not_in__' => 'Byla zadána neplatná cesta',
    'virtualdir_error__already_exists' => 'Adresář s tímto názvem již existuje.',
    'virtualdir_root' => 'Virtuální adresáře',
    'virtualdir_root__title' => 'Virtuální adresáře',
    'virtualdir_root__list_legend' => 'Virtuální adresáře',
    'virtualdir_se__none' => 'Žádné',
    'virtualdir_se__script' => 'Pouze skripty',
    'virtualdir_se__script_execute' => 'Skripty a spustitelné soubory',
    'virtualdirs__title' => 'Virtuální adresáře',
    'virtualdirs__path_not_exists' => 'Neplatná cesta.',
    'virtualdirs__select_for_remove' => "Vybrat virtuální adresáře, které mají být odebrány.",
    'virtualdirs_remove__title' => 'Odebrat virtuální adresáře',
    'virtualdirs_phys_dir_exist' => 'Fyzický adresář s tímto názvem již existuje. Pokud budete pokračovat, stane se nepřístupným. Chcete pokračovat?',
    'virtualdir_auto_create_dir' => "Vytvořit fyzický adresář se stejným názvem jako virtuální adresář",

    'asp_max_default_text' => 'Definováno nadřazeným adresářem (%1 kB)',
    'asp_max_default_text_site' => 'Definováno IIS (%1 kB)',
    'asp_max_buffer_text' =>'Maximální velikosti mezipaměti ASP (kB)',
    'asp_max_body_text' => 'Maximální velikost obsahu entity požadavku ASP (kB)',
    'asp_buffers_legend' =>'Nastavení ASP',

    'asp_debug_default_text' =>'Definováno nadřazeným adresářem',
    'asp_debug_default_text_site' =>'Definováno IIS',
    'asp_client_debug_text' =>'Povolit ladění skriptů ASP na straně klienta',
    'asp_server_debug_text' =>'Povolit ladění skriptů ASP na straně serveru',

    'webdirs__list_with_broken_dirs' => "Existují virtuální adresáře propojené s neexistujícími fyzickými složkami.",
    'webdirs__vdir_physical_path_not_exist' => "Virtuální adresář je nasměrován na fyzickou složku, která neexistuje.",
    'webdirs__physical_path_not_exist' => "Zadaná cesta neexistuje.",

    'filemanager__new_dir_title' => 'Vytvořit adresář',
    'php__configuration_title' => "Konfigurace PHP",

    'permissions__title' => 'Nastavit přístupová oprávnění',
    'permissions__title_advanced' => 'Nastavení rozšířených přístupových oprávnění',
    'permissions__inherit_from_parent' => 'Povolit přenesení dědičných oprávnění z nadřazeného objektu na tento objekt a všechny podřízené objekty. Zahrnout je spolu s explicitně definovanými položkami.',
    'permissions__replace_on_children' => 'Nahradit položky oprávnění na všech podřízených objektech zde zobrazenými záznamy.',
    'permissions__group_or_user_name' => 'Název skupiny nebo uživatele',
    'permissions__Permissions_for' => 'Oprávnění pro',
    'permissions__allow' => 'Povolit',
    'permissions__deny' => 'Odepřít',
    'permissions__FullControl' => 'Úplné řízení',
    'permissions__Modify' => 'Změnit',
    'permissions__ReadAndExecute' => 'Číst a spustit',
    'permissions__ListFolderContents' => 'Zobrazovat obsah složky',
    'permissions__Read' => 'Přečteno',
    'permissions__Write' => 'Zápis',
    'permissions__ReadControl' => 'Řízení čtení',
    'permissions__WriteControl' => 'Řízení zápisu',
    'permissions__ExecuteControl' => 'Spustit řízení',
    'permissions__TraverseFolderOrExecuteFile' => 'Procházet složkou/Spouštět soubory',
    'permissions__ListFolderOrRead' => 'Zobrazovat obsah adresáře / Číst data',
    'permissions__CreateFilesOrWrite' => 'Vytvářet soubory / Zapisovat data',
    'permissions__CreateFoldersOrAppend' => 'Vytvářet složky / Připojovat data',
    'permissions__DeleteSubfoldersandFiles' => 'Odstraňovat podsložky a soubory',
    'permissions__Delete' => 'Odstranit',
    'permissions__ChangePermissions' => 'Změnit oprávnění',
    'permissions__TakeOwnership' => 'Převzít vlastnictví',
    'permissions__inherited_from' => 'Zděděno od',
    'permissions__not_inherited' => '<není zděděno>',
    'permissions__apply_to' => 'Použití',
    'permissions__apply_onto' => 'Použít:',
    'permissions__apply_onto1' => 'Pouze tato složka',
    'permissions__apply_onto2' => 'Jen podsložky',
    'permissions__apply_onto3' => 'Tato složka a podsložky',
    'permissions__apply_onto4' => 'Jen soubory',
    'permissions__apply_onto5' => 'Tato složka a soubory',
    'permissions__apply_onto6' => 'Pouze podsložka a soubory',
    'permissions__apply_onto7' => 'Tato složka, podsložky a soubory',

    'filemanager__not_allowed_dir' => "Změna oprávnění pro tuto složku není povolena.",

    'filemanager__allow' => "Povolit",
    'filemanager__deny' => "Odepřít",
    'filemanager__user_domusr' => 'Správce webu',
    'filemanager__user_webusr' => 'Uživatel webu',
    'filemanager__user_admins' => 'Správci',
    'filemanager__user_system' => 'SYSTÉM',
    'filemanager__user_aspnet' => 'Uživatel ASP.NET',
    'filemanager__user_poolusr' => 'Uživatel fondu aplikací',
    'filemanager__user_sysaccount' => 'Další uživatel systému',

    'bt_permissions_advanced' => 'Rozšířený',
    'b_permissions_advanced' => 'Kliknutím zobrazte a nastavte zvláštní oprávnění.',

    'hotlink-protection_invalid_friend_domain' => 'Neplatný název pro schválenou doménu.',
    'hotlink-protection_duplicate_friend_domain' => 'Duplicitní název pro schválenou doménu.',
    'hotlink-protection_invalid_extensions' => 'Přípony souborů obsahují nesprávné znaky.',

    'i_domain_alias_status_on' => 'Alias domény je povolen.',
    'i_domain_alias_status_off' => 'Alias domény je zakázán.',
    'i_domain_alias_status_with_parent' => 'Alias domény je zakázán, protože doména je vypnuta.',
    'i_domain_alias_turn_off' => 'Kliknutím vypnout.',
    'i_domain_alias_turn_on' => 'Kliknutím zapnout.',
    'i_domain_alias_mail_on' => 'Poštovní služba je pro tento alias domény zapnuta.',
    'i_domain_alias_mail_off' => 'Poštovní služba je pro tento alias domény vypnuta.',
    'i_domain_alias_mail_with_parent' => 'Poštovní služba je vypnutá, protože alias domény je vypnutý.',
    'i_domain_alias_web_on' => 'Webová služba je pro tento alias domény zapnuta.',
    'i_domain_alias_web_off' => 'Webová služba je pro tento alias domény vypnuta.',
    'i_domain_alias_web_with_parent' => 'Webová služba je vypnuta, protože alias domény je vypnutý.',
    'i_domain_alias_dns_on' => 'Služba DNS aliasing je pro tento alias domény zapnuta.',
    'i_domain_alias_dns_off' => 'Služba DNS aliasing je pro tento alias domény vypnuta.',
    'i_domain_alias_dns_with_parent' => 'Synchronizace DNS s nadřízenou doménou je vypnutá, protože alias domény je vypnutý.',
    'i_domain_alias_seoRedirect_on' => 'Přesměrování s kódem HTTP 301 je pro tento alias domény zapnuto.',
    'i_domain_alias_seoRedirect_off' => 'Přesměrování s kódem HTTP 301 je pro tento alias domény vypnuto.',
    'i_domain_alias_seoRedirect_with_parent' => 'Přesměrování s kódem HTTP 301 je vypnuto, protože alias domény je vypnutý.',

    'domain_alias__control_title' => 'Alias domény %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Název služby',
    'domain_alias__control_details_title' => 'Podrobnosti',

    'domain_alias__invalid_values' => 'Zadaný název domény je neplatný. Názvy domén mohou obsahovat písmena, číslice a pomlčky. Každá část názvu domény mezi tečkami nesmí být delší než 63 znaků.',
    'domain_alias__domain_already_exists' => "Nesprávný název aliasu domény %1. Doména %1 již existuje.",
    'domain_alias__www_prefix_domain_already_exists' => "Nesprávný název aliasu domény. %1. Tento alias je již vytvořen pro doménu %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Nesprávný název aliasu domény pro webové rozhraní pošty. %1. Tento alias je již vytvořen pro doménu %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Nesprávný název seznamu doménových aliasů. %1. Tento alias je již vytvořen pro doménu %1.',
    'domain_alias__dns_record_already_exists' => 'Nelze nastavit alias domény %1, protože záznam DNS odkazující na hostitele %1 již existuje.',
    'domain_alias__domain_alias_already_exists' => "Alias domény s tímto názvem již existuje.",
    'domain_aliases__mail_server_not_support_aliases' => 'E-mailový server nepodporuje funkci doménových aliasů. Doménové aliasy nemusí pracovat správně.',
    'domain_alias__restrict_domain_creation' => 'Zadaný název pro alias domény je zakázán podle zásad platných pro celý server. Pokud název doménového aliasu patří vám, kontaktujte svého poskytovatele hostingu.',
    'domain_alias__restrict_creation_with_www' => 'Zadejte název domény bez předpony \\&amp;apos;www\\&amp;apos;. Předpona www pro doménu bude automaticky přidána ke konfiguraci webového serveru.',
    'domain_unable_to_set_name' => 'Nesprávné jméno %1.',

    'domain_alias__domain_service_dns_disabled' => 'Tato doména je obsluhována jiným serverem DNS.',
    'domain_alias__domain_service_dns_enabled_master' => 'Tento server DNS se chová jako primární názvový server pro tuto zónu.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Tento server DNS se chová jako sekundární názvový server pro tuto zónu.',
    'domain_alias__domain_service_mail_enabled' => 'Poštovní služba je pro doménu zapnuta.',
    'domain_alias__domain_service_mail_disabled' => 'Poštovní služba je pro doménu vypnuta.',
    'domain_alias__domain_service_mail_mx' => '%1 se používá jako e-mailový server.',

    'domain_alias__service_seoRedirect_hint' => 'Když návštěvníci otevřou adresu URL aliasu, budou přesměrováni adresu URL hlavní domény. Plesk používá vyhledávač s uživatelsky přívětivým přesměrováním na HTTP 301, což znamená, že se hodnocení vyhledávače nebude dělit mezi adresami URL.',

    'bt_task_run_now' => 'Spustit',
    'ftp__read_perm' => "Oprávnění ke čtení",
    'ftp__write_perm' => "Oprávnění k zápisu",

    'filemanager__upload_backup_file_hint' => 'Zde můžete nahrát soubory zálohy na úložiště Plesk. Maximální velikost souboru je omezena na dva gigabajty.',

    '__default_for_mssql' => 'výchozí pro MS SQL',

    '__login_does_not_pass_validation' => "Přihlašovací jméno je neplatné. Ujistěte se, že splňuje následující požadavky: %1",
    '__login_allowed_symbols' => 'Jsou povoleny pouze alfanumerické znaky včetně teček, čárek a podtržítek. První znak musí být alfanumerický.',

    'restart__nginx' => 'Reverzní proxy server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Rád bych přijímal obecné informace o produktu a oznámení od společnosti Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Rád bych přijímal informace související s bezpečností a další technická upozornění od společnosti Plesk.",

    '__login_status_inactive' => 'Váš účet není aktivní. Kontaktujte správce prostředí Plesk.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Návrat na stránku Nástroje a nastavení. Migrace bude pokračovat na pozadí.',

    'ui__admin-alias-info__description' => "Upravit kontaktní informace dalšího účtu správce.",
    'ui__admin-alias-info__short-title' => "Kontaktní údaje",
    'ui__admin-alias-info__title' => "Informace o dalším účtu správce",
    'ui__admin-alias-password__description' => "Změnit další heslo správce.",

    'ui__admin-alias-password__short-title' => "Změnit heslo",
    'ui__admin-alias-password__title' => "Další heslo správce",
    'ui__admin-alias__description' => "Zobrazit a změnit informace o dalších účtech správce.",

    'chk_js__warning_about_login_syntax' => "V přihlašovacím jménu můžete použít malé alfanumerické znaky, pomlčku a podtržítko. Přihlašovací jméno musí začínat abecedním znakem. Heslo nesmí obsahovat přihlašovací jméno a uvozovky.",
    'chk_js__warning_about_ftp_login_syntax' => "V přihlašovacím jménu můžete použít alfanumerické znaky, pomlčku a podtržítko.",
    'chk_js__warning_about_login_syntax_win' => "V přihlašovacím jménu můžete použít malé alfanumerické znaky, pomlčku, tečku a podtržítko. Přihlašovací jméno musí začínat abecedním znakem nebo číslicí. Heslo nesmí obsahovat přihlašovací jméno a uvozovky.",
    'chk_js__warning_about_passwd_syntax' => "V heslech nepoužívejte uvozovky, mezery a národní abecední znaky.\nDélka hesla by měla být mezi %1 a %2 znaky. Heslo by nemělo obsahovat uživatelské jméno.",
    'chk_js__warning_about_plesk_login_syntax' => "V přihlašovacím jménu můžete použít malé alfanumerické znaky, tečku, pomlčku a podtržítko.",
    'chk_js__warning_about_plesk_login_syntax_win' => "V přihlašovacím jménu můžete použít malé alfanumerické znaky, pomlčku a podtržítko. Přihlašovací jméno musí začínat abecedním znakem.",
    'chk_js__warning_about_plesk_passwd_syntax' => "V heslech nepoužívejte uvozovky, mezery a národní abecední znaky.\nDélka hesla by měla být mezi %1 a %2 znaky. Heslo by nemělo obsahovat uživatelské jméno.",
    'chk_js__warning_about_pam_passwd_error' => "Byl zadán chybný účet uživatele systému: %1",

    'cmd_server__admin_alias_not_found' => "Nelze najít další účet správce.",

    'panel_branding__skins_already_exists' => "Poznámka: motiv \\&amp;apos;%1\\&amp;apos; již existuje. Bude nahrazeno motivem, který právě instalujete.",
    'panel_branding__skins_file_exists' => "Nelze vytvořit adresář pro motiv \\&amp;apos;%1\\&amp;apos;: Soubor s tímto názvem již existuje.",

    'actionlog__login_failed' => 'přihlášení se nezdařilo',
    'actionlog__event_cp_user_login_failed' => 'Přihlášení uživatele Plesk se nezdařilo',
    'actionlog__api_login_failed' => 'přihlášení prostřednictvím API se nezdařilo',
    'actionlog__event_cp_user_api_login_failed' => 'Přihlášení uživatele Plesk prostřednictvím API se nezdařilo',
    'actionlog__pw_reset' => 'vyžádáno obnovení hesla',

    'ch_pass_admin__email_subject' => "Připomenutí hesla Plesk",
    'ch_pass_admin__email_body' => "Dobrý den, %1.\n\nHeslo správce nelze z bezpečnostních důvodů zasílat e-mailem.\n\nChcete-li se přihlásit jako 'admin', použijte příkaz 'plesk login'.\n\nChcete-li zadat nové heslo pro 'admin', použijte příkaz 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Nelze odeslat e-mail: %1',

    'ch_pass_by_secret__email_subject' => "Připomenutí hesla Plesk",
    'ch_pass_by_secret__email_body' => "Zdravíme uživatele %2,\n\nChcete-li nastavit nové heslo, přejděte na odkaz: %1\n\nVaše přihlašovací jméno: %3",
    'ch_pass_by_secret__message_send_error' => 'Nelze odeslat zabezpečovací klíč: %1',
    'ch_pass_by_secret__title' => 'Změnit heslo',
    'ch_pass_by_secret__secret' => 'Zabezpečovací klíč',

    'custom_button__noframe' => "Nepoužívat rámečky",

    'custom_button__internal_hint' => 'Určete, zda chcete otevřít adresu URL na stránce Plesk nebo v novém okně prohlížeče.',
    'custom_button__noframe_hint' => 'Pokud přidáte uživatelské tlačítko, které vede na rozšíření Plesk nebo na aplikaci na panelu zákazníka, můžete specifikovat, jak se má toto rozšíření/aplikace zobrazovat: v rámečku nebo jako součást grafického rozhraní (GUI) Plesk.',


    'actionlog__patch' => 'Aktualizovat',
    'actionlog__patch_available' => 'dostupný',
    'actionlog__event_patch_available' => 'Aktualizace je k dispozici.',
    'actionlog__patch_installed' => 'nainstalováno',
    'actionlog__event_patch_installed' => 'Byla nainstalována aktualizace',

    'actionlog__extension' => 'Rozšíření',
    'actionlog__extension_status' => 'Stav rozšíření',
    'actionlog__cloning' => 'Klonování serveru',
    'actionlog__cloning_complete' => 'hotovo',
    'actionlog__event_cloning_complete' => 'Klonování serveru dokončeno',

    'actionlog__ssl_web_binding' => 'Certifikát SSL/TLS certifikát na doméně',
    'actionlog__ssl_web_binding_update' => 'přiřazen/nepřiřazen',
    'actionlog__event_ssl_web_binding_update' => 'Certifikát SSL/TLS na doméně přiřazen/nepřiřazen',

    'actionlog__ssl_web_mail_binding' => 'Certifikát SSL/TLS na webovém rozhraní pošty',
    'actionlog__ssl_web_mail_binding_update' => 'přiřazen/nepřiřazen',
    'actionlog__event_ssl_web_mail_binding_update' => 'Certifikát SSL/TLS na webovém rozhraní pošty přiřazen/nepřiřazen',

    'actionlog__ssl_mail_binding' => 'Certifikát SSL/TLS na poštovním serveru',
    'actionlog__ssl_mail_binding_update' => 'přiřazen/nepřiřazen',
    'actionlog__event_ssl_mail_binding_update' => 'Certifikát SSL/TLS na poštovním serveru přiřazen/nepřiřazen',

    'actionlog__ssl_panel_binding' => 'Certifikát SSL/TLS na Plesk',
    'actionlog__ssl_panel_binding_update' => 'přiřazen/nepřiřazen',
    'actionlog__event_ssl_panel_binding_update' => 'Certifikát SSL/TLS v prostředí Plesk přiřazen/nepřiřazen',

    'actionlog__hostname' => 'Název hostitele serveru',
    'actionlog__hostname_changed' => 'změněno',

    'actionlog__smb_user' => 'Další uživatel',
    'actionlog__smb_user_create' => 'Vytvořen další uživatel',
    'actionlog__smb_user_delete' => 'Další uživatel odstraněn',
    'actionlog__smb_user_update' => 'Další uživatel aktualizován',

    'actionlog__event_mail_management_status_update' => 'Aktualizace stavu správy pošty',
    'actionlog__mail_management' => 'Stav správy pošty',
    'actionlog__mail_management_status_update' => 'aktualizováno',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Celkem podle domén',

    'chk_js__warning_about_admin_passwd_syntax' => "V heslu nepoužívejte uvozovky, mezery, středníky a znaky národních abeced. Heslo musí mít délku %1 až %2 znaků a nesmí obsahovat přihlašovací jméno.",

    'passwordSecurityLevelCheckFailed' => 'Vaše heslo není dostatečně složité. Podle zásad serveru je minimální síla hesla %1. Chcete-li sílu hesla zvýšit, použijte číslice, velká a malá písmena a zvláštní znaky, např.: !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Velmi slabé',
    'passwordSecurityLevelCheckFailedWeak' => 'Slabé',
    'passwordSecurityLevelCheckFailedMediocre' => 'Střední',
    'passwordSecurityLevelCheckFailedStrong' => 'Vysoká',
    'passwordSecurityLevelCheckFailedStronger' => 'Velmi silné',

    'filemanager__invalid_path' => "Byla zadána neplatná cesta",

    'ui__client/domain/dns/sync__description' => 'Změny ze šablony DNS pro celý server použít na zónu.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Nelze použít změny šablony DNS na zóně, protože zóna je obsluhována jiným serverem DNS.',
    'ui__client/domain/dns/sync__short-title' => 'Použít změny šablony DNS',
    'ui__client/domain/dns/sync__done' => 'Změny ze šablony DNS byly úspěšně použity na zónu.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Změny ze šablony DNS pro celý server použít na zónu.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Nelze použít změny šablony DNS na zóně, protože zóna je obsluhována jiným serverem DNS.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Použít změny šablony DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Změny ze šablony DNS byly úspěšně použity na zónu.',
    'dns__dns_default_ipv4_modified' => 'Záznamy s touto IP adresou budou považovány za modifikovány uživatelem a nebudou synchronizovány se šablonou DNS na celém serveru.',
    'dns__dns_default_ipv6_modified' => 'Záznamy s touto IP adresou budou považovány za modifikovány uživatelem a nebudou synchronizovány se šablonou DNS na celém serveru.',

    'dns__view_dns_record_master_title' => 'Prohlížení záznamů prostředků',
    'dns__view_dns_record_off_title' => 'Prohlížení záznamů názvových serverů',
    'dns__view_dns_record_slave_title' => 'Prohlížení záznamů primárního serveru DNS',

    'dns_unable_to_resolve_hostname' => "Nelze rozpoznat název hostitele \"%1\": %2 Ujistěte se, že překladač DNS operačního systému je nastaven a pracuje správně.",

    'no_database_server_available' => 'Pro toto předplatné nejsou k dispozici žádné servery databáze.',

    'database_used_by_application_can_not_be_moved' => 'Nelze přesunout databázi: tuto databázi používá webová aplikace.',
    'database_user_update_orphaned_is_restricted' => 'Aktualizace osamocených účtů uživatele databáze je zakázána. Můžete je pouze odstranit nebo opravit.',

    'database_unable_to_get_max_filesize_default_message' => 'Nelze určit maximální velikost souboru databáze: \\&amp;apos;%1\\&amp;apos;',
    'database_unable_to_set_max_filesize_default_message' => 'Nelze nastavit maximální velikost souboru databáze: \\&amp;apos;%1\\&amp;apos;',
    'database_unable_to_get_max_log_filesize_default_message' => 'Nelze určit maximální velikost souboru protokolu databáze: \\&amp;apos;%1\\&amp;apos;',
    'database_unable_to_set_max_log_filesize_default_message' => 'Nelze nastavit maximální velikost souboru protokolu databáze: \\&amp;apos;%1\\&amp;apos;',

    'database_unable_to_get_max_filesize' => 'Nelze určit aktuální limit velikosti souboru databáze Microsoft SQL \\&amp;apos;%1\\&amp;apos;. Nastavení nového limitu je nemožné.',
    'database_unable_to_set_max_filesize' => 'Nelze nastavit limit velikosti souboru databáze Microsoft SQL \\&amp;apos;%1\\&amp;apos;.',
    'database_unable_to_get_max_log_filesize' => 'Nelze určit aktuální limit velikosti souboru protokolu databáze Microsoft SQL \\&amp;apos;%1\\&amp;apos;. Nastavení nového limitu je nemožné.',
    'database_unable_to_set_max_log_filesize' => 'Nelze nastavit limit velikosti souboru protokolu databáze Microsoft SQL \\&amp;apos;%1\\&amp;apos;.',

    'database_unable_to_create_because_max_filesize' => 'Nelze vytvořit databázi Microsoft SQL \\&amp;apos;%1\\&amp;apos;: její velikost souboru je větší než maximální povolená velikost.',
    'database_unable_to_move_because_max_filesize' => 'Nelze přesunout databázi Microsoft SQL \\&amp;apos;%1\\&amp;apos;: její velikost souboru je větší než maximální povolená velikost: %2',
    'database_unable_to_create_because_max_log_filesize' => 'Nelze vytvořit databázi Microsoft SQL \\&amp;apos;%1\\&amp;apos;: její soubor protokolu je větší než maximální povolená velikost.',
    'database_unable_to_move_because_max_log_filesize' => 'Nelze přesunout databázi Microsoft SQL \\&amp;apos;%1\\&amp;apos;: velikost jejího souboru protokolu je větší než maximální povolená velikost: %2',
    'database_unable_to_restore_because_max_filesize' => 'Nelze obnovit databázi Microsoft SQL \\&amp;apos;%1\\&amp;apos;: její velikost je větší než maximální povolená velikost.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Totožný server MS SQL je již zaregistrován v prostředí Plesk. Zadejte jiný server MS SQL jako izolovaný prostor (sandbox).',
    'database_server__mssql_server_registered_as_sandbox' => 'Totožný izolovaný prostor (sandbox) MS SQL je již zaregistrován v prostředí Plesk. Zadejte jiný server MS SQL jako izolovaný prostor (sandbox).',

    'database_server_mysql_unable_to_connect_via_cli' => 'Nelze se připojit k serveru prostřednictvím „%1“: %2',

    'bu_conflict_resolver_feature_not_available' => 'Funkce %1 není podporována těmito uzly služby: %2. Tato funkce bude pro všechny objekty vytvořené na těchto uzlech, vypnuta.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Funkce %1 není serverem podporována. Tato funkce bude pro všechny obnovené objekty zakázána.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Součást %1 není nainstalována. Bude nedostupná pro následující weby: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Součást %1 není nainstalována. Bude nahrazena položkou %2 pro následující weby: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Aktuální verze Plesk nepodporuje přihlašovací jména s tečkou (.). Zákazníci a prodejci s takovými přihlašovacími jmény nebudou obnoveni.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Nelze najít soubor zálohy s daty pro %1 %2. Data pro %1 %2 se neobnoví.',

    'bu_conflict_resolver_zone_master_removed' => "Nelze obnovit primární záznam serveru DNS: Záznam v sekundární zóně směřuje ke stávající IP adrese %1. Záznam primárního serveru DNS bude ze sekundární zóny odebrán.",

    'bu_conflict_resolver_not_available_scripting' => '%1 není podporováno.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 není podporováno. Bude nedostupná pro následující weby: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Součást %1 není nainstalována.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Bude nedostupná pro následující uzly služby: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Bude nedostupná pro následující objekty: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Následující databázové servery nejsou k dispozici na tomto serveru: %1',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Soubor zálohy databáze MS SQL se ukládá v nativním formátu MS SQL a lze ho obnovit pouze na místní server MS SQL nebo na vzdálený server MS SQL s plně nakonfigurovaným nastavením zálohování. Některé databáze nebyly obnoveny, protože v prostředí Plesk není zaregistrován žádný vhodný server MS SQL. Byly ovlivněny následující domény: {{objects}}. Obraťte se na svého poskytovatele hostingu.',

    'bu_conflict_resolver_not_available_webmail' => 'Webové rozhraní pošty %1 je nedostupné. Bude nahrazeno položkou %2 pro následující objekty: {{objekty}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Webové rozhraní pošty %1 je nedostupné. Bude nahrazeno položkou %2 pro následující plány služeb: {{objekty}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Databáze typu \\&amp;apos;%1\\&amp;apos; nepodporují jména uživatelů, která se shodují s názvy databáze. Uživatel \\&amp;apos;%2\\&amp;apos; bude přejmenován \\&amp;apos;%3\\&amp;apos; pro databázi \\&amp;apos;%4\\&amp;apos;.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'V konfiguraci cílového serveru není nastaven limit využití místa na disku. Hodnota tohoto nastavení bude změněna na "Neomezeno".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'V konfiguraci cílového serveru není nastaven limit počtu připojení. Hodnota tohoto nastavení bude změněna na "Neomezeno".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'V konfiguraci cílového serveru není nastaven limit využití přenosu dat. Hodnota tohoto nastavení bude změněna na "Neomezeno".',
    'cu__pleskrestore_backup_file_extracted' => 'Soubor zálohy byl rozbalen do "%1".',
    '__mod_bw_not_supported' => 'Modul mod_bw pro webový server Apache není podporován kvůli konfiguraci systému souborů. Omezení využití přenosu a maximální počet připojení nebude pracovat.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Autorizace POP3 pro předávání pošty není podporována, místo toho se použije POP3 před autorizací SMTP. ({{objekty}})',
    'bu_conflict_resolver_service_plan_name' => 'Plán služby \\&amp;apos;%1\\&amp;apos;',
    'bu_conflict_resolver_replaced_in_plans' => '%1 není podporováno. Bude nahrazeno položkou %2 pro následující plány služeb: {{objekty}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 není podporováno. Bude nahrazena položkou %2 pro následující weby: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Následující objekty nebyly nalezeny v souboru zálohy: %1',
    'bu_conflict_resolver_absent_domains' => 'Některé objekty nelze obnovit, protože patří do následujících domén, které nebyly nalezeny v prostředí Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Některé weby nelze obnovit, protože patří do následujících nadřazených domén, které nebyly nalezeny v prostředí Plesk: %1",
    'bu_conflict_resolver_dns_not_supported' => 'Nelze obnovit zóny DNS: služba DNS je v konfiguraci serveru vypnuta.',
    'bu_conflict_resolver_mail_not_supported' => 'Nelze obnovit poštovní schránky: poštovní služba je v konfiguraci serveru vypnuta.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Specifikované omezení akce pro procesor není podporováno webovým serverem služby IIS. Hodnota se vynuluje na %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Certifikát serveru SSL/TLS %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Certifikát SSL/TLS %2 pro doménu %1',
    'bu_conflict_detector_ssl_cert_name' => 'Certifikát SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Obsah následujících objektů nelze obnovit, protože objekty nebyly nalezeny v prostředí Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Obsah následujících poštovních schránek nelze obnovit, protože poštovní schránky nebyly nalezeny v prostředí Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Obsah následujících seznamů adresátů nelze obnovit, protože seznamy adresátů nebyly v prostředí Plesk nalezeny: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Obsah následujících databází nelze obnovit, protože databáze nebyly nalezeny v prostředí Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Obnovení aplikace "%1" na &quot;%2&quot; se nezdařilo, protože je na &quot;%3&quot; již nainstalována jiná aplikace. Nainstalovanou aplikaci můžete odebrat a zkusit to znovu.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Funkce automatická odpověď pošty není podporována.',
    'bu_conflict_resolver_not_available_mail_content' => 'Funkce obnovení obsahu pošty není podporována.',
    'bu_conflict_resolver_invalid_mail_name' => 'Následující poštovní schránky nebyly obnoveny, protože je povoleno subadresování e-mailu a některé e-mailové adresy obsahují znak „%1“: %2',
    'bu_conflict_resolver_invalid_user_name' => 'Následující uživatelé nebyli obnoveni, protože je povoleno subadresování e-mailu a některé e-mailové adresy obsahují znak „%1“: %2',
    'bu_conflict_resolver_licenses_expired' => 'Následující licence expirovaly a nebudou obnoveny: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Následující licence nejsou platné nebo expirovaly a nebudou obnoveny: {{objects}}',
    'expiration_unsupported' => "Limit \\&amp;apos;expiration\\&amp;apos; není podporován.",

    'component_name__dbconnector' => "Databázový konektor",
    'component_name__mysqlserver' => 'Server MySQL',
    'component_name__troubleshooting' => 'Řešení potíží',
    'component_name__savi' => 'Rozhraní antiviru Sophos',

    '__subscription_has_no_license_key' => 'Prostředky předplatného poskytuje uzel služby #%1, který nemá přiřazený licenční klíč.',
    '__subscription_has_expired_license_key' => 'Prostředky předplatného poskytuje uzel služby #%1, jehož licenční klíč %2 vypršel.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Nelze uložit konfigurační soubory',
    '__cfgmonConfigurationFileSaveErrorBody' => "Nelze uložit některé konfigurační soubory na hostiteli <%%host%%>: Došlo k následujícím chybám: %%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Tato možnost povoluje možnost konfigurovat e-mailové adresy ve stylu VERP pro poštovní seznamy',
    'mail__enter_right_ip_mask' => "Vložit IP masku v rozmezí 1 až 32",
    'mail__enter_right_ip_mask_24' => "Vložit IP masku v rozmezí 24 až 32",
    'mail__invalid_dom_name' => "Název domény %1 je neplatný.",
    'mail__invalid_pop_lock_time' => "Časový zámek POP3 je neplatný.",
    'mail__invalid_rbl_server' => "Název zóny DNS je neplatný.",
    'mail__total_files_size' => "Celková velikost úložiště: %1",
    'mail__filename_already_in_repository' => "Soubor se stejným názvem je již v úložišti",
    'mail__no_white_list_mask_feature_24' => "Použít hodnotu masky 24 nebo vyšší.\nVáš e-mailový server nepodporuje nastavení masky. Můžeme emulovat pouze nastavení masky pro hodnoty, které nejsou menší než 24.",
    'mail__unable_add_new_mail_name' => "Nelze přidat e-mailový účet: %1",
    'mail_server_is_not_installed' => 'E-mailový server (Postfix nebo Qmail) není nainstalován. Nainstalujte si ho, abyste mohli pokračovat v práci.',
    'mail_server_not_available' => 'Na uzlu služby nejsou žádné podporované e-mailové servery',
    '__not_installed' => '(není nainstalováno)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Režim filtrování zpráv odchozí e-mailové zprávy je vypnutý.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Uzel služby nepodporuje omezení počtu odchozích e-mailových zpráv z domény pro doménu %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Uzel služby nepodporuje omezení počtu odchozích e-mailových zpráv z poštovní schránky pro doménu %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Zadat adresu nejméně jednoho typu (IPv4 nebo IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Byl zadán neplatný režim odchozí pošta.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Byla zadána neplatná adresa IPv4.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Byla zadána neplatná adresa IPv6.',
    'mail__outgoing_email_mode_unavailable' => 'Změna režimu odchozí pošty není podporována, pravděpodobně proto, že e-mailový server Postfix není na tomto serveru nainstalován.',

    'mail__autoresponder_attachment_not_supported' => 'Momentálně používaný e-mailový server nepodporuje správu příloh automatického odpovídače.',

    'mail__smtp_white_list_not_supported' => 'Aktuálně používaný poštovní server nepodporuje whitelisting IP adres.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Aktuálně vybraný poštovní server nepodporuje masky CIDR. Zadejte IP adresu ve formátu „192.*.0.*“.',
    'mail__smtp_whitelist_mask_not_supported' => 'Vzory IP se zástupnými znaky nejsou aktuálně vybraným poštovním serverem podporovány. Zadejte IP adresu ve formátu „192.0.0.0/8“.',

    'sfdk_server_wide_verify_failed' => 'Nelze změnit nastavení pro ověřovací službu DKIM',

    'sfdk_domain__serverwide_disabled' => 'Vypnuto podle zásad serveru',
    'feature__domainkeys__serverwide_disabled' => 'Antispamová ochrana DKIM celého serveru je vypnuta',

    'defaultcomponents__error_set_default' => 'Nelze nastavit %1 jako výchozí %2: %3',
    'defaultcomponents__error_set_default_none' => 'Nelze nastavit žádnou výchozí komponentu pro %1: %2',
    'defaultcomponents__required_package_not_default' => 'Součást %1 požadovaná pro její činnost není výchozí.',

    '__percentage' => '%',
    '__seconds' => 'Sekundy',
    '__resource_remain' => 'Zbývající',

    '__not_registered' => '(neregistrováno)',
    '__php_handler_id' => 'Verze PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Obslužná rutina PHP "%1" není zaregistrována. Pravděpodobně byla odstraněna ze serveru. Zaregistrujte obslužnou rutinu se stejnými vlastnostmi a zkuste to znovu.',
    '__php_handler_not_registered_on_domain' => 'Doména "%1": Obslužná rutina PHP "%2" není zaregistrována. Pravděpodobně byla odstraněna ze serveru. Zaregistrujte obslužnou rutinu se stejnými vlastnostmi a zkuste to znovu.',
    '__php_fpm_handler' => 'Aplikace FPM',
    '__php_fpm-dedicated_handler' => 'Vyhrazená aplikace FPM',

    'mailname_create_assigned_user_dublicate_error' => 'Nelze vytvořit uživatele pro poštovní schránku. Uživatel se jménem %1 již existuje a má jinou poštovní schránku.',
    'mailname_create_assigned_user_role_absent_error' => 'Nelze vytvořit uživatele pro poštovní schránku. Výchozí role %1 uživatele neexistuje.',

    'gphd__mime_types' => 'Typy MIME',
    'gphd__handlers' => 'Obslužné rutiny Apache',
    'gphd__ip_restrictions_allow' => 'Povolit přístup na web pro zadané hostitele a sítě (kromě těch se zakázaným přístupem)',
    'gphd__ip_restrictions_deny' => 'Odepřít přístup na web pro zadané hostitele a sítě',
    'gphd__directory_index' => 'Indexové soubory',
    'gphd__nginx_transparent_mode' => 'Režim, v němž Apache zpracovává statický i dynamický obsah, zatímco nginx prochází pouze žádosti a odpovědi bez úprav.',
    'gphd__nginx_serve_static' => 'Zpracovat statické soubory přímo prostřednictvím nginx',
    'gphd__nginx_static_extensions' => 'Přípony statických souborů, které musí být zpracovány prostřednictvím nginx',
    'gphd__nginx_serve_php' => 'Zpracovat soubory PHP prostřednictvím nginx',
    'gphd__www_root' => 'Kořenový adresář WWW',

    'eol__none' => 'neupravovat',
    'eol__lf' => 'převést na styl Unix',
    'eol__cr' => 'převést na styl MacOS',
    'eol__crlf' => 'převést na styl Windows',

    'ui__dns_bad_zone' => 'Nekonzistentní Zóna "%1":',
    'ui__dns_ns_has_no_address_records' => 'Záznam NS "%1" nemá žádné záznamy adres (A nebo AAAA).',
    '__dns_bad_zone' => 'Nekonzistentní Zóna "%1":',
    '__dns_ns_has_no_address_records' => 'Záznam NS "%1" nemá žádné záznamy adres (A nebo AAAA).',
    '__dns_ptr_is_wildcard' => 'Záznam PTR "%1" je neplatný: Záznam ukazuje na náhradní doménu.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Povolit vzdálený přístup pro uživatele databáze \\&amp;apos;%3\\&amp;apos; zákazníka \\&amp;apos;%4\\&amp;apos;',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Nelze povolit vzdálená připojení pro uživatele databáze \\&amp;apos;%1\\&amp;apos;: Nelze určit číslo portu TCP používaného serverem Microsoft SQL \\&amp;apos;%2\\&amp;apos;. Možné příčiny: protokol TCP/IP není povolen v konfiguraci sítě serveru nebo je server nakonfigurován na použití dynamických portů TCP. Nakonfigurujte server na poslech na zadaném pevném portu TCP a znovu zkuste povolit vzdálená připojení.',

    'command__convertResellerHasCustomer' => 'Účet prodejce \\&amp;apos;%1\\&amp;apos; má jeden nebo několik zákaznických účtů. Chcete-li převést tento účet prodejce na účet zákazníka, nejprve přeneste tyto zákaznické účty na nového vlastníka nebo je převeďte na účet prodejce.',
    'command__convertResellerNotReseller' => 'Na zákaznické účty lze převést pouze účty prodejce. \\&amp;apos;%1\\&amp;apos; není prodejce.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Nelze synchronizovat předplatné s plánem služeb. Následující nastavení předplatného je v konfliktu s plánem služeb: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Účet \\&amp;apos;%1\\&amp;apos; je účtem prodejce. Účty prodejce nelze přesunout na nového vlastníka, protože jsou ve vlastnictví správce serveru.',
    'moveCustomer__wrong_owner_type' => "Účet zákazníka \\\\&amp;apos;%1\\\\&amp;apos; lze přesunout pouze na prodejce nebo správce, ne na jiného zákazníka.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Účet zákazníka \\&amp;apos;%1\\&amp;apos; již patří vybranému vlastníkovi.',
    'upgradeClient__user_is_admin' => 'Účet \\&amp;apos;%1\\&amp;apos; nelze převést na účet prodejce, protože se jedná o účet správce.',

    'mail__error_setting_max_connections_courier' => 'Nelze nastavit maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Nelze nastavit maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Nelze nastavit maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS) na IP adresu: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Nelze nastavit maximální počet připojení (IMAP, POP3, IMAP přes SSL/TLS nebo POP3 přes SSL/TLS) na IP adresu pro zadaného uživatele e-mailu: %1',
    'outgoing_messages_limit_value_invalid' => 'Hodnota musí být v rozsahu %%MIN%%..%%MAX%%. Nastavení smí upravit pouze správce prostředí Plesk.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Následující domény používají externí e-mailové adresy k předávání pošty odesílané na neexistující adresy. Zprávy odeslané na tyto adresy se nebudou započítávat do Zabezpečení odchozí pošty: %1",
    'outgoing_messages_white_list_not_empty' => 'Limity odchozí pošty nebudou pracovat pro odesílatele pošty, jejichž IP adresy jsou na bílé listině e-mailového serveru. Například pokud bude položka localhost (127.0.0.0 / 8, ::1 / 128) zařazena do bílé listiny, veškerá pošta z místního serveru bude úspěšně odeslána bez ohledu na omezení. Odesílatelé e-mailu mohou použít buď místní IP adresy (weby a vlastní skripty hostované na místním serveru) nebo externí (zákazníci, kteří odeslali e-mail z e-mailových klientů nainstalovaných na svých počítačích nebo mobilních zařízení). Aby byly limity funkční pro všechny odesílatele (místní i externí), odeberte všechny IP adresy a sítě z bílé listiny. Všimněte si, že pokud odeberete položku localhost (127.0.0.0 / 8, ::1 / 128) z bílé listiny, provoz webů a skriptů, které odesílají poštu z tohoto serveru, se může narušit. Podrobnosti týkající se omezení odchozí pošty naleznete v dokumentu Příručka pro správce, Ochrana před odchozím spamem.',
    'outgoing_messages_relay_open' => 'Předávání pošty je otevřeno: Limity odchozí pošty nebudou pracovat.',

    'notification_aps_app_updates_available' => 'Pro následující aplikace jsou k dispozici aktualizace:',
    'notification_aps_app_updates_installed' => 'Pro následující aplikace byly automaticky nainstalovány aktualizace:',
    'notification_aps_app_updates_requirements' => 'Pro následující aplikace jsou k dispozici aktualizace, ale nelze je nainstalovat, protože nastavení hostingu odpovídajících webů nesplňuje požadavky na instalaci:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Zásuvný modul "%%name%%" na %%parentName%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Motiv "%%name%%" na %%parentName%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Zásuvný modul "%%name%%" na %%parentName%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Motiv "%%name%%" na %%parentName%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Vaše verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Zásuvný modul "%%name%%" na %%parentName%% (%%url%%). Vaše verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Motiv "%%name%%" na %%parentName%% (%%url%%). Vaše verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nová verze: %%to%%. Předchozí verze: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nová verze: %%to%%. Předchozí verze: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Nová verze: %%to%%. Předchozí verze: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Nainstalovaná verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Vaše verze: %%from%%. Dostupná verze: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'externí aplikace',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domény',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-mailové adresy',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Předplacené služby',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 zpráv za hodinu',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Neomezeno',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, limit je %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 pokusy(ů) o překročení limitu z %2 na %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 pokusy(ů) o překročení limitu z %2 až dosud',

    'restart__docker' => "Řešení Docker",
    'restart__fail2ban' => "Zablokování IP adresy (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Na cílovém serveru není nainstalována součást Fail2ban.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Instalovat Fail2ban. Pamatujte si, že tato operace může trvat několik minut.',

    'plesk_key__no_reseller_support' => 'Kvůli licenčnímu omezení nelze spravovat prodejce.',
    'plesk_key__no_customers_support' => 'Kvůli licenčnímu omezení nelze spravovat zákazníky.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Kvůli licenčnímu omezení nelze přepnout na režim zobrazení Poskytovatel služeb.',
    'plesk_key__no_security_core_support' => 'Kvůli licenčnímu omezení nejsou k dispozici funkce zabezpečovacího jádra (ModSecurity a Fail2Ban).',
    'plesk_key__outgoing-antispam' => 'Zabezpečení odchozí pošty',
    'plesk_key__security-core' => 'Zabezpečovací jádro (ModSecurity a Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Správa účtů',
    'plesk_key__can-manage-subscriptions' => 'Správa předplacených služeb',
    'plesk_key__can-manage-customers' => 'Správa zákazníků',
    'plesk_key__can-manage-resellers' => 'Správa prodejců',
    'plesk_key__can-manage-custom-view' => 'Dostupnost pro Omezený režim',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Správa předplatného je vypnuta, ale máte několik předplatných (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Správa prodejců je vypnuta, ale máte několik prodejců (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Správa zákazníků je vypnuta, ale máte několik zákazníků (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Některé zdroje v rámci předplatného, které již není možné v rozhraní platformy Plesk spravovat (například limity pro diskový prostor schránek a domén), jsou nyní nastaveny neomezeně.',
    'plesk_key__no_subscriptions_support' => 'Kvůli licenčnímu omezení nelze spravovat předplacené služby.',
    'plesk_key__no_custom_view_support' => 'Omezený režim nelze použít kvůli licenčnímu omezení.',
    'plesk_key__trial_forbidden_region' => 'Prostředí Plesk není bohužel ve vaší oblasti dostupné.',
    'additional_key__main_key' => 'Klíč je hlavním klíčem: Hlavní klíč nelze nahrát jako další klíč.',

    'gch__hosting_waf_rule_engine' => 'Režim webová aplikační brána firewall',

    'backup__fieldset__restoration_options' => 'Možnosti obnovení',
    'backup__restore_options__restore' => 'Obnovit',
    'backup__restore_options__domain__domain_configuration' => 'Konfigurace domény',
    'backup__restore_options__domain__virtual_host_content' => 'Obsah virtuálního hostitele',
    'backup__restore_options__domain__mail' => 'Pošta',
    'backup__restore_options__domain__databases' => 'Databáze',
    'backup__restore_options__client__client_configuration' => 'Konfigurace účtu zákazníka',
    'backup__restore_options__client__domains' => "Domény zákazníka",
    'backup__restore_options__reseller__reseller_configuration' => 'Konfigurace účtu prodejce',
    'backup__restore_options__reseller__personal_domains' => "Domény prodejce",
    'backup__restore_options__reseller__clients' => "Zákazníci prodejce",
    'backup__restore_options__admin__server_configuration' => 'Nastavení serveru',
    'backup__restore_options__admin__administrator_configuration' => 'Konfigurace účtu správce:',
    'backup__restore_options__admin__personal_domains' => "Domény správce",
    'backup__restore_options__admin__personal_clients' => "Zákazníci správce",
    'backup__restore_options__admin__resellers' => 'Distributoři',

    'badge_new' => 'Nový',
    'upgrade_php_on_subscription' => 'Aktualizovat PHP na vašem předplatném na verzi 5.3.0 nebo novější.',

    'pkey_notify__body_expiration_notification' => 'Licenční klíč vypršel. Některé funkce mohou být nedostupné. Obraťte se na svého poskytovatele hostingu.',

    'crontab__crontab_entry_exists' => "Naplánovaná úloha již existuje.",
    'crontab__crontab_entry_not_exists' => "Naplánovaná úloha neexistuje.",
    'crontab__invalid_values_found' => "Nesprávné hodnoty parametru.",
    'crontab__cmd_max_len' => "Příkaz nesmí být delší než %1 znaků.",

    'domain__domain_exists' => "Existuje doména s předponou \\&amp;apos;www\\&amp;apos; a stejným názvem: %1.%2.",
    'domain__subdomain_exists' => "Existuje subdoména s předponou \\&amp;apos;www\\&amp;apos; a stejným názvem: %1.%2.",
    'domain__dalias_exists' => "Existuje alias domény s předponou \\&amp;apos;www\\&amp;apos; a stejným názvem: %1.%2.",
    'domain__record_exists' => "Existuje záznam DNS odkazující na hostitele %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Certifikát \\&amp;apos;%1\\&amp;apos; nelze nastavit jako výchozí: privátní klíč chybí.",
    'ip_addr__update_dns_error' => 'Při aktualizaci IP adresy v zónách DNS se vyskytly potíže. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Nelze přidat IP adresu. Toto síťové rozhraní získává IP adresy automaticky.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Nelze odebrat IP adresu %1. Toto síťové rozhraní získává IP adresy automaticky.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Nelze opravit IP adresu %1. Toto síťové rozhraní získává IP adresy automaticky.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Nelze změnit rozhraní IP adresy %1, protože síťové rozhraní %2 získává IP adresy automaticky.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Byl překročen limit předplatného v počtu %%type%%. Limit je %%limit%% a právě se využívá %%usage%%.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Vytvoření %%type%% není pro toto předplatné povoleno.',
    'shm_lmsg__resource_title__db-mysql' => 'Databáze MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Databáze MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Databáze PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'Uživatelé databáze',
    'shm_lmsg__resource_title__iis-application-pool' => 'Fondy aplikací IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'Další účty FTP',

    'db_user_unable_remove_mysql_global_privileges' => 'Nelze odebrat globální oprávnění MySQL uživatele databáze %1. Důvod: %2',
    'report__client_description' => 'Popis',

    'db__user_role_error' => 'Byla zadána nesprávná role uživatele databáze: %1. Zvolte jednu z následujících rolí: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Nelze nastavit omezení velikosti souboru pro následující databázi Microsoft SQL Server, protože má větší velikost souboru: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Nelze nastavit omezení velikosti souboru protokolu pro následující databázi Microsoft SQL Server, protože má větší velikost souboru protokolu: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Nelze nastavit veřejnou IP adresu: musí existovat soukromá IP adresa.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Pro adresu IPv6 nelze nastavit veřejnou IP adresu IPv4.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Pro adresu IPv4 nelze nastavit veřejnou IP adresu IPv6.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Nelze nastavit veřejnou IP adresu: Neplatná IP adresa.',

    '__user_already_exists' => "Uživatel %1 již existuje.",
    '__user_name_is_empty' => "Zadejte uživatelské jméno.",

    'upgrade_php_on_domain' => 'Na žádné z vašich domén WordPress nelze najít verzi PHP 5.3.0 nebo vyšší. Zkuste aktualizovat PHP.',

    'component_name__waf' => 'Webová aplikační brána firewall',
    'component_name__vcs' => 'Systém správy verzí',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Řešení Docker',
    'possibleSpoofingDetected' => 'Byla zjištěn možný pokus o falšování identity (spoofing): Odkaz se pokusil o zobrazení nepodstatného obsahu.',
    'forceResetPasswordUpdated' => 'Vaše heslo se změnilo. Pro přihlášení k platformě Plesk použijte nové heslo.',

    'php_handlers_error_no_available_instance' => 'Nelze vytvořit doménu: žádné dostupné obslužné rutiny PHP.',
    'domain_error_unable_to_apply_hosting_settings' => 'Nelze použít nastavení hostování: %1',

    'plesk_not_configured' => 'Prostředí Plesk není nakonfigurováno. Chcete-li provést poinstalační konfiguraci, přejděte na ovládací panel.',
    'cmd_mail__mail_password_duplicated' => 'Zadaná dvojice e-mailová adresa a heslo již existuje na e-mailovém serveru. Zadejte jinou e-mailovou adresu nebo heslo.',

    'extensionRequirementOs' => 'Operační systém (%1) není balíčkem podporován.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 je nejstarší verze podporovaná balíčkem.',
    'extensionRequirementPleskMaxVersion' => 'Verze počínající prostředím Plesk %1 nejsou balíčkem podporovány.',
    'extensionBlacklisted' => 'Rozšíření %1 není povoleno pro instalaci.',
    'extensionDisabled' => 'Rozšíření je zakázáno.',


    'optimization_settings__unable_set_mpm_event' => 'Nelze nastavit režim mpm_event: vyžaduje vypnutí modulu Apache PHP5, ale tento modul používají domény.',
    'optimization_settings__unable_turn_off_php' => 'Nelze vypnout modul Apache PHP5: tento modul používají domény.',

    'hst_def__fp_admin_login' =>  'Přihlašovací jméno FTP',
    'hst_def__fp_admin_passwd' =>  'Heslo FTP',

    'database_user_orphaned_old_password_wrong' => "Nelze opravit osamoceného uživatele '%1': heslo je nesprávné.",
    'cannot_load_partner_central_property_key_no_exist' => "Nelze načíst vlastní vlastnosti: licenční klíč neexistuje.",
    'extensionScriptFailure' => "Spuštění %1 se nezdařilo s následující zprávou:\n%3",
    '__ssl_redirect' => "Trvalé přesměrování prostřednictvím zabezpečeného protokolu SEO 301 z HTTP na HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Správa DKIM není podporována.',
    'mail__dmarc_not_supported' => 'Správa DMARC není podporována.',
    'mail__relay_white_list_not_supported' => 'Bílá listina přenosu není podporována.',
    'mail__black_list_not_supported' => 'Správa černé listiny není podporována.',
    'mail__autoresponder_not_supported' => 'Správa automatického odpovídače není podporována.',
    'defaultcomponents__not_supported_version' => '(nepodporovaná verze)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Certifikát \'%1\' nebyl nalezen.',
    'certificate__unable_setup_certificate' => 'Nelze nainstalovat certifikát: Privátní klíč a obsah certifikátu chybí.',
    'certificate__used_by_panel' => 'Jeden z certifikátů, které se chystáte odstranit, se používá k zabezpečení prostředí Plesk.',
    'certificate__used_by_mail_server' => 'Jeden z certifikátů, které se chystáte odstranit, se používá k zabezpečení e-mailového serveru.',
    'certificate__used_by_domain_service' => 'Jeden z certifikátů, které se chystáte odstranit, používá doménová služba.',
    'mail_server__not_installed' => 'Nelze nainstalovat certifikát pro e-mailový server, protože e-mailový server není nainstalován.',

    'email_activation_mail_subject' => 'Aktivujte svůj účet v prostředí Plesk',
    'email_activation_mail_body' => "Na serveru Plesk %1 byl vytvořen účet. \n\nPodrobnosti účtu: \nNázev: %2 \nE-mailová adresa: %3 \n\nJestliže je tato informace správná a účet byl pro vás vytvořen, aktivujte ho prostřednictvím následujícího odkazu: \n\n%4 \n\nAktivací tohoto účtu udělujete majiteli serveru oprávnění ke shromažďování, ukládání, zpracování a využití svých osobních údajů (jméno a e-mailová adresa), k vytvoření a podpoře vašeho účtu, v souladu s aktuálně platnými zákony na ochranu dat, jako součást smlouvy.",

    'backup_transport_permission_name' => 'Správa %1',
    'backup_transport_permission_description' => 'Umožňuje použít %1 k ukládání záloh.',

    'domain_move_err_target_no_hosting' => 'Doménu nelze přesunou na předplatné bez hostování.',
    'domain_move_err_already_in_target' => 'Doména již patří do cílového předplatného.',
    'domain_move_err_main_domain' => 'Hlavní doménu nelze přesunout.',
    'domain_move_err_subdomain_without_parent' => 'Subdoménu %1 nelze přesunou bez nadřazené domény %2.',
    'domain_move_err_root_exists' => 'Cílová cesta na www_root %1 již existuje.',
    'domain_move_err_nested_roots' => 'Doménu nelze přesunout, protože sdílí kořen dokumentu s jinou doménou: %1.',
    'domain_move_err_no_mail_service' => 'Doménu nelze přesunout, protože v cílové předplacené službě je poštovní služba zakázána.',
    'domain_move_err_app' => "Aplikace nainstalovaná na %1 nebyla přesunuta do předplatného '%2': %3",
    'domain_move_database_used_by_app' => "Databázi '%1' na %2 používá přesunutá aplikace. Chcete-li databázi znovu přiřadit na '%3', spusťte příkaz `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Cílové předplatné '%1' bylo uzamčeno pro synchronizaci.",
    'domain_move_filesharing_disabled' => 'Sdílení souboru bylo zakázáno.',
    'domain_move_website_preview_disabled' => 'Náhled webu byl zakázán.',
    'domain_move_additional_webserver_settings' => "Prohlédněte si direktivy dalšího webového serveru domény, aby se zamezilo porušení konfigurace.",
    'domain_move_no_permission' => "%1 není povoleno pro předplatné '%2'.",
    'domain_move_no_access' => "Žádný přístup k předplacené službě '%1'.",
    'domain_split_no_create_permission' => "Vytvoření domény není povoleno.",
    'domain_split_empty_login' => 'Požaduje se přihlášení uživatele systému.',
    'domain_split_empty_password' => 'Požaduje se heslo uživatele systému.',
    'domain_split_err_home_exists' => 'Doménu %1 nelze přesunout, protože její cílová domovská cesta již existuje ve %2. Přejmenovat doménu a přesunout ji na novou předplacenou službu.',
    'domain_split_err_no_hosting_subdomains' => 'Doménu nelze přesunout na nové předplatné, protože doména nemá hostování, ale má subdomény. Chcete-li doménu přesunout, změňte její hodnotu "Typ hostingu" na "Hostování webu" (v nabídce Nastavení hostování).',
    'domain_split_target_locked' => "Cílové předplatné '%1' je uzamčeno pro synchronizaci.",
    'domain_split_target_unsynced' => "Cílové předplatné '%1' nebylo synchronizováno s plánem z důvodu: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Naplánované zálohování bylo deaktivováno v '%1'.",
    'domain_merge_database_error' => "Databáze '%1' nainstalovaná na %2 nebyla přesunuta do předplatného '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Anonymní přístup na FTP '%1\\ byl přepnut.",
    'domain_merge_smb_user_access' => "Další uživatel '%1' byl přesunut na předplacenou službu '%2', ale jeho přístup k předplatnému byl odvolán.",
    'domain_merge_scheduled_tasks' => "Naplánované úlohy byly přesunuty na cílovou předplacenou službu. Obnovit konfiguraci úloh.",
    'domain_merge_scheduled_tasks_deactivated' => "Naplánované úlohy byly přesunuty na cílovou předplacenou službu a deaktivovány. Obnovit konfiguraci úloh.",
    'domain_merge_no_remove_permission' => "Odebrání předplatného není povoleno.",
    'domain_merge_err_has_addons' => 'Nelze přesunout hlavní doménu s jejími dalšími doménami; nejprve přesuňte doménu(y) %1.',
    'domain_merge_err_has_webusers' => 'Nelze přesunout hlavní doménu s jejími uživateli webu.',
    'domain_merge_err_root_exists' => 'Cílová cesta %1 již existuje.',

    'database_server_edit_used_for_psa' => 'Aktualizace lokálního databázového serveru MySQL není povolena.',
    'suggest_repair_main_suggestion_ui' => '<b>Tuto chybu opravíte</b> pomocí nástroje „plesk repair“.',
    'suggest_repair_main_suggestion_cli' =>  'Tuto chybu opravíte pomocí nástroje „plesk repair“.',
    'suggest_repair_repair_kit_link_title' => 'přejděte do nabídky Diagnostika a oprava',
    'suggest_repair_using_cli_and_ui' => 'Za tímto účelem v rozhraní CLI zadejte příkaz „plesk repair %1“ nebo %2 a klikněte na tlačítko Opravit vedle „Databáze platformy Plesk“',
    'suggest_repair_using_cli' => 'Za tímto účelem v rozhraní CLI zadejte příkaz „plesk repair %1“',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Služba DNS nebyla při vytvoření zálohy k dispozici. V záloze ale existují aktivní zóny DNS, které budou povoleny pro následující objekty: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Ovladač prostředků (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Podpora vzdálené funkce SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(není dovoleno licenčním klíčem)',
    'plesk_key__validation_failed' => '%1 (Chybový kód: %2)',
    'promo__button_details' => 'Podrobnosti',
    'promo__extension_catalog_title' => 'Katalog rozšíření',
    'promo__extension_catalog_description' => 'Podívejte se do nového katalogu rozšíření a vylepšete svou platformu Plesk celou řadou výkonných rozšíření!',
    'promo__button_open_catalog' => 'Otevřít katalog',

    'backup__repository_check_login' => "Nelze přistoupit k úložišti: %1 Ujistěte se, že máte správně zadané přístupové údaje.",
    'backup__repository_check_error_list' => "Nelze přistoupit k úložišti: %1 Ujistěte se, že máte správně zadaná nastavení úložiště.",
    'backup__repository_check_error_mkdir' => "Nelze vytvořit adresář: %1 Zkontrolujte, jestli máte oprávnění k vytvoření složek v úložišti.",
    'backup__repository_check_error_upload' => "Nelze nahrát soubor na úložiště: %1 Zkontrolujte, jestli máte oprávnění k nahrávání souborů na úložiště.",
    'backup__repository_check_error_download' => "Nelze stáhnout soubor z úložiště: %1 Zkontrolujte, zda máte oprávnění k nahrávání a stahování souborů z úložiště.",
    'backup__repository_check_error_resume-upload' => "Nelze pokračovat v nahrávání souboru na úložiště: %1 Zkontrolujte, jestli máte oprávnění k obnovení nahrávání na úložiště.",
    'backup__repository_check_error_resume-download' => "Nelze pokračovat ve stahování souboru z úložiště: %1 Zkontrolujte, jestli máte oprávnění k obnovení stahování z úložiště.",
    'backup__repository_check_error_enable-utf8' => "Nelze provozovat úložiště: %1 Zkontrolujte, zda úložiště podporuje kódování UTF8.",
    'backup__repository_check_error_rm' => "Nelze provozovat úložiště: %1 Zkontrolujte, zda máte oprávnění ke smazání souborů z úložiště.",
    'backup__repository_check_error_rmdir' => "Nelze provozovat úložiště: %1 Zkontrolujte, zda máte oprávnění ke smazání složek na úložišti.",

    'backup__ftp_repository_check_login' => "%1 Můžete je zkontrolovat nezávisle pomocí příkazu: %2",
    'backup__ftp_repository_check_error_list' => "%1 Můžete je zkontrolovat nezávisle pomocí příkazu: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazu: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazů: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazů: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazů: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazů: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazu: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazů: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Můžete jej zkontrolovat nezávisle pomocí příkazů: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Nastavení mechanismu DMARC nelze změnit. Za účelem povolení této možnosti prosím zapněte ochranu před nevyžádanou poštou DKIM a SPF.',
    'spf_server_wide_disable_failed' => 'Nelze změnit nastavení pro ochranu před nevyžádanou poštou SPF. Za účelem vypnutí SPF prosím vypněte mechanismus DMARC pro příchozí poštu.',
    'sfdk_server_wide_verify_disable_failed' => 'Nelze změnit nastavení pro ochranu před nevyžádanou poštou DKIM. Za účelem vypnutí DKIM prosím vypněte mechanismus DMARC pro příchozí poštu.',

    'ccs_not_supported' => 'Centrální úložiště certifikátů IIS není v systému nakonfigurováno.',
    'ccs_not_enabled' => 'Na platformě Plesk není povolena správa centrálního úložiště certifikátů IIS.',
    'ad_not_supported' => 'Server není připojen k doméně.',

    'component_name__appinit' => "Inicializace aplikace",
    'component_name__httpcompression' => 'Komprese obsahu HTTP',
    'common_feature_is_not_supported' => 'Tato funkce již není podporována.',
    'common_feature_is_not_supported_in_proto' => 'Tato funkce není podporována pro verzi protokolu %1.',
    'autoinstaller__plesk_component' => 'Součást prostředí Plesk',
    'plesk_key__key_expired' => 'Váš licenční klíč vypršel. Chcete-li pokračovat v používání platformy Plesk, musíte si zakoupit nekončící komerční %1.',
    'plesk_key__key_purchase' => 'licenční klíč',

    'sa_action_move' => 'Přesunout nevyžádanou poštu do složky "Nevyžádaná pošta"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Aplikace Java už nejsou podporovány. Nebudou dostupné pro následující weby: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobilní verze webů hostované pomocí UNITY Mobile nejsou nadále podporovány. Nebudou dostupné pro následující weby: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Zásady používání nastavená na serveru nedovolují používat osobní nastavení antiviru. Tato nastavení budou nekompletně obnovena pro e-mailové účty na následujících doménách: {{objects}}',

    'module__not_installed' => "Rozšíření %1 není nainstalováno",

    'mail__mail_autodiscovery_server_error' => 'Zadejte vlastní název domény pro automatické zjišťování e-mailu',
    'mail__error_mail_autodiscovery_enable' => 'Nelze nastavit automatické zjišťování e-mailu: %1',
    'mail__error_mail_autodiscovery_server' => 'Nelze nastavit vlastní název domény pro automatické zjišťování e-mailu: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Nelze rekonfigurovat automatické zjišťování záznamů DNS na doménách: %1',

    '__invalid_url' => 'Adresa URL „%1“ není platná.',
    'actionlog__cloning_start' => 'start',
    'actionlog__event_cloning_start' => 'Spustit klonování serveru',

    '__UPLOAD_ERR_FORM_SIZE' => "Nahraný soubor přesahuje povolenou velikost",
    '__UPLOAD_ERR_INI_SIZE' => "Nahraný soubor přesahuje povolenou velikost",
    '__UPLOAD_ERR_NO_FILE' => "Nebyl přijat žádný soubor",
    '__UPLOAD_ERR_OK' => "Soubor byl úspěšně nahrán",
    '__UPLOAD_ERR_PARTIAL' => "Soubor byl nahrán jen částečně, zkuste jej nahrát znovu",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Dočasná složka chybí',
    '__UPLOAD_ERR_CANT_WRITE' => 'Zápis souboru na disk se nezdařil',
    '__UPLOAD_ERR_UNKNOWN' => 'Vyskytla se neznámá chyba odeslání souboru',
    '__accounts' => "Účty",
    '__access' => "Přístup",
    '__address' => "Adresa",
    '__addresses' => "Adresy",
    '__acl_records' => 'Záznamy ACL',
    '__admin_repository' => "Úložiště správce",
    '__all' => 'Všechno',
    '__allowed' => "Povoleno",
    '__anonftp_status' => "Anonymní FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 webový server se restartuje, čekejte, prosím...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Podpora Microsoft ASP.NET",
    '__asp_win_support' => "Podpora Microsoft ASP",
    '__attachments' => "Přílohy",
    '__attachments_list' => "Přílohy",
    '__author' => 'Autor',
    '__autoresp_name_already_exists' => "Automatická odpověď s názvem %1 již existuje.",
    '__autoresponder' => "Automatická odpověď",
    '__autoresponders' => "Automatické odpovědi",
    '__autoresponders_list' => "Automatické odpovědi",
    '__autoresponder_attachment_files' => "Soubory přílohy automatické odpovědi",
    '__auto_updates_list' => 'Dostupné aktualizace',
    '__avail' => "Dostupná",
    '__backup_utilites' => "Nástroje zálohování",
    '__bind_status' => "Stav DNS Serveru",
    '__bu_is_not_installed' => "Tato služba není momentálně dostupná, protože zálohovací programy nebyly nainstalovány.",
    '__bu_not_support_in_key' => "Funkce zálohování není podporována licenčním klíčem.",
    '__notifications_not_support_in_key' => 'Upozornění nejsou podporovány licenčním klíčem',
    'disabled_by_key' => 'Není podporováno licenčním klíčem',
    '__bytes' => "bytů",
    '__can_not_use_reserved_words' => "Nelze použít rezervovaná slova.",
    '__certificate' => "Certifikát",
    '__cgi_support' => "Podpora CGI",
    '__change_date' => "Datum modifikace",
    '__city' => "Město",
    '__cl_not_exist' => "Účet zákazníka neexistuje.",
    '__client' => 'Zákazník',
    '__client_card' => "Karta zákazníka",
    '__client_contact_name' => "Jméno kontaktu zákazníka",
    '__client_form' => "Osobní informace",
    '__client_ip_pool' => "Fond IP adres zákazníka",
    '__client_limits' => "Limity účtu zákazníka",
    '__client_permissions' => "Oprávnění zákazníka",
    '__client_preferences' => "Předvolby zákazníka",
    '__client_status' => "Stav zákazníka",
    '__client_name' => "Jméno zákazníka",
    '__client_total' => "Součet zákazníka",
    '__client_with_login_name_already_exists' => "Uživatel s přihlašovacím jménem \"%1\" již existuje",
    '__client_domuser_with_login_already_exists' => "Přihlašovací jméno '%1' již používá správce domény '%1'.",
    '__clients_global_changes' => "Upravit vybrané zákaznické účty",
    '__clients_list' => "Zákazníci",
    '__cmd_not_found' => "Neznámý příkaz: %1",
    '__comments' => "Komentáře",
    '__company_name' => "Název společnosti",
    '__component_version' => "Verze součásti",
    '__component_not_installed' => "Součást %1 není nainstalována",
    '__confirm_del' => "Musíte potvrdit odstranění.",
    '__confirm_overwrite' => "Potvrdit přepis.",
    '__confirm_stop' => "Musíte potvrdit zastavení procesu.",
    '__confirm_passwd' => "Potvrdit heslo %1",
    '__confirm_removal' => "Potvrdit odebrání",
    '__conhelp' => "Popis",
    '__contact_name' => "Jméno kontaktu",
    '__country' => "Země",
    '__countries' => 'Země',
    '__country_unknown' => 'Nelze rozpoznat podkód země.',
    '__courier-imap' => 'Server Courier',
    '__create_domain' => 'Vytvořit doménu',
    '__crypted' => 'šifrováno',
    '__cp_access' => "Přístup k prostředí Plesk",
    '__cp_user' => "Uživatel Plesk",
    '__create' => "Vytvořit",
    '__create_client_template_without_template' => "Vytvořit uživatelský účet bez šablony",
    '__create_domain_for' => "Vytvořit doménu pro <b>%1</b>",
    '__create_domain_template_without_template' => "Vytvořit doménu bez šablony",
    '__creation_date' => "Datum vytvoření",
    '__crontab_unix' => "Plánovač",
    '__crontab_win' => "Plánovač",
    '__ct_month_jan' => 'Leden',
    '__ct_month_feb' => 'Únor',
    '__ct_month_mar' => 'Březen',
    '__ct_month_apr' => 'Duben',
    '__ct_month_may' => 'Kvě.',
    '__ct_month_jun' => 'Červen',
    '__ct_month_jul' => 'Červenec',
    '__ct_month_aug' => 'Srpen',
    '__ct_month_sep' => 'Září',
    '__ct_month_oct' => 'Říjen',
    '__ct_month_nov' => 'Listopad',
    '__ct_month_dec' => 'Prosinec',
    '__custom_button' => "Uživatelské tlačítko",
    '__custom_buttons_list' => "Odkazy na další služby",
    '__daily' => "Denně",
    '__database_not_activated' => "%1 nebyla aktivována na stránce pro správu serveru.",
    '__database_not_installed' => "Databáze %1 není nainstalována.",
    '__database_not_run' => "Databáze %1 není spuštěna.",
    '__database_is_corrupt' => "Databáze Plesk je poškozena. K opravě použijte nástroj Rekonfigurátor.",
    '__databases' => "Databáze",
    '__databases_list' => "Databáze",
    '__database_type_not_supported_by_key' => 'Chcete-li použit server %1, budete pro něj potřebovat podporu ve vašem licenčním klíči. Kontaktujte obchodní zástupce společnosti Plesk.',
    '__date_immediately' => "dnes",
    '__date_never' => "nikdy",
    '__day(s)' => "Den(Dny)",
    '__day0' => "Ne",
    '__day1' => "Po",
    '__day2' => "Út",
    '__day3' => "St",
    '__day4' => "Čt",
    '__day5' => "Pá",
    '__day6' => "So",
    '__days' => "%1 den(dny,dnů)",
    '__db_admin_login_empty' => "Zadali jste prázdné přihlašovací jméno, vypnutí ovládání prostřednictvím %1 v rozhraní. Chcete pokračovat?",
    '__db_unable_to_unregister' => 'Nelze odebrat parametry připojení databáze',
    '__db_db_exists' => 'Na serveru je nejméně jedna databáze',
    '__db_unable_to_change_server_name' => 'Název serveru nelze změnit',
    '__db_unable_to_change_port' => 'Port pro server nelze změnit',
    '__db_already_exist' => "Databáze %1 již existuje.",
    '__db_credentials_invalid' => "Pověření uživatele jsou neplatná.",
    '__db_invalid_password_characters' => 'Heslo obsahuje neplatné znaky',
    '__db_engine' => "Databázový stroj", // indirect
    '__db_type' => "Typ databáze",
    '__db_user' => "Uživatel databáze",
    '__db_server' => 'Databázový server',
    '__def_domain' => "Výchozí doména",
    '__default_for_mysql' => 'výchozí pro MySQL',
    '__default_for_mariadb' => 'výchozí pro MariaDB',
    '__default_for_percona' => 'výchozí pro Percona',
    '__default_for_postgresql' => 'výchozí pro PostgreSQL',
    '__delete' => "Odstranit",
    '__demo' => "Tato funkce není dostupná v demoverzi.",
    '__directory' => "Adresář",
    '__disable_lock_screen' => 'Zabránit uživatelům v práci v prostředí Plesk, dokud nebudou úplně nahrány obrazovky rozhraní',
    '__dismiss_news?' => "Opravdu chcete úplně uzavřít blok novinek? Nebudete moci vidět bloky novinek, dokud nebude k dispozici více novinek.",
    '__description' => "Popis",
    '__disabled' => "vypnuto",
    '__disk_space_limit' => "Limit prostoru na disku",
    '__cgroups_cpu_usage_limit' => 'Limit využití procesoru',
    '__cgroups_ram_usage_limit' => 'Limit využití paměti RAM',
    '__cgroups_disk_read_usage_limit' => 'Limit šířky pásma čtení z disku',
    '__cgroups_disk_write_usage_limit' => 'Limit šířky pásma zápisu na disk',
    '__disk_usage_by' => "Prostor na disku využitý %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Záznam DNS '%1' již existuje.",
    '__dns_master_should_be_remote' => "Měli byste mít dva různé autoritativní názvové servery na jednotlivých hostitelích.",
    '__dns_record_not_exist' => "Záznam DNS neexistuje.",
    '__dns_server' => "DNS server", // indirect
    '__dom_id_is_undefined' => "ID domény není definováno.",
    '__dom_name' => "Název domény",
    '__dom_name_is_invalid' => "Název domény je neplatný. Ujistěte se, prosím, zda název domény obsahuje pouze alfanumerické znaky, znaky tečky a pomlčky, a není delší než 255 znaků. Každá část doménového jména mezi tečkami nesmí přesáhnout délku 63 symbolů.",
    '__dom_not_exist' => "Doména neexistuje.",
    '__domain' => "Doména",
    '__domain_' => 'Doména %1',
    '__domain_form' => "Forma domény",
    '__domain_id' => "ID domény",
    '__domain_is_turned_off_for_backup' => "U webu %1 je dočasně vypnuto zálohování nebo obnovení a není momentálně dostupný.",
    '__domain_limits' => "Limity domény",
    '__domain_name' => "Název domény",
    '__mail_name_in_ASCII_form' => "Název e-mailového účtu ve formátu ASCII",
    '__message_error' => 'Chyba',
    '__message_warning' => 'Varování',
    '__message_info' => 'Informace',
    '__domain_name_in_ASCII_form' => "Název domény ve formátu ASCII",
    '__domain_repository' => "Úložiště domény %1",
    '__domain_status' => "Stav domény",
    '__domain_found_tech' => "Na doméně se našla technologie",
    '__domain_dns' => 'Zóna DNS domény',
    '__domain_total' => "Celkový objem pro předplatné",
    '__domain_total_powerUser' => "Celkový objem pro předplatné",
    '__domain_user' => "Správce domény",
    '__domains_global_changes' => "Upravit vybrané domény",
    '__mailnames_global_changes' => "Upravit vybrané e-mailové účty",
    '__backup_manager' => 'Správa zálohování',
    '__domains_list' => "Domény",
    'domains_list__list_header' => "domény",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Název domény začíná na www, i když se používá předpona WWW, Chcete přesto pokračovat?",
    '__dovecot' => 'Server Dovecot IMAP a POP3',
    '__dsmail' => "Poštovní služba",
    '__dsmaillist' => "Služba seznam adresátů",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Název domény",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Jméno zákazníka",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Celková velikost souborů zálohy v místním úložišti",
    '__email' => "E-mail",
    '__email_addr_is_invalid' => "E-mailová adresa '$' je neplatná.",
    '__enabled' => "zapnuto",
    '__enter_cert_text' => "Zadejte text certifikátu",
    '__enter_size' => "Zadejte velikost",
    '__exclusive' => "Vyhrazený",
    '__expiration_date' => "Datum vypršení platnosti",
    '__fax' => "Fax",
    '__file' => "Soubor",
    '__file_is_empty' => "Soubor je prázdný.",
    '__file_name' => "Název souboru",
    '__file_type' => 'Typ souboru',
    '__filemanager' => "Správce souboru",
    '__filepath_is_empty' => "Cesta k souboru je prázdná",
    '__files_list' => "Soubory",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Nastavení FTP",
    '__ftp_serv' => "Server FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Nejprve musíte zadat vlastnosti účtu FTP!",
    '__ftp_status' => "Stav serveru FTP",
    '__full_day0' => "Neděle",
    '__full_day1' => "Pondělí",
    '__full_day2' => "Úterý",
    '__full_day3' => "Středa",
    '__full_day4' => "Čtvrtek",
    '__full_day5' => "Pátek",
    '__full_day6' => "Sobota",
    '__full_month1' => "Leden",
    '__full_month10' => "Říjen",
    '__full_month11' => "Listopad",
    '__full_month12' => "Prosinec",
    '__full_month2' => "Únor",
    '__full_month3' => "Březen",
    '__full_month4' => "Duben",
    '__full_month5' => "Kvě.",
    '__full_month6' => "Červen",
    '__full_month7' => "Červenec",
    '__full_month8' => "Srpen",
    '__full_month9' => "Září",
    '__giga' => "G",
    '__group' => "Skupina",
    '__h' => "H",
    '__hard_disk_quota' => "Kvóta pevného disku",
    '__hard_disk_quota_not_supported' => 'kvóta pevného disku není podporována kvůli konfiguraci souborového systému serveru',
    '__header_text_is_invalid' => "Název chráněné oblasti je neplatný.",
    '__help_topic_not_found' => 'Téma nápovědy, které požadujete (%1), neexistuje.',
    '__hosting_ip_dns_ip_not_equiv' => "Žádná z IP adres zadaných do záznamů DNS A neodpovídá IP adrese použité pro hostování.",
    '__hosting_scripting' => "Podpora skriptování pro hosting",
    '__hosting_setup_page_title' => "Nastavení web hostingu pro doménu %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Typ hostingu",
    '__hostname_is_empty' => "Položka název hostitele je prázdná.",
    '__hour(s)' => 'hodin',
    '__hst_type_incorrect' => "Nesprávný typ hostingu.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Doba nečinnosti",
    '__iface' => "Rozhraní",
    '__image' => "Obraz",
    '__imap_status' => "Stav serveru IMAP",
    '__in' => "V",
    '__in_%' => "v %",
    '__incorrect_databases_login_pass' => "Pověření, která jste zadali pro přístup k PostgreSQL, jsou nesprávná.",
    '__incorrect_ip_or_network_address' => 'Nesprávná IP adresa nebo síť.',
    '__info' => 'Info',
    '__install' => "Instalovat",
    '__install_prefix' => "Instalovat předponu",
    '__invalid_cert_id' => "ID neplatného certifikátu",
    '__invalid_context' => "Neplatný kontext: %1",
    '__invalid_db_usr_name' => "Jméno uživatele databáze je neplatné.",
    '__invalid_dir_name' => "Název adresáře je neplatný",
    '__invalid_dom_name' => "Název domény je neplatný.",
    '__invalid_filename' => "Neplatný název souboru. Nepoužívejte jednoduché uvozovky nebo kombinace \"../\" .",
    '__invalid_id' => "Neplatný identifikátor.",
    '__invalid_lines_num' => "Nevhodná hodnota pro počet řádků, jsou povoleny pouze číslice.",
    '__invalid_max_letter_size' => "Maximální velikost zprávy je neplatná.",
    '__invalid_pdir_name' => "Název chráněného adresáře je neplatný.",
    '__invalid_restart_apache_interval' => "Interval restartu Apache stránek je neplatný.",
    '__invalid_tmpl_name' => "Název šablony je neplatný.",
    '__invalid_value' => "Nesprávná hodnota.",
    '__ip_addr' => "IP adresa",
    '__ip_address_and_mask' => "IP adresa a maska podsítě",
    '__ip_alias__mask' => "IP adresa a maska podsítě",
    '__ip_addr_is_invalid' => "IP adresa je platná.",
    '__ip_addr_list' => "IP adresy",
    '__ip_address_and_mask_hint' => 'Například %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "kB/s",
    '__kbytes' => "kBytů",
    '__key_for_virtuozzo_only' => "Váš licenční klíč je určen pouze pro použití v kontejnerech Virtuozzo.",
    '__key_limits_exceeding' => "Tato akce přesáhla limit definovaný vaší softwarovou licencí. Pokud jste obdrželi tuto zprávu, můžete kontaktovat Vašeho poskytovatele nebo výrobce kvůli vyjasnění nebo rozšíření práv této licence.",
    '__kilo' => "K",
    '__keywords' => 'Klíčová slova',
    '__lang_unknown' => 'Nelze rozpoznat jazyk.',
    '__languages' => 'Jazyk',
    '__learn_more' => 'Další informace',
    '__loading' => 'Načítání...',
    '__locales' => "Jazykové sady",
    '__lists' => "Seznamy adresátů",
    '__literal_bytes' => "B",
    '__processing' => "Čekejte prosím.<br>Načítání...",
    '__locale' => "Jazyk rozhraní",
    '__locale_is_not_defined' => "Jazyk rozhraní není definován.",
    '__local_server_mysql' => 'Místní server MySQL',
    '__local_server_postgresql' => 'Místní server PostgreSQL',
    '__local_server_mssql' => 'Místní server MS SQL',
    '__log_and_statistics_files' => 'Soubory protokolu a statistické zprávy',
    '__config_files' => 'Konfigurační soubory',
    '__chroot_files' => 'Prostředí Chroot',
    '__login' => "%1 Přihlašovací jméno",
    '__login1' => "Přihlašovací jméno",
    '__login_disabled' => "Přihlášení zakázáno",
    '__login_enabled' => "Přihlášení povoleno",
    '__login_incorrect' => "Zadali jste nesprávné uživatelské jméno nebo heslo.",
    '__login_name' => "%1 přihlašovací jméno",
    '__login_name_is_invalid' => "%1 přihlašovací jméno je neplatné.",
    '__logon_time' => "Čas přihlášení",
    '__ma' => "E-mailové aliasy",
    '__mail' => "Pošta",
    '__mail_alias_name' => "Název e-mailového aliasu",
    '__mail_autodiscovery' => 'Automatické zjišťování e-mailu',
    '__mail_exchanger_name_is_invalid' => "Název služby Mail Exchanger je neplatný.",
    '__mail_groups' => "E-mailové skupiny",
    '__mail_list_engine' => "Software seznamu adresátů",
    '__mail_name' => "Poštovní účet",
    '__mail_name_form' => "Vlastnosti e-mailového účtu",
    '__mail_names' => "Poštovní účty",
    '__mail_serv' => "E-mailový server",
    '__mail_user' => 'Uživatel e-mailu',
    '__mailgroup' => "E-mailová skupina",
    '__maillist' => "Seznam adresátů",
    '__maillists' => "Seznamy adresátů",
    '__maillist_member' => 'Člen seznamu adresátů',
    '__mailname' => "Poštovní účet",
    '__mailname_redir_self' => "E-mailový účet nemůže předávat poštu sám sobě.",
    '__max_dom_num_reached_for_cl' => "U tohoto účtu zákazníka byl dosaženo limitu počtu domén.",
    '__max_file_size_available' => "Maximální povolená velikost souboru %1",
    '__max_subdom_num_reached_for_cl' => "U tohoto účtu zákazníka byl dosaženo limitu počtu subdomén.",
    '__max_subdom_num_reached_for_dom' => "U této domény bylo dosaženo limitu v počtu subdomén.",
    '__max_subdom_num_reached_for_key' => "Bylo dosaženo limitu v počtu subdomén povolených licenčním klíčem.",
    '__max_traffic_limit' => "Limit přenosu dat",
    '__maximum_excl_ip_num' => "Poštovní účty",
    '__mb' => "MB",
    '__mbytes' => "MB",
    '__mb_month' => "MB/měsíc",
    '__mb_sec' => "MB/s",
    '__gb_sec' => "GB/s",
    '__tb_sec' => "TB/s",
    '__mega' => "M",
    '__minute(s)' => 'minut',
    '__mls_not_in_key' => "Klíč vašeho produktu nepodporuje vícejazyčné rozhraní.",
    '__modification_date' => "Datum modifikace",
    '__module' => "Rozšíření",
    '__month' => "Měsíc",
    '__month(s)' => "Měsíc(e)",
    '__month1' => "Led.",
    '__month10' => "Říj.",
    '__month11' => "List.",
    '__month12' => "Pros.",
    '__month2' => "Ún.",
    '__month3' => "Bře.",
    '__month4' => "Duben",
    '__month5' => "Kvě.",
    '__month6' => "Červen",
    '__month7' => "Červenec",
    '__month8' => "Srp.",
    '__month9' => "Zář",
    '__monthly' => "Měsíčně",
    '__months' => "Měsíce",
    '__moved_permanently' => 'Trvale přesunuto',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Název serveru Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "název serveru nelze změnit: je na něm nejméně jedna databáze.",
    '__mssql_status' => "Stav SQL serveru Microsoft",
    '__multiply_login_deny' => "Nelze se přihlásit: Do prostředí Plesk je již přihlášen jiný uživatel se stejným přihlašovacím jménem (%1).",
    '__mysql' => "MySQL",
    '__mysql_status' => "Stav serveru MySQL",
    '__mysql_version' => "Verze MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Stav serveru MariaDB",
    '__mariadb_version' => "Verze MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Stav serveru Percona",
    '__percona_version' => "Verze Percona",
    '__name' => "Jméno",
    '__name_invalid' => "Název je neplatný.",
    '__nameserver' => "názvový server",
    '__network' => "Síť",
    '__networks' => "Sítě",
    '__no' => "Ne",
    '__no_ip_address_with_properly_type_available' => "Nelze obnovit zálohovaná data, protože neexistují vhodné IP adresy, které byly požadovány pro obnovení.",
    '__no_clients_specified' => "Nejsou zadány žádné zákaznické účty.",
    '__no_comments' => "Žádné komentáře.",
    '__nologin' => "Zakázáno",
    '__none' => "Žádné",
    '__not_configured' => "Nenakonfigurováno",
    '__not_implemented_yet' => "Ještě není implementováno",
    '__not_supported_by_ftp' => "(nepodporováno serverem FTP)",
    '__notification' => "Oznámení",
    '__num_displayed' => "zobrazeno %1 z %2",
    '__num_is_invalid' => "Počet je neplatný.",
    '__object_not_found' => 'Objekt nebyl nalezen: %1',
    '__of_all' => "% ze všech",
    '__off' => "Vypnout",
    '__ok' => "OK",
    '__old_passwd' => "Staré heslo %1",
    '__on' => "Zapnout",
    '__others' => "Další",
    '__other_ip__will_be_added' => 'Další dostupné IP adresy (budou přidány do fondu IP adres zákazníka)',
    '__out' => "Ven",
    '__p' => "P",
    '__passwd' => "%1 heslo",
    '__passwd_is_invalid' => "%1 heslo je neplatné.",
    '__passwd_not_match' => "Hesla se neshodují!",
    '__path' => "Cesta",
    '__perl_unix_support' => "Podpora Perlu",
    '__perl_win_support' => "Podpora Perlu",
    '__perm_denied' => "Oprávnění byla odepřeno.",
    '__permissions' => "Oprávnění",
    '__personal_name' => "Jméno a příjmení",
    '__pg_admin_not_activated' => "PostgreSQL nebyl aktivován na stránce pro správu serveru.",
    '__pg_not_inst' => "PostgreSQL nebyl nainstalován.",
    '__pg_not_run_or_inst' => "PostgreSQL nebyl nainstalován nebo není spuštěn.",
    '__pg_not_support_in_key' => "PostgreSQL není podporován licenčním klíčem.",
    '__phone' => "Telefon",
    '__phosting' => "Fyzický hosting",
    '__php_support' => "Podpora PHP",
    '__php_run_as_isapi' => "spustit jako rozšíření ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' zapnutý",
    '__php_version' => "Verze PHP",
    '__physical' => "Fyzický hosting",
    '__plesk_stat_pdir' => "Chránit adresář '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Statistiky domény",
    '__plesk_stat_protect' => "Chránit přístup k webovým statistikám prostřednictvím přihlašovacího jména FTP a hesla uživatele",
    '__plesk_stat_protect_install' => "přístupné přes adresář chráněný heslem '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Stav serveru POP3",
    '__popen_error' => "Při vyvolání funkce popen došlo k chybě.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Stav PostgreSQL",
    '__preferences' => "Nastavení",
    '__account_preferences' => "Nastavení účtu",
    '__interface_preferences_general' => 'Obecné',
    '__interface_preferences_default' => 'Výchozí předvolby rozhraní',
    '__interface_preferences_admin' => "Předvolby rozhraní správce",
    '__interface_template' => 'Šablona přizpůsobení rozhraní',
    '__interface_preferences' => "Předvolby rozhraní",
    '__proceed?' => "Chcete pokračovat?",
    '__protect_dir_user' => "Uživatel chráněného adresáře",
    '__protect_dir_users' => "Uživatelé chráněného adresáře",
    '__provider_contact_name' => "Kontaktní jméno vlastníka",
    '__python_unix_support' => "Podpora Pythonu",
    '__python_win_support' => "Podpora Pythonu",
    '__quota' => "Kvóta",
    '__r' => "R",
    '__reconfigure' => "Rekonfigurovat",
    '__record_type' => "Typ záznamu",
    '__release' => "Uvolnit",
    '__remote_db_not_supported_by_key' => 'Hosting vzdálené databáze není podporován vaším licenčním klíčem.',
    '__remove' => "Odebrat",
    '__remove_confirmation' => "Potvrdit odebrání",
    '__remove_protection' => 'Odstranit ochranu',
    '__report' => "Sestava",
    '__report_size_na' => "Služba je nedostupná",
    '__reports_list' => "Sestavy",
    '__requested' => "Požadováno",
    '__required_fields' => "Požadovaná pole",
    '__resp_name_invalid' => "Název automatické odpovědi je neplatný. Použijte pouze alfanumerické znaky, tečky, podtržítko a prázdné znaky.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Název serveru je neplatný.",
    '__screenshots' => 'Snímky obrazovky',
    '__script_warning' => "Při odstranění skriptování z této domény budou při vyvolání prohlížečem veškeré související skripty zobrazeny jako prostý text. Správci se doporučuje odstranit všechny související skripty z dané domény.",
    '__sec' => "Sekundy",
    '__second(s)' => "Sekund(y)",
    '__see_list_of_logged_in' => "Viz seznam aktuálně přihlášených uživatelů.",
    '__select_certs_to_remove' => "Vybrat certifikáty, které se mají odebrat.",
    '__select_files_to_remove' => "Vyberte soubory, které budou odebrány.",
    '__select_ip' => "Přiřadit IP adresu",
    '__select_ip_to_remove' => "Vybrat IP adresu, která se má odebrat.",
    '__select_domain_template' => "Použít nastavení šablony domény",
    '__select_templates_to_remove' => "Vybrat šablony, které se mají odebrat.",
    '__server' => "Server",
    '__server_total' => "Souhrn serverů",
    '__service' => "Služba",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Databázový server MySQL",
    '__service_description__mysql' => "Databázový server MySQL",
    '__service_title__web' => "Webový server",
    '__service_description__web' => "Webový server",
    '__service_title__smtp' => "Server SMTP",
    '__service_description__smtp' => "Server SMTP",
    '__service_title__mail' => "Server IMAP/POP3",
    '__service_description__mail' => "Server IMAP/POP3",
    '__service_title__dns' => "DNS server",
    '__service_description__dns' => "DNS server",
    '__service_title__postgresq' => "Databázový server PostgreSQL",
    '__service_description__postgresq' => "Databázový server PostgreSQL",
    '__service_title__spamassassin' => "Služba filtrování nevyžádané pošty SpamAssassin",
    '__service_description__spamassassin' => "Služba filtrování nevyžádané pošty SpamAssassin",
    '__services' => "Služby",
    '__all_services' => "Všechny služby",
    '__sessions' => "Relace",
    'sessions__feature_ftp_session_manager_not_supported' => "Funkce relace FTP není podporována aktuálním serverem FTP",
    '__sessions_list' => "Relace",
    '__set' => "Zapnout",
    '__shared' => "Sdílené",
    '__shell_access_warning' => "Povolení přístupu do systému je z hlediska zabezpečení systému vysoce nebezpečné. Povolte přístup do systému pouze pokud jasně víte, co děláte, a pouze důvěryhodným uživatelům. Chcete opravdu povolit přístup?",
    '__siteapp_not_support_in_key' => "Webové aplikace nejsou podporovány licenčním klíčem",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfigurace této webové aplikace byla změněna ručně. Kvůli ochraně změn provedených ručně je opakovaná konfigurace prostřednictvím Plesk nedostupná.',
    '__site_management' => "Publikování na webu", // indirect
    '__size' => "Velikost",
    '__skeleton' => 'Šablona virtuálního hostitele',
    '__skins' => 'Vzhledy',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Stav serveru SMTP",
    '__some_fields_are_empty_or_invalid' => "Některá pole jsou prázdná nebo obsahují nesprávnou hodnotu.",
    '__unable_to_set_parameters' => "Nelze nastavit parametry komponenty",
    '__spamassassin' => "Filtr nevyžádané pošty",
    '__spamassassin_status' => "Stav SpamAssassin",
    '__spamd_status' => 'Stav filtr nevyžádané pošty',
    '__splited_backup' => "(vícesvazkové zálohování)",
    '__split_backup_file' => "Vytvořit zálohu na více svazků",
    '__split_backup_size' => "Velikost svazku",
    '__split_backup_less_than_500' => "Svazky o velikosti menší než 500 MB nejsou podporovány",
    '__ssi' => "SSI",
    '__ssi_support' => "Podpora SSI",
    '__ssi_with_html' => "Použít SSI na soubory *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Podpora SSL/TLS",
    '__same_ssl' => "Použít samostatný adresář pro ukládání obsahu SSL/TLS a bez SSL/TLS.",
    '__same_ssl_cu' => "Běžný obsah SSL/TLS a obsah bez SSL/TLS",
    '__state' => "Stát/Oblast",

    '__status__Active' => 'Aktivní',
    '__status__active' => 'aktivní',
    '__status__Passive' => 'Vypnuto',
    '__status__passive' => 'vypnuto',
    '__status__off' => 'vypnuto',
    '__status__with_parent' => 'vypnuto',
    '__status__backup_restore' => 'dočasně nedostupný pro zálohování či obnovení',
    '__status__admin' => 'pozastaveno správcem serveru',
    '__status__resseler' => 'pozastaveno prodejcem',
    '__status__client' => 'pozastaveno zákazníkem',
    '__status__unknown' => 'stav je neznámý',

    '__status_of' => "stav %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Server Stunnel", // indirect
    '__subdomain' => "Subdoména",
    '__subdomain_name' => "Název subdomény",
    '__subdomain_name_in_ASCII_form' => "Název subdomény ve formátu ASCII",
    '__subdomains' => "Subdomény",
    '__domainaliases' => "Doménové aliasy",
    '__subdomains_list' => "Subdomény",
    '__subdomains_not_support_in_key' => "Operace subdomény nejsou podporovány licenčním klíčem",
    '__sys_user_type' => "Uživatel FTP",
    '__sys_user_type_main' => "Použít uživatelský účet FTP z hlavní domény",
    '__sys_user_type_native' => "Vytvořit zvláštní uživatelský účet FTP pro tuto subdoménu",
    '__t' => "T",
    '__target_domain' => "Cílová doména",
    '__template' => "Šablona",
    '__template_not_accepted' => "Nelze přijmout tuto šablonu: byly překročeny následující limity.",
    '__templates' => "Šablony",
    '__templates_list' => "Šablony",
    '__tera' => "T",
    '__title' => "Titul",
    '__tools' => "Nástroje",
    '__total' => "Celkem %1",
    '__total_size' => "Celková velikost",
    '__total_used' => "Celkem použito",
    '__traffic' => "Provoz",
    '__traffic_by_client' => "Přenos zákazníka",
    '__traffic_by_domain' => "Přenos podle domény",
    '__traffic_by_service' => "Přenos podle služby",
    '__traffic_history' => "Historie přenosu dat",
    '__unable_change_locale' => "Nelze změnit jazyk rozhraní: %1",
    '__unable_create_new_dom' => "Nelze vytvořit doménu: %1",
    '__unable_define_dom_name' => "Nelze definovat název domény: %1",
    '__unable_define_necessary_properties' => "Nelze definovat všechny požadované vlastnosti.",
    '__unable_define_properties' => "Nelze definovat vlastnosti: %1",
    '__unable_exec_util' => "Nelze spustit nástroj: %1",
    '__unable_get_dns_a_recs' => "Nelze načíst IP adresy pro záznamy A DNS tohoto účtu hostitele: %1",
    '__unable_get_mbox_quota' => "Nelze načíst informace o omezení velikosti poštovní schránky.",
    '__unable_redirect_to_myself' => "Nelze předat na stejný účet.",
    '__unable_redirect_to_my_alias' => "Nelze předávat e-mail na e-mailový alias.",
    '__default_domain_redirect_to_myself' => "Nelze nastavit doménu jako výchozí pro IP adresu: bylo zjištěno přesměrování do sebe sama.",
    '__unable_remove_client' => "Nelze odebrat zákazníka: %1",
    '__unable_set_up_mbox_quota' => "Nelze nastavit velikost poštovní schránky pro doménu: %1",
    '__unable_setup_pass' => "Nelze nastavit heslo: %1",
    '__unable_to_create_new_account' => "Nelze vytvořit účet: %1",
    '__unable_to_define_db_size' => "Nelze definovat velikost databáze.",
    '__unable_to_enable_short_names' => "Nelze povolit použití krátkých názvů e-mailových účtů pro účty POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Nelze načíst odeslaná data: %1",
    '__unable_to_open_file' => "Nelze otevřít soubor %1: %2",
    '__unable_to_update_subdomain' => "Nelze možné provést změny na subdoméně: %1",
    '__unable_update_cl_data' => "Nelze uložit změny uživatelského účtu: %1",
    '__unable_update_db_params' => "Nelze aktualizovat parametry databáze: %1",
    '__unable_update_dom_data' => "Nelze aktualizovat data domény: %1",
    '__undefined' => "nedefinováno",
    '__uninstall' => "Odinstalovat",
    '__unknown_error' => "Neznámá chyba",
    '__unlimited_lower' => "Neomezeno",
    '__unset' => "Vypnout",
    '__update' => "Aktualizovat",
    '__uploaded_file_is_invalid' => "Nahraný soubor je neplatný: %1",
    '__url' => "Adresa URL",
    '__usage' => "Využití disku",
    '__user' => 'Uživatel',
    '__user_already_logged' => "Do prostředí Plesk je již přihlášen jiný uživatel se stejným přihlašovacím jménem (%1).",
    '__version' => "Verze",
    '__aps_license' => "Licenční klíč",
    '__vh_type' => "Typ virtuálního hostitele",
    '__vhosts_apache_status' => "Stav webového serveru",
    '__wrong_charset_conversion' => 'Chybná znaková sada, převod z "%1" na "%2" není povolen',
    '__warning_' => "Varování!",
    '__warning_excl_ip_num' => "Vyhrazená IP adresa",
    '__warning_expiration' => "Datum vypršení platnosti",
    '__web_scripting' => "Skriptování pro web", // indirect
    '__web_serv' => "Webový server", // indirect
    '__web_statistic' => "Webová statistika", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Na serveru není nainstalován nástroj Webalizer. Obraťte se na svého poskytovatele služeb s žádostí o pomoc s instalací nástroje Webalizer.",
    '__webstat_support' => "Webová statistika",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Pokud přepnete z jednoho statistického programu na jiný, všechny sestavy vytvořené dříve použitým statistickým programem jsou odstraněny a nové sestavy se vytvoří podle informací načtených ze souborů protokolu uchovaných na serveru. To znamená, že pokud jste konfigurovali systém (v nabídce Domény> název domény> Správce souborů protokolu> Rotace souborů protokolu) tak, aby byly zachovány soubory protokolu pouze pro poslední měsíc, webová statistika bude k dispozici pouze za poslední měsíc. Chcete přepnout na jiný statistický balíček?",
    '__webstat_perm_denied' => 'Nemáte oprávnění spravovat webové statistiky.',
    '__webuser' => "Uživatel webu",
    '__sysusers_list' => "Uživatelé systému",
    '__sysuser' => "Systémový uživatel",
    '__weekly' => "Týdně",
    '__whats_new_in_version' => "Co je nového v prostředí Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Tato operace je dostupná pouze pro domény s webhostingem.",
    '__wrong_hosting_type__none' => 'Na doméně %1 není nakonfigurován žádný web hosting.',
    '__wrong_hosting_type__std_fwd' => 'Doména %1 má nakonfigurováno standardní přesměrování. Tato operace je dostupná pouze pro domény s webhostingem.',
    '__wrong_hosting_type__frm_fwd' => 'Doména %1 má nakonfigurováno rámcové přesměrování. Tato operace je dostupná pouze pro domény s webhostingem.',
    '__wu' => "Uživatelé webu",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Předpona WWW byla změněna. Ujistěte se, že byl současně upraven i certifikát SSL/TLS.",
    '__year' => "Rok",
    '__year(s)' => "Rok(y,ů)",
    '__yes' => "Ano",
    '__you' => "Vy",
    '__zip_code' => "PSČ",
    '__form_normal' => "Normální",
    '__form_advanced' => "Rozšířený",

    'admin_ed__edit_administrator_info' => "Úpravy profilu správce",
    'admin_ed__create_default_client' => "Chci vytvořit výchozí účet zákazníka.",
    'admin_ed__unable_update' => "Nelze aktualizovat informace správce: %1",

    'auth__update_admin_info' => "Zadejte informace o správci. Tyto informace jsou požadovány pro používání %1.",
    'auth__you_not_have_perm' => "Nemáte oprávnění ke správě této domény.",
    'auth__key_expired_admin' => 'Vaše licence Plesk vypršela. Chcete-li používat prostředí Plesk i nadále, licenci obnovte nebo si zakupte novou .',
    'auth__key_expired_admin_restricted' => 'Vaše licence Plesk vypršela. Chcete-li pokračovat a používat prostředí Plesk i nadále, kontaktujte svého poskytovatele služeb.',
    'auth__key_expired_client' => 'Licence Plesk vypršela. Obraťte se na svého poskytovatele hostingu.',
    'autoinstaller__not_installed' => 'Součást automatického instalačního programu není nainstalována.',
    'autoinstaller__release_action' => 'Dostupné operace',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Probíhá aktualizace na novou verzi prostředí Plesk',
    'autoinstaller__release_action_update' => 'Aktualizace nebo přidávání nových součástí',
    'autoinstaller__release_action_up2date' => 'Máte aktuální verzi.',
    'autoinstaller__component_action' => 'Stav',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Nenainstalováno',
    'autoinstaller__component_action_update' => 'Aktualizace jsou dostupné',
    'autoinstaller__component_action_upgrade' => 'Aktualizace je dostupná',
    'autoinstaller__component_action_up2date' => 'Máte aktuální verzi.',
    'autoinstaller__component_action_error' => 'Aktualizace nejsou dostupné',
    'autoinstaller__component_serverbuildtime' => 'Nejnovější verze',
    'autoinstaller__component_localbuildtime' => 'Vaše verze',
    'autoinstaller__component_installed_version' => 'Vaše verze',
    'autoinstaller__component_available_version' => 'Nejnovější verze',
    'autoinstaller__component' => 'Součást',
    'autoinstaller__components' => 'Součásti',
    'autoinstaller__components_title' => '%1 Součásti',
    'autoinstaller__component_dependency_note' => 'požadováno pro instalaci vámi vybraných součástí',
    'autoinstaller__install_confirm' => 'Ano, chci nainstalovat tyto součásti',
    'autoinstaller__install_confirm_request' => 'Potvrďte volbou zaškrtávacího políčka',
    'autoinstaller__install_title' => 'Potvrďte instalaci vybraných součástí',
    'autoinstaller__key_update_confirm' => 'Potvrďte vynechání aktualizace klíče a instalaci výchozího klíče',
    'autoinstaller__key_update_confirm_request' => 'Potvrďte volbou zaškrtávacího políčka.',
    'autoinstaller__key_update_failed' => '<p>Plesk není schopen aktualizovat vaši licenci k produktu.</p><p>%1</p><p>Pokud budete pokračovat v upgradu bez odpovídající licence k produktu, nainstaluje se výchozí licence s omezenou funkčností. Správcům doporučujeme, aby před aktualizací na vyšší verzi produktu nejprve získali odpovídající licenční klíč.</p>',
    'autoinstaller__email' => 'Odeslat oznámení pro',
    'autoinstaller__email_admin' => "E-mail správce",
    'autoinstaller__email_email' => 'Vlastní e-mailová adresa...',
    'autoinstaller__release' => 'Název verze',
    'autoinstaller__releases' => 'Dostupné verze',
    'autoinstaller__releases_title' => 'Nástroj pro aktualizaci prostředí Plesk',
    'autoinstaller__select_components_to_install' => 'Vyberte součásti, které mají být nainstalovány',
    'autoinstaller__status_error' => 'Chyba: %1.',
    'autoinstaller__status_install_error' => 'Instalace nemohla být spuštěna: %1.',
    'autoinstaller__status_install_busy' => 'Instalace nemohla být spuštěna: aktuálně běží jiný instalační proces.',
    'autoinstaller__status_install_ok' => 'Instalace je spuštěna. O průběhu instalace budete informováni e-mailem (%1).',
    'autoinstaller__status_query_busy' => 'Probíhá instalace.',
    'autoinstaller__status_query_error' => 'Nelze načíst stav instalace: %1',
    'autoinstaller__status_unknown' => 'Nelze načíst stav automatického instalačního programu.',
    'autoinstaller__status_busy' => 'Automatický instalační program je zaneprázdněn, čekejte prosím.',
    'autoinstaller__configure_title' => 'Nastavení nástroje pro aktualizaci',
    'autoinstaller__preferences_legend' => 'Nastavení',
    'autoinstaller__target' => 'Dočasný adresář pro stahování',
    'autoinstaller__target_invalid' => "Zadat absolutní cestu",
    'autoinstaller__check_updates' => 'Vyhledat aktualizace při přihlášení správce do prostředí Plesk',
    'autoinstaller__check_updates_warning' => 'Nové <a href="%1">aktualizace</a> jsou dostupné pro %2',
    'autoinstaller__source_type' => 'Typ zdroje',
    'autoinstaller__source' => 'Zdrojová adresa URL',
    'autoinstaller_source__preferences_legend' => 'Nastavení',
    'autoinstaller_source__type' => 'Typ zdroje',
    'autoinstaller_source__url_invalid' => 'Neplatný zdroj',
    'autoinstaller_source__url_invalid_network' => 'Neplatný zdroj URL (příklad: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Zdrojová adresa URL',
    'autoinstaller__source_invalid_network' => 'Zadali jste neplatnou síťovou adresu',
    'backup__repository' => 'Umístění úložiště souborů zálohy',
    'backup__error_notify_email' => 'Pokud se během zálohování vyskytne chyba, odešle se oznámení do e-mailu',
    'backup__dump_info' => "Informace o zálohování",
    'backup__dump_file_name_not_defined' => "Není zadán název souboru zálohy",
    'backup__local_file' => 'Místní soubor zálohy',
    'backup__domain_ftp' => 'vzdálený server FTP',
    'backup__wrong_path' => "Nesprávná cesta k úložišti souborů zálohy: nepoužívejte sekvenci znaků ../../",
    'backup__unable_to_connect_to_ftp_server' => "Nelze se připojit k serveru FTP: %1",
    'backup__unable_to_read_file' => 'Nelze přečíst soubor zálohy.',
    'backup__backup_task_does_not_exist' => "Zálohovací úloha neexistuje, před zapnutím byste ji měli vytvořit.",
    'backup__restore_params' => "Parametry obnovení",
    'backup__confirmation' => "Varování: doména nebude k dispozici během zálohování/obnovení.",
    'backup__backup_method' => 'Metoda zálohování',
    'backup__dumpfile_name' => "Název záložního souboru",
    'backup__dumpfile_name_is_invalid' => "Název souboru zálohy je neplatný; můžete použít jen písmena, číslice, pomlčku, tečku nebo podtržítko, nepoužívejte zkratky jako soubor.* apod.",
    'backup__email_required' => "Chcete-li mít stálé informace o postupech zálohování a obnovení, musíte zadat svou e-mailovou adresu. Do podrobností o účtu zadejte svou e-mailovou adresu.",
    'backup__error_during_backup' => "Nelze vytvořit záložní soubor: %1",
    'backup__input_email_warning' => "Musíte zadat e-mail pro oznámení nebo zrušit zaškrtnutí políčka.",
    'backup__make_download' => "neukládejte soubor zálohy do úložiště, jen jej stáhněte",
    'backup__make_dump' => 'vytvořte soubor zálohy a uložte ho do místního úložiště',
    'backup__makedump_to_ftp' => 'vytvořte záložní soubor a umístěte ho na vzdáleném serveru FTP',
    'backup__restore_ip' => "IP adresa pro obnovení",
    'backup__select_dumpfile' => "Vyberte záložní soubor.",
    'backup__time' => "Čas zálohování",
    'backup__day' => 'Den provedení zálohy',
    'backup__view_dump_info' => "Zobrazit informaci o zálohování pro doménu %1",
    'backup__wrong_domain_name' => "Záložní soubor obsahuje data z domény %1 a proto ho nelze obnovit na doménu %2",
    'backup__incorrect_ftp_user_or_passwd' => "Nesprávné uživatelské jméno nebo heslo FTP. Opravte vlastnosti účtu FTP",
    'backup__access_denied' => "Přístup byl odepřen. Opravte, prosím, vlastnosti účtu FTP.",
    'backup__restore_from' => "Obnovit %1",
    'backup__domain_session_failed' => 'Doména %1 nebyla zálohována',
    'backup__client_session_failed' => 'Zákazník %1 nebyl zálohován',
    'backup__domain_session_restore_failed' => 'Doména %1 nebyla obnovena',
    'backup__client_session_restore_failed' => 'Účet zákazníka %1 nebyl obnoven',
    'backup__domain_session_complete' => 'Doména %1 byla zálohována',
    'backup__domain_session_backup' => 'Záloha domény %1',
    'backup__client_session_backup' => 'Záloha zákazníka %1',
    'backup__domain_stop_title' => 'Zrušení zálohy domény %1',
    'backup__client_stop_title' => 'Ruší se zálohování účtu zákazníka %1',
    'backup__domain_restore_stop_title' => 'Zrušení obnovení domény %1',
    'backup__client_restore_stop_title' => 'Ruší se obnovení účtu zákazníka %1',
    'backup__domain_session_backup_stop' => 'Chystáte se zrušit aktivní proces zálohování. Soubor zálohy nebude vytvořen.',
    'backup__backup_stop_confirm' => 'Ano, chci zastavit proces zálohování',
    'backup__restore_stop_confirm' => 'Ano, chci zastavit proces obnovení',
    'backup__domain_session_restore' => 'Obnovení domény %1',
    'backup__domain_session_restore_stop' => 'Chystáte se zrušit probíhající obnovení.',
    'backup__domain_backup_file_info' => 'Informace o záložním souboru domény',
    'backup__domain_backup_file_list' => 'existující soubory zálohy',
    'backup__domain_backup_progress' => 'Průběh zálohování webu %1',
    'backup__domain_restore_progress' => 'Průběh obnovení webu %1',
    'backup__domain_backup_progress_elapsed_time' => 'Uplynulý čas: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Uplynulý čas: %1',
    'backup__domain_restore_session_complete' => 'Doména %1 je obnovena.',
    'backup__domain_restore_session_complete_message' => 'Doména %1 byla obnovena.',
    'backup__domain_backup_file_delete' => 'Následující záložní soubory budou odstraněny:',
    'backup__domain_backup_file_for_remove' => 'Vyberte záložní soubory, které chcete odstranit',
    'backup__backup_overwrite_file_confirm' => 'Potvrzení nahrazení',
    'backup__backup_overwrite_file_confirm_text' => 'Soubor zálohy s názvem "%1" již existuje. Chcete jej nahradit?',
    'backup__backup_confirm_overwrite' => 'Potvrdit nahrazení souboru',
    'backup__backup_overwrite_legeng' => 'Nahradit',
    'backup__backup_not_contain_domain' => 'Soubor zálohy neobsahuje informaci o doméně %1',
    'backup__backup_not_contain_client' => 'Soubor zálohy neobsahuje informaci o účtu zákazníka %1',
    'backup__backup_client_info' => "Zálohovat nastavení zákazníka a podrobnosti o účtu",
    'backup__client_backup_progress' => 'Průběh zálohování účtu zákazníka %1',
    'backup__client_session_complete' => 'Účet zákazníka %1 se zálohuje',
    'backup__client_backup_file_info' => 'Informace o souboru zálohy zákazníka',
    'backup__restore_client_info' => "Obnovit nastavení zákazníka a podrobnosti o účtu",
    'backup__client_session_restore' => 'Obnovení účtu zákazníka %1',
    'backup__client_db_server_map' => 'Mapování databázových serverů',
    'backup__domain_db_server_map' => 'Mapování databázových serverů',
    'backup__client_restore_session_complete_message' => 'Účet zákazníka %1 byl obnoven.',
    'backup__client_restore_session_complete' => 'Účet zákazníka %1 byl obnoven.',
    'backup__restore_select_some' => 'Vyberte, prosím, objekty, které chcete obnovit.',
    'backup__client_restore_progress' => 'Průběh obnovení pro účet zákazníka %1',
    'backup__new_backup' => 'Vytváření nové zálohy',
    'backup__done' => 'Hotovo:',
    'backup__done_domains' => '%1 doména(y) z %2',
    'backup__done_clients' => '%1 zákazník(ů) ze %2',
    'backup__remaining' => 'Zbývá:',
    'backup__remaining_domains' => '%1 doména(y)',
    'backup__remaining_clients' => '%1 zákazník(ů)',
    'backup__overall_backup_progress' => 'Celkový průběh zálohování',
    'backup__comment_n_a' => 'nelze aplikovat',
    'backup__command_ignore' => 'Příkaz "%1" je ignorován',
    'backup__no_objects' => 'nejsou žádné soubory pro zálohování',
    'backup__cli_warning_not_enough_ip' => 'VAROVÁNÍ: nedostatek IP adres pro provedení výchozího IP mapování:',
    'backup__local_repository' => "Úložiště Plesk",
    'backup__ftp_repository' => 'Úložiště FTP',
    'backup__ftp_login' => 'Uživatelské jméno',
    'backup__ftp_password' => 'Heslo',
    'backup__ftp_account_settings' => 'Nastavení účtu FTP',
    'backup__ftp_account_preferences' => 'Nastavení účtu FTP',
    'backup__repository_not_exist' => 'Adresář neexistuje',
    'backup__repository_not_readable' => 'Zadaný adresář není čitelný',
    'backup__ftp_repository_not_configure' => 'Chcete-li použít úložiště záloh FTP, <a href="%1">zadejte účet FTP</a> první.',
    'backup__ftp_repository_list_not_configure' => 'Nastavení účtu není specifikováno',
    'backup__repository_list_unable_listing' => 'Nelze načíst seznam souborů.',
    'backup__ftp_repository_unable_listing' => 'Nelze načíst výpis adresáře "%1":',
    'backup__repository_legend' => 'Úložiště souborů zálohy',
    'backup__store_in_repository' => 'Uložit soubory do',
    'backup__local_repository_lable' => 'Místní úložiště',
    'backup__ftp_repository_lable' => 'Úložiště FTP',
    'backup__ftp_repository_not_configure_hint' => '(nastavení účtu není specifikováno)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(Účet FTP není zadán ani podporován)',
    'backup__other_user_process_modified' => 'Jiný uživatel zastavil zálohování migrace.',
    'backup__another_user_exist' => 'Probíhající operace byla iniciována jiným uživatelem Plesk. Tento uživatel je stále přihlášen do prostředí Plesk.',
    'backup__ftp_repository_wait' => 'Vyčkejte na načtení informací o úložišti FTP',
    'backup__ftp_write_test_failed' => 'Zápis testovacích dat na účet FTP %1 se nezdařil:',
    'backup__ftp_storage' => 'Úložiště FTP(S)',
    'bt_upload_to_repository' => 'Nahrát soubory na místní úložiště',
    'bt_new_restore' => "Obnovit",
    'bt_backup_schedule' => "Plán zálohy",
    'backup_exist_backups' => "Existující soubory zálohy",
    'backup_dialog__page_title' => "Vytvoření souboru zálohy",
    'backup_dialog__please_wait' => "Proces zálohování začíná. Tato operace může trvat nějakou dobu. Čekejte prosím...",
    'backup_conf__page_title' => 'Konfigurace zálohy',
    'bt_accept' => "Přijmout",
    'bt_access' => "Přístup",
    'bt_action_log' => "Protokol akcí",
    'bt_add' => "Přidat",
    'bt_add_client' => "Přidělit uživatelům",
    'bt_database_server_add' => 'Přidat databázový server',
    'bt_add_services' => "Přidat služby",
    'bt_anonftp_stats' => "Statistiky anonymního FTP",
    'bt_anonymous_ftp' => "Anonymní FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Připojit",
    'bt_autoinstaller' => 'Nástroj pro aktualizaci',
    'bt_auto-updates' => 'Nástroj pro aktualizaci',
    'bt_back' => "<< Zpět",
    'bt_backup' => "Zálohovat",
    'bt_backup_configure' => "Nastavení zálohování",
    'bt_buy_certs' => "Koupit certifikáty",
    'bt_card' => "Karta",
    'bt_cert' => "Certifikát",
    'bt_certificates' => "Certifikáty",
    'bt_change_passwd' => "Změnit heslo",
    'bt_clear' => "Vymazat",
    'bt_client_templates' => "Šablony zákazníka",
    'bt_clients' => "Zákazníci",
    'bt_codepage_change' => 'Změnit kódování',
    'bt_comp_info' => "Správa součásti",
    'bt_configure_maillists' => "Nastavit aplikaci Mailman",
    'bt_configure' => 'Konfigurovat',
    'bt_copy' => "Kopírovat",
    'bt_copy_move' => "Kopírovat/Přesunout",
    'bt_create' => "Vytvořit",
    'bt_create_account' => "Vytvořit účet",
    'bt_create_dir' => "Přidat adresář",
    'bt_create_file' => "Přidat soubor",
    'bt_count_size' => "Vypočítat velikost",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Plánovač úloh",
    'bt_custom_button_new' => "Přidat tlačítko",
    'bt_custom_buttons' => "Zákaznická tlačítka",
    'bt_customize' => "Přizpůsobit",
    'bt_databases' => "Databáze",
    'bt_database_servers' => 'Databázové servery',
    'bt_sqlservers' => "Databázové servery",
    'bt_db_usr_new' => "Přidat uživatele databáze",
    'bt_db_new' => "Přidat databázi",
    'bt_db_phpmyadmin' => "Správa MySQL",
    'bt_dbuser_default' => "Nastavit jako výchozí pro webovou správu DB",
    'bt_decline' => "Zamítnout",
    'bt_default' => "Výchozí",
    'bt_defaultcomponents' => "Služby třetích stran",
    'bt_defaults' => "Výchozí nastavení",
    'bt_delete' => "Odstranit",
    'bt_directories' => "Chráněné adresáře",
    'bt_disable' => "Vypnout",
    'bt_dns_zone_sync' => 'Použít změny šablony DNS',
    'bt_dnsrecord_add' => 'Přidat záznam',
    'bt_do_backup' => "Zálohovat",
    'bt_do_restore' => "Obnovit",
    'bt_do_upload' => "Nahrát",
    'bt_domain_aliases' => "Doménové aliasy",
    'bt_domain_templates' => "Šablony domény",
    'bt_domain_user' => "Správce domény",
    'bt_domain_user_passwd' => "Heslo správce domény",
    'bt_domains' => "Domény",
    'bt_domain_alias_add' => 'Přidat doménový alias',
    'bt_download' => "Stáhnout",
    'bt_edit' => "Upravit",
    'bt_enable' => "Zapnout",
    'bt_export' => 'Exportovat',
    'bt_extras' => "Doplňky",
    'bt_finish' => "Dokončit",
    'bt_ftp_account' => "Vlastnosti účtu FTP",
    'bt_forget_password' => "Zapomněli jste heslo?",
    'bt_fp_ssl_webadmin' => "Webová správa FP-SSL/TLS",
    'bt_fp_webadmin' => "Webová správa FP",
    'bt_ftp_stats' => "Statistiky FTP",
    'bt_get_password' => "Získat heslo",
    'bt_global_changes' => "Změnit",
    'bt_help' => "Nápověda",
    'bt_hide_aliases' => "Skrýt aliasy",
    'bt_hide_toolbar' => 'Skrýt panel nástrojů',
    'bt_hide_subdomains' => "Skrýt subdomény",
    'bt_hide_domainaliases' => "Skrýt doménové aliasy",
    'bt_home' => "Domů",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Brána firewall',
    'bt_install' => "Instalovat",
    'bt_ip_aliasing' => "IP adresy",
    'bt_ip_add' => "Přidat IP adresu",
    'bt_ip_pool' => "Fond IP adres",
    'bt_key_info' => "Informace o licencích",
    'bt_key_buyonline_addons' => 'Objednat doplňky prostředí Plesk',
    'bt_key_buyonline_upgrades' => 'Objednat aktualizace prostředí Plesk',
    'bt_key_buyonline_new' => 'Objednat nový klíč',
    'bt_limits' => "Limity",
    'bt_locale_add' => 'Přidat národní prostředí',
    'bt_locales' => 'Národní prostředí',
    'bt_log_manager' => "Správce souborů protokolu",
    'bt_login' => "Přihlásit se",
    'bt_logo' => "Branding.",
    'bt_logo_send_link' => "Přidat odkaz",
    'bt_logo_send_logo' => "Přidat logo",
    'bt_logout' => "Odhlásit se",
    'bt_logrotation' => "Rotace souborů protokolu",
    'bt_mail' => "Pošta",
    'bt_mail_alias_add' => "Přidat alias emailu",
    'bt_mail_aliases' => "E-mailové aliasy",
    'bt_mail_group_add' => "Přidat člena",
    'bt_mail_groups' => "Skupiny",
    'bt_mail_name_add' => "Přidat poštovní účet",
    'bt_mail_preferences' => "Nastavení",
    'bt_mail_group' => "E-mailová skupina",
    'bt_mail_mailbox' => "Poštovní schránka",
    'bt_mail_redirect' => "Server pro předávání pošty",
    'bt_mail_resp_add' => "Přidat automatickou odpověď",
    'bt_mail_resp_attach_add' => "Přidat přílohu",
    'bt_mail_resp_files' => "Soubory přílohy",
    'bt_mail_responders' => "Automatické odpovědi",
    'bt_mail_spamfilter' => "Filtr nevyžádané pošty",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Přidat seznam adresátů",
    'bt_maillists' => "Seznamy adresátů",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Vytvořit zálohu",
    'bt_manage' => "Spravovat",
    'bt_master' => "Hlavní",
    'bt_migrate' => 'Migrovat',
    'bt_modules_add' => 'Přidat rozšíření',
    'bt_modules_manage' => 'Spravovat rozšíření',
    'bt_move' => "Přesunout",
    'bt_mimetypes' => 'Typy MIME',
    'bt_mimetype_new' => 'Přidat typ MIME',
    'bt_new_client' => "Přidat účet zákazníka",
    'bt_new_domain' => "Přidat doménu",
    'bt_next' => "Další>>",
    'bt_next_page' => "Další",
    'bt_network_add' => "Přidat síť",
    'bt_notifications' => "Oznámení",
    'bt_off' => "Vypnout",
    'bt_on' => "Zapnout",
    'bt_on_off' => "Zapnout/Vypnout",
    'bt_pd_new' => "Přidat chráněný adresář",
    'bt_pd_user_new' => "Přidat uživatele",
    'bt_performance' => 'Výkon',
    'bt_permissions' => "Oprávnění",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Nastavení",
    'bt_prev_page' => "Předchozí",
    'bt_preview' => 'Náhled webu',
    'bt_print' => "Vytisknout",
    'bt_reboot' => "Restartovat",
    'bt_reload' => "Načíst znovu",
    'bt_refresh' => "Obnovit",
    'bt_register' => "Registrovat",
    'bt_remove' => "Odebrat",
    'bt_enable_selected' => 'Zapnout',
    'bt_disable_selected' => 'Vypnout',
    'bt_repair_ip' => "Opravit IP adresu",
    'bt_report' => "Sestava",
    'bt_report_new' => "Přidat rozložení",
    'bt_reset' => "Resetovat",
    'bt_restart_services' => "Správa služeb",
    'bt_save' => "Uložit",
    'bt_send_by_email' => "Odeslat e‑mailem",
    'bt_send_file' => "Odeslat soubor",
    'bt_send_mail' => "Odeslat e-mail",
    'bt_send_passwd' => "Odeslat heslo",
    'bt_send_text' => "Odeslat text",
    'bt_server' => "Server",
    'bt_server_add' => "Přidat server",
    'bt_server_preferences' => "Nastavení serveru",
    'bt_servers_list' => "Servery",
    'bt_sessions' => "Relace",
    'bt_set' => "Nastavit",
    'bt_set_as_default' => "Nastavit jako výchozí",
    'bt_setup' => 'Nastavení',
    'bt_show_aliases' => "Zobrazit aliasy",
    'bt_show_subdomains' => "Zobrazit subdomény",
    'bt_show_domainaliases' => "Zobrazit aliasy domén",
    'bt_shutdown' => "Vypnout",
    'bt_site_apppkgs' => "Aplikační trezor",
    'bt_site_apppool' => "Fond aplikací",
    'bt_application-pool' => "Webové aplikace",
    'bt_site_apps' => "Webové aplikace",
    'bt_site_app_add' => "Nainstalovat aplikaci",
    'bt_site_builder' => "Podpora systému Presence Builder",
    'bt_skeleton' => 'Šablona virtuálního hostitele',
    'bt_skins' => 'Vzhledy',
    'bt_skin_add' => 'Přidat vzhled',
    'bt_skin_manual' => 'Vlastní referenční vzhledy prostředí Plesk', // not used
    'bt_skin_download' => 'Stáhnout vzhled',
    'bt_skin_replace' => 'Aktualizovat vzhled',
    'bt_skip' => 'Vynechat',
    'bt_spamassassin' => "Filtr nevyžádané pošty",
    'bt_spamassassin_train' => "Instruktáž",
    'bt_spamfilter' => "Filtr nevyžádané pošty",
    'bt_start' => "Spustit",
    'bt_stop' => "Zastavit",
    'bt_recycle' => "Recyklovat",
    'bt_statistics' => "Statistiky",
    'bt_subdomain_new' => "Přidat subdoménu",
    'bt_subdomains' => "Subdomény",
    'bt_submit' => "Odeslat",
    'bt_summary_report' => "Souhrnné hlášení",
    'bt_support' => "Podpora",
    'bt_switch' => "Přepnout",
    'bt_system_time' => "Systémový čas",
    'bt_task_new' => "Přidat úkol",
    'bt_dom_tmpl_add' => 'Přidat šablonu domény',
    'bt_cl_tmpl_add' => 'Přidat šablonu zákazníka',
    'bt_cron_backup' => 'Nastavení plánovaného zálohování',
    'bt_test' => "Testovat připojení",
    'bt_text' => "Text",
    'bt_touch' => "Změnit časové razítko",
    'bt_traffic' => "Provoz",
    'bt_traffic_history' => "Historie přenosu dat",
    'bt_update' => "Aktualizovat",
    'bt_upload' => "Nahrát",
    'bt_upload_from_ftp' => "Odeslat na FTP",
    'bt_virtualdirs' => 'Virtuální adresáře',
    'bt_virtualdir_new' => 'Přidat virtuální adresář',
    'bt_virtualdir_add' => 'Přidat virtuální adresář',
    'bt_web_app_new' => "Nainstalovat aplikaci Java",
    'bt_web_stats' => "Webové statistiky",
    'bt_web_stats_ssl' => "Webové statistiky SSL/TLS",
    'bt_web_user_add' => "Přidat uživatele webu",
    'bt_web_users' => "Uživatelé webu",
    'bt_webadmin' => "Správa webu",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Zobrazit celý seznam změn",
    'cert_add__unable_set_ca_cert' => "Nelze zadat CA Certifikát: %1",
    'cert_add__unable_set_cert' => "Nelze zadat certifikát: %1",
    'cert_add__unable_set_private_key' => "Nelze zadat soukromý klíč: %1",
    'certificates_list__certificate_used_as_default' => "Jeden z certifikátů, které se chystáte odstranit, se používá jako výchozí certifikát.",
    'certificates_list__certificates_assigned_on_ip' => "IP adresám/doménám byl přiřazen jeden certifikát nebo několik certifikátů.",
    'ch_pass__admin_pass' => "Změnit heslo správce",
    'ch_pass__old_pass' => "Staré heslo",
    'ch_pass__pass_confirm' => "Potvrdit",
    'ch_pass__unable_change_admin_pass' => "Nelze změnit heslo správce: %1",
    'check_mail_cycle__aliases' => "Bylo zjištěno cyklování emailů, adresa \"%1\" je obsažena v aliasech tohoto e-mailového účtu.",
    'check_mail_cycle__autoresponders' => "Bylo zjištěno cyklování emailů, adresa \"%1\" je obsažena v automatických odpovědích tohoto e-mailového účtu.",
    'check_mail_cycle__mail_groups' => "Bylo zjištěno cyklování emailů, adresa \"%1\" je obsažena v e-mailové skupině tohoto e-mailového účtu.",
    'check_mail_cycle__mail_name' => "Bylo zjištěno cyklování emailů, adresa \"%1\" se shoduje s tímto e-mailovým účtem.",
    'check_mail_cycle__redirect' => "Bylo zjištěno cyklování emailů, adresa \"%1\" se shoduje se serverem pro předávání tohoto e-mailového účtu.",
    'check_mail_dup__redirect' => "Bylo zjištěno duplicitní předávání, adresa \"%1\" se shoduje s předávací adresou tohoto e-mailového účtu.",
    'check_mail_dup__mail_groups' => "Bylo zjištěno duplicitní předávání, adresa \"%1\" je obsažena v e-mailové skupině tohoto e-mailového účtu.",
    'check_maillist_cycle__admin' => "Bylo zjištěno cyklování emailů, e-mail správce \\&amp;apos;%1\\&amp;apos; se shoduje s adresou seznamu adresátů.",
    'check_maillist_cycle__member' => "Bylo zjištěno cyklování emailů, e-mailová adresa \\\"%1\\\" koliduje s adresou v seznamu adresátů.",
    'chk_js__enter_login_and_passwd' => "Zadejte přihlašovací jméno a heslo.",
    'chk_js__enter_login_name' => "Zadejte přihlašovací jméno.",
    'chk_js__enter_passwd' => "Zadat heslo.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Detaily účtu %1'",
    'cl_limits__cl' => "Limity zákazníka %1",
    'cl_logo__setup_logo_pref' => "Nastavit vlastnosti loga pro zákazníka %1",
    'cl_new__enter_new_cl_data' => "Zadejte informace na nového zákazníka",
    'cl_new__unable_to_sent_notification' => 'Uživatelský účet byl vytvořen, nicméně odeslání upozornění zákazníkovi se nezdařilo: %1',
    'cl_perm__all_ip' => "Veškeré dostupné IP adresy",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Všechny hostingové účty pro zákazníka založené na IP adrese budou převedeny na účty založené na názvu.",
    'cl_perm__allow_client_create_domain' => "Pole, která se pokoušíte vybrat, se týkají pouze zákazníků, kteří mají povolení vytvářet domény.",
    'cl_perm__allow_create_nb_w_ip' => "Zákazník může prostřednictvím %1 vytvořit hosting založený na názvu",
    'cl_perm__allow_creation_ip_based_hosting' => "Povolit vytvoření hostingového účtu založeného na IP adrese",
    'cl_perm__available_ips' => "Dostupné IP adresy",
    'cl_perm__change_limits' => "Úprava limitů",
    'cl_perm__cl_disk_space' => "Celkové dostupné místo na disku",
    'cl_perm__cl_expiration' => "Doba platnosti účtu zákazníka",
    'cl_perm__cl_max_box' => "Poštovní schránky",
    'cl_perm__cl_max_db' => "Databáze",
    'cl_perm__cl_max_dom' => "Domény",
    'cl_perm__cl_max_maillists' => "Seznamy adresátů",
    'cl_perm__cl_max_subdom' => "Subdomény",
    'cl_perm__cl_max_traffic' => "Celkový objem dostupných datových přenosů",
    'cl_perm__cl_max_wu' => "Uživatelé webu",
    'cl_perm__cl_mbox_quota' => "Limit velikosti poštovní schránky pro tento uživatelský účet",
    'cl_perm__current_maximum_exp_date' => "Maximální aktuální hodnota doby platnosti domény je %1; požadováno %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Aktuálně stanovené omezení velikosti prostoru na disku vyhrazeného pro poštovní schránky pod tímto uživatelským účtem je %1; požadováno %2",
    'cl_perm__current_total_requested' => "Aktuální celková hodnota limitů domény %1 je %2; požadováno %3.",
    'cl_perm__current_total_requested_dom' => "Aktuální počet %1 patřící tomuto zákazníkovi je %2; požadovaný %3.",
    'cl_perm__disk_space' => "maximální velikost místa na disku",
    'cl_perm__dashboard_stdgui' => 'Uživatelské rozhraní',
    'cl_perm__dashboard' => 'Zobrazení domovské stránky',
    'cl_perm__stdgui' => 'Standardní zobrazení',
    'cl_perm__manage_dashboard' => 'Správa domovské stránky',
    'cl_perm__dashboard_and_stdgui' => 'Zobrazení domovské stránky a standardní zobrazení je povoleno',
    'cl_perm__dashboard_only' => 'Je povoleno pouze zobrazení domovské stránky',
    'cl_perm__stdgui_only' => 'Je povoleno pouze standardní zobrazení',
    'cl_perm__edit_cl' => "Oprávnění zákazníka %1",
    'cl_perm__exp_date_exceeded' => "Doba platnosti, kterou se pokoušíte nastavit, překračuje limit definovaný jednotlivými doménami vztahujícími se k tomuto zákazníkovi.",
    'cl_perm__invalid_value' => "Neplatná hodnota, jsou povoleny pouze číslice.",
    'cl_perm__limit_disk_space' => "%1 Omezení celkové velikosti místa na disku",
    'cl_perm__limit_expiration' => "%1 Omezit dobu platnosti pro účet zákazníka",
    'cl_perm__limit_max_box' => "%1 Omezení maximálního počtu poštovních schránek",
    'cl_perm__limit_max_db' => "%1 Omezení maximálního počtu databází",
    'cl_perm__limit_max_dom' => "%1 Omezení maximálního počtu domén",
    'cl_perm__limit_max_maillists' => "%1 Omezení maximálního počtu seznamů adresátů",
    'cl_perm__limit_max_subdom' => "%1 Omezení maximální počet subdomén",
    'cl_perm__limit_max_traffic' => "%1 Omezení celkového objemu přenesených dat",
    'cl_perm__limit_max_wu' => "%1 Omezení maximálního počtu uživatelů webu",
    'cl_perm__limit_mbox_quota' => "%1 Nastavit kvótu poštovní schránky",
    'cl_perm__limits_exceeded' => "Jeden nebo několik limitů, které se pokoušíte nastavit, již překročil limity definované jednotlivými doménami patřícími tomuto zákazníkovi. Celkový limit pro zákazníka musí být stejný nebo rovný celkovému součtu limitů domény stanovených pro tento účet zákazníka.",
    'cl_perm__mailbox_quota_exceeded' => "Limit místa na disku přiděleného pro poštovní schránky, který se pokoušíte nastavit, překračuje limit definovaný jednotlivými doménami vztahujícími se k tomuto účtu zákazníka.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Limit místa na disku přiděleného pro poštovní schránky, který se pokoušíte nastavit, překračuje limit předepsaný na úrovni serveru.",
    'cl_perm__make_dumps' => "Zálohovat a obnovit data",

    'cl_perm__max_box' => "maximální počet poštovních schránek",
    'cl_perm__max_db' => "maximální počet databází",
    'cl_perm__max_dom' => "domény",
    'cl_perm__max_maillists' => "maximální počet seznamů adresátů",
    'cl_perm__max_subdom' => "subdomény",
    'cl_perm__max_traffic' => "maximální objem přenesených dat",
    'cl_perm__max_wu' => "maximální počet uživatelů webu",
    'cl_perm__max_dom_aliases' => "doménové aliasy",
    'cl_perm__mbox_quota' => "kvóta poštovní schránky",
    'cl_perm__not_allow_create_nb_hst' => "Zákazník nemůže vytvořit hosting založený na názvu.",
    'cl_perm__this_ip_used_vrt_hst' => "Tato IP adresa je používána virtuálním hostingem.\nChcete-li tuto IP adresu odstranit, odeberte služby hostingu nebo změňte jeho typ na hosting založený na názvu.",
    'cl_perm__unable_off_ipb_creating' => "Zákazník má již nastaveny hostitelské služby založené na IP adrese. Chcete-li deaktivovat tuto funkci pro zákazníka, zrušte zaškrtnutí políčka \"Domain creation\" nebo odeberte všechny hostingové účty založené na IP adresách.",
    'cl_perm__unable_off_nb_creating' => "Zákazník má již nastaveny hostitelské služby založené na názvu. Chcete-li deaktivovat tuto funkci pro zákazníka, zrušte zaškrtnutí políčka \"Domain creation\" nebo odeberte všechny hostingové účty založené na názvu.",
    'cl_perm__unable_set_domain_limit' => "Nelze omezit maximální počet domén: zákazník má již %1 domén",
    'cl_perm__unable_update_client_limitations' => "Nelze upravit limity účtu zákazníka: %1",
    'cl_pref__edit_cl' => "Předvolby zákazníka %1",
    'class_anonftp__create_ftp_domain' => "Virtuální doména FTP pro toto dom_id neexistuje, zkuste ji nejprve vytvořit.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Limit diskového prostoru, který se pokoušíte nastavit (%1), nesmí překročit celkový limit diskového prostoru definovaný na doménové úrovni (%2).",
    'class_anonftp__invalid_input_only_digits' => "Byla zadána neplatná hodnota, jsou povoleny pouze číslice.",
    'class_anonftp__unable_change_ownerships' => "Nelze změnit vlastnictví či oprávnění pro soubor kvóty: %1",
    'class_anonftp__unable_copy_quota_file' => "Nelze zkopírovat soubor kvóty: %1",
    'class_anonftp__unable_get_disk_usage' => "Nelze obnovit informaci o využití disku pro příchozí adresář: %1",
    'class_anonftp__unable_parse_quota_file' => "Nelze analyzovat soubor kvóty.",
    'class_anonftp__unable_read_quota_file' => "Nelze přečíst soubor kvóty: %1",
    'class_anonftp__unable_update_quota' => "Nelze aktualizovat kvótu: soubory v příchozí složce zabírají %1 kB diskového prostoru, což převyšuje novou hodnotu kvóty.",
    'class_anonftp__unable_write_temp_file' => "Nelze zapsat do dočasného souboru: %1",
    'class_bsdomain__warn_max_date__' => "Datum vypršení platnosti bylo nastavena na %1",
    'class_cList__empty' => "Žádné položky.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Pro <b>\\\"%1\\\"</b> v %2 (%3 z %4) nebyla nalezena žádná shoda.",
    'class_cList__search_result' => "Výsledky vyhledávání pro <b>\\\"%1\\\"</b> in %2 (%3 z %4).",
    'class_client__client_creation_notification' => "Upozornění na vytvoření zákazníka.",
    'class_client__client_with_contact_name_already_exists' => "Zákazník se jménem %1 již existuje.",
    'class_client__disk_space' => "Místo na disku",
    'class_client__invalid_max_dom' => "Neplatná hodnota domény, jsou povoleny jen číslice.",
    'class_client__limit_exceed' => "Požadované množství %1 nelze přidělit, protože by překročilo naplnění pro účet zákazníka %2 (%3). Pokud chcete alokovat větší množství prostředků, přejděte na položku Zákazníci> Jméno zákazníka> Limity a změna plnění na základě požadavku. Poté se vraťte na tuto stránku a zkuste znovu upravit naplnění.",
    'class_client__limit_exceed_unlimited' => "Pokud chcete přidělit neomezeně množství prostředků (%1), nejprve musíte přejít do nabídky Zákazníci> Jméno zákazníka> Limity, a vybrat zaškrtávací políčko Neomezeně, odpovídající požadovanému typu prostředku. Poté se vraťte na tuto stránku a zkuste znovu upravit naplnění.",
    'class_client__max_box' => "Poštovní schránky",
    'class_client__max_db' => "Databáze",
    'class_client__max_maillists' => "Seznamy adresátů",
    'class_client__max_subdom' => "Subdomény",
    'class_client__max_traffic' => "Maximální přenos dat",
    'class_client__max_wu' => "Uživatelé webu",
    'class_client__max_dom_aliases' => "Doménové aliasy",
    'class_client__mbox_quota' => "Kvóta poštovní schránky",
    'class_client__unable_define_cl_status' => "Nelze definovat stav účtu zákazníka: %1",
    'class_client__unable_define_inactive_dom' => "Nelze definovat neaktivní domény %1.",
    'class_client__unable_del_ip' => "Nelze odebrat IP adresy: %1",
    'class_db__db_name_not_set' => "Název databáze není definován.",
    'class_db__db_not_exist_for_curr_dom' => "Databáze pro tuto doménu neexistuje.",
    'class_db__invalid_db_or_dom_name' => "ID domény či databáze je neplatné nebo není definován název databáze.",
    'class_db__invalid_pass' => "Heslo je neplatné.",
    'class_db__mailgrp_member_exist' => "Člen e-mailové skupiny již existuje.",
    'class_db__access_hosts_notsupport' => 'Nastavení hostitelských přístupů není pro tento typ databáze podporováno',
    'class_db__unable_add' => 'Nelze přidat záznam o hostitelských přístupech: %1',
    'class_db__unable_del' => 'Nelze odstranit záznam o hostitelských přístupech: %1',
    'class_db__inc_user_not_exist' => 'Uživatel databáze "%1" neexistuje',
    'class_db__inc_access_record_exist' => 'Tento přístupový záznam již existuje',
    'class_db__inc_access_record_not_exist' => 'Daný přístupový záznam neexistuje',
    'class_db__inc_unable_del_last_record' => 'Nelze odstranit poslední hostitelský záznam přístupů',
    'class_domtmpleditform__dns_master' => "Primární",
    'class_domtmpleditform__dns_slave' => "Sekundární",
    'class_domtmpleditform__dns_type' => "Typ zóny DNS domény",
    'clienttrafficlist_header' => "Přenos dat na doménách",
    'clienttrafficlist_header_of_client__' => "Přenos dat na doméně zákazníka %1",
    'cmd_dns__a_dns_record_already_exist' => "Tento záznam způsobí konflikt se záznamem A pro zónu.",
    'cmd_dns__domain_last_ns' => 'Nelze smazat poslední záznam DNS NS pro doménu.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kanonický název domény je neplatný.",
    'cmd_dns__cname_dns_record_already_exist' => "Tento záznam způsobí konflikt se záznamem CNAME pro zónu.",
    'cmd_dns__cname_in_rr_combination' => 'Nesprávná kombinace záznamů DNS je přítomna v zóně DNS',
    'cmd_dns__cname_coexist_with_data' => 'Záznam CNAME zóny DNS nemůže existovat s jinými záznamy DNS ve stejné zóně.',
    'cmd_dns__dns_record_type_is_invalid' => "Typ záznamu DNS je neplatný.",
    'cmd_dns__ext_host_is_not_resolved' => "Kanonický název %1 není rozlišen na záznam typu A nebo AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Nelze přidat záznam %1 do zóny %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Název služby Mail Exchanger je neplatný.",
    'cmd_dns__mx_priority_is_invalid' => "Priorita MX je neplatná.",
    'cmd_dns__name_server_is_invalid' => "Názvový server je neplatný.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Hodnota masky sítě by měla být 24, 16 nebo 8.",
    'cmd_dns__this_dns_record_already_exists' => "Takový záznam DNS již existuje.",
    'cmd_dns__unable_add_record' => "Nelze přidat záznam '%1' : %2",
    'cmd_dns__unable_add_a_record' => "Nelze přidat záznam A: %1",
    'cmd_dns__unable_add_cname_record' => "Nelze přidat záznam CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Nelze přidat záznam DNS: %1",
    'cmd_dns__unable_add_ext_ns_record' => "Nelze přidat záznam EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Nelze přidat záznam NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Nelze přidat záznam PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Nelze přidat záznam TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Nelze vytvořit zónu DNS %1",
    'cmd_dns__unable_define_dns_record' => "Nelze definovat záznam DNS: %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Nelze obnovit stav výchozí zóny DNS: %1",
    'cmd_dns__unable_insert_a_record' => "Nelze vložit záznam A: %1",
    'cmd_dns__unable_insert_mx_record' => "Nelze vložit záznam MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Nelze vložit záznam NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Nelze nastavit stav zóny DNS: %1",
    'cmd_domains__dom_already_exists' => "Doména %1 již existuje.",
    'cmd_domains__dns_record_already_exists' => "Nelze vytvořit doménu %1, protože záznam DNS odkazující na hostitele %1 již existuje.",
    'cmd_domains__dom_already_exists1' => "V této doméně je %2 subdomén. Doména %1 již existuje.",
    'cmd_domains__dom_already_exists2' => "subdoména %1 již existuje.",
    'cmd_domains__dalias_already_exists' => "Tento alias již existuje.",
    'cmd_domains__domain_alias_already_exists' => 'Alias domény s tímto názvem již existuje.',
    'cmd_domains__unable_del_mail_for_dom' => "Nelze odstranit poštovní služby pro doménu: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Nelze odstranit anonymní FTP účet pro doménu: %1",
    'cmd_domains__unable_update_dom_param' => "Nelze aktualizovat parametry domény: %1.",
    'cmd_domains__unable_rename_client_exist' => "přihlašovací jméno správce domény se již používá.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Typ hostingu není fyzický.",
    'cmd_hosting__unable_create_user' => "Nelze vytvořit uživatele %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Nelze definovat IP adresu pro virtuální hostitele založené na názvu: %1",
    'cmd_hosting__unable_del_old_hst' => "Nelze odstranit dříve nastavený hosting: %1",
    'cmd_hosting__unable_del_protected_directory' => "Nelze odstranit chráněný adresář: %1",
    'cmd_hosting__unable_del_web_user' => "Nelze odstranit uživatele webu: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Nelze vytvořit nebo aktualizovat virtuálního hostitele: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Nelze nastavit rámcové přesměrování hostingu.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Nelze znovu vytvořit konfigurační soubor proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Nelze nastavit SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Nelze odstranit ochranu z adresáře SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Nelze aktualizovat cílovou adresu URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Nelze aktualizovat zónu DNS pro doménu: provedení nástroje se nezdařilo.",
    'cmd_hosting__unable_update_ftp_passwd' => "Nelze aktualizovat heslo FTP %1.",
    'cmd_hosting__unable_update_user' => "Nelze aktualizovat uživatele %2: %1",
    'cmd_hosting__unknown_hst_type' => "Neznámý typ hostingu.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Nemáte oprávnění ukončit hostingové služby.",
    'cmd_mail__autoresponder__not_configured' => "Automatická odpověď pro tento e-mailový účet není nakonfigurována",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adresa %1 se již používá k předávání pošty.",
    'cmd_mail__alias_already_exists' => "alias již existuje.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID automatické odpovědi a ID emailového účtu se neshodují.",
    'cmd_mail__autoresp_id_is_undefined' => "ID automatického odpovědi není definováno.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "E-mailový alias s tímto názvem již existuje pro e-mailový účet %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "E-mailový účet %1 je již přihlášen do tohoto seznamu adresátů.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "E-mailový účet %1 již existuje v této doméně.",
    'cmd_mail__mail_name_not_exist' => "E-mailový účet neexistuje.",
    'cmd_mail__mail_name_passwd_part' => "Žádná část hesla nesmí obsahovat název e-mailového účtu.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Seznam adresátů %1 již v této doméně existuje.",
    'cmd_mail__mailname_already_exist_in_mg' => "E-mailový účet %1 je již v emailové skupině.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "E-mailový účet %1 již existuje v této doméně.",
    'cmd_mail__mailname_already_exists' => "E-mailový účet již existuje",
    'cmd_mail__mailname_is_invalid' => "Název e-mailového účtu %1 je neplatný.",
    'cmd_mail__mailname_unable_update' => "Nelze aktualizovat vlastnosti e-mailového účtu:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "U této domény bylo dosaženo maximálního počtu automatických odpovědí.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "U této domény bylo dosaženo maximálního počtu e-mailových skupin.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "U této domény bylo dosaženo maximálního počtu serverů pro předávání pošty.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Bylo dosaženo maximálního počtu poštovních schránek.",
    'cmd_mail__no_members_specified' => "nebyli specifikováni žádní členové.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Heslo je příliš jednoduché, prosím zvolte si jiné.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Tato e-mailová adresa se již používá.",
    'cmd_mail__unable_define_autoresp_id' => "Nelze definovat automatickou odpověď ID %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Změna nastavení poštovních služeb pro doménu %1 se nezdařila",
    'cmd_mail__unable_del_mail_for_dom' => "Z domény %1 nelze odstranit poštovní službu.",
    'cmd_mail__unable_del_mail_redirection' => "Nelze odebrat funkci předávání pošty %1",
    'cmd_mail__unable_remove_autoresp' => "Nelze odebrat automatické odpovědi: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Nelze odstranit členy e-mailové skupiny: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Selhalo vypnutí e-mailové skupiny: %1",
    'cmd_mail__unable_update_mail_redirect' => "Nelze změnit konfiguraci služby pro předávání pošty %1",
    'cmd_mail__uploaded_file_is_too_big' => "Velikost nahrávaného souboru je příliš velká.",
    'cmd_mail__additionally' => "Navíc:",
    'cmd_pd__invalid_login' => "Nesprávné přihlašovací jméno.",
    'cmd_pd__this_user_already_exist' => "Tento uživatel již existuje",
    'cmd_pd__unable_define_hst_type' => "Nelze definovat typ hostingu.",
    'cmd_pd__unable_upd_pd_usr' => "Nelze aktualizovat vlastnosti uživatele chráněného adresáře: %1",
    'cmd_pd__user_is_undefined' => "Uživatel není definován.",
    'cmd_server__no_enough_free_disk_space' => "Nedostatek místa na disku.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "staré heslo je nesprávné. Zkuste to znovu.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "pro tuto doménu byl dosažen limit maximálního počtu uživatelů webu.",
    'cmd_web_usr__unable_create_user' => "nelze vytvořit systémového uživatele: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "nelze nastavit limit pro maximální počet uživatelů webu: %1",
    'cmd_web_usr__user_already_exists' => "uživatel již existuje.",
    'cmd_web_usr__web_user_name_is_invalid' => "název uživatele webu %1 je neplatný.",
    'cmd_web_usr__web_user_not_exist' => "uživatel webu neexistuje.",
    'common_func__exec_bad_argument' => "argument exec nesmí obsahovat jednoznakové symboly.",
    '__eol' => 'Konce řádků',
    'eol__binary_file' => 'V binárním souboru nelze změnit styl rozložení řádků.',
    'cp_access_admin_deny' => "Přístup pro správce z adresy '%1' je zakázán v souvislosti s aktuálně aplikovanými zásadami omezení IP přístupu.",
    'create_domain_warn__' => "Během vytváření domény byly vytvořeny následující výjimky:",
    'create_domain__client_select' => 'Vyberte zákazníka, pro kterého chcete vytvořit doménu',

    'dashboard__nav_button_name' => "Domů",
    'dalias__list_title' => 'Doménové aliasy domény %1',
    'dalias__list_legend' => 'Doménové aliasy',
    'dalias__list_header' => 'Doménové aliasy',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Název doménového aliasu',
    'dalias__list_ascii_name' => 'Ve formátu ASCII',
    'dalias__remove_title' => 'Následující doménové aliasy domény %1 budou odstraněny:',
    'dalias__select_domain_aliases_to_remove' => 'Vyberte doménové aliasy, které budou odstraněny.',
    'dalias__mail_turn_on_failed' => 'Nelze zapnout poštovní službu: %1',
    'dalias__web_turn_on_failed' => 'Nelze zapnout webovou službu: %1',
    'db_usr_edit__db_usr_name_old' => "Staré jméno uživatele databáze",
    'database_server_edit_form__cannot_infer_type' => 'Z poskytnutých dat nelze vyvodit způsob připojení. Abyste se připojli pomocí TCP/IP se zadaným portem, použijte jako název hostitele databázového serveru "127.0.0.1". Pokud chcete použít unixový socket "%1", ponechte pole portu prázdné.',
    'database_server_edit_form__duplicate' => 'Databázový server s touto kombinací adresy hostitele a čísla portu je již registrován.',
    'database_server_edit_form__host_is_invalid' => 'Zadaný název hostitele je neplatný.',
    'database_server_edit_form__port_is_invalid' => 'Zadané číslo portu je neplatné.',
    'database_server_error__consult_admin' => 'Kontaktujte správce serveru.',
    'database_server_error__last__connection_failed' => 'Poslední pokus o správu tohoto databázového serveru se nezdařil kvůli problémům se sítí.',
    'database_server_error__last__permission_denied' => 'Poslední pokus o správu tohoto databázového serveru se nezdařil, protože daný účet nemá oprávnění správce.',
    'database_server_error__last__credentials_not_set' => "Poslední pokus o připojení k tomuto serveru se nezdařil, protože nebylo zadáno platné přihlašovací jméno a heslo správce.",
    'database_server_error__last__other_error' => 'atabázového serveru se nezdařil.',
    'database_server_error__real__connection_failed' => 'Připojení k databázovému serveru se nezdařilo kvůli problémům se sítí:',
    'database_server_error__real__permission_denied' => 'Připojení k databázovému serveru se nezdařilo, protože daný účet nemá oprávnění správce:',
    'database_server_error__real__duplicate_object' => 'Připojení k databázovému serveru se nezdařilo kvůli konfliktu názvu:',
    'database_server_error__real__unacceptable_name' => 'Připojení k databázovému serveru se nezdařilo kvůli neplatnému názvu objektu:',
    'database_server_error__real__unacceptable_password' => 'Připojení k databázovému serveru se nezdařilo kvůli kvůli nepřijatelnému heslu:',
    'database_server_error__real__credentials_not_set' => "Plesk se nemůže připojit k databázovému serveru, protože nebylo zadáno platné přihlašovací jméno a heslo správce.",
    'database_server_error__real__other_error' => 'Připojení k databázovému serveru se nezdařilo:',
    'database_server_error__test__connection_failed' => 'Testovací připojení k databázovému serveru se nezdařilo kvůli problémům se sítí:',
    'database_server_error__test__permission_denied' => 'Testovací připojení k databázovému serveru se nezdařilo, protože daný účet nemá oprávnění správce:',
    'database_server_error__test__duplicate_object' => 'Testovací připojení k databázovému serveru se nezdařilo kvůli konfliktu názvu:',
    'database_server_error__test__unacceptable_name' => 'Testovací připojení k databázovému serveru se nezdařilo kvůli neplatnému názvu objektu:',
    'database_server_error__test__unacceptable_password' => 'Testovací připojení k databázovému serveru se nezdařilo kvůli nepřijatelnému heslu:',
    'database_server_error__test__credentials_not_set' => "Testovací připojení k tomuto serveru se nezdařilo, protože nebylo zadáno platné přihlašovací jméno a heslo správce.",
    'database_server_error__test__other_error' => 'Testovací připojení k databázovému serveru se nezdařilo:',

    'db__create_new_db' => "Přidat databázi",
    'db__db_add' => "Přidat databázi",
    'db__db_for_dom' => "Databáze webu %1",
    'db__db_id_undefined' => "ID databáze není definováno.",
    'db__db_name' => "Název databáze",
    'db__db_not_exist' => "Databáze neexistuje.",
    'db__db_type' => "Typ",
    'db__db_server' => "Databázový server",
    'db_server_not_exist' => "Databázový server neexistuje.",
    'db__db_user_not_exist' => "Uživatel databáze neexistuje.",
    'db__domain_not_exist' => "Doména neexistuje.",
    'db__enter_db_name' => "Zadat nový název databáze.",
    'db__invalid_db_id' => "Identifikátor databáze je neplatný.",
    'db__invalid_db_name' => "Název databáze je neplatný. Název databáze by měl obsahovat pouze znaky latinky, číslice, podtržítko nebo pomlčku. Nesmí být delší než 63 znaků.",
    'db__max_db_reached_for_dom' => "Pro tuto doménu byl dosažen limit počtu databází.",
    'db__max_mssql_db_reached_for_dom' => "U této domény bylo dosaženo limitu v počtu databází Microsoft SQL Server.",
    'db__postgres_not_connect_for_admin' => "Nelze se připojit k PostgreSQL. Zapnout podporu PostgreSQL na stránce pro správu serveru.",
    'db__postgres_not_connect_for_client' => "Nelze se připojit k PostgreSQL. Požádejte o pomoc svého správce systému.",
    'db__remove_db_on_domain' => "Následující databáze pod webem %2 ve vlastnictví zákazníka %1 budou odebrány:",
    'db__remove_db_on_domain_of_cl' => "Následující databáze pro doménu %2 ve vlastnictví zákazníka %1 budou odebrány:",
    'db__remove_db_linked_resource' => 'Tuto databázi používá webová aplikace. Lze ji odebrat pouze po odinstalaci této webové aplikace.',
    'db__remove_db_users' => "Následující uživatelé databáze %3 pod webem %2 vlastněným zákazníkem %1 budou odebráni:",
    'db__remove_db_users_of_cl' => "Následující uživatelé databáze %3 pod webem %2 vlastněným zákazníkem %1 budou odebráni:",
    'db__select_db_for_remove' => "Vyberte databázi, která bude odebrána.",
    'db__select_db_users_for_remove' => "Vyberte uživatele databáze, který bude odebrán.",
    'db__unable_create_db_user' => "Nelze vytvořit uživatele databáze: %1",
    'db__unable_define_db_name' => "Nelze definovat název databáze: %1",
    'db__unable_define_db_user' => "Nelze definovat uživatele databáze: %1",
    'db__unable_define_db_users' => "Nelze definovat uživatele databáze: %1",
    'db__unable_select_dom_name' => "Nelze vybrat název domény: %1",
    'db_edit__db_for_dom' => "Uživatelé pro databázi %1 na doméně %2",
    'db_edit__invalid_db_name' => "Název databáze je neplatný.",
    'db_edit__no_users' => "Pro tuto databázi nejsou žádní oprávnění uživatelé.",
    'db_edit__unable_define_db_usrs' => "Nelze definovat uživatele databáze: %1",
    'db_edit__unable_select_db_usr' => "Nelze vybrat uživatele databáze.",
    'db_edit__db_user_password_for_' => "Chcete-li se přihlásit do databáze jako uživatel %1, zadejte heslo",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Přidat uživatele databáze",
    'db_usr_edit__db_usr_name' => "Jméno uživatele databáze",
    'db_usr_edit__edit_db_usr' => "Nastavit pověření pro účet uživatele databáze",
    'db_usr_edit__for_db' => "v databázi %1",
    'db_usr_edit__not_create_pass' => "Tato operace bude mít za výsledek vytvoření účtu uživatele databáze bez hesla.\nChcete vytvořit uživatele bez přidělení hesla?",
    'dbuser__only_one_user_can_be_default' => "Pouze jeden uživatel může být nastaven jako výchozí.",
    'db_server__cannot_delete_default' => "Výchozí databázový server nelze odstranit.",
    'db_server__cannot_delete_local' => "Místní databázový server nelze odstranit.",
    'db_server__cannot_delete_used' => 'Databázový server nelze odstranit, pokud jsou na něm hostovány databáze nebo uživatelé databáze',
    'demo__disabled_in_demo' => "Tato operace není v demo verzi podporována.",
    'defaultcomponents__title' => "Výběr výchozích součásti",
    'defaultcomponents__select_default' => "Vybrat výchozí součást %1",//to check
    'defaultcomponents__not_installed' => "(není nainstalováno)",
    'defaultcomponents__not_configured' => "(nenakonfigurováno)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Některé kategorie služeb obsahují neplatné výběry nebo nebyly žádné výběry provedeny.",
    'defaultcomponents__depends_on' => "(požaduje %1)",
    'defaultcomponents__parameters' => "Parametry %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "Server SQL",
    'component_name__sqladmin' => "Správa webu MySQL",
    'component_name__sqladminmysql' => "Správa webu MySQL",
    'component_name__dnsserver' => "DNS server",
    'component_name__firewall' => "Brána firewall",
    'component_name__ftpserver' => "Server FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "E-mailový server",
    'component_name__local_mailserver' => "Místní poštovní server",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Skriptování pro web",
    'component_name__spamfilter' => "Filtr nevyžádané pošty",
    'component_name__stats' => "Webová statistika",
    'component_name__stunnel' => "Obálka SSL/TLS",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Publikování na webu",
    'component_name__webserver' => "Webový server",
    'dns__dns_record_invalid_values' => 'Byly zadány nesprávné hodnoty záznamu DNS: %1: %2',
    'dns__dns_record_not_found' => 'Záznam DNS nebyl nalezen',
    'dns__dns_zone_invalid_values' => 'Byly zadány nesprávné parametry zóny DNS.',

    'dns__soa_mname_title' => 'Primární jmenný server',
    'dns__soa_mname_legend' => 'Jmenný server',
    'dns__soa_mname_autoselect' => '(Automatický výběr)',

    'dns__dns_zone_off_remove_title' => "Následující záznamy prostředků budou odstraněny ze zóny %1:",
    'dns__dns_zone_master_remove_title' => "Odebírání záznamů prostředků ze zóny DNS %1",
    'dns__dns_zone_slave_remove_title' => "Následující záznamy primárního názvového serveru pro %1 budou odstraněny:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Zadat řetězec záznamu',
    'dns_add__is_spf_syntax' => 'Záznam SPF',
    'dns_add__spf_value_is_invalid' => "Hodnota záznamu SPF je nesprávná, musí začínat 'v=spf'",
    'dns__dns_zone_status' => "Stav zóny DNS.",
    'dns__invalid_ip_address' => "IP adresy nového primárního serveru DNS jsou neplatné nebo prázdné.",
    'dns__ip_address' => "IP adresa",
    'dns__master_dns_type' => "je primární server DNS",
    'dns__masters' => "primární servery DNS",
    'dns__soa_minimum_too_large' => 'Ukládání negativních odpovědí do vyrovnávací paměti po dobu delší než tři hodiny se nedoporučuje.',
    'dns__select_masters_to_remove' => "Vyberte primární servery DNS, které se mají odebrat.",
    'dns__select_template_record_to_remove' => 'Vybrat záznamy šablon DNS, které se mají odebrat.',
    'dns__nameservers_for_domain' => "Názvové servery pro doménu",
    'dns__remove_dns_zone_of_domain__' => "Odebrání záznamů DNS z domény %1",
    'dns__remove_dns_zone_template__' => "Následující záznamy DNS budou odebrány ze šablony:",
    'dns__remove_this_dns_record?' => "Opravdu chcete odebrat následující záznam DNS?",
    'dns__restore_default' => "Obnovení zóny DNS podle šablony",
    'dns__restore_default_confirm' => "Obnovení zóny DNS zruší aktuální konfiguraci zóny DNS. Chcete přesto pokračovat?",
    'dns__restore_default_error' => "Chyba při obnovení zóny DNS:",
    'dns__slave_dns_type' => "je sekundární server DNS",
    'dns__subdomain_dns_rec_removed' => "Záznam A byl odebrán ze zóny subdomény %1.",
    'dns__zone_switched_off_no_ns' => "Zóna byla vypnuta, protože neexistuje záznam NS %1, který musí být v zóně přítomen. Chcete-li vložit záznam do zóny, klikněte na tlačítko Přidat záznam.",
    'dns__cant_switch_on_no_ns' => "Zónu nelze zapnout, protože neexistuje záznam NS %1, který musí být v zóně přítomen. Chcete-li vložit záznam do zóny, klikněte na tlačítko Přidat záznam.",
    'dns__unable_activate/deactivate_dns' => "Nelze aktivovat/deaktivovat DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Nelze přidat primární server DNS: duplicitní záznam.",
    'dns__unable_add_dns_master_local_ip' => "Nelze přidat IP adresu pro primární server DNS: tento záznam musí být vytvořen na vzdáleném serveru.",
    'dns__unable_define_dns_record' => "Nelze definovat záznam DNS: %1",
    'dns__unable_get_dns_template_status' => "Nelze znovu získat stav šablony DNS.",
    'dns__unable_remove_dns_rec' => "Nelze odstranit záznam DNS: %1",
    'dns__warnings__' => "Výsledek úpravy zóny DNS:",
    'dns__you_not_have_perm_manage_dns' => "Nemáte oprávnění ke správě zóny DNS pro tuto doménu.",
    'dns__cant_create_record_with_server_ip' => "Nelze přidat tuto IP adresu, protože se shoduje s IP adresou tohoto serveru řízeného v prostředí Plesk.",

    'dns__tabs_acl' => "Přenosy zóny",
    'dns__acl_add_network_legend' => "Přidat síť",
    'dns__acl_add_ip_legend' => "Přidat IP adresu",
    'dns__acl_network_not_allowed' => "Tato síťová adresa není povolena DNS ve Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP adresa/maska",
    'dns__acl_enter_ip_address' => "IP adresa",
    'dns__acl_list_network_legend' => "Sítě s povolením získat kopii zóny DNS",
    'dns__acl_list_ip_legend' => "IP adresy s povolením získat kopii zóny DNS",
    'bt_dns_acl_add_network' => "Přidat síť",
    'bt_dns_acl_add_ip' => "Přidat IP adresu",

    'dns_add__add_rec_for_zone' => "Přidat %1 pro zónu %2",
    'dns_add__canonical_dom_name_is_invalid' => "Kanonický název domény je neplatný.",
    'dns_add__enter_canonical_name' => "Kanonický název",
    'dns_add__enter_dom_name' => "Název domény",
    'dns_add__enter_ip_address' => "IP adresa",
    'dns_add__enter_ip_mask' => "IP adresa a maska sítě",
    'dns_add__enter_mail_domain' => "Poštovní doména",
    'dns_add__enter_mail_exchanger' => "Server Mail exchange",
    'dns_add__enter_nameserver' => "Názvový server",
    'dns_add__enter_txt_record' => "Záznam TXT",
    'dns_add__enter_service_name' => "Název služby",
    'dns_add__hint_service_name' => "Příklad: SIP (bez podtržítka)",
    'dns_add__enter_protocol' => "Protokol",
    'dns_add__hint_protocol_name' => "Příklad: TCP (bez podtržítka)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Priorita",
    'dns_add__specify_weight_of_service' => "Relativní hmotnost pro záznamy se stejnou prioritou",
    'dns_add__enter_target_host' => "Cílový hostitel",
    'dns_add__hint_target_host' => "Příklad: priklad.cz",
    'dns_add__enter_target_port' => "Cílový port",
    'dns_add__caa_tag' => "Značka",
    'dns_add__caa_value' => "Hodnota",
    'dns_add-invalid-A_ip' => "IP adresa je platná.",
    'dns_add-invalid-AAAA_ip' => "IP adresa je platná.",
    'dns_add-invalid-PTR_ip_mask' => "Neplatný pár IP adresa/maska sítě.",
    'dns_add-invalid-SRV_service_name' => "Neplatný název služby",
    'dns_add-invalid-SRV_protocol_name' => "Neplatný protokol",
    'dns_add-invalid-SRV_target_port' => "Neplatný cílový port",

    'dns_add__invalid_ip' => "IP adresa je platná.",
    'dns_add__low' => "nízká",
    'dns_add__mail_dom_name_is_invalid' => "Název poštovní domény je neplatný.",
    'dns_add__nameserver_is_invalid' => "Názvový server je neplatný.",
    'dns_add__record' => "%1 záznam",
    'dns_add__select_prefer_for_mail_exchange_server' => "Specifikujte prioritu MX serveru",
    'dns_add__unable_insert_new_dns_rec' => "Nelze vložit nový záznam DNS: %1",
    'dns_add__very_high' => "velmi vysoká",
    'dom_ctrl__allowed' => "Povoleno",
    'dom_ctrl__db' => "Databáze MySQL",
    'dom_ctrl__mssql_db' => "Databáze MS SQL",
    'dom_ctrl__disk_space' => "Místo na disku",
    'dom_ctrl__dom_adm' => "Doména %1 z %2",
    'dom_ctrl__dom_cl' => "Doména %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Doména má nastaveno přesměrování s nedefinovanou adresou URL pro přesměrování",
    'dom_ctrl__domain_has_frame_forwarding' => "Doména má nastaveno rámcové přesměrování na adresu URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Doména nemá nakonfigurovaný žádný hosting",
    'dom_ctrl__domain_has_physical_hosting' => "Webhosting je pro tuto doménu nakonfigurován na IP adrese %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Doména má nastaveno standardní přesměrování na adresu URL %1",
    'dom_ctrl__maillists' => "Seznamy adresátů",
    'dom_ctrl__mboxes' => "Poštovní schránky",
    'dom_ctrl__mg' => "Předávání e-mailů",
    'dom_ctrl__resource_name' => "Prostředek",
    'dom_ctrl__resp' => "Automatické odpovědi",
    'dom_ctrl__subdom' => "Subdomény",
    'dom_ctrl__dom_aliases' => "Doménové aliasy",
    'dom_ctrl__traffic' => "Provoz",
    'dom_ctrl__unable_activate/deactivate_dom' => "Nelze aktivovat/deaktivovat doménu: %1",
    'dom_ctrl__used' => "Využito",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Uživatelé webu",
    'dom_pref__bounce_with_phrase' => "Vrátit odesílateli se zprávou",
    'dom_pref__bounce' => "Vrátit",
    'dom_pref__catch_addr' => "Předat na adresu",
    'dom_pref__reject' => 'Zamítnout',
    'dom_pref__confirm_domain_removing' => "Nezapomeňte informovat návštěvníky domény o změně názvu domény. Opravdu chcete doménu přejmenovat?",
    'dom_pref__db_inconsystency' => "nekonzistence databáze.",
    'dom_pref__dbs' => "databáze",
    'dom_pref__delete_traffic_stat' => "Uchovat statistiky webu a přenosu",
    'dom_pref__delete_traffic_stat_older' => "Uchovat statistiky webu a přenosu",
    'dom_pref__dom_level_name_conflict' => "Přihlašovací jméno správce domény je v konfliktu s přihlašovacím jménem jednoho ze zákazníků.",
    'dom_pref__invalid_disk_space_limit' => "Neplatný limit prostoru na disku. Maximální hodnota: %1",
    'dom_pref__invalid_expiration_date_limit' => "Neplatná doba platnosti.",
    'dom_pref__invalid_max_traffic_limit' => "Neplatný limit přenosu dat. Maximální hodnota: %1",
    'dom_pref__limits_of_dom' => "Limity pro doménu %1",
    'dom_pref__mail_grps' => "e-mailové skupiny",
    'dom_pref__mail_nonexistent_user' => "Co dělat se zprávami odeslanými neexistujícím uživatelům",
    'dom_pref__mail_redirs' => "servery pro předávání pošty",
    'dom_pref__mail_resps' => "automatické odpovědi pošty",
    'dom_pref__max_limit_is_invalid' => "%1 je neplatný.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maximální počet %1 je neplatný.",
    'dom_pref__new_limit_less_currently_used' => "%1: požadovaný - %2, aktuálně používaný - %3",
    'dom_pref__older_that' => "pro",
    'dom_pref__postboxes' => "poštovní schránky",
    'dom_pref__preferences_of_dom' => "Nastavení pro doménu %1",
    'dom_pref__redirect_to_itself' => "Doména bude mít nastaveno přesměrování sama na sebe",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Specifikovali jste dobu uchování statistik přenesených dat domény kratší než celkovou hodnotu definovanou pro server (%1 měsíc(ů)). Doba uchování statistik je nastavena stejná jako výchozí hodnota pro server (%1 měsíc(ů)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "K doméně nelze přidat předponu www : %1",
    'dom_pref__unable_define_physical_hst_param' => "Nelze definovat parametry fyzického hostingu: %1",
    'dom_pref__unable_rename_domain' => "Nelze přejmenovat doménu %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Pro tuto doménu nelze nastavit kvótu poštovní schránky: %1",
    'dom_pref__unable_set_up_web_user_script' => "Nelze nastavit skriptování pro uživatele webu: %1",
    'dom_pref__unlimited' => "Neomezeno",
    'dom_pref__web_usrs' => "uživatelé webu",
    'dom_pref__you_already_have_%object' => "Již máte %1",
    'cu_domain__error_unable_update_ftp_users' => 'Nelze aktualizovat uživatele FTP domény: %1',
    'dom_cli__warning_ignore_quota' => 'VAROVÁNÍ: Možnost "-hard_quota" je ignorována: kvóta pevného disku není podporována',
    'dom_user_client_login_exist' => "Správci domény nelze povolit přístup k prostředí Plesk na doméně %1: toto přihlašovací jméno se již používá.",
    'domain__unable_to_turn_on_service' => "Zapnutí služby %1 se nezdařilo.",
    'domains__change_the_status_of_domain?' => "Opravdu chcete změnit stav domény %1?",
    'domains__client_info_hiding_traffic' => "%1 domén, %2 aktivních domén, %3 využitého místa na disku",
    'domains__unable_to_change_client_status' => "Nelze změnit stav účtu zákazníka: %1",
    'domains__unable_update_apache_settings' => "Nelze aktualizovat nastavení Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Nemáte oprávnění k odstranění domén.",
    'domains__you_want_change_the_status_of_the_cl??' => "Opravdu chcete změnit stav účtu zákazníka?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Opravdu chcete uskutečnit tuto operaci?",
    'domains_list__unable_remove_doms' => "Nelze odstranit domény: %1",
    'domaintrafficlist_header_of_domain__' => "Přenos dat na doméně %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Vyberte doménové aliasy, které budou odstraněny.',
    'domain_aliases_remove__title' => 'Odebírání doménových aliasů',
    'domain_aliases__max_aliases_reached_for_dom' => "U této domény bylo dosaženo limitu v počtu aliasů.",
    'domain_edit__edit_title' => 'Upravit název doménového aliasu',
    'domain_alias_edit__type' => 'Typ aliasu domény',
    'domain_aliases__list_header' => 'Doménové aliasy',
    'domain_aliases__name' => 'Jméno',
    'domain_aliases__type' => 'Typ',
    'domain_aliases__type_full' => 'Web+FTP+Mail',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Doménové aliasy',
    'domain_aliases__legend' => 'Doménové aliasy',
    'domain_alias__domain_exists' => 'Doména s tímto názvem již existuje',
    'domain_alias__subdomain_exists' => 'Subdoména s tímto názvem již existuje.',
    'domain_alias__dns_record_exists' => 'Záznam DNS se zadaným názvem aliasu domény již existuje',
    'domain_alias__domain_alias_exists' => "Alias domény s tímto názvem již existuje",
    'domain_alias__invalid_type_full' => 'E-mailový server nepodporuje doménové aliasy',
    'domain_alias__redirect_exists' => 'Bylo zjištěno přesměrování samo do sebe.',

    'ds__anonymous_ftp' => "Anonymní FTP",
    'drweb__pagetitle' => 'Nastavení antivirové ochrany',
    'drweb__drweb' => 'Kontrola pošty antivirem',
    'drweb__drweb_direction' => 'Testování pošty na přítomnost virů',
    'drweb__drweb_direction_off' => 'Neprovádět kontrolu na přítomnost virů',
    'drweb__drweb_direction_any' => 'Příchozí a odchozí pošta',
    'drweb__drweb_direction_from' => 'Pouze odchozí pošta',
    'drweb__drweb_direction_to' => 'Pouze příchozí pošta',
    'drweb__disable_reason_key' => 'Antivirová ochrana není podporována licenčním klíčem.',
    'drweb__disable_reason_perm' => 'Nemáte oprávnění spravovat antivirus.',
    'drweb__disable_reason_install' => 'Antivirus není nainstalován.',
    'drweb__filters' => 'Filtry antiviru',
    'ds__dns' => "Zóna DNS",
    'ds__mail' => "Pošta",
    'dsr__of_client_title' => "Souhrnná sestava o doméně %1",
    'dsr__report_has_been_sent_email' => "Sestava byla odeslána na e-mail: %1",
    'dsr__title' => "Souhrnná sestava o doméně",
    'dumps_list__deletion_page_title' => "Následující záložní soubory domény %1 budou odstraněny:",
    'dumps_list__dumpfile_is_invalid' => "Soubor %1 není platný soubor zálohy domény.",
    'dumps_list__page_title' => "Úložiště souborů zálohy",
    'dumps_upload__page_title' => "Nahrávání souborů zálohy na úložiště",
    'dumps_list__repository_is_not_exist' => "Úložiště souborů zálohy neexistuje.",
    'dumps_list__unable_to_remove' => "Nelze odstranit soubor zálohy: %1",
    'dumps_list__dumpfile_can_conflict' => "Název souboru, který jste specifikovali, je v rozporu se souborem %1. Specifikujte jiný název souboru.",
    'dusr_ed__allow_dl_usr_access' => "Povolit přístup správce domény",
    'dusr_ed__information' => "Vlastnosti správce domény %1",
    'dusr_ed__locale' => "Jazyk správce domény",
    'dusr_ed__skin' => "Vzhled rozhraní správce domény",
    'dusr_ed__personal_information' => 'Osobní informace',
    'ess__error' => "Chyba",
    'example__' => "Příklad: %1",
    'extras__allow_certificate_purchasing' => "Povolit nákup certifikátu",
    'extras__allow_domain_registration' => "Povolit registraci domény",
    'extras__allow_extras' => "Povolit další služby",
    'extras__buy_new_key' => "Vaše aktuální licence neumožňuje upravit tyto objekty.",
    'extras__setup_services' => "Nastavit další služby",

    'ruleeditform__error' => 'Pravidlo brány firewall nelze aktualizovat.',
    'ruleeditform__name_is_required' => 'Zadat název pravidla.',
    'ruleeditform__profiles_is_required' => 'Vybrat alespoň jeden profil.',
    'ruleeditform__invalid_ip' => 'Zadaná IP adresa nebo síť je neplatná.',
    'ruleeditform__invalid_port' => 'Zadaný port je neplatný. Možné hodnoty jsou 1000 nebo 1000-1051',

    'filemanager__items' => 'položky v adresáři %1',
    'filemanager__items_paging' => 'položky v adresáři %1',

    'get_password__encrypted_password' => "Nelze odeslat informaci o hesle: heslo se ukládá v zašifrované podobě.",
    'get_password__mail_error' => "Při pokusu o odeslání hesla na email %1 došlo k chybě: %2",
    'get_password__mail_ok' => "Heslo bylo úspěšně odesláno na e-mail: %1.",
    'get_password__message' => "Vaše přihlašovací jméno k přístupu do systému: %1 Vaše heslo je %2",
    'get_password__subject' => "Heslo k přístupu do systému",
    'groups__available' => "Dostupné e-mailové skupiny",
    'groups__groups_for_mailname' => "E-mailové skupiny, do nichž je předplacen e-mailový účet %1",
    'groups__member_of' => "Člen následující e-mailové skupiny",
    'help__help_area' => "Oblast nápovědy.",
    'hst_def__auth_disabled' => "zakázáno",
    'hst_def__auth_enabled' => "povoleno",
    'hst_def__change_curr_dns_ip' => "Aktuální IP adresa ze záznamu A DNS se změní",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Žádná IP adresa ze záznamů A DNS se neshoduje s IP adresou přidělenou vytvořenému hostingovému účtu",
    'hst_def__dest_url' => "Cílová adresa URL",
    'hst_def__disk_quota' => "Disková kvóta",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Limit prostoru na disku, který se pokoušíte nastavit, překračuje limit prostoru na disku v příchozím adresáři anonymního FTP.  Limit prostoru na disku v příchozím adresáři anonymního FTP nesmí překročit limit prostoru na disku v doméně.",
    'hst_def__frame_forwarding_definition' => "Přidělení rámcového přesměrování pro doménu %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Upozornění: uživatel FTP %1 se používá v nastavení účtu hostitele, ale neexistuje v systému.",
    'hst_def__hst_type_is_not_defined' => "Typ hostingu není definován",
    'hst_def__ip_based' => "Založen na IP adrese",
    'hst_def__name_based_power_anonymous_ftp_down' => "Při předání tohoto účtu hostitele na sdílenou IP adresu bude služba anonymního FTP na této doméně nedostupná. Chcete přesto pokračovat?",
    'hst_def__password_is_invalid_password_syntax' => "Heslo je neplatné.\nV hesle nepoužívejte jednoduché uvozovky a znaky národní abecedy.\nDélka hesla by měla být od 5 do 14 znaků. Heslo nesmí obsahovat uživatelské jméno.",
    'hst_def__shell' => "Přístup do prostředí serveru prostřednictvím SSH pod systémovým uživatelem předplatného",
    'hst_def__shell_windows' => "Přístup na server prostřednictvím vzdálené plochy pod systémovým uživatelem předplatného",
    'hst_def__standard_forwarding_definition' => "Přidělení standardního přesměrování pro doménu %1",
    'hst_def__title_name_based' => "Založený na názvu",
    'hst_def__unable_create/update_physic_hst' => "Nelze vytvořit/aktualizovat fyzický hosting: %1",
    'hst_def__unable_create/update_std_fwd' => "Nelze vytvořit/aktualizovat standardní přesměrování: %1",
    'hst_def__unable_create_forwarding_myself' => "Pro doménu nelze vytvořit přesměrování na sebe.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Nelze povolit použití jediného adresáře k ukládání obsahu SSL/TLS a bez SSL/TLS: podpora SSL/TLS není zapnuta.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Nelze zapnout podporu SSL/TLS: nebyl nainstalován žádný certifikát SSL/TLS.",
    'hst_def__url_is_invalid' => "Adresa URL není platná.",
    'hst_def__virtual_host_access' => "Přístup k virtuálnímu hostiteli pro doménu %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "VAROVÁNÍ. Tento virtuální hostitel používá k hostování neexistující IP adresu.",
    'hst_def__you_have_no_ips' => "Žádné IP adresy nejsou k dispozici a vy nemáte povoleno vytvořit hosting založený na názvu.",
    'hst_sel__header' => "Chcete-li hostit web na tomto serveru, vyberte možnost Fyzický hosting. Chcete-li nastavit předávání domény na web na jiném počítači, vyberte možnost Rámcové přesměrování nebo Standardní přesměrování. Při standardním přesměrování je uživatel přesměrován na web a v prohlížeči uživatele se zobrazí skutečná adresa URL webu, takže uživatel je o přesměrování informován. Při rámcovém přesměrování je uživatel přesměrován na web, aniž by věděl, že se web ve skutečnosti nachází na jiném umístění.",
    'hst_sel__physical_hst' => "Fyzický hosting",
    'hst_sel__select_hst_type' => "Vyberte typ hostingu pro doménu",
    'hst_sel__select_hst_type_warning' => "Vyberte typ hostingu pro doménu",
    'hst_sel__hosting_exists' => "Hosting nelze vytvořit, neboť je již pro tuto doménu nakonfigurován. Budete přesměrováni na stránku správy hostingu.",
    'hst_sel__standard_frw' => "Standardní přesměrování",
    'hst_sel__frame_frw' => "Rámcové přesměrování",
    '__frame_frw' => "Rámcové přesměrování",
    '__hosting_exists' => "Hosting nelze vytvořit, neboť je již pro tuto doménu nakonfigurován. Budete přesměrováni na stránku správy hostingu.",
    '__choose_hst_type' => "Vybrat požadovaný typ hostingu.",
    '__no_hst_conf' => "Pro vaši doménu není nakonfigurován žádný hosting.",
    '__physical_hst' => "Fyzický hosting",
    '__select_hst_type' => "Vyberte typ hostingu pro doménu",
    '__standard_frw' => "Standardní přesměrování",
    '__warning' => "Varování! Veškeré dříve nastavené parametry budou zrušeny. Opravdu chcete změnit typ hostingu?",
    'i_cl_off' => "Zákazník je neaktivní.",
    'i_cl_off_by_admin' => "Účet zákazníka je pozastaven správcem serveru.",
    'i_cl_off_expired' => "Platnost účtu zákazníka vypršela.",
    'i_cl_on' => "Zákazník je aktivní.",

    'icf__title' => 'Brána firewall pro připojení k internetu',
    'icf__if_legend' => 'Rozhraní',
    'icf__mode' => 'Režim',

    'invalid_value' => 'Hodnota je neplatná',

    'ip_addr__already_exists' => "IP adresa %1 již existuje.",
    'ip_addr__cant_add' => "IP adresa %1 neexistuje nebo patří do fondu IP adres jiného zákazníka",
    'ip_alias__interface' => "Rozhraní",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "IP adresa %1 pro virtuální hosting založený na názvu je neplatná.",
    'ip_alias__invalid_ip_or_netmask' => "Neplatný pár IP adresa/maska sítě.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP adresa %1 je originální adresa IP, takže ji nelze odebrat.",
    'ip_alias__ip_is_invalid' => "IP adresa %1 je neplatná.",
    'ip_alias__ip_mask_is_invalid' => "IP maska %1 je neplatná.",
    'ip_alias__ip_not_exist' => "IP adresa %1 neexistuje.",
    'ip_alias__ip_address_and_mask' => 'IP adresa a maska podsítě',
    'ip_alias__mask' => "Maska podsítě",
    'ip_alias__remove_selected_ip_aliases?' => "Opravdu chcete odebrat vybrané IP adresy?",
    'ip_alias__select_ip' => "Vyberte ze seznamu minimálně jednu IP adresu, která se má odebrat.",
    'ip_alias__this_ip_used_for_domain' => "(%1) tato IP adresa je použita pro doménu %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) tato IP adresa je použita pro virtuální hostitele založené na názvu.",
    'ip_alias__unable_add_ip' => "Nelze přidat IP: %1",
    'ip_alias__unable_remove_ip' => "Nelze odebrat IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Nelze změnit typ IP adresy na sdílenou, protože anonymní FTP by se stalo pro doménu '%1' nedostupné.",
    'ip_ctrl__ip_addr' => "IP adresa %2 na rozhraní %1",
    'ip_ctrl__ip_exists_many_pools' => "Nelze změnit typ IP. Tato IP adresa patří do fondu několika uživatelů najednou.",
    'ip_ctrl__ssl_cert' => "Certifikát SSL/TLS",
    'limit__date_in_past' => "Doba platnosti je neplatná. %1 je v minulosti.",
    'limit__enter_date' => "Zadat datum",
    'limit__max_db' => "Databáze",
    'limit__name_disk_space' => "místo na disku",
    'limit__name_max_box' => "poštovní schránky",
    'limit__name_max_db' => "Databáze MySQL",
    'limit__name_max_dom' => "domény",
    'limit__name_max_maillists' => "seznamy adresátů",
    'limit__name_max_subdom' => "subdomény",
    'limit__name_max_traffic' => "přenos dat",
    'limit__name_max_wu' => "uživatelé webu",
    'limit__name_mbox_quota' => "kvóta poštovní schránky",
    'limit__name_max_mn' => "Poštovní účty",
    'limit__name_max_cl' => 'klienti',
    'limit__name_total_mboxes_quota' => "celková kvóta poštovních schránek",
    'limit__name_mysql_dbase_space' => "Velikost databáze MySQL",
    'limit__name_mssql_dbase_space' => "Velikost databáze MSSQL",
    'limit__name_pgsql_dbase_space' => "Velikost databáze PostgreSQL",
    'limit__name_expiration' => 'datum vypršení platnosti',

    'locale_upload__unable_to_install' => 'Nelze nainstalovat soubor jazykové sady',
    'locale_upload__wrong_package' => 'Soubor, který jste nahráli, neobsahuje jazykovou sadu platnou pro tuto verzi prostředí Plesk.',
    'locale_upload__wrong_locale' => 'Soubor, který jste nahráli, neobsahuje platnou jazykovou sadu.',

    'ma__create_title' => 'Vytvoření poštovního aliasu pro %1',
    'ma__edit_title' => "Upravit poštovní alias %1",
    'ma__enter_new_alias' => "Zadejte nový alias.",
    'ma__invalid_alias' => "Neplatný poštovní alias.",
    'ma__mail_aliases_mailname' => "E-mailové aliasy pro e-mailový účet %1",
    'ma__mailname_does_not_exist' => "E-mailový účet neexistuje.",
    'ma__select_ma_for_remove' => "Vyberte poštovní aliasy, které budou odebrány.",
    'ma__unable_to_add_new_ma' => "Nelze přidat e-mailový alias: %1",

    'mail_queue__not_allowed_by_license_key' => 'Správa poštovní fronty není povolena licenčním klíčem.',
    'maillist__' => "Seznam adresátů %1",
    'maillist__already_exists' => "Seznam adresátů již existuje.",
    'maillist__mail_alias_already_exists_in_this_domain' => "E-mailový alias %1 již na této doméně existuje",
    'maillists__' => "Seznamy adresátů %1",
    'maillists__limit_cl_max_maillists' => "U zákazníka bylo dosaženo limitu v počtu seznamů adresátů (limit: %1, použito: %2)",
    'maillists__limit_dom_max_maillists' => "U této domény bylo dosaženo limitu v počtu seznamů adresátů.",
    'maillists__list' => "Seznamy adresátů",
    'maillists__mailman_not_installed_or_conf' => "\nRozšíření Mailman Server nejsou aktuálně nainstalována či nakonfigurována\nna serveru. Kontaktujte správce serveru, aby nainstaloval rozšíření Mailman Server či jej správně nakonfiguroval.",
    'maillists__status' => "Služba pro seznam adresátů je zapnuta",
    'maillists__unable_to_delete__' => "Nelze odstranit seznam adresátů: %1",
    'maillists__disabled_text' => 'Nelze spravovat seznamy adresátů, protože součást serveru seznamu adresátů aplikace Mailman není nainstalována nebo nakonfigurována.',
    'maillist_member__already_exists' => 'Odběratel seznamu adresátů již existuje.',
    'maillist_member__not_exists' => 'V seznamu adresátů není žádný takový uživatel.',
    'mailserver_switching_warning' => "Varování! Změna e-mailového serveru je určena pouze pro výchozí nastavení a pokud se server již používá, způsobí následující problémy: ztrátu nastavení a obsahu poštovních schránek a (v případech, kdy je server, na který se přepnete, již nakonfigurován), nejrůznější konflikty. Pokud se tento server nyní používá a jste si jisti přepnutím na server jiný, můžete své zákazníky na operaci upozornit, aby si mohli svou poštu stáhnout a uložit.",
    'manager__access_denied' => "Přístup odepřen: %1",
    'manager__admin' => "Správce",
    'manager__client' => 'Zákazník',
    'manager__domain' => "Doména",
    'manager__domain_cl_limit_exceeding' => "Pro tento účet zákazníka byl dosažen limit počtu domén.",
    'manager__domain_is_not_yours' => "Doména %1 vám nepatří.",
    'manager__domain_key_limit_exceeding' => "Dosáhli jste limitu v počtu vytvořených domén definovaných vaším licenčním klíčem.",
    'manager__no_perm_to_call' => "Nemáte oprávnění volat %1.",
    'manager__no_perm_to_create_domains' => "Nemáte oprávnění vytvářet domény.",
    'manager__no_perm_to_modify_domain' => "Nemáte oprávnění k úpravě domény %1.",
    'manager__no_perm_to_modify_domains' => "Nemáte oprávnění k úpravě domén.",
    'manager__no_perm_to_remove_domain' => "Nemáte oprávnění k odebrání domény %1.",
    'manager__no_perm_to_remove_domains' => "Nemáte oprávnění k odebrání domén.",
    'manager__node_doesnt_exist' => "%1 neexistuje.",
    'manager__user_disabled' => "Váš účet je pozastaven. Nemůžete obsluhovat systém.",
    'mail_quota_unsupported' => "nepodporováno e-mailovým serverem",
    'mbox_quota_unsupported' => "nepodporováno e-mailovým serverem",
    'mn__create_title' => "Vytvořit e-mailový účet",
    'mn__edit_title' => "Nastavení",
    'mn__files_list_title' => "Soubory přílohy",
    'mn__files_remove' => "Odebrat soubory z úložiště příloh. Tyto soubory možná používaly automatické odpovědi. Budou odebrány z úložiště i z automatických odpovědí, které je používají.",
    'mn__files_select_for_remove' => "Vyberte soubory, které budou odebrány.",
    'mn__mail_alias_form' => "Forma e-mailového aliasu",
    'mn__mail_aliases_list' => "E-mailové aliasy",
    'mn__mailbox' => "Správa poštovní schránky",
    'mn__unable_define_mn' => "Nelze nastavit e-mailové účty: %1",
    'mn__unable_remove_mbox_quota' => "Nelze odebrat kvótu poštovní schránky: %1",
    'mn__upload_file' => "Nahrát soubor",
    'mn_edit__attach_filename_changed' => 'Nahraný soubor %1 byl přejmenován na %2, protože jeho název obsahuje jiné znaky než znaky ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Měli byste přidat člena e-mailové skupiny dříve než skupinu zapnete.",
    'mn_edit__add_resp_or_turn_off_box' => "Měli byste přidat automatickou odpověď nebo vymazat zaškrtávací políčko pro automatickou odpověď.",
    'mn_edit__attachments' => "Přílohy",
    'mn_edit__dom_quota_less_then_quota' => "Velikost této poštovní schránky nesmí překročit limit místa na disku přiděleného pro poštovní schránky v této doméně.",
    'mn_edit__enter_external_rcpnt_email' => "Zadat e-mail člena externí e-mailové skupiny",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Zadejte adresu pro předávání pošty nebo zaškrtávací políčko vymažte.",
    'mn_edit__ext_rcpnt_email_invalid' => "Externí e-mailová adresa příjemce je neplatná.",
    'mn_edit__file_exists' => "Soubor existuje. Přepsat?",
    'mn_edit__files_deld_from_repository' => "Tyto soubory budou odebrány z úložiště i z automatických odpovědí, které je obsahují. Chcete pokračovat?",
    'mn_edit__mail_name' => "Poštovní účet",
    'mn_edit__mail_name_invalid' => "Název e-mailového účtu je neplatný.",
    'mn_edit__mail_redir' => "Servery pro předávání pošty",
    'mn_edit__mail_redir_add' => "Přidat člena e-mailové skupiny",
    'mn_edit__mail_resps' => "Automatické odpovědi pošty",
    'mn_edit__mailbox' => "Poštovní schránka",
    'mn_edit__enable_mailbox' => "Poštovní schránka",
    'mn_edit__mailgroup' => "E-mailová skupina",
    'mn_edit__mailgroup_addresses' => "Členové e-mailové skupiny",
    'mn_edit__mailgroup_disabled' => "Dostupné pouze když je již přidán e-mailový účet.",
    'mn_edit__max_dom_quota' => "Výchozí pro doménu (%1)",
    'mn_edit__mbox_quota_invalid' => "Nesprávná velikost poštovní schránky.",
    'mn_edit__new_resp_name' => "Nový název automatické odpovědi",
    'mn_edit__no_autoresponders' => "Před zapnutím/vypnutím automatické odpovědi byste měli přidat nejméně jednu automatickou odpověď.",
    'mn_edit__no_file_sel' => "Nejsou vybrány žádné soubory.",
    'mn_edit__no_mail_addresses' => "Žádné e-mailové adresy nebyly zadány ani vybrány.",
    'mn_edit__none' => "Žádné",
    'mn_edit__not_create_pass' => "Tímto způsobem se nevytvoří heslo pro tento účet. Bez hesla uživatel nemůže prohlížet a odesílat e-mail.",
    'mn_edit__redir_email_invalid' => "Adresa pro předávání je neplatná.",
    'mn_edit__redirect_addr' => "Adresa pro předávání",
    'mn_edit__remove_autoresp?' => "Opravdu chcete odebrat funkci automatická odpověď?",
    'mn_edit__remove_rcpnts?' => "Opravdu chcete odebrat tyto adresáty?",
    'mn_edit__repository' => "Úložiště",
    'mn_edit__resps_attach' => "Soubory přílohy automatické odpovědi",
    'mn_edit__select_rcpnt_from_list' => "Ze seznamu vyberte minimálně jednoho adresáta, který bude odebrán.",
    'mn_edit__select_registered_users' => "Vybrat registrované uživatele",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Vybrali jste poštovní schránku, ale nenastavili jste pro ni heslo.",
    'mn_edit__unable_act_deact_mail_group' => "Nelze aktivovat či deaktivovat e-mailovou skupinu: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Nelze aktivovat či deaktivovat předávání pošty: %1",
    'mn_edit__unable_act_deact_postbox' => "Nelze aktivovat či deaktivovat poštovní schránku: %1",
    'mn_edit__unable_act_deact_resp' => "Nelze aktivovat či deaktivovat automatické odpovědi: %1",
    'mn_edit__unable_add_attach' => "Nelze přidat soubor přílohy: %1",
    'mn_edit__unable_add_mail_group_member' => "Nelze přidat člena e-mailové skupiny: %1",
    'mn_edit__unable_add_resp' => "Nelze přidat automatickou odpověď: %1",
    'mn_edit__unable_change_mail_name' => "Nelze změnit název e-mailového účtu: %1",
    'mn_edit__unable_deactivate_mail_group' => "Nelze deaktivovat poštovní e-mailovou skupinu: %1",
    'mn_edit__unable_deactivate_resp' => "Nelze deaktivovat automatické odpovědi e-mailu: %1",
    'mn_edit__unable_define_resp_id' => "Nelze definovat ID automatické odpovědi ID: %1",
    'mn_edit__unable_remove_attach' => "Nelze odebrat soubor(y) příloh: %1",
    'mn_edit__unable_remove_autoresp' => "Nelze odebrat automatickou odpověď: %1",
    'mn_edit__unable_remove_mail_group_member' => "Nelze odstranit členy e-mailové skupiny: %1",
    'mn_edit__wrong_way' => 'Zprávy adresované na %1 nebudou doručeny, protože tento e-mailový účet nemá poštovní schránku nebo zapnuto předávání pošty.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Poštovní schránka na adrese %1 byla vypnuta. Zprávy v poštovní schránce nebyly odstraněny, ale nelze je obnovit prostřednictvím protokolů IMAP nebo POP3.',
    'mn_list__mail_names_for_domain' => "E-mailové účty pod doménou %1",
    'mn_list__sa_cannot_unable' => "Nelze zapnout filtrování nevyžádané pošty",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Zákazník',
    'mn_list__tab_title_domain' => 'Doména',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Jméno",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Nelze odebrat e-mailové účty: %1",
    'module_upload__module_was_installed' => 'Tento modul je již nainstalován. Chcete-li nainstalovat novou verzi tohoto modulu, odinstalujte modul prostřednictvím prostředí Plesk a poté ho znovu nainstalujte.',
    'module_upload__unable_to_install' => 'Nelze nainstalovat soubor balíčku modulu',
    'module_upload__wrong_package' => 'Nahraný soubor není podporovaný balíček modulu.',
    'module_upload__wrong_module' => 'Nahraný soubor neobsahuje balíček modulu.',

    'news_articles_title' => 'Novinky prostředí Plesk',
    'notification_text__invalid_subject_length' => "Neplatná délka předmětu oznámení. Měla by být od 1 do 255 znaků.",
    'notification_text__invalid_text_length' => "Neplatná délka textu oznámení. Měla by být od 1 do 65533 znaků.",
    'notification_text__subject' => "Předmět oznámení",
    'notification_text__text' => "Text oznámení",
    'notification_text__title' => "Upravit oznámení",
    'notification_text__unable_set_text' => "Nelze upravit text oznámení:",

    'odbc__cant_add_dsn' => "Nelze přidat DSN %1: %2",
    'odbc__cant_connect' => "Nelze se připojit ke zdroji dat prostřednictvím zadaných nastavení. Server vrátil: %1",
    'odbc__cant_delete_dsn' => "Nelze odstranit DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Nelze získat informace o ovladačích.",
    'odbc__cant_get_drivers' => "Nelze obnovit seznam ovladačů ODBC: %1",
    'odbc__cant_open_info_file' => "Nelze otevřít soubor s informacemi o ovladačích ODBC.",
    'odbc__cant_parse_string' => "Nelze rozložit připojovací řetězec.",
    'odbc__driver_not_set' => "Ovladač není nastaven",
    'odbc__driver_or_name_not_set' => "Ovladač nebo název připojení ODBC nebyl nastaven",
    'odbc__dsn_already_exists' => "DSN s tímto názvem (%1) již v systému existuje",
    'odbc__dsn_not_exists' => "Tento DSN neexistuje",
    'odbc__enter_dsn_name' => "Zadat název DSN",
    'odbc__invalid_dsn_name' => "Chybná syntaxe pro název připojení ODBC (%1): používejte pouze alfanumerické symboly.",
    'odbc__no_such_driver' => "Ovladač ODBC s tímto názvem (%1) názvem není podporován.",
    'odbc__unknown_driver' => "Neznámý název ovladače (%1).",
    'odbc_dsn_system' => "Systém DSN",

    'pb__aliases' => "Aliasy",
    'pb__anonftp' => "Anonymní FTP",
    'pb__autoinstaller_releases' => 'Nástroj pro aktualizaci',
    'pb__cert' => "Certifikáty",
    'pb__cl_pool' => "IP adresy",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Nastavení",
    'pb__cl_rpt' => "Sestava",
    'pb__cl_rpt_list' => "Přizpůsobit",
    'pb__cl_templates' => "Šablony zákazníka",
    'pb__cl_traffic' => "Provoz",
    'pb__cl_traffic_history' => "Historie přenosu dat",
    'pb__cl_traffic_of' => "Přenos dat %1",
    'pb__client' => "%1",
    'pb__clients' => "Zákazníci",
    'pb__comp_info' => "Součásti serveru",
    'pb__common_acl' => 'Povolit přenos ACL',
    'pb__cp_access' => "Přístup",
    'pb__crontab' => "Plánovač",
    'pb__scheduler' => "Plánovač",
    'pb__custom_buttons' => "Zákaznická tlačítka",
    'pb__databases_db' => 'Databáze',
    'pb__sqlservers_db' => 'SQL Servery',//to check
    'pb__db' => "Databáze",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Databázové servery',
    'pb__dl_usr_ed' => "Správce domény",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Limity domény",
    'pb__dom_pref' => "Nastavení",
    'pb__dom_sum_report' => "Souhrnná sestava o doméně",
    'pb__dom_templates' => "Šablony domény",
    'pb__dom_traffic' => "Přenos dat %1",
    'pb__domains' => "Domény",
    'pb__domain_aliases' => 'Doménové aliasy',
    'pb__dumps_list' => "Úložiště souborů zálohy",
    'pb__forwarding_setup' => "Nastavení přesměrování",
    'pb__filemanager' => "Správce souboru",
    'pb__ip_aliasing' => "IP adresy",
    'pb__ip_clients' => "Odebrání IP adres",
    'pb__license_management' => 'Informace o licencích',
    'pb__locales' => 'Národní prostředí',
    'pb__log_files' => "Soubory protokolů",
    'pb__mail' => 'Pošta',
    'pb__mail_name_files' => "Soubory přílohy",
    'pb__mail_name_redirects' => "Servery pro předávání pošty",
    'pb__mail_name_resp_attach_add' => "Nová příloha",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Automatické odpovědi pošty",
    'pb__mail_names' => "Pošta",
    'pb__maillists' => "Seznamy adresátů",
    'pb__mimetypes' => 'Typy MIME',
    'pb__modules' => 'Moduly',
    'pb__modules_management' => 'Spravovat moduly',
    'pb__notifications' => "Oznámení",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Nastavení fyzického hostingu",
    'pb__prtd_dirs' => "Chráněné adresáře",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Sestava",
    'pb__report_list' => "Přizpůsobit",
    'pb__server' => "Server",
    'pb__sessions' => "Relace",
    'pb__sapp_pool' => "Fond webových aplikací",
    'pb__siteapp_install' => 'Instalace webové aplikace',
    'pb__site_app_pkgs' => 'Webové aplikace',
    'pb__site_apps' => "Webové aplikace",
    'pb__additional_key_info' => 'Vlastnosti klíče',
    'pb__additional_key_properties' => 'Vlastnosti klíče',
    'pb__skeleton' => 'Šablona virtuálního hostitele',
    'pb__skins' => 'Vzhledy',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filtr nevyžádané pošty",
    'pb__statistics' => "Statistiky",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Subdomény",
    'pb__templates' => "Šablony",
    'pb__virtualdirs' => 'Virtuální adresáře',
    'pb__web_users' => "Uživatelé webu",
    'pdir__enter_dir_name' => "Zadat název adresáře.",
    'pdir__invalid_hst' => "Typ hostingu je neplatný. Hosting musí být fyzický.",
    'pdir__pd_id_is_undefined' => "ID chráněného adresáře není definováno.",
    'pdir__pdir_exist' => "Adresář s tímto názvem je již chráněný.",
    'pdir__pdir_not_exist' => "Chráněný adresář neexistuje.",
    'pdir__pdir_usr_not_exist' => "Uživatel chráněného adresáře neexistuje.",
    'pdir__remove_pdir_usrs' => "Následující uživatelé chráněného adresáře %2 pod webem %1 budou odebráni:",
    'pdir__remove_pdir_usrs_on_subdom' => "Následující uživatelé chráněného adresáře %2 pod subdoménou %1 budou odebráni:",
    'pdir__select_pdir_usrs_for_remove' => "Vyberte uživatele chráněného adresáře, kteří budou odebráni.",
    'pdir__select_pdirs_to_remove' => "Vyberte adresáře, ze kterých bude odebrána ochrana.",
    'pdir__unable_define_pdir_users' => "Nelze definovat uživatele chráněného adresáře.",
    'pdir__unable_define_pdirs_properties' => "Nelze nastavit vlastnosti chráněného adresáře: %1",
    'pdir__unable_select_dom_param' => "Nelze vybrat parametry domény: %1",
    'pdir_ed__create_pdir_for_domain' => "Vytvořit chráněný adresář pod %1",
    'pdir_ed__create_pdir_for_subdomain' => "Vytvořit chráněný adresář pod subdoménou %1",
    'pdir_ed__dir_already_protect' => "Tento adresář je již chráněný.",
    'pdir_ed__head_txt' => "Název chráněné oblasti",
    'pdir_ed__invalid_login' => "Zadali jste nesprávně přihlašovací jméno.",
    'pdir_ed__login_exists' => "Tento uživatel již existuje. Zkuste zadat jiné přihlašovací jméno.",
    'pdir_ed__new_usr' => "Uživatelské jméno",
    'pdir_ed__non_ssl' => "bez SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Název adresáře",
    'pdir_ed__pdir_for_domain' => "Chráněný adresář %1 na doméně %2",
    'pdir_ed__pdir_for_subdomain' => "Chráněný adresář %1 pod subdoménou %2",
    'pdir_ed__pdir_location' => "Umístění adresáře",
    'pdir_ed__pdir_users' => "Uživatelé chráněného adresáře",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Mezi zaškrtávacími políčky SSL/TLS a bez SSL/TLS by mělo být vybráno nejméně jedno zaškrtávací políčko.",
    'pdir_ed__unable_cr_pdir_usr' => "Nelze vytvořit uživatele chráněného adresáře: %1",
    'pdir_ed__unable_create_pdir' => "Nelze vytvořit chráněný adresář: %1",
    'pdir_ed__unable_define_hst_type' => "Nelze definovat typ hostingu.",
    'pdir_ed__unable_update_pdir' => "Nelze uložit nastavení chráněného adresáře: %1",
    'pdir_ed__wrong_symbol_in_header' => "V názvu adresáře nepoužívejte znak %1.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Vytvořit uživatele pro chráněný adresář %1",
    'pdir_usr_ed__not_create_pass' => "Tímto způsobem nebude vytvořeno heslo pro nového uživatele chráněného adresáře.\nBez hesla se uživatel nebude moci přihlásit.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Heslo pro uživatele chráněného adresáře %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Nelze vybrat uživatele chráněného adresáře: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Nelze definovat uživatele chráněného adresáře: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Nelze odebrat uživatele chráněného adresáře: %1",
    'phosting__anonftp_encrypt' => 'Heslo uživatele FTP je zašifrováno a proto ho nelze použít k ochraně adresáře /plesk-stat/webstat/. Znovu zadejte své heslo FTP nebo zrušte výběr možnosti "přístupné přes adresář chráněný heslem \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Název domény %%domain_name%% přeloží na IP adresu %%dns_ip_address%%. Vaše webové stránky jsou přiřazeny IP adrese %%hosting_ip_address%%. Pokud se web neotevře ve webovém prohlížeči, když na něj odkazujete podle jeho názvu domény, přejděte na stránku správy DNS (Domény> Název domény> DNS) a změňte vlastnosti záznamu o prostředku A: přiřaďte IP adresu %%hosting_ip_address%% k názvu domény %%domain_name%%.",
    'phosting__ip_change_warning' => "IP adresa změněna. Odpovídající změny byly provedeny také v zóně DNS domény.",
    'phosting__other_hosting_exists_on_ip' => "Nelze změnit certifikát, protože tato IP adresa se používá v jednom nebo v několika hostingových účtech.",
    'phosting__unable_to_change_certificate' => "Nelze nainstalovat certifikát: %1",
    'phosting__unable_to_change_ip_address' => "Nelze změnit IP adresu: %1",
    'phosting__unable_to_set_cert' => "Nelze zadat TLS certifikát SSL/TLS: %1",
    'phosting__unable_update' => "Nelze aktualizovat nastavení hostování: %1",
    'phosting__unable_manage' => "Nelze spravovat hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Nepodařilo se nakonfigurovat službu fail2ban za účelem sledování protokolů domény. Protokoly bude možné automaticky sledovat poté, co se služba fail2ban restartuje.\n%1",

    'picker_acl_record__tittle' => 'Zvolit záznam ACL',
    'picker_autoresponder__title' => 'Zvolit automatickou odpověď',
    'picker_black_list__domain_name' => 'Vybrat název domény',
    'picker_certificate' => 'Vybrat TLS certifikát SSL/TLS:',

    'picker_dns_zone_template__title' => 'Vybrat záznam o prostředku',
    'picker_domain__title' => 'Vybrat web',
    'picker_domain_alias__title' => 'Vybrat alias domény',
    'picker_resource_record__title' => 'Vybrat záznam o prostředku',
    'picker_disabled_resource_record__title' => 'Vybrat názvový server',
    'picker_ip_address__title' => 'Vybrat IP adresu',
    'picker_ip_address_clients__title' => 'Vybrat zákazníky, kteří používají tuto IP adresu',
    'picker_mail_queue' => 'Vybrat e-mailové zprávy',
    'picker_site_application__title' => 'Vybrat webovou aplikaci',
    'picker_subdomain__title' => 'Vybrat subdoménu',
    'picker_web_user__title' => 'Vybrat uživatele webu',
    'picker_custom_button__title' => 'Vybrat uživatelské tlačítko',
    'picker_license_key__title' => "Výběr licenčního klíče",
    'picker_spamfilter_address__title' => 'Vybrat adresu filtru nevyžádané pošty',
    'picker_white_list__networks' => 'Výběr sítí',

    'plesk_key__action_logs' => "Protokolování akcí prováděných uživateli Plesk",
    'plesk_key__app_vault' => "Aplikační trezor",
    'plesk_key__backup' => "Funkce zálohování a obnovení",
    'plesk_key__client_templs' => "Správa plánů služeb",
    'plesk_key__clients' => "Uživatelské účty (prodejci a zákazníci)",
    'plesk_key__resellers_only' => "Uživatelské účty (prodejci)",
    'plesk_key__customers_only' => "Uživatelské účty (zákazníci)",
    'plesk_key__domains' => "Domény",
    'plesk_key__domain_aliases' => "Doménové aliasy",
    'plesk_key__manage_dashboard' => 'Vlastní nastavení domovské stránky',
    'plesk_key__drweb' => "Správa Antiviru",
    'plesk_key__event_manager' => "Správce událostí",
    'plesk_key__expirations' => "Správa dat vypršení platnosti účtu",
    'plesk_key__group_ops' => "Úprava více objektů najednou",
    'plesk_key__expiration' => "Datum vypršení platnosti klíče",
    'plesk_key__edition_name' => "Edice systému Plesk",
    'plesk_key__key_number' => "Číslo klíče",
    'plesk_key__languages' => "Jazykové sady",
    'plesk_key__mailnames' => "Poštovní účty",
    'plesk_key__migration_manager' => "Správce Migrace a přenos",
    'plesk_key__mssql' => "Podpora Microsoft SQL Server",
    'plesk_key__myplesk_func' => "Odkazy pro nákup certifikátů SSL/TLS a služby registrace domény",
    'plesk_key__myplesk_server_id' => "Identifikátor podřízeného serveru MPC",
    'plesk_key__notifications' => "Správa oznámení",
    'plesk_key__postgresql' => "Podpora databázového serveru PostgreSQL",
    'plesk_key__qmail_queue' => 'Správa e-mailové fronty.',
    'plesk_key__remote_db' => 'Vzdálený databázový hosting',
    'plesk_key__slave_servers' => "Podřízené servery",
    'plesk_key__spamassassin' => "Správa filtru nevyžádané pošty",
    'plesk_key__subdomains' => "Správa subdomén",
    'plesk_key__sys_access' => "Správa přístupu na server",
    'plesk_key__traffic_reports' => "Sestavy využití přenosu dat",
    'plesk_key__tts' => "Technická podpora",
    'plesk_key__virtuozzo' => "Platí pouze pro kontejnery Virtuozzo",
    'plesk_key__webusers' => "Uživatelé webu",
    'plesk_key__license_update_date' => 'Další aktualizace licenčního klíče',
    'plesk_key__autoinstaller_config' => 'Správa nastavení nástroje pro aktualizaci',
    'plesk_key__check_wrong' => "Licenční klíč je neplatný. Abyste mohli používat prostředí Plesk, získejte nový platný licenční klíč a nainstalujte si ho.",
    'plesk_key__upload_check_wrong' => 'Nahraný licenční klíč je neplatný.',
    'plesk_key__revert_check_wrong' => 'Dříve nainstalovaný licenční klíč je neplatný.',
    'plesk_key__update_check_wrong' => 'Aktualizovaný licenční klíč je neplatný.',
    'plesk_key__viruozzo_only_key' => 'Licenční klíč je určen pouze pro použití v prostředí Plesk v kontejnerech Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Tuto licencovanou kopii prostředí Plesk můžete použít pouze na následující IP adresy: %2. Na následující IP adresy se vaše licence nevztahuje: %1', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Počet aktuálně používaných prostředků překračuje limity definované vaším licenčním klíčem.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Počet webů hostovaných na serveru překračuje limity stanovené vaší licencí. Máte hostované %2 weby; vaše licence umožňuje hostování pouze %1 webů.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Počet doménových aliasů na serveru překračuje limity stanovené vaší licencí. Máte %2 doménových aliasů; vaše licence umožňuje hostování pro %1 doménových aliasů.',
    'plesk_key__limits_exceeded_lim_cl' => 'Počet obsluhovaných zákaznických účtů překračuje limity stanovené vaší licencí. Momentálně máte %2 právě obsluhovaných zákaznických účtů; vaše licence umožňuje obsluhu pouze pro %1 zákaznických účtů.',
    'plesk_key__limits_exceeded_lim_mn' => 'Počet obsluhovaných e-mailových účtů překračuje limity stanovené vaší licencí. Momentálně máte %2 právě obsluhovaných e-mailových účtů; vaše licence umožňuje obsluhu pouze pro %1 e-mailových účtů.',
    'plesk_key__limits_exceeded_lim_wu' => 'Počet obsluhovaných účtů webových uživatelů překračuje limity definované vaší licencí. Máte %2 aktuálně obsluhovaných účtů webových uživatelů; vaše licence umožňuje obsluhovat pouze %1 účtů webových uživatelů.',
    'plesk_key__limits_exceeded_MLS' => 'Počet momentálně nainstalovaných jazykových sad překračuje limity stanovené vaší licencí. Jsou nainstalovány %2 jazykové sady; vaše licence umožňuje instalaci pouze %1 jazykových sad.',
    'plesk_key__wrong_version' => 'Zkoušíte použít licenční klíč vytvořený pro jinou verzi prostředí Plesk. Chcete-li získat správný licenční klíč, kontaktujte obchodní zástupce společnosti Plesk.',
    'plesk_key__other_product' => 'Zkoušíte použít licenční klíč vytvořený pro jiný produkt. Chcete-li získat správný licenční klíč, kontaktujte obchodní zástupce společnosti Plesk.',
    'plesk_key__invalid_machine_id_trial' => 'Vaše současná licence není platná, protože je již aktivována na jiném serveru Plesk. Abyste mohli pokračovat v používání platformy Plesk, nainstalujte novou licenci, nebo svou současnou licenci nainstalujte znovu zadáním aktivačního kódu (pokud jej máte).',
    'plesk_key__invalid_machine_id_retail' => 'Vaše současná licence není platná, protože je již aktivována na jiném serveru Plesk. Plesk EULA (https://www.plesk.com/legal/) brání v používání jedné licence na dvou a více serverech současně. Abyste mohli pokračovat v používání platformy Plesk, nainstalujte novou licenci, nebo nainstalujte svou současnou licenci znovu zadáním aktivačního kódu. Ten jsme vám zaslali e-mailem ve chvíli zakoupení licence. <br>Nemůžete aktivační kód najít? Získat jej můžete pomocí platformy Plesk 360. Nejdříve se přihlaste na adrese https://platform360.io/ s e-mailem, který jste použili k zakoupení licence, pak přejděte na kartu "Licenses" a zde vyhledejte aktivační kód ke své licenci. Případně se můžete obrátit na podporu platformy Plesk pro oblast licencí a nákupů pomocí online formuláře (https://www.plesk.com/licensing-and-purchase-support/). Nezapomeňte v části formuláře nadepsané "How can I help you?" vyplnit číslo své licence.',
    'plesk_key__limits_exceeded_error' => 'Nelze nainstalovat licenční klíč: momentálně používané množství prostředků překračuje limity definované v rámci nahraného licenčního klíč.',
    'plesk_key__limits_exceeded_note' => 'Momentálně používané množství prostředků překračuje limity definované v rámci nahraného licenčního klíč.',
    'plesk_key__key_file_invalid' => 'Nahraný soubor licenčního klíče je neplatný nebo neobsahuje licenční klíč.',
    'plesk_key__server_request_error' => 'Nelze aktualizovat licence. Ověřte si, že připojení k licenčnímu serveru ka.plesk.com na portu TCP %1 není blokováno. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Podívejme se, jak na to</a>.',
    'key__no_key_file_in_zip' => 'Nahraný soubor .zip neobsahuje licenční klíč',
    'key__key_upload' => 'Instalace licenčního klíče',
    'additional_key__prop_name' => 'Vlastnost',
    'additional_key__prop_value' => 'Hodnota',
    'additional_key__descr_name' => 'Název klíče',
    'additional_key__descr_key_number' => 'Číslo klíče',
    'additional_key__descr_key_vz' => "Tento licenční klíč je určen pouze pro kontejnery Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Poštovní schránky',
    'additional_key__descr_lim_date' => 'Datum vypršení platnosti',
    'additional_key__descr_license_update_date' => 'Další aktualizace licenčního klíče',
    'additional_key__file_invalid' => 'Nahraný soubor licenčního klíče je neplatný nebo neobsahuje licenční klíč.',
    'additional_key__file_incompatible' => 'Nahraný soubor licenčního klíče je pro tuto aplikaci neplatný.',
    'additional_key__expired' => 'Tento další klíč vypršel.',
    'additional_key__not_exists' => 'Není nainstalován žádný licenční klíč.',
    'additional_key__viruozzo_only_key' => 'Tento licenční klíč je určen pouze pro použití v prostředí Plesk nainstalovaném v kontejnerech Virtuozzo.',
    'additional_key_update__result_response' => 'Odpověď licenčního serveru: %1',
    'additional_key_update__result_network' => 'Licenční server je nedostupný. Zkontrolujte, zda vaše síť umožňuje komunikaci s %1:%2.',
    'additional_key_update__result_lock' => 'Probíhá aktualizace klíče',
    'additional_key_update__result_internal_error' => 'Došlo k chybě při aktualizaci licenčního klíče: %1',

    'proceed_to_cl_pool' => "Pokračujte konfigurací fondu IP adres zákazníka",
    'proceed_to_hosting_setup' => "Pokračovat v nastavení hostingu",
    'removeCerts__remove_certificates_cp' => "Následující certifikáty budou odebrány:",
    'removeCerts__remove_certificates_domain' => "Následující certifikáty, které vlastní %1, budou odebrány:",
    'removeClientsIP_remove_clients_ip' => "Tato IP adresa bude odebrána z fondů následujících zákazníků:",
    'removeMailAliases__remove_mail_aliases' => "Následující e-mailové aliasy pro e-mailový účet %1 budou odebrány:",
    'removeMailNames__remove_mailnames' => "Následující e-mailové účty a aliasy budou odebrány z domény %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Následující e-mailové účty a aliasy budou odebrány z domény %2 vlastněné zákazníkem %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Tyto e-mailové účty nebudou odstraněny.",
    'removeFtpSessions__remove_title' => "Následující relace FTP bude ukončena:",
    'removeTemplates__remove_templates' => "Následující šablony budou odebrány:",
    'resp_edit__always_respond' => "vždy odpovědět",
    'resp_edit__reply_subject' => "Předmět odpovědi",
    'resp_edit__answer_subject' => "Odpovědět s předmětem",
    'resp_edit__answer_txt' => "Odpovědět s textem",
    'resp_edit__attach' => "Připojit soubory",
    'resp_edit__default_subject' => "Předmět: %1",
    'resp_edit__for' => "pro",
    'resp_edit__frw_rqst_email' => "Při automatické odpovědi předat originální zprávu na zadaný e-mail",
    'resp_edit__fwd_email_invalid' => "Cílová e-mailová adresa je neplatná.",
    'resp_edit__in_body' => "když jsou zadaná slova nalezena v těle zprávy",
    'resp_edit__in_subject' => "když jsou zadaná slova nalezena v předmětu zprávy",
    'resp_edit__invalid_resp_freq' => "Frekvence odpovědi je neplatná.",
    'resp_edit__invalid_rqst_txt' => "Neplatný textový požadavek.",
    'resp_edit__invalid_store_lim_num' => "Hodnota limitu je neplatná.",
    'resp_edit__limits_title' => "Limity",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Počet maximálních odpovědí na den přesahuje zadaný počet. Povolených: %1, požadovaných: %2",
    'resp_edit__no_files_sel' => "Nejsou vybrány žádné soubory.",
    'resp_edit__no_txt_supplied' => "Nebyl dodán žádný text.",
    'resp_edit__reply_title' => "Odpověď",
    'resp_edit__reply_to_address' => "Zpáteční adresa",
    'resp_edit__reply_to_invalid' => "Zpáteční adresa je neplatná.",
    'resp_edit__reply_uniq_email' => "Odpovědět na jedinečnou e-mailovou adresu ne více než",
    'resp_edit__conditions_title' => "Podmínky",
    'resp_edit__request_title' => "Požadavek",
    'resp_edit__resp' => "Automatická odpověď",
    'resp_edit__resp_name' => "Název pro automatickou odpověď",
    'resp_edit__resp_not_exist' => "Automatická odpověď neexistuje.",
    'resp_edit__resp_status' => "Stav automatické odpovědi",
    'resp_edit__rqst_txt' => 'Určit podmínku pro tuto automatickou odpověď',
    'resp_edit__select_files_on_server_for_attach' => "Vyberte soubory, které chcete přiložit",
    'resp_edit__store_up_to' => "Uložit až",
    'resp_edit__subj_line_invalid' => "Řádek předmětu je neplatný.",
    'resp_edit__text_too_big' => "Text odpovědi je příliš dlouhý.",
    'resp_edit__times_in_a_day' => "krát za den.",
    'resp_edit__unable_define_resp_cond' => "Nelze definovat podmínku pro automatickou odpověď: %1",
    'resp_edit__unable_define_resp_status' => "Nelze definovat stav automatické odpovědi: %1",
    'resp_edit__unable_turn_on_resp' => "Nelze zapnout automatickou odpověď: %1",
    'resp_edit__uniq_email' => "jedinečná e-mailová adresa",
    'resp_edit__content_type' => 'Formát odesílání pošty',
    'resp_edit__content_type_text' => 'Prostý text',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Kódování',
    'restart__dns' => 'DNS Server (%1)',
    'restart__drweb' => 'Antivirus Plesk Premium',
    'restart__mail' => "Server IMAP/POP3 (%1)",
    'restart__mssql' => "Server Microsoft SQL",
    'restart__mysql' => "Server MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Služby",
    'restart__smtp' => "Server SMTP (%1)",
    'restart__spamd' => "Filtr nevyžádané pošty",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Webový server (%1)",
    'restart__ftp' => "Server FTP (%1)",
    'restart__service_start' => 'Ponechte určitou dobu, aby se služba mohla spustit.',
    'restart__service_stop' => 'Ponechte určitou dobu, aby se služba mohla zastavit.',
    'restart__service_restart' => 'Ponechte určitou dobu, aby se služba mohla restartovat.',
    'rm_domains__some_domains_are_not_exist' => "Některé ze zadaných domén neexistují. Pravděpodobně byly odebrány jiným uživatelem.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "Skupiny",
    'rpt_cl_dom_mail_lists' => "Seznamy",
    'rpt_cl_dom_mail_resps' => "Odpověď",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "Schránky",
    'rpt_cl_dom_redirects' => "Servery pro předávání",
    'rpt_cl_dom_subdomains' => "Subdomény",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "Uživatelé",
    'rpt_cl_report_for_admin__' => "Sestava pro správce %1",
    'rpt_cl_report_for_reseller__' => "Sestava pro prodejce %1",
    'rpt_cl_report_for_cl__' => "Sestava o zákazníkovi %1",
    'rpt_cl_section_domains' => "Domény",
    'rpt_cl_section_full_domains' => "Domény",
    'rpt_cl_section_general' => "Obecné",
    'rpt_create' => "Vytvořit sestavu",
    'rpt_empty' => "Sestava by měla obsahovat minimálně jeden oddíl",
    'rpt_dom_report_for_dom__' => "Sestava domény pro %1",
    'rpt_dom_section_databases' => "Databáze",
    'rpt_dom_section_full_databases' => "Databáze",
    'rpt_dom_section_full_maillists' => "Seznamy adresátů",
    'rpt_dom_section_full_mailnames' => "Poštovní účty",
    'rpt_dom_section_full_webusers' => "Uživatelé webu",
    'rpt_dom_section_full_siteapps' => 'Webové aplikace',
    'rpt_dom_section_full_aspnetapps' => 'Webová aplikace ASP.NET',
    'rpt_dom_section_general' => "Obecné",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Seznamy adresátů",
    'rpt_dom_section_mailnames' => "Poštovní účty",
    'rpt_dom_section_siteapps' => 'Webové aplikace',
    'rpt_dom_section_aspnetapps' => 'Webová aplikace ASP.NET',
    'rpt_dom_section_webusers' => "Uživatelé webu",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Upravit sestavu %1",
    'rpt_enter_email_address' => "Zadejte e-mailovou adresu, na kterou bude zpráva doručena.",
    'rpt_list' => "Rozložení vlastních sestav",
    'rpt_section_full' => "Úplné",
    'rpt_section_none' => "Žádné",
    'rpt_section_summary' => "Souhrn",
    'rpt_default_full' => 'Úplná sestava',
    'rpt_default_summary' => 'Souhrnné hlášení',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Chyba při odesílání sestavy: %1",
    'rpt_send_report_by_email_ok__' => "Zpráva byla odeslána na %1",
    'sa_action' => "Akce",
    'sa_action_del' => "Odstranit",
    'sa_action_desc' => "Co udělat s nevyžádanou poštou",
    'sa_action_save' => "Označit jako nevyžádanou poštu a uchovat v poštovní schránce",
    'sa_admin_blacklist' => "Černá listina správce",
    'sa_admin_whitelist' => "Bílá listina správce",
    'sa_db_del_confirm' => "Opravdu chcete vymazat databázi filtru nevyžádané pošty?",
    'sa_eml_in_ignorelist' => "E-mail je v seznamu ignorovaných",
    'sa_empty_email' => "Nelze přidat prázdnou šablonu e-mailu.",
    'sa_exists_email' => "Taková šablona e-mailu již existuje.",
    'sa_disabled__mailname_not_filtering' => "Aktuální nastavení serveru neumožňuje pro tento e-mailový účet použít filtrování pošty",
    'sa_disabled__filtering_is_disabled' => 'Filtrování nevyžádané pošty bylo správcem serveru deaktivováno',
    'sa_disabled__hasnt_mailbox' => "Nelze zapnout filtrování nevyžádané pošty bez poštovní schránky",
    'sa_enable_filter' => "Zapnout filtrování nevyžádané pošty",
    'sa_forget' => "zapomenout",
    'sa_from' => "Od",
    'sa_ham' => "korektní zprávy",
    'sa_pattern_is_invalid' => "Vzorec je neplatný.",
    'sa_spam' => "nevyžádaná pošta (spam)",
    'sa_trainer__page_title' => 'Testování filtru nevyžádané pošty',
    'sa_trainer__tools_legend' => 'Nástroje',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Zprávy ve vaší poštovní schránce',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Předmět',
    'sa_trainer__from' => 'Od',
    'sa_trainer__date' => 'Datum',
    'sa_trainer__info_text' => 'Zařazených zpráv: %1 jako nevyžádaná pošta (spam), %2 jako vyžádaná pošta, %3 celkem.',
    'sa_trainer__messages' => 'zpráv',
    'sa_trainer__select__all' => 'Všechno',
    'sa_trainer__select__spam_only' => 'Nevyžádaná pošta (spam)',
    'sa_trainer__select__ham_only' => 'Vyžádaná pošta (není spam)',
    'sa_trainer__select__unknown_only' => 'Neznámý',
    'sa_trainer__cannot_remove_messages' => 'Z poštovní schránky nelze odebrat vybrané zprávy.',
    'sa_trainer__remove_messages_confirm' => 'Opravdu chcete odebrat vybrané zprávy z poštovní schránky?',
    'sa_subj' => "Předmět",
    'sa_training' => "Testování filtru nevyžádané pošty",
    'sa_training_legend' => "Testování Bayesova filtrování",
    'sa_use_srv_settings' => "Použít nastavení pro celý server",
    'sa_user_blacklist' => "Černá listina uživatele",
    'sa_user_whitelist' => "Bílá listina uživatele",
    'sa_usr_disabled_by_srv' => "Individuální nastavení filtrování nevyžádané pošty není povoleno správcem serveru",
    'sa_usr_no_postbox' => "Nelze povolit filtrování nevyžádané pošty, protože poštovní schránka je pro tento poštovní účet vypnuta.",
    'sa_filters' => 'Filtry nevyžádané pošty',
    'spamfilter__tools_legend' => 'Nástroje',
    'spamfilter__prefs_legend' => 'Nastavení',
    'spamfilter__max_children' => 'Maximální počet pracovních procesů Spamd ke spuštění',
    'spamfilter__rewrite_header_subject_hint' => 'Pokud nechcete žádný text přidávat, ponechte toto pole prázdné. Pokud chcete zahrnout počet bodů do předmětu zprávy, napište _SCORE_.',
    'spamfilter__reject_spam' => 'Odstranit nevyžádanou poštu po příchodu do poštovní schránky',
    'spamfilter__enabled' => 'Zapnuto',
    'spamfilter_addresses_list__items' => 'adresy',
    'spamfilter_addresses__remove_title' => 'Ze seznamu budou odebrány následující adresy:',
    'spamfilter_addresses__empty_selection' => 'Nebyla vybrána žádná adresa.',
    'server__admin_info' => "Informace správce",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Zadejte popis chyby níže",
    'server__power_management' => "Řízení spotřeby",
    'server__services' => "Služby",
    'server__system' => "Systém",
    'server__title' => "Správa serveru",
    'server_preferences__admin_skin' => "Vzhled rozhraní správce",
    'server_preferences__default_language' => "Výchozí jazyk",
    'server_preferences__default_skin' => "Výchozí vzhled",
    'server_preferences__restart_apache_interval' => "Interval restartu Apache",
    'server_preferences__system' => 'Nastavení systému',
    'mail__tabs_preferences' => "Nastavení",
    'mail__tabs_white_list' => "Bílá listina",
    'server_preferences__use_vocabulary' => "Zkontrolujte hesla pro poštovní schránky ve slovníku",
    'sessions__agreement' => "Ano, přeji si ukončit tyto relace.",
    'sessions__select_sessions_for_remove' => "Vyberte relaci, která má být ukončena.",
    'sessions__tabs_cp_sessions' => 'Relace Plesk',
    'sessions__tabs_ftp_sessions' => 'Relace FTP',
    'sessions__ftp_sessions_login' => 'Přihlašovací jméno účtu FTP',
    'sessions__ftp_sessions_domain' => 'Název domény',
    'sessions__ftp_sessions_path' => 'Aktuální umístění',
    'sessions__ftp_sessions_file' => 'Název souboru',
    'sessions__ftp_sessions_action' => 'Stav',
    'sessions__ftp_sessions_speed' => 'Rychlost, kB/s',
    'sessions__ftp_sessions_comp' => 'Průběh, %',

    'site_apps__access_level' => 'Úroveň přístupu',
    'site_apps__access_level_commercial' => 'Komerční',
    'site_apps__access_level_free' => 'Zdarma',
    'site_apps__action_installer' => "Instalace webové aplikace",
    'site_apps__action_reconfigure' => "Změna konfigurace webové aplikace",
    'site_apps__custom_button_level' => 'Chcete vytvořit uživatelské tlačítko pro přístup k této aplikaci?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Ne',
    'site_apps__custom_button_level_domain_user_only' => 'Ano',
    'site_apps__custom_button_level_false' => 'Ne',
    'site_apps__custom_button_level_domain' => 'Ano, a zpřístupněte ho pouze pro aktuální doménu',
    'site_apps__custom_button_level_client' => 'Ano, a zpřístupněte ho pro všechny domény zákazníka',
    'site_apps__custom_button_level_admin' => 'Ano, a zpřístupněte ho pro všechny domény',
    'site_apps__description' => "Popis",
    'site_apps__dir_used_by_sapp__' => "Adresář \"%1\" využívají jiné webové aplikace",
    'site_apps__dir_used_by_unknown__' => "Adresář \"%1\" již existuje. Budete-li pokračovat, jeho obsah bude přepsán.",
    'site_apps__dir_invalid_name__' => "Název adresáře %1 je nesprávný",
    'site_apps__file_name' => 'Název souboru webové aplikace',
    'site_apps__invalid_install_prefix' => "Neplatná instalační předpona",
    'site_apps__invalid_package' => "Webová aplikace je neplatná",
    'site_apps__key_status' => 'Správa licencí',
    'site_apps__key_status_free' => 'Distribuováno zdarma. Licenční klíč není vyžadován',
    'site_apps__key_status_ok' => 'Požadovaný licenční klíč je nainstalován',
    'site_apps__key_status_problem' => 'Požadovaný licenční klíč není nainstalován',
    'site_apps__name' => "Jméno",
    'site_apps__no_domains' => 'Webovou aplikaci nelze nainstalovat. V kořenovém adresáři této domény je již nainstalována jiná webová aplikace. Zvažte vytvoření subdomény pro webovou aplikaci.',
    'site_apps__package_info_' => "Informace o webové aplikaci",
    'site_apps__package_integrated' => "vestavěná aplikace, nelze odebrat",
    'site_apps__pool_select_packages_to_add' => 'Vybrat webové aplikace, které chcete přidat do fondu',
    'site_apps__release' => "Uvolnit",
    'site_apps__resource_used_by_sapp' => "Tento prostředek používá nainstalovaná webová aplikace",
    'site_apps__root_used_by_sapp' => "Tento prostředek používá nainstalovaná webová aplikace",
    'site_apps__these_domains_will_not_delete' => 'Tyto (sub)domény nebudou odstraněny',
    'site_apps__upload_site_app_pkg_title' => 'Nahrát novou webovou aplikaci',
    'site_apps__version' => "Verze",
    'site_apps__access_to' => "Přístup k %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Šablona virtuálního hostitele",
    'skeleton__client_label' => "%1 šablona virtuálního hostitele",
    'skeleton__admin_page' => "Spravovat šablonu virtuálního hostitele",
    'skeleton__files_list' => "Soubory a adresáře",
    'skeleton__archiver_not_installed' => "Nelze rozbalit archiv. Na serveru není pravděpodobně nainstalován archivační program. Chcete-li mít nainstalovaný archivační program, kontaktujte správce {$PROD_NAME}.",
    'skeleton__client_page' => "Spravovat šablonu virtuálního hostitele",
    'skeleton__archive_corrupted' => "Kontrola archívu zjistila, že soubor archívu je buď poškozený nebo tento typ archívu není podporován.",
    'skeleton__archive_too_large' => "Kontrola archívu zjistila, že soubor archívu je příliš velký.",
    'skeleton__not_supported_archive_type' => "Tento typ archívu (soubor %1) není podporován.",
    'skeleton__upload_archive_file' => "Nahrát soubor archivu",
    'skin_download__title' => 'Stáhnout vzhled',
    'skin_download_now__title' => 'Probíhá stahování vzhledu',
    'skin_download_now__text' => 'Probíhá vytvoření balíčku vzhledů.<br>Tato operace může chvíli trvat.<br> Jakmile se otevře dialogové okno, můžete pokračovat v práci v prostředí Plesk.',
    'skin_file__help_for_using_types' => "Použijte archiv vzhledu v jednom z následujících formátů:",
    'skin_info__title' => 'Vlastnosti vzhledu',
    'skin_mng_err__rpm_not_skin' => 'Toto RPM není balíček vzhledu Plesk',
    'skin_mng_err__psa_install_noreloc' => 'Selhala instalace vzhledu založeného na rpm do zadaného umístění.',
    'skin_mng_err__already_exists' => 'Instalační adresář vzhledu již existuje, a je v něm umístěn balíček vzhledu.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Nahraný soubor není platný RPM balíček vzhledu.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Nahraný soubor není platný balíček vzhledu.',
    'skin_mng_err__rpm_upgrade_base' => "Nahraný soubor není platný balíček vzhledu {$PROD_NAME}.",
    'skin_mng_err__rpm_upgrade_other' => 'Nelze nainstalovat vzhled: neplatný formát vzhledu.',
    'skin_mng_err__no_a_skin' => "Nahraný soubor není platný balíček vzhledu {$PROD_NAME}.",
    'skin_upload__title' => 'Nahrát nový vzhled',
    'skin_upload__already_exists' => "Vzhled '%1' již existuje.",
    'skin_upload__unable_to_apply' => "Nahraný soubor neobsahuje vzhled Plesk nebo není formát archivu podporován.",
    'skin_upload__unable_to_rename__' => "Vzhled nelze přejmenovat na %2 to %1: %3.",
    'skin_upload__file_name' => 'Cesta k souboru balíčku vzhledu',
    'skins_list__title' => 'Úložiště vzhledů',
    'skins_remove__title' => 'Odebrání vzhledu',
    'skins_remove__select_skins_for_remove' => 'Vyberte vzhledy, které se mají odebrat',

    'spf__unable_update' => 'Nelze aktualizovat parametry SPF',
    'statistics__active_domains' => "Aktivní domény",
    'statistics__clients' => "Zákazníci",
    'statistics__subdomains' => "Subdomény",
    'statistics__cpu' => "Procesor (CPU)",
    'statistics__databases' => "Databáze",
    'statistics__db_users' => "Uživatelé databáze",
    'statistics__dirs' => "Chráněné adresáře",
    'statistics__dom_active' => "Aktivní",
    'statistics__dom_passive' => "Pasivní",
    'statistics__dom_problem' => "Problém",
    'statistics__domains' => "Domény",
    'statistics__domains_with_host' => "Domény s hostingem",
    'statistics__doms' => "Domény",
    'statistics__filesystem' => "Systém souborů",
    'statistics__general' => "Obecné",
    'statistics__hdd_available' => "Dostupná",
    'statistics__hdd_capacity' => "Kapacita",
    'statistics__hdd_total' => "Celkem",
    'statistics__hdd_usage' => "Využití pevného disku",
    'statistics__hdd_used' => "Využito",
    'statistics__ip' => "IP adresa",
    'statistics__key_number' => "Číslo klíče",
    'statistics__l1' => "Poslední 1 minuta",
    'statistics__l15' => "Posledních 15 minut",
    'statistics__l5' => "Posledních 5 minut",
    'statistics__la' => "Využití CPU",
    'statistics__mail_autoresponders' => "Automatické odpovědi",
    'statistics__mail_boxes' => "Poštovní schránky",
    'statistics__mail_groups' => "E-mailové skupiny",
    'statistics__mail_lists' => "Seznamy adresátů",
    'statistics__mail_redirects' => "Servery pro předávání pošty",
    'statistics__mem' => "Využití paměti",
    'statistics__mem_usage' => "Využití",
    'statistics__memory_available' => "Dostupná",
    'statistics__memory_buffer' => "Vyrovnávací paměť",
    'statistics__memory_cached' => "Využitá vyrovnávací paměť (Cached)",
    'statistics__memory_free' => "Zdarma",
    'statistics__memory_shared' => "Sdílené",
    'statistics__memory_total' => "Celkem",
    'statistics__memory_used' => "Využito",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Problémoví zákazníci",
    'statistics__problem_domains' => "Problémové domény",
    'statistics__swap' => "Využití odkládacího souboru",
    'statistics__swap_free' => "Zdarma",
    'statistics__swap_total' => "Celkem",
    'statistics__swap_usage' => "Využití",
    'statistics__swap_used' => "Využito",
    'statistics__system_stat' => "Informace o serveru",
    'statistics__unable_define_active_doms' => "Nelze určit počet aktivních domén: %1",
    'statistics__unable_define_inactive_doms' => "Nelze určit počet neaktivních domén: %1",
    'statistics__failed_define_swap_usage' => 'Nepodařilo se definovat využití swapového souboru',
    'statistics__failed_define_load_averages' => 'Nepodařilo se definovat průměry zatížení',
    'statistics__up_time' => "Doba provozu systému:",
    'statistics__ver' => "Verze",
    'statistics__web_users' => "Uživatelé webu",
    'statistics__mem_win' => "Využití fyzické paměti",
    'statistics__memory_total_win' => "Celkem",
    'statistics__memory_used_win' => "Využito",
    'statistics__memory_free_win' => "Dostupná",
    'statistics__swap_win' => "Využití virtuální paměti",
    'statistics__swap_total_win' => "Celkem",
    'statistics__swap_used_win' => "Využito",
    'statistics__swap_free_win' => "Dostupná",
    'status__domain_has_reasons_to_be_off' => "Doména je stále pozastavena z následujícího důvodu: %1",
    'subdomain__create__' => "Vytvořit subdoménu na doméně %1",
    'subdomain__edit__' => "Spravovat subdoménu %1",
    'subdomain__invalid_name' => "Neplatný název subdomény: používejte pouze alfanumerické symboly a symbol pomlčky.",
    'subdomain__incorrect_name' => "Neplatný název subdomény.",
    'subdomains__maillists_enabled_in_domain' => "Seznam s nesprávným názvem subdomény.%1: tento název domény se již používá v seznamech adresátů pod doménou %1.",
    'subdomains__dalias_exists' => 'Alias domény s tímto názvem již existuje.',
    'subdomains__name_exists' => "Subdoména s tímto názvem již existuje.",
    'subdomains__regular_domain_exists' => "Doména s tímto názvem již existuje.",
    'subdomains__domain_alias_exists' => 'Alias domény s tímto názvem již existuje.',
    'subdomains__remove_subdomains_on_domain' => "Následující subdomény pro doménu %1 budou odstraněny:",
    'subdomains__select_subdomains_for_remove' => "Vyberte subdomény, které budou odstraněny.",
    'subdomains__webmail_enabled_in_domain' => "Webové rozhraní pošty s nesprávným názvem subdomény.%1: tento název domény se používá k přístupu do webového rozhraní pošty pod doménou %1.",
    'subdomains__dns_record_already_exists' => 'Nelze vytvořit subdoménu %1, protože záznam DNS odkazující na hostitele %1 již existuje.',
    'subdomains__www_prefix_in_domain' => "Nesprávný název subdomény www.%1: doména %1 již má předponu WWW.",
    'subdomains__user_type_quota_exceeds' => 'Nelze změnit uživatelský účet, protože by to vedlo k překročení přiděleného místa na disku.',
    'subdomains__creation_in_dns_slave' => "Názvový server Plesk se chová jako sekundární názvový server pro tuto doménu. Aby byla vaše subdoména správně rozpoznána, ujistěte se, že soubor zóny na primárním serveru DNS obsahuje záznam %1.",
    'sys_user__attributes_not_changed' => "\nNásledující atributy uživatele systému nebyly změněny: %1",
    'sys_user__no_access_without_password' => "Nezadali jste heslo. Uživatel systému bude vytvořen, ale nebude se moci přihlásit do systému, dokud nezadá heslo. Chcete pokračovat?",
    'sys_user__no_hard_quota' => "nepodporováno",
    'sysuser__zero_quota_is_unlimited' => "0 pro neomezené",
    'template__num_excl_ips' => "Přidělit vyhrazené IP adresy zákazníkovi",
    'template__sel_sh_ips' => "Vybrané sdílené IP adresy",
    'template__av_sh_ips' => "Dostupné sdílené IP adresy",
    'template__up_to_excl_ip' => "Až %1 IP adres",
    'templates__all_clients' => "všichni odběratelé",
    'templates__cl_domain_templates' => "Šablony pro %1",
    'templates__cl_templates' => "Šablony zákazníka",
    'time__invalid_ip' => "Neplatná IP adresa nebo název domény.",
    '__please_select_country' => 'Vyberte svou zemi',
    'time__unable_set_time' => "Nelze zadat systémový čas: %1",
    'time__sinchronization_setup_error' => 'Nelze nastavit časovou synchronizaci: timemng selhalo: %1',
    'time__sinchronization_disable_error' => 'Nelze zakázat časovou synchronizaci: timemng se nezdařilo: %1',
    'tmpl__create' => "Vytvořit šablonu",
    'tmpl__edit__' => 'Šablona %1',
    'tmpl__logrotation_warn' => "Rotace souborů protokolu na doméně vytvořená pomocí této šablony se uskuteční pouze v případě vytvoření dodatečného účtu fyzického hostingu.",
    'tmpl__name' => "Název šablony",
    'tmpl__dom_exist' => "Šablona domény s tímto názvem již existuje ve fondu šablon správce či zákazníka.",
    'tmpl__name_invalid' => "Název šablony je neplatný nebo prázdný.",
    'tmpl__use_next_ip_addr' => "Bude použita další volná IP adresa",
    'tmpl_name_already_exists' => "Šablona s názvem '%1' již existuje.",
    'traffic__no_periods_found' => "Nelze zobrazit statistiky webu a přenosu. Tato funkce bude k dispozici pouze po příští statistické kalkulaci.",

    'vh_based__no_free_ip_for_vh' => "Nejsou žádné prázdné IP adresy pro virtuální hosting založený na IP adrese. Přidejte IP adresu, prosím.",

    'wu__at_domains_text' => "Povolit přístupový formát uživatele webu @%1",
    'wu__unable_create' => "Nelze vytvořit uživatele webu: %1",
    'wu_edit__disk_quota' => "Disková kvóta",
    'wu_edit__invalid_pass' => "Heslo je neplatné.",
    'wu_edit__invalid_quota' => "Specifikovaná hodnota kvóty prostoru na disku je neplatná. Zadejte celé kladné číslo.",
    'wu_edit__invalid_quota_value' => "Zadaná kvóta diskového prostoru je menší než právě používaná (%1MB). Některé funkce mohou být nedostupné. Určitě chcete pokračovat?",
    'wu_edit__not_create_pass' => "Tato akce nevytvoří heslo pro nového uživatele webu.\nBez hesla se uživatel nebude moci přihlásit.",
    'wu_edit__unable_update' => "Nelze aktualizovat vlastnost uživatele webu: %1",

    'bt_webdirs' => 'Virtuální adresáře',

    'dns__tabs_general' => 'Nastavení zóny',
    'dns__tabs_zone_settings' => 'Záznamy SOA',
    'soa__seconds' => 'sekundy',
    'soa__minutes' => 'minuty',
    'soa__hours' => 'hodiny',
    'soa__days' => 'dny',

    'DomainSubdirectory' => 'Cílový podadresář',

    'filemanager__select_codepage' => 'Vybrat znakovou stránku:',

    'bt_server_app_add' => 'Přidat serverovou aplikaci',
    'packages_list' => 'Serverové aplikace',

    'bt_packages_management' => 'Správa balíčků',
    'pb__packages_management' => 'Správa aplikací',
    'bt_package_new' => 'Přidat aplikaci',
    '__packages' => 'Serverové aplikace',

    'dom_ctrl__mysql_dbase_space' => 'Celková kvóta databází MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Celková kvóta databází MS SQL',

    'dns_add__enter_ixfr_path' => 'Zadejte cestu IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Záznam SPF TXT již existuje. Může zde být pouze jeden záznam SPF. Chcete-li přidat záznam, nejdřív odstraňte záznam stávající.',

    'component_name__network' => 'Sítě',
    'component_name__sitebuilder' => 'Systém Presence Builder',

    'bt_skin_set' => 'Nastavit vzhled',
    'bt_set_skin' => 'Nastavit vzhled',
    'firewall__rule_already_exists' => 'Pravidlo s názvem "%1" již existuje',
    'firewall__rule_readonly' => 'Pravidlo „%1“ je pouze pro čtení',
    'pb__firewall' => 'Brána firewall',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Umístění souboru není platné.',

    'error_doc__erorr_invalid_url_location' =>  'Chybný formát adresy URL. Zadejte absolutní adresu URL uvnitř virtuálního hostitele.',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Antivirová ochrana',
    'antivirus__antivirus_direction_off' => 'Vypnuto',
    'antivirus__antivirus_direction_any' => 'Příchozí a odchozí pošta',
    'antivirus__antivirus_direction_from' => 'Pouze odchozí pošta',
    'antivirus__antivirus_direction_to' => 'Pouze příchozí pošta',
    'antivirus__unable_to_update_settings' => 'Nelze změnit nastavení antivirové ochrany: %1',




    '__normal' => 'Normální',
    '__low' => 'Nízká',
    '__high' => 'Vysoká',

    'mail__antivirus' => "Antivirus interního poštovního serveru",
    'mail__use_internal_antivirus' => 'Použít interní antivirus',

    'sa__tabs_blacklist' => 'Černá listina',

    '__mysql_databases' => 'Databáze MySQL',

    'cl_perm__mysql_dbase_space' => 'Celková kvóta databází MySQL',
    'cl_perm__mssql_dbase_space' => 'Celková kvóta databází MS SQL',
    'cl_perm__max_mssql_db' => 'Maximální počet databází Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Celková kvóta poštovních schránek',

    'i_i_cl_on' => 'Účet zákazníka je aktivní.',
    'i_i_cl_off_by_admin' => 'Účet zákazníka je pozastaven správcem.',

    'sa_exists_tn' => 'Síť je již uvedena v seznamu.',

    'webdir__select_vdirs_to_remove' => 'Vyberte adresáře, které chcete odstranit',
    'webdir__select_mime_types_to_remove' => 'Vybrat typy MIME, které chcete odstranit',

    'defaultcomponents__not_activated' => 'neaktivováno',

    'bt_traffic_at_domains' => 'Provoz',

    '__awstats_perl_warning' => 'AWStats neumožní uživatelům kontrolovat statistiky za předchozí roky bez instalace Perl.',

    'class_client__mysql_dbase_space' => 'Hodnota překračuje limit zákazníka.',
    'class_client__mssql_dbase_space' => 'Hodnota překračuje limit zákazníka.',
    'class_client__max_mssql_db' => 'Hodnota překračuje limit zákazníka.',

    'dns__remove_transfer_restrictions_list_items' => 'Následující sítě budou odebrány ze seznamu kontroly přístupu:',

    'bt_up' => "Nahoru",
    'bt_down' => "Dolů",
    'virtualdir__type_default_doc_name_to_add' => 'Zadejte název souboru, který chcete přidat na seznam',
    'virtualdir__select_default_doc_to_remove' => 'Vybrat soubory, které se mají odebrat ze seznamu',
    'virtualdir__select_directory' => 'Vybrat adresář',

    'bt_install_selected' => 'Nainstalovat vybrané licenční klíče', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Doména překládá na jinou IP adresu (%1). Opravte nastavení DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Právě používaný poštovní server nepodporuje poštovní schránku a e-mailovou skupinu zapnuté současně. Stiskem OK zapněte poštovní schránku na úkor vypnutí e-mailových skupin. Chcete-li opustit vše beze změny, stiskněte Storno.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Právě používaný poštovní server nepodporuje poštovní schránku a e-mailovou skupinu zapnuté současně. Stiskem OK zapněte e-mailové skupiny na úkor vypnutí poštovní schránky. Chcete-li opustit vše beze změny, stiskněte Storno.',

    'mysql_dbase_space_limit' => 'Omezení místa databáze MySQL',
    'mysql_dbase_usage' => 'Využití místa databáze MySQL',
    'mssql_dbase_space_limit' => 'Omezení místa databáze serveru Microsoft SQL',
    'mssql_dbase_usage' => 'Využití místa databáze serveru Microsoft SQL',

    '__statistics' => "statistiky", //indirect

    'dns__soa_minimum_value_is_big' => 'Při nastavení hodnoty Minimální TTL na dobu delší než 3 hodiny může být vaše doména pro některé ze správců domén nepřístupná. Doporučuje se nastavit tyto hodnoty, pouze pokud na nich trvá váš registrátor názvů domén.',

    'virusfilter__interface_not_available' => 'Žádné filtry antiviru nejsou k dispozici.',
    'virusfilter__none_virus_filter' => 'Žádné',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'vypnuto',
    'virusfilter__status_any' => 'příchozí a odchozí pošta',
    'virusfilter__status_outgoing' => 'pouze odchozí pošta',
    'virusfilter__status_incoming' => 'pouze příchozí pošta',

    'visibility__root_override_parse_error' => 'V souboru %1 na řádku %2 je chyba syntaxe.',

    'sb__not_support_publishing_api' => "Součást nepodporuje automatické publikování",

    'component_name__cphosting' => "Hostování prostředí Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Nastavení kvóty poštovní schránky není podporováno aktuálním e-mailovým serverem.',
    '__unable_get_total_mboxes_quota' => 'Nastavení kvóty poštovní schránky není podporováno aktuálním e-mailovým serverem.',

    'install_prefix__parent_not_exists' => "Nadřazený adresář neexistuje.",

    'bt_change_version' => 'Změnit verzi',
    'aspdotnet__changeversion_title' => 'Výběr verze ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Vybrat všechny",
    '__uncheck_all' => "Zrušit zaškrtnutí všech položek",

    'dns__editing_domain_controller_zone' => "Úprava záznamů zóny DNS pro řadič domény může způsobit problémy s fungováním domény",

    'pb__interface_management' => "Správa rozhraní",
    'interface_management__tabs_skins' => "Vzhledy",
    'interface_management__tabs_interface_templates' => "Šablony rozhraní",
    'interface_management__tabs_locales' => "Národní prostředí",
    'locales_list__title' => "Úložiště jazykových sad",
    'locales_list__legend' => "Dostupné jazyky",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Jazyková sada",
    'locales_list__lang_title' => "Jazyk",
    'locales_list__country_title' => "Země",
    'locales_list__used_title' => "Využito",

    'backup__suspend_warning_during_backup' => "V průběhu zálohování bude doména nedostupná",
    'backup__suspend_warning_during_restore' => "Během obnovení bude doména nedostupná",
    'backup__suspend_domain' => "Pozastavit doménu",

    'locales_list__mls_limit' => "Vaše aktuální licence Plesk dovoluje použít %2 jazyky(ů). Momentálně máte nastaveny(o) %1 jazyky(ů) k dispozici uživatelům, kteří překračují počet poskytovaný s licencí. Vyberte %2 jazyky, které chcete použít, a zbytek uživatelům znepřístupněte kliknutím na jejich ikony ve sloupci do 'S'.",

    'bt_change_owner' => 'Přiřadit nového vlastníka',
    'chown__new_owner' => 'Nový vlastník',
    'chown__selected_domains' => 'Vybrané předplacené služby',
    'chown__limits_legend' => 'Prostředky',
    'chown__limit_name' => 'Název prostředku',
    'chown__limit_value' => 'Přidělené zdroje',
    'chown__limit_assigned_before' => 'Před přenosem',
    'chown__limit_assigned_after' => 'Po přenosu',
    'chown__error_limits' => "Nelze pokračovat v převedení předplatného: tato předplacená služba vyžaduje více prostředků, než může poskytovatel nového vlastníka poskytnout.",
    'chown__error_no_domains' => 'Nelze pokračovat v převedení předplatného: buď nebylo vybráno žádné předplatné, nebo vybrané předplacené služby již patří cílovému uživateli.',
    'chown__error_empty_ip_pool' => "Nelze pokračovat v převedení předplatného: fond IP adres poskytovatele nového vlastníka je prázdný. Ověřte si, že poskytovatel má ve fondu nejméně jednu IP adresu.",
    'chown__please_select_new_domain_owner' => 'Vybrat nového vlastníka pro toto předplatné',
    'chown__old_ip_address' => 'Aktuální IP adresa',
    'chown__new_ip_address' => 'Nová IP adresa',

    'chown__error_ssl_already_used' => "U těchto cílových IP adres je podpora SSL/TLS již použita: %1 Následující domény s podporou SSL/TLS proto nelze převést: %2. Prosím vyřešte tento problém a zkuste to znovu",
    'chown__sitebuilder_not_installed' => 'Systém Presence Builder není nainstalován',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Doménu %1 nelze přenést na jiného vlastníka, protože systém Presence Builder není nainstalován.',

    'backup__backup_time' => 'Čas zálohování',
    'backup__backup_time_hour' => 'hodiny',
    'backup__backup_time_minute' => 'minuty',
    'backup__every' => 'každý',
    'backup__day_of_month' => 'den v měsíci',

    'subdomain__select_hst_type' => 'Vyberte typ hostingu pro subdoménu',
    'hst_sel__subdom_subfolder_hst' => 'Subdoména na podsložce',
    'subdomain__www_root_folder_not_exists' => 'Domovský adresář webu %1 neexistuje',
    '__site_home_dir' => 'Domovský adresář webu',
    'subdomain__aspnet_disabled_domain' => 'vypnuto doménou',

    'domains__remove_description' => 'Všechna data domény, včetně obsahu a nastavení domény a příslušných subdomén, data webových aplikací, obsah poštovní schránky, e-mail, nastavení antiviru a filtru nevyžádané pošty, soubory protokolu, data úložiště zálohy domény a certifikáty SSL/TLS budou odstraněny. Pokud na svém počítači nemáte soubor zálohy, dojde k trvalé ztrátě všech dat.',
    'subdomains__remove_description' => 'Všechna data subdomény, včetně jejího obsahu a nastavení, data webových aplikací a soubory protokolu budou odstraněny. Pokud na svém počítači nemáte soubor zálohy, dojde k trvalé ztrátě všech dat.',

    'mail__tabs_spam_filtering' => 'Filtrování nevyžádané pošty',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Použít výchozí serverové nastavení (prohledávat)',
    'antivirus__use_server_settings_no_scan' => 'Použít výchozí serverové nastavení (neprohledávat)',
    'antivirus__check_for_viruses' => 'Hledat viry',
    'antivirus__dont_check_for_viruses' => 'Nehledat viry',
    'antivirus__incoming_mail' => 'Příchozí pošta',
    'antivirus__outgoing_mail' => 'Odchozí pošta',

    'domain_alias__CNAME_dns_record_exists' => 'Záznam DNS CNAME s tímto názvem již existuje',
    'domain_alias__A_dns_record_exists' => 'Záznam DNS A s tímto názvem již existuje',
    'domain_alias__bad_prefix' => 'Chybná předpona aliasu domény',
    'domain_alias__domain_doesnt_exist' => "Doména neexistuje",

    'dns__zone_ttl_message_info' => 'Pokud není hodnota TTL zadána, použije se pro tento záznam DNS hodnota TTL ze šablony záznamu SOA (%1).',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Soubor s názvem index.html bude vytvořen pro přesměrování na vybranou webovou aplikaci. Pokud soubor s názvem index.html již existuje, bude zálohován jako index.html.old a nahrazen souborem novým. Potvrďte stisknutím tlačítka OK",

    'bt_ftp_ctrl' => "Další účty FTP",
    'ftp_users_no_permission' => "Nemáte oprávnění spravovat účty FTP pro tuto doménu",
    'ftp_users_limit_reached' => "U této domény byl dosažen limit účtů FTP",
    'pb__ftp_ctrl' => "Správa FTP",
    'class_client__max_subftp_users' => "Další účty FTP",

    '__client_form_settings' => "Nastavení zákazníka",
    '__sbnet_client_keep_sbnet' => "Ponechat odpovídající uživatelský účet v systému Presence Builder",
    '__sbnet_cant_add_more_sites' => "Pro tohoto zákazníka bylo dosaženo limitu počtu webů, které mohou používat systém Presence Builder",
    '__sbnet_legend_text' => "Integrace systému Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Vytvořit odpovídající účet uživatele v systému Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Zkoušíte odebrat uživatelský účet systému Presence Builder přidružený k tomuto zákazníkovi. Odstraní se všechny weby uživatele a všechna další související nastavení ze systému Presence Builder, odebere se možnost upravit stávající weby prostřednictvím systému Presence Builder, i když tuto možnost zapnete později. Pokud později znovu vytvoříte uživatelský účet systému Presence Builder, budete muset vytvořit a publikovat všechny své weby úplně od začátku. Přejete si vypnout tvorbu webových stránek a publikování prostřednictvím systému Presence Builder?",
    'sb__build_site_with_subdomains' => "Subdomény Vytvořit blog a Galerie fotografií",
    '__sbnet_client_dont_have_sbuser' => "Prostřednictvím systému Presence Builder nelze vytvořit a publikovat web: Uživatel systému Presence Builder neexistuje",

    '__component_disabled' => "Součást je vypnuta",

    'subdomains__physical_path_not_exist' => "Existují subdomény propojené s neexistujícími fyzickými složkami",

    'dnsserver_bind_to_msdns_switching_warning' => "Varování: bude převedeno pouze prvních 254 IP adres podsítí s /8 a /16 maskami umístěnými v seznamu řízení přístupu. Budou převedeny jako samostatné IP adresy. Chcete pokračovat?",

    '__sbnet_net_framework_required_for_site' => "Weby Presence Builder mohou vyžadovat podporu ASP.NET 2.0 na vaší doméně. Pokud používáte systém Presence Builder, doporučujeme zapnout podporu ASP.NET 2.0.",

    'subdomain_auto_create_dir' => "Vytvořit fyzický adresář pro subdoménu",

    'sa_trainer__unable_to_get_messages_list' => "Nelze získat seznam zpráv v poštovní schránce: %1",
    'sa_trainer__pass_doesnt_exist' => "Heslo k tomuto e-mailovému účtu chybí",

    '__sitebuilder_error' => "Při pokusu o připojení k systému Presence Builder došlo k chybě. Obraťte se na svého poskytovatele služeb s žádostí o pomoc.",
    'wsb_error_user_not_exist' => "Tento uživatelský účet systému Presence Builder neexistuje.",
    'wsb_error_site_already_exist' => "Tento web již existuje v systému Presence Builder.",
    'wsb_error_site_limit_reached' => "Bylo dosaženo limitu počtu webů systému Presence Builder.",
    'wsb_error_internal_error' => "Nastala vnitřní chyba systému Presence Builder. Obraťte se na svého poskytovatele služeb s žádostí o pomoc.",
    'wsb_error_user_already_exist' => "Uživatel systému Presence Builder s tímto názvem již v systému Presence Builder existuje.",
    'sb_error_user_not_exist' => "Uživatel systému Presence Builder neexistuje.",
    'wsb_error_object_not_found' => "Systém Presence Builder nenalezl správný záznam hostitele.",

    'mg_no_mail_groups' => "Žádné e-mailové skupiny",

    'drweb__drweb_incoming' => 'Antivirová kontrola příchozí pošty',
    'drweb__drweb_outgoing' => 'Antivirová kontrola odchozí pošty',
    'drweb__disable_reason_serv' => 'E-mailový server nepodporuje nastavení antivirového filtru na úrovni poštovní schránky',

    'vz_sitebuilder3_client_cant_be_created' => "Nelze vytvořit účet zákazníka: není nainstalován doplněk SiteBuilder verze 3.1 nebo novější",

    'chown__client_without_sitebuilder_support' => "Nelze pokračovat v převedení předplatného: služba Presence Builder není zahrnuta v plánu služeb nového vlastníka nebo jeho poskytovatele.",

    // new limits

    'class_client__max_odbc' => "Připojení ODBC",
    'cl_perm__max_odbc' => "maximální počet připojení ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Název doménového aliasu',
    'domain_alias__list_ascii_name' => 'Ve formátu ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Správa rozhraní',
    'pb__interface_templates' => 'Správa rozhraní',
    'pb__interface_clients' => 'Zákazníci používající %1',

    // service management
    'bt_service_showall' => "Zobrazit vše",
    'bt_service_hideall' => "Skrýt vše",
    'bt_service_start' => "Spustit",
    'bt_service_stop' => "Zastavit",
    'bt_service_restart' => "Restartovat",
    'bt_service_disable' => "Vypnout",
    'bt_service_manual' => "Ruční",
    'bt_service_auto' => "Automaticky",
    'service_startup_auto' => 'Automaticky',
    'service_startup_manual' => 'Ruční',
    'service_startup_disabled' => 'Vypnuto',
    'service_action_ok' => "Operace se službou %1 byla úspěšně dokončena",
    'service_action_failed_disabled_service' => "Nelze dokončit operaci se službou %1, protože je vypnuta",
    'service_action_failed_error' => "Nelze dokončit operaci: %1",
    'service_group_action_ok' => "Operace s následujícími službami byla úspěšně dokončena: %1",
    'service_group_action_disabled' => "Nelze dokončit operaci s následujícími službami, protože jsou vypnuty: %1",
    'service_group_action_failed' => "Nelze dokončit operaci s následujícími službami: %1. Chcete-li přijmout podrobné informace o chybě, proveďte operaci s každou službou samostatně",

    // php 4vs5
    'bt_php' => "Nastavení PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Dostupné prodejcům',
    'massmail__resellers_list_selected' => 'Vybraní prodejci',
    'massmail__clients_list_available_for_select' => 'Dostupní zákazníci',
    'massmail__clients_list_selected' => 'Vybraní zákazníci',
    'massmail__advanced' => 'Rozšířený',
    'bt_massmail_send' => 'Odeslat',
    'massmail__save_template_name' => 'Uložit text do nové šablony s názvem',
    'massmail__template' => 'Šablona',
    'massmail__compose_mail' => 'Zpráva',
    'massmail__from' => 'Od',
    'massmail__to' => 'Pro',
    'massmail__subject' => 'Předmět',
    'massmail__body' => 'Text zprávy',
    'massmail__body_hint' => 'Použít <name> proměnnou, která automaticky vloží uživatelské jméno do vaší zprávy.',
    'massmail__send_to_clients' => "Zákazníci",
    'massmail__send_to_domainusers' => "Správci domény",
    'massmail__send_to_admins' => "Správci prostředí Plesk",
    'massmail_select' => 'Vybrat adresy',
    'massmail_showhide_selected' => "Zobrazit/Skrýt vybrané",
    'massmail_send_all' => "Všechno",
    'massmail_send_selected' => "Pouze vybrané",
    'massmail_send_except' => "Vše kromě vybraných",
    'bt_new_mass_mail_template' => "Přidat šablonu hromadných e-mailových zpráv",
    '__mass_mail_templates_list' => "Seznam šablon hromadných e-mailových zpráv",
    'massmail__template_name' => 'Název šablony',
    'massmail__receivers' => 'Příjemci',
    'massmail__created' => 'Odesílatel',
    'massmail__date_created' => 'Datum vytvoření',
    'massmail__compose' => 'Odeslat',
    'mass_mail__resellers_all' => 'Všichni prodejci',
    'mass_mail__clients_all' => 'Všichni odběratelé',
    'mass_mail__domainusers_all' => 'Všichni správci domény',
    'mass_mail__resellers_selected' => 'Vybraní prodejci',
    'mass_mail__clients_selected' => 'Vybraní zákazníci',
    'mass_mail__domainusers_selected' => 'Vybraní správci domény',
    'mass_mail__resellers_except' => 'Všichni prodejci kromě vybraných',
    'mass_mail__clients_except' => 'Všichni zákazníci kromě vybraných',
    'mass_mail__domainusers_except' => 'Všichni správci domény kromě vybraných',
    'mass_mail__admins_all' => 'Všichni správci',
    'massmailtemplateslist__title' => 'Šablony hromadných e-mailových zpráv',
    'massmail__insert_from_template' => "Vložit data ze šablony",
    'massmail__select_template' => "Vybrat šablonu",
    'massmail__body_short_hint' => "(pouze prostý text)",
    'massmail__from_short_hint' => "(e-mail nebo jméno)",
    'bt_insert' => "Vložit",
    'massmail__mail_send_successfully' => "Zpráva byla úspěšně odeslána",
    'massmail__mail_send_successfully_with_some_errors' => "Zpráva byla odeslána, ale bylo nalezeno několik chyb. Někteří z příjemců nemuseli přijmout zprávu. Další informace naleznete v následujícím souboru protokolu: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Zpráva nebyla odeslána. Ověřte si, že je vybrán nejméně jeden příjemce a e-mailový server Plesk pracuje správně. Další informace naleznete v následujícím souboru protokolu: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Data ze šablony %1 byla úspěšně vložena.",
    'massmail__template_added_successfully' => "Šablona zprávy byla uložena pod názvem %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Nastala chyba databáze systému Presence Builder. Obraťte se na svého poskytovatele služeb s žádostí o pomoc.",
    'wsb_error_sitebuilder_access_denied_error' => "Soubor není přístupný: systém Presence Builder nemá přístupová práva k požadovanému souboru nebo složce. Obraťte se na svého poskytovatele služeb s žádostí o pomoc.",
    'wsb_error_sitebuilder_connection_failed' => "K systému Presence Builder se nelze připojit, protože došlo ke ztrátě připojení. Obraťte se na svého poskytovatele služeb s žádostí o pomoc.",
    'wsb_error_critical_during_operation' => "Nastala kritická chyba systému Presence Builder: %1",
    'wsb_error_license_during_operation' => "Nastala chyba licence systému Presence Builder: %1",
    'wsb_error_during_operation' => "Nastala chyba systému Presence Builder: %1",
    'wsb_error_license_error' => "Došlo k omezení licence systému Presence Builder.",

    // Other
    '__confrim_service_stop' => "Varování! Pokud zastavíte službu %1, Plesk může přestat pracovat. Opravdu chcete zastavit službu %1?",
    'virtualdir__name_is_reserved' => "Tento název je rezervován",
    'index_redirect_help_text' => 'Nyní budete automaticky přesměrováni na požadované webové stránky. Pokud váš prohlížeč nepodporuje přesměrování, klikněte %1 sem %2',
    'bt_default_settings' => "Obnovit výchozí",
    'logfiles__remove_failed' => "Nelze odstranit soubor %1: soubor je uzamčen jinou aplikací. Opakujte akci později.",
    'subdomain__invalid_homedirectory' => "Zadaný domovský adresář subdomény je neplatný",
    'scheduler_item__empty_filename' => "Zadejte spustitelný soubor, který se má spustit.",
    'subdomains__overlapped_domain_exists' => 'Subdoména je překryta zónou DNS domény %1',
    'subdomains__overlapped_domain_alias_exists' => 'Subdoména je překryta zónou DNS aliasu domény %1',
    'services_action_none_selected' => 'Nelze dokončit operaci: vyberte požadované služby',
    'cl_perm__max_subftp_users' => "maximální počet dalších účtů FTP",
    'login_up__access_denied_no_cp_access' => 'Přístup odepřen. Nemáte oprávnění k přístupu do prostředí Plesk.',
    'drweb__disable_reason_admin' => "Nastavení antivirového filtru na úrovni poštovní schránky není podle zásad serveru povoleno.",

    'webdirs__name_is_invalid' => 'V názvu adresáře použít pouze alfanumerické znaky, podtržítko a pomlčku.',
    'webdirs__physical_path_is_invalid' => 'Fyzická cesta není platná nebo neexistuje',
    '__use_default' => 'Použít výchozí',

    'webalizer_hidden_referrer__already_exist' => 'Takový záznam již existuje.',
    'webalizer_group_referrer__already_exist' => 'Skupina odkazujících serverů s tímto názvem již existuje.',

    'pb__dashboard' => 'Domů',

    'server_interface__page_title' => 'Nastavení rozhraní serveru',
    'server_interface__tabs_locales' => 'Národní prostředí',
    'server_interface__tabs_skins' => 'Vzhledy',
    'server_interface__tabs_interface_templates' => 'Šablony rozhraní',
    'bt_server_interface' => 'Předvolby rozhraní',
    'pb__server_interface' => 'Předvolby rozhraní',

    'bt_wizard_next' => 'Další>>',
    'bt_wizard_prev' => '<< Zpět',

    '__limit_exceeded_max_dom_server' => 'Na tomto serveru nelze hostit větší počet domén, protože bylo dosaženo limitu v počtu domén povolených na serveru licenčním klíčem. O vyřešení tohoto problému požádejte svého poskytovatele služeb.',
    '__limit_exceeded_max_subdom_server' => 'Na tomto serveru nelze hostit více subdomén. Obraťte se na svého poskytovatele služeb.',
    '__limit_exceeded_max_dom_aliases_server' => 'Na tomto serveru nelze nastavit více doménových aliasů. Obraťte se na svého poskytovatele služeb.',
    '__limit_exceeded_max_wu_server' => 'Nelze vytvořit větší počet uživatelů webu, protože bylo dosaženo limitu v počtu uživatelů webu povolených na serveru licenčním klíčem. O vyřešení tohoto problému požádejte svého poskytovatele služeb.',
    '__limit_exceeded_max_mn_server' => 'Nelze vytvořit větší počet e-mailových účtů, protože bylo dosaženo limitu e-mailových účtů povolených na serveru licenčním klíčem. O vyřešení tohoto problému požádejte svého poskytovatele služeb.',

    '__limit_exceeded_max_cl_useradmin' => 'Dosáhli jste limitu v počtu zákaznických účtů definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Dosáhli jste limitu v počtu domén definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Dosáhli jste limitu v počtu subdomén definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Dosáhli jste limitu počtu doménových aliasů definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Nemáte žádné volné místo na disku',
    '__limit_exceeded_max_wu_useradmin' => 'Dosáhli jste limitu v počtu účtů uživatelů webu definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Dosáhli jste limitu v počtu databází definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Dosáhli jste limitu v počtu poštovních schránek definovaných vaším licenčním klíčem (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Dosáhli jste limitu v počtu e-mailových účtů definovaných vaším licenční klíčem (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Dosáhli jste limitu v počtu seznamů adresátů definovaných vaším licenční klíčem (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Dosáhli jste limitu v počtu domén (%2).',
    '__limit_exceeded_max_subdom_userclient' => 'Dosáhli jste limitu v počtu subdomén (%2) povolených vaším poskytovatelem služeb',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Dosáhli jste limitu počtu doménových aliasů (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Dosáhli jste limitu využití místa na disku (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Dosáhli jste limitu využití šířky pásma za měsíc (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Dosáhli jste limitu v počtu uživatelů webu (%2) povolených vaším poskytovatelem služeb.',
    '__limit_exceeded_max_db_userclient' => 'Dosáhli jste limitu v počtu databází (%2).',
    '__limit_exceeded_max_box_userclient' => 'Dosáhli jste limitu v počtu poštovních schránek (%2).',
    '__limit_exceeded_max_maillists_userclient' => 'Dosáhli jste limitu v počtu seznamů adresátů (%2)',
    '__limit_exceeded_expiration_userclient' => 'Váš účet vyprší %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Dosáhli jste limitu v počtu subdomén (%2) povolených vaším poskytovatelem služeb',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Dosáhli jste limitu počtu doménových aliasů (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Dosáhli jste limitu využití místa na disku (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Dosáhli jste limitu šířky pásma využitého za měsíc (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Dosáhli jste limitu počtu účtů uživatelů webu (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Dosáhli jste limitu v počtu databází (%2).',
    '__limit_exceeded_max_box_userdomain' => 'Dosáhli jste limitu v počtu poštovních schránek (%2).',
    '__limit_exceeded_max_maillists_userdomain' => 'Dosáhli jste limitu v počtu seznamů adresátů (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Váš účet vyprší %2',

    'mmt__to_none' => 'Žádné',
    'mmt__to_admin' => 'Správce',
    'mmt__to_resellers_all' => 'Všichni prodejci',
    'mmt__to_resellers_select' => 'Vybraní prodejci',
    'mmt__to_resellers_select__available' => 'Dostupné prodejcům',
    'mmt__to_resellers_except' => 'Všichni prodejci kromě vybraných',
    'mmt__to_clients_all' => 'Všichni odběratelé',
    'mmt__to_clients_select' => 'Vybraní zákazníci',
    'mmt__to_clients_select__available' => 'Dostupní zákazníci',
    'mmt__to_clients_except' => 'Všichni zákazníci kromě vybraných',

    'mmt__unable_send_empty_selection' => 'Nelze odeslat hromadnou poštu, nebyla vybrána žádná e-mailová adresa.',
    'mmt__unable_send_to__' => 'Nelze odeslat hromadnou poštu pro:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Nelze ověřit webovou aplikaci, protože jeden z požadovaných souborů (%1) nebyl nalezen. O pomoc požádejte zástupce technické podpory.',
    'sapp_error_validation_spec_failed' => 'Nahraná webová aplikace neodpovídá specifikaci AppPacks: %1.',
    'sapp_error_validation_register' => 'Nelze registrovat webovou aplikaci umístěnou v adresáři "%1": %2 Webovou aplikaci musíte odebrat ze serveru, protože nebude pracovat správně.',

    'sapp__install_failed' => 'Instalace webové aplikace se nezdařila: %1',
    'sapp__install_res_failed' => 'Vytvoření požadovaného prostředku se nezdařilo.',

    'server_preferences__subdomains_blog_and_photo' => 'Standardně subdomény Vytvořit blog a Galerie fotografií',
    'plesk_key__blog_and_photo' => 'Schopnost spravovat výchozí stav zaškrtávacího políčka subdomén Vytvořit blog a Galerie fotografií',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Nelze změnit typ IP adresy na jednoúčelový, protože je přiřazena více než jednomu uživateli',

    // 8.1.1

    '__write_modify_warning' => 'Po výběru dalších oprávnění pro zápis/úpravy budou některé webové aplikace pracovat správně, ale zároveň se výrazně zvýší bezpečnostní rizika',
    '__write_modify_subdomain_warning' => 'Po výběru dalších oprávnění pro zápis/úpravy budou některé webové aplikace pracovat správně, ale zároveň se výrazně zvýší bezpečnostní rizika',

    'phosting__php_incorrect_version_used' => "Byly zjištěny problémy s verzí PHP. Chcete-li tyto problémy vyřešit, vyberte dole zaškrtávací políčko s požadovanou verzí PHP a klikněte na OK. Chcete-li vypnout PHP na této doméně, klikněte na OK bez výběru verze PHP",
    'fp__mail_preferences' => 'Nastavení pošty',

    'mail__invalid_white_pattern' => 'Zadaná hodnota je neplatná. Použijte následující formáty: pro e-mailové adresy použijte adresu mail@example.com, pro domény adresu example.com.',
    'mail__invalid_black_pattern' => 'Specifikovaná hodnota je neplatná. Použít následující formát: mail@priklad.cz pro e-mailové adresy, priklad.cz pro domény.',

    'resp_edit__reply_as_html' => 'Odeslat jako HTML',
    'exception__path_very_long' => "Cesta je příliš dlouhá. Ověřte si, zda je v cestě méně než %1 znaků.",

    // 8.2


    //SAPP
    'sapp_on' => 'Zapnout',
    'sapp_off' => 'Vypnout',
    'sapp_directive_aspect' => 'Vyžadováno',
    'sapp_databases_num' => 'Databáze',
    'sapp_db_required' => 'Vyžadováno',
    'sapp_Required' => 'Vyžadováno',
    'sapp_Variant' => 'Varianta',
    'sapp_db_id' => 'ID databáze',
    'sapp_db_id_type' => 'DB (id: %1) typ',
    'sapp_db_id_min_version' => 'DB (id: %1) minimální verze',
    'sapp_db_id_table_prefix' => 'DB (id: %1) předpona tabulky',
    'sapp_Default' => 'Výchozí hodnota',
    'sapp_apache_mod_req' => 'Modul Apache',
    'sapp_dbtype_not_installed' => 'není nainstalováno',
    'sapp_apache_mod_not_installed' => 'není nainstalováno',
    'sapp__value_error_empty' => 'Prázdná hodnota není povolena.',
    'sapp_error_invalid_type' => 'Aplikace "%1" nepodporuje požadovanou akci.',
    'sapp_error_unknown_app_type' => 'Nepodporovaný typ aplikace: %1',
    'sapp__ssl_text' => 'Instalovat aplikaci na virtuálního hostitele "http://" nebo "https://"?',
    'sapp__app_to_upgrade' => 'Aplikace, které se mají aktualizovat na vyšší verzi',
    'sapp__upgrade_apps_title' => 'Aktualizovat aplikace na vyšší verzi',
    'sapp__upgrade_to_ver' => 'Aktualizovat na verzi',
    'sapp__choose_pkg_ver' => 'Vybrat balíček...',
    'sapp__pkg_cant_upgrade_pkg' => 'Balíček "%1" nelze použít k aktualizaci webové aplikace "%2" na vyšší verzi.',
    'sapp__app_ugrade_error' => 'Aplikaci nelze aktualizovat na vyšší verzi: %1. Kontaktujte svého správce systému.',
    'sapp__no_suitable_db_found' => 'Nebyla nalezena žádná vhodná databáze.',
    'sapp__upgrade_success' =>  'Aplikace byla úspěšně aktualizována na vyšší verzi.',
    'sapp__pkg_info_changelog' => 'Historie změn',
    'sapp_requirement_legend' => 'Funkce hostování požadované aplikací',

    // other
    'bt_apply' => 'Použít',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Chcete-li vytvořit e-mailový alias, u tohoto e-mailového účtu musí být zapnuta poštovní schránka. Zapnout poštovní schránku?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Při vypnutí poštovní schránky dojde k odebrání e-mailových aliasů, protože přestanou pracovat. Vypnout poštovní schránku?',
    'antivirus__disable_reason_install' => 'Nelze spravovat antivirový program, protože není nainstalován.',
    'antivirus__disable_reason_key' => 'Nelze spravovat antivirový program, protože není aktivován správným licenčním klíčem.',
    'antivirus__disable_reason_deny_personal_settings' => 'Nelze spravovat antivirovou ochranu, protože zásady serveru zakazují individuální nastavení antiviru.',
    'change_foreign_user_password' => 'Změnit heslo',
    'change_foreign_user_password_hint' => "Uživatel nepatří k této aplikaci. Kliknutím na odkaz přejděte na jinou aplikaci a zde změňte heslo uživatele. K tomu musíte mít v aplikaci odpovídající oprávnění.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Formát řetězce',
    'lang_unknown' => 'Neznámý jazyk',
    'pb__cl_ed' => 'Podrobnosti zákazníka',
    'pb__actionlog' => 'Protokol akcí',
    'pb__cl_limits' => 'Limity zákazníka',
    'pb__edit' => 'Upravit',
    'pb__subdom_edit' => 'Nastavení hostování',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Zálohovat obsah poštovních schránek',

    'maillist_import_result' => "\nCelkový počet e-mailových adres v souboru: %1\n počet naimportovaných e-mailových adres: %2\n počet stávajících e-mailových adres: %3\n počet duplicitních e-mailových adres v zadaném souboru: %4\n počet neplatných e-mailových adres v souboru: %5",
    'maillist_import_error' => 'Nelze importovat seznam e-mailových adres',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Soubor, který jste vybrali, je buď prázdný, nebo se nejedná o platný dokument HTML s vybraným kódováním. Vyberte správné kódování nebo do souboru přidejte obsah.",

    'dom_pref__external_mail_srv' => "Přesměrovat na externí e-mailový server s IP adresou:",
    'mn_edit__store_messages' => 'Poštovní schránka',

    // aps

    'sapp__before_upgrade_notice' => 'Před zahájením aktualizace na vyšší verzi se doporučuje zálohovat aplikaci a data uživatele.',
    'sapp__application_properties' => 'Vlastnosti aplikace',
    'sapp__application_root_descr' => 'Hlavní stránka aplikace',

    'sapp__aps_license_invalid_id' => 'Licenční klíč má neplatné ID: %1',
    'sapp__aps_lic_key_alredy_exists' => 'Licence s číslem klíče %1 již v databázi existuje.',
    'sapp__aps_lic_del_used' => 'Nelze odstranit licenční klíč; používá ho jedna z nainstalovaných aplikací.',
    'sapp__aps_lic_del_unknown' => 'Nelze odstranit licenční klíč: %1',
    'sapp__aps_cappi_duplicate' => "Tato aplikace je již ve fondu aplikací zákazníka",
    'sapp__appi_not_shared_no_install' => "Ve fondu aplikací zákazníka žádná taková aplikace neexistuje. Pokud chcete nainstalovat tuto aplikaci na web, musíte ji nejprve přidat do fondu aplikací zákazníka.",
    'sapp__appi_shared_not_client' => "Ve fondu aplikací zákazníka žádná taková aplikace neexistuje. Pokud chcete provést aktualizaci aplikace na určenou verzi, musíte nejprve přidat tuto verzi aplikace do fondu aplikací zákazníka.",
    'sapp__apply_license_script_not_found' => 'Nelze najít skript "použít licenci" pro tuto webovou aplikaci.',
    'sapp__unable_to_activate_key' => 'Při pokusu o aktivaci licenčního klíče: %1 došlo k chybě',
    'sapp__unable_to_delete_ai_instances_exists' => 'Jsou nainstalovány webové aplikace, které vyžadují přítomnost této webové aplikace v systému.',
    'sapp__unable_to_delete_ai_in_pool' => 'Tato aplikace je stále ve fondu aplikací zákazníka. Pokud chcete tuto aplikaci odebrat, musíte ji nejprve odebrat z fondů aplikací všech zákazníků nebo ji převést na bezplatnou.',
    'sapp__unable_to_delete_app_template' => 'Nelze odebrat aplikaci %1: %2',
    'sapp__limit_exceeded_client' => 'Dosáhli jste limitu v počtu, kolikrát můžete nainstalovat tuto webovou aplikaci (%2).',


    // atis module

    '_week_on' => 'týden na',
    '__week_first' => 'první',
    '__week_second' => 'sekunda',
    '__week_third' => 'třetí',
    '__week_fourth' => 'čtvrtý',
    '__week_last' => 'poslední',
    '__not_started' => 'Čeká se',
    '__started' => 'Spuštěno',
    '__cancel_pending' => 'Probíhá zrušení',
    '__canceled' => 'Zrušeno',
    '__error' => 'Chyba',
    '__done' => 'Hotovo',

    '__php_cgi_handler' => 'Aplikace CGI',
    '__php_isapi_handler' => 'Rozšíření ISAPI',
    '__php_fastcgi_handler' => 'Aplikace FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'spustit jako',

    'cf_dbfolder_text' =>'Složka databáze',
    'cf_isnewdb_text' => 'Vytvořit databázi',
    'cf_isnewdb_title' => 'Zaškrtněte políčko, pokud se má vytvořit databáze',

    'pb__site_apps_upgrade' => 'Aktualizace webové aplikace na vyšší verzi',

    'detach' => 'Odpojit',
    'preferences' => "Změnit heslo",

    'toolsbar__switch_user?' => "Opravdu se chcete přihlásit pod jiným uživatelským účtem?",
    '__aps_left' => 'Zbylé instalace',
    'aps__license_key' => 'Licenční klíč',
    'aps__download_code' => 'Stažení licenčního klíče a aktivačního kódu',
    'aps__license_key_hint' => 'Obnovit z licenčního serveru prostřednictvím aktivačního kódu',
    'aps__database_not_available' => 'není k dispozici; zkontrolujte doménu nebo limity zákazníků',
    'aps__yes' => 'Ano',
    'aps__no' => 'ne',
    '__click_to_enlarge' => 'Kliknutím zvětšit',
    'site_apps__back_to_list' => 'Návrat do seznamu',
    'sapp__pkg_info_installation_requirements' => 'Požadavky na instalaci',
    '__close_window' => 'Zavřít',

    //SAPP END

    'skin_info__already_default' => 'Vzhled je již nastaven jako výchozí.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Antivirus Plesk Premium',
    'drweb:properties_page_title' => 'Nastavení antiviru Plesk Premium pro %1',
    'drweb:properties_legend' => 'Nastavení',
    'drweb:status' => 'Testování pošty na přítomnost virů',

    // sb integration
    'sitebuilder_wizard' => 'Průvodce systémem Presence Builder',
    'dom_site_builder' => 'Kliknutím otevřete průvodce systémem Presence Builder.',
    'sb_plesk_admin_url' => 'Adresa URL serveru Presence Builder. Zajistěte, aby byla tato adresa správně přeložena v DNS',
    'sb_plesk_admin_login' => 'Uživatelské jméno pro přihlášení správce serveru do systému Presence Builder',
    'sb_plesk_admin_password' => 'Heslo správce',
    'sb_sitebuilder_preferences' => 'Pověření správce systému Presence Builder',
    'sb__server' => 'Předvolby správce systému Presence Builder',
    'sb__sitebuilder_support' => 'Podpora systému Presence Builder',
    'sb_keep_sb_user' => 'Ponechat odpovídající uživatelský účet v systému Presence Builder',
    'sb_create_sb_user' => 'Vytvořit odpovídající účet uživatele v systému Presence Builder',
    'sb__build_site_using_sitebuilder' => "Vytvořit web prostřednictvím systému Presence Builder",
    'sb_no_current_sb_server_set' => 'Připojení k systému Presence Builder není dosud nakonfigurováno: do šablony zóny DNS musíte přidat záznam A, který bude směřovat na server Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Nelze načíst informace ze systému Presence Builder : %1",
    'sb_unable_connect_sb_wrong_con_params' => "Nelze se připojit k systému Presence Builder: chybné přihlašovací jméno nebo heslo.",
    'sb_init_sb_manager' => "Inicializace správce systému Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Připojení k systému Presence Builder se nezdařilo.",
    'sb_err_client_dont_have_sbuser' => "Tento zákazník nemá uživatelský účet v systému Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Systém Presence Builder není nakonfigurován.",
    'sb_err_you_dont_have_sbaccount' => "Vaše autorizace v systému Presence Builder se nezdařila.",
    'sb_error_critical_during_operation' => "V systému Presence Builder došlo k následujícím chybám: %1",
    'sb_err_sso_is_not_enabled' => "Podpora jednotného přihlašování není v prostředí Plesk zapnuta.",

    'warning__super_zone_exist' => "Byla vytvořena zóna %1, ale název této zóny je subzónou jiné již existující zóny %2, která patří jinému uživateli %3. Je to možné, ale ujistěte se, že jste si vybrali správný uživatelský účet.",
    'error__super_zone_exist' => "Nelze vytvořit zónu DNS, protože její superzóna patří jinému uživateli.",

    'locales__files_not_exits' => 'Nelze změnit národní prostředí: v systému nejsou soubory zadané jazykové sady rozhraní.',
    'locales__unavailable' => 'Nelze změnit národní prostředí: zadaná jazyková sada rozhraní je nedostupná.',

    // DB BU

    'pb__dbbackup_list' => 'Soubory zálohy databáze',
    // server
    'dbbackup__server_backup_settings' => 'Záloha',
    'dbbackup__network_temp_dir' => 'Dočasný síťový adresář',
    'dbbackup__network_user' => 'Uživatelské jméno',
    'dbbackup__network_pass' => 'Heslo',
    // domain
    'dbbackup__add_database_legend' => 'Obnovit zálohovanou databázi',
    'dbbackup__add_database_restore' => 'Obnovit databázi ze souboru zálohy',
    'dbbackup__add_database_file' => 'Soubor zálohy databáze',
    'dbbackup__add_database_user' => 'Výchozí uživatelské jméno',
    'dbbackup__add_database_pass' => 'Heslo výchozího uživatele',
    'dbbackup__add_database_pass2' => 'Potvrzení hesla výchozího uživatele',

    'bt_dbbackup_now' => 'Zálohovat',

    'bt_repair' => 'Opravit',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Nahrávání výpisů databáze serveru SQL je poskytovatelem hostingu zakázáno.',

    // APS categories

    'cf_invalid_password' => 'Heslo nesmí být delší než |16 znaků',
    'cf_invalid_description_length' => 'Popis nesmí být delší než 256 znaků',
    'ip_addr__ip_used_by_external_mail_server' => 'IP adresu %1 již používá externí e-mailový server',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Přihlašovací jméno účtu FTP nebo heslo je neplatné. Zadejte správná pověření uživatele FTP.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Bylo dosaženo limitu v počtu změn sériového čísla. Dnes nelze uskutečnit žádné další změny zóny DNS.',
    'dns__zone_apply_changes' => 'Změny uskutečněné v záznamech DNS nejsou dosud uloženy. Provedené změny jsou zvýrazněny. Kliknutím na Aktualizovat aplikujte změny na zónu DNS nebo klikněte na Vrátit a změny zrušte.',
    'dns__update_dns_zone' => 'Kliknutím uložte změny vytvořené v záznamech DNS',
    'dns__revert_dns_zone' => 'Kliknutím zrušte změny vytvořené v záznamech DNS',
    'bt_revert' => 'Vrátit uložený',
    'dns__dns_zone_has_beed_updated' => 'Změny uskutečněné v záznamech DNS byly uloženy.',
    'dns__dns_zone_has_beed_reverted' => 'Změny uskutečněné v záznamech DNS byly zrušeny',
    'db__nondefault_server_not_allowed' => 'Použití jiného než výchozího databázového serveru není povoleno',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Účty a domény zákazníka %1.',
    'ui__client__disabled-warning' => 'Účet zákazníka %1 je pozastaven.',
    'ui__client__none-available' => 'Nejsou nakonfigurovány žádné zákaznické účty.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Odběratel %1',
    'ui__client_self__description' => 'Seznam mých domén.',
    'ui__client_self__short-title' => 'Moje domény',
    'ui__client_self__title' => 'Moje domény',


    'site_apps__non_removable' => 'Položky, které nelze odebrat',
    'site_apps__non_removable_items' => 'Následující webové aplikace nelze odebrat.',

    'ui__client/custom-buttons/custom-button__none-available' => 'Neexistují žádná uživatelská tlačítka.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Na Panelu zákazníka %1 neexistují žádná uživatelská tlačítka.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Odebrat tlačítko %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Odebrat',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Odebrat tlačítko %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Odebrat uživatelská tlačítka z panelu zákazníka',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Odebrat',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Odebrat uživatelská tlačítka.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Odebrat tlačítka',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Vyberte zákazníka, jehož uživatelská tlačítka chcete odebrat, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Vyberte tlačítka, které chcete odebrat, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Potvrďte odebrání tlačítek označením zaškrtávacího políčka na této stránce a poté klikněte na Dokončit.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Odebrat uživatelské tlačítko z panelu zákazníka.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Odebrat',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Odebrat uživatelské tlačítko',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Odebrat uživatelské tlačítko',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož uživatelské tlačítko chcete odebrat, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Vyberte uživatelské tlačítko, které chcete odebrat, a klikněte na Další >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Potvrďte odebrání uživatelského tlačítka označením zaškrtávacího políčka na této stránce a poté klikněte na Dokončit.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Upravit vlastnosti tlačítka %1 na úrovni zákazníka.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Nastavení',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Upravit uživatelské tlačítko %1 zákazníka',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Přidat uživatelské tlačítko',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Vyberte zákazníka, na jehož panelu zákazníka chcete vytvořit uživatelské tlačítko, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Tlačítko vytvořte kliknutím na Dokončit.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Změnit vlastnosti tlačítka na panelu zákazníka.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Vlastnosti',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Změnit vlastnosti tlačítka na panelu zákazníka',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Změnit vlastnosti uživatelského tlačítka',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož uživatelské tlačítko chcete upravit, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Vyberte uživatelské tlačítko, které chcete upravit, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Po dokončení úprav vlastností tlačítka potvrďte změny kliknutím na Dokončit a ukončete průvodce.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Vytvořit nedostupnost tlačítka %1 pro vaše zákazníky.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Vytvořit nedostupnost pro vaše zákazníky',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Vytvořit nedostupnost tlačítka %1 pro vaše zákazníky',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Zviditelnit tlačítko %1 pro uživatele zákazníka.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Zpřístupnit pro vaše zákazníky',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Zviditelnit tlačítko %1 pro uživatele zákazníka',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Udělat uživatelské tlačítko dostupné/nedostupné pro vaše zákazníky.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostupný/nedostupný pro vaše zákazníky',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Udělat uživatelské tlačítko dostupné či nedostupné pro vaše zákazníky',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Udělat uživatelské tlačítko dostupné/nedostupné pro vaše zákazníky.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož uživatelské tlačítko chcete zpřístupnit pro uživatele zákazníka, a klikněte na Další>>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Vyberte uživatelské tlačítko, které chcete udělat dostupné či nedostupné pro vaše zákazníky, a klikněte na Další>>.',

    'ui__client/domain__description' => 'Spravovat doménu %1.',
    'ui__client/domain__disabled-warning' => 'Doména %1 je pozastavena.',
    'ui__client/domain__none-available' => 'Nemáte žádné domény.',
    'ui__client/domain__none-available__1' => 'Účet %1 nemá žádné domény.',
    'ui__client/domain__none-available__2' => 'Účet %1 nemá žádné domény.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Doména %1',
    'ui__client/domain_self__description' => 'Spravovat svou doménu.',
    'ui__client/domain_self__disabled-warning' => 'Vaše doména je pozastavena.',
    'ui__client/domain_self__quick-search' => 'Moje domény',
    'ui__client/domain_self__short-title' => 'Moje doména',
    'ui__client/domain_self__title' => 'Moje doména',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Na panelu zákazníka nejsou žádná uživatelská tlačítka.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Zákazník %1 nemá na panelu zákazníka žádná uživatelská tlačítka.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Nejsou žádná uživatelská tlačítka pro doménu %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Odebrat uživatelské tlačítko %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Odebrat',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Odebrat uživatelské tlačítko %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Odebrat uživatelská tlačítka.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Odebrat',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Odebrat uživatelská tlačítka.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Odebrat uživatelská tlačítka.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Vyberte zákazníka, z jehož panelu správy domény chcete odebrat tlačítka, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Vyberte doménu, z jejíž panelu správy chcete odebrat tlačítka, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Vyberte tlačítka, které chcete odebrat, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Zaškrtnutím příslušných políček potvrďte odebrání tlačítek a kliknutím na Dokončit tlačítka odeberte a ukončete průvodce.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Odebrat uživatelské tlačítko.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Odebrat',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Odebrat uživatelské tlačítko',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Odebrat uživatelské tlačítko',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Vyberte zákazníka, z jehož panelu správy domény chcete odebrat uživatelské tlačítko, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Vyberte doménu, z jejíž panelu správy chcete odebrat tlačítko, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Vyberte uživatelské tlačítko, které chcete odebrat, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Zaškrtnutím políčka potvrďte odebrání uživatelského tlačítka a kliknutím na Ukončit tlačítko odeberte a ukončete průvodce.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Změnit vlastnosti uživatelského tlačítka %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Vlastnosti",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Změnit vlastnosti uživatelského tlačítka %1 na panelu zákazníka.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Přidat tlačítko',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Vyberte zákazníka, na jehož panelu zákazníka chcete umístit tlačítko, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Vyberte předplatné, na kterém chcete upravit tlačítko, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Kliknutím na Dokončit vytvořte tlačítko a ukončete průvodce.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Změnit vlastnosti tlačítka na panelu zákazníka.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Vlastnosti',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Změnit vlastnosti tlačítka na panelu zákazníka',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Změnit vlastnosti tlačítka',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Vyberte uživatelské tlačítko, jehož nastavení chcete upravit, a klikněte na Další>>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Po dokončení změn vlastností tlačítka klikněte na Dokončit, uplatněte změny a ukončete průvodce.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Vytvořit nedostupnost tlačítka %1 pro uživatele e-mailu pod touto doménou.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Nedostupné pro uživatele e-mailu',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Vytvořit nedostupnost tlačítka %1 pro uživatele e-mailu pod touto doménou',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Zviditelnit tlačítko %1 uživatelům e-mailu pod doménou.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Přístupné pro uživatele e-mailu pod touto doménou',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Zviditelnit uživatelské tlačítko %1 uživatelům e-mailu pod touto doménou',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Udělat uživatelské tlačítko dostupné či nedostupné ostatním uživatelům.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostupný/nedostupný ostatním uživatelům',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Udělat uživatelské tlačítko dostupné či nedostupné uživatelům e-mailu',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Udělat uživatelské tlačítko dostupné či nedostupné ostatním uživatelům',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Vyberte doménu, na které je umístěno tlačítko, a klikněte na Další>>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Vyberte tlačítko, které chcete udělat dostupné či nedostupné ostatním uživatelům, a klikněte na Další>>.',

    'ui__client/domain/delete__description' => 'Odebrat doménu %1.',
    'ui__client/domain/delete__short-title' => 'Odebrat',
    'ui__client/domain/delete__title' => 'Odebrat doménu %1',
    'ui__client/domain/delete_multi__description' => 'Odebrat domény.',

    'ui__client/domain/delete_multi__short-title' => 'Odebrat',
    'ui__client/domain/delete_multi__title' => 'Odebrat domény',
    'ui__client/domain/delete_multi__wizard-title' => 'Odebrat domény',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Vyberte domény, které chcete odebrat, a klikněte na Další >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Zaškrtnutím políčka potvrďte odebrání domén a kliknutím na Dokončit je odeberte a ukončete průvodce.',
    'ui__client/domain/delete_unknown__description' => 'Odebrat doménu.',
    'ui__client/domain/delete_unknown__short-title' => 'Odebrat',
    'ui__client/domain/delete_unknown__title' => 'Odebrat doménu',
    'ui__client/domain/delete_unknown__wizard-title' => 'Odebrat doménu',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Vyberte doménu, kterou chcete odebrat, a klikněte na Další >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Zaškrtnutím políčka potvrďte odebrání domény a kliknutím na Dokončit ji odeberte a ukončete průvodce.',

    'ui__client/domain/hosting__none-available' => 'Žádné domény s nakonfigurovaným webhostingem. Abyste měli přístup k těmto funkcím, vytvořte doménu a nakonfigurujte na ní webhosting.',
    'ui__client/domain/hosting__none-available__1' => 'Tento uživatelský účet nemá žádné domény s nakonfigurovaným webhostingem. Abyste měli přístup k těmto funkcím, vytvořte doménu a nakonfigurujte na ní webhosting.',
    'ui__client/domain/hosting__none-available__2' => 'Web hosting není nakonfigurován pro doménu %1. Abyste měli přístup k těmto funkcím, nakonfigurujte webhosting na doméně %1.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Zákazníci",
    'ui__client/domain/hosting/application#list_header__description__title' => "Popis",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Položek",
    'ui__client/domain/hosting/application#list_header__name__title' => "Jméno",
    'ui__client/domain/hosting/application#list_header__release__title' => "Uvolnit",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Seřadit podle zákazníků",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Seřadit podle popisu",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Seřadit podle položek",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Řadit podle názvu",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Seřadit podle vydání",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Seřadit podle verzí",
    'ui__client/domain/hosting/application#list_header__title' => "Webové aplikace",
    'ui__client/domain/hosting/application#list_header__version__title' => "Verze",

    'rpt_reseller_section_general' => 'Obecné',
    'rpt_reseller_section_domains' => 'Domény',
    'rpt_reseller_section_clients' => 'Zákazníci',
    'statistics__cl_active_domains' => "Aktivní domény",
    'rpt_reseller_cl_domains' => "Domény",
    'rpt_reseller_cl_subdomains' => "Subdomény",
    'by__cl_domains' => "domény klientů",
    'dom_ctrl__cl_mboxes' => "Poštovní schránky",
    'rpt_reseller_cl_redirects' => "Servery pro předávání",
    'rpt_reseller_cl_mail_groups' => "E-mailové skupiny",
    'rpt_reseller_cl_mail_resps' => "Automatické odpovědi",
    'rpt_reseller_cl_mail_lists' => "Seznamy adresátů",
    'rpt_reseller_cl_web_users' => "Uživatelé webu",
    'rpt_reseller_cl_data_bases' => "Databáze",

    'statistics__active_clients' => 'Zákazníci s aktivními předplacenými službami',
    'statistics__clients_active_domains' => 'Aktivní domény',
    'statistics__clients_doms' => 'Domény',
    'statistics__cl_doms' => 'Domény',
    '__clients_subdomains' => 'Subdomény',
    '__clients_domains' => 'Domény',
    'dom_ctrl__clients_mboxes' => 'Poštovní schránky',
    'dom_ctrl__clients_redir' => 'Servery pro předávání',
    'dom_ctrl__clients_mg' => 'E-mailové skupiny',
    'dom_ctrl__clients_resp' => 'Automatické odpovědi',
    'dom_ctrl__clients_maillists' => 'Seznamy adresátů',
    'dom_ctrl__clients_wu' => 'Uživatelé webu',
    'dom_ctrl__clients_db' => 'Databáze',

    'dom_ctrl__cl_redir' => 'Servery pro předávání', // to resolve!
    'dom_ctrl__cl_mg' => 'E-mailové skupiny', // to resolve!
    'dom_ctrl__cl_resp' => 'Automatické odpovědi', // to resolve!
    'dom_ctrl__cl_maillists' => 'Seznamy adresátů', // to resolve!
    'dom_ctrl__cl_wu' => 'Uživatelé webu', // to resolve!
    'dom_ctrl__cl_db' => 'Databáze', // to resolve!

    'rpt_cl_section_clients' => 'Zákazníci',

    'rpt_admin_section_general' => 'Obecné',
    'rpt_admin_section_resellers' => 'Distributoři',
    'rpt_admin_section_clients' => 'Zákazníci',
    'rpt_admin_section_personal_clients' => 'Vlastní zákazníci',
    'rpt_admin_section_domains' => 'Domény',
    'rpt_admin_section_personal_domains' => 'Osobní domény',

    'rpt_reseller_section_personal_domains' => 'Osobní domény',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Vybrat doménu, kterou chcete pozastavit nebo aktivovat.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Pozastavit nebo aktivovat doménu',

    'ui__client/ip-pool__description' => 'Přiřadit a odebrat přiřazení IP adres a certifikátů SSL/TLS zákazníkovi %1.',
    'ui__client/ip-pool__short-title' => 'Fond IP adres',
    'ui__client/ip-pool__title' => 'Fond IP adres zákazníka %1',
    'ui__client/ip-pool_self__description' => 'Zobrazit svůj fond IP adres.',
    'ui__client/ip-pool_self__short-title' => 'Fond IP adres',
    'ui__client/ip-pool_self__title' => 'Můj fond IP adres',
    'ui__client/ip-pool/properties__description' => 'Nastavit fond IP adres pro zákazníka %1.',

    'ui__client/ip-pool/properties__short-title' => 'Fond IP adres',
    'ui__client/ip-pool/properties__title' => 'Nastavit fond IP adres pro zákazníka %1',
    'ui__client/ip-pool/properties_self__description' => 'Zobrazit svůj fond IP adres.',

    'ui__client/ip-pool/properties_self__short-title' => 'Můj fond IP adres',
    'ui__client/ip-pool/properties_self__title' => 'Můj fond IP adres',
    'ui__client/ip-pool/properties_unknown__description' => 'Přiřadit IP adresy a certifikáty SSL/TLS zákazníkovi nebo jejich přiřazení odebrat.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Fond IP adres',
    'ui__client/ip-pool/properties_unknown__title' => 'Nastavit fond IP adres zákazníka',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Nastavit fond IP adres zákazníka',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož fond IP adres chcete konfigurovat.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Po dokončení konfigurace fondu IP adres uplatněte změny kliknutím na Dokončit a ukončete průvodce.',


    'ui__client/limits_readonly-unknown__description' => 'Zobrazit limity prostředků pro zákazníka.',
    'ui__client/limits_readonly-unknown__short-title' => 'Limity prostředků',
    'ui__client/limits_readonly-unknown__title' => 'Zobrazit limity prostředků pro účet zákazníka',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Zobrazit nebo změnit limity prostředků pro zákazníka',

    'ui__client/limits_unknown__wizard-title' => 'Zobrazit nebo změnit limity prostředků pro zákazníka',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Zvolit zákazníka, kterého potřebujete.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Zvolit zákazníka, kterého potřebujete.',
    'ui__client/limits_unknown__wizard__2' => 'Chcete-li přijmout změny, klikněte na Dokončit.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Pro ukončení průvodce klepněte na tlačítko Dokončit.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Pro ukončení průvodce klepněte na tlačítko Dokončit.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Pro ukončení průvodce klepněte na tlačítko Dokončit.',

    'ui__client/permissions_unknown__wizard-title' => 'Zobrazit nebo změnit oprávnění pro zákazníka',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Po prohlédnutí svých oprávnění uplatněte změny kliknutím na Dokončit a ukončete průvodce.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož oprávnění chcete zobrazit nebo změnit.',
    'ui__client/permissions_unknown__wizard__2' => 'Po dokončení změny v oprávněních zákazníka uplatněte změny kliknutím na Dokončit a ukončete průvodce.',

    'ui__client/preferences_unknown__wizard-title' => 'Upravit předvolby zákazníka',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož relaci a předvolby rozhraní chcete spravovat.',
    'ui__client/preferences_unknown__wizard__2' => 'Po dokončení změn předvoleb zákazníka klikněte na Dokončit.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Po dokončení změn svých předvoleb klikněte na Dokončit.',

    'ui__custom-buttons/custom-button__none-available' => 'Nemáte žádná uživatelská tlačítka.',
    'ui__custom-buttons/custom-button/delete__description' => 'Odebrat uživatelské tlačítko %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Odebrat',
    'ui__custom-buttons/custom-button/delete__title' => 'Odebrat uživatelské tlačítko %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Odebrat uživatelská tlačítka.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Odebrat',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Odebrat uživatelská tlačítka.',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Odebrat uživatelská tlačítka.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Vyberte tlačítka, která chcete odebrat.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Zaškrtnutím políčka potvrďte odebrání tlačítek a kliknutím na Dokončit ukončete průvodce.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Odebrat uživatelská tlačítka.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Odebrat',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Odebrat uživatelská tlačítka.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Odebrat uživatelská tlačítka.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Vyberte uživatelské tlačítko, které chcete odebrat.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Zaškrtnutím políčka potvrďte odebrání tlačítka a kliknutím na Dokončit ukončete průvodce.',
    'ui__custom-buttons/custom-button/properties__description' => 'Změnit vlastnosti tlačítka %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Vlastnosti',
    'ui__custom-buttons/custom-button/properties__title' => 'Změnit vlastnosti tlačítka %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Vytvořit tlačítko',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Tlačítko vytvořte kliknutím na Dokončit.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Změnit vlastnosti uživatelského tlačítka.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Vlastnosti',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Změnit vlastnosti uživatelského tlačítka',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Změnit vlastnosti uživatelského tlačítka',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Vyberte uživatelské tlačítko, jehož vlastnosti chcete změnit.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Chcete-li přijmout změny, klikněte na Dokončit.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Vytvořit nedostupnost uživatelského tlačítka %1 ostatním uživatelům.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Nedostupné ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Vytvořit nedostupnost uživatelského tlačítka %1 ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Vytvořit nedostupnost uživatelského tlačítka %1 ostatním uživatelům.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Dostupné ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Vytvořit nedostupnost uživatelského tlačítka %1 ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Udělat uživatelské tlačítko dostupné či nedostupné ostatním uživatelům.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostupné nebo nedostupné ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Udělat uživatelské tlačítko dostupné či nedostupné ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Udělat uživatelské tlačítko dostupné či nedostupné ostatním uživatelům',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Vyberte uživatelské tlačítko, které chcete udělat dostupné či nedostupné pro ostatní uživatele, a klikněte na Další>>.',

    'ui__longtasks#list_header__name__title' => "Jméno",
    'ui__longtasks#list_header__owner__title' => "Vlastník",
    'ui__longtasks#list_header__start_time__title' => "Čas vytvoření",
    'ui__longtasks#list_header__status__title' => "Stav",
    'ui__longtasks#list_header__title' => "Úlohy",
    'ui__longtasks#list_header__finish_time__title' => "Čas dokončení",
    'ui__longtasks#task_list_legend__title' => "Úlohy",
    'ui__longtasks#tools_legend__title' => "Nástroje",
    'ui__longtasks__description' => "Spravovat úlohy na pozadí",
    'ui__longtasks__short-title' => "Úlohy na pozadí",
    'ui__longtasks__title' => "Úlohy na pozadí",
    'ui__longtasks/longtask/properties#current_operation__title' => "Aktuální operace",
    'ui__longtasks/longtask/properties#finish_time__title' => "Odhadovaný čas dokončení:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Obecné",
    'ui__longtasks/longtask/properties#owner__title' => "Úlohu spustil:",
    'ui__longtasks/longtask/properties#progress__title' => "Celkový průběh:",
    'ui__longtasks/longtask/properties#start_time__title' => "Úloha spuštěna:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Stav úlohy",
    'ui__longtasks/longtask/properties__description' => "Stav a informace úlohy na pozadí",

    'ui__longtasks/properties__description' => "Nastavení úloh na pozadí",
    'ui__longtasks/properties__short-title' => "Nastavení",
    'ui__longtasks/properties__title' => "Úlohy na pozadí",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Šablony hromadných e-mailových zpráv',
    'ui__mass-mail/template#list_header__name__title' => 'Název šablony',
    'ui__mass-mail/template#list_header__from_email__title' => 'Odesílatel',
    'ui__mass-mail/template#list_header__to__title' => 'Příjemci',
    'ui__mass-mail/template#list_header__subject__title' => 'Předmět',
    'ui__mass-mail/template#list_header__cdate__title' => 'Datum vytvoření',
    'ui__mass-mail/template#list_header__send__title' => 'Odeslat',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Upravit šablonu hromadných e-mailových zpráv',
    'ui__mass-mail/template/properties__description' => 'Upravit tuto šablonu hromadných e-mailových zpráv.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Přidat šablonu hromadných e-mailových zpráv',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Přidat šablonu hromadných e-mailových zpráv',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Přidat šablonu hromadných e-mailových zpráv.',
    'ui__mass-mail/send__short-title' => 'Odeslat hromadný e-mail',
    'ui__mass-mail/send__title' => 'Odeslat hromadnou e-mailovou zprávu',
    'ui__mass-mail/send__description' => 'Odeslat hromadnou e-mailovou zprávu vybraným příjemcům.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Odebrat šablony pro hromadný e-mail',
    'ui__mass-mail/template/delete_multi__title' => 'Odebrat tyto šablony hromadných e-mailových zpráv:',
    'ui__mass-mail/template/delete_multi__description' => 'Odebrat vybrané šablony pro hromadné e-mailové zprávy.',
    'ui__mass-mail/template/delete_multi__done' => 'Vybrané šablony zpráv byly odebrány.',
    'ui__mass-mail/template/properties__invalid_values' => 'Byla zadána neplatná hodnota',


    // old
    'ui__mass-mail#body_text__description' => 'Můžete použít <name> proměnnou v textu zprávy (ale ne v hlavičce). Bude nahrazeno kontaktním jménem zákazníka nebo prodejce.',
    'ui__mass-mail#body_text__title' => 'Text zprávy',
    'ui__mass-mail#compose_legend__title' => 'Zpráva',
    'ui__mass-mail#from_email_text__title' => 'Od (e-mailová adresa):',
    'ui__mass-mail#list_header__cdate__title' => 'Vytvořeno',
    'ui__mass-mail#list_header__from_email__title' => 'Od',
    'ui__mass-mail#list_header__name__title' => 'Jméno',
    'ui__mass-mail#list_header__send__title' => 'Vytvořit zprávu',
    'ui__mass-mail#list_header__subject__title' => 'Předmět',
    'ui__mass-mail#list_header__title' => 'Šablony hromadných e-mailových zpráv',
    'ui__mass-mail#list_header__to__title' => 'Pro',
    'ui__mass-mail#list_legend__title' => 'Šablony hromadných e-mailových zpráv',
    'ui__mass-mail#load_template_text__title' => 'Načtení',
    'ui__mass-mail#name_text__title' => 'Název šablony',
    'ui__mass-mail#option_mode_all__title' => 'Všechno',
    'ui__mass-mail#option_mode_except__title' => 'Vše kromě vybraných',
    'ui__mass-mail#option_mode_select__title' => 'Pouze vybrané',
    'ui__mass-mail#option_select_template__title' => '---Vybrat šablonu---',
    'ui__mass-mail#picker_legend__title' => 'Šablony e-mailové zprávy',
    'ui__mass-mail#picker_title__title' => 'Vybrat šablonu',
    'ui__mass-mail#save_as_legend__title' => 'Uložit jako šablonu',
    'ui__mass-mail#save_as_text__title' => 'Uložit složenou zprávu do nové šablony s názvem',
    'ui__mass-mail#subject_text__title' => 'Předmět',
    'ui__mass-mail#template_legend__title' => 'Šablona',
    'ui__mass-mail#to_admin_text__title' => 'Správce prostředí Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Zákazníci',
    'ui__mass-mail#to_domains_text__title' => 'Správci domény',
    'ui__mass-mail#to_select_text__title' => 'Vybrat adresy',
    'ui__mass-mail#to_show_hide_text__title' => 'Zobrazit/Skrýt vybrané',
    'ui__mass-mail#to_text__title' => 'Pro',
    'ui__mass-mail#tools_legend__title' => 'Nástroje',
    'ui__mass-mail__already_exists' => 'Šablona s názvem %1 již existuje.',
    'ui__mass-mail__none-available' => 'Nemáte žádné šablony zpráv.',

    'ui__mass-mail/delete__description' => 'Odebrat šablonu hromadných e-mailových zpráv %1',

    'ui__mass-mail/delete__empty_selection' => 'Vyberte šablonu, kterou chcete odebrat.',
    'ui__mass-mail/delete__short-title' => 'Odstranit %1',
    'ui__mass-mail/delete__title' => 'Odebrat šablonu hromadných e-mailových zpráv %1',
    'ui__mass-mail/delete_multi__description' => 'Odebrat šablony hromadných e-mailových zpráv.',

    'ui__mass-mail/delete_multi__short-title' => 'Odebrat',
    'ui__mass-mail/delete_multi__title' => 'Odebrat šablony hromadných e-mailových zpráv',
    'ui__mass-mail/delete_multi__wizard-title' => 'Odebrání šablon hromadných e-mailových zpráv',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Vyberte šablony hromadných e-mailových zpráv, které chcete odebrat.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Zaškrtnutím políčka potvrďte odebrání šablon a kliknutím na Dokončit ukončete průvodce.',
    'ui__mass-mail/delete_unknown__description' => 'Odebrat šablony hromadných e-mailových zpráv.',
    'ui__mass-mail/delete_unknown__short-title' => 'Odebrat',
    'ui__mass-mail/delete_unknown__title' => 'Odebrat šablony hromadných e-mailových zpráv',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Odebrání šablon hromadných e-mailových zpráv.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Vyberte šablonu hromadných e-mailových zpráv, kterou chcete odebrat.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Zaškrtnutím políčka potvrďte odebrání šablony a kliknutím na Dokončit ukončete průvodce.',

    'ui__mass-mail/properties__description' => 'Upravit šablonu e-mailových zpráv %1.',

    'ui__mass-mail/properties__invalid_values' => 'Zadané hodnoty jsou nesprávné',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Upravit šablonu e-mailových zpráv %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Vytvořit šablonu hromadných e-mailových zpráv',
    'ui__mass-mail/properties_unknown-new__description' => 'Vytvořit šablonu e-mailových zpráv.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Přidat šablonu e-mailových zpráv',
    'ui__mass-mail/properties_unknown-new__title' => 'Vytvořit šablonu e-mailových zpráv',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Upravit šablonu hromadných e-mailových zpráv',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Vyberte šablonu, kterou chcete upravit, a klikněte na Další>>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Po dokončení úprav šablony uplatněte změny kliknutím na Dokončit a ukončete průvodce.',

    'ui__mass-mail/send__invalid_values' => 'Zadali jste nesprávné hodnoty',

    'ui__mass-mail/send_new__wizard-title' => 'Vytvořit šablonu zprávy a odeslat e‑mail',
    'ui__mass-mail/send_unknown-new__description' => 'Odeslat e-mail vybraným příjemcům',

    'ui__mass-mail/send_unknown-new__short-title' => 'Odeslat hromadný e-mail',
    'ui__mass-mail/send_unknown-new__title' => 'Odeslat hromadnou e-mailovou zprávu',
    'ui__mass-mail/send_unknown__description' => 'Odeslat e-mail vybraným příjemcům',

    'ui__mass-mail/send_unknown__short-title' => 'Odeslat hromadný e-mail',
    'ui__mass-mail/send_unknown__title' => 'Odeslat hromadnou e-mailovou zprávu',
    'ui__mass-mail/send_unknown__wizard-title' => 'Odeslat hromadnou e-mailovou zprávu',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Vyberte šablonu, kterou potřebujete, a klikněte na Další>>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Po dokončení úprav vlastností šablony odešlete zprávu kliknutím na Dokončit a ukončete průvodce.',

    'ui__mass-email/delete__description' => 'Odebrat vybrané šablony pro hromadné e-mailové zprávy.',

    'ui__mass-email/delete__empty_selection' => "Vyberte šablony, které chcete odebrat.",
    'ui__mass-email/delete__short-title' => "Odstranit %1",
    'ui__mass-email/delete__title' => "Odebrat šablonu hromadných e-mailových zpráv %1",
    'ui__mass-email/delete_multi__description' => "Odebrat šablony hromadných e-mailových zpráv.",

    'ui__mass-email/delete_multi__short-title' => "Odebrat",
    'ui__mass-email/delete_multi__title' => "Odebrat šablony hromadných e-mailových zpráv",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Zaškrtnutím políčka potvrďte odebrání šablon a kliknutím na Dokončit ukončete průvodce.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Vyberte šablony hromadných e-mailových zpráv, které chcete odebrat.",
    'ui__mass-email/delete_multi__wizard-title' => "Odebrání šablon hromadných e-mailových zpráv",
    'ui__mass-email/delete_unknown__description' => "Odebrat šablony hromadných e-mailových zpráv.",
    'ui__mass-email/delete_unknown__short-title' => "Odebrat",
    'ui__mass-email/delete_unknown__title' => "Odebrat šablony hromadných e-mailových zpráv",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Zaškrtnutím políčka potvrďte odebrání šablony a kliknutím na Dokončit ukončete průvodce.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Vyberte šablonu hromadných e-mailových zpráv, kterou chcete odebrat.",
    'ui__mass-email/delete_unknown__wizard-title' => "Odebrání šablon hromadných e-mailových zpráv.",
    'ui__mass-email/send__description' => "Odeslat e-mail vybraným příjemcům",
    'ui__mass-email/send__short-title' => "Odeslat hromadný e-mail",
    'ui__mass-email/send__title' => "Odeslat hromadnou e-mailovou zprávu",
    'ui__mass-email/send_main__description' => "Odeslat e-mail vybraným příjemcům",

    'ui__mass-email/send_main__short-title' => "Odeslat hromadný e-mail",
    'ui__mass-email/send_main__title' => "Odeslat hromadnou e-mailovou zprávu",
    'ui__mass-email/send_selectresellers__title' => 'Vybrat prodejce',
    'ui__mass-email/send_selectresellers__short-title' => 'Distributoři',
    'ui__mass-email/send_selectresellers__description' => 'Vybrat účty prodejce',

    'ui__mass-email/send_selectclients__description' => "Vybrat zákaznické účty",

    'ui__mass-email/send_selectclients__short-title' => "Zákazníci",
    'ui__mass-email/send_selectclients__title' => "Vybrat zákazníky",
    'ui__mass-email/send_selectdomainusers__description' => "Vybrat účty správce domény",

    'ui__mass-email/send_selectdomainusers__short-title' => "Správci domény",
    'ui__mass-email/send_selectdomainusers__title' => "Vybrat správce domény",
    'ui__mass-email/template/properties_main__description' => "Vytvořit šablonu hromadných e-mailových zpráv",
    'ui__mass-email/template/properties_main__short-title' => "Upravit šablonu",
    'ui__mass-email/template/properties_main__title' => "Upravit šablonu hromadných e-mailových zpráv",
    'ui__mass-email/template/properties_new-main__description' => "Vytvořit šablonu pro hromadné e-mailové zprávy.",
    'ui__mass-email/template/properties_new-main__short-title' => "Vytvořit šablonu hromadných e-mailových zpráv",
    'ui__mass-email/template/properties_new-main__title' => "Vytvořit šablonu hromadných e-mailových zpráv",
    'ui__mass-email/template/properties_new-selectclients__description' => "Vybrat zákazníky, kteří by měli přijímat hromadné e-mailové zprávy založené na této šabloně",
    'ui__mass-email/template/properties_new-selectclients__title' => "Vybrat zákazníky, kteří by měli přijímat hromadné e-mailové zprávy založené na této šabloně",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Vybrat správce domény, kteří by měli přijímat hromadné e-mailové zprávy založené na této šabloně.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Vybrat správce domény, kteří by měli přijímat hromadné e-mailové zprávy založené na této šabloně.",
    'ui__mass-email/template/properties_selectclients__title' => "Vybrat zákazníky, kteří by měli přijímat hromadné e-mailové zprávy založené na této šabloně",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Vybrat správce domény, kteří by měli přijímat hromadné e-mailové zprávy založené na této šabloně.",

    'ui__mass-email/template/properties_unknown-new__description' => "Vytvořit šablonu hromadných e-mailových zpráv",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Vytvořit šablonu",
    'ui__mass-email/template/properties_unknown-new__title' => "Vytvoření šablony hromadných e-mailových zpráv",
    'ui__news/dismiss__description' => 'Kliknutím uzavřete podokno novinek. Plesk nezobrazí toto podokno, dokud nebudou články novinek aktualizovány.',

    'ui__news/dismiss__title' => 'Zavřít novinky',

    'ui__server__description' => 'Správa serveru.',
    'ui__server__short-title' => 'Správa serveru',
    'ui__server__title' => 'Správa serveru',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP adresa %1 je nedostupná.',
    'ui__server/ip-address__none-available' => 'Nejsou dostupné žádné IP adresy.',
    'ui__server/ip-addresses/ip-address__title' => "IP adresy",
    'ui__server/ip-address/client/properties_new__description' => "Přiřadit IP adresu %1 prodejcům.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Přiřadit',
    'ui__server/ip-address/client/properties_new__title' => "Přiřadit IP adresu %1 prodejcům",
    'ui__server/ip-address/client__none-available' => 'Neexistují žádné uživatelské účty',
    'ui__server/ip-address/client_unknown__quick_search' => 'Uživatelé',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Seznam uživatelů, kteří používají tuto IP adresu.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Vyberte IP adresu.',
    'ui__server/ip-address/client/delete__description' => 'Odebrat přiřazení IP adresy prodejci.',
    'ui__server/ip-address/client/delete__short-title' => 'Odebrat přiřazení',
    'ui__server/ip-address/client/delete__title' => 'Odebrat přiřazení IP adresy prodejci',
    'ui__server/ip-address/client/delete_multi__description' => "Odebrat přiřazení IP adresy z fondů prodejce.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Odebrat přiřazení',
    'ui__server/ip-address/client/delete_multi__title' => 'Odebrat přiřazení IP adresy prodejci',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Odebrat IP adresu z fondů uživatelů.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Vyberte IP adresu, jejíž přiřazení chcete odebrat uživatelům, a klikněte na Další>>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Vyberte uživatele, kterým chcete odebrat přiřazení IP adresy, a klikněte na Další>>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Zaškrtnutím políčka potvrďte odebrání přiřazení IP adresy uživatelům a kliknutím na Dokončit ukončete průvodce.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Odebrat přiřazení IP adresy prodejcům.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Odebrat přiřazení',
    'ui__server/ip-address/client/delete_unknown__title' => 'Odebrat přiřazení IP adresy prodejcům',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Odebrat přiřazení IP adresy uživatelům',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Vyberte IP adresu, jejíž přiřazení chcete odebrat uživatelům, a klikněte na Další>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Vyberte uživatele, kterému chcete odebrat přiřazení IP adresy, a klikněte na Další>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Zaškrtnutím políčka potvrďte odebrání přiřazení IP adresy uživatelům a kliknutím na Dokončit ukončete průvodce.',

    'ui__server/ip-address/domain__description' => "Všechny domény na IP adrese %1.",
    'ui__server/ip-address/domain__short-title' => "Domény",
    'ui__server/ip-address/domain__title' => "Domény na IP adrese %1",
    'ui__server/ip-address/domain_unknown__description' => "Všechny domény na IP adrese.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domény",
    'ui__server/ip-address/domain_unknown__title' => "Domény na IP adrese",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Vyberte IP adresu, kterou potřebujete, a klikněte na Další>>.",

    'ui__server/ip-address/properties__description' => 'Změnit vlastnosti IP adresy %1.',
    'ui__server/ip-address/properties__short-title' => 'Vlastnosti',
    'ui__server/ip-address/properties__title' => 'Změnit vlastnosti IP adresy %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Přidat IP adresu',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Až dokončíte změnu vlastností IP adresy, uplatněte změny kliknutím na Dokončit.',
    'ui__server/ip-address/properties_unknown__description' => 'Změnit vlastnosti IP adresy.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Vlastnosti',
    'ui__server/ip-address/properties_unknown__title' => 'Změnit vlastnosti IP adresy',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Změnit vlastnosti IP adresy',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Vyberte IP adresu, jejíž vlastnosti chcete změnit.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Až dokončíte změnu vlastností IP adresy, uplatněte změny kliknutím na Dokončit.',

    'ui__server/spam-filter/black-list__description' => 'Nastavit černou listinu filtru nevyžádané pošty pro celý server.',
    'ui__server/spam-filter/black-list__short-title' => 'Černá listina',
    'ui__server/spam-filter/black-list__title' => 'Černá listina filtru nevyžádané pošty pro celý server',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Bude přidáno pouze %1 prvních jedinečných e-mailových adres.',
    'ui__server/spam-filter/black-list/address__description' => 'Adresa z černé listiny filtru nevyžádané pošty.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'V seznamu nejsou žádné emailové adresy.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Odeslaný soubor je prázdný.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Následující e-mailové adresy jsou neplatné: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Na černé listině filtru nevyžádané pošty nejsou žádné adresy.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adresa',
    'ui__server/spam-filter/black-list/address__title' => 'Adresa %1 na černé listině',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Přidat adresy na černou listinu.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Přidat adresy',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Přidat adresy na černou listinu',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Odebrat adresu %1 z černé listiny pro celý server.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Odebrat',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Odebrat adresu %1 z černé listiny pro celý server',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Odebrat adresy z černé listiny pro celý server.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Odebrat',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Odebrat adresy z černé listiny pro celý server',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Odebrání adresy z černé listiny filtru nevyžádané pošty celého serveru',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Vyberte filtr nevyžádané pošty, který chcete odebrat, a klikněte na Další>>.',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Zaškrtnutím políčka potvrďte odebrání adres filtru nevyžádané pošty a kliknutím na Ukončit dokončete jejich odstranění a ukončete průvodce.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Odebrat adresu z černé listiny pro celý server.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Odebrat',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Odebrat adresu z černé listiny pro celý server',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Odebrání adresy z černé listiny filtru nevyžádané pošty celého serveru',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Vyberte adresu filtru nevyžádané pošty, který chcete odebrat, a klikněte na Další>>.',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Zaškrtnutím políčka potvrďte odebrání adresy filtru nevyžádané pošty a kliknutím na Ukončit dokončete její odstranění a ukončete průvodce.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Bude přidáno pouze %1 prvních jedinečných e-mailových adres.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'V seznamu nejsou žádné emailové adresy.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Soubor nelze nahrát. Maximální velikost souboru, který se má nahrát, je %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Následující e-mailové adresy jsou neplatné: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Přidat adresy na černou listinu.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Přidat adresy',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Přidat adresy na černou listinu',

    'ui__server/spam-filter/properties__description' => 'Nastavit filtr nevyžádané pošty pro celý server.',

    'ui__server/spam-filter/properties__short-title' => 'Nastavení',
    'ui__server/spam-filter/properties__title' => 'Nastavení filtru nevyžádané pošty',

    'ui__server/spam-filter/toggle_disable__description' => 'Zakázat filtrování nevyžádané pošty pro celý systém.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Zakázat',
    'ui__server/spam-filter/toggle_disable__title' => 'Zakázat filtrování nevyžádané pošty',
    'ui__server/spam-filter/toggle_enable__description' => 'Povolit filtrování nevyžádané pošty pro celý server.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Povolit',
    'ui__server/spam-filter/toggle_enable__title' => 'Povolit filtrování nevyžádané pošty',
    'ui__server/spam-filter/toggle_unknown__description' => 'Povolit nebo zakázat filtrování nevyžádané pošty pro celý server.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Povolit či zakázat',
    'ui__server/spam-filter/toggle_unknown__title' => 'Povolit nebo zakázat filtrování nevyžádané pošty',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Povolit nebo zakázat filtr nevyžádané pošty',

    'ui__server/spam-filter/white-list__description' => 'Nastavit bílou listinu filtru nevyžádané pošty celého systému.',
    'ui__server/spam-filter/white-list__short-title' => 'Bílá listina',
    'ui__server/spam-filter/white-list__title' => 'Bílá listina filtru nevyžádané pošty celého systému',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Bude přidáno pouze %1 prvních jedinečných e-mailových adres.',
    'ui__server/spam-filter/white-list/address__description' => 'Adresa z bílé listiny filtru nevyžádané pošty.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'V seznamu nejsou žádné emailové adresy.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Odeslaný soubor je prázdný.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Následující e-mailové adresy jsou neplatné: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Na bílé listině filtru nevyžádané pošty celého serveru nejsou žádné adresy.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adresa',
    'ui__server/spam-filter/white-list/address__title' => 'Adresa %1 na bílé listině',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Přidat adresy na bílou listinu.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Přidat adresy',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Přidat adresy na bílou listinu',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Odebrat adresu %1 z bílé listiny pro celý server.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Odebrat',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Odebrat adresu %1 z bílé listiny pro celý server',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Odebrat adresy z bílé listiny pro celý server.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Odebrat',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Odebrat adresy z bílé listiny pro celý server',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Odebrání adresy z bílé listiny filtru nevyžádané pošty celého serveru',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Vyberte filtr nevyžádané pošty, který chcete odebrat, a klikněte na Další>>.',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Zaškrtnutím políčka potvrďte odebrání adres filtru nevyžádané pošty a kliknutím na Ukončit dokončete jejich odstranění a ukončete průvodce.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Odebrat adresu z bílé listiny pro celý server.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Odebrat',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Odebrat adresu z bílé listiny pro celý server',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Odebrání adresy z bílé listiny filtru nevyžádané pošty celého serveru',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Vyberte adresu filtru nevyžádané pošty, který chcete odebrat, a klikněte na Další>>.',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Zaškrtnutím políčka potvrďte odebrání adresy filtru nevyžádané pošty a kliknutím na Ukončit dokončete její odstranění a ukončete průvodce.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Bude přidáno pouze %1 prvních jedinečných e-mailových adres.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'V seznamu nejsou žádné emailové adresy.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Soubor nelze nahrát. Maximální velikost souboru, který se má nahrát, je %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Následující e-mailové adresy jsou neplatné: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Přidat adresy na bílou listinu.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Přidat adresy',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Přidat adresy na bílou listinu',

    'ui__server/mail/statistics#apply__description' => "Použít filtr",
    'ui__server/mail/statistics#apply__title' => "Použít",
    'ui__server/mail/statistics#custom_from__title' => "od",
    'ui__server/mail/statistics#custom_to__title' => "pro",
    'ui__server/mail/statistics#period_all__title' => "Všechno",
    'ui__server/mail/statistics#period_custom__title' => "Vlastní",
    'ui__server/mail/statistics#period_month__title' => "Aktuální měsíc",
    'ui__server/mail/statistics#period_prev_month__title' => "Předchozí měsíc",
    'ui__server/mail/statistics#period_prev_week__title' => "Předchozí týden",
    'ui__server/mail/statistics#period_today__title' => "Dnes",
    'ui__server/mail/statistics#period_week__title' => "Aktuální týden",
    'ui__server/mail/statistics#period_yesterday__title' => "Včera",
    'ui__server/mail/statistics#show_for_period__title' => "Zobrazit za období",
    'ui__server/mail/statistics#tools_legend__title' => "Nástroje",
    'ui__server/mail/statistics__description' => "Zobrazit statistiky nevyžádané pošty a virů",

    'ui__server/mail/statistics__short-title' => "Statistiky",
    'ui__server/mail/statistics__title' => "Statistiky",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Statistiky nevyžádané pošty",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Nástroje",
    'ui__server/mail/statistics/spam__description' => "Zobrazit statistiky nevyžádané pošty",

    'ui__server/mail/statistics/spam__short-title' => "Statistiky nevyžádané pošty",
    'ui__server/mail/statistics/spam__title' => "Statistiky nevyžádané pošty",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "E-mailový alias",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% ze všech",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Seřadit podle e-mailového účtu",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Seřadit podle % všeho",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Seřadit podle přijaté nevyžádané pošty",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "Poštovní účty",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Přijatá nevyžádaná pošta",
    'ui__server/mail/statistics/spam/recipients__description' => "Příjemci",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Příjemci",
    'ui__server/mail/statistics/spam/recipients__title' => "Příjemci",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Vyčistit",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infikováno",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Stav",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% ze všech",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Počet",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Chráněno",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Nezkontrolováno",
    'ui__server/mail/statistics/spam/summary__description' => "Souhrn",

    'ui__server/mail/statistics/spam/summary__short-title' => "Souhrn",
    'ui__server/mail/statistics/spam/summary__title' => "Souhrn",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Statistiky virů",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Nástroje",
    'ui__server/mail/statistics/virus__description' => "Zobrazit statistiky virů",

    'ui__server/mail/statistics/virus__short-title' => "Statistiky virů",
    'ui__server/mail/statistics/virus__title' => "Statistiky virů",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Poštovní účet",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% ze všech",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Seřadit podle e-mailového aliasu",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Seřadit podle % všeho",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Seřadit podle přijatých virů",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Poštovní účty",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Přijaté viry",
    'ui__server/mail/statistics/virus/recipients__description' => "Příjemci",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Příjemci",
    'ui__server/mail/statistics/virus/recipients__title' => "Příjemci",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Vyčistit",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infikováno",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Stav",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% ze všech",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Počet",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Chráněno",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Nezkontrolováno",
    'ui__server/mail/statistics/virus/summary__description' => "Souhrn",

    'ui__server/mail/statistics/virus/summary__short-title' => "Souhrn",
    'ui__server/mail/statistics/virus/summary__title' => "Souhrn",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Jméno",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% ze všech",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Řadit podle názvu",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Seřadit podle % všeho",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Seřadit podle infikovaných objektů",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Viry",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Infikované objekty",
    'ui__server/mail/statistics/virus/viruses__description' => "Viry",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Viry",
    'ui__server/mail/statistics/virus/viruses__title' => "Viry",

    'ui__support#param_company__title' => "Společnost",
    'ui__support#param_email__title' => "E-mail",
    'ui__support#param_firstname__title' => "Křestní jméno",
    'ui__support#param_keynumber__title' => "Číslo klíče produktu",
    'ui__support#param_operatingsystem__title' => "Operační systém",
    'ui__support#param_phone__title' => "Telefon",
    'ui__support#param_psabuild__title' => "Sestavení Plesk",
    'ui__support#param_psainsttype__title' => "Typ instalace Plesk",
    'ui__support#param_psaversion__title' => "Verze Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Nástroje",

    'ui__reseller/traffic-history_unknown__short-title' => "Zobrazit přenos dat podle prodejců",
    'ui__reseller/traffic-history_unknown__title' => "Zobrazit přenos dat podle prodejců",
    'ui__reseller/traffic-history_unknown__description' => "Zobrazit přenos podle účtů prodejce.",
    'ui__reseller#list__title' => "Distributoři",
    'accounts_list__name__filter_title' => "Jméno",
    'accounts_list__resource__filter_title' => "Využití prostředků",
    'resellers_list__filter_resource_usage_any' => "Každý",
    'resellers_list__filter_resource_usage_overuse' => "Překročení limitu",
    'resellers_list__filter_resource_usage_normal' => "V rozsahu",
    'accounts_list__status__filter_title' => "Stav",
    'resellers_list__filter_status_any' => "Každý",
    'resellers_list__filter_status_blocked' => "Pozastaveno",
    'resellers_list__filter_status_active' => "Aktivní",
    'resellers_list__filter_clients__filter_title' => "Zobrazit",
    'resellers_list__filter_clients_on' => "Prodejci s jejich zákazníky",
    'resellers_list__filter_clients_off' => "Pouze prodejci",
    '__disk_usage' => "Využité místo na disku",
    'ui__reseller/traffic_unknown__short-title' => "Zobrazit přenos dat podle prodejců",
    'ui__reseller/traffic_unknown__title' => "Zobrazit přenos dat podle prodejců",
    'ui__reseller/traffic#list__title' => "Přenos podle prodejce",
    'ui__reseller/traffic_unknown__description' => "Zobrazit sestavy využití přenosu dat.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Přenos podle prodejce",

    '__reseller_name' => "Název prodejce",
    '__reseller' => "Distributoři",
    'resellertrafficlist_header' => "Zobrazit přenos dat podle prodejců",
    '__reseller_personal' => "Přenos využitý doménami prodejce",
    'ui__reseller/traffic-history__short-title' => "Přenos podle prodejců",
    'ui__reseller/traffic-history__title' => "Přenos podle prodejců",
    'ui__reseller/traffic-history__description' => "Zobrazit sestavy využití přenosu dat.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Povolit překročení nabídky",
    'limits__reseller_oversell_description' => "Překročení nabídky umožní prodejci prodat větší množství prostředků, než mu bylo ve skutečnosti přiděleno. Pokud je překročení nabídky povoleno, prodejce se místo výchozího přidělení prostředků řídí skutečným využitím prostředků",
    'limits__overuse_block_text' => "Zásady nadměrné využití",
    'limits__overuse_block_true_text' => "Nadměrné využití není povoleno",
    'limits__reseller_overuse_block_true_description' => "Blokovat nadměrné využití prostředků. Skutečné využití prostředků nemůže překročit výchozí přidělení prostředků",
    'limits__overuse_block_false_text' => "Nadměrné využití je povoleno",
    'limits__reseller_overuse_block_false_description' => "Neblokujte nadměrné využití prostředků, což prodejci umožní využít více prostředků, než bylo původně poskytnuto. Skutečné využití prostředků může překročit výchozí přidělení prostředků",
    'limits__reseller_overuse_notify_text' => "Upozornit prodejce na dosažení limitů prostředků",
    'reseller_perm__manage_sh_access_disabled' => "Prodejce nemůže povolit ani zakázat přístup přes shell",
    'reseller_perm__manage_sh_access_chrooted' => "Prodejce může povolit přístup pouze do prostředí typu chroot",
    'reseller_perm__manage_sh_access_any' => "Prodejce může povolit přístup k libovolnému typu prostředí",
    'template__reseller_num_excl_ips' => "Přidělit vyhrazené IP adresy prodejci",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Účet",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Zákazníci",
    'ui__reseller#domainsTab__title' => "Domény",
    'ui__reseller__title' => "Spravovat účet prodejce %1",
    'domains__reseller_info' => "%1 zákazníků, %2 domén, %3 využitého místa na disku, %4 přenesených dat.",
    'domains__reseller_info_hiding_traffic' => "%1 zákazníků, %2 domén, %3 využitého místa na disku.",
    'ui__reseller__description' => "Spravovat účet prodejce.",

    'ui__reseller/limits_unknown__wizard-title' => 'Zobrazit nebo změnit limity prostředků pro prodejce',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Zvolit prodejce, kterého potřebujete.',
    'ui__reseller/limits_unknown__wizard__2' => 'Chcete-li přijmout změny, klikněte na Dokončit.',

    'ui__client/report_reseller__short-title' => "Sestava",
    'ui__client/report_reseller__title' => "Zobrazit sestavu účtu",
    'ui__client/report_reseller__description' => "Zobrazit zprávu o účtu prodejce.",
    'ui__client/ip-pool_reseller__short-title' => "Fond IP adres",
    'ui__client/ip-pool_reseller__description' => "Přiřadit IP adresy a certifikáty SSL/TLS k účtu prodejce.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Zadejte nastavení účtu a klikněte na Dokončit .",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Zobrazit nebo změnit oprávnění pro prodejce',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Vyberte prodejce, jehož oprávnění chcete zobrazit nebo změnit.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Po dokončení změn oprávnění prodejce uplatněte změny kliknutím na Dokončit a ukončete průvodce.',

    // Customers > create customer account

    '__resellers_list' => 'Distributoři',
    'picker_reseller__title' => 'Vybrat prodejce',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Nástroje",
    'ui__client#tools2__title' => "Účet",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Zákazníci",
    'ui__client#domainslist__title' => "Domény",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Všechny webové aplikace jsou nyní seřazeny podle kategorií, což usnadňuje výběr správné aplikace pro instalaci.",
    'feature__domainkeys__reseller' => "Ke snížení množství nevyžádané pošty a e-mailových útoků phishing můžete použít ověřovací mechanismus antispamové ochrany DKIM pro odesílatele e-mailu.",

    '__reseller_form' => "Formulář prodejce",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Vyberte účet zákazníka, jehož nastavení chcete změnit.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Chcete-li změnit limity využití prostředků, klikněte na Limity prostředků.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Chcete-li změnit oprávnění pro operace, které může zákazník provádět v prostředí Plesk, klikněte na položku Oprávnění.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Zpřístupnit tuto šablonu ostatním uživatelům.",
    'template__shared_description' => "Zvolte tuto možnost, pokud chcete, aby vaši zákazníci mohli používat tuto šablonu.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Nástroje',

    'ui__client/traffic-history_unknown__short-title' => 'Zobrazit přenosu dat podle zákazníků',
    'ui__client/traffic-history_unknown__title' => 'Přenos dat podle zákazníků',
    'ui__client/traffic-history_unknown__description' => 'Zobrazit sestavu využití přenosu dat pro všechny zákazníky',
    'ui__client/traffic-history__short-title' => 'Přenos dat podle zákazníků',
    'ui__client/traffic-history__title' => 'Zobrazit přenosu dat podle zákazníků',
    'ui__client/traffic-history__description' => 'Zobrazit sestavu využití přenosu dat pro všechny zákazníky',

    'ui__client/traffic#list__title' => 'Přenos dat podle zákazníků',
    'ui__reseller/client/traffic#list__title' => 'Přenos dat podle zákazníků',

    'clients_list__filter_type__filter_title' => 'Zobrazit',
    'clients_list__filter_type_any' => 'Zákazníci a prodejci',
    'clients_list__filter_type_clients' => 'Pouze zákazníci',
    'clients_list__filter_type_resellers' => 'Pouze prodejci',
    'ui__client/domain_unknown-new__short-title' => "Vytvořit doménu",

    // Customers > View traffic by customers
    '__personal' => "Přenos využitý doménami uživatele",
    'PersonalTrafficList_header_of_client__' => "Zobrazit sestavu využití přenosu dat pro váš účet",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Správce domény nemůže povolit ani zakázat přístup přes shell",
    'domain_perm__manage_sh_access_chrooted' => "Správce domény může povolit přístup pouze do prostředí typu chroot",
    'domain_perm__manage_sh_access_any' => "Správce domény může povolit přístup k libovolnému typu prostředí",

    // APS Catalog
    'bt_add_to_vault' => "Přidat do trezoru",
    'bt_hide_updates' => "Skrýt dostupné aktualizace",
    'bt_show_updates' => "Zobrazit dostupné aktualizace",

    '__site_apps__applications' => "Aplikace",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Aplikace vybrané k přidání do sejfu",
    'site_apps__application_selected' => "Zvolena",
    'site_apps__currently_in_vault' => "Ostatní verze jsou již v trezoru:",
    'site_apps__new_versions' => "Nové verze:",
    'site_apps__patches' => "Opravy:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Počet aplikací naplánovaných k přidání do sejfu: %1",
    'site_apps__applications_downloading_now' => "Nyní se stahují následující aplikace: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Již v trezoru",

    // Server > Action Log
    'bt_skin_edit' => "Upravit popis vzhledu",
    'domains__you_want_change_the_status_of_the_reseller??' => "Opravdu chcete změnit stav účtu prodejce?",
    'limits__oversell_legend' => "Překročení nabídky",
    'limitsManager__limit_available_error' => "Nelze alokovat požadované množství prostředků (%%quantity%% %%limitName%%). K dispozici jsou pouze %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "Nelze nastavit požadovaný limit využití prostředků (%%quantity%% %%limitName%%), protože nová hodnota je menší než množství prostředků, které byly vyhrazeny pro vaše zákazníky nebo které jste použili sami (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Nelze nastavit požadovaný limit využití prostředků (%%quantity%% %%limitName%%), protože nová hodnota je menší než skutečné množství prostředků již využívaných vaším účtem a weby (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Využití šířky pásma podle služeb",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Zobrazit sestavu využití přenosu dat",
    'ui__client/domain/traffic_unknown-reseller__title' => "Zobrazit sestavu využití přenosu dat",

    'ui__client/domain_new__short-title' => "Vytvořit doménu",

    'ui__client_reseller__description' => "Spravovat účet prodejce %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Spravovat účet prodejce",

    '__owner_name' => "Jméno vlastníka",
    'domains_list__resource__filter_title' => "Využití prostředků",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Katalog aplikací APS",
    'site_apps__applications_have_updates' => "K dispozici jsou aktualizované verze následujících aplikací: %1 Chcete-li zobrazit aktualizace, ověřte si, že je viditelná oblast hledání, zaškrtněte políčko <b>Zobrazit pouze aktualizace</b> a vyhledejte aplikace, které potřebujete.",
    'site_apps__progress_adding_to_vault' => "Přidávání do trezoru:",
    'site_apps__progress_done_message' => "Průběh:",
    'site_apps__progress_applications_left' => "ponecháno %1 z %2 aplikací",
    'site_apps__download_item_long_task_title' => "Stáhnout aplikaci APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Stáhnout aplikace APS z katalogu APS",
    'site_apps__last_check_for_updates' => "poslední kontrola aktualizací: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Všechny naplánované aplikace byly úspěšně přidány do aplikačního trezoru",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 naplánovaných aplikací bylo úspěšně přidáno do aplikačního trezoru.",
    'site_apps__no_search_results' => 'Žádné aplikace nebyly nalezeny. Zkuste jiný požadavek na vyhledávání nebo procházejte aplikace podle kategorií.',
    'site_apps__search_results_title' => 'Výsledky hledání',
    '__site_apps__search_by_application' => 'Název aplikace',
    '__site_apps__search_by_vendor' => 'Dodavatel',
    '__site_apps__search_by_vendor__all' => 'Všichni dodavatelé',
    '__site_apps__search_by_packager' => 'Balíčkovač',
    '__site_apps__search_by_certification_level' => 'Úroveň certifikace',
    '__site_apps__search_by_cert__any' => 'Každý',
    '__site_apps__search_by_cert__silver_and_higher' => 'Stříbro a vyšší',
    '__site_apps__search_by_cert__gold_and_higher' => 'Zlato a vyšší',
    '__retry' => 'Zkusit znovu',
    'site_apps__application_packager_site' => 'Balíčkovač',
    'site_apps__add_to_pool_message' => "Aplikace označené jako \"available for all\" se automaticky šíří všem prodejcům a zákazníkům s neomezeným množstvím instalací. Aplikace s omezením jsou šířeny mezi všechny prodejce a zákazníky ručně na individuální bázi s explicitně zadaným počtem dostupných instalací.",
    'site_apps__make_available_for_all' => "Umožnit dostupnost vybraných aplikací všem uživatelům",

    'site_apps__broadcast_app_text' => "Aplikace označené jako \"available for all\" se automaticky šíří všem prodejcům a zákazníkům s neomezeným množstvím instalací. Aplikace s omezením jsou šířeny mezi všechny prodejce a zákazníky ručně na individuální bázi s explicitně zadaným počtem dostupných instalací.",
    'site_apps__broadcast_app_name' => 'Umožnit dostupnost aplikace všem uživatelům',

    // User Application Pool per application
    'site_apps__available_clients' => 'Uživatelé k dispozici',
    'site_apps__no_more_clients_to_add_to_pool' => 'Neexistují žádné další uživatelské účty, kterým můžete poskytnout tuto aplikaci.',

    // Installed application instances
    'site_apps__installations' => 'Instalace',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Název domény a IP adresa",
    '__assign_ip_address' => "Přiřadit IP adresu",
    '__switch_on_service' => "Zapnout službu",
    '__hosting_configuration' => "Konfigurace hostingu",
    '__vrt_hst' => "Hostování webu",
    '__vrt_hst_hint' => "Hostovat web na tomto serveru.",
    '__fwd' => "Předávání",
    '__web_hosting_settings' => "Nastavení hostování",
    '__fwd_hint' => "Přesměrovat návštěvníky na jiný web.",
    '__none_hint' => "Momentálně nezajišťujte hosting webu.",
    '__login_hint' => "Toto přihlašovací jméno se používá k přístupu na webové stránky prostřednictvím FTP",
    '__password_hint' => "Toto se používá k přístupu na webové stránky prostřednictvím FTP",
    '__advanced_hosting_setup' => "Konfigurovat rozšířené hostování webu",
    '__domain_creation_successful' => "Doména byla vytvořena.",
    'bt_hosting_settings' => "Nastavení hostování",
    '__change_hosting_type' => "Změnit typ hostingu pro doménu %1",
    '__hosting_type_change_warning' => "Pokud změníte typ hostingu na předávání nebo žádný hosting, všechny soubory a adresáře související s vaším webem budou ze serveru odebrány. Nezapomeňte uložit místní kopii svého serveru.",
    '__current_hosting_type' => "Aktuální typ hostingu",
    '__new_hosting_type' => "Nový typ hostingu",
    '__fwd_settings' => "Nastavení předávání",
    '__fwd_settings_legend' => "Nastavení předávání",
    '__fwd_destination_url' => "Cílová adresa URL",
    '__fwd_type' => "Typ přesměrování",
    '__fwd_type_standart' => "Standardní přesměrování",
    '__fwd_type_standart_hint' => "Přesměrujte návštěvníky webu na jiný web a ukažte jim cílovou adresu, aby o přesměrování věděli.",
    '__fwd_type_frame' => "Rámcové přesměrování",
    '__fwd_type_frame_hint' => "Přesměrujte návštěvníky webu na jiný web, ale neukazujte jim cílovou adresu, aby o přesměrování nevěděli.",
    '__hosting_type_template_warning' => "Typ hostingu, který jste vybrali, se liší od typu specifikovaného v šabloně. Pokud budete pokračovat, nastavení webhostingu ve vybrané šabloně bude ignorováno. Opravdu chcete nastavit vybraný typ hostingu?",

    '__no_resellers_selected' => "Musíte vybrat alespoň jeden účet prodejce.",

    'ui__client/logo_unknown__wizard-title' => 'Nastavit logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož vlastnosti loga chcete změnit.',
    'ui__client/logo_unknown__wizard__2' => 'Kliknutím na tlačítko Dokončit uplatněte změny.',
    'ui__client/logo_unknown__wizard__2_self' => 'Kliknutím na tlačítko Dokončit uplatněte změny.',

    'ui__client/ipaddress/properties_new__short-title' => "Přidat IP adresu",
    'ui__client/ipaddress/properties_new__title' => 'Přidat IP adresu',
    'ui__client/ipaddress/properties_new__description' => "Přidat IP adresu.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Přidat IP adresu",
    'ui__client/ipaddress/properties_unknown-new__title' => "Přidat IP adresu",
    'ui__client/ipaddress/properties_unknown-new__description' => "Přidat IP adresu",
    'ui__client/ipaddress/delete_multi__short-title' => "Odebrat IP adresu",
    'ui__client/ipaddress/delete_multi__description' => "Odebrat IP adresy.",
    'ippool_Manager__no_available_ips' => "Ve fondu IP adres nejsou žádné volné IP adresy.",
    'ippool_Manager__ip_shared' => "Sdílený",
    'ippool_Manager__ip_exclusive' => "vyhrazený",
    'ui__client/ipaddress/properties__title' => "Spravovat IP adresy",
    'ui__client/ipaddress/properties__description' => "Zobrazit nebo změnit vlastnosti IP adresy.",
    'ui__client/ipaddress_unknown-new__title' => "Přidat IP adresu",
    'ui__client/ipaddress_unknown-new__short-title' => "Přidat IP adresu",
    'ui__client/ipaddress_unknown-new__description' => "Přidat IP adresy.",

    'ui__mass-mail#to_resellers_text__title' => "Distributoři",
    'ui__mass-mail#to_domainusers_text__title' => "Správci domény",
    'ui__mass-email#tools_legend__title' => "Nástroje",
    'ui__mass-email#list_legend__title' => 'Šablony hromadných e-mailových zpráv',
    'ui__mass-email#template_legend__title' => "Šablona",
    'ui__mass-email#from_email_text__title' => "Od",
    'ui__mass-email#to_text__title' => 'Pro',
    'ui__mass-email#to_resellers_text__title' => "Distributoři",
    'ui__mass-email#to_clients_text__title' => "Zákazníci",
    'ui__mass-email#to_domainusers_text__title' => "Správci domény",
    'ui__mass-email#to_admin_text__title' => "Správce prostředí Plesk",
    'ui__mass-email#option_mode_all__title' => "Všechno",
    'ui__mass-email#option_mode_select__title' => "Pouze vybrané",
    'ui__mass-email#option_mode_except__title' => "Vše kromě vybraných",
    'ui__mass-email#option_select_template__title' => '---Vybrat šablonu---',
    'ui__mass-email#subject_text__title' => "Předmět",
    'ui__mass-email#body_text__title' => "Text zprávy",
    'ui__mass-email#save_as_legend__title' => "Uložit jako šablonu",
    'ui__mass-email#save_as_text__title' => "Uložit složenou zprávu do nové šablony s názvem",
    'ui__reseller/preferences_unknown__wizard-title' => "Změnit nastavení účtu",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Vyberte prodejce, jehož nastavení účtu chcete změnit, a klikněte na Další.",
    'ui__reseller/preferences_unknown__wizard__2' => "Zadejte nastavení účtu a klikněte na OK.",
    'ippoolManager__ip_shared' => "Sdílený",
    'ippoolManager__ip_exclusive' => "vyhrazený",

    '__users_list' => "Uživatelé",
    '__users' => "Uživatelé",
    '__user_name' => "Přihlašovací jméno",

    'limit__name_max_dom_aliases' => "doménové aliasy",
    'limit__name_max_subftp_users' => "Další účty FTP",
    'limit__name_max_mssql_db' => "Databáze Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Fondy aplikací IIS",
    'limit__name_max_odbc' => "Připojení ODBC",
    'total_mboxes_quota_unsupported' => 'nepodporováno e-mailovým serverem',
    'limit_soft__disk_space' => 'Upozornit na dosažení místa na disku',
    'limit_soft__max_traffic' => 'Upozornit na dosažení přenosu',
    'dsr__of_reseller_title' => "Využití prostředků podle domén",
    'limitsManager__commit_failed' => "Nelze změnit limity prostředků.",
    'limitsManager__date_in_past' => "Nesprávné datum vypršení %1.",
    'limitsManager__limit_not_supported' => "Limity pro typ prostředku %1 nelze nastavit.",
    'limitsManager__limit_oversell_inconsistency' => "Při vypnutí překročení nabídky nelze alokovat zadané množství prostředků.",
    'limitsManager__limit_overuse_inconsistency' => "Využití prostředků překračuje stanovené limity.",
    'limitsManager__no_resource_available' => "Nejsou k dispozici žádné prostředky tohoto typu (%%limitName%%). Požadované: %%quantity%%; dostupné: %%unused%%.",
    'limitsManager__no_total_resource_available' => "U vašeho poskytovatele služeb nejsou k dispozici žádné prostředky tohoto typu (%%limitName%%). Požadované: %%quantity%%; dostupné: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Datum vypršení musí být menší nebo rovno %1.",
    'limitsManager__invalid_disk_space_limit' => "Velikost diskového prostoru musí být menší nebo rovna %1.",
    'limitsManager__invalid_max_traffic_limit' => "Objem přenosu musí být menší nebo roven %1.",
    'ippoolManager__ip_has_suballocations' => "Typ IP adresy, která již byla přidělena uživateli, nelze změnit. IP adresa %%ip%% je již přidělena uživateli(ům) jako %%reserved%% IP adresa.",
    'ippoolManager__ip_is_already_in_pool' => "Tato IP adresa je již přidělena uživateli.",
    'ippoolManager__ip_is_not_in_pool' => "Ve fondu není žádná IP adresa %%ip%%.",
    'ippoolManager__can_not_allocate_ip' => "IP adresa %%ip%% je k dispozici pouze jako %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "IP adresu %%ip%% nelze přidělit jako vyhrazenou.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP adresa %%ip%% se již používá k hostování.",
    'ippoolManager__active_anon_ftp_on_ip' => "Pro IP adresu %%ip%% je již zapnut anonymní přístup na FTP",
    'ippoolManager__no_vacant_ips' => "Žádné IP adresy nejsou volné.",
    'ippoolManager__no_available_ips' => "Žádné IP adresy nejsou dostupné.",
    'templates__dublicate_name' => "Šablona s tímto názvem již existuje. Vyberte jiný název pro tuto šablonu.",
    'cl_perm__client_limits_exceeded' => "Zadané hodnoty limitů prostředků překračují hodnoty povolené vaším plánem hostování nebo tyto hodnoty poskytují méně prostředků, než vaše weby momentálně využívají.",
    'cl_perm__reseller_limits_exceeded' => "Zadané hodnoty limitů prostředků překračují hodnoty povolené vaším plánem hostování nebo tyto hodnoty poskytují méně prostředků, než uživatelské účty a weby momentálně využívají.",

    'site_apps__preferences_show_all_versions_title' => "Zobrazit celý seznam verzí pro každou aplikaci získanou z katalogu",
    'site_apps__preferences_show_all_versions_hint' => "Při volbě této možnosti může získání všech verzí každé aplikace při každém otevření katalogu trvat delší dobu. Pokud není vybrána tato možnost, budou zobrazeny pouze nejnovější verze.",
    '__select_user_template' => "Vytvořit uživatelský účet podle šablony.",
    'ip_already_added_to_all_clients' => "Tato IP adresa je již přiřazena všem uživatelům.",
    'ui__server/ip-address/client/delete#legend__description' => "Následující IP adresy budou odebrány ze systému a z fondu IP adres uživatelů:",

    'site_apps__cancelled_apps' => "Zrušili jste přidání následujících aplikací: %2",

    'sb_url_is_not_resolved' => 'Adresu URL nelze rozpoznat: zkontrolujte své nastavení DNS. Adresa URL %1 se musí vyřešit v IP adrese serveru s nainstalovaným systémem Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Nelze odebrat IP adresu %%ip%%, protože je to poslední IP adresa přítomná na síťovém rozhraní.',
    'ip_addr__used_for_current_session' => 'Nelze odebrat IP adresu %%ip%%, protože se používá v aktivní relaci.',
    'ip_addr__used_for_hosting' => 'Nelze odebrat IP adresu %%ip%%, protože se používá k hostování webu.',
    'ip_addr__is_main' => 'Nelze odebrat IP adresu %%ip%%, protože je to primární IP adresa síťového rozhraní.',
    'ip_addr__ip_used_by_message_submission' => 'Nelze odebrat IP adresu %%ip%%, protože se používá k odeslání e-mailových zpráv',

    // RESELLER ACTION LOG

    '__cl_domains' => 'domény zákazníků',
    'excl_ip_num' => 'Vyhrazená IP adresa',

    'sb_err_sitebuilder_not_installed' => 'Systém Presence Builder není nainstalován.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Oprávnění k překročení nabídky nemůže vyvolat uživatel, protože uživatel, který má přiděleno větší množství prostředků, než je k dispozici, přechází do režimu překročení nabídky.',
    'limitsManager__invalid_limit_value' => 'Pro limit %%limit_name%% byla zadána nesprávná hodnota %%value%%',
    'confirmationForm_default_agreement_text' => 'Potvrdit operaci',
    'confirmationForm_default_confirm_message' => 'Potvrďte operaci.',
    'limit__max_mn' => 'Maximální počet e-mailových účtů',

    'limits__client_overuse_description' => 'Zásady překročení limitu řeknou prostředí Plesk co dělat, pokud využití prostředků překročí výchozí přidělení prostředků.',
    'limits__client_overuse_block_true_description' => 'Blokovat nadměrné využití prostředků. Skutečné využití prostředků nemůže překročit výchozí přidělení prostředků',
    'limits__client_overuse_block_false_description' => 'Neblokujte nadměrné využití prostředků, což zákazníkovi umožní využít více prostředků, než bylo původně poskytnuto. Skutečné využití prostředků může překročit výchozí přidělení prostředků',
    'limits__client_overuse_notify_text' => 'Upozornit zákazníka na dosažení limitů prostředků',

    'limits__domain_overuse_description' => 'Zásady překročení limitu řeknou prostředí Plesk co dělat, pokud využití prostředků překročí výchozí přidělení prostředků.',
    'limits__domain_overuse_block_true_description' => 'Zásady nadměrného využití řeknou prostředí Plesk co dělat, pokud jsou prostředky využívány nadměrně.',
    'limits__domain_overuse_block_false_description' => 'Neblokujte nadměrné využití prostředků, což doméně umožní využít více prostředků, než bylo původně poskytnuto. Skutečné využití prostředků může překročit výchozí přidělení prostředků',
    'limits__domain_overuse_notify_text' => 'Upozornit vlastníka domény na dosažení limitů prostředků',


    'cancel_remove' => 'Zrušte veškeré změny a vraťte se na předchozí stránku.',
    'php_not_installed' => 'PHP není nainstalován',

    'dns__dns_rr_delete' => 'Položky, které budou odebrány',
    'dns__delete_rr' => 'Následující záznamy prostředků DNS budou odebrány ze zóny DNS:',
    'dns__dns_rr_delete_non_removable' => 'Položky, které nelze odebrat',
    'dns__non_delete_rr' => 'Nelze odebrat následující záznamy DNS.',
    'dns__dns_rr_delete_confirm_message' => 'Potvrdit odebrání záznamů DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Neznámý formát webové aplikace: webová aplikace může být nedostupná pro instalaci a použití.',

    '__php_handler_type_desc' => 'Spustit PHP jako',
    'sfdk_domain_sign__failed' => 'Při pokusu zapnout funkci podepisování e-mailu s ochranou DKIM na doméně došlo k neidentifikovatelné chybě. Další informace v protokolu chyb webového serveru.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Oznámení o úspěšné aktualizaci klíče Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Oznámení o časovém odkladu aktualizace klíče Plesk',
    'pkey_notify__subj_update_error_notification' => 'Oznámení o chybě aktualizace klíče Plesk',
    'pkey_notify__update_successful' => 'Aktualizace %1 byla úspěšně dokončena.',
    'pkey_notify__update_failed_no_more_try' => 'Nelze aktualizovat %1. Klíč, který se pokoušíte odeslat, je neplatný. Nesmíte se dále pokoušet o aktualizaci tohoto klíče.',
    'pkey_notify__update_failed_try_later' => 'Nelze aktualizovat %1: při zpracování vašeho klíče došlo k chybě. Můžete zkusit načíst klíč ručně v prostředí Plesk (Nástroje a nastavení> Informace o licencích) nebo nechat Plesk, aby ho zkusil aktualizovat v příštích 24 hodinách. Pokud již nechcete dostávat tato oznámení, odeberte tento klíč z prostředí Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Nelze vypnout filtrování nevyžádané pošty pro celý server.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Nelze zapnout filtrování nevyžádané pošty pro celý server',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domény',
    'rpt_reseller_dom_subdomains' => 'Subdomény',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'Schránky',
    'rpt_reseller_dom_redirects' => 'Servery pro předávání',
    'rpt_reseller_dom_mail_groups' => 'Skupiny',
    'rpt_reseller_dom_mail_resps' => 'Odpověď',
    'rpt_reseller_dom_mail_antispam' => 'Antispam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'Seznamy',
    'rpt_reseller_dom_web_users' => 'Uživatelé',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Zákazníci',
    '__cl_name' => 'Jméno zákazníka',
    '__cl_creation_date' => 'Datum vytvoření',
    '__clients_traffic' => 'Přenos dat zákazníka',
    'rpt_reseller_cl_mail_antispam' => 'Antispam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Systém Presence Builder není nainstalován.',
    'sitebuilder_disabled' => 'Systém Presence Builder je vypnutý.',
    'b_sitebuilder_disabled' => 'Systém Presence Builder je vypnutý.',
    'webmail_not_installed' => 'Software pro webové rozhraní pošty není nainstalován.',
    'webmail_disabled' => 'Služba webové rozhraní pošty je vypnuta.',
    'spamassassin_not_installed' => 'Součást SpamAssassin není nainstalována.',
    // pfu:
    'anonymous_ftp_shared' => 'Nelze nastavit službu anonymního FTP: typ sdílené IP adresy.',
    'anonymous_ftp_used' => 'Nelze nastavit službu anonymního FTP: IP adresa se využívá jinou doménou pro službu anonymního FTP.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET není nainstalována.',
    'site_builder_no_package' => 'Systém Presence Builder není k dispozici. Ověřte si, zda je systém Presence Builder nainstalován a zvolen jako aktivní součást.',
    'site_builder_not_configured' => 'Systém Presence Builder není nakonfigurován.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Nástroje',
    'ui__reseller/client#clientslist__title' => 'Zákazníci',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Správa virtuálních adresářů pod webem',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Vybrat web, jehož adresáře chcete spravovat.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Nastavit anonymní FTP na doméně',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Vyberte doménu, pro kterou chcete nastavit anonymní FTP.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Nastavit správce souborů protokolu pro doménu a zobrazit soubory protokolu domény',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Vyberte doménu, jejíž správce protokolů chcete nastavit a jejíž soubory protokolů chcete prohlížet.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Spravovat certifikáty SSL/TLS pro doménu',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Vyberte doménu, jejíž certifikáty SSL/TLS chcete spravovat.',

    'ui__client/domain/disable_multi__wizard-title' => 'Pozastavit domény',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Vyberte domény, které chcete pozastavit.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktivovat domény',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Vyberte domény, které chcete aktivovat.',

    'ui__client/domain_unknown__wizard-title' => 'Zobrazit domény',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Vyberte zákazníka, jehož domény chcete vidět.',

    'ui__client/domain/register_unknown__wizard-title' => 'Registrovat domény',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Vybrat doménu, kterou chcete registrovat.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Použít nástroje z MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Vyberte doménu, kterou chcete spravovat pomocí nástrojů z MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Uživatelé IP adresy',
    'ui__server/ip-address/client_unknown__title' => 'Uživatelé IP adresy',
    'ui__server/ip-address/client_unknown__description' => 'Uživatelé IP adresy %1',

    'disabled_by_admin' => 'Zakázáno správcem serveru',






    'ui__client/domain/chowner_multi__short-title' => 'Změnit vlastníka',
    'ui__client/domain/chowner_multi__title' => 'Změnit vlastnictví předplatného',
    'ui__client/domain/chowner_multi__description' => 'Změnit vlastnictví předplatného.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Vyberte domény, pro které chcete změnit vlastnictví, a klikněte na Další>>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Změnit vlastníka',
    'ui__client/domain/chowner_unknown__title' => 'Změnit vlastnictví předplatného',
    'ui__client/domain/chowner_unknown__description' => 'Změnit vlastnictví předplatného.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Změnit vlastnictví předplatného',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Neexistují žádná uživatelská tlačítka.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Na rozhraní prodejce %1 nejsou žádná uživatelská tlačítka.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Odebrat tlačítko %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Odebrat',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Odebrat tlačítko %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Odebrat uživatelská tlačítka z rozhraní prodejce',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Odebrat',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Odebrat uživatelská tlačítka.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Odebrat tlačítka',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Vyberte prodejce, jehož uživatelská tlačítka chcete odebrat, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Vyberte tlačítka, které chcete odebrat, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Potvrďte odebrání tlačítek označením zaškrtávacího políčka na této stránce a poté klikněte na Dokončit.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Odebrat uživatelské tlačítko z rozhraní prodejce.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Odebrat',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Odebrat uživatelské tlačítko',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Odebrat uživatelské tlačítko',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Vyberte prodejce, jehož uživatelské tlačítko chcete odebrat, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Vyberte uživatelské tlačítko, které chcete odebrat, a klikněte na Další >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Potvrďte odebrání uživatelského tlačítka označením zaškrtávacího políčka na této stránce a poté klikněte na Dokončit.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Upravit vlastnosti uživatelského tlačítka %1 na úrovni prodejce.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Nastavení',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Upravit uživatelské tlačítko %1 prodejce',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Přidat uživatelské tlačítko',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Vyberte prodejce, na jehož rozhraní chcete vytvořit uživatelské tlačítko, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Tlačítko vytvořte kliknutím na Dokončit.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Změnit vlastnosti tlačítka na rozhraní prodejce.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Vlastnosti',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Změnit vlastnosti tlačítka na rozhraní prodejce',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Změnit vlastnosti uživatelského tlačítka',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Vyberte prodejce, jehož uživatelské tlačítko chcete upravit, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Vyberte uživatelské tlačítko, které chcete upravit, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Po dokončení úprav vlastností tlačítka potvrďte změny kliknutím na Dokončit a ukončete průvodce.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Vytvořit nedostupnost tlačítka %1 pro vaše zákazníky.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Vytvořit nedostupnost pro vaše zákazníky',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Vytvořit nedostupnost tlačítka %1 pro vaše zákazníky',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Zviditelnit tlačítko %1 pro zákazníky prodejce.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Zpřístupnit pro vaše zákazníky',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Zviditelnit tlačítko %1 pro zákazníky prodejce',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Udělat uživatelské tlačítko dostupné/nedostupné pro vaše zákazníky.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Dostupný/nedostupný pro vaše zákazníky',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Udělat uživatelské tlačítko dostupné či nedostupné pro vaše zákazníky',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Udělat uživatelské tlačítko dostupné/nedostupné pro vaše zákazníky.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Vyberte prodejce, jehož uživatelské tlačítko chcete zpřístupnit pro zákazníky prodejce, a klikněte na Další>>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Vyberte uživatelské tlačítko, které chcete udělat dostupné či nedostupné pro vaše zákazníky, a klikněte na Další>>.',

    '__not_allowed' => 'Nepovoleno',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Vybrat nového vlastníka domény.',

    '__ip_addr_state_unknown' => "IP adresa nyní není funkční, protože systém stále zpracovává vaši žádost. Počkejte chvíli, prosím.",


    'resellers_list__accounts' => 'Uživatelé',

    'ip_addr__repair_is_not_allowed' => 'IP adresu nelze opravit v prostředí Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Prodejce %1 nemá zákazníky.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP adresu %%ip%% nelze odebrat, protože je používána jednou nebo více doménami bez hostingu.",
    'ippoolManager__ip_used_for_mail_service' => "Adresu IP %%ip%% nelze odebrat, protože je používána jednou nebo více doménami jako IP adresa e-mailové služby.",
    'ippoolManager__ip_used_for_send_emails' => "Adresu IP %%ip%% nelze odebrat, protože se používá k odesílání e-mailů ze specifické adresy IP (viz nastavení serveru pošty).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP adresu %%ip%% nelze odebrat, protože je používána zónou DNS jedné nebo více domén.',
    'ip_ctrl__cannot_manage_on_vz' => 'Tato instalace prostředí Plesk pracuje v kontejnerech Virtuozzo. Nové IP adresy může přidat pouze správce uzlu kontejnerů Virtuozzo.',

    'client_template__limits_auto_adjusted' => 'Limity ze šablony zákazníka byly automaticky upraveny.',

    '__entries' => 'Položky',

    '__path_is_not_set' => 'Cesta není určena. Zadejte platnou cestu.',

    'defaultcomponents__imap_required' => '(Aktuální e-mailový server nepodporuje IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk podporuje pouze komerční software pro webové statistiky softwaru pro statistické výpočty subdomény. V systému není momentálně nainstalován žádný takový software.',


    'server_settings_invalid_traffic_statistics' => 'Neplatný parametr zachování statistik provozu.',
    'server_settings_invalid_logrotate_period' => 'Neplatný parametr období rotace protokolu.',

    'spam_filter/address/file_size' => 'Soubor nelze nahrát. Maximální velikost souboru, který se má nahrát, je %1.',
    'spam_filter/address/file_empty_content' => 'Došlo k problému se čtením e-mailových adres v souboru. Zkontrolujte, že nahráváte soubor s kódováním ve formátu UTF-8, který obsahuje jednu nebo více e-mailových adres, a zkuste to znovu.',
    'spam_filter/address/addresses_empty_content' => 'V seznamu nejsou žádné emailové adresy.',
    'spam_filter/address/addresses_available' => 'Bude přidáno pouze %1 prvních jedinečných e-mailových adres.',
    'spam_filter/address/invalid_addresses' => 'Následující e-mailové adresy jsou neplatné: %1.',
];