<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Tilgang nektet. Din konto har blitt deaktivert.",
    'login_up__login_has_been_locked' => "Du har prøvd å logge deg inn med feil passord for mange ganger. Av sikkerhetsgrunner vil du ikke kunne logge inn med dette brukernavnet for en stund.",
    'login_up__unable_to_check_pass' => "Kan ikke kontrollere passordet: %1",
    'login_up__warning_limits_licence_key' => "Et av følgende elementer har overskredet grensen som defineres av lisensnøkkelen din: antallet brukerkontoer, domener, epostkontoer eller webbrukere som hostes på serveren din.\nVennligst ta kontakt med Plesk salgsavdeling for å kjøpe en nøkkel som vil la deg hoste ønsket antall brukere og domener. Ta kontakt med Plesk tekniske brukerstøtte dersom du mener at du har fått denne meldingen ved en feil.\nLisensgrensen for brukerkontoer/domener/epostkontoer/webbrukere/språkpakker: %2.\nAntall brukerkontoer/domener/epostkontoer/webbrukere/språkpakker som hostes: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Ressursmengden du bruker har overskredet grensene definert av den aktive produktlisensen din. Vennligst ta kontakt med Plesk salgsavdeling og kjøp en ny lisensnøkkel.",
    'login_up__grace_period' => 'Du er nå inne i prøveperioden for produktlisensen din. For å oppdatere produktlisensen, velger du alternativet «Hent nøkler» på %1Lisenshåndteringssiden%2.',
    'login_up__partner_license_message' => 'Du bruker for tiden en begrenset produktlisens som krever registrering før aktivering av hele funksjonssettet. For å oppdatere produktlisensen din, velger du alternativet «Hent nøkler» på %1Lisensbehandlingssiden%2.',
    'login_up__system_admin_disabled' => 'Superbruker (root eller administratorkonto) har av sikkerhetsårsaker ikke tillatelse til å logge på Plesk.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Plesk Administrator-veiledning",
    'plesk_guide_reseller' => "Plesk forhandlerveiledning",
    'plesk_guide_client' => "Plesk kundehåndbok",
    'plesk_guide_domain_admin' => "Plesk håndbok for domeneadministratorer",
    'plesk_guide_mailuser' => "Plesk E-post brukerveiledning",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Søk', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Kunder',
    'ui__reseller_unknown__quick-search' => 'Videreforhandler',
    'ui__client/domain_unknown__quick-search' => 'Domener',
    'nav__general' => 'Hovedmeny',
    '__home' => 'Hjem',
    '__resellers' => 'Videreforhandler',
    '__clients' => 'Kunder',
    '__domains' => 'Domener',
    '__applications' => 'Programmer',
    '__settings' => 'Innstillinger',
    'nav__system' => 'System',
    '__master' => 'Hoved',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Opp nivå',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Fjern',
    'bt_make_default' => 'Bruk som standard',

    // common list object operation errors
    'class_cList__empty_selection' => 'Ingen objekter valgt.',

    // common list object search keys
    'clist__search_show' => 'Vis Søk',
    'clist__search_hide' => 'Skjul søk',

    'bt_show_all' => "Tilbakestill søk",

    // common object list info keys
    'clist__first' => 'Første',
    'clist__last' => 'Siste',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Sider',
    'clist__page_size' => 'Oppføringer per side',
    'clist__info' => 'Sum %1: %4',
    'clist__info_empty' => 'Nr. %1',
    'clist__info_filter' => '%5 %1 funnet (%4 totalt)',
    'clist__info_paging' => '%2-%3 %1 av %4 totalt',
    'clist__info_paging_filter' => '%2-%3 %1 av %5 funnet (%4 totalt)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Aktiv',
    '__object_off' => 'Suspendert',

    '__home_description' => 'Tilbake til hjemmesiden.',
    'indicator_title' => '%1% benyttet, %2% ledig', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Ugyldig URL ble ønsket.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Forhandlerkontoer",
    'ui__reseller_unknown__title' => "Forhandlerkontoer",
    'ui__reseller_unknown__description' => "Administrer forhandlerkontoer.",
    'ui__reseller/client_unknown__short-title' => 'Kundekontoer',
    'ui__reseller/client_unknown__title' => 'Kundekontoer',
    'ui__reseller/client_unknown__description' => 'Administrer kundekontoer.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Ekstra administratorkontoer", // PFW
    'ui__admin-alias_unknown__short-title' => "Ekstra administratorkontoer", // PFW
    'ui__admin-alias_unknown__description' => "Vis og behandle ekstra administratorkontoer.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Globale e-postinnstillinger.",
    'ui__server/mail__title' => "Globale e-postinnstillinger.",
    'ui__server/mail__description' => "Sett opp din e-postserver og konfigurer globale e-postinnstillinger.",
    'ui__server/dns__short-title' => 'DNS-innstillinger',
    'ui__server/dns__title' => 'DNS-innstillinger',
    'ui__server/dns__description' => 'Se gjennom og oppdater globale DNS-innstillinger.',
    'ui__server/services__title' => 'Tjenestebehandling',
    'ui__server/services__description' => 'Start, stopp eller start Plesk-tjenestene om igjen.',
    'ui__server/crontab/task_unknown__short-title' => 'Planlagte oppgaver',
    'ui__server/crontab/task_unknown__title' => 'Planlagte oppgaver',
    'ui__server/crontab/task_unknown__description' => 'Legg til og fjern globale planlagte oppgaver.',
    'ui__server/ip-address_unknown__short-title' => 'IP-adresser',
    'ui__server/ip-address_unknown__title' => 'IP-adresser',
    'ui__server/ip-address_unknown__description' => 'Vis, legg til og fjern IP-adresser, tildel IP-adressene til forhandlere.',
    // dropdowns
    'ui__server/time__title' => 'Systemtid',
    'ui__server/time__short-title' => 'Systemtid',
    'ui__server/time__description' => 'Endre systemdato og -tid, sett opp synkronisering med en NTP-server.',
    'ui__server/maillists__title' => 'Sett opp adresselisteserver', // PFU
    'ui__server/maillists__short-title' => 'Sett opp adresselisteserver', // PFU
    'ui__server/maillists__description' => 'Sett opp Mailman postlisteserver.', // PFU
    'ui__mass-email__short-title' => "Masseutsendelse av e-postmeldinger", // PFW
    'ui__mass-email__title' => "Masseutsendelse av e-postmeldinger", // PFW
    'ui__mass-email__description' => "Send e-postmelding til flere brukere på en gang.", // PFW
    'ui__mass-mail__title' => 'Masseutsendelse av e-postmeldinger', // PFU
    'ui__mass-mail__short-title' => 'Masseutsendelse av e-postmeldinger', // PFU
    'ui__mass-mail__description' => 'Send e-postmelding til flere brukere på en gang.', // PFU
    'ui__server/spam-filter__title' => 'Innstillinger for spamfilter',
    'ui__server/spam-filter__short-title' => 'Innstillinger for spamfilter',
    'ui__server/spam-filter__description' => 'Sett opp globalt filter for søppelpost.',
    'ui__server/preferences__title' => "Serverinnstillinger",
    'ui__server/preferences__short-title' => "Serverinnstillinger",
    'ui__server/preferences__description' => "Sett opp statistikkberegninger for serveren, endre serverens vertsnavn og endre andre serverinnstillinger.",

    // help & support
    // icons
    'ui__support__short-title' => 'Støtte',
    'ui__support__title' => 'Støtte',
    'ui__support__description' => 'Send inn en forespørsel om teknisk støtte eller gå gjennom støtteforespørsler fra kundene dine.',
    'ui__license__short-title' => 'Lisensinformasjon',
    'ui__license__title' => 'Lisensinformasjon for Plesk',
    'ui__license__description' => 'Vis informasjon om lisensen din for Plesk og bestill nye lisensnøkler.',
    'ui__help__short-title' => 'Hjelp',
    'ui__help__title' => 'Elektronisk hjelp',
    'ui__help__description' => 'Vis hjelp på Internettet.',
    'ui__news__short-title' => "Hva er nytt",
    'ui__news__title' => "Hva er nytt",
    'ui__news__description' => "Se liste over endringene i denne versjonen av Plesk.",
    'ui__server/autoinstaller__short-title' => 'Oppdateringer',
    'ui__server/autoinstaller__title' => 'Oppdateringer',
    'ui__server/autoinstaller__description' => 'Oppdater Plesk eller dets komponenter.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Domener',
    'ui__client/domain_unknown__title' => 'Domener',
    'ui__client/domain_unknown__description' => 'Administrer domener.',
    'ui__server/skeleton__short-title' => 'Mal for virtuell vert',
    'ui__server/skeleton__title' => 'Mal for virtuell vert',
    'ui__server/skeleton__description' => 'Angi filer og mapper som skal plasseres i katalogene til nylig opprettede domener.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Tildel ny eier av abonnementer',
    'ui__client/domain/chowner_multi-select__short-title' => 'Tildel ny eier av abonnement',
    'ui__client/domain/chowner_multi-select__description' => 'Tildel ny eier for valgte abonnementer',
    'ui__client/domain/disable_multi__title' => 'Suspender domener',
    'ui__client/domain/disable_multi__short-title' => 'Suspender domener',
    'ui__client/domain/disable_multi__description' => 'Deaktiver de valgte domenene',
    'ui__client/domain/enable_multi__title' => 'Aktiver domener',
    'ui__client/domain/enable_multi__short-title' => 'Aktiver domener',
    'ui__client/domain/enable_multi__description' => 'Aktiver valgte domener',

    // icons
    'ui__admin/extras-domain__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Verktøy fra MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Innstillinger for ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Innstillinger for ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Konfigurere globale ASP.NET-innstillinger.', // PFW
    'ui__server/sitebuilder__short-title' => 'Innstillinger for Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Innstillinger for Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Sett opp Presence Builder for redigering av nettsteder som hostes på denne serveren.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Registrer domene',
    'ui__admin/register-domain__short-title' => 'Registrer domene',
    'ui__admin/register-domain__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Administrer domene',
    'ui__admin/manage-domain__short-title' => 'Administrer domene',
    'ui__admin/manage-domain__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',
    'ui__server/register__title' => 'Registrer din server',
    'ui__server/register__short-title' => 'Registrer serveren',
    'ui__server/register__description' => 'Registrer serveren din for å bli med i et samarbeidsprogram',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Handlingslogg',
    'ui__actionlog__title' => 'Handlingslogg',
    'ui__actionlog__description' => 'Last ned handlingslogg, og behandle innstillinger for handlingslogg.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Serverinformasjon',
    'ui__server/statistics__title' => 'Serverinformasjon',
    'ui__server/statistics__description' => 'Statistikk for tjenester administrert av Plesk.',
    'ui__admin/report__title' => 'Oppsummeringsrapport',
    'ui__admin/report__short-title' => 'Oppsummeringsrapport',
    'ui__admin/report__description' => 'Vis rapport om bruk av trafikk og ressurser for forhandlere, kunder og domener.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Tomgangstid for økt',
    'ui__sessions/properties__title' => 'Tomgangstid for økt',
    'ui__sessions/properties__description' => 'Sett opp inaktiv tid for Plesk-økter.',
    'ui__cp-access__short-title' => 'Tilgang til Plesk',
    'ui__cp-access__title' => 'Tilgang til Plesk',
    'ui__cp-access__description' => 'Begrens tilgang til Plesk.',
    'ui__sessions__short-title' => 'Aktive økter',
    'ui__sessions__title' => 'Aktive økter',
    'ui__sessions__description' => 'Vis aktive Plesk-økter.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'SSL/TLS-sertifikater',
    'ui__server/certificate_unknown__short-title' => 'SSL/TLS-sertifikater',
    'ui__server/certificate_unknown__description' => 'Liste over SSL/TLS-sertifikater.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Personlige data',
    'ui__admin-info__title' => 'Personlige data',
    'ui__admin-info__description' => 'Endre personlige data for din konto.',
    'ui__admin-password__short-title' => 'Endre passord',
    'ui__admin-password__title' => 'Endre passord',
    'ui__admin-password__description' => 'Endre passordet for din konto.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Arbeid med fysiske og virtuelle filer og mapper under et nettsted.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Ressursbruk',
    'ui__reseller/limits__title' => 'Ressursbruk',
    'ui__reseller/limits__description' => 'Vis og administrer ressursbruk for forhandler %1.',
    'ui__reseller/limits_unknown__short-title' => 'Ressursbruk',
    'ui__reseller/limits_unknown__title' => 'Ressursbruk',
    'ui__reseller/limits_unknown__description' => 'Vis og administrer ressursbruk for forhandler.',
    'ui__reseller/limits_self__short-title' => 'Ressursbruk',
    'ui__reseller/limits_self__title' => 'Ressursbruk',
    'ui__reseller/limits_self__description' => "Se og administrer ditt ressursforbruk.",
    'ui__reseller/limits_readonly-self__short-title' => 'Ressursbruk',
    'ui__reseller/limits_readonly-self__title' => 'Ressursbruk',
    'ui__reseller/limits_readonly-self__description' => "Se ditt ressursforbruk.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Trafikkbruk etter kunder',
    'ui__reseller/client/traffic_unknown__title' => 'Vis trafikkbruk etter kunder',
    'ui__reseller/client/traffic_unknown__description' => 'Vis rapporter for trafikkbruk for kundekontoer.',
    'ui__client/traffic_unknown__short-title' => "Trafikkbruk etter kunder", // temporary for presets
    'ui__client/traffic_unknown__title' => "Vis trafikkbruk etter kunder", // temporary for presets
    'ui__client/traffic_unknown__description' => "Vis rapporter for trafikkbruk for kundekontoer.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Logg administrator',
    'ui__client/domain/hosting/logs_unknown__title' => 'Logg administrator',
    'ui__client/domain/hosting/logs_unknown__description' => 'Se logg og konfigurere loggrotasjon.',
    // dropdowns
    'ui__reseller/report__title' => 'Oppsummeringsrapport',
    'ui__reseller/report__short-title' => 'Oppsummeringsrapport',
    'ui__reseller/report__description' => 'Vis rapport om trafikkbruk og ressurser for denne forhandleren.',
    'ui__reseller/report_unknown__title' => 'Oppsummeringsrapport',
    'ui__reseller/report_unknown__short-title' => 'Oppsummeringsrapport',
    'ui__reseller/report_unknown__description' => 'Vis rapport om trafikkbruk og forhandlerressurser.',
    'ui__reseller/report_self__title' => 'Oppsummeringsrapport',
    'ui__reseller/report_self__short-title' => 'Oppsummeringsrapport',
    'ui__reseller/report_self__description' => 'Se rapport over din bruk av trafikk og ressurser.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Profilering av Plesk',
    'ui__client/logo_reseller__short-title' => 'Profilering av Plesk',
    'ui__client/logo_reseller__description' => 'Endre profilering av Plesk for forhandler %1.',
    'ui__client/logo_unknown__title' => 'Profilering av Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Profilering av Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Endre profilering av Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Profilering av Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Profilering av Plesk',
    'ui__client/logo_self-reseller__description' => 'Endre profilering av Plesk.',
    'ui__reseller/permissions__title' => 'Tillatelser',
    'ui__reseller/permissions__short-title' => 'Tillatelser',
    'ui__reseller/permissions__description' => "Vis eller endre handlingene forhandler %1 kan utføre i Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Tillatelser',
    'ui__reseller/permissions_unknown__title' => 'Tillatelser',
    'ui__reseller/permissions_unknown__description' => "Vis eller endre handlingene forhandleren kan utføre i Plesk.",
    'ui__reseller/permissions_self__title' => 'Tillatelser',
    'ui__reseller/permissions_self__short-title' => 'Tillatelser',
    'ui__reseller/permissions_self__description' => 'Vis liste av handlinger du kan utføre i Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Tillatelser',
    'ui__reseller/permissions_readonly-self__short-title' => 'Tillatelser',
    'ui__reseller/permissions_readonly-self__description' => 'Vis liste av handlinger du kan utføre i Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Mal for virtuell vert',
    'ui__client/skeleton__short-title' => 'Mal for virtuell vert',
    'ui__client/skeleton__description' => 'Angi filer og mapper som skal plasseres i katalogene til nylig opprettede domener.',
    'ui__client/skeleton_unknown__short-title' => 'Mal for virtuell vert',
    'ui__client/skeleton_unknown__title' => 'Mal for virtuell vert',
    'ui__client/skeleton_unknown__description' => 'Angi filer og mapper som skal plasseres i katalogene til nylig opprettede domener.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Domenealiaser',
    'ui__client/domain/domain-alias_unknown__title' => 'Domenealiaser',
    'ui__client/domain/domain-alias_unknown__description' => 'Vis listen over alternative navn for domenet ditt.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_unknown__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_unknown__description' => 'Administrer innstillinger for DNS-sonen for et domene.',
    'ui__client/domain/dns_readonly-unknown__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-unknown__description' => 'Vis innstillinger for DNS-sonen for et domene.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Verktøy fra MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Verktøy fra MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Verktøy fra MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Registrer domene',
    'ui__reseller/register-domain__title' => 'Registrer domene',
    'ui__reseller/register-domain__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Registrer domene',
    'ui__reseller/register-domain_unknown__title' => 'Registrer domene',
    'ui__reseller/register-domain_unknown__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Registrer domene',
    'ui__reseller/register-domain_self__title' => 'Registrer domene',
    'ui__reseller/register-domain_self__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Administrer domene',
    'ui__reseller/manage-domain__short-title' => 'Administrer domene',
    'ui__reseller/manage-domain__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Administrer domene',
    'ui__reseller/manage-domain_unknown__short-title' => 'Administrer domene',
    'ui__reseller/manage-domain_unknown__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Administrer domene',
    'ui__reseller/manage-domain_self__short-title' => 'Administrer domene',
    'ui__reseller/manage-domain_self__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'IP-adresser',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'IP-adresser',
    'ui__client/ipaddress_unknown-reseller__description' => 'Administrer IP adresser.',
    'ui__client/domain/certificate_unknown__short-title' => 'SSL/TLS-sertifikater',
    'ui__client/domain/certificate_unknown__title' => 'SSL/TLS-sertifikater',
    'ui__client/domain/certificate_unknown__description' => 'Installer og behandle SSL/TLS-sertifikater.',
    'ui__reseller/sessions__short-title' => 'Aktive økter',
    'ui__reseller/sessions__title' => 'Aktive økter',
    'ui__reseller/sessions__description' => 'Vis aktive Plesk-økter.',
    'ui__reseller/sessions_unknown__short-title' => 'Aktive økter',
    'ui__reseller/sessions_unknown__title' => 'Aktive økter',
    'ui__reseller/sessions_unknown__description' => 'Vis aktive Plesk-økter.',
    'ui__reseller/sessions_self__short-title' => 'Aktive økter',
    'ui__reseller/sessions_self__title' => 'Aktive økter',
    'ui__reseller/sessions_self__description' => 'Vis aktive Plesk-økter.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'E-postkonto under brukerkonto %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Mal for virtuell vert',
    'ui__client/skeleton_self__title' => 'Mal for virtuell vert',
    'ui__client/skeleton_self__description' => 'Angi filer og mapper som skal plasseres i katalogene til nylig opprettede domener.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Ressursbruk',
    'ui__client/limits__title' => 'Ressursbruk',
    'ui__client/limits__description' => "Vis og administrer ressursbruk for kunde %1.",
    'ui__client/limits_unknown__short-title' => 'Ressursbruk',
    'ui__client/limits_unknown__title' => 'Ressursbruk',
    'ui__client/limits_unknown__description' => 'Vis og administrer ressursbruk for kunde.',
    'ui__client/limits_readonly__short-title' => 'Ressursbruk',
    'ui__client/limits_readonly__title' => 'Ressursbruk',
    'ui__client/limits_readonly__description' => 'Vis ressursbruk for kunde %1.',
    'ui__client/limits_self__short-title' => 'Ressursbruk',
    'ui__client/limits_self__title' => 'Ressursbruk',
    'ui__client/limits_self__description' => "Se og administrer ditt ressursforbruk.",
    'ui__client/limits_readonly-self__short-title' => 'Ressursbruk',
    'ui__client/limits_readonly-self__title' => 'Ressursbruk',
    'ui__client/limits_readonly-self__description' => "Se ditt ressursforbruk.",
    'ui__client/domain/traffic_unknown__short-title' => "Trafikkbruk etter domener %1",
    'ui__client/domain/traffic_unknown__title' => "Vis trafikkbruk etter domener",
    'ui__client/domain/traffic_unknown__description' => "Vis rapporter om trafikkbruk for domenene dine.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Oppsummeringsrapport',
    'ui__client/report__short-title' => 'Oppsummeringsrapport',
    'ui__client/report__description' => 'Vis rapport om trafikkbruk og ressurser for denne kunden.',
    'ui__client/report_unknown__short-title' => 'Oppsummeringsrapport',
    'ui__client/report_unknown__title' => 'Oppsummeringsrapport',
    'ui__client/report_unknown__description' => 'Vis rapport om trafikkbruk og ressurser for kunden.',
    'ui__client/report_self__short-title' => 'Oppsummeringsrapport',
    'ui__client/report_self__title' => 'Oppsummeringsrapport',
    'ui__client/report_self__description' => 'Se rapport over bruk av trafikk og ressurser.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Grensesnitt preferanser',
    'ui__client/preferences__title' => 'Grensesnitt preferanser',
    'ui__client/preferences__description' => 'Sett grensesnittpreferanser for Plesk for kunde %1.',
    'ui__client/preferences_unknown__short-title' => 'Grensesnitt preferanser',
    'ui__client/preferences_unknown__title' => 'Grensesnitt preferanser',
    'ui__client/preferences_unknown__description' => "Sett grensesnittpreferanser for kundens Plesk.",
    'ui__client/preferences_self__short-title' => 'Grensesnitt preferanser',
    'ui__client/preferences_self__title' => 'Grensesnitt preferanser',
    'ui__client/preferences_self__description' => 'Sett opp grensesnittinnstillinger for ditt Plesk.',
    'ui__client/logo__title' => 'Profilering av Plesk',
    'ui__client/logo__short-title' => 'Profilering av Plesk',
    'ui__client/logo__description' => "Endre merking på kunde %1s Plesk.",
    'ui__client/logo_self__title' => 'Profilering av Plesk',
    'ui__client/logo_self__short-title' => 'Profilering av Plesk',
    'ui__client/logo_self__description' => 'Omprofiler Plesk, skift logo og tittellinjen i nettleseren.',
    'ui__client/permissions__title' => 'Tillatelser',
    'ui__client/permissions__short-title' => 'Tillatelser',
    'ui__client/permissions__description' => "Vis eller endre handlingene som kunde %1 kan utføre i Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Tillatelser',
    'ui__client/permissions_unknown__title' => 'Tillatelser',
    'ui__client/permissions_unknown__description' => "Vis eller endre handlingene kunden kan utføre i Plesk.",
    'ui__client/permissions_self__title' => 'Tillatelser',
    'ui__client/permissions_self__short-title' => 'Tillatelser',
    'ui__client/permissions_self__description' => "Vis liste av handlinger du kan utføre i Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Tillatelser',
    'ui__client/permissions_readonly-self__short-title' => 'Tillatelser',
    'ui__client/permissions_readonly-self__description' => "Vis liste av handlinger du kan utføre i Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__client/extras-domain__title' => 'Verktøy fra MyPlesk.com',
    'ui__client/extras-domain__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Verktøy fra MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Verktøy fra MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Registrer domene',
    'ui__client/register-domain__short-title' => 'Registrer domene',
    'ui__client/register-domain__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Registrer domene',
    'ui__client/register-domain_unknown__short-title' => 'Registrer domene',
    'ui__client/register-domain_unknown__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Registrer domene',
    'ui__client/register-domain_self__short-title' => 'Registrer domene',
    'ui__client/register-domain_self__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Administrer domene',
    'ui__client/manage-domain__short-title' => 'Administrer domene',
    'ui__client/manage-domain__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Administrer domene',
    'ui__client/manage-domain_unknown__short-title' => 'Administrer domene',
    'ui__client/manage-domain_unknown__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Administrer domene',
    'ui__client/manage-domain_self__short-title' => 'Administrer domene',
    'ui__client/manage-domain_self__description' => 'Administrer registrerte domenenavn gjennom MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'IP-adresser',
    'ui__client/ipaddress_unknown__short-title' => "IP-adresser",
    'ui__client/ipaddress_unknown__description' => "Administrer IP adresser.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Domenealiaser',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Domenealiaser',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Vis listen over alternative navn for domenet ditt.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Aktive økter',
    'ui__client/sessions__title' => 'Aktive økter',
    'ui__client/sessions__description' => 'Vis aktive Plesk-økter.',
    'ui__client/sessions_unknown__short-title' => 'Aktive økter',
    'ui__client/sessions_unknown__title' => 'Aktive økter',
    'ui__client/sessions_unknown__description' => 'Vis aktive Plesk-økter.',
    'ui__client/sessions_self__short-title' => 'Aktive økter',
    'ui__client/sessions_self__title' => 'Aktive økter',
    'ui__client/sessions_self__description' => 'Vis aktive Plesk-økter.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Arbeid med fysiske og virtuelle filer og mapper under nettsted %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Virtuelle mapper', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Arbeid med fysiske og virtuelle filer og mapper under ditt nettsted.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => '%1 Trafikkbruk',
    'ui__client/domain/traffic__title' => 'Dataoverføringsstatistikk for <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Vis statistikk for dataoverføring for domenet %1.',
    'ui__client/domain/traffic_self__short-title' => 'Trafikkforbruk',
    'ui__client/domain/traffic_self__title' => 'Vis trafikkbruk for domenet ditt',
    'ui__client/domain/traffic_self__description' => 'Vis rapport om trafikkbruk for domenet ditt.',
    'ui__client/domain/hosting/logs__short-title' => 'Logg administrator',
    'ui__client/domain/hosting/logs__title' => 'Logg administrator',
    'ui__client/domain/hosting/logs__description' => 'Se logg og konfigurere loggrotasjon.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Logg administrator',
    'ui__client/domain/hosting/logs_self__title' => 'Logg administrator',
    'ui__client/domain/hosting/logs_self__description' => 'Se logg og konfigurere loggrotasjon.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Endre navn på domene',
    'ui__client/domain/rename__short-title' => 'Endre navn på domene',
    'ui__client/domain/rename__description' => 'Endre navn på domene %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Endre navn på domene',
    'ui__client/domain/rename_unknown__title' => 'Endre navn på domene',
    'ui__client/domain/rename_unknown__description' => 'Endre navn på et domene',
    'ui__client/domain/chowner_select__title' => 'Tildel ny eier av domenet',
    'ui__client/domain/chowner_select__short-title' => 'Tildel ny eier av abonnementet',
    'ui__client/domain/chowner_select__description' => 'Tildel ny eier av abonnementet',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Tildel ny eier av abonnementet',
    'ui__client/domain/chowner_unknown-select__title' => 'Tildel ny eier av abonnementet',
    'ui__client/domain/chowner_unknown-select__description' => 'Tildel ny eier av et abonnement.',
    'ui__client/domain/toggle__title' => 'Suspender eller aktiver domene', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Suspender eller aktiver domene', // for HP customization
    'ui__client/domain/toggle__description' => 'Suspender eller aktiver domene %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Suspender eller aktiver domene', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Suspender eller aktiver domene', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Suspender eller aktiver et domene.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Aktiver domene',
    'ui__client/domain/toggle_enable__short-title' => 'Aktiver domene',
    'ui__client/domain/toggle_enable__description' => 'Aktiver domene %1.',
    'ui__client/domain/toggle_disable__title' => 'Suspender domene',
    'ui__client/domain/toggle_disable__short-title' => 'Suspender domene',
    'ui__client/domain/toggle_disable__description' => 'Deaktiver domene %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'DNS-innstillinger',
    'ui__client/domain/dns__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns__description' => 'Administrer innstillinger for DNS-sonen for domene %1.',
    'ui__client/domain/dns_self__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_self__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_self__description' => 'Administrer innstillinger for DNS-sonen for domenet ditt.',
    'ui__client/domain/dns_disabled__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_disabled__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_disabled__description' => 'Administrer innstillinger for DNS-sonen for domene %1.',
    'ui__client/domain/dns_self-disabled__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_self-disabled__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_self-disabled__description' => 'Administrer innstillinger for DNS-sonen for domenet ditt.',
    'ui__client/domain/dns_readonly__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly__description' => 'Vis innstillinger for DNS-sonen for domene %1.',
    'ui__client/domain/dns_readonly-self__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-self__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-self__description' => 'Vis innstillinger for DNS-sonen for domenet ditt.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Vis innstillinger for DNS-sonen for domenet ditt.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Vis innstillinger for DNS-sonen for domenet ditt.',
    'ui__client/domain/dns_slave__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_slave__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_slave__description' => 'Administrer innstillinger for DNS-sonen for domene %1.',
    'ui__client/domain/dns_self-slave__title' => 'DNS-innstillinger',
    'ui__client/domain/dns_self-slave__short-title' => 'DNS-innstillinger',
    'ui__client/domain/dns_self-slave__description' => 'Administrer innstillinger for DNS-sonen for domenet ditt.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__client/domain/extras__title' => 'Verktøy fra MyPlesk.com',
    'ui__client/domain/extras__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Verktøy fra MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Verktøy fra MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Verktøy fra MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Få ytterligere verktøy og tjenester fra MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Registrer domene',
    'ui__client/domain/register__title' => 'Registrer domene',
    'ui__client/domain/register__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Registrer domene',
    'ui__client/domain/register_unknown__title' => 'Registrer domene',
    'ui__client/domain/register_unknown__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Registrer domene',
    'ui__client/domain/register_self__title' => 'Registrer domene',
    'ui__client/domain/register_self__description' => 'Registrer et domenenavn gjennom MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Verktøy",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Vis statistikk',
    'ui__client/domain-summary-report_unknown__title' => 'Vis statistikk',
    'ui__client/domain-summary-report_unknown__description' => 'Vis informasjon om ressursbruk etter domener.',
    'ui__client/domain-summary-report__short-title' => "Vis statistikk",
    'ui__client/domain-summary-report__title' => "Vis statistikk",
    'ui__client/domain-summary-report__description' => "Vis informasjon om ressursbruk etter domener.",
    'ui__client/domain-summary-report_self__short-title' => "Vis statistikk",
    'ui__client/domain-summary-report_self__title' => "Vis statistikk",
    'ui__client/domain-summary-report_self__description' => "Vis informasjon om ressursbruk etter domenene dine.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Domener", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Du må velge de domenene du ønsker å fjerne',
    'ui__client/domain/chowner__empty_selection' => 'Du må velge domenene du ønsker å tildele en ny eier',

    // list objects filtering
    'domains_list__name__filter_title' => 'Navn',
    'domains_list__state__filter_title' => 'Ressursbruk',
    'domains_list__filter_state_any' => 'Hvilken som helst',
    'domains_list__filter_state_overuse' => 'Overforbruk',
    'domains_list__filter_state_normal' => 'Innenfor grenser',
    'domains_list__status__filter_title' => 'Status',
    'domains_list__filter_status_any' => 'Hvilken som helst',
    'domains_list__filter_status_blocked' => 'Suspendert',
    'domains_list__filter_status_active' => 'Aktiv',
    'domains_list__ownership__filter_title' => 'Eierskap',
    'domains_list__filter_ownership_all' => 'Alle domener',
    'domains_list__filter_ownership_personal' => 'Kun mine domener',
    'domains_list__filter_owner_pname__filter_title' => 'Eiernavn',
    'domains_list__subrows__filter_title' => 'Vis',
    'domains_list__subrows_off' => 'Kun domener',
    'domains_list__subrows_subdomain_domainaliases' => 'Med underdomener og aliaser',
    'domains_list__subrows_subdomain' => 'Med underdomener',
    'domains_list__subrows_domainaliases' => 'Med aliaser',

    // objects list
    'domains_list__owner__title' => 'Eier',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Se etter programmer",
    'site_apps__promo_main_text' => "Katalogen Application Packaging Standard (APS) inneholder listen over programmer som kan leveres til et domene eller et nettsted. Hvis du vil levere programmer som for øyeblikket ikke er i katalogen, kan du enkelt gjøre dette ved å følge APS",
    'site_apps__promo_download_now' => "Last ned programmer:",
    'site_apps__promo_close' => "Lukk denne blokken",
    'site_apps__promo_preset__mostused' => '%1 Mest populær',
    'site_apps__promo_preset__lessused' => 'Neste %1 mest populær',
    'site_apps__promo_preset__all' => "Alle",
    'site_apps__promo_disclaimer_note' => 'Vennligst merk at programmer som installeres fra APS-katalogen leveres av tredjeparter og støttes ikke av Plesk.',
    'site_apps__promo_preset__page_title' => '%1 APS-programmer',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Legger til programmer...',

    // Errors
    'site_apps__no_applications_for_update' => 'Du har ingen programmer installert i Programhvelvet.',
    'site_apps__incorrect_download_preset_configuration' => 'Det ble funnet feil i konfigurasjonen av APS katalogens nedlastnings forhåndsinnstillinger',
    'site_apps__aps_catalog_url_is_invalid' => 'Spesifisert URL er ugyldig.',
    'site_apps__no_updates_at_the_moment' => 'Det er for øyeblikket ingen tilgjengelige programoppdateringer.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Feil informasjon ble mottatt fra APS-programkatalogen. Prøv på nytt senere.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Kataloginnstillinger for APS ble lagret, men Plesk kunne ikke opprette en tilkobling til APS-katalogen som er spesifisert i kataloginnstillingene for APS (%1). Forsikre deg om at APS katalog adressen er korrekt og at APS katalogen på denne adressen er aktiv.',
    'site_apps__cannot_retrieve_updates' => 'Kan for øyeblikket ikke laste ned programoppdateringer: kunne ikke etablere tilkobling til APS-katalogen (%1). Forsikre deg om at APS katalog adressen er korrekt og at APS katalogen på denne adressen er aktiv.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Det finnes ingen webprogrammer tilgjengelig for installasjon.',
    'site_apps__site_applications_already_installed_in_root' => 'Andre webprogrammer er allerede installert i rotkatalogene på disse virutelle vertene',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => ".NET web-programmer støttes ikke på Unix/Linux-plattformen",
    'site_apps__server_wide_packages_not_supported' => 'Webprogrammer for hele serveren støttes ikke',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 flere webprogrammer er planlagt å legges til Programhvelvet.",
    'site_apps__applications_all_in_vault' => "De valgte webprogrammene er allerede til stede i Programhvelvet.",
    'site_apps__applications_already_in_download_queue' => "%1 valgte webprogrammer legges for øyeblikket til Programhvelvet.",
    'site_apps__applications_already_in_valut' => "%1 valgte webprogrammer er i Programhvelvet.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Andre (ikke kategoriserte)',

    // Errors
    'site_apps__no_applications_in_category' => 'Det finnes ingen tilgjengelige programmer i denne kategorien. Velg en annen kategori.',
    'site_apps__no_category_selected__please_specify' => 'Velg kategori i meny til venstre. Alle tilgjengelige programmer i den valgte kategorien vil bli oppført i dette vinduet.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Administratorkonto',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Generelt',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Endre vertsnavn',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'Sikkerhet',
    'bt_setup_firewall' => 'Konfigurer brannvegg',
    'bt_manage_firewall_rules' => 'Administrer brannvegg regler',
    'cu_firewall__rule' => 'Opprett en brannvegg regel',
    'cu_firewall__protocol' => 'Definer en protokoll for regelen (\'tcp\' eller \'udp\')',
    'cu_firewall__name' => "Definer et regelnavn",
    'cu_firewall__disabled' => 'Dersom det er \'true\', deaktiveres reglen etter etablering',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Velg DNS-server', // PFW
    'bt_soa_records_template' => 'Mal for SOA oppføringer',
    'bt_restrict_creation_of_subzones' => 'Begrens oppretting av undersoner',

    'databases' => 'Databaser',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Programmer',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'E-post',
    'bt_select_mailserver' => 'Velg e-postserver', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Velg antivirus', // PFW
    'bt_virus_protection_settings' => 'Virusbeskyttelsesinnstillinger',
    'bt_select_spamfilter' => 'Velg filter for søppelpost', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Velg e-posttjeneste',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Logger og statistikker',
    'bt_server_statistics_settings' => 'Innstillinger for serverstatistikk',
    'bt_select_web_statistics' => 'Tilgjengelige nettstatistikk-programvare', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Plesk grensesnitt',

    'components_and_modules' => 'Komponenter og moduler',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Konfigurer watchdog', // PFU
    'bt_setup_vpn' => 'Konfigurer VPN', // PFU
    'bt_setup_samba' => 'Konfigurer samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Innstillinger',
    'ui__client/domain/settings_self__short-title' => 'Innstillinger',
    'ui__client/domain/settings_self__description' => 'Vis og endre domeneinnstillinger.',

    'domain_administrator_account' => 'Domeneadministratorkonto',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Kontoinnstillinger',

    'domain' => 'Domene',
    'bt_dns_soa_records' => 'DNS SOA oppføringer',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Innstillinger for oppgaveplanlegging',

    'website' => 'Nettsted',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Skripting for nett-brukere',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Velg SSL/TLS-sertifikat',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Web statistikk',
    'bt_log_rotation_settings' => 'Loggrotasjonsinnstillinger',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Grenser", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Overbruk og oversalg policy",
    'limits__overuse_policy_legend' => "Overforbruk",
    'limits__oversell_policy_legend' => "Overselge",
    'limits__reseller_overuse_description' => "Retningslinjer for overforbruk forteller Plesk hva som skal gjøres når det forekommer overforbruk av ressurser.",
    'limits__overuse_text' => "Overbruk policy",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Disklagringsplass og trafikk',
    'limit__disk_space' => 'Diskplass',
    'limit__max_traffic' => 'Trafikk',
    'limit_group__client' => 'Kunder',
    'limit__max_cl' => 'Kunder',
    'limit_group__domain' => 'Domener',
    'limit__max_dom' => 'Domener',
    'limit__max_dom_powerUser' => 'Abonnementer',
    'limit__max_subdom' => 'Underdomener',
    'limit__max_dom_aliases' => 'Domenealiaser',
    'limit__max_wu' => 'Webbrukere',
    'limit__max_subftp_users' => 'Ekstra FTP-kontoer', // PFW
    'limit_group__mail' => 'E-post',
    'limit__max_box' => 'Postbokser',
    'limit__mbox_quota' => 'Postboksstørrelse',
    'limit__total_mboxes_quota' => 'Total kvote for e-postbokser', // PFW
    'limit__max_maillists' => 'Adresselister',
    'limit_group__database' => 'Databaser',
    'limit__max_mssql_db' => 'Microsoft SQL Server-databaser', // PFW
    'limit__mssql_dbase_space' => 'Sum kvote av MS SQL-databaser', // PFW
    'limit__max_odbc' => 'ODBC tilkoblinger', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'MySQL databasekvote', // PFW
    'limit__pgsql_dbase_space' => 'PostgreSQL databasekvote', // PFW
    'limit_group__application' => 'Programmer',
    'limit__max_iis_app_pools' => 'IIS-programutvalg', // PFW
    'limit_group__security' => 'Sikkerhet',
    'limit_group__validity' => 'Utløpsdato',
    'limit__expiration' => 'Utløpsdato',
    'limit__validity' => 'Gyldighetsperiode',
    'limit__max_site_builder' => 'Områder publisert med Presence Builder',
    'limit__max_site' => 'Domener',
    'limit__mssql_dbase_filesize' => 'MS SQL-database filstørrelse',
    'limit__mssql_dbase_log_filesize' => 'MS SQL-database størrelse på loggfil',
    'limit__mssql_dbase_filesize_hint' => 'Den maksimale størrelsen på en fil i en Microsoft SQL-database.',
    'limit__mssql_dbase_log_filesize_hint' => 'Den maksimale størrelsen på en loggfil i en Microsoft SQL-database.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Ugyldig domenegrense. Den minste verdien er 1.',

    'property__has_wrong_value' => 'Egenskapen %1 har feil verdi.',
    'property__name_outgoing_messages_domain_limit' => 'Setter grensen for utgående meldinger fra et domene (pr time) For å sette ubegrenset verdi, angi "-1". Spesifiser «standard» for å sette den angitte verdien i innstillinger for hele serveren.',
    'property__name_outgoing_messages_mbox_limit' => 'Setter grensen for utgående meldinger fra en postboks (pr time) For å sette ubegrenset verdi, angi "-1". Spesifiser «standard» for å sette den angitte verdien i innstillinger for hele serveren.',
    'property__name_outgoing_messages_subscription_limit' => 'Setter grensen for utgående meldinger fra et abonnement (pr time) For å sette ubegrenset verdi, angi "-1". Spesifiser «standard» for å sette den angitte verdien i innstillinger for hele serveren.',

    // for CLI report & email notifications
    '__resource_notify' => 'Varsle',
    '__general' => 'Generelt',
    '__template_shared' => 'Delt mal',
    'limit__overuse' => 'Overbruk policy',
    'limit__max_traffic_soft' => 'Gi beskjed når forbruket av trafikk når',
    'limit__disk_space_soft' => 'Gi beskjed når forbruket av disklagringsplass når',
    '__overuse' => 'Overbruk policy',
    'performance__title' => 'Ytelse',
    'performance__bandwidth' => 'Maksimalt båndbredde forbruk (KB/s)',
    'performance__max_connections' => 'Tilkoblinger begrenset til',

    'gch__hosting_php_isapi' => 'Kjør PHP som ISAPI utvidelse',
    'gch__hosting_ssi_html' => 'Bruk SSI for *.htm, *.html filer',
    'gch__hosting_php_handler_type' => 'kjør PHP som',
    'gch__hosting_php_handler_id' => 'kjør PHP som',
    'gch__hosting_php_served_by_nginx' => 'PHP betjent av ngnix',
    'gch__hosting_unpaid_website_status' => 'Status for nettsteder med suspenderte abonnementer',
    'gch__mn_no_autoresponder' => 'Det er ikke satt opp noen auto-svar for e-postkontoen.',
    'gch__no_clients_selected' => "Ingen kundekontoer valgt",
    'gch__no_domains_selected' => "Ingen domener valgt",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/måned",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Ressursnavn',
    '__resource_usage' => 'Brukt',
    '__resource_limit' => 'Grense',

    '__used' => 'Brukt',
    '__limit' => 'Grense',

    '__never_expires' => 'Aldri utløper',
    '__resource_free' => '%1 ledig av %2',
    '__resource_unlimited' => '%1 brukt av Ubegrenset',

    '__unlimited' => 'Ubegrenset',
    '__increment' => "Øk (+)",
    '__decrement' => "Reduser (-)",
    '__pt' => 'Enheter',
    '__procent' => '%',
    '__overused' => 'Overforbrukt',
    '__left' => 'left',
    '__available' => 'ledig',
    '__not_available' => 'Ikke inkludert',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Tidsplan for leveranse',
    'ui__admin/report/layout/auto_unknown__title' => 'Tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto_unknown__description' => 'Velg tidsplan for rapportleveranse for et rapport oppsett.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Legg til tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto/properties_new__title' => 'Legg til tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto/properties_new__description' => 'Legg til en tidsplan for leveranse av rapport %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto/properties__title' => 'Tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto/properties__description' => 'Se og endre egenskaper for rapportleveranse tidsplan.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Fjern tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Fjern tidsplan for rapportleveranse',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Ta bort valgte tidsplaner for rapportleveranse.',

    'ui__admin/report/layout_unknown__short-title' => 'Rapportoppsett',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Vis trafikkbruk for <b>%1</b>',
    'ui__reseller/traffic__description' => 'Vis rapporter om trafikkbruk for forhandlerkonto %1.',
    'ui__reseller/traffic_self__short-title' => 'Min',
    'ui__reseller/traffic_self__title' => 'Vis trafikkbruk etter kunder',
    'ui__reseller/traffic_self__description' => 'Vis rapporter om trafikkbruk for kundekontoene dine.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'W',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Forhandlernavn', // reseller report
    'report__full_client_name' => 'Kundenavn', // customer report
    'report__full_domain_name' => 'Domenenavn', // domain report
    'report__full_owner' => 'Eier', // customer & domain reports
    'report__full_creation_date' => 'Opprettelsesdato',
    'report__full_size' => 'Størrelse',
    'report__full_traffic' => 'Trafikk',
    'report__full_active_clients' => 'Aktiver kunder', // reseller report
    'report__full_clients' => 'Kunder', // reseller report
    'report__full_active_domains' => 'Aktive domener', // reseller & customer reports
    'report__full_domains' => 'Domener', // reseller & customer reports
    'report__full_subdomains' => 'Subdom',
    'report__full_mboxes' => 'MBoxes',
    'report__full_disk_space' => 'Diskplass',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Resp',
    'report__full_mail_antispam' => 'ASpam',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'MailList',
    'report__full_web_users' => 'WebUsr',
    'report__full_mysql_databases' => 'MySQL DB',
    'report__full_mssql_databases' => 'MSSQL DB',
    'report__full_pgsql_databases' => 'PostgreSQL DB',

    // common summary report
    'report__section_general' => 'Generelt',
    'report__version' => 'Produktversjon',
    'report__build' => 'Produktversjon',
    'report__status' => 'Status',
    'report__company_name' => 'Firmanavn',
    'report__personal_name' => 'Navn',
    'report__login' => 'Brukernavn',
    'report__phone' => 'Telefon',
    'report__fax' => 'Faks',
    'report__email' => 'E-post',
    'report__address' => 'Adresse',
    'report__city' => 'Poststed',
    'report__state' => 'Delstat/område',
    'report__zip_code' => 'Postnummer',
    'report__country' => 'Land',
    'report__creation_date' => 'Opprettelsesdato',
    'report__expiration_date' => 'Utløpsdato',
    'report__dumps_total_size' => 'Total størrelse av sikkerhetskopi filer',
    'report__section_resellers' => 'Videreforhandler',
    'report__active_resellers' => 'Forhandlere med aktiver abonnementer',
    'report__resellers' => 'Videreforhandler',
    'report__section_full_resellers' => 'Videreforhandler',
    'report__section_clients' => 'Kunder',
    'report__active_clients' => 'Kunder med aktive abonnementer',
    'report__clients' => 'Kunder',
    'report__section_full_clients' => 'Kunder',
    'report__section_personal_clients' => 'Egne kunder',
    'report__active_personal_clients' => 'Dine kunder med aktive abonnementer',
    'report__personal_clients' => 'Egne kunder',
    'report__section_full_personal_clients' => 'Egne kunder',
    'report__section_domains' => 'Domener',
    'report__disk_usage' => 'Diskbruk',
    'report__traffic' => 'Trafikk',
    'report__active_domains' => 'Aktive domener',
    'report__domains' => 'Domener',
    'report__subdomains' => 'Underdomener',
    'report__mboxes' => 'Postbokser',
    'report__mail_groups' => 'Videresendt e-post',
    'report__mail_autoresp' => 'Autosvar',
    'report__mail_lists' => 'Adresselister',
    'report__web_users' => 'Webbrukere',
    'report__mysql_databases' => 'MySQL databaser',
    'report__mssql_databases' => 'MSSQL databaser',
    'report__pgsql_databases' => 'PostgreSQL-databaser',
    'report__section_full_domains' => 'Domener',
    'report__section_personal_domains' => 'Personlige domener',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Personlige domener',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Områder publisert med Presence Builder',
    'report__invalid_email' => 'Angi en gyldig e-postadresse.',


    // CLI-specific sections
    'report__section_hosting' => 'Hosting',
    'report__section_webusers' => 'Nettbrukere',
    'report__section_mailnames' => 'E-postkontoer',
    'report__section_maillists' => 'Adresselister',
    'report__section_databases' => 'Databaser',
    'report__section_siteapps' => 'Web Applikasjoner',
    'report__section_aspnetapps' => 'ASP.NET-programmer', // PFW
    'report__owner_pname' => "Leverandørens personnavn",
    'report__owner_login' => "Leverandørens brukernavn",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Tidsplan for leveranse',
    'ui__reseller/report/layout/auto_unknown__title' => 'Tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto_unknown__description' => 'Velg tidsplan for rapportleveranse for et rapport oppsett.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Legg til tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Legg til tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Legg til en tidsplan for leveranse av rapport %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto/properties__title' => 'Tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto/properties__description' => 'Se og endre egenskaper for rapportleveranse tidsplan.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Fjern tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Fjern tidsplan for rapportleveranse',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Ta bort valgte tidsplaner for rapportleveranse.',

    'ui__reseller/report/layout_unknown__short-title' => 'Rapportoppsett',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Vis trafikkbruk for <b>%1</b>',
    'ui__client/traffic__description' => 'Vis rapporter for trafikkbruk for kundekonto %1.',
    'ui__client/traffic_self__short-title' => 'Trafikkforbruk',
    'ui__client/traffic_self__title' => 'Trafikkbruk etter domener',
    'ui__client/traffic_self__description' => 'Vis rapporter for trafikkbruk for domenene dine.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Angitt språkpakke er installert men ikke aktivert i systemet.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Slett økter.',
    'ui__sessions/delete__title' => 'Slett økter.',
    'ui__sessions/delete__description' => 'Slett valgte økter.',
    'ui__ftp-sessions__short-title' => 'FTP økter',
    'ui__ftp-sessions__title' => 'FTP økter',
    'ui__ftp-sessions__description' => 'Se FTP økter.',
    'ui__ftp-sessions/delete__short-title' => 'Slett FTP økter.',
    'ui__ftp-sessions/delete__title' => 'Slett FTP økter.',
    'ui__ftp-sessions/delete__description' => 'Slett valgte FTP økter.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Slett økter.',
    'ui__reseller/sessions/delete__title' => 'Slett økter.',
    'ui__reseller/sessions/delete__description' => 'Slett valgte økter.',
    'ui__reseller/sessions/delete_self__short-title' => 'Slett økter.',
    'ui__reseller/sessions/delete_self__title' => 'Slett økter.',
    'ui__reseller/sessions/delete_self__description' => 'Slett valgte økter.',
    'ui__reseller/ftp-sessions__short-title' => 'FTP økter',
    'ui__reseller/ftp-sessions__title' => 'FTP økter',
    'ui__reseller/ftp-sessions__description' => 'Se FTP økter.',
    'ui__reseller/ftp-sessions_self__short-title' => 'FTP økter',
    'ui__reseller/ftp-sessions_self__title' => 'FTP økter',
    'ui__reseller/ftp-sessions_self__description' => 'Se FTP økter.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Slett FTP økter.',
    'ui__reseller/ftp-sessions/delete__title' => 'Slett FTP økter.',
    'ui__reseller/ftp-sessions/delete__description' => 'Slett valgte FTP økter.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Slett FTP økter.',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Slett FTP økter.',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Slett valgte FTP økter.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Slett økter.',
    'ui__client/sessions/delete__title' => 'Slett økter.',
    'ui__client/sessions/delete__description' => 'Slett valgte økter.',
    'ui__client/sessions/delete_self__short-title' => 'Slett økter.',
    'ui__client/sessions/delete_self__title' => 'Slett økter.',
    'ui__client/sessions/delete_self__description' => 'Slett valgte økter.',

    // domain administrator

    'forgery_token_expired' => 'Øktstokenet har utløpt.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Følgende forhandlerkontoer vil bli konvertert til kundekontoer',
    'downgradeResellers__downgrade' => 'Forhandlerkontoer som vil bli konvertert',
    // controls
    'downgradeResellers__submit_downgrade' => 'Utfør konvertering av konto.',
    'downgradeResellers__cancel_downgrade' => 'Avbryt konvertering av konto',
    'downgradeResellers__confirm' => 'Bekreft konvertering',
    'downgradeResellers__confirm_message' => 'Bekreft kontokonverteringen for å gå videre',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Velg kundekontoer',
    'upgradeClients__upgrade_clients' => 'Følgende kundekontoer vil bli konverter til forhandlerkontoer',
    'upgradeClients__upgrade' => 'Kundekontoer som vil bli konvertert',
    // controls
    'upgradeClients__submit_upgrade' => 'Utfør konvertering av konto.',
    'upgradeClients__cancel_upgrade' => 'Avbryt konvertering av konto',
    'upgradeClients__confirm' => 'Bekreft konvertering',
    'upgradeClients__confirm_message' => 'Bekreft kontokonverteringen for å gå videre',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Kan ikke konvertere kontoen \'%1\' til en forhandlerkonto: \'%1\' er allerede en forhandler.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Følgende kontoer for domeneadministratorer vil bli konvertert til kundekontoer',
    'upgradeDomainUser__upgrade' => 'Kontoer for domeneadministratorer som vil bli konvertert',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Utfør konvertering av konto.',
    'upgradeDomainUser__cancel_upgrade' => 'Avbryt konvertering av konto',
    'upgradeDomainUser__confirm' => 'Bekreft konvertering',
    'upgradeDomainUser__confirm_message' => 'Bekreft kontokonverteringen for å gå videre',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Kontoer for domeneadministratorer som ikke kan konverteres',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Følgende kontoer for domeneadministratorer kunne ikke konverteres til kundekontoer:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Flere kontoer for domeneadministratorer kunne ikke konverteres til kundekontoer. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Konto for domeneadministratoren finnes ikke',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Domenet skal direkte tilhøre serveradministratoren eller en forhandler.",
    'upgradeDomainUser__all_logins_already_used' => 'Klarte ikke å opprette en konto for resulterende kunde.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Konto for domeneadministrator ble konvertert',
    'upgradeDomainUser__upgrade_notification_body' => 'Konto for domeneadministrator ble konvertert til en kundekonto med brukernavn \'%%login%%\' og passord \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Velg kundekontoer',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Valgt forhandler har ikke rettigheten \'%1\', men noen av kundene har denne rettigheten.',
    'clientOwnerChanger__application_not_allowed' => 'Applikasjonen \'%1\' er ikke tilgjengelig for valgt forhandler, men er tilgjengelig for noen av kundene.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Ny tildeling av valgte abonnementer',
    // errors
    'domain_chown__empty_selection' => 'Du må velge en ny eier for de valgte domenene',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Maksimalt båndbredde forbruk (%1)',
    'hosting_performance__max_connection_label' => 'Tilkoblinger begrenset til',
    'performance__invalid_value' => "Verdien er ugyldig. Må være i området fra %1 til %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Webmail',
    'webmail__server_text' => 'Tilgjengelige webmail klienter',
    'webmail__none' => 'Ingen',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'IP-utvalg for server',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Databasen blir ikke gjenopprettet: ingen passende database server',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Sikkerhetskopi av server.",
    '__default_backup_comment_reseller' => "Sikkerhetskopi av forhandlerkonto opprettet av %1.",
    '__default_backup_comment_client' => "Sikkerhetskopi av kundekonto opprettet av %1.",
    '__default_backup_comment_domain' => "Sikkerhetskopi av abonnement opprettet av %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "IP-utvalget til kunde %1",
    'backup__ip_mapping__resellers_ip' => "IP-utvalg til forhandleren %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Virtuell vert',
    'backup__restore__object_plesk_admin' => 'Plesk administrator',
    'backup__restore__object_ftpuser' => 'FTP-konto',
    'backup__restore__object_frontpageuser' => 'FrontPage-konto',
    'backup__restore__object_webuser' => 'webbruker',
    'backup__restore__object_domain' => 'domene',
    'backup__restore__object_subdomain' => 'subdomene',
    'backup__restore__object_domainalias' => 'domenealias',
    'backup__restore__object_client' => 'kunde',
    'backup__restore__object_reseller' => 'forhandler',
    'backup__restore__object_autoresponder' => 'autosvar',
    'backup__restore__object_mailalias' => 'e-post-alias',
    'backup__restore__object_database' => 'database',
    'backup__restore__object_mailname' => 'e-postkonto',
    'backup__restore__object_db_user' => 'databasebruker',
    'backup__restore__object_ssl_certificate' => 'SSL/TLS-sertifikat',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Følgende forhandlere kan ikke gjenopprettes fordi de er konvertert til kunder: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Følgende kunder kan ikke gjenopprettes fordi de er konvertert til forhandlere: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Følgende kunder kan ikke gjenopprettes fordi de er flyttet til en annen eier: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Utilstrekkelig diskplass på målserveren til å overføre alle valgte abonnementer. Tilgjengelig: %1 MB. Påkrevet: %2 MB. Merk at plassen som kreves beregnes som en sum av web-, e-post- og database-innholdet til domenene. Den nødvendige plassen beregnes én gang om dagen og lagres i en buffer, slik at faktisk størrelse på domenet kan være forskjellig fra beregnet størrelse. Hvis du sørger for at valgte domener ikke opptar mer plass enn det som er tilgjengelig, kan du fortsette med overføringen.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Frigjør diskplass på målserveren.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Utilstrekkelig diskplass på kildeserveren for å lagre midlertidige filer for overføring. Tilgjengelig: %1 MB. Påkrevet: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Frigjør diskplass på kildeserveren.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Serverinformasjon',

    'backup__restore__capability_not_installed_component_text' => 'Komponent %1 er ikke installert på målserveren. %1 vil være utilgjengelig for alle gjenopprettede objekter.',
    'backup__restore__capability_not_installed_component_resolution' => 'Vennligst installer %1. Bemerk, at dette kan ta noen minutter.',
    'backup__restore__capability_existing_sys_user_text' => 'Det finnes allerede et system med navnet %1 på målserveren.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Gi den eksisterende systembrukeren nytt navn på målserveren.',
    'backup__restore__capability_license_usage_text' => 'Følgende ressursgrenser (defineres av lisensnøkkelen) vil overskrides på målserveren etter dataoverføring:',
    'backup__restore__capability_license_usage_resolution' => 'Vennligst installer en annen lisensnøkkel på målserveren som vil gi den mengden ressurser som kreves.',
    'backup__restore__capability_max_allowed_packet_text' => "Parameteren 'max_allowed_packet' på kildeserveren for databasen er %1, noe som er større enn på målserveren, der den er %2. Noen databaseobjekter for domenene som er angitt under vil kanskje ikke bli gjenopprettet.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Øk verdien for 'max_allowed_packet' på måldatabaseserveren.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Kan ikke overføre PostgreSQL databasene fordi PostgreSQL-versjonen på målserveren er tidligere enn på kildeserveren. Nåværende versjon er %1, den påkrevede versjonen er %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Installer den påkrevde versjonen av PostgreSQL på målserveren.',
    'backup__restore__capability_db_server_connection_problems' => 'Kan ikke koble til PostgreSQL måldatabaseserveren. Databaser vil ikke bli overført med mindre du gjenoppretter forbindelsen.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Kontroller tilkoblingsinnstillingene på måldatabaseserveren.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Komponenten %1 er deaktivert på målserveren.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Aktiver %1 på målserveren.',
    'backup__restore__capability_not_configured_component_text' => 'Komponenten %1 er ikke konfigurert på målserveren.',
    'backup__restore__capability_not_configured_component_resolution' => 'Konfigurer %1 på Verktøy & Innstillinger-siden.',

    'backup__restore__capability_webmail_is_not_available' => 'Eposttjenesten %1 er ikke tilgjengelig på målserveren. Plesk vil i stedet benytte følgende eposttjeneste: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'For å bruke samme e-post som på kildeserveren, må du installere det på denne serveren.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'For å bruke samme e-post som på kildeserveren, må du installere det på målserveren.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "'%1' e-post er ikke tilgjengelig på målserveren. På følgende abonnementer: %3, vil Plesk benytte følgende eposttjeneste: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Installer den påkrevde e-posten på målserveren.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'E-postinnstillinger',

    'backup__restore__capability_shell_is_not_available' => 'Skall %1 er ikke tilgjengelig på målserveren. Et av de tilgjengelige skallene vil bli benyttet i stedet.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'For å bruke samme skall som på kildeserveren, må du slå det på (i /etc/shells) eller installere det på målserveren.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'DNS-målserveren støtter ikke nettverk i malen for overføringsbegrensninger. Oppføringene med nettverk IP adresser i DNS overføring begrensningene vil ikke gjenopprettes.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'DNS-målserver støtter ikke nettverk under Mal for overføringsbegrensninger, men noen abonnementer har nettverk med DNS overføringsbegrensninger. Oppføringene med nettverk IP adresser i DNS overføring begrensningene vil ikke gjenopprettes.',

    'backup__restore__capability_wrong_php_handler_text' => 'PHP-behandlingsprogram %1 er ikke tilgjengelig på målserveren. Plesk vil bruke følgende PHP-behandlingsprogram i stedet: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'For å bruke samme PHP-behandlingsprogram som på kildeserveren, må du aktivere eller installere det på målserveren.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'PHP-behandlingsprogram %1 er ikke tilgjengelig. Plesk vil i stedet bruke %2 for følgende tjenesteplaner: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'PHP-behandlingsprogram %1 er ikke tilgjengelig. Plesk vil i stedet bruke %2 for følgende nettsteder: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'PHP-behandlingsprogrammet %1 er ikke tilgjengelig. Det vil ikke være tilgjengelig for følgende nettsteder: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 er ikke tilgjengelig på målserveren. Standardversjonen vil bli brukt i stedet.',
    'backup__restore__capability_wrong_component_version_resolution' => 'For å bruke samme %1 som på kildeserveren, må du aktivere eller installere det på målserveren.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Brukspolicy for antivirus på målserveren tillater ikke personlige (pr e-postadresse) antivirusinnstillinger for utgående e-post. Disse innstillingene vil ikke bli overført.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Brukspolicy for antivirus på målserveren tillater ikke personlige (pr e-postadresse) antivirusinnstillinger for innkommende e-post. Disse innstillingene vil ikke bli overført.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Brukspolicy for antivirus på målserveren tillater ikke personlige (pr e-postadresse) antivirusinnstillinger. Disse innstillingene vil ikke bli overført.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "For å overføre personlige (pr e-postadresse) antivirusinnstillinger, må du aktivere det tilsvarende valget i Verktøy & Innstillinger > Virusbeskyttelse.",
    'backup__restore__capability_antivirus_not_active_text' => 'Ingen antivirus programvare er aktivert. Alle antivirusinnstillingene på målserveren vil ikke fungere før du velger antivirusprogram på målserveren.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'For å bruke samme antivirus som på kildeserveren, må du installere den og velge den i Verktøy & Innstillinger > Virusbeskyttelse > Antivirusinnstillinger',

    'backup__restore__capability_antivirus_another_active_text' => 'Antivirusprogrammet %2 er ikke tilgjengelig på den målserveren. %1 kommer til å brukes i stedet.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'For å bruke samme antivirus som på kildeserveren, må du installere den og velge den i Verktøy & Innstillinger > Virusbeskyttelse > Antivirusinnstillinger',
    'backup__restore__capability_not_available_sni_text' => 'SNI er ikke tilgjengelig på målserveren. Nettstedene som har samme IP-adresse vil ikke kunne benytte individuelle SSL/TLS-sertifikater.',
    'backup__restore__capability_not_available_sni_resolution' => "Kontroller at operativsystemet på målserveren støtter SNI og at støtten for SNI er aktivert i Plesk (huk av for 'Aktiver SNI-støtte som tillater individuelle SSL/TLS-sertifikater på nettsteder med samme IP-adresse' i Verktøy & Innstillinger> Serverinnstillinger",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Serverinnstillinger',

    'backup__restore__capability_vhost_already_exists_text' => 'Nettstedet %1 kan ikke overføres: Det finnes allerede et nettsted med samme navn på målserveren.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Fjern eller gi nytt navn til nettstedet med samme navn på serveren.',
    'backup__restore__capability_removed_vhosts' => 'Følgende abonnementer vil ikke bli gjenopprettet fordi de inneholder domenenavn som allerede finnes på målserveren: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'På kildeserveren er det %3 forskjellige PHP-behandlingsprogram av type %1 og versjon %2. Et behandlingsprogram av riktig type og versjon vil bli brukt i stedet for dem. Merk at PHP-innstillingene på kilde- og målserver kan være forskjellig.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Plesk Installer støtter ikke Microsoft FrontPage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Plesk Installer støtter ikke Python. Vennligst installer Python manuelt.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Innstillinger for e-postserver',

    'backup__restore__capability_ftps_disabled' => 'Bruk av sikker FTPS er tillatt på kildeserveren, men forbudt på målserveren. Brukerapplikasjoner som bruker FTP vil kanskje ikke fungere riktig.',
    'backup__restore__capability_ftps_required' => 'Bruk av usikker FTP er tillatt på kildeserveren, men forbudt på målserveren. Brukerapplikasjoner som bruker FTP vil kanskje ikke fungere riktig.',
    'backup__restore__capability_ftps_policy_resolution' => 'Endre Secure FTP-policyen i Verktøy & Innstillinger > Sikkerhetspolicy.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte data vil bli flyttet fra kildeserveren til målserveren på %2 timer.',
    'backup__restore__capability_too_much_download_time_resolution' => 'For raskere overføring, kontroller nettverksforbindelsen mellom kilde- og målserveren og utbedre eventuelle problemer.',
    'backup__restore__too_low_download_speed' => "mindre enn 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'For raskere overføring, kontroller nettverksforbindelsen mellom kilde- og målserveren og utbedre eventuelle problemer.',
    'backup__restore__capability_zero_download_speed_text' => 'Den minste, akseptable nedlastningshastigheten er %1 MBps. Nedlastingshastigheten mellom kilde- og målserveren er 0 MBps. Dette kan forårsakes av problemene med nettverk oppkoblingen. Overføring er ikke mulig.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Kontroller nettverksforbindelsen mellom kilde- og målserveren og utbedre eventuelle problemer.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Den minste, akseptable nedlastningshastigheten er %2 MBps. Nedlastingshastigheten mellom kilde- og målserveren er %1 MBps. Dette kan komme til å øke overføringstiden. I det aktive miljøet ditt, vil overføring av %3 MB vil ta %4 timer.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Den minste, akseptable nedlastningshastigheten er %2 MBps. Nedlastingshastigheten mellom kilde- og målserveren er %1 MBps. Dette kan komme til å øke overføringstiden.',

    'backup__restore__capability_remote_database_migration' => "Følgende domener bruker eksterne databaser: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Ikke fjern disse domenene fra kildeserveren etter overføringen hvis versjonen av Plesk på kildeseveren er eldre enn 11.5! Avbryt dem i stedet. Hvis du fjerner domenene, vil databasene bli fjernet fra den eksterne serveren. Merk: Dump-filene fra eksterne databaser vil bli lagret på kildeserveren i mappen %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Sikkerhetskopifiler av MySQL databaseservere tidligere enn 5.1 (%1) kan ikke gjenopprettes på MySQL 5.1.x, fordi MySQL 5.1.x håndterer Unicode-tegn annerledes.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Vennligst les den tilhørende kunnskapsbase artikkelen #136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP er ikke installert på målserveren.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Vennligst installer Courier-IMAP ved hjelp av Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot er ikke installert på målserveren.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Vennligst installer Dovecot ved hjelp av Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'De konfigurerte oppbevaringstidene for trafikkstatistikk på følgende objekter er kortere enn de globale verdiene på målserveren.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Endre de globale verdiene for oppbevaringstid for statistikk på målserveren. Sett denne tiden lik eller mindre enn den minste verdien i domenekonfigurasjonen.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Oppbevaringstiden for trafikkstatistikk på noen domener er mindre enn verdien for hele serveren (%1). Verdien vil bli endret til %1 for disse domenene.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Tiden for å beholde trafikkstatistikk for enkelte tjenesteplaner er mindre enn verdien for hele serveren (%1). Verdien vil bli endret til %1 for disse tjenesteplanene.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Tilordning av en eksklusiv IP adresse til en delt vil deaktivere anonym FTP og HTTPS (dersom ikke SNI støtten er aktivert).',

    'backup__restore__no_postgresql_commands_text' => 'Abonnementet bruker en ekstern PostgreSQL-database og den midlertidige sikkerhetskopifilen av den kan ikke genereres fordi pg_dump og psql-kommandoer mangler på kildeserveren.',
    'backup__restore__no_postgresql_commands_resolution' => 'Vennligst installer en PostgreSQL klientpakke som støtter disse kommandoene.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Følgende Apache-moduler er deaktivert på målserveren: %1',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Vennligst aktiver disse modulene for å unngå potensielle problemer.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Følgende Apache-moduler er ikke installert på målserveren: %1',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Vennligst installer og aktiver disse modulene for å unngå potensielle problemer.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Begrensning av utgående meldinger støttes ikke av lisensen din. De tilsvarende konfigureringsinnstillingene vil ikke bli overført.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Vennligst installer en annen lisensnøkkel på målserveren som gir den mengden ressurser som kreves.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Begrensning av utgående meldinger er slått av på målserveren. De tilsvarende konfigureringsinnstillingene vil ikke bli overført.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Vennligst slå på begrensning av utgående meldinger på målserveren.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Globale e-postinnstillinger.',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Begrensning av utgående meldinger fra en postboks støttes ikke av den epostserveren som benyttes på målserveren. Verdien for denne grensen vil ikke bli overført.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Vennligst endre epostserver til den samme som du benytter på kildeserveren.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Globale e-postinnstillinger.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Begrensning av utgående meldinger fra et domene støttes ikke av den epostserveren som benyttes på målserveren. Verdien for denne grensen vil ikke bli overført.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Vennligst endre epostserver til den samme som du benytter på kildeserveren.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Globale e-postinnstillinger.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Begrensning av utgående meldinger fra et abonnement støttes ikke av den epostserveren som benyttes på målserveren. Verdien for denne grensen vil ikke bli overført.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Vennligst endre epostserver til den samme som du benytter på kildeserveren.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Globale e-postinnstillinger.',

    'bu_conflict_resolver_absent_phosting' => 'Kunne ikke gjenopprette spesifiserte filer, fordi fysisk hosting for å gjenopprette dem ikke finnes. Vennligst opprett et domene med fysisk hosting først, og start deretter gjenoppretting av sikkerhetskopien igjen.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Forhandlerens data vil ikke bli gjenopprettet fordi forhandlerens management ikke støttes.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Komponenten ModSecurity er ikke installert på målserveren.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Vennligst installer ModSecurity for at brannmur for webprogram fortsatt skal fungere for de overførte nettstedene. Merk at installasjonen kan ta noen minutter.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Installer ModSecurity hvis du ønsker å overføre innstillingene for brannmur for webprogram. Merk at installasjonen kan ta noen minutter.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Komponenten ModSecurity er ikke konfigurert på målserveren.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Konfigurer ModSecurity hvis du ønsker at brannmur for webprogram fortsatt skal fungere for de overførte nettstedene.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Brannmur for webprogram (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity er slått av på målserveren.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Aktiver ModSecurity hvis du ønsker at brannmur for webprogram fortsatt skal fungere for de overførte nettstedene.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Brannmur for webprogram (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Komponenten ModSecurity er ikke installert. Brannmurinnstillinger for webprogram vil ikke bli gjenopprettet for følgende objekter: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Noen nettsteder kan ikke gjenopprettes fordi de tilhører abonnementet %1 som ikke finnes i Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Komponent %1 er ikke installert på målserveren. DNS-tjenesten vil ikke være tilgjengelig og DNS-innstillingene vil gå tapt. Alle kundenes nettsteder vil være nede.',
    'bu_conflict_resolver_dns_not_installed' => 'DNS-tjenesten er ikke installert. DNS-innstillinger vil ikke bli gjenopprettet for følgende objekter: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Følgende abonnementer kan ikke gjenopprettes fordi de er flyttet til andre eiere: \'%1\'.',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Følgende abonnementer kan ikke gjenopprettes fordi de er flyttet til andre leverandører: \'%1\'.',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Kunne ikke finne gjenopprettingsprogrammet Web Presence Builder for å gjenopprette Web Presence Builder-data. Web Presence Builder er sannsynligvis ikke installert.',
    'backup__restore__capability_renamed_db' => 'Databasenavnet "%1" er allerede i bruk av et annet abonnement. Navnet på den gjenopprettede databasen vil bli endret til "%2".',
    'backup__restore__capability_renamed_db_user' => 'Databasens brukernavn "%1" er allerede i bruk av et annet abonnement. Navnet på den gjenopprettede databasebrukeren vil bli endret til "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Plesk Installer støtter ikke Perl. Vennligst installer ActiveState Perl manuelt.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% betjent av Apache (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% betjent av ngnix (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Kaspersky Antivirus',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Ressursbruk konflikter',
    'backup__restore__hint_resource_usage_conflicts' => 'Konflikter i ressursbruken oppstår når grensene for ressursforbruk av det gjenopprettede objektet overskrides ved gjenoppretting.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Tillat overforbruk',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Gjenopprett objektet og tillat det å bruke flere ressurser enn opprinnelig tilordnet.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Ikke gjenopprett',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Gjenopprett ikke objekter som har ressursforbruk konflikter.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Konfigurasjons konflikter',
    'backup__restore__hint_configuration_conflicts' => 'Konfigurasjonskonflikter oppstår når det gjenopprettede objektet har innstillinger og webprogrammer som ikke er tilgjengelige eller er forbudt av den aktive serveren eller objekteierens policy. Konfigurasjonskonflikter vil for eksempel oppstå dersom gjenopprettede e-postkontoer har individuelle spamfiltreringsinnstillinger mens nåværende globale policyer ikke tillater e-postkontoer å ha slike innstillinger.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Automatisk',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Gjenopprett objekt og slå automatisk på alle motstridende alternativer som du har tilgang til å behandle.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Ikke gjenopprett',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Gjenopprett ikke objekter som har konfigurasjonskonflikter.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Dedikerte IIS programutvalg er ikke tillatt i innstillinger av IIS programutvalg.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Vennligst endre innstillinger for IIS programutvalg på Verktøy og innstillinger > IIS programutvalg > Globale innstillinger.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Delte IIS programutvalg er ikke tillatt i innstillinger for IIS programutvalg.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Vennligst endre innstillinger for IIS programutvalg på Verktøy og innstillinger > IIS programutvalg > Globale innstillinger.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Korte POP3/IMAP-mailkontonavn er ikke tillatt på målserveren.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Kortnavn for e-postkonto vil ikke være tilgjengelig etter gjenoppretting av data.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Kan ikke åpne loggfilen.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Kunne ikke gjenopprette abonnementet %1: det ble fjernet fra kontoen din og du har ikke tillatelse til å opprette abonnementer. Hvis du har behov for å gjenopprette det, vennligst ta kontakt med tjenesteleverandøren din.',

    'backup__error11' => 'Utilstrekkelig diskplass for sikkerhetskopi.',
    'backup__error3011' => 'Tilkobling avslått: Ingen programmer lytter på angitt adresse og port.',
    'backup__error3012' => 'Tidsavbrudd for tilkobling.',
    'backup__error3013' => 'Nettverket kan ikke nås.',
    'backup__error3014' => 'Ingen rute til vert.',
    'backup__error3015' => 'Tilkobling mislyktes.',
    'backup__error3016' => 'Fant ikke vertsnavn.',
    'backup__error3017' => 'Feil brukernavn eller passord.',
    'backup__error3018' => 'SSH-tilkobling mislyktes.',

    'backup__error3110' => 'Kunne ikke koble til ekstern overføringsagent: Tilkobling til vert er ikke tilgjengelig.',
    'backup__error3111' => 'Overføringsagenten en låst av en mislykket overføringsoppgave eller brukes av en annen overføringsprosess. Vennligst start overføringsagenten på nytt på kildeserveren.',
    'backup__error3112' => 'Tilkobling til vert er ikke tilgjengelig eller overføringsagent kjører ikke på kildeverten.',
    'backup__error3113' => 'Kan ikke distribuere overføringsagent til en Linux-vert. Sjekk SSH-tilkobling til kildeverten.',
    'backup__error3114' => 'Kan ikke distribuere overføringsagent til en Linux-vert: SSH-tilkobling mislyktes.',
    'backup__error3115' => 'Feil brukernavn eller passord.',
    'backup__error3116' => 'Den angitte brukeren har ikke administrative rettigheter.',

    'dns_t__unable_to_remove_ns_record' => 'Klarte ikke fjerne NS-oppføring fra DNS-mal: Hver av DNS-sonene må ha minst én NS-oppføring.',
    'dns__unsupported_server_zone_transfer' => 'Kan ikke overføre viderekoblingsrestriksjonsmalen på grunn av global DNS-konfigurasjon: Følgende nettverksadresser er godkjent for soneoverføring på kildeserveren, men er forbudte på Microsoft DNS-serveren: %1',
    'dns__unsupported_domain_zone_transfer' => 'Kunne ikke overføre Mal for overføringsbegrensninger på grunn av domenets DNS-konfigurasjon: På noen domener er følgende nettverksadresser tillatt for soneoverføring, men disse adressene er forbudt av Microsoft DNS Server: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Kunne ikke komme inn i delt midlertidig nettverksmappe for sikkerhetskopifiler. Vennligst sjekk innstillinger for nettverksmappe, brukernavn og passord. Feil: %1',

    'migration_select_exist_db_server' => 'Velg mål for databaseserver',

    'dbbackup__temp_dir_wrong_value' => 'En ugyldig verdi ble angitt for den midlertidige mappen.',
    'dbbackup__network_temp_dir_wrong_value' => 'En ugyldig verdi ble angitt for den midlertidige nettverksmappen.',
    'dbbackup__server_backup_not_configured' => 'Innstillinger for sikkerhetskopiering av databasen er ikke konfigurert på serveren:',
    'dbbackup__temp_dir' => 'Midlertidig mappe',
    'dbbackup__temp_dir_hint' => 'Banen til en fysisk mappe på den eksterne serveren der MS SQL-serveren befinner seg. MS SQL-serveren må ha tilgang til denne mappen for å lese og skrive midlertidige sikkerhetskopier. For eksempel, C:\\mappesti',
    'dbbackup__network_temp_dir_hint' => 'Banen til nettverksdrevet for den fysiske mappen som er angitt over. Plesk vil få tilgang til den delte mappen for å laste ned og opp sikkerhetskopiene. For eksempel \\\\Servernavn\\Katalogbane',
    'dbbackup__network_user_hint' => 'Brukernavnet til en nettverksbruker opprettet på den eksterne serveren. For eksempel, servernavn\\brukernavn. Brukeren må ha tilgang til den delte mappen som er angitt over.',
    'dbbackup__network_password_hint' => 'Nettverksbrukerens passord',

    'dbbackup__success_import_without_dublicate_users' => 'Følgende brukere ble ikke importert: %1. De allerede finnes på databaseserveren.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Komprimer loggfiler",
    'log_rot__log_rot_status' => "Loggrotasjonsstatus",
    'log_rot__log_rot_period' => "Logg rotasjonsbetingelse",
    'log_rot__log_rot_size' => "på størrelse",
    'log_rot__log_rot_time' => "på tid",
    'log_rot__logrotation_enable' => "Aktiver logg rotasjon",
    'log_rot__mail' => "Send behandlede loggfiler til e-post",
    'log_rot__max_number_of_logfiles' => "Maksimalt antall loggfiler",
    'log_rot__time_period' => "Periode",
    'log_rot__unable_turn_off' => 'Kunne ikke slå av loggrotasjon fordi det tvinges på servernivå',
    'log_rot__unable_set_period' => 'Kunne ikke angi loggrotasjonsperiode annet enn \'daily\', fordi det tvinges på servernivå',
    'log_rot__unable_set_max_log_files' => 'Kunne ikke angi maksimalt antall loggfiler større enn servergrensen på %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Et nummer forventes: %1",
    'actionlog__incorrect_rotation' => "Ugyldige loggrotasjons parametere spesifisert: %1",
    'actionlog__unknown_rot_period' => "Ukjent rotasjonperiode: %1",
    'actionlog__unknown_rot_type' => "Ukjent rotasjontype: %1",
    'actionlog__session_preferences' => 'Øktinnstillinger',
    // items (PFU schema)
    'actionlog__admin_info' => 'Administrator-informasjon',
    'actionlog__admin_preferences' => "Administrators preferanser",
    'actionlog__service' => 'Tjeneste',
    'actionlog__ip_addr' => 'IP-adresse',
    'actionlog__client' => 'Kundekonto',
    'actionlog__client_status' => 'Kundens kontostatus',
    'actionlog__client_preferences' => "Kundens grensesnittpreferanser",
    'actionlog__client_ip_pool' => "Kundens IP-utvalg",
    'actionlog__client_siteapp' => "Kundens webprogramutvalg",
    'actionlog__client_guid' => "Kundens GUID",
    'actionlog__domain' => 'Standarddomene (det første domenet som legges til et abonnement)',
    'actionlog__domain_owner' => 'Eier av abonnement',
    'actionlog__domain_plan' => 'Tjenesteplan for abonnement',
    'actionlog__domain_status' => 'Standarddomene, status',
    'actionlog__domain_dns' => 'Standarddomene, DNS-zone',
    'actionlog__subdomain' => 'Underdomene til et standarddomene',
    'actionlog__domain_alias' => 'Standarddomene, alias',
    'actionlog__domain_alias_dns' => 'Standarddomene, alias DNS-sone',
    'actionlog__site' => 'Domene',
    'actionlog__site_status' => 'Domenestatus',
    'actionlog__site_dns' => 'Domenets DNS-sone',
    'actionlog__site_guid' => 'Domene-GUID',
    'actionlog__site_subdomain' => 'Subdomene',
    'actionlog__site_alias' => 'Domenealias',
    'actionlog__site_alias_dns' => 'Domenealias DNS-sone',
    'actionlog__domain_limits' => 'Abonnementbegrensninger',
    'actionlog__domain_limit_size' => 'Diskplassgrense for abonnement',
    'actionlog__domain_limit_traffic' => 'Trafikkgrense for abonnement',
    'actionlog__domain_limits_powerUser' => 'Abonnementbegrensninger',
    'actionlog__domain_limit_size_powerUser' => 'Diskplassgrense for abonnement',
    'actionlog__domain_limit_traffic_powerUser' => 'Trafikkgrense for abonnement',
    'actionlog__domain_guid' => "Standarddomene, GUID",
    'actionlog__cp_user' => 'Plesk-bruker',
    'actionlog__mailname' => 'E-postkonto',
    'actionlog__maillist' => 'Adresseliste',
    'actionlog__phosting' => 'Hostinginnstillinger',
    'actionlog__forwarding' => 'Standardhosting eller hosting med videresending av ramme',
    'actionlog__webuser' => 'Webbrukerkonto',
    'actionlog__site_application' => 'webprogram',
    'actionlog__license' => 'Lisensnøkkel',
    'actionlog__additional_license' => 'Ekstra lisensnøkkel',
    'actionlog__template_domain' => "Forhandlerens tjenesteplan",
    'actionlog__template_admin' => "Administratorens tjenesteplan",
    'actionlog__template_reseller' => 'Forhandlerplan',
    'actionlog__admin_alias' => 'Ekstra administratorkonto', // PFW
    'actionlog__ftpuser' => 'Ekstra FTP-konto', // PFW
    'actionlog__db_server' => 'Databaseserver',
    'actionlog__db' => 'Database',
    'actionlog__db_user' => 'Brukerkonto for database',
    'actionlog__client_sapppkg_pool' => "Brukerens webprogram", // PFW, not used?
    'actionlog__remote_dns' => 'Status for ekstern DNS-server', // PFW
    'actionlog__reseller' => 'Forhandlerkonto',
    'actionlog__reseller_guid' => 'Forhandler-GUID',
    'actionlog__reseller_ip_pool' => "Forhandlerens IP-utvalg",
    'actionlog__reseller_limit_size' => 'Diskplassgrense for forhandlerkonto',
    'actionlog__reseller_limit_traffic' => 'Trafikkgrense for forhandlerkonto',
    'actionlog__reseller_limits' => 'Grenser for forhandlerkonto',
    'actionlog__reseller_permissions' => 'Forhandlertillatelser',
    'actionlog__reseller_preferences' => "Forhandlerens grensesnittpreferanser",
    'actionlog__reseller_siteapp' => "Webprogrammer i forhandlerens utvalg",
    'actionlog__reseller_status' => 'Status for forhandlerkonto',
    'actionlog__health_status' => 'Status for servertilstand',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'oppnådd',
    'actionlog__added' => 'lagt til',
    'actionlog__removed' => 'har fjernet',
    'actionlog__change' => 'endret',
    'actionlog__update' => 'oppdaterte',
    'actionlog__move' => 'flyttet',
    'actionlog__upgrade' => 'oppgradert', // PFU?
    'actionlog__update_or_add' => 'oppdatert eller lagt til',
    'actionlog__expired' => 'utløpt',
    'actionlog__create' => 'opprettet',
    'actionlog__delete' => 'slettet',
    'actionlog__service_stop' => 'stoppet',
    'actionlog__service_restart' => 'restartet',
    'actionlog__service_start' => 'startet',
    'actionlog__login' => 'logget på',
    'actionlog__logout' => 'logget av',
    'actionlog__install' => 'installert',
    'actionlog__uninstall' => 'avinstallert',
    'actionlog__reconfigure' => 'konfigurert på nytt',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Forespørsel om tilbakestilling av passord',
    'actionlog__event_admin_update' => 'Administrator-informasjon oppdatert',
    'actionlog__event_admin_preferences_update' => "Administratorens preferanser ble oppdatert",
    'actionlog__event_service_restart' => 'Tjeneste startet på nytt',
    'actionlog__event_service_start' => 'Tjeneste startet',
    'actionlog__event_service_stop' => 'Tjeneste stoppet',
    'actionlog__event_ip_address_create' => 'IP-adresse opprettet',
    'actionlog__event_ip_address_delete' => 'IP-adresse slettet',
    'actionlog__event_ip_address_update' => 'IP-adresse oppdatert',
    'actionlog__event_client_create' => 'Kundekonto opprettet',
    'actionlog__event_client_delete' => 'Kundekonto slettet',
    'actionlog__event_client_update' => 'Kundekonto oppdatert',
    'actionlog__event_client_status_update' => 'Kundens kontostatus oppdatert',
    'actionlog__event_client_preferences_update' => "Kundens grensesnittpreferanser oppdatert",
    'actionlog__event_client_siteapp_added' => "Webprogram lagt til kundekontoens programutvalg",
    'actionlog__event_client_siteapp_removed' => "Webprogram fjernet fra kundekontoens programutvalg",
    'actionlog__event_domain_limit_size_reached' => 'Diskplassgrense for abonnement er nådd',
    'actionlog__event_domain_limit_traffic_reached' => 'Trafikkgrense for abonnement er nådd',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Diskplassgrense for abonnement er nådd',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Trafikkgrense for abonnement er nådd',

    'actionlog__domain_limit_database' => 'Databasekvote for abonnement',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'MySQL databasekvote for abonnement er nådd',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'MySQL-databaser myk kvote for abonnement er nådd',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Databasekvote for Microsoft SQL-servere for abonnementet er nådd',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Myk kvote for Microsoft SQL-databaseservere for abonnementet er nådd',
    'actionlog__event_plesk_component_upgrade' => 'Plesk-komponent oppdatert',
    'actionlog__event_plesk_component_install' => 'Plesk-komponent installert',
    'actionlog__event_plesk_component_uninstall' => 'Plesk-komponent avinstallert',
    'actionlog__event_domain_create' => 'Standarddomene (det første domenet som legges til et abonnement ble opprettet',
    'actionlog__event_domain_delete' => 'Standarddomene (det første domenet som legges til et abonnement) ble slettet',
    'actionlog__event_domain_update' => 'Standarddomene (det første domenet som legges til et abonnement) ble oppdatert',
    'actionlog__event_domain_owner_change' => 'Eier av abonnement ble endret',
    'actionlog__event_domain_plan_change' => 'Tjenesteplan for abonnement ble endret',
    'actionlog__event_domain_status_update' => 'Standarddomene, status oppdatert',
    'actionlog__event_domain_dns_update' => 'Standarddomene, DNS-sone ble oppdatert',
    'actionlog__event_subdomain_create' => 'Underdomene til et standarddomene ble opprettet',
    'actionlog__event_subdomain_delete' => 'Underdomene til et standarddomene ble slettet',
    'actionlog__event_subdomain_update' => 'Underdomenet til et standarddomene ble oppdatert',
    'actionlog__event_domain_alias_create' => 'Standarddomene, alias ble opprettet',
    'actionlog__event_domain_alias_delete' => 'Standarddomene, alias ble slettet',
    'actionlog__event_domain_alias_update' => 'Standarddomene, alias ble oppdatert',
    'actionlog__event_domain_limits_update' => 'Abonnementsgrenser ble oppdatert',
    'actionlog__event_cp_user_login' => 'Plesk-bruker pålogget',
    'actionlog__event_cp_user_logout' => 'Plesk-bruker logget ut',
    'actionlog__event_mailname_create' => 'E-postkonto opprettet',
    'actionlog__event_mailname_delete' => 'E-postkonto slettet',
    'actionlog__event_mailname_update' => 'E-postkonto oppdatert',
    'actionlog__event_maillist_create' => 'Adresseliste opprettet',
    'actionlog__event_maillist_delete' => 'Adresseliste slettet',
    'actionlog__event_maillist_update' => 'Adresseliste oppdatert',
    'actionlog__event_phys_hosting_create' => 'Fysisk hosting opprettet',
    'actionlog__event_phys_hosting_delete' => 'Fysisk hosting slettet',
    'actionlog__event_phys_hosting_update' => 'Fysisk hosting oppdatert',
    'actionlog__event_forwarding_create' => 'Standardhosting eller hosting med videresending av ramme ble opprettet',
    'actionlog__event_forwarding_delete' => 'Standardhosting eller hosting med videresending av ramme ble slettet',
    'actionlog__event_forwarding_update' => 'Standardhosting eller hosting med videresending av ramme ble oppdatert',
    'actionlog__event_webuser_create' => 'Webbrukerkonto opprettet',
    'actionlog__event_webuser_delete' => 'Webbrukerkonto slettet',
    'actionlog__event_webuser_update' => 'Webbrukerkonto oppdatert',
    'actionlog__event_siteapp_install' => 'Webprogram ble installert',
    'actionlog__event_siteapp_reconfigure' => 'Webprogram ble konfigurert på nytt',
    'actionlog__event_siteapp_uninstall' => 'Webprogram ble avinstallert',
    'actionlog__event_license_update' => 'Lisensnøkkel oppdatert',
    'actionlog__event_admin_alias_create' => 'Ekstra administratorkonto opprettet',
    'actionlog__event_admin_alias_delete' => 'Ekstra administratorkonto slettet',
    'actionlog__event_admin_alias_update' => 'Ekstra administratorkonto oppdatert',
    'actionlog__event_ftpuser_create' => 'Ekstra FTP-konto opprettet',
    'actionlog__event_ftpuser_update' => 'Ekstra FTP-konto oppdatert',
    'actionlog__event_ftpuser_delete' => 'Ekstra FTP-konto slettet',
    'actionlog__event_template_domain_create' => "Tjenesteplan for forhandler ble opprettet",
    'actionlog__event_template_domain_update' => "Tjenesteplan for forhandler ble oppdatert",
    'actionlog__event_template_domain_delete' => "Tjenesteplan for forhandler ble slettet",
    'actionlog__event_template_admin_create' => "Tjenesteplan for administrator ble opprettet",
    'actionlog__event_template_admin_update' => "Tjenesteplan for administrator ble oppdatert",
    'actionlog__event_template_admin_delete' => "Tjenesteplan for administrator ble slettet",
    'actionlog__event_database_server_create' => 'Databaseserver opprettet',
    'actionlog__event_database_server_update' => 'Databaseserver oppdatert',
    'actionlog__event_database_server_delete' => 'Databaseserver slettet',
    'actionlog__event_remote_dns_status_update' => 'Status for ekstern DNS-server oppdatert.',
    'actionlog__event_session_preferences_update' => 'Øktinnstillinger oppdatert',
    'actionlog__event_domain_alias_dns_update' => 'Standarddomene, DNS-sone for domenealias ble oppdatert',
    'actionlog__event_domain_move' => 'Standarddomenet er flyttet til et nytt abonnement',
    'actionlog__event_site_move' => 'Domenet er flyttet til et nytt abonnement',
    'actionlog__event_site_subdomain_move' => 'Underdomenet er flyttet til et nytt abonnement',
    'actionlog__event_subdomain_move' => 'Underdomenet til et standarddomene er flyttet til et nytt abonnement',
    'actionlog__event_license_expired' => 'Lisensen for Plesk er utløpt',
    'actionlog__event_database_create' => 'Database opprettet',
    'actionlog__event_database_delete' => 'Database fjernet',
    'actionlog__event_database_user_create' => 'Brukerkonto for database opprettet',
    'actionlog__event_database_user_update' => 'Brukerkonto-innstillinger for database oppdatert',
    'actionlog__event_database_user_delete' => 'Brukerkonto for database fjernet',
    'actionlog__event_client_guid_update' => "Kundens GUID oppdatert",
    'actionlog__event_domain_guid_update' => 'Standarddomene, GUID ble oppdatert',
    'actionlog__event_reseller_create' => 'Forhandlerkonto opprettet',
    'actionlog__event_reseller_delete' => 'Forhandlerkonto slettet',
    'actionlog__event_reseller_update' => 'Forhandlerkonto ble oppdatert',
    'actionlog__event_reseller_guid_update' => 'Forhandler-GUID ble oppdatert',
    'actionlog__event_reseller_ip_pool_update' => "Forhandlerens IP-utvalg ble oppdatert",
    'actionlog__event_reseller_limit_size_reached' => 'Diskplassgrense for forhandlerkonto er nådd',
    'actionlog__event_reseller_limit_traffic_reached' => 'Trafikkgrense for forhandlerkonto er nådd',
    'actionlog__event_reseller_limits_update' => 'Grenser for forhandlerkonto ble oppdatert',
    'actionlog__event_reseller_permissions_update' => 'Tillatelser for forhandlerkonto ble oppdatert',
    'actionlog__event_reseller_preferences_update' => "Forhandlerens grensesnittpreferanser ble oppdatert",
    'actionlog__event_reseller_siteapp_added' => "Program lagt til forhandlerkontoens programutvalg",
    'actionlog__event_reseller_siteapp_removed' => "Program fjernet fra forhandlerkontoens programutvalg",
    'actionlog__event_reseller_status_update' => 'Status for forhandlerkonto ble oppdatert',
    'actionlog__event_template_reseller_create' => 'Forhandlerplan ble opprettet',
    'actionlog__event_template_reseller_delete' => 'Forhandlerplan ble slettet',
    'actionlog__event_template_reseller_update' => 'Forhandlerplan ble oppdatert',
    'actionlog__event_health_status_change' => 'Status for servertilstand er endret',
    'actionlog__event_siteapp_upgrade' => 'Webapp oppgradert',
    'actionlog__event_extension_install' => 'Utvidelsen er installert',
    'actionlog__event_extension_uninstall' => 'Utvidelsen er avinstallert',
    'actionlog__event_extension_upgrade' => 'Utvidelsen er oppgradert',
    'actionlog__event_extension_status_update' => 'Status for utvidelsen er oppdatert',
    'actionlog__event_additional_license_expired' => 'Ekstra lisensnøkkel er utløpt',
    'actionlog__event_hostname_changed' => 'Serverens vertsnavn ble endret',
    'actionlog__event_smb_user_create' => 'Ekstra bruker opprettet',
    'actionlog__event_smb_user_delete' => 'Ekstra bruker slettet',
    'actionlog__event_smb_user_update' => 'Ekstra bruker oppdatert',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC er ikke installert på den eksterne verten. Ta kontakt med tjenesteleverandøren din for assistanse.",
    'rsession_no_account_errmsg' => "Fikk ikke tilgang til ekstern tjeneste på kontoen din. Den vanligste årsaken er at tjenesten for kontoen din ikke er aktivert enda. Vent flere minutter, og prøv deretter på nytt. Kontakt systemansvarlig hvis problemet vedvarer.",
    'rsession_no_domain_errmsg' => "Fikk ikke tilgang til ekstern tjeneste for dette domenet. Den vanligste årsaken er at tjenesten for kontoen din ikke er aktivert enda. Vent flere minutter, og prøv deretter på nytt. Kontakt systemansvarlig hvis problemet vedvarer.",
    'rsession_unknown_errmsg' => "Den eksterne serveren har avvist forsøket på å opprette en sesjon. Kontakt systemansvarlig for å få hjelp. Feilen var: %1",
    'rsession_unknown2_errmsg' => "Ukjent feil under etableringen av en fjernøkt. Sannsynligvis svarer ikke den eksterne serveren korrekt, eller i det hele tatt. Be systemadministratoren å kontrollere feilopplysningene i webserverens feillogg.",
    'rsession_no_connect_errmsg' => "Fikk ikke tilgang til ekstern tjeneste: tilkobling til ekstern økt mislyktes. Kontakt systemansvarlig for å få hjelp.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Tillat opplasting til den innkommende arbeidsmappen",
    'anonftp__allow_create_dirs' => 'Tillat opprettelse av mapper i den innkommende arbeidsmappen',
    'anonftp__allow_download_incoming' => 'Tillat nedlasting fra den innkommende arbeidsmappen',
    'anonftp__display_login' => 'Vis innloggingsmelding.',
    'anonftp__login_text' => 'Meldingstekst',
    'anonftp__limit_incoming_disk_space' => "Begrens diskplass i den innkommende arbeidsmappen",
    'anonftp__limit_maximum_bandwidth' => "Grense for nedlastingsbåndbredde for dette virtuelle FTP-domenet",
    'anonftp__limit_maximum_connections' => "Begrens antall samtidige tilkoblinger",
    'anonftp__unable_init' => "Kan ikke initialisere anonym FTP-konto: %1",
    'anonftp__unable_set_quota' => "Kan ikke sette begrensning for diskplass på den innkommende arbeidsmappen: %1",
    'anonftp__unable_update' => "Kan ikke oppdatere egenskaper for anonym FTP-konto: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'SSL/TLS-sertifikater', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "CA-sertifikatet signerer ikke sertifikatet.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Inkompatibel privat nøkkel/sertifikatpar.",
    'class_sslcertificate__invalid_cert_format' => "Ugyldig sertifikatformat.",
    'class_sslcertificate__invalid_private_key_format' => "Ugyldig format for privat nøkkel.",
    'class_sslcertificate__prob_invalid_priv_key' => "Antakelig er formatet til den private nøkkelen ugyldig.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Opprett virtuell mappe',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Opprett virtuell mappe',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Opprett virtuell mappe.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Opprett virtuell mappe',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Opprett virtuell mappe',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Opprett virtuell mappe.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Opprett mappe',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Opprett mappe',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Opprett mappen.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Opprett mappe',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Opprett mappe',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Opprett mappen.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Egenskaper for mappe',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Egenskaper for virtuell mappe',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Vis og endre egenskaper for virtuell mappe',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Egenskaper for mappe',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Egenskaper for virtuell mappe',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Vis og endre egenskaper for virtuell mappe',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Tilgangstillatelser for mappen',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Tilgangstillatelser for mappen',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Sett opp tilgangstillatelser for mappen.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Tilgangstillatelser for mappen',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Tilgangstillatelser for mappen',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Sett opp tilgangstillatelser for mappen.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Innstillinger for ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'ASP.NET-innstillinger for %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Konfigurere ASP.NET-innstillinger for virtuell mappe %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Innstillinger for ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'ASP.NET-innstillinger for %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Konfigurer ASP.NET-innstillinger for virtuell mappe %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'PHP-innstillinger',
    'ui__client/domain/hosting/web-directories/php__title' => 'PHP-innstillinger for %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Konfigurer PHP-innstillinger for virtuell mappe %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'PHP-innstillinger',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'PHP-innstillinger for %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Konfigurer PHP-innstillinger for virtuell mappe %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Fjern',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Fjern virtuell mappe',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Fjern valgte virtuelle mapper.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Fjern',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Fjern virtuell mappe',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Fjern valgte virtuelle mapper.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Følgende virtuelle mapper vil bli fjernet:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Du må velge de mappene som du vil fjerne.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'MIME-typer',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Vis liste over registrert MIME-typer.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Legg til MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Legg til MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Registrer en ny MIME type.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Feildokumenter',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Feildokumenter',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Se og endre feildokumenter.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Beskyttelse',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Mappebeskyttelse',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Begrens tilgang til mappen med passordbeskyttelse.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Beskyttelse',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Mappebeskyttelse',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Begrens tilgang til mappen med passordbeskyttelse.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Innstillinger',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Vis mappens plassering og angi tittel for det beskyttede området.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Brukerinnstillinger',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Legg til bruker',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Legg til bruker',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Legg til en brukerkonto med tilgang til den beskyttede mappen.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'De nye innstillingene ble aktivert.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Brukerkontoen ble lagt til.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Fjern',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Fjern brukere av beskyttet mappen.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Fjern brukerkontoer',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Bekreft fjerning av brukerkonto.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Brukerkontoene ble fjernet.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Operasjonen er fullført.',
    'ui__admin/extras-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__admin/report/layout/delete_multi__done' => 'Valgte rapport oppsett ble tatt bort.',
    'ui__admin/report/traffic-history__done' => 'Operasjonen er fullført.',
    'ui__admin/report__done' => 'Operasjonen er fullført.',
    'ui__admin-alias/delete_multi__done' => "De valgte ekstra administratorkontoene ble fjernet.",
    'ui__admin-alias/properties__done' => "Egenskaper for ekstra administratorkonto ble oppdatert.",
    'ui__admin-alias/properties_new__done' => "Ekstra administratorkonto ble opprettet.",
    'ui__admin-alias/properties_unknown__done' => "Egenskaper for ekstra administratorkonto ble oppdatert.",
    'ui__admin-alias__done' => "Informasjon om ekstra administratorkonto ble oppdatert.",
    'ui__admin/manage-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__admin/register-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Valgte tidsplaner for rapportleveranse ble tatt bort.',
    'ui__admin/report/layout/auto/properties__done' => 'Tidsplan for rapportleveranse ble oppdatert.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Tidsplan for rapportlevering ble opprettet.',
    'ui__client/domain/certificate/properties__done' => 'SSL/TLS-sertifikatets egenskaper ble oppdatert.',
    'ui__client/domain/certificate/properties_new__done' => 'Nytt SSL/TLS-sertifikat ble lagt til. For å få det til å fungere, pass på at du velger det i innstillinger for hosting av nettsteder (på fanen Nettsteder og domener> domenenavn).',
    'ui__client/domain/certificate__done' => 'Operasjonen er fullført.',
    'ui__client/domain/certificate_self__done' => 'Operasjonen er fullført.',
    'ui__client/domain/chowner__done' => 'Abonnement %1 tilhører nå en annen bruker.',
    'ui__client/domain/chowner_multi__done' => 'Eierskap av abonnement ble endret.',
    'ui__client/domain/chowner_multi-select__done' => 'Operasjonen er fullført.',
    'ui__client/domain/chowner_select__done' => 'Operasjonen er fullført.',
    'ui__client/domain/dbbackup/create__done' => "Sikkerhetskopiering av database var vellykket.", // PFW
    'ui__client/domain/dbbackup/get__done' => "Sikkerhetskopiering av database var vellykket.", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Overgitt bruker ble vellykket reparert.", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Sikkerhetskopi filene ble fjernet vellykket.", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Gjenopprettelse av databaseinnhold var vellykket .", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Operasjonen er fullført.", // PFW
    'ui__client/domain/dbbackup__done' => "Operasjonen er fullført.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Operasjonen er fullført.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Operasjonen er fullført.", // PFW
    'ui__client/domain/delete__done' => "Domene %1 ble fjernet.",
    'ui__client/domain/delete_multi__done' => "Domenene ble fjernet.",
    'ui__client/domain/disable__done' => 'Domenet %1 ble suspendert deaktivert.',
    'ui__client/domain/disable_multi__done' => 'De valgte domenene ble suspendert.',
    'ui__client/domain/enable__done' => 'Nettstedet %1 ble aktivert.',
    'ui__client/domain/enable_multi__done' => 'De valgte nettsted ble aktivert.',
    'ui__client/domain/extras__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/domain/extras_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Loggrotasjonsinnstillinger ble endret.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Loggrotasjonsinnstillinger ble endret.',
    'ui__client/domain/hosting/logs__done' => 'Operasjonen er fullført.',
    'ui__client/domain/hosting/logs_self__done' => 'Operasjonen er fullført.',
    'ui__client/domain/hosting/setup__done' => 'Hosting for %1 ble konfigurert.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'ASP.NET versjonen ble endret.', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => 'Operasjonen er fullført.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Operasjonen er fullført.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'ASP.NET-innstillinger for %1 ble endret.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Virtuell mappe ble opprettet under nettsted %1.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Virtuell mappe ble opprettet.', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Valgte mapper ble fjernet.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Valgte mapper ble fjernet.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'Brukerdefinerte feildokumenter ble oppdatert.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Valgte MIME typer ble slettet', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Ny MIME type ble registrert.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Operasjonen er fullført.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Tilgangstillatelser for mappen ble oppdatert..', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Tilgangstillatelser for mappen ble oppdatert..', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'PHP-innstillinger for %1 ble endret.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'PHP-innstillinger for %1 ble endret.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Egenskaper for mappen ble oppdatert..', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Egenskaper for mappen ble oppdatert..', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Mappens beskyttelsesinnstillinger ble oppdatert.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Mappens beskyttelsesinnstillinger ble oppdatert.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Operasjonen er fullført.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Operasjonen er fullført.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'SSL/TLS-sertifikater tilgjengelig i nettlageret',
    'ui__client/domain/mpc-certificates_self__done' => 'SSL/TLS-sertifikater tilgjengelig i nettlageret',
    'ui__client/domain/register__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/domain/register_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/domain/rename__done' => 'Domenenavnet ble endret.',
    'ui__client/domain/rename_self__done' => "Domenenavnet ble endret.",
    'ui__client/domain/settings_self__done' => 'Operasjonen er fullført.',
    'ui__client/domain/toggle_disable__done' => "Domene %1 ble suspendert.",
    'ui__client/domain/toggle_enable__done' => "Domene %1 ble aktivert.",
    'ui__client/domain/traffic__done' => 'Operasjonen er fullført.',
    'ui__client/domain/traffic_self__done' => 'Operasjonen er fullført.',
    'ui__client/domain/traffic_unknown__done' => 'Operasjonen er fullført.',
    'ui__client/domain-summary-report__done' => 'Operasjonen er fullført.',
    'ui__client/domain-summary-report_self__done' => 'Operasjonen er fullført.',
    'ui__client/domain-summary-report_unknown__done' => 'Operasjonen er fullført.',
    'ui__client/extras-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/extras-domain_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/ipaddress/delete_multi__done' => 'Operasjonen er fullført.',
    'ui__client/ipaddress/properties__done' => 'Operasjonen er fullført.',
    'ui__client/ipaddress/properties_new__done' => 'Operasjonen er fullført.',
    'ui__client/ip-pool/properties__done' => "Kunde %1s IP-utvalg ble oppdatert.",
    'ui__client/ip-pool/properties_self__done' => 'Operasjonen er fullført.',
    'ui__client/limits__done' => "Ressursgrenser for kunde %1 ble endret.",
    'ui__client/limits_self__done' => 'Operasjonen er fullført.',
    'ui__client/logo__done' => 'De nye innstillingene for varemerking for kunde %1 ble benyttet.',
    'ui__client/logo_reseller__done' => 'Nye profileringsinnstillinger av kontrollpanel ble aktivert.',
    'ui__client/logo_self__done' => 'Omprofileringsinnstillingene er aktivert.',
    'ui__client/logo_self-reseller__done' => 'Din profilering av kontrollpanel er aktivert.',
    'ui__client/manage-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/manage-domain_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/permissions__done' => "Tillatelser for kunde %1 ble endret.",
    'ui__client/permissions_self__done' => 'Operasjonen er fullført.',
    'ui__client/preferences__done' => "Preferanser for kunde %1 ble endret.",
    'ui__client/preferences_self__done' => "Dine preferanser ble endret.",
    'ui__client/register-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/register-domain_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__client/report/traffic-history__done' => 'Operasjonen er fullført.',
    'ui__client/report/traffic-history_self__done' => 'Operasjonen er fullført.',
    'ui__client/report__done' => 'Operasjonen er fullført.',
    'ui__client/report_self__done' => 'Operasjonen er fullført.',
    'ui__client/sessions/delete__done' => 'Operasjonen er fullført.',
    'ui__client/sessions/delete_self__done' => 'Operasjonen er fullført.',
    'ui__client/sessions__done' => 'Operasjonen er fullført.',
    'ui__client/sessions_self__done' => 'Operasjonen er fullført.',
    'ui__client/skeleton__done' => 'Operasjonen er fullført.',
    'ui__client/skeleton_self__done' => 'Operasjonen er fullført.',
    'ui__client/traffic__done' => "Operasjonen er fullført.",
    'ui__client/traffic_unknown__done' => 'Operasjonen er fullført.',
    'ui__cp-access__done' => 'Operasjonen er fullført.',
    'ui__cp-session/properties__done' => 'Operasjonen er fullført.',
    'ui__cp-session__done' => 'Operasjonen er fullført.',
    'ui__ftp-sessions__done' => 'Operasjonen er fullført.',
    'ui__license__done' => 'Operasjonen er fullført.',
    'ui__logo__done' => "Plesk omprofileringsegenskaper ble endret.",
    'ui__longtasks/longtask/properties__done' => "Innstillinger for bakgrunnsoppgaver ble endret.",
    'ui__mass-email/delete__done' => "Beskjed mal %1 ble fjernet.", // PFW
    'ui__mass-email/delete_multi__done' => "Beskjed maler ble fjernet.",  // PFW
    'ui__mass-email/send_main__done' => "Operasjonen er fullført.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Kundekontoer ble valgt.",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Kontoer for domeneadministratorer ble valgt.",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Forhandlerkontoer ble valgt.',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Endringene i meldingsmal for masseutsendelse av e-post ble lagret.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Meldingsmal for masseutsendelse av e-post ble opprettet.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Kundekontoer for meldingsmal for masseutsendelse av e-post ble valgt.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Kontoer for domeneadministratorer for mal for masseutsendelse av e-post ble valgt.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Forhandlerkontoer for mal for masseutsendelse av e-post ble valgt.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Meldingsmal for masseutsendelse av e-post ble endret.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Ugyldige verdier ble angitt.', // PFW
    'ui__mass-email__done' => "Operasjonen er fullført.", // PFW
    'ui__mass-mail__done' => "Operasjonen er fullført.", // PFU
    'ui__mass-mail/delete__done' => 'Beskjed mal %1 ble fjernet.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Beskjed maler ble fjernet.', // PFU
    'ui__mass-mail/properties__done' => 'Mal %1 ble endret.', // PFU
    'ui__mass-mail/properties_new__done' => 'Malen %1 ble opprettet.', // PFU
    'ui__mass-mail/send__done' => 'Meldingene ble sendt.', // PFU
    'ui__mass-mail/send_new__done' => 'Meldingene ble sendt.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Meldingene ble sendt.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Meldingene ble sendt.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Ny meldingsmal ble opprettet.', // PFU
    'ui__mass-mail/template/properties__done' => 'Beskjedmalen ble endret.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'De nye diskovervåkningsinnstillingene ble aktivert.', // PFU
    'ui__modules__done' => 'Operasjonen er fullført.',
    'ui__modules__short-title' => 'Filetternavn',
    'ui__modules__title' => 'Filetternavn',
    'ui__reseller/client/traffic_unknown__done' => 'Operasjonen er fullført.',
    'ui__reseller/extras-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__reseller/extras-domain_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__reseller/ftp-sessions_self__done' => 'Operasjonen er fullført.',
    'ui__reseller/limits__done' => "Forhandlerens ressursgrenser og policy for ressursbruk ble endret.",
    'ui__reseller/limits_readonly-self__done' => 'Operasjonen er fullført.',
    'ui__reseller/limits_self__done' => 'Dine grenseverdier for ressurser og ressurs forbruk policyer ble endret.',
    'ui__reseller/manage-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__reseller/manage-domain_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__reseller/permissions__done' => 'Tillatelser for forhandler %1 ble endret.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Operasjonen er fullført.',
    'ui__reseller/register-domain__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__reseller/register-domain_self__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Valgte tidsplaner for rapportleveranse ble tatt bort.',
    'ui__reseller/report/layout/auto/properties__done' => 'Tidsplan for rapportleveranse ble oppdatert.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Rapportleveranse tidsplanen ble lagt til.',
    'ui__reseller/report/traffic-history__done' => 'Operasjonen er fullført.',
    'ui__reseller/report/traffic-history_self__done' => 'Operasjonen er fullført.',
    'ui__reseller/report__done' => 'Operasjonen er fullført.',
    'ui__reseller/report_self__done' => 'Operasjonen er fullført.',
    'ui__reseller/sessions/delete__done' => 'Operasjon fullført vellykket',
    'ui__reseller/sessions/delete_self__done' => 'Operasjon fullført vellykket',
    'ui__reseller/sessions__done' => 'Operasjonen er fullført.',
    'ui__reseller/sessions_self__done' => 'Operasjonen er fullført.',
    'ui__reseller/traffic__done' => 'Operasjonen er fullført.',
    'ui__reseller/traffic_self__done' => 'Operasjonen er fullført.',
    'ui__reseller/traffic_unknown__done' => 'Operasjonen er fullført.',
    'ui__reseller/logo_self__title' => 'Profilering av Plesk',
    'ui__reseller/logo_self__done' => 'Din profilering av Plesk er aktivert.',
    'ui__server/aspdotnet__done' => 'Globale ASP.NET-innstillinger ble endret.', // PFW
    'ui__server/certificate/default_multi__done' => 'Valgte SSL/TLS-sertifikat er satt opp til for å sikre tilkobling til nye hostete nettsteder.',
    'ui__server/certificate/delete_multi__done' => 'Valgte SSL/TLS-sertifikater ble fjernet.',
    'ui__server/certificate/download__done' => 'SSL/TLS-sertifikat ble lastet ned.',
    'ui__server/certificate/properties__done' => 'SSL/TLS-sertifikatets egenskaper ble oppdatert.',
    'ui__server/certificate/properties_new__done' => 'SSL/TLS-sertifikat %1 ble opprettet.',
    'ui__server/certificate/setup_multi__done' => 'De valgte SSL/TLS-sertifikat er satt opp til for å sikre tilkobling til Plesk.',
    'ui__server/certificate__done' => 'Operasjonen er fullført.',
    'ui__server/cp-certificate-download__done' => "Plesks SSL/TLS-sertifikat ble lastet ned.",
    'ui__server/crontab/properties__done' => 'Planlagte oppgaver for %1 ble endret.',
    'ui__server/crontab/task/delete__done' => 'Oppgaven ble fjernet.',
    'ui__server/crontab/task/delete_multi__done' => 'Oppgavene ble fjernet.',
    'ui__server/crontab/task/properties__done' => 'De planlagte oppgavene ble oppdatert.',
    'ui__server/crontab/task/properties_new__done' => 'Den nye oppgaven ble planlagt.',
    'ui__server/crontab/task/toggle_disable__done' => 'Den planlagte oppgaven %1 ble deaktivert.',
    'ui__server/crontab/task/toggle_enable__done' => 'Den planlagte oppgaven %1 ble aktivert.',
    'ui__server/crontab__done' => 'Operasjonen er fullført.',
    'ui__server/dns__done' => 'Operasjonen er fullført.',
    'ui__server/ip-address/client/delete__done' => "IP adressen ble fjernet fra brukerens IP utvalg.",
    'ui__server/ip-address/client/delete_multi__done' => "IP adressen ble fjernet fra brukerens IP utvalg.",
    'ui__server/ip-address/client/properties_new__done' => 'IP adressen ble tilordnet til brukere.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'IP-adresse %1 ble tildelt de valgte kundene.',
    'ui__server/ip-addresses__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/spam/recipients__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/spam/summary__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/spam__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/virus/recipients__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/virus/summary__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/virus/viruses__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics/virus__done' => "Operasjonen er fullført.",
    'ui__server/mail/statistics__done' => "Operasjonen er fullført.",
    'ui__server/mail__done' => 'Innstillingene for e-postserveren ble endret.',
    'ui__server/maillists__done' => 'Operasjonen er fullført.',
    'ui__server/mpc-certificates__done' => 'Sidelisten over tilgjengelige SSL/TLS-sertifikater i online-lageret ble åpnet.',
    'ui__server/pmm__done' => 'Operasjonen er fullført.',
    'ui__server/preferences__done' => "Innstillingene for serveren ble endret.",
    'ui__server/register__done' => 'MyPlesk.com siden ble åpnet.',
    'ui__server/services__done' => 'Operasjonen er fullført.',
    'ui__server/sitebuilder__done' => 'Operasjonen er fullført.',
    'ui__server/skeleton__done' => 'Operasjonen er fullført.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Adresse %1 ble fjernet fra serverens globale svarteliste.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Adressene ble fjernet fra serverens svarteliste.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Adressene ble lagt til i svartelisten.',
    'ui__server/spam-filter/black-list/address__done' => 'Adressene ble lagt til i svartelisten.',
    'ui__server/spam-filter/black-list__done' => 'Operasjonen er fullført.', // PFU
    'ui__server/spam-filter/properties__done' => 'Filter for søppelpostinnstillinger ble endret.',
    'ui__server/spam-filter/toggle_disable__done' => 'Spamfiltrering ble deaktivert globalt.',
    'ui__server/spam-filter/toggle_enable__done' => 'Spamfiltrering ble aktivert globalt.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Adresse %1 ble fjernet fra den globale hviteliste.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Adressene ble fjernet fra serverens hviteliste.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Adressene ble lagt til i hvitelisten.',
    'ui__server/spam-filter/white-list/address__done' => 'Adressene ble lagt til i hvitelisten.',
    'ui__server/spam-filter/white-list__done' => 'Operasjonen er fullført.', // PFU
    'ui__server/spam-filter__done' => 'Operasjonen er fullført.',
    'ui__server/statistics__done' => 'Operasjonen er fullført.',
    'ui__server/time__done' => "Systemdato og klokkeslett ble endret.",
    'ui__server__done' => "Operasjonen er fullført.",
    'ui__sessions/properties__done' => 'Operasjonen er fullført.',
    'ui__sessions__done' => 'Operasjonen er fullført.',
    'ui__sessions/delete__done' => 'Valgte økter ble slettet.',
    'ui__support__done' => 'Henvendelse om assistanse ble åpnet i et nytt nettleservindu eller flik.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Ingen filer som skal lastes opp.',
    'login_up__access_denied_no_permission' => "Tilgang nektet. Du har ikke tillatelse til å logge inn.",
    'mail__unable_remove_pattern' => "Kan ikke fjerne adressen fra serverens svarteliste: %1", // PFW
    'mail__incorrect_network_format' => 'Feil nettverk format: %1', // PFW
    'initconf__unable_change_passwd' => "Kan ikke endre administratorpassordet: %1",
    'initconf__unable_get_passwd' => 'Kunne ikke hente aktivt administratorpassord: %1 mislyktes: %2',
    'initconf__invalid_hostname' => 'Feil i vertsnavn "%1"',
    'initconf__unable_reconfig' => 'Kunne ikke konfigurere Plesk: reconfig mislyktes: %1',
    'initconf__unable_update_admin' => 'Kunne ikke oppdatere administratorens kontaktinformasjon: %1',
    '__refresh' => 'Oppdater',
    '__dalias_not_exist' => 'Domenealias eksisterer ikke.',
    '__bug146523_explanation' => 'Forrige versjon av Plesk tillot opptil 16 tegn i FTP-brukernavn. Denne versjonen av Plesk begrenser det maksimale antallet tegn som er tillatt i FTP-brukernavn til 15. For å løse dette problemet, må lengden på berørte FTP-brukernavn reduseres til 15 tegn, og minst ett tegn endres for å unngå konflikter med eksisterende FTP-brukernavn. Vi beklager enhver ulempe denne endringen har medført.',
    'domain__cannot_change_webmail' => 'Klarte ikke endre eposttjeneste for domenet: %1',
    'sb_publish_disable_warning' => 'Dersom du slår av opprettelse av nettsteder med Presence Builder, vil nettsteder som tidligere er opprettet i Presence Builder bli fjernet, og alle nettstedsdata vil gå tapt. Klikk OK hvis du ønsker å fortsette.',
    '__sbnet_client_use_sbnet' => "Opprett en samsvarende brukerkonto i Presence Builder",
    'mail_resp_activate' => 'Aktiver automatisk svar',
    'limitsManger__limit_available_error' => 'Kan ikke tildele nødvendige ressurser ("%%limitName%%"): bare %%available%% er tilgjengelig for din konto.',
    'limitsManger__limit_reserved_error' => 'Kan ikke allokere mindre ressurser ("%%limitName%%") enn allerede benyttet.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Klarte ikke å endre navn på domenet: En virtuell mappe med det angitte navnet finnes allerede.',
    'domain_unable_to_rename' => 'Klarte ikke å endre navn på domenet.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Generelt',
    'spamfilter__spamassassin_status_legend' => 'SpamAssassin spamfiltrering',
    'spamfilter__spamassassin_settings_legend' => 'Innstillinger for SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Slå på global SpamAssassin spamfiltrering.",
    'spamfilter__spamassassin_user_status_legend' => 'Slå på SpamAssassin spamfiltrering',
    'spamfilter__greylisting_status_legend' => 'Slå på global grålisting spambeskyttelse.',
    'spamfilter__personal_settings_not_allowed' => 'Bruk av personlige spamfiltreringsinnstillinger er ikke tillatt av systempolicyen.',
    'spamfilter__required_score' => 'Scoringen som en melding må få for å kvalifisere som søppelpost.',
    'spamfilter__rewrite_header_subject' => 'Legg til følgende tekst til begynnelsen av emne på hver melding som er gjenkjent som søppelpost',
    'spamfilter__use_mailuser_prefs' => 'Aktivere personlige innstillinger for spamfiltrering',
    'spamfilter__score_error' => 'Poengsummen skal ikke være negativ, delen foran desimalpunktet må være mindre enn 100, og kan inneholde maksimalt to tegn etter desimalpunktet.',
    'spamfilter__rewrite_header_error' => 'Meldingstittelen kan inneholde entvert utskrivbart tegn med unntak av siffertegnet (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Returner',
    'nonexistent_mail__mode_discard' => 'Forkast',
    'nonexistent_mail__mode_catch_addr' => 'Videresend til e-postadresse',
    'nonexistent_mail__mode_catch_ip' => 'Videresend til IP',
    'nonexistent_mail__bounce_not_supported' => 'Returneringsmodus støttes ikke',
    'nonexistent_mail__discard_not_supported' => 'Avvisningsmodus støttes ikke',
    'nonexistent_mail__catch_not_supported' => 'Videresending til e-postadressen støttes ikke',
    'nonexistent_mail__redirect_not_supported' => 'Videresending til IP støttes ikke',
    'nonexistent_mail__ip_used_on_this_host' => 'IP adressen oppløses til localhost',
    'nonexistent_mail_address_should_be_local_domain' => 'Siden utgående e-postkontroll er slått på, bør e-postadresse %1 for ikke-eksisterende mottakere tilhøre det valgte domenet. Hvis ikke, vil policyen "Avvis" gjelde i stedet for videresending.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Siden utgående e-postkontroll er slått på, bør e-postadressen som er spesifisert for videresending av e-post (%1) tilhøre det valgte domenet. Hvis ikke, vil meldinger som sendes til denne adressen ikke telles i Utgående e-postkontroll.',
    // mail acc extras
    '__antivirus' => "Antivirus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Ingen ekstra administratorkontoer er tilgjengelige.', // PFW
    'ui__client/domain/certificate__none-available' => 'Kunden har ingen SSL/TLS-sertifikater.',
    'ui__client/domain/certificate__none-available__1' => 'Kunden har ingen domener med SSL/TLS-sertifikater.',
    'ui__client/domain/certificate__none-available__2' => 'Domenet har ingen SSL/TLS-sertifikater.',
    'ui__reseller/client__none-available' => 'Det finnes ingen forhandlere med kunder.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Du må velge de IP-adressene som du vil fjerne fra IP-utvalget.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Du må velge forhandlerkontoene med de IP-utvalgene du ønsker å tilbakekalle en IP-adresse fra.',
    'ui__server/crontab/task/delete__empty_selection' => 'Du må velge hvilken aktivitet du vil avbryte.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Støtte for PHP er slått av for dette nettstedet.',
    'phosting__aspdotnet_not_enabled' => 'Støtte for ASP.NET er slått av for dette nettstedet.',
    'phosting__php_forced_by_site_isolation' => 'Kan ikke endre PHP-innstillingene: tillatelsene for å overstyre den globale sikkerhetspolicyen er ikke innvilget.',
    'phosting__option_forced_by_site_isolation' => 'Kan ikke endre innstillingene %1: tillatelsene for å overstyre den globale sikkerhetspolicyen er ikke innvilget.',
    'phosting__php_handler_id_not_registered' => 'PHP-behandlingsprogrammet er ikke tillatt i innstillingene for områdeisolasjon. Standard PHP behandler vil bli benyttet.',
    'phosting__php_served_by_nginx_is_not_available' => 'PHP-behandlingsprogrammet (FPM-applikasjon levert av nginx) er ikke tillatt i innstillingene for områdeisolasjon. Standard PHP behandler vil bli benyttet.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Vis listen over IP-adresser',
    'ui__client/ipaddress/properties_readonly__title' => 'Vis listen over IP-adresser',
    'ui__client/ipaddress/properties_readonly__description' => 'Vis listen over IP-adresser som er tilgjengelig for denne brukeren.',
    'ui__server/certificate__short-title' => 'SSL/TLS-sertifikater',
    'ui__server/certificate__title' => 'SSL/TLS-sertifikater',
    'ui__server/certificate__description' => 'Vis og behandle SSL/TLS-sertifikater.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Slett MIME typer',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Slett MIME typer',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Slett valgte MIME typer.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Legg til MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Legg til MIME-type',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Registrer en MIME type.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Fjern IP adresser',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Velg de IP-adressene du ønsker å fjerne fra IP-utvalget til kunde %1',

    // mail

    'ui__client/ipaddress__short-title' => 'IP-adresse',
    'ui__client/ipaddress__title' => 'IP-adresse',
    'ui__client/ipaddress__description' => 'Vis informasjon om IP adresser.',
    'ui__server/ip-address__short-title' => 'IP-adresse',
    'ui__server/ip-address__title' => 'IP-adresse',
    'ui__server/ip-address__description' => 'Vis informasjon om IP adresser.',
    'ui__client/domain/hosting/setup__short-title' => 'Innstillinger for webhosting',
    'ui__client/domain/hosting/setup__title' => 'Innstillinger for webhosting',
    'ui__client/domain/hosting/setup__description' => 'Sett opp innstillinger for webhosting for nettsted %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'MIME-type', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'MIME type egenskaper', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Se egenskaper for MIME type.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Feildokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Feildokument', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Feildokument egenskaper.', // PFW

    // tooltips

    'b_get_password_cancel' => 'Gå tilbake til forrige skjermbilde uten å sende e-posten.',
    'b_get_password_send' => 'Klikk OK for å sende en passordgjenopprettingsmelding til e-postadressen som er registrert i systemet.',



    'b_personaltrafficlist_search' => 'Angi et søkemønster og klikk for å finne domener.',
    'b_personaltrafficlist_show_all' => 'Vis alle domener.',

    'b_back' => 'Gå tilbake til forrige side.',
    'b_next' => 'Gå til neste side.',

    'b_dnsnstemplatelist_remove' => 'Slett den valgte navnetjeneren',
    'b_dnsnstemplatelist_search' => 'Skriv inn søkemønster, og klikk for å finne navnetjenere.',
    'b_dnsnstemplatelist_show_all' => 'Vis alle navnetjenere.',

    'l_dnsnstemplatelist_ns' => 'Sortering DNS-maloppføringer etter navneserver',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Generer sikre koblinger til filer og mapper',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Aktiver offentlige filer',
    'cu__serverfilesharing_fsPublicFolder' => 'Mappe for lagring av offentlige filer',
    'cu__serverfilesharing_fsPublicUrl' => 'Url-adresse for gjestetilgang til offentlige filer',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Aktiver passordbeskyttelse av offentlige filer',
    'cu__serverfilesharing_fsPartnerFolder' => 'Katalog for passordbeskyttet lagring',
    'cu__serverfilesharing_fsPartnersLogin' => 'Brukernavn for filtilgang',
    'cu__serverfilesharing_fsPartnersPassword' => 'Passord for filtilgang',
    'cu__serverfilesharing_fsDomain' => 'Rot-URL-adresse for webkatalog Domenenavn',
    'cu__serverfilesharing_fsPrefix' => 'Rot-URL-adresse for webkatalog Prefiks',
    'cu__serverfilesharing_commandUpdate' => 'Oppdater fildelingsinnstillinger for dokumentet',
    'cu__serverfilesharing_commandInfo' => 'Viser fildelingsinnstillinger for dokumentet',
    'subscription_rename_is_forbidden' => 'Endring av navn på abonnement er forbudt av serverpolicy.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Administrer planlagte oppgaver på serveren',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Velg den systembrukerkontoen du ønsker å administrere planlagte oppgaver for.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Planlagt oppgave %1',
    'ui__server/crontab/task__description' => 'Se egenskaper for den planlagte oppgaven %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Systembrukere',
    'ui__server/crontab_unknown__title' => 'Systembrukere',
    'ui__server/crontab_unknown__description' => 'Systembrukere som kan være eiere av planlagte oppgaver.',


    'ui__server/crontab__none-available' => 'Du har ingen systembrukerkontoer.',
    'ui__server/crontab_readonly-unknown__description' => 'Se planlagte oppgaver.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Planlagte oppgaver',
    'ui__server/crontab_readonly-unknown__title' => 'Se planlagte oppgaver',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Se planlagte oppgaver.',
    'ui__server/crontab_readonly__description' => 'Se planlagte oppgaver for %1.',
    'ui__server/crontab_readonly__short-title' => 'Planlagt oppgave for %1',
    'ui__server/crontab_readonly__title' => 'Se planlagte oppgaver for %1',
    'ui__server/crontab_unknown__wizard-title' => 'Behandle planlagte oppgaver.',

    'ui__server/crontab/properties__description' => 'Rediger planlagte oppgaver for %1.',

    'ui__server/crontab/properties__short-title' => 'Innstillinger',
    'ui__server/crontab/properties__title' => 'Rediger planlagte oppgaver for %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Se planlagte oppgaver.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Innstillinger',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Se planlagte oppgaver',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Se planlagte oppgaver.',
    'ui__server/crontab/properties_readonly__description' => 'Se planlagte oppgaver for %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Innstillinger',
    'ui__server/crontab/properties_readonly__title' => 'Se planlagte oppgaver for %1',
    'ui__server/crontab/properties_unknown__description' => 'Rediger planlagte oppgaver.',
    'ui__server/crontab/properties_unknown__short-title' => 'Egenskaper',
    'ui__server/crontab/properties_unknown__title' => 'Rediger planlagte oppgaver',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Rediger planlagte oppgaver.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Velg den systembrukeren du ønsker å se oppgavene til.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Velg den systembrukeren du ønsker å endre oppgavene til.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Lagre endringene ved å klikke på Fullfør og avslutt veiviseren.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Klikk Fullfør hvis du vil avslutte installasjonsveiviseren.',

    'ui__server/crontab/task__none-available' => 'Du har ingen planlagte oppgaver.',
    'ui__server/crontab/task__none-available__2' => 'Systembruker %1 har ingen planlagte oppgaver.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Planlagte oppgaver.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Oppgaver',
    'ui__server/crontab/task_readonly-unknown__title' => 'Planlagte oppgaver',

    'ui__server/crontab/task/delete__description' => 'Fjern den planlagte oppgaven %1',

    'ui__server/crontab/task/delete__short-title' => 'Fjern',
    'ui__server/crontab/task/delete__title' => 'Fjern den planlagte oppgaven %1',
    'ui__server/crontab/task/delete_multi__description' => 'Fjern planlagte oppgaver.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Fjern',
    'ui__server/crontab/task/delete_multi__title' => 'Fjern planlagte oppgaver',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Fjern planlagte oppgaver.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Velg den systembrukeren du ønsker å fjerne oppgaver fra.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Velg oppgaver du vil fjerne.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Bekreft fjerning av oppgaven ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',
    'ui__server/crontab/task/delete_unknown__description' => 'Fjern en planlagt oppgave.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Fjern',
    'ui__server/crontab/task/delete_unknown__title' => 'Fjern en planlagt oppgave.',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Fjern en planlagt oppgave.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Velg den systembrukeren du ønsker å fjerne en oppgave fra.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Velg oppgaven du vil fjerne.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Bekreft fjerning av oppgaven ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',

    'ui__server/crontab/task/properties__description' => 'Rediger planlagte oppgaver.',

    'ui__server/crontab/task/properties__short-title' => 'Rediger oppgave %1',
    'ui__server/crontab/task/properties__title' => 'Rediger planlagte oppgaver',
    'ui__server/crontab/task/properties_new__description' => 'Opprett planlagte oppgaver for %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Legg til oppgave',
    'ui__server/crontab/task/properties_new__title' => 'Opprett planlagte oppgaver for %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Opprett en planlagt oppgave.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Velg den systembrukeren du ønsker å opprette en planlagt oppgave for.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Lagre endringene ved å klikke på Fullfør og avslutt veiviseren.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Se de planlagte oppgavene.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Egenskaper',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Se de planlagte oppgavene',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Se de planlagte oppgavene.',
    'ui__server/crontab/task/properties_readonly__description' => 'Se planlagte oppgaver.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Se oppgave %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Se planlagte oppgaver',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Opprett planlagte oppgaver.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Legg til oppgave',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Opprett planlagte oppgaver',
    'ui__server/crontab/task/properties_unknown__description' => 'Rediger planlagte oppgaver.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Egenskaper',
    'ui__server/crontab/task/properties_unknown__title' => 'Rediger planlagte oppgaver',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Rediger planlagte oppgaver.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Velg den systembrukeren du ønsker å se oppgavene til.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Velg den systembrukeren du ønsker å endre oppgavene til.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Velg planlagt aktivitet.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Velg den planlagte oppgaven du vil endre.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Lagre endringene ved å klikke på Fullfør og avslutt veiviseren.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Klikk Fullfør hvis du vil avslutte installasjonsveiviseren.',

    'ui__server/crontab/task/toggle_disable__description' => 'Deaktiver den planlagte oppgaven %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Deaktiver',
    'ui__server/crontab/task/toggle_disable__title' => 'Deaktiver den planlagte oppgaven %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Aktiver den planlagte oppgaven %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Aktiver',
    'ui__server/crontab/task/toggle_enable__title' => 'Aktiver den planlagte oppgaven %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Aktiver eller deaktiver planlagte oppgaver.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Aktiver eller deaktiver',
    'ui__server/crontab/task/toggle_unknown__title' => 'Aktiver eller deaktiver planlagte oppgaver',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Aktiver eller deaktiver planlagte oppgaver',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Velg den systembrukerkontoen du ønsker å aktivere eller deaktivere oppgaver for.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Velg den oppgaven du vil aktivere eller deaktivere.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Kundekontoer', // not used on HP?
    'ui__client_unknown__title' => 'Kundekontoer', // not used on HP?
    'ui__client_unknown__description' => 'Administrer kundekontoer.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Suspender domene', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Suspender domene', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Suspender et domene.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Aktiver domene', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Aktiver domene', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Aktiver et domene.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "FTP-kontoer under domenet %1", // for Additional FTP Accounts
    '__ftp_users_list' => "FTP-kontoer",
    'ftp__user_name' => "Navn på FTP-konto:",
    'ftp__user_home' => "Hjemmemappe",
    'ftp__invalid_path' => "Ugyldig målbane er angitt",
    'i_ftp_ses_sub_user' => 'FTP-kontoøkt.',
    '__new_passwd' => "Nytt %1 passord",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Kunne ikke konfigurere webserver på verten <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Kunne ikke generere konfigurasjonsfil for webserver på verten <%%host%%> på grunn av følgende feil:\n\n%%error%%\n\nRett opp feilene i malene for webserverkonfigurasjon, og generer filen på nytt.",

    'apacheConfigurationMessageAdminTitle' => 'Generering av webserverkonfigurasjon feilet',
    'apacheConfigurationMessageClientTitle' => 'Advarsel',

    'apacheConfigurationFailedAdminHomeMessage' => 'Ny konfigurasjonsfil ble ikke etablert på grunn av feil i konfigurasjonsmalene. Detaljert feilmelding ble sendt til din e-postadresse. Vær så snill sjekke e-posten, fiks feilen, og klikk %1 for å prøve å generere konfigurasjonen på nytt.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'her', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Ny konfigurasjon for domenet %1 ble ikke opprettet på grunn av feil i konfigurasjonsmalene. Detaljert feilmelding ble sendt til din e-postadresse. Vær så snill sjekke e-posten, fiks feilen, og klikk %2 for å prøve å generere konfigurasjonen på nytt.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'her', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Konfigurasjon av webserver for domenet %1 kan være inkonsekvent. Kontakt serveradministratoren for å løse problemet.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Ny konfigurasjon for noen domener ble ikke opprettet på grunn av feil i konfigurasjonsmalene. Detaljert feilmelding ble sendt til din e-postadresse. Vær så snill sjekke e-posten, fiks feilen, og klikk %1 for å prøve å generere konfigurasjonen på nytt.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'her', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Konfigurasjon av webserver for noen av domenene dine kan være inkonsekvent. Kontakt serveradministratoren for å løse problemet.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Brukerdefinerte feildokumenter",
    'dom_pref__webusers_script' => "Tillat webbruker å bruke skript",
    '__seoRedirect' => 'Konfigurer foretrukket domene som',
    '__seoRedirectToLanding' => 'domene.tld',
    '__seoRedirectToWww' => 'www.domene.tld',
    '__seoRedirectNone' => 'Ingen',

    '__sites' => 'Domener',
    'domain_plan__perm_denied_manage_phosting' => 'Du har ikke tillatelse til å administrere hostinginnstillingene.',
    '__owned_by_client' => 'eid av kunde',
    'ui__client/permissions_readonly__description' => "Vis de handlingene kunde %1 kan utføre i Plesk.",
    'backup__restore__object_client_template' => 'Kundemal',
    '__template_name' => 'Navn på tjenesteplan',
    'template__not_exists' => 'Denne tjenesteplanen finnes ikke',
    'template__exists' => 'Det finnes allerede en plan med navnet %1.',
    'clientOwnerChanger__ip_not_in_pool' => 'Angitt IP-adresse finnes ikke i forhandlerens utvalg.',

    //// Change owner of subscription
    'chown__select_title' => "Velg ny abonnent",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Velg en ny eier for de valgte abonnementene og klikk på Neste >>.',
    'domains__client_info' => "%1 abonnementer, %2 aktive abonnementer, %3 diskplass brukt, %4 trafikk brukt",
    '__possible_owners' => 'Mulige nye eiere av abonnementer',

    'clients_list__filter_owner__filter_title' => 'Leverandør',
    'clients_list__filter_owner_any' => 'Alle brukere',
    'clients_list__filter_owner_my' => 'Kun mine abonnenter',
    'clients_list__filter_owner_name__filter_title' => 'Leverandørens navn',

    '__owner' => "Leverandør",
    'l_clientslist_owner' => 'Sorter brukerkontoer etter leverandør.',
    'l_clientslist_date' => 'Sorter brukerkontoer etter opprettelsesdato.',
    'l_clientslist_name' => 'Sorter brukerkontoer etter navn.',
    'l_clientslist_domains' => 'Sorter brukerkontoer etter domener.',
    'l_clientslist_cname' => 'Sorter brukerkontoer etter firmanavn.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Ny tildeling av valgte abonnementer',
    'chown__check_title' => 'Bytt abonnent',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Klikk Fullfør for å fullføre nytildelingen. Når det er ferdig, vil de valgte abonnementene bli tildelt en ny eier, leverandøren vil bli endret til den nye eierens leverandør og de vil bli løst fra tjenesteplanene sine og bli 'Brukerdefinert'.",

    'chown__error_check' => 'Det oppstod noen problemer under forsøket på å knytte noen av abonnementene til en ny eier.',
    'domain_chown_subscription_will_be_anonymous' => "Abonnementer vil bli løst fra de aktive tjenesteplanene sine og bli 'Brukertilpasset'.",
    'chown__error_domains_exclude' => "Det oppstod noen problemer under forsøket på å knytte noen av abonnementene til en ny eier. Disse abonnementene er merket.",
    'chown__ip_not_in_client_pool' => "IP-adressen som er tilknyttet dette abonnementet ble ikke lagt til IP-utvalget til den nye eieren.",
    'chown__already_owned_by_client' => "Dette abonnementet tilhører allerede denne brukeren.",

    '__redirect_hint' => 'Du vil bli videresendt til en ny adresse om 15 sekunder... Hvis du ikke blir tatt til den nye lokasjonen automatisk, aktiver javascript, eller klikk koblingen %%link%%.',

    'backup__restore__object_maillist' => 'Adresseliste',
    'backup__restore__object_site' => 'Område',
    'backup__restore__object_user' => 'Bruker',
    'backup__restore__object_role' => 'Rolle',

    'limit__name_max_site' => 'omrader',

    'iis_pool__unable_rename_client' => "Kan ikke døpe om IIS applikasjons utvalg: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Anonym FTP-tjeneste støttes bare for hoveddomenet for et abonnement.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Anonym FTP-tjeneste støttes bare for hoveddomenet for et abonnement.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/måned',
    '__tb_month' => 'TB/måned',

    '__customers' => 'Kunder',
    '__customer_name' => 'Kundenavn',
    '__customer_total' => 'Kundetotal',
    '__site' => 'Område',
    '__def_site' => 'Standardområde',
    '__subscription_name' => 'Abonnementsnavn',
    '__subscription_name_powerUser' => 'Abonnementsnavn',

    'limit__units_max_traffic_suffix' => '/måned',

    'dom_pref__discard' => "Avvis",

    'mail__pattern_already_exists' => 'Mønster "%1" er allerede i svartelisten.',

    '__not_supported' => 'Ikke støttet',

    'plesk_key__sitebuilder' => 'Områder publisert med Presence Builder',
    'limit__name_max_site_builder' => 'Områder publisert med Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Støtte for nettsteder med flere språk i Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Dataoverføringsstatistikk for <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Dataoverføringsstatistikk for <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "Dataoverføring av tjenester",

    'login_up__access_denied_no_subscriptions' => "Tilgang nektet. Det er ingen abonnementer tilgjengelige for denne kontoen.",

    'interval__day' => '%1 dag(er)',
    'interval__hour' => '%1 time(r)',
    'interval__minute' => '%1 minutt(er)',
    'interval__second' => '%1 sekund(er)',

    ///License options
    'plesk_key__backward_incompatibility' => 'Du prøver å bruke lisensnøkkel opprettet for en annen versjon av Plesk. Ta kontakt med Plesk salgsrepresentant for å få tak i en korrekt lisensnøkkel.',
    //Standalone or virtualization
    'virtualization_any' => "Fysisk server eller hvilken som helst virtualiseringsløsning",
    'virtualization_pvc' => "Virtuozzo-beholdere",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo-server",
    'plesk_key__virtualization' => "Gyldig for de følgende miljøer:",
    'plesk_key__virtualization_only_key' => 'Lisensnøkkelen er kun ment for bruk sammen med Plesk inne i et %1 virtuelt miljø.',
    'plesk_key__virtualizations_only_key' => 'Lisensnøkkelen er kun ment for bruk sammen med Plesk inne i følgende virtuelle miljøer: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Bruk av brukerdefinerte språkpakker er forbudt.',
    'plesk_key__allowed-locales' => 'Tilgjengelige språk',
    'plesk_key__allowed-locales-any' => 'Hvilket som helst språk',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'cgi-bin-mappen er plassert i',
    '_cgi_bin_mode_webspace' => 'rotmappen for abonnementet',
    '_cgi_bin_mode_www_root' => 'dokumentroten for dette domenet',

    /// Custom buttons
    'custom_button__sort_key' => 'Prioritet',
    'custom_button__place' => 'Plassering',
    'custom_button__place_navigation' => 'Felles tilgang',
    'custom_button__place_admin' => 'Administrator-startside',
    'custom_button__place_admin-settings' => 'Administratorside for verktøy og innstillinger',
    'custom_button__place_reseller' => "Forhandlerens startside",
    'custom_button__place_reseller-settings' => 'Forhandlerens Verktøy og tilbehør-side',
    'custom_button__place_client' => 'Kundens startside',
    'custom_button__place_domain' => "Siden Nettsteder og domener for et abonnement",
    'custom_button__place_domain_powerUser' => "Siden Nettsteder og domener for et abonnement",
    'custom_button__place_domain-properties' => 'Nettstedsverktøy',
    'custom_button__private' => 'Vis kun for meg',
    'custom_button__image' => 'Bakgrunnsbilde',
    'custom_button__conhelp' => "Verktøytipstekst",
    'custom_button__edit' => "Innstillinger for en kobling til en ekstratjeneste",
    'custom_button__include_client_cname' => "Inkluder kundens bedriftsnavn",
    'custom_button__include_client_email' => "Inkluder kundens epostadresse",
    'custom_button__include_client_id' => "Inkluder kunde-ID",
    'custom_button__include_client_pname' => "Inkluder kundens kontaktnavn",
    'custom_button__include_domain_id' => "Inkluder abonnement-ID, domene-ID og domenealias-ID",
    'custom_button__include_domain_id_powerUser' => "Inkluder abonnement-ID, domene-ID og domenealias-ID",

    'custom_button__include_domain_name' => "Inkluder navn på primærdomene",
    'custom_button__include_ftp_user' => "Inkluder FTP brukernavn",
    'custom_button__include_ftp_pass' => "Inkluder FTP-passord",
    'custom_button__internal_open' => "Åpne URL-adresse i Plesk",
    'custom_button__text' => "Knappeetikett",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Filen er ikke en bildefil.',
    'custom_button__big_image' => 'Filen skal ikke overstige 100 KB.',
    'custom_button__failed_copy_image' => 'Kan ikke kopiere filen: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Kan ikke gjenopprette en ikke-Power-User sikkerhetskopi i en Power User visning.',
    '__unknown_network_interface' => 'Ukjent nettverksgrensesnitt.',

    'init_conf__ip_address' => 'IP-adresse',

    //Confirmation page
    'bt_confirm' => 'Bekreft',
    'b_confirm' => 'Bekreft eierskap for dine områder.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Innstillinger for dedikert IIS programutvalg settes i samsvar med sikkerhetsinnstillinger for hele serveren (konfigurasjon for nettstedsisolasjon).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Innstillinger for dedikert IIS programutvalg settes i samsvar med ytelsesinnstillinger for hele serveren.',

    '__current' => 'Gjeldende',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Brukeregenskaper ble oppdatert.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Du har brukt nesten alle domenene som ble levert med Plesk-lisensen din (90 % eller mer).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Du har brukt nesten alle domenene.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Du har brukt nesten alle Presence Builder-nettstedene som ble levert med Plesk-lisensen din (90 % eller mer).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Du har brukt nesten alle Presence Builder-områdene.',
    'promo__button_hide' => 'Skjul',
    'promo__button_next' => 'Neste >>',
    'promo__button_prev' => '<< Forrige',
    'promo__button_license' => 'Oppdater lisens',

    'promo__google_integration_title' => 'Integrasjon med Google-tjenester',
    'promo__google_integration' => 'Konfigurer integrasjon med Google-tjenester som AdSense, Google Apps, Verktøy for nettredaktører.',
    'promo__google_integration_button' => 'Konfigurer',

    'promo__button_learn_more' => 'Lær mer',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Du kan tilpasse utseendet til grensesnittet og innstillinger for varemerking ved hjelp av brukerdefinerte temaer. For instruksjoner om egendefinerte Plesk-temaer, se %1.',
    'panel_branding__description_link' => 'følgende dokument',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Pakk ut filer',
    'b_filemanager__extract' => 'Pakk ut filer fra de valgte arkivene i nåværende mappe. Bemerk, at filnavnene kan vises ukorrekt etter ekstraksjonen dersom de inneholder lokale nasjonale tegn.',
    'filemanager_error_extracting_files' => 'Det oppstod en feil under utpakking av arkivfilene: %1',
    'filemanager_no_archive_files_specified' => 'Angi arkivet du ønsker å pakke ut.',
    'filemanager_not_zip_archive_specified' => '%1 kan ikke pakkes ut, det er ikke et ZIP arkiv.',
    'filemanager_files_successfully_extracted' => 'Arkivfilene ble pakket ut.',
    'filemanager_error_file_download' => 'Nedlasting av filen mislyktes: %1',
    'filemanager__user_poolgrp' => 'Programutvalgsgruppe',

    'loading' => 'Laster inn...',
    'bt_create_archive' => 'Legg til i arkivet',
    'filemanager__pack' => "Målbane til arkivet: %1",
    'filemanager__archive_name' => 'Arkivfil navn',
    'filemanager__empty_filename' => 'Angi arkivfilnavnet.',
    'filemanager_archive_created' => 'Opprettelse av arkivet var vellykket.',
    'filemanager_error_creating_archive' => 'Kan ikke opprette arkivet: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "AAAA-oppføringen vil komme i konflikt med limposten for sonen.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(FTP-serveren støtter ikke Ipv6-adresser.)",
    'cmd_dns__glue_dns_record_conflict' => 'Denne oppføringen vil komme i konflikt med limposten for sonen \'%1\'.',
    '__ftp_ipv6_not_supported' => "(FTP-serveren støtter ikke Ipv6-adresser.)",
    '__ipv6_not_supported' => 'IPv6 støttes ikke.',
    'mail__ipv6_not_supported' => 'IPv6 støttes ikke av e-postserveren.',
    'mail__relay_while_list_ipv6_not_supported' => 'Hvitlisting for videresending for IPv6 støttes ikke av e-postserveren.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Maske verdien må være et multiplum av 16.',
    'mail__ip_or_mask_is_invalid' => 'IP-adresse eller maske er ugyldig.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Videresending til IPv6 IP adresser støttes ikke.',
    'sa__invalid_trusted_networks' => 'Feilaktig spesifisert klarerte nettverk: %1',
    'dns_add__enter_ipv6_address' => "IPv6 adresse",
    'license_trial_days_left' => 'Plesk har en prøvelisens som utløper om %1 dager.',
    'excl_ipv6_num' => 'Dedikert IPv6 adresse',
    '__ip_mask' => "Nettverksmaske",
    '__ipv4_addr' => 'IPv4-adresse',
    '__ipv6_addr' => 'IPv6 adresse',
    'template__num_excl_ipv6s' => 'Tildel dedikerte IPv6-adresser til forhandler',
    'anonftp__exclusive_ipv4_required' => 'Det kreves en dedikert IPv4-adresse for å sette opp og bruke anonym FTP-tjeneste.',
    'anonftp__ipv4_already_used' => 'Du kan ikke sette opp anonym FTP-tjeneste for dette nettstedet da det allerede er konfigurert på et annet domene på den samme IPv4-adressen.',


    'restart__kav' => "Kaspersky Antivirus",
    '__view_migration_log_detailed_info' => 'Vis loggen',

    'chown__ip_address_warn' => 'Før du flytter abonnementet til den nye eieren, må du velge en ny IP-adresse for dette abonnementet.',
    'chown__no_ip_address' => 'Ingen',
    'chown__no_ipv4_address' => 'Ingen IPv4 adresse',
    'chown__no_ipv6_address' => 'Ingen IPv6 adresse',
    'chown__domain_exclude_already_owned_by_client' => 'Dette abonnementet %1 tilhører allerede denne brukeren.',
    'chown__error_ip_absent_in_ip_pool' => 'IP adressen %1 finnes ikke i IP utvalget for målbrukeren.',
    'chown__error_ip_not_exist' => 'IP adressen med ID \'%1\' finnes ikke',
    'chown__error_domain_ip_not_selected' => 'Minst én IP-adresse for domenet %1 bør være valgt. Kontroller de valgte verdiene for IP tilordning.',

    '__new_passwd_single' => "Passord",
    '__confirm_passwd_single' => "Bekfreft passord",

    'mail__ip_or_mask_is_invalid_ipv6' => 'IPv6 adresse eller maske er ugyldig: IP adresse må være en gyldig unicast adresse.',

    '__subscriptions' => 'Abonnementer',

    '__owned_by_reseller' => 'eid av forhandler',
    '__owned_by_provider' => 'eid av leverandør',

    'service_plan__anonymous' => 'Egendefinert',
    'subscription_not_locked__change_limits_warning' => 'Dette abonnementet er ikke låst: Grenser for ressursbruk vil bli endret under synkronisering med tjenesteplanen.',
    'subscription_not_locked__change_permissions_warning' => 'Dette abonnementet er ikke låst: Tillatelsene vil bli endret under synkronisering med tjenesteplanen.',

    'subscription__conflict_resolution_policy' => 'Konfliktløsings policy',
    'subscription__conflict_resolution_policy_lock' => "Lås abonnement",

    'backup__list__backup_warnings' => 'Advarsler',
    'backup__list__backup_info' => 'Informasjon',
    'backup__restore__object_reseller_template' => 'Forhandlermal',
    'backup__restore__object_domain_template' => 'Domenemal',

    'ui__client/permissions_readonly__title' => 'Tillatelser',
    'ui__client/permissions_readonly__short-title' => 'Tillatelser',

    'subscription__unable_lock_anonymous' => 'Dette abonnementet er ikke tilknyttet en tjenesteplan, og kan dermed ikke låses opp.',
    'subscription__unable_sync_anonymous' => 'Dette abonnementet er ikke tilknyttet en tjenesteplan, og kan dermed ikke synkroniseres.',
    'subscription__unable_sync_locked' => 'Dette abonnementet er låst og kan dermet ikke synkroniseres.',
    'subscription__locked' => 'Abonnementet er låst.',
    'component_name__urlrewrite' => "Skriv URL-adresse på nytt",
    '__quantity' => 'Antall',
    'hst__www_root_dir_absent' =>  'Advarsel: Mappen som er angitt som rotmappe for dokumenter, finnes ikke.',
    'object_creation__domain_is_not_a_webspace' => 'Dette objektet kan bare opprettes i et abonnement.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Abonnementet inneholder nettsteder, derfor kan du ikke endre hostingtype eller slette det.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Feil: Mislyktes med å oppdatere IP adressen. Tilleggsdomener kan ikke tilordnes en IP adresse som ikke er tilordnet hoveddomenet for abonnementet.',
    'domain_plan__unable_change' => 'Klarte ikke endre tjenesteplan: %1.',
    'domain_plan__different_hosting_type' => 'Den aktive hostingtypen er forskjellig fra den typen som er angitt i tjenesteplanen.',
    'domain_plan__addon_text' => 'Tilleggsabonnement',
    'domain_plan__addon_description' => 'Tilleggsplan brukes til å supplere en hostingplan.',
    'asp_net__managed_runtime_version' => 'ASP.NET kontrollert kjøretidsversjon',
    'plan__can_not_change_hosting_type' => 'Det er umulig å endre hostingtype under redigering av en plan.',
    'plan__apply_problems' => 'Planen ble ikke tatt i bruk på grunn av problemer med følgende funksjonalitet: %1',
    'plan_save__subscription_update_problem' => 'Kan ikke applisere abonnement endringer til %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Abonnementet er midlertidig suspendert helt til sikkerhetskopieringen eller gjenopprettingen er fullført. Vennligst kom tilbake senere.",
    '__login_incorrect_plain_shadow_password' => 'Du oppga feil passord for administratorkontoen. Bruk systemadministrators påloggingsinformasjon (root), eller få tak i riktig passord. For å lære mer om å finne passordet, les /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Du kan ikke sende IP-adressen du ikke eier.',

    'dns__dns_zone_not_synchronized' => 'DNS-sonen ble endret. Dersom du vil aktivere endringene på DNS-malen for denne sonen, klikker du enten på knappen \'Aktiver endringer i DNS-malen\' på denne siden, eller velger alternativet \'Aktiver endringer for alle soner\' i Serveradministrasjonspanel > Verktøy og Innstillinger > Innstillinger for DNS-mal > Aktiver endringer i DNS-mal.',
    'dns__dns_zone_synchronize_link' => 'Klikk',
    'dns__dns_zone_synchronize_done' => 'DNS-sonen ble synkronisert.',

    'dns__dns_zone_template_error' => 'Det var problemer ved synkronisering av DNS soner med DNS sone-mallen.%1',

    'dns__soa_rname_type_owner' => 'Nettstedeierens e-postadresse',
    'dns__soa_rname_type_domain' => 'E-postadresse for domenet',
    'dns__soa_rname_type_external' => 'Ekstern e-postadresse',
    'dns__soa_rname_enforce_email' => 'Forby endring av RNAME e-post adressen på en per domene-basis',
    'dns__soa_rname_label' => 'E-post (RNAME)',
    'dns__soa_rname_hint' => 'E-postadressen til personen som er ansvarlig for domenets DNS-sone. Returnert fra DNS-serveren som svar på SOA-forespørsler.',

    'dns__dns_zone_soa_sync_title' => 'Overstyr SOA-innstillinger for alle eksisterende domener',
    'dns__dns_zone_soa_sync_legend' => 'Bekreftelse kreves',
    'dns__dns_zone_soa_sync_text' => 'Oppdatere SOA-oppføringer for alle hostede domener ved å bruke endringene gjort i SOA-malen?',

    'cu_db__repair_mysql_dbus' => "Reparer MySQL brukerpassord Denne operasjonen er nødvendig dersom du oppgraderte til Plesk 11 fra en tidligere versjon.",

    'cu_scheduled_backup_comment' => 'Planlagt sikkerhetskopiering',
    'cu_scheduled_backup_error' => 'Det har oppstått en feil under sikkerhetskopieringen: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Det har oppstått en feil under den skjemalagte sikkerhetskopieringen.',
    'cu_scheduled_backup_mail_message' => "%1\nPlesk inngangspunkt: %2 \n\nFølgende feil oppsto under den skjemalagte sikkerhetskopieringen: \n\n%3",

    'cu_scheduled_backup_hourly' => 'Sikkerhetskopiering per time',
    'cu_scheduled_backup_daily' => 'Daglig sikkerhetskopiering',
    'cu_scheduled_backup_weekly' => 'Ukentlig sikkerhetskopiering',
    'cu_scheduled_backup_monthly' => 'Månedlig sikkerhetskopiering',
    'cu_scheduled_backup_comment_backup_all' => '%1. All konfigurasjon og innhold.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. All konfigurasjon og alt innhold unntatt e-postmeldinger.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Kun konfigurasjon og e-postmeldinger.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. All konfigurasjon og alt innhold unntatt brukerdatabasert.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. All konfigurasjon og alt innhold unntatt brukerfiler.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Kun konfigurasjon og brukerdatabaser.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Kun konfigurasjon og brukerfiler',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Domenekonfigurasjon.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Lagring av planlagte sikkerhetskopier i ekstern nettskylagring er en premium-funksjon. Kontakt nettvertsleverandøren for å låse opp.',

    'i_backup_invalid_file' => 'Dette er ikke en gyldig sikkerhetskopi. Kan ikke gjenopprette data fra denne filen. Klikk på sikkerhetskopi navnet for å få detaljer.',

    'ui__server/migration/download-agent__short-title' => 'Last ned Migration & Transfer Agent',
    'ui__server/migration/download-agent__title' => 'Last ned Migration & Transfer Agent',
    'ui__server/migration/download-agent__description' => 'Last ned siste versjon av Migration & Transfer Agent fra Plesk nettsted.',

    'filemanager_resulting_archive_exists' => 'Filen %1 finnes allerede i målmappen.',

    'agent_unable_to_connect' => 'Ute av stand til å kobles opp til agenten på \'%2\'. Vennligst kontroller at agent er installert og kjører, og at det ikke er noen tilkoblingsproblemer med verten \'%2\'.',
    'agent_test_connection_failed' => 'Forbindelse til agenten på \'%2\' gikk galt.',

    'agent_unable_to_resolve_host' => 'Kunne ikke finne den eksterne verten \'%1\'. Vennligst kontroller at det ikke er noen tilkoblingsproblemer med verten.',
    'agent_unknown_curl_error' => 'Feilen \'%1\' oppsto i løpet av oppkoblingen til agenten på \'%2\'.',
    'agent_unexpected_htp_code' => 'Den uventede HTTP koden \'%1\' ble mottatt på HTTP forespørselen til agenten på \'%2\'.',
    'agent_unable_to_auth' => 'Klarer ikke autentisere verten \'%1\'. For å løse dette problemet, følg instruksjonene i http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'En intern serverfeil oppstod under utførelse av kommando på den eksterne verten \'%1\'.',
    'agent_response_is_empty' => 'Et tomt svar ble mottatt på HTTP henvendelsen til agenten på \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Kan ikke finne Migration & Transfer Agent i det lokale bufferet. Vennligst åpne Migration & Transfer Manager på nytt for å rette problemet.',

    '__hosting_webdeploy' => "Web Deploy-publisering",
    'cu_domain__webdeploy' => "Web Deploy publisering (standard: %1)",
    'cu_dom_tpl__webdeploy' => "Web Deploy publisering (standard: %1)",
    'cu_subdomain__webdeploy' => "Web Deploy publisering (standard: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy er ikke installert på serveren",
    'webdeploy__forced_by_site_isolation' => "Kan ikke endre Web Deploy publiserersinnstillinger: Du ikke har tillatelse til å overstyre global sikkerhetspolicy. Ta kontakt med leverandøren din for detaljer.",



    'backup__restore_options__admin__server_configuration_license' => 'Lisensnøkkel',
    'migration_start_migrate_server_license' => 'Overføre lisensnøkkel',

    'defaultcomponents__delegation_rule_not_exist' => '(den påkrevede delegeringsregelen \'appPoolPipeline, appPoolNetFx\' eksisterer ikke)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Sikkerhetskopien ble opprettet av administratoren.',
    'i_backup_created_by_reseller' => 'Sikkerhetskopien ble opprettet av en forhandler.',
    'i_backup_created_by_client' => 'Sikkerhetskopien ble opprettet av en kunde.',

    'migration__object_exists_on_target_host' => '(finnes allerede på målverten)',

    '__customers_total' => 'Sum etter kunder',
    '__resellers_total' => 'Sum etter forhandlere',
    '__reseller_total' => 'Forhandler sum',


    'cu_cl_pref__manage_website_maintenance' => 'Få tilgang til avanserte operasjoner: Kopiering av webområde',
    'cu_cl_pref__manage_protected_dirs' => 'Administrasjon av passordbeskyttede kataloger',
    'cu_cl_pref__manage_mail_settings' => 'Mulighet til å endre e-postinnstillinger',


    'cu__command_update_php_settings' => 'Oppdater PHP-innstillinger',
    'cu__php_settings_option' => 'Angir banen til filen med PHP-innstillinger.',

    'cu__additional_php_settings_option' => 'Setter banen til filen med ytterligere PHP-direktiver.',
    'cu__command_show_php_settings' => 'Viser gjeldende PHP-innstillinger.',
    'cu__general_settings' => 'Generelle innstillinger:',
    'cu__performance_settings' => 'Ytelsesinnstillinger:',
    'cu__php_fpm_settings' => 'PHP-FPM-innstillinger:',
    'cu__additional_directives' => 'Ytterligere direktiver:',

    'php_settings_permission_required' => 'Administrasjon av generelle PHP-innstillinger',
    'php_settings_performance_permission_required' => 'Administrasjon av innstillinger for hostingytelse',
    'php_settings_customized' => 'PHP-innstillingene ble endret.',
    'php_settings_synchronized_with_plan' => 'PHP-innstillingene må være synkronisert med planen.',
    'phosting__unknown_shell_type' => 'Ikke-tilgjengelig skall',

    'login_up__access_denied_subscription_deleted' => 'Ingen tilgang: Abonnementet ditt ble fjernet.',

    'role_restricted_to_subscription' => '(overført med abonnementet: %1)',

    'filemanager__extract' => "Pakk ut filer til: %1",

    'cu__license_command_check_installed_license' => 'Kontroller gyldigheten av den installerte lisensnøkkelen (returnerer utgangskoden 0 hvis nøkkelen er gyldig og 1 hvis den er ugyldig)',

    'promo__mobile_manager_title' => 'Plesk Mobile Server Manager',
    'promo__mobile_manager' => "Utvid Plesk-funksjonaliteten til å kunne kontrollere og overvåke serveren fra mobile enheter (BlackBerry, iPhone og Android).",
    'promo__mobile_monitor_title' => 'Plesk Mobile Server Monitor',
    'promo__mobile_monitor' => 'Hent den viktigste informasjonen om Plesk-servere når som helst og hvor som helst fra en mobil enhet (BlackBerry, iPhone og Android).',
    'promo__mobile_button' => 'Lær mer',

    'ui__server/migration/video__short-title' => 'Instruksjonsvideoer',
    'ui__server/migration/video__title' => 'Se på instruksjonsvideoer',
    'ui__server/migration/video__description' => 'Se på instruksjonsvideoer.',

    'subDomainNameHint' => 'Skriv inn * som underdomenenavn for å opprette et jokertegn underdomene. Besøkende til området vil bli viderekoblet til dette underdomenet uansett hvilken underdomenenavn de skriver inn i nettleseren.',
    'subdomains__wildcard_name_invalid' => "Underdomene-navn er ugyldig. Du kan bare bruke alfanumeriske tegn og bindestrek (-) og en stjerne (*) for jokertegn underdomenenavn.",
    'subdomains__name_invalid' => "Underdomene-navn er ugyldig. Du kan bare bruke alfanumeriske tegn og bindestrek (-) for underdomenenavn.",

    'domain__wildcard_no_www_prefix' => 'Det er ikke mulig å bruke www prefikset for jokertegn underdomener.',

    '__service_title__milter' => "Plesk Postfix milter",
    '__service_description__milter' => "Plesk Postfix e-postfilter",
    '__milter' => "Postfix milter",
    'restart__milter' => "Plesk milter (%1)",
    'restart__pop3' => "Courier POP3-server",
    'restart__pop3s' => "Courier POP3-server med SSL/TLS-støtte",
    'restart__imap' => "Courier IMAP-server",
    'restart__imaps' => "Courier IMAP-server med SSL/TLS-støtte",
    'restart__authdaemon' => "Courier IMAP autentiserings daemon",
    'restart__imap-pop3' => "Dovecot IMAP og POP3-server",


    'addon_packages_not_supported' => 'Tillegg for APS-pakkede webapper er ikke støttet.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Klarte ikke å automatisk tildele en IP-adresse til domenet. Vennligst angi en IP-adresse ved hjelp av alternativet -ip.',

    'plesk_key__mb_accounts' => 'Brukerkontoer (forhandlere og kunder) i Customer and Business Manager',

    'actionlog__subdomain_dns' => 'Underdomenets DNS-sone',
    'actionlog__site_subdomain_dns' => 'DNS-sone til et underdomene under et annet domene',

    // PfW only
    'actionlog__event_site_create' => 'Domene ble opprettet',
    'actionlog__event_site_delete' => 'Domene ble slettet',
    'actionlog__event_site_update' => 'Domene ble oppdatert',

    'actionlog__event_site_status_update' => 'Domenestatus ble oppdatert',
    'actionlog__event_site_dns_update' => 'Domenets DNS-sone ble oppdatert',
    'actionlog__event_site_guid_update' => 'Domene-GUID ble oppdatert',

    'actionlog__event_site_subdomain_create' => 'Underdomene opprettet',
    'actionlog__event_site_subdomain_delete' => 'Underdomene slettet',
    'actionlog__event_site_subdomain_update' => 'Underdomene oppdatert',

    'actionlog__event_site_alias_create' => 'Domenealias ble opprettet',
    'actionlog__event_site_alias_delete' => 'Domenealias ble slettet',
    'actionlog__event_site_alias_update' => 'Domenealias ble oppdatert',

    'actionlog__event_site_alias_dns_update' => 'DNS-sonen for et domene ble oppdatert',
    'actionlog__event_subdomain_dns_update' => 'DNS-sone for et underdomene under standarddomenet ble oppdatert',
    'actionlog__event_site_subdomain_dns_update' => 'DNS-sonen til et underdomene ble oppdatert',
    // End of PfW only

    'win_policy__bad_password' => 'Validering mislyktes. Passordet er ugyldig.',
    'win_policy__password_too_short' => 'Validering mislyktes. Passordet oppfyller ikke krav til passord fordi det er til kort.',
    'win_policy__password_too_long' => 'Validering mislyktes. Passordet oppfyller ikke krav til passord fordi det er til langt.',
    'win_policy__password_not_complex_enough' => 'Bekrefting mislyktes. Passordet er ikke sterkt nok og innfrir ikke kravene i retningslinjene for passord.. Sterke passord må inneholde følgende: åtte tegn, én stor og én liten bokstav, tre tall og ett spesialtegn (!, @, #, $, %, ^, &, *, ?, _, ~) eller ett tall og to spesialtegn.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Kan ikke oppdatere produktlisensen.',


    'filemanager__error_path_is_not_allowed' => 'Banen er ikke tillatt',
    'filemanager__error_path_is_invalid' => 'Banen er ugyldig',
    'filemanager__error_path_not_found' => 'Finner ikke banen.',
    'filemanager__error_path_already_exists' => 'Banen finnes allerede',
    'filemanager__error_access_is_denied' => 'Tilgang nektet',
    'filemanager__error_directory_not_empty' => 'Mappen er ikke tom',
    'filemanager__error_sharing_violation' => 'Brudd på delingstillatelser.',
    'filemanager__error_not_same_device' => 'Målbanen er ikke på den samme enheten',
    'filemanager__binary_data_access' => 'Denne filen kan være en binærfil. Ønsker du å åpne den?',
    'filemanager__unable_to_resolve_realpath' => "Kan ikke finne filen %1 på den angitte plassen",
    'filemanager__access_to_realpath_denied' => "Tilgang til fast filbane ble avslått: %1 til %2.",
    'bt_exit' => 'Avslutt',

    'filemanager__chdir_error__' => "Kan ikke endre mappe til %1: %2",
    'filemanager__chmod_dir' => "Endre tilganger for mappe %1",
    'filemanager__chmod_error__' => "Kan ikke endre tilgangene for filen %1: %2",
    'filemanager__chmod_file' => "Endre tilganger for filen %1",
    'filemanager__copy_error__' => "Kan ikke kopiere %1 til %2: %3",
    'filemanager__copy_move' => "Kopier (flytt) filer fra %1",
    'filemanager__count_size__' => 'Utvalgsstørrelse: %1',
    'filemanager__count_size_error__' => 'Kan ikke beregne størrelsen for %1: %2',
    'filemanager__create_dir' => "Mappeoppretting",
    'filemanager__create_dir_error__' => "Kan ikke opprette mappe %1: %2",
    'filemanager__dir_not_exists' => "Mappe %1 finnes ikke.",
    'filemanager__dirname' => "Mappenavn",
    'filemanager__filename' => "Filnavn",
    'filemanager__is_no_such' => "Det finnes ingen fil eller mappe med navnet %1",
    'filemanager__empty_selection' => "Ingen fil(er) er valgt.",
    'filemanager__file_exists' => "Filen %1 finnes allerede.",
    'filemanager__move_error__' => "Kan ikke flytte %1 til %2: %3",
    'filemanager__new_dir' => "Mappenavn",
    'filemanager__not_allowed' => "Du har ikke lov til å endre tilganger for denne filen.",
    'filemanager__r_perm_dir' => "List mappe",
    'filemanager__r_perm_file' => "Lese data",
    'filemanager__remove' => "Fjern filer fra %1",
    'filemanager__remove_error__' => "Kan ikke fjerne filen %1: %2",
    'filemanager__rename_dir' => "Gi mappe %1 nytt navn",
    'filemanager__rename_error__' => "Kan ikke døpe om %1 til %2: %3",
    'filemanager__rename_file' => "Gi nytt navn til fil %1",
    'filemanager__set_win_permissions_dir' => "Sett opp tilganger for mappen %1",
    'filemanager__set_win_permissions_file' => "Sett opp tilganger for filen %1",
    'filemanager__touch_confirm' => "Er du sikker på at du vil endre tidsstempelet for valgte filer?",
    'filemanager__upload_error__' => "Kan ikke laste opp %1 til %2: %3",
    'filemanager__upload_file' => "Last opp fil",
    'filemanager__upload_file_src' => "Banen til filen",
    'filemanager__username' => "Bruker",
    'filemanager__w_perm_dir' => "Opprett filer",
    'filemanager__w_perm_file' => "Skrive data",
    'filemanager__x_perm_dir' => "Traversering av mappe",
    'filemanager__x_perm_file' => "Kjør filen",
    'filemanager__max_image_size_exceeded' => 'Kan ikke vise frem bildet. Bildestørrelsen kan ikke være større enn %2 bytes',

    '__fastcgi_unix_support' => 'FastCGI-støtte',

    'dns__subdomain_dns_zone_parent' => 'DNS-oppføringer for dette underdomenet lagres i den overordnede DNS-sonen. Du kan endre den overordnede sonen %1 eller opprette en separat sone for underdomenet.',
    'dns__subdomain_dns_zone_parent_link' => 'her',
    'dns__no_dns_zone' => 'Ingen DNS-sone tilknyttet domenet. For å administrere DNS-sonen for domenet ditt, trykk på knappen \'Gjenopprett standardinnstillinger\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Kunne ikke slå på sone for underdomene fordi det finnes en CNAME-oppføring for dette underdomenet i sonen til det overordnede domenet.',

    '__hosting_write_modify' => 'Ekstra skrive/modifiseringstillatelser',

    'aspdotnet__group_framework_version' => "Framework-versjon",
    'aspdotnet__param_version' => "Versjon",

    'bt_restore_default' => "Angi som standard",
    'b_aspdotnet' => 'Endre konfigurasjonsinnstillinger for ASP.NET',
    'b_aspdotnet__restore_default' => 'Gjenopprett standard ASP.NET-innstillinger.',
    'b_aspdotnet__restore_wdir_default' => "Gjenopprett den overordnede mappens ASP.NET-innstillinger for denne virtuelle mappen.",
    'b_aspdotnet__restore_default_disabled' => 'Gjenoppretting av standard ASP.NET-konfigurasjon er ikke tilgjengelig: ASP.NET-konfigurasjonen er skadet enten på serveren eller på overordnet mappenivå.',
    'b_autoinstaller' => 'Oppdater Plesk eller dets komponenter.',
    'b_autoinstaller_configure' => 'Oppdater innstillinger.',
    'b_autoinstaller_install' => 'Installer valgte komponenter.',

    '__iis_app_pool__use_dedicated' => 'Dedikert IIS programutvalg',
    '__iis_app_pool__use_dedicated_addons' => 'Dedikert IIS programutvalg for hvert nettsted',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Aktiver 32-biters applikasjoner',
    '__iis_app_pool__load_user_profile' => 'Last inn brukerprofil',
    'bt_iis_app_pool' => "IIS programutvalg",

    'performance__cpu_usage' => 'Maksimal CPU-bruk (%)',
    'performance__cpu_usage_action' => 'Grensehandling',
    'performance__cpu_usage_interval' => 'Grenseintervall (minutter)',
    'performance__cpu_usage_action_not_supported' => 'Spesifisert handling støttes ikke av webserveren.',

    'performance__idle_timeout_action_not_supported' => 'Spesifisert handling ved tidsavbrudd for inaktivitet støttes ikke av webserveren.',
    'performance__max_worker_processes' => 'Maksimalt antall arbeidsprosesser',
    'performance__idle_timeout' => 'Tidsavbrudd for inaktivitet (minutter)',
    'performance__idle_timeout_action' => 'Handling ved tidsavbrudd for inaktivitet',
    'performance__recycling_by_time' => 'Resirkulering ved regelmessige tidsintervaller (minutter)',
    'performance__recycling_by_requests' => 'Resirkulering når maksimalt antall forespørsler er nådd',
    'performance__recycling_by_virtual_memory' => 'Resirkulering når maksimal mengde virtuelt minne er brukt',
    'performance__recycling_by_private_memory' => 'Resirkulering når maksimal mengde privat minne er brukt',
    'performance__managed_pipeline_mode' => 'Behandlet pipeline-modus',
    'performance__managed_pipeline_mode_not_supported' => 'Spesifisert modus støttes ikke av webserveren.',

    'iis_app_pool' => 'Administrasjon av IIS applikasjonsutvalg',
    'b_iis_app_pool' => 'Administrer IIS programutvalg.',
    'iis_app_pool_cl_dom' => 'Administrasjon av IIS applikasjonsutvalg',

    'i_webdirs_not_protected' => 'Mappen er ikke beskyttet.',
    'i_webdirs_protected' => 'Mappen er beskyttet.',
    'i_webdirs_manage_protection' => 'Administrere beskyttelse',
    'i_webdirs_open' => 'Åpne mappen i nettleseren.',
    'i_webdirs_preferences_disabled' => 'Mappen er ikke en virtuell mappe.',
    'i_webdirs_permissions' => 'Behandle tillatelser.',
    'i_webdirs_permissions_disabled' => 'Tillatelsesbehandling for mapper er ikke tilgjengelig.',
    'i_webdirs_type_dir' => 'Fysisk mapper',
    'i_webdirs_type_vdir' => 'Virtuell mappe',
    'i_webdirs_browse' => 'Bla gjennom innholdet i mappen.',
    'i_webdirs_preferences' => 'Administrasjon av innstillinger for webmappe.',

    'l_webdirslist_type' => 'Sorter mapper etter type.',
    'l_webdirslist_protected' => 'Sorter mapper etter beskyttelsesstatus.',
    'l_webdirslist_name' => 'Sorter mapper etter navn.',

    'b_webdirslist_remove' => 'Slett valgte virtuelle kataloger.',
    'b_webdirslist_search' => 'Skriv inn søkemønster, og klikk for å finne virtuelle kataloger.',
    'b_webdirslist_show_all' => 'Vis alle kataloger.',

    'l_webdirerrordocslist_code' => 'Sorter feildokumenter etter feilkodenummer.',
    'l_webdirerrordocslist_name' => 'Sorter feildokumenter etter feilbeskrivelse.',
    'l_webdirerrordocslist_type' => 'Sorter feildokumenter etter feildokumentets type.',
    'l_webdirerrordocslist_location' => 'Sorter feildokumenter etter feildokumentets lokasjon.',

    'b_webdirerrordocslist_search' => 'Skriv inn et søkebegrep og klikk for å finne feildokumenter.',
    'b_webdirerrordocslist_remove' => 'Slett valgte feildokumenter.',
    'b_webdirerrordocslist_show_all' => 'Vis alle feildokumentene.',

    'l_webdirmimetypeslist_name' => 'Sortering MIME-typer etter filtype.',
    'l_webdirmimetypeslist_content' => 'Sortering MIME-typer etter innhold.',

    'b_webdirmimetypeslist_remove' => 'Slett valgte MIME typer.',
    'b_webdirmimetypeslist_search' => 'Skriv inn et søkebegrep og klikk for å finne MIME typer.',
    'b_webdirmimetypeslist_show_all' => 'Vise alle MIME typer.',

    'b_webdir_preferences' => "Innstillinger for virtuelle mapper.",
    'b_webdir_permissions' => "Tillatelser for virtuelle mapper.",
    'b_webdir_permissions_disabled' => "Tillatelsesbehandling for mapper er ikke tilgjengelig.",
    'b_to_webdirs' => 'Gå tilbake til behandling av katalogene.',
    'b_to_webdir_mime_types' => 'Returner til behandling av MIME-typer.',
    'b_to_webdir_error_docs' => 'Gå tilbake til behandling av feildokumentasjon.',
    'b_to_webdir_protection' => 'Gå tilbake til behandling av beskyttelse av virtuelle mapper.',

    'webdirs__title' => 'Virtuell mappe %1',
    'webdirs__preferences_title' => 'Innstillinger for virtuelle mapper.',
    'webdirs__list_legend' => 'Virtuelle kataloger',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'W',
    'webdirs__list_name' => 'Navn',
    'webdirs__list_header' => '%1 elementer',
    'webdirs__tabs_general' => 'Generelt',
    'webdirs__tabs_mime_types' => 'MIME-typer',
    'webdirs__tabs_error_docs' => 'Feildokumenter',

    'webdirs__tabs_permissions' => 'Tillatelser',
    'webdir__remove_vdirs' => 'Følgende virtuelle mapper vil bli slettet:',
    'webdir__remove_mime_types' => 'Følgende MIME-typer vil bli slettet:',
    'webdir__mime_types_title' => 'MIME-typer',
    'webdir__protection_disable_confirm' => 'Vil du virkelig fjerne beskyttelsen fra mappen?',
    'webdir__protect_title' => 'Beskyttede URL brukere',
    'webdirs__permissions_title' => 'Tillatelser for virtuell mappe',
    'webdirs__browse_content_permission_denied' => 'Du har ikke tillatelse til å lese innholdet i denne mappen.',
    'error_doc__list_code' => 'Feil',
    'error_doc__list_code_description' => 'Beskrivelse',
    'error_doc__list_type' => 'Type',
    'error_doc__list_location' => 'Plassering',
    'error_doc__code' => 'Feil',
    'error_doc__type' => 'Type',
    'error_doc__type_file' => 'Fil',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Plassering',
    'error_doc__legend' => 'Feildokument',
    'error_doc__edit_title' => 'Redigeringsfeil dokument',
    'error_doc_erorr_invalid_url_location' => 'Ugyldig URL-adresse. Vennligst angi korrekt URL.',
    'error_doc_erorr_invalid_file_location' => 'Filbanen er ugyldig. Vennligst angi korrekt filbane.',
    'error_doc__type_default' => 'Standard',

    'webdirs__tabs_protection' => 'Beskyttelse',
    'pb_webdirs' => 'Virtuelle mapper',

    'webdirs_remove_title' => 'Følgende virtuelle mapper vil bli fjernet:',
    'webdirs_mime_types_remove_title' => 'Følgende MIME typer blir fjernet:',
    'webdirs_preferences_title' => 'Innstillinger for virtuelle mapper.',
    'webdirs_permissions_title' => 'Spesialtillatelser for filer og mapper',
    'webdi_protection_disable_confirm' => 'Er du sikker du vil fjerne beskyttelse fra den virtuelle mappen? Dette vil også fjerne alle brukere av den beskyttede mappen og mappens beskyttelsesinnstillinger.',
    'bt_protect' => 'Beskytt',
    'bt_unprotect' => 'Fjern beskyttelse',
    'bt_show_additional_users' => 'Vis flere brukere',
    'bt_hide_additional_users' => 'Vis færre brukere',
    'error_doc__list_title' => 'Feildokumenter',
    'error_doc__list_header' => 'Feildokumenter',
    'error_doc__code_400' => 'Ugyldig forespørsel',
    'error_doc__code_401' => 'Uautorisert',
    'error_doc__code_401.1' => 'Uautorisert - innlogging gikk feil',
    'error_doc__code_401.2' => 'Uautorisert - pålogging feilet på grunn av serverkonfigurasjonen.',
    'error_doc__code_401.3' => 'Uautorisert - uautorisert på grunn av ACL på ressurs',
    'error_doc__code_401.4' => 'Uautorisert: Godkjenning mislyktes i filteret',
    'error_doc__code_401.5' => 'Uautorisert: Godkjenning mislyktes i ISAPI/CGI-app',
    'error_doc__code_401.7' => 'Uautorisert - nektet på grunn av URL autoriseringspolicy',
    'error_doc__code_403' => 'Forbudt',
    'error_doc__code_403.1' => 'Forbudt - Kjøringstilgang avslått',
    'error_doc__code_403.2' => 'Forbudt - Lesetilgang nektet',
    'error_doc__code_403.3' => 'Forbudt - Skrivetilgang nektet',
    'error_doc__code_403.4' => 'Forbudt - SSL kreves',
    'error_doc__code_403.5' => 'Forbudt - SSL 128 kreves',
    'error_doc__code_403.6' => 'Forbudt - IP adresse avvist',
    'error_doc__code_403.7' => 'Forbudt - Klientsertifikat påkrevd',
    'error_doc__code_403.8' => 'Forbudt - Områdetilgang nektet',
    'error_doc__code_403.9' => 'Forbudt - for mange brukere',
    'error_doc__code_403.10' => 'Forbudt - ugyldig konfigurasjon',
    'error_doc__code_403.11' => 'Forbudt - Passordendring',
    'error_doc__code_403.12' => 'Forbudt - Katalog nektet tilgang',
    'error_doc__code_403.13' => 'Forbudt - Klientsertifikat trukket tilbake',
    'error_doc__code_403.14' => 'Forbudt - Mappevisning avslått.',
    'error_doc__code_403.15' => 'Forbudt - Lisenser for klienttilgang overskredet',
    'error_doc__code_403.16' => 'Forbudt - Klientsertifikat ikke klarert eller misformet',
    'error_doc__code_403.17' => 'Ingen tilgang - Klientsertifikatet er utløpt eller er ennå ikke gyldig',
    'error_doc__code_403.18' => 'Forbudt - Kan ikke utføre forespørsel fra dette programutvalget',
    'error_doc__code_403.19' => 'Forbudt - CGI-tilgang nektet.',
    'error_doc__code_403.20' => 'Forbudt - passinnloggong gikk feil',
    'error_doc__code_404' => 'Finner ikke',
    'error_doc__code_404.2' => 'Ikke funnet - avvist på grunn av låsingspolicy',
    'error_doc__code_404.3' => 'Ikke funnet - avvist på grunn av MIMEMAP policy',
    'error_doc__code_405' => 'Metode ikke tillatt',
    'error_doc__code_406' => 'Ikke godtatt',
    'error_doc__code_407' => 'Proxy-godkjenning kreves',
    'error_doc__code_412' => 'Forhåndsbetingelse mislyktes',
    'error_doc__code_414' => 'Forespørsels-URIen er for lang',
    'error_doc__code_415' => 'Medietype støttes ikke',
    'error_doc__code_500' => 'Intern serverfeil',
    'error_doc__code_500.12' => 'Intern serverfeil - Programmet restarter',
    'error_doc__code_500.13' => 'Intern serverfeil - Server for opptatt',
    'error_doc__code_500.15' => 'Intern serverfeil - Direkte forespørsler til GLOBAL.ASA forbudt',
    'error_doc__code_500.16' => 'Intern serverfeil - UNC tilgangsfeil',
    'error_doc__code_500.17' => 'Intern serverfeil - Godkjenningslager for URL-adresser ikke funnet',
    'error_doc__code_500.18' => 'Intern serverfeil - Autorisasjonslager for url-adresse kan ikke åpnes',
    'error_doc__code_500.19' => 'Intern serverfeil - Ugyldig fil-metadata',
    'error_doc__code_500.100' => 'Intern serverfeil - ASP-feil',
    'error_doc__code_501' => 'Ikke implementert',
    'error_doc__code_502' => 'Ugyldig gateway',
    'error_doc__code_503' => 'Tjenesten er midlertidig utilgjengelig',

    'mimetype__extension' => 'Filtype',
    'mimetype__content' => 'Innhold',
    'mimetypeslist__title' => 'MIME-typer',
    'mimetypes__title' => 'MIME-typer',
    'mimetypes__select_to_remove' => 'Velg Mime-typene du vil fjerne.',
    'mimetypes__select_for_remove' => "Velg Mime-typer som skal fjernes.",
    'mimetypes_remove__title' => 'Fjern MIME type',
    'mimetype__legend' => 'MIME-type',
    'mimetype_edit__title' => 'Rediger MIME-type',
    'mimetype_edit__already_exists' => 'MIME typen er allerede definert for denne filtypen',
    'mimetype_edit__not_exists' => 'MIME typen eksisterer ikke.',
    'mimetype__content_type_other' => 'Egendefinert...',

    'b_webdir_protection_enable' => 'Opprett en URL-adresse som samsvarer med den passordbeskyttede mappen.',
    'b_webdir_protection_disable' => 'Opprett en URL-adresse som samsvarer med mappen som er tilgjengelig for alle.',
    'b_webdir_protection_disabled' => 'Beskyttelse av den virtuelle mappen er deaktivert',

    'b_pd_usr_create' => 'Klikk for å skape denne beskyttede URL brukeren.',
    'php__changeversion_title' => "Velg PHP-versjon",
    'php__group_php_version' => "PHP-versjon",

    'virtualdir__name' => 'Navn',
    'virtualdir__path' => 'Bane',
    'virtualdir__read' => 'Lesetillatelse',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Skrive-tilgang',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Tilgang til skriptkilde',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Mappevisning',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Kjøringstillatelser',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Logge besøk',
    'virtualdir__app_create' => 'Opprett program',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Slår på anonym autentisering.',
    'virtualdir__auth_windows' => 'Slår på Windows-autentisering.',
    'virtualdir__auth_not_enabled' => 'Anonym autentisering eller Windows-autentisering må være slått på.',
    'virtualdir__require_ssl' => 'Krever SSL/TLS',
    'virtualdir__enable_default_doc' => 'Bruk standard dokumenter',
    'virtualdir__default_doc' => 'Standard dokument søkesekvens',
    'virtualdir__enable_parent_paths' => 'Tillat å bruke overordnede baner',
    'virtualdir__execute_in_mta' => 'Tillat programutførelse i MTA-modus (flertrådet apartment)',
    'virtualdir_create__title' => 'Opprett virtuell mappe i %1',
    'virtualdir_edit__title' => 'Egenskaper for virtuell mappe %1',
    'virtualdir_edit__legend' => 'Virtuell mappe',
    'virtualdir_edit__application_legend' => 'Programinnstillinger',
    'virtualdir_edit__security_legend' => 'Katalogsikkerhet',
    'virtualdir_edit__documents_legend' => 'Dokumenter',
    'virtualdir_edit__list_legend' => 'Nestete virtuelle mapper',
    'virtualdir_error__path_not_in__' => 'Ugyldig målbane er angitt',
    'virtualdir_error__already_exists' => 'En mappe med dette navnet finnes allerede.',
    'virtualdir_root' => 'Virtuelle kataloger',
    'virtualdir_root__title' => 'Virtuelle kataloger',
    'virtualdir_root__list_legend' => 'Virtuelle kataloger',
    'virtualdir_se__none' => 'Ingen',
    'virtualdir_se__script' => 'Bare skript',
    'virtualdir_se__script_execute' => 'Skript og kjørbare filer',
    'virtualdirs__title' => 'Virtuelle kataloger',
    'virtualdirs__path_not_exists' => 'Ugyldig bane.',
    'virtualdirs__select_for_remove' => "Velg virtuelle mapper som skal fjernes.",
    'virtualdirs_remove__title' => 'Fjern virtuell mappe',
    'virtualdirs_phys_dir_exist' => 'En fysisk mappe med dette navnet finnes allerede. Hvis du vil du fortsette, vil den bli utilgjengelig. Vil du fortsette?',
    'virtualdir_auto_create_dir' => "Opprett en fysisk mappe med samme navn som den virtuelle mappen",

    'asp_max_default_text' => 'Definert av overordnet (%1 KB)',
    'asp_max_default_text_site' => 'Definert av IIS (%1 KB)',
    'asp_max_buffer_text' =>'Maksimal størrelse av ASP bufferet (KB)',
    'asp_max_body_text' => 'Maksimal størrelse av entitetshode av en ASP forespørsel (KB)',
    'asp_buffers_legend' =>'ASP-innstillinger',

    'asp_debug_default_text' =>'Definert av overordnet mappe',
    'asp_debug_default_text_site' =>'Definert av IIS',
    'asp_client_debug_text' =>'Aktiver feilsøking i ASP-skript på klientsiden',
    'asp_server_debug_text' =>'Aktiver feilsøking i ASP-skript på serversiden',

    'webdirs__list_with_broken_dirs' => "Virtuelle mapper er koblet til ikke-eksisterende fysiske mapper.",
    'webdirs__vdir_physical_path_not_exist' => "Den virtuelle mappen er koblet til fysisk mappe som ikke finnes.",
    'webdirs__physical_path_not_exist' => "Den angitte banen finnes ikke.",

    'filemanager__new_dir_title' => 'Opprett mappe',
    'php__configuration_title' => "PHP konfigurasjon",

    'permissions__title' => 'Sett opp tilgangstillatelser',
    'permissions__title_advanced' => 'Sette opp avanserte tilgangstillatelser',
    'permissions__inherit_from_parent' => 'Tillat at arvbare tillatelser videreføres til dette objektet og alle underordnede objekter. Inkluder disse sammen med oppføringene som eksplisitt er definert her.',
    'permissions__replace_on_children' => 'Erstatter tillatelsesoppføringene på alle underordnede objekter med oppføringene som er vist her.',
    'permissions__group_or_user_name' => 'Gruppe- eller brukernavn',
    'permissions__Permissions_for' => 'Tillatelser for',
    'permissions__allow' => 'Tillat',
    'permissions__deny' => 'Nekt',
    'permissions__FullControl' => 'Alle tillatelser',
    'permissions__Modify' => 'Endre',
    'permissions__ReadAndExecute' => 'Lese og kjøre',
    'permissions__ListFolderContents' => 'Vis mappeinnhold',
    'permissions__Read' => 'Les',
    'permissions__Write' => 'Skriv',
    'permissions__ReadControl' => 'Les kontroll',
    'permissions__WriteControl' => 'Skrivekontroll',
    'permissions__ExecuteControl' => 'Kjørekontroll',
    'permissions__TraverseFolderOrExecuteFile' => 'Traverser mappe / Kjør fil',
    'permissions__ListFolderOrRead' => 'Vis mappe / les data',
    'permissions__CreateFilesOrWrite' => 'Opprette filer / Skrive data',
    'permissions__CreateFoldersOrAppend' => 'Opprette mapper / Tilføye data',
    'permissions__DeleteSubfoldersandFiles' => 'Slette undermapper og filer',
    'permissions__Delete' => 'Slett',
    'permissions__ChangePermissions' => 'Endre tillatelser',
    'permissions__TakeOwnership' => 'Bli eier',
    'permissions__inherited_from' => 'Arvet fra',
    'permissions__not_inherited' => '<ikke arvet>',
    'permissions__apply_to' => 'Bruk på',
    'permissions__apply_onto' => 'Bruk på:',
    'permissions__apply_onto1' => 'Bare denne mappen',
    'permissions__apply_onto2' => 'Bare undermapper',
    'permissions__apply_onto3' => 'Denne mappen og undermapper',
    'permissions__apply_onto4' => 'Bare filer',
    'permissions__apply_onto5' => 'Denne mappen og filer',
    'permissions__apply_onto6' => 'Bare undermapper og filer',
    'permissions__apply_onto7' => 'Denne mappen, undermapper og filer',

    'filemanager__not_allowed_dir' => "Du har ikke lov til å endre tilganger for denne mappen.",

    'filemanager__allow' => "Tillat",
    'filemanager__deny' => "Nekt",
    'filemanager__user_domusr' => 'Nettstedsadministrator',
    'filemanager__user_webusr' => 'Webbruker',
    'filemanager__user_admins' => 'Administratorer',
    'filemanager__user_system' => 'SYSTEM',
    'filemanager__user_aspnet' => 'ASP.NET bruker',
    'filemanager__user_poolusr' => 'Bruker av programutvalg',
    'filemanager__user_sysaccount' => 'Ekstra systembruker',

    'bt_permissions_advanced' => 'Avansert',
    'b_permissions_advanced' => 'Klikk for å vise og sette opp spesialtillatelser.',

    'hotlink-protection_invalid_friend_domain' => 'Ugyldige navn for vennlig domene.',
    'hotlink-protection_duplicate_friend_domain' => 'Duplikatnavn for vennlig domene.',
    'hotlink-protection_invalid_extensions' => 'Filtyper inneholder ugyldige tegn.',

    'i_domain_alias_status_on' => 'Domenealias er aktivert.',
    'i_domain_alias_status_off' => 'Domenealias er deaktivert.',
    'i_domain_alias_status_with_parent' => 'Domenealias er deaktivert fordi domenet er slått av.',
    'i_domain_alias_turn_off' => 'Klikk for å deaktivere.',
    'i_domain_alias_turn_on' => 'Klikk for å aktivere.',
    'i_domain_alias_mail_on' => 'Eposttjeneste er aktivert for dette domenealiaset.',
    'i_domain_alias_mail_off' => 'Eposttjeneste er deaktivert for dette domenealiaset.',
    'i_domain_alias_mail_with_parent' => 'Eposttjeneste er deaktivert fordi domenealiaset er slått av.',
    'i_domain_alias_web_on' => 'Webtjeneste er aktivert for dette domenealiaset.',
    'i_domain_alias_web_off' => 'Webtjeneste er deaktivert for dette domenealiaset.',
    'i_domain_alias_web_with_parent' => 'Webtjeneste er deaktivert fordi domenealiaset er slått av.',
    'i_domain_alias_dns_on' => 'Tjenesten DNS-alias er slått på for dette domenealiaset.',
    'i_domain_alias_dns_off' => 'Tjenesten DNS-alias er slått av for dette domenealiaset.',
    'i_domain_alias_dns_with_parent' => 'DNS-synkronisering med det overordnede domenet er deaktivert fordi domenealias er slått av.',
    'i_domain_alias_seoRedirect_on' => 'Omdirigering med HTTP 301-koden er slått på for dette domenealiaset.',
    'i_domain_alias_seoRedirect_off' => 'Omdirigering med HTTP 301-koden er slått av for dette domenealiaset.',
    'i_domain_alias_seoRedirect_with_parent' => 'Omdirigering med HTTP 301-koden er slått av fordi domenealiaset er skrudd av.',

    'domain_alias__control_title' => 'Domenealias %1',
    'domain_alias__control_info_legend' => 'Info',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Tjenestenavn',
    'domain_alias__control_details_title' => 'Detaljer',

    'domain_alias__invalid_values' => 'Domenenavnet du oppga er ugyldig. Domenenavn kan bestå av bokstaver, tall og bindestreker. Hver del av domenenavnet mellom punktene skal ikke være lenger enn 63 tegn.',
    'domain_alias__domain_already_exists' => "Feil navn på domenealias %1. Domenet %1 finnes allerede.",
    'domain_alias__www_prefix_domain_already_exists' => "Feil navn på domenealias www.%1. Dette aliaset er allerede opprettet for domenet %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Feil navn på eposttjeneste for domenealias.%1. Dette aliaset er allerede opprettet for domenet %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Feil navn på listen over domenealias.%1. Dette aliaset er allerede opprettet for domenet %1.',
    'domain_alias__dns_record_already_exists' => 'Kunne ikke sette opp domenealias %1 fordi en DNS-oppføring som peker på verten %1 finnes allerede.',
    'domain_alias__domain_alias_already_exists' => "Et domenealias med dette navnet finnes allerede.",
    'domain_aliases__mail_server_not_support_aliases' => 'E-postserveren støtter ikke funksjonen domenealias. Domenealias vil kanskje ikke fungere riktig.',
    'domain_alias__restrict_domain_creation' => 'Angitt navn for et domenealias er forbudt av serverpolicy. Hvis dette domenealiaset tilhører deg, ta kontakt med hostingleverandøren din.',
    'domain_alias__restrict_creation_with_www' => 'Vennligst angi et domenenavn uten prefiks \'www\'. Prefikset www for domenet vil automatisk legges til konfigurasjon for webserveren.',
    'domain_unable_to_set_name' => 'Feil navn %1.',

    'domain_alias__domain_service_dns_disabled' => 'Dette domenet tjenes av en annen DNS-server.',
    'domain_alias__domain_service_dns_enabled_master' => 'Denne DNS-serveren fungerer som primær navneserver for denne DNS-sonen.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Denne DNS-serveren fungerer som sekundær navneserver for denne DNS-sonen.',
    'domain_alias__domain_service_mail_enabled' => 'Eposttjeneste er slått på for domenet.',
    'domain_alias__domain_service_mail_disabled' => 'Eposttjeneste er slått av for domenet.',
    'domain_alias__domain_service_mail_mx' => '%1 er i bruk som e-postserver.',

    'domain_alias__service_seoRedirect_hint' => 'Når besøkende åpner aliasets URL, vil de bli omdirigert til URL for primærdomenet. Plesk bruker den søkemotorvennlige omdirigeringen HTTP 301, noe som betyr at rangering i søkemotoren ikke vil bli delt mellom URL-adresser.',

    'bt_task_run_now' => 'Kjør nå',
    'ftp__read_perm' => "Lesetillatelse",
    'ftp__write_perm' => "Skrive-tilgang",

    'filemanager__upload_backup_file_hint' => 'Her kan du laste opp sikkerhetskopier til Plesk-lageret. Maksimal filstørrelse er begrenset til to gigabytes.',

    '__default_for_mssql' => 'standard for MS SQL',

    '__login_does_not_pass_validation' => "Brukernavnet er ugyldig. Sørg for at det tilfredsstiller de følgende kravene: %1",
    '__login_allowed_symbols' => 'Bare alfanumeriske tegn inklusive punktum, bindestreker og understrekning er tillatt. Det første tegnet må være alfanumerisk.',

    'restart__nginx' => 'Omvendt proxy-server (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Jeg vil gjerne motta generell produktinformasjon og kunngjøringer fra Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Jeg vil gjerne motta sikkerhetsrelatert informasjon og annen teknisk informasjon fra Plesk.",

    '__login_status_inactive' => 'Din konto er inaktiv. Kontakt Plesk-administrator.',

    'migration__task_keep_in_process' => 'OK',
    'migration__task_keep_in_process_conhelp' => 'Gå tilbake til Verktøy og innstillinger-siden. Overføringen fortsetter i bakgrunnen.',

    'ui__admin-alias-info__description' => "Endre kontaktinformasjonen for den ekstra administratorkontoen.",
    'ui__admin-alias-info__short-title' => "Kontaktinformasjon",
    'ui__admin-alias-info__title' => "Informasjon om ekstra administratorkonto",
    'ui__admin-alias-password__description' => "Endre passordet for den ekstra administratorkontoen.",

    'ui__admin-alias-password__short-title' => "Endre passord",
    'ui__admin-alias-password__title' => "Passord for den ekstra administratorkontoen.",
    'ui__admin-alias__description' => "Vis og endre informasjon om ekstra administratorkontoer.",

    'chk_js__warning_about_login_syntax' => "Du kan bruke små bokstaver alfanumerisk, bindestrek og understrekningstegn i brukernavn. Brukernavnet skal begynne med et alfabetisk tegn. Passordet bør ikke inneholde brukernavnet eller anførselstegn.",
    'chk_js__warning_about_ftp_login_syntax' => "Du kan bruke alfanumeriske tegn, bindestrek og understrekingstegn i brukernavnet.",
    'chk_js__warning_about_login_syntax_win' => "Du kan bruke små alfanumerisk bokstaver, strek, punktum og understrekingstegn i brukernavn. Brukernavnet skal begynne med et alfabetisk tegn eller et tall. Passordet bør ikke inneholde brukernavnet eller anførselstegn.",
    'chk_js__warning_about_passwd_syntax' => "Ikke bruk anførselstegn, mellomrom eller nasjonale alfabetiske tegn i passordet.\nPassordet må være mellom %1 og %2 tegn langt, og må ikke inneholde brukernavnet.",
    'chk_js__warning_about_plesk_login_syntax' => "Du kan bruke små bokstaver alfanumerisk, punktum, bindestrek og understrekningstegn i brukernavn.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Du kan bruke små bokstaver alfanumerisk, bindestrek og understrekningstegn i brukernavn. Brukernavnet skal begynne med et alfabetisk tegn.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Ikke bruk anførselstegn, mellomrom eller nasjonale alfabetiske tegn i passordet.\nPassordet må være mellom %1 og %2 tegn langt, og må ikke inneholde brukernavnet.",
    'chk_js__warning_about_pam_passwd_error' => "Feil systemkonto ble oppgitt: %1",

    'cmd_server__admin_alias_not_found' => "Kan ikke finne den ekstra administratorkontoen.",

    'panel_branding__skins_already_exists' => "Bemerk: Temaet '%1' eksisterer allerede. Det vil bli erstattet med det temaet du nå installerer.",
    'panel_branding__skins_file_exists' => "Kan ikke opprette en katalog for temaet '%1': Det finnes allerede en fil med dette navnet.",

    'actionlog__login_failed' => 'innlogging gikk galt',
    'actionlog__event_cp_user_login_failed' => 'Pålogging av Plesk-bruker feilet',
    'actionlog__api_login_failed' => 'innlogging via API gikk galt',
    'actionlog__event_cp_user_api_login_failed' => 'Pålogging av Plesk-bruker gjennom API feilet',
    'actionlog__pw_reset' => 'ba om tilbakestilling av passord',

    'ch_pass_admin__email_subject' => "Plesk passordpåminnelse",
    'ch_pass_admin__email_body' => "Hei, %1.\n\nAdministratorpassordet kan av sikkerhetsmessige årsaker ikke sendes via e-post.\n\nFor å logge inn som 'admin', kan du bruke kommandoen 'plesk login'.\n\nFor å angi et nytt 'admin' passord, kan du bruke kommandoen 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Kan ikke sende e-posten: %1',

    'ch_pass_by_secret__email_subject' => "Plesk passordpåminnelse",
    'ch_pass_by_secret__email_body' => "Hallo %2,\n\nFor å sette opp et nytt passord, følg lenken: %1\n\nDin innloggning: %3",
    'ch_pass_by_secret__message_send_error' => 'Kan ikke sende den hemmelige koden: %1',
    'ch_pass_by_secret__title' => 'Endre passord',
    'ch_pass_by_secret__secret' => 'Hemmelig kode',

    'custom_button__noframe' => "Ikke bruk rammer",

    'custom_button__internal_hint' => 'Angi om URL-adressen skal åpnes i en Plesk-side eller i et nytt lesevindu.',
    'custom_button__noframe_hint' => 'Hvis du legger til en brukerdefinert knapp som fører til en Plesk-utvidelse eller en app på Kundepanelet, kan du angi hvordan denne utvidelsen/appen skal vises: i en ramme eller som en del av GUI for Plesk.',


    'actionlog__patch' => 'Oppdater',
    'actionlog__patch_available' => 'ledig',
    'actionlog__event_patch_available' => 'Oppdatering er tilgjengelig',
    'actionlog__patch_installed' => 'installert',
    'actionlog__event_patch_installed' => 'oppdatering installert',

    'actionlog__extension' => 'Filtype',
    'actionlog__extension_status' => 'Status for utvidelsen',
    'actionlog__cloning' => 'Kloning av server',
    'actionlog__cloning_complete' => 'Fullført',
    'actionlog__event_cloning_complete' => 'Kloning av server er fullført',

    'actionlog__ssl_web_binding' => 'SSL/TLS sertifikat -sertifikat på domenet',
    'actionlog__ssl_web_binding_update' => 'er tilordnet / er ikke tilordnet',
    'actionlog__event_ssl_web_binding_update' => 'SSL/TLS sertifikat på domenet er tilordnet / er ikke tilordnet',

    'actionlog__ssl_web_mail_binding' => 'SSL/TLS-sertifikat på nettbasert e-post',
    'actionlog__ssl_web_mail_binding_update' => 'er tilordnet / er ikke tilordnet',
    'actionlog__event_ssl_web_mail_binding_update' => 'SSL/TLS sertifikat på nettbasert e-post server er tilordnet / er ikke tilordnet',

    'actionlog__ssl_mail_binding' => 'SSL/TLS-sertifikat på e-post server',
    'actionlog__ssl_mail_binding_update' => 'er tilordnet / er ikke tilordnet',
    'actionlog__event_ssl_mail_binding_update' => 'SSL/TLS-sertifikat på e-post server er tilordnet / er ikke tilordnet',

    'actionlog__ssl_panel_binding' => 'SSL/TLS-sertifikat på Plesk',
    'actionlog__ssl_panel_binding_update' => 'er tilordnet / er ikke tilordnet',
    'actionlog__event_ssl_panel_binding_update' => 'SSL/TLS-sertifikat på Plesk er tilordnet / er ikke tilordnet',

    'actionlog__hostname' => 'Serverens vertsnavn',
    'actionlog__hostname_changed' => 'endret',

    'actionlog__smb_user' => 'Ekstra bruker',
    'actionlog__smb_user_create' => 'Ekstra bruker opprettet',
    'actionlog__smb_user_delete' => 'Ekstra bruker slettet',
    'actionlog__smb_user_update' => 'Ekstra bruker oppdatert',

    'actionlog__event_mail_management_status_update' => 'Statusoppdatering for e-postadministrasjon',
    'actionlog__mail_management' => 'Status for e-postadminsitrasjon',
    'actionlog__mail_management_status_update' => 'oppdaterte',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Sum etter domener',

    'chk_js__warning_about_admin_passwd_syntax' => "Ikke bruk anførselstegn, mellomrom, semikolon eller nasjonale alfabetiske tegn i passordet.\nPassord bør være mellom %1 og %2 tegn, og bør ikke inneholde brukernavnet.",

    'passwordSecurityLevelCheckFailed' => 'Passordet er ikke sammensatt nok. I henhold til serverpolicyen, må passordstyrken være minst %1. For å forbedre passordstyrken, bruk tall, store og små bokstaver, og spesialtegn som !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Veldig svak',
    'passwordSecurityLevelCheckFailedWeak' => 'Svak',
    'passwordSecurityLevelCheckFailedMediocre' => 'Middels',
    'passwordSecurityLevelCheckFailedStrong' => 'Sterkt',
    'passwordSecurityLevelCheckFailedStronger' => 'Veldig sterk',

    'filemanager__invalid_path' => "Ugyldig målbane er angitt",

    'ui__client/domain/dns/sync__description' => 'Bruk endringer fra global DNS-mal for sonen.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Kan ikke bruke endringene i DNS-mal for sonen fordi sonen betjenes av en annen DNS-server.',
    'ui__client/domain/dns/sync__short-title' => 'Aktiver endringer i DNS mal',
    'ui__client/domain/dns/sync__done' => 'Endringene fra DNS malen ble vellykket tatt i bruk på sonen.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Bruk endringer fra global DNS-mal for sonen.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Kan ikke bruke endringene i DNS-mal for sonen fordi sonen betjenes av en annen DNS-server.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Aktiver endringer i DNS mal',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Endringene fra DNS malen ble vellykket tatt i bruk på sonen.',
    'dns__dns_default_ipv4_modified' => 'Oppføringer med denne IP-adressen vil bli ansett som modifisert av brukeren, og vil ikke synkroniseres med den globale DNS-malen.',
    'dns__dns_default_ipv6_modified' => 'Oppføringer med denne IP-adressen vil bli ansett som modifisert av brukeren, og vil ikke synkroniseres med den globale DNS-malen.',

    'dns__view_dns_record_master_title' => 'Viser ressurs oppføringer',
    'dns__view_dns_record_off_title' => 'Viser navneserver oppføringer',
    'dns__view_dns_record_slave_title' => 'Viser oppføringer for primær DNS-server',

    'dns_unable_to_resolve_hostname' => "Kan ikke løse vertsnavnet \"%1\": %2\nPass på at operativsystemets løsningsprogram for DNS er satt opp og fungerer riktig.",

    'no_database_server_available' => 'Det er ingen tilgjengelige databaseservere for dette abonnementet.',

    'database_used_by_application_can_not_be_moved' => 'Kunne ikke flytte databasen: Et program på nettstedet bruker denne databasen.',
    'database_user_update_orphaned_is_restricted' => 'Oppdatering av frittstående database brukerkontroer er forbudt. Du kan bare slette eller reparere dem.',

    'database_unable_to_get_max_filesize_default_message' => 'Kunne ikke bestemme maksimal filstørrelse på databasen: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Kunne ikke sette maksimal filstørrelse på databasen: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Kunne ikke bestemme maksimal størrelse på loggfil på databasen: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Kunne ikke sette maksimal størrelse på loggfil på databasen: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Kunne ikke finne gjeldende grense for størrelse på fil på Microsoft SQL-databasen \'%1\'. Det er ikke mulig å sette en ny grense.',
    'database_unable_to_set_max_filesize' => 'Kunne ikke sette grense for størrelse på loggfil på Microsoft SQL-databasen \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Kunne ikke finne gjeldende grense for størrelse på loggfil på Microsoft SQL-databasen \'%1\'. Det er ikke mulig å sette en ny grense.',
    'database_unable_to_set_max_log_filesize' => 'Kunne ikke sette grense for størrelse på loggfil på Microsoft SQL-databasen \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Kunne ikke opprette Microsoft SQL-database \'%1\': Filstørrelsen er større enn den maksimalt tillatte størrelsen.',
    'database_unable_to_move_because_max_filesize' => 'Kunne ikke flytte Microsoft SQL-databasen \'%1\': Filstørrelsen er større enn den maksimalt tillatte størrelsen: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Kunne ikke opprette Microsoft SQL-database \'%1\': Loggfilen er større enn maksimalt tillatt størrelse.',
    'database_unable_to_move_because_max_log_filesize' => 'Kunne ikke flytte Microsoft SQL-databasen \'%1\': Loggfilen er større enn maksimalt tillatt størrelse: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Kunne ikke gjenopprette Microsoft SQL-databasen \'%1\': Filstørrelsen er større enn den maksimalt tillatte størrelsen.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'En identisk MS SQL-server er allerede registrert i Plesk. Vennligst oppgi en annen MS SQL-server som sandkasseserver.',
    'database_server__mssql_server_registered_as_sandbox' => 'En identisk MS SQL sandkasseserver er allerede registrert i Plesk. Vennligst oppgi en annen MS SQL-server som sandkasseserver.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Kan ikke koble til serveren via \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Funksjonen %1 støttes ikke av følgende servicenoder: %2. Denne funksjonen vil bli deaktivert for alle objekter som opprettes på disse nodene.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Funksjonen %1 er ikke støttet på denne serveren. Denne egenskapen vil deaktiveres for alle gjenopprettede objekter',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Komponenten %1 er ikke installert. Den vil ikke være tilgjengelig for følgende nettsteder: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Komponenten %1 er ikke installert. Det vil bli erstattet med %2 for følgende nettsteder: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Gjeldende versjon av Plesk støtter ikke brukernavn med punktum (.) tegn. Kunder og forhandlere med disse brukernavnene vil ikke bli gjenopprettet.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Kan ikke finne en sikkerhetskopi fil med data for %1 %2. Data for %1 %2 kommer ikke til å bli gjenopprettet.',

    'bu_conflict_resolver_zone_master_removed' => "Kan ikke gjenopprette den primære DNS-oppføringen: Oppføringen i sekundærsonen peker til den eksisterende IP-adressen %1. Den primære DNS-oppføringen blir fjernet fra sekundærsonen.",

    'bu_conflict_resolver_not_available_scripting' => '%1 understøttes ikke.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 understøttes ikke. Den vil ikke være tilgjengelig for følgende nettsteder: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Komponenten %1 er ikke installert.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Den vil ikke være tilgjengelig for følgende tjenestenoder: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Det vil ikke være tilgjengelig for følgende objekter: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'De følgende databaseserverne er ikke tilgjengelige på denne serveren: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Sikkerhetskopi av MS SQL-database lagres i det opprinnelige formatet til MS SQL, som bare kan gjenopprettes til den lokale MS SQL-serveren eller til den eksterne MS SQL-serveren med fullstendig konfigurerte innstillinger for sikkerhetskopiering. Noen av databasene diine ble ikke gjenopprettet fordi det ikke finnes en passende MS SQL-server registrert i Plesk. Følgende domener berøres: {{objects}}. Vennligst ta kontakt med hostingleverandøren din.',

    'bu_conflict_resolver_not_available_webmail' => 'Eposttjenesten %1 er ikke tilgjengelig. Den vil erstattes med %2 for de følgende objektene: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Eposttjenesten %1 er ikke tilgjengelig. Den vil bli erstattet med %2 for følgende tjenesteplaner: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Databaser av type '%1' støtter ikke brukernavn som sammenfaller med databasenavn. Bruker '%2' vil bli gitt nytt navn '%3' for databasen '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Begrensning av bruk av diskplass er ikke angitt i målserver-konfigurasjonen. Verdien av denne innstillingen vil bli endret til «Ubegrenset».',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Begrensningen av antall tilkoblinger er ikke angitt i målserver-konfigurasjonen. Verdien av denne innstillingen vil bli endret til «Ubegrenset».',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Begrensningen for trafikkforbruk er ikke angitt i målserver-konfigurasjonen. Verdien av denne innstillingen vil bli endret til «Ubegrenset».',
    'cu__pleskrestore_backup_file_extracted' => 'Sikkerhetskopi filen ble ekstrahert til "%1".',
    '__mod_bw_not_supported' => 'Modulen mod_bw for Apache Webserver er ikke støttet på grunn av konfigurasjonen av filsystemet. Begrensningene i trafikkbruk og maksimalt antall forbindelser vil ikke fungere.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'POP3-godkjenning for relesending av e-post er ikke støttet, POP3 før SMTP-godkjenning vil benyttes i stedet. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Tjenesteplan \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 understøttes ikke. Den vil bli erstattet med %2 for følgende tjenesteplaner: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 understøttes ikke. Det vil bli erstattet med %2 for følgende nettsteder: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Følgende objekter ble ikke funnet i sikkerhetskopifilen: %1',
    'bu_conflict_resolver_absent_domains' => 'Noen objekter kan ikke gjenopprettes fordi de tilhører følgende domener som ikke finnes i Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Noen nettsteder kan ikke gjenopprettes fordi de tilhører følgende overordnede domener som ikke finnes i Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Kunne ikke gjenopprette DNS-soner: DNS-tjenesten er slått av i serverkonfigurasjonen.',
    'bu_conflict_resolver_mail_not_supported' => 'Kunne ikke gjenopprette postbokser: Posttjenesten er slått av i serverkonfigurasjonen.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Handling ved angitt CPU-grense støttes ikke av IIS webserver. Verdien vil bli tilbakestilt til %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'server SSL/TLS-sertifikat %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'SSL/TLS-sertifikat %2 for domenet %1',
    'bu_conflict_detector_ssl_cert_name' => 'SSL/TLS-sertifikat %1',
    'bu_conflict_resolver_absent_objects' => 'Innholdet av følgende objekter kan ikke gjenopprettes fordi objektene ikke finnes i Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Innholdet av følgende postbokser kan ikke gjenopprettes fordi postboksene ikke finnes i Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Innholdet av følgende adresselister kan ikke gjenopprettes fordi adresselistene ikke finnes i Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Innholdet av følgende databaser kan ikke gjenopprettes fordi databasene ikke finnes i Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Gjenoppretting av applikasjon "%1" på "%2" mislyktes fordi en annen applikasjon allerede er installert til "%3". Du kan fjerne den installerte applikasjonen og prøve på nytt.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Automatisk svarfunksjon på e-post støttes ikke.',
    'bu_conflict_resolver_not_available_mail_content' => 'Gjenoppretting av e-postinnhold støttes ikke.',
    'bu_conflict_resolver_invalid_mail_name' => 'Følgende postbokser ble ikke gjenopprettet fordi e-post-subadressering er aktivert og enkelte e-postadresser inneholder tegnet "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Følgende brukere ble ikke gjenopprettet fordi e-post-subadressering er aktivert og enkelte e-postadresser inneholder tegnet "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Følgende lisenser er utløpt og kan ikke gjenopprettes: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Følgende lisenser er utløpt eller ugyldige og kan ikke gjenopprettes: {{objects}}',
    'expiration_unsupported' => "Begrensningen 'expiration' er ikke understøttet.",

    'component_name__dbconnector' => "Databasetilkobling",
    'component_name__mysqlserver' => 'MySQL server',
    'component_name__troubleshooting' => 'Feilsøking',
    'component_name__savi' => 'Sophos Anti-Virus grensesnitt',

    '__subscription_has_no_license_key' => 'Abonnementsressurser leveres av tjenestenode #%1 som ikke har en tilknyttet lisensnøkkel.',
    '__subscription_has_expired_license_key' => 'Abonnementsressurser leveres av tjenestenode #%1 hvis lisensnøkkel %2 har utløpt.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%> Kunne ikke lagre konfigurasjonsfiler',
    '__cfgmonConfigurationFileSaveErrorBody' => "Kunne ikke lagre enkelte konfigurasjonsfiler på verten <%%host%%>: Følgende feil oppstod:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Dette alternativet aktiverer muligheten til å konfigurere VERP-adresser for e-postlister',
    'mail__enter_right_ip_mask' => "Skriv inn IP masken mellom 1 og 32",
    'mail__enter_right_ip_mask_24' => "Skriv inn IP masken mellom 24 og 32",
    'mail__invalid_dom_name' => "Domenenavnet %1 er ugyldig.",
    'mail__invalid_pop_lock_time' => "POP3 låsningstid er ugyldig.",
    'mail__invalid_rbl_server' => "Navn på DNS-sone er ugyldig.",
    'mail__total_files_size' => "Total lagerstørrelse: %1",
    'mail__filename_already_in_repository' => "En fil med det samme navnet er allerede i repositoriet",
    'mail__no_white_list_mask_feature_24' => "Bruk en maskeverdi på 24 eller høyere.\nDin e-postserver støtter ikke innstillingsmasker. Vi kan bare emulere innstillingsmaske for verdier ikke mindre enn 24.",
    'mail__unable_add_new_mail_name' => "Kan ikke legge til e-postkontoen: %1",
    'mail_server_is_not_installed' => 'E-postserveren (Postfix eller Qmail) er ikke installert. Vennligst installer den for å fortsette med arbeidet.',
    'mail_server_not_available' => 'Det finnes ingen støttede epostservere tilgjengelige på tjenestenoden.',
    '__not_installed' => '(ikke installert)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Spamfiltrering for utgående e-postmeldinger er deaktivert.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Tjenestenoden støtter ikke begrensing av antall utgående e-postmeldinger fra et domene for domenet %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Tjenestenoden støtter ikke begrensing av antall utgående e-postmeldinger fra en postboks for domenet %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Spesifiser en adresse av minst én type (IPv4 eller IPv6).',

    'mail__outgoing_email_mode_invalid' => 'En ugyldig utgående e-postmodus ble spesifisert.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'En ugyldig IPv4-adresse ble spesifisert.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'En ugyldig IPv6-adresse ble spesifisert.',
    'mail__outgoing_email_mode_unavailable' => 'Endring av modus for utgående e-post er ikke støttet, muligens fordi Postfix e-postserveren ikke er installert på denne serveren.',

    'mail__autoresponder_attachment_not_supported' => 'E-postserveren som for tiden er i bruk støtter ikke administrasjon av vedlegg for autosvar.',

    'mail__smtp_white_list_not_supported' => 'E-posten som brukes for øyeblikket støtter ikke hvitelisting av IP-adresser.',
    'mail__smtp_whitelist_cidr_not_supported' => 'CIDR-masker støttes ikke av den nåværende valgte e-postserveren. Spesifiser IP-adressen i formatet «192.*.0.*».',
    'mail__smtp_whitelist_mask_not_supported' => 'Jokertegn-IP-mønstre støttes ikke av den nåværende valgte e-postserveren. Spesifiser IP-adressen i formatet «192.0.0.0/8».',

    'sfdk_server_wide_verify_failed' => 'Kunne ikke endre innstillinger for DKIM verifiseringstjeneste',

    'sfdk_domain__serverwide_disabled' => 'Slått av i henhold til server-policyen.',
    'feature__domainkeys__serverwide_disabled' => 'Global DKIM spambeskyttelse er slått av',

    'defaultcomponents__error_set_default' => 'Kan ikke sette %1 som standard %2: %3',
    'defaultcomponents__error_set_default_none' => 'Kan ikke angi ingen standardkomponent for %1: %2',
    'defaultcomponents__required_package_not_default' => 'Komponenten %1 som kreves for dens arbeide er ikke standardverdi.',

    '__percentage' => '%',
    '__seconds' => 'sekunder',
    '__resource_remain' => 'Gjenstående',

    '__not_registered' => '(ikke registrert)',
    '__php_handler_id' => 'PHP-versjon',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'PHP-behandler "%1" er ikke registrert. Det ble trolig slettet fra serveren. Registrer et behandlingsprogram med de samme egenskapene og forsøk igjen.',
    '__php_handler_not_registered_on_domain' => 'Domenet "%1": PHP-behandler "%2" er ikke registrert. Det ble trolig slettet fra serveren. Registrer et behandlingsprogram med de samme egenskapene og forsøk igjen.',
    '__php_fpm_handler' => 'FPM-program',
    '__php_fpm-dedicated_handler' => 'Dedikert FPM-applikasjon',

    'mailname_create_assigned_user_dublicate_error' => 'Kan ikke opprette en bruker for denne postboksen. Brukeren med brukernavnet %1 eksisterer allerede og har en annen e-postboks.',
    'mailname_create_assigned_user_role_absent_error' => 'Kan ikke opprette en bruker for denne postboksen. Standardrollen %1 for brukeren finnes ikke.',

    'gphd__mime_types' => 'MIME-typer',
    'gphd__handlers' => 'Apache behandlingsprogrammer',
    'gphd__ip_restrictions_allow' => 'Tillat tilgang til området for spesifiserte verter og nettverk (unntatt de som er avslått)',
    'gphd__ip_restrictions_deny' => 'Avslå tilgang til området for angitte verter og nettverk.',
    'gphd__directory_index' => 'Indekser filer',
    'gphd__nginx_transparent_mode' => 'Moduset når Apache behandler både statisk og dynamisk innhold, mens nginx kun viderebefordrer HPPT forespørsler og svar uten modifikasjon.',
    'gphd__nginx_serve_static' => 'Betjen statiske filer direkte med nginx',
    'gphd__nginx_static_extensions' => 'Statiske filtyper som må tas hånd om med nginx',
    'gphd__nginx_serve_php' => 'Behandle PHP filer med nginx',
    'gphd__www_root' => 'WWW rotkatalog',

    'eol__none' => 'Ikke endre',
    'eol__lf' => 'konverter til Unix stil',
    'eol__cr' => 'konverter til MacOS stil',
    'eol__crlf' => 'konverter til Windows stil',

    'ui__dns_bad_zone' => 'Inkonsekvent sone "%1":',
    'ui__dns_ns_has_no_address_records' => 'NS-oppføringen "%1" har ingen adresseoppføringer (A eller AAAA).',
    '__dns_bad_zone' => 'Inkonsekvent sone "%1":',
    '__dns_ns_has_no_address_records' => 'NS-oppføringen "%1" har ingen adresseoppføringer (A eller AAAA).',
    '__dns_ptr_is_wildcard' => 'PTR-oppføring "%1" er ugyldig: Oppføringen peker på et jokertegndomene.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Tillat ekstern tilgang for databasebruker \'%3\' for kunde \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Kan ikke tillate eksterne tilkoblinger for databasebruker \'%1\': Kan ikke finne TCP-portnummer brukt av Microsoft SQL Server \'%2\'. Mulige årsaker er følgende: TCP/IP-protokoll er ikke aktivert i konfigurasjonen for servernettverket eller serveren er konfigurert for å bruke dynamiske TCP-porter. Konfigurer serveren til å lytte til en bestemt fast TCP-port og prøv å tillate eksterne tilkoblinger igjen.',

    'command__convertResellerHasCustomer' => 'Forhandlerkontoen \'%1\' har én eller flere kundekontoer. For å konvertere denne forhandlerkontoen til en kundekonto, overfør først disse kundekontoene til en ny eier elle konverter dem til forhandlerkontoer.',
    'command__convertResellerNotReseller' => 'Bare forhandlerkontoer kan konverteres til kundekontoer. \'%1\' er ikke en forhandler.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Kunne ikke synkronisere abonnementet med tjenesteplanen. Følgende innstillinger i abonnementet står i konflikt med tjenesteplanen: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Kontoen \'%1\' er en forhandlerkonto. Forhandlerkontoer kan ikke flyttes til en ny eier siden de eies av serveradministratoren.',
    'moveCustomer__wrong_owner_type' => "Kundekontoen '%1' kan bare flyttes til en forhandler eller en administrator, ikke til en annen kunde.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Kundekontoen \'%1\' tilhører allerede den valgte eieren.',
    'upgradeClient__user_is_admin' => 'Kontoen \'%1\' kan ikke konverteres til en forhandlerkonto fordi den er en administratorkonto.',

    'mail__error_setting_max_connections_courier' => 'Kunne ikke sette maksimalt antall tilkoblinger (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Kunne ikke sette maksimalt antall tilkoblinger (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Kunne ikke sette maksimalt antall tilkoblinger (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS) per IP-adresse: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Kunne ikke sette maksimalt antall tilkoblinger (IMAP, POP3, IMAP over SSL/TLS eller POP3 over SSL/TLS) per IP-adresse for en bestemt e-postbruker: %1',
    'outgoing_messages_limit_value_invalid' => 'Verdien må være i området %%MIN%%..%%MAX%%. Bare Plesk-administratoren kan justere denne innstillingen.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Følgende domener bruker eksterne e-postadresser for videresending av e-post til ikke-eksisterende adresser. Meldinger sendt til disse adressene vil ikke telles i Utgående e-postkontroll:\n%1",
    'outgoing_messages_white_list_not_empty' => 'Grenser for utgående e-postmeldinger vil ikke fungere for avsendere som har IP-adresser på mailserverens hviteliste. For eksempel, hvis localhost (127.0.0.0 / 8, ::1 / 128) er på hvitelisten, vil all e-post fra den lokale serveren bli sendt, uansett begrensninger. Avsendere kan bruke enten lokale IP-adresser (nettsteder og brukerdefinerte skript som hostes på den lokale serveren) eller eksterne IP-adresser (kunder som sender e-post fra e-postklienter installert på datamaskinen eller mobile enheter). For å få grensene til å fungere for alle avsendere (både lokale og eksterne), fjern alle IP-adresser og nettverk fra hvitelisten. Merk at å fjerne localhost (127.0.0.0 / 8, ::1 / 128) fra the hvitelisten kan forstyrre driften av nettsteder og skript som sender e-post fra denne serveren. For detaljer om begrensninger for utgående e-post, se Administratorveiledningen, Beskyttelse mot utgående spam.',
    'outgoing_messages_relay_open' => 'Videresending av e-post er åpen: Grenser for utgående e-postmeldinger vil ikke fungere.',

    'notification_aps_app_updates_available' => 'Oppdateringer er tilgjengelige for følgende programmer:',
    'notification_aps_app_updates_installed' => 'Oppdateringer ble automatisk installert for følgende programmer:',
    'notification_aps_app_updates_requirements' => 'Oppdateringer er tilgjengelige for følgende programmer, men kan ikke installeres fordi hosting-innstillinger for tilsvarende nettsteder ikke oppfyller installasjonskravene:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Din versjon: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Plugin "%%name%%" på %%parentName%% (%%url%%). Din versjon: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Tema "%%name%%" på %%parentName%% (%%url%%). Din versjon: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny versjon: %%to%%. Forrige versjon: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny versjon: %%to%%. Forrige versjon: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Ny versjon: %%to%%. Forrige versjon: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Installert version: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Din versjon: %%from%%. Tilgjengelig versjon: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'ekstern app',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Domener',
    'notification_outgoing_mail_exceeded_limits_mails' => 'E-postadresser',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Abonnementer',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 meldinger pr time',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Ubegrenset',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, grensen er %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 forsøk på å overskride grenser fra %2 til %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 forsøk på å overskride grenser fra %2 til nå',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Utestenging av IP-adresser (Fail2Ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Fail2ban-komponenten er ikke installert på målserveren.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Installer Fail2ban. Merk at dette kan ta noen minutter.',

    'plesk_key__no_reseller_support' => 'Du kan ikke administrere forhandlere på grunn av lisensbegrensninger.',
    'plesk_key__no_customers_support' => 'Du kan ikke administrere kunder på grunn av lisensbegrensninger.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Kan ikke skifte til tjenesteleverandørvisning på grunn av lisensbegrensninger.',
    'plesk_key__no_security_core_support' => 'Kjernefunksjonene for sikkerhet (ModSecurity og Fail2Ban) er ikke tilgjengelige på grunn av lisensbegrensninger.',
    'plesk_key__outgoing-antispam' => 'Utgående e-postkontroll',
    'plesk_key__security-core' => 'Sikkerhetskjerne (ModSecurity og Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Kontoadministrasjon',
    'plesk_key__can-manage-subscriptions' => 'Administrasjon av abonnementer',
    'plesk_key__can-manage-customers' => 'Kundeadministrasjon',
    'plesk_key__can-manage-resellers' => 'Administrasjon av forhandlere',
    'plesk_key__can-manage-custom-view' => 'Tilgjengelighet for begrenset modus',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Administrasjon av abonnementer er slått av, men du har flere abonnementer (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Administrasjon av forhandlere er slått av, men du har flere forhandlere (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Kundeadministrasjon er slått av, men du har flere kunder (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Visse abonnementressurser du ikke lenger administrerer i Plesk-grensesnittet (som begrensninger på mailbokser og domeners diskplass) er nå satt til ubegrenset.',
    'plesk_key__no_subscriptions_support' => 'Du kan ikke administrere abonnementer på grunn av lisensbegrensninger.',
    'plesk_key__no_custom_view_support' => 'Du kan ikke bruke begrenset modus på grunn av lisensbegrensninger.',
    'plesk_key__trial_forbidden_region' => 'Beklager, Plesk er for øyeblikket ikke tilgjengelig i din region.',
    'additional_key__main_key' => 'Nøkkelen er en hovednøkkel: Du kan ikke laste opp en hovednøkkel som en ekstranøkkel.',

    'gch__hosting_waf_rule_engine' => 'Brannmurmodus for webprogram',

    'backup__fieldset__restoration_options' => 'Gjenoppretting valgmuligheter',
    'backup__restore_options__restore' => 'Gjenopprett',
    'backup__restore_options__domain__domain_configuration' => 'Domenekonfigurasjon',
    'backup__restore_options__domain__virtual_host_content' => 'Innhold på virtuell vert',
    'backup__restore_options__domain__mail' => 'E-post',
    'backup__restore_options__domain__databases' => 'Databaser',
    'backup__restore_options__client__client_configuration' => 'Konfigurasjon av kundekonto',
    'backup__restore_options__client__domains' => "Kundens domener",
    'backup__restore_options__reseller__reseller_configuration' => 'Konfigurasjon av forhandlerkonto',
    'backup__restore_options__reseller__personal_domains' => "Forhandlerens domener",
    'backup__restore_options__reseller__clients' => "Forhandlers kunder",
    'backup__restore_options__admin__server_configuration' => 'Serverinnstillinger',
    'backup__restore_options__admin__administrator_configuration' => 'Konfigurasjon av administratorkonto',
    'backup__restore_options__admin__personal_domains' => "Administratorens domener",
    'backup__restore_options__admin__personal_clients' => "Administratorens kunder",
    'backup__restore_options__admin__resellers' => 'Videreforhandler',

    'badge_new' => 'Ny',
    'upgrade_php_on_subscription' => 'Oppgrader PHP på abonnementet ditt til versjon 5.3.0 eller nyere.',

    'pkey_notify__body_expiration_notification' => 'Lisensnøkkel er utløpt. Enkelte funksjoner kan være utilgjengelige. Vennligst ta kontakt med hostingleverandøren din.',

    'crontab__crontab_entry_exists' => "Den planlagte oppgaven finnes allerede.",
    'crontab__crontab_entry_not_exists' => "Den planlagte oppgaven finnes ikke.",
    'crontab__invalid_values_found' => "Gale parameterverdier.",
    'crontab__cmd_max_len' => "Kommandoen kan ikke være lenger enn %1 tegn.",

    'domain__domain_exists' => "Det finnes et domene med prefiks 'www' og det samme navnet: %1.%2.",
    'domain__subdomain_exists' => "Det finnes et underdomene med prefiks 'www' og det samme navnet: %1.%2.",
    'domain__dalias_exists' => "Det finnes et domenealias med prefiks 'www' og det samme navnet: %1.%2.",
    'domain__record_exists' => "Det finnes en DNS-oppføring som peker på verten %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Sertifikatet '%1' kan ikke settes som standard: privat nøkkel mangler.",
    'ip_addr__update_dns_error' => 'Det oppstod problemer under oppdatering av IP-adresse i DNS-soner. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Kan ikke legge til IP adressen. Dette nettverksgrensesnittet henter IP adresser automatisk.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Kan ikke fjerne IP adressen %1. Dette nettverksgrensesnittet henter IP adresser automatisk.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Kan ikke reparere IP adressen %1. Dette nettverksgrensesnittet henter IP adresser automatisk.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Kan ikke endre grensesnittet på IP adressen %1 fordi nettverksgrensesnittet %2 henter IP adresser automatisk.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Abonnementsgrensen for antall %%type%% er overskredet. Grensen er %%limit%%, og %%usage%% er i bruk.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Opprettelse av %%type%% er ikke tillatt for dette abonnementet.',
    'shm_lmsg__resource_title__db-mysql' => 'MySQL databaser',
    'shm_lmsg__resource_title__db-mssql' => 'MS SQL-databaser',
    'shm_lmsg__resource_title__db-postgresql' => 'PostgreSQL-databaser',
    'shm_lmsg__resource_title__db-user' => 'databasebrukere',
    'shm_lmsg__resource_title__iis-application-pool' => 'IIS-programutvalg',
    'shm_lmsg__resource_title__additional-ftp-account' => 'ekstra FTP-kontoer',

    'db_user_unable_remove_mysql_global_privileges' => 'Kunne ikke fjerne globale privilegier for MySQL for databasebruker %1. Årsak: %2',
    'report__client_description' => 'Beskrivelse',

    'db__user_role_error' => 'Feil rolle ble angitt for databasebruker: %1. Vennligst velg én av følgende roller: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Kunne ikke sette størrelsesgrense for fil for følgende Microsoft SQL Server-databaser fordi de har en større filstørrelse: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Kunne ikke sette størrelsesgrense for loggfil for følgende Microsoft SQL Server-databaser fordi de har en større loggfilstørrelse: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Kunne ikke sette opp en offentlig IP-adresse: det må finnes en privat IP-adresse.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Kunne ikke sette opp en offentlig IPv4-adresse for IPv6-adressen.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Kunne ikke sette opp en offentlig IPv6-adresse for IPv4-adressen.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Kunne ikke sette opp en offentlig IP-adresse: ugyldig IP-adresse.',

    '__user_already_exists' => "Bruker %1 finnes allerede.",
    '__user_name_is_empty' => "Vennligst angi et brukernavn.",

    'upgrade_php_on_domain' => 'Kunne ikke finne PHP-versjon 5.3.0 eller nyere på noen av WordPress-domenene dine. Prøv å oppgradere PHP.',

    'component_name__waf' => 'Brannmur for webprogram',
    'component_name__vcs' => 'System for versjonskontroll',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Et mulig forfalskningsforsøk ble oppdaget: Koblingen forsøkte å vise irrelevant innhold.',
    'forceResetPasswordUpdated' => 'Passordet ditt er endret. Bruk det nye passordet til å logge inn på Plesk.',

    'php_handlers_error_no_available_instance' => 'Kunne ikke opprette et domene: det finnes ingen tilgjengelige PHP-behandlingsprogrammer.',
    'domain_error_unable_to_apply_hosting_settings' => 'Kunne ikke bruke innstillinger for hosting: %1',

    'plesk_not_configured' => 'Plesk er ikke konfigurert. Gå til kontrollpanelet for å utføre konfigurasjon etter installasjonen.',
    'cmd_mail__mail_password_duplicated' => 'Spesifisert e-postadresse med tilhørende passord finnes allerede på epostserveren. Vennligst angi en annen e-postadresse eller passord.',

    'extensionRequirementOs' => 'Operativsystemet (%1) støttes ikke av pakken.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 er den tidligste versjonen som støttes av pakken.',
    'extensionRequirementPleskMaxVersion' => 'Versjoner som starter fra Plesk %1 støttes ikke av pakken.',
    'extensionBlacklisted' => 'Utvidelsen %1 er ikke tillatt for installasjonen.',
    'extensionDisabled' => 'Utvidelsen er deaktivert.',


    'optimization_settings__unable_set_mpm_event' => 'Kunne ikke angi mpm_event-modus: dette krever at Apache PHP5-modulen er slått av, men denne modulen brukes av domener.',
    'optimization_settings__unable_turn_off_php' => 'Kunne ikke slå av Apache PHP5-modulen: den brukes av domener.',

    'hst_def__fp_admin_login' =>  'FTP brukernavn',
    'hst_def__fp_admin_passwd' =>  'FTP-passord',

    'database_user_orphaned_old_password_wrong' => "Kunne ikke reparere løsrevet bruker '%1': passordet er feil.",
    'cannot_load_partner_central_property_key_no_exist' => "Kunne ikke hente brukerdefinerte egenskaper: lisensnøkkelen finnes ikke.",
    'extensionScriptFailure' => "Utførelsen av %1 har gått galt med følgende melding:\n%3",
    '__ssl_redirect' => "Permanent SEO-sikker 301 omdirigerer fra HTTP til HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Administrasjon av DKIM er ikke støttet.',
    'mail__dmarc_not_supported' => 'Administrasjon av DMARC støttes ikke.',
    'mail__relay_white_list_not_supported' => 'Administrasjon av hviteliste for videresending er ikke støttet.',
    'mail__black_list_not_supported' => 'Administrasjon av svarteliste er ikke støttet.',
    'mail__autoresponder_not_supported' => 'Administrasjon av autosvar er ikke støttet.',
    'defaultcomponents__not_supported_version' => '(ikke støttet versjon)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Sertifikat \'%1\' ble ikke funnet.',
    'certificate__unable_setup_certificate' => 'Kunne ikke installere sertifikatet: den private nøkkelen og innholdet av sertifikatet mangler.',
    'certificate__used_by_panel' => 'Ett av sertifikatene du er i ferd med å slette brukes for å sikre Plesk.',
    'certificate__used_by_mail_server' => 'Ett av sertifikatene du er i ferd med å slette brukes for i sikre e-postserveren.',
    'certificate__used_by_domain_service' => 'Ett av sertifikatene du er i ferd med å slette er i bruk av domenetjeneste.',
    'mail_server__not_installed' => 'Kan ikke installere sertifikatet for e-postserveren, fordi e-postserveren ikke er installert.',

    'email_activation_mail_subject' => 'Vennligst aktiver kontoen i Plesk',
    'email_activation_mail_body' => "En konto ble opprettet på Plesk-server %1 \n\nKontodetaljer: \nNavn: %2 \nE-postadresse: %3 \n\nHvis denne informasjonen er riktig og kontoen ble opprettet for deg, vennligst aktiver den med følgende lenke: \n\n%4 \n\nVed å aktivere kontoen, autoriserer du serverinnehaveren til å samle inn, lagre, behandle og bruke dine personlige data (navn og e-postadresse) til å opprette og støtte kontoen din, i samsvar med gjeldende lover for databeskyttelse som en del av en kontrakt.",

    'backup_transport_permission_name' => '%1 administrasjon',
    'backup_transport_permission_description' => 'Muliggjør bruk av %1 for lagring av sikkerhetskopier.',

    'domain_move_err_target_no_hosting' => 'Kan ikke flytte domenet til et abonnement uten hosting.',
    'domain_move_err_already_in_target' => 'Domenet tilhører allerede mål-abonnementet.',
    'domain_move_err_main_domain' => 'Hoveddomenet kan ikke flyttes.',
    'domain_move_err_subdomain_without_parent' => 'Kan ikke flytte underdomenet %1 uten det overordnede domenet %2.',
    'domain_move_err_root_exists' => 'Mål-banen for www_root %1 eksisterer allerede.',
    'domain_move_err_nested_roots' => 'Kan ikke flytte domenet fordi det deler dokument-roten med et annet domene: %1.',
    'domain_move_err_no_mail_service' => 'Kan ikke flytte domenet fordi e-post tjenesten er deaktivert på mål-abonnementet.',
    'domain_move_err_app' => "Applikasjonen installert på %1 ble ikke flyttet til abonnementet '%2': %3",
    'domain_move_database_used_by_app' => "Databasen '%1' på %2 brukes av den applikasjonen som ble flyttet. For å tilordne databasen på nytt til '%3', kjør `plesk bin database --tilordne til abonnement`",
    'domain_move_target_locked' => "Mål.abonnementet '%1' ble låst for synkronisering.",
    'domain_move_filesharing_disabled' => 'Fildeling ble deaktivert.',
    'domain_move_website_preview_disabled' => 'Forhåndsvisning av nettsiden ble deaktivert.',
    'domain_move_additional_webserver_settings' => "Se over domenets ekstra nettserver-direktiv for å forhindre en brutt konfigurasjon.",
    'domain_move_no_permission' => "%1 er ikke tillatt for abonnementet '%2'.",
    'domain_move_no_access' => "Ingen adgang til abonnementet '%1'.",
    'domain_split_no_create_permission' => "Å skape et domene er ikke tillatt.",
    'domain_split_empty_login' => 'Innlogging fra systembruker kreves.',
    'domain_split_empty_password' => 'Passord for systembruker kreves.',
    'domain_split_err_home_exists' => 'Domenet %1 kan ikke flyttes fordi dets mål-hjemmebane allerede eksisterer i %2. Gi domenet et nytt navn for å flytte det til et nytt abonnement.',
    'domain_split_err_no_hosting_subdomains' => 'Domenet kan ikke flyttes til et nytt abonnement fordi domenet ikke har vertstjenester, men det har underdomener. For å flytte domenet, endre dets "Vertstjeneste-type" verdi til "Nettsteds-vertstjeneste" (i Innstillinger for vertstjenester).',
    'domain_split_target_locked' => "Målabonnementet '%1' er låst for synkronisering.",
    'domain_split_target_unsynced' => "Mål-abonnementet '%1' var ikke synkronisert med planen på grunn av: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Planlagt sikkerhetskopiering ble deaktivert på '%1'.",
    'domain_merge_database_error' => "Databasen '%1' på %2 ble ikke flyttet til abonnementet '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Anonym FTP på '%1' ble skrudd av.",
    'domain_merge_smb_user_access' => "Den ekstra brukeren '%1' ble flyttet til abonnementet '%2' men brukerens aksess til abonnementet ble tilbakekalt.",
    'domain_merge_scheduled_tasks' => "Planlagte oppgaver ble flyttet til mål-abonnementet. Gjennomgå oppgavekonfigureringen.",
    'domain_merge_scheduled_tasks_deactivated' => "Planlagte oppgaver ble flyttet til mål-abonnementet og deaktivert.Gjennomgå oppgavekonfigureringen.",
    'domain_merge_no_remove_permission' => "Å ta bort abonnementer er ikke tillatt.",
    'domain_merge_err_has_addons' => 'Kan ikke flytte hoveddomenet med dets tilleggsdomener, flytt domene(ne) %1 først.',
    'domain_merge_err_has_webusers' => 'Kan ikke flytte hoveddomenet med dets nettbrukere.',
    'domain_merge_err_root_exists' => 'Mål-banen %1 eksisterer allerede.',

    'database_server_edit_used_for_psa' => 'Oppdatering av lokal MySQL databaseserver er ikke tillatt.',
    'suggest_repair_main_suggestion_ui' => '<b>Du kan rette denne feilen</b> med «plesk repair»-verktøyet.',
    'suggest_repair_main_suggestion_cli' =>  'Du kan rette denne feilen med «plesk repair»-verktøyet.',
    'suggest_repair_repair_kit_link_title' => 'gå til Diagnose og reparasjon',
    'suggest_repair_using_cli_and_ui' => 'Det kan du gjøre ved å kjøre kommandoen «plesk repair %1» via CLI eller %2 og klikk på Reparer ved siden av «Plesk-database»',
    'suggest_repair_using_cli' => 'Det kan du gjøre ved å kjøre kommandoen «plesk repair %1» via CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'DNS-tjenesten var ikke tilgjengelig da sikkerhetskopien ble opprettet. Sikkerhetskopien har imidlertid aktive DNS-soner og disse vil aktiveres for følgende objekter: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Ressurskontroller (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Støtte for ekstern SmarterMail',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(ikke tillatt med denne lisensnøkkelen)',
    'plesk_key__validation_failed' => '%1 (Feilkode: %2)',
    'promo__button_details' => 'Detaljer',
    'promo__extension_catalog_title' => 'Utvidelseskatalog',
    'promo__extension_catalog_description' => 'Ta en titt på den nye utvidelseskatalogen og gjør Plesk enda bedre ved hjelp av en rekke kraftige, nye utvidelser!',
    'promo__button_open_catalog' => 'Åpne katalogen',

    'backup__repository_check_login' => "Ingen tilgang til lagringsenheten: %1 Kontroller at du har oppgitt korrekte opplysninger for tilgang.",
    'backup__repository_check_error_list' => "Ingen tilgang til lagringsenhet: %1 Kontroller at du har oppgitt korrekte innstillinger.",
    'backup__repository_check_error_mkdir' => "Kan ikke opprette mappe: %1 Kontroller at du har tillatelse til å opprette mapper på enheten.",
    'backup__repository_check_error_upload' => "Kan ikke laste opp filen til lagringsenheten: %1 Kontroller at du har tillatelse til å laste opp til denne enheten.",
    'backup__repository_check_error_download' => "Kan ikke laste ned den lagrede filen: %1 Kontroller at du har tillatelse til å laste opp og laste ned filer fra denne lagringsenheten.",
    'backup__repository_check_error_resume-upload' => "Kan ikke gjenoppta opplasting av filen til lagringsenheten: %1 Kontroller at du har tillatelse til å gjenoppta opplasting til denne enheten.",
    'backup__repository_check_error_resume-download' => "Kan ikke gjenoppta nedlasting av filen fra lagringsenheten: %1 Kontroller at du har tillatelse til å gjenoppta nedlasting fra denne enheten.",
    'backup__repository_check_error_enable-utf8' => "Kan ikke bruke lagringsenheten: %1 Kontroller at lagringsenheten støtter UTF8-koding.",
    'backup__repository_check_error_rm' => "Kan ikke utføres på lagringsenhet: %1 Kontroller at du har tillatelse til å slette filer fra denne lagringsenheten.",
    'backup__repository_check_error_rmdir' => "Kan ikke utføres på lagringsenhet: %1 Kontroller at du har tillatelse til å slette mapper fra denne lagringsenheten.",

    'backup__ftp_repository_check_login' => "%1 Du kan kontrollere dette med følgende kommando: %2",
    'backup__ftp_repository_check_error_list' => "%1 Du kan kontrollere dette med følgende kommando: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Du kan kontrollere dette med følgende kommando: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Du kan kontrollere dette med følgende kommandoer: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Du kan kontrollere dette med følgende kommandoer: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Du kan kontrollere dette med følgende kommandoer: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Du kan kontrollere dette med følgende kommandoer: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Du kan kontrollere dette med følgende kommando: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Du kan kontrollere dette med følgende kommandoer: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Du kan kontrollere dette med følgende kommandoer: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Kan ikke endre innstillinger for DMARC. Aktiver DKIM og SPF spambeskyttelse for å aktivere dette alternativet.',
    'spf_server_wide_disable_failed' => 'Kan ikke endre innstillinger for SPF spambeskyttelse. For å deaktivere SPF, må du slå av DMARC for innkommende e-post.',
    'sfdk_server_wide_verify_disable_failed' => 'Kan ikke endre innstillinger for DKIM spambeskyttelse. For å deaktivere DKIM, må du slå av DMARC for innkommende e-post.',

    'ccs_not_supported' => 'IIS Central Certificate Store er ikke konfigurert i systemet.',
    'ccs_not_enabled' => 'Styring av IIS Central Certificate Store er ikke aktivert i Plesk.',
    'ad_not_supported' => 'Serveren er ikke knyttet til et domene.',

    'component_name__appinit' => "Oppstart av applikasjon",
    'component_name__httpcompression' => 'Kompresjon av HTTP-innhold',
    'common_feature_is_not_supported' => 'Denne funksjonen støttes ikke lenger.',
    'common_feature_is_not_supported_in_proto' => 'Denne funksjonen støttes ikke for protokollversjon %1.',
    'autoinstaller__plesk_component' => 'Plesk-komponent',
    'plesk_key__key_expired' => 'Lisensnøkkelen din er utløpt. Kjøp en permanent kommersiell %1 for å fortsette å bruke Plesk.',
    'plesk_key__key_purchase' => 'lisensnøkkel',

    'sa_action_move' => 'Flytt søppelpost til mappen Søppelpost',

    'bu_conflict_resolver_tomcat_not_supported' => 'Java-applikasjoner støttes ikke lenger. De vil ikke være tilgjengelige for følgende nettsteder: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Mobilnettsteder hostet med UNITY Mobile støttes ikke lenger. De vil ikke være tilgjengelige for følgende nettsteder: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Global policy for denne serveren tillater ikke personlige innstillinger for antivirus. Disse vil delvis gjenopprettes for e-postkontoer på følgende domener: {{objects}}',

    'module__not_installed' => "Utvidelsen %1 er ikke installert",

    'mail__mail_autodiscovery_server_error' => 'Spesifiser et tilpasset domenenavn for autosøk for e-post',
    'mail__error_mail_autodiscovery_enable' => 'Kan ikke konfigurere autosøk for e-post: %1',
    'mail__error_mail_autodiscovery_server' => 'Kan ikke angi tilpasset domenenavn for autosøk for e-post: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Kan ikke omkonfigurere domenets DNS-poster for autosøk: %1',

    '__invalid_url' => '«%1» er ikke en gyldig URL',
    'actionlog__cloning_start' => 'start',
    'actionlog__event_cloning_start' => 'Start kloning av server',

    '__UPLOAD_ERR_FORM_SIZE' => "Den opplastede filen overskrider den tillatte størrelsen",
    '__UPLOAD_ERR_INI_SIZE' => "Den opplastede filen overskrider den tillatte størrelsen",
    '__UPLOAD_ERR_NO_FILE' => "Ingen fil mottatt",
    '__UPLOAD_ERR_OK' => "Filen ble vellykket lastet opp",
    '__UPLOAD_ERR_PARTIAL' => "Filen ble delvis laset opp, vennligst forsøk igjen",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Midlertidig mappe mangler',
    '__UPLOAD_ERR_CANT_WRITE' => 'Å skrive til disken gikk galt',
    '__UPLOAD_ERR_UNKNOWN' => 'Det oppstod en ukjent feil i opplastingen av filen',
    '__accounts' => "Kontoer",
    '__access' => "Tilgang",
    '__address' => "Adresse",
    '__addresses' => "Adresser",
    '__acl_records' => 'ACL oppføringer',
    '__admin_repository' => "Administrators depot",
    '__all' => 'Alle',
    '__allowed' => "Tillatt",
    '__anonftp_status' => "Anonym FTP",
    '__antispam' => "AntiSpam",
    '__apache_restart' => "...%1 webserveren startes på nytt, vennligst vent...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Microsoft ASP.NET støtte",
    '__asp_win_support' => "Microsoft ASP støtte",
    '__attachments' => "Vedlegg",
    '__attachments_list' => "Vedlegg",
    '__author' => 'Forfatter',
    '__autoresp_name_already_exists' => "Det finnes allerede et Autosvar med navnet %1.",
    '__autoresponder' => "Autosvar",
    '__autoresponders' => "Autosvar",
    '__autoresponders_list' => "Autosvar",
    '__autoresponder_attachment_files' => "Autosvar Vedleggsfiler",
    '__auto_updates_list' => 'Tilgjengelige oppdateringer',
    '__avail' => "Tilgjengelig",
    '__backup_utilites' => "Verktøy for sikkerhetskopiering",
    '__bind_status' => "Status for DNS-server",
    '__bu_is_not_installed' => "Denne tjenesten er for tiden utilgjengelig fordi programmer for sikkerhetskopiering ikke ble installert.",
    '__bu_not_support_in_key' => "Sikkerhetskopieringsfunksjonalitet støttes ikke av lisensnøkkelen.",
    '__notifications_not_support_in_key' => 'Varslinger støttes ikke av lisensnøkkelen',
    'disabled_by_key' => 'Støttes ikke av lisensnøkkelen',
    '__bytes' => "byte",
    '__can_not_use_reserved_words' => "Du kan ikke bruke reserverte ord.",
    '__certificate' => "Sertifikat",
    '__cgi_support' => "CGI støtte",
    '__change_date' => "Endringsdato",
    '__city' => "Poststed",
    '__cl_not_exist' => "Kundekonto finnes ikke.",
    '__client' => 'Kunde',
    '__client_card' => "Kundekort",
    '__client_contact_name' => "Navn på kundekontakt",
    '__client_form' => "Personlig informasjon",
    '__client_ip_pool' => "Kundens IP-utvalg",
    '__client_limits' => "Grenser for kundekonto",
    '__client_permissions' => "Kundens tillatelser",
    '__client_preferences' => "Kundens preferanser",
    '__client_status' => "Kundestatus",
    '__client_name' => "Kundenavn",
    '__client_total' => "Kundetotal",
    '__client_with_login_name_already_exists' => "En bruker med brukernavn \"%1\" finnes allerede.",
    '__client_domuser_with_login_already_exists' => "Brukernavnet '%1' er allerede i bruk av administratoren for domene '%1'.",
    '__clients_global_changes' => "Modifiser valgte kundekontoer",
    '__clients_list' => "Kunder",
    '__cmd_not_found' => "Ukjent kommando: %1",
    '__comments' => "Kommentarer",
    '__company_name' => "Firmanavn",
    '__component_version' => "Komponentversjon",
    '__component_not_installed' => "Komponenten %1 ble ikke installert",
    '__confirm_del' => "Du må bekreft sletting.",
    '__confirm_overwrite' => "Bekreft overskriving.",
    '__confirm_stop' => "Du må bekrefte stopping av prosessen.",
    '__confirm_passwd' => "Bekreft %1 passord",
    '__confirm_removal' => "Bekreft fjerning",
    '__conhelp' => "Beskrivelse",
    '__contact_name' => "Kontaktnavn",
    '__country' => "Land",
    '__countries' => 'Land',
    '__country_unknown' => 'Kjenner ikke igjen landets underkode.',
    '__courier-imap' => 'Courier-server',
    '__create_domain' => 'Opprett domene',
    '__crypted' => 'kryptert',
    '__cp_access' => "Tilgang til Plesk",
    '__cp_user' => "Plesk-bruker",
    '__create' => "Opprett",
    '__create_client_template_without_template' => "Opprett brukerkonto uten mal",
    '__create_domain_for' => "Opprett et domene for <b>%1</b>",
    '__create_domain_template_without_template' => "Opprett domene uten mal",
    '__creation_date' => "Opprettelsesdato",
    '__crontab_unix' => "Planlegger",
    '__crontab_win' => "Planlegger",
    '__ct_month_jan' => 'Januar',
    '__ct_month_feb' => 'Februar',
    '__ct_month_mar' => 'Mars',
    '__ct_month_apr' => 'April',
    '__ct_month_may' => 'Mai',
    '__ct_month_jun' => 'Juni',
    '__ct_month_jul' => 'Juli',
    '__ct_month_aug' => 'August',
    '__ct_month_sep' => 'September',
    '__ct_month_oct' => 'Oktober',
    '__ct_month_nov' => 'November',
    '__ct_month_dec' => 'Desember',
    '__custom_button' => "Egendefinert knapp",
    '__custom_buttons_list' => "Koblinger til ytterligere tjenester",
    '__daily' => "Hver dag",
    '__database_not_activated' => "%1 ble ikke aktivert på serverens administrasjonsside.",
    '__database_not_installed' => "Database %1 er ikke installert.",
    '__database_not_run' => "Database %1 kjører ikke.",
    '__database_is_corrupt' => "Plesks database er skadet. Vennligst kjør rekonfigurator verktøyet for å ordne det.",
    '__databases' => "Databaser",
    '__databases_list' => "Databaser",
    '__database_type_not_supported_by_key' => 'For å bruke serveren %1, trenger du support for dette i lisensnøkkelen. Vennligst rådfør deg med Plesk-forhandleren.',
    '__date_immediately' => "i dag",
    '__date_never' => "aldri",
    '__day(s)' => "dag(er)",
    '__day0' => "Søn",
    '__day1' => "Man",
    '__day2' => "Tir",
    '__day3' => "Ons",
    '__day4' => "Tor",
    '__day5' => "Fre",
    '__day6' => "Lør",
    '__days' => "%1 dag(er)",
    '__db_admin_login_empty' => "Du har angitt tomt brukernavn, dette slår av kontroll over %1 i grensesnittet. Vil du fortsette?",
    '__db_unable_to_unregister' => 'Kan ikke fjerne parametere for databasetilkobling',
    '__db_db_exists' => 'Det er minst en database på serveren',
    '__db_unable_to_change_server_name' => 'Navn på serveren kan ikke endres',
    '__db_unable_to_change_port' => 'Port for serveren kan ikke endres',
    '__db_already_exist' => "Database %1 finnes fra før.",
    '__db_credentials_invalid' => "Databasepåloggingsinformasjon er ugyldig.",
    '__db_invalid_password_characters' => 'Passordet inneholder ugyldige tegn',
    '__db_engine' => "Databasemotor", // indirect
    '__db_type' => "Databasetype",
    '__db_user' => "Databasebruker",
    '__db_server' => 'Databaseserver',
    '__def_domain' => "Standard domene",
    '__default_for_mysql' => 'standard for MySQL',
    '__default_for_mariadb' => 'standard for MariaDB',
    '__default_for_percona' => 'standard for Percona',
    '__default_for_postgresql' => 'standard for PostgreSQL',
    '__delete' => "Slett",
    '__demo' => "Denne funksjonen er ikke tilgjengelig i demo versjonen.",
    '__directory' => "Mappe",
    '__disable_lock_screen' => 'Hindre brukere i å arbeide med Plesk før grensesnittskjermer er ferdig lastet',
    '__dismiss_news?' => "Er du sikker du vil lukke nyhetsblokken fullstendig?\n\nDu vil ikke kunne se nyhetsblokken før flere nyheter er tilgjengelige.",
    '__description' => "Beskrivelse",
    '__disabled' => "slått av",
    '__disk_space_limit' => "Diskplassgrense",
    '__cgroups_cpu_usage_limit' => 'Grenseverdi for CPU-bruk',
    '__cgroups_ram_usage_limit' => 'Grense for RAM-forbruk',
    '__cgroups_disk_read_usage_limit' => 'Båndbreddegrense for lesing av disk',
    '__cgroups_disk_write_usage_limit' => 'Båndbreddegrense for skriving til disk',
    '__disk_usage_by' => "Diskplass brukt av %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "DNS-post '%1' finnes allerede.",
    '__dns_master_should_be_remote' => "Du bør har to forskjellige autoritative navneservere på separate verter.",
    '__dns_record_not_exist' => "DNS-post finnes ikke.",
    '__dns_server' => "DNS server", // indirect
    '__dom_id_is_undefined' => "Domene-ID er ikke definert.",
    '__dom_name' => "Domenenavn",
    '__dom_name_is_invalid' => "Domenenavnet er ugyldig. Vennligst pass på at domenenavnet kun består av alfanumeriske symboler, punktum og bindestreker, og ikke er lenger enn 255 tegn. Hver del av domenenavnet mellom punktumene må ikke overskride 63 tegn.",
    '__dom_not_exist' => "Domenet finnes ikke.",
    '__domain' => "Domene",
    '__domain_' => 'Domene %1',
    '__domain_form' => "Domeneskjema",
    '__domain_id' => "Domene-ID",
    '__domain_is_turned_off_for_backup' => "Nettstedet %1 er midlertidig slått av for sikkerhetskopiering eller gjenoppretting og er ikke tilgjengelig nå.",
    '__domain_limits' => "Domenegrenser",
    '__domain_name' => "Domenenavn",
    '__mail_name_in_ASCII_form' => "E-postkontonavn i ASCII -format",
    '__message_error' => 'Feil',
    '__message_warning' => 'Advarsel',
    '__message_info' => 'Informasjon',
    '__domain_name_in_ASCII_form' => "Domenenavn på ASCII-format",
    '__domain_repository' => "Repositorium for domene %1",
    '__domain_status' => "Domenestatus",
    '__domain_found_tech' => "Teknologi funnet på domene",
    '__domain_dns' => 'Domenets DNS-sone',
    '__domain_total' => "Totalbeløp for abonnementet",
    '__domain_total_powerUser' => "Totalbeløp for abonnementet",
    '__domain_user' => "Domeneadministrator",
    '__domains_global_changes' => "Modifiser valgte domener",
    '__mailnames_global_changes' => "Modifiser valgte e-postkontoer",
    '__backup_manager' => 'Sikkerhetskopibehandler',
    '__domains_list' => "Domener",
    'domains_list__list_header' => "domener",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Domenenavnet begynner med www, selv om WWW-prefiks benyttes.\nFortsette likevel?",
    '__dovecot' => 'Dovecot IMAP og POP3-server',
    '__dsmail' => "Posttjeneste",
    '__dsmaillist' => "Adresselistetjeneste",
    '__dsr_db' => "DAVSKR",
    '__dsr_dname' => "Domenenavn",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "MBox",
    '__dsr_pname' => "Kundenavn",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Total størrelse på sikkerhetskopier i lokalt lager",
    '__email' => "E-post",
    '__email_addr_is_invalid' => "E-postadresse er ugyldig.",
    '__enabled' => "slått på",
    '__enter_cert_text' => "Skriv inn sertifikattekst",
    '__enter_size' => "Oppgi størrelse",
    '__exclusive' => "Dedikert",
    '__expiration_date' => "Utløpsdato",
    '__fax' => "Faks",
    '__file' => "Fil",
    '__file_is_empty' => "Filen er tom.",
    '__file_name' => "Filnavn",
    '__file_type' => 'Filtype',
    '__filemanager' => "Filadministrasjon",
    '__filepath_is_empty' => "Banen til filen er tom",
    '__files_list' => "Filer",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "FTP-innstillinger",
    '__ftp_serv' => "FTP-server", // indirect
    '__ftp_server_parameters_are_empty' => "Du bør sette opp egenskapene for FTP-kontoen først!",
    '__ftp_status' => "FTP-server status",
    '__full_day0' => "Søndag",
    '__full_day1' => "Mandag",
    '__full_day2' => "Tirsdag",
    '__full_day3' => "Onsdag",
    '__full_day4' => "Torsdag",
    '__full_day5' => "Fredag",
    '__full_day6' => "Lørdag",
    '__full_month1' => "Januar",
    '__full_month10' => "Oktober",
    '__full_month11' => "November",
    '__full_month12' => "Desember",
    '__full_month2' => "Februar",
    '__full_month3' => "Mars",
    '__full_month4' => "April",
    '__full_month5' => "Mai",
    '__full_month6' => "Juni",
    '__full_month7' => "Juli",
    '__full_month8' => "August",
    '__full_month9' => "September",
    '__giga' => "G",
    '__group' => "Gruppe",
    '__h' => "H",
    '__hard_disk_quota' => "Harddisk kvote",
    '__hard_disk_quota_not_supported' => 'Harddiskkvote støttes ikke på grunn av konfigurasjon av serverfilsystemet.',
    '__header_text_is_invalid' => "Tittel på beskyttet område er ugyldig.",
    '__help_topic_not_found' => 'Hjelpeemnet du ba om (%1) finnes ikke.',
    '__hosting_ip_dns_ip_not_equiv' => "Ingen av IP-adressene som er spesifisert i A DNS-oppføringene matcher IP-adressen som benyttes for hosting.",
    '__hosting_scripting' => "Skriptstøtte for hosting",
    '__hosting_setup_page_title' => "Oppsett av webhosting for domene %1",
    '__hosting_title' => "Hosting (%1)",
    '__hosting_type' => "Hosting-type",
    '__hostname_is_empty' => "Vertsnavnet er tomt.",
    '__hour(s)' => 'Time(r)',
    '__hst_type_incorrect' => "Hostingtype er feil.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Tid uten aktivitet",
    '__iface' => "Grensesnitt",
    '__image' => "Bilde",
    '__imap_status' => "IMAP-server status",
    '__in' => "Inn",
    '__in_%' => "i %",
    '__incorrect_databases_login_pass' => "Påloggingsinformasjonen som du som har angitt for tilgang PostgreSQL er feil.",
    '__incorrect_ip_or_network_address' => 'Feil IP-adresse eller netverk.',
    '__info' => 'Info',
    '__install' => "Installer",
    '__install_prefix' => "Installer prefiks",
    '__invalid_cert_id' => "Ugyldig sertifikat-ID",
    '__invalid_context' => "Ugyldig sammenheng: %1",
    '__invalid_db_usr_name' => "Databasebrukernavn er ugyldig.",
    '__invalid_dir_name' => "Mappenavnet er ugyldig",
    '__invalid_dom_name' => "Domenenavnet er ugyldig.",
    '__invalid_filename' => "Ugyldig filnavn. Bruk ikke enkle anførselstegn og/eller \"../\" kombinasjon.",
    '__invalid_id' => "Ugyldig identifikator.",
    '__invalid_lines_num' => "Upassende verdi for antall linjer, kun tall er tillatt.",
    '__invalid_max_letter_size' => "Maksimal beskjedstørrelse er ugyldig.",
    '__invalid_pdir_name' => "Beskyttet mappenavn er ugyldig.",
    '__invalid_restart_apache_interval' => "Apache omstart intervall er ugyldig.",
    '__invalid_tmpl_name' => "Navnet på malen er ugyldig.",
    '__invalid_value' => "Upassende verdi.",
    '__ip_addr' => "IP-adresse",
    '__ip_address_and_mask' => "IP adresse og nettverksmaske",
    '__ip_alias__mask' => "IP adresse og nettverksmaske",
    '__ip_addr_is_invalid' => "IP adressen er ugyldig.",
    '__ip_addr_list' => "IP-adresser",
    '__ip_address_and_mask_hint' => 'For eksempel, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "kB",
    '__key_for_virtuozzo_only' => "Lisensnøkkelen din er kun ment for bruk i Virtuozzo-beholdere.",
    '__key_limits_exceeding' => "Denne handlingen overskrider grensene som defineres av programvarelisensen din. Hvis du mottok denne meldingen kan du ta kontakt med leverandøren eller produsenten for å klargjøre eller forlenge grensene for denne lisensen.",
    '__kilo' => "K",
    '__keywords' => 'Nøkkelord',
    '__lang_unknown' => 'Kan ikke gjenkjenne språket.',
    '__languages' => 'Språk',
    '__learn_more' => 'Lær mer',
    '__loading' => 'Laster inn...',
    '__locales' => "Språkpakker",
    '__lists' => "Adresselister",
    '__literal_bytes' => "B",
    '__processing' => "Vennligst vent.<br>Laster...",
    '__locale' => "Grensesnitt språk",
    '__locale_is_not_defined' => "Grensesnitt språk er ikke definert.",
    '__local_server_mysql' => 'lokal MySQL server',
    '__local_server_postgresql' => 'Lokal PostgreSQL-server',
    '__local_server_mssql' => 'Lokal MS SQL server',
    '__log_and_statistics_files' => 'loggfiler og statistiske rapporter',
    '__config_files' => 'Konfigurasjonsfiler',
    '__chroot_files' => 'Chrooted miljø',
    '__login' => "%1 Logg på",
    '__login1' => "Logg på",
    '__login_disabled' => "Innlogging forbudt",
    '__login_enabled' => "Innlogging tillatt",
    '__login_incorrect' => "Du har angitt feil brukernavn eller passord.",
    '__login_name' => "%1 brukernavn",
    '__login_name_is_invalid' => "%1 brukernavn er ugyldig.",
    '__logon_time' => "Påloggingstidspunkt",
    '__ma' => "E-postaliaser",
    '__mail' => "E-post",
    '__mail_alias_name' => "E-post-aliasnavn",
    '__mail_autodiscovery' => 'E-post autosøk',
    '__mail_exchanger_name_is_invalid' => "Postutvekslernavn er ugyldig.",
    '__mail_groups' => "E-postgruppe",
    '__mail_list_engine' => "Adresselisteprogram",
    '__mail_name' => "E-postkonto",
    '__mail_name_form' => "Egenskaper for e-postkonto",
    '__mail_names' => "E-postkontoer",
    '__mail_serv' => "E-post server",
    '__mail_user' => 'E-postbruker',
    '__mailgroup' => "E-postgruppe",
    '__maillist' => "Adresseliste",
    '__maillists' => "Adresselister",
    '__maillist_member' => 'E-postlistemedlem',
    '__mailname' => "E-postkonto",
    '__mailname_redir_self' => "E-postkonto kan ikke videresende e-post til seg selv.",
    '__max_dom_num_reached_for_cl' => "Grensen for antall domener ble nådd for denne kundekontoen.",
    '__max_file_size_available' => "Maksimum tillatt filstørrelse %1",
    '__max_subdom_num_reached_for_cl' => "Grensen for antall underdomener ble nådd for denne kundekontoen.",
    '__max_subdom_num_reached_for_dom' => "Grensen for antall underdomener ble nådd for domenet.",
    '__max_subdom_num_reached_for_key' => "Grensen for antall underdomener som tillates av lisensnøkkelen ble nådd.",
    '__max_traffic_limit' => "Trafikkgrense",
    '__maximum_excl_ip_num' => "E-postkontoer",
    '__mb' => "MB",
    '__mbytes' => "megabyte",
    '__mb_month' => "MB/måned",
    '__mb_sec' => "MB/sek",
    '__gb_sec' => "GB/sek.",
    '__tb_sec' => "TB/sek",
    '__mega' => "M",
    '__minute(s)' => 'minutt(er)',
    '__mls_not_in_key' => "Produktnøkkelen din støtter ikke et flerspråklig grensesnitt.",
    '__modification_date' => "Endringsdato",
    '__module' => "Filtype",
    '__month' => "Måned",
    '__month(s)' => "Måned(er)",
    '__month1' => "Jan",
    '__month10' => "Okt",
    '__month11' => "Nov",
    '__month12' => "Des",
    '__month2' => "Feb",
    '__month3' => "Mar",
    '__month4' => "April",
    '__month5' => "Mai",
    '__month6' => "Juni",
    '__month7' => "Juli",
    '__month8' => "Aug",
    '__month9' => "Sept",
    '__monthly' => "Månedlig",
    '__months' => "Måneder",
    '__moved_permanently' => 'Flyttet permanent',
    '__mssql' => "Microsoft SQL Server",
    '__mssql__server' => "Server",
    'mssql__server' => "Microsoft SQL servernavn",
    'mssql__unable_to_change_server_name_db_exists' => "navnet på serveren kan ikke endres: det er minst en database på den.",
    '__mssql_status' => "Status for Microsoft SQL Server",
    '__multiply_login_deny' => "Kan ikke logge deg på. En annen bruker med samme brukernavn (%1) er allerede logget inn i Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "MySQL Serverstatus",
    '__mysql_version' => "Mysql versjon",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "MariaDB-serverstatus",
    '__mariadb_version' => "MariaDB versjon",
    '__percona' => "Percona",
    '__percona_status' => "Percona-serverstatus",
    '__percona_version' => "Percona versjon",
    '__name' => "Navn",
    '__name_invalid' => "Navnet er ugyldig.",
    '__nameserver' => "navneserver",
    '__network' => "Nettverk",
    '__networks' => "Nettverk",
    '__no' => "Nei",
    '__no_ip_address_with_properly_type_available' => "Kan ikke gjenopprette de sikkerhetskopierte data fordi det ikke er noen passende IP adresser som kreves for gjenoppretting.",
    '__no_clients_specified' => "Ingen kundekontoer spesifisert.",
    '__no_comments' => "Ingen kommentarer.",
    '__nologin' => "Forbudt",
    '__none' => "Ingen",
    '__not_configured' => "Ikke konfigurert",
    '__not_implemented_yet' => "Ikke implementert enda",
    '__not_supported_by_ftp' => "(ikke støttet av FTP-server)",
    '__notification' => "Varsling",
    '__num_displayed' => "%1 av %2 vises",
    '__num_is_invalid' => "Nummeret er ugyldig.",
    '__object_not_found' => 'Finner ikke objekt: %1',
    '__of_all' => "% av alle",
    '__off' => "Av",
    '__ok' => "OK",
    '__old_passwd' => "Gammelt %1 passord",
    '__on' => "På",
    '__others' => "Andre",
    '__other_ip__will_be_added' => 'Andre tilgjengelige IP-adresser (vil bli lagt til kundens IP-utvalg)',
    '__out' => "Ut",
    '__p' => "W",
    '__passwd' => "%1 Passord",
    '__passwd_is_invalid' => "%1 passordet er ugyldig.",
    '__passwd_not_match' => "Passordene samsvarer ikke!",
    '__path' => "Bane",
    '__perl_unix_support' => "Støtte for Perl",
    '__perl_win_support' => "Støtte for Perl",
    '__perm_denied' => "Ingen tilgang.",
    '__permissions' => "Tillatelser",
    '__personal_name' => "Navn",
    '__pg_admin_not_activated' => "PostgreSQL ble ikke aktivert på serverens administrasjonssiden.",
    '__pg_not_inst' => "PostgreSQL ble ikke installert.",
    '__pg_not_run_or_inst' => "PostgreSQL ble ikke installert eller kjører ikke nå.",
    '__pg_not_support_in_key' => "PostgreSQL støttes ikke av lisensnøkkelen.",
    '__phone' => "Telefon",
    '__phosting' => "Fysisk hosting",
    '__php_support' => "støtte for PHP",
    '__php_run_as_isapi' => "kjør som ISAPI-tillegg",
    '__php_safe_mode' => "PHP 'safe_mode' på",
    '__php_version' => "PHP-versjon",
    '__physical' => "Fysisk hosting",
    '__plesk_stat_pdir' => "Beskytt mappen '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Domenestatistikk",
    '__plesk_stat_protect' => "Beskytt tilgang til webstatistikk med brukerens brukernavn og passord for FTP",
    '__plesk_stat_protect_install' => "tilgang via passordbeskyttet mappe '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "POP3-Serverstatus",
    '__popen_error' => "Det oppstod en feil under kall av popen funksjonen.",
    '__port' => 'Port',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "PostgreSQL status",
    '__preferences' => "Innstillinger",
    '__account_preferences' => "Kontoinnstillinger",
    '__interface_preferences_general' => 'Generelt',
    '__interface_preferences_default' => 'Standardpreferanser for grensesnitt',
    '__interface_preferences_admin' => "Innstillinger for administratorgrensesnitt",
    '__interface_template' => 'Mal for grensesnitt tilpasning',
    '__interface_preferences' => "Grensesnitt preferanser",
    '__proceed?' => "Vil du fortsette?",
    '__protect_dir_user' => "Bruker av beskyttet mappe",
    '__protect_dir_users' => "Brukere av beskyttet mappe",
    '__provider_contact_name' => "Eierens kontaktnavn",
    '__python_unix_support' => "støtte for Python",
    '__python_win_support' => "støtte for Python",
    '__quota' => "Kvote",
    '__r' => "R",
    '__reconfigure' => "Konfigurer på nytt",
    '__record_type' => "Oppføringstype",
    '__release' => "Frigi",
    '__remote_db_not_supported_by_key' => 'Ekstern databasehosting støttes ikke av lisensnøkkelen din.',
    '__remove' => "Fjern",
    '__remove_confirmation' => "Bekreft fjerning",
    '__remove_protection' => 'Fjern beskyttelse',
    '__report' => "Rapport",
    '__report_size_na' => "Tjenesten er ikke tilgjengelig",
    '__reports_list' => "Rapporter",
    '__requested' => "Forespurt",
    '__required_fields' => "Obligatoriske felt",
    '__resp_name_invalid' => "Autosvar navnet er ugyldig. Benytt kun alfanumeriske tegn, punktum, understrekning og blanke tegn.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Servernavn er ugyldig.",
    '__screenshots' => 'Skjermbilder',
    '__script_warning' => "Ved å fjerne skriptfunksjonaliteten fra dette domenet vil alle påvirkede skript bli vist på tekstformat når de kalles opp av en nettleser. Vi råder administratoren til å fjerne alle underordnede skript fra det spesifiserte domenet.",
    '__sec' => "sekunder",
    '__second(s)' => "Sekund(er)",
    '__see_list_of_logged_in' => "Se liste over brukere som er logget på.",
    '__select_certs_to_remove' => "Velg sertifikater som skal fjernes.",
    '__select_files_to_remove' => "Velg filer som skal fjernes.",
    '__select_ip' => "Tilordne IP adresse",
    '__select_ip_to_remove' => "Velg en IP-adresse som skal fjernes.",
    '__select_domain_template' => "Bruk innstillinger for domenemal",
    '__select_templates_to_remove' => "Velg maler som skal fjernes.",
    '__server' => "Server",
    '__server_total' => "Server totalt",
    '__service' => "Tjeneste",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "MySQL databaseserver",
    '__service_description__mysql' => "MySQL databaseserver",
    '__service_title__web' => "Webserver",
    '__service_description__web' => "Webserver",
    '__service_title__smtp' => "SMTP-server",
    '__service_description__smtp' => "SMTP-server",
    '__service_title__mail' => "IMAP/POP3-server",
    '__service_description__mail' => "IMAP/POP3-server",
    '__service_title__dns' => "DNS server",
    '__service_description__dns' => "DNS server",
    '__service_title__postgresq' => "PostgreSQL databaseserver",
    '__service_description__postgresq' => "PostgreSQL databaseserver",
    '__service_title__spamassassin' => "SpamAssassin spamfiltertjeneste",
    '__service_description__spamassassin' => "SpamAssassin spamfiltertjeneste",
    '__services' => "Tjenester",
    '__all_services' => "Alle tjenester",
    '__sessions' => "Økter",
    'sessions__feature_ftp_session_manager_not_supported' => "FTP Sessions-funksjonen er ikke støttet av gjeldende FTP-server",
    '__sessions_list' => "Økter",
    '__set' => "Slå på",
    '__shared' => "Delt",
    '__shell_access_warning' => "Å tillate skalltilgang til systemet er meget farlig for systemets sikkerhet. Gi bare tilgang til systemet hvis du forstår fullt ut hva du gjør, og kun til autoriserte brukere. Vil du virkelig tillate tilgang?",
    '__siteapp_not_support_in_key' => "Webprogrammer støttes ikke av lisensnøkkelen",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Konfigurasjonen av dette webprogrammet ble endret manuelt. For å beskytte de manuelle endringene, har omkonfigurering via Plesk blitt gjort utilgjengelig.',
    '__site_management' => "Webpublisering", // indirect
    '__size' => "Størrelse",
    '__skeleton' => 'Mal for virtuell vert',
    '__skins' => 'Skall',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "SMTP-serverstatus",
    '__some_fields_are_empty_or_invalid' => "Noen påkrevede felt er tomme eller inneholder en gal verdi",
    '__unable_to_set_parameters' => "Kan ikke angi parametre for komponenten",
    '__spamassassin' => "Filter for søppelpost",
    '__spamassassin_status' => "SpamAssassin status",
    '__spamd_status' => 'Spamfilter status',
    '__splited_backup' => "(multivolum sikkerhetskopi)",
    '__split_backup_file' => "Opprett en multivolum sikkerhetskopi",
    '__split_backup_size' => "Volumstørrelse",
    '__split_backup_less_than_500' => "Volumstørrelser på mindre enn 500 megabytes støttes ikke",
    '__ssi' => "SSI",
    '__ssi_support' => "SSI-støtte",
    '__ssi_with_html' => "Bruk SSI for *.htm, *.html filer",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "SSL/TLS-støtte",
    '__same_ssl' => "Bruk en enkel mappe for å oppbevare SSL/TLS- og ikke-SSL/TLS-innhold",
    '__same_ssl_cu' => "Felles SSL/TLS og ikke-SSL/TLS innhold",
    '__state' => "Område",

    '__status__Active' => 'Aktiv',
    '__status__active' => 'aktiv',
    '__status__Passive' => 'Slått av',
    '__status__passive' => 'slått av',
    '__status__off' => 'slått av',
    '__status__with_parent' => 'slått av',
    '__status__backup_restore' => 'midlertidig avstengt for sikkerhetskopiering eller gjenoppretting',
    '__status__admin' => 'deaktivert av serveradministrator',
    '__status__resseler' => 'suspendert av forhandler',
    '__status__client' => 'suspendert av kunde',
    '__status__unknown' => 'Status er ukjent',

    '__status_of' => "Status for %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Stunnel-server", // indirect
    '__subdomain' => "Subdomene",
    '__subdomain_name' => "Underdomene-navn",
    '__subdomain_name_in_ASCII_form' => "Underdomene-navn i ASCII-formatet",
    '__subdomains' => "Underdomener",
    '__domainaliases' => "Domenealiaser",
    '__subdomains_list' => "Underdomener",
    '__subdomains_not_support_in_key' => "Operasjoner på underdomene støttes ikke av lisensnøkkelen",
    '__sys_user_type' => "FTP -bruker",
    '__sys_user_type_main' => "Bruk FTP brukerkontoen til hoveddomenet",
    '__sys_user_type_native' => "Opprett en separat FTP-brukerkonto for dette underdomene",
    '__t' => "T",
    '__target_domain' => "Måldomene",
    '__template' => "Mal",
    '__template_not_accepted' => "Kan ikke godta malen: følgende begrensninger er overskredet.",
    '__templates' => "Maler",
    '__templates_list' => "Maler",
    '__tera' => "T",
    '__title' => "Tittel",
    '__tools' => "Verktøy",
    '__total' => "Totalt %1",
    '__total_size' => "Samlet størrelse",
    '__total_used' => "Totalt benyttet",
    '__traffic' => "Trafikk",
    '__traffic_by_client' => "Trafikk etter kunde",
    '__traffic_by_domain' => "Trafikk etter domene",
    '__traffic_by_service' => "Trafikk etter tjeneste",
    '__traffic_history' => "Trafikkhistorie",
    '__unable_change_locale' => "Kan ikke endre grensesnitt språket: %1",
    '__unable_create_new_dom' => "Kunne ikke opprette en domene: %1",
    '__unable_define_dom_name' => "Kunne ikke definere domenenavn: %1",
    '__unable_define_necessary_properties' => "Kan ikke definere alle påkrevede brukeregenskaper.",
    '__unable_define_properties' => "Kan ikke definere egenskaper: %1",
    '__unable_exec_util' => "Kan ikke kjøre verktøyet: %1",
    '__unable_get_dns_a_recs' => "Kunne ikke hente IP-adresser for A DNS-oppføringer for denne hostingkontoen: %1",
    '__unable_get_mbox_quota' => "Kan ikke hente frem informasjon om grensen for postboksstørrelsen.",
    '__unable_redirect_to_myself' => "Kan ikke videresende til samme konto.",
    '__unable_redirect_to_my_alias' => "Kan ikke videresende e-post til e-postalias.",
    '__default_domain_redirect_to_myself' => "Kunne ikke sette domene som standard for IP-adresse:\nredirigering til den selv er oppdaget.",
    '__unable_remove_client' => "Kan ikke fjerne kunde: %1",
    '__unable_set_up_mbox_quota' => "Kunne ikke sette grense for postboksstørrelse for domenet: %1",
    '__unable_setup_pass' => "Kan ikke sette passord: %1",
    '__unable_to_create_new_account' => "Kan ikke opprette konto: %1",
    '__unable_to_define_db_size' => "Kan ikke definere databasestørrelse.",
    '__unable_to_enable_short_names' => "Kan ikke tillate bruk av korte e-postkontonavn for POP3-konto.",
    '__unable_to_fetch_data_from_submit' => "Kan ikke få tak i innsendte data: %1",
    '__unable_to_open_file' => "Kan ikke åpne filen %1: %2",
    '__unable_to_update_subdomain' => "Kan ikke foreta endringer i underdomenet: %1",
    '__unable_update_cl_data' => "Kan ikke lagre endringer på brukerkonto: %1",
    '__unable_update_db_params' => "Kan ikke oppdatere databaseparametere: %1",
    '__unable_update_dom_data' => "Kunne ikke oppdatere domenedata: %1",
    '__undefined' => "ikke definert",
    '__uninstall' => "Avinstaller",
    '__unknown_error' => "Ukjent feil",
    '__unlimited_lower' => "Ubegrenset",
    '__unset' => "Slå av",
    '__update' => "Oppdater",
    '__uploaded_file_is_invalid' => "Den opplastede filen er ugyldig: %1",
    '__url' => "URL",
    '__usage' => "Diskbruk",
    '__user' => 'Bruker',
    '__user_already_logged' => "En annen bruker med samme brukernavn (%1) er allerede logget inn i Plesk.",
    '__version' => "Versjon",
    '__aps_license' => "Lisensnøkkel",
    '__vh_type' => "Virtuell vertstype",
    '__vhosts_apache_status' => "Web-server status",
    '__wrong_charset_conversion' => 'Feil tegnsett, konvertering fra "%1" til "%2" er ikke tillatt',
    '__warning_' => "Advarsel!",
    '__warning_excl_ip_num' => "Dedikert IPadresse",
    '__warning_expiration' => "Utløpsdato",
    '__web_scripting' => "Webskripting", // indirect
    '__web_serv' => "Webserver", // indirect
    '__web_statistic' => "Web statistikk", // indirect
    '__webmail' => "Webmail", // +indirect
    '__webstat_not_installed' => "Webalizer er ikke installert på serveren. Ta kontakt med tjenesteleverandør for assistanse med installasjon av Webalizer.",
    '__webstat_support' => "Web statistikk",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Når du skifter fra et statistikkprogram til et annet, vil alle rapporter som er opprettet av det tidligere brukte statistikkprogrammet bli slettet og nye rapporter opprettes i samsvar med informasjon lest fra loggfiler som oppbevares på serveren. Dette betyr at hvis du konfigurerte systemet (på Domener > domenenavn > Logghåndterer > Loggrotasjon) til å kun beholde loggfiler for den siste måneden, vil webstatistikk kun være tilgjengelig for den siste måneden. Vil du til bytte til en annen statistikkpakke?",
    '__webstat_perm_denied' => 'Du ikke har tillatelse til behandle webstatistikk.',
    '__webuser' => "Webbruker",
    '__sysusers_list' => "Systembrukere",
    '__sysuser' => "Systembruker",
    '__weekly' => "Ukentlig",
    '__whats_new_in_version' => "Hva er nytt i Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Denne operasjonen er kun tilgjengelig for domener med webhosting.",
    '__wrong_hosting_type__none' => 'Det er ingen webhosting konfigurert på domene %1.',
    '__wrong_hosting_type__std_fwd' => 'Domenet %1 har standard viderekobling konfigurert. Denne operasjonen er kun tilgjengelig for domener med webhosting.',
    '__wrong_hosting_type__frm_fwd' => 'Domene %1 har videresending av rammer konfigurert. Denne operasjonen er kun tilgjengelig for domener med webhosting.',
    '__wu' => "Webbrukere",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "WWW prefikset ble endret. Sørg for å modifisere SSL/TLS-sertifikat også.",
    '__year' => "År",
    '__year(s)' => "År",
    '__yes' => "Ja",
    '__you' => "Du",
    '__zip_code' => "Postnummer",
    '__form_normal' => "Normal",
    '__form_advanced' => "Avansert",

    'admin_ed__edit_administrator_info' => "Rediger Administratorprofil",
    'admin_ed__create_default_client' => "Jeg vil gjerne opprette en standard kundekonto.",
    'admin_ed__unable_update' => "Kan ikke oppdatere administratorinformasjon: %1",

    'auth__update_admin_info' => "Skriv inn administratorinformasjon. Denne informasjonen kreves for å utføre %1.",
    'auth__you_not_have_perm' => "Du har ikke tillatelse til å behandle dette domenet.",
    'auth__key_expired_admin' => 'Din Plesk-lisens er utløpt. For å fortsette med å bruke Plesk, forny lisensen din eller kjøp en ny.',
    'auth__key_expired_admin_restricted' => 'Din Plesk-lisens er utløpt. Kontakt din tjenestetilbyder for å fortsette med å bruke Plesk.',
    'auth__key_expired_client' => 'Lisensen for Plesk er utløpt. Vennligst ta kontakt med hostingleverandøren din.',
    'autoinstaller__not_installed' => 'Autoinstaller komponent er ikke installert.',
    'autoinstaller__release_action' => 'Tilgjengelige operasjoner',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Oppgraderer til ny Plesk-versjon',
    'autoinstaller__release_action_update' => 'Oppdatering eller legge til nytt komponent',
    'autoinstaller__release_action_up2date' => 'Du har en oppdatert versjon',
    'autoinstaller__component_action' => 'Status',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Ikke installert',
    'autoinstaller__component_action_update' => 'Oppdateringer er tilgjengelig',
    'autoinstaller__component_action_upgrade' => 'En oppdatering er tilgjengelig',
    'autoinstaller__component_action_up2date' => 'Du har en oppdatert versjon',
    'autoinstaller__component_action_error' => 'Oppdateringer er ikke tilgjengelige',
    'autoinstaller__component_serverbuildtime' => 'Nyeste utgave',
    'autoinstaller__component_localbuildtime' => 'Din utgave',
    'autoinstaller__component_installed_version' => 'Din versjon',
    'autoinstaller__component_available_version' => 'Siste Versjon',
    'autoinstaller__component' => 'Komponent',
    'autoinstaller__components' => 'Komponenter',
    'autoinstaller__components_title' => '%1 komponenter',
    'autoinstaller__component_dependency_note' => 'obligatorisk for installasjon av komponentene du valgte',
    'autoinstaller__install_confirm' => 'Ja, jeg vil installere disse komponentene',
    'autoinstaller__install_confirm_request' => 'Velg avmerkingsboks for å bekrefte',
    'autoinstaller__install_title' => 'Bekreft installasjon av de valgte komponentene',
    'autoinstaller__key_update_confirm' => 'Bekreft at du hopper over nøkkeloppdatering og installerer standardnøkkel',
    'autoinstaller__key_update_confirm_request' => 'Velg avmerkingsboks for å bekrefte.',
    'autoinstaller__key_update_failed' => '<p>Plesk kunne ikke oppdatere produktlisensen din.</p><p>%1</p><p>Å fortsette med oppgraderingen uten å ha en egnet produktlisens vil føre til installasjon av en standardlisens med begrenset funksjonalitet. Administratorer anbefales å først få tak i riktig lisensnøkkel før dere fortsetter med produktoppgraderingen.</p>',
    'autoinstaller__email' => 'Send melding til',
    'autoinstaller__email_admin' => "Administrators e-post",
    'autoinstaller__email_email' => 'Brukerdefinert epostadresse...',
    'autoinstaller__release' => 'Utgavens navn',
    'autoinstaller__releases' => 'Tilgjengelige utgaver',
    'autoinstaller__releases_title' => 'Plesk oppdateringsprogram',
    'autoinstaller__select_components_to_install' => 'Velg komponentene som skal installeres',
    'autoinstaller__status_error' => 'Feil: %1',
    'autoinstaller__status_install_error' => 'Installasjonen kan ikke startes: %1',
    'autoinstaller__status_install_busy' => 'Installasjonen kan ikke påbegynnes: en annen installasjonsprosess kjører nå.',
    'autoinstaller__status_install_ok' => 'Installasjonen har startet. Du vil bli varslet om installasjonsfremdriften i e-post (%1).',
    'autoinstaller__status_query_busy' => 'Installasjonen pågår.',
    'autoinstaller__status_query_error' => 'Kan ikke hente installasjonens status: %1',
    'autoinstaller__status_unknown' => 'Kan ikke hente statusen for autoinstaller.',
    'autoinstaller__status_busy' => 'Autoinstaller er opptatt, vennligst vent.',
    'autoinstaller__configure_title' => 'Oppdateringsinnstillinger',
    'autoinstaller__preferences_legend' => 'Innstillinger',
    'autoinstaller__target' => 'Midlertidig nedlastingsmappe.',
    'autoinstaller__target_invalid' => "Angi absolutt bane",
    'autoinstaller__check_updates' => 'Søk etter oppdateringer på administratorlogg til Plesk',
    'autoinstaller__check_updates_warning' => 'Nye <a href="%1">oppdateringer</a> er tilgjengelige for %2',
    'autoinstaller__source_type' => 'Kildetype',
    'autoinstaller__source' => 'Kilde-URL',
    'autoinstaller_source__preferences_legend' => 'Innstillinger',
    'autoinstaller_source__type' => 'Kildetype',
    'autoinstaller_source__url_invalid' => 'Ugyldig kilde',
    'autoinstaller_source__url_invalid_network' => 'Ugyldig URL-adresse for kilde (Eksempel: http://kilde, ftp://kilde)',
    'autoinstaller_source__url' => 'Kilde-URL',
    'autoinstaller__source_invalid_network' => 'Du oppga en ugyldig nettverksadresse',
    'backup__repository' => 'Lager for sikkerhetskopifiler',
    'backup__error_notify_email' => 'Hvis feil oppstår under sikkerhetskopiering, send varsel på e-post',
    'backup__dump_info' => "Sikkerhetskopiinformasjon",
    'backup__dump_file_name_not_defined' => "Sikkerhetskopi filnavn er ikke angitt",
    'backup__local_file' => 'Lokal sikkerhetskopi fil',
    'backup__domain_ftp' => 'ekstern FTP-server',
    'backup__wrong_path' => "Feilaktig bane til lagret for sikkerhetskopi filer: Bruk ikke sekvensen av tegn ../../",
    'backup__unable_to_connect_to_ftp_server' => "Kan ikke koble til FTP-server: %1",
    'backup__unable_to_read_file' => 'Kan ikke lese sikkerhetskopifilen.',
    'backup__backup_task_does_not_exist' => "Sikkerhetskopieringsoppgave finnes ikke, du bør opprette den før du slår på.",
    'backup__restore_params' => "Parametere for gjenoppretting",
    'backup__confirmation' => "Advarsel: domenet vil ikke være tilgjengelig under sikkerhetskopiering/gjenoppretting.",
    'backup__backup_method' => 'Metode for sikkerhetskopiering',
    'backup__dumpfile_name' => "Sikkerhetskopi filnavn",
    'backup__dumpfile_name_is_invalid' => "Filnavnet for sikkerhetskopien er ugyldig: benytt kun alfanumeriske tegn, bindestrek, punktum og understrekingstegn, bruk ikke navn som description.* som et filnavn på en sikkerhetskopi.",
    'backup__email_required' => "Din e-postadresse er nødvendig for å kunne holde deg informert om sikkerhetskopierings- og gjenopprettingsframdrift. Angi e-postadressen din i kontodetaljene.",
    'backup__error_during_backup' => "Kan ikke opprette sikkerhetskopi filen: %1",
    'backup__input_email_warning' => "Du bør enten angi e-post for varsling eller fjerne haken i avmerkingsboksen.",
    'backup__make_download' => "ikke lagre sikkerhetskopien i et lager, bare last den ned",
    'backup__make_dump' => 'opprett sikkerhetskopi fil og lagre i lokalt lager',
    'backup__makedump_to_ftp' => 'opprett sikkerhetskopi og lagre på ekstern FTP-server',
    'backup__restore_ip' => "IP adresse for gjenoppretting",
    'backup__select_dumpfile' => "Velg en sikkerhetskopifil.",
    'backup__time' => "Tid for sikkerhetskopi",
    'backup__day' => 'Reservekopieringdag',
    'backup__view_dump_info' => "Vis informasjon om sikkerhetskopi for domene %1",
    'backup__wrong_domain_name' => "Sikkerhetskopien inneholder data for domene %1 og kan derfor ikke gjenopprettes for domene %2",
    'backup__incorrect_ftp_user_or_passwd' => "Feil FTP-bruker eller passord. Korriger egenskaper for FTP-konto.",
    'backup__access_denied' => "Tilgang nektet. Korriger egenskaper for FTP-konto.",
    'backup__restore_from' => "Gjenopprett %1",
    'backup__domain_session_failed' => 'Domene %1 ble ikke sikkerhetskopiert',
    'backup__client_session_failed' => 'Kunde %1 ble ikke sikkerhetskopiert',
    'backup__domain_session_restore_failed' => 'Domene %1 ble ikke gjenopprettet',
    'backup__client_session_restore_failed' => 'Kundekonto %1 ble ikke gjenopprettet',
    'backup__domain_session_complete' => 'Domene %1 ble sikkerhetskopiert',
    'backup__domain_session_backup' => 'Sikkerhetskopi av domene %1',
    'backup__client_session_backup' => 'Sikkerhetskopi av kunde %1',
    'backup__domain_stop_title' => 'Avbryter sikkerhetskopiering av domene %1',
    'backup__client_stop_title' => 'Avbryter sikkerhetskopiering av kundekonto %1',
    'backup__domain_restore_stop_title' => 'Avbryter gjenoppretting av domene %1',
    'backup__client_restore_stop_title' => 'Avbryter gjenoppretting av kundekonto %1',
    'backup__domain_session_backup_stop' => 'Du er i ferd med å avbryte en aktiv sikkerhetskopieringsprosess. Sikkerhetskopifilen vil ikke bli opprettet.',
    'backup__backup_stop_confirm' => 'Ja, jeg vil stoppe sikkerhetskopi prosessen.',
    'backup__restore_stop_confirm' => 'Ja, jeg vil stoppe sikkerhetskopi prosessen',
    'backup__domain_session_restore' => 'Gjenoppretting av domene %1',
    'backup__domain_session_restore_stop' => 'Du er i ferd med å avbryte en aktiv gjenopprettingsprosess.',
    'backup__domain_backup_file_info' => 'Informasjon om sikkerhetskopi av domene',
    'backup__domain_backup_file_list' => 'eksisterende sikkerhetskopi filer',
    'backup__domain_backup_progress' => 'Fremdrift av sikkerhetskopiering av nettsted %1',
    'backup__domain_restore_progress' => 'Fremdrift for gjenoppretting av nettsted %1',
    'backup__domain_backup_progress_elapsed_time' => 'Tidsforbruk: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Tidsforbruk: %1',
    'backup__domain_restore_session_complete' => 'Domene %1 er gjenopprettet.',
    'backup__domain_restore_session_complete_message' => 'Domene %1 ble gjenopprettet.',
    'backup__domain_backup_file_delete' => 'Følgende sikkerhetskopi filer blir fjernet:',
    'backup__domain_backup_file_for_remove' => 'Velg sikkerhetskopifilen du ønsker å fjerne',
    'backup__backup_overwrite_file_confirm' => 'Bekreftelse av utskifting',
    'backup__backup_overwrite_file_confirm_text' => 'En sikkerhetskopi fil med navnet "%1" finnes allerede. Vil du erstatte den?',
    'backup__backup_confirm_overwrite' => 'Bekreft utskifting av fil',
    'backup__backup_overwrite_legeng' => 'Erstatt',
    'backup__backup_not_contain_domain' => 'Sikkerhetskopien inneholder ikke informasjon om domene %1',
    'backup__backup_not_contain_client' => 'Sikkerhetskopier inneholder ikke informasjon om kundekonto %1',
    'backup__backup_client_info' => "Sikkerhetskopier kundens innstillinger og kontodetaljer",
    'backup__client_backup_progress' => 'Fremdrift for sikkerhetskopiering av kundekonto %1',
    'backup__client_session_complete' => 'Kundekonto %1 er sikkerhetskopiert',
    'backup__client_backup_file_info' => 'Informasjon om kundens sikkerhetskopi',
    'backup__restore_client_info' => "Gjenopprett kundens innstillinger og kontodetaljer",
    'backup__client_session_restore' => 'Gjenoppretter kundekonto %1',
    'backup__client_db_server_map' => 'Kartlegging av databaseserver',
    'backup__domain_db_server_map' => 'Kartlegging av databaseserver',
    'backup__client_restore_session_complete_message' => 'Kundekonto %1 ble gjenopprettet.',
    'backup__client_restore_session_complete' => 'Kundekonto %1 ble gjenopprettet.',
    'backup__restore_select_some' => 'Velg objektene du ønsker å gjenopprette.',
    'backup__client_restore_progress' => 'Fremdrift for gjenoppretting av kundekonto %1',
    'backup__new_backup' => 'Oppretter ny sikkerhetskopi',
    'backup__done' => 'Fullført:',
    'backup__done_domains' => '%1 domene(r) av %2',
    'backup__done_clients' => '%1 kunde(r) av %2',
    'backup__remaining' => 'Gjenstående:',
    'backup__remaining_domains' => '%1 domene(r)',
    'backup__remaining_clients' => '%1 kunde(r)',
    'backup__overall_backup_progress' => 'Samlet sikkerhetskopi fremdrift',
    'backup__comment_n_a' => 'i/t',
    'backup__command_ignore' => 'Kommando "%1" ignoreres',
    'backup__no_objects' => 'det finnes ingen objekter å ta sikkerhetskopi av',
    'backup__cli_warning_not_enough_ip' => 'ADVARSEL: ikke nok IP adresser til å utføre standard IP tilordning:',
    'backup__local_repository' => "Plesks lager",
    'backup__ftp_repository' => 'FTP lager',
    'backup__ftp_login' => 'Brukernavn',
    'backup__ftp_password' => 'Passord',
    'backup__ftp_account_settings' => 'FTP kontoinnstillinger.',
    'backup__ftp_account_preferences' => 'FTP kontoinnstillinger',
    'backup__repository_not_exist' => 'Katalogen eksisterer ikke',
    'backup__repository_not_readable' => 'Den angitte mappen kan ikke leses',
    'backup__ftp_repository_not_configure' => 'For å bruke FTP-lagring av sikkerhetskopier, <a href="%1">må du først angi FTP-kontoen</a>',
    'backup__ftp_repository_list_not_configure' => 'Kontoinnstillinger ble ikke oppgitt',
    'backup__repository_list_unable_listing' => 'Kan ikke hente liste over filer',
    'backup__ftp_repository_unable_listing' => 'Kan ikke hente liste over mappen "%1":',
    'backup__repository_legend' => 'Sikkerhetskopifiler',
    'backup__store_in_repository' => 'Lager filer i',
    'backup__local_repository_lable' => 'Lokalt lager',
    'backup__ftp_repository_lable' => 'FTP lager',
    'backup__ftp_repository_not_configure_hint' => '(kontoinnstillinger ble ikke oppgitt)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(FTP-konto er ikke oppgitt eller ikke støttet)',
    'backup__other_user_process_modified' => 'En annen bruker har stoppet sikkerhetskopi- eller migrasjons prosessen.',
    'backup__another_user_exist' => 'Operasjonen som pågår ble startet av en annen Plesk-bruker. Denne brukeren er fremdeles logget inn på Plesk.',
    'backup__ftp_repository_wait' => 'Vennligst vent mens informasjon om FTP-lageret hentes',
    'backup__ftp_write_test_failed' => 'Skriving av testdata mislyktes til FTP-konto %1:',
    'backup__ftp_storage' => 'FTP(S)-lagring',
    'bt_upload_to_repository' => 'Last opp filer til lokalt lager',
    'bt_new_restore' => "Gjenopprett",
    'bt_backup_schedule' => "Sikkerhetskopi av tidsplan",
    'backup_exist_backups' => "Eksisterende sikkerhetskopi filer",
    'backup_dialog__page_title' => "Etablering av sikkerhetskopifil.",
    'backup_dialog__please_wait' => "Sikkerhetskopi prosessen er i ferd med å starte. Denne operasjonen kan ta litt tid. Vent litt...",
    'backup_conf__page_title' => 'Konfigurering av sikkerhetskopiering',
    'bt_accept' => "Godta",
    'bt_access' => "Tilgang",
    'bt_action_log' => "Handlingslogg",
    'bt_add' => "Legg til",
    'bt_add_client' => "Tilordne til brukere",
    'bt_database_server_add' => 'Legg til databaseserver',
    'bt_add_services' => "Legg til tjenester",
    'bt_anonftp_stats' => "Anon.FTP Statistikk",
    'bt_anonymous_ftp' => "Anonym FTP",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Legg ved",
    'bt_autoinstaller' => 'Oppdaterer',
    'bt_auto-updates' => 'Oppdaterer',
    'bt_back' => "<< Tilbake",
    'bt_backup' => "Sikkerhetskopier",
    'bt_backup_configure' => "Innstillinger for sikkerhetskopiering",
    'bt_buy_certs' => "Kjøp sertifikater",
    'bt_card' => "Kort",
    'bt_cert' => "Sertifikat",
    'bt_certificates' => "Sertifikater",
    'bt_change_passwd' => "Endre passord",
    'bt_clear' => "Klar",
    'bt_client_templates' => "Kundemaler",
    'bt_clients' => "Kunder",
    'bt_codepage_change' => 'Endre koding',
    'bt_comp_info' => "Komponent administrasjon",
    'bt_configure_maillists' => "Definer Mailman",
    'bt_configure' => 'Konfigurer',
    'bt_copy' => "Kopier",
    'bt_copy_move' => "Kopier/flytt",
    'bt_create' => "Opprett",
    'bt_create_account' => "Opprett en konto",
    'bt_create_dir' => "Legg til en mappe",
    'bt_create_file' => "Legg til fil",
    'bt_count_size' => "Beregn størrelse",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Oppgaveplanlegging",
    'bt_custom_button_new' => "Legg til en knapp",
    'bt_custom_buttons' => "Egendefinerte knapper",
    'bt_customize' => "Tilpass",
    'bt_databases' => "Databaser",
    'bt_database_servers' => 'Databaseservere',
    'bt_sqlservers' => "Databaseservere",
    'bt_db_usr_new' => "Legg til en databasebruker",
    'bt_db_new' => "Legg til en database",
    'bt_db_phpmyadmin' => "MySQL Admin",
    'bt_dbuser_default' => "Gjør til standard for DB Webadmin",
    'bt_decline' => "Avslå",
    'bt_default' => "Standard",
    'bt_defaultcomponents' => "Tredjeparts tjenester",
    'bt_defaults' => "Standarer",
    'bt_delete' => "Slett",
    'bt_directories' => "Beskyttede mapper",
    'bt_disable' => "Slå av",
    'bt_dns_zone_sync' => 'Aktiver endringer i DNS mal',
    'bt_dnsrecord_add' => 'Legg til post',
    'bt_do_backup' => "Sikkerhetskopier",
    'bt_do_restore' => "Gjenopprett",
    'bt_do_upload' => "Last opp",
    'bt_domain_aliases' => "Domenealias",
    'bt_domain_templates' => "Domenemaler",
    'bt_domain_user' => "Domeneadministrator",
    'bt_domain_user_passwd' => "Passord for domeneadministrator",
    'bt_domains' => "Domener",
    'bt_domain_alias_add' => 'Legg til domenealias',
    'bt_download' => "Last ned",
    'bt_edit' => "Rediger",
    'bt_enable' => "Slå på",
    'bt_export' => 'Eksporter',
    'bt_extras' => "Tillegg",
    'bt_finish' => "Fullfør",
    'bt_ftp_account' => "Egenskaper for FTP-konto",
    'bt_forget_password' => "Har du glemt passordet?",
    'bt_fp_ssl_webadmin' => "FP-SSL/TLS Webadmin",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "FTP Statistikk",
    'bt_get_password' => "Få passord",
    'bt_global_changes' => "Endre",
    'bt_help' => "Hjelp",
    'bt_hide_aliases' => "Skjul aliaser",
    'bt_hide_toolbar' => 'Skjul verktøylinje',
    'bt_hide_subdomains' => "Skjul underdomener",
    'bt_hide_domainaliases' => "Skjul domenealias",
    'bt_home' => "Hjem",
    'bt_hosting' => "Hosting",
    'bt_icf' => 'Brannmur',
    'bt_install' => "Installer",
    'bt_ip_aliasing' => "IP-adresser",
    'bt_ip_add' => "Legg til IP adresse",
    'bt_ip_pool' => "IP-utvalg",
    'bt_key_info' => "Lisensinformasjon",
    'bt_key_buyonline_addons' => 'Bestill Plesk-tillegg',
    'bt_key_buyonline_upgrades' => 'Bestill Plesk-oppgraderinger',
    'bt_key_buyonline_new' => 'Bestill ny nøkkel',
    'bt_limits' => "Grenser",
    'bt_locale_add' => 'Legg til nasjonal innstilling',
    'bt_locales' => 'Nasjonale innstillinger',
    'bt_log_manager' => "Logg administrator",
    'bt_login' => "Logg på",
    'bt_logo' => "Profilering",
    'bt_logo_send_link' => "Vedlegg kobling",
    'bt_logo_send_logo' => "Vedlegg logo",
    'bt_logout' => "Logg av",
    'bt_logrotation' => "Logg rotasjon",
    'bt_mail' => "E-post",
    'bt_mail_alias_add' => "Legg til e-postalias",
    'bt_mail_aliases' => "E-postaliaser",
    'bt_mail_group_add' => "Legg til medlem",
    'bt_mail_groups' => "Grupper",
    'bt_mail_name_add' => "Legg til e-postkonto",
    'bt_mail_preferences' => "Innstillinger",
    'bt_mail_group' => "E-postgruppe",
    'bt_mail_mailbox' => "Postboks",
    'bt_mail_redirect' => "Videresender",
    'bt_mail_resp_add' => "Legg til autosvar",
    'bt_mail_resp_attach_add' => "Legg til vedlegg",
    'bt_mail_resp_files' => "Vedleggsfiler",
    'bt_mail_responders' => "Autosvar",
    'bt_mail_spamfilter' => "Filter for søppelpost",
    'bt_mail_webmail' => "Webmail",
    'bt_maillist_new' => "Legg til adresseliste",
    'bt_maillists' => "Adresselister",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Opprett sikkerhetskopi",
    'bt_manage' => "Administrer",
    'bt_master' => "Hoved",
    'bt_migrate' => 'Overfør',
    'bt_modules_add' => 'Legg til utvidelse',
    'bt_modules_manage' => 'Administrer utvidelser',
    'bt_move' => "Flytt",
    'bt_mimetypes' => 'MIME-typer',
    'bt_mimetype_new' => 'Legg til MIME-type',
    'bt_new_client' => "Legg til kundekonto",
    'bt_new_domain' => "Legge til domene",
    'bt_next' => "Neste >>",
    'bt_next_page' => "Neste",
    'bt_network_add' => "Legg til nettverk",
    'bt_notifications' => "Varslinger",
    'bt_off' => "Av",
    'bt_on' => "På",
    'bt_on_off' => "Av/på",
    'bt_pd_new' => "Legg til beskyttet mappe.",
    'bt_pd_user_new' => "Legg til bruker",
    'bt_performance' => 'Ytelse',
    'bt_permissions' => "Tillatelser",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Innstillinger",
    'bt_prev_page' => "Forr.",
    'bt_preview' => 'Forhåndsvisning av område',
    'bt_print' => "Skriv ut",
    'bt_reboot' => "Starte på nytt",
    'bt_reload' => "Last inn på nytt",
    'bt_refresh' => "Oppdater",
    'bt_register' => "Registrer",
    'bt_remove' => "Fjern",
    'bt_enable_selected' => 'Slå på',
    'bt_disable_selected' => 'Slå av',
    'bt_repair_ip' => "Reparer IP",
    'bt_report' => "Rapport",
    'bt_report_new' => "Legg til layout",
    'bt_reset' => "Tilbakestill",
    'bt_restart_services' => "Tjenestebehandling",
    'bt_save' => "Lagre",
    'bt_send_by_email' => "Send som e-post",
    'bt_send_file' => "Send fil",
    'bt_send_mail' => "Send post",
    'bt_send_passwd' => "Send passord",
    'bt_send_text' => "Send tekst",
    'bt_server' => "Server",
    'bt_server_add' => "Legg til server",
    'bt_server_preferences' => "Serverinnstillinger",
    'bt_servers_list' => "Servere",
    'bt_sessions' => "Økter",
    'bt_set' => "Angi",
    'bt_set_as_default' => "Angi som standard",
    'bt_setup' => 'Oppsett',
    'bt_show_aliases' => "Vis aliaser",
    'bt_show_subdomains' => "Vis underdomener",
    'bt_show_domainaliases' => "Vis domenealias",
    'bt_shutdown' => "Slå av",
    'bt_site_apppkgs' => "Programhvelv",
    'bt_site_apppool' => "Programutvalg",
    'bt_application-pool' => "Web Applikasjoner",
    'bt_site_apps' => "Web Applikasjoner",
    'bt_site_app_add' => "Installer applikasjon",
    'bt_site_builder' => "Støtte for Presence Builder",
    'bt_skeleton' => 'Mal for virtuell vert',
    'bt_skins' => 'Skall',
    'bt_skin_add' => 'Legg til tema',
    'bt_skin_manual' => 'Brukerdefinert Plesk skallreferanse', // not used
    'bt_skin_download' => 'Last ned skin',
    'bt_skin_replace' => 'Oppdater skin',
    'bt_skip' => 'Hopp over',
    'bt_spamassassin' => "Filter for søppelpost",
    'bt_spamassassin_train' => "Opplæring",
    'bt_spamfilter' => "Filter for søppelpost",
    'bt_start' => "Start",
    'bt_stop' => "Stopp",
    'bt_recycle' => "Resirkuler",
    'bt_statistics' => "Statistikk",
    'bt_subdomain_new' => "Legg til underdomene",
    'bt_subdomains' => "Underdomener",
    'bt_submit' => "Send",
    'bt_summary_report' => "Oppsummeringsrapport",
    'bt_support' => "Støtte",
    'bt_switch' => "Switch",
    'bt_system_time' => "Systemtid",
    'bt_task_new' => "Legg til oppgave",
    'bt_dom_tmpl_add' => 'Legg til domenemal',
    'bt_cl_tmpl_add' => 'Legg til kundemal',
    'bt_cron_backup' => 'Innstillinger for planlagte sikkerhetskopieringer',
    'bt_test' => "Test tilkobling",
    'bt_text' => "Tekst",
    'bt_touch' => "Endre tidsstempel",
    'bt_traffic' => "Trafikk",
    'bt_traffic_history' => "Trafikkhistorie",
    'bt_update' => "Oppdater",
    'bt_upload' => "Last opp",
    'bt_upload_from_ftp' => "FTP opplasting",
    'bt_virtualdirs' => 'Virtuelle mapper',
    'bt_virtualdir_new' => 'Legg til virtuell mappe',
    'bt_virtualdir_add' => 'Legg til virtuell mappe',
    'bt_web_app_new' => "Installer Java-program",
    'bt_web_stats' => "Webstatistikk",
    'bt_web_stats_ssl' => "WebStats SSL/TLS",
    'bt_web_user_add' => "Legg til webbruker",
    'bt_web_users' => "Nettbrukere",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Se full liste over endringer",
    'cert_add__unable_set_ca_cert' => "Kan ikke sette CA-sertifikat: %1",
    'cert_add__unable_set_cert' => "Kan ikke sette sertifikat: %1",
    'cert_add__unable_set_private_key' => "Kunne ikke sette den private nøkkelen: %1",
    'certificates_list__certificate_used_as_default' => "Ett av sertifikatene du er i ferd med å slette er i bruk som Standard sertifikat.",
    'certificates_list__certificates_assigned_on_ip' => "ett eller flere sertifikater er tildelt IP-adressene/domenene.",
    'ch_pass__admin_pass' => "Endre administratorpassordet",
    'ch_pass__old_pass' => "Gammelt passord",
    'ch_pass__pass_confirm' => "Bekreft",
    'ch_pass__unable_change_admin_pass' => "Kan ikke endre administratorpassordet: %1",
    'check_mail_cycle__aliases' => "E-postløkke er oppdaget, adressen \"%1\"  finnes i aliaser til denne e-postkontoen.",
    'check_mail_cycle__autoresponders' => "E-postløkke er oppdaget, adressen \"%1\" finnes i autosvaret til denne e-postkontoen.",
    'check_mail_cycle__mail_groups' => "E-postløkke er oppdaget, adressen \"%1\" finnes i e-postgruppen til denne e-postkontoen.",
    'check_mail_cycle__mail_name' => "E-postløkke er oppdaget, adressen \"%1\" samsvarer med denne e-postkontoen.",
    'check_mail_cycle__redirect' => "E-postløkke er oppdaget, adressen \"%1\" samsvarer med videresendingsadresse for denne e-postkontoen.",
    'check_mail_dup__redirect' => "Duplikat videresender er oppdaget, adressen \"%1\" samsvarer med videresendingsadresse av denne e-postkontoen.",
    'check_mail_dup__mail_groups' => "Duplikat videresender er oppdaget, adressen \"%1\" finnes i e-postgruppe av denne e-postkontoen.",
    'check_maillist_cycle__admin' => "E-postløkke er oppdaget, administrators e-post \"%1\" samsvarer med adressen til en adresseliste.",
    'check_maillist_cycle__member' => "E-postløkke er oppdaget, adressen \"%1\" samsvarer med adressen til en adresseliste.",
    'chk_js__enter_login_and_passwd' => "Skriv inn brukernavn og passord.",
    'chk_js__enter_login_name' => "Skriv inn brukernavn.",
    'chk_js__enter_passwd' => "Skriv inn passord.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "%1's kontodetaljer",
    'cl_limits__cl' => "Kunde %1s grenser",
    'cl_logo__setup_logo_pref' => "Sett logoegenskaper for kunde %1",
    'cl_new__enter_new_cl_data' => "Angi informasjon om ny kunde",
    'cl_new__unable_to_sent_notification' => 'Brukerkonto ble opprettet, men sending av varsel til kunden mislyktes: %1',
    'cl_perm__all_ip' => "Alle tilgjengelige IP'er",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Alle IP-baserte hostingkontoer for kunden vil bli overført til navnebasert.",
    'cl_perm__allow_client_create_domain' => "Feltene du prøver å velge gjelder bare for kunder som har lov til å opprette domener.",
    'cl_perm__allow_create_nb_w_ip' => "Kunden kan opprette navnebasert hosting ved hjelp av %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Tillat opprettelse av IP-baserte hostingkontoer",
    'cl_perm__available_ips' => "Tilgjengelige IP'er",
    'cl_perm__change_limits' => "Justering av grenser",
    'cl_perm__cl_disk_space' => "Total diskplass tilgjengelig",
    'cl_perm__cl_expiration' => "Gyldighetsperiode for kundekonto",
    'cl_perm__cl_max_box' => "Postbokser",
    'cl_perm__cl_max_db' => "Databaser",
    'cl_perm__cl_max_dom' => "Domener",
    'cl_perm__cl_max_maillists' => "Adresselister",
    'cl_perm__cl_max_subdom' => "Underdomener",
    'cl_perm__cl_max_traffic' => "Total tilgjengelig mengde trafikk",
    'cl_perm__cl_max_wu' => "Webbrukere",
    'cl_perm__cl_mbox_quota' => "Størrelsesgrensen for postboksen for denne brukerkontoen",
    'cl_perm__current_maximum_exp_date' => "Den gjeldende maksimalverdien for domenets gyldighetsperiode er %1; forespurt %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Den gjeldende definerte grensen for tilordnet diskplass for postbokser for denne brukerkontoen er %1; forespurt %2",
    'cl_perm__current_total_requested' => "Gjeldende totalverdi for domenegrensene for %1 er %2; forespurt %3.",
    'cl_perm__current_total_requested_dom' => "Gjeldende antall %1 som tilhører denne kunden er %2; forespurt %3.",
    'cl_perm__disk_space' => "maksimal størrelse av diskplass",
    'cl_perm__dashboard_stdgui' => 'Brukergrensesnitt',
    'cl_perm__dashboard' => 'Hjemmeside visning',
    'cl_perm__stdgui' => 'Standardvisning',
    'cl_perm__manage_dashboard' => 'Administrasjon av hjemmeside',
    'cl_perm__dashboard_and_stdgui' => 'Hjemmeside visning og standard visning er tillatt',
    'cl_perm__dashboard_only' => 'Kun hjemmeside visning er tillatt',
    'cl_perm__stdgui_only' => 'Kun standard visning er tillatt',
    'cl_perm__edit_cl' => "Tillatelser for kunde %1",
    'cl_perm__exp_date_exceeded' => "Den gyldighetsperioden du prøver å sette overskrider grensen angitt for individuelle domener relatert til denne kunden.",
    'cl_perm__invalid_value' => "Ugyldig verdi, kun tall er tillatt.",
    'cl_perm__limit_disk_space' => "%1 Begrenser maksimal størrelse av diskplass",
    'cl_perm__limit_expiration' => "%1 Begrens gyldighetsperioden for kundekontoen",
    'cl_perm__limit_max_box' => "%1 Begrenser maksimalt antall postbokser",
    'cl_perm__limit_max_db' => "%1 Begrens maksimalt antall av databaser",
    'cl_perm__limit_max_dom' => "%1 Begrens maksimalt antall domener",
    'cl_perm__limit_max_maillists' => "%1 Begrens maksimalt antall av adresselister",
    'cl_perm__limit_max_subdom' => "%1 Begrenser maksimalt antall underdomener",
    'cl_perm__limit_max_traffic' => "%1 Begrenser maksimal mengde trafikk",
    'cl_perm__limit_max_wu' => "%1 Begrens maksimalt antall av webbrukere",
    'cl_perm__limit_mbox_quota' => "%1 Setter kvoten for postboks",
    'cl_perm__limits_exceeded' => "Én eller flere av de grensene du prøver å sette er allerede overskredet av grensene som er definert innenfor de individuelle domenene som tilhører denne kunden.\nTotalgrensen for kunden må være større eller lik den totale summen av domenegrenser definert for denne kundekontoen.",
    'cl_perm__mailbox_quota_exceeded' => "Grensen for diskplassmengden tildelt for de postboksene du prøver å sette overskrider grensene definert innen individuelle domener relatert til denne kundekontoen.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Begrensning for datamengde tilordnet for postbokser du er prøver å sette opp overstiger begrensning satt på servernivå.",
    'cl_perm__make_dumps' => "Sikkerhetskopier og gjenopprett data",

    'cl_perm__max_box' => "maksimalt antall postbokser",
    'cl_perm__max_db' => "maksimalt antall databaser",
    'cl_perm__max_dom' => "domener",
    'cl_perm__max_maillists' => "maksimum antall adresselister",
    'cl_perm__max_subdom' => "underdomener",
    'cl_perm__max_traffic' => "maksimal mengde trafikk",
    'cl_perm__max_wu' => "maksimalt antall web-brukere",
    'cl_perm__max_dom_aliases' => "domenealiaser",
    'cl_perm__mbox_quota' => "postkasse kvote",
    'cl_perm__not_allow_create_nb_hst' => "Kunden kan ikke opprette navnebasert hosting.",
    'cl_perm__this_ip_used_vrt_hst' => "Denne IP-adressen brukes av virtuell hosting.\nFor å slette denne IP-adressen, fjern hostingtjenesten eller endre typen til navnebasert.",
    'cl_perm__unable_off_ipb_creating' => "Kunden har allerede IP-basert hostingtjeneste satt opp. For å deaktivere denne funksjonen for kunden, ta bort krysset for \"Opprettelse av domene\" eller fjern alle IP-baserte hostingkontoer.",
    'cl_perm__unable_off_nb_creating' => "Kunden har allerede en navnebasert hostingtjeneste satt opp. For å deaktivere denne funksjonen for kunden, ta bort krysset for \"Opprettelse av domene\" eller fjern alle navnebaserte hostingkontoer.",
    'cl_perm__unable_set_domain_limit' => "Kunne ikke begrense maksimalt antall domener: kunde har allerede %1 domener",
    'cl_perm__unable_update_client_limitations' => "Kunne ikke modifisere grenser for kundekonto: %1",
    'cl_pref__edit_cl' => "Kunde %1s preferanser",
    'class_anonftp__create_ftp_domain' => "Ingen virtuelle FTP-domener for dom_id, prøv å opprette det først.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Diskplassgrensen du prøver å sette (%1) bør ikke overskride total displassgrense definert ved domenenivå (%2).",
    'class_anonftp__invalid_input_only_digits' => "Ugyldig verdi angitt, kun tall er tillatt.",
    'class_anonftp__unable_change_ownerships' => "Kan ikke endre eier eller tillatelser for kvotefilen: %1",
    'class_anonftp__unable_copy_quota_file' => "Kan ikke kopiere kvotefilen: %1",
    'class_anonftp__unable_get_disk_usage' => "Kan ikke hente informasjon om diskbruk på den innkommende mappen: %1",
    'class_anonftp__unable_parse_quota_file' => "Kan ikke analysere kvotefilen.",
    'class_anonftp__unable_read_quota_file' => "Kan ikke lese kvotefilen: %1",
    'class_anonftp__unable_update_quota' => "Kan ikke oppdatere kvoten: filene i den innkommende mappen bruker %1 kB diskplass, som overskrider den nye kvoteverdien.",
    'class_anonftp__unable_write_temp_file' => "Kan ikke skrive til den midlertidige filen: %1",
    'class_bsdomain__warn_max_date__' => "Utløpsdatoen ble satt til %1",
    'class_cList__empty' => "Ingen elementer.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Ingen matcher funnet for <b>\"%1\"</b> i %2 (%3 av %4).",
    'class_cList__search_result' => "Søkeresultat for <b>\"%1\"</b> i %2 (%3 av %4).",
    'class_client__client_creation_notification' => "Varsel om kundeopprettelse.",
    'class_client__client_with_contact_name_already_exists' => "Kunde med navnet %1 finnes allerede.",
    'class_client__disk_space' => "Diskplass",
    'class_client__invalid_max_dom' => "Ugyldig verdi for antall domener, kun tall er tillatt.",
    'class_client__limit_exceed' => "Forespurt mengde %1 kan ikke tildeles fordi dette vil overskride tildeling for kunde %2s konto (%3). Hvis du ønsker å tildele flere ressurser, gå til Kunder > kundenavn > Grenser og endring av tildeling etter behov. Gå tilbake til denne skjermen og prøv å justere tildelingene på nytt.",
    'class_client__limit_exceed_unlimited' => "Hvis du ønsker å tildele ubegrenset antall ressurser (%1), du bør først gå til Kunder > kundenavn > Grenser, og sette kryss for Ubegrenset for ønsket ressurstype. Gå tilbake til denne skjermen og prøv å justere tildelingene på nytt.",
    'class_client__max_box' => "Postbokser",
    'class_client__max_db' => "Databaser",
    'class_client__max_maillists' => "Adresselister",
    'class_client__max_subdom' => "Underdomener",
    'class_client__max_traffic' => "Maksimal trafikk",
    'class_client__max_wu' => "Webbrukere",
    'class_client__max_dom_aliases' => "Domenealiaser",
    'class_client__mbox_quota' => "Postkasse kvote",
    'class_client__unable_define_cl_status' => "Kunne ikke definere status for kundekonto: %1",
    'class_client__unable_define_inactive_dom' => "Kunne ikke definere deaktiverte domener %1.",
    'class_client__unable_del_ip' => "Kan ikke fjerne IP'er: %1",
    'class_db__db_name_not_set' => "Databasenavn er ikke definert.",
    'class_db__db_not_exist_for_curr_dom' => "Databasen finnes ikke for dette domenet.",
    'class_db__invalid_db_or_dom_name' => "Domene eller database-ID er ugyldig eller databasenavn er ikke definert.",
    'class_db__invalid_pass' => "Passordet er ugyldig.",
    'class_db__mailgrp_member_exist' => "E-postgruppe-medlemmet finnes allerede.",
    'class_db__access_hosts_notsupport' => 'Tilgangsvertsinnstillinger er ikke støttet for denne databasetypen.',
    'class_db__unable_add' => 'Kunne ikke legge til oppføring på tilgangsvert: %1',
    'class_db__unable_del' => 'Kunne ikke slette oppføring på tilgangsvert: %1',
    'class_db__inc_user_not_exist' => 'Database bruker "%1" finnes ikke',
    'class_db__inc_access_record_exist' => 'Denne tilgangsoppføringen finnes allerede.',
    'class_db__inc_access_record_not_exist' => 'Oppgitt tilgangsoppføring finnes ikke',
    'class_db__inc_unable_del_last_record' => 'Kunne ikke slette siste oppføring på tilgangsvert',
    'class_domtmpleditform__dns_master' => "Primær",
    'class_domtmpleditform__dns_slave' => "Sekundær",
    'class_domtmpleditform__dns_type' => "Type DNS-sone for domene",
    'clienttrafficlist_header' => "Trafikk på domener",
    'clienttrafficlist_header_of_client__' => "Trafikk på domenene til kunde %1",
    'cmd_dns__a_dns_record_already_exist' => "A-oppføringen vil komme i konflikt med limposten for sonen.",
    'cmd_dns__domain_last_ns' => 'Kan ikke slette den siste NS DNS-oppføringen for domenet.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Kanonisk domenenavn er ugyldig.",
    'cmd_dns__cname_dns_record_already_exist' => "CNAME-oppføringen vil komme i konflikt med limposten for sonen.",
    'cmd_dns__cname_in_rr_combination' => 'Feil kombinasjon av DNS-oppføringer er til stede i DNS-sonen',
    'cmd_dns__cname_coexist_with_data' => 'CNAME DNS-soneoppføring kan ikke eksistere samtidig med andre DNS-oppføringer i den samme sonen.',
    'cmd_dns__dns_record_type_is_invalid' => "DNS-oppføring type er ugyldig.",
    'cmd_dns__ext_host_is_not_resolved' => "Det kanoniske navnet %1 er ikke løst til en A- eller AAAA-oppføring.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Kan ikke legge oppføringen %1 til sone %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Postutvekslernavn er ugyldig.",
    'cmd_dns__mx_priority_is_invalid' => "MX-prioritet er ugyldig.",
    'cmd_dns__name_server_is_invalid' => "Navneserver er ugyldig.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Nettverksmaske verdien skal være 24, 16 eller 8.",
    'cmd_dns__this_dns_record_already_exists' => "En slik DNS oppføring finnes allerede.",
    'cmd_dns__unable_add_record' => "Kan ikke legge til '%1' oppføring: %2",
    'cmd_dns__unable_add_a_record' => "Kan ikke legge til A oppføring: %1",
    'cmd_dns__unable_add_cname_record' => "Kan ikke legge til CNAME oppføring: %1",
    'cmd_dns__unable_add_dns_record' => "Kan ikke legge til DNS oppføring: %1",
    'cmd_dns__unable_add_ext_ns_record' => "Kan ikke legge til EXT_NS oppføring: %1",
    'cmd_dns__unable_add_ns_record' => "Kan ikke legge til NS oppføring: %1",
    'cmd_dns__unable_add_ptr_record' => "Kan ikke legge til PTR oppføring: %1",
    'cmd_dns__unable_add_txt_record' => "Kan ikke legge til PTR oppføring: %1",
    'cmd_dns__unable_create_dns_zone' => "Klarte ikke opprette DNS-sone %1",
    'cmd_dns__unable_define_dns_record' => "Kan ikke definere DNS oppføringen: %1",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Klarte ikke å hente status for standard DNS-sone: %1",
    'cmd_dns__unable_insert_a_record' => "Kan ikke sette inn A oppføring: %1",
    'cmd_dns__unable_insert_mx_record' => "Kan ikke sette inn MX oppføring: %1",
    'cmd_dns__unable_insert_ns_record' => "Kan ikke sette inn NS oppføring: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Klarte ikke å sette status for DNS-sone: %1",
    'cmd_domains__dom_already_exists' => "Domenet %1 finnes allerede.",
    'cmd_domains__dns_record_already_exists' => "Kunne ikke opprette domene %1 fordi en DNS-oppføring som peker på vert %1 finnes allerede.",
    'cmd_domains__dom_already_exists1' => "Det finnes %2 underdomener i dette domenet. Domene %1 finnes allerede.",
    'cmd_domains__dom_already_exists2' => "underdomene %1 finnes fra før.",
    'cmd_domains__dalias_already_exists' => "Dette alias finnes allerede.",
    'cmd_domains__domain_alias_already_exists' => 'Et domenealias med dette navnet finnes allerede.',
    'cmd_domains__unable_del_mail_for_dom' => "Klarte ikke å slette eposttjenester for domene: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Klarte ikke å slette anonym FTP-konto for domene: %1",
    'cmd_domains__unable_update_dom_param' => "Klarte ikke å oppdatere domeneparametere: %1.",
    'cmd_domains__unable_rename_client_exist' => "domeneadministratorens brukernavn er allerede i bruk.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Hostingtype er ikke fysisk.",
    'cmd_hosting__unable_create_user' => "Kan ikke skape bruker %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Kan ikke definere IP adresse for de navnebaserte virituelle vertene: %1",
    'cmd_hosting__unable_del_old_hst' => "Klarte ikke å slette tidligere oppsatt hosting: %1",
    'cmd_hosting__unable_del_protected_directory' => "Kan ikke slette den beskyttede mappen : %1.",
    'cmd_hosting__unable_del_web_user' => "Kan ikke slette webbruker: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Klarte ikke å opprette eller oppdatere virtuell vert: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Klarte ikke å sette opp hosting med videresending av ramme.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Kan ikke gjenoppbygge proftpd konfigurasjonsfilen: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Kan ikke sette opp SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Kan ikke fjerne beskyttelse fra SSL/TLS-mappen: %1",
    'cmd_hosting__unable_update_dest_url' => "Kan ikke oppdatere destinasjons URL %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Klarte ikke å oppdatere DNS-sone for domenet: kjøring av nytteprogram mislyktes.",
    'cmd_hosting__unable_update_ftp_passwd' => "Kan ikke oppdatere FTP-passord %1.",
    'cmd_hosting__unable_update_user' => "Kan ikke oppdatere bruker %2: %1",
    'cmd_hosting__unknown_hst_type' => "Ukjent hostingtype.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Du har ikke tillatelse til å avslutte hostingtjenesten.",
    'cmd_mail__autoresponder__not_configured' => "Autosvar for denne e-postkontoen er ikke konfigurert",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Adresse %1 er allerede i bruk for videresending av e-post.",
    'cmd_mail__alias_already_exists' => "alias finnes allerede.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "Autosvar-ID og e-postkonto-ID matcher ikke.",
    'cmd_mail__autoresp_id_is_undefined' => "Udefinert autosvar ID.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Et e-postalias med dette navnet finnes allerede for e-postkontoen %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "E-postkonto %1 abonnerer allerede på denne adresselisten.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Epostkonto %1 finnes allerede i dette domenet.",
    'cmd_mail__mail_name_not_exist' => "E-postkontoen finnes ikke.",
    'cmd_mail__mail_name_passwd_part' => "Passordet bør ikke inneholder e-postkontonavnet.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Adresseliste %1 finnes allerede på dette domenet.",
    'cmd_mail__mailname_already_exist_in_mg' => "E-postkonto %1 er allerede i en e-postgruppe.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Epostkonto %1 finnes allerede i dette domenet.",
    'cmd_mail__mailname_already_exists' => "E-postkonto finnes allerede",
    'cmd_mail__mailname_is_invalid' => "E-postkontonavn %1 er ugyldig.",
    'cmd_mail__mailname_unable_update' => "Kan ikke oppdatere e-postkontoens egenskaper:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Maksimalt antall automatiske besvarelser ble nådd for dette domenet.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Maksimalt antall epostgrupper ble nådd for dette domenet.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Maksimalt antall videresendinger ble nådd for dette domenet.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Maksimalt antall postbokser ble nådd.",
    'cmd_mail__no_members_specified' => "ingen medlemmer er angitt.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Passordet er for enkelt, velg et annet.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "E-postadressen er allerede i bruk.",
    'cmd_mail__unable_define_autoresp_id' => "Kan ikke definere autosvar ID %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Kunne ikke endre innstillinger for eposttjeneste for domene %1",
    'cmd_mail__unable_del_mail_for_dom' => "Klarte ikke å fjerne eposttjenesten fra domene %1.",
    'cmd_mail__unable_del_mail_redirection' => "Klarte ikke å fjerne tjeneste for videresending av epost %1.",
    'cmd_mail__unable_remove_autoresp' => "Kan ikke fjerne autosvar: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Kan ikke fjerne e-postgruppemedlemmer: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Feilet å slå av e-postgruppe: %1",
    'cmd_mail__unable_update_mail_redirect' => "Kunne ikke omkonfigurere tjeneste for videresending av epost %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Opplastet filstørrelse er for stor.",
    'cmd_mail__additionally' => "I tillegg:",
    'cmd_pd__invalid_login' => "Feil brukernavn.",
    'cmd_pd__this_user_already_exist' => "Denne brukeren finnes allerede.",
    'cmd_pd__unable_define_hst_type' => "Klarte ikke å definere hostingtype.",
    'cmd_pd__unable_upd_pd_usr' => "Kan ikke oppdatere beskyttet mappe brukeregenskaper: %1.",
    'cmd_pd__user_is_undefined' => "Brukeren er ikke definert.",
    'cmd_server__no_enough_free_disk_space' => "Ikke nok diskplass.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "gammelt passord er feil. Vennligst prøv igjen.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "maksimalt antall webbrukere er nådd for dette domenet.",
    'cmd_web_usr__unable_create_user' => "Kan ikke opprette systembruker: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Kan ikke definere maksimal webbrukergrense: %1",
    'cmd_web_usr__user_already_exists' => "Brukeren finnes allerede.",
    'cmd_web_usr__web_user_name_is_invalid' => "Webbrukernavn %1 er ugyldig.",
    'cmd_web_usr__web_user_not_exist' => "webbruker finnes ikke.",
    'common_func__exec_bad_argument' => "exec argumentet skal ikke inneholde tegnet enkelt anførselstegn.",
    '__eol' => 'Linjeskift',
    'eol__binary_file' => 'Kan ikke endre linjeskift stilen i binær fil.',
    'cp_access_admin_deny' => "Tilgang for administrator fra adresse '%1' er begrenset i henhold til gjeldende policy for IP-tilgangsbegrensning.",
    'create_domain_warn__' => "Følgende unntak ble gjort under opprettelse av domene:",
    'create_domain__client_select' => 'Velg kunden du vil opprette domene for',

    'dashboard__nav_button_name' => "Hjem",
    'dalias__list_title' => 'Domenealias for domene %1',
    'dalias__list_legend' => 'Domenealiaser',
    'dalias__list_header' => 'Domenealiaser',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Navn på domenealias',
    'dalias__list_ascii_name' => 'I ASCII format',
    'dalias__remove_title' => 'Følgende domenealias for domene %1 vil bli fjernet:',
    'dalias__select_domain_aliases_to_remove' => 'Velg domenealias som skal fjernes.',
    'dalias__mail_turn_on_failed' => 'Kunne ikke slå på eposttjeneste: %1',
    'dalias__web_turn_on_failed' => 'Kunne ikke slå på webtjeneste: %1',
    'db_usr_edit__db_usr_name_old' => "Gammel databasebrukernavn",
    'database_server_edit_form__cannot_infer_type' => 'Kan ikke utlede tilkoblingsmetode fra angitt data. Angi «127.0.0.1» som databaseserververt for å koble til over TCP/IP med angitt port, eller la portfeltet være tomt for å bruke Unix-socket «%1».',
    'database_server_edit_form__duplicate' => 'En databaseserver med denne kombinasjonen av vertsadresse og portnummer er allerede registrert.',
    'database_server_edit_form__host_is_invalid' => 'Det angitte vertsnavnet er ugyldig.',
    'database_server_edit_form__port_is_invalid' => 'Det angitte portnummeret er ugyldig.',
    'database_server_error__consult_admin' => 'Kontakt server-administrator.',
    'database_server_error__last__connection_failed' => 'Siste forsøk på å kontrollere denne databaseserveren mislyktes på grunn av nettverksproblemer.',
    'database_server_error__last__permission_denied' => 'Siste forsøk på å kontrollere denne databaseserveren mislyktes fordi angitt konto ikke har administrative rettigheter.',
    'database_server_error__last__credentials_not_set' => "Det siste forsøket på å koble til denne serveren mislyktes fordi det ikke ble angitt gyldig brukernavn og passord for en administrator.",
    'database_server_error__last__other_error' => 'Siste forsøk på å kontrollere denne databaseserveren mislyktes.',
    'database_server_error__real__connection_failed' => 'Tilkobling til databaseservere har mislyktes på grunn av nettverksproblemer:',
    'database_server_error__real__permission_denied' => 'Tilkobling til databaseservere har mislyktes fordi angitt konto ikke har administrative rettigheter:',
    'database_server_error__real__duplicate_object' => 'Tilkobling til databaseservere har mislyktes på grunn av navnekonflikt:',
    'database_server_error__real__unacceptable_name' => 'Tilkobling til databaseservere har mislyktes på grunn av ugyldig objektnavn:',
    'database_server_error__real__unacceptable_password' => 'Tilkobling til databaseservere har mislyktes på grunn av uakseptabelt passord:',
    'database_server_error__real__credentials_not_set' => "Plesk kan ikke koble til databaseserveren fordi det ikke ble spesifisert gyldig brukernavn og passord for en administrator.",
    'database_server_error__real__other_error' => 'Tilkobling til databaseserveren mislyktes:',
    'database_server_error__test__connection_failed' => 'Testtilkoblingen til databaseservere har mislyktes på grunn av nettverksproblemer:',
    'database_server_error__test__permission_denied' => 'Testtilkoblingen til databaseservere har mislyktes fordi angitt konto ikke har administrative rettigheter:',
    'database_server_error__test__duplicate_object' => 'Testtilkoblingen til databaseservere har mislyktes på grunn av navnekonflikt:',
    'database_server_error__test__unacceptable_name' => 'Testtilkoblingen til databaseservere har mislyktes på grunn av ugyldig objektnavn:',
    'database_server_error__test__unacceptable_password' => 'Testtilkoblingen til databaseservere har mislyktes på grunn av uakseptabel passord:',
    'database_server_error__test__credentials_not_set' => "Testtilkoblingen til denne serveren mislyktes fordi det ikke ble angitt gyldig brukernavn og passord for en administrator.",
    'database_server_error__test__other_error' => 'Testtilkobling til databaseserveren mislyktes:',

    'db__create_new_db' => "Legg til en database",
    'db__db_add' => "Legg til database",
    'db__db_for_dom' => "Databaser av nettsted %1",
    'db__db_id_undefined' => "Database-ID er udefinert.",
    'db__db_name' => "Databasenavn",
    'db__db_not_exist' => "Databasen finnes ikke.",
    'db__db_type' => "Type",
    'db__db_server' => "Databaseserver",
    'db_server_not_exist' => "Databaseserver finnes ikke.",
    'db__db_user_not_exist' => "Database bruker finnes ikke.",
    'db__domain_not_exist' => "Domenet finnes ikke.",
    'db__enter_db_name' => "Skriv inn nytt databasenavn.",
    'db__invalid_db_id' => "Databaseidentifikator er ugyldig.",
    'db__invalid_db_name' => "Databasenavn er ugyldig. Databasenavn bør inneholder bare latinske alfabetsymboler, siffer, understrekingstegn eller bindestrek. Den kan ikke være lenger enn 63 tegn.",
    'db__max_db_reached_for_dom' => "Grensen for antall databaser er nådd for dette domenet.",
    'db__max_mssql_db_reached_for_dom' => "Grensen for antall Microsoft SQL Server-databaser er nådd for dette domenet",
    'db__postgres_not_connect_for_admin' => "Kan ikke koble til PostgreSQL. Slå på PostgreSQL-støtte på serverens administrasjonsside.",
    'db__postgres_not_connect_for_client' => "Kan ikke koble til PostgreSQL. Kontakt systemadministrator for å få hjelp.",
    'db__remove_db_on_domain' => "Følgende databaser under nettsted %2 som eies av kunde %1 vil bli fjernet:",
    'db__remove_db_on_domain_of_cl' => "Følgende databaser for domene %2 eid av kunde %1 vil bli fjernet:",
    'db__remove_db_linked_resource' => 'Databasen er i bruk av et webprogram. Den kan kun fjernes etter avinstallering av dette webprogrammet.',
    'db__remove_db_users' => "Følgende brukere av database %3 under nettstedet %2 som eies av kunde %1 vil bli fjernet:",
    'db__remove_db_users_of_cl' => "Følgende brukere av database %3 under nettstedet %2 som eies av kunde %1 vil bli fjernet:",
    'db__select_db_for_remove' => "Velg databaser som skal fjernes.",
    'db__select_db_users_for_remove' => "Velg databasebrukere som skal fjernes.",
    'db__unable_create_db_user' => "Kan ikke opprette databasebruker: %1",
    'db__unable_define_db_name' => "Kan ikke definere databasenavn: %1",
    'db__unable_define_db_user' => "Kan ikke definere databasebruker: %1",
    'db__unable_define_db_users' => "Kan ikke definere databasebrukere: %1",
    'db__unable_select_dom_name' => "Klarte ikke å velge domenenavn: %1",
    'db_edit__db_for_dom' => "Brukere for database %1 på domene %2",
    'db_edit__invalid_db_name' => "Databasenavn er ugyldig.",
    'db_edit__no_users' => "Det er ingen brukere med påloggingsinformasjon for denne databasen.",
    'db_edit__unable_define_db_usrs' => "Kan ikke definere databasebrukere: %1",
    'db_edit__unable_select_db_usr' => "Kan ikke velge databasebruker.",
    'db_edit__db_user_password_for_' => "Skriv inn passordet for å logge inn som databasebruker. %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Legg til databasebruker.",
    'db_usr_edit__db_usr_name' => "Databasebrukernavn",
    'db_usr_edit__edit_db_usr' => "Sett opp påloggingsinformasjon for databasebrukerkonto",
    'db_usr_edit__for_db' => "i %1 database",
    'db_usr_edit__not_create_pass' => "Denne operasjonen vil resultere i opprettelse av en databasebrukerkonto uten passord.\nØnsker å opprette en bruker uten å tildele et passord?",
    'dbuser__only_one_user_can_be_default' => "Bare en bruker kan settes som standard.",
    'db_server__cannot_delete_default' => "Standard databaseservere kan ikke slettes.",
    'db_server__cannot_delete_local' => "Den lokale databaseserveren kan ikke slettes.",
    'db_server__cannot_delete_used' => 'En databaseserver kan ikke slettes mens det finnes databaser eller databasebrukere som hostes på den.',
    'demo__disabled_in_demo' => "Denne operasjonen støttes ikke av programmet i demo versjonen.",
    'defaultcomponents__title' => "Velger standard komponenter",
    'defaultcomponents__select_default' => "Velg standard %1 komponent",//to check
    'defaultcomponents__not_installed' => "(ikke installert)",
    'defaultcomponents__not_configured' => "(ikke konfigurert)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Noen tjenestekategorier inneholder ugyldige valg, eller ingen valg ble gjort.",
    'defaultcomponents__depends_on' => "(krever %1)",
    'defaultcomponents__parameters' => "Parametere for %1",
    'component_name__antivirus' => "Antivirus",
    'component_name__database' => "SQL-server",
    'component_name__sqladmin' => "MySQL Webadmin",
    'component_name__sqladminmysql' => "MySQL Webadmin",
    'component_name__dnsserver' => "DNS-server",
    'component_name__firewall' => "Brannmur",
    'component_name__ftpserver' => "FTP-server",
    'component_name__java' => "Java",
    'component_name__mailserver' => "eposttjener",
    'component_name__local_mailserver' => "Lokal e-posttjener",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Webskripting",
    'component_name__spamfilter' => "Filter for søppelpost",
    'component_name__stats' => "Webstatistikk",
    'component_name__stunnel' => "SSL/TLS Wrapper",
    'component_name__webmail' => "Webmail",
    'component_name__webpublish' => "Webpublisering",
    'component_name__webserver' => "Webserver",
    'dns__dns_record_invalid_values' => 'Gale DNS oppføringsverdier ble angitt: %1: %2',
    'dns__dns_record_not_found' => 'DNS-oppføring ikke funnet',
    'dns__dns_zone_invalid_values' => 'Feil parametere for DNS-sone ble angitt.',

    'dns__soa_mname_title' => 'Primær navneserver',
    'dns__soa_mname_legend' => 'Navneserver',
    'dns__soa_mname_autoselect' => '(Automatisk valg)',

    'dns__dns_zone_off_remove_title' => "Følgende ressursoppføringer blir fjernet fra sone %1:",
    'dns__dns_zone_master_remove_title' => "Fjern ressursoppføringer fra DNS-sone %1",
    'dns__dns_zone_slave_remove_title' => "Følgende primære navneserveroppføringer for %1 blir fjernet:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Skriv inn oppføringsstrengen.',
    'dns_add__is_spf_syntax' => 'SPF oppføring',
    'dns_add__spf_value_is_invalid' => "SPF oppføringens verdi er feil, den må starte med 'v=spf'",
    'dns__dns_zone_status' => "Status for DNS-sone.",
    'dns__invalid_ip_address' => "IP-adressen for den nye primære DNS-serveren er ugyldig eller tom.",
    'dns__ip_address' => "IP-adresse",
    'dns__master_dns_type' => "er en primær DNS-server",
    'dns__masters' => "primære DNS-servere",
    'dns__soa_minimum_too_large' => 'Bufring av negative svar for mer enn tre timer anbefales ikke.',
    'dns__select_masters_to_remove' => "Velg primære DNS-servere som skal fjernes.",
    'dns__select_template_record_to_remove' => 'Velg DNS-mal post som skal fjernes.',
    'dns__nameservers_for_domain' => "Navneservere for domenet",
    'dns__remove_dns_zone_of_domain__' => "Fjerning av DNS-oppføringer fra domene %1",
    'dns__remove_dns_zone_template__' => "Følgende DNS oppføringer blir fjernet fra malen:",
    'dns__remove_this_dns_record?' => "Er du sikker du ønsker å fjerne denne DNS-oppføringen?",
    'dns__restore_default' => "Gjenoppretting av DNS-sone etter mal",
    'dns__restore_default_confirm' => "Gjenoppretting av DNS-sone vil fjerne aktiv konfigurasjon for DNS-sone. Fortsette likevel?",
    'dns__restore_default_error' => "Feil ved gjenoppretting av DNS-sone:",
    'dns__slave_dns_type' => "er en sekundær DNS-server",
    'dns__subdomain_dns_rec_removed' => "A-oppføringen ble fjernet fra underdomene sone %1.",
    'dns__zone_switched_off_no_ns' => "Sonen var slått av fordi det ikke finnes noen NS oppføring %1, som må være tilstede i sonen. For å legge til oppføringen i sonen, klikk på Add Record knappen.",
    'dns__cant_switch_on_no_ns' => "Sonen kan ikke slås på fordi det ikke finnes noen NS oppføring %1, som må være tilstede i sonen. For å legge til oppføringen i sonen, klikk på Add Record knappen.",
    'dns__unable_activate/deactivate_dns' => "Kan ikke aktivere/deaktivere DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Kan ikke legge til primær DNS-server: duplikatoppføring.",
    'dns__unable_add_dns_master_local_ip' => "Kan ikke legge til IP-adresse for primær DNS-server: denne oppføringen må opprettes på en ekstern server.",
    'dns__unable_define_dns_record' => "Kan ikke definere DNS oppføringen: %1",
    'dns__unable_get_dns_template_status' => "Kan ikke hente statusen for DNS malen.",
    'dns__unable_remove_dns_rec' => "Kan ikke fjerne DNS oppføringen: %1",
    'dns__warnings__' => "Resultatet av modifisering av DNS-sone:",
    'dns__you_not_have_perm_manage_dns' => "Du har ikke tillatelse til å administrere DNS-sonen for dette domenet.",
    'dns__cant_create_record_with_server_ip' => "Kan ikke legge til denne IP-adresse fordi den matcher IP-adresse til denne Plesk-administrerte serveren.",

    'dns__tabs_acl' => "Sone overføringer",
    'dns__acl_add_network_legend' => "Legg til nettverk",
    'dns__acl_add_ip_legend' => "Legg til IP adresse",
    'dns__acl_network_not_allowed' => "Denne nettverksadressen tillates ikke av DNS i Windows.",
    'dns__acl_enter_ip_address_with_mask' => "IP adresse/maske",
    'dns__acl_enter_ip_address' => "IP-adresse",
    'dns__acl_list_network_legend' => "Nettverk har tillatelse til å motta en kopi av DNS-sone",
    'dns__acl_list_ip_legend' => "IP-adresser har tillatelse til å motta en kopi av DNS-sone",
    'bt_dns_acl_add_network' => "Legg til nettverk",
    'bt_dns_acl_add_ip' => "Legg til IP adresse",

    'dns_add__add_rec_for_zone' => "Legg til %1 for sone %2",
    'dns_add__canonical_dom_name_is_invalid' => "Kanonisk domenenavn er ugyldig.",
    'dns_add__enter_canonical_name' => "Kanonisk navn",
    'dns_add__enter_dom_name' => "Domenenavn",
    'dns_add__enter_ip_address' => "IP-adresse",
    'dns_add__enter_ip_mask' => "IP adresse og nettverksmaske",
    'dns_add__enter_mail_domain' => "Epostdomene",
    'dns_add__enter_mail_exchanger' => "Postutvekslingsserver",
    'dns_add__enter_nameserver' => "Navneserver",
    'dns_add__enter_txt_record' => "TXT oppføring",
    'dns_add__enter_service_name' => "Tjenestenavn",
    'dns_add__hint_service_name' => "Eksempel: SIP (uten symbol for understrekning)",
    'dns_add__enter_protocol' => "Protokoll",
    'dns_add__hint_protocol_name' => "Eksempel: TCP (uten symbol for understrekning)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Prioritet",
    'dns_add__specify_weight_of_service' => "Relativ vekt for oppføringer med samme prioritet",
    'dns_add__enter_target_host' => "Målvert",
    'dns_add__hint_target_host' => "Eksempel: eksempel.com",
    'dns_add__enter_target_port' => "Målport",
    'dns_add__caa_tag' => "Tagg",
    'dns_add__caa_value' => "Verdi",
    'dns_add-invalid-A_ip' => "IP adressen er ugyldig.",
    'dns_add-invalid-AAAA_ip' => "IP adressen er ugyldig.",
    'dns_add-invalid-PTR_ip_mask' => "Ugyldig IP adresse/ nettmaske par.",
    'dns_add-invalid-SRV_service_name' => "Ugyldig servernavn",
    'dns_add-invalid-SRV_protocol_name' => "Ugyldig protokoll",
    'dns_add-invalid-SRV_target_port' => "Ugyldig målport",

    'dns_add__invalid_ip' => "IP adressen er ugyldig.",
    'dns_add__low' => "lav",
    'dns_add__mail_dom_name_is_invalid' => "Navn på epostdomene er ugyldig.",
    'dns_add__nameserver_is_invalid' => "Navneserver er ugyldig.",
    'dns_add__record' => "%1 oppføring",
    'dns_add__select_prefer_for_mail_exchange_server' => "Angi prioritet for postutvekslingsserver",
    'dns_add__unable_insert_new_dns_rec' => "Kan ikke sette inn ny DNS oppføring: %1",
    'dns_add__very_high' => "svært høy",
    'dom_ctrl__allowed' => "Tillatt",
    'dom_ctrl__db' => "MySQL databaser",
    'dom_ctrl__mssql_db' => "MS SQL-databaser",
    'dom_ctrl__disk_space' => "Diskplass",
    'dom_ctrl__dom_adm' => "Domene %1 av %2",
    'dom_ctrl__dom_cl' => "Domene %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Domene har viderekobling satt opp med udefinert URL for viderekobling",
    'dom_ctrl__domain_has_frame_forwarding' => "Domene har videresending av ramme til URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Domenet har ikke hosting konfigurert",
    'dom_ctrl__domain_has_physical_hosting' => "Webhosting er konfigurert for dette domenet på IP-adresse %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Domenet har standard videresending til URL %1",
    'dom_ctrl__maillists' => "Adresselister",
    'dom_ctrl__mboxes' => "Postbokser",
    'dom_ctrl__mg' => "Videresendt e-post",
    'dom_ctrl__resource_name' => "Ressurs",
    'dom_ctrl__resp' => "Autosvar",
    'dom_ctrl__subdom' => "Underdomener",
    'dom_ctrl__dom_aliases' => "Domenealiaser",
    'dom_ctrl__traffic' => "Trafikk",
    'dom_ctrl__unable_activate/deactivate_dom' => "Klarte ikke å aktivere/deaktivere domene: %1",
    'dom_ctrl__used' => "Brukt",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Webbrukere",
    'dom_pref__bounce_with_phrase' => "Returner med melding",
    'dom_pref__bounce' => "Returner",
    'dom_pref__catch_addr' => "Videresend til adresse",
    'dom_pref__reject' => 'Avvis',
    'dom_pref__confirm_domain_removing' => "Vennligst, ikke glem å informere besøkende på domenet om endring av domenenavn. Er du sikker på at du vil endre navn på domenet?",
    'dom_pref__db_inconsystency' => "database inkonsistens.",
    'dom_pref__dbs' => "databaser",
    'dom_pref__delete_traffic_stat' => "Behold web- og trafikkstatistikk",
    'dom_pref__delete_traffic_stat_older' => "Behold web- og trafikkstatistikk",
    'dom_pref__dom_level_name_conflict' => "Brukernavnet til domeneadministratoren er i konflikt med brukernavnet til en av kundene.",
    'dom_pref__invalid_disk_space_limit' => "Ugyldig grense for diskplass. Maksimumsverdi: %1",
    'dom_pref__invalid_expiration_date_limit' => "Ugyldig gyldighetsperiode.",
    'dom_pref__invalid_max_traffic_limit' => "Ugyldig trafikkgrense. Maksimumsverdi: %1",
    'dom_pref__limits_of_dom' => "Grenser for domene %1",
    'dom_pref__mail_grps' => "e-postgrupper",
    'dom_pref__mail_nonexistent_user' => "Hva skal gjøres med e-post sendt til ikke-eksisterende brukere",
    'dom_pref__mail_redirs' => "e-post-videresendere",
    'dom_pref__mail_resps' => "e-post-autosvar",
    'dom_pref__max_limit_is_invalid' => "%1 er ugyldig",
    'dom_pref__max_num_of_%objects_is_invalid' => "Maksimalat antall av %1 er ugyldig.",
    'dom_pref__new_limit_less_currently_used' => "%1: ønsket - %2, i bruk nå - %3",
    'dom_pref__older_that' => "for",
    'dom_pref__postboxes' => "postbokser",
    'dom_pref__preferences_of_dom' => "Innstillinger for domene %1",
    'dom_pref__redirect_to_itself' => "Domenet vil ha videresendingen satt til seg selv",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Du spesifiserte oppbevaringstid for domenets trafikkstatistikk til å være mindre enn totalverdien definert for serveren (%1 måned(er)). Oppbevaringsperiode for statistikk er satt til standardverdi for serveren (%1 måned(er)).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Klarte ikke å legge et www-prefiks til domene: %1",
    'dom_pref__unable_define_physical_hst_param' => "Klarte ikke å definere fysiske hostingparametere: %1",
    'dom_pref__unable_rename_domain' => "Kan ikke endre domenenavn %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Klarte ikke å sette postbokskvote for dette domenet: %1",
    'dom_pref__unable_set_up_web_user_script' => "Kan ikke sett opp skript for webbruker: %1",
    'dom_pref__unlimited' => "Ubegrenset",
    'dom_pref__web_usrs' => "webbrukere",
    'dom_pref__you_already_have_%object' => "Du har allerede %1",
    'cu_domain__error_unable_update_ftp_users' => 'Kunne ikke oppdatere domenets FTP-brukere: %1',
    'dom_cli__warning_ignore_quota' => 'ADVARSEL: Valgmuligheten "-hard_quota" ignoreres: harddisk kvote støttes ikke',
    'dom_user_client_login_exist' => "Klarte ikke å gi domeneadministratoren tilgang til Plesk på domene %1: dette brukernavnet er allerede i bruk.",
    'domain__unable_to_turn_on_service' => "Kunne ikke slå på tjenesten %1.",
    'domains__change_the_status_of_domain?' => "Er du sikker på at du ønsker å endre status for domene %1?",
    'domains__client_info_hiding_traffic' => "%1 domener, %2 aktive domener, %3 diskplass brukt",
    'domains__unable_to_change_client_status' => "Klarte ikke å endre status for kundekonto: %1",
    'domains__unable_update_apache_settings' => "Kunne ikke oppdatere Apache-innstillinger.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Du har ikke tillatelse til å slette domener.",
    'domains__you_want_change_the_status_of_the_cl??' => "Er du sikker på at du ønsker å endre status for kundekonto?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Er du sikker på at du vil utføre denne operasjonen?",
    'domains_list__unable_remove_doms' => "Kan ikke fjerne domener: %1",
    'domaintrafficlist_header_of_domain__' => "Trafikk for domene %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Velg domenealias som skal fjernes.',
    'domain_aliases_remove__title' => 'Fjerning av domenealias',
    'domain_aliases__max_aliases_reached_for_dom' => "Grensen på antall alias er nådd for dette domenet.",
    'domain_edit__edit_title' => 'Rediger navn på domenealias',
    'domain_alias_edit__type' => 'Type domenealias',
    'domain_aliases__list_header' => 'Domenealiaser',
    'domain_aliases__name' => 'Navn',
    'domain_aliases__type' => 'Type',
    'domain_aliases__type_full' => 'Web+FTP+E-post',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Domenealiaser',
    'domain_aliases__legend' => 'Domenealiaser',
    'domain_alias__domain_exists' => 'Et domene med dette navnet finnes allerede',
    'domain_alias__subdomain_exists' => 'Et underdomene med dette navnet finnes allerede',
    'domain_alias__dns_record_exists' => 'En DNS-oppføring med angitt domenealias finnes allerede',
    'domain_alias__domain_alias_exists' => "Et domenealias med dette navnet finnes allerede",
    'domain_alias__invalid_type_full' => 'Epostserver støtter ikke domenealias',
    'domain_alias__redirect_exists' => 'Omdirigering til seg selv ble oppdaget.',

    'ds__anonymous_ftp' => "Anonym FTP",
    'drweb__pagetitle' => 'Antivirusinnstillinger',
    'drweb__drweb' => 'Antiviruskontroll av e-post',
    'drweb__drweb_direction' => 'Kontrollerer e-post for virus',
    'drweb__drweb_direction_off' => 'Ikke skann etter virus',
    'drweb__drweb_direction_any' => 'Innkommende og utgående e-post',
    'drweb__drweb_direction_from' => 'Kun utgående e-post',
    'drweb__drweb_direction_to' => 'Kun innkommende e-post',
    'drweb__disable_reason_key' => 'Antivirus støttes ikke av lisensnøkkelen.',
    'drweb__disable_reason_perm' => 'Du har ikke tillatelse til behandle Antivirus.',
    'drweb__disable_reason_install' => 'Antivirus er ikke innstallert.',
    'drweb__filters' => 'Antivirus filtre',
    'ds__dns' => "DNS-sone",
    'ds__mail' => "E-post",
    'dsr__of_client_title' => "Oppsummeringsrapport for domene for %1",
    'dsr__report_has_been_sent_email' => "Rapporten ble sendt til e-post: %1",
    'dsr__title' => "Oppsummeringsrapport for domene",
    'dumps_list__deletion_page_title' => "Følgende sikkerhetskopier for domene %1 vil bli fjernet:",
    'dumps_list__dumpfile_is_invalid' => "Filen %1 er ikke en gyldig sikkerhetskopi av domenet.",
    'dumps_list__page_title' => "Sikkerhetskopifiler",
    'dumps_upload__page_title' => "Laster opp sikkerhetskopier til lager",
    'dumps_list__repository_is_not_exist' => "Lager for sikkerhetskopifiler eksisterer ikke.",
    'dumps_list__unable_to_remove' => "Kan ikke slette sikkerhetskopi filen: %1",
    'dumps_list__dumpfile_can_conflict' => "Filnavnet du oppga er i konflikt med filen %1 , angi et annet filnavn.",
    'dusr_ed__allow_dl_usr_access' => "Gi tilgang til domeneadministrator",
    'dusr_ed__information' => "Egenskaper for domeneadministrator for %1",
    'dusr_ed__locale' => "Språk for domeneadministrator",
    'dusr_ed__skin' => "Domeneadministratorens grensesnittskin",
    'dusr_ed__personal_information' => 'Personlig informasjon',
    'ess__error' => "Feil",
    'example__' => "Eksempel: %1",
    'extras__allow_certificate_purchasing' => "Tillat sertifikatkjøp",
    'extras__allow_domain_registration' => "Tillat domeneregistrering",
    'extras__allow_extras' => "Tillat ekstra tjenester",
    'extras__buy_new_key' => "Den aktive lisensen din lar deg ikke modifisere disse objektene.",
    'extras__setup_services' => "Sett opp ekstra tjenester",

    'ruleeditform__error' => 'Kan ikke oppdatere brannmurregel.',
    'ruleeditform__name_is_required' => 'Angi navn på regelen.',
    'ruleeditform__profiles_is_required' => 'Velg minst én profil.',
    'ruleeditform__invalid_ip' => 'Den spesifiserte IP-adressen eller nettverket er ugyldig.',
    'ruleeditform__invalid_port' => 'Angitt port er ugyldig. De mulige verdiene er 1000 eller 1000-1051',

    'filemanager__items' => 'elementer i katalog %1',
    'filemanager__items_paging' => 'elementer i katalog %1',

    'get_password__encrypted_password' => "Kan ikke sende passordinformasjon: passord er lagret i kryptert skjema.",
    'get_password__mail_error' => "Det oppstod en feil under forsøket på å sende passordet til e-post %1: %2",
    'get_password__mail_ok' => "Passord ble sendt til e-post: %1",
    'get_password__message' => "Ditt brukernavn for å få tilgang til systemet: %1\nPassordet ditt er %2",
    'get_password__subject' => "Passord for tilgang systemet.",
    'groups__available' => "Tilgjengelige e-postgrupper",
    'groups__groups_for_mailname' => "E-postgruppe som e-postkonto %1 abonnerer på",
    'groups__member_of' => "Medlem av følgende postgrupper",
    'help__help_area' => "Hjelpeområde.",
    'hst_def__auth_disabled' => "forbudt",
    'hst_def__auth_enabled' => "tillatt",
    'hst_def__change_curr_dns_ip' => "Den nåværende IP adressen for A DNS oppføringen vil bli endret",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Ingen av IP-adressene for A DNS-oppføringen matcher IP-adressen tildelt hostingkontoen som opprettes",
    'hst_def__dest_url' => "Mål-URL-adresse",
    'hst_def__disk_quota' => "Diskkvote",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Diskplassgrensen som du prøver å sette opp er overskredet av diskplassgrensen i den anonyme innkommende FTP-mappen. Grensen for diskplass for den innkommende mappen for anonym FTP må ikke overskride domenets diskplassgrense.",
    'hst_def__frame_forwarding_definition' => "Tildeling av rammeviderekobling for domene %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Advarsel: FTP-bruker %1 benyttes i innstillinger for hostingkonto men finnes ikke i systemet.",
    'hst_def__hst_type_is_not_defined' => "Hostingtype er ikke definert",
    'hst_def__ip_based' => "IP basert",
    'hst_def__name_based_power_anonymous_ftp_down' => "Overføring av denne hostingkontoen til delt IP-adresse vil gjøre anonym FTP-tjeneste på dette domenet tilgjengelig. Fortsette likevel?",
    'hst_def__password_is_invalid_password_syntax' => "Passordet er ugyldig.\nIkke bruk enkelt anførselstegn og nasjonale alfabettegn i passordet.\nPassordlengden bør fra være mellom 5 og 14 tegn. Passordet bør ikke inneholde brukernavn.",
    'hst_def__shell' => "SSH-tilgang til serverskallet under abonnementets systembruker",
    'hst_def__shell_windows' => "Servertilgang for eksternt skrivebord under abonnementets superbruker",
    'hst_def__standard_forwarding_definition' => "Standard tildeling av videresending for domene %1",
    'hst_def__title_name_based' => "Navnvebasert",
    'hst_def__unable_create/update_physic_hst' => "Klarte ikke å opprette/oppdatere fysisk hosting: %1",
    'hst_def__unable_create/update_std_fwd' => "Kan ikke skape/oppdatere standard videresending: %1",
    'hst_def__unable_create_forwarding_myself' => "Klarte ikke å opprette videresending til selve domenet.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Kan ikke tillate bruk av en enkel mappe for lagring av SSL/TLS og ikke-SSL/TLS innhold: SSL/TLS-støtte er ikke slått på.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Kan ikke slå på SSL/TLS støtte: ingen SSL/TLS-sertifikat installert.",
    'hst_def__url_is_invalid' => "Ugyldig URL-adresse.",
    'hst_def__virtual_host_access' => "Tilgang for virtuell vert for domene %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "ADVARSEL. Denne virtuelle verten bruker en ikke-eksisterende IP-adresse for hosting.",
    'hst_def__you_have_no_ips' => "Du har ingen IP-adresser tilgjengelig og du har ikke lov til å opprette navnebasert hosting.",
    'hst_sel__header' => "For å hoste et nettsted på denne serveren, velg alternativet Fysisk hosting.\n For å sette opp videresending av domene til et nettsted på en annen maskin, velg alternativet Videresending av ramme eller Standard videresending.\n Med standard videresending blir en bruker omdirigert til området og det faktiske områdets URL-adresse vises i brukers nettleser, så brukeren vet om videresendingen. Med rammevideresending blir en bruker videresendt til området uten å vite at området faktisk er på en annen lokasjon.",
    'hst_sel__physical_hst' => "Fysisk hosting",
    'hst_sel__select_hst_type' => "Velg hostingtype for domenet",
    'hst_sel__select_hst_type_warning' => "Velg hostingtype for domenet",
    'hst_sel__hosting_exists' => "Klarte ikke å opprette hosting, da det allerede er konfigurert for dette domenet. Du vil bli omdirigert til administrasjonsside for hosting.",
    'hst_sel__standard_frw' => "Standard videresending",
    'hst_sel__frame_frw' => "Ramme videresending",
    '__frame_frw' => "Ramme videresending",
    '__hosting_exists' => "Klarte ikke å opprette hosting, da det allerede er konfigurert for dette domenet. Du vil bli omdirigert til administrasjonsside for hosting.",
    '__choose_hst_type' => "Velg ønsket hostingtype.",
    '__no_hst_conf' => "Det er ingen hosting konfigurert for domenet ditt.",
    '__physical_hst' => "Fysisk hosting",
    '__select_hst_type' => "Velg hostingtype for domenet",
    '__standard_frw' => "Standard videresending",
    '__warning' => "Advarsel! Det vil bli sett bort i fra alle tidligere angitte parametere. Er du sikker på at du ønsker å endre den hostingtypen?",
    'i_cl_off' => "Kunden er ikke aktiv.",
    'i_cl_off_by_admin' => "Kundekonto er suspendert av serveradministrator.",
    'i_cl_off_expired' => "Kundekonto er utløpt.",
    'i_cl_on' => "Kunde er aktiv.",

    'icf__title' => 'Internett forbindelse brannvegg',
    'icf__if_legend' => 'Grensesnitt',
    'icf__mode' => 'Modus',

    'invalid_value' => 'Verdien er ugyldig',

    'ip_addr__already_exists' => "IP adressen %1 finnes allerede.",
    'ip_addr__cant_add' => "IP %1 eksisterer ikke eller tilhører IP-utvalget til en annen kunde",
    'ip_alias__interface' => "Grensesnitt",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 IP-adresse for navnebasert virtuell hosting er ugyldig.",
    'ip_alias__invalid_ip_or_netmask' => "Ugyldig IP adresse/ nettmaske par.",
    'ip_alias__orig_ip_can_not_be_deleted' => "IP-adresse %1 er den originale server-IP, så du kan ikke fjerne den.",
    'ip_alias__ip_is_invalid' => "%1 IP adresse er ugyldig.",
    'ip_alias__ip_mask_is_invalid' => "%1 IP maske er ugyldig.",
    'ip_alias__ip_not_exist' => "IP adressen %1 eksisterer ikke.",
    'ip_alias__ip_address_and_mask' => 'IP adresse og nettverksmaske',
    'ip_alias__mask' => "Nettverksmaske",
    'ip_alias__remove_selected_ip_aliases?' => "Er du sikker på at du vil fjerne de valgte IP-adresser?",
    'ip_alias__select_ip' => "Velg minst en IP-adresse fra listen for å fjerne den.",
    'ip_alias__this_ip_used_for_domain' => "(%1) denne IP-adressen brukes for domene %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) denne P adressen benyttes for navnebaserte virituelle verter.",
    'ip_alias__unable_add_ip' => "Kan ikke legge til IP: %1",
    'ip_alias__unable_remove_ip' => "Kan ikke fjerne IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Du kan ikke endre IP-adressetype til delt, da den vil gjøre anonym FTP for domene '%1' utilgjengelig.",
    'ip_ctrl__ip_addr' => "IP adressen %2 på grensesnittet %1",
    'ip_ctrl__ip_exists_many_pools' => "Du kan ikke endre IP-typen. Denne IP adressen tilhører gruppene for mange brukere samtidig.",
    'ip_ctrl__ssl_cert' => "SSL/TLS-sertifikat",
    'limit__date_in_past' => "Gyldighetsperioden er ugyldig. %1 er i fortiden.",
    'limit__enter_date' => "Angi dato",
    'limit__max_db' => "Databaser",
    'limit__name_disk_space' => "diskplass",
    'limit__name_max_box' => "postbokser",
    'limit__name_max_db' => "MySQL databaser",
    'limit__name_max_dom' => "domener",
    'limit__name_max_maillists' => "adresselister",
    'limit__name_max_subdom' => "underdomener",
    'limit__name_max_traffic' => "trafikk",
    'limit__name_max_wu' => "webbrukere",
    'limit__name_mbox_quota' => "postkasse kvote",
    'limit__name_max_mn' => "e-postkontoer",
    'limit__name_max_cl' => 'klienter',
    'limit__name_total_mboxes_quota' => "total postbokskvote",
    'limit__name_mysql_dbase_space' => "MySQL databaseplass",
    'limit__name_mssql_dbase_space' => "MSSQL databaseplass",
    'limit__name_pgsql_dbase_space' => "PostgreSQL databaserom",
    'limit__name_expiration' => 'utløpsdato',

    'locale_upload__unable_to_install' => 'Kan ikke installere språkpakke fil',
    'locale_upload__wrong_package' => 'Filen du lastet opp inneholder ikke språkpakke for denne versjonen av Plesk.',
    'locale_upload__wrong_locale' => 'Filen du lastet opp inneholder ikke gyldig språkpakke.',

    'ma__create_title' => 'Oppretter e-postalias for %1.',
    'ma__edit_title' => "Rediger e-postalias %1",
    'ma__enter_new_alias' => "Skriv inn nytt alias.",
    'ma__invalid_alias' => "Ugyldig e-postalias.",
    'ma__mail_aliases_mailname' => "E-postaliaser for e-postkonto %1",
    'ma__mailname_does_not_exist' => "E-postkonto finnes ikke.",
    'ma__select_ma_for_remove' => "Velg e-postaliaser som skal fjernes.",
    'ma__unable_to_add_new_ma' => "Kan ikke legge til e-postalias %1",

    'mail_queue__not_allowed_by_license_key' => 'Administrasjon av epostkø er ikke tillatt av lisensnøkkelen.',
    'maillist__' => "Adresseliste %1",
    'maillist__already_exists' => "Adresselisten finnes allerede.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Epostalias %1 finnes allerede på dette domenet",
    'maillists__' => "Adresselister %1",
    'maillists__limit_cl_max_maillists' => "Grensen for antall adresselister ble nådd for kunden (grense: %1, brukt: %2)",
    'maillists__limit_dom_max_maillists' => "Grensen for antall adresselister ble nådd for domenet.",
    'maillists__list' => "Adresselister",
    'maillists__mailman_not_installed_or_conf' => "\nMailman Server-tillegg er ikke installert eller konfigurert\npå serveren. Kontakt serveradministratoren for å få Mailman Server-tillegg installert eller konfigurert riktig.",
    'maillists__status' => "Adresselistetjeneste er slått på",
    'maillists__unable_to_delete__' => "Kan ikke slette adresseliste: %1",
    'maillists__disabled_text' => 'Du kan ikke behandle adresseliste fordi Mailman adresselisteserverkomponentet er ikke installert eller konfigurert.',
    'maillist_member__already_exists' => 'Adresseliste-abonnenten finnes allerede.',
    'maillist_member__not_exists' => 'Det er ingen slik bruker på adresselisten.',
    'mailserver_switching_warning' => "Advarsel!\n\nEndrer e-postserver er beregnet på for første konfigurering og dersom serveren er allerede i bruk, og forårsaker følgende problemer: tap av innstillinger og postboks-innhold, og i tilfeller hvor serveren du bytter til er allerede konfigurert, diverse konflikter.\nHvis denne serveren er i bruk nå og du er sikker på at du vil bytte til en annen, kan du varsle kundene dine om operasjonen slik at de kan laste ned og lagre eposten sin.",
    'manager__access_denied' => "Ingen tilgang: %1",
    'manager__admin' => "Administrator",
    'manager__client' => 'Kunde',
    'manager__domain' => "Domene",
    'manager__domain_cl_limit_exceeding' => "Grense for antall domener er nådd for denne kundekontoen.",
    'manager__domain_is_not_yours' => "Domene %1 tilhører ikke deg.",
    'manager__domain_key_limit_exceeding' => "Grensen for domeneopprettelse som definert av lisensnøkkelen din er nådd.",
    'manager__no_perm_to_call' => "Du har ikke tillatelse til å ringe %1.",
    'manager__no_perm_to_create_domains' => "Du har ikke tillatelse til å opprette domener.",
    'manager__no_perm_to_modify_domain' => "Du har ikke tillatelse til å modifisere domene %1.",
    'manager__no_perm_to_modify_domains' => "Du har ikke tillatelse til å modifisere domener.",
    'manager__no_perm_to_remove_domain' => "Du har ikke tillatelse til å fjerne domene %1.",
    'manager__no_perm_to_remove_domains' => "Du har ikke tillatelse til å fjerne domener.",
    'manager__node_doesnt_exist' => "%1 finnes ikke.",
    'manager__user_disabled' => "Kontoen din er deaktivert. Du kan ikke kjøre systemet.",
    'mail_quota_unsupported' => "ikke støttet av e-postserver",
    'mbox_quota_unsupported' => "ikke støttet av e-postserver",
    'mn__create_title' => "Opprett e-postkonto",
    'mn__edit_title' => "Innstillinger",
    'mn__files_list_title' => "Vedleggsfiler",
    'mn__files_remove' => "Ta bort filene fra lagret for vedlegg. Disse filene brukes muligens av autosvar. De vil fjernes fra både lagret og autosvar som bruker dem.",
    'mn__files_select_for_remove' => "Velg filer som skal fjernes.",
    'mn__mail_alias_form' => "E-postalias-format",
    'mn__mail_aliases_list' => "E-postaliaser",
    'mn__mailbox' => "Administrasjon av postboks",
    'mn__unable_define_mn' => "Kan ikke sette opp e-postkontoer: %1",
    'mn__unable_remove_mbox_quota' => "Kan ikke fjerne postbokskvoten: %1",
    'mn__upload_file' => "Last opp fil",
    'mn_edit__attach_filename_changed' => 'Den opplastede filen %1 ble omdøpt til %2 fordi navnet inneholdt ikke-ASCII tegn.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Du bør legg til et medlem i e-postgruppen før du aktiverer e-postgruppen.",
    'mn_edit__add_resp_or_turn_off_box' => "Du bør legge til et autosvar eller fjern haken i avmerkingsboksen.",
    'mn_edit__attachments' => "Vedlegg",
    'mn_edit__dom_quota_less_then_quota' => "Størrelsen på denne postboksen må ikke overskride grensen for diskplass tildelt postbokser på dette domenet.",
    'mn_edit__enter_external_rcpnt_email' => "Skriv inn e-post for medlemmer av ekstern e-postgruppe",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Skriv inn en adresse for videresender for e-post eller fjern avmerkingsboks.",
    'mn_edit__ext_rcpnt_email_invalid' => "Ekstern mottakers e-postadresse er ugyldig.",
    'mn_edit__file_exists' => "Filen finnes. Overskrive?",
    'mn_edit__files_deld_from_repository' => "Disse filene vil bli slettet fra depotet og autosvar som inneholder dem. Vil du fortsette?",
    'mn_edit__mail_name' => "E-postkonto",
    'mn_edit__mail_name_invalid' => "E-postkontonavn er ugyldig.",
    'mn_edit__mail_redir' => "Videresendere for e-post.",
    'mn_edit__mail_redir_add' => "Legg til e-postgruppemedlem.",
    'mn_edit__mail_resps' => "E-post-autosvar.",
    'mn_edit__mailbox' => "Postboks",
    'mn_edit__enable_mailbox' => "Postboks",
    'mn_edit__mailgroup' => "E-postgruppe",
    'mn_edit__mailgroup_addresses' => "E-postgruppemedlemmer",
    'mn_edit__mailgroup_disabled' => "Bare tilgjengelig når e-postkonto allerede er lagt til.",
    'mn_edit__max_dom_quota' => "Standard for domenet (%1)",
    'mn_edit__mbox_quota_invalid' => "Gal postboksstørrelse spesifisert.",
    'mn_edit__new_resp_name' => "Nytt autosvar navn",
    'mn_edit__no_autoresponders' => "Du bør minst legge til ett automatisk svar før du slår den automatisk svartjenesten på/av.",
    'mn_edit__no_file_sel' => "Ingen fil er valgt.",
    'mn_edit__no_mail_addresses' => "Ingen e-postadresser ble oppgitt eller valgt.",
    'mn_edit__none' => "Ingen",
    'mn_edit__not_create_pass' => "Dette vil ikke opprette et passord for denne enheten\nUten passord kan brukeren ikke se og sende e-post.",
    'mn_edit__redir_email_invalid' => "Videresendingsadresse er ugyldig.",
    'mn_edit__redirect_addr' => "Videresendingsadresse",
    'mn_edit__remove_autoresp?' => "Er du sikker på at du vil fjerne autosvar?",
    'mn_edit__remove_rcpnts?' => "Er du sikker på at du vil fjerne disse mottakere?",
    'mn_edit__repository' => "Repositorium",
    'mn_edit__resps_attach' => "Autosvar vedleggsfiler",
    'mn_edit__select_rcpnt_from_list' => "Velg minst en mottaker fra listen for å fjerne den.",
    'mn_edit__select_registered_users' => "Velg registrerte brukere",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Du har valgt å ha en postboks, men har ikke satt opp passord for den.",
    'mn_edit__unable_act_deact_mail_group' => "Kan ikke aktiver eller deaktiver e-postgruppe: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Kan ikke aktivere eller deaktivere videresending av e-post: %1",
    'mn_edit__unable_act_deact_postbox' => "Kan ikke aktivere eller deaktivere postboks: %1",
    'mn_edit__unable_act_deact_resp' => "Kan ikke aktivere eller deaktivere autosvar: %1",
    'mn_edit__unable_add_attach' => "Kan ikke legge til vedleggsfilen: %1",
    'mn_edit__unable_add_mail_group_member' => "Kan ikke legge til e-postgruppemedlem: %1",
    'mn_edit__unable_add_resp' => "Kan ikke legge til autosvar: %1",
    'mn_edit__unable_change_mail_name' => "Kan ikke endre e-postkontonavn: %1",
    'mn_edit__unable_deactivate_mail_group' => "Kan ikke deaktivere e-postgruppe: %1",
    'mn_edit__unable_deactivate_resp' => "Kan ikke deaktiver autosvar for e-post : %1",
    'mn_edit__unable_define_resp_id' => "Kan ikke definere autosvar ID %1",
    'mn_edit__unable_remove_attach' => "Kan ikke fjerne vedleggsfilen(e): %1",
    'mn_edit__unable_remove_autoresp' => "Kan ikke fjerne autosvar: %1",
    'mn_edit__unable_remove_mail_group_member' => "Kan ikke fjerne e-postgruppemedlemmer: %1",
    'mn_edit__wrong_way' => 'Meldingen som er adressert til %1 vil ikke bli levert, siden denne e-postkontoen ikke har en postboks eller videresender for e-post slått på.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Postkassen ved adressen %1 var slått av. Meldingene i postboksen ble ikke fjernet, men du vil ikke kunne hente dem via IMAP eller POP3-protokollen.',
    'mn_list__mail_names_for_domain' => "Epostkontoer under domenet %1",
    'mn_list__sa_cannot_unable' => "Kan ikke slå på spamfiltrering",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Kunde',
    'mn_list__tab_title_domain' => 'Domene',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Navn",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Kan ikke fjerne e-postkontoer: %1",
    'module_upload__module_was_installed' => 'Denne modulen er allerede installert. Hvis du ønsker å installere en nyere versjon av denne modulen, må du avinstallere modulen med Plesk, og deretter prøve å installere.',
    'module_upload__unable_to_install' => 'Kan ikke installere modulpakke filen',
    'module_upload__wrong_package' => 'Den opplastede filen er ikke en understøttet modulpakke.',
    'module_upload__wrong_module' => 'Den opplastede filen inneholder ikke en modulpakke.',

    'news_articles_title' => 'Plesk-nyheter',
    'notification_text__invalid_subject_length' => "Ugyldig lengde av tema for meldingen. Skulle være fra 1 til 255 tegn.",
    'notification_text__invalid_text_length' => "Ugyldig lengde av meldingstekst. Skulle være fra 1 til 65533 tegn.",
    'notification_text__subject' => "Tema for meldingen",
    'notification_text__text' => "Meldingstekst",
    'notification_text__title' => "Rediger melding",
    'notification_text__unable_set_text' => "Kan ikke endre meldingstekst:",

    'odbc__cant_add_dsn' => "Kan ikke legge til DSN %1: %2",
    'odbc__cant_connect' => "Kan ikke koble til datakilden ved hjelp av definerte innstillinger. Server har returnert: %1",
    'odbc__cant_delete_dsn' => "Kan ikke slette DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Kan ikke få informasjon om drivere.",
    'odbc__cant_get_drivers' => "Kan ikke hente en liste over ODBC-drivere: %1",
    'odbc__cant_open_info_file' => "Kan ikke åpne filen med informasjon om ODBC drivere.",
    'odbc__cant_parse_string' => "Kan ikke analysere koblingsstrengen.",
    'odbc__driver_not_set' => "Driver er ikke angitt",
    'odbc__driver_or_name_not_set' => "Driver eller navnet på ODBC koblingen var ikke angitt.",
    'odbc__dsn_already_exists' => "DSN med navnet (%1) finnes allerede i systemet.",
    'odbc__dsn_not_exists' => "Denne DSN finnes ikke",
    'odbc__enter_dsn_name' => "Angi DSN navn",
    'odbc__invalid_dsn_name' => "Gal syntaks for ODBC koblingsnavn (%1): vennligst bare bruk alfanumeriske tegn.",
    'odbc__no_such_driver' => "En ODBC-driver med dette navnet (%1) støttes ikke.",
    'odbc__unknown_driver' => "Ukjent driver navn (%1).",
    'odbc_dsn_system' => "System-DSN",

    'pb__aliases' => "Aliaser",
    'pb__anonftp' => "Anonym FTP",
    'pb__autoinstaller_releases' => 'Oppdaterer',
    'pb__cert' => "Sertifikater",
    'pb__cl_pool' => "IP-adresser",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Innstillinger",
    'pb__cl_rpt' => "Rapport",
    'pb__cl_rpt_list' => "Tilpass",
    'pb__cl_templates' => "Kundemaler",
    'pb__cl_traffic' => "Trafikk",
    'pb__cl_traffic_history' => "Trafikkhistorie",
    'pb__cl_traffic_of' => "Trafikk for %1",
    'pb__client' => "%1",
    'pb__clients' => "Kunder",
    'pb__comp_info' => "Serverkomponenter",
    'pb__common_acl' => 'Tillat Transfer ACL',
    'pb__cp_access' => "Tilgang",
    'pb__crontab' => "Planlegger",
    'pb__scheduler' => "Planlegger",
    'pb__custom_buttons' => "Egendefinerte knapper",
    'pb__databases_db' => 'Databaser',
    'pb__sqlservers_db' => 'SQL-servere',//to check
    'pb__db' => "Databaser",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Databaseservere',
    'pb__dl_usr_ed' => "Domeneadministrator",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Domenegrenser",
    'pb__dom_pref' => "Innstillinger",
    'pb__dom_sum_report' => "Oppsummeringsrapport for domene",
    'pb__dom_templates' => "Domenemaler",
    'pb__dom_traffic' => "Trafikk for %1",
    'pb__domains' => "Domener",
    'pb__domain_aliases' => 'Domenealias',
    'pb__dumps_list' => "Sikkerhetskopifiler",
    'pb__forwarding_setup' => "Oppsett av videresending",
    'pb__filemanager' => "Filadministrasjon",
    'pb__ip_aliasing' => "IP-adresser",
    'pb__ip_clients' => "Fjerning av IP adresser",
    'pb__license_management' => 'Lisensinformasjon',
    'pb__locales' => 'Nasjonale innstillinger',
    'pb__log_files' => "Loggfiler",
    'pb__mail' => 'E-post',
    'pb__mail_name_files' => "Vedleggsfiler",
    'pb__mail_name_redirects' => "Videresendere for e-post.",
    'pb__mail_name_resp_attach_add' => "Nytt vedlegg",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "E-post-autosvar.",
    'pb__mail_names' => "E-post",
    'pb__maillists' => "Adresselister",
    'pb__mimetypes' => 'MIME-typer',
    'pb__modules' => 'Moduler',
    'pb__modules_management' => 'Administrer moduler',
    'pb__notifications' => "Varslinger",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Oppsett av fysisk hosting",
    'pb__prtd_dirs' => "Beskyttede mapper",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Rapport",
    'pb__report_list' => "Tilpass",
    'pb__server' => "Server",
    'pb__sessions' => "Økter",
    'pb__sapp_pool' => "Webprogramutvalg",
    'pb__siteapp_install' => 'Installasjon av webprogram',
    'pb__site_app_pkgs' => 'Web Applikasjoner',
    'pb__site_apps' => "Web Applikasjoner",
    'pb__additional_key_info' => 'Egenskaper for nøkkel',
    'pb__additional_key_properties' => 'Egenskaper for nøkkel',
    'pb__skeleton' => 'Mal for virtuell vert',
    'pb__skins' => 'Skall',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Filter for søppelpost",
    'pb__statistics' => "Statistikk",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Underdomener",
    'pb__templates' => "Maler",
    'pb__virtualdirs' => 'Virtuelle kataloger',
    'pb__web_users' => "Webbrukere",
    'pdir__enter_dir_name' => "Skriv inn mappenavn.",
    'pdir__invalid_hst' => "Hostingtype er ugyldig. Må være fysisk.",
    'pdir__pd_id_is_undefined' => "ID for beskyttet mappe er udefinert.",
    'pdir__pdir_exist' => "Mappen med dette navnet er allerede beskyttet.",
    'pdir__pdir_not_exist' => "Beskyttet mappen finnes ikke.",
    'pdir__pdir_usr_not_exist' => "Brukeren av beskyttet mappe finnes ikke.",
    'pdir__remove_pdir_usrs' => "Følgende brukere av den beskyttede mappen %2 under nettsted %1 vil bli fjernet:",
    'pdir__remove_pdir_usrs_on_subdom' => "Følgende brukere av den beskyttede mappen %2 under underdomene %1 vil bli fjernet:",
    'pdir__select_pdir_usrs_for_remove' => "Velg brukeren av den beskyttede mappene som skal fjernes.",
    'pdir__select_pdirs_to_remove' => "Velg de mappene du vil fjerne beskyttelse fra.",
    'pdir__unable_define_pdir_users' => "Kan ikke definere brukerne av den beskyttede mappen.",
    'pdir__unable_define_pdirs_properties' => "Kan ikke sette egenskaper for beskyttede mapper: %1",
    'pdir__unable_select_dom_param' => "Kunne ikke velge domeneparametere: %1",
    'pdir_ed__create_pdir_for_domain' => "Opprett en beskyttet mappe under %1",
    'pdir_ed__create_pdir_for_subdomain' => "Opprett beskyttet mappe under underdomenet %1",
    'pdir_ed__dir_already_protect' => "Denne mappen er allerede beskyttet.",
    'pdir_ed__head_txt' => "Tittel på beskyttet område",
    'pdir_ed__invalid_login' => "Du oppga feil brukernavn.",
    'pdir_ed__login_exists' => "Denne brukeren finnes allerede. Forsøk å spesifisere et annet brukernavn.",
    'pdir_ed__new_usr' => "Brukernavn",
    'pdir_ed__non_ssl' => "ikke-SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Mappenavn",
    'pdir_ed__pdir_for_domain' => "Beskyttet mappen %1 på domenet %2",
    'pdir_ed__pdir_for_subdomain' => "Beskyttet mappe %1 under underdomene %2",
    'pdir_ed__pdir_location' => "Mappeplassering",
    'pdir_ed__pdir_users' => "Brukere av beskyttet mappe",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Minst en avmerkingsboks skal velges fra SSL/TLS og ikke-SSL/TLS boksene.",
    'pdir_ed__unable_cr_pdir_usr' => "Kan ikke opprette brukeren for den beskyttede mappe: %1",
    'pdir_ed__unable_create_pdir' => "Kan ikke opprette den beskyttede mappen: %1",
    'pdir_ed__unable_define_hst_type' => "Klarte ikke å definere hostingtype.",
    'pdir_ed__unable_update_pdir' => "Kan ikke lagre innstillinger av den beskyttede mappen: %1",
    'pdir_ed__wrong_symbol_in_header' => "Ikke bruk tegnet %1 inn mappetittelen.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Opprette bruker for den beskyttede mappen %1",
    'pdir_usr_ed__not_create_pass' => "Dette vil ikke opprette et passord for den nye brukeren av den beskyttede mappen.\nUten passord vil brukeren ikke kunne logge inn.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Passord for brukeren av den beskyttede mappen %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Kan ikke velg brukeren av den beskyttede mappen: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Kan ikke definere brukerne av den beskyttede mappen: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Kan ikke fjerne brukerne fra den beskyttede mappen: %1",
    'phosting__anonftp_encrypt' => 'Passordet til FTP-brukeren er kryptert, og kan derfor ikke brukes til å beskytte mappen /plesk-stat/webstat/. Skriv inn ditt FTP-passord på nytt, eller fjern merking fra alternativet "tilgjengelig via passordbeskyttet mappen',
    'phosting__hosting_and_dns_ip_difference_warning' => "Domenenavnet %%domain_name%% løses til IP-adressen %%dns_ip_address%%. Nettstedet er tildelt IP-adressen %%hosting_ip_address%%. Hvis webstedet ditt ikke åpnes i en nettleser når henviser til det med domenenavnet, gå til skjermbildet for DNS-administrasjon (Domener > Domenenavn > DNS) og endre egenskaper for A-ressursoppføring: tildel IP-adresse %%hosting_ip_address%% til domenenavnet %%domain_name%%.",
    'phosting__ip_change_warning' => "IP adresse endret. Tilsvarende endringer ble også gjort for domenets DNS-sone.",
    'phosting__other_hosting_exists_on_ip' => "Kunne ikke endre sertifikatet fordi denne IP-adressen benyttes for én eller flere hostingkontoer.",
    'phosting__unable_to_change_certificate' => "Kan ikke installere sertifikatet: %1",
    'phosting__unable_to_change_ip_address' => "Kan ikke endre IP adressen: %1",
    'phosting__unable_to_set_cert' => "Kan ikke sette SSL/TLS-sertifikat: %1",
    'phosting__unable_update' => "Kunne ikke oppdatere innstillinger for hosting: %1",
    'phosting__unable_manage' => "Kunne administrere hosting: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Kunne ikke konfigurere fail2ban til å spore domeneloggene. Loggene blir automatisk sporet neste gang fail2ban-tjenesten starter på nytt.\n%1",

    'picker_acl_record__tittle' => 'Velg en ACL-oppføring',
    'picker_autoresponder__title' => 'Velg et autosvar',
    'picker_black_list__domain_name' => 'Velg et domenenavn',
    'picker_certificate' => 'Velg et SSL/TLS-sertifikat',

    'picker_dns_zone_template__title' => 'Velg en ressursoppføring',
    'picker_domain__title' => 'Velg et nettsted:',
    'picker_domain_alias__title' => 'Velg et domenealias',
    'picker_resource_record__title' => 'Velg en ressursoppføring',
    'picker_disabled_resource_record__title' => 'Velg en navneserver',
    'picker_ip_address__title' => 'Velg en IP-adresse:',
    'picker_ip_address_clients__title' => 'Velg kunder som bruker denne IP-adressen',
    'picker_mail_queue' => 'Velg e-postmeldinger',
    'picker_site_application__title' => 'Velg et webprogram',
    'picker_subdomain__title' => 'Velg et underdomene',
    'picker_web_user__title' => 'Velg en webbruker',
    'picker_custom_button__title' => 'Velg en brukerdefinert knapp',
    'picker_license_key__title' => "Valg av lisensnøkkel",
    'picker_spamfilter_address__title' => 'Velg en spamfilter-adresse',
    'picker_white_list__networks' => 'Nettverksvalg',

    'plesk_key__action_logs' => "Logging av handlinger utført av Plesk-brukere",
    'plesk_key__app_vault' => "Programhvelv",
    'plesk_key__backup' => "Oppdaterings- og gjenopprettingsfunksjoner",
    'plesk_key__client_templs' => "Administrasjon av tjenesteplaner",
    'plesk_key__clients' => "Brukerkontoer (forhandlere og kunder)",
    'plesk_key__resellers_only' => "Brukerkontoer (forhandlere)",
    'plesk_key__customers_only' => "Brukerkontoer (kunder)",
    'plesk_key__domains' => "Domener",
    'plesk_key__domain_aliases' => "Domenealiaser",
    'plesk_key__manage_dashboard' => 'Hjemmeside tilpasning',
    'plesk_key__drweb' => "Antivirus administrasjon",
    'plesk_key__event_manager' => "Hendelsesbehandler",
    'plesk_key__expirations' => "Administrasjon av utløpsdato for konto",
    'plesk_key__group_ops' => "Modifisering av multiple objekter på samme tid",
    'plesk_key__expiration' => "Utløpsdato for nøkkel",
    'plesk_key__edition_name' => "Plesk versjon",
    'plesk_key__key_number' => "Nøkkelnummer",
    'plesk_key__languages' => "Språkpakker",
    'plesk_key__mailnames' => "E-postkontoer",
    'plesk_key__migration_manager' => "Migration & Transfer Manager",
    'plesk_key__mssql' => "Microsoft SQL-serverstøtte",
    'plesk_key__myplesk_func' => "Koblinger for kjøp av SSL/TLS-sertifikater og tjenester for domeneregistrering",
    'plesk_key__myplesk_server_id' => "MPC slaveserver-identifikator",
    'plesk_key__notifications' => "Administrasjon av meldinger",
    'plesk_key__postgresql' => "PostgreSQL databaseserver-støtte",
    'plesk_key__qmail_queue' => 'Administrasjon av e-postkø',
    'plesk_key__remote_db' => 'Ekstern databasehosting',
    'plesk_key__slave_servers' => "Slaveservere",
    'plesk_key__spamassassin' => "Administrasjon av spamfilter",
    'plesk_key__subdomains' => "Administrasjon av underdomener.",
    'plesk_key__sys_access' => "Administrasjon av tilgang til serveren",
    'plesk_key__traffic_reports' => "Bruksrapporter for trafikk",
    'plesk_key__tts' => "Kundestøtte",
    'plesk_key__virtuozzo' => "Kun gyldig Virtuozzo-beholdere",
    'plesk_key__webusers' => "Webbrukere",
    'plesk_key__license_update_date' => 'Neste oppdatering av lisensnøkkel',
    'plesk_key__autoinstaller_config' => 'Administrasjon av innstillinger for Updater',
    'plesk_key__check_wrong' => "Lisensnøkkel er ugyldig. For å kunne bruke Plesk, vennligst hent og installer en ny gyldig lisensnøkkel.",
    'plesk_key__upload_check_wrong' => 'Lastet opp lisensnøkkel er ugyldig.',
    'plesk_key__revert_check_wrong' => 'Tidligere installert lisensnøkkel er ugyldig.',
    'plesk_key__update_check_wrong' => 'Oppdatert lisensnøkkel er ugyldig.',
    'plesk_key__viruozzo_only_key' => 'Lisensnøkkelen er bare ment for bruk sammen med Plesk i Virtuozzo-beholdere.',
    'plesk_key__ip_ranges_exceeded' => 'Du kan kun bruke denne lisensierte kopien av Plesk med følgende IP-adresser: %2. Følgende IP-adresser dekkes ikke av lisensen din: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Mengden ressurser som brukes for tiden overstiger grensene som defineres av lisensen din.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Antall nettsteder som hostes på serveren overskrider grensene som defineres av lisensen din. Du hoster %2 nettsteder; lisensen din tillater kun hosting av %1 nettsteder.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Antall domenealias på serveren overskrider grensene som defineres av lisensen din. Du har %2 domenealias; lisensen din tillater kun hosting av %1 domenealias.',
    'plesk_key__limits_exceeded_lim_cl' => 'Antallet kundekontoer som tjenes overskrider grensene definert av lisensen din. Du har for tiden %2 kundekontoer som tjenes; lisensen din øar deg bare tjene %1 kundekontoer.',
    'plesk_key__limits_exceeded_lim_mn' => 'Antall tjente epostkontoer overskrider grensene som er definert av lisensen din. Du tjener for tiden %2 epostkontoer; lisensen din tillater kun at du tjener %1 epostkontoer.',
    'plesk_key__limits_exceeded_lim_wu' => 'Antall tjente webbrukerkontoer overskrider grensene som defineres av lisensen din. Du tjener for tiden %2 webbrukerkontoer; lisensen din tillater kun at du tjener %1 webbrukerkontoer.',
    'plesk_key__limits_exceeded_MLS' => 'Antall språkpakker som for tiden er installert overskrider grensene som er definert av lisensen din. Det finnes %2 språkpakker installert; lisensen din tillater bare installasjon av %1 språkpakker.',
    'plesk_key__wrong_version' => 'Du prøver å bruke lisensnøkkel opprettet for en annen versjon av Plesk. Ta kontakt med Plesk salgsrepresentant for å få tak i en korrekt lisensnøkkel.',
    'plesk_key__other_product' => 'Du prøver å bruke en lisensnøkkel opprettet for et annet produkt. Ta kontakt med Plesk salgsrepresentant for å få tak i en korrekt lisensnøkkel.',
    'plesk_key__invalid_machine_id_trial' => 'Din gjeldende lisens er ugyldig fordi den allerede er aktivert på en annen Plesk-server. For å fortsette å bruke Plesk, må du enten installere en ny lisens eller installere gjeldende lisens igjen ved å angi aktiveringskoden (hvis du har en slik).',
    'plesk_key__invalid_machine_id_retail' => 'Din gjeldende lisens er ugyldig fordi den allerede er aktivert på en annen Plesk-server. Plesks brukervilkår (https://www.plesk.com/legal/) forbyr bruk av enkeltlisenser på to eller flere servere samtidig. For å fortsette å bruke Plesk, må du enten installere en ny lisens eller installere gjeldende lisens igjen ved å angi aktiveringskoden. Den ble sendt til deg via e-post da du kjøpte lisensen. <br>Finner du ikke aktiveringskoden? Du kan gjenopprette den ved å bruke Plesk 360. For å gjøre dette, logger du inn på https://platform360.io/ med e-postadressen du brukte ved lisenskjøp. Gå til fanen "Licenses" for å se lisensens aktiveringskode. Alternativt kan du kontakte Plesks lisens- og kjøpsavdeling via det nettbaserte skjemaet (https://www.plesk.com/licensing-and-purchase-support/). Husk å angi lisensnummeret ditt under "How can we help you?" i skjemaet.',
    'plesk_key__limits_exceeded_error' => 'Klarte ikke å installere lisensnøkkelen: mengden ressurser som brukes for tiden overskrider grensene definert i den opplastede lisensnøkkelen.',
    'plesk_key__limits_exceeded_note' => 'Den ressursmengden som brukes for tiden overskrider grensene som er definert i den opplastede lisensnøkkelen.',
    'plesk_key__key_file_invalid' => 'Den opplastede nøkkelfilen er ikke gyldig eller inneholder ikke en lisensnøkkel.',
    'plesk_key__server_request_error' => 'Kunne ikke oppdatere lisensen. Forsikre deg om at forbindelsene til lisensserveren ka.plesk.com op TCP port %1 ikke er blokkert. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Se hvordan dette gjøres</a>.',
    'key__no_key_file_in_zip' => 'Den opplastede .zip-filen inneholder ikke nøkkelfilen',
    'key__key_upload' => 'Installasjon av lisensnøkkel',
    'additional_key__prop_name' => 'Eiendom',
    'additional_key__prop_value' => 'Verdi',
    'additional_key__descr_name' => 'Nøkkelnavn',
    'additional_key__descr_key_number' => 'Nøkkelnummer',
    'additional_key__descr_key_vz' => "Denne lisensnøkkelen er kun ment for bruk i Virtuozzo-beholdere.",
    'additional_key__descr_key_mailboxes' => 'Postbokser',
    'additional_key__descr_lim_date' => 'Utløpsdato',
    'additional_key__descr_license_update_date' => 'Neste oppdatering av lisensnøkkel',
    'additional_key__file_invalid' => 'Den opplastede nøkkelfilen er ikke gyldig eller inneholder ikke en lisensnøkkel.',
    'additional_key__file_incompatible' => 'Den opplastede nøkkelfilen er ikke gyldig for dette programmet.',
    'additional_key__expired' => 'Denne ekstranøkkelen er utløpt.',
    'additional_key__not_exists' => 'Ingen lisensnøkkel installert.',
    'additional_key__viruozzo_only_key' => 'Denne lisensnøkkelen er kun ment for bruk sammen med Plesk installert i Virtuozzo-beholdere.',
    'additional_key_update__result_response' => 'Lisensieringsserverens respons: %1',
    'additional_key_update__result_network' => 'Kan ikke koble til lisensieringsserver. Vennligst forsikre deg om at dine nettverk tillater kommunikasjon til %1: %2.',
    'additional_key_update__result_lock' => 'Nøkkeloppdatering er allerede i gang',
    'additional_key_update__result_internal_error' => 'Feil oppstod under oppdatering av lisensnøkkelen: %1',

    'proceed_to_cl_pool' => "Fortsett til konfigurering av kundens IP-utvalg",
    'proceed_to_hosting_setup' => "Fortsett til oppsett av hosting",
    'removeCerts__remove_certificates_cp' => "Følgende sertifikater vil bli fjernet:",
    'removeCerts__remove_certificates_domain' => "Følgende sertifikater eid av %1 vil bli fjernet:",
    'removeClientsIP_remove_clients_ip' => "Denne IP-adressen vil bli fjernet fra utvalgene til følgende kunder:",
    'removeMailAliases__remove_mail_aliases' => "Følgende e-postaliaser for e-postkonto %1 vil bli fjernet:",
    'removeMailNames__remove_mailnames' => "Følgende epostkontoer og alias vil bli fjernet fra domene %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Følgende epostkontoer og alias vil bli fjernet fra domene %2 som eies av kunde %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Disse e-postkontoene vil ikke bli slettet.",
    'removeFtpSessions__remove_title' => "De følgende FTP økter avsluttes:",
    'removeTemplates__remove_templates' => "Følgende maler vil bli fjernet:",
    'resp_edit__always_respond' => "besvar alltid",
    'resp_edit__reply_subject' => "Svar emne",
    'resp_edit__answer_subject' => "Besvar med enme",
    'resp_edit__answer_txt' => "Svar med tekst",
    'resp_edit__attach' => "Legg ved filer",
    'resp_edit__default_subject' => "SV:%1",
    'resp_edit__for' => "for",
    'resp_edit__frw_rqst_email' => "Ved automatisk svar, videresend originalmeldingen til angitt e-post",
    'resp_edit__fwd_email_invalid' => "Destinasjon e-postadressen er ugyldig.",
    'resp_edit__in_body' => "når spesifiserte ord finnes i meldingsteksten",
    'resp_edit__in_subject' => "når spesifiserte ord finnes i meldingens emne",
    'resp_edit__invalid_resp_freq' => "Responssfrekvensen er ikke gyldig.",
    'resp_edit__invalid_rqst_txt' => "Ugyldig forespørsel tekst.",
    'resp_edit__invalid_store_lim_num' => "Grenseverdien er ugyldig.",
    'resp_edit__limits_title' => "Grenser",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Maksimalt antall svar per dag overskrider den definerte mengden. Tillatt: %1, ønsket: %2",
    'resp_edit__no_files_sel' => "Ingen fil er valgt.",
    'resp_edit__no_txt_supplied' => "Ingen tekst angitt.",
    'resp_edit__reply_title' => "Svar",
    'resp_edit__reply_to_address' => "Avsenderadresse",
    'resp_edit__reply_to_invalid' => "Avsenderadresse er ugyldig.",
    'resp_edit__reply_uniq_email' => "Svar til den unike e-postadressen ikke mer en",
    'resp_edit__conditions_title' => "Betingelser",
    'resp_edit__request_title' => "Forespørsel",
    'resp_edit__resp' => "Autosvar",
    'resp_edit__resp_name' => "Autosvar navn",
    'resp_edit__resp_not_exist' => "Autosvar finnes ikke.",
    'resp_edit__resp_status' => "Autosvar status",
    'resp_edit__rqst_txt' => 'Spesifiser betingelser for dette automatiske svaret',
    'resp_edit__select_files_on_server_for_attach' => "Velg filene du ønsker å feste",
    'resp_edit__store_up_to' => "Lagre opptil",
    'resp_edit__subj_line_invalid' => "Emnelinjen er feil.",
    'resp_edit__text_too_big' => "Svarsteksten er for stor.",
    'resp_edit__times_in_a_day' => "ganger om dagen.",
    'resp_edit__unable_define_resp_cond' => "Kan ikke definere autosvar betingelsen: %1",
    'resp_edit__unable_define_resp_status' => "Kan ikke definere status: %1",
    'resp_edit__unable_turn_on_resp' => "Kan ikke slå på autosvar: %1",
    'resp_edit__uniq_email' => "unike e-postadresser",
    'resp_edit__content_type' => 'Format for sending av e-post',
    'resp_edit__content_type_text' => 'Ren tekst',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Koding',
    'restart__dns' => 'DNS-server (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "IMAP/POP3-server (%1)",
    'restart__mssql' => "Microsoft SQL Server",
    'restart__mysql' => "MySQL-server",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Tjenester",
    'restart__smtp' => "SMTP-server (%1)",
    'restart__spamd' => "Filter for søppelpost",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Webserver (%1)",
    'restart__ftp' => "FTP-server (%1)",
    'restart__service_start' => 'Vennligst sørg for nok tid til starting av tjenesten.',
    'restart__service_stop' => 'Vennligst sørg for nok tid til stopping av tjenesten.',
    'restart__service_restart' => 'Vennligst sørg for nok tid til omstart av tjenesten.',
    'rm_domains__some_domains_are_not_exist' => "Noen av de spesifiserte domenene finnes ikke. Muligvis var de fjernet av en annen bruker.",
    'rpt_cl_dom_data_bases' => "DBMySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "MGroups",
    'rpt_cl_dom_mail_lists' => "MLists",
    'rpt_cl_dom_mail_resps' => "AResp.",
    'rpt_cl_dom_mail_antispam' => "AntiSpam",
    'rpt_cl_dom_mail_antivirus' => "Antivirus",
    'rpt_cl_dom_postboxes' => "MBoxes",
    'rpt_cl_dom_redirects' => "Videresendere",
    'rpt_cl_dom_subdomains' => "Subdom",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "WUsers",
    'rpt_cl_report_for_admin__' => "Rapport for administrator %1",
    'rpt_cl_report_for_reseller__' => "Rapport for forhandler %1",
    'rpt_cl_report_for_cl__' => "Rapport om kunde %1",
    'rpt_cl_section_domains' => "Domener",
    'rpt_cl_section_full_domains' => "Domener",
    'rpt_cl_section_general' => "Generelt",
    'rpt_create' => "Opprett rapport",
    'rpt_empty' => "Rapporten bør inneholde i det minste en seksjon",
    'rpt_dom_report_for_dom__' => "Domenerapport for %1",
    'rpt_dom_section_databases' => "Databaser",
    'rpt_dom_section_full_databases' => "Databaser",
    'rpt_dom_section_full_maillists' => "Adresselister",
    'rpt_dom_section_full_mailnames' => "E-postkontoer",
    'rpt_dom_section_full_webusers' => "Webbrukere",
    'rpt_dom_section_full_siteapps' => 'Web Applikasjoner',
    'rpt_dom_section_full_aspnetapps' => 'ASP.NET webprogrammer',
    'rpt_dom_section_general' => "Generelt",
    'rpt_dom_section_hosting' => "Hosting",
    'rpt_dom_section_maillists' => "Adresselister",
    'rpt_dom_section_mailnames' => "E-postkontoer",
    'rpt_dom_section_siteapps' => 'Web Applikasjoner',
    'rpt_dom_section_aspnetapps' => 'ASP.NET webprogrammer',
    'rpt_dom_section_webusers' => "Webbrukere",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Rediger rapport %1",
    'rpt_enter_email_address' => "Skriv inn e-postadressen rapporten vil bli levert til.",
    'rpt_list' => "Brukerdefinerte rapportlayouter",
    'rpt_section_full' => "Full",
    'rpt_section_none' => "Ingen",
    'rpt_section_summary' => "Sammendrag",
    'rpt_default_full' => 'Full rapport',
    'rpt_default_summary' => 'Oppsummeringsrapport',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Feil i sending av rapporten: %1",
    'rpt_send_report_by_email_ok__' => "Rapporten ble sendt til %1",
    'sa_action' => "Handling",
    'sa_action_del' => "Slett",
    'sa_action_desc' => "Dette gjør du med søppelpost",
    'sa_action_save' => "Merk som spam og lagre i postboks",
    'sa_admin_blacklist' => "Administrators svarteliste",
    'sa_admin_whitelist' => "Administrators hviteliste",
    'sa_db_del_confirm' => "Er du sikker du vil tømme Spamfilter-databasen?",
    'sa_eml_in_ignorelist' => "E-post er på ignorer-listen",
    'sa_empty_email' => "Kan ikke legge til tomt e-postmønster.",
    'sa_exists_email' => "Et slikt e-postmønster finnes allerede.",
    'sa_disabled__mailname_not_filtering' => "Gjeldende server tillater ikke bruk av e-postfilter for denne e-postkontoen",
    'sa_disabled__filtering_is_disabled' => 'Spamfiltrering ble slått av etter serveradministratoren',
    'sa_disabled__hasnt_mailbox' => "Umulig å slå på spamfiltrering uten en postboks",
    'sa_enable_filter' => "Slå på spamfiltrering",
    'sa_forget' => "Ignorer",
    'sa_from' => "Fra",
    'sa_ham' => "ham",
    'sa_pattern_is_invalid' => "Mønsteret er ugyldig.",
    'sa_spam' => "spam",
    'sa_trainer__page_title' => 'Spamfilter-læring',
    'sa_trainer__tools_legend' => 'Verktøy',
    'sa_trainer__info_legend' => 'Info',
    'sa_trainer__messages_list_legend' => 'Meldinger i din postboks.',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Emne',
    'sa_trainer__from' => 'Fra',
    'sa_trainer__date' => 'Dato',
    'sa_trainer__info_text' => 'Meldinger lært: %1 som søppelpost, %2 som ikke-søppelpost, %3 totalt.',
    'sa_trainer__messages' => 'melding(er)',
    'sa_trainer__select__all' => 'Alle',
    'sa_trainer__select__spam_only' => 'Spam',
    'sa_trainer__select__ham_only' => 'Ikke-spam',
    'sa_trainer__select__unknown_only' => 'Ukjent',
    'sa_trainer__cannot_remove_messages' => 'Kan ikke fjerne valgte meldinger fra postboks.',
    'sa_trainer__remove_messages_confirm' => 'Er du sikker som du ønsker å fjerne valgte meldinger fra postboksen?',
    'sa_subj' => "Emne",
    'sa_training' => "Spamfilter-læring",
    'sa_training_legend' => "Bayesisk filtertrening",
    'sa_use_srv_settings' => "Bruk globale server-innstillinger",
    'sa_user_blacklist' => "Brukers svarteliste",
    'sa_user_whitelist' => "Brukers hviteliste",
    'sa_usr_disabled_by_srv' => "Personlige spamfiltreringsinnstillinger er ikke tillatt av systemadministratoren.",
    'sa_usr_no_postbox' => "Kan ikke aktivere filtrering av spam fordi postkassen er stengt av for denne e-postkontoen.",
    'sa_filters' => 'Spamfiltre',
    'spamfilter__tools_legend' => 'Verktøy',
    'spamfilter__prefs_legend' => 'Innstillinger',
    'spamfilter__max_children' => 'Maksimalt antall av worker spamd prosesser å kjøre',
    'spamfilter__rewrite_header_subject_hint' => 'La dette feltet være blankt hvis du ikke vil legge til noen tekst. Skriv _SCORE_ hvis du vil inkludere resultatet i meldingsemnet.',
    'spamfilter__reject_spam' => 'Slett søppelpost når den kommer til postboks',
    'spamfilter__enabled' => 'Slått på',
    'spamfilter_addresses_list__items' => 'adresser',
    'spamfilter_addresses__remove_title' => 'Følgende adresser vil bli fjernet fra liste:',
    'spamfilter_addresses__empty_selection' => 'Ingen adresser valgt.',
    'server__admin_info' => "Administrator-informasjon",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Skriv inn feilbeskrivelsen nedenfor",
    'server__power_management' => "Strømstyring",
    'server__services' => "Tjenester",
    'server__system' => "System",
    'server__title' => "Serveradministrasjon",
    'server_preferences__admin_skin' => "Skin for administratorgrensesnitt",
    'server_preferences__default_language' => "Standardspråk",
    'server_preferences__default_skin' => "Standard skin",
    'server_preferences__restart_apache_interval' => "Apache omstart intervall",
    'server_preferences__system' => 'Systeminnstillinger',
    'mail__tabs_preferences' => "Innstillinger",
    'mail__tabs_white_list' => "Hviteliste",
    'server_preferences__use_vocabulary' => "Kontroller passordene for postbokser i ordliste",
    'sessions__agreement' => "Ja, jeg vil avslutte disse øktene.",
    'sessions__select_sessions_for_remove' => "Velg økter som skal avsluttes.",
    'sessions__tabs_cp_sessions' => 'Plesk-økter',
    'sessions__tabs_ftp_sessions' => 'FTP økter',
    'sessions__ftp_sessions_login' => 'FTP-konto brukernavn',
    'sessions__ftp_sessions_domain' => 'Domenenavn',
    'sessions__ftp_sessions_path' => 'Gjeldende lokasjon',
    'sessions__ftp_sessions_file' => 'Filnavn',
    'sessions__ftp_sessions_action' => 'Status',
    'sessions__ftp_sessions_speed' => 'Hastighet, KB/S',
    'sessions__ftp_sessions_comp' => 'Fremdrift, %',

    'site_apps__access_level' => 'Tilgangsnivå',
    'site_apps__access_level_commercial' => 'Kommersielt',
    'site_apps__access_level_free' => 'Frigjør',
    'site_apps__action_installer' => "Installasjon av webprogram",
    'site_apps__action_reconfigure' => "Omkonfigurering av webprogram",
    'site_apps__custom_button_level' => 'Ønsker du å opprette en brukerdefinert knapp for å gå inn på dette programmet?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Nei',
    'site_apps__custom_button_level_domain_user_only' => 'Ja',
    'site_apps__custom_button_level_false' => 'Nei',
    'site_apps__custom_button_level_domain' => 'Ja, og gjør den kun tilgjengelig for det aktive domenet',
    'site_apps__custom_button_level_client' => 'Ja, og gjør den tilgjengelig for alle kundens domener',
    'site_apps__custom_button_level_admin' => 'Ja, og gjør den tilgjengelig for alle domener',
    'site_apps__description' => "Beskrivelse",
    'site_apps__dir_used_by_sapp__' => "Mappen \"%1\" er i bruk av et annet webprogram",
    'site_apps__dir_used_by_unknown__' => "Mappen \"%1\" finnes allerede Hvis du fortsetter vil innholdet bli overskrevet.",
    'site_apps__dir_invalid_name__' => "Mappenavnet %1 er feil",
    'site_apps__file_name' => 'Filnavn på webprogram',
    'site_apps__invalid_install_prefix' => "Ugyldig installasjonsprefiks",
    'site_apps__invalid_package' => "Webprogram er ugyldig",
    'site_apps__key_status' => 'Lisensiering',
    'site_apps__key_status_free' => 'Distribueres fritt. Ingen lisensnøkkel kreves',
    'site_apps__key_status_ok' => 'Den nødvendige lisensnøkkelen er installert',
    'site_apps__key_status_problem' => 'Den nødvendige lisensnøkkelen er ikke installert',
    'site_apps__name' => "Navn",
    'site_apps__no_domains' => 'Webprogrammet kunne ikke installeres. Det finnes allerede et annet webprogram installert i rotmappen for dette domenet. Vurder opprettelse av et underdomene for webprogrammet.',
    'site_apps__package_info_' => "Informasjon om webprogram",
    'site_apps__package_integrated' => "innebygd program, kan ikke fjernes",
    'site_apps__pool_select_packages_to_add' => 'Velg webprogrammer som skal legges til utvalget',
    'site_apps__release' => "Frigi",
    'site_apps__resource_used_by_sapp' => "Denne ressursen benyttes av installert webprogram",
    'site_apps__root_used_by_sapp' => "Denne ressursen brukes av av et installert webprogram",
    'site_apps__these_domains_will_not_delete' => 'Disse (under)domenene vil ikke bli slettet',
    'site_apps__upload_site_app_pkg_title' => 'Last opp det nye webprogrammet',
    'site_apps__version' => "Versjon",
    'site_apps__access_to' => "Tilgang til %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Mal for virtuell vert",
    'skeleton__client_label' => "%1 mal for virtuell vert",
    'skeleton__admin_page' => "Administrer mal for virtuell vert",
    'skeleton__files_list' => "Administrer filer og mapper",
    'skeleton__archiver_not_installed' => "Kan ikke pakke opp arkivet. Archiver er kanskje ikke installert på serveren Kontakt {$PROD_NAME} administrator for å få arkiveringsprogrammet installert.",
    'skeleton__client_page' => "Administrer mal for virtuell vert",
    'skeleton__archive_corrupted' => "En kontroll av arkivet oppdaget at arkivfilen enten er korrupt, eller at denne filtypen ikke støttes.",
    'skeleton__archive_too_large' => "En kontroll av arkivet oppdaget at arkivfilen enten er for stor.",
    'skeleton__not_supported_archive_type' => "Denne typen av arkiv (file %1) støttes ikke.",
    'skeleton__upload_archive_file' => "Last opp arkivfil",
    'skin_download__title' => 'Last ned skin',
    'skin_download_now__title' => 'Skin nedlasting pågår',
    'skin_download_now__text' => 'Opprettelse av skin-pakken pågår.<br>Denne prosedyren kan ta litt tid.<br>Med en gang dialogvinduet vises, kan du fortsette å jobbe med Plesk.',
    'skin_file__help_for_using_types' => "Vennligst bruk skins arkivene i et av de følgende formatene:",
    'skin_info__title' => 'Skin egenskaper',
    'skin_mng_err__rpm_not_skin' => 'Denne RPM er ikke en Plesk skinpakke',
    'skin_mng_err__psa_install_noreloc' => 'Feilet i å installere rpm-basert skin på den angitte plassen.',
    'skin_mng_err__already_exists' => 'Skininstallasjonsmappen finnes allerede, og en skinpakke er distribuert.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Den opplastede filen er ikke en gyldig RPM skin pakke.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Den opplastede filen er ikke en gyldig skin pakke.',
    'skin_mng_err__rpm_upgrade_base' => "Den opplastede filen er ikke en gyldig {$PROD_NAME} skin pakke.",
    'skin_mng_err__rpm_upgrade_other' => 'Kan ikke installere skin: ugyldig skin format.',
    'skin_mng_err__no_a_skin' => "Den opplastede filen er ikke en gyldig {$PROD_NAME} skin pakke.",
    'skin_upload__title' => 'Last opp nytt skin',
    'skin_upload__already_exists' => "Skin '%1' finnes allerede.",
    'skin_upload__unable_to_apply' => "Den opplastede fil inneholder ikke et Plesk-skin, eller arkivformatet er ikke støttet.",
    'skin_upload__unable_to_rename__' => "Kan ikke døpe om skin %2 til %1: %3.",
    'skin_upload__file_name' => 'Bane til skin pakkefilen',
    'skins_list__title' => 'Lager av skin',
    'skins_remove__title' => 'Fjerning av skin',
    'skins_remove__select_skins_for_remove' => 'Velg de skallene som skal fjernes.',

    'spf__unable_update' => 'Kan ikke oppdatere SPF parametere',
    'statistics__active_domains' => "Aktive domener",
    'statistics__clients' => "Kunder",
    'statistics__subdomains' => "Underdomener",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Databaser",
    'statistics__db_users' => "Databasebrukere",
    'statistics__dirs' => "Beskyttede mapper",
    'statistics__dom_active' => "Aktiv",
    'statistics__dom_passive' => "Passiv",
    'statistics__dom_problem' => "Problem",
    'statistics__domains' => "Domener",
    'statistics__domains_with_host' => "Domener med hosting",
    'statistics__doms' => "Domener",
    'statistics__filesystem' => "Filsystem:",
    'statistics__general' => "Generelt",
    'statistics__hdd_available' => "Tilgjengelig",
    'statistics__hdd_capacity' => "Kapasitet",
    'statistics__hdd_total' => "Totalt",
    'statistics__hdd_usage' => "Forbruk av harddisk",
    'statistics__hdd_used' => "Brukt",
    'statistics__ip' => "IP-adresse",
    'statistics__key_number' => "Nøkkelnummer",
    'statistics__l1' => "Siste 1 minutt",
    'statistics__l15' => "Siste 15 minutter",
    'statistics__l5' => "Siste 5 minutter",
    'statistics__la' => "CPU-bruk",
    'statistics__mail_autoresponders' => "Autosvar",
    'statistics__mail_boxes' => "Postbokser",
    'statistics__mail_groups' => "E-postgruppe",
    'statistics__mail_lists' => "Adresselister",
    'statistics__mail_redirects' => "Videresendere for e-post.",
    'statistics__mem' => "Minnebruk",
    'statistics__mem_usage' => "Bruk",
    'statistics__memory_available' => "Tilgjengelig",
    'statistics__memory_buffer' => "Buffer",
    'statistics__memory_cached' => "Hurtigbufret",
    'statistics__memory_free' => "Frigjør",
    'statistics__memory_shared' => "Delt",
    'statistics__memory_total' => "Totalt",
    'statistics__memory_used' => "Brukt",
    'statistics__os' => "OS",
    'statistics__problem_clients' => "Problemkunder",
    'statistics__problem_domains' => "Problemdomener",
    'statistics__swap' => "Bruk av swap",
    'statistics__swap_free' => "Frigjør",
    'statistics__swap_total' => "Totalt",
    'statistics__swap_usage' => "Bruk",
    'statistics__swap_used' => "Brukt",
    'statistics__system_stat' => "Serverinformasjon",
    'statistics__unable_define_active_doms' => "Kunne ikke finne antall aktive domener: %1",
    'statistics__unable_define_inactive_doms' => "Kunne ikke finne antall inaktive domener: %1",
    'statistics__failed_define_swap_usage' => 'Kunne ikke definere byttebruk',
    'statistics__failed_define_load_averages' => 'Kunne ikke definere belastningsgjennomsnitt',
    'statistics__up_time' => "System oppetid:",
    'statistics__ver' => "Versjon",
    'statistics__web_users' => "Webbrukere",
    'statistics__mem_win' => "Bruk av fysisk minne",
    'statistics__memory_total_win' => "Totalt",
    'statistics__memory_used_win' => "Brukt",
    'statistics__memory_free_win' => "Tilgjengelig",
    'statistics__swap_win' => "Bruk av virtuelt minne",
    'statistics__swap_total_win' => "Totalt",
    'statistics__swap_used_win' => "Brukt",
    'statistics__swap_free_win' => "Tilgjengelig",
    'status__domain_has_reasons_to_be_off' => "Domenet er fremdeles suspendert av følgende årsak: %1",
    'subdomain__create__' => "Opprette et underdomene for domene %1",
    'subdomain__edit__' => "Administrer underdomene %1",
    'subdomain__invalid_name' => "Ugyldig underdomenenavn: bruk bare alfanumerisk og bindestrek.",
    'subdomain__incorrect_name' => "Ugyldig underdomenenavn.",
    'subdomains__maillists_enabled_in_domain' => "Feil navnelister med underdomener.%1: dette domenenavnet er allerede i bruk av adresselister under domenet %1.",
    'subdomains__dalias_exists' => 'Et domenealias med dette navnet finnes allerede.',
    'subdomains__name_exists' => "Et underdomene med dette navnet finnes allerede.",
    'subdomains__regular_domain_exists' => "Et domene med dette navnet finnes allerede.",
    'subdomains__domain_alias_exists' => 'Et domenealias med dette navnet finnes allerede.',
    'subdomains__remove_subdomains_on_domain' => "Følgende underdomener for domene %1 vil bli fjernet:",
    'subdomains__select_subdomains_for_remove' => "Velg underdomener som skal fjernes.",
    'subdomains__webmail_enabled_in_domain' => "Feil navn på eposttjeneste for underdomene.%1: dette domenenavnet benyttes for å gå inn på eposttjeneste under domenet %1.",
    'subdomains__dns_record_already_exists' => 'Kunne ikke opprette underdomene %1 fordi det allerede finnes en DNS-oppføring som peker på vert %1.',
    'subdomains__www_prefix_in_domain' => "Feil navn på underdomene www.%1: domenet %1 har allerede prefiks WWW.",
    'subdomains__user_type_quota_exceeds' => 'Kan ikke endre brukerkontoen fordi dette ville resultert i overskridelse av tildelt diskplass.',
    'subdomains__creation_in_dns_slave' => "Navneserveren for Plesk fungerer som en sekundær navneserver for dette domenet. For at underdomenet skal løses riktig, må du sørge for at sonefilen på den primære DNS-serveren inneholder oppføringen %1.",
    'sys_user__attributes_not_changed' => "\nFølgende systembruker attributter ble ikke endret: %1",
    'sys_user__no_access_without_password' => "Du satte ikke et passord. Systembrukeren ble opprettet, men vil ikke kunne logge inn på systemet før han eller hun får et passord. Vil du fortsette?",
    'sys_user__no_hard_quota' => "ikke støttet",
    'sysuser__zero_quota_is_unlimited' => "0 for ubegrenset",
    'template__num_excl_ips' => "Tildel dedikerte IP-adresser til kunden",
    'template__sel_sh_ips' => "Valgte delte IP adresser",
    'template__av_sh_ips' => "Tilgjengelige delte IP adresser",
    'template__up_to_excl_ip' => "Opptil %1 IP adresser",
    'templates__all_clients' => "alle kunder",
    'templates__cl_domain_templates' => "Maler for %1",
    'templates__cl_templates' => "Kundemaler",
    'time__invalid_ip' => "Ugyldig IP-adresse eller domenenavn.",
    '__please_select_country' => 'Velg landet ditt',
    'time__unable_set_time' => "Kan ikke angi systemtiden: %1",
    'time__sinchronization_setup_error' => 'Kan ikke konfiguerere tidssynkronisering: timemng mislyktes: %1',
    'time__sinchronization_disable_error' => 'Kunne ikke deaktivere tidssynkronisering: timemng mislyktes: %1',
    'tmpl__create' => "Opprett mal",
    'tmpl__edit__' => 'Mal %1',
    'tmpl__logrotation_warn' => "Loggrotasjon på domenet som opprettes av denne malen vil kun bli utført i tilfelle påfølgende opprettelse av fysisk hosting for det.",
    'tmpl__name' => "Malnavn",
    'tmpl__dom_exist' => "En domenemal med dette navnet finnes allerede i administratorens eller kundens malutvalg.",
    'tmpl__name_invalid' => "Navnet på malen er ugyldig eller tomt.",
    'tmpl__use_next_ip_addr' => "Neste ledige IP adresse vil benyttes",
    'tmpl_name_already_exists' => "Det finnes allerede en mal med navnet '%1'.",
    'traffic__no_periods_found' => "Kan ikke vise web- og trafikkstatistikk. Denne funksjonen vil bare være tilgjengelig etter neste statistikkberegning.",

    'vh_based__no_free_ip_for_vh' => "Det finnes ingen tomme IP-adresser for IP-basert virtuell hosting. Vennligst legg til en IP adresse.",

    'wu__at_domains_text' => "Tillat webuser@%1 tilgangsformat",
    'wu__unable_create' => "Kan ikke opprette webbruker: %1",
    'wu_edit__disk_quota' => "Diskkvote",
    'wu_edit__invalid_pass' => "Passordet er ugyldig.",
    'wu_edit__invalid_quota' => "Den spesifiserte kvoteverdien for diskplass er ugyldig. Fyll inn et positivt heltall.",
    'wu_edit__invalid_quota_value' => "Den spesifiserte kvoteverdien for diskplass er mindre enn det som benyttes nå (%1MB). Endel funksjonalitet kan komme til å bli utilgjengelig. Er du sikker på at du vil fortsette?",
    'wu_edit__not_create_pass' => "Denne handlingen vil ikke opprette et passord for den nye webbrukeren.\nUten passord vil brukeren ikke kunne logge inn.",
    'wu_edit__unable_update' => "Kan ikke oppdatere webbrukeregenskap: %1",

    'bt_webdirs' => 'Virtuelle mapper',

    'dns__tabs_general' => 'Soneinnstillinger',
    'dns__tabs_zone_settings' => 'SOA oppføringer',
    'soa__seconds' => 'sekunder',
    'soa__minutes' => 'minutter',
    'soa__hours' => 'timer',
    'soa__days' => 'dager',

    'DomainSubdirectory' => 'Destinasjons undermappe',

    'filemanager__select_codepage' => 'Velg kodeside:',

    'bt_server_app_add' => 'Legg til serverprogram',
    'packages_list' => 'Serverprogrammer',

    'bt_packages_management' => 'Administrasjon av pakker',
    'pb__packages_management' => 'Programstyring',
    'bt_package_new' => 'Legg til applikasjon',
    '__packages' => 'Serverprogrammer',

    'dom_ctrl__mysql_dbase_space' => 'Sum kvote av MySQL-databaser',
    'dom_ctrl__mssql_dbase_space' => 'Sum kvote av MS SQL-databaser',

    'dns_add__enter_ixfr_path' => 'Angi IXFR banen',

    'cmd_dns__txt_dns_record_already_exist' => 'SPF TXT oppføring finnes allerede. Det kan bare finnes en SPF oppføring. For å legge til en oppføring, slett først den eksisterende.',

    'component_name__network' => 'Nettverk',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Sett skin',
    'bt_set_skin' => 'Sett skin',
    'firewall__rule_already_exists' => 'Regel med navnet "%1" finnes allerede',
    'firewall__rule_readonly' => 'Regel «%1» er skrivebeskyttet',
    'pb__firewall' => 'Brannmur',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Filplasseringen er ugyldig.',

    'error_doc__erorr_invalid_url_location' =>  'Feil URL format. Vennligst angi en absolutt URL innen den virtuelle verten (nettsted).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Antivirus',
    'antivirus__antivirus' => 'Antivirus beskyttelse',
    'antivirus__antivirus_direction_off' => 'Slått av',
    'antivirus__antivirus_direction_any' => 'Innkommende og utgående e-post',
    'antivirus__antivirus_direction_from' => 'Kun utgående e-post',
    'antivirus__antivirus_direction_to' => 'Kun innkommende e-post',
    'antivirus__unable_to_update_settings' => 'Kan ikke endre antivirusinnstillinger: %1',




    '__normal' => 'Normal',
    '__low' => 'Lav',
    '__high' => 'Høy',

    'mail__antivirus' => "Intern e-postservers antivirus",
    'mail__use_internal_antivirus' => 'Bruk intern antivirus',

    'sa__tabs_blacklist' => 'Svarteliste',

    '__mysql_databases' => 'MySQL databaser',

    'cl_perm__mysql_dbase_space' => 'Sum kvote av MySQL-databaser',
    'cl_perm__mssql_dbase_space' => 'Sum kvote av MS SQL-databaser',
    'cl_perm__max_mssql_db' => 'Maksimalt antall Microsoft SQL Server-databaser',
    'cl_perm__total_mboxes_quota' => 'Total kvote for e-postbokser',

    'i_i_cl_on' => 'Kundekontoen er aktiv.',
    'i_i_cl_off_by_admin' => 'Kundekonto er suspendert av administrator.',

    'sa_exists_tn' => 'Nettverket er allerede i listen.',

    'webdir__select_vdirs_to_remove' => 'Velg mapper du ønsker å slette',
    'webdir__select_mime_types_to_remove' => 'Velg MIME-typer du ønsker å slette',

    'defaultcomponents__not_activated' => 'ikke aktivert',

    'bt_traffic_at_domains' => 'Trafikk',

    '__awstats_perl_warning' => 'Hvis Perl ikke er installert, vil ikke AWStats la brukere sjekke statistikk for tidligere år.',

    'class_client__mysql_dbase_space' => 'Verdien overstiger kundens grense.',
    'class_client__mssql_dbase_space' => 'Verdien overstiger kundens grense.',
    'class_client__max_mssql_db' => 'Verdien overstiger kundens grense.',

    'dns__remove_transfer_restrictions_list_items' => 'Følgende nettverk vil bli fjernet fra tilgangskontrollisten:',

    'bt_up' => "Opp",
    'bt_down' => "Ned",
    'virtualdir__type_default_doc_name_to_add' => 'Angi et filnavn å legge til listen',
    'virtualdir__select_default_doc_to_remove' => 'Velg filer for å fjerne fra liste',
    'virtualdir__select_directory' => 'Velg en mappe',

    'bt_install_selected' => 'Installer valgte lisensnøkler', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Domenet løses til en annen IP-adresse: (%1). Korriger DNS-innstillingene.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'E-postserveren som er i bruk støtter ikke både postbokser og e-postgrupper slått på samtidig. Trykk Ok for å slå på postboks på bekostning av e-postgrupper som da slås av. Klikk Kanseller for å la alt være intakt.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'E-postserveren som er i bruk støtter ikke både postbokser og e-postgrupper slått på samtidig. Trykk Ok for å slå på e-postgruppe på bekostning av postboks som da slås av. Klikk Kanseller for å la alt være intakt.',

    'mysql_dbase_space_limit' => 'MySQL databaseplassgrense',
    'mysql_dbase_usage' => 'MySQL databaseplassbruk',
    'mssql_dbase_space_limit' => 'Områdebegrensning for Microsoft SQL Server-database',
    'mssql_dbase_usage' => 'Områdebruk for Microsoft SQL Server-database',

    '__statistics' => "statistikk", //indirect

    'dns__soa_minimum_value_is_big' => 'Innstilling av minimum TTL-verdi som er mer enn 3 timer kan gjøre domenene dine utilgjengelige for noen av domeneadministratorene. Det anbefales å sette denne verdien kun hvis domenenamnregistratoren insisterer på dette.',

    'virusfilter__interface_not_available' => 'Ingen virus filtre er tilgjengelige.',
    'virusfilter__none_virus_filter' => 'Ingen',
    'virusfilter__mailname_status_text' => 'Antivirus (%1)',
    'virusfilter__status_none' => 'slått av',
    'virusfilter__status_any' => 'innkommende og utgående e-post',
    'virusfilter__status_outgoing' => 'bare utgående e-post',
    'virusfilter__status_incoming' => 'bare innkommende e-post',

    'visibility__root_override_parse_error' => 'Det finnes en syntaksfeil i filen %1 i linje %2.',

    'sb__not_support_publishing_api' => "Utgivelse automatisering støttes ikke av komponenten",

    'component_name__cphosting' => "Plesk Hosting",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Sette opp e-postbokskvote er ikke støttet av gjeldende e-postserver.',
    '__unable_get_total_mboxes_quota' => 'Sette opp e-postbokskvote er ikke støttet av gjeldende e-postserver.',

    'install_prefix__parent_not_exists' => "Overordnet mappe finnes ikke.",

    'bt_change_version' => 'Endre versjon',
    'aspdotnet__changeversion_title' => 'Velger ASP.NET versjon.',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Velg alle",
    '__uncheck_all' => "Fjern alle",

    'dns__editing_domain_controller_zone' => "Redigering av DNS-soneoppføringer for domenekontroller kan føre til problemer med domenefunksjonalitet",

    'pb__interface_management' => "Grensesnitt administrasjon",
    'interface_management__tabs_skins' => "Skall",
    'interface_management__tabs_interface_templates' => "Grensesnitt maler",
    'interface_management__tabs_locales' => "Nasjonale innstillinger",
    'locales_list__title' => "Lager for språkpakker",
    'locales_list__legend' => "Tilgjengelige språk",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Språkpakke",
    'locales_list__lang_title' => "Språk",
    'locales_list__country_title' => "Land",
    'locales_list__used_title' => "Brukt",

    'backup__suspend_warning_during_backup' => "Domenet vil ikke være tilgjengelig under sikkerhetskopieringen",
    'backup__suspend_warning_during_restore' => "Domenet vil ikke være tilgjengelig under gjenopprettingsprosessen",
    'backup__suspend_domain' => "Suspender domene",

    'locales_list__mls_limit' => "Den aktive lisensen din for Plesk tillater bruk av %2 språk. For øyeblikket har du %1 språk satt tilgjengelig for brukere, som overskrider antallet som tildeles med lisensen. Velg %2 språk du vil som skal brukes, og gjør resten utilgjengelig ved å klikke på ikonene deres i 'S'-kolonnen.",

    'bt_change_owner' => 'Tilordne ny eier',
    'chown__new_owner' => 'Ny eier',
    'chown__selected_domains' => 'Valgte abonnementer',
    'chown__limits_legend' => 'Ressurser',
    'chown__limit_name' => 'Ressursnavn',
    'chown__limit_value' => 'Allokerte ressurser',
    'chown__limit_assigned_before' => 'Før overføring',
    'chown__limit_assigned_after' => 'Etter overføring',
    'chown__error_limits' => "Kunne ikke fortsette overføring av abonnementet: dette abonnementet krever flere ressurser enn de som kan leveres av leverandøren til den nye eieren.",
    'chown__error_no_domains' => 'Kunne ikke fortsette overføring av abonnement: enten er ingen abonnementer valgt, eller så tilhører de valgte abonnementene målbrukeren allerede.',
    'chown__error_empty_ip_pool' => "Kunne ikke fortsette overføring av abonnement: IP-utvalget til den nye eierens leverandør er tomt. Pass på at leverandøren har minst én IP-adresse i utvalget.",
    'chown__please_select_new_domain_owner' => 'Velg den nye eieren for dette abonnementet',
    'chown__old_ip_address' => 'Nåværende IP adresse',
    'chown__new_ip_address' => 'Ny IP-adresse',

    'chown__error_ssl_already_used' => "SSL/TLS-støtte er allerede i bruk på følgende mål-IP’er: %1 Derfor kunne ikke følgende domener med SSL/TLS-støtte overføres: %2. Vennligst løs problemet og prøv igjen",
    'chown__sitebuilder_not_installed' => 'Presence Builder er ikke installert',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Domene %1 kan ikke overføres til en annen eier fordi Presence Builder ikke er installert.',

    'backup__backup_time' => 'Tid for sikkerhetskopi',
    'backup__backup_time_hour' => 'timer',
    'backup__backup_time_minute' => 'minutter',
    'backup__every' => 'hver(t)',
    'backup__day_of_month' => 'Dag i måned',

    'subdomain__select_hst_type' => 'Velg hostingtype for underdomenet',
    'hst_sel__subdom_subfolder_hst' => 'Underdomene på undermappe.',
    'subdomain__www_root_folder_not_exists' => 'Område-hjemmemappen %1 finnes ikke',
    '__site_home_dir' => 'Områdets hjemmemappe',
    'subdomain__aspnet_disabled_domain' => 'slått av etter domene',

    'domains__remove_description' => 'Alle domenedata, inkludert domene og innhold og innstillinger for tilhørende underdomener, data for webprogrammer, innhold i postbokser, epost, innstillinger for antivirus og spamfiltrering, loggfiler, repositoriedata for sikkerhetskopi av domene og SSL/TLS-sertifikater vil bli slettet. Hvis du ikke har en sikkerhetskopifil på din lokal maskin, vil alle data være tapt for alltid.',
    'subdomains__remove_description' => 'Alle data om underdomene, inkludert innhold og innstillinger, data i webprogrammer og loggfiler vil bli slettet. Hvis du ikke har en sikkerhetskopifil på din lokal maskin, vil alle data være tapt for alltid.',

    'mail__tabs_spam_filtering' => 'Spamfiltrering',
    'mail__tabs_antivirus' => 'Antivirus',
    'antivirus__use_server_settings_scan' => 'Bruk standard globale innstillinger (Skann)',
    'antivirus__use_server_settings_no_scan' => 'Bruk standard globale innstillinger (ikke skann)',
    'antivirus__check_for_viruses' => 'Skann etter virus',
    'antivirus__dont_check_for_viruses' => 'Ikke skann etter virus',
    'antivirus__incoming_mail' => 'Innkommende e-post',
    'antivirus__outgoing_mail' => 'Utgående e-post',

    'domain_alias__CNAME_dns_record_exists' => 'En DNS CNAME-oppføring med dette navnet eksisterer allerede',
    'domain_alias__A_dns_record_exists' => 'En DNS-oppføring med dette navnet eksisterer allerede',
    'domain_alias__bad_prefix' => 'Feil prefiks for domenealias',
    'domain_alias__domain_doesnt_exist' => "Domenet eksisterer ikke",

    'dns__zone_ttl_message_info' => 'Hvis TTL-verdien ikke er spesifisert, vil TTL-verdien i SOA-malen (%1) brukes til denne DNS-oppføringen.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "En fil ved navn index.html vil bli opprettet for omdirigering til det valgte webprogrammet. Om en fil ved navn index.html allerede eksisterer, vil den sikkerhetskopieres som index.html.old og erstattes av den nye. Trykk OK for å bekrefte.",

    'bt_ftp_ctrl' => "Ekstra FTP-kontoer",
    'ftp_users_no_permission' => "Du har ikke tillatelse til å administrere FTP-kontoer for dette domenet",
    'ftp_users_limit_reached' => "Grense for FTP-kontoer er nådd for dette domenet",
    'pb__ftp_ctrl' => "FTP administrasjon",
    'class_client__max_subftp_users' => "Ekstra FTP-kontoer",

    '__client_form_settings' => "Kundeinnstillinger",
    '__sbnet_client_keep_sbnet' => "Behold samsvarende brukerkonto inn Presence Builder",
    '__sbnet_cant_add_more_sites' => "Grensen for antall nettsteder som kan bruke Presence Builder er nådd for denne kunden",
    '__sbnet_legend_text' => "Presence Builder integrasjon",
    '__sbnet_synchronize_user_with_sbnet' => "Opprett en samsvarende brukerkonto i Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Du prøver å fjerne brukerkonto for Presence Builder som er tilknyttet denne kunden. Dette vil slette alle brukerens nettsteder og andre relevante innstillinger fra Presence Builder-systemet, og fjerne muligheten til å redigere eksisterende nettsteder i Presence Builder, selv om du slår på dette alternativet senere. Hvis du opprettelse en Presence Builder brukerkonto på nytt senere, du har til opprettelse og publiser alle din nettsted fra tenkende smilefjes. Ønsker du å slå av nettstedopprettelse og publisering med Presence Builder?",
    'sb__build_site_with_subdomains' => "Create Blog og Photo Gallery underdomener",
    '__sbnet_client_dont_have_sbuser' => "Kan ikke opprette og publiser område ved hjelp av Presence Builder: Presence Builder-bruker finnes ikke",

    '__component_disabled' => "Komponenten slått av",

    'subdomains__physical_path_not_exist' => "Det finnes underdomener som er koblet til ikke-eksisterende fysiske mapper",

    'dnsserver_bind_to_msdns_switching_warning' => "Advarsel: bare de første 254 IP-adressene av delnett med /8 og /16-maske plassert i tilgangskontroll-liste vil bli overført. De vil overføres som separate IP adresser. Vil du fortsette?",

    '__sbnet_net_framework_required_for_site' => "Presence Builder-nettsteder kan kreve støtte for ASP.NET 2.0 på domenet ditt. Vi anbefaler å aktivere støtte for ASP.NET 2.0 hvis du bruker Presence Builder.",

    'subdomain_auto_create_dir' => "Opprette fysisk mappe for underdomene",

    'sa_trainer__unable_to_get_messages_list' => "Kan ikke hente liste over meldinger i postboksen: %1",
    'sa_trainer__pass_doesnt_exist' => "Passordet for denne e-postkontoen mangler",

    '__sitebuilder_error' => "Det oppstod en feil under forsøk på å koble til Presence Builder. Ta kontakt med tjenesteleverandøren din for assistanse.",
    'wsb_error_user_not_exist' => "Denne Presence Builder brukerkontoen finnes ikke.",
    'wsb_error_site_already_exist' => "Dette området finnes allerede i Presence Builder.",
    'wsb_error_site_limit_reached' => "Begrensningen for antall Presence Builder-områder er nådd.",
    'wsb_error_internal_error' => "Intern Presence Builder feil oppstod. Ta kontakt med tjenesteleverandøren din for assistanse.",
    'wsb_error_user_already_exist' => "Presence Builder bruker med slikt navn eksisterer allerede i Presence Builder.",
    'sb_error_user_not_exist' => "Presence Builder brukeren finnes ikke.",
    'wsb_error_object_not_found' => "Presence Builder kunne ikke finne riktig vertoppføring.",

    'mg_no_mail_groups' => "Ingen e-postgruppe",

    'drweb__drweb_incoming' => 'Antiviruskontroll av innkommende e-post',
    'drweb__drweb_outgoing' => 'Antiviruskontroll av utgående e-post',
    'drweb__disable_reason_serv' => 'E-postserveren støtter ikke antivirusfilterinnstillinger på postboksnivå',

    'vz_sitebuilder3_client_cant_be_created' => "Kan ikke opprette kundekonto: SiteBuilder versjon 3.1 eller nyere er ikke installert",

    'chown__client_without_sitebuilder_support' => "Klarte ikke fortsette overføring av abonnement: Presence Builder-tjeneste er ikke inkludert i tjenesteplanen til den nye eieren eller leverandøren deres.",

    // new limits

    'class_client__max_odbc' => "ODBC tilkoblinger",
    'cl_perm__max_odbc' => "maksimalt antall ODBC tilkoblinger",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Navn på domenealias',
    'domain_alias__list_ascii_name' => 'I ASCII format',


    // Interface Customization Templates
    'interface_preferences' => 'Grensesnitt administrasjon',
    'pb__interface_templates' => 'Grensesnitt administrasjon',
    'pb__interface_clients' => 'Kunder som bruker %1',

    // service management
    'bt_service_showall' => "Vis alle",
    'bt_service_hideall' => "Skjul alle",
    'bt_service_start' => "Start",
    'bt_service_stop' => "Stopp",
    'bt_service_restart' => "Starte på nytt",
    'bt_service_disable' => "Slå av",
    'bt_service_manual' => "Manuell",
    'bt_service_auto' => "Auto",
    'service_startup_auto' => 'Automatisk',
    'service_startup_manual' => 'Manuell',
    'service_startup_disabled' => 'Slått av',
    'service_action_ok' => "Operasjonen med tjenesten %1 ble fullført",
    'service_action_failed_disabled_service' => "Kunne ikke fullføre operasjonen med tjenesten %1 fordi den er slått av",
    'service_action_failed_error' => "Kan ikke fullføre operasjonen: %1",
    'service_group_action_ok' => "Operasjonen for følgende tjenester ble utført: \n %1",
    'service_group_action_disabled' => "Kunne ikke fullføre operasjonen med følgende tjenester fordi de allerede er slått av: \n %1",
    'service_group_action_failed' => "Klarte ikke å fullføre operasjonen med følgende tjenester: \n %1. \n For å motta detaljert informasjon om feilen, utfør operasjonen for hver tjeneste separat",

    // php 4vs5
    'bt_php' => "PHP-innstillinger",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Tilgjengelige forhandlere',
    'massmail__resellers_list_selected' => 'Valgte forhandlere',
    'massmail__clients_list_available_for_select' => 'Tilgjengelige kunder',
    'massmail__clients_list_selected' => 'Valgte kunder',
    'massmail__advanced' => 'Avansert',
    'bt_massmail_send' => 'Send',
    'massmail__save_template_name' => 'Lagre tekst til en ny mal med navn',
    'massmail__template' => 'Mal',
    'massmail__compose_mail' => 'Melding',
    'massmail__from' => 'Fra',
    'massmail__to' => 'Til',
    'massmail__subject' => 'Emne',
    'massmail__body' => 'Meldingstekst',
    'massmail__body_hint' => 'Bruk <name> variablen for å automatisk sette inn brukerens navn i din melding.',
    'massmail__send_to_clients' => "Kunder",
    'massmail__send_to_domainusers' => "Domeneadministratorer",
    'massmail__send_to_admins' => "Plesk-administratorer",
    'massmail_select' => 'Velg adresser',
    'massmail_showhide_selected' => "Vis/skjul de valgte",
    'massmail_send_all' => "Alle",
    'massmail_send_selected' => "Kun de valgte",
    'massmail_send_except' => "Alle unntatt valgte",
    'bt_new_mass_mail_template' => "Legg til mal for masseutsendelse av e-post",
    '__mass_mail_templates_list' => "Liste over meldingmaler for masseutsendelse",
    'massmail__template_name' => 'Malnavn',
    'massmail__receivers' => 'Mottakere',
    'massmail__created' => 'Avsender',
    'massmail__date_created' => 'Opprettelsesdato',
    'massmail__compose' => 'Send',
    'mass_mail__resellers_all' => 'Alle forhandlere',
    'mass_mail__clients_all' => 'Alle kunder',
    'mass_mail__domainusers_all' => 'Alle domeneadministratorer',
    'mass_mail__resellers_selected' => 'Valgte forhandlere',
    'mass_mail__clients_selected' => 'Valgte kunder',
    'mass_mail__domainusers_selected' => 'Valgte domeneadministratorer',
    'mass_mail__resellers_except' => 'Alle forhandlere unntatt valgte',
    'mass_mail__clients_except' => 'Alle kunder unntatt valgte',
    'mass_mail__domainusers_except' => 'Alle domeneadministratorer unntatt valgte',
    'mass_mail__admins_all' => 'Alle administratorer',
    'massmailtemplateslist__title' => 'Meldingmal for masseutsendelse',
    'massmail__insert_from_template' => "Sett inn data fra mal",
    'massmail__select_template' => "Velg mal",
    'massmail__body_short_hint' => "(kun enkel tekst)",
    'massmail__from_short_hint' => "(e-post eller navn)",
    'bt_insert' => "Sett inn",
    'massmail__mail_send_successfully' => "Meldingen ble vellykket sendt",
    'massmail__mail_send_successfully_with_some_errors' => "Meldingen ble sendt, men flere feil oppstod. Det kan være at enkelte av mottagerne ikke mottar meldingen. Hvis du vil ha mer informasjon, se følgende loggfil: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Meldingen ble ikke sendt. Kontroller at som minst en mottaker er valgt og at Plesks e-postserver fungerer riktig. Hvis du vil ha mer informasjon, se følgende loggfil: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Data fra malen %1 ble vellykket satt inn.",
    'massmail__template_added_successfully' => "Meldingsmalen ble lagret med navnet %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Presence Builder databasefeil inntraff. Ta kontakt med tjenesteleverandøren din for assistanse.",
    'wsb_error_sitebuilder_access_denied_error' => "Kan ikke få tilgang filen: Presence Builder har ikke tilgangsrettigheter for den nødvendige filen eller mappen. Ta kontakt med tjenesteleverandøren din for assistanse.",
    'wsb_error_sitebuilder_connection_failed' => "Kan ikke forbinde til Presence Builder fordi forbindelsen var tapt. Ta kontakt med tjenesteleverandøren din for assistanse.",
    'wsb_error_critical_during_operation' => "Det oppstod en kritisk Presence Builder feil:\n%1",
    'wsb_error_license_during_operation' => "Det oppstod en lisensfeil i Presence Builder:\n%1",
    'wsb_error_during_operation' => "Presence Builder feil oppstod:\n%1",
    'wsb_error_license_error' => "Det ble funnet en lisensbegrensning for Presence Builder.",

    // Other
    '__confrim_service_stop' => "Advarsel! Hvis du stopper tjenesten %1, kan Plesk slutte å fungere. Er du sikker på at du ønsker å stoppe tjenesten %1?",
    'virtualdir__name_is_reserved' => "Dette navnet er reservert",
    'index_redirect_help_text' => 'Nå du vil bli automatisk omdirigert til det påkrevde nettstedet. Dersom din nettleser ikke støtter omdirigering, vennligst klikk %1 her %2',
    'bt_default_settings' => "Bruk standard",
    'logfiles__remove_failed' => "Kunne ikke slette fil %1: filen er låst av et annet program. Prøv på nytt senere",
    'subdomain__invalid_homedirectory' => "Angitt hjemmemappe for underdomene er ugyldig",
    'scheduler_item__empty_filename' => "Vennligst angi kjørbar fil som skal kjøres",
    'subdomains__overlapped_domain_exists' => 'Underdomenet overlappes av DNS-sonen for domene %1',
    'subdomains__overlapped_domain_alias_exists' => 'Underdomene overlappet av DNS-sone for domenealias %1',
    'services_action_none_selected' => 'Kunne ikke fullføre operasjonen: vennligst velg de nødvendige tjenestene',
    'cl_perm__max_subftp_users' => "Maksimalt antall av tillegg FTP-konto",
    'login_up__access_denied_no_cp_access' => 'Tilgang nektet. Du ikke har tillatelse til å åpne Plesk.',
    'drweb__disable_reason_admin' => "Antivirusfilter av på postboksnivå er ikke tillatt av serverens policy.",

    'webdirs__name_is_invalid' => 'Bruk bare alfanumeriske, understrekings- og bindestrektegn i mappenavn.',
    'webdirs__physical_path_is_invalid' => 'Fysisk bane er ugyldig eller eksisterer ikke',
    '__use_default' => 'Bruk standard',

    'webalizer_hidden_referrer__already_exist' => 'En slik oppføring eksisterer allerede.',
    'webalizer_group_referrer__already_exist' => 'En gruppereferanse med dette navnet finnes allerede.',

    'pb__dashboard' => 'Hjem',

    'server_interface__page_title' => 'Grensesnittinnstillinger for server',
    'server_interface__tabs_locales' => 'Nasjonale innstillinger',
    'server_interface__tabs_skins' => 'Skall',
    'server_interface__tabs_interface_templates' => 'Grensesnitt maler',
    'bt_server_interface' => 'Grensesnitt preferanser',
    'pb__server_interface' => 'Grensesnitt preferanser',

    'bt_wizard_next' => 'Neste >>',
    'bt_wizard_prev' => '<< Tilbake',

    '__limit_exceeded_max_dom_server' => 'Du kan ikke hoste flere domener på denne serveren fordi grensen for antall domener som tillates på serveren av lisensnøkkelen ble nådd. Ta kontakt med tjenesteleverandøren din for å løse dette problemet.',
    '__limit_exceeded_max_subdom_server' => 'Du kan ikke hoste flere underdomener på denne serveren. Vennligst ta kontakt med din tjenesteleverandør.',
    '__limit_exceeded_max_dom_aliases_server' => 'Du kan ikke sette opp flere domenealias på denne serveren. Vennligst ta kontakt med din tjenesteleverandør.',
    '__limit_exceeded_max_wu_server' => 'Du kan ikke opprette flere webbrukere fordi grensen for antall webbrukere som tillates på serveren av lisensnøkkelen ble nådd. Ta kontakt med tjenesteleverandøren din for å løse dette problemet.',
    '__limit_exceeded_max_mn_server' => 'Du kan ikke opprette flere epostkontoer fordi grensen for antall kunder epostkontoer som tillates på serveren av lisensnøkkelen er nådd. Ta kontakt med tjenesteleverandøren din for å løse dette problemet.',

    '__limit_exceeded_max_cl_useradmin' => 'Du har nådd grensen for antall kundekontoer definert av lisensnøkkel (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Du har nådd grensen for antall domener definert av lisensnøkkelen din (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Du har nådd grensen for antall underdomener definert av lisensnøkkelen din (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Du har nådd grensen for antall domenealias definert av lisensnøkkelen din (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Du har ingen ledig diskplass',
    '__limit_exceeded_max_wu_useradmin' => 'Du har nådd grensen for antall webbrukerkontoer som definert av lisensnøkkelen din (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Du har nådd grensen for antall databaser definert av lisensnøkkelen (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Du har nådd grensen for antall postbokser definert av lisensnøkkelen (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Du har nådd grensen for antall epostkontoer definert av lisensnøkkelen din (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Du har nådd grensen for antall distribusjonslister definert av lisensnøkkelen din (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Du har nådd grensen for antall domener (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Du har nådd grensen for antall underdomener (%2) som tillates av tjenesteleverandøren din',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Du har nådd grensen for antall domenealias (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Du har nådd grensen for bruk av diskplass (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Du har nådd grensen for bruk av båndbredde per måned (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Du har nådd grensen for antall webbrukere (%2) som tillates av tjenesteleverandøren din.',
    '__limit_exceeded_max_db_userclient' => 'Du har nådd grensen for antall databaser (%2)',
    '__limit_exceeded_max_box_userclient' => 'Du har nådd grensen for antall postbokser (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Du har nådd grensen for antall adresselister (%2)',
    '__limit_exceeded_expiration_userclient' => 'Din konto utløp %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Du har nådd grensen for antall underdomener (%2) som tillates av tjenesteleverandøren din',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Du har nådd grensen for antall domenealias (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Du har nådd grensen for bruk av diskplass (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Du har nådd grensen for bruk av båndbredde per måned (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Du har nådd grensen for antall webbrukerkontoer (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Du har nådd grensen for antall databaser (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Du har nådd grensen for antall postbokser (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Du har nådd grensen for antall adresselister (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Din konto utløp %2',

    'mmt__to_none' => 'Ingen',
    'mmt__to_admin' => 'Administrator',
    'mmt__to_resellers_all' => 'Alle forhandlere',
    'mmt__to_resellers_select' => 'Valgte forhandlere',
    'mmt__to_resellers_select__available' => 'Tilgjengelige forhandlere',
    'mmt__to_resellers_except' => 'Alle forhandlere unntatt valgte',
    'mmt__to_clients_all' => 'Alle kunder',
    'mmt__to_clients_select' => 'Valgte kunder',
    'mmt__to_clients_select__available' => 'Tilgjengelige kunder',
    'mmt__to_clients_except' => 'Alle kunder unntatt valgte',

    'mmt__unable_send_empty_selection' => 'Kan ikke massesende e-post, ingen e-postadresser valgt.',
    'mmt__unable_send_to__' => 'Kan ikke sende massee-post til:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Kunne ikke validere webprogram fordi én av de nødvendige filene (%1) ikke ble funnet. Kontakt din ansvarlige for støtte for å få hjelp.',
    'sapp_error_validation_spec_failed' => 'Det opplastede webprogrammet overholder ikke spesifikasjonene for AppPacks: %1.',
    'sapp_error_validation_register' => 'Kunne ikke registrere webprogram som befinner seg i mappen "%1": %2 Du bør fjerne webprogrammet fra serveren fordi det ikke vil fungere riktig.',

    'sapp__install_failed' => 'Installasjon av webprogram mislyktes: %1',
    'sapp__install_res_failed' => 'Feilet i opprettingen av den ønskede ressursen.',

    'server_preferences__subdomains_blog_and_photo' => 'Create Blog og Photo Gallery underdomener som standard',
    'plesk_key__blog_and_photo' => 'Avmerkingsboks for mulighet til å administrere standardtilstanden av Create Blog og Photo Gallery underdomener',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Kan ikke endre IP adresse typen til dedikert fordi den er tilordnet mer enn en bruker.',

    // 8.1.1

    '__write_modify_warning' => 'Å velge ytterligere skrive-/modifiseringstillatelser vil gjøre at noen webprogrammer fungerer riktig, men vil også vesentlig øke sikkerhetsrisikoen',
    '__write_modify_subdomain_warning' => 'Å velge ytterligere skrive-/modifiseringstillatelser vil gjøre at noen webprogrammer fungerer riktig, men vil også vesentlig øke sikkerhetsrisikoen',

    'phosting__php_incorrect_version_used' => "PHP versjonsproblemer ble oppdaget. For å løse disse problemene, velg avmerkingsboks med påkrevd PHP versjon nedenfor, og klikk OK. For å slå av PHP på dette domenet, klikk på OK uten å velge PHP-versjon",
    'fp__mail_preferences' => 'E-postinnstillinger',

    'mail__invalid_white_pattern' => 'Den spesifiserte verdien er ugyldig. Bruk følgende formater: e-post@eksempel.com for e-postadresser og eksempel.com for domener.',
    'mail__invalid_black_pattern' => 'Den angitte verdien er ugyldig. Bruk følgende format: epost@eksempel.com for epostadresser, eksempel.com for domener.',

    'resp_edit__reply_as_html' => 'Send som HTML',
    'exception__path_very_long' => "Banen er for lang. Vennligst forsikre deg om at det er mindre enn %1 tegn i banen.",

    // 8.2


    //SAPP
    'sapp_on' => 'På',
    'sapp_off' => 'Av',
    'sapp_directive_aspect' => 'Påkrevd',
    'sapp_databases_num' => 'Databaser',
    'sapp_db_required' => 'Påkrevd',
    'sapp_Required' => 'Påkrevd',
    'sapp_Variant' => 'Variant',
    'sapp_db_id' => 'Database-ID',
    'sapp_db_id_type' => 'DB (id: %1) type',
    'sapp_db_id_min_version' => 'DB (id: %1) min versjon',
    'sapp_db_id_table_prefix' => 'DB (id: %1) tabell prefiks',
    'sapp_Default' => 'Standardverdi',
    'sapp_apache_mod_req' => 'Apache modul',
    'sapp_dbtype_not_installed' => 'ikke installert',
    'sapp_apache_mod_not_installed' => 'ikke installert',
    'sapp__value_error_empty' => 'Tom verdi er ikke tillatt.',
    'sapp_error_invalid_type' => 'Programmet "%1" støtter ikke den forespurte handlingen.',
    'sapp_error_unknown_app_type' => 'Programtype støttes ikke: %1.',
    'sapp__ssl_text' => 'Installere program på "http://" eller "https://" virtuell vert?',
    'sapp__app_to_upgrade' => 'Programmer som skal oppgraderes',
    'sapp__upgrade_apps_title' => 'Oppgrader programmer',
    'sapp__upgrade_to_ver' => 'Oppgrader til versjon',
    'sapp__choose_pkg_ver' => 'Velg en pakke...',
    'sapp__pkg_cant_upgrade_pkg' => 'Pakken "%1" kan ikke benyttes for oppgradering av webprogrammet "%2".',
    'sapp__app_ugrade_error' => 'Klarte ikke å oppgradere programmet: %1. Vennligst ta kontakt med systemadministrator.',
    'sapp__no_suitable_db_found' => 'Ingen passende database funnet.',
    'sapp__upgrade_success' =>  'Programmet ble vellykket oppgradert.',
    'sapp__pkg_info_changelog' => 'Endringshistorikk',
    'sapp_requirement_legend' => 'Hostingfunksjoner som kreves av programmet',

    // other
    'bt_apply' => 'Bruk',
    'mn_edit__add_alias_if_mailbox_disabled' => 'For å opprette et e-postalias bør postboksen være slått på for denne epostkontoen. Slå på postboksen?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Å slå av postboksen vil fjerne e-postaliasene siden de vil slutte å virke. Slå av postboksen?',
    'antivirus__disable_reason_install' => 'Du kan ikke behandle antivirus fordi det er ikke installert.',
    'antivirus__disable_reason_key' => 'Du kan ikke administrere antivirus fordi den ikke er aktivert av en egnet lisensnøkkel.',
    'antivirus__disable_reason_deny_personal_settings' => 'Du kan ikke behandle antivirus fordi serverpolicyen ikke tillater personlige antivirusinnstillinger.',
    'change_foreign_user_password' => 'Endre passord',
    'change_foreign_user_password_hint' => "Brukeren hører ikke til dette programmet. Klikk på koblingen for å gå til et annet program og endre brukerens passord der. For å gjøre dette må du ha de riktige tillatelsene i programmet.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Streng format',
    'lang_unknown' => 'Ukjent språk',
    'pb__cl_ed' => 'Kundedetaljer',
    'pb__actionlog' => 'Handlingslogg',
    'pb__cl_limits' => 'Kundegrenser',
    'pb__edit' => 'Rediger',
    'pb__subdom_edit' => 'Hostinginnstillinger',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Gjør en sikkerhetskopi av postbokser innholdet.',

    'maillist_import_result' => "\nTotalt antall e-postadresser i filen: %1\nantall importert e-postadresser: %2\nantall allerede eksisterende e-postadresser: %3\nantall dupliserte e-postadresser i angitt fil: %4\nantall ugyldige e-postadresser i filen: %5",
    'maillist_import_error' => 'Kan ikke importere e-postadresseliste',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Filen du valgte er enten tom eller ikke et gyldig HTML-dokument ifølge valgte koding. Velg korrekt koding eller legg ganske enkelt til innhold til filen.",

    'dom_pref__external_mail_srv' => "Omdiriger til en ekstern e-postserver med IP-adressen:",
    'mn_edit__store_messages' => 'Postboks',

    // aps

    'sapp__before_upgrade_notice' => 'Det anbefales at du sikkerhetskopierer programmet og brukerdataene før du starter oppgraderingsprosessen.',
    'sapp__application_properties' => 'Programegenskaper',
    'sapp__application_root_descr' => 'Hovedsiden av programmet',

    'sapp__aps_license_invalid_id' => 'Lisensnøkkel har ugyldig ID: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Lisens med nøkkelnummer %1 finnes allerede i databasen.',
    'sapp__aps_lic_del_used' => 'Kunne ikke slette lisensnøkkelen, den benyttes av et av de installerte programmene.',
    'sapp__aps_lic_del_unknown' => 'Kunne ikke slette lisensnøkkelen: %1',
    'sapp__aps_cappi_duplicate' => "Programmet er allerede i programutvalget til denne kunden",
    'sapp__appi_not_shared_no_install' => "Programmet finnes ikke i kundens programutvalg. Hvis du ønsker å installere dette programmet på et nettsted, bør du først legge dette programmet til kundens programutvalg.",
    'sapp__appi_shared_not_client' => "Programmet finnes ikke i kundens programutvalg. Hvis du ønsker å oppgradere programmet til spesifisert versjon, bør du først legge denne programversjonen til kundens programutvalg.",
    'sapp__apply_license_script_not_found' => 'Klarte ikke finne skriptet "apply-license" for dette webprogrammet.',
    'sapp__unable_to_activate_key' => 'En feil oppstod under et forsøk på å aktivere en lisensnøkkel: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Du har webprogrammer installert som krever tilstedeværelsen av dette webprogrammet i systemet.',
    'sapp__unable_to_delete_ai_in_pool' => 'Dette programmet er fremdeles i programutvalget til en kunde. Hvis du ønsker å fjerne dette programmet, må du først fjerne det fra programutvalget til alle kundene eller gjøre det gratis.',
    'sapp__unable_to_delete_app_template' => 'Klarte ikke å fjerne programmet #%1: %2',
    'sapp__limit_exceeded_client' => 'Du har nådd grensen for antall ganger du kan installere dette webprogrammet (%2).',


    // atis module

    '_week_on' => 'uke på',
    '__week_first' => 'først',
    '__week_second' => 'sekund',
    '__week_third' => 'tredje',
    '__week_fourth' => 'fjerde',
    '__week_last' => 'siste',
    '__not_started' => 'Venter',
    '__started' => 'Kjører',
    '__cancel_pending' => 'Avbryter',
    '__canceled' => 'Avbrutt',
    '__error' => 'Feil',
    '__done' => 'Fullført',

    '__php_cgi_handler' => 'CGI-program',
    '__php_isapi_handler' => 'ISAPI-tillegg',
    '__php_fastcgi_handler' => 'FastCGI-program',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'Kjør som',

    'cf_dbfolder_text' =>'Databasemappe',
    'cf_isnewdb_text' => 'Lag database',
    'cf_isnewdb_title' => 'Velg avmerkingsboksen hvis databasen må opprettes',

    'pb__site_apps_upgrade' => 'Oppgradering av webprogram',

    'detach' => 'Koble fra',
    'preferences' => "Endre passord",

    'toolsbar__switch_user?' => "Er du sikker på at du vil logge inn under en annen brukerkonto?",
    '__aps_left' => 'Installasjoner som gjenstår',
    'aps__license_key' => 'Lisensnøkkel',
    'aps__download_code' => 'Nedlasting og aktiveringskode for lisensnøkkel',
    'aps__license_key_hint' => 'Hent fra lisensieringsserver ved hjelp av aktiveringskode',
    'aps__database_not_available' => 'ikke tilgjengelig, vennligst sjekk domene eller kundegrenser',
    'aps__yes' => 'ja',
    'aps__no' => 'nei',
    '__click_to_enlarge' => 'Klikk for å forstørre',
    'site_apps__back_to_list' => 'Gå tilbake til listen',
    'sapp__pkg_info_installation_requirements' => 'Installasjonskrav',
    '__close_window' => 'Lukk',

    //SAPP END

    'skin_info__already_default' => 'Dette skin\'et er allerede satt som standard.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Plesk Premium Antivirus-innstillinger for %1',
    'drweb:properties_legend' => 'Innstillinger',
    'drweb:status' => 'Kontrollerer e-post for virus',

    // sb integration
    'sitebuilder_wizard' => 'Presence Builder veiviser',
    'dom_site_builder' => 'Klikk for å åpne Presence Builder veiviseren.',
    'sb_plesk_admin_url' => 'Presence Builder server URL-adresse. Forsikre deg om at denne adressen oppløses ordentlig i DNS.',
    'sb_plesk_admin_login' => 'Brukernavn for serveradministrators pålogging til Presence Builder',
    'sb_plesk_admin_password' => 'Administrators passord',
    'sb_sitebuilder_preferences' => 'Presence Builder administratorpåloggingsinformasjon',
    'sb__server' => 'Presence Builder systemadministratorinnstillinger',
    'sb__sitebuilder_support' => 'Støtte for Presence Builder',
    'sb_keep_sb_user' => 'Behold samsvarende brukerkonto inn Presence Builder',
    'sb_create_sb_user' => 'Opprett en samsvarende brukerkonto i Presence Builder',
    'sb__build_site_using_sitebuilder' => "Opprett et nettsted ved hjelp av Presence Builder",
    'sb_no_current_sb_server_set' => 'Forbindelsen til Presence Builder er ikke konfigurert enda: du må legge til en A-oppføring i DNS-sonemalen som peker på serveren med Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Kan ikke hente frem informasjon fra Presence Builder systemet:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Kan ikke koble til Presence Builder: feil brukernavn eller passord.",
    'sb_init_sb_manager' => "Initialiserer Presence Builder manager: %1",
    'sb_err_couldnt_connect_sb' => "Feilet i tilkoblingen til Presence Builder systemet.",
    'sb_err_client_dont_have_sbuser' => "Denne kunden har ingen brukerkonto i Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder er ikke konfigurert.",
    'sb_err_you_dont_have_sbaccount' => "Godkjenning mislyktes i Presence Builder.",
    'sb_error_critical_during_operation' => "Følgende feil oppstod i Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Enkel pålogging-støtte er ikke slått på i Plesk.",

    'warning__super_zone_exist' => "Sone %1 ble opprettet, men dette sonenavn er undersone av en annen allerede eksisterende sone %2 som tilhører en annen bruker %3. Det er mulig, men pass på at du har valgt den riktige brukerkonto.",
    'error__super_zone_exist' => "Klarte ikke å opprette DNS-sone fordi supersonen tilhører en annen bruker.",

    'locales__files_not_exits' => 'Kan ikke endre nasjonal innstilling: de spesifiserte språkpakke filene for grensesnittet eksisterer ikke i systemet.',
    'locales__unavailable' => 'Kan ikke endre nasjonal innstilling: den spesifiserte språkpakke filen for grensesnittet er utilgjengelig.',

    // DB BU

    'pb__dbbackup_list' => 'Sikkerhetskopi av databasefiler',
    // server
    'dbbackup__server_backup_settings' => 'Sikkerhetskopi',
    'dbbackup__network_temp_dir' => 'Midlertidig nettverksmappe.',
    'dbbackup__network_user' => 'Brukernavn',
    'dbbackup__network_pass' => 'Passord',
    // domain
    'dbbackup__add_database_legend' => 'Gjenopprett sikkerhetskopiert database',
    'dbbackup__add_database_restore' => 'Gjenopprett database fra sikkerhetskopifilen.',
    'dbbackup__add_database_file' => 'Sikkerhetskopifil av database',
    'dbbackup__add_database_user' => 'Standard brukernavn',
    'dbbackup__add_database_pass' => 'Standard brukerpassord',
    'dbbackup__add_database_pass2' => 'Bekreft standard brukerpassord',

    'bt_dbbackup_now' => 'Sikkerhetskopier',

    'bt_repair' => 'Reparer',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Opplasting av databasedumper fra SQL-server er forbudt av hostingleverandøren.',

    // APS categories

    'cf_invalid_password' => 'Passordet kan ikke være lengre enn 16 tegn.',
    'cf_invalid_description_length' => 'Beskrivelse kan ikke være lenger enn 256 tegn',
    'ip_addr__ip_used_by_external_mail_server' => 'IP-adresse %1 er allerede i bruk av ekstern e-postserver',

    // 8.4.1

    '__ftp_login_is_invalid' => 'FTP-konto brukernavn eller passord er ugyldig. Vennligst spesifiser korrekt FTP bruker legitimasjon.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Grensen for serienummer endringer ble nådd. Ingen flere endringer av DNS-sonen kan utføres i dag.',
    'dns__zone_apply_changes' => 'Endringer gjort i DNS oppføringer er ikke lagret enda. De utførte endringene er markerte nedenfor. Klikk Oppdater for å bruke endringene i DNS-sonen eller klikk på Tilbakestill for å forkaste endringene.',
    'dns__update_dns_zone' => 'Klikk for å kansellere endringene som er utført i DNS oppføringene',
    'dns__revert_dns_zone' => 'Klikk for å kansellere endringene som er utført i DNS oppføringene',
    'bt_revert' => 'Gjenopprett',
    'dns__dns_zone_has_beed_updated' => 'Endringer gjort i DNS oppføringer ble lagret.',
    'dns__dns_zone_has_beed_reverted' => 'Endringer gjort i DNS oppføringer ble kansellert',
    'db__nondefault_server_not_allowed' => 'Bruk av ikke-standard databaseservere er ikke tillatt',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Kunde %1s konto og domener.',
    'ui__client__disabled-warning' => 'Kontoen til kunde %1 er suspendert.',
    'ui__client__none-available' => 'Det er ingen konfigurerte kundekontoer.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Kunde %1',
    'ui__client_self__description' => 'Liste over domenene mine.',
    'ui__client_self__short-title' => 'Mine domener',
    'ui__client_self__title' => 'Mine domener',


    'site_apps__non_removable' => 'Elementer som ikke kan fjernes',
    'site_apps__non_removable_items' => 'Følgende webprogrammer kan ikke fjernes:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Det er ingen brukerdefinerte knapper.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Det er ingen brukerdefinerte knapper på kunde %1s Kundepanel.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Fjern denne knappen %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Fjern denne knappen %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Fjern de brukerdefinerte knappene fra kundens Kundepanel',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Fjern kundedefinerte knapper',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern knapper',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Velg en kunde du ønsker å fjerne brukerdefinerte knapper for å klikk på Neste >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Velg knappene du vil fjerne og klikk Neste>>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bekreft fjerningen av knapper ved å velge avmerkingsboksen på denne skjermen, og klikk på Fullfør.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Fjern en brukerdefinert knapp fra kundens Kundepanel.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Fjern en brukerdefinert knapp',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern brukerdefinert knapp',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Velg en kunde du ønsker å fjerne brukerdefinert knapp for og klikk på Neste >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Velg en brukerdefinert knapp du ønsker å fjerne og klikk på Neste >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bekreft fjerning av brukerdefinert knapp ved å krysse av på dette skjermbildet og deretter klikke på Fullfør.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Rediger egenskaper for knapp på kundenivå %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Innstillinger',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Modifiser kundens brukerdefinerte knapp %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Legg til brukerdefinert knapp',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Velg en kunde du ønsker å opprette en brukerdefinert knapp på Kundepanelet for klikk på Neste>>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klikk på Fullfør for å opprette knappen.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Endre egenskaper for en knapp på kundens Kundepanel.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Endre egenskaper for en knapp på kundens Kundepanel',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Endre egenskaper for brukerdefinert knapp',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Velg en kunde du ønsker å modifisere en brukerdefinert knapp for og klikk på Neste >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Velg en brukerdefinert knapp du ønsker å modifisere og klikk på Neste >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Når du er klar med å endre egenskapene for knappen, klikk på Fullfør for å godta endringene og sluttføre veiviseren.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Gjør knappen %1 utilgjengelig for kundene dine.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Gjør utilgjengelig for kundene dine',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Gjør knappen %1 utilgjengelig for kundene dine',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Gjør knappen %1 synlig for kundens brukere.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Gjør tilgjengelig for kundene dine',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Gjør knappen %1 synlig for kundens brukere',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Gjør en brukerdefinert knapp tilgjengelig/utilgjengelig for kundene dine.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgjengelig/utilgjengelig for kundene dine',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Gjør en brukerdefinert knapp tilgjengelig eller utilgjengelig for kundene dine',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gjør en brukerdefinert knapp tilgjengelig/utilgjengelig for kundene dine.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Velg en kunde du ønsker å gjøre en brukerdefinert knapp tilgjengelig for kundens brukere for og klikk på Neste >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Velg en brukerdefinert knapp du ønsker å gjøre tilgjengelig eller utilgjengelig for kundene dine og klikk på Neste >>.',

    'ui__client/domain__description' => 'Administrer domene %1.',
    'ui__client/domain__disabled-warning' => 'Domene %1 er suspendert.',
    'ui__client/domain__none-available' => 'Du har ingen domener.',
    'ui__client/domain__none-available__1' => 'Kontoen %1 har ingen domener.',
    'ui__client/domain__none-available__2' => 'Kontoen %1 har ingen domener.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Domene %1',
    'ui__client/domain_self__description' => 'Administrer domenet ditt.',
    'ui__client/domain_self__disabled-warning' => 'Domenet ditt er suspendert.',
    'ui__client/domain_self__quick-search' => 'Mine domener',
    'ui__client/domain_self__short-title' => 'Mitt domene',
    'ui__client/domain_self__title' => 'Mitt domene',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Det er ingen brukerdefinerte knapper plassert på kundens Kundepanel.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Kunde %1 har ingen brukerdefinerte knapper på Kundepanelet.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Det er ingen brukerdefinerte knapper for domene %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Fjern den brukerdefinerte knappen %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Fjern den brukerdefinerte knappen %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Fjern brukerdefinerte knapper.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Fjern kundedefinerte knapper',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern kundedefinerte knapper',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Velg kunden du ønsker å fjerne knapper fra panel for domeneadministrasjon for og klikk på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Velg det domenet du ønsker å fjerne knapper fra administrasjonspanelet for og klikke på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Velg knappene du vil fjerne og klikk Neste>>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Bekreft fjerning av knappene ved å markere i de respektive avmerkingsboksene og klikke Fullfør for å fjerne knappene og å sluttføre veiviseren.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Fjern en brukerdefinert knapp.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Fjern en brukerdefinert knapp',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern en brukerdefinert knapp',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Velg den kunden du ønsker å fjerne den brukerdefinert knappen fra panel for domeneadministrasjon for og klikk på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Velg domenet du ønsker å fjerne knapp fra administrasjonspanel for og klikk på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Velg den brukerdefinerte knappen du ønsker å fjerne og klikk på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Bekreft fjerning av brukerdefinert knapp ved å sette kryss og klikk på Fullfør for å fjerne knappen og avslutte veiviseren.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Endre egenskaper for den brukerdefinerte knappen %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Egenskaper",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Endre egenskaper for brukerdefinert knapp %1 på Kundepanelet.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Legg til en knapp',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Velg den kunden du ønsker å plassere knapp på Kundepanelet for og klikk på Neste>>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Velg det abonnementet du ønsker å modifisere knappen for og klikk på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Klikk på Fullfør for å skape knappen og avslutte veiviseren.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Endre egenskaper for en knapp i Kundepanel.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Endre egenskaper for en knapp i Kundepanel',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Endre knappegenskaper',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Velg den brukerdefinerte knappen du ønsker å modifisere innstillinger for og klikk på Neste >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Når du er klar med å endre egenskapene for knappen, klikk på Fullfør for å godta endringene og sluttføre veiviseren.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Gjør knappen %1 utilgjengelig for epostbrukere under dette domenet.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Ikke tilgjengelig for e-postbrukere',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Gjør knappen %1 utilgjengelig for epostbrukere under dette domenet',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Gjør knappen %1 synlig for epostbrukere under domenet.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Tilgjengelig for epostbrukere under dette domenet',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Gjør den brukerdefinerte knappen %1 synlig for epostbrukere under dette domenet',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Gjør en brukerdefinert knapp tilgjengelig eller utilgjengelig for andre brukere.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgjengelig/ utilgjengelig for andre brukere',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Gjør en brukerdefinert knapp tilgjengelig eller utilgjengelig for epostbrukere',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gjør en brukerdefinert knapp tilgjengelig eller utilgjengelig for andre brukere',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Velg et domene der knappen er plassert og klikk på Neste >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Velg en knapp som du vil gjøre tilgjengelig eller utilgjengelig for andre brukere og klikk Neste>>.',

    'ui__client/domain/delete__description' => 'Fjern domenet %1.',
    'ui__client/domain/delete__short-title' => 'Fjern',
    'ui__client/domain/delete__title' => 'Fjern domenet %1',
    'ui__client/domain/delete_multi__description' => 'Fjern domener.',

    'ui__client/domain/delete_multi__short-title' => 'Fjern',
    'ui__client/domain/delete_multi__title' => 'Fjern domener',
    'ui__client/domain/delete_multi__wizard-title' => 'Fjern domener',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Velg domener du ønsker å fjerne og klikk på Neste >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Bekreft fjerning av domener ved å sette kryss og klikk deretter på Fullfør for å fjerne dem og avslutte veiviseren.',
    'ui__client/domain/delete_unknown__description' => 'Fjern et domene.',
    'ui__client/domain/delete_unknown__short-title' => 'Fjern',
    'ui__client/domain/delete_unknown__title' => 'Fjerne domene',
    'ui__client/domain/delete_unknown__wizard-title' => 'Fjern et domene',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Velg et domene du ønsker å fjerne og klikk på Neste >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Bekreft fjerning av domene ved å sette kryss og klikk deretter på Fullfør for å fjerne det og avslutte veiviseren.',

    'ui__client/domain/hosting__none-available' => 'Det finnes ingen domener med konfigurert webhosting. Opprett et domene og konfigurer webhosting på det for å få tilgang til denne funksjonaliteten.',
    'ui__client/domain/hosting__none-available__1' => 'Denne brukerkontoen har ingen domener med konfigurert webhosting. Konfigurer web hosting på på det ønskede domenet for å få tilgang til denne funksjonaliteten.',
    'ui__client/domain/hosting__none-available__2' => 'Webhosting er ikke konfigurert for domene %1. Konfigurer webhosting på domene %1 for å få tilgang til denne funksjonaliteten.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Kunder",
    'ui__client/domain/hosting/application#list_header__description__title' => "Beskrivelse",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Elementer",
    'ui__client/domain/hosting/application#list_header__name__title' => "Navn",
    'ui__client/domain/hosting/application#list_header__release__title' => "Frigi",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sorter etter kunder",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sorter etter beskrivelse",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sorter etter element",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sorter etter navn",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sorter etter utgivelse",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sorter etter versjoner",
    'ui__client/domain/hosting/application#list_header__title' => "Web Applikasjoner",
    'ui__client/domain/hosting/application#list_header__version__title' => "Versjoner",

    'rpt_reseller_section_general' => 'Generelt',
    'rpt_reseller_section_domains' => 'Domener',
    'rpt_reseller_section_clients' => 'Kunder',
    'statistics__cl_active_domains' => "Aktive domener",
    'rpt_reseller_cl_domains' => "Domener",
    'rpt_reseller_cl_subdomains' => "Underdomener",
    'by__cl_domains' => "klientenes domener",
    'dom_ctrl__cl_mboxes' => "Postbokser",
    'rpt_reseller_cl_redirects' => "Videresendere",
    'rpt_reseller_cl_mail_groups' => "E-postgruppe",
    'rpt_reseller_cl_mail_resps' => "Autosvar",
    'rpt_reseller_cl_mail_lists' => "Adresselister",
    'rpt_reseller_cl_web_users' => "Webbrukere",
    'rpt_reseller_cl_data_bases' => "Databaser",

    'statistics__active_clients' => 'Kunder med aktive abonnementer',
    'statistics__clients_active_domains' => 'Aktive domener',
    'statistics__clients_doms' => 'Domener',
    'statistics__cl_doms' => 'Domener',
    '__clients_subdomains' => 'Underdomener',
    '__clients_domains' => 'Domener',
    'dom_ctrl__clients_mboxes' => 'Postbokser',
    'dom_ctrl__clients_redir' => 'Videresendere',
    'dom_ctrl__clients_mg' => 'E-postgruppe',
    'dom_ctrl__clients_resp' => 'Autosvar',
    'dom_ctrl__clients_maillists' => 'Adresselister',
    'dom_ctrl__clients_wu' => 'Webbrukere',
    'dom_ctrl__clients_db' => 'Databaser',

    'dom_ctrl__cl_redir' => 'Videresendere', // to resolve!
    'dom_ctrl__cl_mg' => 'E-postgruppe', // to resolve!
    'dom_ctrl__cl_resp' => 'Autosvar', // to resolve!
    'dom_ctrl__cl_maillists' => 'Adresselister', // to resolve!
    'dom_ctrl__cl_wu' => 'Webbrukere', // to resolve!
    'dom_ctrl__cl_db' => 'Databaser', // to resolve!

    'rpt_cl_section_clients' => 'Kunder',

    'rpt_admin_section_general' => 'Generelt',
    'rpt_admin_section_resellers' => 'Videreforhandler',
    'rpt_admin_section_clients' => 'Kunder',
    'rpt_admin_section_personal_clients' => 'Egne kunder',
    'rpt_admin_section_domains' => 'Domener',
    'rpt_admin_section_personal_domains' => 'Personlige domener',

    'rpt_reseller_section_personal_domains' => 'Personlige domener',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Velg domenet du ønsker å suspendere eller aktivere.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Suspender eller aktiver et domene',

    'ui__client/ip-pool__description' => 'Tildel og fraordne IP-adresser og SSL/TLS-sertifikater til kunde %1.',
    'ui__client/ip-pool__short-title' => 'IP-utvalg',
    'ui__client/ip-pool__title' => 'Kunde %1s IP-utvalg',
    'ui__client/ip-pool_self__description' => 'Se din IP gruppe.',
    'ui__client/ip-pool_self__short-title' => 'IP-utvalg',
    'ui__client/ip-pool_self__title' => 'Min IP gruppe',
    'ui__client/ip-pool/properties__description' => 'Sett opp IP-utvalg for kunde %1.',

    'ui__client/ip-pool/properties__short-title' => 'IP-utvalg',
    'ui__client/ip-pool/properties__title' => 'Sett opp IP-utvalg for kunde %1',
    'ui__client/ip-pool/properties_self__description' => 'Se din IP gruppe.',

    'ui__client/ip-pool/properties_self__short-title' => 'Min IP gruppe',
    'ui__client/ip-pool/properties_self__title' => 'Min IP gruppe',
    'ui__client/ip-pool/properties_unknown__description' => 'Tildel eller fraordne IP-adresser og SSL/TLS-sertifikater fra kunden.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'IP-utvalg',
    'ui__client/ip-pool/properties_unknown__title' => 'Sett opp kundens IP-utvalg',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Sett opp kundens IP-utvalg',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Velg den kunden du ønsker å konfigurere IP-utvalg for.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Når du er klar med å endre IP gruppen, klikk på Fullfør for å godta endringene og sluttføre veiviseren.',


    'ui__client/limits_readonly-unknown__description' => 'Vis ressursgrenser for en kunde.',
    'ui__client/limits_readonly-unknown__short-title' => 'Ressursgrenser',
    'ui__client/limits_readonly-unknown__title' => 'Vis ressursgrenser for en kundekonto',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Vis eller endre ressursgrenser for en kunde',

    'ui__client/limits_unknown__wizard-title' => 'Vis eller endre ressursgrenser for en kunde',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Velg den kunden du trenger.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Velg den kunden du trenger.',
    'ui__client/limits_unknown__wizard__2' => 'kKikk på Fullfør for å godta endringene.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Klikk Fullfør for å avslutte veiviseren.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Klikk Fullfør for å avslutte veiviseren.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Klikk Fullfør for å avslutte veiviseren.',

    'ui__client/permissions_unknown__wizard-title' => 'Vis eller endre tillatelser for en kunde',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Når du er ferdig å se dine tillatelser, klikk Fullfør aktivere endringene og avslutte veiviseren.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Velg den kunden du ønsker å vise eller endre tillatelser for.',
    'ui__client/permissions_unknown__wizard__2' => 'Når du er ferdig med å endre kundens tillatelser, klikk på Fullfør for å bruke endringene og avslutte veiviseren.',

    'ui__client/preferences_unknown__wizard-title' => 'Rediger kundens preferanser',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Velg den kunden du ønsker å endre preferanser for økt og grensesnitt for.',
    'ui__client/preferences_unknown__wizard__2' => 'Når du er ferdig med å endre kundens preferanser, klikk på Fullfør.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Når du er klar med å endre dine preferanser, klikk på Fullfør.',

    'ui__custom-buttons/custom-button__none-available' => 'Du har ingen brukerdefinerte knapper.',
    'ui__custom-buttons/custom-button/delete__description' => 'Fjern den brukerdefinerte knappen %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__custom-buttons/custom-button/delete__title' => 'Fjern den brukerdefinerte knappen %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Fjern brukerdefinerte knapper.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Fjern kundedefinerte knapper',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern kundedefinerte knapper',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Velg knappene du vil fjerne.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Bekreft fjerning av knappene ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Fjern brukerdefinerte knapper.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Fjern kundedefinerte knapper',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern kundedefinerte knapper',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Velg den egendefinerte knappen du vil fjerne.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Bekreft fjerning av knappen ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',
    'ui__custom-buttons/custom-button/properties__description' => 'Endre egenskapene til knappen %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Egenskaper',
    'ui__custom-buttons/custom-button/properties__title' => 'Endre egenskapene til knappen %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Opprett en knapp',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Klikk på Fullfør for å opprette knappen.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Endre egenskaper for brukerdefinert knapp.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Endre egenskaper for en brukerdefinert knapp',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Endre egenskaper for en brukerdefinert knapp',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Velg den egendefinerte knappen hvis egenskaper du ønsker å endre.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'kKikk på Fullfør for å godta endringene.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Gjør brukerdefinert knapp %1 utilgjengelig for andre brukere.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Utilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Gjør den brukerdefinerte knappen %1 utilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Gjør den brukerdefinerte knappen %1 tilgjengelig for andre brukere.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Tilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Gjør den brukerdefinerte knappen %1 tilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Gjør den brukerdefinerte knappen tilgjengelig eller utilgjengelig for andre brukere.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgjengelig eller utilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Gjør den brukerdefinerte knappen tilgjengelig eller utilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gjør den brukerdefinerte knappen tilgjengelig eller utilgjengelig for andre brukere',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Velg en brukerdefinert knapp du ønsker å gjøre tilgjengelig eller utilgjengelig for andre brukere og klikk på Neste >>.',

    'ui__longtasks#list_header__name__title' => "Navn",
    'ui__longtasks#list_header__owner__title' => "Eier",
    'ui__longtasks#list_header__start_time__title' => "Opprettelsestidspunkt",
    'ui__longtasks#list_header__status__title' => "Status",
    'ui__longtasks#list_header__title' => "Oppgaver",
    'ui__longtasks#list_header__finish_time__title' => "Fullføringstid",
    'ui__longtasks#task_list_legend__title' => "Oppgaver",
    'ui__longtasks#tools_legend__title' => "Verktøy",
    'ui__longtasks__description' => "Administrer bakgrunnsoppgaver",
    'ui__longtasks__short-title' => "Bakgrunnsoppgaver",
    'ui__longtasks__title' => "Bakgrunnsoppgaver",
    'ui__longtasks/longtask/properties#current_operation__title' => "Gjeldende operasjon:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Estimert fullføringstidspunkt:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Generelt",
    'ui__longtasks/longtask/properties#owner__title' => "Oppgave startet:",
    'ui__longtasks/longtask/properties#progress__title' => "Total fremdrift:",
    'ui__longtasks/longtask/properties#start_time__title' => "Oppgave startet:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Oppgavestatus",
    'ui__longtasks/longtask/properties__description' => "Status og informasjon for bakgrunnsoppgave",

    'ui__longtasks/properties__description' => "Innstillinger for bakgrunnsoppgaver",
    'ui__longtasks/properties__short-title' => "Innstillinger",
    'ui__longtasks/properties__title' => "Bakgrunnsoppgaver",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Meldingmal for masseutsendelse',
    'ui__mass-mail/template#list_header__name__title' => 'Malnavn',
    'ui__mass-mail/template#list_header__from_email__title' => 'Avsender',
    'ui__mass-mail/template#list_header__to__title' => 'Mottakere',
    'ui__mass-mail/template#list_header__subject__title' => 'Emne',
    'ui__mass-mail/template#list_header__cdate__title' => 'Opprettelsesdato',
    'ui__mass-mail/template#list_header__send__title' => 'Send',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Rediger meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/template/properties__description' => 'Rediger denne meldingsmalen for masseutsendelse av e-post.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Legg til mal for masseutsendelse av e-post',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Legg til mal for masseutsendelse av e-post',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Legg til meldingsmal for masseutsendelse av e-post.',
    'ui__mass-mail/send__short-title' => 'Send massepost',
    'ui__mass-mail/send__title' => 'Send masse e-postmelding',
    'ui__mass-mail/send__description' => 'Send massepost til valgte mottakere.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Fjern mal for masseutsendelse av e-post',
    'ui__mass-mail/template/delete_multi__title' => 'Fjern disse meldingsmalene for masseutsendelse av e-post:',
    'ui__mass-mail/template/delete_multi__description' => 'Fjern valgte meldingsmal for masseutsendelse av e-post.',
    'ui__mass-mail/template/delete_multi__done' => 'De valgte meldingsmalene ble fjernet.',
    'ui__mass-mail/template/properties__invalid_values' => 'Ugyldige verdier angitt.',


    // old
    'ui__mass-mail#body_text__description' => 'Du kan bruke <name>variabelen i meldingsteksten (men ikke i overskriften). Den vil bli erstattet av kundens eller forhandlerens kontaktnavn.',
    'ui__mass-mail#body_text__title' => 'Meldingstekst',
    'ui__mass-mail#compose_legend__title' => 'Melding',
    'ui__mass-mail#from_email_text__title' => 'Fra (-postadresse)',
    'ui__mass-mail#list_header__cdate__title' => 'Opprettet',
    'ui__mass-mail#list_header__from_email__title' => 'Fra',
    'ui__mass-mail#list_header__name__title' => 'Navn',
    'ui__mass-mail#list_header__send__title' => 'Opprett melding',
    'ui__mass-mail#list_header__subject__title' => 'Emne',
    'ui__mass-mail#list_header__title' => 'Meldingmal for masseutsendelse',
    'ui__mass-mail#list_header__to__title' => 'Til',
    'ui__mass-mail#list_legend__title' => 'Meldingmal for masseutsendelse',
    'ui__mass-mail#load_template_text__title' => 'Last inn',
    'ui__mass-mail#name_text__title' => 'Malnavn',
    'ui__mass-mail#option_mode_all__title' => 'Alle',
    'ui__mass-mail#option_mode_except__title' => 'Alle unntatt valgte',
    'ui__mass-mail#option_mode_select__title' => 'Kun de valgte',
    'ui__mass-mail#option_select_template__title' => '---Velg en mal---',
    'ui__mass-mail#picker_legend__title' => 'Meldingsmal for E-post',
    'ui__mass-mail#picker_title__title' => 'Velg en mal',
    'ui__mass-mail#save_as_legend__title' => 'Lagre som mal',
    'ui__mass-mail#save_as_text__title' => 'Lagre sammensatt melding til en ny mal med navn',
    'ui__mass-mail#subject_text__title' => 'Emne',
    'ui__mass-mail#template_legend__title' => 'Mal',
    'ui__mass-mail#to_admin_text__title' => 'Plesk administrator',
    'ui__mass-mail#to_clients_text__title' => 'Kunder',
    'ui__mass-mail#to_domains_text__title' => 'Domeneadministratorer',
    'ui__mass-mail#to_select_text__title' => 'Velg adresser',
    'ui__mass-mail#to_show_hide_text__title' => 'Vis/skjul de valgte',
    'ui__mass-mail#to_text__title' => 'Til',
    'ui__mass-mail#tools_legend__title' => 'Verktøy',
    'ui__mass-mail__already_exists' => 'Det finnes allerede en mal med navnet %1',
    'ui__mass-mail__none-available' => 'Du har ingen meldingsmaler.',

    'ui__mass-mail/delete__description' => 'Fjern meldingsmal for masseutsendelse av e-post %1',

    'ui__mass-mail/delete__empty_selection' => 'Velg malene du vil fjerne',
    'ui__mass-mail/delete__short-title' => 'Fjern %1',
    'ui__mass-mail/delete__title' => 'Fjern meldingsmal for masseutsendelse av e-post %1',
    'ui__mass-mail/delete_multi__description' => 'Fjern meldingsmal for masseutsendelse av e-post.',

    'ui__mass-mail/delete_multi__short-title' => 'Fjern',
    'ui__mass-mail/delete_multi__title' => 'Fjern meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/delete_multi__wizard-title' => 'Fjerning av meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Velg meldingsmal for masseutsendelse av e-post du vil fjerne.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Bekreft fjerning av malene ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',
    'ui__mass-mail/delete_unknown__description' => 'Fjern meldingsmal for masseutsendelse av e-post.',
    'ui__mass-mail/delete_unknown__short-title' => 'Fjern',
    'ui__mass-mail/delete_unknown__title' => 'Fjern meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Fjerning av meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Velg meldingsmalen for masseutsendelse av e-post du vil fjerne.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Bekreft fjerning av malen ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',

    'ui__mass-mail/properties__description' => 'Rediger meldingsmal for e-post %1.',

    'ui__mass-mail/properties__invalid_values' => 'Angitte verdier er gale',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Rediger meldingsmal for e-post %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Opprett en meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/properties_unknown-new__description' => 'Opprett en meldingsmal for E-post',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Legg til meldingsmal for e-post',
    'ui__mass-mail/properties_unknown-new__title' => 'Opprett meldingsmal for e-post',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Rediger meldingsmal for masseutsendelse av e-post',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Velg malene du vil fjerne og klikk Neste>>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Når du er klar med å redigere malen, klikk på Fullfør for å godta endringene og sluttføre veiviseren.',

    'ui__mass-mail/send__invalid_values' => 'Du oppga feil verdier',

    'ui__mass-mail/send_new__wizard-title' => 'Opprett en meldingsmal og send e-post',
    'ui__mass-mail/send_unknown-new__description' => 'Send e-post til valgte mottaker',

    'ui__mass-mail/send_unknown-new__short-title' => 'Send massepost',
    'ui__mass-mail/send_unknown-new__title' => 'Send masse e-postmelding',
    'ui__mass-mail/send_unknown__description' => 'Send e-post til valgte mottaker',

    'ui__mass-mail/send_unknown__short-title' => 'Send massepost',
    'ui__mass-mail/send_unknown__title' => 'Send masse e-postmelding',
    'ui__mass-mail/send_unknown__wizard-title' => 'Send masse e-postmelding',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Velg malen du trenger og klikk neste>>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Når du er klar med å redigere egenskapene for malen, klikk på Fullfør for å godta endringene og sluttføre veiviseren.',

    'ui__mass-email/delete__description' => 'Fjern valgte meldingsmal for masseutsendelse av e-post.',

    'ui__mass-email/delete__empty_selection' => "Velg malene du vil fjerne",
    'ui__mass-email/delete__short-title' => "Fjern %1",
    'ui__mass-email/delete__title' => "Fjern meldingsmal for masseutsendelse av e-post %1",
    'ui__mass-email/delete_multi__description' => "Fjern meldingsmal for masseutsendelse av e-post.",

    'ui__mass-email/delete_multi__short-title' => "Fjern",
    'ui__mass-email/delete_multi__title' => "Fjern meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Bekreft fjerning av malene ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Velg meldingsmal for masseutsendelse av e-post du vil fjerne.",
    'ui__mass-email/delete_multi__wizard-title' => "Fjerning av meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/delete_unknown__description' => "Fjern meldingsmal for masseutsendelse av e-post.",
    'ui__mass-email/delete_unknown__short-title' => "Fjern",
    'ui__mass-email/delete_unknown__title' => "Fjern meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Bekreft fjerning av malen ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Velg meldingsmalen for masseutsendelse av e-post du vil fjerne.",
    'ui__mass-email/delete_unknown__wizard-title' => "Fjerning av meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/send__description' => "Send e-post til valgte mottaker",
    'ui__mass-email/send__short-title' => "Send masse e-post",
    'ui__mass-email/send__title' => "Send masse e-postmelding",
    'ui__mass-email/send_main__description' => "Send e-post til valgte mottaker",

    'ui__mass-email/send_main__short-title' => "Send masse e-post",
    'ui__mass-email/send_main__title' => "Send masse e-postmelding",
    'ui__mass-email/send_selectresellers__title' => 'Velg forhandlere',
    'ui__mass-email/send_selectresellers__short-title' => 'Videreforhandler',
    'ui__mass-email/send_selectresellers__description' => 'Velg forhandlerkontoer',

    'ui__mass-email/send_selectclients__description' => "Velg kundekontoer",

    'ui__mass-email/send_selectclients__short-title' => "Kunder",
    'ui__mass-email/send_selectclients__title' => "Velg kunder",
    'ui__mass-email/send_selectdomainusers__description' => "Velg domeneadministratorkontoer",

    'ui__mass-email/send_selectdomainusers__short-title' => "Domeneadministratorer",
    'ui__mass-email/send_selectdomainusers__title' => "Velg domeneadministratorer",
    'ui__mass-email/template/properties_main__description' => "Opprett en meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/template/properties_main__short-title' => "Rediger mal",
    'ui__mass-email/template/properties_main__title' => "Rediger meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/template/properties_new-main__description' => "Opprett en-mal for masseutsendelse av e-post melding.",
    'ui__mass-email/template/properties_new-main__short-title' => "Opprett en meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/template/properties_new-main__title' => "Opprett en meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/template/properties_new-selectclients__description' => "Velg de kundene som skal motta epostmeldinger basert på denne malen",
    'ui__mass-email/template/properties_new-selectclients__title' => "Velg de kundene som skal motta epostmeldinger basert på denne malen",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Velg domeneadministratorer som skal motta masseutsendelser av e-post basert på denne malen.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Velg domeneadministratorer som skal motta masseutsendelser av e-post basert på denne malen.",
    'ui__mass-email/template/properties_selectclients__title' => "Velg de kundene som skal motta epostmeldinger basert på denne malen",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Velg domeneadministratorer som skal motta masseutsendelser av e-post basert på denne malen.",

    'ui__mass-email/template/properties_unknown-new__description' => "Opprett en meldingsmal for masseutsendelse av e-post",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Opprett mal",
    'ui__mass-email/template/properties_unknown-new__title' => "Opprettelse av Masseutsendelse av meldingsmal for e-post",
    'ui__news/dismiss__description' => 'Klikk for å lukke nyhetsvinduet. Plesk ikke vise dette rammen før nyhetsartikler er oppdatert.',

    'ui__news/dismiss__title' => 'Lukk nyhetene',

    'ui__server__description' => 'Serveradministrasjon.',
    'ui__server__short-title' => 'Behandle din server',
    'ui__server__title' => 'serveradministrasjon',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'IP adressen %1 er ikke tilgjengelig.',
    'ui__server/ip-address__none-available' => 'Det finnes ingen ledige IP adresser.',
    'ui__server/ip-addresses/ip-address__title' => "IP-adresser",
    'ui__server/ip-address/client/properties_new__description' => "Tildel IP-adresse %1 til forhandlere.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Tilordne',
    'ui__server/ip-address/client/properties_new__title' => "Tildel IP-adresse %1 til forhandlere",
    'ui__server/ip-address/client__none-available' => 'Det er ingen brukerkontoer',
    'ui__server/ip-address/client_unknown__quick_search' => 'Brukere',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Liste av brukere som bruker denne IP-adresse.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Velg IP-adresse.',
    'ui__server/ip-address/client/delete__description' => 'Fraordne IP-adresse fra forhandler.',
    'ui__server/ip-address/client/delete__short-title' => 'Fraordne',
    'ui__server/ip-address/client/delete__title' => 'Fraordne IP-adresse fra forhandleren',
    'ui__server/ip-address/client/delete_multi__description' => "Fraordne IP-adresse fra forhandlerens utvalg.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Fraordne',
    'ui__server/ip-address/client/delete_multi__title' => 'Fraordne en IP-adresse fra en forhandler',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Ta bort IP adresse fra brukers gruppe.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'velg IP-adresse du vil fradele fra brukere og klikk neste>>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Velg brukere som du vil fradele IP-adresse og klikk neste>>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Bekreft fraordning av IP adresse ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Fraordne en IP-adresse fra forhandlere.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Fraordne',
    'ui__server/ip-address/client/delete_unknown__title' => 'Fraordne IP-adresse fra forhandlere',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Fraordne en IP adresse fra brukere',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'velg IP-adresse du vil fradele fra brukere og klikk neste>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Velg brukeren som du vil fradele IP-adresse fra og klikk neste>>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Bekreft fraordning av IP adresse ved å markere i avmerkingsboksen og klikke Fullfør for å sluttføre veiviseren.',

    'ui__server/ip-address/domain__description' => "Alle domener på IP-adresse %1.",
    'ui__server/ip-address/domain__short-title' => "Domener",
    'ui__server/ip-address/domain__title' => "Domener på IP-adresse %1",
    'ui__server/ip-address/domain_unknown__description' => "Alle domener på IP-adresse.",
    'ui__server/ip-address/domain_unknown__short-title' => "Domener",
    'ui__server/ip-address/domain_unknown__title' => "Domener på IP-adresse",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Velg IP-adresse du trenger og klikk neste>>.",

    'ui__server/ip-address/properties__description' => 'Endre egenskapene for IP adressen %1.',
    'ui__server/ip-address/properties__short-title' => 'Egenskaper',
    'ui__server/ip-address/properties__title' => 'Endre egenskapene for IP adressen %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Legg til IP adresse',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Når du er klar med å endre IP adresse egenskapene, klikk på Fullfør for å sluttføre veiviseren.',
    'ui__server/ip-address/properties_unknown__description' => 'Endre egenskapene for IP adressen.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Egenskaper',
    'ui__server/ip-address/properties_unknown__title' => 'Endre egenskapene for IP adressen',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Endre egenskapene for IP adressen',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Velg IP-adressen du vil endre egenskaper på.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Når du er klar med å endre IP adresse egenskapene, klikk på Fullfør for å sluttføre veiviseren.',

    'ui__server/spam-filter/black-list__description' => 'Sett opp svarteliste for globalt spamfilter.',
    'ui__server/spam-filter/black-list__short-title' => 'Svarteliste',
    'ui__server/spam-filter/black-list__title' => 'Svarteliste for globalt spamfilter',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Bare %1 første unike e-postadresser vil bli lagt til.',
    'ui__server/spam-filter/black-list/address__description' => 'Spamfilterets svartelisteadresse.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Det er ingen e-postadresser i listen.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Den opplastede filen er tom.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Følgende e-postadresser er ugyldige %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Det er ingen adresser i spamfilterets svarteliste.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/black-list/address__title' => 'Svarteliste adresse %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Legg til adresser i svarteliste',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Legg til adresser',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Legg til adresser i svarteliste',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Fjern %1 adresse fra global svarteliste.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Fjern',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Fjern %1 adresse fra global svarteliste',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Fjern adresser fra global svarteliste.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Fjern',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Fjern adresser fra global svarteliste',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Fjerning av adresser fra global spamfilter svarteliste',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Velg spamfilteradresser du vil fjerne og klikk neste>>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Bekreft fjerning av spamfilteradresser ved å velge avmerkingsboksen, og klikk Fullfør for å fjerne dem fullstendig, og avslutt veiviseren.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Fjern adresse fra global svarteliste.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Fjern',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Fjern adresse fra global svarteliste',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Fjerning av adresser fra global spamfilter svarteliste',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Velg spamfilteradressen du vil fjerne og klikk neste>>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Bekreft fjerning av spamfilteradressen ved å velge avmerkingsboksen, og klikk Fullfør for å fjerne den fullstendig, og avslutt veiviseren.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Bare %1 første unike e-postadresser vil bli lagt til.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Det er ingen e-postadresser i listen.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Kunne ikke laste opp filen. Maksimal størrelse på en fil som skal lastes opp er %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Følgende e-postadresser er ugyldige %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Legg til adresser i svarteliste',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Legg til adresser',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Legg til adresser i svarteliste',

    'ui__server/spam-filter/properties__description' => 'Sett opp globalt filter for søppelpost.',

    'ui__server/spam-filter/properties__short-title' => 'Innstillinger',
    'ui__server/spam-filter/properties__title' => 'Innstillinger for spamfilter',

    'ui__server/spam-filter/toggle_disable__description' => 'Deaktiver spamfiltrering for hele systemet.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Deaktiver',
    'ui__server/spam-filter/toggle_disable__title' => 'Deaktiver spamfiltrering',
    'ui__server/spam-filter/toggle_enable__description' => 'Aktiver spamfiltrering for hele serveren.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Aktiver',
    'ui__server/spam-filter/toggle_enable__title' => 'Aktiver spamfiltrering',
    'ui__server/spam-filter/toggle_unknown__description' => 'Aktiver eller deaktiver spamfiltrering for hele serveren.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Aktiver eller deaktiver',
    'ui__server/spam-filter/toggle_unknown__title' => 'Aktiver eller deaktiver spamfiltrering',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Aktiver eller deaktiver spamfilter',

    'ui__server/spam-filter/white-list__description' => 'Sett opp global hviteliste for spamfilter.',
    'ui__server/spam-filter/white-list__short-title' => 'Hviteliste',
    'ui__server/spam-filter/white-list__title' => 'Global hviteliste for spamfilter.',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Bare %1 første unike e-postadresser vil bli lagt til.',
    'ui__server/spam-filter/white-list/address__description' => 'Spam filters hviteliste adresse.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Det er ingen e-postadresser i listen.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Den opplastede filen er tom.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Følgende e-postadresser er ugyldige %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Det er ingen adresser inn spamfilterets globale hviteliste.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Adresse',
    'ui__server/spam-filter/white-list/address__title' => 'Hviteliste adresse %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Legg til adresser til hviteliste.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Legg til adresser',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Legg til adresser til hviteliste',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Fjern %1 adresse fra global hviteliste.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Fjern',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Fjern %1 adresse fra global hviteliste',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Fjern adresser fra global hviteliste.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Fjern',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Fjern adresser fra global hviteliste',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Fjerning av adresser fra globalt spamfilter hviteliste',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Velg spamfilteradresser du vil fjerne og klikk neste>>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Bekreft fjerning av spamfilteradresser ved å velge avmerkingsboksen, og klikk Fullfør for å fjerne dem fullstendig, og avslutt veiviseren.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Fjern adresse fra global hviteliste.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Fjern',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Fjern adresse fra global hviteliste',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Fjerning av adresser fra globalt spamfilter hviteliste',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Velg spamfilteradressen du vil fjerne og klikk neste>>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Bekreft fjerning av spamfilteradressen ved å velge avmerkingsboksen, og klikk Fullfør for å fjerne den fullstendig, og avslutt veiviseren.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Bare %1 første unike e-postadresser vil bli lagt til.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Det er ingen e-postadresser i listen.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Kunne ikke laste opp filen. Maksimal størrelse på en fil som skal lastes opp er %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Følgende e-postadresser er ugyldige %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Legg til adresser til hviteliste.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Legg til adresser',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Legg til adresser til hviteliste',

    'ui__server/mail/statistics#apply__description' => "Bruke filter",
    'ui__server/mail/statistics#apply__title' => "Bruk",
    'ui__server/mail/statistics#custom_from__title' => "fra",
    'ui__server/mail/statistics#custom_to__title' => "til",
    'ui__server/mail/statistics#period_all__title' => "Alle",
    'ui__server/mail/statistics#period_custom__title' => "Egendefinert",
    'ui__server/mail/statistics#period_month__title' => "Gjeldende måned",
    'ui__server/mail/statistics#period_prev_month__title' => "Forrige måned",
    'ui__server/mail/statistics#period_prev_week__title' => "Forrige uke",
    'ui__server/mail/statistics#period_today__title' => "I dag",
    'ui__server/mail/statistics#period_week__title' => "Gjeldende uke",
    'ui__server/mail/statistics#period_yesterday__title' => "I går",
    'ui__server/mail/statistics#show_for_period__title' => "Vis for periode",
    'ui__server/mail/statistics#tools_legend__title' => "Verktøy",
    'ui__server/mail/statistics__description' => "Vis spam- og virusstatistikk",

    'ui__server/mail/statistics__short-title' => "Statistikk",
    'ui__server/mail/statistics__title' => "Statistikk",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Spamstatistikk",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Verktøy",
    'ui__server/mail/statistics/spam__description' => "Vis spamstatistikk",

    'ui__server/mail/statistics/spam__short-title' => "Spamstatistikk",
    'ui__server/mail/statistics/spam__title' => "Spamstatistikk",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "E-post navn",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% av alle",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sorter etter e-postkonto",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sorter etter % av alle",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sorter etter mottatt søppelpost",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "e-postkontoer",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Spam mottatt",
    'ui__server/mail/statistics/spam/recipients__description' => "Mottakere",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Mottakere",
    'ui__server/mail/statistics/spam/recipients__title' => "Mottakere",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Ren",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Infisert",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% av alle",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Antall",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Beskyttet",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Ikke sjekket",
    'ui__server/mail/statistics/spam/summary__description' => "Sammendrag",

    'ui__server/mail/statistics/spam/summary__short-title' => "Sammendrag",
    'ui__server/mail/statistics/spam/summary__title' => "Sammendrag",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Virusstatistikk",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Verktøy",
    'ui__server/mail/statistics/virus__description' => "Vis virusstatistikk",

    'ui__server/mail/statistics/virus__short-title' => "Virusstatistikk",
    'ui__server/mail/statistics/virus__title' => "Virusstatistikk",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "E-postkonto",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% av alle",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sorter etter postnavn",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sorter etter % av alle",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sorter etter mottatte virus",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "E-postkontoer",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Virus mottatt",
    'ui__server/mail/statistics/virus/recipients__description' => "Mottakere",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Mottakere",
    'ui__server/mail/statistics/virus/recipients__title' => "Mottakere",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Ren",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Infisert",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Status",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% av alle",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Antall",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Beskyttet",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Ikke sjekket",
    'ui__server/mail/statistics/virus/summary__description' => "Sammendrag",

    'ui__server/mail/statistics/virus/summary__short-title' => "Sammendrag",
    'ui__server/mail/statistics/virus/summary__title' => "Sammendrag",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Navn",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% av alle",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sorter etter navn",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sorter etter % av alle",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sorter etter infiserte objekter",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Virus",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Infiserte objekter",
    'ui__server/mail/statistics/virus/viruses__description' => "Virus",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Virus",
    'ui__server/mail/statistics/virus/viruses__title' => "Virus",

    'ui__support#param_company__title' => "Firma",
    'ui__support#param_email__title' => "E-post",
    'ui__support#param_firstname__title' => "Fornavn",
    'ui__support#param_keynumber__title' => "Produktnøkkelnummer",
    'ui__support#param_operatingsystem__title' => "Operativsystem",
    'ui__support#param_phone__title' => "Telefon",
    'ui__support#param_psabuild__title' => "Plesk-build",
    'ui__support#param_psainsttype__title' => "Plesk installasjonstype",
    'ui__support#param_psaversion__title' => "Plesk-versjon",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Verktøy",

    'ui__reseller/traffic-history_unknown__short-title' => "Vis trafikk etter forhandlere",
    'ui__reseller/traffic-history_unknown__title' => "Vis trafikk etter forhandlere",
    'ui__reseller/traffic-history_unknown__description' => "Vis trafikk etter forhandlerkontoer.",
    'ui__reseller#list__title' => "Videreforhandler",
    'accounts_list__name__filter_title' => "Navn",
    'accounts_list__resource__filter_title' => "Ressursbruk",
    'resellers_list__filter_resource_usage_any' => "Hvilken som helst",
    'resellers_list__filter_resource_usage_overuse' => "Overforbruk",
    'resellers_list__filter_resource_usage_normal' => "Innenfor grenser",
    'accounts_list__status__filter_title' => "Status",
    'resellers_list__filter_status_any' => "Hvilken som helst",
    'resellers_list__filter_status_blocked' => "Suspendert",
    'resellers_list__filter_status_active' => "Aktiv",
    'resellers_list__filter_clients__filter_title' => "Vis",
    'resellers_list__filter_clients_on' => "Forhandlere med kundene sine",
    'resellers_list__filter_clients_off' => "Kun forhandlere",
    '__disk_usage' => "Brukt diskplass",
    'ui__reseller/traffic_unknown__short-title' => "Vis trafikk etter forhandlere",
    'ui__reseller/traffic_unknown__title' => "Vis trafikk etter forhandlere",
    'ui__reseller/traffic#list__title' => "Trafikk etter forhandler",
    'ui__reseller/traffic_unknown__description' => "Se forbruksrapport for trafikk.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Trafikk etter forhandler",

    '__reseller_name' => "Forhandlerens navn",
    '__reseller' => "Videreforhandler",
    'resellertrafficlist_header' => "Vis trafikk etter forhandlere",
    '__reseller_personal' => "Trafikk brukt av forhandlerens domener",
    'ui__reseller/traffic-history__short-title' => "Trafikk etter forhandlere",
    'ui__reseller/traffic-history__title' => "Trafikk etter forhandlere",
    'ui__reseller/traffic-history__description' => "Se forbruksrapport for trafikk.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Tillat oversalg",
    'limits__reseller_oversell_description' => "Oversalg lar forhandleren selge flere ressurser enn de som faktisk ble tildelt dem. Hvis oversalg tillates, styres forhandleren av faktisk ressursbruk i stedet for opprinnelig ressurstildeling",
    'limits__overuse_block_text' => "Overbruk policy",
    'limits__overuse_block_true_text' => "Overforbruk er ikke tillatt",
    'limits__reseller_overuse_block_true_description' => "Blokker overforbruk av ressurser. Faktisk ressursforbruk kan ikke overskride den initielle ressurs allokeringen",
    'limits__overuse_block_false_text' => "Overforbruk er tillatt",
    'limits__reseller_overuse_block_false_description' => "Ikke blokker overforbruk av ressurser, la forhandler bruke flere ressurser enn de som først ble tildelt. Faktisk ressursforbruk kan overskride den initielle ressurs allokeringen",
    'limits__reseller_overuse_notify_text' => "Varsle forhandler om at de har nådd ressursgrensene",
    'reseller_perm__manage_sh_access_disabled' => "Forhandler kan ikke gi eller hindre skalltilgang",
    'reseller_perm__manage_sh_access_chrooted' => "Forhandler kan bare gi tilgang til et chrooted-miljø",
    'reseller_perm__manage_sh_access_any' => "Forhandler kan gi tilgang til alle skalltyper",
    'template__reseller_num_excl_ips' => "Tildel dedikerte IP-adresser til forhandleren",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Konto",
    'ui__reseller#info__title' => "Info",
    'ui__reseller#clientsTab__title' => "Kunder",
    'ui__reseller#domainsTab__title' => "Domener",
    'ui__reseller__title' => "Administrer %1s forhandlerkonto",
    'domains__reseller_info' => "%1 kunder, %2 domener, %3 av diskplass brukt, %4 av data overført.",
    'domains__reseller_info_hiding_traffic' => "%1 kunder, %2 domener, %3 av diskplass brukt.",
    'ui__reseller__description' => "Administrer forhandlerens konto.",

    'ui__reseller/limits_unknown__wizard-title' => 'Vise eller endre ressursgrenser for en forhandler',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Velg den forhandleren du trenger.',
    'ui__reseller/limits_unknown__wizard__2' => 'kKikk på Fullfør for å godta endringene.',

    'ui__client/report_reseller__short-title' => "Rapport",
    'ui__client/report_reseller__title' => "Vis kontorapporter",
    'ui__client/report_reseller__description' => "Vis rapport for forhandlerkonto.",
    'ui__client/ip-pool_reseller__short-title' => "IP-utvalg",
    'ui__client/ip-pool_reseller__description' => "Tildel IP-adresser og SSL/TLS-sertifikater til forhandlerkontoen.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Angi kontoinnstillinger. og klikk Fullfør.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Vise eller endre tillatelser for en forhandler',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Velg den forhandleren du ønsker å vise eller endre tillatelser for.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Når du er ferdig med å endre forhandlerens tillatelser, klikk på Fullfør for å bruke endringene og avslutte veiviseren.',

    // Customers > create customer account

    '__resellers_list' => 'Videreforhandler',
    'picker_reseller__title' => 'Valg av forhandler',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Verktøy",
    'ui__client#tools2__title' => "Konto",
    'ui__client#info__title' => "Info",
    'ui__client#clientslist__title' => "Kunder",
    'ui__client#domainslist__title' => "Domener",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Alle webprogrammer er nå sortert etter kategorier, noe som gjør det enklere å velge riktig program å installere.",
    'feature__domainkeys__reseller' => "Du kan bruke DKIM godkjenningsmekanisme av e-postavsender til å redusere mengden av søppelpost og phishing-post.",

    '__reseller_form' => "Forhandlerskjema",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Velg den kundekontoen du ønsker å endre innstillinger for.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "For å endre grensene for ressursforbruk, klikk på Ressursgrenser.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "For å endre tillatelsene for operasjonene kunden kan utføre på Plesk, klikk på Tillatelser.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "Gjør denne malen tilgjengelig for andre brukere",
    'template__shared_description' => "Velg dette alternativet hvis du ønsker at kundene dine skal bruke denne malen.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Verktøy',

    'ui__client/traffic-history_unknown__short-title' => 'Vis trafikk etter kunder',
    'ui__client/traffic-history_unknown__title' => 'Trafikk etter kunder',
    'ui__client/traffic-history_unknown__description' => 'Vis rapport om trafikkforbruk for alle kunder',
    'ui__client/traffic-history__short-title' => 'Trafikk etter kunder',
    'ui__client/traffic-history__title' => 'Vis trafikk etter kunder',
    'ui__client/traffic-history__description' => 'Vis rapport om trafikkforbruk for alle kunder',

    'ui__client/traffic#list__title' => 'Trafikk etter kunder',
    'ui__reseller/client/traffic#list__title' => 'Trafikk etter kunder',

    'clients_list__filter_type__filter_title' => 'Vis',
    'clients_list__filter_type_any' => 'Kunder og forhandlere',
    'clients_list__filter_type_clients' => 'Kun kunder',
    'clients_list__filter_type_resellers' => 'Kun forhandlere',
    'ui__client/domain_unknown-new__short-title' => "Opprett domene",

    // Customers > View traffic by customers
    '__personal' => "Trafikk brukt av brukerens domener",
    'PersonalTrafficList_header_of_client__' => "Vis rapport over trafikkbruk for din konto.",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Domeneadministrator kan ikke tillate eller hindre skalltilgang",
    'domain_perm__manage_sh_access_chrooted' => "Domeneadministrator kan bare gi tilgang til et chrootet miljø",
    'domain_perm__manage_sh_access_any' => "Domeneadministrator kan gi tilgang til alle typer skall",

    // APS Catalog
    'bt_add_to_vault' => "Legg til i hvelvet",
    'bt_hide_updates' => "Skjul tilgjengelige oppdateringer",
    'bt_show_updates' => "Vis tilgjengelige oppdateringer",

    '__site_apps__applications' => "Programmer",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Programmer valgt for å legges til hvelvet",
    'site_apps__application_selected' => "Valgt",
    'site_apps__currently_in_vault' => "Andre versjoner er allerede i hvelvet:",
    'site_apps__new_versions' => "Nye versjoner:",
    'site_apps__patches' => "Oppdateringer:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Antall programmer som skal legges til hvelvet: %1",
    'site_apps__applications_downloading_now' => "Følgende programmer lastes nå ned: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Allerede i hvelvet",

    // Server > Action Log
    'bt_skin_edit' => "Rediger skin beskrivelse",
    'domains__you_want_change_the_status_of_the_reseller??' => "Er du sikker på at du ønsker endre status for forhandlerkonto?",
    'limits__oversell_legend' => "Oversalg",
    'limitsManager__limit_available_error' => "Kan ikke allokere den ønskede mengde ressurser (%%quantity%% %%limitName%%). Kun %%available%% %%limitName%% er tilgjengelig.",
    'limitsManager__limit_reserved_error' => "Kunne ikke sette ønsket grense for ressursbruk (%%quantity%% %%limitName%%) fordi den nye verdien er mindre enn den ressursmengden som er reservert for kundene dine eller som brukes av deg selv (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Kan ikke sette påkrevd ressursbrukgrense (%%quantity%% %%limitName%%) fordi den nye verdien er mindre enn den faktiske mengden ressurser som allerede brukes av dine kontoer og områder (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Forbruk av båndbredde etter tjenester",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Se trafikk forbruksrapport",
    'ui__client/domain/traffic_unknown-reseller__title' => "Se trafikk forbruksrapport",

    'ui__client/domain_new__short-title' => "Opprett domene",

    'ui__client_reseller__description' => "Administrer forhandlerkonto %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Administrer forhandlerkonto",

    '__owner_name' => "Eierens navn",
    'domains_list__resource__filter_title' => "Ressursbruk",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "APS programkatalog",
    'site_apps__applications_have_updates' => "Oppdaterte versjoner av følgende programmer er tilgjengelige:\n%1\nFor å se oppdateringer, pass på at Søkeområdet er synlig, sett kryss for <b>Vis bare oppdateringer/b> og søk etter de programmene du trenger.",
    'site_apps__progress_adding_to_vault' => "Legger til i hvelvet:",
    'site_apps__progress_done_message' => "Fremdrift:",
    'site_apps__progress_applications_left' => "%1 av %2 programmer igjen",
    'site_apps__download_item_long_task_title' => "Last ned APS-program (%1)",
    'site_apps__download_transaction_long_task_title' => "Last ned APS-programmer fra APS-katalog",
    'site_apps__last_check_for_updates' => "siste sjekk etter oppdateringer: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Alle planlagte programmer ble lagt til Programhvelvet",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 planlagte programmer ble lagt til Programhvelvet.",
    'site_apps__no_search_results' => 'Ingen applikasjoner funnet. Prøv forskjellige søkeforespørsler eller bla gjennom forskjellige programmer etter kategori.',
    'site_apps__search_results_title' => 'Søkeresultater',
    '__site_apps__search_by_application' => 'Applikasjonsnavn',
    '__site_apps__search_by_vendor' => 'Leverandør',
    '__site_apps__search_by_vendor__all' => 'Alle leverandører',
    '__site_apps__search_by_packager' => 'Innpakking',
    '__site_apps__search_by_certification_level' => 'Sertifiseringsnivå',
    '__site_apps__search_by_cert__any' => 'Hvilken som helst',
    '__site_apps__search_by_cert__silver_and_higher' => 'Sølv og høyere',
    '__site_apps__search_by_cert__gold_and_higher' => 'Gull og høyere',
    '__retry' => 'Prøv på nytt',
    'site_apps__application_packager_site' => 'Innpakking',
    'site_apps__add_to_pool_message' => "Programmer merket \"tilgjengelig for alle\" distribueres automatisk til alle forhandlere og kunder med et ubegrenset antall installasjoner. Begrensede programmer distribueres manuelt til alle forhandlere og kunder på individuell basis med et uttrykkelig spesifisert antall tilgjengelige installasjoner.",
    'site_apps__make_available_for_all' => "Gjør valgte programmer tilgjengelige for alle brukere",

    'site_apps__broadcast_app_text' => "Programmer merket \"tilgjengelig for alle\" distribueres automatisk til alle forhandlere og kunder med et ubegrenset antall installasjoner. Begrensede programmer distribueres manuelt til alle forhandlere og kunder på individuell basis med et uttrykkelig spesifisert antall tilgjengelige installasjoner.",
    'site_apps__broadcast_app_name' => 'Gjøre program tilgjengelig for alle brukere',

    // User Application Pool per application
    'site_apps__available_clients' => 'Tilgjengelige brukere',
    'site_apps__no_more_clients_to_add_to_pool' => 'Det er ingen flere brukerkontoer du kan gi dette programmet til',

    // Installed application instances
    'site_apps__installations' => 'Installasjoner',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Domenenavn og IP-adresse",
    '__assign_ip_address' => "Tilordne IP adresse",
    '__switch_on_service' => "Slå på tjeneste",
    '__hosting_configuration' => "Hosting-konfigurasjon",
    '__vrt_hst' => "Nettstedet hosting",
    '__vrt_hst_hint' => "Host et nettsted på denne serveren.",
    '__fwd' => "Videresending",
    '__web_hosting_settings' => "Hostinginnstillinger",
    '__fwd_hint' => "Viderekoble besøkende til et annet nettsted.",
    '__none_hint' => "Ikke hoste et nettsted for øyeblikket.",
    '__login_hint' => "Dette brukernavnet brukes for å få tilgang til ditt nettsted gjennom FTP",
    '__password_hint' => "Dette passordet brukes for å få tilgang til ditt nettsted gjennom FTP",
    '__advanced_hosting_setup' => "Konfigurer avanserte innstillinger for hosting av nettsted",
    '__domain_creation_successful' => "Domenet ble opprettet.",
    'bt_hosting_settings' => "Hostinginnstillinger",
    '__change_hosting_type' => "Endre hostingtype for domene %1",
    '__hosting_type_change_warning' => "Når du endrer hostingtype til viderekobling eller ingen hosting, vil alle filer og kataloger relatert til nettstedet ditt bli fjernet fra serveren. Pass på at du lagrer en lokal kopi av din område.",
    '__current_hosting_type' => "Aktiv hostingtype",
    '__new_hosting_type' => "Ny hostingtype",
    '__fwd_settings' => "Videresendingsinnstillinger",
    '__fwd_settings_legend' => "Videresendingsinnstillinger",
    '__fwd_destination_url' => "Mål-URL-adresse",
    '__fwd_type' => "Videresending type",
    '__fwd_type_standart' => "Standard videresending",
    '__fwd_type_standart_hint' => "Viderekoble besøk på nettsted til et annet område og vis dem måladresse, slik at de vet om viderekoblingen.",
    '__fwd_type_frame' => "Ramme videresending",
    '__fwd_type_frame_hint' => "Viderekoble besøk på nettsted til et annet område, men ikke vis dem måladressen, slik at de ikke vet om viderekoblingen.",
    '__hosting_type_template_warning' => "Den hostingtypen du valgte er forskjellig fra den typen som er spesifisert i malen. Hvis du fortsetter, vil innstillinger for webhosting i malen bli ignorert. Er du sikker på at du ønsker å sette den valgte hostingtypen?",

    '__no_resellers_selected' => "Du må velge minst én forhandlerkonto.",

    'ui__client/logo_unknown__wizard-title' => 'Sett opp en logo',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Vennligst velg den kunden du ønsker å endre logoegenskaper for.',
    'ui__client/logo_unknown__wizard__2' => 'Klikk på Fullfør for å godta endringene.',
    'ui__client/logo_unknown__wizard__2_self' => 'Klikk på Fullfør for å godta endringene.',

    'ui__client/ipaddress/properties_new__short-title' => "Legg til IP adresse",
    'ui__client/ipaddress/properties_new__title' => 'Legg til IP adresse',
    'ui__client/ipaddress/properties_new__description' => "Legg til IP adresser.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Legg til IP adresse",
    'ui__client/ipaddress/properties_unknown-new__title' => "Legg til IP adresse",
    'ui__client/ipaddress/properties_unknown-new__description' => "Legg til IP adresse",
    'ui__client/ipaddress/delete_multi__short-title' => "Fjern IP adresser",
    'ui__client/ipaddress/delete_multi__description' => "Fjern IP adressene.",
    'ippool_Manager__no_available_ips' => "Det finnes ingen ledige IP adresser i IP utvalget.",
    'ippool_Manager__ip_shared' => "delt",
    'ippool_Manager__ip_exclusive' => "dedikert",
    'ui__client/ipaddress/properties__title' => "Administrer IP adresser",
    'ui__client/ipaddress/properties__description' => "Se eller endre IP adresse egenskaper.",
    'ui__client/ipaddress_unknown-new__title' => "Legg til IP adresse",
    'ui__client/ipaddress_unknown-new__short-title' => "Legg til IP adresse",
    'ui__client/ipaddress_unknown-new__description' => "Legg til IP-adresser.",

    'ui__mass-mail#to_resellers_text__title' => "Videreforhandler",
    'ui__mass-mail#to_domainusers_text__title' => "Domeneadministratorer",
    'ui__mass-email#tools_legend__title' => "Verktøy",
    'ui__mass-email#list_legend__title' => 'Meldingmal for masseutsendelse',
    'ui__mass-email#template_legend__title' => "Mal",
    'ui__mass-email#from_email_text__title' => "Fra",
    'ui__mass-email#to_text__title' => 'Til',
    'ui__mass-email#to_resellers_text__title' => "Videreforhandler",
    'ui__mass-email#to_clients_text__title' => "Kunder",
    'ui__mass-email#to_domainusers_text__title' => "Domeneadministratorer",
    'ui__mass-email#to_admin_text__title' => "Plesk administrator",
    'ui__mass-email#option_mode_all__title' => "Alle",
    'ui__mass-email#option_mode_select__title' => "Kun de valgte",
    'ui__mass-email#option_mode_except__title' => "Alle unntatt valgte",
    'ui__mass-email#option_select_template__title' => '---Velg en mal---',
    'ui__mass-email#subject_text__title' => "Emne",
    'ui__mass-email#body_text__title' => "Meldingstekst",
    'ui__mass-email#save_as_legend__title' => "Lagre som mal",
    'ui__mass-email#save_as_text__title' => "Lagre sammensatt melding til en ny mal med navn",
    'ui__reseller/preferences_unknown__wizard-title' => "Endre kontoinnstillinger",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Velg den forhandleren du ønsker å endre kontoinnstillinger for og klikk på Neste.",
    'ui__reseller/preferences_unknown__wizard__2' => "Angi kontoinnstillinger. og klikk OK.",
    'ippoolManager__ip_shared' => "delt",
    'ippoolManager__ip_exclusive' => "dedikert",

    '__users_list' => "Brukere",
    '__users' => "Brukere",
    '__user_name' => "Brukerens navn",

    'limit__name_max_dom_aliases' => "domenealiaser",
    'limit__name_max_subftp_users' => "ekstra FTP-kontoer",
    'limit__name_max_mssql_db' => "Microsoft SQL Server-databaser",
    'limit__name_max_iis_app_pools' => "IIS-programutvalg",
    'limit__name_max_odbc' => "ODBC tilkoblinger",
    'total_mboxes_quota_unsupported' => 'ikke støttet av e-postserver',
    'limit_soft__disk_space' => 'Gi melding når diskplassen oppnås',
    'limit_soft__max_traffic' => 'Gi melding når trafikkmengden oppnås',
    'dsr__of_reseller_title' => "Ressursforbruk etter domener",
    'limitsManager__commit_failed' => "Kan ikke endre ressursgrensene.",
    'limitsManager__date_in_past' => "Feil utløpsdato %1.",
    'limitsManager__limit_not_supported' => "Grenser for ressurstypen %1 kan ikke settes.",
    'limitsManager__limit_oversell_inconsistency' => "Kan ikke allokere den angitte mengden ressurser med oversalg slått av.",
    'limitsManager__limit_overuse_inconsistency' => "Ressursbruken overskrider de definerte grensene.",
    'limitsManager__no_resource_available' => "Det finnes ingen tilgjengelige ressurser av denne typen (%%limitName%%) igjen. Ønsket: %%quantity%%; tilgjengelig: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Det finnes ingen ressurser av denne typen (%%limitName%%) tilgjengelig fra tjenesteleverandøren din. Ønsket: %%quantity%%; tilgjengelig: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Utløpsdatoen må være mindre enn eller lik %1.",
    'limitsManager__invalid_disk_space_limit' => "Hvor mye diskplass må være mindre enn eller lik %1.",
    'limitsManager__invalid_max_traffic_limit' => "Mengden av trafikken må være mindre enn eller lik %1.",
    'ippoolManager__ip_has_suballocations' => "Kan ikke endre typen av IP adresse som allerede er allokert til en bruker. IP adresse %%ip%% er allerede allokert til bruker(e) som %%reserved%% IP adresse.",
    'ippoolManager__ip_is_already_in_pool' => "Denne IP adressen er allerede tilordnet til brukeren.",
    'ippoolManager__ip_is_not_in_pool' => "Det finnes ingen IP adresse %%ip%% i gruppen.",
    'ippoolManager__can_not_allocate_ip' => "IP adressen %%ip%% er tilgjengelig bare som %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "IP adressen %%ip%% kan ikke allokeres som dedikert.",
    'ippoolManager__ip_used_by_hst_or_frw' => "IP-adressen %%ip%% er allerede i bruk for hosting.",
    'ippoolManager__active_anon_ftp_on_ip' => "Anonym FTP-tilgang er allerede slått på for IP-adresse %%ip%%",
    'ippoolManager__no_vacant_ips' => "Det finnes ingen ledige IP adresser.",
    'ippoolManager__no_available_ips' => "Det finnes ingen tilgjengelige IP adresser.",
    'templates__dublicate_name' => "En mal med dette navnet eksisterer allerede. Velg et annet navn for denne malen.",
    'cl_perm__client_limits_exceeded' => "De spesifiserte ressursgrenseverdiene overskrider verdiene som tillates av hostingplanen din ellers vil disse verdiene gi mindre ressurser enn de som for tiden brukes av nettstedene dine.",
    'cl_perm__reseller_limits_exceeded' => "Angitte verdier for ressursgrenser overskrider verdiene som tillates av hostingplanen, eller disse verdiene gir mindre ressurser enn de som for tiden benyttes av brukerkontoer og nettsteder.",

    'site_apps__preferences_show_all_versions_title' => "Vis hele listen med versjoner for hvert program som hentes inn fra katalogen",
    'site_apps__preferences_show_all_versions_hint' => "Hvis dette alternativet velges, kan det ta betraktelig tid å hente inn alle versjoner av hvert program hver gang du åpner katalogen. Om denne muligheten ikke er valgt, vises bare de siste versjonene.",
    '__select_user_template' => "Opprett brukerkonto basert på en mal",
    'ip_already_added_to_all_clients' => "Denne IP adressen er allerede tilordnet til alle brukere.",
    'ui__server/ip-address/client/delete#legend__description' => "De følgende IP adressene vil fjernes fra systemet og brukerens IP utvalg:",

    'site_apps__cancelled_apps' => "Du har avbrutt tilføyelsen av følgende programmer: %2",

    'sb_url_is_not_resolved' => 'URL-adresse kan ikke løses: kontroller din DNS-innstillinger. URL-adresse %1 må løses i IP-adresse av serveren hvor Presence Builder er installert.',

    'ip_addr__is_last_on_interface' => 'Kan ikke fjerne IP adressen %%ip%% fordi det er den siste IP adressen tilstede på et nettverks grensesnitt.',
    'ip_addr__used_for_current_session' => 'Kan ikke fjerne IP adressen %%ip%% fordi den er i bruk av en aktiv økt.',
    'ip_addr__used_for_hosting' => 'Kan ikke fjerne IP-adressen %%ip%% fordi den brukes for hosting av et nettsted.',
    'ip_addr__is_main' => 'Kan ikke fjerne IP adressen %%ip%% fordi det er den primære IP adressen på et nettverks grensesnitt.',
    'ip_addr__ip_used_by_message_submission' => 'Kan ikke fjerne IP-adresse %%ip%% fordi den er i bruk for sending av e-post.',

    // RESELLER ACTION LOG

    '__cl_domains' => 'kundenes domener',
    'excl_ip_num' => 'Dedikert IPadresse',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder er ikke installert',

    '__perm_allow_oversell_can_not_be_revoked' => 'Tillatelse til oversalg kan ikke fjernes fra brukeren fordi brukeren allerede har allokert flere ressurser enn de som er tilgjengelige, og gått inn i oversalgsmodus.',
    'limitsManager__invalid_limit_value' => 'Gal verdi %%value%% spesifisert for grensen %%limit_name%%',
    'confirmationForm_default_agreement_text' => 'Bekreft operasjonen',
    'confirmationForm_default_confirm_message' => 'Vennligst bekreft operasjonen.',
    'limit__max_mn' => 'Maksimalt antall e-postkontoer',

    'limits__client_overuse_description' => 'Policyer for overbruk forteller Plesk hva som skal gjøres når ressursbruk overstiger opprinnelig ressurstilordning.',
    'limits__client_overuse_block_true_description' => 'Blokker overforbruk av ressurser. Faktisk ressursforbruk kan ikke overskride den initielle ressurs allokeringen',
    'limits__client_overuse_block_false_description' => 'Ikke blokker overforbruk av ressurser, la kunden bruke flere ressurser enn de som først ble tildelt. Faktisk ressursforbruk kan overskride den initielle ressurs allokeringen',
    'limits__client_overuse_notify_text' => 'Varsle kunden om at de har nådd ressursgrensene',

    'limits__domain_overuse_description' => 'Policyer for overbruk forteller Plesk hva som skal gjøres når ressursbruk overstiger opprinnelig ressurstilordning.',
    'limits__domain_overuse_block_true_description' => 'Retningslinjer for overforbruk forteller Plesk hva som skal gjøres når det forekommer overforbruk av ressurser.',
    'limits__domain_overuse_block_false_description' => 'Ikke blokker overforbruk av ressurser, la domenet bruke flere ressurser enn de som først ble tildelt. Faktisk ressursforbruk kan overskride den initielle ressurs allokeringen',
    'limits__domain_overuse_notify_text' => 'Varsle domeneeier om at de har nådd ressursgrensene',


    'cancel_remove' => 'Forkaste hvilken som helst endring og gå tilbake til forrige side.',
    'php_not_installed' => 'PHP er ikke installert',

    'dns__dns_rr_delete' => 'Elementer som fjernes',
    'dns__delete_rr' => 'Følgende DNS-oppføringer vil bli fjernet fra DNS-sonen:',
    'dns__dns_rr_delete_non_removable' => 'Elementer som ikke kan fjernes',
    'dns__non_delete_rr' => 'Følgende DNS oppføringer kan ikke fjernes:',
    'dns__dns_rr_delete_confirm_message' => 'Bekreft fjerningen av DNS oppføringer',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Ukjent format på webprogram: webprogram kan være utilgjengelig for installasjon og bruk.',

    '__php_handler_type_desc' => 'Kjør PHP som',
    'sfdk_domain_sign__failed' => 'En uidentifisert feil oppstod da du prøvde å slå på signering av epost med DKIM på domenet. Se serverens feillogg for mer informasjon.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Suksessvarsel for Plesk nøkkeloppdatering',
    'pkey_notify__subj_update_deferral_notification' => 'Utsettelsesvarsel for Plesk nøkkeloppdatering',
    'pkey_notify__subj_update_error_notification' => 'Feilvarsel for Plesk nøkkeloppdatering',
    'pkey_notify__update_successful' => '%1 oppdatering fullført vellykket.',
    'pkey_notify__update_failed_no_more_try' => 'Kunne ikke oppdatere %1. Nøkkelen du prøver å sende er ugyldig. Du bør ikke prøve å oppdatere denne nøkkelen mer.',
    'pkey_notify__update_failed_try_later' => 'Kunne ikke oppdatere %1: en feil oppstod under behandling av nøkkelen din. Du kan prøve å hente nøkkelen manuelt i Plesk (Verktøy og innstillinger>Lisensinformasjon) eller la Plesk prøve å oppdatere den i løpet av de neste 24 timene. Hvis du ikke ønsker å motta dette varselet igjen, fjerner du denne nøkkelen fra Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Kan ikke slå av global spamfiltrering.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Kan ikke slå på global spamfiltrering',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Domener',
    'rpt_reseller_dom_subdomains' => 'Subdom',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'MBoxes',
    'rpt_reseller_dom_redirects' => 'Videresendere',
    'rpt_reseller_dom_mail_groups' => 'MGroups',
    'rpt_reseller_dom_mail_resps' => 'AResp.',
    'rpt_reseller_dom_mail_antispam' => 'AntiSpam',
    'rpt_reseller_dom_mail_antivirus' => 'Antivirus',
    'rpt_reseller_dom_mail_lists' => 'MLists',
    'rpt_reseller_dom_web_users' => 'WUsers',
    'rpt_reseller_dom_data_bases' => 'DBMySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Kunder',
    '__cl_name' => 'Kundenavn',
    '__cl_creation_date' => 'Opprettelsesdato',
    '__clients_traffic' => 'Kundetrafikk',
    'rpt_reseller_cl_mail_antispam' => 'AntiSpam',
    'rpt_reseller_cl_mail_antivirus' => 'Antivirus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder er ikke installert',
    'sitebuilder_disabled' => 'Presence Builder er slått av.',
    'b_sitebuilder_disabled' => 'Presence Builder er slått av.',
    'webmail_not_installed' => 'Webmail programvare er ikke installert.',
    'webmail_disabled' => 'Eposttjeneste er slått av.',
    'spamassassin_not_installed' => 'SpamAssassin er ikke installert.',
    // pfu:
    'anonymous_ftp_shared' => 'Kan ikke sette opp anonym FTP: delt IP adresse type.',
    'anonymous_ftp_used' => 'Kunne ikke sette opp anonym FTP: IP-adressen benyttes av et annet domene for anonym FTP-tjeneste.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET er ikke installert.',
    'site_builder_no_package' => 'Presence Builder er ikke tilgjengelig. Vennligst sjekk at Presence Builder er installert og valgt som en aktiv komponent.',
    'site_builder_not_configured' => 'Presence Builder er ikke konfigurert.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Verktøy',
    'ui__reseller/client#clientslist__title' => 'Kunder',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Behandle virtuelle mapper under et nettsted',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Velg nettstedet du vil behandle mappene på.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Sett opp anonym FTP på domene',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Velg domenet du ønsker å sette opp anonym FTP på.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Sett opp logghåndterer for domene og vis loggfiler for domene',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Velg domene du ønsker å sette opp logghåndterer for og hvilke loggfiler du ønsker å vise.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Administrer SSL/TLS-sertifikater for domene',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Velg det domenet du ønsker å administrere SSL/TLS-sertifikater for.',

    'ui__client/domain/disable_multi__wizard-title' => 'Suspender domener',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Velg de domenene du ønsker å suspendere.',

    'ui__client/domain/enable_multi__wizard-title' => 'Aktiver domener',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Velg domenene som du vil aktivere.',

    'ui__client/domain_unknown__wizard-title' => 'Vis domener',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Velg en kunde du ønsker å vise domener for.',

    'ui__client/domain/register_unknown__wizard-title' => 'Registrer domener',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Velg det domenet du ønsker å registrere.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Bruk verktøy fra MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Velg det domenet du ønsker å administrere med verktøy fra MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'IP adresse brukere',
    'ui__server/ip-address/client_unknown__title' => 'IP adresse brukere',
    'ui__server/ip-address/client_unknown__description' => 'Brukere av IP adresse %1',

    'disabled_by_admin' => 'Deaktivert av serveradministrator',






    'ui__client/domain/chowner_multi__short-title' => 'Endre eierskap',
    'ui__client/domain/chowner_multi__title' => 'Endre eierskap for abonnement',
    'ui__client/domain/chowner_multi__description' => 'Endre eierskap for abonnement.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Velg domener du ønsker å endre eierskap for og klikk på Neste >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Endre eierskap',
    'ui__client/domain/chowner_unknown__title' => 'Endre eierskap for abonnement',
    'ui__client/domain/chowner_unknown__description' => 'Endre eierskap for abonnement.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Endre eierskap for abonnement',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Det er ingen brukerdefinerte knapper.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Det er ingen egendefinerte knapper på forhandler %1s grensesnitt.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Fjern denne knappen %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Fjern',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Fjern denne knappen %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Fjern egendefinerte knapper fra forhandlerens grensesnitt',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Fjern',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Fjern kundedefinerte knapper',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Fjern knapper',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Velg en forhandler du ønsker å fjerne brukerdefinerte knapper for og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Velg knappene du vil fjerne og klikk Neste>>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Bekreft fjerningen av knapper ved å velge avmerkingsboksen på denne skjermen, og klikk på Fullfør.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Fjern en egendefinert knapp forhandlerens grensesnitt.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Fjern',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Fjern en brukerdefinert knapp',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Fjern brukerdefinert knapp',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Velg en forhandler du ønsker å fjerne en brukerdefinert knapp fra og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Velg en brukerdefinert knapp du ønsker å fjerne og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Bekreft fjerning av brukerdefinert knapp ved å krysse av på dette skjermbildet og deretter klikke på Fullfør.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Rediger egenskaper for brukerdefinert knapp %1 på forhandlernivå.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Innstillinger',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Modifiser forhandlerens brukerdefinerte knapp %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Legg til brukerdefinert knapp',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Velg en forhandler du ønsker å opprette en brukerdefinert knapp på grensesnitt for og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Klikk på Fullfør for å opprette knappen.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Endre egenskaper for en knapp på forhandlerens grensesnitt.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Egenskaper',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Endre egenskaper for en knapp på forhandlerens grensesnitt',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Endre egenskaper for brukerdefinert knapp',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Velg en forhandler du ønsker å modifisere en brukerdefinert knapp for og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Velg en brukerdefinert knapp du ønsker å modifisere og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Når du er klar med å endre egenskapene for knappen, klikk på Fullfør for å godta endringene og sluttføre veiviseren.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Gjør knappen %1 utilgjengelig for kundene dine.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Gjør utilgjengelig for kundene dine',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Gjør knappen %1 utilgjengelig for kundene dine',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Gjør knappen %1 synlig for forhandlerens kunder.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Gjør tilgjengelig for kundene dine',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Gjør knappen %1 synlig for forhandlerens kunder',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Gjør en brukerdefinert knapp tilgjengelig/utilgjengelig for kundene dine.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Tilgjengelig/utilgjengelig for kundene dine',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Gjør en brukerdefinert knapp tilgjengelig eller utilgjengelig for kundene dine',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Gjør en brukerdefinert knapp tilgjengelig/utilgjengelig for kundene dine.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Velg en forhandler du ønsker å gjøre en brukerdefinert knapp tilgjengelig for forhandlerens kunder for og klikk på Neste >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Velg en brukerdefinert knapp du ønsker å gjøre tilgjengelig eller utilgjengelig for kundene dine og klikk på Neste >>.',

    '__not_allowed' => 'Ikke tillatt',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Velg ny eier for domenet.',

    '__ip_addr_state_unknown' => "IP adressen er ikke brukbar nå fordi systemet fortsatt behandler ditt ønske. Vennligst vent litt.",


    'resellers_list__accounts' => 'Brukere',

    'ip_addr__repair_is_not_allowed' => 'IP adressen kan ikke repareres i Virtuozzo miljøet.',

    'ui__reseller/client__none-available__1' => 'Forhandler %1 har ingen kunder.',

    'ippoolManager__ip_used_by_nohost_domain' => "IP-adressen %%ip%% kan ikke fjernes fordi den brukes av et eller flere domener uten hosting.",
    'ippoolManager__ip_used_for_mail_service' => "IP-adressen %%ip%% kan ikke fjernes fordi den brukes av ett eller flere domener for e-posttjenestens IP-adresse.",
    'ippoolManager__ip_used_for_send_emails' => "IP-adressen %%ip%% kan ikke fjernes fordi den brukes til å sende e-postmeldinger fra spesifikk IP (se e-postserverinnstillingene).",
    'ippoolManager__ip_used_in_dns_zone' => 'IP-adressen %%ip%% kan ikke fjernes fordi den brukes av DNS-sonen til et eller flere domener.',
    'ip_ctrl__cannot_manage_on_vz' => 'Denne installasjonen av Plesk kjører under Virtuozzo-beholdere. Nye IP-adresser kan bare legges til av Virtuozzo-beholdere nodeadministrator.',

    'client_template__limits_auto_adjusted' => 'Grenser fra kundemal ble automatisk justert.',

    '__entries' => 'Innlegg',

    '__path_is_not_set' => 'Banen er ikke angitt. Vennligst angi en gyldig bane.',

    'defaultcomponents__imap_required' => '(Gjeldende e-postserver ikke støtter IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk støtter bare kommersielle webstatistikkprogramvare for statistikkberegning på underdomene. Det finnes ingen slik programvare installert i systemet nå.',


    'server_settings_invalid_traffic_statistics' => 'Ugyldig parameter for trafikkstatistikk.',
    'server_settings_invalid_logrotate_period' => 'Ugyldig parameter for loggroteringsperiode.',

    'spam_filter/address/file_size' => 'Kunne ikke laste opp filen. Maksimal størrelse på en fil som skal lastes opp er %1.',
    'spam_filter/address/file_empty_content' => 'Det oppstod et problem ved lesing av e-postadresser fra filen. Sørg for at filen du laster opp er i UTF-8-format og at den inneholder én eller flere e-postadresser, og prøv igjen.',
    'spam_filter/address/addresses_empty_content' => 'Det er ingen e-postadresser i listen.',
    'spam_filter/address/addresses_available' => 'Bare %1 første unike e-postadresser vil bli lagt til.',
    'spam_filter/address/invalid_addresses' => 'Følgende e-postadresser er ugyldige %1.',
];