<?php
// Copyright 1999-2023. Plesk International GmbH. All rights reserved.
// This file contains structured and commented locale keys for Plesk 9.x

global $PROD_NAME;

$GLOBALS['lmsg_arr'] += [
    ////
    //// LOGIN SCREEN
    ////

    'login_up__access_denied_account_disabled' => "Truy cập bị từ chối. Tài khoản của bạn đã bị đình chỉ.",
    'login_up__login_has_been_locked' => "Bạn đã cố đăng nhập bằng mật khẩu sai quá nhiều lần. Vì lý do bảo mật, bạn sẽ không thể đăng nhập bằng tài khoản này trong một lúc.",
    'login_up__unable_to_check_pass' => "Không thể kiểm tra mật khẩu: %1",
    'login_up__warning_limits_licence_key' => "Một trong các mục sau đây đã vượt quá giới hạn quy định theo bản quyền của bạn: số tài khoản người dùng, tên miền, các tài khoản email hoặc người dùng web được lưu trữ trên máy chủ của bạn.\nHãy liên hệ với bộ phận bán hàng Plesk để mua key cho phép bạn lưu trữ số lượng người dùng và tên miền mong muốn. Vui lòng liên hệ bộ phận hỗ trợ kỹ thuật Plesk nếu bạn cảm thấy bạn nhận được thông báo này do nhầm lẫn.\nGiới hạn bản quyền cho các tài khoản người dùng/tên miền/tài khoản mail/người dùng web/gói ngôn ngữ: %2.\nSố lượng tài khoản người dùng/tên miền/tài khoản mail/người dùng web/gói ngôn ngữ hiện được lưu trữ: %3.", // PFW
    'login_up__short_warning_limits_licence_key' => "Số lượng tài nguyên bạn sử dụng đã vượt quá giới hạn quy định theo bản quyền sản phẩm hiện tại của bạn. Hãy liên hệ với bộ phận bán hàng Plesk và mua key bản quyền mới.",
    'login_up__grace_period' => 'Bạn đang hoạt động trong thời gian ân hạn theo giấy phép của sản phẩm. Để cập nhật giấy phép, chọn tùy chọn Lấy giấy phép trong phần %1Trang Thông tin bản quyền%2.',
    'login_up__partner_license_message' => 'Hoạt động của bạn đang bị giới hạn, cần phải đăng ký để có thể sử dụng tất cả những tính năng. Để cập nhật giấy phép, chọn tùy chọn Lấy giấy phép trong phần %1Trang Thông tin bản quyền%2.',
    'login_up__system_admin_disabled' => 'Người dùng cao cấp (tài khoản root hoặc tài khoản quản trị) bị cấm đăng nhập vào Plesk vì các lý do bảo mật.',

    ///
    /// Online help keys:
    ///

    'plesk_guide' => "Hướng dẫn dành cho quản trị viên Plesk",
    'plesk_guide_reseller' => "Hướng dẫn dành cho đại lý Plesk",
    'plesk_guide_client' => "Hướng dẫn dành cho khách hàng Plesk",
    'plesk_guide_domain_admin' => "Hướng dẫn dành cho quản trị tên miền Plesk",
    'plesk_guide_mailuser' => "Hướng dẫn dành cho người dùng email Plesk",

    ////
    //// COMMON KEYS FOR NAVIGATION THROUGHOUT PANEL
    ////

    ///
    /// NAVIGATION PANE
    ///

    'bt_search' => 'Tìm kiếm', // multiple usage: TBI
    'ui__client_unknown__quick-search' => 'Khách hàng',
    'ui__reseller_unknown__quick-search' => 'Các đại lý',
    'ui__client/domain_unknown__quick-search' => 'Các tên miền',
    'nav__general' => 'Menu chính',
    '__home' => 'Trang chủ',
    '__resellers' => 'Các đại lý',
    '__clients' => 'Khách hàng',
    '__domains' => 'Các tên miền',
    '__applications' => 'Ứng dụng',
    '__settings' => 'Cài đặt',
    'nav__system' => 'Hệ thống',
    '__master' => 'Chính',

    ///
    /// END OF NAVIGATION PANE
    ///

    ///
    /// NAVIGATION KEYS
    ///

    // up level
    'bt_up_level' => 'Lên cấp',

    // object switcher

    ///
    /// END OF NAVIGATION KEYS
    ///

    ///
    /// LISTS
    ///

    // common operations on list objects
    'bt_remove_selected' => 'Gỡ bỏ',
    'bt_make_default' => 'Đặt mặc định',

    // common list object operation errors
    'class_cList__empty_selection' => 'Không có đối tượng nào được chọn.',

    // common list object search keys
    'clist__search_show' => 'Hiển thị Tìm kiếm',
    'clist__search_hide' => 'Ẩn Tìm kiếm',

    'bt_show_all' => "Đặt lại tìm kiếm",

    // common object list info keys
    'clist__first' => 'Đầu tiên',
    'clist__last' => 'Cuối cùng',
    'clist__prev' => '&lt;&lt;',
    'clist__next' => '&gt;&gt;',
    'clist__page' => 'Trang',
    'clist__page_size' => 'Các mục trên mỗi trang',
    'clist__info' => 'Tổng %1: %4',
    'clist__info_empty' => 'Số %1',
    'clist__info_filter' => '%5 %1 đã phát hiện (tổng cộng %4)',
    'clist__info_paging' => '%2-%3 %1 trong tổng số %4',
    'clist__info_paging_filter' => '%2-%3 %1 của %5 được phát hiện (tổng cộng %4)',

    ///
    /// END OF LISTS
    ///

    ////
    //// KEYS FOR USER HOME PAGES
    ////

    ///
    /// COMMON HOME PAGE KEYS
    ///

    // business object controls
    '__object_on' => 'Hiện hoạt',
    '__object_off' => 'Đã treo',

    '__home_description' => 'Quay trở lại trang chủ.',
    'indicator_title' => 'Đã dùng %1%, còn trống %2%', // tooltip for visual stats area

    ///
    /// END OF COMMON HOME PAGE KEYS
    ///

    ///
    /// SERVER ADMINISTRATOR
    ///

    '__invalid_url_requested' => 'Đã yêu cầu URL không hợp lệ.',

    // accounts
    // icons
    'ui__reseller_unknown__short-title' => "Tài khoản đại lý",
    'ui__reseller_unknown__title' => "Tài khoản đại lý",
    'ui__reseller_unknown__description' => "Quản lý tài khoản đại lý.",
    'ui__reseller/client_unknown__short-title' => 'Tài khoản khách hàng',
    'ui__reseller/client_unknown__title' => 'Tài khoản khách hàng',
    'ui__reseller/client_unknown__description' => 'Quản lý tài khoản của khách hàng.',
    // dropdowns
    'ui__admin-alias_unknown__title' => "Tài khoản quản trị bổ sung", // PFW
    'ui__admin-alias_unknown__short-title' => "Tài khoản quản trị bổ sung", // PFW
    'ui__admin-alias_unknown__description' => "Xem và quản lý tài khoản quản trị bổ sung.", // PFW

    // server
    // icons
    'ui__server/mail__short-title' => "Thiết lập thư toàn máy chủ",
    'ui__server/mail__title' => "Thiết lập thư toàn máy chủ",
    'ui__server/mail__description' => "Khởi tạo máy chủ thư và cấu hình các thiết lập thư trên toàn máy chủ.",
    'ui__server/dns__short-title' => 'Thiết lập DNS',
    'ui__server/dns__title' => 'Thiết lập DNS',
    'ui__server/dns__description' => 'Xem và cập nhật thiết lập DNS trên toàn máy chủ.',
    'ui__server/services__title' => 'Trình Quản lý dịch vụ',
    'ui__server/services__description' => 'Bắt đầu, ngừng hoặc khởi động lại các dịch vụ Plesk.',
    'ui__server/crontab/task_unknown__short-title' => 'Các Tác vụ lập lịch',
    'ui__server/crontab/task_unknown__title' => 'Các Tác vụ lập lịch',
    'ui__server/crontab/task_unknown__description' => 'Thêm và gỡ bỏ các tác vụ được lập lịch trên toàn máy chủ.',
    'ui__server/ip-address_unknown__short-title' => 'Các địa chỉ IP',
    'ui__server/ip-address_unknown__title' => 'Các địa chỉ IP',
    'ui__server/ip-address_unknown__description' => 'Xem, thêm và gỡ bỏ địa chỉ IP, gán địa chỉ IP cho đại ý.',
    // dropdowns
    'ui__server/time__title' => 'Giờ Hệ thống',
    'ui__server/time__short-title' => 'Giờ Hệ thống',
    'ui__server/time__description' => 'Thay đổi ngày và giờ hệ thống, thiết lập đồng bộ hóa với máy chủ NTP.',
    'ui__server/maillists__title' => 'Thiết lập máy chủ danh sách gửi thư', // PFU
    'ui__server/maillists__short-title' => 'Thiết lập máy chủ danh sách gửi thư', // PFU
    'ui__server/maillists__description' => 'Thiết đặt máy chủ danh sách gửi thư Mailman.', // PFU
    'ui__mass-email__short-title' => "Tin nhắn email hàng loạt", // PFW
    'ui__mass-email__title' => "Tin nhắn email hàng loạt", // PFW
    'ui__mass-email__description' => "Gửi tin nhắn email cho nhiều người dùng cùng lúc.", // PFW
    'ui__mass-mail__title' => 'Tin nhắn email hàng loạt', // PFU
    'ui__mass-mail__short-title' => 'Tin nhắn email hàng loạt', // PFU
    'ui__mass-mail__description' => 'Gửi tin nhắn email cho nhiều người dùng cùng lúc.', // PFU
    'ui__server/spam-filter__title' => 'Các thiết lập bộ lọc thư rác',
    'ui__server/spam-filter__short-title' => 'Các thiết lập bộ lọc thư rác',
    'ui__server/spam-filter__description' => 'Khởi tạo bộ lọc thư rác trên toàn máy chủ.',
    'ui__server/preferences__title' => "Các thiết lập máy chủ",
    'ui__server/preferences__short-title' => "Các thiết lập máy chủ",
    'ui__server/preferences__description' => "Thiết đặt tính toán thống kê toàn máy chủ, thay đổi tên máy chủ host và các thiết lập khác của máy chủ.",

    // help & support
    // icons
    'ui__support__short-title' => 'Hỗ trợ',
    'ui__support__title' => 'Hỗ trợ',
    'ui__support__description' => 'Gửi một yêu cầu đến hỗ trợ kỹ thuật hoặc xem lại các phiếu hỗ trợ được tạo bởi khách hàng.',
    'ui__license__short-title' => 'Thông tin bản quyền',
    'ui__license__title' => 'Thông tin bản quyền Plesk',
    'ui__license__description' => 'Xem thông tin về bản quyền Plesk của bạn và đặt hàng các key bản quyền mới.',
    'ui__help__short-title' => 'Trợ giúp',
    'ui__help__title' => 'Trợ giúp trực tuyến',
    'ui__help__description' => 'Xem trợ giúp trực tuyến.',
    'ui__news__short-title' => "Tin mới",
    'ui__news__title' => "Tin mới",
    'ui__news__description' => "Xem danh sách các thay đổi trong phiên bản Plesk này.",
    'ui__server/autoinstaller__short-title' => 'Cập nhật',
    'ui__server/autoinstaller__title' => 'Cập nhật',
    'ui__server/autoinstaller__description' => 'Cập nhật Plesk và các thành phần của nó.',
    // dropdowns

    // domains
    // icons
    'ui__client/domain_unknown__short-title' => 'Các tên miền',
    'ui__client/domain_unknown__title' => 'Các tên miền',
    'ui__client/domain_unknown__description' => 'Quản lý tên miền.',
    'ui__server/skeleton__short-title' => 'Mẫu lưu trữ ảo',
    'ui__server/skeleton__title' => 'Mẫu lưu trữ ảo',
    'ui__server/skeleton__description' => 'Xác định các tập tin và thư mục sẽ bao gồm trong tên miền được tạo mới.',
    // dropdowns
    'ui__client/domain/chowner_multi-select__title' => 'Gán chủ sở hữu mới cho thuê bao',
    'ui__client/domain/chowner_multi-select__short-title' => 'Gán chủ sở hữu thuê bao mới',
    'ui__client/domain/chowner_multi-select__description' => 'Gán chủ sở hữu mới cho các thuê bao được chọn',
    'ui__client/domain/disable_multi__title' => 'Tạm dừng tên miền',
    'ui__client/domain/disable_multi__short-title' => 'Tạm dừng tên miền',
    'ui__client/domain/disable_multi__description' => 'Tạm dừng các tên miền được chọn',
    'ui__client/domain/enable_multi__title' => 'Kích hoạt tên miền',
    'ui__client/domain/enable_multi__short-title' => 'Kích hoạt tên miền',
    'ui__client/domain/enable_multi__description' => 'Kích hoạt các tên miền được chọn',

    // icons
    'ui__admin/extras-domain__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__admin/extras-domain__title' => 'Công cụ từ MyPlesk.com',
    'ui__admin/extras-domain__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__server/aspdotnet__short-title' => 'Các thiết lập ASP.NET', // PFW
    'ui__server/aspdotnet__title' => 'Các thiết lập ASP.NET', // PFW
    'ui__server/aspdotnet__description' => 'Cấu hình thiết lập ASP.NET trên toàn máy chủ.', // PFW
    'ui__server/sitebuilder__short-title' => 'Cài đặt Presence Builder', // PFU
    'ui__server/sitebuilder__title' => 'Cài đặt Presence Builder', // PFU
    'ui__server/sitebuilder__description' => 'Thiết lập Presence Builder để chỉnh sửa các website lưu trữ trên máy chủ này.', // PFU
    // dropdowns
    'ui__admin/register-domain__title' => 'Đăng ký tên miền',
    'ui__admin/register-domain__short-title' => 'Đăng ký tên miền',
    'ui__admin/register-domain__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__admin/manage-domain__title' => 'Quản lý tên miền',
    'ui__admin/manage-domain__short-title' => 'Quản lý tên miền',
    'ui__admin/manage-domain__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',
    'ui__server/register__title' => 'Đăng ký máy chủ của bạn',
    'ui__server/register__short-title' => 'Đăng ký máy chủ',
    'ui__server/register__description' => 'Đăng ký máy chủ của bạn để tham gia vào chương trình liên kết',

    // logs & statistics
    // icons
    'ui__actionlog__short-title' => 'Nhật ký hoạt động',
    'ui__actionlog__title' => 'Nhật ký hoạt động',
    'ui__actionlog__description' => 'Tải nhật ký hoạt động và quản lý các thiết lập của nhật ký hoạt động.',
    // dropdowns
    'ui__server/statistics__short-title' => 'Thông tin máy chủ',
    'ui__server/statistics__title' => 'Thông tin máy chủ',
    'ui__server/statistics__description' => 'Thống kê các dịch vụ quản lý bởi Plesk.',
    'ui__admin/report__title' => 'Báo cáo tóm tắt',
    'ui__admin/report__short-title' => 'Báo cáo tóm tắt',
    'ui__admin/report__description' => 'Xem báo cáo về tình hình sử dụng lưu lượng và tài nguyên dành cho đại lý, khách hàng và tên miền.',

    // security
    // icons
    'ui__sessions/properties__short-title' => 'Thời gian chờ của phiên',
    'ui__sessions/properties__title' => 'Thời gian chờ của phiên',
    'ui__sessions/properties__description' => 'Đặt thời gian chờ của phiên cho các phiên Plesk.',
    'ui__cp-access__short-title' => 'Truy cập vào Plesk',
    'ui__cp-access__title' => 'Truy cập vào Plesk',
    'ui__cp-access__description' => 'Hạn chế truy cập vào Plesk.',
    'ui__sessions__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__sessions__title' => 'Phiên kết nối đang hoạt động',
    'ui__sessions__description' => 'Xem các phiên Plesk đang hoạt động.',
    // dropdowns
    'ui__server/certificate_unknown__title' => 'Chứng nhận SSL/TLS',
    'ui__server/certificate_unknown__short-title' => 'Chứng nhận SSL/TLS',
    'ui__server/certificate_unknown__description' => 'Danh sách các chứng nhận SSL/TLS.',

    // account
    // icons
    'ui__admin-info__short-title' => 'Dữ liệu cá nhân',
    'ui__admin-info__title' => 'Dữ liệu cá nhân',
    'ui__admin-info__description' => 'Thay đổi dữ liệu cá nhân của tài khoản.',
    'ui__admin-password__short-title' => 'Đổi mật khẩu',
    'ui__admin-password__title' => 'Đổi mật khẩu',
    'ui__admin-password__description' => 'Đổi mật khẩu cho tài khoản của bạn.',
    // dropdowns

    ///
    /// END OF SERVER ADMINISTRATOR
    ///

    ///
    /// RESELLER
    ///

    // business objects

    // files
    // icons
    'ui__client/domain/hosting/web-directories_unknown__title' => 'Thư mục ảo', // PFW
    'ui__client/domain/hosting/web-directories_unknown__short-title' => 'Thư mục ảo', // PFW
    'ui__client/domain/hosting/web-directories_unknown__description' => 'Làm việc với tập tin và thư mục vật lý và ảo trên một trang web.', // PFW

    // statistics
    // icons
    'ui__reseller/limits__short-title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits__title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits__description' => 'Xem và quản lý tài nguyên sử dụng của đại lý %1.',
    'ui__reseller/limits_unknown__short-title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits_unknown__title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits_unknown__description' => 'Xem và quản lý tài nguyên sử dụng của đại lý.',
    'ui__reseller/limits_self__short-title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits_self__title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits_self__description' => "Xem và quản lý tài nguyên sử dụng của bạn.",
    'ui__reseller/limits_readonly-self__short-title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits_readonly-self__title' => 'Sử dụng Tài nguyên',
    'ui__reseller/limits_readonly-self__description' => "Xem tài nguyên sử dụng của bạn.",
    'ui__reseller/client/traffic_unknown__short-title' => 'Việc sử dụng lưu lượng của khách hàng',
    'ui__reseller/client/traffic_unknown__title' => 'Xem lưu lượng sử dụng bởi khách hàng',
    'ui__reseller/client/traffic_unknown__description' => 'Xem báo cáo lưu lượng sử dụng của tài khoản khách hàng.',
    'ui__client/traffic_unknown__short-title' => "Việc sử dụng lưu lượng của khách hàng", // temporary for presets
    'ui__client/traffic_unknown__title' => "Xem lưu lượng sử dụng bởi khách hàng", // temporary for presets
    'ui__client/traffic_unknown__description' => "Xem báo cáo lưu lượng sử dụng của tài khoản khách hàng.", //  temporary for presets
    'ui__client/domain/hosting/logs_unknown__short-title' => 'Quản lý nhật ký',
    'ui__client/domain/hosting/logs_unknown__title' => 'Quản lý nhật ký',
    'ui__client/domain/hosting/logs_unknown__description' => 'Xem nhật ký và cấu hình luân chuyển nhật ký.',
    // dropdowns
    'ui__reseller/report__title' => 'Báo cáo tóm lược',
    'ui__reseller/report__short-title' => 'Báo cáo tóm lược',
    'ui__reseller/report__description' => 'Xem báo cáo sử dụng lưu lượng và tài nguyên của đại lý này.',
    'ui__reseller/report_unknown__title' => 'Báo cáo tóm lược',
    'ui__reseller/report_unknown__short-title' => 'Báo cáo tóm lược',
    'ui__reseller/report_unknown__description' => 'Xem báo cáo sử dụng lưu lượng và tài nguyên dành cho đại lý.',
    'ui__reseller/report_self__title' => 'Báo cáo tóm lược',
    'ui__reseller/report_self__short-title' => 'Báo cáo tóm lược',
    'ui__reseller/report_self__description' => 'Xem báo cáo sử dụng lưu lượng và tài nguyên của bạn.',

    // account
    // icons
    'ui__client/logo_reseller__title' => 'Nhãn hiệu Plesk',
    'ui__client/logo_reseller__short-title' => 'Nhãn hiệu Plesk',
    'ui__client/logo_reseller__description' => 'Đổi tên nhãn hiệu Plesk cho đại lý %1.',
    'ui__client/logo_unknown__title' => 'Nhãn hiệu Plesk', // temporary for presets
    'ui__client/logo_unknown__short-title' => 'Nhãn hiệu Plesk', // temporary for presets
    'ui__client/logo_unknown__description' => 'Đổi tên nhãn hiệu Plesk.', // temporary for presets
    'ui__client/logo_self-reseller__title' => 'Nhãn hiệu Plesk',
    'ui__client/logo_self-reseller__short-title' => 'Nhãn hiệu Plesk',
    'ui__client/logo_self-reseller__description' => 'Đổi tên nhãn hiệu Plesk của bạn.',
    'ui__reseller/permissions__title' => 'Quyền truy cập',
    'ui__reseller/permissions__short-title' => 'Quyền truy cập',
    'ui__reseller/permissions__description' => "Xem hoặc thay đổi các hành động mà đại lý %1 có thể thực hiện trong Plesk.",
    'ui__reseller/permissions_unknown__short-title' => 'Quyền truy cập',
    'ui__reseller/permissions_unknown__title' => 'Quyền truy cập',
    'ui__reseller/permissions_unknown__description' => "Xem hoặc thay đổi các hành động mà đại lý có thể thực hiện trong Plesk.",
    'ui__reseller/permissions_self__title' => 'Quyền truy cập',
    'ui__reseller/permissions_self__short-title' => 'Quyền truy cập',
    'ui__reseller/permissions_self__description' => 'Xem danh sách các hành động mà bạn có thể thực hiện trong Plesk.',
    'ui__reseller/permissions_readonly-self__title' => 'Quyền truy cập',
    'ui__reseller/permissions_readonly-self__short-title' => 'Quyền truy cập',
    'ui__reseller/permissions_readonly-self__description' => 'Xem danh sách các hành động mà bạn có thể thực hiện trong Plesk.',

    // domains
    // icons
    // Domains - see SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - see SERVER ADMINISTRATOR/DOMAINS
    'ui__client/skeleton__title' => 'Mẫu lưu trữ ảo',
    'ui__client/skeleton__short-title' => 'Mẫu lưu trữ ảo',
    'ui__client/skeleton__description' => 'Xác định các tập tin và thư mục sẽ bao gồm trong tên miền được tạo mới.',
    'ui__client/skeleton_unknown__short-title' => 'Mẫu lưu trữ ảo',
    'ui__client/skeleton_unknown__title' => 'Mẫu lưu trữ ảo',
    'ui__client/skeleton_unknown__description' => 'Xác định các tập tin và thư mục sẽ bao gồm trong tên miền được tạo mới.',

    // website
    // icons
    'ui__client/domain/domain-alias_unknown__short-title' => 'Các bí danh tên miền',
    'ui__client/domain/domain-alias_unknown__title' => 'Các bí danh tên miền',
    'ui__client/domain/domain-alias_unknown__description' => 'Xem danh sách các tên miền thay thế cho tên miền của bạn.',
    //dropdowns
    'ui__client/domain/dns_unknown__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_unknown__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_unknown__description' => 'Quản lý thiết lập vùng DNS cho một tên miền.',
    'ui__client/domain/dns_readonly-unknown__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-unknown__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-unknown__description' => 'Xem thiết lập vùng DNS cho một tên miền.',

    // applications & services
    // icons
    'ui__reseller/extras-domain__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__reseller/extras-domain__title' => 'Công cụ từ MyPlesk.com',
    'ui__reseller/extras-domain__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__reseller/extras-domain_unknown__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__reseller/extras-domain_unknown__title' => 'Công cụ từ MyPlesk.com',
    'ui__reseller/extras-domain_unknown__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__reseller/extras-domain_self__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__reseller/extras-domain_self__title' => 'Công cụ từ MyPlesk.com',
    'ui__reseller/extras-domain_self__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__reseller/register-domain__short-title' => 'Đăng ký tên miền',
    'ui__reseller/register-domain__title' => 'Đăng ký tên miền',
    'ui__reseller/register-domain__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__reseller/register-domain_unknown__short-title' => 'Đăng ký tên miền',
    'ui__reseller/register-domain_unknown__title' => 'Đăng ký tên miền',
    'ui__reseller/register-domain_unknown__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__reseller/register-domain_self__short-title' => 'Đăng ký tên miền',
    'ui__reseller/register-domain_self__title' => 'Đăng ký tên miền',
    'ui__reseller/register-domain_self__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    // dropdowns
    'ui__reseller/manage-domain__title' => 'Quản lý tên miền',
    'ui__reseller/manage-domain__short-title' => 'Quản lý tên miền',
    'ui__reseller/manage-domain__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',
    'ui__reseller/manage-domain_unknown__title' => 'Quản lý tên miền',
    'ui__reseller/manage-domain_unknown__short-title' => 'Quản lý tên miền',
    'ui__reseller/manage-domain_unknown__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',
    'ui__reseller/manage-domain_self__title' => 'Quản lý tên miền',
    'ui__reseller/manage-domain_self__short-title' => 'Quản lý tên miền',
    'ui__reseller/manage-domain_self__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown-reseller__title' => 'Các địa chỉ IP',
    'ui__client/ipaddress_unknown-reseller__short-title' => 'Các địa chỉ IP',
    'ui__client/ipaddress_unknown-reseller__description' => 'Quản lý địa chỉ IP.',
    'ui__client/domain/certificate_unknown__short-title' => 'Chứng nhận SSL/TLS',
    'ui__client/domain/certificate_unknown__title' => 'Chứng nhận SSL/TLS',
    'ui__client/domain/certificate_unknown__description' => 'Cài đặt và quản lý chứng nhận SSL/TLS.',
    'ui__reseller/sessions__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__reseller/sessions__title' => 'Phiên kết nối đang hoạt động',
    'ui__reseller/sessions__description' => 'Xem phiên Plesk đang hoạt động.',
    'ui__reseller/sessions_unknown__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__reseller/sessions_unknown__title' => 'Phiên kết nối đang hoạt động',
    'ui__reseller/sessions_unknown__description' => 'Xem các phiên Plesk đang hoạt động.',
    'ui__reseller/sessions_self__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__reseller/sessions_self__title' => 'Phiên kết nối đang hoạt động',
    'ui__reseller/sessions_self__description' => 'Xem các phiên Plesk đang hoạt động.',

    ///
    /// END OF RESELLER
    ///

    ///
    /// CLIENT
    ///

    // business objects
    'mn_list__mail_names_for_client' => 'Các tài khoản thư thuộc tài khoản người dùng %1',

    // domains
    // icons
    // Domains - SERVER ADMINISTRATOR/DOMAINS
    // Domain Templates - SERVER ADMINISTRATOR/DOMAINS
    // Virtual host template - RESELLER/DOMAINS
    'ui__client/skeleton_self__short-title' => 'Mẫu lưu trữ ảo',
    'ui__client/skeleton_self__title' => 'Mẫu lưu trữ ảo',
    'ui__client/skeleton_self__description' => 'Xác định các tập tin và thư mục sẽ bao gồm trong tên miền được tạo mới.',
    // dropdowns
    // Create domain - see RESELLER/DOMAINS
    // Create domain template - see RESELLER/DOMAINS
    // Assign new owner for domains - see SERVER ADMINISTRATOR/DOMAINS
    // Convert Domain Administrator Accounts to Client Accounts - see SERVER ADMINISTRATOR/DOMAINS
    // Update Properties of Multiple Domains - see SERVER ADMINISTRATOR/DOMAINS

    // Suspend domains - see SERVER ADMINISTRATOR/DOMAINS
    // Activate domains - see SERVER ADMINISTRATOR/DOMAINS

    // mail
    // icons
    // Mail accounts - RESELLER/MAIL
    // Create mail account - RESELLER/MAIL
    // Create forwarder - RESELLER/MAIL
    // Create autoresponder - RESELLER/MAIL
    // Mailing lists - RESELLER/MAIL
    // Virus protection - RESELLER/MAIL
    // Spam filtering - RESELLER/MAIL
    // Open Webmail - RESELLER/MAIL
    // dropdowns
    // Mail settings - RESELLER/MAIL
    //Create mailing list - RESELLER/MAIL

    // files
    // icons
    // File manager - RESELLER/FILES
    // Anonymous FTP - RESELLER/FILES
    // FTP accounts - RESELLER/FILES    // PFW
    // SSH terminal - RESELLER/FILES    // PFU
    // Virtual directories - RESELLER/FILES    // PFW
    // Web directories - RESELLER/FILES    // PFW

    // statistics
    // icons
    // Web statistics - RESELLER/STATISTICS
    'ui__client/limits__short-title' => 'Tài nguyên sử dụng',
    'ui__client/limits__title' => 'Tài nguyên sử dụng',
    'ui__client/limits__description' => "Xem và quản lý tài nguyên sử dụng của khách hàng %1.",
    'ui__client/limits_unknown__short-title' => 'Tài nguyên sử dụng',
    'ui__client/limits_unknown__title' => 'Tài nguyên sử dụng',
    'ui__client/limits_unknown__description' => 'Xem và quản lý tài nguyên sử dụng của khách hàng.',
    'ui__client/limits_readonly__short-title' => 'Tài nguyên sử dụng',
    'ui__client/limits_readonly__title' => 'Tài nguyên sử dụng',
    'ui__client/limits_readonly__description' => 'Xem tài nguyên sử dụng của khách hàng %1.',
    'ui__client/limits_self__short-title' => 'Tài nguyên sử dụng',
    'ui__client/limits_self__title' => 'Tài nguyên sử dụng',
    'ui__client/limits_self__description' => "Xem và quản lý tài nguyên sử dụng của bạn.",
    'ui__client/limits_readonly-self__short-title' => 'Tài nguyên sử dụng',
    'ui__client/limits_readonly-self__title' => 'Tài nguyên sử dụng',
    'ui__client/limits_readonly-self__description' => "Xem tài nguyên sử dụng của bạn.",
    'ui__client/domain/traffic_unknown__short-title' => "Lưu lượng sử dụng bởi tên miền %1",
    'ui__client/domain/traffic_unknown__title' => "Xem lưu lượng sử dụng bởi tên miền",
    'ui__client/domain/traffic_unknown__description' => "Xem báo cáo lưu lượng sử dụng dành cho tên miền.",
    // Log manager - RESELLER/STATISTICS
    // dropdowns
    'ui__client/report__title' => 'Báo cáo tóm lược',
    'ui__client/report__short-title' => 'Báo cáo tóm lược',
    'ui__client/report__description' => 'Xem báo cáo tình hình sử dụng lưu lượng và tài nguyên của khách hàng này.',
    'ui__client/report_unknown__short-title' => 'Báo cáo tóm lược',
    'ui__client/report_unknown__title' => 'Báo cáo tóm lược',
    'ui__client/report_unknown__description' => 'Xem báo cáo việc sử dụng lưu lượng và tài nguyên dành cho khách hàng.',
    'ui__client/report_self__short-title' => 'Báo cáo tóm lược',
    'ui__client/report_self__title' => 'Báo cáo tóm lược',
    'ui__client/report_self__description' => 'Xem báo cáo việc sử dụng lưu lượng và tài nguyên.',

    // account
    // icons
    'ui__client/preferences__short-title' => 'Tùy chọn giao diện',
    'ui__client/preferences__title' => 'Tùy chọn giao diện',
    'ui__client/preferences__description' => 'Đặt tùy chọn giao diện Plesk cho khách hàng %1.',
    'ui__client/preferences_unknown__short-title' => 'Tùy chọn giao diện',
    'ui__client/preferences_unknown__title' => 'Tùy chọn giao diện',
    'ui__client/preferences_unknown__description' => "Thiết lập tùy chọn giao diện cho Plesk của khách hàng.",
    'ui__client/preferences_self__short-title' => 'Tùy chọn giao diện',
    'ui__client/preferences_self__title' => 'Tùy chọn giao diện',
    'ui__client/preferences_self__description' => 'Thiết lập tùy chọn giao diện cho Plesk của bạn.',
    'ui__client/logo__title' => 'Nhãn hiệu Plesk',
    'ui__client/logo__short-title' => 'Nhãn hiệu Plesk',
    'ui__client/logo__description' => "Đổi tên nhãn hiệu Plesk của khách hàng %1\\.",
    'ui__client/logo_self__title' => 'Nhãn hiệu Plesk',
    'ui__client/logo_self__short-title' => 'Nhãn hiệu Plesk',
    'ui__client/logo_self__description' => 'Đổi tên nhãn hiệu Plesk, thay đổi hình ảnh logo và thanh tiêu đề trình duyệt.',
    'ui__client/permissions__title' => 'Quyền truy cập',
    'ui__client/permissions__short-title' => 'Quyền truy cập',
    'ui__client/permissions__description' => "Xem hoặc thay đổi các hành động mà khách hàng %1 có thể thực hiện trong Plesk.",
    'ui__client/permissions_unknown__short-title' => 'Quyền truy cập',
    'ui__client/permissions_unknown__title' => 'Quyền truy cập',
    'ui__client/permissions_unknown__description' => "Xem hoặc thay đổi các hành động mà khách hàng có thể thực hiện trong Plesk.",
    'ui__client/permissions_self__title' => 'Quyền truy cập',
    'ui__client/permissions_self__short-title' => 'Quyền truy cập',
    'ui__client/permissions_self__description' => "Xem danh sách các hành động mà bạn có thể thực hiện trong Plesk.",
    'ui__client/permissions_readonly-self__title' => 'Quyền truy cập',
    'ui__client/permissions_readonly-self__short-title' => 'Quyền truy cập',
    'ui__client/permissions_readonly-self__description' => "Xem danh sách các hành động mà bạn có thể thực hiện trong Plesk.",

    // website
    // icons
    // Edit in SiteBuilder - RESELLER/WEBSITE
    // Web hosting settings - RESELLER/WEBSITE
    // Subdomains - RESELLER/WEBSITE
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Frontpage Webadmin - RESELLER/WEBSITE
    // Frontpage SSL/TLS Webadmin - RESELLER/WEBSITE
    // Web users - RESELLER/WEBSITE
    // Site preview - RESELLER/WEBSITE
    // dropdowns
    // DNS settings - RESELLER/WEBSITE
    // Change hosting type - RESELLER/WEBSITE
    // FrontPage management - RESELLER/WEBSITE    // PFW
    // Create subdomain - RESELLER/WEBSITE

    // applications & services
    // icons
    // Web applications - RESELLER/APPLICATIONS & SERVICES
    'ui__client/extras-domain__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__client/extras-domain__title' => 'Công cụ từ MyPlesk.com',
    'ui__client/extras-domain__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__client/extras-domain_unknown__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__client/extras-domain_unknown__title' => 'Công cụ từ MyPlesk.com',
    'ui__client/extras-domain_unknown__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__client/extras-domain_self__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__client/extras-domain_self__title' => 'Công cụ từ MyPlesk.com',
    'ui__client/extras-domain_self__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    // Databases - RESELLER/APPLICATIONS & SERVICES
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/register-domain__title' => 'Đăng ký tên miền',
    'ui__client/register-domain__short-title' => 'Đăng ký tên miền',
    'ui__client/register-domain__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__client/register-domain_unknown__title' => 'Đăng ký tên miền',
    'ui__client/register-domain_unknown__short-title' => 'Đăng ký tên miền',
    'ui__client/register-domain_unknown__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__client/register-domain_self__title' => 'Đăng ký tên miền',
    'ui__client/register-domain_self__short-title' => 'Đăng ký tên miền',
    'ui__client/register-domain_self__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    // dropdowns
    // Install web application - RESELLER/APPLICATIONS & SERVICES
    // Create database - RESELLER/APPLICATIONS & SERVICES
    // Create database user - RESELLER/APPLICATIONS & SERVICES
    // Install Java application - RESELLER/APPLICATIONS & SERVICES
    'ui__client/manage-domain__title' => 'Quản lý tên miền',
    'ui__client/manage-domain__short-title' => 'Quản lý tên miền',
    'ui__client/manage-domain__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',
    'ui__client/manage-domain_unknown__title' => 'Quản lý tên miền',
    'ui__client/manage-domain_unknown__short-title' => 'Quản lý tên miền',
    'ui__client/manage-domain_unknown__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',
    'ui__client/manage-domain_self__title' => 'Quản lý tên miền',
    'ui__client/manage-domain_self__short-title' => 'Quản lý tên miền',
    'ui__client/manage-domain_self__description' => 'Quản lý tên miền đã đăng ký thông qua MyPlesk.com.',

    // additional tools
    // icons
    'ui__client/ipaddress_unknown__title' => 'Các địa chỉ IP',
    'ui__client/ipaddress_unknown__short-title' => "Các địa chỉ IP",
    'ui__client/ipaddress_unknown__description' => "Quản lý địa chỉ IP.",
    'ui__client/domain/domain-alias_readonly-unknown__short-title' => 'Các bí danh tên miền',
    'ui__client/domain/domain-alias_readonly-unknown__title' => 'Các bí danh tên miền',
    'ui__client/domain/domain-alias_readonly-unknown__description' => 'Xem danh sách các tên miền thay thế cho tên miền của bạn.',
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    'ui__client/sessions__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__client/sessions__title' => 'Phiên kết nối đang hoạt động',
    'ui__client/sessions__description' => 'Xem các phiên Plesk đang hoạt động.',
    'ui__client/sessions_unknown__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__client/sessions_unknown__title' => 'Phiên kết nối đang hoạt động',
    'ui__client/sessions_unknown__description' => 'Xem các phiên Plesk đang hoạt động.',
    'ui__client/sessions_self__short-title' => 'Phiên kết nối đang hoạt động',
    'ui__client/sessions_self__title' => 'Phiên kết nối đang hoạt động',
    'ui__client/sessions_self__description' => 'Xem các phiên Plesk đang hoạt động.',
    // Shared SSL/TLS - RESELLER/ADDITIONAL TOOLS    // PFW
    // ASP.NET settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // PHP settings - RESELLER/ADDITIONAL TOOLS    // PFW
    // dropdowns
    //Schedule new task - RESELLER/ADDITIONAL TOOLS

    ///
    /// END OF CLIENT
    ///

    ///
    /// DOMAIN / DOMAIN ADMINISTRATOR
    ///

    // files
    // icons
    'ui__client/domain/hosting/web-directories__title' => 'Thư mục ảo', // PFW
    'ui__client/domain/hosting/web-directories__short-title' => 'Thư mục ảo', // PFW
    'ui__client/domain/hosting/web-directories__description' => 'Làm việc với tập tin và thư mục vật lý và ảo hóa thuộc trang web %1.', // PFW
    'ui__client/domain/hosting/web-directories_self__title' => 'Thư mục ảo', // PFW
    'ui__client/domain/hosting/web-directories_self__short-title' => 'Thư mục ảo', // PFW
    'ui__client/domain/hosting/web-directories_self__description' => 'Làm việc với tập tin và thư mục vật lý và ảo hóa thuộc trang web của bạn.', // PFW

    // statistics
    // icons
    'ui__client/domain/traffic__short-title' => 'Lưu lượng sử dụng của %1',
    'ui__client/domain/traffic__title' => 'Thống kê truyền tải dữ liệu của <b>%1</b>',
    'ui__client/domain/traffic__description' => 'Xem thống kê truyền tải dữ liệu của tên miền %1.',
    'ui__client/domain/traffic_self__short-title' => 'Lưu lượng sử dụng',
    'ui__client/domain/traffic_self__title' => 'Xem lưu lượng sử dụng dành cho tên miền của bạn',
    'ui__client/domain/traffic_self__description' => 'Xem báo cáo lưu lượng sử dụng dành cho tên miền của bạn.',
    'ui__client/domain/hosting/logs__short-title' => 'Quản lý nhật ký',
    'ui__client/domain/hosting/logs__title' => 'Quản lý nhật ký',
    'ui__client/domain/hosting/logs__description' => 'Xem nhật ký và cấu hình luân chuyển nhật ký.',
    'ui__client/domain/hosting/logs_self__short-title' => 'Quản lý nhật ký',
    'ui__client/domain/hosting/logs_self__title' => 'Quản lý nhật ký',
    'ui__client/domain/hosting/logs_self__description' => 'Xem nhật ký và cấu hình luân chuyển nhật ký.',

    // domain administration
    // dropdowns
    'ui__client/domain/rename__title' => 'Đổi tên miền',
    'ui__client/domain/rename__short-title' => 'Đổi tên miền',
    'ui__client/domain/rename__description' => 'Đổi tên miền %1.',
    'ui__client/domain/rename_unknown__short-title' => 'Đổi tên miền',
    'ui__client/domain/rename_unknown__title' => 'Đổi tên miền',
    'ui__client/domain/rename_unknown__description' => 'Đổi một tên miền',
    'ui__client/domain/chowner_select__title' => 'Gán chủ sở hữu mới cho tên miền',
    'ui__client/domain/chowner_select__short-title' => 'Gán chủ sở hữu mới cho thuê bao',
    'ui__client/domain/chowner_select__description' => 'Gán chủ sở hữu mới cho thuê bao',
    'ui__client/domain/chowner_unknown-select__short-title' => 'Gán chủ sở hữu mới cho thuê bao',
    'ui__client/domain/chowner_unknown-select__title' => 'Gán chủ sở hữu mới cho thuê bao',
    'ui__client/domain/chowner_unknown-select__description' => 'Gán chủ sở hữu mới cho một thuê bao.',
    'ui__client/domain/toggle__title' => 'Tạm dừng hoặc kích hoạt tên miền', // for HP customization
    'ui__client/domain/toggle__short-title' => 'Tạm dừng hoặc kích hoạt tên miền', // for HP customization
    'ui__client/domain/toggle__description' => 'Tạm dừng hoặc kích hoạt tên miền %1.', // for HP customization
    'ui__client/domain/toggle_unknown__title' => 'Tạm dừng hoặc kích hoạt tên miền', // for HP customization
    'ui__client/domain/toggle_unknown__short-title' => 'Tạm dừng hoặc kích hoạt tên miền', // for HP customization
    'ui__client/domain/toggle_unknown__description' => 'Tạm dừng hoặc kích hoạt một tên miền.', // for HP customization
    'ui__client/domain/toggle_enable__title' => 'Kích hoạt tên miền',
    'ui__client/domain/toggle_enable__short-title' => 'Kích hoạt tên miền',
    'ui__client/domain/toggle_enable__description' => 'Kích hoạt tên miền %1.',
    'ui__client/domain/toggle_disable__title' => 'Tạm dừng tên miền',
    'ui__client/domain/toggle_disable__short-title' => 'Tạm dừng tên miền',
    'ui__client/domain/toggle_disable__description' => 'Tạm dừng tên miền %1.',

    // website
    // icons
    // dropdowns
    'ui__client/domain/dns__title' => 'Thiết lập DNS',
    'ui__client/domain/dns__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns__description' => 'Quản lý thiết lập vùng DNS cho tên miền %1.',
    'ui__client/domain/dns_self__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_self__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_self__description' => 'Quản lý thiết lập vùng DNS cho tên miền của bạn.',
    'ui__client/domain/dns_disabled__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_disabled__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_disabled__description' => 'Quản lý thiết lập vùng DNS cho tên miền %1.',
    'ui__client/domain/dns_self-disabled__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_self-disabled__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_self-disabled__description' => 'Quản lý thiết lập vùng DNS cho tên miền của bạn.',
    'ui__client/domain/dns_readonly__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly__description' => 'Xem thiết lập vùng DNS cho tên miền %1.',
    'ui__client/domain/dns_readonly-self__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-self__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-self__description' => 'Xem thiết lập vùng DNS cho tên miền của bạn.',
    'ui__client/domain/dns_readonly-self-disabled__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-self-disabled__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-self-disabled__description' => 'Xem thiết lập vùng DNS cho tên miền của bạn.',
    'ui__client/domain/dns_readonly-self-slave__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-self-slave__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_readonly-self-slave__description' => 'Xem thiết lập vùng DNS cho tên miền của bạn.',
    'ui__client/domain/dns_slave__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_slave__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_slave__description' => 'Quản lý thiết lập vùng DNS cho tên miền %1.',
    'ui__client/domain/dns_self-slave__title' => 'Thiết lập DNS',
    'ui__client/domain/dns_self-slave__short-title' => 'Thiết lập DNS',
    'ui__client/domain/dns_self-slave__description' => 'Quản lý thiết lập vùng DNS cho tên miền của bạn.',
    // FrontPage management - RESELLER/WEBSITE    // PFW

    // applications & services
    // icons
    'ui__client/domain/extras__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__client/domain/extras__title' => 'Công cụ từ MyPlesk.com',
    'ui__client/domain/extras__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__client/domain/extras_unknown__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__client/domain/extras_unknown__title' => 'Công cụ từ MyPlesk.com',
    'ui__client/domain/extras_unknown__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    'ui__client/domain/extras_self__short-title' => 'Công cụ từ MyPlesk.com',
    'ui__client/domain/extras_self__title' => 'Công cụ từ MyPlesk.com',
    'ui__client/domain/extras_self__description' => 'Lấy công cụ và dịch vụ bổ sung từ MyPlesk.com.',
    // Java applications - RESELLER/APPLICATIONS & SERVICES    // PFU
    'ui__client/domain/register__short-title' => 'Đăng ký tên miền',
    'ui__client/domain/register__title' => 'Đăng ký tên miền',
    'ui__client/domain/register__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__client/domain/register_unknown__short-title' => 'Đăng ký tên miền',
    'ui__client/domain/register_unknown__title' => 'Đăng ký tên miền',
    'ui__client/domain/register_unknown__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    'ui__client/domain/register_self__short-title' => 'Đăng ký tên miền',
    'ui__client/domain/register_self__title' => 'Đăng ký tên miền',
    'ui__client/domain/register_self__description' => 'Đăng ký một tên miền thông qua MyPlesk.com.',
    // dropdowns
    // Create database user - RESELLER/APPLICATIONS & SERVICES

    // additional tools
    // icons
    // Domain aliases - RESELLER/ADDITIONAL TOOLS
    // Scheduled tasks - RESELLER/ADDITIONAL TOOLS    // PFU
    // SSL/TLS certificates - RESELLER/ADDITIONAL TOOLS
    // dropdowns


    ///
    /// END OF DOMAIN / DOMAIN ADMINISTRATOR
    ///

    ////
    //// KEYS FOR BUSINESS OBJECT LISTS/PAGES (RESELLERS, CLIENTS, DOMAINS)
    ////

    ///
    /// DOMAINS
    ///

    // Domains list page title - ui__client/domain_unknown__short-title (HOME)

    // tools
    'ui__client/domain#tools__title' => "Công cụ",
    // Below: TBD
    'ui__client/domain-summary-report_unknown__short-title' => 'Xem thống kê',
    'ui__client/domain-summary-report_unknown__title' => 'Xem thống kê',
    'ui__client/domain-summary-report_unknown__description' => 'Xem thông tin về tài nguyên sử dụng bởi tên miền.',
    'ui__client/domain-summary-report__short-title' => "Xem thống kê",
    'ui__client/domain-summary-report__title' => "Xem thống kê",
    'ui__client/domain-summary-report__description' => "Xem thông tin về tài nguyên sử dụng bởi tên miền.",
    'ui__client/domain-summary-report_self__short-title' => "Xem thống kê",
    'ui__client/domain-summary-report_self__title' => "Xem thống kê",
    'ui__client/domain-summary-report_self__description' => "Xem thông tin về tài nguyên sử dụng bởi tên miền của bạn.",
    // Traffic usage - ui__client/domain/traffic_unknown__short-title

    'ui__client/domain#list__title' => "Các tên miền", // DOMAINS

    // list object operation errors
    'ui__client/domain/delete__empty_selection' => 'Bạn phải chọn tên miền muốn gỡ bỏ',
    'ui__client/domain/chowner__empty_selection' => 'Bạn phải chọn tên miền mà bạn muốn gán chủ sở hữu mới',

    // list objects filtering
    'domains_list__name__filter_title' => 'Tên',
    'domains_list__state__filter_title' => 'Sử dụng Tài nguyên',
    'domains_list__filter_state_any' => 'Bất kỳ',
    'domains_list__filter_state_overuse' => 'Sử dụng vượt định mức',
    'domains_list__filter_state_normal' => 'Trong giới hạn',
    'domains_list__status__filter_title' => 'Trạng thái',
    'domains_list__filter_status_any' => 'Bất kỳ',
    'domains_list__filter_status_blocked' => 'Đã treo',
    'domains_list__filter_status_active' => 'Hiện hoạt',
    'domains_list__ownership__filter_title' => 'Quyền sở hữu',
    'domains_list__filter_ownership_all' => 'Tất cả tên miền',
    'domains_list__filter_ownership_personal' => 'Chỉ tên miền của tôi',
    'domains_list__filter_owner_pname__filter_title' => 'Tên chủ sở hữu',
    'domains_list__subrows__filter_title' => 'Hiển thị',
    'domains_list__subrows_off' => 'Chỉ tên miền',
    'domains_list__subrows_subdomain_domainaliases' => 'Với tên miền thứ cấp và bí danh tên miền',
    'domains_list__subrows_subdomain' => 'Với tên miền thứ cấp',
    'domains_list__subrows_domainaliases' => 'Với bí danh tên miền',

    // objects list
    'domains_list__owner__title' => 'Chủ sở hữu',

    ///
    /// END OF DOMAINS
    ///

    ////
    //// KEYS FOR APPLICATION VAULT AND WEB APPLICATION MANAGEMENT
    ////

    ///
    /// APPLICATION VAULT / APS CATALOG
    ///

    // Application Vault / APS Catalog promotional block
    'site_apps__promo_browse_for_applications' => "Duyệt ứng dụng",
    'site_apps__promo_main_text' => "Danh mục Application Packaging Standard (APS) chứa danh sách các ứng dụng có thể được cung cấp cho tên miền hoặc không gian web. Nếu bạn muốn sử dụng ứng dụng hiện không có trong danh mục bạn có thể làm theo hướng dẫn tại trang www.apsstandard.com",
    'site_apps__promo_download_now' => "Tải về ứng dụng:",
    'site_apps__promo_close' => "Đóng khối này",
    'site_apps__promo_preset__mostused' => '%1 phổ biến nhất',
    'site_apps__promo_preset__lessused' => 'Kế tiếp %1 phổ biến nhất',
    'site_apps__promo_preset__all' => "Tất cả",
    'site_apps__promo_disclaimer_note' => 'Xin lưu ý rằng các ứng dụng được cài đặt từ Catalog APS được cung cấp bởi bên thứ ba và không được hỗ trợ bởi Plesk.',
    'site_apps__promo_preset__page_title' => '%1 ứng dụng APS',

    // Progress bar
    'site_apps__progress_initialization_message' => 'Đang thêm ứng dụng...',

    // Errors
    'site_apps__no_applications_for_update' => 'Bạn chưa có ứng dụng được cài đặt trong Application Vault.',
    'site_apps__incorrect_download_preset_configuration' => 'Có lỗi trong cấu hình thiết lập sẵn tải về APS',
    'site_apps__aps_catalog_url_is_invalid' => 'Địa chỉ URL được chỉ định không có giá trị.',
    'site_apps__no_updates_at_the_moment' => 'Hiện tại không có bản cập nhật ứng dụng nào.',
    'site_apps__incorrect_content_returned_by_catalog' => 'Thông tin không chính xác được nhận từ danh mục ứng dụng APS. Vui lòng thử lại sau.',
    'site_apps__entered_aps_catalog_url_is_not_valid' => 'Cài đặt danh mục APS đã được lưu, tuy nhiên Plesk không thể thiết lập kết nối đến danh mục APS chỉ định trong cài đặt danh mục APS (%1). Đảm bảo rằng địa chỉ danh mục APS chính xác và danh mục APS tại địa chỉ này đang hoạt động.',
    'site_apps__cannot_retrieve_updates' => 'Không thể tải về các bản cập nhật ứng dụng vào thời điểm hiện tại: không thể thiết lập kết nối đến danh mục APS (%1). Đảm bảo rằng địa chỉ danh mục APS là chính xác và danh mục APS tại địa chỉ này đang hoạt động.',
    'site_apps__no_site_applications_in_client_pool_to_install' => 'Không tồn tại ứng dụng web nào để cài đặt.',
    'site_apps__site_applications_already_installed_in_root' => 'Các ứng dụng web khác đã cài đặt trong thư mục gốc của những máy chủ ảo này',
    'site_apps__dot_net_packages_not_supported_on_unix_platform' => "Ứng dụng web .NET không được hỗ trợ trên nền tảng Unix/Linux",
    'site_apps__server_wide_packages_not_supported' => 'Ứng dụng web trên toàn máy chủ không được hỗ trợ',
    'site_apps__applications_added_to_queue_for_adding_to_application_vault' => "%1 ứng dụng web được lập lịch để thêm vào Application Vault.",
    'site_apps__applications_all_in_vault' => "Ứng dụng web được chọn đã tồn tại trong Application Vault.",
    'site_apps__applications_already_in_download_queue' => "%1 ứng dụng web được chọn hiện đang được thêm vào Application Vault.",
    'site_apps__applications_already_in_valut' => "%1 ứng dụng web được chọn hiện có trong Application Vault.",

    // UI errors

    ///
    /// END OF APPLICATION VAULT / APS CATALOG
    ///

    ///
    /// APS CATEGORIES
    ///

    // General
    'site_apps__not_categorized' => 'Khác (không được phân mục)',

    // Errors
    'site_apps__no_applications_in_category' => 'Không tồn tại ứng dụng trong hạng mục này. Vui lòng chọn hạng mục khác.',
    'site_apps__no_category_selected__please_specify' => 'Chọn một hạng mục trong trình đơn bên trái. Tất cả các ứng dụng hiện có sẽ được liệt kê trong cửa sổ này.',

    // Category: Back office
    // Category: Collaboration
    // Category: Front Office
    // Category: Infrastructure
    // Category: Personal
    // Category: Web

    ///
    /// END OF APS CATEGORIES
    ///

    ///
    /// APPLICATION VAULT
    ///

    //removal


    ///
    /// END OF APPLICATION VAULT
    ///

    ////
    //// KEYS FOR SETTINGS PAGE
    ////

    ///
    /// SERVER ADMINISTRATOR SETTINGS
    ///

    'administrator_account' => 'Tài khoản quản trị',
    // Personal data - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Change password - HOME/SERVER ADMINISTRATOR/ACCOUNT
    // Interface preferences - HOME/SERVER ADMINISTRATOR/ACCOUNT

    'general' => 'Tổng quan',
    // Server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_change_hostname' => 'Thay đổi tên máy chủ host',
    // System time - HOME/SERVER ADMINISTRATOR/SERVER
    // IP addresses - HOME/SERVER ADMINISTRATOR/SERVER
    // Scheduled tasks - HOME/SERVER ADMINISTRATOR/SERVER
    // FTP settings - HOME/SERVER ADMINISTRATOR/SERVER    // PFW

    'security' => 'An ninh',
    'bt_setup_firewall' => 'Cài đặt tường lửa',
    'bt_manage_firewall_rules' => 'Quản lý các quy luật tường lửa',
    'cu_firewall__rule' => 'Tạo một quy tắc tường lửa',
    'cu_firewall__protocol' => 'Đặt giao thức cho quy tắc (\'tcp\' hoặc \'udp\')',
    'cu_firewall__name' => "Đặt tên quy tắc",
    'cu_firewall__disabled' => 'Nếu \'đúng\', quy tắc này đã bị hủy kích hoạt sau khi tạo',
    // Session idle time - HOME/SERVER ADMINISTRATOR/SECURITY
    // SSL/TLS certificates - HOME/SERVER ADMINISTRATOR/SECURITY
    // Shared SSL/TLS - HOME/SERVER ADMINISTRATOR/SECURITY    // PFW

    'dns' => 'DNS',
    'bt_select_dns_server' => 'Chọn máy chủ DNS', // PFW
    'bt_soa_records_template' => 'Mẫu bản ghi SOA',
    'bt_restrict_creation_of_subzones' => 'Cấm tạo vùng thứ cấp',

    'databases' => 'Cơ sở dữ liệu',
    // Database hosting preferences - HOME/SERVER ADMINISTRATOR/SERVER

    'applications' => 'Ứng dụng',
    // ASP.NET settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // IIS application pool - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES    // PFW
    // SiteBuilder settings - HOME/SERVER ADMINISTRATOR/APPLICATIONS & SERVICES

    'mail' => 'Thư',
    'bt_select_mailserver' => 'Chọn máy chủ thư', // PFW
    // Mail server settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_antivirus' => 'Chọn chức năng chống virus', // PFW
    'bt_virus_protection_settings' => 'Các thiết lập bảo vệ khỏi virus',
    'bt_select_spamfilter' => 'Chọn chức năng lọc thư rác', // PFW
    // Spam filter settings - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_select_webmail' => 'Chọn webmail',
    // Set up mailing lists server - HOME/SERVER ADMINISTRATOR/SERVER    // PFU

    'logs_and_statistics' => 'Nhật ký & thống kê',
    'bt_server_statistics_settings' => 'Thiết lập của thống kê máy chủ',
    'bt_select_web_statistics' => 'Phần mềm thống kê web sẵn có', // PFW
    // Action log - HOME/SERVER ADMINISTRATOR/LOGS & STATISTICS

    'control_panel_interface' => 'Giao diện Plesk',

    'components_and_modules' => 'Thành phần & Cấu kiện',
    // Server components - HOME/SERVER ADMINISTRATOR/SERVER
    'bt_setup_watchdog' => 'Cài đặt Watchdog', // PFU
    'bt_setup_vpn' => 'Cài đặt VPN', // PFU
    'bt_setup_samba' => 'Cài đặt Samba',    // PFU

    ///
    /// END OF SERVER ADMINISTRATOR SETTINGS
    ///

    ///
    /// DOMAIN SETTINGS
    ///

    'ui__client/domain/settings_self__title' => 'Cài đặt',
    'ui__client/domain/settings_self__short-title' => 'Cài đặt',
    'ui__client/domain/settings_self__description' => 'Xem và thay đổi các thiết lập tên miền.',

    'domain_administrator_account' => 'Tài khoản quản trị tên miền',
    // Interface preferences - HOME/DOMAIN ADMINISTRATOR/DOMAIN
    'bt_account_settings' => 'Thiết lập tài khoản',

    'domain' => 'Tên miền',
    'bt_dns_soa_records' => 'Bản ghi DNS SOA',
    // Mail settings - HOME/DOMAIN ADMINISTRATOR/MAIL
    'bt_task_scheduler_settings' => 'Thiết lập tiến trình lập lịch tác vụ',

    'website' => 'Trang web',
    // Web hosting settings - HOME/DOMAIN ADMINISTRATOR/WEBSITE
    // Bandwidth limiting - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS
    'bt_web_users_scripting' => 'Tập lệnh cho người dùng web',
    // Anonymous FTP - HOME/DOMAIN ADMINISTRATOR/FILES

    // Applications - SETTINGS/SERVER/APPLICATIONS    // PFW
    // ASP.NET settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // PHP settings - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW
    // IIS application pool - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Security - SETTINGS/SERVER/SECURITY
    'bt_select_ssl_certificate' => 'Chọn chứng nhận SSL/TLS',
    // Shared SSL/TLS - HOME/DOMAIN ADMINISTRATOR/ADDITIONAL TOOLS    // PFW

    // Logs & statistics - SETTINGS/SERVER/LOGS & STATISTICS
    'bt_web_statistics' => 'Thống kê Web',
    'bt_log_rotation_settings' => 'Thiết lập luân chuyển nhật ký',

    ///
    /// END OF DOMAIN SETTINGS
    ///

    ////
    //// KEYS FOR LIMITS AND PERMISSIONS
    ////

    ///
    /// LIMITS
    ///

    '__limits' => "Các giới hạn", // template

    // overuse & oversell
    'limits__overuse_oversell_policy_legend' => "Chính sách sử dụng tài nguyên và bán vượt giới hạn",
    'limits__overuse_policy_legend' => "Sử dụng vượt định mức",
    'limits__oversell_policy_legend' => "Bán vượt giới hạn",
    'limits__reseller_overuse_description' => "Chính sách sử dụng quá mức sẽ hỗ trợ Plesk cần làm gì khi tài nguyên bị sử dụng quá mức.",
    'limits__overuse_text' => "Chính sách sử dụng vượt định mức",

    // limit names
    'limit_group__disk_space_and_traffic' => 'Dung lượng và lưu lượng',
    'limit__disk_space' => 'Không gian đĩa',
    'limit__max_traffic' => 'Lưu lượng',
    'limit_group__client' => 'Khách hàng',
    'limit__max_cl' => 'Khách hàng',
    'limit_group__domain' => 'Các tên miền',
    'limit__max_dom' => 'Các tên miền',
    'limit__max_dom_powerUser' => 'Thuê bao',
    'limit__max_subdom' => 'Tên miền phụ',
    'limit__max_dom_aliases' => 'Các bí danh tên miền',
    'limit__max_wu' => 'Người dùng Web',
    'limit__max_subftp_users' => 'Các tài khoản FTP bổ sung', // PFW
    'limit_group__mail' => 'Thư',
    'limit__max_box' => 'Hòm thư',
    'limit__mbox_quota' => 'Dung lượng hòm thư',
    'limit__total_mboxes_quota' => 'Tổng số hạn ngạch hòm thư', // PFW
    'limit__max_maillists' => 'Các danh sách gửi thư',
    'limit_group__database' => 'Cơ sở dữ liệu',
    'limit__max_mssql_db' => 'Cơ sở dữ liệu Microsoft SQL Server', // PFW
    'limit__mssql_dbase_space' => 'Tổng hạn ngạch cơ sở dữ liệu MS SQL', // PFW
    'limit__max_odbc' => 'Các kết nối ODBC', // PFW
    // limit__max_db - CONFLICTED
    'limit__mysql_dbase_space' => 'Hạn ngạch cơ sở dữ liệu MySQL', // PFW
    'limit__pgsql_dbase_space' => 'Tổng hạn ngạch cơ sở dữ liệu PostgreSQL', // PFW
    'limit_group__application' => 'Ứng dụng',
    'limit__max_iis_app_pools' => 'Kho ứng dụng IIS', // PFW
    'limit_group__security' => 'An ninh',
    'limit_group__validity' => 'Ngày hết hạn',
    'limit__expiration' => 'Ngày hết hạn',
    'limit__validity' => 'Thời gian hợp lệ',
    'limit__max_site_builder' => 'Các trang được xuất bản bằng Presence Builder',
    'limit__max_site' => 'Các tên miền',
    'limit__mssql_dbase_filesize' => 'Kích cỡ tập tin cơ sở dữ liệu MS SQL',
    'limit__mssql_dbase_log_filesize' => 'Kích cỡ tập tin nhật ký cơ sở dữ liệu MS SQL',
    'limit__mssql_dbase_filesize_hint' => 'Kích cỡ tối đa của tệp cơ sở dữ liệu Microsoft SQL.',
    'limit__mssql_dbase_log_filesize_hint' => 'Kích cỡ tối đa của tệp nhật ký cơ sở dữ liệu Microsoft SQL.',
    'limit__units_mssql_dbase_filesize' => "MB",
    'limit__units_mssql_dbase_log_filesize' => "MB",

    'dom_pref__invalid_max_site_limit' => 'Giới hạn tên miền không hợp lệ. Giá trị tối thiểu là 1.',

    'property__has_wrong_value' => 'Đặc tính %1 có giá trị sai.',
    'property__name_outgoing_messages_domain_limit' => 'Thiết lập giới hạn cho tin nhắn gửi đi từ một miền (mỗi giờ). Để thiết lập giá trị không giới hạn, chỉ định "-1". Chỉ định "mặc định" để thiết lập giá trị trong cài đặt trên toàn máy chủ.',
    'property__name_outgoing_messages_mbox_limit' => 'Thiết lập giới hạn cho tin nhắn gửi đi từ một hòm thư (mỗi giờ). Để thiết lập giá trị không giới hạn, chỉ định "-1". Chỉ định "mặc định" để thiết lập giá trị trong cài đặt trên toàn máy chủ.',
    'property__name_outgoing_messages_subscription_limit' => 'Thiết lập giới hạn cho tin nhắn gửi đi từ một thuê bao (mỗi giờ). Để thiết lập giá trị không giới hạn, chỉ định "-1". Chỉ định "mặc định" để thiết lập giá trị trong cài đặt trên toàn máy chủ.',

    // for CLI report & email notifications
    '__resource_notify' => 'Thông báo',
    '__general' => 'Tổng quan',
    '__template_shared' => 'Mẫu chia sẻ',
    'limit__overuse' => 'Chính sách sử dụng vượt định mức',
    'limit__max_traffic_soft' => 'Thông báo khi lưu lượng sử dụng sắp đến hạn mức',
    'limit__disk_space_soft' => 'Thông báo khi tình trạng sử dụng không gian đĩa đạt ngưỡng',
    '__overuse' => 'Chính sách sử dụng vượt định mức',
    'performance__title' => 'Hiệu suất',
    'performance__bandwidth' => 'Băng thông sử dụng tối đa (KB/s)',
    'performance__max_connections' => 'Giới hạn đối với các kết nối tới',

    'gch__hosting_php_isapi' => 'Chạy PHP như là phần mở rộng ISAPI',
    'gch__hosting_ssi_html' => 'Sử dụng SSI cho tập tin *.htm, *.html',
    'gch__hosting_php_handler_type' => 'chạy PHP là',
    'gch__hosting_php_handler_id' => 'chạy PHP là',
    'gch__hosting_php_served_by_nginx' => 'PHP được nginx hỗ trợ',
    'gch__hosting_unpaid_website_status' => 'Trạng thái của các website trong các thuê bao bị ngưng',
    'gch__mn_no_autoresponder' => 'Có cài đặt không tự động trả lời cho tài khoản thư.',
    'gch__no_clients_selected' => "Không có tài khoản khách hàng nào được chọn",
    'gch__no_domains_selected' => "Không có tên miền nào được chọn",

    // limit units
    'limit__units_disk_space' => "MB",
    'limit__units_max_traffic' => "MB/tháng",
    'limit__units_mbox_quota' => "KB",
    'limit__units_mysql_dbase_space' => "MB", // PFW
    'limit__units_mssql_dbase_space' => "MB", // PFW
    'limit__units_pgsql_dbase_space' => "MB", // PFW
    'limit__units_total_mboxes_quota' => "MB", // PFW

    // manipulations and statuses of limits
    '__resource_name' => 'Tên tài nguyên',
    '__resource_usage' => 'Đã sử dụng',
    '__resource_limit' => 'Giới hạn',

    '__used' => 'Đã sử dụng',
    '__limit' => 'Giới hạn',

    '__never_expires' => 'Không bao giờ hết hạn',
    '__resource_free' => '%1 còn trống của %2',
    '__resource_unlimited' => '%1 đã sử dụng của Không giới hạn',

    '__unlimited' => 'Không giới hạn',
    '__increment' => "Tăng (+)",
    '__decrement' => "Giảm (-)",
    '__pt' => 'đơn vị',
    '__procent' => '%',
    '__overused' => 'Đã sử dụng vượt hạn',
    '__left' => 'còn lại',
    '__available' => 'còn trống',
    '__not_available' => 'Không bao gồm',

    ///
    /// END OF LIMITS
    ///

    ///
    /// PERMISSIONS
    ///

    //permissions hints

    ///
    /// END OF PERMISSIONS
    ///

    ////
    //// KEYS FOR STATISTICS AND REPORTS
    ////

    ///
    /// REPORT
    ///

    // administrator

    'ui__admin/report/layout/auto_unknown__short-title' => 'Lịch trình phân phối',
    'ui__admin/report/layout/auto_unknown__title' => 'Lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto_unknown__description' => 'Chọn lịch trình phân phối báo cáo cho giao diện báo cáo.',
    'ui__admin/report/layout/auto/properties_new__short-title' => 'Thêm lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto/properties_new__title' => 'Thêm lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto/properties_new__description' => 'Thêm kế hoạch gửi báo cáo cho báo cáo %1.',
    'ui__admin/report/layout/auto/properties__short-title' => 'Lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto/properties__title' => 'Lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto/properties__description' => 'Xem và chỉnh sửa thuộc tính của lịch trình phân phối báo cáo.',
    'ui__admin/report/layout/auto/delete_multi__short-title' => 'Gỡ bỏ lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto/delete_multi__title' => 'Gỡ bỏ lịch trình phân phối báo cáo',
    'ui__admin/report/layout/auto/delete_multi__description' => 'Gỡ bỏ lịch trình phân phối báo cáo được chọn.',

    'ui__admin/report/layout_unknown__short-title' => 'Giao diện báo cáo',

    // reselle
    'ui__reseller/traffic__short-title' => '%1',
    'ui__reseller/traffic__title' => 'Xem Lưu lượng sử dụng cho <b>%1</b>',
    'ui__reseller/traffic__description' => 'Xem báo cáo lưu lượng sử dụng cho tài khoản đại lý %1.',
    'ui__reseller/traffic_self__short-title' => 'Của tôi',
    'ui__reseller/traffic_self__title' => 'Xem lưu lượng sử dụng bởi khách hàng',
    'ui__reseller/traffic_self__description' => 'Xem báo cáo lưu lượng sử dụng dành cho tài khoản khách hàng của bạn.',

       ///
    /// END OF REPORT
    ///

    ///
    /// SUMMARY / FULL REPORT
    ///

    // common full report
    'report__full_p' => 'P',
    'report__full_s' => 'S',
    'report__full_h' => 'H',
    'report__full_reseller_name' => 'Tên đại lý', // reseller report
    'report__full_client_name' => 'Tên khách hàng', // customer report
    'report__full_domain_name' => 'Tên miền', // domain report
    'report__full_owner' => 'Chủ sở hữu', // customer & domain reports
    'report__full_creation_date' => 'Ngày tạo',
    'report__full_size' => 'Kích thước',
    'report__full_traffic' => 'Lưu lượng',
    'report__full_active_clients' => 'Khách hàng đang hoạt động', // reseller report
    'report__full_clients' => 'Khách hàng', // reseller report
    'report__full_active_domains' => 'Tên miền đang hoạt động', // reseller & customer reports
    'report__full_domains' => 'Các tên miền', // reseller & customer reports
    'report__full_subdomains' => 'Tên miền thứ cấp',
    'report__full_mboxes' => 'Hộp thư',
    'report__full_disk_space' => 'Không gian đĩa',
    'report__full_mail_groups' => 'MForw',
    'report__full_mail_autoresp' => 'Trả lời',
    'report__full_mail_antispam' => 'Chống thư rác',
    'report__full_mail_antivirus' => 'AVir',
    'report__full_mail_lists' => 'Danh sách thư',
    'report__full_web_users' => 'Người dùng Web',
    'report__full_mysql_databases' => 'Cơ sở dữ liệu MySQL',
    'report__full_mssql_databases' => 'Cơ sở dữ liệu MSSQL',
    'report__full_pgsql_databases' => 'Cơ sở dữ liệu PostgreSQL',

    // common summary report
    'report__section_general' => 'Tổng quan',
    'report__version' => 'Phiên bản sản phẩm',
    'report__build' => 'Bản tạo sản phẩm',
    'report__status' => 'Trạng thái',
    'report__company_name' => 'Tên công ty',
    'report__personal_name' => 'Tên cá nhân',
    'report__login' => 'Tên người dùng',
    'report__phone' => 'Điện thoại',
    'report__fax' => 'Fax',
    'report__email' => 'Email',
    'report__address' => 'Địa chỉ',
    'report__city' => 'Thành phố',
    'report__state' => 'Tỉnh/thành',
    'report__zip_code' => 'Mã bưu điện/Mã ZIP',
    'report__country' => 'Quốc gia',
    'report__creation_date' => 'Ngày tạo',
    'report__expiration_date' => 'Ngày hết hạn',
    'report__dumps_total_size' => 'Tổng dung lượng các tập tin sao lưu',
    'report__section_resellers' => 'Các đại lý',
    'report__active_resellers' => 'Đại lý có thuê bao đang hoạt động',
    'report__resellers' => 'Các đại lý',
    'report__section_full_resellers' => 'Các đại lý',
    'report__section_clients' => 'Khách hàng',
    'report__active_clients' => 'Khách hàng có thuê bao đang hoạt động',
    'report__clients' => 'Khách hàng',
    'report__section_full_clients' => 'Khách hàng',
    'report__section_personal_clients' => 'Khách hàng cá nhân',
    'report__active_personal_clients' => 'Khách hàng có thuê bao đang hoạt động của bạn',
    'report__personal_clients' => 'Khách hàng cá nhân',
    'report__section_full_personal_clients' => 'Khách hàng cá nhân',
    'report__section_domains' => 'Các tên miền',
    'report__disk_usage' => 'Sử dụng đĩa',
    'report__traffic' => 'Lưu lượng',
    'report__active_domains' => 'Tên miền đang hoạt động',
    'report__domains' => 'Các tên miền',
    'report__subdomains' => 'Tên miền phụ',
    'report__mboxes' => 'Hòm thư',
    'report__mail_groups' => 'Chuyển tiếp thư',
    'report__mail_autoresp' => 'Trả lời tự động',
    'report__mail_lists' => 'Các danh sách gửi thư',
    'report__web_users' => 'Người dùng Web',
    'report__mysql_databases' => 'CSDL MySQL',
    'report__mssql_databases' => 'Cơ sở dữ liệu MSSQL',
    'report__pgsql_databases' => 'Cơ sở dữ liệu PostgreSQL',
    'report__section_full_domains' => 'Các tên miền',
    'report__section_personal_domains' => 'Tên miền cá nhân',
    // keys here are the same as in report__section_domains section
    'report__section_full_personal_domains' => 'Tên miền cá nhân',

    //New for Plesk 10
    'report__sitebuilder_sites' => 'Các trang được xuất bản bằng Presence Builder',
    'report__invalid_email' => 'Xin vui lòng chỉ định một địa chỉ email hợp lệ.',


    // CLI-specific sections
    'report__section_hosting' => 'Vùng lưu trữ',
    'report__section_webusers' => 'Người dùng web',
    'report__section_mailnames' => 'Các tài khoản thư',
    'report__section_maillists' => 'Danh sách gửi thư',
    'report__section_databases' => 'Cơ sở dữ liệu',
    'report__section_siteapps' => 'Ứng dụng Web',
    'report__section_aspnetapps' => 'Ứng dụng ASP.NET', // PFW
    'report__owner_pname' => "Tên nhà cung cấp",
    'report__owner_login' => "tên người dùng của nhà cung cấp",

    ///
    /// END OF SUMMARY / FULL REPORT
    ///

    'ui__reseller/report/layout/auto_unknown__short-title' => 'Lịch trình phân phối',
    'ui__reseller/report/layout/auto_unknown__title' => 'Lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto_unknown__description' => 'Chọn lịch trình phân phối báo cáo cho giao diện báo cáo.',
    'ui__reseller/report/layout/auto/properties_new__short-title' => 'Thêm lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto/properties_new__title' => 'Thêm lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto/properties_new__description' => 'Thêm kế hoạch gửi báo cáo cho báo cáo %1.',
    'ui__reseller/report/layout/auto/properties__short-title' => 'Lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto/properties__title' => 'Lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto/properties__description' => 'Xem và chỉnh sửa thuộc tính của lịch trình phân phối báo cáo.',
    'ui__reseller/report/layout/auto/delete_multi__short-title' => 'Gỡ bỏ lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto/delete_multi__title' => 'Gỡ bỏ lịch trình phân phối báo cáo',
    'ui__reseller/report/layout/auto/delete_multi__description' => 'Gỡ bỏ lịch trình phân phối báo cáo được chọn.',

    'ui__reseller/report/layout_unknown__short-title' => 'Giao diện báo cáo',

    // customer
    'ui__client/traffic__short-title' => '%1',
    'ui__client/traffic__title' => 'Xem Lưu lượng sử dụng cho <b>%1</b>',
    'ui__client/traffic__description' => 'Xem báo cáo lưu lượng sử dụng dành cho tài khoản khách hàng %1.',
    'ui__client/traffic_self__short-title' => 'Lưu lượng sử dụng',
    'ui__client/traffic_self__title' => 'Việc sử dụng lưu lượng của tên miền',
    'ui__client/traffic_self__description' => 'Xem báo cáo lưu lượng sử dụng dành cho tên miền của bạn.',

    ////
    //// KEYS FOR VARIOUS FEATURES
    ////

    ///
    /// SERVER INTERFACE
    ///

    // Locales
    // errors
    'locales__not_allowed' => 'Gói ngôn ngữ chỉ định được cài đặt nhưng không được kích hoạt trong hệ thống.',

    ///
    /// END OF SERVER INTERFACE
    ///

    ///
    /// HOME PAGE CUSTOMIZATION
    ///

    ///
    /// SESSIONS
    ///

    // Entry keys are under respective HP/ADDITIONAL TOOLS/ACTIVE SESSIONS

    // administrator
    'ui__sessions/delete__short-title' => 'Xóa phiên kết nối',
    'ui__sessions/delete__title' => 'Xóa phiên kết nối',
    'ui__sessions/delete__description' => 'Xóa phiên kết nối được chọn.',
    'ui__ftp-sessions__short-title' => 'Phiên kết nối FTP',
    'ui__ftp-sessions__title' => 'Phiên kết nối FTP',
    'ui__ftp-sessions__description' => 'Xem phiên kết nối FTP.',
    'ui__ftp-sessions/delete__short-title' => 'Xóa phiên kết nối FTP',
    'ui__ftp-sessions/delete__title' => 'Xóa phiên kết nối FTP',
    'ui__ftp-sessions/delete__description' => 'Xóa phiên kết nối FTP được chọn.',

    // reseller
    'ui__reseller/sessions/delete__short-title' => 'Xóa phiên kết nối',
    'ui__reseller/sessions/delete__title' => 'Xóa phiên kết nối',
    'ui__reseller/sessions/delete__description' => 'Xóa phiên kết nối được chọn.',
    'ui__reseller/sessions/delete_self__short-title' => 'Xóa phiên kết nối',
    'ui__reseller/sessions/delete_self__title' => 'Xóa phiên kết nối',
    'ui__reseller/sessions/delete_self__description' => 'Xóa phiên kết nối được chọn.',
    'ui__reseller/ftp-sessions__short-title' => 'Phiên kết nối FTP',
    'ui__reseller/ftp-sessions__title' => 'Phiên kết nối FTP',
    'ui__reseller/ftp-sessions__description' => 'Xem phiên kết nối FTP.',
    'ui__reseller/ftp-sessions_self__short-title' => 'Phiên kết nối FTP',
    'ui__reseller/ftp-sessions_self__title' => 'Phiên kết nối FTP',
    'ui__reseller/ftp-sessions_self__description' => 'Xem phiên kết nối FTP.',
    'ui__reseller/ftp-sessions/delete__short-title' => 'Xóa phiên kết nối FTP',
    'ui__reseller/ftp-sessions/delete__title' => 'Xóa phiên kết nối FTP',
    'ui__reseller/ftp-sessions/delete__description' => 'Xóa phiên kết nối FTP được chọn.',
    'ui__reseller/ftp-sessions/delete_self__short-title' => 'Xóa phiên kết nối FTP',
    'ui__reseller/ftp-sessions/delete_self__title' => 'Xóa phiên kết nối FTP',
    'ui__reseller/ftp-sessions/delete_self__description' => 'Xóa phiên kết nối FTP được chọn.',

    // customer
    'ui__client/sessions/delete__short-title' => 'Xóa phiên kết nối',
    'ui__client/sessions/delete__title' => 'Xóa phiên kết nối',
    'ui__client/sessions/delete__description' => 'Xóa phiên kết nối được chọn.',
    'ui__client/sessions/delete_self__short-title' => 'Xóa phiên kết nối',
    'ui__client/sessions/delete_self__title' => 'Xóa phiên kết nối',
    'ui__client/sessions/delete_self__description' => 'Xóa phiên kết nối được chọn.',

    // domain administrator

    'forgery_token_expired' => 'Mã thông báo của phiên đã hết hạn.',

    ///
    /// END OF SESSIONS
    ///

    ///
    /// USER ACCOUNT CONVERSION
    ///

    //
    // USER ACCOUNT TYPE CHANGES
    //

    // resellers > customers
    'downgradeResellers__downgrade_resellers' => 'Tài khoản đại lý sau đây sẽ được chuyển đổi thành tài khoản khách hàng',
    'downgradeResellers__downgrade' => 'Tài khoản đại lý sẽ được chuyển đổi',
    // controls
    'downgradeResellers__submit_downgrade' => 'Thực thi chuyển đổi tài khoản.',
    'downgradeResellers__cancel_downgrade' => 'Hủy bỏ chuyển đổi tài khoản.',
    'downgradeResellers__confirm' => 'Xác nhận chuyển đổi',
    'downgradeResellers__confirm_message' => 'Xác nhận chuyển đổi tài khoản để tiếp tục thực hiện',
    // errors

    // customers > resellers
    'picker_client_multi__title' => 'Chọn tài khoản khách hàng',
    'upgradeClients__upgrade_clients' => 'Tài khoản khách hàng sau đây sẽ không thể chuyển đổi thành tài khoản đại lý',
    'upgradeClients__upgrade' => 'Tài khoản khách hàng sẽ được chuyển đổi',
    // controls
    'upgradeClients__submit_upgrade' => 'Thực thi chuyển đổi tài khoản.',
    'upgradeClients__cancel_upgrade' => 'Hủy bỏ chuyển đổi tài khoản.',
    'upgradeClients__confirm' => 'Xác nhận chuyển đổi',
    'upgradeClients__confirm_message' => 'Xác nhận chuyển đổi tài khoản để tiếp tục thực hiện',
    // errors
    'upgradeClient__user_is_already_reseller' => 'Không thể chuyển tài khoản \'%1\' thành tài khoản bán lẻ: \'%1\' đã là một đại lý.',

    // domain administrators > customers
    'upgradeDomainUser__upgrade_domain_users' => 'Tài khoản quản trị tên miền sau đây sẽ được chuyển đổi thành tài khoản khách hàng',
    'upgradeDomainUser__upgrade' => 'Tài khoản quản trị tên miền sẽ được chuyển đổi',
    // controls
    'upgradeDomainUser__submit_upgrade' => 'Thực thi chuyển đổi tài khoản.',
    'upgradeDomainUser__cancel_upgrade' => 'Hủy bỏ chuyển đổi tài khoản.',
    'upgradeDomainUser__confirm' => 'Xác nhận chuyển đổi',
    'upgradeDomainUser__confirm_message' => 'Xác nhận chuyển đổi tài khoản để tiếp tục thực hiện',
    // errors
    'upgradeDomainUser__non_upgradeable' => 'Tài khoản quản trị tên miền không thể được chuyển đổi',
    'upgradeDomainUser__non_upgradeable_domain_users' => 'Tài khoản quản trị tên miền sau đây sẽ không thể chuyển đổi thành tài khoản khách hàng:',
    'upgradeDomainUser__some_domains_were_not_converted' => 'Một vài tài khoản quản trị tên miền không thể chuyển đổi thành tài khoản khách hàng. %%domainsList%%',
    'upgradeDomainUser__domain_user_does_not_exist' => 'Tài khoản quản trị tên miền không tồn tại',
    'upgradeDomainUser__domain_owner_must_be_a_reseller' => "Tên miền phải thuộc quyền quản lý trực tiếp của quản trị máy chủ hoặc đại lý.",
    'upgradeDomainUser__all_logins_already_used' => 'Không thể tạo tài khoản cho khách hàng kết quả.',
    // notifications
    'upgradeDomainUser__upgrade_notification_subject' => 'Tài khoản quản trị tên miền đã được chuyển đổi',
    'upgradeDomainUser__upgrade_notification_body' => 'Tài khoản quản trị tên miền của bạn vừa được chuyển đổi thành tài khoản khách hàng với tên người dùng \'%%login%%\' và mật khẩu \'%%password%%\'.',

    //
    // USER ACCOUNT OWNER CHANGES
    //

    // Customer owner change
    // customers selection - reseller & admin home
    'picker_client__title' => 'Chọn tài khoản khách hàng',
    // errors
    'clientOwnerChanger__owner_has_no_permission' => 'Đại lý đã chọn không có quyền truy cập \'%1\', nhưng một số khách hàng lại có quyền này.',
    'clientOwnerChanger__application_not_allowed' => 'Ứng dụng \'%1\' không khả dụng cho đại lý đã chọn, nhưng lại khả dụng cho một số khách hàng.',

    // Domain owner change
    'ui__client/domain/chowner_multi-select__wizard-title' => 'Gán lại cho thuê bao được chọn',
    // errors
    'domain_chown__empty_selection' => 'Bạn phải chọn một chủ sở hữu mới của tên miền được chọn',



    //
    // USER ACCOUNT STATE CHANGES
    //


    ///
    /// END OF USER ACCOUNT CONVERSION
    ///

    ///
    /// BANDWIDTH LIMITING
    ///

    'hosting_performance__traffic_bandwidth_label' => 'Băng thông sử dụng tối đa (%1)',
    'hosting_performance__max_connection_label' => 'Giới hạn đối với các kết nối tới',
    'performance__invalid_value' => "Giá trị không hợp lệ. Giá trị này nên được đặt trong khoảng từ %1 đến %2.",

    ///
    /// END OF BANDWIDTH LIMITING
    ///

    ///
    /// WEBMAIL SELECTION (these keys are currently PfU-only)
    ///

    'webmail__server_legend' => 'Trình Quản lý thư trực tuyến',
    'webmail__server_text' => 'Trình Quản lý thư trực tuyến sẵn có của khách hàng',
    'webmail__none' => 'Không',

    ///
    /// END OF WEBMAIL SELECTION
    ///


    ////
    //// BACKUP/RESTORATION
    ////

    // random common keys:
    'backup__ip_mapping__server_ip' => 'Kho IP của máy chủ',

    ///
    /// END OF BACKUP MANAGER ACTIONS
    ///

    ///
    /// LISTS
    ///


    // Common info/errors:
    'migration_db_server_not_find' => 'Cơ sở dữ liệu sẽ không thể được khôi phục: Không có máy chủ cơ sở dữ liệu thích hợp',

    ///
    /// END OF LISTS
    ///

    ///
    /// COMMON SCREENS
    ///

    // Back Up
    // Comments - __comments
    '__default_backup_comment_server' => "Sao lưu máy chủ.",
    '__default_backup_comment_reseller' => "Sao lưu tài khoản bán lẻ đã được tạo bởi %1.",
    '__default_backup_comment_client' => "Sao lưu tài khoản khách hàng đã được tạo bởi %1.",
    '__default_backup_comment_domain' => "Sao lưu thuê bao đã được tạo bởi %1.",

    // Restoration & backup information

    // IP mapping
    'backup__ip_mapping__clients_ip' => "Dãy IP của khách hàng %1",
    'backup__ip_mapping__resellers_ip' => "Dãy IP của đại lý %1",

    // Conflicts occured
    'backup__restore__object_vhost' => 'Máy chủ host ảo',
    'backup__restore__object_plesk_admin' => 'Quản trị viên Plesk',
    'backup__restore__object_ftpuser' => 'Tài khoản FTP',
    'backup__restore__object_frontpageuser' => 'Tài khoản FrontPage',
    'backup__restore__object_webuser' => 'người dùng web',
    'backup__restore__object_domain' => 'tên miền',
    'backup__restore__object_subdomain' => 'Tên miền thứ cấp',
    'backup__restore__object_domainalias' => 'Bí danh tên miền',
    'backup__restore__object_client' => 'Khách hàng',
    'backup__restore__object_reseller' => 'Đại lý',
    'backup__restore__object_autoresponder' => 'tự động trả lời',
    'backup__restore__object_mailalias' => 'Bí danh thư',
    'backup__restore__object_database' => 'cơ sở dữ liệu',
    'backup__restore__object_mailname' => 'tài khoản thư',
    'backup__restore__object_db_user' => 'Cơ sở người dùng',
    'backup__restore__object_ssl_certificate' => 'Chứng nhận SSL/TLS',
    'backup__restore__resellers_cannot_restore_converted_to_customers' => 'Những đại lý sau đây không thể được khôi phục vì họ đã được chuyển thành khách hàng: \'%1\'.',
    'backup__restore__customers_cannot_restore_converted_to_resellers' => 'Những khách hàng sau đây không thể được khôi phục vì họ đã được chuyển thành đại lý: \'%1\'.',
    'backup__restore__customers_cannot_restore_moved_to_another_owners' => 'Những khách hàng sau đây không thể được khôi phục vì họ đã được chuyển cho chủ sở hữu khác: \'%1\'.',

    // Before migration starts
    'backup__restore__capability_not_enough_disk_text' => 'Không đủ không gian đĩa trên máy chủ đích để chuyển tất cả các thuê bao đã chọn. Có sẵn: %1 MB. Được yêu cầu: %2 MB. Lưu ý rằng không gian cần thiết được tính toán là tổng của web, mail, và các nội dung cơ sở dữ liệu của các miền. Không gian cần thiết được tính toán mỗi ngày một lần và lưu trữ trong bộ nhớ đệm, do đó dung lượng thực của các miền có thể khác với dung lượng tính toán. Nếu bạn chắc chắn các miền đã chọn không chiếm nhiều không gian hơn lượng có sẵn, bạn có thể tiếp tục chuyển.',
    'backup__restore__capability_not_enough_disk_resolution' => 'Vui lòng giải phóng không gian đĩa trên máy chủ đích.',
    'backup__restore__capability_source_not_enough_disk_text' => 'Không đủ không gian đĩa trên máy chủ nguồn để lưu trữ các tập tin tạm cần chuyển. Có sẵn: %1 MB. Được yêu cầu: %2 MB.',
    'backup__restore__capability_source_not_enough_disk_resolution' => 'Vui lòng giải phóng không gian đĩa trên máy chủ nguồn.',
    'backup__restore__capability_not_enough_disk_resolution_url_text' => 'Thông tin máy chủ',

    'backup__restore__capability_not_installed_component_text' => 'Thành phần %1 không được cài đặt trên máy chủ đích. %1 sẽ không sẵn có cho mọi đối tượng được khôi phục.',
    'backup__restore__capability_not_installed_component_resolution' => 'Vui lòng cài đặt %1. Lưu ý rằng hoạt động này có thể mất vài phút.',
    'backup__restore__capability_existing_sys_user_text' => 'Người dùng hệ thống có tên %1 đã tồn tại trên máy chủ đích.',
    'backup__restore__capability_existing_sys_user_resolution' => 'Vui lòng đổi tên cho người dùng hệ thống hiện tại trên máy chủ đích.',
    'backup__restore__capability_license_usage_text' => 'Những giới hạn tài nguyên sau đây (quy định theo key bản quyền) sẽ bị vượt ngưỡng trên máy chủ đích sau khi chuyển dữ liệu:',
    'backup__restore__capability_license_usage_resolution' => 'Vui lòng cài đặt trên máy chủ đích một key bản quyền khác sẽ cung cấp số tài nguyên theo yêu cầu.',
    'backup__restore__capability_max_allowed_packet_text' => "Thông số 'max_allowed_packet' trên máy chủ cơ sở dữ liệu nguồn là %1, lớn hơn trên máy chủ đích là %2. Một số đối tượng cơ sở dữ liệu cho các miền chỉ định dưới đây có thể không được khôi phục.",
    'backup__restore__capability_max_allowed_packet_resolution' => "Vui lòng tăng giá trị 'max_allowed_packet' trên máy chủ cơ sở dữ liệu đích.",

    'backup__restore__capability_postgres_to_lower_version_text' => 'Không thể chuyển cơ sở dữ liệu PostgreSQL vì phiên bản PostgreSQL trên máy chủ đích cũ hơn phiên bản trên máy chủ nguồn. Phiên bản hiện tại là %1, phiên bản yêu cầu là %2.',
    'backup__restore__capability_postgres_to_lower_version_text_resolution' => 'Vui lòng cài đặt phiên bản yêu cầu của PostgreSQL trên máy chủ đích.',
    'backup__restore__capability_db_server_connection_problems' => 'Không thể kết nối đến máy chủ cơ sở dữ liệu đích PostgreSQL. Cơ sở dữ liệu sẽ không được chuyển trừ khi bạn khôi phục lại kết nối.',
    'backup__restore__capability_db_server_connection_problems_resolution' => 'Vui lòng kiểm tra cài đặt kết nối trên máy chủ cơ sở dữ liệu đích.',
    'backup__restore__capability_component_not_enabled_server_wide_text' => 'Thành phần %1 đã bị tắt trên máy chủ đích.',
    'backup__restore__capability_component_not_enabled_server_wide_resolution' => 'Vui lòng bật %1 trên máy chủ đích.',
    'backup__restore__capability_not_configured_component_text' => 'Thành phần %1 không được cấu hình trên máy chủ đích.',
    'backup__restore__capability_not_configured_component_resolution' => 'Vui lòng cấu hình %1 trên trang Công cụ & Cài đặt.',

    'backup__restore__capability_webmail_is_not_available' => 'Dịch vụ webmail %1 không khả dụng trên máy chủ đích. Thay vào đó, Plesk sẽ sử dụng dịch vụ webmail sau đây: %2.',
    'backup__restore__capability_webmail_is_not_available_resolution' => 'Để sử dụng cùng webmail như trên máy chủ nguồn, bạn nên cài đặt nó trên máy chủ này.',
    'backup__restore__capability_webmail_is_not_installed_resolution' => 'Để sử dụng cùng webmail như trên máy chủ nguồn, bạn nên cài đặt nó trên máy chủ đích.',
    'backup__restore__capability_webmail_is_not_available_changed_on_subscriptions' => "Webmail '%1' không khả dụng trên máy chủ đích. Thay vào đó, khả dụng trên các thuê bao sau đây: %3, Plesk sẽ sử dụng dịch vụ webmail sau đây: %2.",
    'backup__restore__capability_webmail_is_not_installed_custom_resolution' => 'Vui lòng cài đặt webmail yêu cầu trên máy chủ đích.',
    'backup__restore__capability_webmail_is_not_available_url_text' => 'Cài đặt webmail',

    'backup__restore__capability_shell_is_not_available' => 'Vỏ %1 không khả dụng trên máy chủ đích. Một trong số các vỏ khả dụng sẽ được sử dụng thay thế.',
    'backup__restore__capability_shell_is_not_available_resolution' => 'Để sử dụng cùng vỏ như trên máy chủ nguồn, bạn nên bật (trong /etc/shells) hoặc cài đặt nó trên máy chủ đích.',

    'backup__restore__capability_acl_network_not_allowed_dns_template' => 'Máy chủ đích DNS không hỗ trợ các mạng trong Biểu mẫu hạn chế chuyển. Các bản ghi có địa chỉ IP mạng trong danh sách hạn chế chuyển DNS sẽ không thể khôi phục.',
    'backup__restore__capability_acl_network_not_allowed_dns_zone' => 'Máy chủ đích DNS không hỗ trợ các mạng trong Biểu mẫu hạn chế chuyển, nhưng một số thuê bao có mạng trong danh sách hạn chế chuyển DNS. Các bản ghi có địa chỉ IP mạng trong danh sách hạn chế chuyển DNS sẽ không thể khôi phục.',

    'backup__restore__capability_wrong_php_handler_text' => 'Bộ quản lý PHP %1 không khả dụng trên máy chủ đích. Thay vào đó, Plesk sẽ sử dụng Bộ quản lý PHP sau đây: %2.',
    'backup__restore__capability_wrong_php_handler_resolution' => 'Để sử dụng cùng bộ quản lý PHP như trên máy chủ nguồn, bạn nên bật hoặc cài đặt nó trên máy chủ đích.',
    'bu_conflict_resolver_php_handler_replaced_in_plans' => 'Bộ xử lý PHP %1 không sẵn sàng. Thay vì đó, Plesk sẽ dùng %2 cho các gói dịch vụ sau: {{objects}}',
    'bu_conflict_resolver_php_handler_replaced_in_sites' => 'Bộ xử lý PHP %1 không sẵn sàng. Thay vì đó, Plesk sẽ dùng %2 cho các trang web sau: {{objects}}',
    'bu_conflict_resolver_php_handler_not_allowed_in_sites' => 'Bộ xử lý PHP %1 hiện không khả dụng. Nó sẽ không có sẵn cho các trang web sau: {{objects}}',

    'backup__restore__capability_wrong_component_version_text' => '%1 %2 không khả dụng trên máy chủ đích. Phiên bản mặc định sẽ được sử dụng thay thế.',
    'backup__restore__capability_wrong_component_version_resolution' => 'Để sử dụng cùng %1 như trên máy chủ nguồn, bạn nên bật hoặc cài đặt nó trên máy chủ đích.',

    'backup__restore__capability_antivirus_not_allowed_outgoing_text' => 'Chính sách sử dụng chống virus trên máy chủ đích không cho phép cài đặt chống virus cá nhân (theo địa chỉ email) đối với thư gửi đi. Những cài đặt này sẽ không được chuyển.',
    'backup__restore__capability_antivirus_not_allowed_incoming_text' => 'Chính sách sử dụng chống virus trên máy chủ đích không cho phép cài đặt chống virus cá nhân (theo địa chỉ email) đối với thư đến. Những cài đặt này sẽ không được chuyển.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_text' => 'Chính sách sử dụng chống virus trên máy chủ đích không cho phép cài đặt chống virus cá nhân (theo địa chỉ email). Những cài đặt này sẽ không được chuyển.',
    'backup__restore__capability_antivirus_not_allowed_personal_settings_resolution' => "Để chuyển cài đặt chống virus cá nhân (theo địa chỉ email), vui lòng bật các tùy chọn tương ứng trong Công cụ & Cài đặt > Cài đặt Bảo vệ Virus.",
    'backup__restore__capability_antivirus_not_active_text' => 'Chưa bật phần mềm chống virus nào. Tất cả các cài đặt chống virus từ máy chủ nguồn sẽ không làm việc cho đến khi bạn chọn phần mềm chống virus trên máy chủ đích.',
    'backup__restore__capability_antivirus_not_active_resolution' => 'Vui lòng chọn phần mềm chống virus trong mục Công cụ & Cài đặt > Cài đặt Bảo vệ Virus > Cài đặt chống virus.',

    'backup__restore__capability_antivirus_another_active_text' => 'Phần mềm chống virus %2 không có sẵn trên máy chủ đích. %1 sẽ được sử dụng thay thế.',
    'backup__restore__capability_antivirus_another_active_resolution' => 'Để sử dụng cùng tính năng chống virus trên máy chủ nguồn, vui lòng cài đặt và chọn phần này trong mục Công cụ & Cài đặt > Cài đặt Bảo vệ Virus > Cài đặt chống virus.',
    'backup__restore__capability_not_available_sni_text' => 'SNI không có sẵn trên máy chủ đích. Các trang web có địa chỉ IP giống nhau sẽ không thể sử dụng chứng nhận SSL/TLS cá nhân.',
    'backup__restore__capability_not_available_sni_resolution' => "Hãy đảm bảo hệ điều hành trên máy chủ đích hỗ trợ SNI và hỗ trợ SNI được bật trong Plesk (hộp kiểm 'Bật hỗ trợ SNI, cho phép sử dụng các chứng nhận SSL/TLS cá nhân trên các trang web có cùng địa chỉ IP' trong phần Công Cụ &> Thiết Lập> Cài Đặt Máy Chủ).",
    'backup__restore__capability_not_available_sni_resolution_url_text' => 'Các thiết lập máy chủ',

    'backup__restore__capability_vhost_already_exists_text' => 'Website %1 không thể được chuyển: một website có cùng tên đã tồn tại trên máy chủ đích.',
    'backup__restore__capability_vhost_already_exists_resolution' => 'Vui lòng đặt tên lại hoặc gỡ bỏ website có cùng tên ra khỏi máy chủ.',
    'backup__restore__capability_removed_vhosts' => 'Các thuê bao sau đây sẽ không được khôi phục bởi chúng có chứa các tên miền đã tồn tại trên máy chủ đích: %1',
    'backup__restore__capability_duplicate_php_handler_text' => 'Trên máy chủ nguồn, có %3 bộ quản lý PHP khác nhau thuộc loại %1 và phiên bản %2. Thay thế cho các bộ quản lý này, một bộ quản lý thuộc loại và phiên bản phù hợp sẽ được sử dụng trên máy chủ đích. Lưu ý rằng cài đặt PHP trên máy chủ đích và nguồn có thể khác nhau.',

    'backup__restore__capability_not_installed_frontpage_resolution' => 'Bộ cài Plesk Installer không hỗ trợ Microsoft Frontpage.',
    'backup__restore__capability_not_installed_python_resolution' => 'Bộ cài Pleask Installer không hỗ trợ Python. Hãy cài Python bằng tay.',

    'backup__restore__capability_mail_spamfilter_domain_keys_resolution_url_text' => 'Các thiết lập máy chủ thư',

    'backup__restore__capability_ftps_disabled' => 'Sử dụng FTPS bảo đảm được cho phép trên máy chủ nguồn nhưng bị cấm trên máy chủ đích. Các ứng dụng người dùng sử dụng FTP có thể không hoạt động đúng.',
    'backup__restore__capability_ftps_required' => 'Sử dụng FTP không bảo đảm được cho phép trên máy chủ nguồn nhưng bị cấm trên máy chủ đích. Các ứng dụng người dùng sử dụng FTP có thể không hoạt động đúng.',
    'backup__restore__capability_ftps_policy_resolution' => 'Thay đổi chính sách FTP bảo đảm trong Công cụ & Cài đặt > Chính sách bảo mật.',

    'backup__restore__capability_too_much_download_time_text' => '%1 megabyte dữ liệu sẽ được chuyển từ máy chủ nguồn sang máy chủ đích trong %2 giờ.',
    'backup__restore__capability_too_much_download_time_resolution' => 'Để chuyển nhanh hơn, vui lòng kiểm tra kết nối mạng giữa máy chủ nguồn và máy chủ đích và giải quyết các vấn đề (nếu có).',
    'backup__restore__too_low_download_speed' => "dưới 0,01",
    'backup__restore__capability_too_slow_download_speed_resolution' => 'Để chuyển nhanh hơn, vui lòng kiểm tra kết nối mạng giữa máy chủ nguồn và máy chủ đích và giải quyết các vấn đề (nếu có).',
    'backup__restore__capability_zero_download_speed_text' => 'Tốc độ tải về tối thiểu chấp nhận được là %1 MBps. Tốc độ tải về giữa máy chủ nguồn và máy chủ đích là 0 MBps. Điều này có thể do các vấn đề kết nối mạng. Không thể thực hiện chuyển.',
    'backup__restore__capability_zero_download_speed_resolution' => 'Vui lòng kiểm tra kết nối mạng giữa máy chủ nguồn và máy chủ đích và giải quyết các vấn đề.',
    'backup__restore__capability_too_slow_download_speed_text' => 'Tốc độ tải về tối thiểu chấp nhận được là %2 MBps. Tốc độ tải về giữa máy chủ nguồn và máy chủ đích là %1 MBps. Điều này có thể làm tăng thời gian chuyển. Trong môi trường hiện tại, chuyển rời %3 MB sẽ mất %4 giờ.',
    'backup__restore__capability_too_slow_download_speed_text_without_diskusage' => 'Tốc độ tải về tối thiểu chấp nhận được là %2 MBps. Tốc độ tải về giữa máy chủ nguồn và máy chủ đích là %1 MBps. Điều này có thể làm tăng thời gian chuyển.',

    'backup__restore__capability_remote_database_migration' => "Các miền sau đây đang sử dụng cơ sở dữ liệu từ xa: %1",
    'backup__restore__capability_remote_database_migration_resolution' => "Không gỡ bỏ các miền này ra khỏi máy chủ nguồn sau khi chuyển nếu phiên bản Plesk trên máy chủ nguồn cũ hơn bản 11.5! Thay vào đó, tạm ngưng các miền đó. Nếu bạn gỡ bỏ các miền, cơ sở dữ liệu sẽ bị gỡ khỏi máy chủ từ xa. Lưu ý: Các tập tin rác của cơ sở dữ liệu từ xa sẽ được lưu trữ trên máy chủ nguồn trong danh mục %1.",

    'backup__restore__capability_mysql_50_to_51_migration' => 'Các tệp sao lưu của máy chủ cơ sở dữ liệu MySQL trước 5.1 (%1) có thể không được khôi phục trên MySQL 5.1.x vì MySQL 5.1.x quản lý các ký tự Unicode khác nhau.',
    'backup__restore__capability_mysql_50_to_51_migration_resolution' => '',
    'backup__restore__capability_mysql_50_to_51_migration_kb_link_title' => 'Vui lòng đọc bài kiến thức nền liên quan #136850',

    'backup__restore__capability_courier_not_installed_text' => 'Courier-IMAP không được cài đặt trên máy chủ đích.',
    'backup__restore__capability_courier_not_installed_resolution' => 'Hãy cài đặt Courier-IMAP bằng cách dùng bộ cài Plesk Installer.',
    'backup__restore__capability_dovecot_not_installed_text' => 'Dovecot không được cài đặt trên máy chủ đích.',
    'backup__restore__capability_dovecot_not_installed_resolution' => 'Hãy cài đặt Dovecot bằng cách dùng bộ cài Plesk Installer.',

    'backup__restore__wrong_stat_ttl_value_text' => 'Thời gian duy trì thống kê lưu lượng trong cấu hình của các đối tượng sau đây ít hơn giá trị trên toàn máy chủ của máy chủ đích.',
    'backup__restore__wrong_stat_ttl_value_resolution' => 'Vui lòng thay đổi giá trị trên toàn máy chủ cho thời gian duy trì thống kê trên máy chủ đích. Thiết lập thời gian này bằng hoặc ít hơn giá trị nhỏ nhất trong cấu hình của các miền.',
    'bu_conflict_resolver_wrong_stat_ttl_value' => 'Thời gian lưu trữ thống kê lưu lượng trên một số miền nhỏ hơn giá trị trên toàn máy chủ (%1). Giá trị sẽ được đổi thành %1 cho các miền này.',
    'bu_conflict_resolver_wrong_stat_ttl_template_value' => 'Thời gian lưu thống kê lưu lượng trên một số gói dịch vụ nhỏ hơn giá trị trên toàn máy chủ (%1). Giá trị sẽ được đổi thành %1 cho các gói dịch vụ này.',

    'backup__ip_mapping__map_dedicated_to_shared_ip' => 'Lập bản đồ một địa chỉ IP độc quyền đến một địa chỉ IP chia sẻ sẽ hủy kích hoạt FTP và HTTPS ẩn danh (trừ khi hỗ trợ SNI được bật).',

    'backup__restore__no_postgresql_commands_text' => 'Thuê bao sử dụng một cơ sở dữ liệu PostgreSQL từ xa, và tệp sao lưu tạm thời của nó không thể được tạo ra vì các lệnh pg_dump và psql bị mất trên máy chủ nguồn.',
    'backup__restore__no_postgresql_commands_resolution' => 'Vui lòng cài đặt bất kỳ gói máy khách PostgreSQL nào hỗ trợ các lệnh này.',
    'backup__restore__capability_apache_modules_disabled_text' => 'Các mô-đun Apache sau đây đã được hủy kích hoạt trên máy chủ đích: %1.',
    'backup__restore__capability_apache_modules_disabled_resolution' => 'Vui lòng kích hoạt các mô-đun này để tránh các vấn đề có thể xảy ra.',
    'backup__restore__capability_apache_modules_not_installed_text' => 'Các mô-đun Apache sau đây không được cài đặt trên máy chủ đích: %1.',
    'backup__restore__capability_apache_modules_not_installed_resolution' => 'Vui lòng cài đặt và kích hoạt các mô-đun này để tránh các vấn đề có thể xảy ra.',

    'backup__restore__capability_license_not_supported_outgoing_antispam' => 'Giới hạn tin nhắn gửi đi không được hỗ trợ theo giấy phép của bạn. Những cài đặt cấu hình tương ứng sẽ không được chuyển.',
    'backup__restore__capability_license_not_supported_outgoing_antispam_resolution' => 'Vui lòng cài đặt trên máy chủ đích một key bản quyền khác cung cấp các tính năng theo yêu cầu.',
    'backup__restore__capability_disabled_outgoing_antispam' => 'Giới hạn tin nhắn gửi đi đã bị tắt trên máy chủ đích. Những cài đặt cấu hình tương ứng sẽ không được chuyển.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution' => 'Vui lòng bật giới hạn tin nhắn gửi đi trên máy chủ đích.',
    'backup__restore__capability_disabled_outgoing_antispam_resolution_url_text' => 'Cài đặt thư trên toàn máy chủ',

    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported' => 'Giới hạn các tin nhắn gửi đi từ một hòm thư không được hỗ trợ bởi máy chủ thư sử dụng trên máy chủ đích. Giá trị của giới hạn này sẽ không được chuyển.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution' => 'Vui lòng đổi máy chủ thư sang cùng máy chủ bạn sử dụng trên máy chủ nguồn.',
    'backup__restore__capability_outgoing_antispam_mbox_limit_not_supported_resolution_url_text' => 'Cài đặt thư trên toàn máy chủ',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported' => 'Giới hạn các tin nhắn gửi đi từ một miền không được hỗ trợ bởi máy chủ thư sử dụng trên máy chủ đích. Giá trị của giới hạn này sẽ không được chuyển.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution' => 'Vui lòng đổi máy chủ thư sang cùng máy chủ bạn sử dụng trên máy chủ nguồn.',
    'backup__restore__capability_outgoing_antispam_domain_limit_not_supported_resolution_url_text' => 'Cài đặt thư trên toàn máy chủ',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported' => 'Giới hạn các tin nhắn gửi đi từ một thuê bao không được hỗ trợ bởi máy chủ thư sử dụng trên máy chủ đích. Giá trị của giới hạn này sẽ không được chuyển.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution' => 'Vui lòng đổi máy chủ thư sang cùng máy chủ bạn sử dụng trên máy chủ nguồn.',
    'backup__restore__capability_outgoing_antispam_subscription_limit_not_supported_resolution_url_text' => 'Cài đặt thư trên toàn máy chủ',

    'bu_conflict_resolver_absent_phosting' => 'Không thể khôi phục các tập tin đã chỉ định vì dịch vụ lưu trữ thực để khôi phục chúng không tồn tại. Trước tiên, vui lòng tạo một miền có dịch vụ lưu trữ thực và sau đó bắt đầu khôi phục sao lưu lại.',
    'bu_conflict_resolver_resellers_management_is_not_supported' => 'Dữ liệu về đại lý sẽ không được lưu trữ do không hỗ trợ quản lý đại lý.',

    'backup__restore__capability_modsecurity_not_installed_text' => 'Thành phần ModSecurity không được cài đặt trên máy chủ đích.',
    'backup__restore__capability_modsecurity_not_installed_resolution' => 'Vui lòng cài đặt ModSecurity nếu bạn muốn để tường lửa ứng dụng web làm việc cho các trang đã chuyển. Lưu ý rằng hoạt động cài đặt có thể mất vài phút.',
    'backup__restore__capability_modsecurity_not_installed_resolution_for_server' => 'Cài đặt ModSecurity nếu bạn muốn chuyển các cài đặt của tường lửa ứng dụng web. Lưu ý rằng hoạt động cài đặt có thể mất vài phút.',
    'backup__restore__capability_modsecurity_not_configured_text' => 'Thành phần ModSecurity không được cấu hình trên máy chủ đích.',
    'backup__restore__capability_modsecurity_not_configured_resolution' => 'Cấu hình ModSecurity nếu bạn muốn để tường lửa ứng dụng web làm việc cho các trang đã chuyển.',
    'backup__restore__capability_modsecurity_not_configured_resolution_url_text' => 'Tường lửa Ứng dụng Web (ModSecurity)',
    'backup__restore__capability_modsecurity_not_active_text' => 'ModSecurity đã bị tắt trên máy chủ đích.',
    'backup__restore__capability_modsecurity_not_active_resolution' => 'Kích hoạt ModSecurity nếu bạn muốn để tường lửa ứng dụng web làm việc cho các trang đã chuyển.',
    'backup__restore__capability_modsecurity_not_active_resolution_url_text' => 'Tường lửa Ứng dụng Web (ModSecurity)',
    'bu_conflict_resolver_modsecurity_not_installed' => 'Thành phần ModSecurity không được cài đặt. Cài đặt tường lửa ứng dụng web sẽ không được khôi phục cho các đối tượng sau đây: {{objects}}',
    'bu_conflict_resolver_absent_websites_subscription' => "Các website không thể được khôi phục vì chúng thuộc về thuê bao %1, và không thể tìm thấy trong Plesk.",
    'backup__restore__capability_not_installed_dns_text' => 'Thành phần %1 không được cài đặt trên máy chủ đích. Dịch vụ DNS sẽ không khả dụng và các cài đặt DNS sẽ bị mất. Toàn bộ các website của khách hàng sẽ bị tắt.',
    'bu_conflict_resolver_dns_not_installed' => 'Dịch vụ cơ sở dữ liệu không được cài đặt. Cài đặt DNS sẽ không được khôi phục cho các đối tượng sau đây: {{objects}}',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_owners' => 'Những thuê bao sau đây không thể được khôi phục vì họ đã được chuyển cho chủ sở hữu khác: \'%1\'',
    'backup__restore__subscriptions_cannot_restore_moved_to_another_vendors' => 'Những thuê bao sau đây không thể được khôi phục vì họ đã được chuyển cho nhà cung cấp khác: \'%1\'',
    'bu_conflict_resolver_sitebuilder_restore_util_is_not_installed' => 'Không thể tìm thấy tiện ích phục hồi Web Presence Builder để phục hồi dữ liệu Web Presence Builder. Có thể Web Presence Builder chưa được cài đặt.',
    'backup__restore__capability_renamed_db' => 'Tên cơ sở dữ liệu "%1" đã được sử dụng bởi thuê bao khác. Tên của cơ sở dữ liệu khôi phục sẽ được thay đổi thành "%2".',
    'backup__restore__capability_renamed_db_user' => 'Tên người dùng cơ sở dữ liệu "%1" đã được sử dụng bởi thuê bao khác. Tên người dùng cơ sở dữ liệu khôi phục sẽ được thay đổi thành "%2".',
    'backup__restore__capability_not_installed_perl_resolution' => 'Bộ cài Pleask Installer không hỗ trợ Perl. Hãy cài ActiveState Perl bằng tay.',
    'backup__restore__capability_php_handler' => '%%version%% %%type%% (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_apache' => '%%version%% %%type%% được Apache hỗ trợ (id=%%id%%)',
    'backup__restore__capability_php_handler_served_by_nginx' => '%%version%% %%type%% được nginx hỗ trợ (id=%%id%%)',


    '__sni' => 'SNI',
    '__kav' => 'Chống virus Kaspersky',
    '__drweb' => 'Odin Premium Antivirus',

    // Resource usage conflicts
    'backup__restore__resource_useage_conflicts' => 'Xung đột sử dụng tài nguyên',
    'backup__restore__hint_resource_usage_conflicts' => 'Xung đột sử dụng tài nguyên xảy ra khi giới hạn sử dụng tài nguyên của đối tượng được khôi phục bị vượt quá khi phục hồi.',
    'backup__restore__text_resource_usage_resolution_policy_overusage' => 'Cho phép sử dụng vượt giới hạn',
    'backup__restore__hint_resource_usage_resolution_policy_overusage' => 'Khôi phục đối tượng và cho phép nó sử dụng nhiều tài nguyên hơn so với thời điểm khởi tạo ban đầu.',
    'backup__restore__text_resource_usage_resolution_policy_do_not_restore' => 'Không khôi phục',
    'backup__restore__hint_resource_usage_resolution_policy_do_not_restore' => 'Không khôi phục các đối tượng có xung đột sử dụng tài nguyên.',
    // Configuration conflicts
    'backup__restore__configuration_conflicts' => 'Xung đột cấu hình',
    'backup__restore__hint_configuration_conflicts' => 'Xung đột cấu hình xảy ra khi đối tượng được khôi phục có các thiết lập và ứng dụng web không tồn tại hoặc bị cấm bởi máy chủ hiện tại hoặc chính sách của chủ sở hữu. Ví dụ, xung đột cấu hình sẽ xảy ra nếu tài khoản thư được khôi phục có các thiết lập lọc thư rác của riêng nó trong khi chính sách phía máy chủ ngăn cấm các tài khoản thư khỏi việc sở hữu các thiết lập này.',
    'backup__restore__text_configuration_resolution_policy_automatic' => 'Tự động',
    'backup__restore__hint_configuration_resolution_policy_automatic' => 'Khôi phục đối tượng và tự động bật tất cả các cấu hình xung đột mà bạn được quyền quản lý. Các ứng dụng web thiếu sẽ được cài đặt và sẵn sàng hoạt động nếu quyền hạn của bạn cho phép.',
    'backup__restore__text_configuration_resolution_policy_do_not_restore' => 'Không khôi phục',
    'backup__restore__hint_configuration_resolution_policy_do_not_restore' => 'Không khôi phục các đối tượng có xung đột cấu hình.',

    'backup__restore__dedicated_app_pool_restore_to_shared_text' => 'Các dãy ứng dụng IIS chuyên dụng không được cho phép trong cài đặt dãy ứng dụng IIS.',
    'backup__restore__dedicated_app_pool_restore_to_shared_resolution' => 'Vui lòng thay đổi cài đặt dãy ứng dụng IIS của bạn trong Công cụ & Cài đặt > Dãy ứng dụng IIS > Cài đặt toàn cầu.',
    'backup__restore__shared_app_pool_restore_to_dedicated_text' => 'Các dãy ứng dụng IIS chia sẻ không được cho phép trong cài đặt dãy ứng dụng IIS.',
    'backup__restore__shared_app_pool_restore_to_dedicated_resolution' => 'Vui lòng thay đổi cài đặt dãy ứng dụng IIS của bạn trong Công cụ & Cài đặt > Dãy ứng dụng IIS > Cài đặt toàn cầu.',

    'backup__restore__unable_allow_short_pop3 _names_text' => 'Tên viết tắt cho tài khoản thư POP3/IMAP không được cho phép trên máy chủ đích.',
    'backup__restore__unable_allow_short_pop3 _names_resolution' => 'Tên viết tắt cho các tài khoản thư sẽ không khả dụng sau khi khôi phục dữ liệu.',

    // Restore status messages & errors:
    'backup__unable_to_open_log_file' => 'Không thể mở tập tin nhật ký.',
    'backup__restore__customer_cannot_restore_nonexistent_subscription' => 'Không thể khôi phục thuê bao %1: nó đã bị gỡ bỏ khỏi tài khoản của bạn và bạn không có quyền để tạo các thuê bao. Nếu bạn cần khôi phục, xin vui lòng liên hệ với nhà cung cấp dịch vụ của bạn.',

    'backup__error11' => 'Không đủ không gian đĩa cho sao lưu.',
    'backup__error3011' => 'Kết nối bị từ chối: Không có chương trình nào đang chờ nghe trên địa chỉ và cổng đã chỉ định.',
    'backup__error3012' => 'Thời gian chờ kết nối.',
    'backup__error3013' => 'Không kể kết nối với mạng.',
    'backup__error3014' => 'Không có định tuyến đến bộ lưu trữ.',
    'backup__error3015' => 'Không thể kết nối.',
    'backup__error3016' => 'Không thể phân giải tên bộ lưu trữ.',
    'backup__error3017' => 'Tên người dùng hoặc mặt khẩu không đúng.',
    'backup__error3018' => 'Không thể kết nối SSH.',

    'backup__error3110' => 'Không thể kết nối đến đại lý chuyển rời từ xa: Kết nối đến bộ lưu trữ không khả dụng.',
    'backup__error3111' => 'Đại lý chuyển rời bị khóa do một tác vụ chuyển rời lỗi hoặc đang được sử dụng bởi một quy trình chuyển rời khác. Vui lòng khởi động lại đại lý chuyển rời trên máy chủ nguồn.',
    'backup__error3112' => 'Kết nối đến bộ lưu trữ không khả dụng hoặc đại lý chuyển rời không chạy trên bộ lưu trữ nguồn.',
    'backup__error3113' => 'Không thể triển khai đại lý chuyển rời sang bộ lưu trữ Linux. Vui lòng kiểm tra kết nối SSH đến bộ lưu trữ nguồn.',
    'backup__error3114' => 'Không thể triển khai đại lý chuyển rời sang bộ lưu trữ Linux: Không thể kết nối SSH.',
    'backup__error3115' => 'Tên người dùng hoặc mặt khẩu không đúng.',
    'backup__error3116' => 'Người dùng không có quyền ưu tiên quản trị.',

    'dns_t__unable_to_remove_ns_record' => 'Không thể gỡ bỏ bản ghi NS khỏi biểu mẫu DNS: Mỗi vùng DNS phải có ít nhất một bản ghi NS.',
    'dns__unsupported_server_zone_transfer' => 'Không thể chuyển Biểu mẫu hạn chế chuyển do cấu hình DNS trên toàn máy chủ: Trên máy chủ nguồn, các địa chỉ mạng sau đây được cho phép chuyển vùng, tuy nhiên các địa chỉ mạng này bị cấm bởi Máy chủ Microsoft DNS: %1',
    'dns__unsupported_domain_zone_transfer' => 'Không thể chuyển Biểu mẫu hạn chế chuyển do cấu hình DNS của miền: Trên một số miền, các địa chỉ mạng sau đây được cho phép chuyển vùng, tuy nhiên các địa chỉ mạng này bị cấm bởi Máy chủ Microsoft DNS: %1',
    ///
    /// END OF COMMON SCREENS
    ///

    ///
    /// DATABASE BACKUP - PFW // TBD
    ///

    // Actions

    'dbbackup__check_network_settings_failed' => 'Không thể truy cập danh mục mạng chia sẻ tạm thời để lấy tệp sao lưu. Vui lòng kiểm tra cài đặt danh mục mạng, tên người dùng, và mật khẩu. Lỗi: %1',

    'migration_select_exist_db_server' => 'Chọn máy chủ cơ sở dữ liệu đích',

    'dbbackup__temp_dir_wrong_value' => 'Đã chỉ định giá trị không hợp lệ cho danh mục tạm thời.',
    'dbbackup__network_temp_dir_wrong_value' => 'Đã chỉ định giá trị không hợp lệ cho danh mục mạng tạm thời.',
    'dbbackup__server_backup_not_configured' => 'Cài đặt sao lưu cơ sở dữ liệu không được cấu hình trên máy chủ.',
    'dbbackup__temp_dir' => 'Danh mục tạm thời',
    'dbbackup__temp_dir_hint' => 'Đường dẫn đến thư mục vật lý trên máy chủ từ xa, nơi đặt máy chủ MS SQL. Máy chủ MS SQL phải có khả năng truy cập vào thư mục này cho việc đọc và ghi các tập tin sao lưu tạm thời. Ví dụ, C:\\DirectoryPath',
    'dbbackup__network_temp_dir_hint' => 'Đường dẫn đến chia sẻ mạng được chỉ tới thư mục vật lý được chỉ định ở trên. Plesk sẽ truy cập vào thư mục chia sẻ để tải về và tải lên các tập tin sao lưu. Ví dụ, \\\\ServerName\\DirectoryPath',
    'dbbackup__network_user_hint' => 'Tên người dùng của người dùng mạng được tạo ra trên máy chủ từ xa. Ví dụ, ServerName\\UserName. Người dùng phải có quyền truy cập vào thư mục chia sẻ chỉ định ở trên.',
    'dbbackup__network_password_hint' => 'Mật khẩu của người dùng mạng',

    'dbbackup__success_import_without_dublicate_users' => 'Các người dùng sau không được nhập: %1. Họ đã tồn tại trên máy chủ cơ sở dữ liệu.',

    ///
    /// END OF DATABASE BACKUP
    ///

    ///
    /// LOGS & LOG ROTATION
    ///

    'log_rot__compress' => "Nén các tập tin nhật ký",
    'log_rot__log_rot_status' => "Trạng thái luân chuyển nhật ký",
    'log_rot__log_rot_period' => "Điều kiện luân chuyển nhật ký",
    'log_rot__log_rot_size' => "theo kích thước",
    'log_rot__log_rot_time' => "theo thời gian",
    'log_rot__logrotation_enable' => "Bật luân chuyển nhật ký",
    'log_rot__mail' => "Gửi tập tin nhật ký đã xử lý sang email",
    'log_rot__max_number_of_logfiles' => "Số tập tin nhật ký tối đa",
    'log_rot__time_period' => "kỳ",
    'log_rot__unable_turn_off' => 'Không thể tắt luân chuyển nhật ký vì nó bị buộc ở cấp máy chủ',
    'log_rot__unable_set_period' => 'Không thể đặt thời gian luân chuyển nhật ký khác với \'daily\', bởi vì nó bị buộc ở cấp độ máy chủ',
    'log_rot__unable_set_max_log_files' => 'Không thể đặt số tệp nhật ký tối đa lớn hơn giới hạn trên toàn bộ máy chủ %1',

    /// action log
    // common/various
    'actionlog__digit_expected' => "Số lượng mong muốn: %1",
    'actionlog__incorrect_rotation' => "Bản tin tham số không hợp lệ được chỉ định: %1",
    'actionlog__unknown_rot_period' => "Giai đoạn xoay không biết: %1",
    'actionlog__unknown_rot_type' => "Kiểu xoay không biết: %1",
    'actionlog__session_preferences' => 'Thiết lập phiên',
    // items (PFU schema)
    'actionlog__admin_info' => 'Thông tin người quản trị',
    'actionlog__admin_preferences' => "Lựa chọn của quản trị",
    'actionlog__service' => 'Dịch vụ',
    'actionlog__ip_addr' => 'Địa chỉ IP',
    'actionlog__client' => 'Tài khoản khách hàng',
    'actionlog__client_status' => 'Trạng thái tài khoản khách hàng',
    'actionlog__client_preferences' => "Tùy chọn giao diện khách hàng",
    'actionlog__client_ip_pool' => "Địa chỉ IP chung của khách hàng",
    'actionlog__client_siteapp' => "Kho ứng dụng web của khách hàng",
    'actionlog__client_guid' => "GUID khách hàng",
    'actionlog__domain' => 'Miền mặc định (miền đầu tiên được thêm vào thuê bao)',
    'actionlog__domain_owner' => 'Chủ sở hữu của thuê bao',
    'actionlog__domain_plan' => 'Gói dịch vụ thuê bao',
    'actionlog__domain_status' => 'Miền, trạng thái mặc định',
    'actionlog__domain_dns' => 'Vùng DNS của miền mặc định',
    'actionlog__subdomain' => 'Tên miền phụ của một miền mặc định',
    'actionlog__domain_alias' => 'Miền, bí danh mặc định',
    'actionlog__domain_alias_dns' => 'Vùng DNS của miền, bí danh mặc định',
    'actionlog__site' => 'Tên miền',
    'actionlog__site_status' => 'Trạng thái miền',
    'actionlog__site_dns' => 'Vùng DNS của tên miền',
    'actionlog__site_guid' => 'GUID miền',
    'actionlog__site_subdomain' => 'Tên miền phụ',
    'actionlog__site_alias' => 'Bí danh miền',
    'actionlog__site_alias_dns' => 'Vùng DNS bí danh miền',
    'actionlog__domain_limits' => 'Giới hạn của thuê bao',
    'actionlog__domain_limit_size' => 'Giới hạn dung lượng ổ cứng cho thuê bao',
    'actionlog__domain_limit_traffic' => 'Giới hạn lưu lượng cho thuê bao',
    'actionlog__domain_limits_powerUser' => 'Giới hạn thuê bao',
    'actionlog__domain_limit_size_powerUser' => 'Giới hạn không gian đĩa cho thuê bao',
    'actionlog__domain_limit_traffic_powerUser' => 'Giới hạn lưu lượng của thuê bao',
    'actionlog__domain_guid' => "Miền, GUID mặc định",
    'actionlog__cp_user' => 'Người dùng Plesk',
    'actionlog__mailname' => 'Tài khoản thư',
    'actionlog__maillist' => 'Danh sách gửi thư',
    'actionlog__phosting' => 'Thiết lập lưu trữ',
    'actionlog__forwarding' => 'Dịch vụ lưu trữ chuyển tiếp tiêu chuẩn hoặc khung',
    'actionlog__webuser' => 'Tài khoản người dùng web',
    'actionlog__site_application' => 'Ứng dụng web',
    'actionlog__license' => 'Mã bản quyền',
    'actionlog__additional_license' => 'Mã bản quyền bổ sung',
    'actionlog__template_domain' => "gói dịch vụ của đại lý",
    'actionlog__template_admin' => "Mẫu gói dịch vụ của tài khoản quản trị",
    'actionlog__template_reseller' => 'Gói đại lý',
    'actionlog__admin_alias' => 'Tài khoản quản trị bổ sung', // PFW
    'actionlog__ftpuser' => 'Tài khoản FTP bổ sung', // PFW
    'actionlog__db_server' => 'Máy chủ cơ sở dữ liệu',
    'actionlog__db' => 'Cơ sở dữ liệu',
    'actionlog__db_user' => 'Tài khoản người dùng cơ sở dữ liệu',
    'actionlog__client_sapppkg_pool' => "Ứng dụng web của người dùng", // PFW, not used?
    'actionlog__remote_dns' => 'Trạng thái máy chủ DNS từ xa', // PFW
    'actionlog__reseller' => 'Tài khoản đại lý',
    'actionlog__reseller_guid' => 'GUID đại lý',
    'actionlog__reseller_ip_pool' => "dãy IP của đại lý",
    'actionlog__reseller_limit_size' => 'Giới hạn dung lượng ổ đĩa cho đại lý',
    'actionlog__reseller_limit_traffic' => 'Giới hạn lưu lượng cho đại lý',
    'actionlog__reseller_limits' => 'Giới hạn tài khoản đại lý',
    'actionlog__reseller_permissions' => 'Quyền hạn đại lý',
    'actionlog__reseller_preferences' => "Tùy chọn giao diện đại lý",
    'actionlog__reseller_siteapp' => "Ứng dụng web dùng chung cho đại lý",
    'actionlog__reseller_status' => 'Trạng thái tài khoản đại lý',
    'actionlog__health_status' => 'Tình trạng sức khỏe của máy chủ',
    // actions (PFU schema)
    'actionlog__limit_reached' => 'đã đạt đến',
    'actionlog__added' => 'đã thêm vào',
    'actionlog__removed' => 'đã xóa bỏ',
    'actionlog__change' => 'đã thay đổi',
    'actionlog__update' => 'đã cập nhật',
    'actionlog__move' => 'đã chuyển',
    'actionlog__upgrade' => 'đã nâng cấp', // PFU?
    'actionlog__update_or_add' => 'đã cập nhật hoặc thêm vào',
    'actionlog__expired' => 'đã hết hạn',
    'actionlog__create' => 'đã được tạo',
    'actionlog__delete' => 'đã xóa bỏ',
    'actionlog__service_stop' => 'đã dừng lại',
    'actionlog__service_restart' => 'đã khởi động lại',
    'actionlog__service_start' => 'đã khởi động',
    'actionlog__login' => 'đã đăng nhập',
    'actionlog__logout' => 'đã đăng xuất',
    'actionlog__install' => 'đã cài đặt',
    'actionlog__uninstall' => 'đã gỡ cài đặt',
    'actionlog__reconfigure' => 'đã cấu hình lại',
    // events (PFW schema)
    'actionlog__event_pw_reset' => 'Yêu cầu đặt lại mật khẩu',
    'actionlog__event_admin_update' => 'Thông tin người quản trị đã được cập nhật',
    'actionlog__event_admin_preferences_update' => "Lựa chọn của quản trị được cập nhật",
    'actionlog__event_service_restart' => 'Khởi động lại dịch vụ',
    'actionlog__event_service_start' => 'Khởi động dịch vụ',
    'actionlog__event_service_stop' => 'Dừng dịch vụ',
    'actionlog__event_ip_address_create' => 'Địa chỉ IP đã được tạo',
    'actionlog__event_ip_address_delete' => 'Địa chỉ IP đã được được xóa',
    'actionlog__event_ip_address_update' => 'Địa chỉ IP đã được cập nhật',
    'actionlog__event_client_create' => 'Tài khoản khách hàng đã được tạo',
    'actionlog__event_client_delete' => 'Tài khoản khách hàng đã xóa',
    'actionlog__event_client_update' => 'Tài khoản khách hàng đã được cập nhật',
    'actionlog__event_client_status_update' => 'Trạng thái tài khoản khách hàng được cập nhật',
    'actionlog__event_client_preferences_update' => "Tùy chọn giao diện người dùng được cập nhật",
    'actionlog__event_client_siteapp_added' => "Ứng dụng web được thêm vào kho ứng dụng của tài khoản khách hàng",
    'actionlog__event_client_siteapp_removed' => "Ứng dụng web đã được tháo bỏ khỏi kho ứng dụng của người dùng",
    'actionlog__event_domain_limit_size_reached' => 'Đã đạt đến giới hạn dung lượng ổ cứng cho thuê bao',
    'actionlog__event_domain_limit_traffic_reached' => 'Đã đạt đến giới hạn lưu lượng cho thuê bao',
    'actionlog__event_domain_limit_size_reached_powerUser' => 'Đã đạt giới hạn không gian đĩa',
    'actionlog__event_domain_limit_traffic_reached_powerUser' => 'Đã đạt giới hạn thuê bao',

    'actionlog__domain_limit_database' => 'Hạn ngạch cơ sở dữ liệu cho thuê bao',
    'actionlog__event_domain_limit_mysql_quota_reached' => 'Đã đạt tới hạn ngạch cơ sở dữ liệu MySQL cho thuê bao',
    'actionlog__event_domain_limit_mysql_soft_quota_reached' => 'Đã đạt tới hạn ngạch mềm cơ sở dữ liệu MySQL cho thuê bao',
    'actionlog__event_domain_limit_mssql_quota_reached' => 'Đã đạt tới hạn ngạch cơ sở dữ liệu máy chủ SQL Microsoft cho thuê bao',
    'actionlog__event_domain_limit_mssql_soft_quota_reached' => 'Đã đạt tới hạn ngạch mềm cơ sở dữ liệu máy chủ SQL Microsoft cho thuê bao',
    'actionlog__event_plesk_component_upgrade' => 'Thành phần Plesk được cập nhật',
    'actionlog__event_plesk_component_install' => 'Thành phần Plesk được cài đặt',
    'actionlog__event_plesk_component_uninstall' => 'Thành phần Plesk được gỡ cài đặt',
    'actionlog__event_domain_create' => 'Miền mặc định (miền đầu tiên thêm vào thuê bao) được tạo',
    'actionlog__event_domain_delete' => 'Miền mặc định (miền đầu tiên thêm vào thuê bao) bị xóa',
    'actionlog__event_domain_update' => 'Miền mặc định (miền đầu tiên thêm vào thuê bao) được cập nhật',
    'actionlog__event_domain_owner_change' => 'Đã thay đổi chủ sở hữu thuê bao',
    'actionlog__event_domain_plan_change' => 'Gói dịch vụ thuê bao đã thay đổi',
    'actionlog__event_domain_status_update' => 'Đã cập nhật miền, trạng thái mặc định',
    'actionlog__event_domain_dns_update' => 'Đã cập nhật miền, vùng DNS mặc định',
    'actionlog__event_subdomain_create' => 'Đã tạo tên miền phụ của một miền mặc định',
    'actionlog__event_subdomain_delete' => 'Đã xóa tên miền phụ của một miền mặc định',
    'actionlog__event_subdomain_update' => 'Đã cập nhật tên miền phụ của một miền mặc định',
    'actionlog__event_domain_alias_create' => 'Đã tạo miền, bí danh mặc định',
    'actionlog__event_domain_alias_delete' => 'Đã xóa miền, bí danh mặc định',
    'actionlog__event_domain_alias_update' => 'Đã cập nhật miền, bí danh mặc định',
    'actionlog__event_domain_limits_update' => 'Đã cập nhật giới hạn thuê bao',
    'actionlog__event_cp_user_login' => 'Người dùng Plesk đã đăng nhập',
    'actionlog__event_cp_user_logout' => 'Người dùng Plesk đã đăng xuất',
    'actionlog__event_mailname_create' => 'tài khoản thư đã được tạo',
    'actionlog__event_mailname_delete' => 'Đã xóa tài khoản thư',
    'actionlog__event_mailname_update' => 'Đã cập nhật tài khoản thư',
    'actionlog__event_maillist_create' => 'Đã tạo danh sách gửi thư',
    'actionlog__event_maillist_delete' => 'Đã xóa danh sách gửi thư',
    'actionlog__event_maillist_update' => 'Đã cập nhật danh sách gửi thư',
    'actionlog__event_phys_hosting_create' => 'Đã tạo nơi lưu trữ vật lý',
    'actionlog__event_phys_hosting_delete' => 'Đã xóa nơi lưu trữ vật lý',
    'actionlog__event_phys_hosting_update' => 'Đã cập nhật nơi lưu trữ vật lý',
    'actionlog__event_forwarding_create' => 'Đã tạo nơi lưu trữ chuyển tiếp hoặc tiêu chuẩn',
    'actionlog__event_forwarding_delete' => 'Đã xóa nơi lưu trữ chuyển tiếp hoặc tiêu chuẩn',
    'actionlog__event_forwarding_update' => 'Đã cập nhật nơi lưu trữ chuyển tiếp hoặc tiêu chuẩn',
    'actionlog__event_webuser_create' => 'Đã tạo tài khoản người dùng web',
    'actionlog__event_webuser_delete' => 'Đã xóa tài khoản người dùng web',
    'actionlog__event_webuser_update' => 'Đã cập nhật tài khoản người dùng web',
    'actionlog__event_siteapp_install' => 'Đã cài đặt ứng dụng web',
    'actionlog__event_siteapp_reconfigure' => 'ứng dụng web đã được tái cấu hình',
    'actionlog__event_siteapp_uninstall' => 'ứng dụng web đã được gỡ cài đặt',
    'actionlog__event_license_update' => 'Giấy phép được cập nhật',
    'actionlog__event_admin_alias_create' => 'Đã tạo tài khoản quản trị bổ sung',
    'actionlog__event_admin_alias_delete' => 'Đã xóa tài khoản quản trị bổ sung',
    'actionlog__event_admin_alias_update' => 'Đã cập nhật tài khoản quản trị bổ sung',
    'actionlog__event_ftpuser_create' => 'Đã tạo tài khoản FTP bổ sung',
    'actionlog__event_ftpuser_update' => 'Đã cập nhật tài khoản FTP bổ sung',
    'actionlog__event_ftpuser_delete' => 'Đã xóa tài khoản FTP bổ sung',
    'actionlog__event_template_domain_create' => "Đã tạo gói dịch vụ cho đại lý",
    'actionlog__event_template_domain_update' => "Đã cập nhật gói dịch vụ cho đại lý",
    'actionlog__event_template_domain_delete' => "Đã xóa gói dịch vụ của đại lý",
    'actionlog__event_template_admin_create' => "Đã tạo gói dịch vụ của người quản trị",
    'actionlog__event_template_admin_update' => "Đã cập nhật gói dịch vụ của người quản trị",
    'actionlog__event_template_admin_delete' => "Đã xóa gói dịch vụ của người quản trị",
    'actionlog__event_database_server_create' => 'Đã tạo máy chủ cơ sở dữ liệu',
    'actionlog__event_database_server_update' => 'Đã cập nhật máy chủ cơ sở dữ liệu',
    'actionlog__event_database_server_delete' => 'Đã xóa chủ cơ sở dữ liệu',
    'actionlog__event_remote_dns_status_update' => 'Đã cập nhật trạng thái máy chủ DNS từ xa',
    'actionlog__event_session_preferences_update' => 'Đã cập nhật thiết lập đăng nhập',
    'actionlog__event_domain_alias_dns_update' => 'Đã cập nhật miền, vùng DNS mặc định của bí danh miền',
    'actionlog__event_domain_move' => 'Đã chuyển miền mặc định sang thuê bao mới',
    'actionlog__event_site_move' => 'Đã chuyển miền sang thuê bao mới',
    'actionlog__event_site_subdomain_move' => 'Đã chuyển miền con sang thuê bao mới',
    'actionlog__event_subdomain_move' => 'Đã chuyển miền con của miền mặc định sang thuê bao mới',
    'actionlog__event_license_expired' => 'Bản quyền Plesk đã hết hạn',
    'actionlog__event_database_create' => 'Đã tạo cơ sở dữ liệu',
    'actionlog__event_database_delete' => 'Đã xóa cơ sở dữ liệu',
    'actionlog__event_database_user_create' => 'Đã tạo tài khoản cơ sở dữ liệu người dùng',
    'actionlog__event_database_user_update' => 'Đã cập nhật thiết lập tài khoản người dùng CSDL',
    'actionlog__event_database_user_delete' => 'Đã xóa tài khoản cơ sở dữ liệu người dùng',
    'actionlog__event_client_guid_update' => "Đã cập nhật GUID khách hàng",
    'actionlog__event_domain_guid_update' => 'Đã cập nhật miền, GUID mặc định',
    'actionlog__event_reseller_create' => 'Đã tạo tài khoản đại lý',
    'actionlog__event_reseller_delete' => 'Đã xóa tài khoản đại lý',
    'actionlog__event_reseller_update' => 'Đã cập nhật tài khoản đại lý',
    'actionlog__event_reseller_guid_update' => 'Đã cập nhật GUID đại lý',
    'actionlog__event_reseller_ip_pool_update' => "Đã cập nhật IP đại lý dùng chung",
    'actionlog__event_reseller_limit_size_reached' => 'Đã đạt đến giới hạn dung lượng ổ đĩa cho tài khoản đại lý',
    'actionlog__event_reseller_limit_traffic_reached' => 'Đã đạt đến giới hạn lưu lượng cho tài khoản đại lý',
    'actionlog__event_reseller_limits_update' => 'Đã cập nhật giới hạn tài khoản đại lý',
    'actionlog__event_reseller_permissions_update' => 'Đã cập nhật quyền hạn cho tài khoản đại lý',
    'actionlog__event_reseller_preferences_update' => "Đã cập nhật Tùy chọn giao diện của đại lý",
    'actionlog__event_reseller_siteapp_added' => "Ứng dụng được thêm vào ứng dụng dùng chung của tài khoản đại lý",
    'actionlog__event_reseller_siteapp_removed' => "Ứng dụng được xóa bỏ khỏi ứng dụng dùng chung của tài khoản đại lý",
    'actionlog__event_reseller_status_update' => 'Đã cập nhật trạng thái tài khoản đại lý',
    'actionlog__event_template_reseller_create' => 'Đã tạo gói dành cho đại lý',
    'actionlog__event_template_reseller_delete' => 'Đã xóa gói dành cho đại lý',
    'actionlog__event_template_reseller_update' => 'Đã cập nhật gói dành cho đại lý',
    'actionlog__event_health_status_change' => 'Đã thay đổi tình trạng sức khỏe của máy chủ',
    'actionlog__event_siteapp_upgrade' => 'Đã nâng cấp ứng dụng web',
    'actionlog__event_extension_install' => 'Đã cài đặt phần mở rộng',
    'actionlog__event_extension_uninstall' => 'Đã gỡ cài đặt phần mở rộng',
    'actionlog__event_extension_upgrade' => 'Đã nâng cấp phần mở rộng',
    'actionlog__event_extension_status_update' => 'Đã cập nhật trạng thái phần mở rộng',
    'actionlog__event_additional_license_expired' => 'Giấy phép bổ sung đã hết hạn',
    'actionlog__event_hostname_changed' => 'Tên dịch vụ lưu trữ máy chủ đã thay đổi',
    'actionlog__event_smb_user_create' => 'Đã tạo người dùng bổ sung',
    'actionlog__event_smb_user_delete' => 'Đã xóa người dùng bổ sung',
    'actionlog__event_smb_user_update' => 'Đã cập nhật người dùng bổ sung',

    // REMOTE SESSION
    'rsession_no_api_rpc_errmsg' => "Plesk API RPC không được cài đặt trên bộ lưu trữ từ xa. Liên hệ với nhà cung cấp dịch vụ để được hỗ trợ.",
    'rsession_no_account_errmsg' => "Không thể truy cập dịch vụ từ xa bằng tài khoản của bạn. Lý do là dịch vụ cho tài khoản của bạn chưa được kích hoạt. Xin vui lòng thử lại trong ít phút. Nếu lỗi tương tự vẫn xảy ra, hãy liên hệ với người quản trị.",
    'rsession_no_domain_errmsg' => "Không thể truy cập dịch vụ từ xa cho miền này. Lý do là dịch vụ cho miền này chưa được kích hoạt. Xin vui lòng thử lại trong ít phút. Nếu lỗi tương tự vẫn xảy ra, hãy liên hệ với người quản trị.",
    'rsession_unknown_errmsg' => "Máy chủ từ xa đã từ chối việc xây dựng kết nối. Liên hệ người quản trị để được hỗ trợ. Lỗi: %1",
    'rsession_unknown2_errmsg' => "Không hiểu lỗi trong quá trình xây dựng phiên giao dịch từ xa. Có thể là các máy chủ ở xa không trả lời các yêu cầu. Liên hệ người quản trị để kiểm tra các lỗi chi tiết trong nhật ký lỗi của máy chủ web.",
    'rsession_no_connect_errmsg' => "Không thể truy cập vào dịch vụ từ xa: kết nối từ xa thất bại. Liên hệ người quản trị để được hỗ trợ.",

    // ANONYMOUS FTP
    'anonftp__allow_upload_incoming' => "Cho phép tải lên danh mục gửi đến",
    'anonftp__allow_create_dirs' => 'Cho phép tạo các danh mục trong danh mục gửi đến',
    'anonftp__allow_download_incoming' => 'Cho phép tải về từ danh mục gửi đến',
    'anonftp__display_login' => 'Hiển thị tin nhắn đăng nhập',
    'anonftp__login_text' => 'Tin nhắn văn bản',
    'anonftp__limit_incoming_disk_space' => "Giới hạn không gian đĩa trên thư mục đến",
    'anonftp__limit_maximum_bandwidth' => "Giới hạn băng thông tải cho miền FPT ảo",
    'anonftp__limit_maximum_connections' => "Giới hạn số kết nối đồng thời",
    'anonftp__unable_init' => "Không thể khởi tạo tài khoản FTP ẩn danh: %1",
    'anonftp__unable_set_quota' => "Không thể thiết lập giới hạn đĩa cho thư mục đến: %1",
    'anonftp__unable_update' => "Không thể cập nhật đặc tính tài khoản FTP ẩn danh: %1",

    ///
    /// SSL/TLS CERTIFICATES
    ///

    // common keys
    '__certificates' => 'Chứng nhận SSL/TLS', // page title
    // errors
    'class_sslcertificate__ca_not_signs' => "chứng chỉ CA không ký chứng chỉ.",
    'class_sslcertificate__incompatible_pvt_key_cert' => "Cặp chứng chỉ/khóa riêng không tương thích.",
    'class_sslcertificate__invalid_cert_format' => "Định dạng chứng nhận không hợp lệ.",
    'class_sslcertificate__invalid_private_key_format' => "Khóa riêng không hợp lệ.",
    'class_sslcertificate__prob_invalid_priv_key' => "Có thể là định dạng khóa riêng không hợp lệ.",

    ///
    ///END OF SSL/TLS CERTIFICATES
    ///

    ///
    /// WEB DIRECTORIES (PFW)
    ///

    //
    // DOMAIN
    //

    // Web Directories tab
    // Web Directories - ui__client/domain/hosting/web-directories__title (HOME/DOMAIN)
    'ui__client/domain/hosting/web-directories/create-virtual-dir__short-title' => 'Tạo thư mục ảo',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__title' => 'Tạo danh mục ảo',
    'ui__client/domain/hosting/web-directories/create-virtual-dir__description' => 'Tạo danh mục ảo.',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__short-title' => 'Tạo thư mục ảo',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__title' => 'Tạo danh mục ảo',
    'ui__client/domain/hosting/web-directories/create-virtual-dir_self__description' => 'Tạo danh mục ảo.',
    'ui__client/domain/hosting/web-directories/create-dir__short-title' => 'Tạo danh mục',
    'ui__client/domain/hosting/web-directories/create-dir__title' => 'Tạo danh mục',
    'ui__client/domain/hosting/web-directories/create-dir__description' => 'Tạo một danh mục.',
    'ui__client/domain/hosting/web-directories/create-dir_self__short-title' => 'Tạo danh mục',
    'ui__client/domain/hosting/web-directories/create-dir_self__title' => 'Tạo danh mục',
    'ui__client/domain/hosting/web-directories/create-dir_self__description' => 'Tạo một danh mục.',
    'ui__client/domain/hosting/web-directories/properties__short-title' => 'Thuộc tính thư mục',
    'ui__client/domain/hosting/web-directories/properties__title' => 'Thuộc tính thư mục ảo',
    'ui__client/domain/hosting/web-directories/properties__description' => 'Xem và thay đổi thuộc tính thư mục ảo.',
    'ui__client/domain/hosting/web-directories/properties_self__short-title' => 'Thuộc tính thư mục',
    'ui__client/domain/hosting/web-directories/properties_self__title' => 'Thuộc tính thư mục ảo',
    'ui__client/domain/hosting/web-directories/properties_self__description' => 'Xem và thay đổi thuộc tính thư mục ảo.',
    'ui__client/domain/hosting/web-directories/permissions__short-title' => 'Quyền hạn truy cập thư mục',
    'ui__client/domain/hosting/web-directories/permissions__title' => 'Quyền hạn truy cập thư mục',
    'ui__client/domain/hosting/web-directories/permissions__description' => 'Khởi tạo quyền hạn truy cập thư mục.',
    'ui__client/domain/hosting/web-directories/permissions_self__short-title' => 'Quyền hạn truy cập thư mục',
    'ui__client/domain/hosting/web-directories/permissions_self__title' => 'Quyền hạn truy cập thư mục',
    'ui__client/domain/hosting/web-directories/permissions_self__description' => 'Khởi tạo quyền hạn truy cập thư mục.',
    'ui__client/domain/hosting/web-directories/aspdotnet__short-title' => 'Thiết lập ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet__title' => 'Thiết lập ASP.NET cho %1',
    'ui__client/domain/hosting/web-directories/aspdotnet__description' => 'Cấu hình tùy chọn ASP.NET cho thư mục ảo %1.',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__short-title' => 'Thiết lập ASP.NET',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__title' => 'Thiết lập ASP.NET cho %1',
    'ui__client/domain/hosting/web-directories/aspdotnet_self__description' => 'Cấu hình thiết lập ASP.NET cho thư mục ảo %1.',
    'ui__client/domain/hosting/web-directories/php__short-title' => 'Cài đặt PHP',
    'ui__client/domain/hosting/web-directories/php__title' => 'Thiết lập PHP cho %1',
    'ui__client/domain/hosting/web-directories/php__description' => 'Cấu hình thiết lập PHP cho thư mục ảo %1.',
    'ui__client/domain/hosting/web-directories/php_self__short-title' => 'Cài đặt PHP',
    'ui__client/domain/hosting/web-directories/php_self__title' => 'Thiết lập PHP cho %1',
    'ui__client/domain/hosting/web-directories/php_self__description' => 'Cấu hình thiết lập PHP cho thư mục ảo %1.',

    // list object operations
    'ui__client/domain/hosting/web-directories/delete__short-title' => 'Gỡ bỏ',
    'ui__client/domain/hosting/web-directories/delete__title' => 'Gỡ bỏ thư mục ảo',
    'ui__client/domain/hosting/web-directories/delete__description' => 'Gỡ bỏ thư mục ảo được chọn.',
    'ui__client/domain/hosting/web-directories/delete_self__short-title' => 'Gỡ bỏ',
    'ui__client/domain/hosting/web-directories/delete_self__title' => 'Gỡ bỏ thư mục ảo',
    'ui__client/domain/hosting/web-directories/delete_self__description' => 'Gỡ bỏ thư mục ảo được chọn.',
    'ui__client/domain/hosting/web-directories/delete#legend__description' => 'Những thư mục ảo sau đây sẽ được gỡ bỏ:',
    'ui__client/domain/hosting/web-directories/delete__empty_selection' => 'Bạn phải chọn thư mục muốn gỡ bỏ.',

    // MIME Types tab
    'ui__client/domain/hosting/web-directories/mime-type_unknown__short-title' => 'Các kiểu MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__title' => 'Các kiểu MIME',
    'ui__client/domain/hosting/web-directories/mime-type_unknown__description' => 'Xem danh sách các kiểu MIME đã đăng ký.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__short-title' => 'Thêm kiểu MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__title' => 'Thêm loại MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__description' => 'Đăng ký kiểu MIME mới.',

    // Error documents tab
    'ui__client/domain/hosting/web-directories/error-doc_unknown__short-title' => 'Tài liệu báo lỗi',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__title' => 'Tài liệu báo lỗi',
    'ui__client/domain/hosting/web-directories/error-doc_unknown__description' => 'Xem và thay đổi tài liệu báo lỗi.',

    // Protection tab
    'ui__client/domain/hosting/web-directories/protection__short-title' => 'Bảo vệ',
    'ui__client/domain/hosting/web-directories/protection__title' => 'Bảo vệ thư mục',
    'ui__client/domain/hosting/web-directories/protection__description' => 'Ngăn cấm truy xuất thư mục được bảo vệ bằng mật khẩu.',
    'ui__client/domain/hosting/web-directories/protection_self__short-title' => 'Bảo vệ',
    'ui__client/domain/hosting/web-directories/protection_self__title' => 'Bảo vệ thư mục',
    'ui__client/domain/hosting/web-directories/protection_self__description' => 'Ngăn cấm truy xuất thư mục được bảo vệ bằng mật khẩu.',
    'ui__client/domain/hosting/web-directories/protection/properties__short-title' => 'Cài đặt',
    'ui__client/domain/hosting/web-directories/protection/properties__description' => 'Xem địa điểm của thư mục và xác định tiêu đề cho các khu vực được bảo vệ.',
    'ui__client/domain/hosting/web-directories/protection/user/properties__title' => 'Cài đặt người dùng',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__title' => 'Thêm người dùng',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__short-title' => 'Thêm người dùng',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__description' => 'Thêm tài khoản người dùng để cho phép truy cập vào thư mục được bảo vệ.',
    'ui__client/domain/hosting/web-directories/protection/properties__done' => 'Thiết lập mới đã được áp dụng.',
    'ui__client/domain/hosting/web-directories/protection/user/properties_new__done' => 'Tài khoản người dùng đã được thêm.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__description' => 'Gỡ bỏ người dùng của thư mục được bảo vệ.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__title' => 'Gỡ bỏ tài khoản người dùng',
    'ui__client/domain/hosting/web-directories/protection/user/delete#legend__description' => 'Xác nhận gỡ bỏ tài khoản người dùng.',
    'ui__client/domain/hosting/web-directories/protection/user/delete_multi__done' => 'Tài khoản người dùng đã được gỡ bỏ.',

    //
    // SUBDOMAIN
    //

    // Web Directories tab

    // list object operations

    // MIME Types tab

    // Protection tab
    // Error documents tab

    ///
    /// END OF WEB DIRECTORIES
    ///

    ///
    /// SUBDOMAIN PAGE
    ///


    ///
    /// END OF SUBDOMAIN PAGE
    ///

    ///
    /// DONE MESSAGES
    ///

    // UI
    'ui____done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__admin/extras-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__admin/report/layout/delete_multi__done' => 'Giao diện báo cáo được chọn đã bị gỡ bỏ.',
    'ui__admin/report/traffic-history__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__admin/report__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__admin-alias/delete_multi__done' => "Tài khoản quản trị bổ sung được chọn đã được gỡ bỏ.",
    'ui__admin-alias/properties__done' => "Thuộc tính tài khoản quản trị bổ sung đã được cập nhật.",
    'ui__admin-alias/properties_new__done' => "Tài khoản quản trị bổ sung đã được tạo.",
    'ui__admin-alias/properties_unknown__done' => "Thuộc tính tài khoản quản trị bổ sung đã được cập nhật.",
    'ui__admin-alias__done' => "Thông tin tài khoản quản trị bổ sung đã được cập nhật thành công.",
    'ui__admin/manage-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__admin/register-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__admin/report/layout/auto/delete_multi__done' => 'Lịch trình phân phối báo cáo được chọn đã được gỡ bỏ.',
    'ui__admin/report/layout/auto/properties__done' => 'Lịch trình phân phối báo cáo đã được cập nhật.',
    'ui__admin/report/layout/auto/properties_new__done' => 'Lịch trình phân phối báo cáo đã được tạo.',
    'ui__client/domain/certificate/properties__done' => 'Thuộc tính chứng nhận SSL/TLS được cập nhật.',
    'ui__client/domain/certificate/properties_new__done' => 'Chứng nhận SSL/TLS mới đã được thêm vào. Để nó hoạt động, phải chọn nó ở phần thiết lập lưu trữ trang web (tại tab Trang web & Miền> tên miền).',
    'ui__client/domain/certificate__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/certificate_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/chowner__done' => 'Thuê bao %1 hiện thuộc về người dùng khác.',
    'ui__client/domain/chowner_multi__done' => 'Sở hữu thuê bao vừa được thay đổi.',
    'ui__client/domain/chowner_multi-select__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/chowner_select__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/dbbackup/create__done' => "Cơ sở dữ liệu đã được sao lưu thành công", // PFW
    'ui__client/domain/dbbackup/get__done' => "Cơ sở dữ liệu đã được sao lưu thành công", // PFW
    'ui__client/domain/dbbackup/orphaned__done' => "Tài khoản người dùng bị cô lập đã được sửa chữa thành công", // PFW
    'ui__client/domain/dbbackup/remove__done' => "Tập tin sao lưu đã được gỡ bỏ thành công", // PFW
    'ui__client/domain/dbbackup/restore__done' => "Nội dung cơ sở dữ liệu đã được khôi phục thành công", // PFW
    'ui__client/domain/dbbackup/upload__done' => "Hoạt động đã hoàn tất thành công.", // PFW
    'ui__client/domain/dbbackup__done' => "Hoạt động đã hoàn tất thành công.", // PFW
    'ui__client/domain/dbbackup_self__done' => "Hoạt động đã hoàn tất thành công.", // PFW
    'ui__client/domain/dbbackup_unknown__done' => "Hoạt động đã hoàn tất thành công.", // PFW
    'ui__client/domain/delete__done' => "Tên miền %1 vừa được gỡ bỏ.",
    'ui__client/domain/delete_multi__done' => "Tên miền vừa được gỡ bỏ.",
    'ui__client/domain/disable__done' => 'Tên miền %1 vừa bị tạm dừng.',
    'ui__client/domain/disable_multi__done' => 'Các miền đã chọn bị tạm ngưng.',
    'ui__client/domain/enable__done' => 'Trang web %1 đã được kích hoạt.',
    'ui__client/domain/enable_multi__done' => 'Các tên miền được chọn vừa được kích hoạt lại.',
    'ui__client/domain/extras__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/domain/extras_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/domain/hosting/logs/rotation__done' => 'Thiết lập luân chuyển nhật ký đã được thay đổi.',
    'ui__client/domain/hosting/logs/rotation_self__done' => 'Thiết lập luân chuyển nhật ký đã được thay đổi.',
    'ui__client/domain/hosting/logs__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/hosting/logs_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/hosting/setup__done' => 'Lưu trữ cho %1 đã được cấu hình.',
    'ui__client/domain/hosting/web-directories/aspdotnet/change-version__done' => 'Phiên bản ASP.NET đã được thay đổi.', // PFW
    'ui__client/domain/hosting/ssh-terminal__done' => 'Hoạt động đã hoàn tất thành công.', // PFU
    'ui__client/domain/hosting/ssh-terminal_self__done' => 'Hoạt động đã hoàn tất thành công.', // PFU
    'ui__client/domain/hosting/web-directories/aspdotnet__done' => 'Thiết lập ASP.NET cho %1 đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/create-dir__done' => 'Thư mục Web thuộc tên miền %1 đã được tạo.', // PFW
    'ui__client/domain/hosting/web-directories/create-virtual-dir__done' => 'Thư mục ảo đã được tạo', // PFW
    'ui__client/domain/hosting/web-directories/delete__done' => 'Thư mục được chọn đã được gỡ bỏ.', // PFW
    'ui__client/domain/hosting/web-directories/delete_self__done' => 'Thư mục được chọn đã được gỡ bỏ.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__done' => 'tài liệu báo lỗi tùy biến đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__done' => 'Kiểu MIME được chọn đã được gỡ bỏ', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties_new__done' => 'Kiểu MIME mới đã được đăng ký.', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__done' => 'Hoạt động đã hoàn tất thành công.', // PFW
    'ui__client/domain/hosting/web-directories/permissions__done' => 'Quyền hạn truy cập thư mục đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/permissions_self__done' => 'Quyền hạn truy cập thư mục đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/php__done' => 'Thiết lập PHP cho %1 đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/php_self__done' => 'Thiết lập PHP cho %1 đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/properties__done' => 'Thuộc tính thư mục đã được cập nhật', // PFW
    'ui__client/domain/hosting/web-directories/properties_self__done' => 'Thuộc tính thư mục đã được cập nhật', // PFW
    'ui__client/domain/hosting/web-directories/protection__done' => 'Thiết lập bảo vệ thư mục đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories/protection_self__done' => 'Thiết lập bảo vệ thư mục đã được cập nhật.', // PFW
    'ui__client/domain/hosting/web-directories__done' => 'Hoạt động đã hoàn tất thành công.', // PFW
    'ui__client/domain/hosting/web-directories_self__done' => "Hoạt động đã hoàn tất thành công.", // PFW
    'ui__client/domain/mpc-certificates__done' => 'Chứng nhận SSL/TLS có trong cửa hàng trực tuyến',
    'ui__client/domain/mpc-certificates_self__done' => 'Chứng nhận SSL/TLS có trong cửa hàng trực tuyến',
    'ui__client/domain/register__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/domain/register_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/domain/rename__done' => 'Tên miền vừa được đổi tên.',
    'ui__client/domain/rename_self__done' => "Tên miền đã được đổi tên thành công.",
    'ui__client/domain/settings_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/toggle_disable__done' => "Tên miền %1 đã bị tạm dừng.",
    'ui__client/domain/toggle_enable__done' => "Tên miền %1 đã được kích hoạt.",
    'ui__client/domain/traffic__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/traffic_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain/traffic_unknown__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain-summary-report__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain-summary-report_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/domain-summary-report_unknown__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/extras-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/extras-domain_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/ipaddress/delete_multi__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/ipaddress/properties__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/ipaddress/properties_new__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/ip-pool/properties__done' => "Kho IP của khách hàng %1 đã được cập nhật.",
    'ui__client/ip-pool/properties_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/limits__done' => "Giới hạn tài nguyên dành cho khách hàng %1 đã được thay đổi.",
    'ui__client/limits_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/logo__done' => 'Thiết lập thương hiệu mới cho khách hàng %1 đã được áp dụng.',
    'ui__client/logo_reseller__done' => 'Thiết lập thương hiệu bảng điều khiển mới đã được áp dụng.',
    'ui__client/logo_self__done' => 'Các cài đặt nhãn hiệu đã được áp dụng.',
    'ui__client/logo_self-reseller__done' => 'Thiết lập thương hiệu bảng điều khiển mới của bạn đã được áp dụng.',
    'ui__client/manage-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/manage-domain_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/permissions__done' => "Quyền hạn của khách hàng %1 đã được thay đổi.",
    'ui__client/permissions_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/preferences__done' => "Tùy chỉnh cho khách hàng %1 đã được thay đổi.",
    'ui__client/preferences_self__done' => "Tùy chỉnh của bạn đã được cập nhật.",
    'ui__client/register-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/register-domain_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__client/report/traffic-history__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/report/traffic-history_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/report__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/report_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/sessions/delete__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/sessions/delete_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/sessions__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/sessions_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/skeleton__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/skeleton_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__client/traffic__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__client/traffic_unknown__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__cp-access__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__cp-session/properties__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__cp-session__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__ftp-sessions__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__license__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__logo__done' => "Các đặc tính nhãn hiệu Plesk đã được thay đổi.",
    'ui__longtasks/longtask/properties__done' => "Thiết lập tác vụ nền đã được thay đổi thành công.",
    'ui__mass-email/delete__done' => "Mẫu thông điệp %1 đã được gỡ bỏ.", // PFW
    'ui__mass-email/delete_multi__done' => "Mẫu thông điệp đã được gỡ bỏ.",  // PFW
    'ui__mass-email/send_main__done' => "Hoạt động đã hoàn tất thành công.",  // PFW
    'ui__mass-email/send_selectclients__done' => "Tài khoản khách hàng được chọn thành công",  // PFW
    'ui__mass-email/send_selectdomainusers__done' => "Tài khoản quản trị tên miền được chọn thành công",  // PFW
    'ui__mass-email/send_selectresellers__done' => 'Tài khoản đại lý được chọn thành công',  // PFW
    'ui__mass-email/template/properties_main__done' => 'Đã lưu những thay đổi với biểu mẫu tin nhắn email hàng loạt.', // PFW
    'ui__mass-email/template/properties_new-main__done' => 'Đã tạo biểu mẫu tin nhắn email hàng loạt.', // PFW
    'ui__mass-email/template/properties_new-selectclients__done' => 'Đã chọn tài khoản khách hàng cho biểu mẫu tin nhắn email hàng loạt.',  // PFW
    'ui__mass-email/template/properties_new-selectdomainusers__done' => 'Đã chọn tài khoản quản trị miền cho biểu mẫu tin nhắn email hàng loạt.', // PFW
    'ui__mass-email/template/properties_new-selectresellers__done' => 'Đã chọn tài khoản đại lý cho biểu mẫu tin nhắn email hàng loạt.',  // PFW
    'ui__mass-email/template/properties_unknown__done' => "Đã thay đổi biểu mẫu tin nhắn email hàng loạt.",  // PFW
    'ui__mass-email/template/properties__invalid_values' => 'Giá trị không hợp lệ đã được chỉ định.', // PFW
    'ui__mass-email__done' => "Hoạt động đã hoàn tất thành công.", // PFW
    'ui__mass-mail__done' => "Hoạt động đã hoàn tất thành công.", // PFU
    'ui__mass-mail/delete__done' => 'Mẫu thông điệp %1 đã được gỡ bỏ.', // PFU
    'ui__mass-mail/delete_multi__done' => 'Mẫu thông điệp đã được gỡ bỏ.', // PFU
    'ui__mass-mail/properties__done' => 'Mẫu %1 đã được thay đổi.', // PFU
    'ui__mass-mail/properties_new__done' => 'Mẫu %1 đã được thay đổi.', // PFU
    'ui__mass-mail/send__done' => 'Thông điệp đã được gửi.', // PFU
    'ui__mass-mail/send_new__done' => 'Thông điệp đã được gửi.', // PFU
    'ui__mass-mail/send_unknown__done' => 'Thông điệp đã được gửi.',  // PFU
    'ui__mass-mail/send_unknown-new__done' => 'Thông điệp đã được gửi.', // PFU
    'ui__mass-mail/template/properties_new__done' => 'Mẫu thông điệp mới đã được tạo.', // PFU
    'ui__mass-mail/template/properties__done' => 'Mẫu tin nhắn đã được thay đổi.', // PFU
    'ui__modules/watchdog/disk/properties__done' => 'Thiết lập theo dõi ổ đĩa mới đã được áp dụng.', // PFU
    'ui__modules__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__modules__short-title' => 'Phần mở rộng',
    'ui__modules__title' => 'Phần mở rộng',
    'ui__reseller/client/traffic_unknown__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/extras-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__reseller/extras-domain_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__reseller/ftp-sessions_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/limits__done' => "Giới hạn tài nguyên và chính sách sử dụng của đại lý đã thay đổi.",
    'ui__reseller/limits_readonly-self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/limits_self__done' => 'Chính sách giới hạn tài nguyên và tài nguyên sử dụng của bạn đã được thay đổi.',
    'ui__reseller/manage-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__reseller/manage-domain_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__reseller/permissions__done' => 'Quyền hạn của đại lý %1 đã được thay đổi.',
    'ui__reseller/permissions_readonly-self__done' => '',
    'ui__reseller/permissions_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/register-domain__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__reseller/register-domain_self__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__reseller/report/layout/auto/delete_multi__done' => 'Lịch trình phân phối báo cáo được chọn đã được gỡ bỏ.',
    'ui__reseller/report/layout/auto/properties__done' => 'Lịch trình phân phối báo cáo đã được cập nhật.',
    'ui__reseller/report/layout/auto/properties_new__done' => 'Lịch trình phân phối báo cáo vừa được thêm.',
    'ui__reseller/report/traffic-history__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/report/traffic-history_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/report__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/report_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/sessions/delete__done' => 'Hoạt động đã hoàn tất thành công',
    'ui__reseller/sessions/delete_self__done' => 'Hoạt động đã hoàn tất thành công',
    'ui__reseller/sessions__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/sessions_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/traffic__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/traffic_self__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/traffic_unknown__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__reseller/logo_self__title' => 'Nhãn hiệu Plesk',
    'ui__reseller/logo_self__done' => 'Các cài đặt nhãn hiệu Plesk đã được áp dụng.',
    'ui__server/aspdotnet__done' => 'Thiết lập ASP.NET trên toàn máy chủ đã được thay đổi.', // PFW
    'ui__server/certificate/default_multi__done' => 'Chứng nhận SSL/TLS được chọn đã được thiết lập để được sử dụng để bảo vệ các kết nối đến các trang web mới được lưu trữ.',
    'ui__server/certificate/delete_multi__done' => 'Chứng nhận SSL/TLS được chọn đã được gỡ bỏ.',
    'ui__server/certificate/download__done' => 'Chứng nhận SSL/TLS đã được tải xuống.',
    'ui__server/certificate/properties__done' => 'Thuộc tính chứng nhận SSL/TLS được cập nhật.',
    'ui__server/certificate/properties_new__done' => 'Chứng nhận SSL/TLS %1 đã được tạo.',
    'ui__server/certificate/setup_multi__done' => 'Chứng nhận SSL/TLS được chọn đã được thiết lập để bảo vệ các kết nối đến Plesk.',
    'ui__server/certificate__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/cp-certificate-download__done' => "Chứng nhận SSL/TLS của Plesk đã được tải xuống.",
    'ui__server/crontab/properties__done' => 'Tác vụ được lập lịch của %1 vừa được thay đổi.',
    'ui__server/crontab/task/delete__done' => 'Tác vụ đã được gỡ bỏ.',
    'ui__server/crontab/task/delete_multi__done' => 'Tác vụ đã được gỡ bỏ.',
    'ui__server/crontab/task/properties__done' => 'Tác vụ được lập lịch đã được cập nhật.',
    'ui__server/crontab/task/properties_new__done' => 'Tác vụ mới đã được lập lịch.',
    'ui__server/crontab/task/toggle_disable__done' => 'Tác vụ được lập lịch %1 đã bị vô hiệu hóa.',
    'ui__server/crontab/task/toggle_enable__done' => 'Tác vụ được lập lịch %1 đã được kích hoạt.',
    'ui__server/crontab__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/dns__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/ip-address/client/delete__done' => "Địa chỉ IP đã được gỡ bỏ khỏi kho IP của người dùng.",
    'ui__server/ip-address/client/delete_multi__done' => "Địa chỉ IP đã được gỡ bỏ khỏi kho IP của người dùng.",
    'ui__server/ip-address/client/properties_new__done' => 'Địa chỉ IP vừa được gán cho người dùng.',
    'ui__server/ip-address/ip-address/add-to-clients_add-target__done' => 'Địa chỉ IP %1 được gán cho những khách hàng được chọn.',
    'ui__server/ip-addresses__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/spam/recipients__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/spam/summary__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/spam__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/virus/recipients__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/virus/summary__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/virus/viruses__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics/virus__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail/statistics__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__server/mail__done' => 'Thiết lập máy chủ thư đã được thay đổi.',
    'ui__server/maillists__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/mpc-certificates__done' => 'Các chứng nhận SSL/TLS có trên danh sách trang cửa hàng trực tuyến đã được mở.',
    'ui__server/pmm__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/preferences__done' => "Thiết lập máy chủ đã được thay đổi.",
    'ui__server/register__done' => 'Trang MyPlesk.com đã được mở.',
    'ui__server/services__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/sitebuilder__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/skeleton__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/spam-filter/black-list/address/delete__done' => 'Địa chỉ %1 vừa được gỡ bỏ khỏi danh sách thư rác trên toàn máy chủ.',
    'ui__server/spam-filter/black-list/address/delete_multi__done' => 'Địa chỉ vừa được gỡ bỏ khỏi danh sách thư rác trên toàn máy chủ.',
    'ui__server/spam-filter/black-list/address/properties_new__done' => 'Địa chỉ đã được thêm vào danh sách thư rác.',
    'ui__server/spam-filter/black-list/address__done' => 'Địa chỉ đã được thêm vào danh sách thư rác.',
    'ui__server/spam-filter/black-list__done' => 'Hoạt động đã hoàn tất thành công.', // PFU
    'ui__server/spam-filter/properties__done' => 'Thiết lập bộ lọc thư rác đã được thay đổi.',
    'ui__server/spam-filter/toggle_disable__done' => 'Bộ lọc thư rác đã được vô hiệu hóa trên toàn hệ thống.',
    'ui__server/spam-filter/toggle_enable__done' => 'Bộ lọc thư rác vừa được kích trên toàn hệ thống.',
    'ui__server/spam-filter/white-list/address/delete__done' => 'Địa chỉ %1 vừa được gỡ bỏ khỏi danh sách thư sạch trên toàn máy chủ.',
    'ui__server/spam-filter/white-list/address/delete_multi__done' => 'Địa chỉ vừa được gỡ bỏ khỏi danh sách thư sạch trên toàn máy chủ.',
    'ui__server/spam-filter/white-list/address/properties_new__done' => 'Địa chỉ đã được thêm vào danh sách thư sạch.',
    'ui__server/spam-filter/white-list/address__done' => 'Địa chỉ đã được thêm vào danh sách thư sạch.',
    'ui__server/spam-filter/white-list__done' => 'Hoạt động đã hoàn tất thành công.', // PFU
    'ui__server/spam-filter__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/statistics__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__server/time__done' => "Ngày giờ hệ thống đã được thay đổi.",
    'ui__server__done' => "Hoạt động đã hoàn tất thành công.",
    'ui__sessions/properties__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__sessions__done' => 'Hoạt động đã hoàn tất thành công.',
    'ui__sessions/delete__done' => 'Phiên kết nối được chọn đã được xóa.',
    'ui__support__done' => 'Yêu cầu hỗ trợ đã được mở trong một cửa sổ hoặc thẻ riêng của trình duyệt.',

    ///
    /// END OF DONE MESSAGES
    ///

    ///
    /// ASSORTED COMMON KEYS / TBI
    ///

    // non-UI
    '__no_files_to_upload' => 'Không có tập tin để đăng tải.',
    'login_up__access_denied_no_permission' => "Truy cập bị từ chối. Bạn không có quyền đăng nhập.",
    'mail__unable_remove_pattern' => "Không thể gỡ bỏ địa chỉ khỏi danh sách thư rác của máy chủ: %1", // PFW
    'mail__incorrect_network_format' => 'Dạng thức mạng không đúng: %1', // PFW
    'initconf__unable_change_passwd' => "Không thể thay đổi mật khẩu của người quản trị. %1",
    'initconf__unable_get_passwd' => 'Không thể lấy mật khẩu quản trị viên hiện tại: %1 không thành công: %2',
    'initconf__invalid_hostname' => 'Lỗi ở tên host “%1”',
    'initconf__unable_reconfig' => 'Không thể cấu hình Plesk: không cấu hình lại được: %1',
    'initconf__unable_update_admin' => 'Không thể cập nhật thông tin liên hệ quản trị viên: %1',
    '__refresh' => 'Cập nhật mới',
    '__dalias_not_exist' => 'Bí danh tên miền không tồn tại.',
    '__bug146523_explanation' => 'Các phiên bản trước của Plesk cho phép sử dụng đến 16 ký tự cho tên người dùng FTP. Phiên bản Plesk này giới hạn số lượng ký tự tối đa cho phép trong tên người dùng FTP là 15. Để giải quyết vấn đề này, giảm độ dài tên người dùng FTP xuống 15 ký tự đối với những tên người dùng FTP bị ảnh hưởng và thay đổi ít nhất một ký tự trong tên người dùng FTP bị ảnh hưởng để tránh các vấn đề xung đột tên người dùng. Chúng tôi lấy làm tiếc vì sự bất tiện có thể gây ra bởi sự thay đổi này.',
    'domain__cannot_change_webmail' => 'Không thể thay đổi Trình Quản lý thư trực tuyến cho tên miền: %1',
    'sb_publish_disable_warning' => 'Nếu bạn tắt phần tạo website bằng Presence Builder, website đã được tạo trước đó trong Presence Builder sẽ bị gỡ bỏ và tất cả các dữ liệu website sẽ bị mất. Nhấp Đồng ý nếu bạn muốn tiếp tục.',
    '__sbnet_client_use_sbnet' => "Tạo tài khoản người dùng tương ứng trong Presence Builder",
    'mail_resp_activate' => 'Kích hoạt tính năng tự trả lời',
    'limitsManger__limit_available_error' => 'Không thể phân bổ mức tài nguyên yêu cầu ("%%limitName%%"): chỉ có %%available%% cho tài khoản của bạn.',
    'limitsManger__limit_reserved_error' => 'Không thể phân bổ tài nguyên ít hơn ("%%limitName%%") so với mức đã sử dụng.',
    'domain__unable_to_rename_vhost_dir_already_exists' => 'Không thể đổi tên của miền: Kho chứa ảo có tên này đã tồn tại.',
    'domain_unable_to_rename' => 'Không thể đổi tên của miền.',

    // Greylisting
    'spamfilter__general_settings_legend' => 'Tổng quan',
    'spamfilter__spamassassin_status_legend' => 'Lọc thư rác SpamAssassin',
    'spamfilter__spamassassin_settings_legend' => 'Cấu hình SpamAssassin',
    'spamfilter__spamassassin_server_status_legend' =>  "Bật tính năng lọc thư rác trên toàn máy chủ SpamAssassin",
    'spamfilter__spamassassin_user_status_legend' => 'Bật lọc chống thư rác SpamAssassin',
    'spamfilter__greylisting_status_legend' => 'Bật bảo vệ chống thư rác trên toàn máy chủ',
    'spamfilter__personal_settings_not_allowed' => 'Việc sử dụng cấu hình lọc thư rác cá nhân không được cho phép bởi chính sách hệ thống.',
    'spamfilter__required_score' => 'Điểm số chỉ ra một thông điệp hội đủ điều kiện để nhận biết là thư rác',
    'spamfilter__rewrite_header_subject' => 'Thêm văn bản sau vào đầu của mỗi chủ đề thông điệp được nhận biết là thư rác',
    'spamfilter__use_mailuser_prefs' => 'Áp dụng các thiết lập riêng để lọc thư rác',
    'spamfilter__score_error' => 'Điểm số không được âm, phần đứng trước dấu chấm thập phân phải nhỏ hơn 100, và có thể có nhiều hơn hai chữ số đằng sau dấu thập phân.',
    'spamfilter__rewrite_header_error' => 'Chủ đề tin nhắn có thể chứa các ký tự in được, trừ ký tự chỉ số (#).',

    // template conflict keys
    'nonexistent_mail__mode_bounce' => 'Trả về',
    'nonexistent_mail__mode_discard' => 'Hủy bỏ',
    'nonexistent_mail__mode_catch_addr' => 'Chuyển tiếp đến địa chỉ email',
    'nonexistent_mail__mode_catch_ip' => 'Chuyển tiếp đến địa chỉ IP',
    'nonexistent_mail__bounce_not_supported' => 'Chế độ trả về không được hỗ trợ',
    'nonexistent_mail__discard_not_supported' => 'Chế độ hủy bỏ không được hỗ trợ',
    'nonexistent_mail__catch_not_supported' => 'Chuyển tiếp đến địa chỉ email không được hỗ trợ',
    'nonexistent_mail__redirect_not_supported' => 'Việc chuyển tiếp đến địa chỉ IP không được hỗ trợ',
    'nonexistent_mail__ip_used_on_this_host' => 'Địa chỉ IP phân giải sang máy cục bộ',
    'nonexistent_mail_address_should_be_local_domain' => 'Do quản lý thư gửi đi được bật, địa chỉ email %1 cho người nhận không tồn tại phải thuộc về tên miền được chọn. Nếu không, thì chính sách "Từ chối" sẽ được áp dụng thay vì chuyển tiếp.',
    'nonexistent_mail_address_should_be_local_domain_not_restricted' => 'Do quản lý thư gửi đi được bật, địa chỉ email được chỉ định cho chuyển tiếp thư (%1) phải thuộc về tên miền được chọn. Nếu không, tin nhắn gửi đến địa chỉ này sẽ không được tính vào Quản lý thư gửi đi.',
    // mail acc extras
    '__antivirus' => "Chống virus",

    // web apps

    // none available
    'ui__admin-alias__none-available' => 'Không có tài khoản quản trị bổ sung nào có thể được dùng.', // PFW
    'ui__client/domain/certificate__none-available' => 'Khách hàng không có chứng nhận SSL/TLS.',
    'ui__client/domain/certificate__none-available__1' => 'Khách hàng không có các miền có giấy chứng nhận SSL/TLS.',
    'ui__client/domain/certificate__none-available__2' => 'Miền không có chứng nhận SSL/TLS.',
    'ui__reseller/client__none-available' => 'Không có tài khoản đại lý có khách hàng.',

    // empty selection for lists
    'ui__client/ipaddress/delete__empty_selection' => 'Bạn phải chọn địa chỉ IP muốn gỡ bỏ khỏi kho IP.',
    'ui__server/ip-address/client/delete__empty_selection' => 'Bạn phải chọn tài khoản đại lý sở hữu kho IP mà bạn muốn gỡ bỏ địa chỉ IP',
    'ui__server/crontab/task/delete__empty_selection' => 'Bạn phải chọn tác vụ được lập lịch muốn hủy bỏ.',

    // scripting languages errors
    'phosting__php_not_enabled' => 'Hỗ trợ PHP đã bị tắt đối với trang web này.',
    'phosting__aspdotnet_not_enabled' => 'Hỗ trợ ASP.NET đã bị tắt với website này.',
    'phosting__php_forced_by_site_isolation' => 'Không thể thay đổi cài đặt PHP: không được cấp quyền ghi đè lên chính sách bảo mật trên toàn máy chủ.',
    'phosting__option_forced_by_site_isolation' => 'Không thể thay đổi cài đặt %1: không được cấp quyền ghi đè lên chính sách bảo mật trên toàn máy chủ.',
    'phosting__php_handler_id_not_registered' => 'Bộ quản lý PHP không được cho phép trong cài đặt cách biệt trang. Bộ quản lý PHP mặc định sẽ được sử dụng.',
    'phosting__php_served_by_nginx_is_not_available' => 'Bộ xử lý PHP (ứng dụng FPM do nginx cung cấp) không được cho phép trong cài đặt cô lập trang. Bộ xử lý PHP mặc định sẽ được sử dụng.',

    // various UI
    'ui__client/ipaddress/properties_readonly__short-title' => 'Xem danh sách địa chỉ IP',
    'ui__client/ipaddress/properties_readonly__title' => 'Xem danh sách địa chỉ IP',
    'ui__client/ipaddress/properties_readonly__description' => 'Xem danh sách địa chỉ IP sẵn sàng cho người dùng này.',
    'ui__server/certificate__short-title' => 'Chứng nhận SSL/TLS',
    'ui__server/certificate__title' => 'Chứng nhận SSL/TLS',
    'ui__server/certificate__description' => 'Xem và quản lý chứng nhận SSL/TLS.',

    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__short-title' => 'Gỡ bỏ các kiểu MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__title' => 'Gỡ bỏ các kiểu MIME',
    'ui__client/domain/hosting/web-directories/mime-type/delete_multi__description' => 'Gỡ bỏ những kiểu MIME được chọn.',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__short-title' => 'Thêm kiểu MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__title' => 'Thêm loại MIME',
    'ui__client/domain/hosting/web-directories/mime-type/properties_unknown-new__description' => 'Đăng ký loại MIME.',

    'ui__client/ipaddress/delete_multi__wizard-title' => 'Gỡ bỏ địa chỉ IP',
    'ui__client/ipaddress/delete_multi__wizard__2_multi' => 'Chọn địa chỉ IP muốn gỡ bỏ khỏi kho IP của khách hàng %1',

    // mail

    'ui__client/ipaddress__short-title' => 'Địa chỉ IP',
    'ui__client/ipaddress__title' => 'Địa chỉ IP',
    'ui__client/ipaddress__description' => 'Xem thông tin về địa chỉ IP.',
    'ui__server/ip-address__short-title' => 'Địa chỉ IP',
    'ui__server/ip-address__title' => 'Địa chỉ IP',
    'ui__server/ip-address__description' => 'Xem thông tin về địa chỉ IP.',
    'ui__client/domain/hosting/setup__short-title' => 'Thiết lập vùng lưu trữ Web',
    'ui__client/domain/hosting/setup__title' => 'Thiết lập vùng lưu trữ Web',
    'ui__client/domain/hosting/setup__description' => 'Khởi tạo thiết lập vùng lưu trữ web cho tên miền %1.',
    'ui__client/domain/hosting/web-directories/mime-type/properties__short-title' => 'Kiểu MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__title' => 'Thuộc tính Kiểu MIME', // PFW
    'ui__client/domain/hosting/web-directories/mime-type/properties__description' => 'Xem thuộc tính của kiểu MIME.', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__short-title' => 'Tài liệu báo lỗi', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__title' => 'Tài liệu báo lỗi', // PFW
    'ui__client/domain/hosting/web-directories/error-doc/properties__description' => 'Thuộc tính tài liệu báo lỗi.', // PFW

    // tooltips

    'b_get_password_cancel' => 'Trở lại màn hình trước mà không gửi email.',
    'b_get_password_send' => 'Nhấp Đồng ý để gửi tin nhắn phục hồi mật khẩu đến địa chỉ email đã đăng ký trong hệ thống.',



    'b_personaltrafficlist_search' => 'Nhập mô hình tìm kiếm và bấm vào để tìm tên miền.',
    'b_personaltrafficlist_show_all' => 'Hiển thị tất cả các tên miền.',

    'b_back' => 'Trở về trang trước.',
    'b_next' => 'Đến trang tiếp theo.',

    'b_dnsnstemplatelist_remove' => 'Xóa máy chủ tên miền được chọn.',
    'b_dnsnstemplatelist_search' => 'Nhập mô hình tìm kiếm và bấm vào để tìm máy chủ tên miền.',
    'b_dnsnstemplatelist_show_all' => 'Hiển thị tất cả các máy chủ tên miền.',

    'l_dnsnstemplatelist_ns' => 'Sắp xếp hồ sơ mẫu DNS theo tên máy chủ.',

    // filesharing management tool
    'cu__serverfilesharing_fsLinksAsHttps' => 'Tạo đường dẫn bảo đảm đến các tập tin và thư mục',
    'cu__serverfilesharing_fsPublicFolderEnabled' => 'Kích hoạt tệp công cộng',
    'cu__serverfilesharing_fsPublicFolder' => 'Thư mục để lưu trữ các tệp công cộng',
    'cu__serverfilesharing_fsPublicUrl' => 'URL để khách thăm truy cập tệp công cộng',
    'cu__serverfilesharing_fsPartnerFolderEnabled' => 'Kích hoạt bảo vệ mật khẩu cho các tệp công cộng',
    'cu__serverfilesharing_fsPartnerFolder' => 'Thư mục để lưu trữ các tập tin được bảo vệ bằng mật khẩu',
    'cu__serverfilesharing_fsPartnersLogin' => 'Tên người dùng để truy cập tập tin',
    'cu__serverfilesharing_fsPartnersPassword' => 'Mật khẩu để truy cập tập tin',
    'cu__serverfilesharing_fsDomain' => 'URL gốc thư mục web. Tên miền',
    'cu__serverfilesharing_fsPrefix' => 'URL gốc thư mục web. Tiền tố',
    'cu__serverfilesharing_commandUpdate' => 'Cập nhật cài đặt chia sẻ tập tin',
    'cu__serverfilesharing_commandInfo' => 'Hiển thị cài đặt chia sẻ tập tin hiện tại',
    'subscription_rename_is_forbidden' => 'Đổi tên thuê bao bị cấm theo chính sách trên toàn máy chủ.',
    ///
    /// END OF RANDOM COMMON KEYS
    ///

    ////
    //// CRONTAB - temporary
    ////

    // wizard:

    'ui__server/crontab/task_unknown__wizard-title' => 'Quản lý các tác vụ được lập lịch trên máy chủ',
    'ui__server/crontab/task_unknown__wizard__2_unknown' => 'Chọn tài khoản người dùng hệ thống sở hữu tác vụ được lập lịch mà bạn muốn quản lý.',

    'ui__server/crontab/task__short-title' => '%1',
    'ui__server/crontab/task__title' => 'Tác vụ được lập lịch %1',
    'ui__server/crontab/task__description' => 'Xem thuộc tính của tác vụ được lập lịch %1.',

    ///
    /// SERVER
    ///

    'ui__server/crontab_unknown__short-title' => 'Người dùng hệ thống',
    'ui__server/crontab_unknown__title' => 'Người dùng hệ thống',
    'ui__server/crontab_unknown__description' => 'Người dùng hệ thống có thể là chủ sở hữu các tác vụ được lập lịch.',


    'ui__server/crontab__none-available' => 'Bạn không có tài khoản người dùng hệ thống.',
    'ui__server/crontab_readonly-unknown__description' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab_readonly-unknown__short-title' => 'Các Tác vụ lập lịch',
    'ui__server/crontab_readonly-unknown__title' => 'Xem tác vụ được lập lịch',
    'ui__server/crontab_readonly-unknown__wizard-title' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab_readonly__description' => 'Xem tác vụ được lập lịch của %1.',
    'ui__server/crontab_readonly__short-title' => 'Tác vụ được lập lịch của %1',
    'ui__server/crontab_readonly__title' => 'Xem tác vụ được lập lịch của %1',
    'ui__server/crontab_unknown__wizard-title' => 'Quản lý tác vụ được lập lịch.',

    'ui__server/crontab/properties__description' => 'Chỉnh sửa tác vụ được lập lịch của %1.',

    'ui__server/crontab/properties__short-title' => 'Cài đặt',
    'ui__server/crontab/properties__title' => 'Chỉnh sửa tác vụ được lập lịch của %1',
    'ui__server/crontab/properties_readonly-unknown__description' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab/properties_readonly-unknown__short-title' => 'Cài đặt',
    'ui__server/crontab/properties_readonly-unknown__title' => 'Xem tác vụ được lập lịch',
    'ui__server/crontab/properties_readonly-unknown__wizard-title' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab/properties_readonly__description' => 'Xem tác vụ được lập lịch của %1.',
    'ui__server/crontab/properties_readonly__short-title' => 'Cài đặt',
    'ui__server/crontab/properties_readonly__title' => 'Xem tác vụ được lập lịch của %1',
    'ui__server/crontab/properties_unknown__description' => 'Chỉnh sửa tác vụ được lập lịch.',
    'ui__server/crontab/properties_unknown__short-title' => 'Thuộc tính',
    'ui__server/crontab/properties_unknown__title' => 'Chỉnh sửa tác vụ được lập lịch',
    'ui__server/crontab/properties_unknown__wizard-title' => 'Chỉnh sửa tác vụ được lập lịch.',
    'ui__server/crontab/properties_unknown__wizard__2_readonly-unknown' => 'Chọn người dùng hệ thống sở hữu các tác vụ mà bạn muốn xem.',
    'ui__server/crontab/properties_unknown__wizard__2_unknown' => 'Chọn người dùng hệ thống sở hữu các tác vụ mà bạn muốn thay đổi.',
    'ui__server/crontab/properties_unknown__wizard__3' => 'Nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',
    'ui__server/crontab/properties_unknown__wizard__3_readonly' => 'Nhấn Hoàn tất để thoát khỏi trình thuật sĩ.',

    'ui__server/crontab/task__none-available' => 'Bạn không có tác vụ được lập lịch nào.',
    'ui__server/crontab/task__none-available__2' => 'Người dùng hệ thống %1 không có bất kỳ tác vụ được lập lịch nào.',
    'ui__server/crontab/task_readonly-unknown__description' => 'Tác vụ được lập lịch.',
    'ui__server/crontab/task_readonly-unknown__short-title' => 'Tác vụ',
    'ui__server/crontab/task_readonly-unknown__title' => 'Các Tác vụ lập lịch',

    'ui__server/crontab/task/delete__description' => 'Gỡ bỏ tác vụ được lập lịch %1',

    'ui__server/crontab/task/delete__short-title' => 'Gỡ bỏ',
    'ui__server/crontab/task/delete__title' => 'Gỡ bỏ tác vụ được lập lịch %1',
    'ui__server/crontab/task/delete_multi__description' => 'Gỡ bỏ tác vụ được lập lịch.',

    'ui__server/crontab/task/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__server/crontab/task/delete_multi__title' => 'Gỡ bỏ tác vụ được lập lịch',
    'ui__server/crontab/task/delete_multi__wizard-title' => 'Gỡ bỏ tác vụ được lập lịch.',
    'ui__server/crontab/task/delete_multi__wizard__2_unknown' => 'Chọn người dùng hệ thống sở hữu tác vụ mà bạn muốn gỡ bỏ.',
    'ui__server/crontab/task/delete_multi__wizard__3_multi' => 'Chọn các tác vụ mà bạn muốn gỡ bỏ.',
    'ui__server/crontab/task/delete_multi__wizard__4_multi' => 'Xác nhận việc gỡ bỏ tác vụ bằng cách đánh dấu kiểm vào ô tương ứng và nhấn Hoàn tất để hoàn tất.',
    'ui__server/crontab/task/delete_unknown__description' => 'Gỡ bỏ một tác vụ được lập lịch.',
    'ui__server/crontab/task/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__server/crontab/task/delete_unknown__title' => 'Gỡ bỏ một tác vụ được lập lịch',
    'ui__server/crontab/task/delete_unknown__wizard-title' => 'Gỡ bỏ một tác vụ được lập lịch.',
    'ui__server/crontab/task/delete_unknown__wizard__2_unknown' => 'Chọn người dùng hệ thống sở hữu tác vụ mà bạn muốn gỡ bỏ.',
    'ui__server/crontab/task/delete_unknown__wizard__3_unknown' => 'Chọn tác vụ mà bạn muốn gỡ bỏ.',
    'ui__server/crontab/task/delete_unknown__wizard__4' => 'Xác nhận việc gỡ bỏ tác vụ bằng cách đánh dấu kiểm vào ô tương ứng và nhấn Hoàn tất để hoàn tất.',

    'ui__server/crontab/task/properties__description' => 'Chỉnh sửa tác vụ được lập lịch.',

    'ui__server/crontab/task/properties__short-title' => 'Chỉnh sửa tác vụ %1',
    'ui__server/crontab/task/properties__title' => 'Chỉnh sửa tác vụ được lập lịch',
    'ui__server/crontab/task/properties_new__description' => 'Tạo tác vụ lập lịch cho %1.',

    'ui__server/crontab/task/properties_new__short-title' => 'Thêm tác vụ',
    'ui__server/crontab/task/properties_new__title' => 'Tạo tác vụ lập lịch cho %1',
    'ui__server/crontab/task/properties_new__wizard-title' => 'Tạo tác vụ lập lịch.',
    'ui__server/crontab/task/properties_new__wizard__2_unknown' => 'Chọn người dùng hệ thống mà bạn muốn tạo tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_new__wizard__4_new' => 'Nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',
    'ui__server/crontab/task/properties_readonly-unknown__description' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_readonly-unknown__short-title' => 'Thuộc tính',
    'ui__server/crontab/task/properties_readonly-unknown__title' => 'Xem tác vụ được lập lịch',
    'ui__server/crontab/task/properties_readonly-unknown__wizard-title' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_readonly__description' => 'Xem tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_readonly__short-title' => 'Xem tác vụ %1',
    'ui__server/crontab/task/properties_readonly__title' => 'Xem tác vụ được lập lịch',
    'ui__server/crontab/task/properties_unknown-new__description' => 'Tạo tác vụ lập lịch.',
    'ui__server/crontab/task/properties_unknown-new__short-title' => 'Thêm tác vụ',
    'ui__server/crontab/task/properties_unknown-new__title' => 'Tạo tác vụ lập lịch.',
    'ui__server/crontab/task/properties_unknown__description' => 'Chỉnh sửa tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_unknown__short-title' => 'Thuộc tính',
    'ui__server/crontab/task/properties_unknown__title' => 'Chỉnh sửa tác vụ được lập lịch',
    'ui__server/crontab/task/properties_unknown__wizard-title' => 'Chỉnh sửa tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_unknown__wizard__2_readonly-unknown' => 'Chọn người dùng hệ thống sở hữu các tác vụ mà bạn muốn xem.',
    'ui__server/crontab/task/properties_unknown__wizard__2_unknown' => 'Chọn người dùng hệ thống sở hữu các tác vụ mà bạn muốn thay đổi.',
    'ui__server/crontab/task/properties_unknown__wizard__3_readonly-unknown' => 'Chọn tác vụ được lập lịch.',
    'ui__server/crontab/task/properties_unknown__wizard__3_unknown' => 'Chọn tác vụ được lập lịch mà bạn muốn thay đổi.',
    'ui__server/crontab/task/properties_unknown__wizard__4' => 'Nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',
    'ui__server/crontab/task/properties_unknown__wizard__4_readonly' => 'Nhấn Hoàn tất để thoát khỏi trình thuật sĩ.',

    'ui__server/crontab/task/toggle_disable__description' => 'Vô hiệu hóa tác vụ được lập lịch %1.',

    'ui__server/crontab/task/toggle_disable__short-title' => 'Tắt',
    'ui__server/crontab/task/toggle_disable__title' => 'Vô hiệu hóa tác vụ được lập lịch %1',
    'ui__server/crontab/task/toggle_enable__description' => 'Kích hoạt tác vụ được lập lịch %1.',

    'ui__server/crontab/task/toggle_enable__short-title' => 'Bật',
    'ui__server/crontab/task/toggle_enable__title' => 'Kích hoạt tác vụ được lập lịch %1',
    'ui__server/crontab/task/toggle_unknown__description' => 'Kích hoạt hoặc vô hiệu hóa tác vụ được lập lịch.',
    'ui__server/crontab/task/toggle_unknown__short-title' => 'Kích hoạt hoặc vô hiệu hóa',
    'ui__server/crontab/task/toggle_unknown__title' => 'Kích hoạt hoặc vô hiệu hóa tác vụ được lập lịch',
    'ui__server/crontab/task/toggle_unknown__wizard-title' => 'Kích hoạt hoặc vô hiệu hóa tác vụ được lập lịch',
    'ui__server/crontab/task/toggle_unknown__wizard__2_unknown' => 'Chọn tài khoản người dùng hệ thống sở hữu tác vụ mà bạn muốn kích hoạt hoặc vô hiệu hóa.',
    'ui__server/crontab/task/toggle_unknown__wizard__3_unknown' => 'Chọn tác vụ mà bạn muốn kích hoạt hoặc vô hiệu hóa.',


    /// not used on HP:

    'ui__client_unknown__short-title' => 'Tài khoản khách hàng', // not used on HP?
    'ui__client_unknown__title' => 'Tài khoản khách hàng', // not used on HP?
    'ui__client_unknown__description' => 'Quản lý tài khoản của khách hàng.', // not used on HP?
    'ui__client/domain/disable_unknown__title' => 'Tạm dừng tên miền', // not used on HP
    'ui__client/domain/disable_unknown__short-title' => 'Tạm dừng tên miền', // not used on HP,
    'ui__client/domain/disable_unknown__description' => 'Tạm dừng một tên miền.', // not used on HP
    'ui__client/domain/enable_unknown__title' => 'Kích hoạt tên miền', // not used on HP
    'ui__client/domain/enable_unknown__short-title' => 'Kích hoạt tên miền', // not used on HP
    'ui__client/domain/enable_unknown__description' => 'Kích hoạt một tên miền.', // not used on HP

    //Additional FTP Accounts
    'ftp__management_domain' => "Tài khoản FTP theo tên miền %1", // for Additional FTP Accounts
    '__ftp_users_list' => "Tài khoản FTP",
    'ftp__user_name' => "Tên tài khoản FTP",
    'ftp__user_home' => "Thư mục chủ",
    'ftp__invalid_path' => "Đường dẫn được chỉ định không hợp lệ",
    'i_ftp_ses_sub_user' => 'Phiên của tài khoản FTP.',
    '__new_passwd' => "Mật khẩu mới %1",

    ////
    //// Errors with custom template of Apache configuration
    ////

    'apacheConfigurationFailedMessageSubject' => 'Không thể cấu hình một máy chủ web trên bộ lưu trữ <%%host%%>',
    'apacheConfigurationFailedMessageBody' => "Không thể tạo tập tin cấu hình máy chủ web trên bộ lưu trữ <%%host%%>vì các lỗi sau:\n\n%%error%%\n\nVui lòng xử lý các lỗi trong các biểu mẫu cấu hình máy chủ web và tạo lại tập tin.",

    'apacheConfigurationMessageAdminTitle' => 'Không tạo được cấu hình cho máy chủ web',
    'apacheConfigurationMessageClientTitle' => 'Cảnh báo',

    'apacheConfigurationFailedAdminHomeMessage' => 'Tập tin cấu hình mới không được thiết lập do lỗi trong các biểu mẫu cấu hình. Tin nhắn lỗi chi tiết đã được gửi đến email của bạn, vui lòng kiểm tra email, sửa lỗi, và nhấp %1 để thử tạo cấu hình lại.',
    'apacheConfigurationFailedAdminHomeMessageLink' => 'tại đây', //used on linked text in apacheConfigurationFailedAdminHomeMessage
    'apacheConfigurationFailedAdminDomainMessage' =>  'Cấu hình mới cho miền %1 không được thiết lập do lỗi trong các biểu mẫu cấu hình. Tin nhắn lỗi chi tiết đã được gửi đến email của bạn, vui lòng kiểm tra email, sửa lỗi, và nhấp %2 để thử tạo cấu hình lại.',
    'apacheConfigurationFailedAdminDomainMessageLink' => 'tại đây', //used on linked text in apacheConfigurationFailedAdminDomainMessage

    'apacheConfigurationFailedUserDomainMessage' => 'Cấu hình máy chủ web cho tên miền %1 có thể không phù hợp. Xin vui lòng liên hệ với quản trị máy chủ để giải quyết vấn đề.',

    'apacheConfigurationFailedAdminDomainsMessage' => 'Cấu hình mới cho một số miền không được thiết lập do lỗi trong các biểu mẫu cấu hình. Tin nhắn lỗi chi tiết đã được gửi đến email của bạn, vui lòng kiểm tra email, sửa lỗi, và nhấp %1 để thử tạo cấu hình lại.',
    'apacheConfigurationFailedAdminDomainsMessageLink' => 'tại đây', //used on linked text in apacheConfigurationFailedAdminDomainsMessage

    'apacheConfigurationFailedUserDomainsMessage' => 'Cấu hình máy chủ web cho một số tên miền có thể không nhất quán. Xin vui lòng liên hệ với quản trị máy chủ để giải quyết vấn đề.',



    ///HOSTING PARAMETERS
    '__apache_errdocs' => "Tài liệu báo lỗi tùy biến",
    'dom_pref__webusers_script' => "Cho phép người dùng web sử dụng scripts",
    '__seoRedirect' => 'Cấu hình miền tùy chọn theo',
    '__seoRedirectToLanding' => 'domain.tld',
    '__seoRedirectToWww' => 'www.domain.tld',
    '__seoRedirectNone' => 'Không',

    '__sites' => 'Các tên miền',
    'domain_plan__perm_denied_manage_phosting' => 'Bạn không có quyền quản lý thiết lập lưu trữ.',
    '__owned_by_client' => 'thuộc về khách hàng',
    'ui__client/permissions_readonly__description' => "Xem các hành động mà khách hàng %1 có thể thực hiện trong Plesk.",
    'backup__restore__object_client_template' => 'Mẫu khách hàng',
    '__template_name' => 'Tên gói dịch vụ máy chủ',
    'template__not_exists' => 'Không có gói dịch vụ nào như vậy',
    'template__exists' => 'Gói dịch vụ có tên %1 đã tồn tại.',
    'clientOwnerChanger__ip_not_in_pool' => 'Địa chỉ IP đã chỉ định không có trong dãy của đại lý.',

    //// Change owner of subscription
    'chown__select_title' => "Chọn thuê bao khách hàng mới",
    'ui__client/domain/chowner_multi__wizard__3_multi-select' => 'Chọn một chủ sở hữu mới cho các thuê bao được chọn và nhấn Tiếp tục >>.',
    'domains__client_info' => "%1 thuê bao, %2 thuê bao hoạt động, %3 dung lượng được sử dụng, %4 lưu lượng truy cập được sử dụng",
    '__possible_owners' => 'Chủ sở hữu tiềm năng mới của các thuê bao',

    'clients_list__filter_owner__filter_title' => 'Nhà cung cấp',
    'clients_list__filter_owner_any' => 'Tất cả người dùng',
    'clients_list__filter_owner_my' => 'Chỉ có các thuê bao khách hàng của tôi',
    'clients_list__filter_owner_name__filter_title' => 'Tên nhà cung cấp',

    '__owner' => "Nhà cung cấp",
    'l_clientslist_owner' => 'Sắp xếp tài khoản khách hàng theo nhà cung cấp',
    'l_clientslist_date' => 'Sắp xếp tài khoản khách hàng theo ngày.',
    'l_clientslist_name' => 'Sắp xếp tài khoản khách hàng theo tên.',
    'l_clientslist_domains' => 'Sắp xếp tài khoản khách hàng theo tên miền.',
    'l_clientslist_cname' => 'Sắp xếp tài khoản khách hàng theo tên công ty.',

    'ui__client/domain/chowner_multi__wizard-title' => 'Gán lại cho thuê bao được chọn',
    'chown__check_title' => 'Thay đổi người thuê bao',

    'ui__client/domain/chowner_multi__wizard__3_multi' => "Nhấn Kết thúc để hoàn thành việc gán lại. Sua khi hoàn tất, những thuê bao được chọn sẽ được gán cho chủ sở hữu mới, nhà cung cấp của chúng sẽ thay đổi thành của chủ mới, và chúng sẽ được giải phóng khỏi gói dịch vụ của chúng và trở thành 'Tùy biến'.",

    'chown__error_check' => 'Gặp phải một số vấn đề khi chuyển thuê bao đến chủ sở hữu mới.',
    'domain_chown_subscription_will_be_anonymous' => "Thuê bao sẽ được gỡ ràng buộc khỏi các gói dịch vụ hiện tại của mình và trở thành 'Tùy biến'.",
    'chown__error_domains_exclude' => "Gặp phải một số vấn đề khi chuyển tên miền đến thuê bao mới. Những thuê bao này đã được tô sáng.",
    'chown__ip_not_in_client_pool' => "Địa chỉ IP liên kết với tên thuê bao này không được gán tới dải IP của chủ sở hữu mới.",
    'chown__already_owned_by_client' => "Thuê bao này đã thuộc về người dùng này rồi.",

    '__redirect_hint' => 'Bạn sẽ được chuyển đến địa chỉ mới trong 15 giây... Nếu bạn không tự động được đưa đến địa chỉ mới, hãy kích hoạt javascript hoặc nhấn vào liên kết %%link%%.',

    'backup__restore__object_maillist' => 'Danh sách gửi thư',
    'backup__restore__object_site' => 'Trang',
    'backup__restore__object_user' => 'Người dùng',
    'backup__restore__object_role' => 'Vai trò',

    'limit__name_max_site' => 'trang',

    'iis_pool__unable_rename_client' => "không thể đổi tên Kho ứng dụng IIS: %1.",

    'anonftp__is_not_supported_for_addon_domains' => 'Dịch vụ FTP ẩn danh chỉ được hỗ trợ cho tên miền chính của một thuê bao.',
    'anonftp__is_not_supported_for_addon_domains_powerUser' => 'Dịch vụ FTP ẩn danh được hỗ trợ chỉ cho miền chính của thuê bao.',

    '__gb' => 'GB',
    '__tb' => 'TB',
    '__gb_month' => 'GB/tháng',
    '__tb_month' => 'TB/tháng',

    '__customers' => 'Khách hàng',
    '__customer_name' => 'Tên khách hàng',
    '__customer_total' => 'Tổng số khách hàng',
    '__site' => 'Trang',
    '__def_site' => 'Trang mặc định',
    '__subscription_name' => 'Tên thuê bao',
    '__subscription_name_powerUser' => 'Tên thuê bao',

    'limit__units_max_traffic_suffix' => '/tháng',

    'dom_pref__discard' => "Từ chối",

    'mail__pattern_already_exists' => 'Từ khóa "%1" đã có trong danh sách từ chối.',

    '__not_supported' => 'Không được hỗ trợ',

    'plesk_key__sitebuilder' => 'Các trang được xuất bản bằng Presence Builder',
    'limit__name_max_site_builder' => 'Các trang được xuất bản bằng Presence Builder',
    'plesk_key__wpb-multi-language-sites-support' => 'Hỗ trợ cho các trang đa ngôn ngữ trong Presence Builder',

    'ui__client/domain/traffic-hosting__title' => 'Thống kê truyền tải dữ liệu của <b>%1</b>',
    'ui__client/domain/traffic-hosting__title_powerUser' => 'Thống kê truyền tải dữ liệu của <b>%1</b>',
    'ui__client/domain/traffic-hosting#list__title' => "truyền tải dữ liệu bằng dịch vụ",

    'login_up__access_denied_no_subscriptions' => "Truy cập bị từ chối. Không có thuê bao nào cho tài khoản này.",

    'interval__day' => '%1 ngày',
    'interval__hour' => '%1 giờ',
    'interval__minute' => '%1 phút',
    'interval__second' => '%1 giây',

    ///License options
    'plesk_key__backward_incompatibility' => 'Bạn đang cố sử dụng key bản quyền được tạo cho phiên bản Plesk khác. Hãy liên lạc với đại diện bán hàng Plesk để có được key bản quyền phù hợp.',
    //Standalone or virtualization
    'virtualization_any' => "Máy chủ vật lý hay những giải pháp ảo hóa bất kỳ",
    'virtualization_pvc' => "Bộ chứa Virtuozzo",
    'virtualization_vmware' => "VMWare",
    'virtualization_hyperv' => "Microsoft Hyper-V",
    'virtualization_xen' => "Xen",
    'virtualization_kvm' => "KVM",
    'virtualization_parallels_server' => "Virtuozzo Server",
    'plesk_key__virtualization' => "Hợp lệ cho các môi trường sau đây:",
    'plesk_key__virtualization_only_key' => 'Key bản quyền chỉ định dùng với Plesk vận hành trong một môi trường ảo %1.',
    'plesk_key__virtualizations_only_key' => 'Key bản quyền chỉ định dùng với Plesk vận hành trong các môi trường ảo sau: %1.',
    //Language options
    'plesk_key__invalid_locale_signature' => 'Không được phép sử dụng gói ngôn ngữ tùy biến.',
    'plesk_key__allowed-locales' => 'Ngôn ngữ hiện có',
    'plesk_key__allowed-locales-any' => 'Bất cứ ngôn ngữ nào',

    /// Web hosting settings on domain/subdomain

    '__cgi_bin_mode' => 'thư mục cgi-bin được đặt tại',
    '_cgi_bin_mode_webspace' => 'thư mục gốc của thuê bao',
    '_cgi_bin_mode_www_root' => 'thư mục gốc của tên miền này',

    /// Custom buttons
    'custom_button__sort_key' => 'Ưu tiên',
    'custom_button__place' => 'Vị trí',
    'custom_button__place_navigation' => 'Truy cập thường xuyên',
    'custom_button__place_admin' => 'Trang chủ của quản trị viên',
    'custom_button__place_admin-settings' => 'Công cụ của quản trị viên &amp; Trang cài đặt',
    'custom_button__place_reseller' => "Trang chủ của đại lý",
    'custom_button__place_reseller-settings' => 'Công cụ của đại lý &amp; Trang cài đặt',
    'custom_button__place_client' => 'Trang chủ của khách hàng',
    'custom_button__place_domain' => "Trang thuê bao trang web và tên miền",
    'custom_button__place_domain_powerUser' => "Trang thuê bao trang web và tên miền",
    'custom_button__place_domain-properties' => 'Công cụ website',
    'custom_button__private' => 'Chỉ hiển thị với tôi',
    'custom_button__image' => 'Hình nền',
    'custom_button__conhelp' => "Các thủ thuật trợ giúp",
    'custom_button__edit' => "Thiết lập của một Liên kết đến một Dịch vụ bổ sung",
    'custom_button__include_client_cname' => "Bao gồm tên công ty của khách hàng",
    'custom_button__include_client_email' => "Gồm email của khách hàng",
    'custom_button__include_client_id' => "Bao gồm ID khách hàng",
    'custom_button__include_client_pname' => "Bao gồm tên địa chỉ liên lạc của khách hàng",
    'custom_button__include_domain_id' => "Bao gồm ID thuê bao, ID miền và ID biệt hiệu của miền",
    'custom_button__include_domain_id_powerUser' => "Bao gồm ID thuê bao, ID miền và ID biệt hiệu của miền",

    'custom_button__include_domain_name' => "Bao gồm tên miền chính",
    'custom_button__include_ftp_user' => "Bao gồm tên người dùng FTP",
    'custom_button__include_ftp_pass' => "Bao gồm mật khẩu FTP",
    'custom_button__internal_open' => "Mở URL trong Plesk",
    'custom_button__text' => "Nhãn nút",
    'custom_button__url' => "URL",

    'custom_button__not_image' => 'Tập tin không phải là tập tin ảnh.',
    'custom_button__big_image' => 'Kích thước tập tin không được vượt quá 100 KB.',
    'custom_button__failed_copy_image' => 'Không thể sao chép tập tin: %1',


    'backup__restore__cannot_restore_non_power_user_dump_in_power_user_mode' => 'Không thể khôi phục một bản sao lưu người dùng phụ trong giao diện người dùng chính.',
    '__unknown_network_interface' => 'Giao diện mạng không xác định',

    'init_conf__ip_address' => 'Địa chỉ IP',

    //Confirmation page
    'bt_confirm' => 'Xác nhận',
    'b_confirm' => 'Xác nhận quyền sở hữu trang web của bạn.',

    'performance__iss_app_pool_forced_by_site_isolation' => 'Thiết lập của kho ứng dụng IIS chuyên dụng thiết lập theo các chính sách bảo mật trên toàn máy chủ (cấu hình cô lập trang).',
    'performance__iss_app_pool_forced_by_server_wide_settings' => 'Thiết lập của kho ứng dụng IIS chuyên dụng được lập theo các thiết lập hiệu suất trên toàn máy chủ.',

    '__current' => 'Hiện tại',
    'ui__client/domain/hosting/web-directories/protection/user/properties__done' => 'Thuộc tính người dùng đã được cập nhật.',



    //// New Promos Block

    'promo__you_are_about_to_exceed_license_limit_max_dom' => 'Bạn đã sử dụng hầu hết các miền được cung cấp theo giấy phép Plesk (90% hoặc hơn).',
    'promo__you_are_about_to_exceed_license_limit_max_dom_title' => 'Bạn đã sử dụng hầu hết các miền.',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder' => 'Bạn đã sử dụng hầu hết các trang Presence Builder được cung cấp theo giấy phép Plesk (90% hoặc hơn).',
    'promo__you_are_about_to_exceed_license_limit_max_site_builder_title' => 'Bạn đã sử dụng hầu hết các trang Presence Builder.',
    'promo__button_hide' => 'Ẩn',
    'promo__button_next' => 'Tiếp tục >>',
    'promo__button_prev' => '<< Trước',
    'promo__button_license' => 'Cập nhật bản quyền',

    'promo__google_integration_title' => 'Tích hợp với dịch vụ của Google',
    'promo__google_integration' => 'Cấu hình tích hợp với dịch vụ Google, chẳng hạn như AdSense, Google Apps, các công cụ Quản trị Trang web.',
    'promo__google_integration_button' => 'Cấu hình',

    'promo__button_learn_more' => 'Tìm Hiểu Thêm',

    //// Plesk Branding in 10.1
    'panel_branding__description' => 'Bạn có thể tùy chỉnh bề ngoài giao diện và cài đặt nhãn hiệu bằng các chủ đề tùy chỉnh. Để xem hướng dẫn tùy chỉnh chủ đề Plesk, tham khảo %1.',
    'panel_branding__description_link' => 'tài liệu sau',

    ///// File Manager new buttons
    'bt_extract_archive' => 'Giải nén các tập tin',
    'b_filemanager__extract' => 'Giải nén tập tin từ các tập tin nén được chọn vào thư mục hiện hành. Lưu ý rằng các tên tập tin có thể được hiển thị không đúng cách sau khi giải nén nếu chúng chứa các ký tự quốc gia.',
    'filemanager_error_extracting_files' => 'Một lỗi xảy ra khi giải nén các tập tin nén: %1',
    'filemanager_no_archive_files_specified' => 'Chỉ định những tập tin nén mà bạn muốn giải nén.',
    'filemanager_not_zip_archive_specified' => '%1 không thể được giải nén, nó không phải là một tập tin nén ZIP.',
    'filemanager_files_successfully_extracted' => 'Các tập tin nén đã được giải nén.',
    'filemanager_error_file_download' => 'Quá trình tải tập tin thất bại: %1',
    'filemanager__user_poolgrp' => 'Nhóm dãy ứng dụng',

    'loading' => 'Đang tải...',
    'bt_create_archive' => 'Thêm vào bộ lưu trữ',
    'filemanager__pack' => "Đường dẫn đến bộ lưu trữ: %1",
    'filemanager__archive_name' => 'Tên tập tin lưu trữ',
    'filemanager__empty_filename' => 'Hãy nhập tên tập tin lưu trữ.',
    'filemanager_archive_created' => 'Bộ lưu trữ đã được tạo thành công.',
    'filemanager_error_creating_archive' => 'Không thể tạo bộ lưu trữ: %1',

    'cmd_dns__aaaa_dns_record_already_exist' => "Bản ghi này xung đột các bản ghi AAAA cho phần khu vực.",
    'defaultcomponents__ftp_ipv6_hosting_not_supported' => "(Máy chủ FTP không hỗ trợ địa chỉ IPv6.)",
    'cmd_dns__glue_dns_record_conflict' => 'Bản ghi này sẽ mâu thuẫn với bản ghi phụ cho vùng \'%1\'.',
    '__ftp_ipv6_not_supported' => "(Máy chủ FTP không hỗ trợ địa chỉ IPv6.)",
    '__ipv6_not_supported' => 'IPv6 không được hỗ trợ.',
    'mail__ipv6_not_supported' => 'IPv6 không được hỗ trợ bởi máy chủ thư.',
    'mail__relay_while_list_ipv6_not_supported' => 'Danh sách IPv6 cho phép chuyển mạng không được hỗ trợ bởi máy chủ thư.',
    'mail__relay_while_list_ipv6_mask_mul_16' => 'Giá trị mặt nạ phải là một bội số của 16.',
    'mail__ip_or_mask_is_invalid' => 'Cặp địa chỉ IP/mặt nạ không hợp lệ.',
    'nonexistent_mail__redirect_ipv6_not_supported' => 'Tính năng chuyển tiếp đến địa chỉ IP IPv6 không được hỗ trợ.',
    'sa__invalid_trusted_networks' => 'Mạng tin cậy được chỉ định không chính xác: %1',
    'dns_add__enter_ipv6_address' => "Địa chỉ IPv6",
    'license_trial_days_left' => 'Plesk của bạn đang chạy trên bản quyền dùng thử sẽ hết hạn trong %1 ngày.',
    'excl_ipv6_num' => 'Địa chỉ IPv6 chuyên dụng',
    '__ip_mask' => "Mặt nạ mạng con",
    '__ipv4_addr' => 'Địa chỉ IPv4',
    '__ipv6_addr' => 'Địa chỉ IPv6',
    'template__num_excl_ipv6s' => 'Phân bổ địa chỉ IPv6 chuyên dụng cho đại lý',
    'anonftp__exclusive_ipv4_required' => 'Một địa chỉ IPv4 dành riêng được yêu cầu để thiết lập và sử dụng dịch vụ FTP ẩn danh.',
    'anonftp__ipv4_already_used' => 'Bạn không thể thiết lập dịch vụ FTP ẩn danh cho trang web này bởi vì nó đã được cấu hình trên một tên miền khác trên cùng địa chỉ IPv4.',


    'restart__kav' => "Chống virus Kaspersky",
    '__view_migration_log_detailed_info' => 'Xem nhật ký',

    'chown__ip_address_warn' => 'Trước khi di chuyển thuê bao đến chủ sở hữu mới, bạn phải chọn một địa chỉ IP mới cho thuê bao đó.',
    'chown__no_ip_address' => 'Không',
    'chown__no_ipv4_address' => 'Không có địa chỉ IPv4',
    'chown__no_ipv6_address' => 'Không có địa chỉ IPv6',
    'chown__domain_exclude_already_owned_by_client' => 'Thuê bao %1 đã thuộc về người dùng đó.',
    'chown__error_ip_absent_in_ip_pool' => 'Địa chỉ IP %1 không có trong kho IP của người dùng đích.',
    'chown__error_ip_not_exist' => 'Địa chỉ IP với ID \'%1\' không tồn tại.',
    'chown__error_domain_ip_not_selected' => 'Cần chọn ít nhất một địa chỉ IP cho tên miền %1. Kiểm tra các giá trị được chọn để ánh xạ IP.',

    '__new_passwd_single' => "Mật khẩu",
    '__confirm_passwd_single' => "Xác nhận mật khẩu",

    'mail__ip_or_mask_is_invalid_ipv6' => 'Địa chỉ IPv6 hoặc mặt nạ không hợp lệ: địa chỉ IP phải là một địa chỉ định hướng hợp lệ.',

    '__subscriptions' => 'Thuê bao',

    '__owned_by_reseller' => 'thuộc sở hữu của đại lý',
    '__owned_by_provider' => 'thuộc sở hữu của nhà cung cấp',

    'service_plan__anonymous' => 'Tuỳ biến',
    'subscription_not_locked__change_limits_warning' => 'Thuê bao này không bị khóa: Giới hạn sử dụng tài nguyên sẽ được thay đổi trong quá trình đồng bộ hóa với gói dịch vụ.',
    'subscription_not_locked__change_permissions_warning' => 'Thuê bao này không bị khóa: Quyền hạn sẽ được thay đổi trong quá trình đồng bộ hóa với các gói dịch vụ.',

    'subscription__conflict_resolution_policy' => 'Chính sách giải quyết xung đột',
    'subscription__conflict_resolution_policy_lock' => "Khóa thuê bao",

    'backup__list__backup_warnings' => 'Cảnh báo',
    'backup__list__backup_info' => 'Thông tin',
    'backup__restore__object_reseller_template' => 'Mẫu đại lý',
    'backup__restore__object_domain_template' => 'Mẫu tên miền',

    'ui__client/permissions_readonly__title' => 'Quyền truy cập',
    'ui__client/permissions_readonly__short-title' => 'Quyền truy cập',

    'subscription__unable_lock_anonymous' => 'Thuê bao này không gắn liền với gói dịch vụ, và vì vậy nó không thể được mở khóa.',
    'subscription__unable_sync_anonymous' => 'Thuê bao này không gắn liền với gói dịch vụ, và vì vậy nó không thể được đồng bộ.',
    'subscription__unable_sync_locked' => 'Thuê bao này bị khóa và vì vậy nó không thể được đồng bộ.',
    'subscription__locked' => 'Thuê bao bị khóa.',
    'component_name__urlrewrite' => "Viết lại URL",
    '__quantity' => 'Số lượng',
    'hst__www_root_dir_absent' =>  'Cảnh báo: thư mục được chỉ định làm thư mục gốc không tồn tại.',
    'object_creation__domain_is_not_a_webspace' => 'Đối tượng này chỉ có thể được tạo ra trong thuê bao.',
    'phosting__webspace_hosting_with_sites_cannot_be_deleted' => 'Thuê bao chứa các trang nên bạn không thể thay đổi lưu trữ hoặc xóa bỏ nó.',
    'phosting__addon_domain_ip_must_match_webspace' => 'Lỗi: Không thể cập nhật địa chỉ IP. Các miền bổ sung không thể được gán địa chỉ IP sẽ không được gán cho miền chính của thuê bao.',
    'domain_plan__unable_change' => 'Không thể thay đổi gói dịch vụ: %1.',
    'domain_plan__different_hosting_type' => 'Các loại hình lưu trữ hiện hành khác nhau với các loại quy định trong gói dịch vụ.',
    'domain_plan__addon_text' => 'Gói mở rộng',
    'domain_plan__addon_description' => 'Gói mở rộng được sử dụng để bổ sung cho gói lưu trữ.',
    'asp_net__managed_runtime_version' => 'Phiên bản ASP.NET đã đóng gói được quản lý',
    'plan__can_not_change_hosting_type' => 'Không thể thay đổi loại hình lưu trữ khi chỉnh sửa một gói.',
    'plan__apply_problems' => 'Gói không được áp dụng do những vấn đề về chức năng sau: %1',
    'plan_save__subscription_update_problem' => 'Không thể áp dụng thay đổi gói cho %1.',
    '__perm_denied_subscription_suspended_by_backuprestore' => "Thuê bao bị tạm đình chỉ cho đến khi quá trình sao lưu hoặc khôi phục hoàn tất. Xin vui lòng quay lại sau.",
    '__login_incorrect_plain_shadow_password' => 'Bạn đã nhập một mật khẩu không chính xác cho tài khoản của quản trị viên. Xin vui lòng sử dụng thông tin đăng nhập (gốc) của quả trị hệ thống, hoặc sử dụng mật khẩu chính xác. Để tìm hiểu thêm về việc lấy lại mật khẩu, đọc tập tin /etc/psa/README.psa.shadow.',

    '__perm_denied_ip' => 'Bạn không thể gửi địa chỉ IP không thuộc sở hữu của bạn',

    'dns__dns_zone_not_synchronized' => 'Vùng DNS đã bị thay đổi. Nếu bạn muốn áp dụng các thay đổi biểu mẫu DNS cho vùng này, nhấp vào nút \'Áp dụng Thay đổi biểu mẫu DNS\' trên trang này hoặc đánh dấu tùy chọn \'Áp dụng thay đổi cho tất cả các vùng\' trong Bảng Điều Khiển Quản Trị Máy chủ > Công cụ & Cài đặt > Cài đặt biểu mẫu DNS > Áp dụng thay đổi biểu mẫu DNS.',
    'dns__dns_zone_synchronize_link' => 'Nhấp vào',
    'dns__dns_zone_synchronize_done' => 'Vùng DNS đã được đồng bộ thành công.',

    'dns__dns_zone_template_error' => 'Sự cố xảy ra khi đồng bộ vùng DNS với mẫu vùng DNS.%1',

    'dns__soa_rname_type_owner' => 'Địa chỉ email của chủ sở hữu trang web',
    'dns__soa_rname_type_domain' => 'Địa chỉ email miền',
    'dns__soa_rname_type_external' => 'Địa chỉ email ngoài',
    'dns__soa_rname_enforce_email' => 'Cấm thay đổi địa chỉ email RNAME trên cơ sở từng miền',
    'dns__soa_rname_label' => 'Email (RNAME)',
    'dns__soa_rname_hint' => 'Địa chỉ email của người chịu trách nhiệm về vùng DNS của miền. Máy chủ DNS trả về để đáp ứng với các truy vấn SOA.',

    'dns__dns_zone_soa_sync_title' => 'Ghi đè cài đặt SOA cho tất cả các tên miền hiện có',
    'dns__dns_zone_soa_sync_legend' => 'Yêu cầu xác nhận',
    'dns__dns_zone_soa_sync_text' => 'Cập nhật bản ghi SOA của tất cả các miền được lưu trữ bằng cách áp dụng các thay đổi được thực hiện cho mẫu SOA?',

    'cu_db__repair_mysql_dbus' => "Sửa mật khẩu người dùng MySQL. Thao tác này là cần thiết nếu bạn đã nâng cấp từ phiên bản cũ sang Plesk 11.",

    'cu_scheduled_backup_comment' => 'Sao lưu được lên lịch',
    'cu_scheduled_backup_error' => 'Lỗi xảy ra trong quá trình sao lưu: %1',
    'cu_scheduled_backup_mail_subject' => '<%1> Xảy ra lỗi trong khi sao lưu theo lịch trình.',
    'cu_scheduled_backup_mail_message' => "%1\nĐiểm nhập Plesk: %2\n\nXảy ra các lỗi sau trong quá trình sao lưu theo lịch trình:\n\n%3",

    'cu_scheduled_backup_hourly' => 'Sao lưu hằng giờ',
    'cu_scheduled_backup_daily' => 'Sao lưu hằng ngày',
    'cu_scheduled_backup_weekly' => 'Sao lưu hằng tuần',
    'cu_scheduled_backup_monthly' => 'Sao lưu hằng tháng',
    'cu_scheduled_backup_comment_backup_all' => '%1. Tất cả cấu hình và nội dung.',
    'cu_scheduled_backup_comment_backup_vhost' => '%1. Tất cả cấu hình và nội dung trừ tin nhắn email.',
    'cu_scheduled_backup_comment_backup_mail' => '%1. Chỉ cấu hình và tin nhắn email.',
    'cu_scheduled_backup_comment_backup_mail_file' => '%1. Tất cả cấu hình và nội dung trừ cơ sở dữ liệu người dùng.',
    'cu_scheduled_backup_comment_backup_mail_database' => '%1. Tất cả cấu hình và nội dung trừ tập tin người dùng.',
    'cu_scheduled_backup_comment_backup_database' => '%1. Chỉ cấu hình và cơ sở dữ liệu người dùng.',
    'cu_scheduled_backup_comment_backup_file' => '%1. Chỉ cấu hình và tập tin người dùng',
    'cu_scheduled_backup_comment_backup_domain' => '%1. Cấu hình tên miền.',

    'cu_scheduled_backup_to_cloud_not_allowed' => 'Lưu trữ các bản sao lưu theo lịch trình trong bộ lưu trữ đám mây từ xa là một tính năng cao cấp. Hãy liên hệ với nhà cung cấp dịch vụ lưu trữ của bạn để mở khóa.',

    'i_backup_invalid_file' => 'Đây không phải là sao lưu hợp lệ. Dữ liệu không thể khôi phục được từ tập tin này. Nhấp vào tên sao lưu để xem chi tiết.',

    'ui__server/migration/download-agent__short-title' => 'Tải về Đại lý Chuyển & Chuyển rời',
    'ui__server/migration/download-agent__title' => 'Tải về Đại lý Chuyển & Chuyển rời',
    'ui__server/migration/download-agent__description' => 'Tải về phiên bản mới nhất có sẵn của Migration & Transfer Agent từ trang web của Plesk.',

    'filemanager_resulting_archive_exists' => 'Tập tin %1 đã tồn tại trong danh mục đích.',

    'agent_unable_to_connect' => 'Không thể kết nối đến đại lý tại \'%2\'. Đảm bảo rằng đại lý đã được cài đặt và đang chạy, và không có vấn đề về kết nối với bộ lưu trữ \'%2\'.',
    'agent_test_connection_failed' => 'Không thể kết nối đến đại lý tại \'%2\'.',

    'agent_unable_to_resolve_host' => 'Không thể định vị bộ lưu trữ từ xa \'%1\'. Đảm bảo rằng không có vấn đề về kết nối với bộ lưu trữ.',
    'agent_unknown_curl_error' => 'Xảy ra lỗi \'%1\' trong quá trình kết nối với đại lý tại \'%2\'.',
    'agent_unexpected_htp_code' => 'Đã nhận được mã HTTP không mong muốn \'%1\' trên yêu cầu HTTP đến đại lý tại \'%2\'.',
    'agent_unable_to_auth' => 'Không thể xác nhận tại máy chủ \'%1\'. Để giải quyết vấn đề này, hãy làm theo hướng dẫn tại http://kb.plesk.com/116606.',
    'agent_internal_server_error' => 'Xảy ra lỗi nội bộ máy chủ khi thực thi lệnh trên bộ lưu trữ từ xa \'%1\'.',
    'agent_response_is_empty' => 'Đã nhận được một phản hồi trống trên yêu cầu HTTP đến đại lý tại \'%1\'.',

    'migration__disabled_due_to_local_file_does_not_exist' => 'Không tìm thấy Đại lý Chuyển & Chuyển rời trong bộ nhớ đệm cục bộ. Hãy mở lại Trình quản lý Chuyển & Chuyển rời để sửa lỗi.',

    '__hosting_webdeploy' => "Xuất bản triển khai Web",
    'cu_domain__webdeploy' => "Xuất bản Web Deploy (mặc định: %1)",
    'cu_dom_tpl__webdeploy' => "Xuất bản Web Deploy (mặc định: %1)",
    'cu_subdomain__webdeploy' => "Xuất bản Web Deploy (mặc định: %1)",
    'webdeploy__not_installed' => "Microsoft Web Deploy không được cài đặt trên máy chủ",
    'webdeploy__forced_by_site_isolation' => "Không thể thay đổi cài đặt xuất bản Web Deploy: Bạn không được phép ghi đè lên chính sách bảo mật trên toàn máy chủ. Liên hệ với nhà cung cấp để biết chi tiết.",



    'backup__restore_options__admin__server_configuration_license' => 'Mã bản quyền',
    'migration_start_migrate_server_license' => 'Chuyển key bản quyền',

    'defaultcomponents__delegation_rule_not_exist' => '(quy tắc ủy quyền được yêu cầu \'appPoolPipeline, appPoolNetFx\' không tồn tại)',

    '__o' => 'O',

    'i_backup_created_by_admin' => 'Sao lưu đã được tạo bởi quản trị viên.',
    'i_backup_created_by_reseller' => 'Sao lưu đã được tạo bởi đại lý.',
    'i_backup_created_by_client' => 'Sao lưu đã được tạo bởi khách hàng.',

    'migration__object_exists_on_target_host' => '(đã tồn tại trên bộ lưu trữ đích)',

    '__customers_total' => 'Tổng số theo khách hàng',
    '__resellers_total' => 'Tổng số theo đại lý',
    '__reseller_total' => 'Tổng đại lý',


    'cu_cl_pref__manage_website_maintenance' => 'Truy cập các thao tác nâng cao: Đang sao chép website',
    'cu_cl_pref__manage_protected_dirs' => 'Quản lý các danh mục được bảo vệ bằng mật khẩu',
    'cu_cl_pref__manage_mail_settings' => 'Khả năng thay đổi thiết lập thư',


    'cu__command_update_php_settings' => 'Cập nhật Cài đặt PHP.',
    'cu__php_settings_option' => 'Thiết lập đường dẫn đến tập tin có các cài đặt PHP.',

    'cu__additional_php_settings_option' => 'Thiết lập đường dẫn đến tập tin có các lệnh dẫn hướng PHP bổ sung.',
    'cu__command_show_php_settings' => 'Hiển thị cài đặt PHP hiện tại.',
    'cu__general_settings' => 'Cài đặt chung:',
    'cu__performance_settings' => 'Cài đặt hiệu suất:',
    'cu__php_fpm_settings' => 'Cài đặt PHP-FPM:',
    'cu__additional_directives' => 'Chỉ thị bổ sung:',

    'php_settings_permission_required' => 'Quản lý thiết lập PHP chung',
    'php_settings_performance_permission_required' => 'Quản lý thiết lập hiệu suất dịch vụ lưu trữ',
    'php_settings_customized' => 'Cài đặt PHP đã được tùy chỉnh.',
    'php_settings_synchronized_with_plan' => 'Cài đặt PHP phỉa được đồng bộ với gói.',
    'phosting__unknown_shell_type' => 'Trình Shell không khả dụng',

    'login_up__access_denied_subscription_deleted' => 'Truy cập bị từ chối: Thuê bao của bạn đã bị gỡ bỏ.',

    'role_restricted_to_subscription' => '(được chuyển với thuê bao: %1)',

    'filemanager__extract' => "Giải nén các tập tin vào: %1",

    'cu__license_command_check_installed_license' => 'Kiểm tra tính hợp lệ của key bản quyền đã cài đặt (trả về mã thoát 0 nếu key hợp lệ và 1 nếu không hợp lệ)',

    'promo__mobile_manager_title' => 'Quản lý Máy chủ Di động dành cho Plesk',
    'promo__mobile_manager' => "Mở rộng chức năng Plesk để có thể kiểm soát và giám sát máy chủ từ các thiết bị di động (BlackBerry, iPhone và Android).",
    'promo__mobile_monitor_title' => 'Bộ Giám Sát Di Động Máy Chủ Plesk',
    'promo__mobile_monitor' => 'Lấy thông tin quan trọng nhất về các máy chủ Plesk vào bất kỳ lúc nào và đại bất kỳ đâu từ một thiết bị di động (BlackBerry, iPhone, và Android).',
    'promo__mobile_button' => 'Tìm Hiểu Thêm',

    'ui__server/migration/video__short-title' => 'Video hướng dẫn',
    'ui__server/migration/video__title' => 'Xem video hướng dẫn',
    'ui__server/migration/video__description' => 'Xem video hướng dẫn.',

    'subDomainNameHint' => 'Nhập * như là tên miền phụ để tạo một tên miền phụ ký tự đại diện. Khách thăm trang sẽ được chuyển hướng đến tên miền phụ, không quan tâm đến tên miền phụ mà họ nhập vào trình duyệt.',
    'subdomains__wildcard_name_invalid' => "Tên miền phụ không hợp lệ. Bạn chỉ có thể sử dụng các ký tự chữ số, dấu gạch nối (-) và dấu hoa thị (*) cho tên miền phụ.",
    'subdomains__name_invalid' => "Tên miền phụ không hợp lệ. Bạn chỉ có thể sử dụng các ký tự chữ số và dấu gạch nối (-) cho tên miền phụ.",

    'domain__wildcard_no_www_prefix' => 'Không thể sử dụng tiền tố www cho tên miền phụ ký tự đại diện.',

    '__service_title__milter' => "Bộ lọc thư hậu tố Plesk",
    '__service_description__milter' => "Bộ lọc thư hậu tố Plesk",
    '__milter' => "Bộ lọc thư hậu tố",
    'restart__milter' => "Bộ lọc thư Plesk (%1)",
    'restart__pop3' => "Máy chủ Courier POP3",
    'restart__pop3s' => "Máy chủ Courier POP3 có hỗ trợ SSL/TLS",
    'restart__imap' => "Máy chủ Courier IMAP",
    'restart__imaps' => "Máy chủ Courier IMAP có hỗ trợ SSL/TLS",
    'restart__authdaemon' => "Daemon xác thực Courier IMAP",
    'restart__imap-pop3' => "Máy chủ Dovecot IMAP và POP3",


    'addon_packages_not_supported' => 'Không hỗ trợ các phần bổ sung cho ứng dụng web theo gói của APS.',
    'cu_domain__unable_to_automaticaly_select_ip' => 'Không thể tự động gán địa chỉ IP cho miền này. Vui lòng chỉ định một địa chỉ IP sử dụng tùy chọn -ip.',

    'plesk_key__mb_accounts' => 'Tài khoản người dùng (đại lý và khách hàng) trong Trình quản lý Khách hàng và Doanh nghiệp',

    'actionlog__subdomain_dns' => 'Vùng DNS tên miền phụ',
    'actionlog__site_subdomain_dns' => 'Vùng DNS của một tên miền phụ dưới một miền bổ sung',

    // PfW only
    'actionlog__event_site_create' => 'Đã tạo miền',
    'actionlog__event_site_delete' => 'Đã xóa miền',
    'actionlog__event_site_update' => 'Đã cập nhật miền',

    'actionlog__event_site_status_update' => 'Đã cập nhật trạng thái miền',
    'actionlog__event_site_dns_update' => 'Đã cập nhật vùng DNS miền',
    'actionlog__event_site_guid_update' => 'Đã cập nhật GUID miền',

    'actionlog__event_site_subdomain_create' => 'Đã tạo tên miền phụ',
    'actionlog__event_site_subdomain_delete' => 'Đã xóa tên miền phụ',
    'actionlog__event_site_subdomain_update' => 'Đã cập nhật tên miền phụ',

    'actionlog__event_site_alias_create' => 'Đã tạo bí danh miền',
    'actionlog__event_site_alias_delete' => 'Đã xóa bí danh miền',
    'actionlog__event_site_alias_update' => 'Đã cập nhật bí danh miền',

    'actionlog__event_site_alias_dns_update' => 'Đã cập nhật vùng DNS của một bí danh miền',
    'actionlog__event_subdomain_dns_update' => 'Đã cập nhật vùng DNS của một tên miền phụ dưới miền mặc định',
    'actionlog__event_site_subdomain_dns_update' => 'Đã cập nhật vùng DNS của một tên miền phụ',
    // End of PfW only

    'win_policy__bad_password' => 'Xác nhận không thành công. Mật khẩu không hợp lệ.',
    'win_policy__password_too_short' => 'Xác nhận không thành công. Mật khẩu không đáp ứng yêu cầu chính sách mật khẩu bởi vì nó quá ngắn.',
    'win_policy__password_too_long' => 'Xác nhận không thành công. Mật khẩu không đáp ứng yêu cầu chính sách mật khẩu bởi vì nó quá dài.',
    'win_policy__password_not_complex_enough' => 'Xác thực không thành công. Mật khẩu không đủ phức tạp và không đáp ứng các yêu cầu về chính sách mật khẩu. Mật khẩu mạnh phải chứa ít nhất tất cả những yếu tố sau: tám ký tự; một ký tự viết hoa hoặc viết thường; ba số và một ký tự đặc biệt (!, @, #, $,%, ^, &, *,?, _, ~) hoặc một số và hai ký tự đặc biệt.',

    //// Activation Code feature
    'plesk_key__license_update_failed' => 'Không thể cập nhật địa bản quyền sản phẩm.',


    'filemanager__error_path_is_not_allowed' => 'Đường dẫn không được phép',
    'filemanager__error_path_is_invalid' => 'Đường dẫn không hợp lệ',
    'filemanager__error_path_not_found' => 'Đường dẫn không tìm thấy',
    'filemanager__error_path_already_exists' => 'Đường dẫn đã tồn tại',
    'filemanager__error_access_is_denied' => 'Từ chối truy cập',
    'filemanager__error_directory_not_empty' => 'Thư mục không trống',
    'filemanager__error_sharing_violation' => 'Vi phạm trong việc Chia sẻ',
    'filemanager__error_not_same_device' => 'Đường dẫn đích không nằm trên cùng một thiết bị',
    'filemanager__binary_data_access' => 'Tập tin này có thể là một tập tin nhị phân. Bạn có muốn mở nó?',
    'filemanager__unable_to_resolve_realpath' => "Không thể tìm được tập tin %1 tại địa điểm đã chỉ định",
    'filemanager__access_to_realpath_denied' => "Truy cập vào đường dẫn thực bị từ chối: %1 tới %2.",
    'bt_exit' => 'Thoát',

    'filemanager__chdir_error__' => "Không thể thay đổi thư mục tới %1: %2",
    'filemanager__chmod_dir' => "Thay đổi quyền truy cập cho thư mục %1",
    'filemanager__chmod_error__' => "Không thể thay đổi quyền truy cập cho tập tin %1: %2",
    'filemanager__chmod_file' => "Thay đổi quyền truy cập cho tập tin %1",
    'filemanager__copy_error__' => "Không thể sao chép %1 tới %2: %3",
    'filemanager__copy_move' => "Sao chép (di chuyển) các tập tin từ %1",
    'filemanager__count_size__' => 'Lựa chọn kích thước: %1',
    'filemanager__count_size_error__' => 'Không thể tính toán kích thước cho %1: %2',
    'filemanager__create_dir' => "Tạo thư mục",
    'filemanager__create_dir_error__' => "Không thể tạo thư mục %1: %2",
    'filemanager__dir_not_exists' => "Thư mục %1 không tồn tại.",
    'filemanager__dirname' => "Tên danh mục",
    'filemanager__filename' => "Tên tập tin",
    'filemanager__is_no_such' => "Không có tập tin hoặc thư mục với tên %1",
    'filemanager__empty_selection' => "Không có tập tin nào được lựa chọn.",
    'filemanager__file_exists' => "Tập tin %1 đã tồn tại.",
    'filemanager__move_error__' => "Không thể di chuyển %1 tới %2: %3",
    'filemanager__new_dir' => "Tên danh mục",
    'filemanager__not_allowed' => "Bạn không được phép để thay đổi quyền truy cập cho tập tin này.",
    'filemanager__r_perm_dir' => "Liệt kê thư mục",
    'filemanager__r_perm_file' => "Đọc dữ liệu",
    'filemanager__remove' => "Gỡ bỏ các tập tin từ %1",
    'filemanager__remove_error__' => "Không thể gỡ bỏ tập tin %1: %2",
    'filemanager__rename_dir' => "Đổi tên thư mục %1",
    'filemanager__rename_error__' => "Không thể đổi tên %1 thành %2: %3",
    'filemanager__rename_file' => "Đổi tên tập tin %1",
    'filemanager__set_win_permissions_dir' => "Thiết lập quyền cho thư mục %1",
    'filemanager__set_win_permissions_file' => "Thiết lập quyền cho tập tin %1",
    'filemanager__touch_confirm' => "Bạn có chắc là bạn muốn thay đổi thời gian của các tập tin được chọn?",
    'filemanager__upload_error__' => "Không thể tải lên %1 đến %2: %3",
    'filemanager__upload_file' => "Tải lên tập tin",
    'filemanager__upload_file_src' => "Đường dẫn đến tập tin",
    'filemanager__username' => "Người dùng",
    'filemanager__w_perm_dir' => "Tạo các tập tin",
    'filemanager__w_perm_file' => "Ghi dữ liệu",
    'filemanager__x_perm_dir' => "Quyền thư mục",
    'filemanager__x_perm_file' => "Thực thi tập tin",
    'filemanager__max_image_size_exceeded' => 'Không thể hiển thị hình ảnh. Dung lượng hình ảnh không được lớn hơn %2 bytes',

    '__fastcgi_unix_support' => 'Hỗ trợ FastCGI',

    'dns__subdomain_dns_zone_parent' => 'Các bản ghi DNS của tên miền phụ này được lưu trữ trong vùng DNS chính. Bạn có thể thay đổi vùng chính %1 hoặc tạo một vùng riêng cho tên miền phụ này.',
    'dns__subdomain_dns_zone_parent_link' => 'tại đây',
    'dns__no_dns_zone' => 'Không có vùng DNS được gán cho miền. Để quản lý vùng DNS cho miền của bạn, bạn nên nhấn nút \'Khôi phục mặc định\'.',
    'dns__unable_turn_on_subdomain_zone' => 'Không thể bật vùng của tên miền phụ vì có một hồ sơ CNAME cho tên miền phụ này trong vùng miền chính.',

    '__hosting_write_modify' => 'Đặc quyền ghi/sửa bổ sung',

    'aspdotnet__group_framework_version' => "Phiên bản Framework",
    'aspdotnet__param_version' => "Phiên bản",

    'bt_restore_default' => "Đặt làm mặc định",
    'b_aspdotnet' => 'Chỉnh sửa các thiết lập cấu hình ASP.NET.',
    'b_aspdotnet__restore_default' => 'Khôi phục các thiết lập ASP.NET mặc định.',
    'b_aspdotnet__restore_wdir_default' => "Khôi phục cài đặt ASP.NET của danh mục chính cho kho chứa ảo này.",
    'b_aspdotnet__restore_default_disabled' => 'Khôi phục cấu hình ASP.NET mặc định không khả dụng: Cấu hình ASP.NET bị hỏng trên máy chủ hoặc trên cấp độ danh mục chính.',
    'b_autoinstaller' => 'Cập nhật Plesk hoặc các thành phần của nó.',
    'b_autoinstaller_configure' => 'Thiết đặt cập nhật.',
    'b_autoinstaller_install' => 'Cài đặt các thành phần được chọn.',

    '__iis_app_pool__use_dedicated' => 'Kho ứng dụng IIS chuyên dụng',
    '__iis_app_pool__use_dedicated_addons' => 'Dãy ứng dụng IIS chuyên dụng cho mỗi trang web',
    '__iis_app_pool__enable_32bit_app_on_win64' => 'Bật ứng dụng 32-bit',
    '__iis_app_pool__load_user_profile' => 'Tải hồ sơ người dùng',
    'bt_iis_app_pool' => "Dãy ứng dụng IIS",

    'performance__cpu_usage' => 'Tình trạng sử dụng CPU tối đa (%)',
    'performance__cpu_usage_action' => 'Hành động giới hạn',
    'performance__cpu_usage_interval' => 'Thời gian giới hạn (phút)',
    'performance__cpu_usage_action_not_supported' => 'Hành động đã chỉ định không được hỗ trợ bởi máy chủ web.',

    'performance__idle_timeout_action_not_supported' => 'Hành động thời gian chờ nhàn rỗi đã chỉ định không được hỗ trợ bởi máy chủ web.',
    'performance__max_worker_processes' => 'Số lượng quy trình thao tác tối đa',
    'performance__idle_timeout' => 'Thời gian chờ nhàn rỗi (phút)',
    'performance__idle_timeout_action' => 'Hành động thời gian chờ nhàn rỗi',
    'performance__recycling_by_time' => 'Quay vòng theo khoảng thời gian đều đặn (phút)',
    'performance__recycling_by_requests' => 'Quay vòng khi sử dụng đạt ngưỡng tối đa số yêu cầu',
    'performance__recycling_by_virtual_memory' => 'Quay vòng khi sử dụng đến tối đa lượng bộ nhớ ảo',
    'performance__recycling_by_private_memory' => 'Quay vòng khi sử dụng đến tối đa lượng bộ nhớ riêng',
    'performance__managed_pipeline_mode' => 'Chế độ đường được quản lý',
    'performance__managed_pipeline_mode_not_supported' => 'Các chế độ chỉ định không được hỗ trợ bởi máy chủ web.',

    'iis_app_pool' => 'Quản lý kho ứng dụng IIS.',
    'b_iis_app_pool' => 'Quản lý kho ứng dụng IIS.',
    'iis_app_pool_cl_dom' => 'Quản lý kho ứng dụng IIS.',

    'i_webdirs_not_protected' => 'Danh mục này không được bảo vệ.',
    'i_webdirs_protected' => 'Danh mục này đã được bảo vệ.',
    'i_webdirs_manage_protection' => 'Quản lý bảo vệ.',
    'i_webdirs_open' => 'Mở danh mục/tập tin trong trình duyệt.',
    'i_webdirs_preferences_disabled' => 'Thư mục này không phải là một thư mục ảo.',
    'i_webdirs_permissions' => 'Quản lý quyền truy cập.',
    'i_webdirs_permissions_disabled' => 'Quản lý quyền truy cập danh mục không khả dụng.',
    'i_webdirs_type_dir' => 'Thư mục vật lý',
    'i_webdirs_type_vdir' => 'Thư mục ảo',
    'i_webdirs_browse' => 'Duyệt nội dung danh mục.',
    'i_webdirs_preferences' => 'Quản lý cài đặt danh mục Web.',

    'l_webdirslist_type' => 'Sắp xếp các danh mục theo loại.',
    'l_webdirslist_protected' => 'Sắp xếp các danh mục theo trạng thái bảo vệ.',
    'l_webdirslist_name' => 'Sắp xếp các danh mục theo tên.',

    'b_webdirslist_remove' => 'Xóa các kho chứa ảo được chọn.',
    'b_webdirslist_search' => 'Nhập kiểu tìm kiếm và nhấp để tìm các kho chứa ảo.',
    'b_webdirslist_show_all' => 'Hiển thị tất cả các danh mục.',

    'l_webdirerrordocslist_code' => 'Sắp xếp tài liệu báo lỗi theo mã số lỗi.',
    'l_webdirerrordocslist_name' => 'Sắp xếp các tài liệu báo lỗi theo mô tả lỗi.',
    'l_webdirerrordocslist_type' => 'Sắp xếp tài liệu báo lỗi theo loại tài liệu báo lỗi.',
    'l_webdirerrordocslist_location' => 'Sắp xếp các tài liệu báo lỗi theo vị trí của tài liệu báo lỗi.',

    'b_webdirerrordocslist_search' => 'Nhập một từ khóa tìm kiếm và nhấn để tìm tài liệu báo lỗi.',
    'b_webdirerrordocslist_remove' => 'Xóa các tài liệu báo lỗi được chọn.',
    'b_webdirerrordocslist_show_all' => 'Hiện tất cả các tài liệu báo lỗi.',

    'l_webdirmimetypeslist_name' => 'Sắp xếp loại theo theo phần mở rộng.',
    'l_webdirmimetypeslist_content' => 'Sắp xếp kiểu MIME theo nội dung.',

    'b_webdirmimetypeslist_remove' => 'Xóa các kiểu MIME được chọn.',
    'b_webdirmimetypeslist_search' => 'Nhập kiểu tìm kiếm và nhấp để tìm các kiểu MIME.',
    'b_webdirmimetypeslist_show_all' => 'Hiển thị tất cả các kiểu MIME.',

    'b_webdir_preferences' => "Chỉnh sửa kho chứa ảo.",
    'b_webdir_permissions' => "Quyền truy cập kho chứa ảo.",
    'b_webdir_permissions_disabled' => "Quản lý quyền truy cập danh mục không khả dụng.",
    'b_to_webdirs' => 'Quay lại để quản lý các danh mục.',
    'b_to_webdir_mime_types' => 'Quay lại để quản lý kiểu MIME.',
    'b_to_webdir_error_docs' => 'Quay lại để quản lý các tài liệu lỗi.',
    'b_to_webdir_protection' => 'Quay lại để quản lý bảo vệ kho chứa ảo.',

    'webdirs__title' => 'Kho chứa ảo %1',
    'webdirs__preferences_title' => 'Cài đặt kho chứa ảo',
    'webdirs__list_legend' => 'Thư mục ảo',
    'webdirs__list_type' => 'T',
    'webdirs__list_protected' => 'P',
    'webdirs__list_name' => 'Tên',
    'webdirs__list_header' => '%1 mục',
    'webdirs__tabs_general' => 'Tổng quan',
    'webdirs__tabs_mime_types' => 'Các kiểu MIME',
    'webdirs__tabs_error_docs' => 'Tài liệu báo lỗi',

    'webdirs__tabs_permissions' => 'Quyền truy cập',
    'webdir__remove_vdirs' => 'Các kho chứa ảo sau sẽ bị xóa:',
    'webdir__remove_mime_types' => 'Các kiểu MIME sau đây sẽ bị xóa:',
    'webdir__mime_types_title' => 'Các kiểu MIME',
    'webdir__protection_disable_confirm' => 'Bạn có thực sự muốn loại bỏ bảo vệ khỏi thư mục?',
    'webdir__protect_title' => 'Người dùng URL được bảo vệ',
    'webdirs__permissions_title' => 'Quyền truy cập kho chứa ảo',
    'webdirs__browse_content_permission_denied' => 'Bạn không có quyền xem nội dung của danh mục này.',
    'error_doc__list_code' => 'Lỗi',
    'error_doc__list_code_description' => 'Mô tả',
    'error_doc__list_type' => 'Kiểu',
    'error_doc__list_location' => 'Vị trí',
    'error_doc__code' => 'Lỗi',
    'error_doc__type' => 'Kiểu',
    'error_doc__type_file' => 'Tập tin',
    'error_doc__type_url' => 'URL',
    'error_doc__location' => 'Vị trí',
    'error_doc__legend' => 'Tài liệu báo lỗi',
    'error_doc__edit_title' => 'Chỉnh sửa tài liệu báo lỗi',
    'error_doc_erorr_invalid_url_location' => 'URL không hợp lệ. Vui lòng chỉ định URL chính xác.',
    'error_doc_erorr_invalid_file_location' => 'Đường dẫn tập tin không hợp lệ. Vui lòng chỉ định đường dẫn tập tin chính xác.',
    'error_doc__type_default' => 'Mặc định',

    'webdirs__tabs_protection' => 'Bảo vệ',
    'pb_webdirs' => 'Thư mục ảo',

    'webdirs_remove_title' => 'Các kho chứa ảo sau sẽ được gỡ bỏ:',
    'webdirs_mime_types_remove_title' => 'Các kiểu MIME sau đây sẽ được gỡ bỏ:',
    'webdirs_preferences_title' => 'Cài đặt kho chứa ảo',
    'webdirs_permissions_title' => 'Quyền truy cập đặc biệt cho các Tập tin và Thư mục',
    'webdi_protection_disable_confirm' => 'Bạn có chắc chắn muốn gỡ bỏ bảo vệ khỏi kho chứa ảo? Điều này sẽ gỡ bỏ tất cả người dùng danh mục được bảo vệ và các cài đặt bảo vệ danh mục.',
    'bt_protect' => 'Bảo vệ',
    'bt_unprotect' => 'Gỡ bỏ bảo vệ',
    'bt_show_additional_users' => 'Hiển thị thêm người dùng',
    'bt_hide_additional_users' => 'Hiển thị ít người dùng hơn',
    'error_doc__list_title' => 'Tài liệu báo lỗi',
    'error_doc__list_header' => 'Tài liệu báo lỗi',
    'error_doc__code_400' => 'Yêu cầu không hợp lệ',
    'error_doc__code_401' => 'Trái phép',
    'error_doc__code_401.1' => 'Trái phép - Đăng nhập thất bại',
    'error_doc__code_401.2' => 'Trái phép - Đăng nhập thất bại do cấu hình máy chủ',
    'error_doc__code_401.3' => 'Trái phép - Không chứng thực được do ACL về tài nguyên',
    'error_doc__code_401.4' => 'Trái phép - Chứng thực thất bại do bộ lọc',
    'error_doc__code_401.5' => 'Trái phép - Chứng thực thất bại do ứng dụng ISAPI/CGI',
    'error_doc__code_401.7' => 'Không xác thực - Bị từ chối do chính sách xác thực URL',
    'error_doc__code_403' => 'Bị cấm',
    'error_doc__code_403.1' => 'Bị cấm - Thực hiện truy cập bị từ chối',
    'error_doc__code_403.2' => 'Bị cấm - Truy cập dạng đọc bị từ chối',
    'error_doc__code_403.3' => 'Bị cấm - Truy cập dạng ghi bị từ chối',
    'error_doc__code_403.4' => 'Bị cấm - SSL được yêu cầu',
    'error_doc__code_403.5' => 'Bị cấm - Yêu cầu SSL 128',
    'error_doc__code_403.6' => 'Bị cấm - Địa chỉ IP bị từ chối',
    'error_doc__code_403.7' => 'Bị cấm - Chứng chỉ khách được yêu cầu',
    'error_doc__code_403.8' => 'Bị cấm - Truy cập trang web bị từ chối',
    'error_doc__code_403.9' => 'Bị cấm - Quá nhiều người sử dụng',
    'error_doc__code_403.10' => 'Bị cấm - Cấu hình không hợp lệ',
    'error_doc__code_403.11' => 'Bị cấm - Thay đổi mật khẩu',
    'error_doc__code_403.12' => 'Bị cấm - Truy cập trình lập bản đồ bị từ chối',
    'error_doc__code_403.13' => 'Bị cấm - Chứng chỉ khách bị thu hồi',
    'error_doc__code_403.14' => 'Bị cấm - Lập danh sách danh mục bị từ chối',
    'error_doc__code_403.15' => 'Bị cấm - Vượt quá bản quyền truy cập của khách hàng',
    'error_doc__code_403.16' => 'Bị cấm - Chứng nhận khách hàng không đáng tin hoặc bất thường',
    'error_doc__code_403.17' => 'Bị cấm - Chứng chỉ khách đã hết hạn hoặc không hợp lệ',
    'error_doc__code_403.18' => 'Bị cấm - Không thể thực hiện yêu cầu của kho ứng dụng này',
    'error_doc__code_403.19' => 'Bị cấm - Truy cập CGI bị từ chối',
    'error_doc__code_403.20' => 'Bị cấm - Đăng nhập hộ chiếu thất bại',
    'error_doc__code_404' => 'Không tìm thấy',
    'error_doc__code_404.2' => 'Không tìm thấy - Bị từ chối do chính sách khóa',
    'error_doc__code_404.3' => 'Không tìm thấy - Bị từ chối do chính sách MIMEMAP',
    'error_doc__code_405' => 'Phương pháp không được cho phép',
    'error_doc__code_406' => 'Không được chấp nhận',
    'error_doc__code_407' => 'Yêu cầu xác thực Proxy',
    'error_doc__code_412' => 'Điều kiện trước thất bại',
    'error_doc__code_414' => 'Yêu cầu - URI quá dài',
    'error_doc__code_415' => 'Kiểu phương tiện không được hỗ trợ',
    'error_doc__code_500' => 'Lỗi nội bộ máy chủ',
    'error_doc__code_500.12' => 'Lỗi nội bộ máy chủ - Khởi động lại ứng dụng',
    'error_doc__code_500.13' => 'Lỗi nội bộ máy chủ - Máy chủ quá bận',
    'error_doc__code_500.15' => 'Lỗi nội bộ máy chủ - Yêu cầu trực tiếp cho GLOBAL.ASA bị cấm',
    'error_doc__code_500.16' => 'Lỗi nội bộ máy chủ - lỗi truy cập UNC',
    'error_doc__code_500.17' => 'Lỗi nội bộ máy chủ - Không tìm thấy bộ lưu trữ ủy quyền URL',
    'error_doc__code_500.18' => 'Lỗi nội bộ máy chủ - Không mở được bộ lưu trữ ủy quyền URL',
    'error_doc__code_500.19' => 'Lỗi nội bộ máy chủ - Siêu dữ liệu tập tin lỗi',
    'error_doc__code_500.100' => 'Lỗi nội bộ máy chủ - lỗi ASP',
    'error_doc__code_501' => 'Chưa được thực hiện',
    'error_doc__code_502' => 'Lỗi cổng vào',
    'error_doc__code_503' => 'Dịch vụ tạm thời không khả dụng',

    'mimetype__extension' => 'Mở rộng',
    'mimetype__content' => 'Nội dung',
    'mimetypeslist__title' => 'Các kiểu MIME',
    'mimetypes__title' => 'Các kiểu MIME',
    'mimetypes__select_to_remove' => 'Chọn các kiểu MIME mà bạn muốn gỡ bỏ.',
    'mimetypes__select_for_remove' => "Chọn các kiểu MIME cần gỡ bỏ.",
    'mimetypes_remove__title' => 'Gỡ bỏ kiểu MIME',
    'mimetype__legend' => 'Kiểu MIME',
    'mimetype_edit__title' => 'Chỉnh sửa kiểu MIME',
    'mimetype_edit__already_exists' => 'Kiểu MIME đã được định nghĩa cho phần mở rộng này.',
    'mimetype_edit__not_exists' => 'Kiểu MIME không tồn tại.',
    'mimetype__content_type_other' => 'Tuỳ biến...',

    'b_webdir_protection_enable' => 'Tạo URL tương ứng với danh mục được bảo vệ bằng mật khẩu.',
    'b_webdir_protection_disable' => 'Tạo URL tương ứng với danh mục có thể truy cập đến tất cả.',
    'b_webdir_protection_disabled' => 'Bảo vệ kho chứa ảo đã bị hủy kích hoạt.',

    'b_pd_usr_create' => 'Nhấn vào để tạo ra người sử dụng URL được bảo vệ này.',
    'php__changeversion_title' => "Chọn Phiên bản PHP",
    'php__group_php_version' => "Phiên bản PHP",

    'virtualdir__name' => 'Tên',
    'virtualdir__path' => 'Đường dẫn',
    'virtualdir__read' => 'Quyền truy cập đọc',
    'virtualdir__read_short' => 'R',
    'virtualdir__write' => 'Quyền truy cập ghi',
    'virtualdir__write_short' => 'W',
    'virtualdir__source' => 'Truy cập nguồn script',
    'virtualdir__source_short' => 'S',
    'virtualdir__browse' => 'Đang duyệt danh mục',
    'virtualdir__browse_short' => 'B',
    'virtualdir__script_execute' => 'Quyền thực hiện',
    'virtualdir__script_execute_short' => 'E',
    'virtualdir__log_visits' => 'Lượt truy cập nhật ký',
    'virtualdir__app_create' => 'Tạo ứng dụng',
    'virtualdir__app_create_short' => 'A',
    'virtualdir__auth_anon' => 'Bật xác thực ẩn danh.',
    'virtualdir__auth_windows' => 'Bật xác thực Windows.',
    'virtualdir__auth_not_enabled' => 'Phải bật xác thực ẩn danh hoặc Windows.',
    'virtualdir__require_ssl' => 'Yêu cầu SSL/TLS',
    'virtualdir__enable_default_doc' => 'Sử dụng tài liệu mặc định',
    'virtualdir__default_doc' => 'Thứ tự tìm kiếm tài liệu mặc định',
    'virtualdir__enable_parent_paths' => 'Cho phép sử dụng đường dẫn của thư mục cha',
    'virtualdir__execute_in_mta' => 'Cho phép ứng dụng thực thi trong chế độ MTA (không gian riêng đa luồng)',
    'virtualdir_create__title' => 'Tạo thư mục ảo trong %1',
    'virtualdir_edit__title' => 'Thuộc tính của thư mục ảo %1',
    'virtualdir_edit__legend' => 'Thư mục ảo',
    'virtualdir_edit__application_legend' => 'Thiết lập ứng dụng',
    'virtualdir_edit__security_legend' => 'Bảo mật thư mục',
    'virtualdir_edit__documents_legend' => 'Tài liệu',
    'virtualdir_edit__list_legend' => 'Thư mục ảo được lồng',
    'virtualdir_error__path_not_in__' => 'Đường dẫn được chỉ định không hợp lệ',
    'virtualdir_error__already_exists' => 'Danh mục có tên này đã tồn tại.',
    'virtualdir_root' => 'Thư mục ảo',
    'virtualdir_root__title' => 'Thư mục ảo',
    'virtualdir_root__list_legend' => 'Thư mục ảo',
    'virtualdir_se__none' => 'Không',
    'virtualdir_se__script' => 'Chỉ script',
    'virtualdir_se__script_execute' => 'Script và thực thi',
    'virtualdirs__title' => 'Thư mục ảo',
    'virtualdirs__path_not_exists' => 'Đường dẫn không hợp lệ.',
    'virtualdirs__select_for_remove' => "Chọn các thư mục ảo cần gỡ bỏ.",
    'virtualdirs_remove__title' => 'Gỡ bỏ thư mục ảo',
    'virtualdirs_phys_dir_exist' => 'Danh mục thực có tên này đã tồn tại. Nếu bạn tiếp tục, nó sẽ không thể truy cập được. Bạn có muốn tiếp tục?',
    'virtualdir_auto_create_dir' => "Tạo thư mục vật lý có cùng tên với thư mục ảo",

    'asp_max_default_text' => 'Xác định bởi thư mục cha (%1 KB)',
    'asp_max_default_text_site' => 'Xác định bởi IIS (%1 KB)',
    'asp_max_buffer_text' =>'Kích thước tối đa của bộ đệm ASP (KB)',
    'asp_max_body_text' => 'Kích thước tối đa của toàn bộ một yêu cầu ASP (KB)',
    'asp_buffers_legend' =>'Thiết lập ASP',

    'asp_debug_default_text' =>'Xác định bởi thư mục cha',
    'asp_debug_default_text_site' =>'Xác định bởi IIS',
    'asp_client_debug_text' =>'Kích hoạt tính năng sửa lỗi kịch bản ASP phía máy khách',
    'asp_server_debug_text' =>'Bật tính năng sửa lỗi kịch bản ASP trên toàn máy chủ',

    'webdirs__list_with_broken_dirs' => "Có những kho chứa ảo liên kết đến các thư mục thực không tồn tại.",
    'webdirs__vdir_physical_path_not_exist' => "Kho chứa ảo được liên kết đến một thư mục thực không tồn tại.",
    'webdirs__physical_path_not_exist' => "Đường dẫn được chỉ định không tồn tại.",

    'filemanager__new_dir_title' => 'Tạo danh mục',
    'php__configuration_title' => "Cấu hình PHP",

    'permissions__title' => 'Thiết lập Quyền truy cập',
    'permissions__title_advanced' => 'Thiết lập Quyền truy cập nâng cao',
    'permissions__inherit_from_parent' => 'Cho phép quyền truy cập có thể thừa kế từ bố mẹ để truyền sang đối tượng này và tất cả các đối tượng con. Bao gồm với các mục nhập được định nghĩa rõ ràng trong đây.',
    'permissions__replace_on_children' => 'Thay thế các mục nhập quyền truy cập trên tất cả các đối tượng con có mục nhập trình bày tại đây.',
    'permissions__group_or_user_name' => 'Nhóm hoặc tên người dùng',
    'permissions__Permissions_for' => 'Quyền để',
    'permissions__allow' => 'Cho phép',
    'permissions__deny' => 'Từ chối',
    'permissions__FullControl' => 'Toàn quyền điều khiển',
    'permissions__Modify' => 'Sửa đổi',
    'permissions__ReadAndExecute' => 'Đọc & Thực thi',
    'permissions__ListFolderContents' => 'Liệt kê nội dung thư mục',
    'permissions__Read' => 'Đọc',
    'permissions__Write' => 'Ghi',
    'permissions__ReadControl' => 'Kiểm soát việc đọc',
    'permissions__WriteControl' => 'Kiểm soát ghi',
    'permissions__ExecuteControl' => 'Kiểm soát thực thi',
    'permissions__TraverseFolderOrExecuteFile' => 'Vào thư mục / Thực thi tập tin',
    'permissions__ListFolderOrRead' => 'Duyệt thư mục / Đọc dữ liệu',
    'permissions__CreateFilesOrWrite' => 'Tạo tập tin / Ghi dữ liệu',
    'permissions__CreateFoldersOrAppend' => 'Tạo các thư mục / Nối dữ liệu',
    'permissions__DeleteSubfoldersandFiles' => 'Xóa thư mục con và tập tin',
    'permissions__Delete' => 'Xóa',
    'permissions__ChangePermissions' => 'Thay đổi Quyền hạn',
    'permissions__TakeOwnership' => 'Chiếm quyền sở hữu',
    'permissions__inherited_from' => 'Thừa kế từ',
    'permissions__not_inherited' => '<không thừa kế>',
    'permissions__apply_to' => 'Áp dụng cho',
    'permissions__apply_onto' => 'Áp dụng cho:',
    'permissions__apply_onto1' => 'Chỉ với thư mục này',
    'permissions__apply_onto2' => 'Chỉ các thư mục con',
    'permissions__apply_onto3' => 'Thư mục này và thư mục con',
    'permissions__apply_onto4' => 'Chỉ các tập tin',
    'permissions__apply_onto5' => 'Thư mục này và các tập tin',
    'permissions__apply_onto6' => 'Chỉ thư mục con và các tập tin',
    'permissions__apply_onto7' => 'Thư mục này, các thư mục nhỏ và tập tin',

    'filemanager__not_allowed_dir' => "Bạn không được phép thay đổi quyền truy cập cho thư mục này.",

    'filemanager__allow' => "Cho phép",
    'filemanager__deny' => "Từ chối",
    'filemanager__user_domusr' => 'Quản trị viên website',
    'filemanager__user_webusr' => 'Người dùng web',
    'filemanager__user_admins' => 'Quản trị viên',
    'filemanager__user_system' => 'HỆ THỐNG',
    'filemanager__user_aspnet' => 'Người dùng ASP.NET',
    'filemanager__user_poolusr' => 'Người dùng kho ứng dụng',
    'filemanager__user_sysaccount' => 'Ngươi dùng hệ thống bổ sung',

    'bt_permissions_advanced' => 'Nâng cao',
    'b_permissions_advanced' => 'Nhấn vào để xem và thiết lập các quyền hạn đặc biệt.',

    'hotlink-protection_invalid_friend_domain' => 'Tên không hợp lệ cho miền thân thiện.',
    'hotlink-protection_duplicate_friend_domain' => 'Tên trùng lặp cho miền thân thiện.',
    'hotlink-protection_invalid_extensions' => 'Phần mở rộng của tập tin có chứa các ký tự không đúng.',

    'i_domain_alias_status_on' => 'Bí danh tên miền được kích hoạt.',
    'i_domain_alias_status_off' => 'Bí danh tên miền bị vô hiệu hóa.',
    'i_domain_alias_status_with_parent' => 'Bí danh tên miền bị vô hiệu hóa bởi vì tên miền đã tắt.',
    'i_domain_alias_turn_off' => 'Nhấn vào để vô hiệu hóa.',
    'i_domain_alias_turn_on' => 'Nhấp vào để kích hoạt.',
    'i_domain_alias_mail_on' => 'Dịch vụ thư đã được kích hoạt cho bí danh tên miền này.',
    'i_domain_alias_mail_off' => 'Dịch vụ thư đã tắt với bí danh tên miền này.',
    'i_domain_alias_mail_with_parent' => 'Dịch vụ thư bị vô hiệu hóa bởi vì bí danh tên miền đã tắt.',
    'i_domain_alias_web_on' => 'Dịch vụ Web được kích hoạt cho bí danh tên miền này.',
    'i_domain_alias_web_off' => 'Dịch vụ Web bị vô hiệu hóa với bí danh tên miền này.',
    'i_domain_alias_web_with_parent' => 'Dịch vụ web bị vô hiệu hóa bởi vì bí danh tên miền đã tắt.',
    'i_domain_alias_dns_on' => 'Dịch vụ bí danh DNS đã được bật cho bí danh miền này.',
    'i_domain_alias_dns_off' => 'Dịch vụ bí danh DNS đã được tắt trên bí danh miền này.',
    'i_domain_alias_dns_with_parent' => 'Đồng bộ hóa DNS với miền chính bị hủy kích hoạt bởi vì bí danh miền đã bị tắt.',
    'i_domain_alias_seoRedirect_on' => 'Chuyển hướng có mã HTTP 301 đã được bật cho bí danh miền này.',
    'i_domain_alias_seoRedirect_off' => 'Chuyển hướng có mã HTTP 301 đã được tắt cho bí danh miền này.',
    'i_domain_alias_seoRedirect_with_parent' => 'Chuyển hướng có mã HTTP 301 đã được tắt vì bí danh miền đã được tắt.',

    'domain_alias__control_title' => 'Bí danh miền %1',
    'domain_alias__control_info_legend' => 'Thông báo',
    'domain_alias__control_status_title' => 'S',
    'domain_alias__control_name_title' => 'Tên dịch vụ',
    'domain_alias__control_details_title' => 'Chi tiết',

    'domain_alias__invalid_values' => 'Tên miền bạn chỉ định không hợp lệ. Tên miền có thể bao gồm chữ, số và dấu gạch nối. Mỗi mục của tên miền giữa các dấu chấm không được vượt quá 63 ký tự.',
    'domain_alias__domain_already_exists' => "Tên bí danh tên miền %1 không đúng. Miền %1 đã tồn tại.",
    'domain_alias__www_prefix_domain_already_exists' => "Tên bí danh tên miền www.%1 không đúng. Bí danh này đã được tạo cho miền %1.",
    'domain_alias__webmail_enabled_domain_already_exists' => 'Tên webmail bí danh tên miền.%1 không đúng. Bí danh này đã được tạo cho miền %1.',
    'domain_alias__lists_enabled_domain_already_exists' => 'Tên danh sách bí danh tên miền.%1 không đúng. Bí danh này đã được tạo cho miền %1.',
    'domain_alias__dns_record_already_exists' => 'Không thể thiết lập các bí danh miền %1 bởi vì một bản ghi DNS trỏ đến bộ lưu trữ %1 đã tồn tại.',
    'domain_alias__domain_alias_already_exists' => "Bí danh miền có tên này đã tồn tại.",
    'domain_aliases__mail_server_not_support_aliases' => 'Máy chủ thư không hỗ trợ tính năng bí danh tên miền. Bí danh tên miền có thể không hoạt động một cách chính xác.',
    'domain_alias__restrict_domain_creation' => 'Tên được chỉ định cho bí danh miền đã bị cấm theo chính sách của máy chủ. Nếu tên bí danh miền này là của bạn, vui lòng liên hệ với nhà cung cấp dịch vụ lưu trữ của bạn.',
    'domain_alias__restrict_creation_with_www' => 'Hãy nhập tên miền không có tiền tố \'www\'. Tiền tố www của tên miền sẽ được tự động thêm vào cấu hình máy chủ web.',
    'domain_unable_to_set_name' => 'Tên không đúng %1.',

    'domain_alias__domain_service_dns_disabled' => 'Miền này được phục vụ bởi một máy chủ DNS khác.',
    'domain_alias__domain_service_dns_enabled_master' => 'Máy chủ DNS này hoạt động như máy chủ tên chính cho vùng DNS này.',
    'domain_alias__domain_service_dns_enabled_slave' => 'Máy chủ DNS này hoạt động như một máy chủ tên phụ cho vùng DNS này.',
    'domain_alias__domain_service_mail_enabled' => 'Dịch vụ thư đã được bật cho tên miền này.',
    'domain_alias__domain_service_mail_disabled' => 'Dịch vụ thư đã bị tắt cho tên miền này.',
    'domain_alias__domain_service_mail_mx' => '%1 được sử dụng làm máy chủ thư.',

    'domain_alias__service_seoRedirect_hint' => 'Khi khách truy cập mở URL của bí danh, họ sẽ được chuyển hướng sang URL của miền chính. Plesk sử dụng chuyển hướng HTTP 301 có công cụ tìm kiếm thân thiện, điều này có nghĩa là thứ hạng công cụ tìm kiếm sẽ không bị ngắt ra giữa các URL.',

    'bt_task_run_now' => 'Chạy ngay',
    'ftp__read_perm' => "Quyền truy cập đọc",
    'ftp__write_perm' => "Quyền truy cập ghi",

    'filemanager__upload_backup_file_hint' => 'Tại đây, bạn có thể tải lên các tập tin sao lưu vào lưu trữ Plesk. Kích thước tập tin tối đa được giới hạn ở hai gigabyte.',

    '__default_for_mssql' => 'mặc định cho MS SQL',

    '__login_does_not_pass_validation' => "Tên người dùng không hợp lệ. Đảm bảo nó đáp ứng các yêu cầu sau: %1",
    '__login_allowed_symbols' => 'Chỉ cho phép các ký tự chữ số, bao gồm dấu chấm, gạch ngang và gạch dưới. Ký tự đầu tiên phải là chữ số.',

    'restart__nginx' => 'Máy chủ Proxy đảo (nginx)',
    'restart__php-fpm' => 'PHP-FPM %1',

    'admin_ed__i_would_like_recieve_announce' => "Tôi muốn nhận được thông tin chung của sản phẩm, và các thông báo từ Plesk.",
    'admin_ed__i_would_like_recieve_tech_announce' => "Tôi muốn nhận được các thông tin liên quan đến bảo mật và các thông báo kỹ thuật khác từ Plesk.",

    '__login_status_inactive' => 'Tài khoản của bạn bị không hoạt động. Xin vui lòng liên hệ với quản trị viên Plesk.',

    'migration__task_keep_in_process' => 'Đồng ý',
    'migration__task_keep_in_process_conhelp' => 'Quay lại trang Công cụ & Cài đặt. Chuyển rời sẽ được tiếp tục trên nền.',

    'ui__admin-alias-info__description' => "Chỉnh sửa thông tin liên lạc của tài khoản quản trị viên bổ sung.",
    'ui__admin-alias-info__short-title' => "Thông tin liên hệ",
    'ui__admin-alias-info__title' => "Thông tin tài khoản quản trị viên bổ sung",
    'ui__admin-alias-password__description' => "Thay đổi mật khẩu quản trị viên bổ sung.",

    'ui__admin-alias-password__short-title' => "Đổi mật khẩu",
    'ui__admin-alias-password__title' => "Mật khẩu của quản trị viên bổ sung",
    'ui__admin-alias__description' => "Xem và thay đổi thông tin tài khoản quản trị viên bổ sung.",

    'chk_js__warning_about_login_syntax' => "Bạn có thể sử dụng chữ số viết thường, gạch ngang và gạch dưới trong tên người dùng. Tên người dùng phải được bắt đầu bằng một ký tự trong bảng chữ cái. Mật khẩu không được chứa tên người dùng và dấu ngoặc kép.",
    'chk_js__warning_about_ftp_login_syntax' => "Bạn có thể sử dụng chữ số, gạch ngang và gạch dưới trong tên đăng nhập.",
    'chk_js__warning_about_login_syntax_win' => "Bạn có thể sử dụng chữ số viết thường, gạch ngang, dấu chấm và gạch dưới trong tên người dùng. Tên người dùng phải được bắt đầu bằng một ký tự trong bảng chữ cái hoặc số. Mật khẩu không được chứa tên người dùng và dấu ngoặc kép.",
    'chk_js__warning_about_passwd_syntax' => "Bạn không được sử dụng dấu ngoặc kép, khoảng trống và các ký tự trong bảng chữ cái quốc gia trong một mật khẩu.\nMật khẩu phải có độ dài từ %1 đến %2 ký tự, và không được chứa tên người dùng.",
    'chk_js__warning_about_plesk_login_syntax' => "Bạn có thể sử dụng chữ số viết thường, dấu chấm, gạch ngang và gạch dưới trong tên người dùng.",
    'chk_js__warning_about_plesk_login_syntax_win' => "Bạn có thể sử dụng chữ số viết thường, gạch ngang và gạch dưới trong tên người dùng. Tên người dùng phải được bắt đầu bằng một ký tự trong bảng chữ cái.",
    'chk_js__warning_about_plesk_passwd_syntax' => "Bạn không được sử dụng dấu ngoặc kép, khoảng trống và các ký tự trong bảng chữ cái quốc gia trong một mật khẩu.\nMật khẩu phải có độ dài từ %1 đến %2 ký tự, và không được chứa tên người dùng.",
    'chk_js__warning_about_pam_passwd_error' => "Phát hiện sai tài khoản người dùng trên hệ thống: %1",

    'cmd_server__admin_alias_not_found' => "Không thể tìm thấy tài khoản quản trị viên bổ sung.",

    'panel_branding__skins_already_exists' => "Lưu ý: Chủ đề '%1' đã tồn tại. Nó sẽ bị thay thế bởi chủ đề bạn đang cài đặt.",
    'panel_branding__skins_file_exists' => "Không thể tạo danh mục cho chủ đề '%1': Một tập tin có tên này đã tồn tại.",

    'actionlog__login_failed' => 'không thể đăng nhập',
    'actionlog__event_cp_user_login_failed' => 'Người dùng Plesk không thể đăng nhập',
    'actionlog__api_login_failed' => 'không thể đăng nhập qua API',
    'actionlog__event_cp_user_api_login_failed' => 'Người dùng Plesk không thể đăng nhập qua API',
    'actionlog__pw_reset' => 'đã yêu cầu đặt lại mật khẩu',

    'ch_pass_admin__email_subject' => "Trình nhắc nhở mật khẩu Plesk",
    'ch_pass_admin__email_body' => "Xin chào, %1.\n\nMật khẩu quản trị viên không thể gửi được qua email vì lý do bảo mật.\n\nĐể đăng nhập với tư cách 'admin', dùng lệnh 'plesk login'.\n\nĐể đặt mật khẩu 'admin' mới, sử dụng lệnh 'plesk bin admin --set-password -passwd <new_password>'\n\n",
    'ch_pass_admin__message_send_error' => 'Không thể gửi email: %1',

    'ch_pass_by_secret__email_subject' => "Trình nhắc nhở mật khẩu Plesk",
    'ch_pass_by_secret__email_body' => "Xin chào %2,\n\nĐể thiết lập mật khẩu mới, truy cập liên kết: %1\n\nThông tin đăng nhập của bạn: %3",
    'ch_pass_by_secret__message_send_error' => 'Không thể gửi mã bí mật: %1',
    'ch_pass_by_secret__title' => 'Thay Đổi Mật Khẩu Của Bạn',
    'ch_pass_by_secret__secret' => 'Mã bí mật',

    'custom_button__noframe' => "Không sử dụng khung",

    'custom_button__internal_hint' => 'Chỉ định mở URL trên một trang Plesk hay trong một cửa sổ trình duyệt mới.',
    'custom_button__noframe_hint' => 'Nếu bạn thêm nút tùy chỉnh dẫn đến phần mở rộng Plesk hoặc một ứng dụng trong Bảng Điều Khiển Khách Hàng, bạn có thể chỉ định cách phần mở rộng/ứng dụng này sẽ được hiển thị: trong một khung hoặc là một phần của giao diện Plesk GUI.',


    'actionlog__patch' => 'Cập nhật',
    'actionlog__patch_available' => 'có sẵn',
    'actionlog__event_patch_available' => 'Cập nhật sẵn sàng',
    'actionlog__patch_installed' => 'đã được cài đặt',
    'actionlog__event_patch_installed' => 'Cập nhật đã được cài đặt',

    'actionlog__extension' => 'Phần mở rộng',
    'actionlog__extension_status' => 'Trạng thái phần mở rộng',
    'actionlog__cloning' => 'Nhân bản máy chủ',
    'actionlog__cloning_complete' => 'hoàn thành',
    'actionlog__event_cloning_complete' => 'Đã nhân bản xong máy chủ',

    'actionlog__ssl_web_binding' => 'Chứng chỉ SSL/TLS trên miền',
    'actionlog__ssl_web_binding_update' => 'chứng chỉ SSL/TLS trên miền',
    'actionlog__event_ssl_web_binding_update' => 'Đã gán/chưa gán chứng chỉ SSL/TLS trên miền',

    'actionlog__ssl_web_mail_binding' => 'Đã gán/chưa gán',
    'actionlog__ssl_web_mail_binding_update' => 'chứng chỉ SSL/TLS trên webmail',
    'actionlog__event_ssl_web_mail_binding_update' => 'Đã gán/chưa gán chứng chỉ SSL/TLS trên webmail',

    'actionlog__ssl_mail_binding' => 'Đã gán/chưa gán',
    'actionlog__ssl_mail_binding_update' => 'chứng chỉ SSL/TLS trên máy chủ thư',
    'actionlog__event_ssl_mail_binding_update' => 'Đã gán/chưa gán chứng chỉ SSL/TLS trên máy chủ thư',

    'actionlog__ssl_panel_binding' => 'Chứng chỉ SSL/TLS trên Plesk',
    'actionlog__ssl_panel_binding_update' => 'chứng chỉ SSL/TLS trên Plesk',
    'actionlog__event_ssl_panel_binding_update' => 'Đã gán/chưa gán chứng chỉ SSL/TLS trên Plesk',

    'actionlog__hostname' => 'Tên dịch vụ lưu trữ máy chủ',
    'actionlog__hostname_changed' => 'đã thay đổi',

    'actionlog__smb_user' => 'Người dùng bổ sung',
    'actionlog__smb_user_create' => 'Đã tạo người dùng bổ sung',
    'actionlog__smb_user_delete' => 'Đã xóa người dùng bổ sung',
    'actionlog__smb_user_update' => 'Đã cập nhật người dùng bổ sung',

    'actionlog__event_mail_management_status_update' => 'Cập nhật trạng thái quản lý thư',
    'actionlog__mail_management' => 'Trạng thái quản lý thư',
    'actionlog__mail_management_status_update' => 'đã cập nhật',

    'virtualization_openvz' => 'OpenVZ',

    '__domains_total' => 'Tổng số theo miền',

    'chk_js__warning_about_admin_passwd_syntax' => "Bạn không được sử dụng dấu ngoặt kép, khoảng trống, dấu ngoặc đơn và các ký tự trong bảng chữ cái quốc gia trong một mật khẩu.\nMật khẩu phải có độ dài từ %1 đến %2 ký tự, và không được chứa tên người dùng.",

    'passwordSecurityLevelCheckFailed' => 'Mật khẩu của bạn không đủ phức tạp. Theo chính sách của máy chủ, độ mạnh mật khẩu tối thiểu là %1. Để tăng cường độ mạnh mật khẩu, sử dụng số, các ký tự in hoa và in thường và các ký tự đặc biệt như !,@,#,$,%,^,&,*,?,_,~',
    'passwordSecurityLevelCheckFailedVeryWeak' => 'Rất yếu',
    'passwordSecurityLevelCheckFailedWeak' => 'Yếu',
    'passwordSecurityLevelCheckFailedMediocre' => 'Trung bình',
    'passwordSecurityLevelCheckFailedStrong' => 'Mạnh',
    'passwordSecurityLevelCheckFailedStronger' => 'Rất mạnh',

    'filemanager__invalid_path' => "Chỉ định đường dẫn không hợp lệ",

    'ui__client/domain/dns/sync__description' => 'Áp dụng thay đổi từ biểu mẫu DNS trên toàn máy chủ cho vùng này.',
    'ui__client/domain/dns/sync__disabled-warning' => 'Không thể áp dụng thay đổi biểu mẫu DNS cho vùng này bởi vì vùng này được cấp dịch vụ bởi một máy chủ DNS khác.',
    'ui__client/domain/dns/sync__short-title' => 'Áp dụng các thay đổi Mẫu DNS',
    'ui__client/domain/dns/sync__done' => 'Thay đổi từ biểu mẫu DNS đã được áp dụng thành công cho vùng này.',
    'ui__client/domain/domain-alias/dns/sync__description' => 'Áp dụng thay đổi từ biểu mẫu DNS trên toàn máy chủ cho vùng này.',
    'ui__client/domain/domain-alias/dns/sync__disabled-warning' => 'Không thể áp dụng thay đổi biểu mẫu DNS cho vùng này bởi vì vùng này được cấp dịch vụ bởi một máy chủ DNS khác.',
    'ui__client/domain/domain-alias/dns/sync__short-title' => 'Áp dụng các thay đổi Mẫu DNS',
    'ui__client/domain/domain-alias/dns/sync__done' => 'Thay đổi từ biểu mẫu DNS đã được áp dụng thành công cho vùng này.',
    'dns__dns_default_ipv4_modified' => 'Các bản ghi có địa chỉ IP này sẽ được coi là do người dùng chỉnh sửa và sẽ không đồng bộ với các biểu mẫu DNS trên toàn máy chủ.',
    'dns__dns_default_ipv6_modified' => 'Các bản ghi có địa chỉ IP này sẽ được coi là do người dùng chỉnh sửa và sẽ không đồng bộ với các biểu mẫu DNS trên toàn máy chủ.',

    'dns__view_dns_record_master_title' => 'Đang xem bản ghi tài nguyên',
    'dns__view_dns_record_off_title' => 'Đang xem bản ghi máy chủ tên',
    'dns__view_dns_record_slave_title' => 'Đang xem Bản ghi Máy chủ DNS sơ cấp',

    'dns_unable_to_resolve_hostname' => "Không thể giải quyết tên máy chủ \"%1\": %2Đảm bảo bộ phân giải DNS của hệ điều hành được cài đặt và hoạt động đúng.",

    'no_database_server_available' => 'Không có máy chủ cơ sở dữ liệu khả dụng cho thuê bao này.',

    'database_used_by_application_can_not_be_moved' => 'Không thể di chuyển cơ sở dữ liệu: Một ứng dụng web sử dụng cơ sở dữ liệu này.',
    'database_user_update_orphaned_is_restricted' => 'Việc cập nhật các tài khoản cơ sở dữ liệu cô lập là bị cấm. Bạn chỉ có thể xóa hoặc sửa chữa chúng.',

    'database_unable_to_get_max_filesize_default_message' => 'Không thể xác định kích cỡ tệp tối đa của cơ sở dữ liệu: \'%1\'',
    'database_unable_to_set_max_filesize_default_message' => 'Không thể đặt kích cỡ tệp tối đa của cơ sở dữ liệu: \'%1\'',
    'database_unable_to_get_max_log_filesize_default_message' => 'Không thể xác định kích cỡ tệp nhật ký tối đa của cơ sở dữ liệu: \'%1\'',
    'database_unable_to_set_max_log_filesize_default_message' => 'Không thể đặt kích cỡ tệp nhật ký tối đa của cơ sở dữ liệu: \'%1\'',

    'database_unable_to_get_max_filesize' => 'Không thể xác định giới hạn hiện hành về kích thước tập tin của cơ sở dữ liệu Microsoft SQL \'%1\'. Việc cài đặt giới hạn mới là không thể.',
    'database_unable_to_set_max_filesize' => 'Không thể đặt giới hạn cho kích thước tập tin của cơ sở dữ liệu Microsoft SQL \'%1\'.',
    'database_unable_to_get_max_log_filesize' => 'Không thể xác định giới hạn hiện hành về kích thước tập tin nhật ký của cơ sở dữ liệu Microsoft SQL \'%1\'. Việc cài đặt giới hạn mới là không thể.',
    'database_unable_to_set_max_log_filesize' => 'Không thể đặt giới hạn cho kích thước tập tin nhật ký của cơ sở dữ liệu Microsoft SQL \'%1\'.',

    'database_unable_to_create_because_max_filesize' => 'Không thể tạo cơ sở dữ liệu Microsoft SQL \'%1\': Kích cỡ tệp lớn hơn kích cỡ cho phép tối đa.',
    'database_unable_to_move_because_max_filesize' => 'Không thể di chuyển cơ sở dữ liệu Microsoft SQL \'%1\': Kích cỡ tệp của nó lớn hơn kích cỡ cho phép tối đa: %2.',
    'database_unable_to_create_because_max_log_filesize' => 'Không thể tạo cơ sở dữ liệu Microsoft SQL \'%1\': Kích cỡ tệp nhật ký lớn hơn kích cỡ cho phép tối đa.',
    'database_unable_to_move_because_max_log_filesize' => 'Không thể di chuyển cơ sở dữ liệu Microsoft SQL \'%1\': Kích cỡ tệp nhật ký lớn hơn kích cỡ cho phép tối đa: %2.',
    'database_unable_to_restore_because_max_filesize' => 'Không thể khôi phục cơ sở dữ liệu Microsoft SQL \'%1\': Kích cỡ tệp lớn hơn kích cỡ cho phép tối đa.',

    'sandbox_mssql_server_registered_as_usual_db_server' => 'Một máy chủ MS SQL tương tự đã đăng ký trong Plesk. Hãy chỉ định máy chủ MS SQL khác làm hộp cát.',
    'database_server__mssql_server_registered_as_sandbox' => 'Một máy chủ MS SQL hộp cát tương tự đã đăng ký trong Plesk. Hãy chỉ định máy chủ MS SQL khác làm hộp cát.',

    'database_server_mysql_unable_to_connect_via_cli' => 'Không thể kết nối tới máy chủ qua \'%1\': %2',

    'bu_conflict_resolver_feature_not_available' => 'Tính năng %1 không được hỗ trợ bởi các nút dịch vụ sau: %2. Tính năng này sẽ bị hủy kích hoạt đối với tất cả các đối tượng được tạo trên các nút này.',
    'bu_conflict_resolver_feature_not_available_single_server' => 'Tính năng %1 không được hỗ trợ bởi máy chủ này. Tính năng này sẽ bị hủy kích hoạt đối với tất cả các đối tượng được khôi phục.',
    'bu_conflict_resolver_component_unavailable_in_sites' => 'Thành phần %1 không được cài đặt. Nó sẽ không có sẵn cho các trang web sau: {{objects}}',
    'bu_conflict_resolver_component_replaced_in_sites' => 'Thành phần %1 không được cài đặt. Nó sẽ bị thay thế bằng %2 cho các website sau đây: {{objects}}',

    'bu_conflict_resolver_restoration_of_object_end_to_dot_not_supported' => 'Phiên bản Plesk hiện tại không hỗ trợ tên người dùng có ký tự dấu chấm (.). Khách hàng và đại lý có tên người dùng như vậy sẽ không được khôi phục.',
    'bu_conflict_resolver_unable_to_find_backup_part' => 'Không thể tìm tệp sao lưu có dữ liệu cho %1 %2. Dữ liệu cho %1 %2 sẽ không được khôi phục.',

    'bu_conflict_resolver_zone_master_removed' => "Không thể khôi phục bản ghi DNS chính: Bản ghi trong vùng phụ trỏ đến địa chỉ IP hiện tại %1. Bản ghi DNS chính sẽ bị gỡ bỏ khỏi vùng phụ.",

    'bu_conflict_resolver_not_available_scripting' => '%1 không được hỗ trợ.',
    'bu_conflict_resolver_not_available_scripting_in_sites' => '%1 không được hỗ trợ. Nó sẽ không có sẵn cho các trang web sau: {{objects}}',
    'bu_conflict_resolver_not_available_component' => 'Thành phần %1 không được cài đặt.',
    'bu_conflict_resolver_disabled_in_multi_server' => 'Nó sẽ không có sẵn cho các điểm dịch vụ sau: {{objects}}',
    'bu_conflict_resolver_disabled_in_single_server' => 'Nó sẽ không có sẵn cho các chủ đề sau: {{objects}}',
    'bu_conflict_resolver_not_available_db' => 'Các máy chủ cơ sở dữ liệu sau đây không khả dụng trên máy chủ này: %1.',

    'bu_conflict_resolver_mssql_native_dump_restore_not_available' => 'Tập tin sao lưu cơ sở dữ liệu MS SQL được lưu trữ ở định dạng gốc MS SQL, chỉ có thể được phục hồi sang máy chủ MS SQL cục bộ hoặc máy chủ MS SQL từ xa với các cài đặt được cấu hình đầy đủ. Một số cơ sở dữ liệu của bạn không được khôi phục bởi vì không có máy chủ MS SQL thích hợp được đăng ký trong Plesk. Các miền sau bị ảnh hưởng: {{objects}}. Vui lòng liên hệ với nhà cung cấp dịch vụ lưu trữ.',

    'bu_conflict_resolver_not_available_webmail' => 'Dịch vụ webmail %1 không khả dụng. Nó sẽ bị thay thế bằng %2 cho các đối tượng sau đây: {{objects}}',
    'bu_conflict_resolver_not_available_webmail_plan' => 'Dịch vụ webmail %1 không khả dụng. Nó sẽ bị thay thế bằng %2 cho các gói dịch vụ sau đây: {{objects}}',
    'bu_conflict_resolver_not_available_rename_db_user' => "Các cơ sở dữ liệu loại '%1' không hỗ trợ tên người dùng trung với tên cơ sở dữ liệu. Người dùng '%2' sẽ bị đổi tên '%3' cho cơ sở dữ liệu '%4'.",

    'bu_conflict_resolver_wrong_hard_quota_value' => 'Giới hạn tình trạng sử dụng máy chủ đích không được thiết lập trong cấu hình máy chủ đích. Giá trị cho cài đặt này sẽ được đổi thành "Không giới hạn".',
    'bu_conflict_resolver_wrong_max_connections_value' => 'Giới hạn số kết nối không được thiết lập trong cấu hình máy chủ đích. Giá trị cho cài đặt này sẽ được đổi thành "Không giới hạn".',
    'bu_conflict_resolver_wrong_traffic_bandwidth_value' => 'Giới hạn tình trạng sử dụng lưu lượng không được thiết lập trong cấu hình máy chủ đích. Giá trị cho cài đặt này sẽ được đổi thành "Không giới hạn".',
    'cu__pleskrestore_backup_file_extracted' => 'Tệp sao lưu được rút về "%1".',
    '__mod_bw_not_supported' => 'Mô-đun mod_bw cho máy chủ web Apache không được hỗ trợ do cấu hình của hệ thống tập tin. Giới hạn mức độ sử dụng lưu lượng và số kết nối tối đa sẽ không hoạt động.',
    'bu_conflict_resolver_pop3_only_relay_auth_not_supported' => 'Ủy quyền POP3 cho chuyển tiếp thư không được hỗ trợ, ủy quyền POP3 trước SMTP sẽ được sử dụng thay thế. ({{objects}})',
    'bu_conflict_resolver_service_plan_name' => 'Gói dịch vụ \'%1\'',
    'bu_conflict_resolver_replaced_in_plans' => '%1 không được hỗ trợ. Nó sẽ bị thay thế bằng %2 cho các gói dịch vụ sau đây: {{objects}}',
    'bu_conflict_resolver_replaced_in_sites' => '%1 không được hỗ trợ. Nó sẽ bị thay thế bằng %2 cho các website sau đây: {{objects}}',
    'bu_conflict_resolver_absent_objects_in_dump' => 'Những đối tượng sau đây không tìm thấy trong tệp sao lưu: %1',
    'bu_conflict_resolver_absent_domains' => 'Một số đối tượng không thể được khôi phục vì chúng thuộc về các miền sau đây, và không thể tìm thấy trong Plesk: %1',
    'bu_conflict_resolver_absent_parent_domains' => "Một số website không thể được khôi phục vì chúng thuộc về các miền chính sau đây, và không thể tìm thấy trong Plesk:\n%1",
    'bu_conflict_resolver_dns_not_supported' => 'Không thể khôi phục các vùng DNS: Dịch vụ DNS đã bị tắt trong cấu hình máy chủ.',
    'bu_conflict_resolver_mail_not_supported' => 'Không thể khôi phục hòm thư: Dịch vụ thư đã bị tắt trong cấu hình máy chủ.',
    'bu_conflict_resolver__cpu_limit_action_not_supported' => 'Hành động giới hạn CPU đã chỉ định không được hỗ trợ bởi máy chủ web IIS. Giá trị sẽ được thiết lập lại về %1.',
    'bu_conflict_detector_server_ssl_cert_name' => 'Chứng nhận SSL/TLS máy chủ %1',
    'bu_conflict_detector_domain_ssl_cert_name' => 'Chứng nhận SSL/TLS %2 của miền %1',
    'bu_conflict_detector_ssl_cert_name' => 'Chứng nhận SSL/TLS %1',
    'bu_conflict_resolver_absent_objects' => 'Nội dung của các đối tượng sau đây không thể khôi phục được bởi vì các đối tượng này không tìm thấy trong Plesk: %1',
    'bu_conflict_resolver_absent_objects_mailuser' => 'Nội dung của các hòm thư sau đây không thể khôi phục được bởi vì các hòm thư này không tìm thấy trong Plesk: %1',
    'bu_conflict_resolver_absent_objects_maillist' => 'Nội dung của các danh sách gửi thư sau đây không thể khôi phục được bởi vì các danh sách gửi thư này không tìm thấy trong Plesk: %1',
    'bu_conflict_resolver_absent_objects_database' => 'Nội dung của các cơ sở dữ liệu sau đây không thể khôi phục được bởi vì các cơ sở dữ liệu này không tìm thấy trong Plesk: %1',
    'bu_conflict_resolver__remove_conflicted_aps_app' => 'Việc khôi phục ứng dụng "%1" trên "%2" đã không thành công do có ứng dụng khác đã cài đặt vào "%3". Bạn có thể loại bỏ ứng dụng đã cài đặt và thử lại.',
    'bu_conflict_resolver_not_available_mail_autoresponders' => 'Chức năng tự động trả lời thư không được hỗ trợ.',
    'bu_conflict_resolver_not_available_mail_content' => 'Khôi phục nội dung thư không được hỗ trợ.',
    'bu_conflict_resolver_invalid_mail_name' => 'Các hòm thư sau chưa được khôi phục bởi tính năng định địa chỉ phụ email đã được bật, và một số địa chỉ email có dấu "%1": %2',
    'bu_conflict_resolver_invalid_user_name' => 'Những người dùng sau chưa được khôi phục bởi tính năng định địa chỉ phụ email đã được bật, và một số địa chỉ email có dấu "%1": %2',
    'bu_conflict_resolver_licenses_expired' => 'Những bản quyền sau đã hết hạn và sẽ không được khôi phục: {{objects}}',
    'bu_conflict_resolver_licenses_invalid' => 'Những bản quyền sau không hợp lệ hoặc đã hết hạn và sẽ không được khôi phục: {{objects}}',
    'expiration_unsupported' => "Giới hạn 'hết hạn' không được hỗ trợ.",

    'component_name__dbconnector' => "Bộ kết nối cơ sở dữ liệu",
    'component_name__mysqlserver' => 'Máy chủ MySQL',
    'component_name__troubleshooting' => 'Xử lý sự cố',
    'component_name__savi' => 'Giao diện Sophos Anti-Virus',

    '__subscription_has_no_license_key' => 'Các tài nguyên đăng ký được cung cấp bởi nút dịch vụ #%1 mà nút này không có key bản quyền đi kèm.',
    '__subscription_has_expired_license_key' => 'Các tài nguyên đăng ký được cung cấp bởi nút dịch vụ #%1 có key bản quyền %2 đã hết hạn.',

    '__cfgmonConfigurationFileSaveErrorSubject' => '<%%host%%>Không thể lưu một số tập tin cấu hình',
    '__cfgmonConfigurationFileSaveErrorBody' => "Không thể lưu một số tập tin cấu hình trên bộ lưu trữ <%%host%%>: Xảy ra các lỗi sau:\n\n%%errors%%",

    'mail__enable_email_subaddressing_cli_desc' => 'Tùy chọn này cho phép khả năng cấu hình các địa chỉ email kiểu VERP cho danh sách thư',
    'mail__enter_right_ip_mask' => "Nhập mặt nạ IP giữa 1 và 32",
    'mail__enter_right_ip_mask_24' => "Nhập mặt nạ IP giữa 24 và 32",
    'mail__invalid_dom_name' => "Tên miền %1 không hợp lệ.",
    'mail__invalid_pop_lock_time' => "Thời gian khóa POP3 không hợp lệ.",
    'mail__invalid_rbl_server' => "Tên vùng DNS không hợp lệ.",
    'mail__total_files_size' => "Tổng kích thước kho lưu trữ: %1",
    'mail__filename_already_in_repository' => "Tệp có cùng tên này đã có trong kho chứa",
    'mail__no_white_list_mask_feature_24' => "Sử dụng giá trị mặt nạ là 24 hoặc cao hơn.\nMáy chủ thư của bạn không hỗ trợ cài đặt các mặt nạ. Chúng tôi chỉ có thể thiết lập mô phỏng mặt nạ cho các giá trị không nhỏ hơn 24.",
    'mail__unable_add_new_mail_name' => "Không thể thêm tài khoản thư: %1",
    'mail_server_is_not_installed' => 'Máy chủ thư (Postfix hoặc Qmail) chưa được cài đặt. Cài đặt để tiếp tục công việc.',
    'mail_server_not_available' => 'Không có máy chủ thư được hỗ trợ nào khả dụng trên nút dịch vụ.',
    '__not_installed' => '(không được cài đặt)',
    'mail__service_node_outgoing_messages_is_disabled' => 'Lọc thư rác trên tin nhắn email gửi đi bị hủy kích hoạt.',
    'mail__service_node_does_not_support_outgoing_messages_domain_limit' => 'Nút dịch vụ không hỗ trợ giới hạn số tin nhắn email gửi đi từ một miền cho miền %1.',
    'mail__service_node_does_not_support_outgoing_messages_mbox_limit' => 'Nút dịch vụ không hỗ trợ giới hạn số tin nhắn email gửi đi từ một hòm thư cho miền %1.',

    'mail__outgoing_email_mode_explicit_ip_unspecified' => 'Chỉ định một địa chỉ thuộc ít nhất một loại (IPv4 hoặc IPv6).',

    'mail__outgoing_email_mode_invalid' => 'Chỉ định một chế độ thư gửi đi không hợp lệ.',
    'mail__outgoing_email_mode_explicit_ip_v4_invalid' => 'Chỉ định một địa chỉ IPv4 không hợp lệ.',
    'mail__outgoing_email_mode_explicit_ip_v6_invalid' => 'Chỉ định một địa chỉ IPv6 không hợp lệ.',
    'mail__outgoing_email_mode_unavailable' => 'Thay đổi chế độ thư gửi đi không được hỗ trợ, có thể bởi vì máy chủ thư Hậu tố không được cài đặt trên máy chủ này.',

    'mail__autoresponder_attachment_not_supported' => 'Máy chủ thư hiện đang sử dụng không hỗ trợ quản lý đính kèm tự động phản hồi.',

    'mail__smtp_white_list_not_supported' => 'Máy chủ thư đang sử dụng hiện tại không hỗ trợ cho địa chỉ IP vào sổ trắng.',
    'mail__smtp_whitelist_cidr_not_supported' => 'Mặt nạ CIDR không được máy chủ thư đang chọn hỗ trợ. Chỉ định địa chỉ IP theo định dạng "192.*.0.*".',
    'mail__smtp_whitelist_mask_not_supported' => 'Kiểu mẫu IP ký tự đại diện không được máy chủ thư đang chọn hỗ trợ. Chỉ định địa chỉ IP theo định dạng "192.0.0.0/8".',

    'sfdk_server_wide_verify_failed' => 'Không thể thay đổi các thiết lập cho dịch vụ xác minh DKIM',

    'sfdk_domain__serverwide_disabled' => 'Đã tắt theo chính sách của máy chủ',
    'feature__domainkeys__serverwide_disabled' => 'Bảo vệ chống thư rác DKIM trên toàn máy chủ đã tắt',

    'defaultcomponents__error_set_default' => 'Không thể cài đặt %1 làm %2 mặc định: %3',
    'defaultcomponents__error_set_default_none' => 'Không thể đặt thành phần mặc định rỗng cho %1: %2',
    'defaultcomponents__required_package_not_default' => 'Thành phần %1 được yêu cầu cho hoạt động này không phải là mặc định.',

    '__percentage' => '%',
    '__seconds' => 'Giây',
    '__resource_remain' => 'Còn lại',

    '__not_registered' => '(không được đăng ký)',
    '__php_handler_id' => 'Phiên bản PHP',
    '__php_handler_id_string' => 'PHP %1 (%2)',
    '__php_handler_not_registered' => 'Bộ quản lý PHP "%1" không được đăng ký. Nó có thể đã bị xóa khỏi máy chủ. Đăng ký một bộ quản lý có cùng đặc tính và thử lại.',
    '__php_handler_not_registered_on_domain' => 'Miền "%1": Bộ quản lý PHP "%2" không được đăng ký. Nó có thể đã bị xóa khỏi máy chủ. Đăng ký một bộ quản lý có cùng đặc tính và thử lại.',
    '__php_fpm_handler' => 'Ứng dụng FPM',
    '__php_fpm-dedicated_handler' => 'Ứng dụng FPM chuyên dụng',

    'mailname_create_assigned_user_dublicate_error' => 'Không thể tạo người dùng cho hòm thư. Người dùng có tên người dùng %1 đã tồn tại và có một hòm thư khác.',
    'mailname_create_assigned_user_role_absent_error' => 'Không thể tạo người dùng cho hòm thư. Vai trò mặc định %1 của người dùng không tồn tại.',

    'gphd__mime_types' => 'Các loại MIME',
    'gphd__handlers' => 'Bộ quản lý Apache',
    'gphd__ip_restrictions_allow' => 'Cho phép truy cập vào trang đối với các bộ lưu trữ và mạng chỉ định (không bao gồm những trang đã bị từ chối)',
    'gphd__ip_restrictions_deny' => 'Từ chối truy cập vào trang đối với các bộ lưu trữ và mạng chỉ định',
    'gphd__directory_index' => 'Các tập tin chỉ mục',
    'gphd__nginx_transparent_mode' => 'Chế độ khi Apache xử lý cả nội dung tĩnh và động, trong khi nginx chỉ thông qua các yêu cầu và phản hồi HTTP mà không thay đổi.',
    'gphd__nginx_serve_static' => 'Phục vụ trực tiếp các tập tin tĩnh bằng nginx',
    'gphd__nginx_static_extensions' => 'Các mở rộng tập tin tĩnh phải được xử lý bằng nginx',
    'gphd__nginx_serve_php' => 'Xử lý các tập tin PHP bằng nginx',
    'gphd__www_root' => 'Kho lưu trữ Gốc WWW',

    'eol__none' => 'không hiệu chỉnh',
    'eol__lf' => 'Chuyển sang kiểu Unix',
    'eol__cr' => 'Chuyển sang kiểu MacOS',
    'eol__crlf' => 'Chuyển sang kiểu Windows',

    'ui__dns_bad_zone' => 'Vùng không nhất quán "%1":',
    'ui__dns_ns_has_no_address_records' => 'Bản ghi NS "%1" không có các bản ghi địa chỉ (A hoặc AAAA).',
    '__dns_bad_zone' => 'Vùng không nhất quán "%1":',
    '__dns_ns_has_no_address_records' => 'Bản ghi NS "%1" không có các bản ghi địa chỉ (A hoặc AAAA).',
    '__dns_ptr_is_wildcard' => 'Bản ghi PTR "%1" không hợp lệ: Bản ghi trỏ đến một miền ký tự đại diện.',

    'firewall_database_user_remote_access_rule_name' => '[%1][%2] Cho phép truy cập từ xa cho người dùng cơ sở dữ liệu \'%3\' của khách hàng \'%4\'',
    'firewall_database_user_remote_access_rule_name_removed' => '[%1][%2] %3',
    'firewall_database_user_remote_access_mssql_server_port_undefined' => 'Không thể cho phép kết nối từ xa cho người dùng cơ sở dữ liệu \'%1\': Không thể xác định số cổng TCP sử dụng bởi máy chủ Microsoft SQL \'%2\'. Những nguyên nhân có thể gặp: Giao thức TCP/IP không được kích hoạt trong cấu hình mạng máy chủ hoặc máy chủ được cấu hình để sử dụng cổng TCP động. Cấu hình máy chủ để theo dõi trên một cổng TCP cố định và cho phép kết nối từ xa lại lần nữa.',

    'command__convertResellerHasCustomer' => 'Tài khoản bán lẻ \'%1\' có một hoặc nhiều tài khoản khách hàng. Để chuyển tài khoản bán lẻ này thành tài khoản khách hàng, trước tiên chuyển các tài khoản khách hàng này sang một chủ sở hữu mới hoặc chuyển chúng hoặc chuyển chúng thành các tài khoản bán lẻ.',
    'command__convertResellerNotReseller' => 'Chỉ các tài khoản bán lẻ mới có thể chuyển được thành tài khoản khách hàng. \'%1\' không phải là đại lý.',
    'command__convertResellerToCustomerSubscriptionNotSynchronized' => 'Không thể đồng bộ thuê bao với gói dịch vụ. Các thiết lập dưới đây của thuê bao xung đột với gói dịch vụ: %%problems%%.',

    'moveCustomer__wrong_customer_type' => 'Tài khoản \'%1\' là một tài khoản bán lẻ. Các tài khoản bán lẻ không thể được chuyển cho một chủ sở hữu mới vì chúng được sở hữu bởi quản trị viên máy chủ.',
    'moveCustomer__wrong_owner_type' => "Tài khoản khách hàng '%1' chỉ có thể được chuyển cho một đại lý hoặc quản trị viên, không được chuyển cho khách hàng khác.",
    'moveCustomer__customer_already_belongs_to_owner' => 'Tài khoản khách hàng \'%1\' đã thuộc về chủ sở hữu được chọn.',
    'upgradeClient__user_is_admin' => 'Tài khoản \'%1\' không thể chuyển được thành tài khoản bán lẻ bởi vì đây là một tài khoản quản trị viên.',

    'mail__error_setting_max_connections_courier' => 'Không thể đặt số lượng tối đa của kết nối (IMAP, POP3, IMAP trên SSL/TLS hoặc POP3 trên SSL/TLS): %1',
    'mail__error_setting_max_connections_dovecot' => 'Không thể đặt số lượng tối đa của kết nối (IMAP, POP3, IMAP trên SSL/TLS hoặc POP3 trên SSL/TLS): %1',
    'mail__error_setting_max_connections_per_ip_courier' => 'Không thể đặt số lượng tối đa của kết nối (IMAP, POP3, IMAP trên SSL/TLS hoặc POP3 trên SSL/TLS) trên mỗi địa chỉ IP: %1',
    'mail__error_setting_max_connections_per_ip_dovecot' => 'Không thể đặt số lượng tối đa của kết nối (IMAP, POP3, IMAP trên SSL/TLS hoặc POP3 trên SSL/TLS) trên mỗi địa chỉ IP cho người dùng thư cụ thể: %1',
    'outgoing_messages_limit_value_invalid' => 'Giá trị phải nằm trong phạm vi %%MIN%%..%%MAX%%. Chỉ quản trị viên Plesk mới có thể điều chỉnh cài đặt này.',
    'outgoing_messages_server_settings_catch_address_are_not_local' => "Các miền sau sử dụng các địa chỉ email bên ngoài để chuyển tiếp thư của thư gửi đến địa chỉ không tồn tại. Tin nhắn gửi đến các địa chỉ này sẽ không được tính trong Trình quản lý thư gửi đi:\n %1",
    'outgoing_messages_white_list_not_empty' => 'Giới hạn trên thư gửi đi sẽ không hoạt động với những người gửi thư có địa chỉ IP trong danh sách trắng của máy chủ thư. Ví dụ, nếu có một lưu trữ nội bộ (127.0.0.0 / 8, ::1 / 128) trong danh sách trắng, tất cả thư từ máy chủ nội bộ sẽ được gửi thành công kể cả có giới hạn. Người gửi thư có thể sử dụng các địa chỉ IP nội bộ (website và các tập lệnh tùy chỉnh lưu trữ trên máy chủ nội bộ) hoặc các địa chỉ bên ngoài (khách hàng gửi thư từ máy khách thư cài đặt trên máy tính hoặc thiết bị di động của họ). Để các giới hạn hoạt động cho tất cả người gửi thư (cả nội bộ và bên ngoài), gỡ bỏ tất cả các địa chỉ IP và mạng khỏi danh sách trắng. Lưu ý rằng gỡ bỏ lưu trữ nội bộ (127.0.0.0 / 8, ::1 / 128) ra khỏi danh sách trắng có thể làm giám đoạn hoạt động của các website và các tập lệnh gửi thư từ máy chủ này. Chi tiết về giới hạn thư gửi đi, xem Hướng dẫn của quản trị viên, Bảo vệ khỏi Thư rác từ bên ngoài.',
    'outgoing_messages_relay_open' => 'Chuyển tiếp thư đang mở: Giới hạn trên thư gửi đi sẽ không hoạt động.',

    'notification_aps_app_updates_available' => 'Cập nhật khả dụng cho các ứng dụng sau:',
    'notification_aps_app_updates_installed' => 'Cập nhật được tự động cài đặt cho các ứng dụng sau:',
    'notification_aps_app_updates_requirements' => 'Cập nhật khả dụng cho các ứng dụng sau nhưng không thể được cài đặt bởi vì Cài đặt lưu trữ của website tương ứng không đáp ứng các yêu cầu cài đặt:',
    'notification_admin_aps_app_updates_available_item' => '%%name%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_admin_aps_app_updates_available_plugin_item' => 'Trình cắm "%%name%%" trên %%parentName%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_admin_aps_app_updates_available_theme_item' => 'Chủ đề "%%name%%" trên %%parentName%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_reseller_aps_app_updates_available_item' => '%%name%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_reseller_aps_app_updates_available_plugin_item' => 'Trình cắm "%%name%%" trên %%parentName%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_reseller_aps_app_updates_available_theme_item' => 'Chủ đề "%%name%%" trên %%parentName%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_client_aps_app_updates_available_item' => '%%name%% (%%url%%). Phiên bản của bạn: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_client_aps_app_updates_available_plugin_item' => 'Trình cắm "%%name%%" trên %%parentName%% (%%url%%). Phiên bản của bạn: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_client_aps_app_updates_available_theme_item' => 'Chủ đề "%%name%%" trên %%parentName%% (%%url%%). Phiên bản của bạn: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_admin_aps_app_updates_installed_item' => '%%name%% (%%url%%). Phiên bản mới: %%to%%. Phiên bản cũ: %%from%%.',
    'notification_reseller_aps_app_updates_installed_item' => '%%name%% (%%url%%). Phiên bản mới: %%to%%. Phiên bản cũ: %%from%%.',
    'notification_client_aps_app_updates_installed_item' => '%%name%% (%%url%%). Phiên bản mới: %%to%%. Phiên bản cũ: %%from%%.',
    'notification_admin_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_reseller_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Phiên bản được cài đặt: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_client_aps_app_updates_requirements_item' => '%%name%% (%%url%%). Phiên bản của bạn: %%from%%. Phiên bản khả dụng: %%to%%.',
    'notification_aps_app_updates_no_installation_url' => 'ứng dụng ngoài',

    'notification_outgoing_mail_exceeded_limits_domains' => 'Các tên miền',
    'notification_outgoing_mail_exceeded_limits_mails' => 'Địa chỉ email',
    'notification_outgoing_mail_exceeded_limits_subscriptions' => 'Thuê bao',
    'notification_outgoing_mail_exceeded_limits_limit_value' => '%1 tin nhắn mỗi giờ',
    'notification_outgoing_mail_exceeded_limits_limit_value_unlimited' => 'Không giới hạn',
    'notification_outgoing_mail_exceeded_limits_object' => '%1, giới hạn là %2',
    'notification_outgoing_mail_exceeded_limits_attempt' => '%1 lần vượt quá giới hạn từ %2 đến %3',
    'notification_outgoing_mail_exceeded_limits_attempt_still_exceeding' => '%1 lần vượt quá giới hạn từ %2 cho đến nay',

    'restart__docker' => "Docker",
    'restart__fail2ban' => "Cấm địa chỉ IP (Fail2ban)",

    'backup__restore__capability_fail2ban_not_installed_text' => 'Thành phần Fail2ban không được cài đặt trên máy chủ đích.',
    'backup__restore__capability_fail2ban_not_installed_resolution' => 'Cài đặt Fail2ban. Lưu ý rằng hoạt động này có thể mất vài phút.',

    'plesk_key__no_reseller_support' => 'Bạn không thể quản lý đại lý do giới hạn bản quyền.',
    'plesk_key__no_customers_support' => 'Bạn không thể quản lý khách hàng do giới hạn bản quyền.',
    'panel_interface_uimodes__service_provider_view_not_allowed' => 'Không thể chuyển sang Giao diện nhà cung cấp dịch vụ do giới hạn bản quyền.',
    'plesk_key__no_security_core_support' => 'Các tính năng lõi bảo mật (ModSecurity và Fail2Ban) không khả dụng do giới hạn bản quyền.',
    'plesk_key__outgoing-antispam' => 'Quản lý thư gửi đi',
    'plesk_key__security-core' => 'Lõi bảo mật (ModSecurity và Fail2Ban)',
    'plesk_key__can-manage-accounts' => 'Quản lý tài khoản',
    'plesk_key__can-manage-subscriptions' => 'Quản lý thuê bao',
    'plesk_key__can-manage-customers' => 'Quản lý khách hàng',
    'plesk_key__can-manage-resellers' => 'Quản lý đại lý',
    'plesk_key__can-manage-custom-view' => 'Có Chế độ hạn chế',
    'plesk_key__limits_exceeded_no_subscriptions_management' => 'Quản lý thuê bao đang bị tắt nhưng bạn có một số thuê bao (%1).',
    'plesk_key__limits_exceeded_no_resellers_management' => 'Quản lý đại lý đang bị tắt nhưng bạn có một số đại ý (%1).',
    'plesk_key__limits_exceeded_no_customers_management' => 'Quản lý khách hàng bị tắt, nhưng bạn có một vài khách hàng (%1).',
    'plesk_key__limits_unlimited_subscriptions' => 'Một số tài nguyên thuê bao mà bạn không còn có thể quản lý trong giao diện Plesk (chẳng hạn như giới hạn về hộp thư và không gian đĩa của miền) hiện được đặt thành không giới hạn.',
    'plesk_key__no_subscriptions_support' => 'Bạn không thể quản lý thuê bao do giới hạn bản quyền.',
    'plesk_key__no_custom_view_support' => 'Bạn không thể sử dụng Chế độ hạn chế do giới hạn bản quyền.',
    'plesk_key__trial_forbidden_region' => 'Rất tiếc, Plesk hiện chưa sẵn sàng tại khu vực của bạn.',
    'additional_key__main_key' => 'Key này là một key chính: Bạn không thể tải lên một key chính như một key bổ sung.',

    'gch__hosting_waf_rule_engine' => 'Chế độ tường lửa ứng dụng web',

    'backup__fieldset__restoration_options' => 'Các tùy chọn khôi phục',
    'backup__restore_options__restore' => 'Khôi phục',
    'backup__restore_options__domain__domain_configuration' => 'Cấu hình miền',
    'backup__restore_options__domain__virtual_host_content' => 'Nội dung máy chủ ảo',
    'backup__restore_options__domain__mail' => 'Thư',
    'backup__restore_options__domain__databases' => 'Cơ sở dữ liệu',
    'backup__restore_options__client__client_configuration' => 'Cấu hình tài khoản khách hàng',
    'backup__restore_options__client__domains' => "Miền của khách hàng",
    'backup__restore_options__reseller__reseller_configuration' => 'Cấu hình tài khoản bán lẻ',
    'backup__restore_options__reseller__personal_domains' => "Miền của đại lý",
    'backup__restore_options__reseller__clients' => "Khách hàng của đại lý",
    'backup__restore_options__admin__server_configuration' => 'Các thiết lập máy chủ',
    'backup__restore_options__admin__administrator_configuration' => 'Cấu hình tài khoản quản trị',
    'backup__restore_options__admin__personal_domains' => "Tên miền của người quản trị",
    'backup__restore_options__admin__personal_clients' => "Khách hàng của người quản trị",
    'backup__restore_options__admin__resellers' => 'Các đại lý',

    'badge_new' => 'Mới',
    'upgrade_php_on_subscription' => 'Nâng cấp PHP trên thuê bảo của bạn lên phiên bản 5.3.0 hoặc mới hơn.',

    'pkey_notify__body_expiration_notification' => 'Key bản quyền bị hết hạn. Một số tính năng có thể không có sẵn. Vui lòng liên hệ với nhà cung cấp dịch vụ lưu trữ.',

    'crontab__crontab_entry_exists' => "Tác vụ được lập lịch đã tồn tại.",
    'crontab__crontab_entry_not_exists' => "Tác vụ được lập lịch không tồn tại.",
    'crontab__invalid_values_found' => "Các giá trị của tham số không chính xác.",
    'crontab__cmd_max_len' => "Lệnh không được dài hơn %1 ký tự.",

    'domain__domain_exists' => "Có một miền có tiền tố 'www' và có tên tương tự: %1.%2.",
    'domain__subdomain_exists' => "Có một tên miền phụ có tiền tố 'www' và có tên tương tự: %1.%2.",
    'domain__dalias_exists' => "Có một bí danh miền có tiền tố 'www' và có tên tương tự: %1.%2.",
    'domain__record_exists' => "Có một bản ghi DNS trỏ đến máy chủ %1.%2.",

    'ip_addr__cannot_assign_certificate' => "Không thể đặt chứng nhận '%1' làm mặc định: khóa riêng bị thiếu.",
    'ip_addr__update_dns_error' => 'Xảy ra vấn đề khi cập nhật các địa chỉ IP trong vùng DNS. %1',
    'ip_addr__cannot_add_dhcp_enabled' => 'Không thể thêm địa chỉ IP. Giao diện mạng này tự động nhận địa chỉ IP.',
    'ip_addr__cannot_remove_dhcp_enabled' => 'Không thể xóa địa chỉ IP %1: Giao diện mạng này tự động nhận địa chỉ IP.',
    'ip_addr__cannot_repair_dhcp_enabled' => 'Không thể sửa địa chỉ IP %1: Giao diện mạng này tự động nhận địa chỉ IP.',
    'ip_addr__cannot_change_interface_dhcp_enabled' => 'Không thể thay đổi giao diện của địa chỉ IP %1 bởi vì giao diện mạng %2 tự động nhận địa chỉ IP.',

    'shm_lmsg__limit_for_resource_exceeded' => 'Đã vượt quá giới hạn thuê bao trên số %%type%%. Giới hạn là %%limit%%, và %%usage%% hiện đang được sử dụng.',
    'shm_lmsg__resource_is_forbidden_for_creation' => 'Không được phép tạo %%type%% trên thuê bao này.',
    'shm_lmsg__resource_title__db-mysql' => 'CSDL MySQL',
    'shm_lmsg__resource_title__db-mssql' => 'Cơ sở dữ liệu MS SQL',
    'shm_lmsg__resource_title__db-postgresql' => 'Cơ sở dữ liệu PostgreSQL',
    'shm_lmsg__resource_title__db-user' => 'người dùng cơ sở dữ liệu',
    'shm_lmsg__resource_title__iis-application-pool' => 'Kho ứng dụng IIS',
    'shm_lmsg__resource_title__additional-ftp-account' => 'Các tài khoản FTP bổ sung',

    'db_user_unable_remove_mysql_global_privileges' => 'Không thể gỡ bỏ đặc quyền toàn cầu MySQL của người dùng cơ sở dữ liệu %1. Lý do: %2',
    'report__client_description' => 'Mô tả',

    'db__user_role_error' => 'Đã chỉ định vai trò của người dùng cơ sở dữ liệu không chính xác: %1. Hãy chọn một trong những vai trò sau: %2.',

    'subscription_unable_to_set_max_filesize_warning' => 'Không thể thiết lập giới hạn kích thước tập tin cho cơ sở dữ liệu Microsoft SQL Server sau vì chúng có kích thước tập tin lớn hơn: %1.',
    'subscription_unable_to_set_max_log_filesize_warning' => 'Không thể thiết lập giới hạn kích thước tập tin nhật ký cho cơ sở dữ liệu Microsoft SQL Server sau vì chúng có kích thước tập tin lớn hơn: %1.',
    'ipaddress__cannot_set_up_public_ip_need_ipaddress' => 'Không thể thiết lập địa chỉ IP công cộng: phải có địa chỉ IP riêng.',
    'ipaddress__cannot_set_up_public_ip_need_ipv6' => 'Không thể thiết lập địa chỉ IPv4 nào cho địa chỉ IPv6.',
    'ipaddress__cannot_set_up_public_ip_need_ipv4' => 'Không thể thiết lập địa chỉ IPv6 nào cho địa chỉ IPv4.',
    'ipaddress__cannot_set_up_public_ip_invalid' => 'Không thể thiết lập địa chỉ IP công cộng: địa chỉ IP không hợp lệ.',

    '__user_already_exists' => "Người dùng %1 đã tồn tại.",
    '__user_name_is_empty' => "Hãy chỉ định tên người dùng.",

    'upgrade_php_on_domain' => 'Không thể tìm thấy phiên bản PHP 5.3.0 hoặc mới hơn trên bất kỳ tên miền WordPress nào của bạn. Thử nâng cấp PHP.',

    'component_name__waf' => 'Tường lửa Ứng Dụng Web',
    'component_name__vcs' => 'Hệ Điều Khiển Phiên Bản',

    'virtualization_lxc' => 'LXC',
    'virtualization_docker' => 'Docker',
    'possibleSpoofingDetected' => 'Phát hiện có thể có giả mạo: Liên kết cố hiển thị nội dung không thích hợp.',
    'forceResetPasswordUpdated' => 'Mật khẩu của bạn đã được thay đổi. Hãy sử dụng mật khẩu mới để đăng nhập vào Plesk.',

    'php_handlers_error_no_available_instance' => 'Nhấn để tạo tên miền: không có bộ xử lý PHP có sẵn.',
    'domain_error_unable_to_apply_hosting_settings' => 'Không thể áp dụng cài đặt lưu trữ: %1',

    'plesk_not_configured' => 'Plesk chưa được cấu hình. Đi đến bảng điều khiển để thực hiện cấu hình sau cài đặt.',
    'cmd_mail__mail_password_duplicated' => 'Cặp địa chỉ và mật khẩu chỉ định đã tồn tại trên máy chủ thư. Hãy chỉ định địa chỉ email hoặc mật khẩu khác.',

    'extensionRequirementOs' => 'Hệ điều hành (%1) không được gói phần mềm này hỗ trợ.',
    'extensionRequirementPleskMinVersion' => 'Plesk %1 là phiên bản sớm nhất được gói phần mềm này hỗ trợ.',
    'extensionRequirementPleskMaxVersion' => 'Bắt đầu từ phiên bản Plesk %1 không được gói phần mềm này hỗ trợ.',
    'extensionBlacklisted' => 'Đuôi mở rộng %1 không được cho phép để cài đặt.',
    'extensionDisabled' => 'Phần mở rộng bị vô hiệu hóa.',


    'optimization_settings__unable_set_mpm_event' => 'Không thể thiết lập chế độ mpm_event: yêu cầu phải tắt mô-đun Apache PHP5 tắt nhưng mô-đun này được sử dụng bởi các tên miền.',
    'optimization_settings__unable_turn_off_php' => 'Không thể tắt mô-đun Apache PHP5: nó được sử dụng bởi các tên miền.',

    'hst_def__fp_admin_login' =>  'Tên người dùng FTP',
    'hst_def__fp_admin_passwd' =>  'Mật Khẩu FTP',

    'database_user_orphaned_old_password_wrong' => "Không thể sửa người dùng cô lập \\’%1\\’: mật khẩu không đúng.",
    'cannot_load_partner_central_property_key_no_exist' => "Không thể truy xuất các thuộc tính tùy chỉnh: khóa bản quyền không tồn tại.",
    'extensionScriptFailure' => "Thực thi %1 thất bại kèm thông báo sau:\n%3",
    '__ssl_redirect' => "301 an toàn SEO vĩnh viễn được chuyển hướng từ HTTP sang HTTPS",
    'component_name__dotnetcore' => '.NET Core',
    'mail__dkim_not_supported' => 'Quản trị DKIM không được hỗ trợ.',
    'mail__dmarc_not_supported' => 'Không hỗ trợ quản lý DMARC.',
    'mail__relay_white_list_not_supported' => 'Quản trị sổ trắng tiếp vận không được hỗ trợ.',
    'mail__black_list_not_supported' => 'Quản trị danh sách đen không được hỗ trợ.',
    'mail__autoresponder_not_supported' => 'Quản trị hệ thống trả lời tự động không được hỗ trợ.',
    'defaultcomponents__not_supported_version' => '(phiên bản không được hỗ trợ)',
    'component_name__nodejs' => 'Node.js',

    'certificate__not_found' => 'Chứng nhận \'%1\' không tìm thấy.',
    'certificate__unable_setup_certificate' => 'Không thể cài đặt chứng nhận: Thiếu mã cá nhân và nội dung chứng nhận.',
    'certificate__used_by_panel' => 'Một trong những chứng nhận bạn dự định xóa đang được sử dụng để bảo mật Plesk.',
    'certificate__used_by_mail_server' => 'Một trong những chứng nhận bạn dự định xóa đang được sử dụng để bảo mật máy chủ mail.',
    'certificate__used_by_domain_service' => 'Một trong những chứng nhận bạn dự định xóa đang được dịch vụ miền sử dụng.',
    'mail_server__not_installed' => 'Không thể cài đặt chứng nhận cho máy chủ mail bởi vì máy chủ mail chưa được cài đặt.',

    'email_activation_mail_subject' => 'Vui lòng kích hoạt tài khoản của bạn trong Plesk',
    'email_activation_mail_body' => "Một tài khoản đã được tạo trên máy chủ Plesk %1\n\nChi tiết tài khoản:\nTên: %2\nĐịa chỉ email: %3\n\nNếu thông tin này là chính xác và tài khoản đã được tạo cho bạn, vui lòng kích hoạt nó bằng liên kết sau:\n\n%4\n\nBằng cách kích hoạt tài khoản, bạn cho phép chủ sở hữu máy chủ thu thập, lưu trữ, xử lý và sử dụng dữ liệu cá nhân của bạn (tên và email) để tạo và hỗ trợ tài khoản của bạn, phù hợp với luật bảo vệ dữ liệu hiện hành đang có hiệu lực, như một phần của hợp đồng.",

    'backup_transport_permission_name' => '%1 quản lý',
    'backup_transport_permission_description' => 'Cho phép sử dụng %1 để lưu trữ các bản sao lưu.',

    'domain_move_err_target_no_hosting' => 'Không thể di chuyển miền đến một đăng ký khi không có lưu trữ máy chủ.',
    'domain_move_err_already_in_target' => 'Miền đã thuộc về đăng ký đích.',
    'domain_move_err_main_domain' => 'Không được di chuyển miền chính.',
    'domain_move_err_subdomain_without_parent' => 'Không thể di chuyển miền con %1 khi không có miền mẹ %2.',
    'domain_move_err_root_exists' => 'Đã tồn tại đường dẫn đích của www_root %1.',
    'domain_move_err_nested_roots' => 'Không thể di chuyển miền vì miền này có chung thư mục văn bản gốc với một miền khác: %1.',
    'domain_move_err_no_mail_service' => 'Không thể di chuyển miền vì đã tắt dịch vụ thư trên đăng ký đích.',
    'domain_move_err_app' => "Ứng dụng cài đặt trên %1 chưa bị di chuyển đến đăng ký '%2': %3",
    'domain_move_database_used_by_app' => "Cơ sở dữ liệu '%1' trên %2 được sử dụng bởi ứng dụng đã bị di chuyển. Để gán lại cơ sở dữ liệu cho '%3', hãy chạy `plesk bin database --assign-to-subscription`",
    'domain_move_target_locked' => "Đăng ký đích '%1' đã bị khóa không cho đồng bộ.",
    'domain_move_filesharing_disabled' => 'Đã tắt chia sẻ tệp tin.',
    'domain_move_website_preview_disabled' => 'Đã tắt chế độ xem trước trang web.',
    'domain_move_additional_webserver_settings' => "Xem xét thêm các chỉ thị máy chủ web của miền để ngăn chặn gãy cấu hình.",
    'domain_move_no_permission' => "%1 không được phép đối với thuê bao '%2'.",
    'domain_move_no_access' => "Không có quyền truy cập thuê bao '%1'.",
    'domain_split_no_create_permission' => "Không được phép tạo miền.",
    'domain_split_empty_login' => 'Phải có thông tin đăng nhập của người dùng hệ thống.',
    'domain_split_empty_password' => 'Phải có mật khẩu của người dùng hệ thống.',
    'domain_split_err_home_exists' => 'Không thể chuyển miền %1 vì đã tồn tại đường dẫn gốc đích ở %2. Đặt lại tên để chuyển miền sang một thuê bao mới.',
    'domain_split_err_no_hosting_subdomains' => 'Không thể chuyển miền sang thuê bao mới vì miền không có dịch vụ lưu trữ nhưng có các miền con. Để chuyển miền, hãy đổi giá trị "Kiểu lưu trữ" thành "Lưu trữ trang web" (trong Thiết lập Lưu trữ).',
    'domain_split_target_locked' => "Thuê bao đích '%1' đã bị khóa không cho đồng bộ.",
    'domain_split_target_unsynced' => "Thuê bao đích '%1' không được đồng bộ với gói dịch vụ do: %2.",
    'domain_merge_scheduled_backup_deactivated' => "Đã hủy kích hoạt bản sao lưu định kỳ trên '%1'.",
    'domain_merge_database_error' => "Chưa chuyển cơ sở dữ liệu '%1' trên %2 sang thuê bao '%3': %4",
    'domain_merge_anon_ftp_deactivated' => "Đã tắt FTP ẩn danh trên '%1'.",
    'domain_merge_smb_user_access' => "Đã chuyển người dùng bổ sung '%1' sang thuê bao '%2' nhưng quyền truy cập thuê bao của người dùng đã bị thu hồi.",
    'domain_merge_scheduled_tasks' => "Đã chuyển các tác vụ định kỳ sang thuê bao đích. Xem xét cấu hình tác vụ.",
    'domain_merge_scheduled_tasks_deactivated' => "Đã chuyển các tác vụ định kỳ sang thuê bao đích và hủy kích hoạt. Xem xét cấu hình tác vụ.",
    'domain_merge_no_remove_permission' => "Không được phép xóa thuê bao.",
    'domain_merge_err_has_addons' => 'Không thể chuyển miền chính cùng các miền bổ sung của miền chính; chuyển (các) miền %1 trước.',
    'domain_merge_err_has_webusers' => 'Không thể chuyển miền chính cùng người dùng web của miền chính.',
    'domain_merge_err_root_exists' => 'Đã tồn tại đường dẫn đích %1.',

    'database_server_edit_used_for_psa' => 'Cập nhật máy chủ cơ sở dữ liệu MySQL cục bộ không được cho phép.',
    'suggest_repair_main_suggestion_ui' => '<b>Bạn có thể sửa lỗi này</b> bằng tiện ích "plesk repair".',
    'suggest_repair_main_suggestion_cli' =>  'Bạn có thể sửa lỗi này bằng tiện ích "plesk repair".',
    'suggest_repair_repair_kit_link_title' => 'đi đến Chẩn đoán & Sửa',
    'suggest_repair_using_cli_and_ui' => 'Để làm vậy hãy chạy lệnh `plesk repair %1` qua CLI hoặc %2 và nhấn vào nút Sửa bên canh "Cơ sở dữ liệu Plesk"',
    'suggest_repair_using_cli' => 'Để làm vậy hãy chạy lệnh `plesk repair %1` qua CLI',

    'backup__restore__capability_duplicate_php_handler_resolution' => '',
    'bu_conflict_resolver_dns_not_available' => 'Dịch vụ DNS không khả dụng khi tạo sao lưu. Tuy nhiên, có các vùng DNS hiện hoạt trong sao lưu, và các vùng ấy sẽ được bật cho các đối tượng sau: {{objects}}',
    'plesk_key__system-resources-limits-enabled' => 'Trình điều khiển tài nguyên (Cgroups)',
    'plesk_key__remote-smartermail-enabled' => 'Hỗ trợ cho SmarterMail từ xa',
    'plesk_key__complete-backup-solution' => 'Backup to Cloud Pro',
    'defaultcomponents__no_license' => '(key bản quyền không cho phép)',
    'plesk_key__validation_failed' => '%1 (Mã lỗi: %2)',
    'promo__button_details' => 'Chi tiết',
    'promo__extension_catalog_title' => 'Danh mục phần mở rộng',
    'promo__extension_catalog_description' => 'Kiểm tra danh mục phần mở rộng mới và tăng cường cho Plesk của bạn với một loạt các phần mở rộng mạnh!',
    'promo__button_open_catalog' => 'Mở danh mục',

    'backup__repository_check_login' => "Không thể truy cập lưu trữ: %1 Hãy đảm bảo rằng bạn đã nhập đúng giấy chứng nhận lưu trữ.",
    'backup__repository_check_error_list' => "Không thể truy cập lưu trữ: %1 Hãy đảm bảo rằng bạn đã nhập đúng cài đặt lưu trữ.",
    'backup__repository_check_error_mkdir' => "Không thể tạo thư mục: %1 Kiểm tra xem bạn có quyền để tạo các thư mục trong lưu trữ hay không.",
    'backup__repository_check_error_upload' => "Không thể tải lên tệp tin tới lưu trữ: %1 Kiểm tra xem bạn có quyền tiếp tục tải lên tới lưu trữ hay không.",
    'backup__repository_check_error_download' => "Không thể tải về tệp tin từ lưu trữ: %1 Kiểm tra xem bạn có quyền tải lên và tải xuống các tệp tin từ lưu trữ hay không.",
    'backup__repository_check_error_resume-upload' => "Không thể tiếp tục tải lên tệp tin tới lưu trữ: %1 Kiểm tra xem bạn có quyền tiếp tục tải lên tới lưu trữ hay không.",
    'backup__repository_check_error_resume-download' => "Không thể tiếp tục tải về tệp tin từ lưu trữ: %1 Kiểm tra xem bạn có quyền tiếp tục tải về từ lưu trữ hay không.",
    'backup__repository_check_error_enable-utf8' => "Không thể vận hành lưu trữ: %1 Kiểm tra xem lưu trữ hỗ trợ mã hóa UTF8 hay không.",
    'backup__repository_check_error_rm' => "Không thể vận hành lưu trữ: %1 Kiểm tra xem bạn có quyền xóa các tệp tin từ lưu trữ hay không.",
    'backup__repository_check_error_rmdir' => "Không thể vận hành lưu trữ: %1 Kiểm tra xem bạn có quyền xóa các thư mục từ lưu trữ hay không.",

    'backup__ftp_repository_check_login' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2",
    'backup__ftp_repository_check_error_list' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2",
    'backup__ftp_repository_check_error_mkdir' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2",
    'backup__ftp_repository_check_error_upload' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2 %3",
    'backup__ftp_repository_check_error_download' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2 %3",
    'backup__ftp_repository_check_error_resume-upload' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2 %3 %4",
    'backup__ftp_repository_check_error_resume-download' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2 %3",
    'backup__ftp_repository_check_error_enable-utf8' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2",
    'backup__ftp_repository_check_error_rm' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2 %3",
    'backup__ftp_repository_check_error_rmdir' => "%1 Bạn có thể kiểm tra riêng lẻ với các lệnh: %2 %3",

    'sfdmarc_server_wide_enable_failed' => 'Không thể thay đổi cài đặt cho DMARC. Để bật tùy chọn này, vui lòng bật DKIM và bảo vệ chống thư rác SPF.',
    'spf_server_wide_disable_failed' => 'Không thể thay đổi thiết lập cho bảo vệ chống thư rác SPF. Để tắt SPF, vui lòng tắt DMARC cho thư đến.',
    'sfdk_server_wide_verify_disable_failed' => 'Không thể thay đổi thiết lập cho bảo vệ chống thư rác DKIM. Để tắt DKIM, vui lòng tắt DMARC cho thư đến.',

    'ccs_not_supported' => 'Quản lý Cửa hàng Chứng nhận Trung tâm IIS chưa được cấu hình trong hệ thống.',
    'ccs_not_enabled' => 'Quản lý Cửa hàng Chứng nhận Trung tâm IIS chưa được bật trong Plesk.',
    'ad_not_supported' => 'Máy chủ không tham gia vào miền.',

    'component_name__appinit' => "Khởi động Ứng dụng",
    'component_name__httpcompression' => 'Nén Nội dung HTTP',
    'common_feature_is_not_supported' => 'Tính năng không còn được hỗ trợ.',
    'common_feature_is_not_supported_in_proto' => 'Tính năng này không được hỗ trợ cho giao thức phiên bản %1.',
    'autoinstaller__plesk_component' => 'Thành phần Plesk',
    'plesk_key__key_expired' => 'Key bản quyền đã hết hạn. Để tiếp tục sử dụng Plesk, hãy mua bản thương mại vô thời hạn %1.',
    'plesk_key__key_purchase' => 'key bản quyền',

    'sa_action_move' => 'Chuyển thư rác vào thư mục "Thư rác"',

    'bu_conflict_resolver_tomcat_not_supported' => 'Các ứng dụng Java không còn được hỗ trợ. Các ứng dụng ấy sẽ không khả dụng cho các trang web sau: {{objects}}',
    'bu_conflict_resolver_unity_mobile_not_supported' => 'Phiên bản di động của các trang web được lưu trữ với UNITY Mobile không còn được hỗ trợ. Các ứng dụng ấy sẽ không khả dụng cho các trang web sau: {{objects}}',
    'bu_conflict_resolver_antivirus_personal_management_not_allowed' => 'Chính sách sử dụng toàn máy chủ không cho phép sử dụng các cài đặt chống virus cá nhân. Các cài đặt này sẽ được khôi phục không hoàn toàn cho các tài khoản cá nhân trên các tên miền sau: {{objects}}',

    'module__not_installed' => "Phần mở rộng %1 chưa được cài đặt",

    'mail__mail_autodiscovery_server_error' => 'Chỉ định một tên miền tùy biến cho tự động phát hiện thư',
    'mail__error_mail_autodiscovery_enable' => 'Không thể đặt tự động phát hiện thư: %1',
    'mail__error_mail_autodiscovery_server' => 'Không thể đặt một tên miền tùy biến cho tự động phát hiện thư: %1',
    'mail__error_mail_autodiscovery_reconfigure_dns' => 'Không thể cấu hình lại miền tự động phát hiện bản ghi DNS: %1',

    '__invalid_url' => 'URL "%1" không hợp lệ',
    'actionlog__cloning_start' => 'bắt đầu',
    'actionlog__event_cloning_start' => 'Bắt đầu sao chép máy chủ',

    '__UPLOAD_ERR_FORM_SIZE' => "Tập tin được tải lên đã vượt qua kích thước cho phép",
    '__UPLOAD_ERR_INI_SIZE' => "Tập tin được tải lên đã vượt qua kích thước cho phép",
    '__UPLOAD_ERR_NO_FILE' => "Không nhận được tập tin nào",
    '__UPLOAD_ERR_OK' => "Tập tin được tải lên thành công",
    '__UPLOAD_ERR_PARTIAL' => "Tập tin chỉ được tải lên thành công một phần, hãy thử lại",
    '__UPLOAD_ERR_NO_TMP_DIR' => 'Không có thư mục tạm',
    '__UPLOAD_ERR_CANT_WRITE' => 'Không thể ghi tập tin vào đĩa',
    '__UPLOAD_ERR_UNKNOWN' => 'Đã xảy ra lỗi tải lên tập tin chưa xác định',
    '__accounts' => "Các tài khoản",
    '__access' => "Truy cập",
    '__address' => "Địa chỉ",
    '__addresses' => "Địa chỉ",
    '__acl_records' => 'Các bản ghi ACL',
    '__admin_repository' => "Nơi lưu trữ của người quản trị",
    '__all' => 'Tất cả',
    '__allowed' => "Được cho phép",
    '__anonftp_status' => "FTP ẩn danh",
    '__antispam' => "Trình lọc thư rác",
    '__apache_restart' => "...%1 vùng lưu trữ web đang được khởi động lại, hãy chờ...",
    '__asp' => "Microsoft ASP",
    '__asp_dot_net' => "Microsoft ASP.NET",
    '__asp_dot_net_support' => "Hỗ trợ Microsoft ASP.NET",
    '__asp_win_support' => "Hỗ trợ Microsoft ASP",
    '__attachments' => "Đính kèm",
    '__attachments_list' => "Đính kèm",
    '__author' => 'Tác giả',
    '__autoresp_name_already_exists' => "Trả lời tự động có tên %1 đã tồn tại.",
    '__autoresponder' => "Trả lời tự động",
    '__autoresponders' => "Trả lời tự động",
    '__autoresponders_list' => "Trả lời tự động",
    '__autoresponder_attachment_files' => "Các tập tin đính kèm trả lời tự động",
    '__auto_updates_list' => 'Các bản cập nhật có sẳn',
    '__avail' => "Sẵn dùng",
    '__backup_utilites' => "Tiện Ích Sao Lưu",
    '__bind_status' => "Tình trạng máy chủ DNS",
    '__bu_is_not_installed' => "Dịch vụ này hiện không có sẵn, Do các tiện ích sao lưu dữ phòng không được cài đặt.",
    '__bu_not_support_in_key' => "Mã bản quyền này không hỗ trợ tính năng sao lưu dự phòng.",
    '__notifications_not_support_in_key' => 'Mã bản quyền này không hỗ trợ tính năng thông báo',
    'disabled_by_key' => 'Không được hỗ trợ bởi mã bản quyền',
    '__bytes' => "byte",
    '__can_not_use_reserved_words' => "Bạn không thể sử dụng các từ được dành riêng.",
    '__certificate' => "Chứng chỉ",
    '__cgi_support' => "Hỗ trợ CGI",
    '__change_date' => "Ngày hiệu chỉnh",
    '__city' => "Thành phố",
    '__cl_not_exist' => "Tài khoản khách hàng không tồn tại.",
    '__client' => 'Khách hàng',
    '__client_card' => "Thẻ khách hàng",
    '__client_contact_name' => "Tên liên hệ của khách hàng",
    '__client_form' => "Thông tin cá nhân",
    '__client_ip_pool' => "Địa chỉ IP chung của khách hàng",
    '__client_limits' => "Các giới hạn tài khoản khách hàng",
    '__client_permissions' => "Quyền khách hàng",
    '__client_preferences' => "Tùy chỉnh khách hàng",
    '__client_status' => "Trạng thái khách hàng",
    '__client_name' => "Tên của khách hàng",
    '__client_total' => "Tổng số khách hàng",
    '__client_with_login_name_already_exists' => "Người dùng có tên \"%1\" đã tồn tại.",
    '__client_domuser_with_login_already_exists' => "Tên người dùng '%1' đã được sử dụng bởi quản trị viên của miền '%1'.",
    '__clients_global_changes' => "Hiệu chỉnh các tài khoản khách hàng được chọn",
    '__clients_list' => "Khách hàng",
    '__cmd_not_found' => "Lệnh không biết: %1",
    '__comments' => "Chú thích",
    '__company_name' => "Tên công ty",
    '__component_version' => "Phiên bản thành phần",
    '__component_not_installed' => "Thành phần %1 không được cài đặt",
    '__confirm_del' => "Bạn phải xác nhận xóa.",
    '__confirm_overwrite' => "Xác nhận ghi đè.",
    '__confirm_stop' => "Bạn phải xác nhận tiến trình tạm ngưng.",
    '__confirm_passwd' => "Xác nhận %1 mật khẩu",
    '__confirm_removal' => "Xác nhận gỡ bỏ",
    '__conhelp' => "Mô tả",
    '__contact_name' => "Tên liên hệ",
    '__country' => "Quốc gia",
    '__countries' => 'Quốc gia',
    '__country_unknown' => 'Không thể xác định được mã phụ quốc gia.',
    '__courier-imap' => 'Máy chủ nhà mạng',
    '__create_domain' => 'Tạo tên miền',
    '__crypted' => 'được mã hóa',
    '__cp_access' => "Truy cập vào Plesk",
    '__cp_user' => "Người dùng Plesk",
    '__create' => "Tạo",
    '__create_client_template_without_template' => "Tạo tài khoản không cần mẫu",
    '__create_domain_for' => "Tạo tên miền cho <b>%1</b>",
    '__create_domain_template_without_template' => "Tạo tên miền không cần mẫu",
    '__creation_date' => "Ngày tạo",
    '__crontab_unix' => "Trình lập lịch",
    '__crontab_win' => "Trình lập lịch",
    '__ct_month_jan' => 'Tháng Một',
    '__ct_month_feb' => 'Tháng Hai',
    '__ct_month_mar' => 'Tháng Ba',
    '__ct_month_apr' => 'Tháng Tư',
    '__ct_month_may' => 'Tháng Năm',
    '__ct_month_jun' => 'Tháng Sáu',
    '__ct_month_jul' => 'Tháng Bảy',
    '__ct_month_aug' => 'Tháng Tám',
    '__ct_month_sep' => 'Tháng Chín',
    '__ct_month_oct' => 'Tháng Mười',
    '__ct_month_nov' => 'Tháng Mười Một',
    '__ct_month_dec' => 'Tháng Mười Hai',
    '__custom_button' => "Nút tùy biến",
    '__custom_buttons_list' => "Đường dẫn đến các Dịch vụ bổ sung",
    '__daily' => "Hàng ngày",
    '__database_not_activated' => "%1 không được kích hoạt trên trang quản trị máy chủ.",
    '__database_not_installed' => "Cơ sở dữ liệu %1 không được cài đặt.",
    '__database_not_run' => "Cơ sở dữ liệu %1 không chạy.",
    '__database_is_corrupt' => "Cơ sở dữ liệu của Plesk bị lỗi. Vui lòng chạy tiện ích tái cấu hình để sửa.",
    '__databases' => "Cơ sở dữ liệu",
    '__databases_list' => "Cơ sở dữ liệu",
    '__database_type_not_supported_by_key' => 'Để sử dụng máy chủ %1, bạn cần sự hỗ trợ qua key bản quyền của bạn. Hãy tham khảo ý kiến đại diện bán hàng Plesk của bạn.',
    '__date_immediately' => "hôm nay",
    '__date_never' => "không bao giờ",
    '__day(s)' => "Ngày",
    '__day0' => "Chủ Nhật",
    '__day1' => "Thứ Hai",
    '__day2' => "Thứ Ba",
    '__day3' => "Thứ Tư",
    '__day4' => "Thứ Năm",
    '__day5' => "Thứ Sáu",
    '__day6' => "Thứ Bảy",
    '__days' => "%1 ngày",
    '__db_admin_login_empty' => "Bạn chưa nhâp tên đăng nhập, tắt điều khiển thông qua %1 trong giao diện. Bạn có muốn thực thi không?",
    '__db_unable_to_unregister' => 'Không thể để gỡ bỏ các thông số kết nối cơ sở dữ liệu',
    '__db_db_exists' => 'Có ít nhất một cơ sở dữ liệu trên máy chủ',
    '__db_unable_to_change_server_name' => 'Không thể thay đổi tên cho máy chủ',
    '__db_unable_to_change_port' => 'Cổng cho máy chủ không thể thay đổi',
    '__db_already_exist' => "Cơ sở dữ liệu %1 đã tồn tại.",
    '__db_credentials_invalid' => "Thông tin đăng nhập cơ sở dữ liệu không hợp lệ.",
    '__db_invalid_password_characters' => 'Mật khẩu chứa ký tự không hợp lệ',
    '__db_engine' => "Bộ máy cơ sở dữ liệu", // indirect
    '__db_type' => "Kiểu cơ sở dữ liệu",
    '__db_user' => "Người dùng cơ sở dữ liệu",
    '__db_server' => 'Máy chủ cơ sở dữ liệu',
    '__def_domain' => "Tên miền mặc định",
    '__default_for_mysql' => 'mặc định cho MySQL',
    '__default_for_mariadb' => 'mặc định cho MariaDB',
    '__default_for_percona' => 'mặc định cho Percona',
    '__default_for_postgresql' => 'mặc định cho PostgreSQL',
    '__delete' => "Xóa",
    '__demo' => "Chức năng này không có sẵn trong phiên bản thử nghiệm.",
    '__directory' => "Thư mục",
    '__disable_lock_screen' => 'Chặn người dùng không thao tác trên Plesk cho đến khi các màn hình giao diện đã được tải xong',
    '__dismiss_news?' => "Bạn có chắc muốn đóng hộp tin này không?\n\nBạn sẽ không thể thấy hộp tin tức cho đến khi có thêm nhiều tin mới.",
    '__description' => "Mô tả",
    '__disabled' => "tắt",
    '__disk_space_limit' => "Giới hạn không gian đĩa",
    '__cgroups_cpu_usage_limit' => 'Giới hạn sử dụng CPU',
    '__cgroups_ram_usage_limit' => 'Giới hạn sử dụng RAM',
    '__cgroups_disk_read_usage_limit' => 'Giới hạn Băng Thông Đọc Đĩa',
    '__cgroups_disk_write_usage_limit' => 'Giới hạn Băng Thông Ghi Đĩa',
    '__disk_usage_by' => "Không gian đĩa đã sử dụng bởi %1",
    '__dns' => "DNS",
    '__dns_record_already_exist' => "Bản ghi DNS '%1' đã tồn tại.",
    '__dns_master_should_be_remote' => "Bạn nên có hai máy chủ tên miền khác nhau trên các host lưu trữ riêng biệt.",
    '__dns_record_not_exist' => "Bản ghi DNS không tồn tại.",
    '__dns_server' => "Máy chủ DNS", // indirect
    '__dom_id_is_undefined' => "ID tên miền không được định nghĩa.",
    '__dom_name' => "Tên miền",
    '__dom_name_is_invalid' => "Tên miền không hợp lệ. Đảm bảo rằng tên miền chỉ chứa các biểu tượng ký tự chữ và số, dấu chấm, dấu gạch ngang và không dài quá 255 ký tự. Mỗi phần tên miền giữa các dấu chấm không được vượt quá 63 biểu tượng.",
    '__dom_not_exist' => "Tên miền không tồn tại.",
    '__domain' => "Tên miền",
    '__domain_' => 'Tên miền %1',
    '__domain_form' => "Mẫu tên miền",
    '__domain_id' => "ID Miền",
    '__domain_is_turned_off_for_backup' => "Website %1 tạm thời bị tắt để sao lưu hoặc khôi phục và hiện không khả dụng.",
    '__domain_limits' => "Giới hạn tên miền",
    '__domain_name' => "Tên miền",
    '__mail_name_in_ASCII_form' => "Tên tài khoản thư theo định dạng ASCII",
    '__message_error' => 'Lỗi',
    '__message_warning' => 'Cảnh báo',
    '__message_info' => 'Thông tin',
    '__domain_name_in_ASCII_form' => "Tên miền theo định dạng ASCII",
    '__domain_repository' => "Nơi lưu trữ tên miền %1",
    '__domain_status' => "Trạng thái miền",
    '__domain_found_tech' => "Công nghệ được tìm thấy trên miền",
    '__domain_dns' => 'Vùng DNS của tên miền',
    '__domain_total' => "Tổng số thuê bao",
    '__domain_total_powerUser' => "Tổng số thuê bao",
    '__domain_user' => "Quản trị tên miền",
    '__domains_global_changes' => "Hiệu chỉnh tên miền được chọn",
    '__mailnames_global_changes' => "Hiệu chỉnh tài khoản thư được chọn",
    '__backup_manager' => 'Quản lý sao lưu',
    '__domains_list' => "Các tên miền",
    'domains_list__list_header' => "các tên miền",
    //this is a part of phrases like No domains (and others), so it should not be capitalized
    '__double_www_warning' => "Tên miền bắt đầu với www, mặc dù tiền tố WWW đã được sử dụng.\nTiếp tục không?",
    '__dovecot' => 'Máy chủ Dovecot IMAP và POP3',
    '__dsmail' => "Dịch vụ thư",
    '__dsmaillist' => "Dịch vụ danh sách gửi thư",
    '__dsr_db' => "DB",
    '__dsr_dname' => "Tên miền",
    '__dsr_du' => "DU",
    '__dsr_ma' => "MA",
    '__dsr_mg' => "MF",
    '__dsr_ml' => "ML",
    '__dsr_mn' => "Hthư",
    '__dsr_pname' => "Tên của khách hàng",
    '__dsr_sd' => "SD",
    '__dsr_tr' => "TR",
    '__dsr_wu' => "WU",
    '__dumps_tot_size' => "Tổng kích thước tập tin sao lưu trong lưu trữ cục bộ",
    '__email' => "Email",
    '__email_addr_is_invalid' => "Địa chỉ email không hợp lệ.",
    '__enabled' => "Bật",
    '__enter_cert_text' => "Nhập văn bản chứng chỉ",
    '__enter_size' => "Nhập kích cỡ",
    '__exclusive' => "Chuyên dụng",
    '__expiration_date' => "Ngày hết hạn",
    '__fax' => "Fax",
    '__file' => "Tập tin",
    '__file_is_empty' => "Tập tin trống rỗng.",
    '__file_name' => "Tên tập tin",
    '__file_type' => 'Kiểu tập tin',
    '__filemanager' => "Trình quản lý tập tin",
    '__filepath_is_empty' => "Đường dẫn đến tập tin trống rỗng",
    '__files_list' => "Các tập tin",
    '__frontpage' => "Microsoft FrontPage",
    '__ftp' => "FTP", // +indirect
    '__ftp_settings' => "Các thiết lập FTP",
    '__ftp_serv' => "Máy chủ FTP", // indirect
    '__ftp_server_parameters_are_empty' => "Bạn nên thiết lập các thuộc tính tài khoản FTP trước tiên!",
    '__ftp_status' => "Trạng thái máy chủ FTP",
    '__full_day0' => "Chủ nhật",
    '__full_day1' => "Thứ Hai",
    '__full_day2' => "Thứ Ba",
    '__full_day3' => "Thứ Tư",
    '__full_day4' => "Thứ Năm",
    '__full_day5' => "Thứ Sáu",
    '__full_day6' => "Thứ Bảy",
    '__full_month1' => "Tháng Một",
    '__full_month10' => "Tháng Mười",
    '__full_month11' => "Tháng Mười Một",
    '__full_month12' => "Tháng Mười Hai",
    '__full_month2' => "Tháng Hai",
    '__full_month3' => "Tháng Ba",
    '__full_month4' => "Tháng Tư",
    '__full_month5' => "Tháng Năm",
    '__full_month6' => "Tháng Sáu",
    '__full_month7' => "Tháng Bảy",
    '__full_month8' => "Tháng Tám",
    '__full_month9' => "Tháng Chín",
    '__giga' => "G",
    '__group' => "Nhóm",
    '__h' => "H",
    '__hard_disk_quota' => "Giới hạn dung lượng đĩa cứng",
    '__hard_disk_quota_not_supported' => 'Hạn ngạch đĩa cứng không được hỗ trợ do cấu hình hệ thống tập tin máy chủ',
    '__header_text_is_invalid' => "Tiêu đề vùng được bảo vệ không hợp lệ.",
    '__help_topic_not_found' => 'Chủ đề hỗ trợ bạn yêu cầu (%1) không tồn tại.',
    '__hosting_ip_dns_ip_not_equiv' => "Không địa chỉ IP nào được chỉ định trong các bản ghi DNS trùng khớp với địa chỉ IP được sử dụng để lưu trữ.",
    '__hosting_scripting' => "Hỗ trợ kịch bản lưu trữ",
    '__hosting_setup_page_title' => "Cài đặt lưu trữ web cho tên miền %1",
    '__hosting_title' => "Lưu trữ (%1)",
    '__hosting_type' => "Loại lưu trữ",
    '__hostname_is_empty' => "Tên máy lưu trữ trống rỗng.",
    '__hour(s)' => 'Giờ',
    '__hst_type_incorrect' => "Kiểu lưu trữ không hợp lệ.",
    '__http' => "HTTP", //indirect
    '__htype' => "H",
    '__idle_time' => "Thời gian chờ",
    '__iface' => "Giao diện",
    '__image' => "Hình",
    '__imap_status' => "Trạng thái máy chủ IMAP",
    '__in' => "Trong",
    '__in_%' => "trong %",
    '__incorrect_databases_login_pass' => "Các thông tin bạn chỉ định truy cập PostgreSQL không đúng.",
    '__incorrect_ip_or_network_address' => 'Địa chỉ IP hoặc mạng không đúng.',
    '__info' => 'Thông báo',
    '__install' => "Cài đặt",
    '__install_prefix' => "Tiền tố cài đặt",
    '__invalid_cert_id' => "ID chứng chỉ bảo mật không hợp lệ",
    '__invalid_context' => "Nội dung không hợp lệ: %1",
    '__invalid_db_usr_name' => "Tên người dùng cơ sở dữ liệu không hợp lệ.",
    '__invalid_dir_name' => "Tên thư mục không hợp lệ",
    '__invalid_dom_name' => "Tên miền không hợp lệ.",
    '__invalid_filename' => "Tên tập tin không hợp lệ. Không được sử dụng kết hợp dấu ngoặc đơn và/hoặc \"../\".",
    '__invalid_id' => "Bộ nhận dạng không hợp lệ.",
    '__invalid_lines_num' => "Số lượng dòng không đúng, chỉ ký tự số được chấp nhận.",
    '__invalid_max_letter_size' => "Kích thước tin tối đa không hợp lệ.",
    '__invalid_pdir_name' => "Tên thư mục được bảo vệ không hợp lệ.",
    '__invalid_restart_apache_interval' => "Khoảng thời gian khởi động lại Apache không hợp lệ.",
    '__invalid_tmpl_name' => "Tên mẫu không hợp lệ.",
    '__invalid_value' => "Giá trị không hợp lệ.",
    '__ip_addr' => "Địa chỉ IP",
    '__ip_address_and_mask' => "Địa chỉ IP và mặt nạ mạng con",
    '__ip_alias__mask' => "Địa chỉ IP và mặt nạ mạng con",
    '__ip_addr_is_invalid' => "Địa chỉ IP không hợp lệ.",
    '__ip_addr_list' => "Địa chỉ IP",
    '__ip_address_and_mask_hint' => 'Ví dụ, %1',
    '__is_owner' => "O",
    '__java_engine' => "Java", // indirect
    '__jdk' => "JDK",
    '__kb' => "KB",
    '__kbps' => "KB/s",
    '__kbytes' => "KByte",
    '__key_for_virtuozzo_only' => "Key bản quyền của bạn chỉ để sử dụng trong các bộ chứa Virtuozzo.",
    '__key_limits_exceeding' => "Bạn đã vượt qua giới hạn được định nghĩa trong bản quyền của bạn. Nếu nhận được thông báo này bạn có thể liên hệ nhà cung cấp hoặc nhà sản xuất để biết thêm chi tiết hoặc mở rộng các giới hạn bản quyền.",
    '__kilo' => "K",
    '__keywords' => 'Từ khóa',
    '__lang_unknown' => 'Không thể nhận dạng ngôn ngữ.',
    '__languages' => 'Ngôn ngữ',
    '__learn_more' => 'Tìm hiểu thêm',
    '__loading' => 'Đang tải...',
    '__locales' => "gói ngôn ngữ",
    '__lists' => "Các danh sách gửi thư",
    '__literal_bytes' => "B",
    '__processing' => "Hãy chờ.<br>Đang tải...",
    '__locale' => "Ngôn ngữ giao diện",
    '__locale_is_not_defined' => "Giao diện ngôn ngữ không được chỉ định.",
    '__local_server_mysql' => 'Máy chủ MySQL cục bộ',
    '__local_server_postgresql' => 'Máy chủ PostgreSQL cục bộ',
    '__local_server_mssql' => 'Máy chủ MS SQL cục bộ',
    '__log_and_statistics_files' => 'Tập tin bản ghi và các báo cáo thống kê',
    '__config_files' => 'Các tập tin cấu hình',
    '__chroot_files' => 'Môi trường chroot',
    '__login' => "%1 Đăng nhập",
    '__login1' => "Đăng nhập",
    '__login_disabled' => "Cấm đăng nhập",
    '__login_enabled' => "Cho phép đăng nhập",
    '__login_incorrect' => "Bạn đã nhập tên đăng nhập và mật khẩu không hợp lệ.",
    '__login_name' => "Tên đăng nhập %1",
    '__login_name_is_invalid' => "Tên đăng nhập %1 không hợp lệ.",
    '__logon_time' => "Thời gian đăng nhập",
    '__ma' => "Các bí danh thư",
    '__mail' => "Thư",
    '__mail_alias_name' => "Tên bí danh thư",
    '__mail_autodiscovery' => 'Tự động phát hiện thư',
    '__mail_exchanger_name_is_invalid' => "Tên Mail exchanger không hợp lệ.",
    '__mail_groups' => "Các nhóm thư",
    '__mail_list_engine' => "Phần mềm danh sách gửi thư",
    '__mail_name' => "Tài khoản thư",
    '__mail_name_form' => "Các thuộc tính tài khoản thư",
    '__mail_names' => "Các tài khoản thư",
    '__mail_serv' => "Máy chủ thư",
    '__mail_user' => 'Người dùng thư',
    '__mailgroup' => "Nhóm thư",
    '__maillist' => "Danh sách gửi thư",
    '__maillists' => "Các danh sách gửi thư",
    '__maillist_member' => 'Thành viên trong danh sách gửi thư',
    '__mailname' => "Tài khoản thư",
    '__mailname_redir_self' => "Tài khoản thư không thể chuyển tiếp thư đến chính nó.",
    '__max_dom_num_reached_for_cl' => "Đã đạt đến giới hạn số lượng tên miền cho phép đối với tài khoản khách hàng này.",
    '__max_file_size_available' => "Kích thước tập tin tối đa được phép %1",
    '__max_subdom_num_reached_for_cl' => "Đã đạt đến giới hạn số lượng tên miền con cho phép đối với tài khoản khách hàng này.",
    '__max_subdom_num_reached_for_dom' => "Đã đạt đến giới hạn số lượng tên miền con cho phép đối với tên miền này.",
    '__max_subdom_num_reached_for_key' => "Giới hạn số lượng tên miền con được phép bởi bản quyền đã tới hạn.",
    '__max_traffic_limit' => "Giới hạn lưu lượng truy cập",
    '__maximum_excl_ip_num' => "Các tài khoản thư",
    '__mb' => "MB",
    '__mbytes' => "megabytes",
    '__mb_month' => "MB/tháng",
    '__mb_sec' => "MB/giây",
    '__gb_sec' => "MB/giây",
    '__tb_sec' => "TB/giây",
    '__mega' => "M",
    '__minute(s)' => 'Phút',
    '__mls_not_in_key' => "Mã bản quyền của bạn không hỗ trợ giao diện đa ngôn ngữ.",
    '__modification_date' => "Ngày hiệu chỉnh",
    '__module' => "Mở rộng",
    '__month' => "Tháng",
    '__month(s)' => "Tháng",
    '__month1' => "Tháng Một",
    '__month10' => "Tháng Mười",
    '__month11' => "Tháng Mười Một",
    '__month12' => "Tháng Mười Hai",
    '__month2' => "Tháng Hai",
    '__month3' => "Tháng Ba",
    '__month4' => "Tháng Tư",
    '__month5' => "Tháng Năm",
    '__month6' => "Tháng Sáu",
    '__month7' => "Tháng Bảy",
    '__month8' => "Tháng Tám",
    '__month9' => "Tháng Chín",
    '__monthly' => "Hàng tháng",
    '__months' => "Tháng",
    '__moved_permanently' => 'Di chuyển vĩnh viễn',
    '__mssql' => "Máy chủ Microsoft SQL",
    '__mssql__server' => "Máy chủ",
    'mssql__server' => "Máy chủ tên miền Microsoft SQL",
    'mssql__unable_to_change_server_name_db_exists' => "tên cho máy chủ không thể thay đổi: có ít nhất một cơ sở dữ liệu trên đó.",
    '__mssql_status' => "Trạng thái máy chủ Microsoft SQL",
    '__multiply_login_deny' => "Không thể đăng nhập. Có người dùng khác có cùng tên người dùng (%1) đã đăng nhập vào Plesk.",
    '__mysql' => "MySQL",
    '__mysql_status' => "Trạng thái máy chủ MySQL",
    '__mysql_version' => "Phiên bản MySQL",
    '__mariadb' => "MariaDB",
    '__mariadb_status' => "Trạng thái máy chủ MariaDB",
    '__mariadb_version' => "Phiên bản MariaDB",
    '__percona' => "Percona",
    '__percona_status' => "Trạng thái máy chủ Percona",
    '__percona_version' => "Phiên bản Percona",
    '__name' => "Tên",
    '__name_invalid' => "Tên không hợp lệ.",
    '__nameserver' => "máy chủ tên miền",
    '__network' => "Mạng",
    '__networks' => "Mạng",
    '__no' => "Không",
    '__no_ip_address_with_properly_type_available' => "Không thể khôi phục dữ liệu sao lưu vì không có địa chỉ IP thích hợp.",
    '__no_clients_specified' => "Không có tài khoản khách hàng nào được chỉ định.",
    '__no_comments' => "Không có chú thích.",
    '__nologin' => "Bị cấm",
    '__none' => "Không",
    '__not_configured' => "Không được cấu hình",
    '__not_implemented_yet' => "Chưa thực hiện",
    '__not_supported_by_ftp' => "(Không được hỗ trợ bởi máy chủ FTP)",
    '__notification' => "Thông báo",
    '__num_displayed' => "%1 của %2 được hiển thị",
    '__num_is_invalid' => "Số không hợp lệ.",
    '__object_not_found' => 'Đối tượng không được tìm thấy: %1',
    '__of_all' => "% trong tổng số",
    '__off' => "Tắt",
    '__ok' => "Đồng ý",
    '__old_passwd' => "Mật khẩu cũ %1",
    '__on' => "Bật",
    '__others' => "Khác",
    '__other_ip__will_be_added' => 'Các địa chỉ IP đang có khác (sẽ được thêm vào dãy IP của khách hàng)',
    '__out' => "Ra",
    '__p' => "P",
    '__passwd' => "%1 Mật khẩu",
    '__passwd_is_invalid' => "%1 Mật khẩu không hợp lệ.",
    '__passwd_not_match' => "Mật khẩu không trùng khớp!",
    '__path' => "Đường dẫn",
    '__perl_unix_support' => "Hỗ trợ Perl",
    '__perl_win_support' => "Hỗ trợ Perl",
    '__perm_denied' => "Từ chối truy cập.",
    '__permissions' => "Quyền truy cập",
    '__personal_name' => "Tên cá nhân",
    '__pg_admin_not_activated' => "PostgreSQL không được kích hoạt trên trang quản trị máy chủ.",
    '__pg_not_inst' => "PostgreSQL không được cài đặt.",
    '__pg_not_run_or_inst' => "PostgreSQL không được cài đặt hoặc không chạy.",
    '__pg_not_support_in_key' => "PostgreSQL không được hỗ trợ bởi mã bản quyền.",
    '__phone' => "Điện thoại",
    '__phosting' => "Lưu trữ vật lý",
    '__php_support' => "Hỗ trợ PHP",
    '__php_run_as_isapi' => "chạy với tư cách là phần mở rộng ISAPI",
    '__php_safe_mode' => "PHP 'safe_mode' được bật",
    '__php_version' => "Phiên bản PHP",
    '__physical' => "Lưu trữ vật lý",
    '__plesk_stat_pdir' => "Bảo vệ thư mục '/plesk-stat/webstat/'",
    '__plesk_stat_dir_name' => "Các thống kê tên miền",
    '__plesk_stat_protect' => "Bảo vệ truy cập vào thống kê web bằng tên người dùng và mật khẩu FTP của người dùng",
    '__plesk_stat_protect_install' => "truy cập qua thư mục được bảo vệ bằng mật khẩu '/plesk-stat/webstat/'",
    '__pop3_imap' => "POP3/IMAP", // indirect
    '__pop3_status' => "Trạng thái máy chủ POP3",
    '__popen_error' => "Một lỗi xảy ra khi gọi tính năng popen.",
    '__port' => 'Cổng',
    '__postgres' => "PostgreSQL",
    '__postgresql' => "PostgreSQL",
    '__postgresql_status' => "Trạng thái PostgreSQL",
    '__preferences' => "Cài đặt",
    '__account_preferences' => "Cài đặt tài khoản",
    '__interface_preferences_general' => 'Tổng quan',
    '__interface_preferences_default' => 'Tùy chỉnh giao diện mặc định',
    '__interface_preferences_admin' => "Tùy chỉnh giao diện của quản trị viên",
    '__interface_template' => 'Mẫu giao diện tùy chỉnh',
    '__interface_preferences' => "Tùy chọn giao diện",
    '__proceed?' => "Bạn có muốn thực thi không?",
    '__protect_dir_user' => "Người dùng thư mục được bảo vệ",
    '__protect_dir_users' => "Người dùng thư mục được bảo vệ",
    '__provider_contact_name' => "Tên liên hệ của chủ sở hữu",
    '__python_unix_support' => "Hỗ trợ Python",
    '__python_win_support' => "Hỗ trợ Python",
    '__quota' => "Giới hạn",
    '__r' => "R",
    '__reconfigure' => "Cấu hình lại",
    '__record_type' => "Loại bản ghi",
    '__release' => "Phát hành",
    '__remote_db_not_supported_by_key' => 'Lưu trữ cơ sở dữ liệu từ xa không được hỗ trợ bởi mã bản quyền.',
    '__remove' => "Gỡ bỏ",
    '__remove_confirmation' => "Xác nhận gỡ bỏ",
    '__remove_protection' => 'Gỡ bỏ bảo vệ',
    '__report' => "Báo cáo",
    '__report_size_na' => "Dịch vụ không có sẵn",
    '__reports_list' => "Các báo cáo",
    '__requested' => "Được yêu cầu",
    '__required_fields' => "Các trường bắt buộc",
    '__resp_name_invalid' => "Tên trả lời tự động không hợp lệ. Chủ sử dụng các biểu tượng chữ số, dấu chấm, gạch chân và khoảng trắng.",
    '__c' => "A", // Access to panel
    '__s' => "S",
    '__server_name_is_invalid' => "Máy chủ tên miền không hợp lệ.",
    '__screenshots' => 'Ảnh chụp màn hình',
    '__script_warning' => "Bằng cách tắt khả năng chạy các mã kịch bản khỏi tên miền này, các mã kịch bản bị ảnh hưởng sẽ hiển thị dạng văn bản. Quản trị viên nên xóa tất cả các mã kịch bản phụ thuộc của tên miền đã cho.",
    '__sec' => "Giây",
    '__second(s)' => "Giây",
    '__see_list_of_logged_in' => "Xem danh sách các người dùng đang đăng nhập.",
    '__select_certs_to_remove' => "Chọn các chứng chỉ để gỡ bỏ.",
    '__select_files_to_remove' => "Chọn các tập tin sẽ được gỡ bỏ.",
    '__select_ip' => "Gán địa chỉ IP",
    '__select_ip_to_remove' => "Chọn địa chỉ IP để gỡ bỏ.",
    '__select_domain_template' => "Sử dụng các thiết lập từ tên miền mẫu",
    '__select_templates_to_remove' => "Chọn các mẫu để gỡ bỏ.",
    '__server' => "Máy chủ",
    '__server_total' => "Tổng số máy chủ",
    '__service' => "Dịch vụ",
    '__service_title__plesk' => "Plesk",
    '__service_description__plesk' => "Plesk",
    '__service_title__mysql' => "Máy chủ cơ sở dữ liệu MySQL",
    '__service_description__mysql' => "Máy chủ cơ sở dữ liệu MySQL",
    '__service_title__web' => "Máy chủ Web",
    '__service_description__web' => "Máy chủ Web",
    '__service_title__smtp' => "Máy chủ SMTP",
    '__service_description__smtp' => "Máy chủ SMTP",
    '__service_title__mail' => "Máy chủ IMAP/POP3",
    '__service_description__mail' => "Máy chủ IMAP/POP3",
    '__service_title__dns' => "Máy chủ DNS",
    '__service_description__dns' => "Máy chủ DNS",
    '__service_title__postgresq' => "Máy chủ cơ sở dữ liệu PostgreSQL",
    '__service_description__postgresq' => "Máy chủ cơ sở dữ liệu PostgreSQL",
    '__service_title__spamassassin' => "Dịch vụ lọc thư rác SpamAssassin",
    '__service_description__spamassassin' => "Dịch vụ lọc thư rác SpamAssassin",
    '__services' => "Dịch vụ",
    '__all_services' => "Tất cả dịch vụ",
    '__sessions' => "Phiên",
    'sessions__feature_ftp_session_manager_not_supported' => "Tính năng phiên kết nối FTP không được hỗ trợ bởi máy chủ FTP hiện tại",
    '__sessions_list' => "Phiên",
    '__set' => "Bật",
    '__shared' => "chia sẻ",
    '__shell_access_warning' => "Cho phép truy cập môi trường Shell hệ thống sẽ không bảo mật. Chỉ cho phép truy cập khi bạn hiểu bạn đang làm gì, và chỉ cho phép người dùng đáng tin cậy. Bạn có muốn cho phép không?",
    '__siteapp_not_support_in_key' => "ứng dụng web không được hỗ trợ bởi mã bản quyền",
    '__siteapp_cannot_reconfigure_with_remote_database' => 'Cấu hình của ứng dụng web này đã được thay đổi thủ công. Để bảo vệ nhưng thay đổi thủ công, cấu hình lại thông qua Plesk đã bị hủy khả dụng.',
    '__site_management' => "Xuất bản Web", // indirect
    '__size' => "Kích thước",
    '__skeleton' => 'Biểu mẫu máy chủ ảo',
    '__skins' => 'Các giao diện',
    '__smtp' => "SMTP", // indirect
    '__smtp_status' => "Trạng thái máy chủ SMTP",
    '__some_fields_are_empty_or_invalid' => "Một số trường trống rỗng hoặc chứa giá trị không hợp lệ.",
    '__unable_to_set_parameters' => "Không thể đặt tham số của thành phần",
    '__spamassassin' => "Bộ lọc thư rác",
    '__spamassassin_status' => "Trạng thái SpamAssassin",
    '__spamd_status' => 'Trạng thái bộ lọc thư rác',
    '__splited_backup' => "(Sao lưu nhiều ổ đĩa)",
    '__split_backup_file' => "Tạo sao lưu nhiều ổ đĩa",
    '__split_backup_size' => "Kích thước ổ đĩa",
    '__split_backup_less_than_500' => "Kích thước ổ đĩa thấp hơn 500 MB không được hỗ trợ",
    '__ssi' => "SSI",
    '__ssi_support' => "Hỗ trợ SSI",
    '__ssi_with_html' => "dùng SSI cho các tập tin *.htm, *.html",
    '__ssl' => 'SSL/TLS',
    '__ssl_support' => "Hỗ trợ SSL/TLS",
    '__same_ssl' => "Sử dụng thư mục duy nhất để lưu trữ nội dung SSL/TLS và nội dung không SSL/TLS",
    '__same_ssl_cu' => "Nội dung SSL/TLS chung và nội dung không SSL/TLS",
    '__state' => "Tỉnh/Thành",

    '__status__Active' => 'Hiện hoạt',
    '__status__active' => 'đang hoạt động',
    '__status__Passive' => 'Tắt',
    '__status__passive' => 'tắt',
    '__status__off' => 'tắt',
    '__status__with_parent' => 'tắt',
    '__status__backup_restore' => 'Ngưng hoạt động tạm thời để sao lưu hoặc khôi phục',
    '__status__admin' => 'Tạm ngưng bởi người quản trị máy chủ',
    '__status__resseler' => 'Tạm ngưng bởi đại lý',
    '__status__client' => 'tạm ngưng bởi khách hàng',
    '__status__unknown' => 'Không thể nhận biết trạng thái này',

    '__status_of' => "trạng thái %1",
    // end of akss part

    // shramko part

    '__stunnel' => "Stunnel",
    '__stunnel_server' => "Máy chủ Stunnel", // indirect
    '__subdomain' => "Tên miền phụ",
    '__subdomain_name' => "Tên miền con",
    '__subdomain_name_in_ASCII_form' => "tên miền con ở dạng ASCII",
    '__subdomains' => "Tên miền phụ",
    '__domainaliases' => "Các bí danh tên miền",
    '__subdomains_list' => "Tên miền phụ",
    '__subdomains_not_support_in_key' => "Các thao tác trên tên miền con không được hỗ trợ bởi mã bản quyền",
    '__sys_user_type' => "người dùng FTP",
    '__sys_user_type_main' => "Sử dụng tài khoản người dùng FTP của tên miền chính",
    '__sys_user_type_native' => "Tạo tài khoản người dùng FTP riêng cho tên miền con",
    '__t' => "T",
    '__target_domain' => "Tên miền đích",
    '__template' => "Mẫu",
    '__template_not_accepted' => "Không thể chấp nhận mẫu này: các giới hạn sau bị vượt quá.",
    '__templates' => "Các mẫu",
    '__templates_list' => "Các mẫu",
    '__tera' => "T",
    '__title' => "Tiêu đề",
    '__tools' => "Công cụ",
    '__total' => "Tổng %1",
    '__total_size' => "Tổng dung lượng",
    '__total_used' => "Tổng sử dụng",
    '__traffic' => "Lưu lượng",
    '__traffic_by_client' => "Lưu lượng truy cập của khách hàng",
    '__traffic_by_domain' => "Lưu lượng truy cập của tên miền",
    '__traffic_by_service' => "Lưu lượng truy cập của dịch vụ",
    '__traffic_history' => "Lược sử lưu lượng",
    '__unable_change_locale' => "Không thể thay đổi giao diện ngôn ngữ: %1",
    '__unable_create_new_dom' => "Nhấn để tạo tên miền: %1",
    '__unable_define_dom_name' => "Không thể xác định tên miền: %1",
    '__unable_define_necessary_properties' => "Không thể xác định tất cả các thuộc tính yêu cầu.",
    '__unable_define_properties' => "Không thể xác định các thuộc tính: %1",
    '__unable_exec_util' => "Không thể thực thi tiện ích: %1",
    '__unable_get_dns_a_recs' => "Không thể lấy được địa chỉ IP ứng với bản ghi A DNS cho tài khoản lưu trữ này: %1",
    '__unable_get_mbox_quota' => "Không thể lấy được thông tin về giới hạn kích thước hộp thư.",
    '__unable_redirect_to_myself' => "Không thể chuyển tiếp đến cùng tài khoản.",
    '__unable_redirect_to_my_alias' => "Không thể chuyển tiếp thư đến một bí danh thư.",
    '__default_domain_redirect_to_myself' => "Không thể thiết lập tên miền mặc định cho địa chỉ IP:\nphát hiện tự chuyển hướng về chính nó.",
    '__unable_remove_client' => "Không thể gỡ bỏ khách hàng: %1",
    '__unable_set_up_mbox_quota' => "Không thể thiết lập giới hạn dung lượng hộp thư cho tên miền: %1",
    '__unable_setup_pass' => "Không thể thiết lập mật khẩu: %1",
    '__unable_to_create_new_account' => "Không thể tạo tài khoản: %1",
    '__unable_to_define_db_size' => "Không thể xác định kích thước cơ sở dữ liệu.",
    '__unable_to_enable_short_names' => "Không thể cho phép sử dụng tên tài khoản thư ngắn gọn cho tài khoản POP3/IMAP.",
    '__unable_to_fetch_data_from_submit' => "Không thể tải dữ liệu đã gửi: %1",
    '__unable_to_open_file' => "Không thể mở tập tin %1: %2",
    '__unable_to_update_subdomain' => "Không thể làm thay đổi cho tên miền con: %1",
    '__unable_update_cl_data' => "Không thể lưu các thay đổi vào tài khoản người dùng: %1",
    '__unable_update_db_params' => "Không thể cập nhật các tham số cơ sở dữ liệu: %1",
    '__unable_update_dom_data' => "Không thể cập nhật dữ liệu tên miền: %1",
    '__undefined' => "không xác định",
    '__uninstall' => "Gỡ cài đặt",
    '__unknown_error' => "Lỗi không xác định",
    '__unlimited_lower' => "Không giới hạn",
    '__unset' => "Tắt",
    '__update' => "Cập nhật",
    '__uploaded_file_is_invalid' => "Tập tin được tải lên không hợp lệ: %1",
    '__url' => "URL",
    '__usage' => "Sử dụng đĩa",
    '__user' => 'Người dùng',
    '__user_already_logged' => "Có người dùng khác có cùng tên người dùng (%1) đã đăng nhập vào Plesk.",
    '__version' => "Phiên bản",
    '__aps_license' => "Mã bản quyền",
    '__vh_type' => "Kiểu lưu trữ ảo",
    '__vhosts_apache_status' => "Trạng thái máy chủ Web",
    '__wrong_charset_conversion' => 'Sai ký tự, chuyển từ "%1" đến "%2" không được cho phép',
    '__warning_' => "Cảnh báo!",
    '__warning_excl_ip_num' => "Địa chỉ IP chuyên dụng",
    '__warning_expiration' => "Ngày hết hạn",
    '__web_scripting' => "Mã Web", // indirect
    '__web_serv' => "Máy chủ Web", // indirect
    '__web_statistic' => "Thống kê Web", // indirect
    '__webmail' => "Trình Quản lý thư trực tuyến", // +indirect
    '__webstat_not_installed' => "Webalizer hiện không được cài đặt trên máy chủ. Liên hệ với quản trị viên để hỗ trợ cài đặt Webalizer.",
    '__webstat_support' => "Thống kê Web",
    '__webstat_awstats_support' => "AWStats",
    '__webstat_webalizer_support' => "Webalizer",
    '__webstat_awstats' => "AWStats",
    '__webstat_webalizer' => "Webalizer",
    '__webstat_type_change_warning' => "Khi bản chuyển từ một chương trình thống kê sang chương trình khác, tất cả các báo cáo được tạo bởi chương trình thống kê sử dụng trước đó sẽ bị xóa và các báo cáo mới được tạo theo thông tin đọc được từ các tệp nhật ký lưu trên máy chủ. Điều này có nghĩa là nếu bạn đã cấu hình hệ thống (tại Miền > tên miền > Trình quản lý nhật ký > Luân chuyển nhật ký) để lưu các tệp nhật ký chỉ trong tháng qua, thì thống kê web sẽ chỉ khả dụng cho tháng đó. Bạn có muốn chuyển sang gói thống kê khác không?",
    '__webstat_perm_denied' => 'Bạn không có quyền quản lý thống kê web.',
    '__webuser' => "Người dùng web",
    '__sysusers_list' => "Người dùng hệ thống",
    '__sysuser' => "Người dùng hệ thống",
    '__weekly' => "Hàng tuần",
    '__whats_new_in_version' => "Có gì mới trong Plesk %1?",
    '__wrong_hosting_type__virtual_required' => "Tính năng này chỉ có hiệu lực với các tên miền được cấu hình lưu trữ web.",
    '__wrong_hosting_type__none' => 'Không có cấu hình lưu trữ web cho tên miền %1.',
    '__wrong_hosting_type__std_fwd' => 'Tên miền %1 đã được cấu hình chuyển tiếp dạng chuẩn. Tính năng này chỉ có hiệu lực với các tên miền được cấu hình lưu trữ web.',
    '__wrong_hosting_type__frm_fwd' => 'Tên miền %1 đã được cấu hình chuyển tiếp dạng khung. Tính năng này chỉ có hiệu lực với các tên miền được cấu hình lưu trữ web.',
    '__wu' => "Người dùng Web",
    '__www' => "WWW",
    '__www_prefix_was_changed' => "Tiền tố WWW được thay đổi. Đảm bảo phải sửa đổi chứng nhận SSL/TLS cho phù hợp.",
    '__year' => "Năm",
    '__year(s)' => "Năm",
    '__yes' => "Có",
    '__you' => "Bạn",
    '__zip_code' => "Mã bưu điện/Mã ZIP",
    '__form_normal' => "Bình thường",
    '__form_advanced' => "Nâng cao",

    'admin_ed__edit_administrator_info' => "Hiệu chỉnh thông tin của quản trị viên",
    'admin_ed__create_default_client' => "Tôi muốn tạo tài khoản khách hàng mặc định.",
    'admin_ed__unable_update' => "Không thể cập nhật thông tin của quản trị viên: %1",

    'auth__update_admin_info' => "Hãy nhập thông tin của quản trị viên. Thông tin này được yêu cầu để thực thi %1.",
    'auth__you_not_have_perm' => "Bạn không có quyền để quản lý tên miền này.",
    'auth__key_expired_admin' => 'Bản quyền Plesk của bạn đã hết hạn. Để tiếp tục sử dụng Plesk, hãy gia hạn giấy phép bản quyền hoặc mua giấy phép bản quyền mới.',
    'auth__key_expired_admin_restricted' => 'Bản quyền Plesk của bạn đã hết hạn. Liên hệ với nhà cung cấp dịch vụ của bạn để tiếp tục sử dụng Plesk.',
    'auth__key_expired_client' => 'Giấy phép bản quyền Plesk đã hết hạn. Vui lòng liên hệ với nhà cung cấp dịch vụ lưu trữ.',
    'autoinstaller__not_installed' => 'Thành phần Autoinstaller không được cài đặt.',
    'autoinstaller__release_action' => 'Các hoạt động hiện có',
    'autoinstaller__release_action_icon' => 'S',
    'autoinstaller__release_action_upgrade' => 'Nâng cấp lên phiên bản Plesk mới',
    'autoinstaller__release_action_update' => 'Đang cập nhật hoặc đang thêm thành phần mới',
    'autoinstaller__release_action_up2date' => 'Bạn đã có phiên bản mới',
    'autoinstaller__component_action' => 'Trạng thái',
    'autoinstaller__component_action_icon' => 'S',
    'autoinstaller__component_action_install' => 'Chưa cài đặt',
    'autoinstaller__component_action_update' => 'Các bản cập nhật đang có sẵn',
    'autoinstaller__component_action_upgrade' => 'Một bản cập nhật hiện có',
    'autoinstaller__component_action_up2date' => 'Bạn đã có phiên bản mới',
    'autoinstaller__component_action_error' => 'Hiện không có bản cập nhật nào',
    'autoinstaller__component_serverbuildtime' => 'Phiên bản mới phát hành',
    'autoinstaller__component_localbuildtime' => 'Phiên bản của bạn',
    'autoinstaller__component_installed_version' => 'Phiên bản của bạn',
    'autoinstaller__component_available_version' => 'Phiên bản mới nhất',
    'autoinstaller__component' => 'Thành phần',
    'autoinstaller__components' => 'Thành phần',
    'autoinstaller__components_title' => '%1 Các thành phần',
    'autoinstaller__component_dependency_note' => 'được yêu cầu để cài đặt các thành phần được chọn',
    'autoinstaller__install_confirm' => 'Có, tôi muốn cài đặt các thành phần này',
    'autoinstaller__install_confirm_request' => 'Hãy đánh dấu kiểm để xác nhận',
    'autoinstaller__install_title' => 'Xác nhận cài đặt các thành phần được chọn',
    'autoinstaller__key_update_confirm' => 'Xác nhận không cập nhật mã bản quyền và cài đặt mã mặc định',
    'autoinstaller__key_update_confirm_request' => 'Hãy đánh dấu kiểm để xác nhận.',
    'autoinstaller__key_update_failed' => '<p>Plesk không thể cập nhật bản quyền sản phẩm của bạn.</p><p>%1<p/><p>Tiếp tục với việc nâng cấp mà không có bản quyền sản phẩm thích hợp sẽ dẫn đến việc cài đặt một bản quyền mặc định có tính năng hạn chế. Các quản trị viên cần có key bản quyền thích hợp trước khi tiếp tục nâng cấp sản phẩm.</p>',
    'autoinstaller__email' => 'Gửi thông báo đến',
    'autoinstaller__email_admin' => "Email của quản trị viên",
    'autoinstaller__email_email' => 'Tùy chỉnh địa chỉ email...',
    'autoinstaller__release' => 'Tên phiên bản',
    'autoinstaller__releases' => 'Các bản phát hành hiện có',
    'autoinstaller__releases_title' => 'Trình cập nhật Plesk Updater',
    'autoinstaller__select_components_to_install' => 'Chọn các thành phần để cài đặt',
    'autoinstaller__status_error' => 'Lỗi: %1',
    'autoinstaller__status_install_error' => 'Tiến trình cài đặt không thể được bắt đầu: %1',
    'autoinstaller__status_install_busy' => 'Tiến trình cài đặt không thể được bắt đầu: tiến trình cài đặt khác đang thực hiện.',
    'autoinstaller__status_install_ok' => 'Bắt đầu cài đặt. Bạn sẽ được thông báo về quá trình cài đặt qua email (%1).',
    'autoinstaller__status_query_busy' => 'Đang cài đặt.',
    'autoinstaller__status_query_error' => 'Không thể xác định trạng thái cài đặt: %1',
    'autoinstaller__status_unknown' => 'Không thể lấy được thông tin về trình cài đặt.',
    'autoinstaller__status_busy' => 'Trình cài đặt tự động đang bận, hãy chờ.',
    'autoinstaller__configure_title' => 'Các thiết lập cập nhật',
    'autoinstaller__preferences_legend' => 'Cài đặt',
    'autoinstaller__target' => 'Thư mục tải về tạm thời',
    'autoinstaller__target_invalid' => "Chỉ định đường dẫn tuyệt đối",
    'autoinstaller__check_updates' => 'Kiểm tra các cập nhật khi quản trị viên đăng nhập vào Plesk',
    'autoinstaller__check_updates_warning' => 'Mới <a href="%1">cập nhật</a> hiện có %2',
    'autoinstaller__source_type' => 'Kiểu nguồn',
    'autoinstaller__source' => 'Địa chỉ URL nguồn',
    'autoinstaller_source__preferences_legend' => 'Cài đặt',
    'autoinstaller_source__type' => 'Kiểu nguồn',
    'autoinstaller_source__url_invalid' => 'Nguồn không hợp lệ',
    'autoinstaller_source__url_invalid_network' => 'Địa chỉ URL nguồn không hợp lệ (Thí dụ: http://source, ftp://source)',
    'autoinstaller_source__url' => 'Địa chỉ URL nguồn',
    'autoinstaller__source_invalid_network' => 'Bạn chỉ định địa chỉ mạng không hợp lệ',
    'backup__repository' => 'Vị trí lưu trữ tập tin sao lưu',
    'backup__error_notify_email' => 'Nếu xảy ra lỗi trong quá trình sao lưu, gửi thông báo đến email',
    'backup__dump_info' => "Thông tin sao lưu",
    'backup__dump_file_name_not_defined' => "Tên tập tin sao lưu dự phòng không được chỉ định",
    'backup__local_file' => 'Tập tin sao lưu cục bộ',
    'backup__domain_ftp' => 'Máy chủ FTP từ xa',
    'backup__wrong_path' => "Đường dẫn đến nơi lưu trữ các tập tin sao lưu không đúng: Không sử dụng chuỗi các ký tự ../../",
    'backup__unable_to_connect_to_ftp_server' => "Không thể kết nối đến máy chủ FTP: %1",
    'backup__unable_to_read_file' => 'Không thể đọc tập tin sao lưu dự phòng.',
    'backup__backup_task_does_not_exist' => "Tác vụ sao lưu dự phòng không tồn tại, bạn nên tạo nó trước khi mở.",
    'backup__restore_params' => "Các tham số khôi phục",
    'backup__confirmation' => "Cảnh báo: tên miền sẽ không hoạt động trong suốt thời gian sao lưu/khôi phục.",
    'backup__backup_method' => 'Phương thức sao lưu',
    'backup__dumpfile_name' => "Tên tập tin cơ sở dữ liệu",
    'backup__dumpfile_name_is_invalid' => "Tên tập tin sao lưu không hợp lệ: chỉ sử dụng các ký tự chữ, số, dấu chấm, gạch ngang và gạch dưới, không sử dụng tên giống phần mô tả.* làm tên tập tin sao lưu.",
    'backup__email_required' => "Cần cung cấp địa chỉ email của bạn để thông báo về tiến trình sao lưu và khôi phục. Vui lòng chỉ định email của bạn trong chi tiết tài khoản.",
    'backup__error_during_backup' => "Không thể tạo tập tin sao lưu: %1",
    'backup__input_email_warning' => "Bạn nên chỉ định email nhận thông báo hoặc xóa đánh dấu.",
    'backup__make_download' => "không sao lưu tập tin trong lưu trữ, chỉ được tải xuống",
    'backup__make_dump' => 'tạo tập tin sao lưu và lưu vào lưu trữ cục bộ',
    'backup__makedump_to_ftp' => 'Tạo tập tin sao lưu dự phòng và lưu trữ tại máy chủ FTP',
    'backup__restore_ip' => "Địa chỉ IP để khôi phục",
    'backup__select_dumpfile' => "Chọn một tập tin sao lưu.",
    'backup__time' => "Thời gian sao lưu",
    'backup__day' => 'Ngày sao lưu',
    'backup__view_dump_info' => "Xem thông tin sao lưu cho tên miền %1",
    'backup__wrong_domain_name' => "Tập tin sao lưu chứa dữ liệu của tên miền %1 và vì vậy không thể khôi phục vào tên miền %2",
    'backup__incorrect_ftp_user_or_passwd' => "Tên đăng nhập FTP hoặc mặt khẩu không đúng. Hãy nhập đúng thông tin đăng nhập",
    'backup__access_denied' => "Từ chối truy cập. Hãy nhập đúng thông tin đăng nhập",
    'backup__restore_from' => "Khôi phục %1",
    'backup__domain_session_failed' => 'Tên miền %1 không được sao lưu',
    'backup__client_session_failed' => 'Khách hàng %1 không được sao lưu',
    'backup__domain_session_restore_failed' => 'Tên miền %1 không được khôi phục',
    'backup__client_session_restore_failed' => 'Tài khoản khách hàng %1 không được khôi phục',
    'backup__domain_session_complete' => 'Tên miền %1 đã được sao lưu',
    'backup__domain_session_backup' => 'Sao lưu tên miền %1',
    'backup__client_session_backup' => 'Sao lưu khách hàng %1',
    'backup__domain_stop_title' => 'Hủy sao lưu tên miền %1',
    'backup__client_stop_title' => 'Hủy sao lưu tài khoản khách hàng %1',
    'backup__domain_restore_stop_title' => 'Hủy khôi phục tên miền %1',
    'backup__client_restore_stop_title' => 'Hủy khôi phục tài khoản khách hàng %1',
    'backup__domain_session_backup_stop' => 'Bạn sắp hủy tiến trình sao lưu đang hoạt động. Tệp sao lưu sẽ không được tạo.',
    'backup__backup_stop_confirm' => 'Có, tôi muốn dừng tiến trình sao lưu',
    'backup__restore_stop_confirm' => 'Có, tôi muốn dừng tiến trình khôi phục',
    'backup__domain_session_restore' => 'Khôi phục tên miền %1',
    'backup__domain_session_restore_stop' => 'Bạn sắp hủy tiến trình khôi phục đang hoạt động.',
    'backup__domain_backup_file_info' => 'Thông tin tập tin sao lưu dự phòng',
    'backup__domain_backup_file_list' => 'các tập tin sao lưu đang tồn tại',
    'backup__domain_backup_progress' => 'Tiến trình sao lưu website %1',
    'backup__domain_restore_progress' => 'Tiến trình khôi phục website %1',
    'backup__domain_backup_progress_elapsed_time' => 'Thời gian trôi qua: %1',
    'backup__domain_restore_progress_elapsed_time' => 'Thời gian trôi qua: %1',
    'backup__domain_restore_session_complete' => 'Tên miền %1 được khôi phục.',
    'backup__domain_restore_session_complete_message' => 'Tên miền %1 đã được khôi phục.',
    'backup__domain_backup_file_delete' => 'Tập tin sao lưu dự phòng sau sẽ được gỡ bỏ:',
    'backup__domain_backup_file_for_remove' => 'Chọn tập tin sao lưu dự phòng bạn muốn gỡ bỏ',
    'backup__backup_overwrite_file_confirm' => 'Xác nhận thay thế',
    'backup__backup_overwrite_file_confirm_text' => 'Tên tập tin sao lưu "%1" đã tồn tại rồi. Bạn có muốn thay thế nó không?',
    'backup__backup_confirm_overwrite' => 'Xác nhận thay thế tập tin',
    'backup__backup_overwrite_legeng' => 'Thay thế',
    'backup__backup_not_contain_domain' => 'Tên tập tin sao lưu không chứa thông tin về tên miền %1',
    'backup__backup_not_contain_client' => 'Tập tin sao lưu không chứa thông tin về tài khoản khách hàng %1',
    'backup__backup_client_info' => "Sao lưu các cài đặt của khách hàng và chi tiết tài khoản",
    'backup__client_backup_progress' => 'Tiến trình sao lưu tài khoản khách hàng %1',
    'backup__client_session_complete' => 'Tài khoản khách hàng %1 đã được sao lưu',
    'backup__client_backup_file_info' => 'Thông tin tập tin sao lưu của khách hàng',
    'backup__restore_client_info' => "Khôi phục các cài đặt của khách hàng và chi tiết tài khoản",
    'backup__client_session_restore' => 'Khôi phục tài khoản khách hàng %1',
    'backup__client_db_server_map' => 'Ánh xạ máy chủ cơ sở dữ liệu',
    'backup__domain_db_server_map' => 'Ánh xạ máy chủ cơ sở dữ liệu',
    'backup__client_restore_session_complete_message' => 'Tài khoản khách hàng %1 đã được khôi phục.',
    'backup__client_restore_session_complete' => 'Tài khoản khách hàng %1 đã được khôi phục.',
    'backup__restore_select_some' => 'Hãy chọn các đối tượng bạn muốn khôi phục.',
    'backup__client_restore_progress' => 'Tiến trình khôi phục tài khoản khách hàng %1',
    'backup__new_backup' => 'Tạo sao lưu mới',
    'backup__done' => 'Hoàn thành:',
    'backup__done_domains' => '%1 tên miền của %2',
    'backup__done_clients' => '%1 khách hàng của %2',
    'backup__remaining' => 'Còn lại:',
    'backup__remaining_domains' => '%1 tên miền',
    'backup__remaining_clients' => '%1 khách hàng',
    'backup__overall_backup_progress' => 'Toàn bộ tiến trình sao lưu',
    'backup__comment_n_a' => 'không có',
    'backup__command_ignore' => 'Lệnh "%1" đã được bỏ qua',
    'backup__no_objects' => 'Không có các đối tượng sao lưu',
    'backup__cli_warning_not_enough_ip' => 'CẢNH BÁO: không đủ địa chỉ IP để thực hiện ánh xạ IP:',
    'backup__local_repository' => "Lưu trữ của Plesk",
    'backup__ftp_repository' => 'Bộ lưu trữ DTP',
    'backup__ftp_login' => 'Tên người dùng',
    'backup__ftp_password' => 'Mật khẩu',
    'backup__ftp_account_settings' => 'Các thiết lập tài khoản FTP',
    'backup__ftp_account_preferences' => 'Các tài khoản tài khoản FTP',
    'backup__repository_not_exist' => 'Thư mục không tồn tại',
    'backup__repository_not_readable' => 'Thư mục chỉ định không thể đọc',
    'backup__ftp_repository_not_configure' => 'Để sử dụng lưu trữ sao lưu FTP, <a href="%1">chỉ định tài khoản FTP</a>trước tiên.',
    'backup__ftp_repository_list_not_configure' => 'Các thiết lập tài khoản không được chỉ định',
    'backup__repository_list_unable_listing' => 'Không thể lấy danh sách các tập tin',
    'backup__ftp_repository_unable_listing' => 'Không thể lấy được danh sách thư mục "%1":',
    'backup__repository_legend' => 'Lưu trữ tập tin sao lưu',
    'backup__store_in_repository' => 'Lưu trữ các tập tin trong',
    'backup__local_repository_lable' => 'Lưu trữ cục bộ',
    'backup__ftp_repository_lable' => 'Bộ lưu trữ DTP',
    'backup__ftp_repository_not_configure_hint' => '(các thiết lập tài khoản không được chỉ định)',
    'backup__ftp_repository_not_configure_or_forbidden_hint' => '(Tài khoản FTP không được chỉ định hoặc không được hỗ trợ)',
    'backup__other_user_process_modified' => 'Người dùng khác đã dừng việc sao lưu hoặc tiến trình di chuyển.',
    'backup__another_user_exist' => 'Thao tác đang thực hiện đã được bắt đầu bởi một người dùng Plesk khác. Người dùng này vẫn đang đăng nhập trong Plesk.',
    'backup__ftp_repository_wait' => 'Hãy chờ trong khi lấy thông tin về lưu trữ FTP',
    'backup__ftp_write_test_failed' => 'Kiểm tra việc ghi dữ liệu bằng tài khoản FTP chỉ định thất bại %1:',
    'backup__ftp_storage' => 'Lưu trữ FTP(S)',
    'bt_upload_to_repository' => 'Tải lên tập tin vào lưu trữ cục bộ',
    'bt_new_restore' => "Khôi phục",
    'bt_backup_schedule' => "Lập lịch sao lưu",
    'backup_exist_backups' => "Các tập tin sao lưu đang tồn tại",
    'backup_dialog__page_title' => "Tạo tập tin sao lưu",
    'backup_dialog__please_wait' => "Tiến trình sao lưu đang bắt đầu. Thao tác này cần một khoảng thời gian. Vui lòng chờ...",
    'backup_conf__page_title' => 'Cấu hình sao lưu',
    'bt_accept' => "Chấp nhận",
    'bt_access' => "Truy cập",
    'bt_action_log' => "Nhật ký hoạt động",
    'bt_add' => "Thêm",
    'bt_add_client' => "Gán cho người dùng",
    'bt_database_server_add' => 'Thêm máy chủ cơ sở dữ liệu',
    'bt_add_services' => "Thêm các dịch vụ",
    'bt_anonftp_stats' => "Thống kê FTP ẩn danh",
    'bt_anonymous_ftp' => "FTP ẩn danh",
    'bt_aspdotnet' => "ASP.NET",
    'bt_attach' => "Đính kèm",
    'bt_autoinstaller' => 'Trình cập nhật',
    'bt_auto-updates' => 'Trình cập nhật',
    'bt_back' => "<< Quay lại",
    'bt_backup' => "Sao lưu",
    'bt_backup_configure' => "Các thiết lập sao lưu",
    'bt_buy_certs' => "Mua các chứng chỉ",
    'bt_card' => "Thẻ",
    'bt_cert' => "Chứng chỉ",
    'bt_certificates' => "Chứng chỉ",
    'bt_change_passwd' => "Thay đổi mật khẩu",
    'bt_clear' => "Xóa",
    'bt_client_templates' => "Mẫu khách hàng",
    'bt_clients' => "Khách hàng",
    'bt_codepage_change' => 'Thay đổi mã',
    'bt_comp_info' => "Quản lý thành phần",
    'bt_configure_maillists' => "Cài đặt Mailman",
    'bt_configure' => 'Cấu hình',
    'bt_copy' => "Sao chép",
    'bt_copy_move' => "Sao chép/Di chuyển",
    'bt_create' => "Tạo",
    'bt_create_account' => "Tạo một tài khoản",
    'bt_create_dir' => "Thêm danh mục",
    'bt_create_file' => "Thêm tập tin",
    'bt_count_size' => "Tính Kích Thước",
    'bt_crontab_unix' => "Crontab",
    'bt_crontab_win' => "Lập lịch tác vụ",
    'bt_custom_button_new' => "Thêm nút",
    'bt_custom_buttons' => "Các nút tùy biến",
    'bt_customize' => "Tùy biến",
    'bt_databases' => "Cơ sở dữ liệu",
    'bt_database_servers' => 'Máy chủ cơ sở dữ liệu',
    'bt_sqlservers' => "Máy chủ cơ sở dữ liệu",
    'bt_db_usr_new' => "Thêm người dùng cơ sở dữ liệu",
    'bt_db_new' => "Thêm cơ sở dữ liệu",
    'bt_db_phpmyadmin' => "Quản trị MySQL",
    'bt_dbuser_default' => "Đặt mặc định cho DB Webadmin",
    'bt_decline' => "Từ chối",
    'bt_default' => "Mặc định",
    'bt_defaultcomponents' => "Dịch vụ bên thứ ba",
    'bt_defaults' => "Mặc định",
    'bt_delete' => "Xóa",
    'bt_directories' => "Thư mục được bảo vệ",
    'bt_disable' => "Tắt",
    'bt_dns_zone_sync' => 'Áp dụng các thay đổi Mẫu DNS',
    'bt_dnsrecord_add' => 'Thêm bản ghi',
    'bt_do_backup' => "Sao Lưu",
    'bt_do_restore' => "Khôi phục",
    'bt_do_upload' => "Tải lên",
    'bt_domain_aliases' => "Bí danh tên miền",
    'bt_domain_templates' => "Mẫu tên miền",
    'bt_domain_user' => "Quản trị tên miền",
    'bt_domain_user_passwd' => "Mật khẩu quản trị tên miền",
    'bt_domains' => "Các tên miền",
    'bt_domain_alias_add' => 'Thêm bí danh tên miền',
    'bt_download' => "Tải xuống",
    'bt_edit' => "Hiệu chỉnh",
    'bt_enable' => "Bật",
    'bt_export' => 'Xuất',
    'bt_extras' => "Mở rộng",
    'bt_finish' => "Hoàn thành",
    'bt_ftp_account' => "Các thuộc tính tài khoản FTP",
    'bt_forget_password' => "Quên mật khẩu?",
    'bt_fp_ssl_webadmin' => "Quản trị web FP-SSL/TLS",
    'bt_fp_webadmin' => "FP Webadmin",
    'bt_ftp_stats' => "Thống kê FTP",
    'bt_get_password' => "Lấy mật khẩu",
    'bt_global_changes' => "Sửa đổi",
    'bt_help' => "Trợ giúp",
    'bt_hide_aliases' => "Ẩn các bí danh",
    'bt_hide_toolbar' => 'Ẩn thanh công cụ',
    'bt_hide_subdomains' => "Ẩn các tên miền con",
    'bt_hide_domainaliases' => "Ẩn các bí danh tên miền",
    'bt_home' => "Trang chủ",
    'bt_hosting' => "Vùng lưu trữ",
    'bt_icf' => 'Tường lửa',
    'bt_install' => "Cài đặt",
    'bt_ip_aliasing' => "Địa chỉ IP",
    'bt_ip_add' => "Thêm Địa chỉ IP",
    'bt_ip_pool' => "Dãy IP",
    'bt_key_info' => "Thông tin bản quyền",
    'bt_key_buyonline_addons' => 'Lệnh phụ trợ của Plesk',
    'bt_key_buyonline_upgrades' => 'Lệnh nâng cấp của Plesk',
    'bt_key_buyonline_new' => 'Đặt hàng mã bản quyền mới',
    'bt_limits' => "Các giới hạn",
    'bt_locale_add' => 'Thêm vùng ngôn ngữ',
    'bt_locales' => 'Vùng ngôn ngữ',
    'bt_log_manager' => "Quản lý nhật ký",
    'bt_login' => "Đăng nhập",
    'bt_logo' => "Chi nhánh",
    'bt_logo_send_link' => "Đính kèm liên kết",
    'bt_logo_send_logo' => "Đính kèm logo",
    'bt_logout' => "Thoát",
    'bt_logrotation' => "Luân chuyển nhật ký",
    'bt_mail' => "Thư",
    'bt_mail_alias_add' => "Thêm bí danh thư",
    'bt_mail_aliases' => "Các bí danh thư",
    'bt_mail_group_add' => "Thêm thành viên",
    'bt_mail_groups' => "Nhóm",
    'bt_mail_name_add' => "Thêm tài khoản thư",
    'bt_mail_preferences' => "Cài đặt",
    'bt_mail_group' => "Nhóm thư",
    'bt_mail_mailbox' => "Hộp thư",
    'bt_mail_redirect' => "Bộ chuyển hướng",
    'bt_mail_resp_add' => "Thêm tự động trả lời",
    'bt_mail_resp_attach_add' => "Thêm bản đính kèm",
    'bt_mail_resp_files' => "Các tập tin đính kèm",
    'bt_mail_responders' => "Trả lời tự động",
    'bt_mail_spamfilter' => "Bộ lọc thư rác",
    'bt_mail_webmail' => "Trình Quản lý thư trực tuyến",
    'bt_maillist_new' => "Thêm danh sách gửi thư",
    'bt_maillists' => "Danh sách gửi thư",
    'bt_mailman' => "Mailman",
    'bt_make_dump' => "Tạo sao lưu dự phòng",
    'bt_manage' => "Quản lý",
    'bt_master' => "Chính",
    'bt_migrate' => 'Di chuyển',
    'bt_modules_add' => 'Thêm mở rộng',
    'bt_modules_manage' => 'Quản lý mở rộng',
    'bt_move' => "Di chuyển",
    'bt_mimetypes' => 'Các kiểu MIME',
    'bt_mimetype_new' => 'Thêm kiểu MIME',
    'bt_new_client' => "Thêm tài khoản khách hàng",
    'bt_new_domain' => "Thêm miền",
    'bt_next' => "Tiếp tục >>",
    'bt_next_page' => "Tiếp theo",
    'bt_network_add' => "Thêm mạng",
    'bt_notifications' => "Thông báo",
    'bt_off' => "Tắt",
    'bt_on' => "Bật",
    'bt_on_off' => "Bật/Tắt",
    'bt_pd_new' => "Thêm thư mục được bảo vệ",
    'bt_pd_user_new' => "Thêm người dùng",
    'bt_performance' => 'Hiệu suất',
    'bt_permissions' => "Quyền truy cập",
    'bt_phpmyadmin' => "PhpMyAdmin",
    'bt_postgre_sql' => "PostgreSQL",
    'bt_preferences' => "Cài đặt",
    'bt_prev_page' => "Trước",
    'bt_preview' => 'Xem trước',
    'bt_print' => "In",
    'bt_reboot' => "Khởi động lại",
    'bt_reload' => "Tải lại",
    'bt_refresh' => "Cập nhật mới",
    'bt_register' => "Đăng ký",
    'bt_remove' => "Gỡ bỏ",
    'bt_enable_selected' => 'Bật',
    'bt_disable_selected' => 'Tắt',
    'bt_repair_ip' => "Sửa IP",
    'bt_report' => "Báo cáo",
    'bt_report_new' => "Thêm giao diện",
    'bt_reset' => "Đặt lại",
    'bt_restart_services' => "Trình Quản lý dịch vụ",
    'bt_save' => "Lưu",
    'bt_send_by_email' => "Gửi qua email",
    'bt_send_file' => "Gửi tập tin",
    'bt_send_mail' => "Gửi thư",
    'bt_send_passwd' => "Gửi mật khẩu",
    'bt_send_text' => "Gửi nội dung",
    'bt_server' => "Máy chủ",
    'bt_server_add' => "Thêm máy chủ",
    'bt_server_preferences' => "Các thiết lập máy chủ",
    'bt_servers_list' => "Các máy chủ",
    'bt_sessions' => "Phiên",
    'bt_set' => "Thiết lập",
    'bt_set_as_default' => "Thiết lập mặc định",
    'bt_setup' => 'Cài đặt',
    'bt_show_aliases' => "Hiển thị các bí danh",
    'bt_show_subdomains' => "Hiện các tên miền con",
    'bt_show_domainaliases' => "Hiện các bí danh tên miền",
    'bt_shutdown' => "Tắt",
    'bt_site_apppkgs' => "Kho ứng dụng",
    'bt_site_apppool' => "Dải ứng dụng",
    'bt_application-pool' => "Ứng dụng Web",
    'bt_site_apps' => "Ứng dụng Web",
    'bt_site_app_add' => "Cài đặt ứng dụng",
    'bt_site_builder' => "Hỗ trợ Presence Builder",
    'bt_skeleton' => 'Mẫu lưu trữ ảo',
    'bt_skins' => 'Các giao diện',
    'bt_skin_add' => 'Thêm giao diện nền',
    'bt_skin_manual' => 'Tùy chỉnh Tham chiếu giao diện nền Plesk', // not used
    'bt_skin_download' => 'Tải hình nền xuống',
    'bt_skin_replace' => 'Cập nhật hình nền',
    'bt_skip' => 'Bỏ qua',
    'bt_spamassassin' => "Bộ lọc thư rác",
    'bt_spamassassin_train' => "Huấn luyện",
    'bt_spamfilter' => "Bộ lọc thư rác",
    'bt_start' => "Bắt đầu",
    'bt_stop' => "Ngừng",
    'bt_recycle' => "Quay vòng",
    'bt_statistics' => "Thống kê",
    'bt_subdomain_new' => "Thêm tên miền phụ",
    'bt_subdomains' => "Tên miền phụ",
    'bt_submit' => "Gửi đi",
    'bt_summary_report' => "Báo cáo tóm tắt",
    'bt_support' => "Hỗ trợ",
    'bt_switch' => "Chuyển",
    'bt_system_time' => "Giờ Hệ thống",
    'bt_task_new' => "Thêm nhiệm vụ",
    'bt_dom_tmpl_add' => 'Thêm mẫu tên miền',
    'bt_cl_tmpl_add' => 'Thêm mẫu khách hàng',
    'bt_cron_backup' => 'Các thiết lập Sao lưu đã được lập lịch',
    'bt_test' => "Kiểm tra kết nối",
    'bt_text' => "Nội dung",
    'bt_touch' => "Thay đổi Thời gian",
    'bt_traffic' => "Lưu lượng",
    'bt_traffic_history' => "Lược sử lưu lượng",
    'bt_update' => "Cập nhật",
    'bt_upload' => "Tải lên",
    'bt_upload_from_ftp' => "Tải lên FTP",
    'bt_virtualdirs' => 'Thư mục ảo',
    'bt_virtualdir_new' => 'Thêm thư mục ảo',
    'bt_virtualdir_add' => 'Thêm thư mục ảo',
    'bt_web_app_new' => "Cài đặt ứng dụng Java",
    'bt_web_stats' => "Thống kê Web",
    'bt_web_stats_ssl' => "Thống kê web SSL/TLS",
    'bt_web_user_add' => "Thêm người dùng web",
    'bt_web_users' => "Người dùng web",
    'bt_webadmin' => "Webadmin",
    'bt_webalizer' => "Webalizer",
    'bt_whats_new_full' => "Xem danh sách các thay đổi",
    'cert_add__unable_set_ca_cert' => "Không thể thiết lập chứng chỉ CA: %1",
    'cert_add__unable_set_cert' => "Không thể thiết lập chứng chỉ: %1",
    'cert_add__unable_set_private_key' => "Không thể thiết lập khóa riêng: %1",
    'certificates_list__certificate_used_as_default' => "Một trong những chứng nhận bạn dự định xóa đang được sử dụng làm Chứng nhận Mặc định.",
    'certificates_list__certificates_assigned_on_ip' => "Một hoặc nhiều chứng nhận được cấp cho miền/địa chỉ IP.",
    'ch_pass__admin_pass' => "Thay đổi mật khẩu của quản trị viên",
    'ch_pass__old_pass' => "Mật khẩu cũ",
    'ch_pass__pass_confirm' => "Xác nhận",
    'ch_pass__unable_change_admin_pass' => "Không thể thay đổi mật khẩu của người quản trị. %1",
    'check_mail_cycle__aliases' => "Luân chuyển thư được phát hiện, địa chỉ \"%1\" thuộc bí danh của tài khoản thư này.",
    'check_mail_cycle__autoresponders' => "Tái chuyển thư được phát hiện, địa chỉ \"%1\" có trong trả lời tự động của tài khoản thư này.",
    'check_mail_cycle__mail_groups' => "Luân chuyển thư đã được phát hiện, địa chỉ \"%1\" nằm trong nhóm thư của tài khoản thư này.",
    'check_mail_cycle__mail_name' => "Luân chuyển thư đã được phát hiện, địa chỉ \"%1\" trùng với tài khoản thư này.",
    'check_mail_cycle__redirect' => "Tái chuyển thư được phát hiện, địa chỉ \"%1\" trùng với bộ chuyển tiếp của tài khoản thư này.",
    'check_mail_dup__redirect' => "Chuyển tiếp lặp được phát hiện, địa chỉ \"%1\" trùng với địa chỉ chuyển tiếp của tài khoản thư này.",
    'check_mail_dup__mail_groups' => "Chuyển tiếp lặp được phát hiện, địa chỉ \"%1\" có trong nhóm thư của tài khoản thư này.",
    'check_maillist_cycle__admin' => "Tái chuyển thư được phát hiện, email của quản trị viên \"%1\" trùng với địa chỉ của danh sách gửi thư.",
    'check_maillist_cycle__member' => "Luân chuyển thư được phát hiện, địa chỉ \"%1\" trùng với địa chỉ của danh sách gửi thư.",
    'chk_js__enter_login_and_passwd' => "Nhập tên đăng nhập và mật khẩu.",
    'chk_js__enter_login_name' => "Nhập tên đăng nhập.",
    'chk_js__enter_passwd' => "Nhập mật khẩu.",

    // end of shramko part

    // serge part
    'cl_ed__edit_cl' => "Các chi tiết tài khoản của %1",
    'cl_limits__cl' => "Các giới hạn của khách hàng %1",
    'cl_logo__setup_logo_pref' => "Đặt thuộc tính biểu tượng cho khách hàng %1",
    'cl_new__enter_new_cl_data' => "Nhập thông tin về khách hàng mới",
    'cl_new__unable_to_sent_notification' => 'Tài khoản người dùng đã được tạo, tuy nhiên gửi thông báo cho khách hàng thất bại: %1',
    'cl_perm__all_ip' => "Tất cả các IP có sẵn",
    'cl_perm__all_ip_based_hst_will_be_nb' => "Tất cả các tài khoản lưu trữ dựa trên IP của khách hàng sẽ được chuyển thành dựa trên tên.",
    'cl_perm__allow_client_create_domain' => "Các khu vực mà bạn đang cố gắng để lựa chọn chỉ được áp dụng cho khách hàng được cho phép tạo ra các tên miền.",
    'cl_perm__allow_create_nb_w_ip' => "Khách hàng có thể tạo Lưu trữ dựa trên tên bằng cách sử dụng %1",
    'cl_perm__allow_creation_ip_based_hosting' => "Cho phép tạo các tài khoản lưu trữ dựa trên IP",
    'cl_perm__available_ips' => "Các IP có sẵn",
    'cl_perm__change_limits' => "Hiệu chỉnh các giới hạn",
    'cl_perm__cl_disk_space' => "Tổng số dung lượng đĩa còn trống",
    'cl_perm__cl_expiration' => "Tài khoản khách hàng trong thời gian hiệu lực",
    'cl_perm__cl_max_box' => "Hòm thư",
    'cl_perm__cl_max_db' => "Cơ sở dữ liệu",
    'cl_perm__cl_max_dom' => "Các tên miền",
    'cl_perm__cl_max_maillists' => "Các danh sách gửi thư",
    'cl_perm__cl_max_subdom' => "Tên miền phụ",
    'cl_perm__cl_max_traffic' => "Tổng lưu lượng truy cập khả dụng",
    'cl_perm__cl_max_wu' => "Người dùng Web",
    'cl_perm__cl_mbox_quota' => "Giới hạn kích thước hộp thư cho tài khoản người dùng này",
    'cl_perm__current_maximum_exp_date' => "Giá trị tối đa của thời gian hiệu lực tên miền hiện tại là %1; được yêu cầu %2.",
    'cl_perm__current_maximum_mailbox_quota' => "Các định nghĩa giới hạn về dung lượng đĩa hiện thời được phân bổ cho các hộp thư theo tài khoản người dùng này là %1; được yêu cầu %2",
    'cl_perm__current_total_requested' => "Tổng giá trị các giới hạn tên miền hiện tại cho %1 là %2; được yêu cầu %3.",
    'cl_perm__current_total_requested_dom' => "Tác vụ di chuyển hiện tạiSố lượng hiện tại của %1 thuộc khách hàng này là %2; được yêu cầu %3.",
    'cl_perm__disk_space' => "mức không gian đĩa tối đa",
    'cl_perm__dashboard_stdgui' => 'Giao diện người dùng',
    'cl_perm__dashboard' => 'Xem trang chủ',
    'cl_perm__stdgui' => 'Kiểu xem chuẩn',
    'cl_perm__manage_dashboard' => 'Quản lý trang chủ',
    'cl_perm__dashboard_and_stdgui' => 'Xem trang chủ và kiểu xem chuẩn được cho phép',
    'cl_perm__dashboard_only' => 'Chỉ cho phép xem trang chủ',
    'cl_perm__stdgui_only' => 'Chỉ cho phép kiểu xem tiêu chuẩn',
    'cl_perm__edit_cl' => "Quyền hạn của khách hàng %1",
    'cl_perm__exp_date_exceeded' => "Thời hạn hiệu lực mà bạn thiết lập vượt quá giới hạn được chỉ định cho các tên miền riêng biệt liên quan đến khách hàng này.",
    'cl_perm__invalid_value' => "Giá trị không hợp lệ, chỉ được phép dùng chữ số.",
    'cl_perm__limit_disk_space' => "%1 Giới hạn tổng không gian đĩa",
    'cl_perm__limit_expiration' => "%1 Hạn chế thời gian hiệu lực cho tài khoản khách hàng",
    'cl_perm__limit_max_box' => "%1 Giới hạn số lượng hộp thư tối đa",
    'cl_perm__limit_max_db' => "%1 Giới hạn số lượng cơ sở dữ liệu tối đa",
    'cl_perm__limit_max_dom' => "%1 Giới hạn số lượng tên miền tối đa",
    'cl_perm__limit_max_maillists' => "%1 Giới hạn số lượng danh sách gửi thư tối đa",
    'cl_perm__limit_max_subdom' => "%1 Giới hạn số lượng tên miền con tối đa",
    'cl_perm__limit_max_traffic' => "%1 Giới hạn tổng lưu lượng truy cập",
    'cl_perm__limit_max_wu' => "%1 Giới hạn số lượng người dùng web tối đa",
    'cl_perm__limit_mbox_quota' => "%1 Thiết lập giới hạn cho hộp thư",
    'cl_perm__limits_exceeded' => "Một hoặc một vài giới hạn mà bạn đang thiết lập đã vượt quá giới hạn được xác định trong các tên miền riêng biệt thuộc khách hàng này.\nTổng số giới hạn cho các khách hàng phải nhiều hơn hoặc bằng với tổng số các giới hạn tên miền được xác định cho tài khoản khách hàng này.",
    'cl_perm__mailbox_quota_exceeded' => "Giới hạn về dung lượng lưu trữ được phân bổ cho các hộp thư mà bạn đang cài đặt vượt quá giới hạn được xác định trong các tên miền riêng biệt có liên quan đến tài khoản khách hàng này.",
    'cl_perm__mailbox_quota_exceeds_server_limit' => "Giới hạn về dung lượng lưu trữ được phân bổ cho các hộp thư mà bạn đang cài đặt vượt quá giới hạn ở cấp độ máy chủ.",
    'cl_perm__make_dumps' => "Sao lưu và khôi phục dữ liệu",

    'cl_perm__max_box' => "Số lượng hộp thư tối đa",
    'cl_perm__max_db' => "Số lượng cơ sở dữ liệu tối đa",
    'cl_perm__max_dom' => "các tên miền",
    'cl_perm__max_maillists' => "Số lượng danh sách gửi thư tối đa",
    'cl_perm__max_subdom' => "tên miền phụ",
    'cl_perm__max_traffic' => "Tổng lưu lượng truy cập tối đa",
    'cl_perm__max_wu' => "Số lượng người dùng web tối đa",
    'cl_perm__max_dom_aliases' => "Các bí danh tên miền",
    'cl_perm__mbox_quota' => "hạn ngạch hòm thư",
    'cl_perm__not_allow_create_nb_hst' => "Khách hàng không thể tạo lưu trữ dựa theo tên.",
    'cl_perm__this_ip_used_vrt_hst' => "Đây là địa chỉ IP được sử dụng bởi dịch vụ lưu trữ.\nĐể xóa địa chỉ IP này, gỡ bỏ dịch vụ lưu trữ hoặc thay đổi thành loại lưu trữ dựa theo tên.",
    'cl_perm__unable_off_ipb_creating' => "Khách hàng đã thiết lập dịch vụ lưu trữ dựa trên IP. Để tắt tính năng này, bỏ đánh dấu ô \"Tạo tên miền\" hoặc gỡ bỏ tất cả các tài khoản lưu trữ dựa trên IP.",
    'cl_perm__unable_off_nb_creating' => "Khách hàng đã thiết lập dịch vụ lưu trữ dựa theo tên. Để tắt tính năng này, bỏ đánh dấu ô \"Tạo tên miền\" hoặc gỡ bỏ tất cả các tài khoản lưu trữ dựa theo tên.",
    'cl_perm__unable_set_domain_limit' => "Không thể hạn chế số lượng tên miền tối đa: khách hàng đã có %1 tên miền",
    'cl_perm__unable_update_client_limitations' => "Không thể hiệu chỉnh các giới hạn của tài khoản khách hàng: %1",
    'cl_pref__edit_cl' => "Các tùy chọn của khách hàng %1",
    'class_anonftp__create_ftp_domain' => "Không có tên miền FTP ảo cho dom_id này, đầu tiên hãy thử tạo ra nó.",
    'class_anonftp__incoming_disk_space_should_be_lower' => "Giới hạn không gian lưu trữ mà bạn đang cài đặt (%1) không nên vượt quá tổng số giới hạn không gian lưu trữ được xác định ở cấp độ tên miền (%2).",
    'class_anonftp__invalid_input_only_digits' => "Chỉ định giá trị không hợp lệ, chỉ được dùng số.",
    'class_anonftp__unable_change_ownerships' => "Không thể thay đổi quyền sở hữu hoặc quyền cho tập tin hạn ngạch: %1",
    'class_anonftp__unable_copy_quota_file' => "Không thể sao chép tập tin hạn ngạch: %1",
    'class_anonftp__unable_get_disk_usage' => "Không thể lấy thông tin dung lượng sử dụng trên thư mục: %1",
    'class_anonftp__unable_parse_quota_file' => "Không thể phân tích tập tin hạn ngạch.",
    'class_anonftp__unable_read_quota_file' => "Không thể đọc tập tin hạn ngạch: %1",
    'class_anonftp__unable_update_quota' => "Không thể cập nhật hạn ngạch: các tập tin trong thư mục đến sử dụng %1 KBs dung lượng, đã vượt quá giá trị hạn ngạch mới.",
    'class_anonftp__unable_write_temp_file' => "Không thể ghi vào tập tin tạm thời: %1",
    'class_bsdomain__warn_max_date__' => "Ngày hết hạn được thiết lập sang %1",
    'class_cList__empty' => "Không có mục nào.",
    'class_cList__header' => "%1 (%2)",
    'class_cList__not_found' => "Không có giá trị nào khớp với <b>\"%1\"</b> trong %2 (%3 của %4).",
    'class_cList__search_result' => "Kết quả tìm kiếm cho <b>\"%1\"</b> trong %2 (%3 của %4).",
    'class_client__client_creation_notification' => "Thông báo việc tạo khách hàng.",
    'class_client__client_with_contact_name_already_exists' => "Khách hàng có tên %1 đã tồn tại.",
    'class_client__disk_space' => "Không gian đĩa",
    'class_client__invalid_max_dom' => "Giá trị số lượng tên miền không hợp lệ, chỉ được phép sử dụng số.",
    'class_client__limit_exceed' => "Số lượng yêu cầu %1 không thể phân bổ được do nó vượt quá lượng phân bổ cho tài khoản của khách hàng %2 (%3). Nếu bạn muốn phân bổ nhiều tài nguyên hơn, truy cập Khách hàng > tên khách hàng > Giới hạn và thay đổi phân bổ theo yêu cầu. Sau đó trở lại màn hình này và điều chỉnh phân bổ lại lần nữa.",
    'class_client__limit_exceed_unlimited' => "Nếu bạn muốn phân bổ tài nguyên không giới hạn (%1), trước tiên bạn cần truy cập Khách hàng > tên khách hàng > Giới hạn và đánh dấu ô Không giới hạn tương ứng với loại tài nguyên theo yêu cầu. Sau đó trở lại màn hình này và điều chỉnh phân bổ lại lần nữa.",
    'class_client__max_box' => "Hòm thư",
    'class_client__max_db' => "Cơ sở dữ liệu",
    'class_client__max_maillists' => "Các danh sách gửi thư",
    'class_client__max_subdom' => "Tên miền phụ",
    'class_client__max_traffic' => "Lưu lượng truy cập tối đa",
    'class_client__max_wu' => "Người dùng Web",
    'class_client__max_dom_aliases' => "Các bí danh tên miền",
    'class_client__mbox_quota' => "Hạn ngạch hộp thư",
    'class_client__unable_define_cl_status' => "Không thể xác định trạng thái của tài khoản khách hàng: %1",
    'class_client__unable_define_inactive_dom' => "Không thể xác định các tên miền không hoạt động %1.",
    'class_client__unable_del_ip' => "Không thể gỡ bỏ các IP: %1",
    'class_db__db_name_not_set' => "Tên cơ sở dữ liệu không được chỉ định.",
    'class_db__db_not_exist_for_curr_dom' => "Cơ sở dữ liệu không tồn tại cho tên miền này.",
    'class_db__invalid_db_or_dom_name' => "ID tên miền hoặc cơ sở dữ liệu không hợp lệ hoặc tên cơ sở dữ liệu không được chỉ định.",
    'class_db__invalid_pass' => "Mật khẩu không hợp lệ.",
    'class_db__mailgrp_member_exist' => "Thành viên nhóm thư đã tồn tại.",
    'class_db__access_hosts_notsupport' => 'Việc truy cập vào dịch vụ lưu trữ không được hỗ trợ cho kiểu cơ sở dữ liệu này',
    'class_db__unable_add' => 'Không thể thêm bản ghi lưu trữ truy cập: %1',
    'class_db__unable_del' => 'Không thể xóa bản ghi lưu trữ truy cập: %1',
    'class_db__inc_user_not_exist' => 'Người dùng cơ sở dữ liệu "%1" không tồn tại',
    'class_db__inc_access_record_exist' => 'Bản ghi truy cập này đã tồn tại',
    'class_db__inc_access_record_not_exist' => 'Bản ghi truy cập được cung cấp không tồn tại',
    'class_db__inc_unable_del_last_record' => 'Không thể xóa bản ghi lưu trữ được truy cập lần cuối',
    'class_domtmpleditform__dns_master' => "Chính",
    'class_domtmpleditform__dns_slave' => "Phụ",
    'class_domtmpleditform__dns_type' => "Loại vùng DNS tên miền",
    'clienttrafficlist_header' => "Lưu lượng của các tên miền",
    'clienttrafficlist_header_of_client__' => "Lưu lượng tại tên miền thuộc khách hàng %1",
    'cmd_dns__a_dns_record_already_exist' => "Bản ghi này xung đột các bản ghi A cho phần khu vực.",
    'cmd_dns__domain_last_ns' => 'Không thể xóa bản ghi DNS NS cuối cùng cho miền.',
    'cmd_dns__canonical_dom_name_is_invalid' => "Tên miền chuẩn tắc không hợp lệ.",
    'cmd_dns__cname_dns_record_already_exist' => "Bản ghi này xung đột các bản ghi CNAME cho phần khu vực.",
    'cmd_dns__cname_in_rr_combination' => 'Sự kết hợp không chính xác của các bản ghi DNS có trong vùng DNS',
    'cmd_dns__cname_coexist_with_data' => 'Bản ghi CNAME không thể cùng tồn tại với các bản ghi DNS khác trong cùng một vùng.',
    'cmd_dns__dns_record_type_is_invalid' => "Loại bản ghi DNS không hợp lệ.",
    'cmd_dns__ext_host_is_not_resolved' => "Tên tiêu chuẩn %1 không phân giải sang bản ghi A hoặc AAAA.",
    'cmd_dns__domain_restore_dns_zone_failed_add_record' => 'Không thể thêm hồ sơ %1 vào vùng %2: %3',
    'cmd_dns__mail_dom_name_is_invalid' => "Tên Mail exchanger không hợp lệ.",
    'cmd_dns__mx_priority_is_invalid' => "Ưu tiên MX không hợp lệ.",
    'cmd_dns__name_server_is_invalid' => "Máy chủ tên miền không hợp lệ.",
    'cmd_dns__network_mask_should_be_24_16_or_8' => "Giá trị mặt nạ mạng nên là 24, 16 hay 8.",
    'cmd_dns__this_dns_record_already_exists' => "Bản ghi DNS đã tồn tại.",
    'cmd_dns__unable_add_record' => "Không thể thêm bản ghi '%1': %2",
    'cmd_dns__unable_add_a_record' => "Không thể thêm bản ghi A: %1",
    'cmd_dns__unable_add_cname_record' => "Không thể thêm bản ghi CNAME: %1",
    'cmd_dns__unable_add_dns_record' => "Không thể thêm bản ghi DNS: %1.",
    'cmd_dns__unable_add_ext_ns_record' => "Không thể thêm bản ghi EXT_NS: %1",
    'cmd_dns__unable_add_ns_record' => "Không thể thêm bản ghi NS: %1",
    'cmd_dns__unable_add_ptr_record' => "Không thể thêm bản ghi PTR: %1",
    'cmd_dns__unable_add_txt_record' => "Không thể thêm bản ghi TXT: %1",
    'cmd_dns__unable_create_dns_zone' => "Không thể tạo vùng DNS %1",
    'cmd_dns__unable_define_dns_record' => "Không thể xác định các bản ghi DNS %1.",
    'cmd_dns__unable_get_default_dns_zone_status_set_true' => "Không thể lấy lại trạng thái vùng DNS mặc định: %1",
    'cmd_dns__unable_insert_a_record' => "Không thể chèn bản ghi A: %1",
    'cmd_dns__unable_insert_mx_record' => "Không thể chèn bản ghi MX: %1",
    'cmd_dns__unable_insert_ns_record' => "Không thể chèn bản ghi NS: %1",
    'cmd_dns__unable_set_dns_zone_status' => "Không thể thiết lập trạng thái vùng DNS: %1",
    'cmd_domains__dom_already_exists' => "Tên miền %1 đã tồn tại.",
    'cmd_domains__dns_record_already_exists' => "Không thể tạo các tên miền %1 bởi vì một bản ghi DNS trỏ đến máy chủ %1 đã tồn tại.",
    'cmd_domains__dom_already_exists1' => "Hiện có %2 tên miền con thuộc tên miền này. Tên miền %1 đã tồn tại.",
    'cmd_domains__dom_already_exists2' => "tên miền con %1 đã tồn tại.",
    'cmd_domains__dalias_already_exists' => "Bí danh này đã tồn tại.",
    'cmd_domains__domain_alias_already_exists' => 'Bí danh miền có tên này đã tồn tại.',
    'cmd_domains__unable_del_mail_for_dom' => "Không thể xóa các dịch vụ thư của tên miền: %1",
    'cmd_domains__unable_delete_anonymous_ftp' => "Không thể xóa tài khoản FTP ẩn danh của tên miền: %1",
    'cmd_domains__unable_update_dom_param' => "Không thể cập nhật các thông số tên miền: %1.",
    'cmd_domains__unable_rename_client_exist' => "Tên người dùng của quản trị miền đã được sử dụng.",
    'cmd_hosting__hst_type_is_not_physical_hst' => "Kiểu lưu trữ không phải là vật lý.",
    'cmd_hosting__unable_create_user' => "Không thể tạo người dùng %2: %1",
    'cmd_hosting__unable_define_ip_addr_for_name_based_virtual_hosts' => "Không thể xác định địa chỉ IP cho các lưu trữ ảo dựa theo tên: %1",
    'cmd_hosting__unable_del_old_hst' => "Không thể xóa các lưu trữ được thiết lập trước đó: %1",
    'cmd_hosting__unable_del_protected_directory' => "Không thể xóa thư mục được bảo vệ: %1.",
    'cmd_hosting__unable_del_web_user' => "Không thể xóa người dùng web: %1",
    'cmd_hosting__unable_make/update_virtual_host' => "Không thể tạo hoặc cập nhật lưu trữ ảo: %1",
    'cmd_hosting__unable_make_frame_forward_hst' => "Không thể thiết lập lưu trữ dạng chuyển tiếp khung.",
    'cmd_hosting__unable_rebuild_ftp_config' => "Không thể xây dựng lại các tập tin cấu hình proftpd: %1.",
    'cmd_hosting__unable_set_up_ssl' => "Không thể cài đặt SSL/TLS: %1.",
    'cmd_hosting__unable_unprotect_ssl_directory' => "Không thể gỡ bỏ bảo vệ từ thư mục SSL/TLS: %1",
    'cmd_hosting__unable_update_dest_url' => "Không thể cập nhật các URL đích %1.",
    'cmd_hosting__unable_update_dns_zone_for_dom_unable_exec_util' => "Không thể cập nhật vùng DNS cho tên miền: thực hiện tiện ích không thành công.",
    'cmd_hosting__unable_update_ftp_passwd' => "Không thể cập nhật mật khẩu FTP %1.",
    'cmd_hosting__unable_update_user' => "Không thể cập nhật người dùng %2: %1",
    'cmd_hosting__unknown_hst_type' => "Kiểu lưu trữ không xác định.",
    'cmd_hosting__you_not_have_permission_del_hst' => "Bạn không có quyền chấm dứt dịch vụ lưu trữ.",
    'cmd_mail__autoresponder__not_configured' => "Trả lời tự động cho tài khoản thư này chưa được cấu hình",
    'cmd_mail__addr_already_used_in_mail_redirect' => "Địa chỉ %1 đã được sử dụng để chuyển hướng thư.",
    'cmd_mail__alias_already_exists' => "Bí danh đã tồn tại.",
    'cmd_mail__autoresp_id_and_mailname_id_not_match' => "ID trả lời tự động và ID tài khoản thư không khớp.",
    'cmd_mail__autoresp_id_is_undefined' => "ID trả lời tự động không được xác định.",
    'cmd_mail__mail_alias_already_exists_in_mail_name' => "Bí danh thư có tên này đã tồn tại cho tài khoản thư %1.",
    'cmd_mail__mail_name_already_exists_in_maillists' => "Tài khoản thư %1 đã được đăng ký trong danh sách gửi thư này.",
    'cmd_mail__mail_name_alredy_exist_in_dom' => "Tài khoản thư %1 đã tồn tại trong miền này.",
    'cmd_mail__mail_name_not_exist' => "Tài khoản thư không tồn tại.",
    'cmd_mail__mail_name_passwd_part' => "Mật khẩu không nên chứa tên tài khoản thư.",
    'cmd_mail__maillist_already_exist_in_this_dom' => "Danh sách gửi thư %1 đã có trên tên miền này.",
    'cmd_mail__mailname_already_exist_in_mg' => "Tài khoản thư %1 đã tồn tại trong một nhóm thư.",
    'cmd_mail__mailname_already_exist_in_this_dom' => "Tài khoản thư %1 đã tồn tại trong miền này.",
    'cmd_mail__mailname_already_exists' => "Tài khoản thư đã tồn tại.",
    'cmd_mail__mailname_is_invalid' => "Tên tài khoản thư %1 không hợp lệ.",
    'cmd_mail__mailname_unable_update' => "Không thể cập nhật các thuộc tính của tài khoản thư:",
    'cmd_mail__max_autoresp_reached_for_this_dom' => "Đã đạt đến số lượng trả lời tự động tối đa cho tên miền này.",
    'cmd_mail__max_mail_groups_num_has_been_reached_for_this_dom' => "Đã đạt đến số lượng nhóm thư tối đa cho tên miền này.",
    'cmd_mail__max_num_of_redirects_has_been_reached_for_this_dom' => "Đã đạt đến số bộ chuyển tiếp tối đa đối với tên miền này.",
    'cmd_mail__max_postboxes_num_has_been_reached' => "Đã đạt đến số lượng hộp thư tối đa.",
    'cmd_mail__no_members_specified' => "không có thành viên nào được chỉ định.",
    'cmd_mail__the_passwd_is_too_simple_choose_another' => "Mật khẩu quá đơn giản, hãy chọn một mật khẩu khác.",
    'cmd_mail__this_addr_already_exist_in_mg_or_mn' => "Địa chỉ email này đã được sử dụng.",
    'cmd_mail__unable_define_autoresp_id' => "Không thể xác định ID trả lời tự động %1.",
    'cmd_mail__unable_update_mail_for_dom' => "Không thể thay đổi các thiết lập dịch vụ thư cho tên miền %1",
    'cmd_mail__unable_del_mail_for_dom' => "Không thể gỡ bỏ dịch vụ thư khỏi tên miền %1.",
    'cmd_mail__unable_del_mail_redirection' => "Không thể gỡ bỏ dịch vụ chuyển tiếp thư %1.",
    'cmd_mail__unable_remove_autoresp' => "Không thể gỡ bỏ trả lời tự động: %1",
    'cmd_mail__unable_remove_mail_group_members' => "Không thể gỡ bỏ các thành viên khỏi nhóm thư: %1",
    'cmd_mail__unable_turn_off_mail_group' => "Không thể tắt nhóm thư: %1",
    'cmd_mail__unable_update_mail_redirect' => "Không thể cấu hình lại dịch vụ chuyển tiếp thư %1.",
    'cmd_mail__uploaded_file_is_too_big' => "Kích thước tập tin được tải lên quá lớn.",
    'cmd_mail__additionally' => "Ngoài ra:",
    'cmd_pd__invalid_login' => "Tên người dùng không đúng.",
    'cmd_pd__this_user_already_exist' => "Người dùng đã tồn tại.",
    'cmd_pd__unable_define_hst_type' => "Không thể xác định kiểu lưu trữ.",
    'cmd_pd__unable_upd_pd_usr' => "Không thể cập nhật các thuộc tính của tài khoản người dùng thuộc chức năng bảo vệ thư mục: %1.",
    'cmd_pd__user_is_undefined' => "Người dùng không được xác định.",
    'cmd_server__no_enough_free_disk_space' => "Không đủ dung lượng đĩa.",
    'cmd_server__old_passwd_is_incorrect_please_try_again' => "Mật khẩu cũ không chính xác. Hãy thử lại.",
    'cmd_web_usr__max_web_users_reached_for_this_dom' => "Đã đạt đến số lượng người dùng web tối đa.",
    'cmd_web_usr__unable_create_user' => "Không thể tạo người dùng hệ thống: %1",
    'cmd_web_usr__unable_define_max_web_users_limit' => "Không thể xác định giới hạn số lượng người dùng web tối đa: %1",
    'cmd_web_usr__user_already_exists' => "Người dùng đã tồn tại.",
    'cmd_web_usr__web_user_name_is_invalid' => "Tên người dùng web %1 không hợp lệ.",
    'cmd_web_usr__web_user_not_exist' => "Người dùng web không tồn tại.",
    'common_func__exec_bad_argument' => "tham số thực thi không nên chứa biểu tượng dấu nháy đơn.",
    '__eol' => 'Ngắt dòng',
    'eol__binary_file' => 'Không thể thay đổi kiểu ngắt dòng trong tập tin nhị phân.',
    'cp_access_admin_deny' => "Việc truy cập dưới quyền quản trị từ địa chỉ '%1' là bị giới hạn theo chính sách hạn chế IP truy cập hiện đang áp dụng.",
    'create_domain_warn__' => "Dưới đây là những trường hợp ngoại lệ được thực hiện trong quá trình tạo tên miền:",
    'create_domain__client_select' => 'Chọn khách hàng để tạo tên miền',

    'dashboard__nav_button_name' => "Trang chủ",
    'dalias__list_title' => 'Các bí danh tên miền của tên miền %1',
    'dalias__list_legend' => 'Các bí danh tên miền',
    'dalias__list_header' => 'Các bí danh tên miền',
    'dalias__list_status' => 'S',
    'dalias__list_name' => 'Tên bí danh tên miền',
    'dalias__list_ascii_name' => 'Trong định dạng ASCII',
    'dalias__remove_title' => 'Dưới đây là những bí danh của tên miền %1 sẽ được gỡ bỏ:',
    'dalias__select_domain_aliases_to_remove' => 'Chọn các bí danh tên miền để được gỡ bỏ.',
    'dalias__mail_turn_on_failed' => 'Không thể bật dịch vụ thư: %1',
    'dalias__web_turn_on_failed' => 'Không thể bật dịch vụ web: %1',
    'db_usr_edit__db_usr_name_old' => "Tên người dùng cơ sở dữ liệu cũ",
    'database_server_edit_form__cannot_infer_type' => 'Không thể suy luận phương thức kết nối từ dữ liệu được cung cấp. Chỉ định "127.0.0.1" làm tên máy chủ cơ sở dữ liệu để kết nối qua TCP/IP với cổng được cung cấp hoặc để trống trường cổng để sử dụng cổng Unix "%1".',
    'database_server_edit_form__duplicate' => 'Một máy chủ cơ sở dữ liệu với sự kết hợp của địa chỉ và số cổng này đã được đăng ký.',
    'database_server_edit_form__host_is_invalid' => 'Tên máy chủ được chỉ định không hợp lệ.',
    'database_server_edit_form__port_is_invalid' => 'Số cổng được chỉ định không hợp lệ.',
    'database_server_error__consult_admin' => 'Hãy liên lạc với quản trị viên.',
    'database_server_error__last__connection_failed' => 'Việc quản lý máy chủ cơ sở dữ liệu không thành công vì các vấn đề về mạng.',
    'database_server_error__last__permission_denied' => 'Việc quản lý máy chủ cơ sở dữ liệu không thành công vì tài khoản được cung cấp không có quyền quản trị.',
    'database_server_error__last__credentials_not_set' => "Không thể kết nối thành công với máy chủ này do tên người dùng và mật khẩu của quản trị viên không hợp lệ.",
    'database_server_error__last__other_error' => 'Việc quản lý máy chủ cơ sở dữ liệu này không thành công.',
    'database_server_error__real__connection_failed' => 'Kết nối đến máy chủ cơ sở dữ liệu đã thất bại vì các vấn đề về mạng:',
    'database_server_error__real__permission_denied' => 'Kết nối đến máy chủ cơ sở dữ liệu đã thất bại vì tài khoản được cung cấp không có quyền quản trị:',
    'database_server_error__real__duplicate_object' => 'Kết nối đến máy chủ cơ sở dữ liệu đã thất bại vì xung đột tên:',
    'database_server_error__real__unacceptable_name' => 'Kết nối đến máy chủ cơ sở dữ liệu đã thất bại vì tên đối tượng không hợp lệ:',
    'database_server_error__real__unacceptable_password' => 'Kết nối đến máy chủ cơ sở dữ liệu đã thất bại vì mật khẩu không được chấp nhận:',
    'database_server_error__real__credentials_not_set' => "Plesk không thể kết nối với máy chủ cơ sở dữ liệu do tên người dùng và mật khẩu của quản trị viên không hợp lệ.",
    'database_server_error__real__other_error' => 'Kết nối đến máy chủ cơ sở dữ liệu thất bại:',
    'database_server_error__test__connection_failed' => 'Kết nối thử đến máy chủ cơ sở dữ liệu thất bại do các vấn đề về mạng:',
    'database_server_error__test__permission_denied' => 'Không thể kết nối thử đến máy chủ cơ sở dữ liệu do tài khoản được cung cấp không có quyền ưu tiên quản trị:',
    'database_server_error__test__duplicate_object' => 'Không thể kết nối thử đến máy chủ cơ sở dữ liệu do xung đột tên:',
    'database_server_error__test__unacceptable_name' => 'Không thể kết nối thử đến máy chủ cơ sở dữ liệu do tên đối tượng không hợp lệ:',
    'database_server_error__test__unacceptable_password' => 'Không thể kết nối thử đến máy chủ cơ sở dữ liệu do mật khẩu không được chấp nhận:',
    'database_server_error__test__credentials_not_set' => "Không thể kết nối thử với máy chủ này do tên người dùng và mật khẩu của quản trị viên không hợp lệ.",
    'database_server_error__test__other_error' => 'Kiểm tra kết nối thử đến máy chủ cơ sở dữ liệu thất bại:',

    'db__create_new_db' => "Thêm cơ sở dữ liệu",
    'db__db_add' => "Thêm cơ sở dữ liệu",
    'db__db_for_dom' => "Cơ sở dữ liệu cho trang web %1",
    'db__db_id_undefined' => "ID Cơ sở dữ liệu không được xác định.",
    'db__db_name' => "Tên cơ sở dữ liệu",
    'db__db_not_exist' => "Cơ sở dữ liệu không tồn tại.",
    'db__db_type' => "Kiểu",
    'db__db_server' => "Máy chủ cơ sở dữ liệu",
    'db_server_not_exist' => "Máy chủ cơ sở dữ liệu không tồn tại.",
    'db__db_user_not_exist' => "Người dùng cơ sở dữ liệu không tồn tại.",
    'db__domain_not_exist' => "Tên miền không tồn tại.",
    'db__enter_db_name' => "Nhập tên cơ sở dữ liệu mới.",
    'db__invalid_db_id' => "Xác định cơ sở dữ liệu không hợp lệ.",
    'db__invalid_db_name' => "Tên cơ sở dữ liệu không hợp lệ. Tên cơ sở dữ liệu chỉ nên chứa các ký tự chữ cái Latinh, chữ số, dấu gạch dưới hoặc dấu gạch ngang. Nó không thể được dài hơn 63 ký tự.",
    'db__max_db_reached_for_dom' => "Đã đạt đến giới hạn số lượng cơ sở dữ liệu tối đa.",
    'db__max_mssql_db_reached_for_dom' => "Cơ sở dữ liệu Máy chủ Microsoft SQL đã đạt giới hạn cho phép trong miền này",
    'db__postgres_not_connect_for_admin' => "Không thể kết nối đến PostgreSQL. Bật hỗ trợ PostgreSQL trên trang quản lý máy chủ.",
    'db__postgres_not_connect_for_client' => "Không thể kết nối đến PostgreSQL. Liên hệ quản trị hệ thống để được giúp đỡ.",
    'db__remove_db_on_domain' => "Cơ sở dữ liệu sau đây trong website %2 thuộc sở hữu của khách hàng %1 sẽ bị gỡ bỏ:",
    'db__remove_db_on_domain_of_cl' => "Cơ sở dữ liệu sau đây cho miền %2 thuộc sở hữu của khách hàng %1 sẽ bị gỡ bỏ:",
    'db__remove_db_linked_resource' => 'Cơ sở dữ liệu này đang sử dụng bởi một ứng dụng web. Nó chỉ có thể được gỡ bỏ sau khi gỡ ứng dụng web này.',
    'db__remove_db_users' => "Người dùng cơ sở dữ liệu %3 sau đây trong website %2 thuộc sở hữu của khách hàng %1 sẽ bị gỡ bỏ:",
    'db__remove_db_users_of_cl' => "Người dùng cơ sở dữ liệu %3 sau đây trong website %2 thuộc sở hữu của khách hàng %1 sẽ bị gỡ bỏ:",
    'db__select_db_for_remove' => "Chọn cơ sở dữ liệu sẽ được gỡ bỏ.",
    'db__select_db_users_for_remove' => "Chọn những người dùng cơ sở dữ liệu sẽ bị gỡ bỏ.",
    'db__unable_create_db_user' => "Không thể tạo người dùng cơ sở dữ liệu: %1",
    'db__unable_define_db_name' => "Không thể xác định tên cơ sở dữ liệu: %1",
    'db__unable_define_db_user' => "Không thể xác định người dùng cơ sở dữ liệu: %1",
    'db__unable_define_db_users' => "Không thể xác định người dùng cơ sở dữ liệu: %1",
    'db__unable_select_dom_name' => "Không thể chọn tên miền: %1",
    'db_edit__db_for_dom' => "Người dùng cơ sở dữ liệu %1 trên tên miền %2",
    'db_edit__invalid_db_name' => "Tên cơ sở dữ liệu không hợp lệ.",
    'db_edit__no_users' => "Không có người dùng nào với thông tin đăng nhập thuộc cơ sở dữ liệu này.",
    'db_edit__unable_define_db_usrs' => "Không thể xác định những người dùng cơ sở dữ liệu: %1",
    'db_edit__unable_select_db_usr' => "Không thể chọn người dùng cơ sở dữ liệu.",
    'db_edit__db_user_password_for_' => "Hãy nhập mật khẩu để đăng nhập với vai trò người dùng cơ sở dữ liệu %1",
    'db_list__tab_title_db_type' => "T",
    'db_usr_edit__add_db_usr' => "Thêm người dùng cơ sở dữ liệu",
    'db_usr_edit__db_usr_name' => "Tên tài khoản người dùng cơ sở dữ liệu",
    'db_usr_edit__edit_db_usr' => "Thiết lập thông tin đăng nhập cho tài khoản người dùng cơ sở dữ liệu",
    'db_usr_edit__for_db' => "trong %1 cơ sở dữ liệu",
    'db_usr_edit__not_create_pass' => "Thao tác này sẽ tạo một tài khoản người dùng cơ sở dữ liệu mà không cần mật khẩu.\nBạn có muốn tạo một người dùng mà không cần gán một mật khẩu?",
    'dbuser__only_one_user_can_be_default' => "Chỉ có một người dùng có thể được đặt làm mặc định.",
    'db_server__cannot_delete_default' => "Máy chủ cơ sở dữ liệu mặc định không thể bị xóa.",
    'db_server__cannot_delete_local' => "Máy chủ cơ sở dữ liệu cục bộ không thể bị xóa.",
    'db_server__cannot_delete_used' => 'Không thể xóa máy chủ cơ sở dữ liệu trong khi có những cơ sở dữ liệu hoặc người sử dụng cơ sở dữ liệu được lưu trữ trên đó.',
    'demo__disabled_in_demo' => "Thao tác này không được hỗ trợ trong phiên bản dùng thử.",
    'defaultcomponents__title' => "Lựa chọn Thành phần Mặc định",
    'defaultcomponents__select_default' => "Chọn thành phần mặc định %1",//to check
    'defaultcomponents__not_installed' => "(không được cài đặt)",
    'defaultcomponents__not_configured' => "(không được cấu hình)", // to check
    'defaultcomponents__not_opted_to_install_support_files' => "Một số loại dịch vụ có chứa các lựa chọn không hợp lệ, hoặc không có lựa chọn.",
    'defaultcomponents__depends_on' => "(yêu cầu %1)",
    'defaultcomponents__parameters' => "Các thông số của %1",
    'component_name__antivirus' => "Chống virus",
    'component_name__database' => "Máy chủ SQL",
    'component_name__sqladmin' => "Quản trị Web MySQL",
    'component_name__sqladminmysql' => "Quản trị Web MySQL",
    'component_name__dnsserver' => "Máy chủ DNS",
    'component_name__firewall' => "Tường lửa",
    'component_name__ftpserver' => "Máy chủ FTP",
    'component_name__java' => "Java",
    'component_name__mailserver' => "Máy chủ thư",
    'component_name__local_mailserver' => "Máy Chủ Thư Cục Bộ",
    'component_name__psa' => "Plesk",
    'component_name__script' => "Mã Web",
    'component_name__spamfilter' => "Bộ lọc thư rác",
    'component_name__stats' => "Thống kê Web",
    'component_name__stunnel' => "Trình bọc SSL/TLS",
    'component_name__webmail' => "Trình Quản lý thư trực tuyến",
    'component_name__webpublish' => "Xuất bản Web",
    'component_name__webserver' => "Máy chủ web",
    'dns__dns_record_invalid_values' => 'Các giá trị bản ghi DNS không chính xác được chỉ định: %1: %2',
    'dns__dns_record_not_found' => 'Không tìm thấy bản ghi DNS',
    'dns__dns_zone_invalid_values' => 'Các tham số vùng DNS không chính xác được chỉ định.',

    'dns__soa_mname_title' => 'Máy chủ tên miền chính',
    'dns__soa_mname_legend' => 'Máy chủ tên miền',
    'dns__soa_mname_autoselect' => '(Tự động chọn)',

    'dns__dns_zone_off_remove_title' => "Những bản ghi tài nguyên sau sẽ được gỡ bỏ khỏi vùng %1:",
    'dns__dns_zone_master_remove_title' => "Những bản ghi tài nguyên sau thuộc vùng DNS %1",
    'dns__dns_zone_slave_remove_title' => "Những bản ghi máy chủ tên chính cho %1 sẽ được gỡ bỏ:",
    'dns_add__param_ttl' => "TTL",
    'dns_add__enter_spf' => 'Nhập chuỗi bản ghi',
    'dns_add__is_spf_syntax' => 'Bản ghi SPF',
    'dns_add__spf_value_is_invalid' => "Giá trị của bản ghi SPF không đúng, giá trị bắt đầu bằng 'v=spf'",
    'dns__dns_zone_status' => "Trạng thái vùng DNS.",
    'dns__invalid_ip_address' => "Địa chỉ IP của máy chủ DNS chính mới không hợp lệ hoặc trống.",
    'dns__ip_address' => "Địa chỉ IP",
    'dns__master_dns_type' => "là một máy chủ DNS chính",
    'dns__masters' => "máy chủ DNS chính",
    'dns__soa_minimum_too_large' => 'Việc lưu tạm các phản hồi vô hiệu trong hơn ba giờ không được khuyến cáo.',
    'dns__select_masters_to_remove' => "Chọn các máy chủ DNS chính sẽ được gỡ bỏ.",
    'dns__select_template_record_to_remove' => 'Chọn các bản ghi mẫu DNS sẽ được gỡ bỏ.',
    'dns__nameservers_for_domain' => "Máy chủ tên miền cho tên miền",
    'dns__remove_dns_zone_of_domain__' => "Gỡ bỏ các bản ghi DNS từ tên miền %1",
    'dns__remove_dns_zone_template__' => "Những bản ghi DNS sau sẽ bị gỡ bỏ khỏi mẫu:",
    'dns__remove_this_dns_record?' => "Bạn có chắc chắn muốn gỡ bản ghi DNS này?",
    'dns__restore_default' => "Khôi phục lại vùng DNS theo mẫu",
    'dns__restore_default_confirm' => "Việc khôi phục lại vùng DNS sẽ huỷ các cấu hình vùng DNS hiện tại. Tiếp Tục không?",
    'dns__restore_default_error' => "Lỗi khôi phục vùng DNS:",
    'dns__slave_dns_type' => "là một máy chủ DNS thứ cấp",
    'dns__subdomain_dns_rec_removed' => "Bản ghi A đã được gỡ bỏ khỏi vùng của tên miền con %1.",
    'dns__zone_switched_off_no_ns' => "Vùng đã bị tắt do không tồn tại bản ghi NS %1, là bản phải có trong vùng. Để thêm các bản ghi, hãy nhấn nút Thêm Bản ghi.",
    'dns__cant_switch_on_no_ns' => "Vùng không thể được bật lên do không tồn tại bản ghi NS %1. Để thêm các bản ghi, hãy nhấn nút Thêm Bản ghi.",
    'dns__unable_activate/deactivate_dns' => "Không thể kích hoạt/vô hiệu hóa DNS: %1",
    'dns__unable_add_dns_master_duplicate_entry' => "Không thể thêm máy chủ DNS chính: nhập trùng lặp.",
    'dns__unable_add_dns_master_local_ip' => "Không thể thêm địa chỉ IP cho máy chủ DNS chính: bản ghi này nên được tạo trên một máy chủ từ xa.",
    'dns__unable_define_dns_record' => "Không thể xác định bản ghi DNS: %1",
    'dns__unable_get_dns_template_status' => "Không thể lấy trạng thái mẫu DNS.",
    'dns__unable_remove_dns_rec' => "Không thể gỡ bỏ bản ghi DNS: %1",
    'dns__warnings__' => "Kết quả của việc hiệu chỉnh vùng DNS:",
    'dns__you_not_have_perm_manage_dns' => "Bạn không được phép quản lý vùng DNS cho tên miền này.",
    'dns__cant_create_record_with_server_ip' => "Không thể thêm địa chỉ IP này vì nó khớp với địa chỉ IP của máy chủ do Plesk quản lý.",

    'dns__tabs_acl' => "Chuyển vùng",
    'dns__acl_add_network_legend' => "Thêm mạng",
    'dns__acl_add_ip_legend' => "Bổ sung địa chỉ IP",
    'dns__acl_network_not_allowed' => "Địa chỉ mạng này không được DNS cho phép trong Windows.",
    'dns__acl_enter_ip_address_with_mask' => "Địa chỉ IP/mặt nạ",
    'dns__acl_enter_ip_address' => "Địa chỉ IP",
    'dns__acl_list_network_legend' => "Các mạng được cho phép lấy một bản sao vùng DNS",
    'dns__acl_list_ip_legend' => "Danh sách các địa chỉ IP cho phép lấy một bản sao vùng DNS",
    'bt_dns_acl_add_network' => "Thêm mạng",
    'bt_dns_acl_add_ip' => "Bổ sung địa chỉ IP",

    'dns_add__add_rec_for_zone' => "Thêm %1 cho vùng %2",
    'dns_add__canonical_dom_name_is_invalid' => "Tên miền chuẩn tắc không hợp lệ.",
    'dns_add__enter_canonical_name' => "Tên miền chuẩn tắc",
    'dns_add__enter_dom_name' => "Tên miền",
    'dns_add__enter_ip_address' => "Địa chỉ IP",
    'dns_add__enter_ip_mask' => "Nhập địa chỉ IP và mặt nạ mạng",
    'dns_add__enter_mail_domain' => "Tên miền thư",
    'dns_add__enter_mail_exchanger' => "Máy chủ trao đổi thư",
    'dns_add__enter_nameserver' => "Máy chủ tên miền",
    'dns_add__enter_txt_record' => "Bản ghi TXT",
    'dns_add__enter_service_name' => "Tên dịch vụ",
    'dns_add__hint_service_name' => "Ví dụ: SIP (không có biểu tượng gạch chân)",
    'dns_add__enter_protocol' => "Giao thức",
    'dns_add__hint_protocol_name' => "Ví dụ: TCP (không có biểu tượng gạch chân)",
    'dns_add__protocol_tcp' => "TCP",
    'dns_add__protocol_udp' => "UDP",
    'dns_add__enter_srv_priority' => "Ưu tiên",
    'dns_add__specify_weight_of_service' => "Trọng số tương đối của các bản ghi có cùng mức ưu tiên",
    'dns_add__enter_target_host' => "Máy chủ đích",
    'dns_add__hint_target_host' => "Ví dụ: example.com",
    'dns_add__enter_target_port' => "Cổng đích",
    'dns_add__caa_tag' => "Thẻ",
    'dns_add__caa_value' => "Giá trị",
    'dns_add-invalid-A_ip' => "Địa chỉ IP không hợp lệ.",
    'dns_add-invalid-AAAA_ip' => "Địa chỉ IP không hợp lệ.",
    'dns_add-invalid-PTR_ip_mask' => "Cặp địa chỉ IP/mặt nạ mạng không hợp lệ.",
    'dns_add-invalid-SRV_service_name' => "Tên dịch vụ không hợp lệ",
    'dns_add-invalid-SRV_protocol_name' => "Giao thức không hợp lệ",
    'dns_add-invalid-SRV_target_port' => "Cổng mục tiêu không hợp lệ",

    'dns_add__invalid_ip' => "Địa chỉ IP không hợp lệ.",
    'dns_add__low' => "thấp",
    'dns_add__mail_dom_name_is_invalid' => "Tên miền của thư không hợp lệ.",
    'dns_add__nameserver_is_invalid' => "Máy chủ tên miền không hợp lệ.",
    'dns_add__record' => "%1 bản ghi",
    'dns_add__select_prefer_for_mail_exchange_server' => "Xác định độ ưu tiên của máy chủ mail exchange",
    'dns_add__unable_insert_new_dns_rec' => "Không thể chèn thêm bản ghi DNS mới: %1",
    'dns_add__very_high' => "rất cao",
    'dom_ctrl__allowed' => "Được cho phép",
    'dom_ctrl__db' => "CSDL MySQL",
    'dom_ctrl__mssql_db' => "Cơ sở dữ liệu MS SQL",
    'dom_ctrl__disk_space' => "Không gian đĩa",
    'dom_ctrl__dom_adm' => "Tên miền %1 của %2",
    'dom_ctrl__dom_cl' => "Tên miền %1",
    'dom_ctrl__domain_has_forwarding_with_undefined_fwd_url' => "Tên miền có thiết lập chuyển tiếp với địa chỉ URL không xác định",
    'dom_ctrl__domain_has_frame_forwarding' => "Tên miền đã cấu hình chuyển tiếp dạng khung tới URL %1",
    'dom_ctrl__domain_has_no_hosting' => "Tên miền này không được cấu hình lưu trữ",
    'dom_ctrl__domain_has_physical_hosting' => "Lưu trữ web được cấu hình cho miền này trên địa chỉ IP %1",
    'dom_ctrl__domain_has_standard_forwarding' => "Tên miền đã cấu hình chuyển tiếp dạng chuẩn tới URL %1",
    'dom_ctrl__maillists' => "Các danh sách gửi thư",
    'dom_ctrl__mboxes' => "Hòm thư",
    'dom_ctrl__mg' => "Chuyển tiếp thư",
    'dom_ctrl__resource_name' => "Nguồn",
    'dom_ctrl__resp' => "Trả lời tự động",
    'dom_ctrl__subdom' => "Tên miền phụ",
    'dom_ctrl__dom_aliases' => "Các bí danh tên miền",
    'dom_ctrl__traffic' => "Lưu lượng",
    'dom_ctrl__unable_activate/deactivate_dom' => "Không thể kích hoạt/vô hiệu hóa tên miền: %1",
    'dom_ctrl__used' => "Đã sử dụng",
    // end of serge part

    // maverick part
    'dom_ctrl__wu' => "Người dùng Web",
    'dom_pref__bounce_with_phrase' => "Trả về bằng thông báo",
    'dom_pref__bounce' => "Trả về",
    'dom_pref__catch_addr' => "Chuyển tiếp đến địa chỉ",
    'dom_pref__reject' => 'Từ chối',
    'dom_pref__confirm_domain_removing' => "Đừng quên thông báo cho khách truy cập về việc thay đổi tên của miền. Bạn có chắc là muốn đổi tên của miền?",
    'dom_pref__db_inconsystency' => "cơ sở dữ liệu không nhất quán.",
    'dom_pref__dbs' => "cơ sở dữ liệu",
    'dom_pref__delete_traffic_stat' => "Giữ số liệu thống kê lưu lượng và web",
    'dom_pref__delete_traffic_stat_older' => "Giữ số liệu thống kê lưu lượng và web",
    'dom_pref__dom_level_name_conflict' => "Tên người dùng của quản trị miền mâu thuẫn với tên người dùng của một trong số khách hàng.",
    'dom_pref__invalid_disk_space_limit' => "Giới hạn dung lượng lưu trữ không hợp lệ. Giá trị tối đa: %1",
    'dom_pref__invalid_expiration_date_limit' => "Thời gian hiệu lực không hợp lệ.",
    'dom_pref__invalid_max_traffic_limit' => "Giới hạn lưu lượng truy cập không hợp lệ. Giá trị tối đa: %1",
    'dom_pref__limits_of_dom' => "Giới hạn cho tên miền %1",
    'dom_pref__mail_grps' => "các nhóm thư",
    'dom_pref__mail_nonexistent_user' => "Cần thực hiện các thao tác sau với thư gửi đến người dùng không tồn tại",
    'dom_pref__mail_redirs' => "chuyển tiếp thư",
    'dom_pref__mail_resps' => "trả lời tự động thư",
    'dom_pref__max_limit_is_invalid' => "%1 không hợp lệ.",
    'dom_pref__max_num_of_%objects_is_invalid' => "Số lượng tối đa của %1 không hợp lệ.",
    'dom_pref__new_limit_less_currently_used' => "%1: được yêu cầu - %2, hiện đang được sử dụng - %3",
    'dom_pref__older_that' => "cho",
    'dom_pref__postboxes' => "hòm thư",
    'dom_pref__preferences_of_dom' => "Thiết lập cho tên miền %1",
    'dom_pref__redirect_to_itself' => "Các tên miền sẽ cấu hình chuyển tiếp tới chính nó",
    'dom_pref__traffic_logging_period_couldnt_be_lower' => "Bạn chỉ định thời gian duy trì số liệu thống kê lưu lượng truy cập tên miền ít hơn tổng giá trị được định nghĩa cho máy chủ (%1 tháng). Các số liệu thống kê duy trì trong thời gian được thiết lập bằng với giá trị mặc định cho máy chủ (%1 tháng).",
    'dom_pref__unable_add_www_prefix_in_dom' => "Không thể thêm tiền tố www vào tên miền: %1",
    'dom_pref__unable_define_physical_hst_param' => "Không thể xác định các tham số lưu trữ vật lý: %1",
    'dom_pref__unable_rename_domain' => "Không thể đổi tên của miền %1: %2",
    'dom_pref__unable_set_up_mbox_quota' => "Không thể đặt các giới hạn hộp thư cho tên miền này: %1",
    'dom_pref__unable_set_up_web_user_script' => "Không thể thiết lập mã kịch bản cho người dùng Web: %1",
    'dom_pref__unlimited' => "Không giới hạn",
    'dom_pref__web_usrs' => "người dùng web",
    'dom_pref__you_already_have_%object' => "Bạn đã có %1",
    'cu_domain__error_unable_update_ftp_users' => 'Cập nhật các người dùng FTP miền không thành công: %1',
    'dom_cli__warning_ignore_quota' => 'CẢNH BÁO: Tùy chọn "-hard_quota" được bỏ qua: hạn ngạch đĩa cứng không được hỗ trợ',
    'dom_user_client_login_exist' => "Không thể cho phép quản trị miền truy cập vào Plesk trên miền %1: tên người dùng này được sử dụng.",
    'domain__unable_to_turn_on_service' => "Lỗi khi bật dịch vụ %1.",
    'domains__change_the_status_of_domain?' => "Bạn có chắc chắn rằng bạn muốn thay đổi trạng thái của tên miền %1?",
    'domains__client_info_hiding_traffic' => "%1 tên miền, %2 tên miền hoạt động, %3 dung lượng được sử dụng",
    'domains__unable_to_change_client_status' => "Không thể thay đổi trạng thái tài khoản khách hàng: %1",
    'domains__unable_update_apache_settings' => "Không thể cập nhật các thiết lập Apache.",
    'domains__you_do_not_have_permissions_to_delete_domains' => "Bạn không có quyền xóa các tên miền.",
    'domains__you_want_change_the_status_of_the_cl??' => "Bạn có chắc là bạn muốn thay đổi trạng thái tài khoản khách hàng?",
    'domains__you_want_change_the_cp_access_of_the_cl??' => "Bạn có chắc chắn muốn thực hiện thao tác này?",
    'domains_list__unable_remove_doms' => "Không thể gỡ bỏ các tên miền: %1",
    'domaintrafficlist_header_of_domain__' => "Lưu lượng truy cập vào tên miền %1",

    'domain_aliases_remove__select_domain_aliases_for_remove' => 'Chọn các bí danh tên miền để được gỡ bỏ.',
    'domain_aliases_remove__title' => 'Gỡ bỏ các bí danh tên miền',
    'domain_aliases__max_aliases_reached_for_dom' => "Số lượng bí danh đã đạt đến giới hạn cho phép của miền này.",
    'domain_edit__edit_title' => 'Chỉnh sửa bí danh của tên miền',
    'domain_alias_edit__type' => 'Loại bí danh tên miền',
    'domain_aliases__list_header' => 'Các bí danh tên miền',
    'domain_aliases__name' => 'Tên',
    'domain_aliases__type' => 'Kiểu',
    'domain_aliases__type_full' => 'Web+FTP+Thư',
    'domain_aliases__type_web_ftp' => 'Web+FTP',
    'domain_aliases__page_title' => 'Các bí danh tên miền',
    'domain_aliases__legend' => 'Các bí danh tên miền',
    'domain_alias__domain_exists' => 'Tên miền này đã tồn tại',
    'domain_alias__subdomain_exists' => 'Tên miền phụ này đã tồn tại',
    'domain_alias__dns_record_exists' => 'Bản ghi DNS có tên bí danh miền này đã tồn tại',
    'domain_alias__domain_alias_exists' => "Bí danh miền có tên này đã tồn tại",
    'domain_alias__invalid_type_full' => 'Máy chủ thư không hỗ trợ bí danh tên miền',
    'domain_alias__redirect_exists' => 'Phát hiện thấy tự đổi hướng.',

    'ds__anonymous_ftp' => "FTP ẩn danh",
    'drweb__pagetitle' => 'Cài đặt chống virus',
    'drweb__drweb' => 'Kiểm tra thư bằng chống virus',
    'drweb__drweb_direction' => 'Kiểm tra virus cho thư',
    'drweb__drweb_direction_off' => 'Không kiểm tra vi rus',
    'drweb__drweb_direction_any' => 'Thư đến và thư đi',
    'drweb__drweb_direction_from' => 'Chỉ thư đi',
    'drweb__drweb_direction_to' => 'Chỉ thư đến',
    'drweb__disable_reason_key' => 'Chống virus không được mã bản quyền hỗ trợ.',
    'drweb__disable_reason_perm' => 'Bạn không có quyền quản lý Chống virus.',
    'drweb__disable_reason_install' => 'Chống virus không được cài đặt.',
    'drweb__filters' => 'Các bộ lọc chống virus',
    'ds__dns' => "Vùng DNS",
    'ds__mail' => "Thư",
    'dsr__of_client_title' => "Báo cáo tóm lược về tên miền %1",
    'dsr__report_has_been_sent_email' => "Báo cáo được gửi đến email: %1",
    'dsr__title' => "Báo cáo tóm lược tên miền",
    'dumps_list__deletion_page_title' => "Các tập tin sao lưu bên dưới của tên miền %1 sẽ được gỡ bỏ:",
    'dumps_list__dumpfile_is_invalid' => "Tập tin %1 không phải là tập tin sao lưu hợp lệ.",
    'dumps_list__page_title' => "Lưu trữ tập tin sao lưu",
    'dumps_upload__page_title' => "Tải lên các tập tin sao lưu tới lưu trữ",
    'dumps_list__repository_is_not_exist' => "Lưu trữ các tập tin sao lưu không tồn tại.",
    'dumps_list__unable_to_remove' => "Không thể gỡ bỏ tập tin sao lưu: %1",
    'dumps_list__dumpfile_can_conflict' => "Tên tập tin mà bạn đã chỉ định xung đột với tập tin %1. Hãy chỉ định một tên tập tin khác.",
    'dusr_ed__allow_dl_usr_access' => "Cho phép người quản trị tên miền truy cập",
    'dusr_ed__information' => "Thuộc tính của tài khoản quản trị tên miền %1",
    'dusr_ed__locale' => "Ngôn ngữ của tài khoản quản trị tên miền",
    'dusr_ed__skin' => "Giao diện của tài khoản quản trị tên miền",
    'dusr_ed__personal_information' => 'Thông tin cá nhân',
    'ess__error' => "Lỗi",
    'example__' => "Ví dụ: %1",
    'extras__allow_certificate_purchasing' => "Cho phép mua chứng chỉ",
    'extras__allow_domain_registration' => "Cho phép đăng ký tên miền",
    'extras__allow_extras' => "Cho phép các dịch vụ mở rộng",
    'extras__buy_new_key' => "Bản quyền hiện tại của bạn không cho phép bạn sửa đổi các đối tượng này.",
    'extras__setup_services' => "Thiết lập các dịch vụ bổ sung",

    'ruleeditform__error' => 'Không thể cập nhật quy tắc tường lửa.',
    'ruleeditform__name_is_required' => 'Chỉ định tên quy tắc.',
    'ruleeditform__profiles_is_required' => 'Chọn ít nhất một hồ sơ.',
    'ruleeditform__invalid_ip' => 'Địa chỉ IP hoặc mạng không hợp lệ.',
    'ruleeditform__invalid_port' => 'Cổng không hợp lệ. Các giá trị có thể nhập là 1000 hoặc 1000-1051',

    'filemanager__items' => 'các mục trong danh mục %1',
    'filemanager__items_paging' => 'các mục trong danh mục %1',

    'get_password__encrypted_password' => "Không thể gửi thông tin mật khẩu: mật khẩu đã được lưu ở dạng mã hóa.",
    'get_password__mail_error' => "Xảy ra lỗi khi gửi mật khẩu đến email %1: %2",
    'get_password__mail_ok' => "Mật khẩu đã được gửi đến email: %1",
    'get_password__message' => "Tên đăng nhập của bạn để truy cập vào hệ thống: %1\nMật khẩu của bạn là %2",
    'get_password__subject' => "Mật khẩu để truy cập vào hệ thống",
    'groups__available' => "Các nhóm thư có sẵn",
    'groups__groups_for_mailname' => "Các nhóm thư mà tài khoản thư %1 được đăng ký",
    'groups__member_of' => "Thành viên của các nhóm thư sau",
    'help__help_area' => "Khu vực trợ giúp.",
    'hst_def__auth_disabled' => "bị cấm",
    'hst_def__auth_enabled' => "được cho phép",
    'hst_def__change_curr_dns_ip' => "Địa chỉ IP hiện tại của bản ghi A DNS sẽ được thay đổi",
    'hst_def__cr_hosting_ip_dns_ip_not_equiv' => "Không tồn tại các địa chỉ IP của bản ghi A DNS trùng khớp với các địa chỉ IP được gán cho tài khoản lưu trữ được tạo ra",
    'hst_def__dest_url' => "URL đích",
    'hst_def__disk_quota' => "Hạn ngạch đĩa",
    'hst_def__disk_space_limit_exceed_incoming_quota' => "Giới hạn không gian đĩa mà bạn thiết lập đã vượt quá giới hạn không gian đĩa trong thư mục FTP ẩn danh. Giới hạn không gian đĩa trong thư mục FTP ẩn danh không được vượt quá giới hạn đã cấp cho tên miền.",
    'hst_def__frame_forwarding_definition' => "Cấu hình chuyển tiếp dạng khung cho tên miền %1",
    'hst_def__ftpuser_for_hst_not_exist_in_system' => "Cảnh báo: Người dùng FTP %1 được sử dụng trong Cài đặt tài khoản dịch vụ lưu trữ nhưng lại không tồn tại trong hệ thống.",
    'hst_def__hst_type_is_not_defined' => "Kiểu lưu trữ không được xác định",
    'hst_def__ip_based' => "Dựa trên IP",
    'hst_def__name_based_power_anonymous_ftp_down' => "Chuyển giao tài khoản lưu trữ này tới địa chỉ IP được chia sẻ sẽ làm cho dịch vụ FTP ẩn danh thuộc miền này không hoạt động. Tiếp tục không?",
    'hst_def__password_is_invalid_password_syntax' => "Mật khẩu không hợp lệ.\nBạn không được sử dụng dấu nháy đơn và các ký tự trong bảng chữ cái quốc gia trong một mật khẩu.\nChiều dài mật khẩu sẽ từ 5 đến 14 ký tự. Mật khẩu không nên chứa tên người dùng.",
    'hst_def__shell' => "SSH truy cập vào vỏ máy chủ dưới tên người dùng hệ thống của thuê bao",
    'hst_def__shell_windows' => "Máy tính từ xa truy cập vào máy chủ dưới tên người dùng hệ thống của thuê bao",
    'hst_def__standard_forwarding_definition' => "Cấu hình chuyển tiếp dạng chuẩn được gán cho tên miền %1",
    'hst_def__title_name_based' => "Dựa theo tên",
    'hst_def__unable_create/update_physic_hst' => "Không thể tạo ra/cập nhật lưu trữ vật lý: %1",
    'hst_def__unable_create/update_std_fwd' => "Không thể tạo/cập nhật các chuyển tiếp dạng chuẩn: %1",
    'hst_def__unable_create_forwarding_myself' => "Không thể tạo chuyển tiếp đến chính tên miền này.",
    'hst_def__unable_turn_same_ssl_while_ssl_off' => "Không thể cho phép việc sử dụng thư mục duy nhất để lưu trữ nội dung SSL/TLS và nội dung không SSL/TLS: Hỗ trợ SSL/TLS không được bật lên.",
    'hst_def__unable_turn_on_ssl_cert_not_defined' => "Không thể bật hỗ trợ SSL/TLS: không có chứng nhận SSL/TLS được cài đặt.",
    'hst_def__url_is_invalid' => "URL không hợp lệ.",
    'hst_def__virtual_host_access' => "Truy cập vào vùng lưu trữ ảo tên miền %1",
    'hst_def__virtual_host_uses_non_existed_ip_address' => "CẢNH BÁO. Máy chủ ảo đang sử dụng một địa chỉ IP không tồn tại cho dịch vụ lưu trữ.",
    'hst_def__you_have_no_ips' => "Bạn không có sẵn địa chỉ IP, và bạn không được phép tạo vùng lưu trữ dựa trên tên.",
    'hst_sel__header' => "Để lưu trữ một website trên máy chủ này, chọn tùy chọn dịch vụ lưu trữ thực.\n Để thiết lập tên miền chuyển tiếp đến một trang trên máy khác, chọn tùy chọn chuyển tiếp khung hoặc chuyển tiếp thông thường.\n Với chuyển tiếp thông thường, người dùng được chuyển hướng đến trang này và URL thực của trang được hiển thị trên trình duyệt của người dùng, do đó người dùng có thể biết được hoạt động chuyển hướng. Với chuyển tiếp khung, người dùng được chuyển hướng đến trang này mà không biết rằng trang này thực tế đang ở một địa điểm khác.",
    'hst_sel__physical_hst' => "Lưu trữ vật lý",
    'hst_sel__select_hst_type' => "Chọn kiểu lưu trữ cho tên miền",
    'hst_sel__select_hst_type_warning' => "Chọn kiểu lưu trữ cho tên miền",
    'hst_sel__hosting_exists' => "Không thể tạo ra lưu trữ, vì nó đã được cấu hình cho tên miền này. Bạn sẽ được chuyển hướng đến trang web quản lý lưu trữ.",
    'hst_sel__standard_frw' => "Chuyển tiếp dạng chuẩn",
    'hst_sel__frame_frw' => "Chuyển tiếp khung",
    '__frame_frw' => "Chuyển tiếp khung",
    '__hosting_exists' => "Không thể tạo ra lưu trữ, vì nó đã được cấu hình cho tên miền này. Bạn sẽ được chuyển hướng đến trang web quản lý lưu trữ.",
    '__choose_hst_type' => "Chọn loại lưu trữ được yêu cầu.",
    '__no_hst_conf' => "Không có lưu trữ nào được cấu hình cho tên miền của bạn.",
    '__physical_hst' => "Lưu trữ vật lý",
    '__select_hst_type' => "Chọn kiểu lưu trữ cho tên miền",
    '__standard_frw' => "Chuyển tiếp dạng chuẩn",
    '__warning' => "Cảnh báo! Tất cả các thông số cài đặt trước đó sẽ được bỏ đi. Bạn có chắc là bạn muốn thay đổi kiểu lưu trữ?",
    'i_cl_off' => "Khách hàng không hoạt động.",
    'i_cl_off_by_admin' => "Tài khoản khách hàng đã bị tạm ngưng bởi quản trị viên.",
    'i_cl_off_expired' => "Tài khoản khách hàng là hết hạn.",
    'i_cl_on' => "Khách hàng đang hoạt động.",

    'icf__title' => 'Tường lửaKết nối Internet',
    'icf__if_legend' => 'Các giao diện',
    'icf__mode' => 'Chế độ',

    'invalid_value' => 'Giá trị không hợp lệ',

    'ip_addr__already_exists' => "Địa chỉ IP %1 đã tồn tại.",
    'ip_addr__cant_add' => "IP %1 không tồn tại hoặc thuộc về dãy IP của một khách hàng khác",
    'ip_alias__interface' => "Giao diện",
    'ip_alias__invalid_ip_nm_bsd_vrt_hsts' => "%1 Địa chỉ IP cho lưu trữ ảo dựa trên tên không hợp lệ.",
    'ip_alias__invalid_ip_or_netmask' => "Cặp địa chỉ IP/mặt nạ mạng không hợp lệ.",
    'ip_alias__orig_ip_can_not_be_deleted' => "Các địa chỉ IP %1 là địa chỉ IP máy chủ gốc, vì vậy bạn không thể gỡ bỏ nó.",
    'ip_alias__ip_is_invalid' => "Địa chỉ IP %1 không hợp lệ.",
    'ip_alias__ip_mask_is_invalid' => "Mặt nạ IP %1 không hợp lệ.",
    'ip_alias__ip_not_exist' => "Địa chỉ IP %1 không tồn tại.",
    'ip_alias__ip_address_and_mask' => 'Địa chỉ IP và mặt nạ mạng con',
    'ip_alias__mask' => "Mặt nạ mạng con",
    'ip_alias__remove_selected_ip_aliases?' => "Bạn có chắc chắn muốn gỡ bỏ các địa chỉ IP được chọn?",
    'ip_alias__select_ip' => "Chọn ít nhất một địa chỉ IP từ danh sách để gỡ bỏ nó.",
    'ip_alias__this_ip_used_for_domain' => "(%1) địa chỉ IP này sẽ được sử dụng cho tên miền %2.",
    'ip_alias__this_ip_used_for_nm_bsd_vrt_hsts' => "(%1) địa chỉ IP này sẽ được sử dụng cho các lưu trữ ảo dựa trên tên.",
    'ip_alias__unable_add_ip' => "Không thể thêm IP: %1",
    'ip_alias__unable_remove_ip' => "Không thể gỡ bỏ IP: %1",
    'ip_ctrl__anonymous_ftp_exists_in_domain' => "Bạn không thể thay đổi địa chỉ IP thành dạng chia sẻ, vì nó sẽ làm cho FTP ẩn danh của tên miền '%1' không hoạt động.",
    'ip_ctrl__ip_addr' => "Địa chỉ IP %2 trên giao diện %1",
    'ip_ctrl__ip_exists_many_pools' => "Bạn không thể thay đổi loại IP. Địa chỉ IP này thuộc về dãy IP của một số người dùng vào cùng thời điểm.",
    'ip_ctrl__ssl_cert' => "Chứng nhận SSL/TLS",
    'limit__date_in_past' => "Thời gian hiệu lực không hợp lệ. %1 là trong quá khứ.",
    'limit__enter_date' => "Nhập ngày",
    'limit__max_db' => "Cơ sở dữ liệu",
    'limit__name_disk_space' => "Không gian đĩa",
    'limit__name_max_box' => "hòm thư",
    'limit__name_max_db' => "CSDL MySQL",
    'limit__name_max_dom' => "các tên miền",
    'limit__name_max_maillists' => "Các danh sách gửi thư",
    'limit__name_max_subdom' => "tên miền phụ",
    'limit__name_max_traffic' => "lưu lượng",
    'limit__name_max_wu' => "người dùng web",
    'limit__name_mbox_quota' => "hạn ngạch hòm thư",
    'limit__name_max_mn' => "các tài khoản thư",
    'limit__name_max_cl' => 'Khách hàng',
    'limit__name_total_mboxes_quota' => "tổng số hạn ngạch hòm thư",
    'limit__name_mysql_dbase_space' => "Không gian cơ sở dữ liệu MySQL",
    'limit__name_mssql_dbase_space' => "Không gian cơ sở dữ liệu MSSQL",
    'limit__name_pgsql_dbase_space' => "Không gian cơ sở dữ liệu PostgreSQL",
    'limit__name_expiration' => 'ngày hết hạn',

    'locale_upload__unable_to_install' => 'Không thể cài đặt tập tin gói ngôn ngữ',
    'locale_upload__wrong_package' => 'Tập tin bạn đã tải lên không chứa gói ngôn ngữ hợp lệ cho phiên bản Plesk này.',
    'locale_upload__wrong_locale' => 'Tập tin bạn đã tải lên chứa gói ngôn ngữ không hợp lệ.',

    'ma__create_title' => 'Tạo bí danh thư cho %1',
    'ma__edit_title' => "Chỉnh sửa bí danh thư %1",
    'ma__enter_new_alias' => "Nhập bí danh mới.",
    'ma__invalid_alias' => "Bí danh thư không hợp lệ.",
    'ma__mail_aliases_mailname' => "Bí danh thư cho tài khoản thư %1",
    'ma__mailname_does_not_exist' => "Tài khoản thư không tồn tại.",
    'ma__select_ma_for_remove' => "Chọn bí danh thư cần gỡ bỏ.",
    'ma__unable_to_add_new_ma' => "Không thể thêm bí danh thư: %1",

    'mail_queue__not_allowed_by_license_key' => 'Quản lý hàng đợi thư không được phép do mã bản quyền.',
    'maillist__' => "Danh sách gửi thư %1",
    'maillist__already_exists' => "Danh sách gửi thư đã tồn tại.",
    'maillist__mail_alias_already_exists_in_this_domain' => "Bí danh thư %1 đã tồn tại trong miền này",
    'maillists__' => "Các danh sách gửi thư %1",
    'maillists__limit_cl_max_maillists' => "Đã đạt tới giới hạn về số lượng danh sách gửi thư cấp cho các khách hàng (giới hạn: %1, được sử dụng: %2)",
    'maillists__limit_dom_max_maillists' => "Đã đạt tới giới hạn về số lượng danh sách gửi thư cho tên miền.",
    'maillists__list' => "Các danh sách gửi thư",
    'maillists__mailman_not_installed_or_conf' => "\nDịch vụ Mailman hiện chưa được cài đặt hoặc cấu hình\ntrên máy chủ. Liên lạc với quản trị viên để cài đặt hoặc cấu hình Mailman chính xác.",
    'maillists__status' => "Dịch vụ danh sách gửi thư đã được kích hoạt",
    'maillists__unable_to_delete__' => "Không thể xóa bỏ danh sách gửi thư: %1",
    'maillists__disabled_text' => 'Bạn không thể quản lý danh sách gửi thư vì thành phần này chưa được cài đặt hoặc cấu hình.',
    'maillist_member__already_exists' => 'Thành viên đăng ký đã tồn tại.',
    'maillist_member__not_exists' => 'Không có những người dùng nào trên các danh sách gửi thư.',
    'mailserver_switching_warning' => "Cảnh báo! Chỉ nên thay đổi máy chủ thư khi thiết lập ban đầu và nếu máy chủ đang được sử dụng, thì sẽ gây ra các vấn đề sau đây: mất các thiết lập và nội dung hộp thư, và, trong trường hợp khi bạn chuyển sang máy chủ đã được cấu hình, sẽ xảy ra các xung đột.\nNếu máy chủ này đang được sử dụng và bạn chắc chắn muốn chuyển sang máy khác, bạn có thể thông báo cho khách hàng để họ có thể tải về và lưu thư.",
    'manager__access_denied' => "Truy cập bị từ chối: %1",
    'manager__admin' => "Quản trị viên",
    'manager__client' => 'Khách hàng',
    'manager__domain' => "Tên miền",
    'manager__domain_cl_limit_exceeding' => "Đã đạt tới giới hạn về tên miền cho tài khoản khách hàng này.",
    'manager__domain_is_not_yours' => "Tên miền %1 không thuộc về bạn.",
    'manager__domain_key_limit_exceeding' => "Đã đạt tới giới hạn số lượng tên miền được phép tạo.",
    'manager__no_perm_to_call' => "Bạn không có quyền để gọi %1.",
    'manager__no_perm_to_create_domains' => "Bạn không có quyền để tạo các tên miền.",
    'manager__no_perm_to_modify_domain' => "Bạn không có quyền để hiệu chỉnh tên miền %1.",
    'manager__no_perm_to_modify_domains' => "Bạn không có quyền để hiệu chỉnh các tên miền.",
    'manager__no_perm_to_remove_domain' => "Bạn không có quyền để gỡ bỏ tên miền %1.",
    'manager__no_perm_to_remove_domains' => "Bạn không có quyền để gỡ bỏ các tên miền.",
    'manager__node_doesnt_exist' => "%1 không tồn tại.",
    'manager__user_disabled' => "Tài khoản của bạn bị tạm ngưng. Bạn không thể sử dụng hệ thống.",
    'mail_quota_unsupported' => "không được hỗ trợ bởi máy chủ thư",
    'mbox_quota_unsupported' => "không được hỗ trợ bởi máy chủ thư",
    'mn__create_title' => "Tạo tài khoản thư",
    'mn__edit_title' => "Cài đặt",
    'mn__files_list_title' => "Các tập tin đính kèm",
    'mn__files_remove' => "Gỡ bỏ các tập tin khỏi kho lưu trữ các tài liệu đính kèm. Các tập tin này có thể được sử dụng bởi trả lời tự động. Chúng sẽ được gỡ bỏ khỏi cả kho lưu trữ và trả lời tự động đang sử dụng chúng.",
    'mn__files_select_for_remove' => "Chọn các tập tin sẽ được gỡ bỏ.",
    'mn__mail_alias_form' => "Mẫu bí danh thư",
    'mn__mail_aliases_list' => "Các bí danh thư",
    'mn__mailbox' => "Quản lý hộp thư",
    'mn__unable_define_mn' => "Không thể thiết lập các tài khoản thư: %1",
    'mn__unable_remove_mbox_quota' => "Không thể gỡ bỏ hạn ngạch hộp thư: %1",
    'mn__upload_file' => "Tải lên tập tin",
    'mn_edit__attach_filename_changed' => 'Tập tin tải lên %1 được đổi tên thành %2 vì tên này có chứa các ký tự ngoài ASCII.',
    'mn_edit__add_mail_group_members_or_turn_off_box' => "Bạn nên thêm thành viên trước khi kích hoạt nhóm thư.",
    'mn_edit__add_resp_or_turn_off_box' => "Bạn nên thêm trả lời tự động hoặc xóa ô trống trả lời tự động.",
    'mn_edit__attachments' => "Đính kèm",
    'mn_edit__dom_quota_less_then_quota' => "Kích thước của hộp thư này không được vượt quá giới hạn về dung lượng đĩa được phân bổ cho các hộp thư thuộc tên miền này.",
    'mn_edit__enter_external_rcpnt_email' => "Nhập email của thành viên nhóm thư bên ngoài",
    'mn_edit__enter_mail_redir_or_turn_off_box' => "Gõ một địa chỉ để chuyển tiếp thư hoặc xóa đánh dấu.",
    'mn_edit__ext_rcpnt_email_invalid' => "Địa chỉ email của khách hàng bên ngoài không hợp lệ.",
    'mn_edit__file_exists' => "Tập tin đã tồn tại. Ghi đè lên?",
    'mn_edit__files_deld_from_repository' => "Những tập tin này sẽ được xóa khỏi kho lưu trữ và những thư trả lời tự động chứa chúng. Bạn có muốn thực thi không?",
    'mn_edit__mail_name' => "Tài khoản thư",
    'mn_edit__mail_name_invalid' => "Tên tài khoản thư không hợp lệ.",
    'mn_edit__mail_redir' => "Chuyển tiếp thư",
    'mn_edit__mail_redir_add' => "Thêm Thành viên Nhóm Thư",
    'mn_edit__mail_resps' => "Trả lời tự động thư",
    'mn_edit__mailbox' => "Hộp thư",
    'mn_edit__enable_mailbox' => "Hộp thư",
    'mn_edit__mailgroup' => "Nhóm thư",
    'mn_edit__mailgroup_addresses' => "Các thành viên nhóm thư",
    'mn_edit__mailgroup_disabled' => "Chỉ hoạt động khi nào tài khoản thư đã được thêm vào.",
    'mn_edit__max_dom_quota' => "Mặc định cho tên miền (%1)",
    'mn_edit__mbox_quota_invalid' => "Kích thước hộp thư được chỉ định không đúng.",
    'mn_edit__new_resp_name' => "Tên trả lời tự động mới",
    'mn_edit__no_autoresponders' => "Bạn nên thêm ít nhất một trả lời tự động trước khi bật hay tắt dịch vụ trả lời tự động.",
    'mn_edit__no_file_sel' => "Không có tập tin nào được chọn.",
    'mn_edit__no_mail_addresses' => "Không có địa chỉ email nào được chỉ định hoặc chọn.",
    'mn_edit__none' => "Không",
    'mn_edit__not_create_pass' => "Điều này sẽ không tạo một mật khẩu cho tài khoản này.\nKhông có mật khẩu, người dùng sẽ không thể xem và gửi thư.",
    'mn_edit__redir_email_invalid' => "Chuyển tiếp địa chỉ thư không hợp lệ.",
    'mn_edit__redirect_addr' => "Chuyển tiếp địa chỉ",
    'mn_edit__remove_autoresp?' => "Bạn có chắc là bạn muốn gỡ bỏ trả lời tự động?",
    'mn_edit__remove_rcpnts?' => "Bạn có chắc là bạn muốn gỡ bỏ những người nhận này?",
    'mn_edit__repository' => "Kho lưu trữ",
    'mn_edit__resps_attach' => "Các tập tin đính kèm trong trả lời tự động",
    'mn_edit__select_rcpnt_from_list' => "Chọn ít nhất một người nhận từ danh sách để gỡ bỏ nó.",
    'mn_edit__select_registered_users' => "Chọn những người dùng được đăng ký",
    'mn_edit__selected_postbox_have_not_setup_passwd' => "Bạn đã chọn để có một hộp thư nhưng chưa đặt mật khẩu cho nó.",
    'mn_edit__unable_act_deact_mail_group' => "Không thể kích hoạt hay vô hiệu hóa nhóm thư: %1",
    'mn_edit__unable_act_deact_mail_redir' => "Không thể kích hoạt hay hủy kích hoạt chuyển tiếp thư: %1",
    'mn_edit__unable_act_deact_postbox' => "Không thể kích hoạt hay vô hiệu hóa hộp thư: %1",
    'mn_edit__unable_act_deact_resp' => "Không thể kích hoạt/vô hiệu hóa trả lời tự động: %1",
    'mn_edit__unable_add_attach' => "Không thể thêm tập tin đính kèm: %1",
    'mn_edit__unable_add_mail_group_member' => "Không thể thêm thành viên nhóm thư: %1",
    'mn_edit__unable_add_resp' => "Không thể thêm bộ trả lời tự động: %1",
    'mn_edit__unable_change_mail_name' => "Không thể thay đổi tên tài khoản thư: %1",
    'mn_edit__unable_deactivate_mail_group' => "Không thể vô hiệu hóa nhóm thư: %1",
    'mn_edit__unable_deactivate_resp' => "Không thể vô hiệu hóa chức năng trả lởi tự động: %1",
    'mn_edit__unable_define_resp_id' => "Không thể xác định nhận dạng cho bộ trả lời tự động: %1",
    'mn_edit__unable_remove_attach' => "Không thể gỡ bỏ (các) tập tin đính kèm: %1",
    'mn_edit__unable_remove_autoresp' => "Không thể gỡ bỏ bộ trả lời tự động: %1",
    'mn_edit__unable_remove_mail_group_member' => "Không thể gỡ bỏ các thành viên nhóm thư: %1",
    'mn_edit__wrong_way' => 'Các tin nhắn gửi cho địa chỉ %1 sẽ không được chuyển đi, do tài khoản này hiện không có hộp thư hoặc chức năng chuyển tiếp thư đang được kích hoạt.',
    'mn_edit__mailbox_is_disabled_mail_not_removed' => 'Hộp thư tại địa chỉ %1 đã được tắt. Các tin nhắn trong hộp thư này không bị gỡ bỏ, nhưng bạn sẽ vẫn không thể lấy thông qua giao thức POP3 hay IMAP.',
    'mn_list__mail_names_for_domain' => "Các tài khoản thư theo tên miền %1",
    'mn_list__sa_cannot_unable' => "Không thể bật chức năng lọc thư rác",
    'mn_list__tab_cp_access' => "L",
    'mn_list__tab_title_client' => 'Khách hàng',
    'mn_list__tab_title_domain' => 'Tên miền',
    'mn_list__tab_title_autoresp' => "A",
    'mn_list__tab_title_box' => "B",
    'mn_list__tab_title_group' => "G",
    'mn_list__tab_title_name' => "Tên",
    'mn_list__tab_title_redirect' => "F",
    'mn_list__tab_title_spamfilter' => "S",
    'mn_list__tab_title_virusfilter' => 'AV',
    'mn_list__tab_title_drweb' => 'AV',
    'mn_list__unable_remove_mns' => "Không thể gỡ bỏ các tài khoản thư: %1",
    'module_upload__module_was_installed' => 'Mô-đun này đã được cài đặt. Nếu bạn muốn cài đặt phiên bản mới hơn của mô-đun này, vui lòng gỡ cài đặt mô-đun qua Plesk, và sau đó cài đặt lại.',
    'module_upload__unable_to_install' => 'Không thể cài đặt tập tin gói phân đoạn',
    'module_upload__wrong_package' => 'Tệp tin được tải lên không phải là một gói phân đoạn được hỗ trợ.',
    'module_upload__wrong_module' => 'Tệp tin được tải lên không chứa một gói phân đoạn.',

    'news_articles_title' => 'Tin tức Plesk',
    'notification_text__invalid_subject_length' => "Chủ đề thông báo có độ dài không hợp lệ. Cần có từ 1 đến 255 ký tự.",
    'notification_text__invalid_text_length' => "Độ dài văn bản thông báo không hợp lệ. Nên có từ 1 đến 65533 ký tự.",
    'notification_text__subject' => "Chủ đề thông báo",
    'notification_text__text' => "Văn bản thông báo",
    'notification_text__title' => "Hiệu chỉnh thông báo",
    'notification_text__unable_set_text' => "Không thể sửa đổi văn bản thông báo:",

    'odbc__cant_add_dsn' => "Không thể thêm DSN %1: %2",
    'odbc__cant_connect' => "Không thể kết nối với nguồn dữ liệu bằng các thiết lập được chỉ định. Máy chủ đã trả lại: %1",
    'odbc__cant_delete_dsn' => "Không thể xóa DSN %1: %2",
    'odbc__cant_get_drivers_info' => "Không thể lấy thông tin về các trình điều khiển.",
    'odbc__cant_get_drivers' => "Không thể lấy một danh sách các trình điều khiển ODBC: %1",
    'odbc__cant_open_info_file' => "Không thể mở tập tin với thông tin về trình điều khiển ODBC.",
    'odbc__cant_parse_string' => "Không thể phân tích cú pháp cho chuỗi kết nối.",
    'odbc__driver_not_set' => "Trình điều khiển không được thiết lập",
    'odbc__driver_or_name_not_set' => "Trình điều khiển hoặc tên của kết nối ODBC không được thiết lập",
    'odbc__dsn_already_exists' => "DSN với tên này (%1) đã tồn tại trong hệ thống",
    'odbc__dsn_not_exists' => "DSN này không tồn tại",
    'odbc__enter_dsn_name' => "Nhập tên DSN",
    'odbc__invalid_dsn_name' => "Sai cú pháp cho tên kết nối ODBC (%1): Hãy chỉ sử dụng các ký tự chữ và số.",
    'odbc__no_such_driver' => "Trình điều khiển ODBC có tên (%1) không được hỗ trợ.",
    'odbc__unknown_driver' => "Tên trình điều khiển (%1) không xác định.",
    'odbc_dsn_system' => "Hệ thống DSN",

    'pb__aliases' => "Các bí danh",
    'pb__anonftp' => "FTP ẩn danh",
    'pb__autoinstaller_releases' => 'Trình cập nhật',
    'pb__cert' => "Chứng chỉ",
    'pb__cl_pool' => "Các địa chỉ IP",
    'pb__cl_pool_ctrl' => "%1",
    'pb__cl_pref' => "Cài đặt",
    'pb__cl_rpt' => "Báo cáo",
    'pb__cl_rpt_list' => "Tùy biến",
    'pb__cl_templates' => "Mẫu khách hàng",
    'pb__cl_traffic' => "Lưu lượng",
    'pb__cl_traffic_history' => "Lược sử lưu lượng",
    'pb__cl_traffic_of' => "Lưu lượng của %1",
    'pb__client' => "%1",
    'pb__clients' => "Khách hàng",
    'pb__comp_info' => "Các Thành Phần Máy Chủ",
    'pb__common_acl' => 'Cho phép truyền ACL',
    'pb__cp_access' => "Truy cập",
    'pb__crontab' => "Trình lập lịch",
    'pb__scheduler' => "Trình lập lịch",
    'pb__custom_buttons' => "Các nút tùy biến",
    'pb__databases_db' => 'Cơ sở dữ liệu',
    'pb__sqlservers_db' => 'Máy chủ SQL',//to check
    'pb__db' => "Cơ sở dữ liệu",
    'pb__db_edit' => "%1",
    'pb__db_server_edit' => '%1',
    'pb__db_servers' => 'Các máy chủ cơ sở dữ liệu',
    'pb__dl_usr_ed' => "Quản trị tên miền",
    'pb__dns' => "DNS",
    'pb__dns_template' => "DNS",
    'pb__dns_t' => "DNS",
    'pb__dom_ctrl' => "%1",
    'pb__dom_lim' => "Giới hạn tên miền",
    'pb__dom_pref' => "Cài đặt",
    'pb__dom_sum_report' => "Báo cáo tóm lược tên miền",
    'pb__dom_templates' => "Mẫu tên miền",
    'pb__dom_traffic' => "Lưu lượng của %1",
    'pb__domains' => "Các tên miền",
    'pb__domain_aliases' => 'Bí danh tên miền',
    'pb__dumps_list' => "Lưu trữ tập tin sao lưu",
    'pb__forwarding_setup' => "Thiết lập chuyển tiếp",
    'pb__filemanager' => "Trình quản lý tập tin",
    'pb__ip_aliasing' => "Địa chỉ IP",
    'pb__ip_clients' => "Gỡ bỏ các địa chỉ IP",
    'pb__license_management' => 'Thông tin bản quyền',
    'pb__locales' => 'Vùng ngôn ngữ',
    'pb__log_files' => "Tập tin bản ghi",
    'pb__mail' => 'Thư',
    'pb__mail_name_files' => "Các tập tin đính kèm",
    'pb__mail_name_redirects' => "Chuyển tiếp thư",
    'pb__mail_name_resp_attach_add' => "Tập tin đính kèm mới",
    'pb__mail_name_resp_edit' => "%1",
    'pb__mail_name_responders' => "Trả lời tự động thư",
    'pb__mail_names' => "Thư",
    'pb__maillists' => "Các danh sách gửi thư",
    'pb__mimetypes' => 'Các kiểu MIME',
    'pb__modules' => 'Các phân đoạn',
    'pb__modules_management' => 'Quản lý các phân đoạn',
    'pb__notifications' => "Thông báo",
    'pb__odbc' => "ODBC",
    'pb__phosting_setup' => "Thiết lập lưu trữ vật lý",
    'pb__prtd_dirs' => "Thư mục được bảo vệ",
    'pb__prtdir_edit' => "%1",
    'pb__report' => "Báo cáo",
    'pb__report_list' => "Tùy biến",
    'pb__server' => "Máy chủ",
    'pb__sessions' => "Phiên",
    'pb__sapp_pool' => "Chuỗi ứng dụng web",
    'pb__siteapp_install' => 'Cài đặt ứng dụng web',
    'pb__site_app_pkgs' => 'Ứng dụng Web',
    'pb__site_apps' => "Ứng dụng Web",
    'pb__additional_key_info' => 'Các thuộc tính khóa',
    'pb__additional_key_properties' => 'Các thuộc tính khóa',
    'pb__skeleton' => 'Mẫu lưu trữ ảo',
    'pb__skins' => 'Các giao diện',
    'pb__skin_info' => '%1',
    'pb__spamassassin' => "Bộ lọc thư rác",
    'pb__statistics' => "Thống kê",
    'pb__subdom_ctrl' => "%1",
    'pb__subdomains' => "Tên miền phụ",
    'pb__templates' => "Các mẫu",
    'pb__virtualdirs' => 'Thư mục ảo',
    'pb__web_users' => "Người dùng Web",
    'pdir__enter_dir_name' => "Nhập tên thư mục.",
    'pdir__invalid_hst' => "Kiểu lưu trữ không hợp lệ. Phải là vật lý.",
    'pdir__pd_id_is_undefined' => "ID thư mục được bảo vệ không được xác định.",
    'pdir__pdir_exist' => "Thư mục với tên này đã được bảo vệ.",
    'pdir__pdir_not_exist' => "Các thư mục được bảo vệ không tồn tại.",
    'pdir__pdir_usr_not_exist' => "Người dùng thư mục được bảo vệ không tồn tại.",
    'pdir__remove_pdir_usrs' => "Những người dùng danh mục được bảo vệ %2 dưới website %1 sau đây sẽ bị gỡ bỏ:",
    'pdir__remove_pdir_usrs_on_subdom' => "Những người dùng danh mục được bảo vệ %2 dưới tên miền phụ %1 sau đây sẽ bị gỡ bỏ:",
    'pdir__select_pdir_usrs_for_remove' => "Chọn các người dùng thư mục được bảo vệ sẽ được gỡ bỏ.",
    'pdir__select_pdirs_to_remove' => "Chọn các thư mục để gỡ bỏ sự bảo vệ.",
    'pdir__unable_define_pdir_users' => "Không thể xác định các người dùng thư mục được bảo vệ.",
    'pdir__unable_define_pdirs_properties' => "Không thể đặt các thuộc tính của thư mục được bảo vệ: %1",
    'pdir__unable_select_dom_param' => "Không thể chọn các tham số của tên miền: %1",
    'pdir_ed__create_pdir_for_domain' => "Tạo thư mục được bảo vệ theo %1",
    'pdir_ed__create_pdir_for_subdomain' => "Tạo danh mục được bảo vệ theo tên miền phụ %1",
    'pdir_ed__dir_already_protect' => "Thư mục này đã được bảo vệ.",
    'pdir_ed__head_txt' => "Tiêu đề vùng được bảo vệ",
    'pdir_ed__invalid_login' => "Bạn đã chỉ định tên người dùng không hợp lệ.",
    'pdir_ed__login_exists' => "Người dùng này đã tồn tại. Thử chỉ định tên người dùng khác.",
    'pdir_ed__new_usr' => "Tên người dùng",
    'pdir_ed__non_ssl' => "Không SSL/TLS",
    'pdir_ed__cgi_bin' => "cgi-bin",
    'pdir_ed__path' => "Tên danh mục",
    'pdir_ed__pdir_for_domain' => "Thư mục được bảo vệ %1 thuộc tên miền %2",
    'pdir_ed__pdir_for_subdomain' => "Danh mục được bảo vệ %1 dưới tên miền phụ %2",
    'pdir_ed__pdir_location' => "Vị trí thư mục",
    'pdir_ed__pdir_users' => "Người dùng thư mục được bảo vệ",
    'pdir_ed__ssl' => "SSL/TLS",
    'pdir_ed__ssl_or_nonssl_should_be_checked' => "Cần đánh dấu ít nhất một ô trong các ô SSL/TLS và không SSL/TLS.",
    'pdir_ed__unable_cr_pdir_usr' => "Không thể tạo người dùng thư mục được bảo vệ: %1",
    'pdir_ed__unable_create_pdir' => "Không thể tạo thư mục được bảo vệ: %1",
    'pdir_ed__unable_define_hst_type' => "Không thể xác định kiểu lưu trữ.",
    'pdir_ed__unable_update_pdir' => "Không thể lưu cài đặt của danh mục được bảo vệ: %1",
    'pdir_ed__wrong_symbol_in_header' => "Không sử dụng ký tự %1 trong tiêu đề thư mục.",
    'pdir_usr_ed__create_pdir_usr_for_pd' => "Tạo người dùng cho thư mục được bảo vệ %1",
    'pdir_usr_ed__not_create_pass' => "Điều này sẽ không tạo ra mật khẩu mới cho người dùng thư mục được bảo vệ.\nKhông có mật khẩu người dùng sẽ không thể đăng nhập.",
    'pdir_usr_ed__pass_for_pdir_usr' => "Mật khẩu cho người dùng thư mục được bảo vệ %1",
    'pdir_usr_ed__unable_select_pdir_usr' => "Không thể chọn người dùng thư mục được bảo vệ: %1",
    'pdir_usrs_list__unable_define_pdir_usrs' => "Không thể xác định các người dùng thư mục được bảo vệ: %1",
    'pdir_usrs_list__unable_remove_pd_usrs' => "Không thể gỡ bỏ các người dùng thư mục được bảo vệ: %1",
    'phosting__anonftp_encrypt' => 'Mật khẩu của người dùng FTP được mã hóa, do đó không thể được sử dụng để bảo vệ thư mục /plesk-stat/webstat/. Hãy nhập lại mật khẩu FTP của bạn, hoặc bỏ chọn tùy chọn "có thể truy cập các thư mục được bảo vệ bằng mật khẩu \'/plesk-stat/webstat/\'"',
    'phosting__hosting_and_dns_ip_difference_warning' => "Tên miền %%domain_name%% tách ra thành địa chỉ IP %%dns_ip_address%%. Website của bạn được gán địa chỉ IP %%hosting_ip_address%%. Nếu website của bạn không mở trong một trình duyệt web khi bạn chỉ dẫn đến bằng tên miền, truy cập màn hình quản lý DNS (Miền > Tên miền > DNS) và thay đổi thuộc tính của bản ghi tài nguyên: gán địa chỉ IP %%hosting_ip_address%% cho tên miền %%domain_name%%.",
    'phosting__ip_change_warning' => "Địa chỉ IP đã thay đổi. Những thay đổi tương ứng cũng được thực hiện trong vùng DNS của tên miền.",
    'phosting__other_hosting_exists_on_ip' => "Không thể thay đổi chứng chỉ bởi vì địa chỉ IP này đang được sử dụng trong một hoặc một số tài khoản lưu trữ.",
    'phosting__unable_to_change_certificate' => "Không thể cài đặt chứng chỉ: %1",
    'phosting__unable_to_change_ip_address' => "Không thể thay đổi địa chỉ IP: %1",
    'phosting__unable_to_set_cert' => "Không thể thiết lập chứng nhận SSL/TLS: %1",
    'phosting__unable_update' => "Không thể cập nhật thiết lập lưu trữ: %1",
    'phosting__unable_manage' => "Không thể quản lý lưu trữ: %1",
    'phosting__failed_to_add_logs_fail2ban' => "Không thể định cấu hình fail2ban để theo dõi nhật ký của miền. Nhật ký sẽ được tự động theo dõi vào lần khởi động lại dịch vụ fail2ban tiếp theo.\n%1",

    'picker_acl_record__tittle' => 'Chọn một bản ghi ACL',
    'picker_autoresponder__title' => 'Chọn một Trả lời tự động',
    'picker_black_list__domain_name' => 'Chọn một tên miền',
    'picker_certificate' => 'Chọn một chứng nhận SSL/TLS',

    'picker_dns_zone_template__title' => 'Chọn một bản ghi',
    'picker_domain__title' => 'Chọn một Trang web',
    'picker_domain_alias__title' => 'Chọn một bí danh tên miền',
    'picker_resource_record__title' => 'Chọn một bản ghi',
    'picker_disabled_resource_record__title' => 'Chọn một máy chủ tên miền',
    'picker_ip_address__title' => 'Chọn một địa chỉ IP',
    'picker_ip_address_clients__title' => 'Chọn khách hàng sử dụng địa chỉ IP này',
    'picker_mail_queue' => 'Chọn các tin nhắn email',
    'picker_site_application__title' => 'Chọn một ứng dụng web',
    'picker_subdomain__title' => 'Chọn một tên miền con',
    'picker_web_user__title' => 'Chọn một người dùng Web',
    'picker_custom_button__title' => 'Chọn một nút tùy biến',
    'picker_license_key__title' => "Chọn mã bản quyền",
    'picker_spamfilter_address__title' => 'Chọn một địa chỉ bộ lọc thư rác',
    'picker_white_list__networks' => 'Chọn mạng',

    'plesk_key__action_logs' => "Nhật ký các hoạt động thực hiện bởi người dùng Plesk",
    'plesk_key__app_vault' => "Kho ứng dụng",
    'plesk_key__backup' => "Khả năng sử dụng chức năng sao lưu dự phòng",
    'plesk_key__client_templs' => "Quản lý các mẫu mô hình dịch vụ",
    'plesk_key__clients' => "Tài khoản người dùng (Đại lý và khách hàng)",
    'plesk_key__resellers_only' => "Tài khoản người dùng (đại lý)",
    'plesk_key__customers_only' => "Tài khoản người dùng (khách hàng)",
    'plesk_key__domains' => "Các tên miền",
    'plesk_key__domain_aliases' => "Các bí danh tên miền",
    'plesk_key__manage_dashboard' => 'Tùy chỉnh trang chủ',
    'plesk_key__drweb' => "Quản lý chống virus",
    'plesk_key__event_manager' => "Trình quản lý sự kiện",
    'plesk_key__expirations' => "Việc quản lý ngày hết hạn tài khoản",
    'plesk_key__group_ops' => "Hiệu chỉnh nhiều đối tượng cùng một lúc",
    'plesk_key__expiration' => "Ngày hết hạn mã",
    'plesk_key__edition_name' => "Phiên bản Plesk",
    'plesk_key__key_number' => "Số mã",
    'plesk_key__languages' => "gói ngôn ngữ",
    'plesk_key__mailnames' => "Các tài khoản thư",
    'plesk_key__migration_manager' => "Trình quản lý Chuyển & Chuyển rời",
    'plesk_key__mssql' => "Hỗ trợ máy chủ Microsoft SQL",
    'plesk_key__myplesk_func' => "Liên kết để mua các chứng nhận SSL/TLS và dịch vụ đăng ký tên miền",
    'plesk_key__myplesk_server_id' => "Định dạng máy chủ MPC phụ",
    'plesk_key__notifications' => "Quản lý các thông báo",
    'plesk_key__postgresql' => "Hỗ trợ máy chủ PostgreSQL",
    'plesk_key__qmail_queue' => 'Quản lý hàng đợi thư',
    'plesk_key__remote_db' => 'Dịch vụ lưu trữ cơ sở dữ liệu từ xa',
    'plesk_key__slave_servers' => "Máy chủ phụ",
    'plesk_key__spamassassin' => "Quản lý bộ lọc thư rác",
    'plesk_key__subdomains' => "Quản lý tên miền phụ",
    'plesk_key__sys_access' => "Quản lý truy cập vào máy chủ",
    'plesk_key__traffic_reports' => "Báo cáo lưu lượng truy cập",
    'plesk_key__tts' => "Bàn Trợ Giúp",
    'plesk_key__virtuozzo' => "Chỉ phù hợp cho bộ chứa Virtuozzo",
    'plesk_key__webusers' => "Người dùng Web",
    'plesk_key__license_update_date' => 'Cập nhật mã bản quyền kế tiếp',
    'plesk_key__autoinstaller_config' => 'Khả năng quản lý thiết lập cập nhật',
    'plesk_key__check_wrong' => "Key bản quyền không hợp lệ. Để có thể sử dụng Plesk, vui lòng cài đặt key bản quyền hợp lệ mới.",
    'plesk_key__upload_check_wrong' => 'Mã bản quyền được tải lên không hợp lệ.',
    'plesk_key__revert_check_wrong' => 'Mã bản quyền được cài đặt trước đó không hợp lệ.',
    'plesk_key__update_check_wrong' => 'Mã bản quyền được cập nhật không hợp lệ.',
    'plesk_key__viruozzo_only_key' => 'Key bản quyền này chỉ dành cho Plesk vận hành trong bộ chứa Virtuozzo.',
    'plesk_key__ip_ranges_exceeded' => 'Bạn chỉ có thể sử dụng bản sao Plesk bản quyền này với các địa chỉ IP dưới đây: %2. Các địa chỉ IP sau không nằm trong giấy phép bản quyền của bạn: %1.', //%1 not allowed addresses list separated by comma, %2 allowed IP addresses list separated by comma
    'plesk_key__limits_exceeded' => 'Số lượng tài nguyên hiện đang sử dụng vượt quá giới hạn được quy định bởi giấy phép của bạn.',
    'plesk_key__wp-toolkit-deluxe' => 'WP Toolkit Deluxe',
    // For the keys below: %1 limit value, %2 used value, %3 delta value
    'plesk_key__limits_exceeded_lim_dom' => 'Số lượng các trang web được lưu trữ trên máy chủ vượt quá giới hạn được xác định theo bản quyền của bạn. Bạn có %2 trang web được lưu trữ, bản quyền của bạn chỉ cho phép lưu trữ %1 trang web.',
    'plesk_key__limits_exceeded_lim_domain_aliases' => 'Số lượng các bí danh tên miền được phục vụ đã vượt quá giới hạn được xác định theo bản quyền của bạn. Bạn có %2 bí danh tên miền hiện đang được phục vụ, bản quyền của bạn chỉ cho phép %1 bí danh tên miền.',
    'plesk_key__limits_exceeded_lim_cl' => 'Số lượng các tài khoản khách hàng được phục vụ đã vượt quá giới hạn được xác định theo bản quyền của bạn. Bạn có %2 tài khoản khách hàng hiện đang được phục vụ, bản quyền của bạn chỉ cho phép phục vụ %1 tài khoản khách hàng.',
    'plesk_key__limits_exceeded_lim_mn' => 'Số lượng các tài khoản email được phục vụ đã vượt quá giới hạn quy định theo giấy phép của bạn. Bạn có %2 tài khoản email hiện đang được cấp dịch vụ, bản quyền của bạn chỉ cho phép phục vụ %1 tài khoản email.',
    'plesk_key__limits_exceeded_lim_wu' => 'Số lượng các tài khoản người dùng web được phục vụ đã vượt quá giới hạn được xác định theo bản quyền của bạn. Bạn có %2 tài khoản người dùng web hiện đang được phục vụ, bản quyền của bạn chỉ cho phép phục vụ %1 tài khoản người dùng web.',
    'plesk_key__limits_exceeded_MLS' => 'Số lượng hiện tại của các gói ngôn ngữ được cài đặt đã vượt quá giới hạn được xác định bởi bản quyền của bạn. Hiện có %2 gói ngôn ngữ được cài đặt; bản quyền của bạn chỉ cho phép cài đặt %1 gói ngôn ngữ.',
    'plesk_key__wrong_version' => 'Bạn đang cố sử dụng key bản quyền được tạo cho phiên bản Plesk khác. Hãy liên lạc với đại diện bán hàng Plesk để có được key bản quyền phù hợp.',
    'plesk_key__other_product' => 'Bạn đang cố sử dụng key bản quyền được tạo cho sản phẩm khác. Hãy liên lạc với đại diện bán hàng Plesk để có được key bản quyền phù hợp.',
    'plesk_key__invalid_machine_id_trial' => 'Bản quyền hiện tại của bạn không hợp lệ vì đã được kích hoạt trên một máy chủ Plesk khác. Để tiếp tục sử dụng Plesk, hãy cài đặt bản quyền mới hoặc cài đặt lại bản quyền hiện tại của bạn bằng cách nhập mã kích hoạt (nếu bạn có).',
    'plesk_key__invalid_machine_id_retail' => 'Bản quyền hiện tại của bạn không hợp lệ vì đã được kích hoạt trên một máy chủ Plesk khác. Plesk EULA (https://www.plesk.com/legal/) cấm sử dụng một bản quyền trên hai hoặc nhiều máy chủ cùng một lúc. Để tiếp tục sử dụng Plesk, hãy cài đặt bản quyền mới hoặc cài đặt lại bản quyền hiện tại của bạn bằng cách nhập mã kích hoạt. Mã đã được gửi cho bạn qua email khi bạn mua bản quyền. <br>Không thể tìm thấy mã kích hoạt? Bạn có thể lấy mã bằng Plesk 360. Để làm như vậy, hãy đăng nhập vào https://platform360.io/ bằng email bạn đã sử dụng để mua bản quyền, chuyển đến tab "Licenses" và xem mã kích hoạt bản quyền của bạn. Hoặc bạn có thể liên hệ với bộ phận hỗ trợ Mua hàng và Bản quyền Plesk bằng biểu mẫu trực tuyến (https://www.plesk.com/licensing-and-purchase-support/). Hãy nhớ đề cập đến số bản quyền của bạn trong phần "How can we help you?" của biểu mẫu.',
    'plesk_key__limits_exceeded_error' => 'Không thể cài đặt key bản quyền: số tài nguyên đang sử dụng vượt quá giới hạn quy định đối với key bản quyền.',
    'plesk_key__limits_exceeded_note' => 'Số tài nguyên đang sử dụng vượt quá giới hạn quy định đối với key bản quyền đã tải lên.',
    'plesk_key__key_file_invalid' => 'Tập tin được tải lên không hợp lệ hoặc không chứa một mã bản quyền.',
    'plesk_key__server_request_error' => 'Không thể cập nhật giấy phép. Đảm bảo rằng kết nối đến máy chủ cấp phép ka.plesk.com trên cổng TCP %1 không bị chặn. <a href="https://support.plesk.com/hc/en-us/articles/12388137260695" target="_blank">Tham khảo cách thực hiện việc này</a>.',
    'key__no_key_file_in_zip' => 'Tập tin .zip được tải lên không chứa mã bản quyền',
    'key__key_upload' => 'Cài đặt mã bản quyền',
    'additional_key__prop_name' => 'Thuộc tính',
    'additional_key__prop_value' => 'Giá trị',
    'additional_key__descr_name' => 'Tên mã',
    'additional_key__descr_key_number' => 'Số mã',
    'additional_key__descr_key_vz' => "Key bản quyền này chỉ để sử dụng trong các bộ chứa Virtuozzo.",
    'additional_key__descr_key_mailboxes' => 'Hòm thư',
    'additional_key__descr_lim_date' => 'Ngày hết hạn',
    'additional_key__descr_license_update_date' => 'Cập nhật mã bản quyền kế tiếp',
    'additional_key__file_invalid' => 'Tập tin được tải lên không hợp lệ hoặc không chứa một mã bản quyền.',
    'additional_key__file_incompatible' => 'Tập tin được tải lên không hợp lệ cho các ứng dụng này.',
    'additional_key__expired' => 'Mã bản quyền này đã hết hạn.',
    'additional_key__not_exists' => 'Không có mã bản quyền được cài đặt.',
    'additional_key__viruozzo_only_key' => 'Key bản quyền này chỉ để sử dụng với Plesk được cài đặt trong các bộ chứa Virtuozzo.',
    'additional_key_update__result_response' => 'Phản hồi của máy chủ cấp bản quyền: %1',
    'additional_key_update__result_network' => 'Không thể kết nối đến máy chủ cấp bản quyền. Hãy đảm bảo rằng mạng của bạn cho phép kết nối tới %1: %2.',
    'additional_key_update__result_lock' => 'Cấp nhật mã đã trong tiến trình thực hiện',
    'additional_key_update__result_internal_error' => 'Lỗi xảy ra trong khi đang cập nhật mã bản quyền: %1',

    'proceed_to_cl_pool' => "Tiếp tục cấu hình dãy IP của khách hàng",
    'proceed_to_hosting_setup' => "Tiến hành thiết lập lưu trữ",
    'removeCerts__remove_certificates_cp' => "Những chứng chỉ sau đây sẽ được gỡ bỏ:",
    'removeCerts__remove_certificates_domain' => "Những chứng chỉ sau thuộc sở hữu bởi %1 sẽ được gỡ bỏ:",
    'removeClientsIP_remove_clients_ip' => "Địa chỉ IP này sẽ được gỡ bỏ khỏi dãy IP của các khách hàng sau đây:",
    'removeMailAliases__remove_mail_aliases' => "Những bí danh thuộc tài khoản thư sau %1 sẽ được gỡ bỏ:",
    'removeMailNames__remove_mailnames' => "Những bí danh và tài khoản thư sau sẽ được gỡ khỏi tên miền %1:",
    'removeMailNames__remove_mailnames_of_cl' => "Các tài khoản thư và bí danh sau đây sẽ bị gỡ bỏ ra khỏi tên miền %2 thuộc sở hữu của khách hàng %1:",
    'removeMailNames__these_mailnames_will_not_delete' => "Các tài khoản thư này sẽ không được xóa.",
    'removeFtpSessions__remove_title' => "Những phiên FTP sau đây sẽ được kết thúc:",
    'removeTemplates__remove_templates' => "Những bản mẫu sau sẽ được gỡ bỏ:",
    'resp_edit__always_respond' => "luôn luôn phản hồi",
    'resp_edit__reply_subject' => "Trả lời chủ đề",
    'resp_edit__answer_subject' => "Trả lời theo chủ đề",
    'resp_edit__answer_txt' => "Trả lời với văn bản",
    'resp_edit__attach' => "Đính kèm các tập tin",
    'resp_edit__default_subject' => "Trả lời: %1",
    'resp_edit__for' => "cho",
    'resp_edit__frw_rqst_email' => "Khi có phản hồi tự động, chuyển tiếp tin nhắn gốc đến email đã chỉ định",
    'resp_edit__fwd_email_invalid' => "Địa chỉ email đích không hợp lệ.",
    'resp_edit__in_body' => "khi các từ đã xác định được tìm thấy trong nội dung tin nhắn",
    'resp_edit__in_subject' => "Khi các từ đã xác định được tìm thấy trong chủ đề tin nhắn",
    'resp_edit__invalid_resp_freq' => "Tần số phản hồi không hợp lệ.",
    'resp_edit__invalid_rqst_txt' => "Văn bản yêu cầu không hợp lệ.",
    'resp_edit__invalid_store_lim_num' => "Giá trị giới hạn không hợp lệ.",
    'resp_edit__limits_title' => "Các giới hạn",
    'resp_edit__maximum_allowed_resp_freq_reached' => "Số lượng tối đa hồi đáp mỗi ngày vượt quá tỷ lệ được xác định. Được cho phép: %1, được yêu cầu: %2",
    'resp_edit__no_files_sel' => "Không có tập tin nào được chọn.",
    'resp_edit__no_txt_supplied' => "Không có văn bản nào được cung cấp.",
    'resp_edit__reply_title' => "Trả lời",
    'resp_edit__reply_to_address' => "Địa chỉ trả lời",
    'resp_edit__reply_to_invalid' => "Địa chỉ trả lời không hợp lệ.",
    'resp_edit__reply_uniq_email' => "Phản hồi địa chỉ email duy nhất không quá",
    'resp_edit__conditions_title' => "Điều kiện",
    'resp_edit__request_title' => "Yêu cầu",
    'resp_edit__resp' => "Trả lời tự động",
    'resp_edit__resp_name' => "Tên trả lời tự động",
    'resp_edit__resp_not_exist' => "Trả lời tự động không tồn tại.",
    'resp_edit__resp_status' => "Trạng thái trả lời tự động",
    'resp_edit__rqst_txt' => 'Chỉ định các điều kiện để trả lời này được gửi tự động',
    'resp_edit__select_files_on_server_for_attach' => "Chọn các tập tin mà bạn muốn đính kèm",
    'resp_edit__store_up_to' => "Lưu trữ tại",
    'resp_edit__subj_line_invalid' => "Dòng tiêu đề không chính xác.",
    'resp_edit__text_too_big' => "Văn bản tin nhắn trả lời quá lớn.",
    'resp_edit__times_in_a_day' => "Múi giờlần một ngày.",
    'resp_edit__unable_define_resp_cond' => "Không thể xác định điều kiện cho bộ trả lời tự động: %1",
    'resp_edit__unable_define_resp_status' => "Không thể xác định trạng thái của bộ trả lời tự động: %1",
    'resp_edit__unable_turn_on_resp' => "Không thể bật trả lời tự động: %1",
    'resp_edit__uniq_email' => "địa chỉ email duy nhất",
    'resp_edit__content_type' => 'Định dạng thư gửi đi',
    'resp_edit__content_type_text' => 'Văn bản thuần túy',
    'resp_edit__content_type_html' => 'HTML',
    'resp_edit__charset' => 'Đang mã hóa',
    'restart__dns' => 'Máy chủ DNS (%1)',
    'restart__drweb' => 'Plesk Premium Antivirus',
    'restart__mail' => "Máy chủ IMAP/POP3 (%1)",
    'restart__mssql' => "Máy chủ Microsoft SQL",
    'restart__mysql' => "Máy chủ MySQL",
    'restart__postgresql' => "PostgreSQL",
    'restart__psa' => "Dịch vụ",
    'restart__smtp' => "Máy chủ SMTP (%1)",
    'restart__spamd' => "Bộ lọc thư rác",
    'restart__spamassassin' => "SpamAssassin",
    'restart__stunnel' => "Stunnel",
    'restart__web' => "Máy chủ Web (%1)",
    'restart__ftp' => "Máy chủ FTP (%1)",
    'restart__service_start' => 'Hãy dành thời gian cho dịch vụ khởi động.',
    'restart__service_stop' => 'Hãy dành thời gian cho dịch vụ cho dừng lại.',
    'restart__service_restart' => 'Hãy dành thời gian cho dịch vụ khởi động lại.',
    'rm_domains__some_domains_are_not_exist' => "Một số tên miền chỉ định không tồn tại. Có thể chúng đã bị gỡ bỏ bởi người dùng khác.",
    'rpt_cl_dom_data_bases' => "CSDL MySQL",
    'rpt_cl_dom_mssql_data_bases' => "DBMSSQL",
    'rpt_cl_dom_mail_groups' => "Nhóm tin nhắn",
    'rpt_cl_dom_mail_lists' => "Danh sách gửi thư",
    'rpt_cl_dom_mail_resps' => "Tất cả phản hồi",
    'rpt_cl_dom_mail_antispam' => "Trình lọc thư rác",
    'rpt_cl_dom_mail_antivirus' => "Chống virus",
    'rpt_cl_dom_postboxes' => "Hộp thư",
    'rpt_cl_dom_redirects' => "Bộ chuyển hướng",
    'rpt_cl_dom_subdomains' => "Tên miền thứ cấp",
    'rpt_cl_dom_domain_aliases' => "DAliases",
    'rpt_cl_dom_web_users' => "Người dùng web",
    'rpt_cl_report_for_admin__' => "Báo cáo cho quản trị viên %1",
    'rpt_cl_report_for_reseller__' => "Báo cáo cho đại lý %1",
    'rpt_cl_report_for_cl__' => "Báo cáo về khách hàng %1",
    'rpt_cl_section_domains' => "Các tên miền",
    'rpt_cl_section_full_domains' => "Các tên miền",
    'rpt_cl_section_general' => "Tổng quan",
    'rpt_create' => "Tạo báo cáo",
    'rpt_empty' => "Bản báo cáo nên có ít nhất một phần",
    'rpt_dom_report_for_dom__' => "Báo cáo tên miền cho %1",
    'rpt_dom_section_databases' => "Cơ sở dữ liệu",
    'rpt_dom_section_full_databases' => "Cơ sở dữ liệu",
    'rpt_dom_section_full_maillists' => "Các danh sách gửi thư",
    'rpt_dom_section_full_mailnames' => "Các tài khoản thư",
    'rpt_dom_section_full_webusers' => "Người dùng Web",
    'rpt_dom_section_full_siteapps' => 'Các ứng dụng web',
    'rpt_dom_section_full_aspnetapps' => 'Ứng dụng web ASP.NET',
    'rpt_dom_section_general' => "Tổng quan",
    'rpt_dom_section_hosting' => "Vùng lưu trữ",
    'rpt_dom_section_maillists' => "Các danh sách gửi thư",
    'rpt_dom_section_mailnames' => "Các tài khoản thư",
    'rpt_dom_section_siteapps' => 'Các ứng dụng web',
    'rpt_dom_section_aspnetapps' => 'Ứng dụng web ASP.NET',
    'rpt_dom_section_webusers' => "Người dùng Web",
    'rpt_dom_title_wa_status' => "S",
    'rpt_edit__' => "Hiệu chỉnh báo cáo %1",
    'rpt_enter_email_address' => "Nhập địa chỉ email cần chuyển báo cáo đến.",
    'rpt_list' => "Tùy chỉnh các mẫu báo cáo",
    'rpt_section_full' => "Đầy đủ",
    'rpt_section_none' => "Không",
    'rpt_section_summary' => "Tóm tắt",
    'rpt_default_full' => 'Báo cáo đầy đủ',
    'rpt_default_summary' => 'Báo cáo tóm tắt',

    // end of kooper part

    // pit part

    'rpt_send_report_by_email_error__' => "Lỗi gửi báo cáo: %1",
    'rpt_send_report_by_email_ok__' => "Báo cáo được gửi đến %1",
    'sa_action' => "Hành động",
    'sa_action_del' => "Xóa",
    'sa_action_desc' => "Làm gì với thư rác",
    'sa_action_save' => "Đánh dấu là thư rác và lưu trữ trong hộp thư",
    'sa_admin_blacklist' => "Danh sách từ chối của quản trị viên",
    'sa_admin_whitelist' => "Danh sách cho phép của quản trị viên",
    'sa_db_del_confirm' => "Bạn có chắc chắn muốn xóa các cơ sở dữ liệu Bộ lọc thư rác?",
    'sa_eml_in_ignorelist' => "Email có trong danh sách chặn",
    'sa_empty_email' => "Không thể thêm kiểu email trống.",
    'sa_exists_email' => "Kiểu email đã tồn tại.",
    'sa_disabled__mailname_not_filtering' => "Các thiết lập máy chủ hiện tại không cho phép sử dụng bộ lọc thư cho các tài khoản thư này",
    'sa_disabled__filtering_is_disabled' => 'Bộ lọc thư rác đã được tắt bởi quản trị viên',
    'sa_disabled__hasnt_mailbox' => "Không thể bật tính năng lọc thư rác mà không có hộp thư",
    'sa_enable_filter' => "Bật bộ lọc thư rác",
    'sa_forget' => "quên",
    'sa_from' => "Từ",
    'sa_ham' => "giả tạo",
    'sa_pattern_is_invalid' => "Từ khóa không hợp lệ.",
    'sa_spam' => "thư rác",
    'sa_trainer__page_title' => 'Huấn luyện bộ lọc thư rác',
    'sa_trainer__tools_legend' => 'Công cụ',
    'sa_trainer__info_legend' => 'Thông báo',
    'sa_trainer__messages_list_legend' => 'Các tin nhắn trong hộp thư của bạn',
    'sa_trainer__c' => 'T',
    'sa_trainer__l' => 'L',
    'sa_trainer__subject' => 'Chủ đề',
    'sa_trainer__from' => 'Từ',
    'sa_trainer__date' => 'Ngày',
    'sa_trainer__info_text' => 'Tin nhắn được nhận biết: %1 là thư rác, %2 không phải là thư rác, %3 tổng số.',
    'sa_trainer__messages' => '(các) tin nhắn',
    'sa_trainer__select__all' => 'Tất cả',
    'sa_trainer__select__spam_only' => 'Thư rác',
    'sa_trainer__select__ham_only' => 'Không phải là thư rác',
    'sa_trainer__select__unknown_only' => 'Vô danh',
    'sa_trainer__cannot_remove_messages' => 'Không thể gỡ bỏ các tin nhắn được lựa chọn từ hộp thư.',
    'sa_trainer__remove_messages_confirm' => 'Bạn có chắc chắn rằng bạn muốn xóa các tin nhắn được lựa chọn từ các hộp thư?',
    'sa_subj' => "Chủ đề",
    'sa_training' => "Huấn luyện bộ lọc thư rác",
    'sa_training_legend' => "Huấn luyện bộ lọc kiểu bayesian",
    'sa_use_srv_settings' => "Sử dụng cài đặt trên toàn máy chủ",
    'sa_user_blacklist' => "Danh sách từ chối của người dùng",
    'sa_user_whitelist' => "Danh sách cho phép của người dùng",
    'sa_usr_disabled_by_srv' => "Các thiết lập bộ lọc thư rác cá nhân không được phép bởi quản trị viên",
    'sa_usr_no_postbox' => "Không thể bật tính năng lọc thư rác vì hộp thư đã được tắt cho tài khoản email này.",
    'sa_filters' => 'Bộ lọc thư rác',
    'spamfilter__tools_legend' => 'Công cụ',
    'spamfilter__prefs_legend' => 'Cài đặt',
    'spamfilter__max_children' => 'Số lượng tối đa của quy trình spamd hoạt động cần chạy',
    'spamfilter__rewrite_header_subject_hint' => 'Bỏ trống trường này nếu bạn không muốn thêm bất kỳ văn bản. Loại _SCORE_ nếu bạn muốn thêm điểm số vào tiêu đề tin nhắn.',
    'spamfilter__reject_spam' => 'Xóa thư rác khi nó đến hộp thư',
    'spamfilter__enabled' => 'Bật',
    'spamfilter_addresses_list__items' => 'địa chỉ',
    'spamfilter_addresses__remove_title' => 'Các địa chỉ sau sẽ được gỡ bỏ khỏi danh sách:',
    'spamfilter_addresses__empty_selection' => 'Không có địa chỉ nào được chọn.',
    'server__admin_info' => "Thông tin người quản trị",
    'server__ctrl_panel' => "Plesk",
    'server__enter_bug_essence_below' => "Nhập các mô tả lỗi dưới đây",
    'server__power_management' => "Quản lý nguồn điện năng",
    'server__services' => "Dịch vụ",
    'server__system' => "Hệ thống",
    'server__title' => "Quản trị máy chủ",
    'server_preferences__admin_skin' => "Hình nền giao diện của quản trị viên",
    'server_preferences__default_language' => "Ngôn ngữ mặc định",
    'server_preferences__default_skin' => "Hình nền mặc định",
    'server_preferences__restart_apache_interval' => "Khoảng thời gian khởi động lại Apache",
    'server_preferences__system' => 'Cài đặt hệ thống',
    'mail__tabs_preferences' => "Cài đặt",
    'mail__tabs_white_list' => "Danh sách cho phép",
    'server_preferences__use_vocabulary' => "Kiểm tra mật khẩu cho các hộp thư trong từ điển",
    'sessions__agreement' => "Có, tôi muốn kết thúc các phiên kết nối này.",
    'sessions__select_sessions_for_remove' => "Chọn các phiên kết nối sẽ được kết thúc.",
    'sessions__tabs_cp_sessions' => 'Các phiên Plesk',
    'sessions__tabs_ftp_sessions' => 'Phiên kết nối FTP',
    'sessions__ftp_sessions_login' => 'Tên đăng nhập của người dùng FTP',
    'sessions__ftp_sessions_domain' => 'Tên miền',
    'sessions__ftp_sessions_path' => 'Vị trí hiện tại',
    'sessions__ftp_sessions_file' => 'Tên tập tin',
    'sessions__ftp_sessions_action' => 'Trạng thái',
    'sessions__ftp_sessions_speed' => 'Tốc độ, KB/S',
    'sessions__ftp_sessions_comp' => 'Tiến trình, %',

    'site_apps__access_level' => 'Cấp độ truy cập',
    'site_apps__access_level_commercial' => 'Thương mại',
    'site_apps__access_level_free' => 'Miễn phí',
    'site_apps__action_installer' => "Cài đặt ứng dụng web",
    'site_apps__action_reconfigure' => "Cấu hình lại ứng dụng web",
    'site_apps__custom_button_level' => 'Bạn có muốn tạo một nút tùy chỉnh biến để truy cập ứng dụng này không?',
    'site_apps__custom_button_level_false_domain_user_only' => 'Không',
    'site_apps__custom_button_level_domain_user_only' => 'Có',
    'site_apps__custom_button_level_false' => 'Không',
    'site_apps__custom_button_level_domain' => 'Có, và làm cho nó có hiệu lực chỉ cho tên miền hiện tại',
    'site_apps__custom_button_level_client' => 'Có, và làm cho nó có hiệu lực cho tất cả các tên miền của khách hàng',
    'site_apps__custom_button_level_admin' => 'Có, và làm cho nó có hiệu lực cho tất cả các tên miền',
    'site_apps__description' => "Mô tả",
    'site_apps__dir_used_by_sapp__' => "Thư mục \"%1\" được sử dụng bởi một ứng dụng web khác",
    'site_apps__dir_used_by_unknown__' => "Thư mục \"%1\" đã tồn tại. Nội dung của nó sẽ bị ghi đè nếu bạn thực thi.",
    'site_apps__dir_invalid_name__' => "Tên thư mục %1 không chính xác",
    'site_apps__file_name' => 'Tên tập tin ứng dụng web',
    'site_apps__invalid_install_prefix' => "Tiền tố cài đặt không hợp lệ",
    'site_apps__invalid_package' => "ứng dụng web không hợp lệ",
    'site_apps__key_status' => 'Cấp bản quyền',
    'site_apps__key_status_free' => 'Bản phân phối miển phí. Không yêu cầu mã bản quyền',
    'site_apps__key_status_ok' => 'Mã bản quyền yêu cầu đã được cài đặt',
    'site_apps__key_status_problem' => 'Mã bản quyền yêu cầu đã được cài đặt',
    'site_apps__name' => "Tên",
    'site_apps__no_domains' => 'ứng dụng web không thể được cài đặt. Có một ứng dụng web khác đã được cài đặt trong thư mục gốc của tên miền này. Xem xét việc tạo ra một tên miền con cho ứng dụng web.',
    'site_apps__package_info_' => "Thông tin ứng dụng web",
    'site_apps__package_integrated' => "ứng dụng đã được tích hợp sẵn, không thể bị gỡ bỏ",
    'site_apps__pool_select_packages_to_add' => 'Chọn các ứng dụng web để bổ sung vào kho ứng dụng',
    'site_apps__release' => "Phát hành",
    'site_apps__resource_used_by_sapp' => "Tài nguyên này được sử dụng bởi ứng dụng web đã được cài đặt",
    'site_apps__root_used_by_sapp' => "Tài nguyên này được sử dụng bởi một ứng dụng web đã được cài đặt",
    'site_apps__these_domains_will_not_delete' => 'Những tên miền (thứ cấp) này sẽ không bị xóa',
    'site_apps__upload_site_app_pkg_title' => 'Tải lên ứng dụng web mới',
    'site_apps__version' => "Phiên bản",
    'site_apps__access_to' => "Truy cập %1",
    'site_builder_requires' => '%1 - %3',
    'skeleton__admin_label' => "Biểu mẫu máy chủ ảo",
    'skeleton__client_label' => "Mẫu lưu trữ ảo %1",
    'skeleton__admin_page' => "Quản lý Mẫu Lưu trữ ảo",
    'skeleton__files_list' => "Tập tin và thư mục",
    'skeleton__archiver_not_installed' => "Không thể bung tập tin nén. Tính năng đóng gói không được cài đặt trên máy chủ. Liên lạc với quản trị viên {$PROD_NAME} để cài đặt phần mềm đóng gói.",
    'skeleton__client_page' => "Quản lý Mẫu Lưu trữ ảo",
    'skeleton__archive_corrupted' => "Kiểm tra tập tin nén để phát hiện ra các tập tin bị hỏng hoặc loại tập tin nén này không được hỗ trợ.",
    'skeleton__archive_too_large' => "Kiểm tra tập tin nén để phát hiện ra các tập tin là quá lớn.",
    'skeleton__not_supported_archive_type' => "Kiểu của tập tin nén này (tập tin %1) không được hỗ trợ.",
    'skeleton__upload_archive_file' => "Tải lên tập tin nén",
    'skin_download__title' => 'Tải hình nền xuống',
    'skin_download_now__title' => 'Tiến trình tải hình nền xuống đang diễn ra',
    'skin_download_now__text' => 'Đang tạo gói giao diện nền.<br>Quá trình này cần một khoảng thời gian.<br>Khi cửa sổ đối thoại xuất hiện, bạn có thể tiếp tục làm việc với Plesk.',
    'skin_file__help_for_using_types' => "Hãy sử dụng kiểu gói hình nền thuộc một trong các định dạng sau đây:",
    'skin_info__title' => 'Các thuộc tính hình nền',
    'skin_mng_err__rpm_not_skin' => 'RPM này không phải là một gói giao diện nền',
    'skin_mng_err__psa_install_noreloc' => 'Lỗi khi cài đặt gói hình nền định dạng rpm tại vị trí được chỉ định.',
    'skin_mng_err__already_exists' => 'Thư mục cài đặt hình nền đã tồn tại, và đã có một gói hình nền được triển khai.',
    'skin_mng_err__rpm_upgrade_nonrpm' => 'Tập tin được tải lên không phải là một gói hình nền định dạng RPM hợp lệ.',
    'skin_mng_err__rpm_upgrade_noskin' => 'Tập tin được tải lên không phải là một gói hình nền hợp lệ.',
    'skin_mng_err__rpm_upgrade_base' => "Tập tin được tải lên không phải là một gói hình nền {$PROD_NAME} hợp lệ.",
    'skin_mng_err__rpm_upgrade_other' => 'Không thể cài đặt hình nền: định dạng hình nền không hợp lệ.',
    'skin_mng_err__no_a_skin' => "Tập tin được tải lên không phải là một gói hình nền {$PROD_NAME} hợp lệ.",
    'skin_upload__title' => 'Tải lên hình nền mới',
    'skin_upload__already_exists' => "Hình nền '%1' đã tồn tại.",
    'skin_upload__unable_to_apply' => "Tập tin đã tải lên không chứa giao diện nền Plesk, hoặc định dạng lưu không được hỗ trợ.",
    'skin_upload__unable_to_rename__' => "Không thể đổi tên bộ hình nền %2 thành %1: %3.",
    'skin_upload__file_name' => 'Đường dẫn đến gói tập tin hình nền',
    'skins_list__title' => 'Kho lưu trữ hình nền',
    'skins_remove__title' => 'Gỡ bỏ hình nền',
    'skins_remove__select_skins_for_remove' => 'Chọn các hình nền để gỡ bỏ',

    'spf__unable_update' => 'Không thể cập nhật các thông số SPF',
    'statistics__active_domains' => "Tên miền đang hoạt động",
    'statistics__clients' => "Khách hàng",
    'statistics__subdomains' => "Tên miền phụ",
    'statistics__cpu' => "CPU",
    'statistics__databases' => "Cơ sở dữ liệu",
    'statistics__db_users' => "Người dùng cơ sở dữ liệu",
    'statistics__dirs' => "Các thư mục được bảo vệ",
    'statistics__dom_active' => "Hiện hoạt",
    'statistics__dom_passive' => "Bị động",
    'statistics__dom_problem' => "Sự cố",
    'statistics__domains' => "Các tên miền",
    'statistics__domains_with_host' => "Tên miền với cấu hình lưu trữ",
    'statistics__doms' => "Tên miền",
    'statistics__filesystem' => "Hệ thống tập tin",
    'statistics__general' => "Tổng quan",
    'statistics__hdd_available' => "Sẵn dùng",
    'statistics__hdd_capacity' => "Dung lượng",
    'statistics__hdd_total' => "Tổng",
    'statistics__hdd_usage' => "Tình trạng sử dụng ổ cứng",
    'statistics__hdd_used' => "Đã sử dụng",
    'statistics__ip' => "Địa chỉ IP",
    'statistics__key_number' => "Số mã",
    'statistics__l1' => "1 phút gần nhất",
    'statistics__l15' => "15 phút gần nhất",
    'statistics__l5' => "5 phút gần nhất",
    'statistics__la' => "Tình trạng sử dụng CPU",
    'statistics__mail_autoresponders' => "Trả lời tự động",
    'statistics__mail_boxes' => "Hòm thư",
    'statistics__mail_groups' => "Các nhóm thư",
    'statistics__mail_lists' => "Các danh sách gửi thư",
    'statistics__mail_redirects' => "Chuyển tiếp thư",
    'statistics__mem' => "Tình trạng sử dụng bộ nhớ",
    'statistics__mem_usage' => "Tình trạng sử dụng",
    'statistics__memory_available' => "Sẵn dùng",
    'statistics__memory_buffer' => "Bộ đệm",
    'statistics__memory_cached' => "Lưu tạm",
    'statistics__memory_free' => "Miễn phí",
    'statistics__memory_shared' => "chia sẻ",
    'statistics__memory_total' => "Tổng",
    'statistics__memory_used' => "Đã sử dụng",
    'statistics__os' => "HĐH",
    'statistics__problem_clients' => "Vấn đề của khách hàng",
    'statistics__problem_domains' => "Vấn đề của tên miền",
    'statistics__swap' => "Tình trạng sử dụng hoán đổi",
    'statistics__swap_free' => "Miễn phí",
    'statistics__swap_total' => "Tổng",
    'statistics__swap_usage' => "Tình trạng sử dụng",
    'statistics__swap_used' => "Đã sử dụng",
    'statistics__system_stat' => "Thông tin máy chủ",
    'statistics__unable_define_active_doms' => "Không thể xác định số lượng các tên miền hoạt động: %1",
    'statistics__unable_define_inactive_doms' => "Không thể xác định số lượng các tên miền không hoạt động: %1",
    'statistics__failed_define_swap_usage' => 'Xác định Tình trạng sử dụng hoán đổi không thành công',
    'statistics__failed_define_load_averages' => 'Xác định Mức tải trung bình không thành công',
    'statistics__up_time' => "Thời gian hoạt động của hệ thống:",
    'statistics__ver' => "Phiên bản",
    'statistics__web_users' => "Người dùng Web",
    'statistics__mem_win' => "Tình Trạng Sử Dụng Bộ Nhớ Vật Lý",
    'statistics__memory_total_win' => "Tổng",
    'statistics__memory_used_win' => "Đã sử dụng",
    'statistics__memory_free_win' => "Sẵn dùng",
    'statistics__swap_win' => "Tình Trạng Sử Dụng Bộ Nhớ Ảo",
    'statistics__swap_total_win' => "Tổng",
    'statistics__swap_used_win' => "Đã sử dụng",
    'statistics__swap_free_win' => "Sẵn dùng",
    'status__domain_has_reasons_to_be_off' => "Tên miền này vẫn bị tạm ngưng vì lý do sau: %1",
    'subdomain__create__' => "Tạo một tên miền con trong miền %1",
    'subdomain__edit__' => "Quản lý các tên miền con %1",
    'subdomain__invalid_name' => "Tên miền con không hợp lệ: chỉ sử dụng các ký tự chữ cái và dấu gạch ngang.",
    'subdomain__incorrect_name' => "Tên miền con có tên không hợp lệ.",
    'subdomains__maillists_enabled_in_domain' => "Danh sách các tên miền con không chính xác.%1: Tên miền này đã được sử dụng bởi các danh sách gửi thư dưới tên miền %1.",
    'subdomains__dalias_exists' => 'Bí danh miền có tên này đã tồn tại.',
    'subdomains__name_exists' => "Tên miền phụ này đã tồn tại.",
    'subdomains__regular_domain_exists' => "Tên miền này đã tồn tại.",
    'subdomains__domain_alias_exists' => 'Bí danh miền có tên này đã tồn tại.',
    'subdomains__remove_subdomains_on_domain' => "Những tên miền con sau thuộc tên miền %1 sẽ được gỡ bỏ:",
    'subdomains__select_subdomains_for_remove' => "Chọn tên miền con sẽ được gỡ bỏ.",
    'subdomains__webmail_enabled_in_domain' => "Webmail tên miền phụ không chính xác.%1: Tên miền này đã được sử dụng để truy cập vào webmail dưới tên miền %1.",
    'subdomains__dns_record_already_exists' => 'Không thể tạo các tên miền con %1, vì đã có một bản ghi DNS trỏ đến máy chủ %1.',
    'subdomains__www_prefix_in_domain' => "Tên miền con www.%1 không chính xác: tên miền %1 đã có tiền tố WWW.",
    'subdomains__user_type_quota_exceeds' => 'Không thể thay đổi tài khoản người dùng bởi vì điều này sẽ dẫn đến vượt quá không gian đĩa được phân bổ.',
    'subdomains__creation_in_dns_slave' => "Máy chủ tên của Plesk đang đóng vai trò là máy chủ tên phụ cho miền này. Để tên miền phụ của bạn có thể phân giải chuẩn, đảm bảo rằng tập tin vùng trên máy chủ DNS chính có chứa bản ghi %1.",
    'sys_user__attributes_not_changed' => "\nNhững thuộc tính người dùng hệ thống sau không được thay đổi: %1",
    'sys_user__no_access_without_password' => "Bạn đã không đặt mật khẩu. Người dùng hệ thống này sẽ được tạo ra, nhưng sẽ không thể đăng nhập vào hệ thống, cho đến khi được đặt một mật khẩu. Bạn có muốn tiến hành không?",
    'sys_user__no_hard_quota' => "Không được hỗ trợ",
    'sysuser__zero_quota_is_unlimited' => "0 cho không giới hạn",
    'template__num_excl_ips' => "Phân bổ các địa chỉ IP chuyên dụng cho khách hàng",
    'template__sel_sh_ips' => "Các địa chỉ IP chia sẻ được chọn",
    'template__av_sh_ips' => "Các địa chỉ IP được chia sẻ chưa sử dụng",
    'template__up_to_excl_ip' => "Lên tới %1 địa chỉ IP",
    'templates__all_clients' => "Tất cả các khách hàng",
    'templates__cl_domain_templates' => "Các mẫu cho %1",
    'templates__cl_templates' => "Mẫu khách hàng",
    'time__invalid_ip' => "Địa chỉ IP hoặc tên miền không hợp lệ.",
    '__please_select_country' => 'Hãy chọn quốc gia của bạn',
    'time__unable_set_time' => "Không thể thiết lập thời gian hệ thống: %1",
    'time__sinchronization_setup_error' => 'Không thể thiết lập đồng bộ thời gian: chọn thời gian không thành công: %1',
    'time__sinchronization_disable_error' => 'Không thể tắt đồng bộ thời gian: chọn thời gian không thành công: %1',
    'tmpl__create' => "Tạo mẫu",
    'tmpl__edit__' => 'Mẫu %1',
    'tmpl__logrotation_warn' => "Luân chuyển nhật ký của tên miền được tạo ra bởi mẫu này sẽ chỉ được thực hiện trong trường hợp tạo tài khoản lưu trữ vật lý cho nó.",
    'tmpl__name' => "Tên mẫu",
    'tmpl__dom_exist' => "Biểu mẫu miền có tên này đã tồn tại trong dãy biểu mẫu của quản trị viên hoặc khách hàng.",
    'tmpl__name_invalid' => "Tên mẫu không hợp lệ hoặc trống.",
    'tmpl__use_next_ip_addr' => "Địa chỉ IP chưa được sử dụng sau đây sẽ được sử dụng",
    'tmpl_name_already_exists' => "Mẫu với tên '%1' đã tồn tại.",
    'traffic__no_periods_found' => "Không thể hiển thị số liệu thống kê lưu lượng và web. Chức năng này chỉ áp dụng sau lần tính toán số liệu kế tiếp.",

    'vh_based__no_free_ip_for_vh' => "Không có địa chỉ IP trống cho lưu trữ ảo dựa trên IP. Hãy thêm một địa chỉ IP.",

    'wu__at_domains_text' => "Cho phép định dạng truy cập webuser@%1",
    'wu__unable_create' => "Không thể tạo người dùng Web: %1",
    'wu_edit__disk_quota' => "Hạn ngạch đĩa",
    'wu_edit__invalid_pass' => "Mật khẩu không hợp lệ.",
    'wu_edit__invalid_quota' => "Các quy định hạn ngạch dung lượng đĩa có giá trị không hợp lệ. Hãy hãy nhập một số nguyên dương.",
    'wu_edit__invalid_quota_value' => "Giới hạn dung lượng đĩa nhỏ hơn mức hiện tại sử dụng (%1MB). Một số chức năng có thể trở nên không sử dụng được. Bạn có chắc bạn muốn tiếp tục?",
    'wu_edit__not_create_pass' => "Hành động này sẽ không tạo ra một mật khẩu mới cho các người dùng web.\nKhông có mật khẩu người dùng sẽ không thể đăng nhập.",
    'wu_edit__unable_update' => "Không thể cập nhật các thuộc tính người dùng web: %1",

    'bt_webdirs' => 'Thư mục ảo',

    'dns__tabs_general' => 'Thiết lập Vùng',
    'dns__tabs_zone_settings' => 'Bản ghi SOA',
    'soa__seconds' => 'giây',
    'soa__minutes' => 'phút',
    'soa__hours' => 'giờ',
    'soa__days' => 'Ngày',

    'DomainSubdirectory' => 'Thư mục con đích',

    'filemanager__select_codepage' => 'Chọn Bảng mã:',

    'bt_server_app_add' => 'Thêm ứng dụng máy chủ',
    'packages_list' => 'Các Ứng Dụng Máy Chủ',

    'bt_packages_management' => 'Quản lý gói',
    'pb__packages_management' => 'Quản Lý Ứng Dụng',
    'bt_package_new' => 'Thêm ứng dụng',
    '__packages' => 'Các Ứng Dụng Máy Chủ',

    'dom_ctrl__mysql_dbase_space' => 'Tổng hạn ngạch cơ sở dữ liệu MySQL',
    'dom_ctrl__mssql_dbase_space' => 'Tổng hạn ngạch cơ sở dữ liệu MS SQL',

    'dns_add__enter_ixfr_path' => 'Nhập đường dẫn IXFR',

    'cmd_dns__txt_dns_record_already_exist' => 'Bản ghi SPF TXT đã tồn tại. Chỉ có thể có một bản ghi SPF. Để thêm bản ghi, xóa các bản ghi hiện có trước.',

    'component_name__network' => 'Mạng',
    'component_name__sitebuilder' => 'Presence Builder',

    'bt_skin_set' => 'Cài đặt giao diện',
    'bt_set_skin' => 'Cài đặt giao diện',
    'firewall__rule_already_exists' => 'Quy tắc có tên "%1" đã tồn tại',
    'firewall__rule_readonly' => 'Quy tắc "%1" có định dạng chỉ đọc',
    'pb__firewall' => 'Tường lửa',

    '__webstat_smarterstats' => 'SmarterStats',

    'error_doc__erorr_invalid_file_location' => 'Vị trí tập tin không hợp lệ.',

    'error_doc__erorr_invalid_url_location' =>  'Sai định dạng URL. Xin vui lòng nhập một URL chính xác trên máy chủ (trang web).',

    'mn_list__tab_title_antivirus' => 'AV',

    'bt_antivirus' => 'Chống virus',
    'antivirus__antivirus' => 'Bảo vệ chống virus',
    'antivirus__antivirus_direction_off' => 'Tắt',
    'antivirus__antivirus_direction_any' => 'Thư đến và thư đi',
    'antivirus__antivirus_direction_from' => 'Chỉ thư đi',
    'antivirus__antivirus_direction_to' => 'Chỉ thư đến',
    'antivirus__unable_to_update_settings' => 'Không thể thay đổi cài đặt chống virus: %1',




    '__normal' => 'Bình thường',
    '__low' => 'Thấp',
    '__high' => 'Cao',

    'mail__antivirus' => "Chống virus bên trong máy chủ thư",
    'mail__use_internal_antivirus' => 'Sử dụng chống virus nội bộ',

    'sa__tabs_blacklist' => 'Danh sách từ chối',

    '__mysql_databases' => 'Cơ sở dữ liệu MySQL',

    'cl_perm__mysql_dbase_space' => 'Tổng hạn ngạch cơ sở dữ liệu MySQL',
    'cl_perm__mssql_dbase_space' => 'Tổng hạn ngạch cơ sở dữ liệu MS SQL',
    'cl_perm__max_mssql_db' => 'Số lượng cơ sở dữ liệu tối đa của Microsoft SQL Server',
    'cl_perm__total_mboxes_quota' => 'Tổng số hạn ngạch hòm thư',

    'i_i_cl_on' => 'Tài khoản khách hàng đang hoạt động.',
    'i_i_cl_off_by_admin' => 'Tài khoản khách hàng đã bị tạm ngưng bởi quản trị viên.',

    'sa_exists_tn' => 'Mạng đã có trong danh sách.',

    'webdir__select_vdirs_to_remove' => 'Chọn thư mục bạn muốn gỡ bỏ',
    'webdir__select_mime_types_to_remove' => 'Chọn kiểu MIME bạn muốn xóa',

    'defaultcomponents__not_activated' => 'không được kích hoạt',

    'bt_traffic_at_domains' => 'Lưu lượng',

    '__awstats_perl_warning' => 'Nếu không có trình Perl được cài đặt, AWStats sẽ không cho phép người dùng kiểm tra số liệu thống kê các năm trước.',

    'class_client__mysql_dbase_space' => 'Giá trị vượt quá giới hạn của khách hàng.',
    'class_client__mssql_dbase_space' => 'Giá trị vượt quá giới hạn của khách hàng.',
    'class_client__max_mssql_db' => 'Giá trị vượt quá giới hạn của khách hàng.',

    'dns__remove_transfer_restrictions_list_items' => 'Các mạng sau đây sẽ được gỡ bỏ khỏi danh sách điều khiển truy cập:',

    'bt_up' => "Lên",
    'bt_down' => "Xuống",
    'virtualdir__type_default_doc_name_to_add' => 'Nhập tên tập tin để thêm vào danh sách',
    'virtualdir__select_default_doc_to_remove' => 'Chọn tập tin để gỡ bỏ khỏi danh sách',
    'virtualdir__select_directory' => 'Chọn một thư mục',

    'bt_install_selected' => 'Cài đặt những Mã Bản quyền được chọn', // SELECTED


    'dom_pref__the_domain_resolves_to_another_ip_address' => 'Tên miền phân giải thành địa chỉ IP khác: (%1). Xin vui lòng sửa các thiết lập DNS.',

    'mn_edit__mailbox_enable_if_mailgroup_enabled' => 'Các máy chủ thư hiện đang sử dụng không hỗ trợ bật cả hộp thư và nhóm thư cùng một lúc. Bấm Đồng ý để bật hộp thư và tắt nhóm thư. Nhấn Hủy để giữ nguyên trạng thái ban đầu.',

    'mn_edit__mailgroup_enable_if_mailbox_enabled' => 'Các máy chủ thư hiện đang sử dụng không hỗ trợ bật cả hộp thư và nhóm thư cùng một lúc. Bấm Đồng ý để bật nhóm thư và tắt hộp thư. Nhấn Hủy để giữ nguyên trạng thái ban đầu.',

    'mysql_dbase_space_limit' => 'Giới hạn không gian cơ sở dữ liệu MySQL',
    'mysql_dbase_usage' => 'Sử dụng không gian cơ sở dữ liệu MySQL',
    'mssql_dbase_space_limit' => 'Giới hạn không gian cơ sở dữ liệu Microsoft SQL Server',
    'mssql_dbase_usage' => 'Mức sử dụng không gian cơ sở dữ liệu Microsoft SQL Server',

    '__statistics' => "Thống kê", //indirect

    'dns__soa_minimum_value_is_big' => 'Thiết lập giá trị TTL tối thiểu sao cho chỉ với hơn 3 giờ có thể Cài đặt sao cho tên miền của bạn không truy cập được bởi một số các quản trị viên tên miền. Chúng tôi khuyến nghị thiết lập giá trị đó chỉ trong trường hợp bản đăng ký tên miền tên của bạn yêu cầu.',

    'virusfilter__interface_not_available' => 'Không có bộ lọc vi-rút nào.',
    'virusfilter__none_virus_filter' => 'Không',
    'virusfilter__mailname_status_text' => 'Chống virus (%1)',
    'virusfilter__status_none' => 'tắt',
    'virusfilter__status_any' => 'Thư đến và đi',
    'virusfilter__status_outgoing' => 'chỉ thư đi',
    'virusfilter__status_incoming' => 'chỉ thư đến',

    'visibility__root_override_parse_error' => 'Có một lỗi cú pháp trong tập tin %1 tại dòng %2.',

    'sb__not_support_publishing_api' => "Tính năng tự động xuất bản không được hỗ trợ bởi thành phần này",

    'component_name__cphosting' => "Lưu trữ Plesk",

    'dom_pref__unable_set_up_total_mboxes_quota' => 'Thiết lập hạn ngạch hộp thư không được hỗ trợ bởi máy chủ thư hiện tại.',
    '__unable_get_total_mboxes_quota' => 'Thiết lập hạn ngạch hộp thư không được hỗ trợ bởi máy chủ thư hiện tại.',

    'install_prefix__parent_not_exists' => "Thư mục cấp trên không tồn tại.",

    'bt_change_version' => 'Thay đổi phiên bản',
    'aspdotnet__changeversion_title' => 'Chọn Phiên bản ASP.NET',
    'pb__aspdotnet' => 'ASP.NET',

    '__check_all' => "Chọn tất cả",
    '__uncheck_all' => "Xóa tất cả",

    'dns__editing_domain_controller_zone' => "Chỉnh sửa bản ghi vùng DNS cho bộ điều khiển tên miền có thể gây ra các vấn đề về chức năng hoạt động của tên miền",

    'pb__interface_management' => "Quản Lý Giao Diện",
    'interface_management__tabs_skins' => "Các giao diện",
    'interface_management__tabs_interface_templates' => "Các mẫu giao diện",
    'interface_management__tabs_locales' => "Vùng ngôn ngữ",
    'locales_list__title' => "Kho lưu trữ các gói ngôn ngữ",
    'locales_list__legend' => "Ngôn ngữ hiện có",
    'locales_list__active_title' => "S",
    'locales_list__locale_title' => "Gói ngôn ngữ",
    'locales_list__lang_title' => "Ngôn ngữ",
    'locales_list__country_title' => "Quốc gia",
    'locales_list__used_title' => "Đã sử dụng",

    'backup__suspend_warning_during_backup' => "Tên miền sẽ không thể sử dụng trong suốt quá trình sao lưu",
    'backup__suspend_warning_during_restore' => "Tên miền sẽ không thể sử dụng trong suốt quá trình khôi phục",
    'backup__suspend_domain' => "Tạm dừng tên miền",

    'locales_list__mls_limit' => "Giấy phép Plesk hiện tại của bạn cho phép sử dụng %2 ngôn ngữ. Vào thời điểm hiện tại, bạn có %1 ngôn ngữ được cài đặt khả dụng cho người dùng, vượt quá số ngôn ngữ được quy định theo giấy phép. Vui lòng chọn %2 ngôn ngữ bạn muốn sử dụng, và hủy khả dụng các ngôn ngữ còn lại cho người dùng bằng cách nhấp vào các biểu tượng trong cột 'S'.",

    'bt_change_owner' => 'Gán chủ sở hữu mới',
    'chown__new_owner' => 'Chủ sở hữu mới',
    'chown__selected_domains' => 'Chọn các tên miền con',
    'chown__limits_legend' => 'Tài nguyên',
    'chown__limit_name' => 'Tên tài nguyên',
    'chown__limit_value' => 'Tài nguyên phân bổ',
    'chown__limit_assigned_before' => 'Trước khi chuyển',
    'chown__limit_assigned_after' => 'Sau khi chuyển',
    'chown__error_limits' => "Không thể tiếp tục chuyển thuê bao: thuê bao này yêu cầu nhiều tài nguyên hơn mức có thể cấp của nhà cung cấp của chủ nhân mới.",
    'chown__error_no_domains' => 'Không thể tiếp tục chuyển thuê bao: hoặc chưa chọn thuê bao, hoặc thuê bao đã chọn đã thuộc về người dùng đích.',
    'chown__error_empty_ip_pool' => "Không thể tiếp tục chuyển thuê bao: dãy IP của nhà cung cấp của chủ nhân mới trống rỗng. Hãy chắc chắn nhà cung cấp có ít nhất một địa chỉ IP trong kho.",
    'chown__please_select_new_domain_owner' => 'Chọn chủ sở hữu mới cho thuê bao này',
    'chown__old_ip_address' => 'Địa chỉ IP hiện tại',
    'chown__new_ip_address' => 'Địa chỉ IP mới',

    'chown__error_ssl_already_used' => "Hỗ trợ SSL/TLS đã được sử dụng trên các IP đích sau: %1 Do đó, các miền sau có hỗ trợ SSL/TLS sẽ không được chuyển: %2. Hãy xử lý vấn đề và thử lại",
    'chown__sitebuilder_not_installed' => 'Presence Builder chưa được cài đặt',
    'chown__domain_exclude_sitebuilder_not_installed' => 'Miền %1 không thể chuyển được cho chủ sở hữu khác do chưa cài đặt Presence Builder.',

    'backup__backup_time' => 'Thời gian sao lưu',
    'backup__backup_time_hour' => 'giờ',
    'backup__backup_time_minute' => 'phút',
    'backup__every' => 'mỗi',
    'backup__day_of_month' => 'ngày trong tháng',

    'subdomain__select_hst_type' => 'Chọn loại lưu trữ cho tên miền con',
    'hst_sel__subdom_subfolder_hst' => 'Tên miền con trên thư mục con',
    'subdomain__www_root_folder_not_exists' => 'Thư mục chủ của trang %1 không tồn tại',
    '__site_home_dir' => 'Thư mục trang chủ',
    'subdomain__aspnet_disabled_domain' => 'tắt theo tên miền',

    'domains__remove_description' => 'Tất cả các dữ liệu miền, bao gồm nội dung và thiết lập tên miền và tên miền phụ tương ứng, dữ liệu ứng dụng web, nội dung hộp thư, thư, cài đặt chống virus và bộ lọc thư rác, tập tin nhật ký, dữ liệu kho sao lưu miền và chứng nhận SSL/TLS sẽ bị xóa. Nếu bạn không có tập tin sao lưu trên máy tính cục bộ thì tất cả dữ liệu sẽ bị mất vĩnh viễn.',
    'subdomains__remove_description' => 'Tất cả dữ liệu tên miền con, bao gồm cả nội dung và các thiết lập tên miền con, dữ liệu các ứng dụng web và các tập tin nhật ký sẽ bị xóa. Nếu bạn không có một tập tin sao lưu trên máy cục bộ của bạn, tất cả dữ liệu sẽ vĩnh viễn bị mất.',

    'mail__tabs_spam_filtering' => 'Lọc Thư rác',
    'mail__tabs_antivirus' => 'Chống virus',
    'antivirus__use_server_settings_scan' => 'Sử dụng các thiết lập mặc định trên toàn máy chủ (Quét)',
    'antivirus__use_server_settings_no_scan' => 'Sử dụng các thiết lập mặc định trên toàn máy chủ (Không quét)',
    'antivirus__check_for_viruses' => 'Quét virus',
    'antivirus__dont_check_for_viruses' => 'Không quét virus',
    'antivirus__incoming_mail' => 'Thư đến',
    'antivirus__outgoing_mail' => 'Thư gửi đi',

    'domain_alias__CNAME_dns_record_exists' => 'Bản ghi DNS CNAME có tên này đã tồn tại',
    'domain_alias__A_dns_record_exists' => 'Bản ghi DNS A có tên này đã tồn tại',
    'domain_alias__bad_prefix' => 'Sai tiền tố cho bí danh tên miền',
    'domain_alias__domain_doesnt_exist' => "Tên miền không tồn tại",

    'dns__zone_ttl_message_info' => 'Nếu giá trị TTL không được chỉ định, giá trị TTL trong Mẫu Bản ghi SOA (%1) sẽ được sử dụng cho bản ghi DNS này.',

    '__webalizer_support' => 'Webalizer',
    '__awstats_support' => 'AWStats',
    '__smarterstats_support' => 'SmarterStats',

    'site_apps__make_default_warning_message' => "Một tập tin định danh index.html sẽ được tạo để chuyển hướng đến ứng dụng web được chọn. Nếu một tập tin định danh index.html đã tồn tại, nó sẽ được sao lưu như index.html.old và được thay thế bằng bản mới. Bấm Đồng ý để xác nhận",

    'bt_ftp_ctrl' => "Các tài khoản FTP bổ sung",
    'ftp_users_no_permission' => "Bạn không có quyền để quản lý các tài khoản FTP cho tên miền này",
    'ftp_users_limit_reached' => "Giới hạn tài khoản FTP đã đạt ngưỡng với tên miền này",
    'pb__ftp_ctrl' => "Trình quản lý FTP",
    'class_client__max_subftp_users' => "Các tài khoản FTP bổ sung",

    '__client_form_settings' => "Cài đặt khách hàng",
    '__sbnet_client_keep_sbnet' => "Giữ tài khoản người dùng tương ứng trong Presence Builder",
    '__sbnet_cant_add_more_sites' => "Giới hạn về số lượng trang có thể sử dụng Presence Builder đã đạt ngưỡng đối với khách hàng này",
    '__sbnet_legend_text' => "Tích hợp Presence Builder",
    '__sbnet_synchronize_user_with_sbnet' => "Tạo tài khoản người dùng tương ứng trong Presence Builder",
    '__sbnet_client_warning_delete_sb_user' => "Bạn đang gỡ bỏ tài khoản người dùng Presence Builder có liên kết với khách hàng này. Hành động này sẽ xóa tất cả các website của người dùng và các cài đặt liên quan khác ra khỏi hệ thống Presence Builder, xóa bỏ khả năng chỉnh sửa các website đang tồn tại thông qua Presence Builder, ngay cả khi bạn đã bật tùy chọn này về sau. Nếu bạn tạo lại một tài khoản người dùng Presence Builder, bạn sẽ phải tạo và xuất tất cả các website từ phần đã bị xóa. Bạn có muốn tắt trình tạo và xuất website thông qua Presence Builder không?",
    'sb__build_site_with_subdomains' => "Tạo tên miền con cho Nhật ký và Phòng Ảnh",
    '__sbnet_client_dont_have_sbuser' => "Không thể tạo và xuất trang sử dụng Presence Builder: Người dùng Presence Builder không tồn tại",

    '__component_disabled' => "Thành phần đã bị tắt",

    'subdomains__physical_path_not_exist' => "Có những tên miền con liên quan đến thư mục vật lý không tồn tại",

    'dnsserver_bind_to_msdns_switching_warning' => "Cảnh báo: chỉ có 254 địa chỉ IP đầu tiên của mạng con với /8 và/16 mặt nạ trong Danh sách Điều khiển Truy cập sẽ được chuyển giao. Chúng sẽ được chuyển giao như những địa chỉ IP riêng biệt. Bạn có muốn Tiếp Tục không?",

    '__sbnet_net_framework_required_for_site' => "Các trang Presence Builder có thể yêu cầu hỗ trợ ASP.NET 2.0 trên miền của bạn. Chúng tôi đề xuất kích hoạt hỗ trợ ASP.NET 2.0 nếu bạn đang sử dụng Presence Builder.",

    'subdomain_auto_create_dir' => "Tạo thư mục vật lý cho tên miền con",

    'sa_trainer__unable_to_get_messages_list' => "Không thể lấy được danh sách các tin nhắn trong hộp thư: %1",
    'sa_trainer__pass_doesnt_exist' => "Mật khẩu cho tài khoản thư đã bị mất",

    '__sitebuilder_error' => "Đã có một lỗi xảy ra trong khi kết nối đến Presence Builder. Liên hệ với nhà cung cấp dịch vụ để được hỗ trợ.",
    'wsb_error_user_not_exist' => "Tài khoản người dùng Presence Builder không tồn tại.",
    'wsb_error_site_already_exist' => "Trang này đã tồn tại trong Presence Builder.",
    'wsb_error_site_limit_reached' => "Giới hạn số kết nối trang Presence Builder đã đạt ngưỡng.",
    'wsb_error_internal_error' => "Xảy ra lỗi nội bộ trong Presence Builder. Liên hệ với nhà cung cấp dịch vụ để được hỗ trợ.",
    'wsb_error_user_already_exist' => "Tên người dùng Presence Builder đã tồn tại trong Presence Builder.",
    'sb_error_user_not_exist' => "Người dùng Presence Builder không tồn tại.",
    'wsb_error_object_not_found' => "Presence Builder không thể tìm thấy mục nhập lưu trữ chính xác.",

    'mg_no_mail_groups' => "Không có nhóm thư",

    'drweb__drweb_incoming' => 'Kiểm tra chống virus cho thư đến',
    'drweb__drweb_outgoing' => 'Kiểm tra chống virus cho thư đi',
    'drweb__disable_reason_serv' => 'Máy chủ thư không hỗ trợ các cài đặt bộ lọc chống virus ở cấp độ hòm thư',

    'vz_sitebuilder3_client_cant_be_created' => "Không thể tạo tài khoản khách hàng: SiteBuilder phiên bản 3.1 hoặc mới hơn không được cài đặt",

    'chown__client_without_sitebuilder_support' => "Không thể Tiếp Tục chuyển thuê bao: Dịch vụ Presence Builder không bao gồm trong gói dịch vụ của chủ sở hữu mới hoặc nhà cung cấp của họ.",

    // new limits

    'class_client__max_odbc' => "Các kết nối ODBC",
    'cl_perm__max_odbc' => "số lượng tối đa các kết nối ODBC",

    // domain aliases DNS
    'domain_alias__list_status' => 'S',
    'domain_alias__list_name' => 'Tên bí danh tên miền',
    'domain_alias__list_ascii_name' => 'Trong định dạng ASCII',


    // Interface Customization Templates
    'interface_preferences' => 'Quản Lý Giao Diện',
    'pb__interface_templates' => 'Quản lý giao diện',
    'pb__interface_clients' => 'Khách hàng đang sử dụng %1',

    // service management
    'bt_service_showall' => "Hiển thị tất cả",
    'bt_service_hideall' => "Ẩn tất cả",
    'bt_service_start' => "Bắt đầu",
    'bt_service_stop' => "Ngừng",
    'bt_service_restart' => "Khởi động lại",
    'bt_service_disable' => "Tắt",
    'bt_service_manual' => "Bằng tay",
    'bt_service_auto' => "Tự động",
    'service_startup_auto' => 'Tự động',
    'service_startup_manual' => 'Bằng tay',
    'service_startup_disabled' => 'Tắt',
    'service_action_ok' => "thao tác với dịch vụ %1 đã hoàn thành thành công",
    'service_action_failed_disabled_service' => "Không thể hoàn thành thao tác với %1 dịch vụ vì nó đã bị tắt",
    'service_action_failed_error' => "Không thể hoàn thành thao tác: %1",
    'service_group_action_ok' => "Các thao tác với các dịch vụ sau đây đã được hoàn thành thành công:\n%1",
    'service_group_action_disabled' => "Không thể hoàn thành thao tác với các dịch vụ sau đây bởi vì chúng đã bị tắt:\n%1",
    'service_group_action_failed' => "Không thể hoàn thành thao tác với các dịch vụ sau đây:\n%1.\nĐể nhận được thông tin lỗi chi tiết, thực hiện các thao tác với mỗi dịch vụ riêng biệt",

    // php 4vs5
    'bt_php' => "Cài đặt PHP",

    // Mass mail

    'massmail__resellers_list_available_for_select' => 'Các đại lý đang hoạt động',
    'massmail__resellers_list_selected' => 'Các đại lý được chọn',
    'massmail__clients_list_available_for_select' => 'Khách hàng có sẵn',
    'massmail__clients_list_selected' => 'Khách hàng được chọn',
    'massmail__advanced' => 'Nâng cao',
    'bt_massmail_send' => 'Gởi',
    'massmail__save_template_name' => 'Lưu văn bản vào một mẫu đã có tên',
    'massmail__template' => 'Mẫu',
    'massmail__compose_mail' => 'Tin nhắn',
    'massmail__from' => 'Từ',
    'massmail__to' => 'Tới',
    'massmail__subject' => 'Chủ đề',
    'massmail__body' => 'Tin nhắn văn bản',
    'massmail__body_hint' => 'Sử dụng <name>biến để tự động chèn tên người dùng vào tin nhắn của bạn.',
    'massmail__send_to_clients' => "Khách hàng",
    'massmail__send_to_domainusers' => "Quản trị viên tên miền",
    'massmail__send_to_admins' => "Quản trị viên Plesk",
    'massmail_select' => 'Chọn Địa chỉ',
    'massmail_showhide_selected' => "Ẩn/Hiện những mục được chọn",
    'massmail_send_all' => "Tất cả",
    'massmail_send_selected' => "Chỉ được chọn",
    'massmail_send_except' => "Tất cả các lựa chọn ngoại trừ",
    'bt_new_mass_mail_template' => "Thêm biểu mẫu email hàng loạt",
    '__mass_mail_templates_list' => "Danh sách biểu mẫu tin nhắn email hàng loạt",
    'massmail__template_name' => 'Tên mẫu',
    'massmail__receivers' => 'Người nhận',
    'massmail__created' => 'Tên người gửi',
    'massmail__date_created' => 'Ngày tạo',
    'massmail__compose' => 'Gởi',
    'mass_mail__resellers_all' => 'Tất cả các đại lý',
    'mass_mail__clients_all' => 'Tất cả khách hàng',
    'mass_mail__domainusers_all' => 'Tất cả các quản trị viên tên miền',
    'mass_mail__resellers_selected' => 'Các đại lý được chọn',
    'mass_mail__clients_selected' => 'Khách hàng được chọn',
    'mass_mail__domainusers_selected' => 'Các quản trị viên tên miền được chọn',
    'mass_mail__resellers_except' => 'Tất cả các đại lý trừ được chọn',
    'mass_mail__clients_except' => 'Tất cả các khách hàng trừ khách hàng được chọn',
    'mass_mail__domainusers_except' => 'Tất cả các quản trị viên tên miền trừ được chọn',
    'mass_mail__admins_all' => 'Tất cả quản trị viên',
    'massmailtemplateslist__title' => 'Biểu mẫu tin nhắn email hàng loạt',
    'massmail__insert_from_template' => "Chèn dữ liệu từ mẫu",
    'massmail__select_template' => "Chọn mẫu",
    'massmail__body_short_hint' => "(chỉ dùng văn bản thuần túy)",
    'massmail__from_short_hint' => "(email hoặc tên)",
    'bt_insert' => "Thêm",
    'massmail__mail_send_successfully' => "tin nhắn đã được gửi thành công",
    'massmail__mail_send_successfully_with_some_errors' => "Tin nhắn đã được gửi đi, nhưng gặp phải một số lỗi. Một số người nhận có thể không nhận được tin nhắn. Để biết thêm thông tin, xem tập tin nhật ký sau đây: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__mail_send_failed' => "Tin nhắn không được gửi. Đảm bảo rằng có ít nhất một người nhận được chọn và máy chủ thư của Plesk đang hoạt động chuẩn. Để biết thêm thông tin, xem tập tin nhật ký sau đây: %plesk_dir%\\admin\\logs\\send_mass_mail.log",
    'massmail__template_data_inserted' => "Dữ liệu từ biểu mẫu %1 đã được chèn thành công.",
    'massmail__template_added_successfully' => "Biểu mẫu tin nhắn được lưu dưới tên %1.",

    // wsb integration
    'wsb_error_sitebuilder_database_error' => "Xảy ra lỗi cơ sở dữ liệu trong Presence Builder. Liên hệ với nhà cung cấp dịch vụ để được hỗ trợ.",
    'wsb_error_sitebuilder_access_denied_error' => "Không thể truy cập tập tin: Presence Builder không có quyền truy cập đối với tập tin hoặc thư mục yêu cầu. Liên hệ với nhà cung cấp dịch vụ để được hỗ trợ.",
    'wsb_error_sitebuilder_connection_failed' => "Không thể kết nối với Presence Builder do mất liên kết. Liên hệ với nhà cung cấp dịch vụ để được hỗ trợ.",
    'wsb_error_critical_during_operation' => "Xảy ra lỗi nghiêm trọng trong Presence Builder:\n%1",
    'wsb_error_license_during_operation' => "Xảy ra lỗi bản quyền trong Presence Builder:\n%1",
    'wsb_error_during_operation' => "Xảy ra lỗi trong Presence Builder:\n%1",
    'wsb_error_license_error' => "Gặp vấn đề giới hạn bản quyền Presence Builder.",

    // Other
    '__confrim_service_stop' => "Cảnh báo! Nếu bạn dừng dịch vụ %1, Plesk có thể dừng hoạt động. Bạn có chắc chắn muốn dừng dịch vụ %1?",
    'virtualdir__name_is_reserved' => "Tên này được giữ lại",
    'index_redirect_help_text' => 'Bây giờ bạn sẽ được tự động chuyển hướng đến trang web yêu cầu. Nếu trình duyệt của bạn không hỗ trợ chuyển hướng, xin vui lòng click vào %1 ở đây %2',
    'bt_default_settings' => "Khôi phục giá trị mặc định",
    'logfiles__remove_failed' => "Không thể xóa tập tin %1: tập tin bị khóa bởi ứng dụng khác. Vui lòng thử lại sau",
    'subdomain__invalid_homedirectory' => "Thư mục chủ của tên miền con chỉ định không hợp lệ",
    'scheduler_item__empty_filename' => "Hãy chỉ định các tập tin thực thi để chạy",
    'subdomains__overlapped_domain_exists' => 'Tên miền con bị chồng chéo bởi vùng DNS của tên miền %1',
    'subdomains__overlapped_domain_alias_exists' => 'Tên miền con bị chồng chéo bởi vùng DNS của bí danh tên miền %1',
    'services_action_none_selected' => 'Không thể hoàn thành thao tác: xin vui lòng chọn các dịch vụ cần thiết',
    'cl_perm__max_subftp_users' => "số lượng các tài khoản FTP bổ sung tối đa",
    'login_up__access_denied_no_cp_access' => 'Từ chối truy cập. Bạn không có quyền truy cập Plesk.',
    'drweb__disable_reason_admin' => "Các cài đặt bộ lọc chống virus ở mức độ hòm thư không được cho phép theo chính sách máy chủ.",

    'webdirs__name_is_invalid' => 'Chỉ sử dụng các ký tự kiểu chữ số, gạch chân và gạch ngang trong tên danh mục.',
    'webdirs__physical_path_is_invalid' => 'Đường dẫn vật lý không hợp lệ hoặc không tồn tại',
    '__use_default' => 'Sử dụng mặc định',

    'webalizer_hidden_referrer__already_exist' => 'Mục nhập đã tồn tại.',
    'webalizer_group_referrer__already_exist' => 'Trang tham chiếu nhóm có tên này đã tồn tại.',

    'pb__dashboard' => 'Trang chủ',

    'server_interface__page_title' => 'Cài đặt giao diện máy chủ',
    'server_interface__tabs_locales' => 'Vùng ngôn ngữ',
    'server_interface__tabs_skins' => 'Các giao diện',
    'server_interface__tabs_interface_templates' => 'Các mẫu giao diện',
    'bt_server_interface' => 'Tuỳ chỉnh giao diện',
    'pb__server_interface' => 'Tuỳ chỉnh giao diện',

    'bt_wizard_next' => 'Tiếp tục >>',
    'bt_wizard_prev' => '<< Quay lại',

    '__limit_exceeded_max_dom_server' => 'Bạn không thể lưu trữ thêm tên miền trên máy chủ này vì đã đạt tới các giới hạn về số lượng tên miền được cho phép trên máy chủ của bạn theo mã bản quyền. Liên hệ với nhà cung cấp dịch vụ để giải quyết vấn đề này.',
    '__limit_exceeded_max_subdom_server' => 'Bạn không thể lưu trữ thêm tên miền phụ trên máy chủ này. Vui lòng liên hệ với nhà cung cấp dịch vụ.',
    '__limit_exceeded_max_dom_aliases_server' => 'Bạn không thể cài đặt thêm các bí danh miền trên máy chủ này. Vui lòng liên hệ với nhà cung cấp dịch vụ.',
    '__limit_exceeded_max_wu_server' => 'Bạn không thể tạo thêm người dùng web bởi vì các giới hạn về số người dùng web được cho phép trên máy chủ theo mã bản quyền của bạn đã tới hạn. Liên hệ với nhà cung cấp dịch vụ để giải quyết vấn đề này.',
    '__limit_exceeded_max_mn_server' => 'Bạn không thể tạo thêm tài khoản thư, vì đã đạt tới các giới hạn về số lượng tài khoản thư được cho phép trên máy chủ theo mã bản quyền này. Liên hệ với nhà cung cấp dịch vụ để giải quyết vấn đề này.',

    '__limit_exceeded_max_cl_useradmin' => 'Bạn đã đạt đến giới hạn số tài khoản khách hàng quy định theo key bản quyền của bạn (%2)',
    '__limit_exceeded_max_dom_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng tên miền được xác định theo mã bản quyền của bạn (%2)',
    '__limit_exceeded_max_subdom_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng tên miền phụ được xác định theo mã bản quyền của bạn (%2)',
    '__limit_exceeded_max_dom_aliases_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng bí danh tên miền được xác định theo mã bản quyền của bạn (%2)',
    '__limit_exceeded_disk_space_useradmin' => 'Bạn không còn đủ không gian đĩa trống',
    '__limit_exceeded_max_wu_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng tài khoản người dùng web được xác định theo mã bản quyền của bạn (%2)',
    '__limit_exceeded_max_db_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng cơ sở dữ liệu được xác định theo mã bản quyền của bạn (%2)',
    '__limit_exceeded_max_box_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng các hộp thư được xác định theo mã bản quyền của bạn (%2)',
    '__limit_exceeded_max_mn_useradmin' => 'Bạn đã đạt đến giới hạn số tài khoản email quy định theo key bản quyền của bạn (%2)',
    '__limit_exceeded_max_maillists_useradmin' => 'Bạn đã đạt đến giới hạn về số lượng danh sách gửi thư được xác định theo mã bản quyền của bạn (%2)',

    '__limit_exceeded_max_dom_userclient' => 'Bạn đã đạt đến giới hạn về số lượng tên miền (%2)',
    '__limit_exceeded_max_subdom_userclient' => 'Bạn đã đạt đến giới hạn về số lượng tên miền phụ (%2) được cho phép của nhà cung cấp dịch vụ',
    '__limit_exceeded_max_dom_aliases_userclient' => 'Bạn đã đạt đến giới hạn về số lượng bí danh tên miền (%2)',
    '__limit_exceeded_disk_space_userclient' => 'Bạn đã đạt đến giới hạn sử dụng không gian đĩa (%2)',
    '__limit_exceeded_max_traffic_userclient' => 'Bạn đã đạt đến giới hạn về số lượng lưu lượng được sử dụng mỗi tháng (%2)',
    '__limit_exceeded_max_wu_userclient' => 'Bạn đã đạt đến giới hạn về số lượng người dùng web (%2) được cho phép của nhà cung cấp dịch vụ của bạn.',
    '__limit_exceeded_max_db_userclient' => 'Bạn đã đạt đến giới hạn về số lượng cơ sở dữ liệu (%2)',
    '__limit_exceeded_max_box_userclient' => 'Bạn đã đạt đến giới hạn về số lượng các hộp thư (%2)',
    '__limit_exceeded_max_maillists_userclient' => 'Bạn đã đạt đến giới hạn về số lượng danh sách gửi thư (%2)',
    '__limit_exceeded_expiration_userclient' => 'Tài khoản của bạn hết hạn vào ngày %2',

    '__limit_exceeded_max_subdom_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng tên miền phụ (%2) được cho phép của nhà cung cấp dịch vụ',
    '__limit_exceeded_max_dom_aliases_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng bí danh tên miền (%2)',
    '__limit_exceeded_disk_space_userdomain' => 'Bạn đã đạt đến giới hạn sử dụng không gian đĩa (%2)',
    '__limit_exceeded_max_traffic_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng lưu lượng được sử dụng mỗi tháng (%2)',
    '__limit_exceeded_max_wu_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng tài khoản người dùng web (%2)',
    '__limit_exceeded_max_db_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng cơ sở dữ liệu (%2)',
    '__limit_exceeded_max_box_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng các hộp thư (%2)',
    '__limit_exceeded_max_maillists_userdomain' => 'Bạn đã đạt đến giới hạn về số lượng danh sách gửi thư (%2)',
    '__limit_exceeded_expiration_userdomain' => 'Tài khoản của bạn hết hạn vào ngày %2',

    'mmt__to_none' => 'Không',
    'mmt__to_admin' => 'Quản trị viên',
    'mmt__to_resellers_all' => 'Tất cả các đại lý',
    'mmt__to_resellers_select' => 'Các đại lý được chọn',
    'mmt__to_resellers_select__available' => 'Các đại lý đang hoạt động',
    'mmt__to_resellers_except' => 'Tất cả các đại lý trừ được chọn',
    'mmt__to_clients_all' => 'Tất cả khách hàng',
    'mmt__to_clients_select' => 'Khách hàng được chọn',
    'mmt__to_clients_select__available' => 'Khách hàng có sẵn',
    'mmt__to_clients_except' => 'Tất cả các khách hàng trừ khách hàng được chọn',

    'mmt__unable_send_empty_selection' => 'Không thể gửi được thư hàng loạt, chưa chọn địa chỉ email.',
    'mmt__unable_send_to__' => 'Không thể gửi thư hàng loạt cho:',
    'mmt__unable_send_to_email' => '%1 <%2>',

    'sapp_error_validation_not_found' => 'Không thể xác minh ứng dụng web bởi vì một trong các tập tin được yêu cầu (%1) đã không được tìm thấy. Liên hệ với người đại diện hỗ trợ kỹ thuật để được giúp đỡ.',
    'sapp_error_validation_spec_failed' => 'ứng dụng web được tải lên không phù hợp với chi tiết kỹ thuật AppPacks : %1.',
    'sapp_error_validation_register' => 'Không thể đăng ký ứng dụng web nằm trong thư mục "%1": %2 Bạn nên gỡ bỏ ứng dụng web từ máy chủ, vì nó không hoạt động đúng chức năng.',

    'sapp__install_failed' => 'Cài đặt ứng dụng web không thành công: %1',
    'sapp__install_res_failed' => 'Không thể tạo ra các tài nguyên được yêu cầu.',

    'server_preferences__subdomains_blog_and_photo' => 'Tạo tên miền con cho Nhật ký và Phòng Ảnh theo mặc định',
    'plesk_key__blog_and_photo' => 'Khả năng quản lý chế độ mặc định của ô đánh dấu tên miền con Tạo Nhật ký và Phòng Lưu Trữ Ảnh',
    'ip_ctrl__cannot_make_exclusive_ip_with_more_than_one_client' => 'Không thể thay đổi loại địa chỉ IP sang chuyên dụng vì nó đã được gán cho nhiều người dùng.',

    // 8.1.1

    '__write_modify_warning' => 'Lựa chọn quyền ghi/sửa bổ sung sẽ khiến một số ứng dụng web hoạt động chính xác, nhưng nó cũng sẽ làm tăng đáng kể các nguy cơ bảo mật',
    '__write_modify_subdomain_warning' => 'Lựa chọn quyền ghi/sửa bổ sung sẽ khiến một số ứng dụng web hoạt động chính xác, nhưng nó cũng sẽ làm tăng đáng kể các nguy cơ bảo mật',

    'phosting__php_incorrect_version_used' => "Các vấn đề về phiên bản PHP đã được phát hiện. Để giải quyết những vấn đề này, chọn ô đánh dấu với phiên bản PHP được yêu cầu dưới đây và nhấn Đồng ý. Để tắt PHP trên tên miền này, nhấn Đồng ý mà không cần chọn phiên bản PHP",
    'fp__mail_preferences' => 'Thiết lập thư',

    'mail__invalid_white_pattern' => 'Giá trị không hợp lệ. Sử dụng định dạng sau: mail@example.com cho các địa chỉ email, example.com cho các tên miền.',
    'mail__invalid_black_pattern' => 'Giá trị không hợp lệ. Sử dụng định dạng sau: mail@example.com cho các địa chỉ email, example.com cho các tên miền.',

    'resp_edit__reply_as_html' => 'Gửi dưới dạng HTML',
    'exception__path_very_long' => "Đường dẫn quá dài. Đảm bảo rằng có ít hơn %1 ký tự trong đường dẫn.",

    // 8.2


    //SAPP
    'sapp_on' => 'Bật',
    'sapp_off' => 'Tắt',
    'sapp_directive_aspect' => 'Được yêu cầu',
    'sapp_databases_num' => 'Cơ sở dữ liệu',
    'sapp_db_required' => 'Được yêu cầu',
    'sapp_Required' => 'Được yêu cầu',
    'sapp_Variant' => 'Ngôn ngữ địa phương',
    'sapp_db_id' => 'Cơ sở dữ liệu id',
    'sapp_db_id_type' => 'DB (id: %1) loại',
    'sapp_db_id_min_version' => 'DB (id: %1) phiên bản tối thiểu',
    'sapp_db_id_table_prefix' => 'DB (id: %1) tiền tố bảng',
    'sapp_Default' => 'Giá trị mặc định',
    'sapp_apache_mod_req' => 'Phân đoạn Apache',
    'sapp_dbtype_not_installed' => 'chưa cài đặt',
    'sapp_apache_mod_not_installed' => 'chưa cài đặt',
    'sapp__value_error_empty' => 'Giá trị trống không được phép.',
    'sapp_error_invalid_type' => 'Các ứng dụng "%1" không hỗ trợ hoạt động được yêu cầu.',
    'sapp_error_unknown_app_type' => 'Loại hình ứng dụng không được hỗ trợ: %1.',
    'sapp__ssl_text' => 'Cài đặt ứng dụng tới vùng lưu trữ ảo "http://" hay "https://"?',
    'sapp__app_to_upgrade' => 'Ứng dụng sẽ được nâng cấp',
    'sapp__upgrade_apps_title' => 'Nâng cấp các ứng dụng',
    'sapp__upgrade_to_ver' => 'Nâng cấp lên phiên bản',
    'sapp__choose_pkg_ver' => 'Chọn gói...',
    'sapp__pkg_cant_upgrade_pkg' => 'Các gói phần mềm "%1" không thể được sử dụng để nâng cấp ứng dụng web "%2".',
    'sapp__app_ugrade_error' => 'Không thể nâng cấp ứng dụng: %1. Hãy liên hệ với quản trị hệ thống của bạn.',
    'sapp__no_suitable_db_found' => 'Không có cơ sở dữ liệu phù hợp được tìm thấy.',
    'sapp__upgrade_success' =>  'Ứng dụng đã được nâng cấp thành công.',
    'sapp__pkg_info_changelog' => 'Lịch sử thay đổi',
    'sapp_requirement_legend' => 'Các tính năng lưu trữ theo yêu cầu của ứng dụng',

    // other
    'bt_apply' => 'Áp dụng',
    'mn_edit__add_alias_if_mailbox_disabled' => 'Để tạo một bí danh thư, hộp thư phải được bật trên tài khoản thư này. Bật hộp thư?',
    'mn_edit__mailbox_disable_if_has_alias' => 'Tắt hộp thư sẽ gỡ bỏ các bí danh thư vì chúng sẽ ngừng làm việc. Tắt hộp thư?',
    'antivirus__disable_reason_install' => 'Bạn không thể quản lý chống virus do phần này chưa được cài đặt.',
    'antivirus__disable_reason_key' => 'Bạn không thể quản lý chống virus do phần này chưa được kích hoạt bằng khóa bản quyền hợp lệ.',
    'antivirus__disable_reason_deny_personal_settings' => 'Bạn không thể quản lý chống virus do chính sách của máy chủ cấm cài đặt chống virus cá nhân.',
    'change_foreign_user_password' => 'Đổi mật khẩu',
    'change_foreign_user_password_hint' => "Người dùng không thuộc về ứng dụng này. Nhấn liên kết để đến một ứng dụng khác và thay đổi mật khẩu của người dùng đó. Để làm được điều này, bạn phải có quyền thích hợp trong ứng dụng.",
    'cf_url_text' => 'JDBC URL',
    'cf_sendStringParametersAsUnicode_text' => 'Định dạng Chuỗi',
    'lang_unknown' => 'Không có ngôn ngữ này',
    'pb__cl_ed' => 'Chi tiết khách hàng',
    'pb__actionlog' => 'Nhật ký hoạt động',
    'pb__cl_limits' => 'Giới hạn khách hàng',
    'pb__edit' => 'Hiệu chỉnh',
    'pb__subdom_edit' => 'Thiết lập lưu trữ',

    // NEW 8.3 FEATURES

    'backup_mail_content' => 'Sao lưu nội dung hộp thư',

    'maillist_import_result' => "\nTổng số địa chỉ email trong tập tin: %1\nsố địa chỉ email đã nạp: %2\nsố địa chỉ email đã tồn tại: %3\nsố địa chỉ email bị lặp trong tập tin: %4\nsố địa chỉ email không hợp lệ trong tập tin: %5",
    'maillist_import_error' => 'Không thể nạp danh sách các địa chỉ email',

    //  spaw

    'spaw__unable_to_edit_no_body' => "Tập tin mà bạn đã chọn hoặc rỗng hoặc không phải là tài liệu HTML theo kiểu mã hóa được chọn. Xin vui lòng chọn kiểu mã hóa chính xác hoặc chỉ thêm nội dung vào tập tin.",

    'dom_pref__external_mail_srv' => "Chuyển hướng đến máy chủ thư bên ngoài có địa chỉ IP:",
    'mn_edit__store_messages' => 'Hộp thư',

    // aps

    'sapp__before_upgrade_notice' => 'Nên sao lưu ứng dụng và dữ liệu người dùng trước khi bắt đầu quá trình nâng cấp.',
    'sapp__application_properties' => 'Các thuộc tính ứng dụng',
    'sapp__application_root_descr' => 'Trang chính của ứng dụng',

    'sapp__aps_license_invalid_id' => 'Mã bản quyền có ID không hợp lệ: %1.',
    'sapp__aps_lic_key_alredy_exists' => 'Bản quyền với số mã %1 đã tồn tại trong cơ sở dữ liệu.',
    'sapp__aps_lic_del_used' => 'Không thể xóa mã bản quyền, nó đang được sử dụng bởi một trong những ứng dụng được cài đặt.',
    'sapp__aps_lic_del_unknown' => 'Không thể xóa mã bản quyền: %1',
    'sapp__aps_cappi_duplicate' => "Ứng dụng này đã tồn tại trong kho ứng dụng của khách hàng",
    'sapp__appi_not_shared_no_install' => "Không có một ứng dụng nào trong kho ứng dụng của khách hàng. Nếu bạn muốn cài đặt ứng dụng này trên một trang web, trước tiên bạn cần thêm các ứng dụng này vào kho ứng dụng của khách hàng.",
    'sapp__appi_shared_not_client' => "Không có một ứng dụng nào trong kho ứng dụng của khách hàng. Nếu bạn muốn nâng cấp các ứng dụng tới phiên bản được xác định, trước tiên bạn cần thêm các phiên bản ứng dụng này tới kho ứng dụng của khách hàng.",
    'sapp__apply_license_script_not_found' => 'Không thể tìm thấy mã kịch bản "apply-license" cho ứng dụng web này.',
    'sapp__unable_to_activate_key' => 'Đã xảy ra lỗi trong khi cố gắng để kích hoạt mã bản quyền: %1',
    'sapp__unable_to_delete_ai_instances_exists' => 'Có các ứng dụng web được cài đặt đòi hỏi sự hiện diện của ứng dụng web này trong hệ thống.',
    'sapp__unable_to_delete_ai_in_pool' => 'Ứng dụng này đã tồn tại trong dãy của khách hàng. Nếu bạn muốn gỡ bỏ ứng dụng này, trước tiên bạn cần gỡ bỏ ứng dụng ra khỏi tất cả các dãy ứng dụng của khách hàng hoặc khiến nó trở nên miễn phí.',
    'sapp__unable_to_delete_app_template' => 'Không thể gỡ bỏ ứng dụng #%1: %2',
    'sapp__limit_exceeded_client' => 'Bạn đã đạt đến giới hạn về số lần bạn có thể cài đặt các ứng dụng web (%2) này.',


    // atis module

    '_week_on' => 'tuần trên',
    '__week_first' => 'đầu tiên',
    '__week_second' => 'giây',
    '__week_third' => 'thứ ba',
    '__week_fourth' => 'thứ tư',
    '__week_last' => 'cuối cùng',
    '__not_started' => 'Đang đợi',
    '__started' => 'Đang chạy',
    '__cancel_pending' => 'Đang hủy',
    '__canceled' => 'Đã hủy',
    '__error' => 'Lỗi',
    '__done' => 'Xong',

    '__php_cgi_handler' => 'Ứng dụng CGI',
    '__php_isapi_handler' => 'Phần mở rộng ISAPI',
    '__php_fastcgi_handler' => 'Ứng dụng FastCGI',
    '__php_module_handler' => 'mod_php',
    '__php_run_as' => 'chạy với tư cách là',

    'cf_dbfolder_text' =>'Thư mục Cơ sở dữ liệu',
    'cf_isnewdb_text' => 'Tạo Cơ sở dữ liệu',
    'cf_isnewdb_title' => 'Đánh dấu vào ô nếu cần phải tạo cơ sở dữ liệu',

    'pb__site_apps_upgrade' => 'Nâng cấp ứng dụng web',

    'detach' => 'Ngắt kết nối',
    'preferences' => "Thay đổi mật khẩu",

    'toolsbar__switch_user?' => "Bạn có chắc chắn muốn đăng nhập dưới tài khoản người dùng khác?",
    '__aps_left' => 'Các bản cài đặt còn lại',
    'aps__license_key' => 'Mã bản quyền',
    'aps__download_code' => 'Tải mã bản quyền về và kích hoạt mã',
    'aps__license_key_hint' => 'Lấy lại từ máy chủ cấp bản quyền bằng cách sử dụng mã kích hoạt',
    'aps__database_not_available' => 'không khả dụng, vui lòng kiểm tra giới hạn miền hoặc khách hàng',
    'aps__yes' => 'có',
    'aps__no' => 'không',
    '__click_to_enlarge' => 'Nhấn để mở rộng',
    'site_apps__back_to_list' => 'Quay trở lại danh sách',
    'sapp__pkg_info_installation_requirements' => 'Các yêu cầu cài đặt',
    '__close_window' => 'Đóng',

    //SAPP END

    'skin_info__already_default' => 'Giao diện đã được thiết lập thành mặc định.',

    //move this to other file after splitting drweb to module
    'drweb:virus_filter_full_name' => 'Plesk Premium Antivirus',
    'drweb:properties_page_title' => 'Cài đặt Plesk Premium Antivirus cho %1',
    'drweb:properties_legend' => 'Cài đặt',
    'drweb:status' => 'Kiểm tra virus cho thư',

    // sb integration
    'sitebuilder_wizard' => 'Trình hướng dẫn Presence Builder',
    'dom_site_builder' => 'Nhấp để mở Trình hướng dẫn Presence Builder.',
    'sb_plesk_admin_url' => 'URL máy chủ Presence Builder. Đảm bảo địa chỉ này phân giải chuẩn trong DNS',
    'sb_plesk_admin_login' => 'Tên người dùng cho quản trị viên máy chủ đăng nhập vào Presence Builder',
    'sb_plesk_admin_password' => 'Mật khẩu của quản trị viên',
    'sb_sitebuilder_preferences' => 'Các giấy chứng nhận của quản trị viên Presence Builder',
    'sb__server' => 'Các tùy chọn của quản trị viên hệ thống Presence Builder',
    'sb__sitebuilder_support' => 'Hỗ trợ Presence Builder',
    'sb_keep_sb_user' => 'Giữ tài khoản người dùng tương ứng trong Presence Builder',
    'sb_create_sb_user' => 'Tạo tài khoản người dùng tương ứng trong Presence Builder',
    'sb__build_site_using_sitebuilder' => "Tạo một website sử dụng Presence Builder",
    'sb_no_current_sb_server_set' => 'Kết nối với Presence Builder chưa được cấu hình: bạn cần thêm một bản ghi A trong biểu mẫu vùng DNS sẽ trỏ tới máy chủ Presence Builder.',
    'sb_unable_update_sb_server_sb_return_message' => "Không thể lấy được thông tin từ hệ thống Presence Builder:\n%1",
    'sb_unable_connect_sb_wrong_con_params' => "Không thể kết nối với Presence Builder: sai tên người dùng hoặc mật khẩu.",
    'sb_init_sb_manager' => "Khởi động trình quản lý Presence Builder: %1",
    'sb_err_couldnt_connect_sb' => "Không thể kết nối đến hệ thống Presence Builder.",
    'sb_err_client_dont_have_sbuser' => "Khách hàng này không có tài khoản người dùng trong Presence Builder.",
    'sb_err_sitebuilder_not_configured' => "Presence Builder chưa được cấu hình.",
    'sb_err_you_dont_have_sbaccount' => "Không thể xác thực bạn trong Presence Builder.",
    'sb_error_critical_during_operation' => "Đã xảy ra lỗi sau trong Presence Builder:\n%1",
    'sb_err_sso_is_not_enabled' => "Hỗ trợ đăng nhập đơn chưa được bật trong Plesk.",

    'warning__super_zone_exist' => "Vùng %1 đã được tạo ra, tuy nhiên, tên vùng này là một vùng phụ khác đã tồn tại trong vùng %2, thuộc các người dùng khác %3. Nếu có thể, hãy chắc chắn rằng bạn đã chọn đúng tài khoản người dùng.",
    'error__super_zone_exist' => "Không thể tạo ra vùng DNS vì vùng chính của nó thuộc về một người dùng khác.",

    'locales__files_not_exits' => 'Không thể thay đổi vùng ngôn ngữ: các tập tin gói ngôn ngữ được chỉ định không tồn tại trong hệ thống.',
    'locales__unavailable' => 'Không thể thay đổi vùng ngôn ngữ: gói ngôn ngữ được chỉ định không có.',

    // DB BU

    'pb__dbbackup_list' => 'Tập tin sao lưu CSDL',
    // server
    'dbbackup__server_backup_settings' => 'Sao lưu',
    'dbbackup__network_temp_dir' => 'Thư mục mạng tạm thời',
    'dbbackup__network_user' => 'Tên người dùng',
    'dbbackup__network_pass' => 'Mật khẩu',
    // domain
    'dbbackup__add_database_legend' => 'Khôi phục cơ sở dữ liệu được sao lưu',
    'dbbackup__add_database_restore' => 'Khôi phục cơ sở dữ liệu từ tập tin sao lưu',
    'dbbackup__add_database_file' => 'Tập tin sao lưu CSDL',
    'dbbackup__add_database_user' => 'Tên người dùng mặc định',
    'dbbackup__add_database_pass' => 'Mật khẩu mặc định của người dùng',
    'dbbackup__add_database_pass2' => 'Xác nhận mật khẩu mặc định của người dùng',

    'bt_dbbackup_now' => 'Sao Lưu',

    'bt_repair' => 'Sửa chữa',

    'dbbackup__mssql_dump_upload_not_allowed' => 'Tải lên rác cơ sở dữ liệu máy chủ SQL bị cấm bởi nhà cung cấp dịch vụ lưu trữ.',

    // APS categories

    'cf_invalid_password' => 'Mật khẩu không quá 16 ký tự',
    'cf_invalid_description_length' => 'Mô tả không được quá 256 ký tự',
    'ip_addr__ip_used_by_external_mail_server' => 'Địa chỉ IP %1 đã được sử dụng bởi máy chủ thư ngoại vi',

    // 8.4.1

    '__ftp_login_is_invalid' => 'Tên người dùng tài khoản FTP hoặc mật khẩu không hợp lệ. Vui lòng chỉ định giấy chứng nhận người dùng FTP chính xác.',

    // 8.6

    'dns__dns_serial_update_limit_warning' => 'Các giới hạn về việc thay đổi số thứ tự đã đạt tới. Không thêm thay đổi vùng DNS nào có thể được tiến hành ngày hôm nay.',
    'dns__zone_apply_changes' => 'Thay đổi bản ghi DNS chưa được lưu. Những thay đổi được thực hiện được nêu bật dưới đây. Nhấn Cập nhật để áp dụng các thay đổi cho vùng DNS hoặc nhấn Hoàn lại để bỏ các thay đổi.',
    'dns__update_dns_zone' => 'Nhấn để lưu các thay đổi đối vơi sbản ghi DNS',
    'dns__revert_dns_zone' => 'Nhấn để hủy bỏ các thay đổi đối với bản ghi DNS',
    'bt_revert' => 'Hoàn lại',
    'dns__dns_zone_has_beed_updated' => 'Thay đổi bản ghi DNS đã được lưu.',
    'dns__dns_zone_has_beed_reverted' => 'Thay đổi bản ghi DNS đã được hủy bỏ',
    'db__nondefault_server_not_allowed' => 'Cách sử dụng của máy chủ cơ sở dữ liệu không phải mặc định không được cho phép',


    //// UI POINTER CAPTIONS START HERE
    ////
    // *** The strings below have been generated automatically from @@CAPTION directives.

    'ui__client__description' => 'Tên miền và tài khoản khách hàng %1.',
    'ui__client__disabled-warning' => 'Tài khoản khách hàng %1 bị đình chỉ.',
    'ui__client__none-available' => 'Không có tài khoản khách hàng nào được cấu hình.',
    'ui__client__short-title' => '%1',
    'ui__client__title' => 'Khách hàng %1',
    'ui__client_self__description' => 'Danh sách tên miền của tôi.',
    'ui__client_self__short-title' => 'Tên miền của tôi',
    'ui__client_self__title' => 'Tên miền của tôi',


    'site_apps__non_removable' => 'Các mục không thể bị gỡ bỏ',
    'site_apps__non_removable_items' => 'Dưới đây là các ứng dụng web không thể bị gỡ bỏ:',

    'ui__client/custom-buttons/custom-button__none-available' => 'Không có các nút tùy biến nào.',
    'ui__client/custom-buttons/custom-button__none-available__1' => 'Không có các nút tùy biến trong bảng điều khiển của khách hàng %1.',

    'ui__client/custom-buttons/custom-button/delete__description' => 'Gỡ bỏ nút %1.',
    'ui__client/custom-buttons/custom-button/delete__short-title' => 'Gỡ bỏ',
    'ui__client/custom-buttons/custom-button/delete__title' => 'Gỡ bỏ nút %1',
    'ui__client/custom-buttons/custom-button/delete_multi__description' => 'Xóa các nút tùy biến khỏi Bảng Điều Khiển Khách Hàng',
    'ui__client/custom-buttons/custom-button/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__client/custom-buttons/custom-button/delete_multi__title' => 'Gỡ bỏ các nút tùy biến',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard-title' => 'Gỡ bỏ các nút',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Chọn một khách hàng có các nút tùy biến bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Chọn các nút bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Xác nhận gỡ bỏ các nút bằng cách đánh dấu vào ô trên màn hình này, và sau đó nhấn Hoàn tất.',
    'ui__client/custom-buttons/custom-button/delete_unknown__description' => 'Xóa nút tùy biến khỏi Bảng Điều Khiển Khách Hàng.',
    'ui__client/custom-buttons/custom-button/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__client/custom-buttons/custom-button/delete_unknown__title' => 'Gỡ bỏ một nút tùy biến',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Gỡ bỏ nút tùy biến',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Chọn một khách hàng có nút tùy biến bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Chọn một nút tùy biến bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Xác nhận gỡ bỏ nút tùy biến bằng cách đánh dấu vào ô trên màn hình này, và sau đó nhấn Hoàn tất.',

    'ui__client/custom-buttons/custom-button/properties__description' => 'Hiệu chỉnh các thuộc tính của nút cấp độ khách hàng %1.',
    'ui__client/custom-buttons/custom-button/properties__short-title' => 'Cài đặt',
    'ui__client/custom-buttons/custom-button/properties__title' => 'Sửa đổi nút tùy biến của khách hàng %1',
    'ui__client/custom-buttons/custom-button/properties_new__wizard-title' => 'Thêm nút tùy biến',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Chọn một khách hàng có Bảng Điều Khiển Khách Hàng mà bạn muốn tạo nút tùy biến và nhấp vào Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Nhấn Hoàn tất để tạo nút.',
    'ui__client/custom-buttons/custom-button/properties_unknown__description' => 'Thay đổi các thuộc tính của một nút trong bảng điều khiển của khách hàng.',
    'ui__client/custom-buttons/custom-button/properties_unknown__short-title' => 'Thuộc tính',
    'ui__client/custom-buttons/custom-button/properties_unknown__title' => 'Thay đổi các thuộc tính của một nút trong bảng điều khiển của khách hàng',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Thay đổi các thuộc tính nút tùy biến',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Chọn một khách hàng có nút tùy biến mà bạn muốn sửa đổi và nhấn Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Chọn một nút tùy biến mà bạn muốn sửa đổi và nhấn Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Khi hiệu chỉnh các thuộc tính của các nút xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',

    'ui__client/custom-buttons/custom-button/toggle_private__description' => 'Làm cho nút %1 không có hiệu lực với các khách hàng của bạn.',
    'ui__client/custom-buttons/custom-button/toggle_private__short-title' => 'Làm cho không có hiệu lực với các khách hàng của bạn',
    'ui__client/custom-buttons/custom-button/toggle_private__title' => 'Làm cho nút %1 không có hiệu lực với các khách hàng của bạn',
    'ui__client/custom-buttons/custom-button/toggle_public__description' => 'Làm cho nút %1 có hiệu lực với các người dùng của khách hàng.',
    'ui__client/custom-buttons/custom-button/toggle_public__short-title' => 'Làm cho có hiệu lực với các khách hàng của bạn',
    'ui__client/custom-buttons/custom-button/toggle_public__title' => 'Làm cho nút %1 có hiệu lực với các khách hàng của khách hàng',
    'ui__client/custom-buttons/custom-button/toggle_unknown__description' => 'Làm cho một nút tùy biến có hiệu lực/không có hiệu lực với các khách hàng của bạn.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__short-title' => 'Có hiệu lực/không có hiệu lực với các khách hàng của bạn',
    'ui__client/custom-buttons/custom-button/toggle_unknown__title' => 'Làm cho một nút tùy biến có hiệu lực hoặc không có hiệu lực với các khách hàng của bạn',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Làm cho một nút tùy biến có hiệu lực/không có hiệu lực với các khách hàng của bạn.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Chọn một khách hàng có nút tùy biến mà bạn muốn làm cho có hiệu lực với các người dùng của khách hàng đó và nhấp Tiếp tục >>.',
    'ui__client/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Chọn một nút tùy biến mà bạn muốn làm cho có hiệu lực hoặc không có hiệu lực với các khách hàng của bạn và nhấn Tiếp tục >>.',

    'ui__client/domain__description' => 'Quản lý tên miền %1.',
    'ui__client/domain__disabled-warning' => 'Tên miền %1 đã bị đình chỉ.',
    'ui__client/domain__none-available' => 'Bạn không có bất kỳ tên miền nào.',
    'ui__client/domain__none-available__1' => 'Các tài khoản của %1 hiện không có bất kỳ tên miền nào.',
    'ui__client/domain__none-available__2' => 'Các tài khoản của %1 hiện không có bất kỳ tên miền nào.',
    'ui__client/domain__short-title' => '%1',
    'ui__client/domain__title' => 'Tên miền %1',
    'ui__client/domain_self__description' => 'Quản lý tên miền của bạn.',
    'ui__client/domain_self__disabled-warning' => 'Tên miền của bạn đã bị đình chỉ.',
    'ui__client/domain_self__quick-search' => 'Tên miền của tôi',
    'ui__client/domain_self__short-title' => 'Tên miền của tôi',
    'ui__client/domain_self__title' => 'Tên miền của tôi',

    'ui__client/domain/custom-buttons/custom-button__none-available' => 'Không có các nút tùy biến đặt trong Bảng Điều Khiển Khách Hàng.',
    'ui__client/domain/custom-buttons/custom-button__none-available__1' => 'Khách hàng %1 không có các nút tùy biến trong Bảng Điều Khiển Khách Hàng.',
    'ui__client/domain/custom-buttons/custom-button__none-available__2' => 'Không có các nút tùy biến cho tên miền %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__description' => 'Gỡ bỏ nút tùy biến %1.',
    'ui__client/domain/custom-buttons/custom-button/delete__short-title' => 'Gỡ bỏ',
    'ui__client/domain/custom-buttons/custom-button/delete__title' => 'Gỡ bỏ nút tùy biến %1',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__description' => 'Gỡ bỏ các nút tùy biến.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__title' => 'Gỡ bỏ các nút tùy biến',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard-title' => 'Gỡ bỏ các nút tùy biến',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Chọn các khách hàng từ bảng điều khiển quản lý tên miền mà bạn muốn gỡ bỏ các nút và nhấn Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__2_unknown' => 'Hãy chọn tên miền từ bảng điều khiển quản trị mà bạn muốn gỡ bỏ các nút và nhấn Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Chọn các nút bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_multi__wizard__5_multi' => 'Xác nhận gỡ bỏ các nút bằng cách đánh dấu vào ô tương ứng và nhấn Hoàn tất để gỡ bỏ các nút và thoát khỏi trình thuật sĩ.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__description' => 'Gỡ bỏ một nút tùy biến.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__title' => 'Gỡ bỏ một nút tùy biến',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Gỡ bỏ một nút tùy biến',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Chọn các khách hàng từ bảng điều khiển quản lý tên miền mà bạn muốn gỡ bỏ nút tùy biến và nhấn Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Hãy chọn tên miền từ bảng điều khiển quản trị mà bạn muốn gỡ bỏ và nhấn nút Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__4_unknown' => 'Chọn các nút tùy biến bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/delete_unknown__wizard__5' => 'Xác nhận gỡ bỏ các nút tùy biến bằng cách đánh dấu vào ô và nhấn Hoàn tất để gỡ bỏ các nút và thoát khỏi trình thuật sĩ.',

    'ui__client/domain/custom-buttons/custom-button/properties__title' => "Thay đổi các thuộc tính của nút tùy biến %1",
    'ui__client/domain/custom-buttons/custom-button/properties__short-title' => "Thuộc tính",
    'ui__client/domain/custom-buttons/custom-button/properties__description' => "Thay đổi các thuộc tính của nút tùy chỉnh %1 trong Bảng Điều Khiển Khách Hàng.",

    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard-title' => 'Thêm một nút',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Chọn khách hàng có Bảng Điều Khiển Khách Hàng mà bạn muốn tạo nút và nhấp vào Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__2_unknown' => 'Chọn tên miền con mà bạn muốn sửa đổi và nhấn nút Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/properties_new__wizard__5_new' => 'Nhấn Hoàn tất để tạo ra các nút và thoát khỏi trình thuật sĩ.',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__description' => "Thay đổi các thuộc tính của một nút trong Bảng Điều Khiển Khách Hàng.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__short-title' => 'Thuộc tính',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__title' => 'Thay đổi các thuộc tính của nút trong Bảng Điều Khiển Khách Hàng',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Thay đổi các thuộc tính của nút',
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__4_unknown' => "Chọn các nút tùy biến có những thiết lập mà bạn muốn sửa đổi và nhấn Tiếp tục >>.",
    'ui__client/domain/custom-buttons/custom-button/properties_unknown__wizard__5' => 'Khi thay đổi thuộc tính của các nút xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',

    'ui__client/domain/custom-buttons/custom-button/toggle_private__description' => 'Làm cho nút %1 không có hiệu lực với người dùng thư theo tên miền này.',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__short-title' => 'Không có hiệu lực với những người dùng thư',
    'ui__client/domain/custom-buttons/custom-button/toggle_private__title' => 'Làm cho nút %1 không có hiệu lực với người dùng thư theo tên miền này',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__description' => 'Làm cho nút %1 hiển thị cho người dùng thư theo tên miền.',

    'ui__client/domain/custom-buttons/custom-button/toggle_public__short-title' => 'Người dùng có thể truy cập vào thư theo tên miền này',
    'ui__client/domain/custom-buttons/custom-button/toggle_public__title' => 'Làm cho nút tùy biến %1 hiển thị cho người dùng thư theo tên miền này',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__description' => 'Làm cho một nút tùy biến có hiệu lực hoặc không có hiệu lực với những người dùng khác.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__short-title' => 'Có sẵn hoặc không có hiệu lực với những người dùng khác',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__title' => 'Làm cho một nút tùy biến có hiệu lực hoặc không có hiệu lực với những người dùng thư',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Làm cho một nút tùy biến có hiệu lực hoặc không có hiệu lực với những người dùng khác',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Chọn một tên miền mà các nút được đặt và nhấn Tiếp tục >>.',
    'ui__client/domain/custom-buttons/custom-button/toggle_unknown__wizard__4_unknown' => 'Chọn nút mà bạn muốn làm cho có hiệu lực hoặc không có hiệu lực với những người dùng khác và nhấn Tiếp tục >>.',

    'ui__client/domain/delete__description' => 'Gỡ bỏ tên miền %1.',
    'ui__client/domain/delete__short-title' => 'Gỡ bỏ',
    'ui__client/domain/delete__title' => 'Gỡ bỏ tên miền %1',
    'ui__client/domain/delete_multi__description' => 'Gỡ bỏ tên miền.',

    'ui__client/domain/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__client/domain/delete_multi__title' => 'Gỡ bỏ tên miền',
    'ui__client/domain/delete_multi__wizard-title' => 'Gỡ bỏ tên miền',
    'ui__client/domain/delete_multi__wizard__2_multi' => 'Chọn tên miền bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/domain/delete_multi__wizard__3_multi' => 'Xác nhận gỡ bỏ các miền bằng cách chọn hộp kiểm, và sau đó nhấp vào hoàn tất để gỡ bỏ chúng và thoát khỏi thuật sĩ.',
    'ui__client/domain/delete_unknown__description' => 'Gỡ bỏ một tên miền.',
    'ui__client/domain/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__client/domain/delete_unknown__title' => 'Gỡ bỏ tên miền',
    'ui__client/domain/delete_unknown__wizard-title' => 'Gỡ bỏ một tên miền',
    'ui__client/domain/delete_unknown__wizard__2_unknown' => 'Chọn một tên miền bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__client/domain/delete_unknown__wizard__3' => 'Xác nhận gỡ bỏ các tên miền bằng cách đánh dấu vào ô, và sau đó nhấn Hoàn tất để gỡ bỏ nó và thoát khỏi trình thuật sĩ.',

    'ui__client/domain/hosting__none-available' => 'Không có tên miền nào với vùng lưu trữ web được cấu hình. Tạo một tên miền và cấu hình vùng lưu trữ web để truy cập vào tính năng này.',
    'ui__client/domain/hosting__none-available__1' => 'Tài khoản người dùng này hiện không có bất kỳ tên miền nào với vùng lưu trữ web được cấu hình. Cấu hình của vùng lưu trữ web trên các tên miền được yêu cầu để truy cập vào tính năng này.',
    'ui__client/domain/hosting__none-available__2' => 'Vùng lưu trữ web không được định cấu hình cho tên miền %1. Cấu hình của máy chủ Web trên tên miền của %1 để truy cập vào tính năng này.',

    'ui__client/domain/hosting/application#list_header__clients_number__title' => "Khách hàng",
    'ui__client/domain/hosting/application#list_header__description__title' => "Mô tả",
    'ui__client/domain/hosting/application#list_header__items_number__title' => "Các khoản mục",
    'ui__client/domain/hosting/application#list_header__name__title' => "Tên",
    'ui__client/domain/hosting/application#list_header__release__title' => "Phát hành",
    'ui__client/domain/hosting/application#list_header__sort_by_clients_number__title' => "Sắp xếp theo khách hàng",
    'ui__client/domain/hosting/application#list_header__sort_by_description__title' => "Sắp xếp theo mô tả",
    'ui__client/domain/hosting/application#list_header__sort_by_items_number__title' => "Sắp xếp theo mục",
    'ui__client/domain/hosting/application#list_header__sort_by_name__title' => "Sắp xếp theo tên",
    'ui__client/domain/hosting/application#list_header__sort_by_release__title' => "Sắp xếp theo phát hành",
    'ui__client/domain/hosting/application#list_header__sort_by_version__title' => "Sắp xếp theo các phiên bản",
    'ui__client/domain/hosting/application#list_header__title' => "Các ứng dụng web",
    'ui__client/domain/hosting/application#list_header__version__title' => "Các phiên bản",

    'rpt_reseller_section_general' => 'Tổng quan',
    'rpt_reseller_section_domains' => 'Các tên miền',
    'rpt_reseller_section_clients' => 'Khách hàng',
    'statistics__cl_active_domains' => "Tên miền đang hoạt động",
    'rpt_reseller_cl_domains' => "Các tên miền",
    'rpt_reseller_cl_subdomains' => "Tên miền phụ",
    'by__cl_domains' => "Tên miền của khách hàng",
    'dom_ctrl__cl_mboxes' => "Hòm thư",
    'rpt_reseller_cl_redirects' => "Bộ chuyển hướng",
    'rpt_reseller_cl_mail_groups' => "Các nhóm thư",
    'rpt_reseller_cl_mail_resps' => "Trả lời tự động",
    'rpt_reseller_cl_mail_lists' => "Các danh sách gửi thư",
    'rpt_reseller_cl_web_users' => "Người dùng Web",
    'rpt_reseller_cl_data_bases' => "Cơ sở dữ liệu",

    'statistics__active_clients' => 'Khách hàng có thuê bao đang hoạt động',
    'statistics__clients_active_domains' => 'Tên miền đang hoạt động',
    'statistics__clients_doms' => 'Các tên miền',
    'statistics__cl_doms' => 'Các tên miền',
    '__clients_subdomains' => 'Tên miền phụ',
    '__clients_domains' => 'Các tên miền',
    'dom_ctrl__clients_mboxes' => 'Hòm thư',
    'dom_ctrl__clients_redir' => 'Bộ chuyển hướng',
    'dom_ctrl__clients_mg' => 'Các nhóm thư',
    'dom_ctrl__clients_resp' => 'Trả lời tự động',
    'dom_ctrl__clients_maillists' => 'Các danh sách gửi thư',
    'dom_ctrl__clients_wu' => 'Người dùng Web',
    'dom_ctrl__clients_db' => 'Cơ sở dữ liệu',

    'dom_ctrl__cl_redir' => 'Bộ chuyển hướng', // to resolve!
    'dom_ctrl__cl_mg' => 'Các nhóm thư', // to resolve!
    'dom_ctrl__cl_resp' => 'Trả lời tự động', // to resolve!
    'dom_ctrl__cl_maillists' => 'Các danh sách gửi thư', // to resolve!
    'dom_ctrl__cl_wu' => 'Người dùng Web', // to resolve!
    'dom_ctrl__cl_db' => 'Cơ sở dữ liệu', // to resolve!

    'rpt_cl_section_clients' => 'Khách hàng',

    'rpt_admin_section_general' => 'Tổng quan',
    'rpt_admin_section_resellers' => 'Các đại lý',
    'rpt_admin_section_clients' => 'Khách hàng',
    'rpt_admin_section_personal_clients' => 'Khách hàng cá nhân',
    'rpt_admin_section_domains' => 'Các tên miền',
    'rpt_admin_section_personal_domains' => 'Tên miền cá nhân',

    'rpt_reseller_section_personal_domains' => 'Tên miền cá nhân',

    'ui__client/domain/toggle_unknown__wizard__2_unknown' => 'Chọn tên miền mà bạn muốn tạm ngưng hoặc tái kích hoạt.',
    'ui__client/domain/toggle_unknown__wizard-title' => 'Tạm ngưng hoặc kích hoạt một tên miền',

    'ui__client/ip-pool__description' => 'Chỉ định hoặc bỏ chỉ định địa chỉ IP và các chứng nhận SSL/TLS cho khách hàng %1.',
    'ui__client/ip-pool__short-title' => 'Dãy IP',
    'ui__client/ip-pool__title' => 'Dãy IP của khách hàng %1',
    'ui__client/ip-pool_self__description' => 'Xem dãy IP của bạn.',
    'ui__client/ip-pool_self__short-title' => 'Dãy IP',
    'ui__client/ip-pool_self__title' => 'Dãy IP của tôi',
    'ui__client/ip-pool/properties__description' => 'Thiết lập dãy IP cho khách hàng %1.',

    'ui__client/ip-pool/properties__short-title' => 'Dãy IP',
    'ui__client/ip-pool/properties__title' => 'Thiết lập dãy IP cho khách hàng %1',
    'ui__client/ip-pool/properties_self__description' => 'Xem dãy IP của bạn.',

    'ui__client/ip-pool/properties_self__short-title' => 'Dãy IP của tôi',
    'ui__client/ip-pool/properties_self__title' => 'Dãy IP của tôi',
    'ui__client/ip-pool/properties_unknown__description' => 'Chỉ định hoặc bỏ chỉ định địa chỉ IP và các chứng nhận SSL/TLS khỏi khách hàng.',
    'ui__client/ip-pool/properties_unknown__short-title' => 'Dãy IP',
    'ui__client/ip-pool/properties_unknown__title' => 'Thiết lập dãy IP của khách hàng',
    'ui__client/ip-pool/properties_unknown__wizard-title' => 'Thiết lập dãy IP của khách hàng',
    'ui__client/ip-pool/properties_unknown__wizard__1_unknown' => 'Chọn khách hàng có dãy IP mà bạn muốn cấu hình.',
    'ui__client/ip-pool/properties_unknown__wizard__3' => 'Khi cấu hình dãy IP xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',


    'ui__client/limits_readonly-unknown__description' => 'Xem giới hạn tài nguyên cho một khách hàng.',
    'ui__client/limits_readonly-unknown__short-title' => 'Giới hạn tài nguyên',
    'ui__client/limits_readonly-unknown__title' => 'Xem giới hạn tài nguyên cho một tài khoản khách hàng',
    'ui__client/limits_readonly-unknown__wizard-title' => 'Xem hoặc thay đổi giới hạn tài nguyên cho một khách hàng',

    'ui__client/limits_unknown__wizard-title' => 'Xem hoặc thay đổi giới hạn tài nguyên cho một khách hàng',
    'ui__client/limits_unknown__wizard__1_readonly-unknown' => 'Chọn khách hàng mà bạn cần.',
    'ui__client/limits_unknown__wizard__1_unknown' => 'Chọn khách hàng mà bạn cần.',
    'ui__client/limits_unknown__wizard__2' => 'Để áp dụng các thay đổi, hãy nhấn Hoàn tất.',
    'ui__client/limits_unknown__wizard__2_readonly' => 'Để thoát khỏi trình thuật sĩ, bấm Kết thúc.',
    'ui__client/limits_unknown__wizard__2_readonly-self' => 'Để thoát khỏi trình thuật sĩ, bấm Kết thúc.',
    'ui__client/limits_unknown__wizard__2_readonly-self-reseller' => 'Để thoát khỏi trình thuật sĩ, bấm Kết thúc.',

    'ui__client/permissions_unknown__wizard-title' => 'Xem hoặc thay đổi quyền truy cập cho một khách hàng',
    'ui__client/permissions_unknown__wizard__1/properties_self' => 'Khi xem quyền truy cập của bạn xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',
    'ui__client/permissions_unknown__wizard__1_unknown' => 'Chọn khách hàng có quyền truy cập mà bạn muốn xem hoặc thay đổi.',
    'ui__client/permissions_unknown__wizard__2' => 'Khi thay đổi các quyền hạn của khách hàng xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',

    'ui__client/preferences_unknown__wizard-title' => 'Chỉnh sửa các tùy chỉnh của khách hàng',
    'ui__client/preferences_unknown__wizard__1_unknown' => 'Chọn khách hàng có phiên hoạt động và tùy chọn giao diện mà bạn muốn quản lý.',
    'ui__client/preferences_unknown__wizard__2' => 'Khi hoàn tất thay đổi tùy chọn của khách hàng, nhấp vào Xong.',
    'ui__client/preferences_unknown__wizard__2_self' => 'Khi hoàn tất thay đổi tùy chọn của bạn, nhấp vào Xong.',

    'ui__custom-buttons/custom-button__none-available' => 'Bạn không có các nút tùy biến nào.',
    'ui__custom-buttons/custom-button/delete__description' => 'Gỡ bỏ nút tùy biến %1.',
    'ui__custom-buttons/custom-button/delete__short-title' => 'Gỡ bỏ',
    'ui__custom-buttons/custom-button/delete__title' => 'Gỡ bỏ nút tùy biến %1',
    'ui__custom-buttons/custom-button/delete_multi__description' => 'Gỡ bỏ các nút tùy biến.',

    'ui__custom-buttons/custom-button/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__custom-buttons/custom-button/delete_multi__title' => 'Gỡ bỏ các nút tùy biến',
    'ui__custom-buttons/custom-button/delete_multi__wizard-title' => 'Gỡ bỏ các nút tùy biến',
    'ui__custom-buttons/custom-button/delete_multi__wizard__2_multi' => 'Chọn các nút tùy biến mà bạn muốn gỡ bỏ.',
    'ui__custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Xác nhận việc gỡ bỏ các nút bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.',
    'ui__custom-buttons/custom-button/delete_unknown__description' => 'Gỡ bỏ các nút tùy biến.',
    'ui__custom-buttons/custom-button/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__custom-buttons/custom-button/delete_unknown__title' => 'Gỡ bỏ các nút tùy biến',
    'ui__custom-buttons/custom-button/delete_unknown__wizard-title' => 'Gỡ bỏ các nút tùy biến',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__2_unknown' => 'Chọn các nút tùy biến mà bạn muốn gỡ bỏ.',
    'ui__custom-buttons/custom-button/delete_unknown__wizard__3' => 'Xác nhận việc gỡ bỏ nút bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.',
    'ui__custom-buttons/custom-button/properties__description' => 'Thay đổi các thuộc tính của nút tùy biến %1.',

    'ui__custom-buttons/custom-button/properties__short-title' => 'Thuộc tính',
    'ui__custom-buttons/custom-button/properties__title' => 'Thay đổi các thuộc tính của nút tùy biến %1',

    'ui__custom-buttons/custom-button/properties_new__wizard-title' => 'Tạo một nút',
    'ui__custom-buttons/custom-button/properties_new__wizard__3_new' => 'Nhấn Hoàn tất để tạo nút.',
    'ui__custom-buttons/custom-button/properties_unknown__description' => 'Thay đổi các thuộc tính của một nút tùy biến.',
    'ui__custom-buttons/custom-button/properties_unknown__short-title' => 'Thuộc tính',
    'ui__custom-buttons/custom-button/properties_unknown__title' => 'Thay đổi các thuộc tính của một nút tùy biến',
    'ui__custom-buttons/custom-button/properties_unknown__wizard-title' => 'Thay đổi các thuộc tính của một nút tùy biến',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__2_unknown' => 'Chọn các nút tùy biến có các thuộc tính mà bạn muốn thay đổi.',
    'ui__custom-buttons/custom-button/properties_unknown__wizard__3' => 'Để áp dụng các thay đổi, hãy nhấn Hoàn tất.',
    'ui__custom-buttons/custom-button/toggle_private__description' => 'Làm cho nút tùy biến %1 không có hiệu lực với những người dùng khác.',

    'ui__custom-buttons/custom-button/toggle_private__short-title' => 'Không có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_private__title' => 'Làm cho nút tùy biến %1 không có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_public__description' => 'Làm cho nút tùy biến %1 hiệu lực với cho những người dùng khác.',

    'ui__custom-buttons/custom-button/toggle_public__short-title' => 'Có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_public__title' => 'Làm cho nút tùy biến %1 có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_unknown__description' => 'Làm cho nút tùy biến có hiệu lực hoặc không có hiệu lực với những người dùng khác.',
    'ui__custom-buttons/custom-button/toggle_unknown__short-title' => 'Có hiệu lực hoặc không có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_unknown__title' => 'Làm cho nút tùy biến có hiệu lực hoặc không có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Làm cho nút tùy biến có hiệu lực hoặc không có hiệu lực với những người dùng khác',
    'ui__custom-buttons/custom-button/toggle_unknown__wizard__2_unknown' => 'Chọn các nút tùy biến mà bạn muốn làm cho có hiệu lực hoặc không có hiệu lực với những người dùng khác và nhấn Tiếp tục >>.',

    'ui__longtasks#list_header__name__title' => "Tên",
    'ui__longtasks#list_header__owner__title' => "Chủ sở hữu",
    'ui__longtasks#list_header__start_time__title' => "Thời gian tạo",
    'ui__longtasks#list_header__status__title' => "Trạng thái",
    'ui__longtasks#list_header__title' => "Tác vụ",
    'ui__longtasks#list_header__finish_time__title' => "Thời gian hoàn thành",
    'ui__longtasks#task_list_legend__title' => "Tác vụ",
    'ui__longtasks#tools_legend__title' => "Công cụ",
    'ui__longtasks__description' => "Quản lý các tác vụ nền",
    'ui__longtasks__short-title' => "Các tác vụ nền",
    'ui__longtasks__title' => "Các tác vụ nền",
    'ui__longtasks/longtask/properties#current_operation__title' => "Hoạt động hiện tại:",
    'ui__longtasks/longtask/properties#finish_time__title' => "Thời gian hoàn thành dự kiến:",
    'ui__longtasks/longtask/properties#general_legend__title' => "Tổng quan",
    'ui__longtasks/longtask/properties#owner__title' => "Tác vụ được bắt đầu bởi:",
    'ui__longtasks/longtask/properties#progress__title' => "Toàn bộ tiến trình:",
    'ui__longtasks/longtask/properties#start_time__title' => "Tác vụ được bắt đầu:",
    'ui__longtasks/longtask/properties#status_legend__title' => "Trạng Thái Tác Vụ",
    'ui__longtasks/longtask/properties__description' => "Tình trạng và thông tin của tác vụ nền",

    'ui__longtasks/properties__description' => "Cài đặt các tác vụ nền",
    'ui__longtasks/properties__short-title' => "Cài đặt",
    'ui__longtasks/properties__title' => "Các tác vụ nền",

    // updated
    'ui__mass-mail/template#list_header__title' => 'Biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/template#list_header__name__title' => 'Tên mẫu',
    'ui__mass-mail/template#list_header__from_email__title' => 'Tên người gửi',
    'ui__mass-mail/template#list_header__to__title' => 'Người nhận',
    'ui__mass-mail/template#list_header__subject__title' => 'Chủ đề',
    'ui__mass-mail/template#list_header__cdate__title' => 'Ngày tạo',
    'ui__mass-mail/template#list_header__send__title' => 'Gởi',

    'ui__mass-mail/template/properties__short-title' => '%1',
    'ui__mass-mail/template/properties__title' => 'Chỉnh sửa biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/template/properties__description' => 'Chỉnh sửa biểu mẫu tin nhắn email hàng loạt này.',

    'ui__mass-mail/template/properties_unknown-new__short-title' => 'Thêm biểu mẫu email hàng loạt',
    'ui__mass-mail/template/properties_unknown-new__title' => 'Thêm biểu mẫu email hàng loạt',
    'ui__mass-mail/template/properties_unknown-new__description' => 'Thêm biểu mẫu tin nhắn email hàng loạt.',
    'ui__mass-mail/send__short-title' => 'Gửi email hàng loạt',
    'ui__mass-mail/send__title' => 'Gửi tin nhắn email hàng loạt',
    'ui__mass-mail/send__description' => 'Gửi tin nhắn email hàng loạt cho người nhận đã chọn.',
    'ui__mass-mail/template/delete_multi__short-title' => 'Gỡ bỏ biểu mẫu email hàng loạt',
    'ui__mass-mail/template/delete_multi__title' => 'Gỡ bỏ các biểu mẫu tin nhắn email hàng loạt này:',
    'ui__mass-mail/template/delete_multi__description' => 'Gỡ bỏ các biểu mẫu tin nhắn email hàng loạt đã chọn.',
    'ui__mass-mail/template/delete_multi__done' => 'Các biểu mẫu tin nhắn đã chọn vừa được gỡ bỏ.',
    'ui__mass-mail/template/properties__invalid_values' => 'Chỉ định giá trị không hợp lệ',


    // old
    'ui__mass-mail#body_text__description' => 'Bạn có thể sử dụng <name> biến trong văn bản tin nhắn (nhưng không phải trong đầu mục). Nó sẽ được thay thế với tên liên lạc của khách hàng hoặc của đại lý.',
    'ui__mass-mail#body_text__title' => 'Tin nhắn văn bản',
    'ui__mass-mail#compose_legend__title' => 'Tin nhắn',
    'ui__mass-mail#from_email_text__title' => 'Từ (địa chỉ email)',
    'ui__mass-mail#list_header__cdate__title' => 'đã được tạo',
    'ui__mass-mail#list_header__from_email__title' => 'Từ',
    'ui__mass-mail#list_header__name__title' => 'Tên',
    'ui__mass-mail#list_header__send__title' => 'Tạo tin nhắn',
    'ui__mass-mail#list_header__subject__title' => 'Chủ đề',
    'ui__mass-mail#list_header__title' => 'Biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail#list_header__to__title' => 'Tới',
    'ui__mass-mail#list_legend__title' => 'Biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail#load_template_text__title' => 'Tải',
    'ui__mass-mail#name_text__title' => 'Tên mẫu',
    'ui__mass-mail#option_mode_all__title' => 'Tất cả',
    'ui__mass-mail#option_mode_except__title' => 'Tất cả các lựa chọn ngoại trừ',
    'ui__mass-mail#option_mode_select__title' => 'Chỉ được chọn',
    'ui__mass-mail#option_select_template__title' => '---Chọn một mẫu---',
    'ui__mass-mail#picker_legend__title' => 'Biểu mẫu tin nhắn email',
    'ui__mass-mail#picker_title__title' => 'Chọn một mẫu',
    'ui__mass-mail#save_as_legend__title' => 'Lưu dưới dạng mẫu',
    'ui__mass-mail#save_as_text__title' => 'Lưu thông báo đã soạn với một mẫu mới có tên',
    'ui__mass-mail#subject_text__title' => 'Chủ đề',
    'ui__mass-mail#template_legend__title' => 'Mẫu',
    'ui__mass-mail#to_admin_text__title' => 'Quản trị viên Plesk',
    'ui__mass-mail#to_clients_text__title' => 'Khách hàng',
    'ui__mass-mail#to_domains_text__title' => 'Quản trị viên tên miền',
    'ui__mass-mail#to_select_text__title' => 'Chọn địa chỉ',
    'ui__mass-mail#to_show_hide_text__title' => 'Hiển thị/ẩn được chọn',
    'ui__mass-mail#to_text__title' => 'Tới',
    'ui__mass-mail#tools_legend__title' => 'Công cụ',
    'ui__mass-mail__already_exists' => 'Mẫu có tên %1 đã tồn tại',
    'ui__mass-mail__none-available' => 'Bạn không có các mẫu tin nhắn.',

    'ui__mass-mail/delete__description' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt %1',

    'ui__mass-mail/delete__empty_selection' => 'Hãy chọn các mẫu mà bạn muốn gỡ bỏ',
    'ui__mass-mail/delete__short-title' => 'Laọi bỏ %1',
    'ui__mass-mail/delete__title' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt %1',
    'ui__mass-mail/delete_multi__description' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt.',

    'ui__mass-mail/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__mass-mail/delete_multi__title' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/delete_multi__wizard-title' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/delete_multi__wizard__1_multi' => 'Chọn biểu mẫu tin nhắn email hàng loạt bạn muốn gỡ bỏ.',
    'ui__mass-mail/delete_multi__wizard__2_multi' => 'Xác nhận gỡ bỏ các mẫu bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.',
    'ui__mass-mail/delete_unknown__description' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt.',
    'ui__mass-mail/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__mass-mail/delete_unknown__title' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/delete_unknown__wizard-title' => 'Gỡ bỏ biểu mẫu tin nhắn email hàng loạt.',
    'ui__mass-mail/delete_unknown__wizard__1_unknown' => 'Chọn biểu mẫu tin nhắn email hàng loạt mà bạn muốn gỡ bỏ.',
    'ui__mass-mail/delete_unknown__wizard__2' => 'Xác nhận gỡ bỏ các mẫu bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.',

    'ui__mass-mail/properties__description' => 'Chỉnh sửa biểu mẫu tin nhắn email %1.',

    'ui__mass-mail/properties__invalid_values' => 'Giá trị được nhập không chính xác',
    'ui__mass-mail/properties__short-title' => '%1',
    'ui__mass-mail/properties__title' => 'Chỉnh sửa biểu mẫu tin nhắn email %1',

    'ui__mass-mail/properties_new__wizard-title' => 'Tạo biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/properties_unknown-new__description' => 'Tạo một biểu mẫu tin nhắn email.',
    'ui__mass-mail/properties_unknown-new__short-title' => 'Thêm một biểu mẫu tin nhắn email',
    'ui__mass-mail/properties_unknown-new__title' => 'Tạo biểu mẫu tin nhắn email',
    'ui__mass-mail/properties_unknown__wizard-title' => 'Chỉnh sửa biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-mail/properties_unknown__wizard__1_unknown' => 'Chọn mẫu mà bạn muốn sửa đổi và nhấn Tiếp tục >>.',
    'ui__mass-mail/properties_unknown__wizard__2' => 'Khi hiệu chỉnh mẫu xong, hãy nhấn Hoàn tất để gửi tin nhắn và thoát khỏi trình thuật sĩ.',

    'ui__mass-mail/send__invalid_values' => 'Bạn đã nhập giá trị không chính xác',

    'ui__mass-mail/send_new__wizard-title' => 'Tạo một Biểu mẫu tin nhắn và Gửi email',
    'ui__mass-mail/send_unknown-new__description' => 'Gửi email cho người nhận đã chọn',

    'ui__mass-mail/send_unknown-new__short-title' => 'Gửi email hàng loạt',
    'ui__mass-mail/send_unknown-new__title' => 'Gửi tin nhắn email hàng loạt',
    'ui__mass-mail/send_unknown__description' => 'Gửi email cho người nhận đã chọn',

    'ui__mass-mail/send_unknown__short-title' => 'Gửi email hàng loạt',
    'ui__mass-mail/send_unknown__title' => 'Gửi tin nhắn email hàng loạt',
    'ui__mass-mail/send_unknown__wizard-title' => 'Gửi tin nhắn email hàng loạt',
    'ui__mass-mail/send_unknown__wizard__1_unknown' => 'Chọn mẫu mà bạn cần và nhấn Tiếp tục >>.',
    'ui__mass-mail/send_unknown__wizard__2' => 'Khi hiệu chỉnh các thuộc tính của các nút xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',

    'ui__mass-email/delete__description' => 'Gỡ bỏ các biểu mẫu tin nhắn email hàng loạt đã chọn.',

    'ui__mass-email/delete__empty_selection' => "Chọn các biểu mẫu mà bạn muốn gỡ bỏ.",
    'ui__mass-email/delete__short-title' => "Laọi bỏ %1",
    'ui__mass-email/delete__title' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt %1",
    'ui__mass-email/delete_multi__description' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt.",

    'ui__mass-email/delete_multi__short-title' => "Gỡ bỏ",
    'ui__mass-email/delete_multi__title' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/delete_multi__wizard__mass-mail/delete_multi' => "Xác nhận gỡ bỏ các mẫu bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.",
    'ui__mass-email/delete_multi__wizard__mass-mail_multi' => "Chọn biểu mẫu tin nhắn email hàng loạt bạn muốn gỡ bỏ.",
    'ui__mass-email/delete_multi__wizard-title' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/delete_unknown__description' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt.",
    'ui__mass-email/delete_unknown__short-title' => "Gỡ bỏ",
    'ui__mass-email/delete_unknown__title' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/delete_unknown__wizard__mass-mail/delete' => "Xác nhận gỡ bỏ các mẫu bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.",
    'ui__mass-email/delete_unknown__wizard__mass-mail_unknown' => "Chọn biểu mẫu tin nhắn email hàng loạt mà bạn muốn gỡ bỏ.",
    'ui__mass-email/delete_unknown__wizard-title' => "Gỡ bỏ biểu mẫu tin nhắn email hàng loạt.",
    'ui__mass-email/send__description' => "Gửi email cho người nhận đã chọn",
    'ui__mass-email/send__short-title' => "Gửi email hàng loạt",
    'ui__mass-email/send__title' => "Gửi tin nhắn email hàng loạt",
    'ui__mass-email/send_main__description' => "Gửi email cho người nhận đã chọn",

    'ui__mass-email/send_main__short-title' => "Gửi email hàng loạt",
    'ui__mass-email/send_main__title' => "Gửi tin nhắn email hàng loạt",
    'ui__mass-email/send_selectresellers__title' => 'Chọn các đại lý',
    'ui__mass-email/send_selectresellers__short-title' => 'Các đại lý',
    'ui__mass-email/send_selectresellers__description' => 'Chọn các tài khoản đại lý',

    'ui__mass-email/send_selectclients__description' => "Chọn các tài khoản khách hàng",

    'ui__mass-email/send_selectclients__short-title' => "Khách hàng",
    'ui__mass-email/send_selectclients__title' => "Chọn khách hàng",
    'ui__mass-email/send_selectdomainusers__description' => "Chọn các tài khoản quản trị tên miền",

    'ui__mass-email/send_selectdomainusers__short-title' => "Quản trị viên tên miền",
    'ui__mass-email/send_selectdomainusers__title' => "Chọn các quản trị viên miền",
    'ui__mass-email/template/properties_main__description' => "Tạo biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/template/properties_main__short-title' => "Chỉnh sửa mẫu",
    'ui__mass-email/template/properties_main__title' => "Chỉnh sửa biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/template/properties_new-main__description' => "Tạo biểu mẫu cho tin nhắn email hàng loạt.",
    'ui__mass-email/template/properties_new-main__short-title' => "Tạo biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/template/properties_new-main__title' => "Tạo biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/template/properties_new-selectclients__description' => "Chọn những khách hàng sẽ nhận được tin nhắn email hàng loạt dựa trên mẫu này",
    'ui__mass-email/template/properties_new-selectclients__title' => "Chọn những khách hàng sẽ nhận được tin nhắn email hàng loạt dựa trên mẫu này",
    'ui__mass-email/template/properties_new-selectdomainusers__description' => "Chọn những quản trị tên miền sẽ nhận được thư hàng loạt dựa trên mẫu này.",
    'ui__mass-email/template/properties_new-selectdomainusers__title' => "Chọn những quản trị tên miền sẽ nhận được thư hàng loạt dựa trên mẫu này.",
    'ui__mass-email/template/properties_selectclients__title' => "Chọn những khách hàng sẽ nhận được tin nhắn email hàng loạt dựa trên mẫu này",
    'ui__mass-email/template/properties_selectdomainusers__title' => "Chọn những quản trị tên miền sẽ nhận được thư hàng loạt dựa trên mẫu này.",

    'ui__mass-email/template/properties_unknown-new__description' => "Tạo biểu mẫu tin nhắn email hàng loạt",
    'ui__mass-email/template/properties_unknown-new__short-title' => "Tạo mẫu",
    'ui__mass-email/template/properties_unknown-new__title' => "Tạo biểu mẫu tin nhắn email hàng loạt",
    'ui__news/dismiss__description' => 'Nhấp để đóng khung tin tức. Plesk sẽ không hiển thị khung này cho đến khi các bài tin tức được cập nhật.',

    'ui__news/dismiss__title' => 'Đóng tin tức',

    'ui__server__description' => 'Quản lý máy chủ.',
    'ui__server__short-title' => 'Quản lý máy chủ của bạn',
    'ui__server__title' => 'Quản lý máy chủ',


    // UNUSED SINCE 9.2



    // END OF UNUSED SINCE 9.2

    'ui__server/ip-address__disabled-warning' => 'Các địa chỉ IP %1 không có hiệu lực.',
    'ui__server/ip-address__none-available' => 'Không có địa chỉ IP nào.',
    'ui__server/ip-addresses/ip-address__title' => "Các địa chỉ IP",
    'ui__server/ip-address/client/properties_new__description' => "Gán địa chỉ IP %1 cho đại lý.",
    'ui__server/ip-address/client/properties_new__short-title' => 'Gán',
    'ui__server/ip-address/client/properties_new__title' => "Gán địa chỉ IP %1 cho đại lý",
    'ui__server/ip-address/client__none-available' => 'Không có tài khoản người dùng nào',
    'ui__server/ip-address/client_unknown__quick_search' => 'Người dung',
    'ui__server/ip-address/client_unknown__wizard-title' => 'Danh sách những người dùng sử dụng địa chỉ IP này.',
    'ui__server/ip-address/client_unknown__wizard__3_unknown' => 'Hãy lựa chọn địa chỉ IP.',
    'ui__server/ip-address/client/delete__description' => 'Bỏ gán địa chỉ IP khỏi đại lý.',
    'ui__server/ip-address/client/delete__short-title' => 'Bỏ gán',
    'ui__server/ip-address/client/delete__title' => 'Bỏ gán địa chỉ IP khỏi đại lý',
    'ui__server/ip-address/client/delete_multi__description' => "Bỏ gán địa chỉ IP khỏi dãy của đại lý.",

    'ui__server/ip-address/client/delete_multi__short-title' => 'Bỏ gán',
    'ui__server/ip-address/client/delete_multi__title' => 'Bỏ gán một địa chỉ IP khỏi đại lý',
    'ui__server/ip-address/client/delete_multi__wizard-title' => "Gỡ bỏ địa chỉ IP khỏi dãy của người dùng.",
    'ui__server/ip-address/client/delete_multi__wizard__3_unknown' => 'Chọn địa chỉ IP mà bạn muốn bỏ gán khỏi người dùng và nhấn Tiếp tục >>.',
    'ui__server/ip-address/client/delete_multi__wizard__3_multi' => 'Chọn người dùng mà bạn muốn bỏ gán địa chỉ IP và nhấn Tiếp tục >>.',
    'ui__server/ip-address/client/delete_multi__wizard__4_multi' => 'Xác nhận bỏ gán địa chỉ IP của người dùng bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.',
    'ui__server/ip-address/client/delete_unknown__description' => 'Bỏ gán một địa chỉ IP khỏi đại lý.',
    'ui__server/ip-address/client/delete_unknown__short-title' => 'Bỏ gán',
    'ui__server/ip-address/client/delete_unknown__title' => 'Bỏ gán địa chỉ IP khỏi đại lý',
    'ui__server/ip-address/client/delete_unknown__wizard-title' => 'Bỏ gán một địa chỉ IP khỏi người dùng',
    'ui__server/ip-address/client/delete_unknown__wizard__3_unknown' => 'Chọn địa chỉ IP mà bạn muốn bỏ gán khỏi người dùng và nhấn Tiếp tục >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__4_unknown' => 'Chọn người dùng từ mà bạn muốn bỏ gán địa chỉ IP và nhấn Tiếp tục >>.',
    'ui__server/ip-address/client/delete_unknown__wizard__5' => 'Xác nhận bỏ gán địa chỉ IP của người dùng bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn thành trình thuật sĩ.',

    'ui__server/ip-address/domain__description' => "Tất cả các tên miền trên địa chỉ IP %1.",
    'ui__server/ip-address/domain__short-title' => "Các tên miền",
    'ui__server/ip-address/domain__title' => "Tên miền trên địa chỉ IP %1",
    'ui__server/ip-address/domain_unknown__description' => "Tất cả các tên miền trên địa chỉ IP.",
    'ui__server/ip-address/domain_unknown__short-title' => "Các tên miền",
    'ui__server/ip-address/domain_unknown__title' => "Các tên miền trên địa chỉ IP",
    'ui__server/ip-address/domain_unknown__wizard__3_unknown' => "Chọn địa chỉ IP mà bạn cần và nhấn Tiếp tục >>.",

    'ui__server/ip-address/properties__description' => 'Thay đổi các thuộc tính của địa chỉ IP %1.',
    'ui__server/ip-address/properties__short-title' => 'Thuộc tính',
    'ui__server/ip-address/properties__title' => 'Thay đổi các thuộc tính của địa chỉ IP %1',

    'ui__server/ip-address/properties_new__wizard-title' => 'Thêm Địa chỉ IP',
    'ui__server/ip-address/properties_new__wizard__4_new' => 'Khi thay đổi các thuộc tính của địa chỉ IP xong, hãy nhấn Hoàn tất để áp dụng các thay đổi.',
    'ui__server/ip-address/properties_unknown__description' => 'Thay đổi các thuộc tính của địa chỉ IP.',
    'ui__server/ip-address/properties_unknown__short-title' => 'Thuộc tính',
    'ui__server/ip-address/properties_unknown__title' => 'Thay đổi các thuộc tính của địa chỉ IP',
    'ui__server/ip-address/properties_unknown__wizard-title' => 'Thay đổi các thuộc tính của địa chỉ IP',
    'ui__server/ip-address/properties_unknown__wizard__3_unknown' => 'Chọn địa chỉ IP có các thuộc tính mà bạn muốn thay đổi.',
    'ui__server/ip-address/properties_unknown__wizard__4' => 'Khi thay đổi các thuộc tính của địa chỉ IP xong, hãy nhấn Hoàn tất để áp dụng các thay đổi.',

    'ui__server/spam-filter/black-list__description' => 'Thiết lập danh sách từ chối của bộ lọc thư rác trên toàn bộ máy chủ.',
    'ui__server/spam-filter/black-list__short-title' => 'Danh sách từ chối',
    'ui__server/spam-filter/black-list__title' => 'Danh sách từ chối của bộ lọc thư rác trên toàn bộ máy chủ',

    'ui__server/spam-filter/black-list/address__addresses_available' => 'Chỉ các địa chỉ email đầu tiên %1 sẽ được thêm.',
    'ui__server/spam-filter/black-list/address__description' => 'Danh sách địa chỉ bị từ chối của bộ lọc thư rác.',

    'ui__server/spam-filter/black-list/address__empty_content' => 'Không có địa chỉ email nào trống trong danh sách.',
    'ui__server/spam-filter/black-list/address__file_size' => 'Tệp tin được tải lên rỗng.',
    'ui__server/spam-filter/black-list/address__invalid_addresses' => 'Các địa chỉ email sau đây không hợp lệ: %1.',
    'ui__server/spam-filter/black-list/address__none-available' => 'Không có địa chỉ nào trong danh sách của bộ lọc thư rác.',
    'ui__server/spam-filter/black-list/address__short-title' => 'Địa chỉ',
    'ui__server/spam-filter/black-list/address__title' => 'Danh sách địa chỉ bị từ chối %1',
    'ui__server/spam-filter/black-list/address_unknown__description' => 'Thêm địa chỉ vào danh sách từ chối.',
    'ui__server/spam-filter/black-list/address_unknown__short-title' => 'Thêm địa chỉ',
    'ui__server/spam-filter/black-list/address_unknown__title' => 'Thêm địa chỉ vào danh sách từ chối',

    'ui__server/spam-filter/black-list/address/delete__description' => 'Gỡ bỏ địa chỉ %1 khỏi danh sách từ chối trên toàn bộ máy chủ.',

    'ui__server/spam-filter/black-list/address/delete__short-title' => 'Gỡ bỏ',
    'ui__server/spam-filter/black-list/address/delete__title' => 'Gỡ bỏ địa chỉ %1 khỏi danh sách từ chối trên toàn bộ máy chủ',
    'ui__server/spam-filter/black-list/address/delete_multi__description' => 'Gỡ bỏ địa chỉ khỏi danh sách từ chối trên toàn bộ máy chủ.',

    'ui__server/spam-filter/black-list/address/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__server/spam-filter/black-list/address/delete_multi__title' => 'Gỡ bỏ địa chỉ khỏi danh sách từ chối trên toàn bộ máy chủ',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard-title' => 'Gỡ bỏ các địa chỉ khỏi danh sách từ chối của bộ lọc thư rác trên toàn bộ máy chủ',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__4_multi' => 'Chọn các địa chỉ bộ lọc thư rác mà bạn muốn gỡ bỏ và nhấn Tiếp tục >>',
    'ui__server/spam-filter/black-list/address/delete_multi__wizard__5_multi' => 'Xác nhận gỡ bỏ các địa chỉ bộ lọc thư rác, bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn toàn gỡ bỏ chúng và thoát khỏi trình thuật sĩ.',
    'ui__server/spam-filter/black-list/address/delete_unknown__description' => 'Gỡ bỏ địa chỉ khỏi danh sách từ chối trên toàn bộ máy chủ.',
    'ui__server/spam-filter/black-list/address/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__server/spam-filter/black-list/address/delete_unknown__title' => 'Gỡ bỏ các địa chỉ khỏi danh sách từ chối trên toàn bộ máy chủ',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard-title' => 'Gỡ bỏ các địa chỉ khỏi danh sách từ chối của bộ lọc thư rác trên toàn bộ máy chủ',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__4_unknown' => 'Chọn địa chỉ bộ lọc thư rác mà bạn muốn gỡ bỏ và nhấn Tiếp tục >>',
    'ui__server/spam-filter/black-list/address/delete_unknown__wizard__5' => 'Xác nhận gỡ bỏ địa chỉ bộ lọc thư rác, bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn toàn gỡ bỏ nó và thoát khỏi trình thuật sĩ.',

    'ui__server/spam-filter/black-list/address/properties__addresses_available' => 'Chỉ các địa chỉ email đầu tiên %1 sẽ được thêm.',
    'ui__server/spam-filter/black-list/address/properties__empty_content' => 'Không có địa chỉ email nào trống trong danh sách.',
    'ui__server/spam-filter/black-list/address/properties__file_size' => 'Không thể tải lên tập tin. Kích thước tối đa của một tập tin để tải lên là %1.',
    'ui__server/spam-filter/black-list/address/properties__invalid_addresses' => 'Các địa chỉ email sau đây không hợp lệ: %1.',

    'ui__server/spam-filter/black-list/address/properties_unknown-new__description' => 'Thêm địa chỉ vào danh sách từ chối.',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__short-title' => 'Thêm địa chỉ',
    'ui__server/spam-filter/black-list/address/properties_unknown-new__title' => 'Thêm địa chỉ vào danh sách từ chối',

    'ui__server/spam-filter/properties__description' => 'Khởi tạo bộ lọc thư rác trên toàn máy chủ.',

    'ui__server/spam-filter/properties__short-title' => 'Cài đặt',
    'ui__server/spam-filter/properties__title' => 'Các thiết lập bộ lọc thư rác',

    'ui__server/spam-filter/toggle_disable__description' => 'Vô hiệu hoá lọc thư rác cho toàn bộ hệ thống.',

    'ui__server/spam-filter/toggle_disable__short-title' => 'Tắt',
    'ui__server/spam-filter/toggle_disable__title' => 'Vô hiệu hoá lọc thư rác',
    'ui__server/spam-filter/toggle_enable__description' => 'Kích hoạt tính năng lọc thư rác cho toàn bộ máy chủ.',

    'ui__server/spam-filter/toggle_enable__short-title' => 'Bật',
    'ui__server/spam-filter/toggle_enable__title' => 'Kích hoạt tính năng lọc thư rác',
    'ui__server/spam-filter/toggle_unknown__description' => 'Kích hoạt hoặc vô hiệu hoá tính năng lọc thư rác cho toàn bộ máy chủ.',
    'ui__server/spam-filter/toggle_unknown__short-title' => 'Kích hoạt hoặc vô hiệu hóa',
    'ui__server/spam-filter/toggle_unknown__title' => 'Kích hoạt hoặc vô hiệu hoá tính năng lọc thư rác',
    'ui__server/spam-filter/toggle_unknown__wizard-title' => 'Kích hoạt hoặc vô hiệu hóa bộ lọc thư rác',

    'ui__server/spam-filter/white-list__description' => 'Thiết đặt danh sách cho phép của bộ lọc thư rác trên toàn bộ hệ thống.',
    'ui__server/spam-filter/white-list__short-title' => 'Danh sách cho phép',
    'ui__server/spam-filter/white-list__title' => 'Danh sách cho phép của bộ lọc thư rác trên toàn bộ hệ thống',

    'ui__server/spam-filter/white-list/address__addresses_available' => 'Chỉ các địa chỉ email đầu tiên %1 sẽ được thêm.',
    'ui__server/spam-filter/white-list/address__description' => 'Danh sách địa chỉ cho phép của bộ lọc thư rác.',

    'ui__server/spam-filter/white-list/address__empty_content' => 'Không có địa chỉ email nào trống trong danh sách.',
    'ui__server/spam-filter/white-list/address__file_size' => 'Tệp tin được tải lên rỗng.',
    'ui__server/spam-filter/white-list/address__invalid_addresses' => 'Các địa chỉ email sau đây không hợp lệ: %1.',
    'ui__server/spam-filter/white-list/address__none-available' => 'Không có địa chỉ trong danh sách cho phép bộ lọc thư rác trên toàn bộ máy chủ.',
    'ui__server/spam-filter/white-list/address__short-title' => 'Địa chỉ',
    'ui__server/spam-filter/white-list/address__title' => 'Danh sách cho phép %1',
    'ui__server/spam-filter/white-list/address_unknown__description' => 'Thêm địa chỉ vào danh sách cho phép.',
    'ui__server/spam-filter/white-list/address_unknown__short-title' => 'Thêm địa chỉ',
    'ui__server/spam-filter/white-list/address_unknown__title' => 'Thêm địa chỉ vào danh sách cho phép',

    'ui__server/spam-filter/white-list/address/delete__description' => 'Gỡ bỏ %1 địa chỉ khỏi danh sách cho phép trong toàn bộ máy chủ.',

    'ui__server/spam-filter/white-list/address/delete__short-title' => 'Gỡ bỏ',
    'ui__server/spam-filter/white-list/address/delete__title' => 'Gỡ bỏ %1 địa chỉ khỏi danh sách cho phép trong toàn bộ máy chủ',
    'ui__server/spam-filter/white-list/address/delete_multi__description' => 'Gỡ bỏ địa chỉ khỏi danh sách cho phép trong toàn bộ máy chủ.',

    'ui__server/spam-filter/white-list/address/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__server/spam-filter/white-list/address/delete_multi__title' => 'Gỡ bỏ địa chỉ khỏi danh sách cho phép trong toàn bộ máy chủ',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard-title' => 'Gỡ bỏ các địa chỉ khỏi danh sách cho phép bộ lọc thư rác trong toàn bộ máy chủ',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__4_multi' => 'Chọn các địa chỉ bộ lọc thư rác mà bạn muốn gỡ bỏ và nhấn Tiếp tục >>',
    'ui__server/spam-filter/white-list/address/delete_multi__wizard__5_multi' => 'Xác nhận gỡ bỏ các địa chỉ bộ lọc thư rác, bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn toàn gỡ bỏ chúng và thoát khỏi trình thuật sĩ.',
    'ui__server/spam-filter/white-list/address/delete_unknown__description' => 'Gỡ bỏ địa chỉ khỏi danh sách cho phép trong toàn bộ máy chủ.',
    'ui__server/spam-filter/white-list/address/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__server/spam-filter/white-list/address/delete_unknown__title' => 'Gỡ bỏ địa chỉ khỏi danh sách cho phép trong toàn bộ máy chủ',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard-title' => 'Gỡ bỏ các địa chỉ khỏi danh sách cho phép bộ lọc thư rác trong toàn bộ máy chủ',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__4_unknown' => 'Chọn địa chỉ bộ lọc thư rác mà bạn muốn gỡ bỏ và nhấn Tiếp tục >>',
    'ui__server/spam-filter/white-list/address/delete_unknown__wizard__5' => 'Xác nhận gỡ bỏ địa chỉ bộ lọc thư rác, bằng cách đánh dấu vào ô và nhấn Hoàn tất để hoàn toàn gỡ bỏ nó và thoát khỏi trình thuật sĩ.',

    'ui__server/spam-filter/white-list/address/properties__addresses_available' => 'Chỉ các địa chỉ email đầu tiên %1 sẽ được thêm.',
    'ui__server/spam-filter/white-list/address/properties__empty_content' => 'Không có địa chỉ email nào trống trong danh sách.',
    'ui__server/spam-filter/white-list/address/properties__file_size' => 'Không thể tải lên tập tin. Kích thước tối đa của một tập tin để tải lên là %1.',
    'ui__server/spam-filter/white-list/address/properties__invalid_addresses' => 'Các địa chỉ email sau đây không hợp lệ: %1.',

    'ui__server/spam-filter/white-list/address/properties_unknown-new__description' => 'Thêm địa chỉ vào danh sách cho phép.',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__short-title' => 'Thêm địa chỉ',
    'ui__server/spam-filter/white-list/address/properties_unknown-new__title' => 'Thêm địa chỉ vào danh sách cho phép',

    'ui__server/mail/statistics#apply__description' => "Áp dụng bộ lọc",
    'ui__server/mail/statistics#apply__title' => "Áp dụng",
    'ui__server/mail/statistics#custom_from__title' => "từ",
    'ui__server/mail/statistics#custom_to__title' => "đến",
    'ui__server/mail/statistics#period_all__title' => "Tất cả",
    'ui__server/mail/statistics#period_custom__title' => "Tuỳ biến",
    'ui__server/mail/statistics#period_month__title' => "Tháng này",
    'ui__server/mail/statistics#period_prev_month__title' => "Tháng trước",
    'ui__server/mail/statistics#period_prev_week__title' => "Tuần trước",
    'ui__server/mail/statistics#period_today__title' => "Hôm nay",
    'ui__server/mail/statistics#period_week__title' => "Tuần này",
    'ui__server/mail/statistics#period_yesterday__title' => "Hôm qua",
    'ui__server/mail/statistics#show_for_period__title' => "Hiển thị giai đoạn",
    'ui__server/mail/statistics#tools_legend__title' => "Công cụ",
    'ui__server/mail/statistics__description' => "Xem số liệu thống kê thư rác và virus",

    'ui__server/mail/statistics__short-title' => "Thống kê",
    'ui__server/mail/statistics__title' => "Thống kê",
    'ui__server/mail/statistics/spam#statistics_legend__title' => "Thống kê thư rác",
    'ui__server/mail/statistics/spam#tools_legend__title' => "Công cụ",
    'ui__server/mail/statistics/spam__description' => "Xem số liệu thống kê thư rác",

    'ui__server/mail/statistics/spam__short-title' => "Thống kê thư rác",
    'ui__server/mail/statistics/spam__title' => "Thống kê thư rác",
    'ui__server/mail/statistics/spam/recipients#list_header__name__title' => "Tên thư",
    'ui__server/mail/statistics/spam/recipients#list_header__ratio__title' => "% trong tổng số",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_name__title' => "Sắp xếp theo tài khoản thư",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_ratio__title' => "Sắp xếp theo % trong tổng số",
    'ui__server/mail/statistics/spam/recipients#list_header__sort_by_val__title' => "Sắp xếp theo thư rác nhận được",
    'ui__server/mail/statistics/spam/recipients#list_header__title' => "các tài khoản thư",
    'ui__server/mail/statistics/spam/recipients#list_header__val__title' => "Thư rác nhận được",
    'ui__server/mail/statistics/spam/recipients__description' => "Người nhận",

    'ui__server/mail/statistics/spam/recipients__short-title' => "Người nhận",
    'ui__server/mail/statistics/spam/recipients__title' => "Người nhận",
    'ui__server/mail/statistics/spam/summary#clean__title' => "Xóa",
    'ui__server/mail/statistics/spam/summary#infected__title' => "Đã bị nhiễm",
    'ui__server/mail/statistics/spam/summary#list_header__name__title' => "Trạng thái",
    'ui__server/mail/statistics/spam/summary#list_header__ratio__title' => "% trong tổng số",
    'ui__server/mail/statistics/spam/summary#list_header__val__title' => "Đếm",
    'ui__server/mail/statistics/spam/summary#protected__title' => "Được bảo vệ",
    'ui__server/mail/statistics/spam/summary#skipped__title' => "Chưa kiểm tra",
    'ui__server/mail/statistics/spam/summary__description' => "Tóm tắt",

    'ui__server/mail/statistics/spam/summary__short-title' => "Tóm tắt",
    'ui__server/mail/statistics/spam/summary__title' => "Tóm tắt",
    'ui__server/mail/statistics/virus#statistics_legend__title' => "Thống kê virus",
    'ui__server/mail/statistics/virus#tools_legend__title' => "Công cụ",
    'ui__server/mail/statistics/virus__description' => "Xem thống kê virus",

    'ui__server/mail/statistics/virus__short-title' => "Thống kê virus",
    'ui__server/mail/statistics/virus__title' => "Thống kê virus",
    'ui__server/mail/statistics/virus/recipients#list_header__name__title' => "Tài khoản thư",
    'ui__server/mail/statistics/virus/recipients#list_header__ratio__title' => "% trong tổng số",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_name__title' => "Sắp xếp theo tựa đề thư",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_ratio__title' => "Sắp xếp theo % trong tổng số",
    'ui__server/mail/statistics/virus/recipients#list_header__sort_by_val__title' => "Sắp xếp theo viruses nhận được",
    'ui__server/mail/statistics/virus/recipients#list_header__title' => "Các tài khoản thư",
    'ui__server/mail/statistics/virus/recipients#list_header__val__title' => "Viruses đã nhận",
    'ui__server/mail/statistics/virus/recipients__description' => "Người nhận",

    'ui__server/mail/statistics/virus/recipients__short-title' => "Người nhận",
    'ui__server/mail/statistics/virus/recipients__title' => "Người nhận",
    'ui__server/mail/statistics/virus/summary#clean__title' => "Xóa",
    'ui__server/mail/statistics/virus/summary#infected__title' => "Đã bị nhiễm",
    'ui__server/mail/statistics/virus/summary#list_header__name__title' => "Trạng thái",
    'ui__server/mail/statistics/virus/summary#list_header__ratio__title' => "% trong tổng số",
    'ui__server/mail/statistics/virus/summary#list_header__val__title' => "Đếm",
    'ui__server/mail/statistics/virus/summary#protected__title' => "Được bảo vệ",
    'ui__server/mail/statistics/virus/summary#skipped__title' => "Chưa kiểm tra",
    'ui__server/mail/statistics/virus/summary__description' => "Tóm tắt",

    'ui__server/mail/statistics/virus/summary__short-title' => "Tóm tắt",
    'ui__server/mail/statistics/virus/summary__title' => "Tóm tắt",
    'ui__server/mail/statistics/virus/viruses#list_header__name__title' => "Tên",
    'ui__server/mail/statistics/virus/viruses#list_header__ratio__title' => "% trong tổng số",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_name__title' => "Sắp xếp theo tên",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_ratio__title' => "Sắp xếp theo % trong tổng số",
    'ui__server/mail/statistics/virus/viruses#list_header__sort_by_val__title' => "Sắp xếp theo các đối tượng bị nhiễm",
    'ui__server/mail/statistics/virus/viruses#list_header__title' => "Viruses",
    'ui__server/mail/statistics/virus/viruses#list_header__val__title' => "Đối tượng bị nhiễm",
    'ui__server/mail/statistics/virus/viruses__description' => "Viruses",

    'ui__server/mail/statistics/virus/viruses__short-title' => "Viruses",
    'ui__server/mail/statistics/virus/viruses__title' => "Viruses",

    'ui__support#param_company__title' => "Công ty",
    'ui__support#param_email__title' => "Email",
    'ui__support#param_firstname__title' => "Tên",
    'ui__support#param_keynumber__title' => "Số mã sản phẩm",
    'ui__support#param_operatingsystem__title' => "Hệ điều hành",
    'ui__support#param_phone__title' => "Điện thoại",
    'ui__support#param_psabuild__title' => "Bản tạo Plesk",
    'ui__support#param_psainsttype__title' => "Loại cài đặt Plesk",
    'ui__support#param_psaversion__title' => "Phiên bản Plesk",

    // *** The strings above have been generated automatically from @@CAPTION directives.

    ////
    //// UI POINTER CAPTIONS END HERE


    // RESELLERS

    // Resellers
    'ui__reseller#tools__title' => "Công cụ",

    'ui__reseller/traffic-history_unknown__short-title' => "Xem lưu lượng truy cập của đại lý",
    'ui__reseller/traffic-history_unknown__title' => "Xem lưu lượng truy cập của đại lý",
    'ui__reseller/traffic-history_unknown__description' => "Xem lưu lượng truy cập của tài khoản đại lý.",
    'ui__reseller#list__title' => "Các đại lý",
    'accounts_list__name__filter_title' => "Tên",
    'accounts_list__resource__filter_title' => "Tài nguyên sử dụng",
    'resellers_list__filter_resource_usage_any' => "Bất kỳ",
    'resellers_list__filter_resource_usage_overuse' => "Sử dụng vượt định mức",
    'resellers_list__filter_resource_usage_normal' => "Trong giới hạn",
    'accounts_list__status__filter_title' => "Trạng thái",
    'resellers_list__filter_status_any' => "Bất kỳ",
    'resellers_list__filter_status_blocked' => "Đã treo",
    'resellers_list__filter_status_active' => "Hiện hoạt",
    'resellers_list__filter_clients__filter_title' => "Hiển thị",
    'resellers_list__filter_clients_on' => "Ðại lý và khách hàng của họ",
    'resellers_list__filter_clients_off' => "Chỉ các đại lý",
    '__disk_usage' => "Không gian đĩa đã sử dụng",
    'ui__reseller/traffic_unknown__short-title' => "Xem lưu lượng truy cập của đại lý",
    'ui__reseller/traffic_unknown__title' => "Xem lưu lượng truy cập của đại lý",
    'ui__reseller/traffic#list__title' => "Lưu lượng truy cập của đại lý",
    'ui__reseller/traffic_unknown__description' => "Xem các báo cáo lưu lượng sử dụng.",

    // Resellers > Traffic by resellers
    '__traffic_by_reseller' => "Lưu lượng truy cập của đại lý",

    '__reseller_name' => "Tên của đại lý",
    '__reseller' => "Các đại lý",
    'resellertrafficlist_header' => "Xem lưu lượng truy cập của đại lý",
    '__reseller_personal' => "Lưu lượng truy cập được sử dụng bởi các tên miền của đại lý",
    'ui__reseller/traffic-history__short-title' => "Lưu lượng truy cập của đại lý",
    'ui__reseller/traffic-history__title' => "Lưu lượng truy cập của đại lý",
    'ui__reseller/traffic-history__description' => "Xem các báo cáo lưu lượng sử dụng.",

    // Resellers > Create Reseller Account
    'ui__reseller__short-title' => "%1",

    // Resellers > Reseller preferences

    // Resellers > Reseller Account Templates

    // Resellers > Reseller Account Templates > Create Reseller Account Template
    'limits__oversell_text' => "Cho phép bán vượt định mức",
    'limits__reseller_oversell_description' => "Bán vượt định mức cho phép các đại lý bán nhiều tài nguyên hơn trên thực tế đã được giao cho họ. Nếu được phép bán vượt định mức, đại lý được chi phối theo thực tế sử dụng tài nguyên thay vì tài nguyên được phân bổ ban đầu",
    'limits__overuse_block_text' => "Chính sách sử dụng vượt định mức",
    'limits__overuse_block_true_text' => "Không được phép sử dụng quá mức",
    'limits__reseller_overuse_block_true_description' => "Ngăn cản sử dụng quá giới hạn tài nguyên. Thực tế tài nguyên sử dụng không thể vượt quá sự phân bổ tài nguyên ban đầu",
    'limits__overuse_block_false_text' => "Được phép sử dụng quá mức",
    'limits__reseller_overuse_block_false_description' => "Không ngăn cản sử dụng quá giới hạn tài nguyên, cho phép các đại lý sử dụng nhiều hơn các tài nguyên đầu tiên được cung cấp. Tài nguyên sử dụng thực tế có thể vượt quá lượng phân bổ ban đầu",
    'limits__reseller_overuse_notify_text' => "Cảnh báo đại lý về việc sử dụng quá giới hạn tài nguyên",
    'reseller_perm__manage_sh_access_disabled' => "Đại lý có thể không thể cho phép hoặc không cho phép truy cập dòng lệnh",
    'reseller_perm__manage_sh_access_chrooted' => "Đại lý chỉ có thể cho phép truy cập vào một môi trường chroot",
    'reseller_perm__manage_sh_access_any' => "Đại lý có thể cho phép truy cập vào bất kỳ loại shell nào",
    'template__reseller_num_excl_ips' => "Phân bổ địa chỉ IP chuyên dụng cho đại lý",

    // Reseller's Home page
    'ui__reseller#tools2__title' => "Tài khoản",
    'ui__reseller#info__title' => "Thông báo",
    'ui__reseller#clientsTab__title' => "Khách hàng",
    'ui__reseller#domainsTab__title' => "Các tên miền",
    'ui__reseller__title' => "Quản lý tài khoản đại lý của %1",
    'domains__reseller_info' => "%1 khách hàng, %2 các tên miền, %3 của không gian đĩa được sử dụng, %4 của dữ liệu được chuyển giao.",
    'domains__reseller_info_hiding_traffic' => "%1 khách hàng, %2 các tên miền, %3 của không gian đĩa được sử dụng.",
    'ui__reseller__description' => "Quản lý tài khoản đại lý.",

    'ui__reseller/limits_unknown__wizard-title' => 'Xem hoặc thay đổi giới hạn tài nguyên cho đại lý',
    'ui__reseller/limits_unknown__wizard__1_unknown' => 'Chọn đại lý mà bạn cần.',
    'ui__reseller/limits_unknown__wizard__2' => 'Để áp dụng các thay đổi, hãy nhấn Hoàn tất.',

    'ui__client/report_reseller__short-title' => "Báo cáo",
    'ui__client/report_reseller__title' => "Xem báo cáo tài khoản",
    'ui__client/report_reseller__description' => "Xem báo cáo tài khoản đại lý.",
    'ui__client/ip-pool_reseller__short-title' => "Dãy IP",
    'ui__client/ip-pool_reseller__description' => "Chỉ định địa chỉ IP và chứng nhận SSL/TLS cho tài khoản đại lý.",

    //'ui__client/preferences_reseller__short-title' => "Settings",
    //'ui__client/preferences_reseller__description' => "Set Plesk session settings.",

    'ui__reseller/preferences_unknown__wizard__2_self' => "Chỉ định các thiết lập tài khoản và nhấn Hoàn tất.",

    //'ui__client/permissions_reseller__short-title' => "Permissions",
    //'ui__client/permissions_reseller__description' => "View or change permissions for the reseller's account.",

    'ui__reseller/permissions_unknown__wizard-title' => 'Xem hoặc thay đổi quyền truy cập cho đại lý',
    'ui__reseller/permissions_unknown__wizard__1_unknown' => 'Lựa chọn những đại lý có quyền truy cập mà bạn muốn xem hoặc thay đổi.',
    //'ui__reseller/permissions_unknown__wizard__1/properties_self' => 'When done with viewing your permissions, click Finish to to apply the changes and exit the wizard.',
    'ui__reseller/permissions_unknown__wizard__2' => 'Khi thay đổi quyền hạn của đại lý xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',

    // Customers > create customer account

    '__resellers_list' => 'Các đại lý',
    'picker_reseller__title' => 'Chọn đại lý',

    // Resellers > reseller name > customer name
    'ui__client#tools1__title' => "Công cụ",
    'ui__client#tools2__title' => "Tài khoản",
    'ui__client#info__title' => "Thông báo",
    'ui__client#clientslist__title' => "Khách hàng",
    'ui__client#domainslist__title' => "Các tên miền",

    // Reseller's session in the Customer Panel - Home page

    'feature__aps_categories__reseller' => "Tất cả các ứng dụng web hiện nay đã được sắp xếp theo danh mục, làm cho việc chọn các ứng dụng để cài đặt dễ dàng hơn.",
    'feature__domainkeys__reseller' => "Bạn có thể sử dụng cơ chế xác thực người gửi email DKIM để giảm số lượng thư rác và email giả mạo.",

    '__reseller_form' => "Hình thức đại lý",

    // Reseller's session in the control panel - Home page > Manage Customer Settings
    'ui__client/preferences_unknown__wizard__reseller' => "Chọn tài khoản khách hàng bạn muốn thay đổi thiết lập.",

    // Reseller's session in the control panel - Home page > Suspend/Activate Customer Account

    // Reseller's session in the control panel - Home page > Change Customer Limits
    'ui__client/limits_unknown__wizard__1' => "Để thay đổi giới hạn sử dụng các tài nguyên, nhấn Giới hạn tài nguyên.",

    // Reseller's session in the control panel - Home page > Change Customer Permissions
    'ui__client/permissions_unknown__wizard__1' => "Thay đổi quyền thao tác mà khách hàng có thể thực hiện trong Plesk, nhấp vào Quyền truy cập.",

    // Reseller's session in the control panel - Home page > Create Customer Template
    'template__shared_text' => "làm các mẫu này có hiệu lực với những người dùng khác",
    'template__shared_description' => "Lựa chọn tùy chọn này nếu bạn muốn khách hàng của bạn có thể sử dụng mẫu này.",

    // CLIENT (updated for reseller feature):

    // Customers
    'ui__client#tools__title' => 'Công cụ',

    'ui__client/traffic-history_unknown__short-title' => 'Xem lưu lượng truy cập của khách hàng',
    'ui__client/traffic-history_unknown__title' => 'Lưu lượng truy cập của khách hàng',
    'ui__client/traffic-history_unknown__description' => 'Xem báo cáo sử dụng lưu lượng truy cập của tất cả các khách hàng',
    'ui__client/traffic-history__short-title' => 'Lưu lượng truy cập của khách hàng',
    'ui__client/traffic-history__title' => 'Xem lưu lượng truy cập của khách hàng',
    'ui__client/traffic-history__description' => 'Xem báo cáo sử dụng lưu lượng truy cập của tất cả các khách hàng',

    'ui__client/traffic#list__title' => 'Lưu lượng truy cập của khách hàng',
    'ui__reseller/client/traffic#list__title' => 'Lưu lượng truy cập của khách hàng',

    'clients_list__filter_type__filter_title' => 'Hiển thị',
    'clients_list__filter_type_any' => 'Khách hàng và đại lý',
    'clients_list__filter_type_clients' => 'Chỉ khách hàng',
    'clients_list__filter_type_resellers' => 'Chỉ các đại lý',
    'ui__client/domain_unknown-new__short-title' => "Tạo tên miền",

    // Customers > View traffic by customers
    '__personal' => "Lưu lượng truy cập được sử dụng bởi người dùng tên miền",
    'PersonalTrafficList_header_of_client__' => "Xem Báo cáo sử dụng sử dụng lưu lượng truy cập bởi tài khoản của bạn",

    // DOMAINS

    // Domain > Domain Admin Permissions

    'domain_perm__manage_sh_access_disabled' => "Quản trị tên miền không thể cho phép hoặc không cho phép truy cập môi trường dòng lệnh",
    'domain_perm__manage_sh_access_chrooted' => "Quản trị tên miền chỉ có thể cho phép truy cập vào một môi trường chroot",
    'domain_perm__manage_sh_access_any' => "Quản trị tên miền có thể cho phép truy cập vào bất kỳ loại trình shell nào",

    // APS Catalog
    'bt_add_to_vault' => "Bổ sung vào Kho",
    'bt_hide_updates' => "Ẩn các bản cập nhật có hiệu lực",
    'bt_show_updates' => "Hiển thị các bản cập nhật có hiệu lực",

    '__site_apps__applications' => "Ứng dụng",
    //search elements
    // Application; Vendor; Packager; Certification level;

    '__site_apps__apps_selected_to_add_to_vault' => "Ứng dụng được chọn để đưa vào kho",
    'site_apps__application_selected' => "Được chọn",
    'site_apps__currently_in_vault' => "Các phiên bản khác đã có trong các kho:",
    'site_apps__new_versions' => "Phiên bản mới:",
    'site_apps__patches' => "Các bản vá lỗi:",
    'site_apps__applications_have_been_scheduled_for_adding_to_application_vault' => "Số lượng các ứng dụng được sắp xếp để bổ sung cho kho: %1",
    'site_apps__applications_downloading_now' => "Dưới đây là những ứng dụng hiện nay đang được tải xuống: %1", // temporary workaround string, to be removed later

    'site_apps__package_already_exist_in_vault' => "Đã có trong kho",

    // Server > Action Log
    'bt_skin_edit' => "Chỉnh sửa mô tả hình nền",
    'domains__you_want_change_the_status_of_the_reseller??' => "Bạn có chắc chắn rằng bạn muốn thay đổi tình trạng tài khoản đại lý?",
    'limits__oversell_legend' => "Bán vượt định mức",
    'limitsManager__limit_available_error' => "Không thể phân bổ các tài nguyên được yêu cầu (%%quantity%% %%limitName%%). Chỉ còn lại %%available%% %%limitName%%.",
    'limitsManager__limit_reserved_error' => "Không thể đặt được yêu cầu hạn chế sử dụng tài nguyên (%%quantity%% %%limitName%%) bởi vì giá trị mới ít hơn số lượng các tài nguyên dành riêng cho khách hàng của bạn hay được sử dụng cho chính bạn (%%reserved%% %%limitName%%).",
    'limitsManager__limit_used_error' => "Không thể đặt giới hạn sử dụng tài nguyên (%%quantity%% %%limitName%%) bởi vì giá trị mới thấp hơn thực tế số lượng tài nguyên đã được sử dụng của tài khoản của bạn và trang web (%%used%% %%limitName%%).",

    'ui__client/domain/traffic#list__title' => "Băng thông sử dụng bởi dịch vụ",

    'ui__client/domain/traffic_unknown-reseller__short-title' => "Xem báo cáo sử dụng lưu lượng truy cập",
    'ui__client/domain/traffic_unknown-reseller__title' => "Xem báo cáo sử dụng lưu lượng truy cập",

    'ui__client/domain_new__short-title' => "Tạo tên miền",

    'ui__client_reseller__description' => "Quản lý tài khoản đại lý %1.",
    'ui__client_reseller__short-title' => "%1",
    'ui__client_reseller__title' => "Quản lý các tài khoản đại lý",

    '__owner_name' => "Tên của chủ sở hữu",
    'domains_list__resource__filter_title' => "Sử dụng Tài nguyên",

    // APS CATALOG
    'site_apps__application_catalog_preferences' => "Danh mục các ứng dụng APS",
    'site_apps__applications_have_updates' => "Các phiên bản Cập nhật sau đây của các ứng dụng đang sẵng sàng:\n%1\nĐể xem các bản cập nhật, hãy chắc chắn rằng khu vực tìm kiếm được hiển thị, chọn ô <b>Chỉ hiển thị cập nhật</b> và tìm kiếm các ứng dụng mà bạn cần.",
    'site_apps__progress_adding_to_vault' => "Thêm vào kho:",
    'site_apps__progress_done_message' => "Tiến trình:",
    'site_apps__progress_applications_left' => "%1 trên %2 ứng dụng còn lại",
    'site_apps__download_item_long_task_title' => "Tải về ứng dụng APS (%1)",
    'site_apps__download_transaction_long_task_title' => "Tải về các ứng dụng APS từ danh mục APS",
    'site_apps__last_check_for_updates' => "lần kiểm tra mới nhất cho các cập nhật: %1",
    'site_apps__all_sucessfully_added_to_app_vault' => "Tất cả các ứng dụng lập kế hoạch được bổ sung thành công vào kho ứng dụng",
    'site_apps__number_of_apps_sucessfully_added_to_app_vault' => "%1 các ứng dụng lập kế hoạch được bổ sung thành công vào kho ứng dụng.",
    'site_apps__no_search_results' => 'Không tìm thấy các ứng dụng. Hãy thử các yêu cầu tìm kiếm hoặc duyệt qua các ứng dụng của danh mục.',
    'site_apps__search_results_title' => 'Kết quả tìm kiếm',
    '__site_apps__search_by_application' => 'Tên ứng dụng',
    '__site_apps__search_by_vendor' => 'Người bán',
    '__site_apps__search_by_vendor__all' => 'Tất cả các nhà cung cấp',
    '__site_apps__search_by_packager' => 'Trình Đóng gói',
    '__site_apps__search_by_certification_level' => 'Cấp chứng chỉ',
    '__site_apps__search_by_cert__any' => 'Bất kỳ',
    '__site_apps__search_by_cert__silver_and_higher' => 'Bạc và cao hơn',
    '__site_apps__search_by_cert__gold_and_higher' => 'Vàng và cao hơn',
    '__retry' => 'Thử lại',
    'site_apps__application_packager_site' => 'Trình Đóng gói',
    'site_apps__add_to_pool_message' => "Các ứng dụng được đánh dấu là \"khả dụng cho tất cả\" sẽ tự động được phân phối cho tất cả các đại lý và khách hàng với số lượng bản cài đặt không giới hạn. Các ứng dụng hạn chế được phân phối cho tất cả các đại lý và khách hàng theo cách thủ công trên cơ sở cá nhân với số lượng bản cài được quy định rõ ràng.",
    'site_apps__make_available_for_all' => "Làm cho các ứng dụng được chọn có hiệu lực với tất cả người dùng",

    'site_apps__broadcast_app_text' => "Các ứng dụng được đánh dấu là \"khả dụng cho tất cả\" sẽ tự động được phân phối cho tất cả các đại lý và khách hàng với số lượng bản cài đặt không giới hạn. Các ứng dụng hạn chế được phân phối cho tất cả các đại lý và khách hàng theo cách thủ công trên cơ sở cá nhân với số lượng bản cài được quy định rõ ràng.",
    'site_apps__broadcast_app_name' => 'Làm cho ứng dụng có hiệu lực với tất cả người dùng',

    // User Application Pool per application
    'site_apps__available_clients' => 'Người dùng có sẵn',
    'site_apps__no_more_clients_to_add_to_pool' => 'Không có thêm tài khoản người dùng để bạn có thể cung cấp cho ứng dụng này',

    // Installed application instances
    'site_apps__installations' => 'Bản cài đặt',

    // Hosting setup redesign
    '__domain_name_and_ip_address' => "Tên miền và địa chỉ IP",
    '__assign_ip_address' => "Gán địa chỉ IP",
    '__switch_on_service' => "Bật dịch vụ",
    '__hosting_configuration' => "Cấu hình lưu trữ",
    '__vrt_hst' => "Lưu trữ trang web",
    '__vrt_hst_hint' => "Lưu trữ một trang web trên máy chủ này.",
    '__fwd' => "Chuyển tiếp",
    '__web_hosting_settings' => "Thiết lập lưu trữ",
    '__fwd_hint' => "Chuyển hướng khách truy cập vào một trang web khác.",
    '__none_hint' => "Không được lưu trữ một trang web vào lúc này.",
    '__login_hint' => "Tên người dùng này được sử dụng để truy cập website của bạn qua FTP",
    '__password_hint' => "Mật khẩu này được sử dụng để truy cập website của bạn qua FTP",
    '__advanced_hosting_setup' => "Cấu hình các thiết lập lưu trữ trang web nâng cao",
    '__domain_creation_successful' => "Tên miền đã được tạo.",
    'bt_hosting_settings' => "Cài đặt lưu trữ",
    '__change_hosting_type' => "Thay đổi loại hình lưu trữ cho tên miền %1",
    '__hosting_type_change_warning' => "Khi bạn thay đổi loại hình lưu trữ để chuyển tiếp hoặc không lưu trữ, tất cả các tập tin và thư mục có liên quan đến trang web của bạn sẽ bị gỡ bỏ khỏi máy chủ. Hãy chắc chắn lưu lại một bản sao trang web của bạn.",
    '__current_hosting_type' => "Loại hình lưu trữ hiện tại",
    '__new_hosting_type' => "Loại lưu trữ mới",
    '__fwd_settings' => "Các thiết lập chuyển tiếp",
    '__fwd_settings_legend' => "Các thiết lập chuyển tiếp",
    '__fwd_destination_url' => "URL đích",
    '__fwd_type' => "Kiểu chuyển tiếp",
    '__fwd_type_standart' => "Chuyển tiếp dạng chuẩn",
    '__fwd_type_standart_hint' => "Chuyển hướng khách truy cập trang web vào một trang web khác và chúng hiển thị địa chỉ đích đến để họ biết về việc chuyển hướng này.",
    '__fwd_type_frame' => "Chuyển tiếp khung",
    '__fwd_type_frame_hint' => "Chuyển hướng khách truy cập trang web đến trang web khác, nhưng không cho họ địa chỉ đích, để họ không biết gì về việc chuyển hướng này.",
    '__hosting_type_template_warning' => "Các loại hình lưu trữ mà bạn đã chọn khác với các loại được xác định trong mẫu. Nếu bạn tiếp tục, thiết lập lưu trữ web trong các mẫu được chọn sẽ bị bỏ qua. Bạn có chắc chắn rằng bạn muốn thiết lập loại hình lưu trữ được chọn?",

    '__no_resellers_selected' => "Bạn phải chọn ít nhất một tài khoản đại lý.",

    'ui__client/logo_unknown__wizard-title' => 'Thiết lập một biểu tượng',
    'ui__client/logo_unknown__wizard__1_unknown' => 'Hãy lựa chọn khách hàng có các thuộc tính biểu tượng mà bạn muốn thay đổi.',
    'ui__client/logo_unknown__wizard__2' => 'Nhấn Hoàn tất để áp dụng các thay đổi.',
    'ui__client/logo_unknown__wizard__2_self' => 'Nhấn Hoàn tất để áp dụng các thay đổi.',

    'ui__client/ipaddress/properties_new__short-title' => "Bổ sung địa chỉ IP",
    'ui__client/ipaddress/properties_new__title' => 'Bổ sung địa chỉ IP',
    'ui__client/ipaddress/properties_new__description' => "Thêm địa chỉ IP.",
    'ui__client/ipaddress/properties_unknown-new__short-title' => "Bổ sung địa chỉ IP",
    'ui__client/ipaddress/properties_unknown-new__title' => "Bổ sung địa chỉ IP",
    'ui__client/ipaddress/properties_unknown-new__description' => "Bổ sung địa chỉ IP",
    'ui__client/ipaddress/delete_multi__short-title' => "Gỡ bỏ địa chỉ IP",
    'ui__client/ipaddress/delete_multi__description' => "Gỡ bỏ các địa chỉ IP.",
    'ippool_Manager__no_available_ips' => "Không có các địa chỉ IP nào trống trong dãy IP.",
    'ippool_Manager__ip_shared' => "chia sẻ",
    'ippool_Manager__ip_exclusive' => "chuyên dụng",
    'ui__client/ipaddress/properties__title' => "Quản lý các địa chỉ IP",
    'ui__client/ipaddress/properties__description' => "Xem hoặc thay đổi các thuộc tính của địa chỉ IP.",
    'ui__client/ipaddress_unknown-new__title' => "Bổ sung địa chỉ IP",
    'ui__client/ipaddress_unknown-new__short-title' => "Bổ sung địa chỉ IP",
    'ui__client/ipaddress_unknown-new__description' => "Bổ sung địa chỉ IP.",

    'ui__mass-mail#to_resellers_text__title' => "Các đại lý",
    'ui__mass-mail#to_domainusers_text__title' => "Quản trị viên tên miền",
    'ui__mass-email#tools_legend__title' => "Công cụ",
    'ui__mass-email#list_legend__title' => 'Biểu mẫu tin nhắn email hàng loạt',
    'ui__mass-email#template_legend__title' => "Mẫu",
    'ui__mass-email#from_email_text__title' => "Từ",
    'ui__mass-email#to_text__title' => 'Tới',
    'ui__mass-email#to_resellers_text__title' => "Các đại lý",
    'ui__mass-email#to_clients_text__title' => "Khách hàng",
    'ui__mass-email#to_domainusers_text__title' => "Quản trị viên tên miền",
    'ui__mass-email#to_admin_text__title' => "Quản trị viên Plesk",
    'ui__mass-email#option_mode_all__title' => "Tất cả",
    'ui__mass-email#option_mode_select__title' => "Chỉ được chọn",
    'ui__mass-email#option_mode_except__title' => "Tất cả các lựa chọn ngoại trừ",
    'ui__mass-email#option_select_template__title' => '---Chọn một mẫu---',
    'ui__mass-email#subject_text__title' => "Chủ đề",
    'ui__mass-email#body_text__title' => "Tin nhắn văn bản",
    'ui__mass-email#save_as_legend__title' => "Lưu dưới dạng mẫu",
    'ui__mass-email#save_as_text__title' => "Lưu thông báo đã soạn với một mẫu mới có tên",
    'ui__reseller/preferences_unknown__wizard-title' => "Thay đổi thiết lập Tài khoản",
    'ui__reseller/preferences_unknown__wizard__1_unknown' => "Chọn đại lý có thiết lập tài khoản mà bạn muốn thay đổi và nhấn Tiếp theo.",
    'ui__reseller/preferences_unknown__wizard__2' => "Chỉ định thiết lập tài khoản và bấm Đồng ý.",
    'ippoolManager__ip_shared' => "chia sẻ",
    'ippoolManager__ip_exclusive' => "chuyên dụng",

    '__users_list' => "Người dung",
    '__users' => "Người dung",
    '__user_name' => "Tên của người dùng",

    'limit__name_max_dom_aliases' => "Các bí danh tên miền",
    'limit__name_max_subftp_users' => "Các tài khoản FTP bổ sung",
    'limit__name_max_mssql_db' => "Cơ sở dữ liệu Microsoft SQL Server",
    'limit__name_max_iis_app_pools' => "Kho ứng dụng IIS",
    'limit__name_max_odbc' => "Các kết nối ODBC",
    'total_mboxes_quota_unsupported' => 'không được hỗ trợ bởi máy chủ thư',
    'limit_soft__disk_space' => 'Thông báo khi đạt ngưỡng không gian đĩa',
    'limit_soft__max_traffic' => 'Thông báo khi đạt ngưỡng lưu lượng',
    'dsr__of_reseller_title' => "Tài nguyên sử dụng của tên miền",
    'limitsManager__commit_failed' => "Không thể thay đổi giới hạn tài nguyên.",
    'limitsManager__date_in_past' => "Ngày hết hạn không chính xác %1.",
    'limitsManager__limit_not_supported' => "Giới hạn cho loại tài nguyên %1 không thể được thiết lập.",
    'limitsManager__limit_oversell_inconsistency' => "Không thể phân bổ số lượng tài nguyên được chỉ định với chức năng bán vượt định mức đã tắt.",
    'limitsManager__limit_overuse_inconsistency' => "Tài nguyên sử dụng vượt quá giới hạn đã định.",
    'limitsManager__no_resource_available' => "Không sẵn tài nguyên loại này (%%limitName%%) còn lại. Yêu cầu: %%quantity%%; đang có: %%unused%%.",
    'limitsManager__no_total_resource_available' => "Không có tài nguyên loại này (%%limitName%%) từ nhà cung cấp dịch vụ của bạn. Yêu cầu: %%quantity%%; đang có: %%unused%%.",
    'limitsManager__invalid_expiration_limit' => "Ngày hết hạn phải nhỏ hơn hoặc bằng %1.",
    'limitsManager__invalid_disk_space_limit' => "Dung lượng đĩa trống phải nhỏ hơn hoặc bằng %1.",
    'limitsManager__invalid_max_traffic_limit' => "Lưu lượng truy cập phải nhỏ hơn hoặc bằng %1.",
    'ippoolManager__ip_has_suballocations' => "Không thể thay đổi loại hình địa chỉ IP đã được gán cho một người dùng. Địa chỉ IP %%ip%% đã được gán cho (những) người dùng là địa chỉ IP %%reserved%%.",
    'ippoolManager__ip_is_already_in_pool' => "Địa chỉ IP này đã được gán cho người dùng.",
    'ippoolManager__ip_is_not_in_pool' => "Không có địa chỉ IP %%ip%% nào trong dãy.",
    'ippoolManager__can_not_allocate_ip' => "Các địa chỉ IP %%ip%% chỉ có sẵn là %%available%%.",
    'ippoolManager__unable_to_set_default_type' => "Địa chỉ IP %%ip%% không thể được gán là chuyên dụng.",
    'ippoolManager__ip_used_by_hst_or_frw' => "Địa chỉ IP %%ip%% đã được sử dụng để lưu trữ.",
    'ippoolManager__active_anon_ftp_on_ip' => "Truy cập FTP ẩn danh đã được bật lên cho các địa chỉ IP %%ip%%",
    'ippoolManager__no_vacant_ips' => "Không còn địa chỉ IP trống.",
    'ippoolManager__no_available_ips' => "Không còn địa chỉ IP sẵng sàng.",
    'templates__dublicate_name' => "Biểu mẫu có tên này đã tồn tại. Vui lòng chọn tên khác cho biểu mẫu này.",
    'cl_perm__client_limits_exceeded' => "Giá trị giới hạn tài nguyên đã định đã vượt các giá trị được cho phép bởi kế hoạch lưu trữ của bạn, hoặc những giá trị này cung cấp ít tài nguyên hơn lượng đang dùng bởi trang web của bạn.",
    'cl_perm__reseller_limits_exceeded' => "Giá trị giới hạn tài nguyên đã định đã vượt các giá trị được cho phép theo gói lưu trữ của bạn, hoặc những giá trị này cung cấp ít tài nguyên hơn lượng đang dùng bởi tài khoản người dùng và trang web của bạn.",

    'site_apps__preferences_show_all_versions_title' => "Hiển thị toàn bộ danh sách những phiên bản cho mỗi ứng dụng lấy từ các danh mục",
    'site_apps__preferences_show_all_versions_hint' => "Nếu tùy chọn này được chọn, có thể phải mất nhiều thời gian để tải về tất cả các phiên bản của mỗi ứng dụng mỗi khi bạn mở mục. Nếu tùy chọn này không được chọn, chỉ có phiên bản mới nhất được hiển thị.",
    '__select_user_template' => "Tạo tài khoản người dùng dựa trên một mẫu",
    'ip_already_added_to_all_clients' => "Địa chỉ IP này đã được gán cho tất cả người dùng.",
    'ui__server/ip-address/client/delete#legend__description' => "Dưới đây là những địa chỉ IP sẽ được gỡ bỏ khỏi hệ thống và dãy IP của người dùng:",

    'site_apps__cancelled_apps' => "Bạn đã hủy bỏ việc bổ sung các ứng dụng sau: %2",

    'sb_url_is_not_resolved' => 'URL không thể phân giải được: kiểm tra các cài đặt DNS. URL %1 phải phân giải trong địa chỉ IP của máy chủ có cài đặt Presence Builder.',

    'ip_addr__is_last_on_interface' => 'Không thể gỡ bỏ địa chỉ IP %%ip%% vì nó là địa chỉ IP cuối cùng hiển thị trên một giao diện mạng.',
    'ip_addr__used_for_current_session' => 'Không thể gỡ bỏ địa chỉ IP %%ip%%, vì nó được sử dụng bởi một phiên hoạt động.',
    'ip_addr__used_for_hosting' => 'Không thể gỡ bỏ địa chỉ IP %%ip%% vì nó được sử dụng để lưu trữ một trang Web.',
    'ip_addr__is_main' => 'Không thể gỡ bỏ địa chỉ IP %%ip%% vì nó chính là địa chỉ IP chính của một giao diện mạng.',
    'ip_addr__ip_used_by_message_submission' => 'Không thể gỡ bỏ địa chỉ IP %%ip%%, vì nó được sử dụng cho các thư gửi tin nhắn',

    // RESELLER ACTION LOG

    '__cl_domains' => 'Tên miền của khách hàng',
    'excl_ip_num' => 'Địa chỉ IP chuyên dụng',

    'sb_err_sitebuilder_not_installed' => 'Presence Builder chưa được cài đặt.',

    '__perm_allow_oversell_can_not_be_revoked' => 'Quyền hạn bán vượt định mức không thể được thu hồi từ người dùng từ lúc người dùng đã được phân bổ nhiều tài nguyên hơn sự sẵn có ban đầu, đi vào chế độ bán vượt định mức.',
    'limitsManager__invalid_limit_value' => 'Giá trị %%value%% được chỉ định cho giới hạn %%limit_name%% không chính xác',
    'confirmationForm_default_agreement_text' => 'Xác nhận hoạt động',
    'confirmationForm_default_confirm_message' => 'Hãy xác nhận hoạt động.',
    'limit__max_mn' => 'Số lượng tối đa tài khoản thư',

    'limits__client_overuse_description' => 'Chính sách sử dụng quá mức sẽ hỗ trợ Plesk cần làm gì khi tình trạng sử dụng tài nguyên vượt quá lượng phân bổ tài nguyên ban đầu.',
    'limits__client_overuse_block_true_description' => 'Ngăn cản sử dụng quá giới hạn tài nguyên. Thực tế tài nguyên sử dụng không thể vượt quá sự phân bổ tài nguyên ban đầu',
    'limits__client_overuse_block_false_description' => 'Không ngăn cản sử dụng tài nguyên quá giới hạn, cho phép khách hàng sử dụng tài nguyên nhiều hơn lượng ban đầu. Tài nguyên sử dụng thực tế có thể vượt quá lượng phân bổ ban đầu',
    'limits__client_overuse_notify_text' => 'Thông báo cho khách hàng về việc tiếp cận các nguồn lực hạn chế',

    'limits__domain_overuse_description' => 'Chính sách sử dụng quá mức sẽ hỗ trợ Plesk cần làm gì khi tình trạng sử dụng tài nguyên vượt quá lượng phân bổ tài nguyên ban đầu.',
    'limits__domain_overuse_block_true_description' => 'Chính sách sử dụng quá mức sẽ hỗ trợ Plesk cần làm gì khi tài nguyên bị sử dụng quá mức.',
    'limits__domain_overuse_block_false_description' => 'Không ngăn cản sử dụng tài nguyên quá giới hạn, cho phép tên miền sử dụng tài nguyên nhiều hơn lượng ban đầu. Tài nguyên sử dụng thực tế có thể vượt quá lượng phân bổ ban đầu',
    'limits__domain_overuse_notify_text' => 'Thông báo cho chủ sở hữu tên miền về sử dụng tài nguyên vượt hạn',


    'cancel_remove' => 'Hủy bỏ các thay đổi và trở về trang trước.',
    'php_not_installed' => 'PHP không được cài đặt',

    'dns__dns_rr_delete' => 'Các mục sẽ được gỡ bỏ',
    'dns__delete_rr' => 'Dưới đây là những bản ghi DNS sẽ bị gỡ bỏ khỏi các vùng DNS:',
    'dns__dns_rr_delete_non_removable' => 'Các mục không thể bị gỡ bỏ',
    'dns__non_delete_rr' => 'Những bản ghi DNS sau đây không thể được gỡ bỏ:',
    'dns__dns_rr_delete_confirm_message' => 'Xác nhận việc gỡ bỏ các bản ghi DNS',

    'site_apps__format_is_unsupported_broadcast_not_set' => 'Định dạng ứng dụng web không nhận biết: trang web có lẽ không thể cài đặt và sử dụng.',

    '__php_handler_type_desc' => 'Chạy PHP với quyền',
    'sfdk_domain_sign__failed' => 'Xảy ra lỗi không xác định khi bật đăng nhập mail với DKIM trên miền. Hãy tham khảo nhật ký lỗi máy chủ để biết thêm thông tin.',

    // key management ported from cpp to php
    'pkey_notify__subj_update_success_notification' => 'Thông báo cập nhật thành công key Plesk',
    'pkey_notify__subj_update_deferral_notification' => 'Thông báo hoãn cập nhật key Plesk',
    'pkey_notify__subj_update_error_notification' => 'Thông báo lỗi cập nhật key Plesk',
    'pkey_notify__update_successful' => '%1 cập nhật hoàn tất thành công.',
    'pkey_notify__update_failed_no_more_try' => 'Không thể cập nhật %1. Key bạn đang gửi không hợp lệ. Bạn không nên thử cập nhật key này lần nữa.',
    'pkey_notify__update_failed_try_later' => 'Không thể cập nhật %1: xảy ra lỗi trong khi xử lý mã bản quyền của bạn. Bạn có thể thử lấy lại khóa bằng tay trong Plesk (Công cụ & Cài đặt> Thông tin bản quyền) hoặc để cho Plesk cập nhật trong 24 giờ tới. Nếu bạn không muốn nhận thông báo này nữa, hãy gỡ bỏ khóa này khỏi Plesk.',

    // spam assassin error messages
    'ui__server/spam-filter/toggle__unable_disable' => 'Không thể tắt chức năng lọc thư rác trên toàn máy chủ.',
    'ui__server/spam-filter/toggle__unable_enable' => 'Không thể bật chức năng lọc thư rác trên toàn máy chủ',

    // Application vault/ application pool for admin mapping - TEMPORARY

    'rpt_reseller_section_full_domains' => 'Các tên miền',
    'rpt_reseller_dom_subdomains' => 'Tên miền thứ cấp',
    'rpt_reseller_dom_domain_aliases' => 'DAliases',
    'rpt_reseller_dom_postboxes' => 'Hộp thư',
    'rpt_reseller_dom_redirects' => 'Bộ chuyển hướng',
    'rpt_reseller_dom_mail_groups' => 'Nhóm tin nhắn',
    'rpt_reseller_dom_mail_resps' => 'Tất cả phản hồi',
    'rpt_reseller_dom_mail_antispam' => 'Trình lọc thư rác',
    'rpt_reseller_dom_mail_antivirus' => 'Chống virus',
    'rpt_reseller_dom_mail_lists' => 'Danh sách gửi thư',
    'rpt_reseller_dom_web_users' => 'Người dùng web',
    'rpt_reseller_dom_data_bases' => 'CSDL MySQL',
    'rpt_reseller_dom_mssql_data_bases' => 'DBMSSQL',

    'rpt_reseller_section_full_clients' => 'Khách hàng',
    '__cl_name' => 'Tên khách hàng',
    '__cl_creation_date' => 'Ngày tạo',
    '__clients_traffic' => 'Lưu lượng truy cập của khách hàng',
    'rpt_reseller_cl_mail_antispam' => 'Trình lọc thư rác',
    'rpt_reseller_cl_mail_antivirus' => 'Chống virus',

    // CONHELPS FOR HOME PAGE
    // common:
    'sitebuilder_not_installed' => 'Presence Builder chưa được cài đặt.',
    'sitebuilder_disabled' => 'Presence Builder đã bị tắt.',
    'b_sitebuilder_disabled' => 'Presence Builder đã bị tắt.',
    'webmail_not_installed' => 'Phần mềm Quản lý thư trực tuyến không được cài đặt.',
    'webmail_disabled' => 'Dịch vụ webmail đã bị tắt.',
    'spamassassin_not_installed' => 'SpamAssassin không được cài đặt.',
    // pfu:
    'anonymous_ftp_shared' => 'Không thể thiết lập FTP ẩn danh: loại địa chỉ IP được chia sẻ.',
    'anonymous_ftp_used' => 'Không thể thiết lập FTP ẩn danh: địa chỉ IP được sử dụng bởi một tên miền khác cho dịch vụ FTP ẩn danh.',
    // pfw:
    'aspdotnet_not_installed' => 'ASP.NET không được cài đặt.',
    'site_builder_no_package' => 'Presence Builder không khả dụng. Vui lòng kiểm tra xem Presence Builder đã được cài đặt và chọn là thành phần đang hoạt động chưa.',
    'site_builder_not_configured' => 'Presence Builder chưa được cấu hình.',

    // LIST OF CLIENTS
    // under reseller
    'ui__reseller/client#tools__title' => 'Công cụ',
    'ui__reseller/client#clientslist__title' => 'Khách hàng',

    //reseller accounts removal





    // NEW HOME PAGE WIZARDS

    // PFW-only

    'ui__client/domain/hosting/web-directories_unknown__wizard-title' => 'Quản lý các kho chứa ảo dưới một website',
    'ui__client/domain/hosting/web-directories_unknown__wizard__2_unknown' => "Chọn website có danh mục mà bạn muốn quản lý.",

    // COMMON WIZARDS


    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard-title' => 'Thiết lập FTP ẩn danh trên tên miền',
    'ui__client/domain/hosting/anonymous-ftp_unknown__wizard__2_unknown' => 'Chọn tên miền mà bạn muốn thiết lập FTP ẩn danh trên đó.',

    'ui__client/domain/hosting/logs_unknown__wizard-title' => 'Thiết đặt quản lý nhật ký cho tên miền và xem các tập tin nhật ký của tên miền',
    'ui__client/domain/hosting/logs_unknown__wizard__2_unknown' => 'Chọn tên miền mà bạn muốn cài đặt quản lý nhật ký và các tập tin nhật ký bạn muốn xem.',

    'ui__client/domain/certificate_unknown__wizard-title' => 'Quản lý chứng nhận SSL/TLS cho miền',
    'ui__client/domain/certificate_unknown__wizard__2_unknown' => 'Chọn miền có chứng nhận SSL/TLS bạn muốn quản lý.',

    'ui__client/domain/disable_multi__wizard-title' => 'Tạm ngưng các tên miền',
    'ui__client/domain/disable_multi__wizard__2_multi' => 'Chọn tên miền mà bạn muốn tạm ngưng.',

    'ui__client/domain/enable_multi__wizard-title' => 'Kích hoạt tên miền',
    'ui__client/domain/enable_multi__wizard__2_multi' => 'Chọn tên miền mà bạn muốn kích hoạt.',

    'ui__client/domain_unknown__wizard-title' => 'Xem Tên miền',
    'ui__client/domain_unknown__wizard__1_unknown' => 'Chọn một tên miền của khách hàng mà bạn muốn xem.',

    'ui__client/domain/register_unknown__wizard-title' => 'Đăng ký Tên miền',
    'ui__client/domain/register_unknown__wizard__2_unknown' => 'Chọn tên miền mà bạn muốn đăng ký.',

    'ui__client/domain/extras_unknown__wizard-title' => 'Sử dụng các công cụ từ MyPlesk.com',
    'ui__client/domain/extras_unknown__wizard__2_unknown' => 'Chọn tên miền mà bạn muốn quản lý với các công cụ từ MyPlesk.com.',

    // various

    'ui__server/ip-address/client_unknown__short-title' => 'Người dùng địa chỉ IP',
    'ui__server/ip-address/client_unknown__title' => 'Người dùng địa chỉ IP',
    'ui__server/ip-address/client_unknown__description' => 'Người dùng địa chỉ IP %1',

    'disabled_by_admin' => 'Đình chỉ bởi người quản trị máy chủ',






    'ui__client/domain/chowner_multi__short-title' => 'Thay đổi quyền sở hữu',
    'ui__client/domain/chowner_multi__title' => 'Thay đổi quyền sở hữu thuê bao',
    'ui__client/domain/chowner_multi__description' => 'Thay đổi quyền sở hữu thuê bao.',

    'ui__client/domain/chowner_multi__wizard__2_multi' => 'Chọn tên miền mà bạn muốn thay đổi quyền sở hữu và nhấn Tiếp tục >>.',
    'ui__client/domain/chowner_unknown__short-title' => 'Thay đổi quyền sở hữu',
    'ui__client/domain/chowner_unknown__title' => 'Thay đổi quyền sở hữu thuê bao',
    'ui__client/domain/chowner_unknown__description' => 'Thay đổi quyền sở hữu thuê bao.',

    'ui__client/domain/chowner_unknown__wizard-title' => 'Thay đổi quyền sở hữu thuê bao',

    //custom buttons reseller home support
    //ui captions
    'ui__reseller/custom-buttons/custom-button__none-available' => 'Không có các nút tùy biến nào.',
    'ui__reseller/custom-buttons/custom-button__none-available__1' => 'Không có nút tùy biến nào trong giao diện của đại lý %1.',

    'ui__reseller/custom-buttons/custom-button/delete__description' => 'Gỡ bỏ nút %1.',

    'ui__reseller/custom-buttons/custom-button/delete__short-title' => 'Gỡ bỏ',
    'ui__reseller/custom-buttons/custom-button/delete__title' => 'Gỡ bỏ nút %1',
    'ui__reseller/custom-buttons/custom-button/delete_multi__description' => 'Gỡ bỏ các nút tùy biến khỏi giao diện của đại lý',

    'ui__reseller/custom-buttons/custom-button/delete_multi__short-title' => 'Gỡ bỏ',
    'ui__reseller/custom-buttons/custom-button/delete_multi__title' => 'Gỡ bỏ các nút tùy biến',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard-title' => 'Gỡ bỏ các nút',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__1_unknown' => 'Chọn một đại lý có các nút tùy biến mà bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__3_multi' => 'Chọn các nút bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/delete_multi__wizard__4_multi' => 'Xác nhận gỡ bỏ các nút bằng cách đánh dấu vào ô trên màn hình này, và sau đó nhấn Hoàn tất.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__description' => 'Gỡ bỏ một nút tùy biến khỏi giao diện của đại lý.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__short-title' => 'Gỡ bỏ',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__title' => 'Gỡ bỏ một nút tùy biến',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard-title' => 'Gỡ bỏ nút tùy biến',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__1_unknown' => 'Chọn một đại lý có các nút tùy biến bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__3_unknown' => 'Chọn một nút tùy biến bạn muốn gỡ bỏ và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/delete_unknown__wizard__4' => 'Xác nhận gỡ bỏ nút tùy biến bằng cách đánh dấu vào ô trên màn hình này, và sau đó nhấn Hoàn tất.',

    'ui__reseller/custom-buttons/custom-button/properties__description' => 'Hiệu chỉnh các thuộc tính của nút tùy biến ở cấp độ đại lý %1.',

    'ui__reseller/custom-buttons/custom-button/properties__short-title' => 'Cài đặt',
    'ui__reseller/custom-buttons/custom-button/properties__title' => 'Sửa đổi nút tùy biến của đại lý %1',

    'ui__reseller/custom-buttons/custom-button/properties_new__wizard-title' => 'Thêm nút tùy biến',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__1_unknown' => 'Chọn một đại lý có giao diện bạn muốn tạo nút tùy biến và nhấp vào Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/properties_new__wizard__4_new' => 'Nhấn Hoàn tất để tạo nút.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__description' => 'Thay đổi các thuộc tính của một nút trong giao diện của đại lý.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__short-title' => 'Thuộc tính',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__title' => 'Thay đổi các thuộc tính của một nút trong giao diện của đại lý',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard-title' => 'Thay đổi các thuộc tính nút tùy biến',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__1_unknown' => 'Chọn một đại lý có các nút tùy biến mà bạn muốn sửa đổi và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__3_unknown' => 'Chọn một nút tùy biến mà bạn muốn sửa đổi và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/properties_unknown__wizard__4' => 'Khi hiệu chỉnh các thuộc tính của các nút xong, hãy nhấn Hoàn tất để áp dụng các thay đổi và thoát khỏi trình thuật sĩ.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__description' => 'Làm cho nút %1 không có hiệu lực với các khách hàng của bạn.',

    'ui__reseller/custom-buttons/custom-button/toggle_private__short-title' => 'Làm cho không có hiệu lực với các khách hàng của bạn',
    'ui__reseller/custom-buttons/custom-button/toggle_private__title' => 'Làm cho nút %1 không có hiệu lực với các khách hàng của bạn',
    'ui__reseller/custom-buttons/custom-button/toggle_public__description' => 'Làm cho nút %1 hiển thị với các khách hàng của đại lý.',
    'ui__reseller/custom-buttons/custom-button/toggle_public__short-title' => 'Làm cho có hiệu lực với các khách hàng của bạn',
    'ui__reseller/custom-buttons/custom-button/toggle_public__title' => 'Làm cho nút %1 hiển thị với các khách hàng của đại lý',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__description' => 'Làm cho một nút tùy biến có hiệu lực/không có hiệu lực với các khách hàng của bạn.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__short-title' => 'Có hiệu lực/không có hiệu lực với các khách hàng của bạn',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__title' => 'Làm cho một nút tùy biến có hiệu lực hoặc không có hiệu lực với các khách hàng của bạn',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard-title' => 'Làm cho một nút tùy biến có hiệu lực/không có hiệu lực với các khách hàng của bạn.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__1_unknown' => 'Chọn một đại lý có các nút tùy biến mà bạn muốn làm cho có hiệu lực với các khách hàng của đại lý đó và nhấn Tiếp tục >>.',
    'ui__reseller/custom-buttons/custom-button/toggle_unknown__wizard__3_unknown' => 'Chọn một nút tùy biến mà bạn muốn làm cho có hiệu lực hoặc không có hiệu lực với các khách hàng của bạn và nhấn Tiếp tục >>.',

    '__not_allowed' => 'Không được phép',

    'ui__client/domain/chowner__wizard__3' => '',
    'ui__client/domain/chowner__wizard__3_select' => 'Chọn chủ sở hữu mới cho tên miền.',

    '__ip_addr_state_unknown' => "Hiện giờ địa chỉ IP không hoạt động do hệ thống vẫn đang xử lý yêu cầu của bạn. Hãy chờ một phút.",


    'resellers_list__accounts' => 'Người dung',

    'ip_addr__repair_is_not_allowed' => 'Địa chỉ IP không thể được sửa chữa trong môi trường Virtuozzo.',

    'ui__reseller/client__none-available__1' => 'Đại lý %1 hiện không có khách hàng.',

    'ippoolManager__ip_used_by_nohost_domain' => "Địa chỉ IP %%ip%% không thể được gỡ bỏ vì nó được sử dụng bởi một hay nhiều tên miền không có lưu trữ.",
    'ippoolManager__ip_used_for_mail_service' => "Địa chỉ IP %%ip%% không thể được gỡ bỏ vì nó được sử dụng bởi một hay nhiều tên miền cho địa chỉ IP dịch vụ thư của họ.",
    'ippoolManager__ip_used_for_send_emails' => "Địa chỉ IP %%ip%% không thể được gỡ bỏ vì nó được sử dụng để gửi email từ IP cụ thể (xem Cài đặt máy chủ thư).",
    'ippoolManager__ip_used_in_dns_zone' => 'Địa chỉ IP %%ip%% không thể được gỡ bỏ vì nó được sử dụng bởi vùng DNS của một hay nhiều tên miền.',
    'ip_ctrl__cannot_manage_on_vz' => 'Cài đặt Plesk đang hoạt động trong các bộ chứa Virtuozzo. Chỉ quản trị viên phần bộ chứa Virtuozzo mới có thể thêm các địa chỉ IP mới.',

    'client_template__limits_auto_adjusted' => 'Các giới hạn trong biểu mẫu khách hàng được tự động điều chỉnh.',

    '__entries' => 'Các mục',

    '__path_is_not_set' => 'Đường dẫn không được chỉ định. Hãy chỉ định một đường dẫn hợp lệ.',

    'defaultcomponents__imap_required' => '(Máy chủ thư này không hỗ trợ IMAP)',

    '__commercial_web_stats_not_installed' => 'Plesk chỉ hỗ trợ phần mềm thống kê web thương mại để tính toán thống kê tên miền phụ. Không có phần mềm nào như vậy hiện được cài đặt trong hệ thống.',


    'server_settings_invalid_traffic_statistics' => 'Tham số thống kê lưu lượng truy cập giữ lại không hợp lệ.',
    'server_settings_invalid_logrotate_period' => 'Tham số thời gian luân chuyển nhật ký không hợp lệ.',

    'spam_filter/address/file_size' => 'Không thể tải lên tập tin. Kích thước tối đa của một tập tin để tải lên là %1.',
    'spam_filter/address/file_empty_content' => 'Đã xảy ra sự cố khi đọc địa chỉ email từ tập tin. Hãy đảm bảo rằng bạn đang tải tập tin lên theo định dạng mã hóa UTF-8 chứa một hoặc nhiều địa chỉ email và thử lại.',
    'spam_filter/address/addresses_empty_content' => 'Không có địa chỉ email nào trống trong danh sách.',
    'spam_filter/address/addresses_available' => 'Chỉ các địa chỉ email đầu tiên %1 sẽ được thêm.',
    'spam_filter/address/invalid_addresses' => 'Các địa chỉ email sau đây không hợp lệ: %1.',
];