<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Неправильний шлюз: upstream надіслав занадто довгий заголовок під час читання заголовка відповіді"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Буде готово найближчим часом.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Внутрішня помилка сервера: параметр FollowSymLinks не дозволений тут"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Буде готово найближчим часом.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "сервер досяг налаштування max_children"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Ознаки</h4><ul><li><p>Веб-сайти, для яких обробник PHP встановлено як<strong>FPM-застосунок, що обслуговується Apache</strong> або <strong>FPM-застосунок, що обслуговується nginx</strong> на <strong> Доменах</strong>&gt;<strong>example.com</strong> &gt; <strong> У налаштуваннях PHP</strong> виникає одна з наведених нижче проблем:</p><ul><li><p>довгий час завантаження</p></li><li><p>немає доступу (постійно або періодично) з помилкою 50x у веб-оглядачі:</p><pre>502 Неправильний шлюз</pre><hr><pre>503 Сервіс тимчасово недоступний</pre><hr><pre>504 Час очікування шлюзу перевищено</pre></li></ul></li><li><p>У журналі помилок PHP-FPM з’являється таке повідомлення <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (де <em>XX</em> це версія PHP, яку використовують вебсайти):</p><pre>ПОПЕРЕДЖЕННЯ: сервер [пула example.com] досяг параметра max_children (*), розгляньте варіант його підвищення</pre><ul><li><p>Повідомлення вище зазвичай супроводжується наступною помилкою:</p><pre>неможливо зчитати інформацію дочірного об’єкта: поганий дескриптор файлу (9)</pre></li></ul></li><li><p>Якщо nginx увімкнено на сервері, у журналі помилок домену може з’явитися одне з наведених нижче повідомлень про помилку <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 з\'єднатися() з unix:///var/www/vhosts/system/example.com/php-fpm.sock не вдалося (11: Ресурс тимчасово недоступний) під час підключення до upstream, клієнт: 203.0.113.2, сервер: example.com, запит: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", хост: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream передчасно завершив з\'єднання під час читання заголовка відповіді з upstream, клієнт: 203.0.113.2, сервер: example.com, запит: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM<code>pm.max_children</code> досягнутий вебсайтом (вебсайтами).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Збільшити ліміт pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Збільште обмеження <code>pm.max_children</code> для уражених доменів:</p><ol><li><p>З\'єднайтеся з сервером Plesk через <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Знайдіть уражені домени за допомогою команди нижче:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Примітка:</strong>Число зліва вказує, скільки разів<code>pm.max_children</code> обмеження було досягнуто на вебсайті.</div><pre style="white-space: pre-wrap;"># grep -r "сервер досяг налаштування max_children" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Увійти до Plesk</a>.</p></li><li><p>Перейти до<strong>Домени</strong>&gt;<strong>example.com</strong> &gt; <strong>Налаштування PHP</strong> &gt; <strong>Налаштування PHP-FPM</strong>.</p></li><li><p>Збільште значення <code>pm.max_children</code> для домену та застосуйте зміни. Збільште це значення для всіх доменів, перерахованих на кроці 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Забагато відкритих файлів"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx не запускається/перезавантажується на сервері Plesk: забагато відкритих файлів</p><h4>Ознаки</h4><ul><li><p>Служба nginx не запускається/перезавантажується з наступною помилкою в <code>/var/log/nginx/error.log</code> файл:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/ www/vhosts/system/example.com/logs/proxy_access_ssl_log" не вдалося (24: Забагато відкритих файлів)</pre></li><li><p>Деякі або всі вебсайти недоступні</p></li><li><p>Попередження показане в розділі <strong>Інструменти &amp; Налаштування &gt; Виявити &amp; виправити</strong>:</p><pre style="white-space: pre-wrap;">Перевірка наявності nginx ULIMIT значення N доменів знайдена на сервері. Можлива проблема з обмеженням за замовчуванням nginx для відкритих файлів</pre></li><li><p>Веб-застосунки NodeJS і Ruby показують помилку 502 Неправильний шлюз під час виконання деяких завдань Plesk, як-от створення доменів, підписок, зміни в Apache або Nginx тощо:</p><pre style="white-space: pre-wrap;">Помилка сервера<br>502 Неправильний шлюз <br>Веб-сервер отримав недійсну відповідь, працюючи як шлюз або проксі-сервер.</pre></li><li><p>Після <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">встановлення нового сертифіката для домену</a>, старий все ще показаний у веб-оглядачі, однак правильний сертифікат вибирається на <strong>Домени &gt; example.com &gt; Сторінка налаштувань хостингу.</strong></p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Віртуальний хост Nginx відкриває 4 журнали для кожного віртуального хосту з фізичним хостингом:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Отже, сервер nginx перевищив максимальну кількість відкритих файлів через велику кількість доменів (зазвичай більше 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Збільшити ліміт відкритих файлів',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Попередження:</strong> Виконання <code>websrv_ulimits</code> утиліту без <strong>--no-restart</strong> опції ініціює відновлення файлів конфігурації вебсайтів для всіх доменів і може призвести до значних простоїв у разі великої кількості розміщених вебсайтів.<br><br>Виконайте команду протягом періоду обслуговування.</div><p>Рекомендується встановити граничне значення для відкритих файлів більше ніж принаймні <strong>кількість доменів у Plesk * 16</strong>. У прикладі нижче наведено дії, як встановити обмеження на 4096:</p><ol><li><p>З\'єднатися з сервером через <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Установіть обмеження для відкритих файлів на 4096 як для Apache, так і для Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Перезапустіть сервіси Apache і nginx за адресою<strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Інструменти &amp; Налаштування &gt; Управління сервісами</strong>, щоб застосувати зміни.</p></li><li><p>Після перезапуску веб-сервісів переконайтеся, що «Максимальне обмеження відкритих файлів» застосовано належним чином:</p><pre># grep «Максимальна кількість відкритих файлів» /proc/$(cat /var/run/nginx.pid)/limits<br>Максимальна кількість відкритих файлів 4096 4096 файл</pre></li><li><p>Якщо вище вказане рішення не допомогло, встановіть обмеження за допомогою <code>ulimit</code> утиліти: </p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Тіло відповіді завелике"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Буде готово найближчим часом.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "У доступі відмовлено, код 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Симптоми</h4><ul><li><p>ModSecurity інстальовано та ввімкнено в меню <strong>Інструменти та налаштування > Брандмауер веб-програми (ModSecurity) > Режим брандмауера веб-програми> Увімкнути</strong>.</p></li><li>Веб-сайт, розміщений у Plesk, не завантажується. На веб-сайті неможливо виконувати такі операції, як керування WordPress, отримувати доступ до веб-пошти або файлу <code>robots.txt</code>. У браузері може відображатися одна з наведених нижче помилок: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Заборонено</pre><hr><pre>500 Внутрішня помилка сервера</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Повідомлення про помилку ModSecurity, подібне до наведеного нижче, з’являється у файлі журналу <code>/var/log/modsec_audit.log</code> або на сторінці журналів у Plesk (<strong>Домени</strong> &gt; <strong>example.com</strong> &gt; <strong>Журнали</strong>): <pre>ModSecurity: доступ відхилено, код 403 (фаза 2). Оператор GE відповідав 5 у TX:anomaly_score. [файл "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_3-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Перевищено показник аномалії вхідного доступу (загальний показник: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Брандмауер веб-програми ModSecurity увімкнено з набором дуже обмежувальних правил, наприклад, OWASP, Comodo чи спеціального набору правил, як-от Imunify360. Набори обмежувальних правил можуть блокувати певні операції на веб-сайті.</p><p><Strong>Примітка.</strong> Помилка ModSecurity може означати атаку на ваш сервер. Використовуйте наведені нижче рішення, лише якщо ви впевнені, що ModSecurity блокує припустиме використання вашого веб-сайту.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Вимкніть набір правил ModSecurity за допомогою ідентифікатора чи тега',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Знайдіть ідентифікатор правила, що блокує припустиме використання вашого веб-сайту. Знайти ідентифікатори можна в повідомленнях про помилки у файлі журналу <code>/var/log/modsec_audit.log</code>. Ідентифікатор є цілим числом у лапках із префіксом <code>id</code> у квадратних дужках, наприклад, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Вимикання певного набору правил у Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Перейти до іншого набору правил ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Перехід до набору менш обмежувальних правил ModSecurity, наприклад, Atomic ModSecurity Ruleset. Для цього перейдіть у меню <strong>Інструменти та налаштування</strong> > <strong>Брандмауер веб-програми (ModSecurity)</strong> > <strong>Налаштування</strong>, виберіть <strong>Atomic Standard</strong> і клацніть <strong>ОК</strong>, щоб застосувати зміни.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Внутрішня помилка сервера 500: Вичерпано дозволений розмір пам\'яті XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Симптоми</h4><ul><li><p>Вебсайт, розміщений у Plesk, недоступний:</p><pre>500 Внутрішня помилка сервера</pre></li><li><p>У журналі вебсайту відображається помилка:</p><pre >Отримано помилку "Повідомлення PHP: Критична помилка PHP: вичерпано дозволений розмір пам’яті 4194304 байтів (спроба виділити 4000032 байтів) у /var/www/vhosts/example.com/httpdocs/somethingBig.php на лінії 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Веб-сайту недостатньо виділеної пам’яті для обробки.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Збільште memory_limit веб-сайту',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "Діє обмеження open_basedir"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Симптоми</h4><ul><li><p>Веб-сайт недоступний через одну з наведених нижче помилок у веб-браузері:</p><pre>404 Файл не знайдено</pre><hr><pre>500 Внутрішня помилка сервера</pre><hr><pre>Помилка 500 move_uploaded_file(): діє обмеження open_basedir. Файл(/path/to/the/directory) не міститься у дозволеному шляху(-ах): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>На сторінці журналів домену з’являється повідомлення про помилку (<strong>Домени</strong> > <strong>example.com</strong> > <strong>Журнали</strong>):</p><pre><...> Діє обмеження open_basedir. Файл(/path/to/the/directory) не міститься у дозволеному шляху(-ах) <...></pre><hr><pre>Необроблений виняток: Сеанс: налаштований шлях збереження /path/to/the/directory не є каталогом, не існує чи не може бути створений.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Сценарій PHP намагається отримати доступ до каталогу із забороненим доступом. Це обмеження визначається директивою PHP <code>open_basedir</code> окремо для кожного домену. За умовчанням <code>open_basedir</code> дозволяє отримати доступ до <code>tmp</code> і кореневих каталогів документів домену, а також до шляху за умовчанням сеансів системи.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Додати додатковий шлях до директиви open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Вимкнути директиву open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Перейдіть на сторінку <strong>Домени &gt example.com &gt Налаштування PHP</strong> і встановіть для директиви <code>open_basedir</code> значення none.</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Заборонено AH01797: клієнту відмовлено у доступі конфігурацією сервера"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Симптоми</h4><ul><li><p>Веб-сайт відображує помилку, подібну до такої:</p><pre>Помилка сервера 403<br>Заборонено</pre></li><li><p>Файл журналу <code>/var/www/vhosts/system/example.com/logs/error_log</code> містить помилки, подібні до такої:</p><pre>AH01797: клієнта відхилено конфігурацією сервера: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Поточна конфігурація Apache не дозволяє отримати доступ до вебсайту.</p><p>Це очікувано для таких файлів, як .htaccess і .htpasswd, адже доступ до цих файлів не має надаватися через вебсервер.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Перевірте конфігурацію сервера та файли .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Не вдається отримати доступ до каталогу вебсайтів у Plesk: 403 Заборонено"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Симптоми</h4><ul><li><p>Неможливо отримати доступ до певного розташування веб-сайту, наприклад, <code>http://example.com/some_folder</code>. Виникає така помилка:</p><pre>Помилка сервера 403<br>Заборонено</pre></li><li><p>У файлі <code>/var/www/vhosts/example.com/logs/error_log<code/> виникає така помилка:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Обслуговування каталогу /var/www/vhosts/example.com/httpdocs/some_folder/ неможливе: не знайдено відповідний DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml), і згенерований сервером індекс каталогу заборонений директивою Options</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Запитаний каталог не містить файлів індексу чи перегляд каталогу не ввімкнено.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Додати файл індексу до каталогу',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Увімкнути перегляд каталогів',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Не вдається отримати доступ до каталогу вебсайтів у Plesk: 403 Заборонено"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Симптоми</h4><ul><li><p>Неможливо отримати доступ до певного розташування веб-сайту, наприклад, <code>http://example.com/some_folder</code>. Виникає така помилка:</p><pre>Помилка сервера 403<br>Заборонено</pre></li><li><p>У файлі <code>/var/www/vhosts/example.com/logs/error_log<code/> виникає така помилка:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Обслуговування каталогу /var/www/vhosts/example.com/httpdocs/some_folder/ неможливе: не знайдено відповідний DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml), а згенерований сервером індекс каталогу заборонений директивою Options</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Запитаний каталог не містить файлів індексу чи перегляд каталогу не ввімкнено.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Додати файл індексу до каталогу',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Увімкнути перегляд каталогів',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "сервер досяг налаштування MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Буде готово найближчим часом.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Обмеження тіла запиту PHP "клієнт збирається надіслати занадто довгий текст"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Буде готово найближчим часом.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Обмеження тіла запиту PHP "клієнт збирається надіслати занадто довгий текст"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Буде готово найближчим часом.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Сеанси PHP "503 Внутрішня помилка сервера" або "Не вдалося прочитати дані сеансу"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Буде готово найближчим часом.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Заборонено: pcfg_openfile: неможливо перевірити файл htaccess, переконайтеся, що файл доступний для читання"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Симптоми</h4><ul><li><p>Веб-сайт, розміщений у Plesk, не працює:</p><pre>У вас немає дозволу на доступ до / на цьому сервері. <br> Крім того, під час спроби використати ErrorDocument для обробки запиту виникла помилка «403 Заборонено».</pre><p>Замість зазначеної вище помилки може також відображатися порожня сторінка.</p></li ><li><p>Помилка входу в домен<strong>Журнали доменів &gt example.com &gt</strong> містять наступне:</p><pre>(13)Дозвіл відхилено: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: неможливо перевірити файл htaccess, переконайтеся, що він доступний для зчитування і що виконання /var/www/vhosts/example.com/httpdocs/ можливе </pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Неправильні дозволи для файлів або папок домену.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Відновити дозволи для вмісту веб-сайту',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Прочитайте статтю бази знань і дотримуйтесь інструкцій</a>.</p></li></ol>',
];