<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    '_shared.webstatDomainIsSuspended' => '网站%%domainName%%已挂起。',
    '_shared.webstatHostingNotConfigured' => '在 %%domainName%% 上没有配置的主机。',
    '_shared.webstatNotSelected' => '尚未选择要用于%%domainName%%的网站统计程序。',
    '_shared.domainDisabled' => '此域名（网站）已被主机提供商禁用。',
    '_shared.domainSuspended' => '此域名（网站）已被主机提供商挂起。',
    '_shared.operationSelectorHint' => '若要执行操作，请选择一个主机空间。',
    '_shared.operationSelectorTitle' => '主机空间',

    'add-domain-alias.noDomains' => '无法创建别名：没有可用的域名。',
    'add-domain.noDomains' => '无法创建附加域名：没有可用的域名。',
    'add-subdomain.noDomains' => '无法创建子域名：没有可用的域名。',

    'change-hosting.title' => '更改主机类型',

    'change-status-alias.activated' => '域名别名 %%domainAliasName%% 已成功被激活。',
    'change-status-alias.deactivated' => '域名别名 %%domainAliasName%% 已被禁用。',
    'change-status-alias.notActivated' => '无法激活域名别名 %%domainAliasName%% 因为它已被主机提供商禁用。',

    'change-status.title' => '更改网站状态',

    'delete.sitesNotSpecified' => '未指定要移除的网站。',
    'delete.domainDeletionNotAllowed' => '不允许删除域名。',
    'delete.subdomainDeletionNotAllowed' => '不允许删除子域名。',
    'delete.aliasDeletionNotAllowed' => '不允许删除别名',
    'delete.domainDeletedSuccessfully' => '该域名已被移除。',
    'delete.subdomainDeletedSuccessfully' => '该子域已被移除。',
    'delete.aliasDeletedSuccessfully' => '该别名已被移除。',

    'download-web-deploy-publish-settings.hostingNotConfigured' => '在 %%domainName%% 上没有配置的主机。',
    'download-web-deploy-publish-settings.webDeployNotSupported' => '不支持 Web Deploy。',
    'download-web-deploy-publish-settings.webDeployNotInstalled' => '未安装 Web Deploy。',
    'download-web-deploy-publish-settings.webDeployNotConfigured' => '在 %%domainName%% 上没有配置 Web Deploy 发布功能。',

    'index.title' => '网站与域名',
    'index.home' => '首页',

    'overview.title' => '域概要',
    'overview.suspended' => '挂起',
    'overview.disabled' => '禁用',

    'php-settings.title' => '%%domainName%% 的 PHP 设置',
    'php-settings.updatedSuccessfully' => '已成功更新设置。',
    'php-settings.showPhpInfoError' => '无法索取有关 PHP 配置的信息。',
    'php-settings.phpHandlerNotFound' => '无法检索有关该域名的PHP版本的信息。将其重新安装或为域名选择其它PHP版本。',
    'php-settings.phpHandlerNotRegistered' => "PHP 版本 %%fullVersion%% 未安装。域名 '%%domainName%%' 的 PHP 脚本不可用。安装 PHP <nobr>版本 %%fullVersion%%</nobr> 或为该域名选择其它 PHP 版本。",

    'seo-settings.title' => 'SEO 设置',
    'seo-settings.description' => '为您的网站配置特定的搜索引擎设置。',
    'seo-settings.successSaved' => '已成功保存 SEO 设置。',

    'settings.title' => '主机设置',
    'settings.titleForObject' => '%%name%% 的主机设置',
    'settings.updatedSuccessfully' => '设置已更新。',

    'site-copy.title' => '复制 %%siteName%% 文件',
    'site-copy.description' => '复制网站文件到该帐户或 FTP 存储下的其它网站。如果这是生产环境下的网站而您计划对网站做较大修改，建议使用此类复制。您可以克隆网站到一个过渡环境，让您的设计师和程序员们在克隆的环境下对网站进行修改，这样就不会影响生产环境下的网站的运行。复制网站文件是克隆网站的一部分：您还需要复制网站使用的数据库才能完成克隆。如果您没有其他网站可用作过渡环境，您则可以添加一个新域名或子域名用作过渡环境。',
    'site-copy.siteCopiedSuccessfully' => '网站 %%sourceName%%  的文件被复制到 %%destinationName%%。',

    'site-select.domain-aliases-title' => '域名别名',
    'site-select.domain-aliases-areaDescription' => '若要设置网站的其他域名，选择下面的网站，并点击相应的管理链接。',
    'site-select.logs-title' => '日志管理',
    'site-select.logs-areaDescription' => '若要查看网站的错误和访问日志文件，选择下面的网站，并点击相应的管理链接。',
    'site-select.ssl-certificates-title' => 'SSL/TLS 证书',
    'site-select.ssl-certificates-areaDescription' => '若要管理网站的 SSL/TLS 证书，请选择下面的网站，并点击相应的 管理 链接。',
    'site-select.dns-title' => 'DNS设置',
    'site-select.dns-areaDescription' => 'DNS是解析网站域名(如example.com)为IP地址(如192.0.2.13) 的Internet系统。此类解析基于DNS解析文件完成，它可在域名与IP之间建立关联。您域名的区域文件可存放到此服务器上，并可更改其内容，或存放到其他服务器上。若要配置网站的DNS区域，选择网站，并点击相应的管理链接。',
    'site-select.databases-title' => '数据库',
    'site-select.databases-areaDescription' => '若要管理网站所用数据库，选择下面的网站，并点击相应的管理链接。',
    'site-select.web-users-title' => '网站用户',
    'site-select.web-users-areaDescription' => '若要设置可在您的其中一个网站上托管个人网页的用户帐户，选择下面的网站，并点击相应的管理链接。',
    'site-select.protected-dirs-title' => '受保护目录',
    'site-select.protected-dirs-areaDescription' => '若要使用密码保护网站区的访问，选择下面的网站，并点击相应的管理链接。',
    'site-select.cron-title' => '计划的任务',
    'site-select.cron-areaDescription' => '若要自动执行服务器上的脚本或程序，选择下面的网站，并点击相应的管理链接。',
    'site-select.bandwidth-limit-title' => '带宽限制',
    'site-select.bandwidth-limit-areaDescription' => '若要查看或限制网络所用的带宽，选择下面的网站，并点击相应的管理链接。',
    'site-select.iis-app-pool-title' => 'IIS应用程序池',
    'site-select.rdesktop-title' => '远程桌面',
    'site-select.asp-net-settings-title' => 'ASP.NET设置',
    'site-select.asp-net-settings-areaDescription' => '若要配置ASP.NET框架设置，选择下面的网站，并点击相应的管理链接。',
    'site-select.odbc-data-sources-title' => 'ODBC数据源',
    'site-select.odbc-data-sources-areaDescription' => '如要配置ODBC数据源名称，选择下面的网站，并点击相应的管理链接。',
    'site-select.sitebuilder-title' => 'Presence Builder',
    'site-select.sitebuilder-areaDescription' => '要使用 Presence Builder 创建或编辑网站，请选择以下网站并点击相应的 管理 链接。',
    'site-select.copy-title' => '创建网站副本',
    'site-select.copy-areaDescription' => '复制网站，选择网站并点击相应的管理链接。',
    'site-select.web-deploy-publish-settings-title' => 'Web Deploy 发布设置',
    'site-select.web-deploy-publish-settings-areaDescription' => '在使用 Microsoft WebMatrix 发布您的代码时，您会被要求指定如如域名或数据传输协议等不同的设置来设置您的网站连接。您可手动或以 XML 文件的方式提供这些参数。在此处您可通过点击相应的下载链接下载某个网站的此类文件。',

    'statistics.show' => '显示',
    'statistics.webStatistics' => '网站统计',
    'statistics.sslWebStatistics' => 'SSL/TLS 网站统计',
    'statistics.ftpStatistics' => 'FTP统计',
    'statistics.anonymousFtpStatistics' => '匿名FTP统计',
    'statistics.hostingNotConfigured' => '域名%%domainName%%上未配置主机',
    'statistics.webstatNotSelected' => '尚未选择要在域名%%domainName%%上使用的网站统计程序',

    'subscription-delete.infoSubscriptionDeleted' => '选定的主机空间已被移除。',
    'subscription-delete.infoSubscriptionNotDeleted' => '一些选定的主机空间未被移除。',

    'subscriptions.title' => '主机空间',
    'subscriptions.buttonRemove' => '移除',
    'subscriptions.buttonRemoveDescription' => '移除选定的主机空间。',
    'subscriptions.confirmOnDelete' => '您想要移除所选主机空间吗？',
    'subscriptions.buttonAddNew' => '添加主机空间',
    'subscriptions.buttonAddNewDescription' => '创建一个主机空间。',
    'subscriptions.buttonMyResources' => '我的资源',
    'subscriptions.buttonMyResourcesDescription' => '查看可用的资源。',
    'subscriptions.subscriptionsHintTitle' => '主机空间概要',
    'subscriptions.subscriptionsHintWaitMessage' => '正在加载...',

    'view.title' => '网站与域名',
    'view.suspended' => '挂起',
    'view.disabled' => '禁用',
    'view.buttonDeleteDomain' => '移除网站',
    'view.buttonDeleteDomainHint' => '移除该网站也会从服务器删除所有相关的文件、目录和 web 应用程序。',
    'view.buttonDeleteSubdomain' => '移除子域',
    'view.buttonDeleteSubdomainHint' => '移除该网站也会从服务器删除所有相关的文件、目录和 web 应用程序。',
    'view.buttonDeleteAlias' => '移除域名别名',
    'view.buttonDeleteAliasHint' => '移除该别名。',
    'view.warningSubscriptionUsesSNWithoutLicense' => '此订阅不允许主机管理操作： %%reason%%. 请联系你的服务提供商。',
    'view.warningSubscriptionIsSuspended' => '订阅已挂起。所有网站不可用。',
    'view.warningSubscriptionIsSuspendedByBackupRestore' => '订阅暂时不可用，因为正在进行数据备份或恢复。请稍后重试。',
    'view.warningSubscriptionIsSuspended_powerUser' => '此主机空间已挂起。主机空间内托管的所有站点都不可用。',
    'view.buttonIssAppPoolHint_powerUser' => '设置一个独立的 IIS 应用程序池服务在当前所选主机空间内托管的网站。',
    'view.buttonSitebuilder' => 'Presence Builder',
    'view.buttonSitebuilderHint' => '通过 Presence Builder 编辑器使用企业和个人模板实现快速创建网站。',
    'view.buttonMobileSites' => '移动网站',
    'view.buttonMobileSitesHint' => '创建网站的移动版本，并编辑其内容。',
    'view.buttonApplications' => '应用程序',
    'view.buttonApplicationsHint' => '在您的网站上安装并管理web应用程序。轻松点击即可安装论坛、图库、协作工具及其他。',
    'view.buttonGoogleServicesForWebsites' => 'Google网站服务',
    'view.buttonGoogleServicesForWebsitesHint' => '配置Google服务来增强网站、提高流量 、留住用户，并提高利润。',
    'view.buttonConnectionInfo' => '连接信息',
    'view.buttonConnectionInfoDesc' => '针对 FTP、数据库',
    'view.buttonConnectionInfoLabelNew' => '新',
    'view.buttonFileManager' => '文件',
    'view.buttonFileManagerHint' => '上传新文件，并处理网站当前文件及目录。',
    'view.buttonWebStatistics' => '网站统计',
    'view.buttonWebStatisticsHint' => '查看通过 HTTP 访问网站的访客数量，以及他们浏览了哪些网页。',
    'view.buttonWebStatisticsSsl' => '网站统计 SSL/TLS',
    'view.buttonWebStatisticsSslHint' => '查看通过 HTTPS 访问网站的访客数量，以及他们浏览了哪些网页。',
    'view.buttonTransferStats' => '数据传输',
    'view.buttonTransferStatsHint' => '查看各种服务使用了多少流量。',
    'view.buttonTransferStatsComment' => 'HTTP, FTP, Mail',
    'view.buttonStatistics' => '磁盘空间和流量',
    'view.buttonStatisticsHint' => '查看各种服务使用了多少磁盘空间和流量。',
    'view.buttonFTPStats' => 'FTP 传输报告',
    'view.buttonFTPStatsHint' => '查看有多少数据已通过 FTP 传入或传出您的网站。',
    'view.buttonAnonFTPStats' => '匿名 FTP 下载',
    'view.buttonAnonFTPStatsHint' => '从无需用户名和密码的目录进行 FTP 下载。',
    'view.buttonFtpAccess' => 'FTP',
    'view.buttonFtpAccessHint' => '设置通过FTP协议访问网站文件。',
    'view.buttonDnsSettings' => 'DNS',
    'view.buttonDnsSettingsHint' => '管理域名相关DNS区域。',
    'view.domainNotResolvedComment' => '域名不可解析',
    'view.buttonWhoisInfo' => 'Whois 信息',
    'view.buttonWhoisInfoHint' => '查看有关您注册的域名的信息。',
    'view.buttonSslCertificates' => 'SSL/TLS 证书',
    'view.buttonSslCertificatesHint' => '使用 SSL/TLS 证书保护网站的连接安全。',
    'view.buttonWebAppFirewall' => 'Web 应用程序防火墙',
    'view.buttonWebAppFirewallHint' => '为您网站使用的 web 应用程序配置攻击防护。',
    'view.buttonBackup' => '备份与恢复',
    'view.buttonBackupHint' => '备份并恢复网站，包括网站设置、内容及邮件帐户。',
    'view.buttonHostingSettings' => '主机访问',
    'view.buttonHostingSettingsHint' => '更改用于远程访问 Plesk（通过 SSH 或 RDP）以及操作文件管理器中文件和文件夹的系统用户帐户设置。',
    'view.buttonHostingSettingsDesc' => 'IP 地址、系统用户、通过 SSH 或 RDP 进行的 web 空间访问。',
    'view.buttonWebScripting' => '主机',
    'view.buttonWebScriptingHint' => '在此处您可以配置网站主机设置并选择您网站可用的功能。',
    'view.buttonWebScriptingDesc' => '域名、文档根目录、SSL证书、Web脚本等等。',
    'view.buttonHosting' => '主机',
    'view.buttonHostingDesc' => '主机设置和 Web 主机访问',
    'view.buttonEmailAddresses' => '邮件帐户',
    'view.buttonEmailAddressesHint' => '创建和管理与该网站相关联的邮件帐户。',
    'view.buttonMailSettings' => '邮件设置',
    'view.buttonMailSettingsHint' => '修改该域名的邮件服务。',
    'view.buttonMailLists' => '邮件列表',
    'view.buttonMailListsHint' => '创建和管理邮件列表 - 一次给多个收件人发送电子邮件信息的一种方式。',
    'view.buttonOutgoingSpamSettings' => '传出信息的限制',
    'view.buttonOutgoingSpamSettingsHint' => '设置该域名的传出信息的数量限制。将无法发送超过指定数量限制的信息。',
    'view.buttonInstallApplication' => '创建网站',
    'view.buttonInstallApplicationDesc' => 'CMS、Builders，等等',
    'view.buttonPhpSettings' => 'PHP',
    'view.buttonPhpSettingsVersion' => '版本',
    'view.buttonPhpSettingsHint' => '修改该网站的 PHP 设置。',
    'view.buttonWebServerSettingsUnix' => 'Apache 与 nginx',
    'view.buttonWebServerSettingsUnixHint' => '更改该网站的 Apache 与 nginx 设置。',
    'view.buttonWebServerSettingsWindows' => 'IIS 设置',
    'view.buttonWebServerSettingsWindowsHint' => '修改该网站的 IIS 设置。',
    'view.buttonProtectedDirectories' => '有密码保护的目录',
    'view.buttonProtectedDirectoriesHint' => '限制访问有密码保护的所选网站区。',
    'view.buttonSeoSettings' => 'SEO 设置',
    'view.buttonSeoSettingsHint' => '为您的网站配置特定的搜索引擎设置。',
    'view.buttonSheduledTasks' => '计划的任务',
    'view.buttonSheduledTasksHint' => '查看和管理计划的任务。',
    'view.buttonDatabases' => '数据库',
    'view.buttonDatabasesHint' => '创建和删除网站所用的数据库，并使用集成的管理web应用程序进行管理。',
    'view.buttonLogs' => '日志',
    'view.buttonLogsDescProblem' => '检测出问题',
    'view.buttonLogsHint' => '查看日志并配置日志文件循环。',
    'view.buttonFailedRequests' => '跟踪失败的请求',
    'view.buttonFailedRequestsHint' => '跟踪失败的对您的网站的 HTTP 请求。',
    'view.buttonHotlinkProtection' => '盗链防护',
    'view.buttonHotlinkProtectionHint' => '保护您的网站内容防止被盗链。',
    'view.buttonVirtualFolder' => '虚拟目录',
    'view.buttonVirtualFolderHint' => '创建和管理网站虚拟目录。',
    'view.buttonBandwidthLimiting' => '带宽限制',
    'view.buttonBandwidthLimitingHint' => '调整网站带宽使用限制及连线。',
    'view.buttonDomainAliases' => '域名别名',
    'view.buttonDomainAliasesHint' => '查看并管理网站的多个别名。',
    'view.buttonIpAddresses' => 'IP地址',
    'view.buttonIpAddressesHint' => '管理IP地址。',
    'view.buttonWebUsers' => '网站用户',
    'view.buttonWebUsersHint' => '为在您的网站上托管其个人网页的用户设置帐户。',
    'view.buttonJavaApps' => 'Java应用程序',
    'view.buttonJavaAppsHint' => '安装并管理Java应用程序。',
    'view.buttonOdbcDataSources' => 'ODBC数据源',
    'view.buttonOdbcDataSourcesHint' => '设置ODBC数据源。',
    'view.buttonAspNetSettings' => 'ASP.NET设置',
    'view.buttonAspNetSettingsHint' => '配置ASP.NET框架设置。',
    'view.buttonCustomerIisAppPool' => '您帐户的独立IIS应用程序池。',
    'view.buttonCustomerIisAppPoolHint' => '设置独立IIS应用程序池向您帐户名下的多个网站提供服务。',
    'view.buttonIssAppPool' => '用于网站的独立 IIS 应用程序池',
    'view.buttonIssAppPoolHint' => '设置独立 IIS 应用程序池以服务该网站。',
    'view.buttonSiteCopy' => '网站复制',
    'view.buttonSiteCopyHint' => '复制网站文件到其他网站或外部 FTP 存储。',
    'view.buttonWebDeploy' => 'Web Deploy 发布设置',
    'view.buttonWebDeployHint' => '下载 Web Deploy 发布设置。',
    'view.buttonSubscriptions' => '主机空间',
    'view.buttonSubscriptionsHint' => '查看和管理主机空间。',
    'view.buttonOutgoingMailControl' => '传出邮件控制',
    'view.buttonOutgoingMailControlHint' => '查看和管理传出邮件。',
    'view.forceUpdateApplicationsNotification' => '现在您的应用程序可自动更新。需谨慎使用该设置，因为更新可影响应用程序的功能实现。例如，应用程序的扩展可能不适用于该应用程序的其它版本。%%link%%.',
    'view.forceUpdateAllApplicationsNotificationLink' => '为所有的应用程序启用自动更新',
    'view.unnotifiedApplicationsUpdatesMessage' => '以下应用程序可更新：',
    'view.updatedAutomaticallyApplicationsMessage' => '以下应用程序已进行自动更新：',
    'view.activeStateComponentsWarning' => '服务器中已安装 ActivePython 和/或 ActivePerl 组件。Plesk 不再从 ActiveState 为其授予许可。为避免违反该许可协议，%%link%%。',
    'view.activeStateComponentsWarningLink' => '您需要执行操作',
    'view.toSecurePasswordsGoTo' => '要提高 Plesk 的安全性，我们建议您在该链接 %%link%% 中打开增强的安全模式。',
    'view.securePasswords' => '页面',
    'view.upgradeDnsSyncSkip' => '注意升级后，所有现有的 DNS 区域都会被视作用户修改。这表示您应用 DNS 模板修改到此类区域的方式只能是在 %%link%% 中选择 \'应该更改到所有区域\' 选项。%%learnMoreLink%%.',
    'view.serverDns' => '同步',
    'view.learnMore' => '了解更多',
    'view.backEncryptionRequired' => '出于安全原因，我们建议您保护备份中的数据。请进入 %%link%% 更新备份安全设置。',
    'view.backupSettingPage' => '备份设置',
    'view.ipAddress' => 'IP 地址：%%ipAddress%%',
    'view.ipv4Address' => 'IPv4 地址：%%ipAddress%%',
    'view.ipv6Address' => 'IPv6 地址：%%ipAddress%%',
    'view.subscriptionNotExist' => '该订阅不存在',
    'view.ftpLogin' => 'FTP 登录名：%%ftpLogin%%',
    'view.phpVersion' => 'PHP 版本：%%phpVersion%%',
    'view.phpHandlerOutdated' => '（已过时）',
    'view.resellerDescription' => '代理商',
    'view.ownerDescription' => '客户',
    'view.buttonDescriptionEdit' => '编辑描述',
    'view.buttonDescriptionRemove' => '移除描述',
    'view.popupDescriptionTitle' => '%%name%% %%descriptionType%%',
    'view.confirmOnDeleteDescription' => '您要移除该描述吗？',
    'view.buttonDescription' => '描述',
    'view.updatesAvailable' => '有可用的更新',
    'view.apsInstall' => '安装',
    'view.apsApplicationInstall' => '安装 %%app%%',
    'view.apsInstallAll' => '安装所有',
    'view.apsChangelog' => '更新日志',
    'view.apsApplicationChangelog' => '%%app%% 更新日志',
    'view.apsInstances' => '%%total%% 安装实例',
    'view.loading' => '正在加载...',
    'view.close' => '关闭',
    'view.viewMore' => '继续查看 %%number%% 个更新',
    'view.unableGetChangelog' => '无法检索更新日志。请刷新页面然后再试。',

    'view.buttonAppCatalogue' => '更多应用',
    'view.buttonAppCatalogueComment' => '在应用程序目录中',

    'web-server-settings.titleUnix' => '%%domainName%% 的 Apache 与 nginx 设置',
    'web-server-settings.titleWindows' => '%%domainName%% 的 IIS 设置',
    'web-server-settings.updatedSuccessfully' => '设置已更新。',

    'setup.title' => '网站与域名',
    'setup.noDomainTitle' => '启用网站的所有配套设置',
    'setup.description' => '添加一个新域名以开始创建网站。',
    'setup.openTutorial' => '如果您需要帮助，请参阅我们的%%link%%。',
    'setup.openTutorialLink' => '网站创建教程',
    'setup.addDomain' => '添加域名',
];