<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "بوابة غير صالحة 502: أرسل المصدر عنوانًا كبيرًا جدًا أثناء قراءة عنوان الاستجابة"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "خطأ في الخادم الداخلي 500: غير مسموح بالخيار FollowSymLinks هنا"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "وصل الخادم إلى إعداد الحد الأقصى للأطفال"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>الأعراض</h4><ul><li><p>مواقع الويب التي جرى تعيين معالج PHP بها على أنه <strong>تطبيق FPM متوفر من قِبل Apache</strong> أو <strong>تطبيق FPM متوفر من قِبل nginx</strong> على <strong>النطاقات</strong> &gt؛ <strong>example.com</strong> &gt؛ تواجه <strong>إعدادات PHP</strong> إحدى المشكلات التالية:</p><ul><li><p>التحميل ببطء</p></li><li><p>لا يمكن الوصول إليها (بشكل دائم أو بشكل دوري) مع ظهور الخطأ 50x في متصفح الويب:</p><pre>502 بوابة غير صالحة</pre><hr><pre>503الخدمة غير متاحة مؤقتًا</pre><hr><pre>504 انتهت مهلة البوابة</pre></li></ul></li><li><p>تظهر الرسالة التالية في ملف سجل أخطاء PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (حيثما يمثل الرمز <em>XX</em> إصدار PHP الذي تستخدمه مواقع الويب):</p><pre>تحذير: وصل خادم [pool example.com] إلى إعداد الحد الأقصى للأطفال (*)، يرجى مراعاة ارتفاعه</pre><ul><li><p>عادةً ما يصحب الرسالة الواردة أعلاه هذا الخطأ:</p><pre>يتعذر قراءة ما يقوله الطفل: واصف ملف غير صالح (9)</pre></li></ul></li><li><p>في حالة تمكين nginx على الخادم، فقد تظهر إحدى رسائل الخطأ التالية في ملف سجل أخطاء النطاق <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 اتصال () بـ unix:///var/www/vhosts/system/example.com/php-fpm.sock فشل (11: المورد غير متاح مؤقتًا) أثناء الاتصال بالمصدر، العميل: 203.0.113.2، الخادم: example.com، الطلب: "GET / HTTP/1.1"، المصدر: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:"، المضيف: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 لقد أغلق اتصال المصدر قبل المدة المحددة أثناء قراءة عنوان الاستجابة من المصدر، العميل: 203.0.113.2، الخادم: example.com، الطلب: "POST /path/to/some/file HTTP/2.0"، المصدر:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' وصل موقع الويب (مواقع الويب) إلى <p>PHP-FPM <code>pm.max_children</code>.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'يرجى زيادة حد pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>زيادة حد <code>pm.max_children</code> للنطاقات المتضررة:</p><ol><li><p>اتصل بخادم منصة Plesk عبر <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>ابحث عن النطاقات المتضررة باستخدام الأمر الوارد أدناه:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>ملاحظة:</strong> يشير الرقم الموجود على اليسار إلى عدد مرات وصول موقع الويب إلى حد <code>pm.max_children</code>.</div><pre style="white-space: pre-wrap;"># grep -r "وصل الخادم إلى إعداد max_children" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">سجِّل الدخول إلى منصة Plesk</a>.</p></li><li><p>انتقل إلى <strong>النطاقات</strong> &gt; <strong>example.com</strong> &gt; <strong>إعدادات PHP</strong> &gt; <strong>إعدادات PHP-FPM</strong>.</p></li><li><p>زيادة قيمة <code>pm.max_children</code> للنطاق وتطبيق التغييرات. قم بزيادة هذه القيمة لجميع النطاق المدرجة في الخطوة 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "يوجد عدد كبير جدًا من الملفات مفتوحًا"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>يفشل nginx في البدء / إعادة التحميل على خادم منصة Plesk: يوجد عدد كبير جدًا من الملفات مفتوحًا</p><h4>الأعراض</h4><ul><li><p>تفشل خدمة nginx في البدء / إعادة التحميل مع ظهور الخطأ التالي في ملف <code>/var/log/nginx/error.log</code>:</p><pre style="white-space: pre-wrap;">nginx: [emerg] فتح () "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" فشل (24: يوجد عدد كبير جدًا من الملفات مفتوحًا)</pre></li><li><p>لا يمكن الوصول إلى بعض من مواقع الويب أو كلها</p></li><li><p>يظهر تحذير في <strong>الأدوات&amp; الإعدادات &gt; التشخيص &amp; الإصلاح</strong>:</p><pre style="white-space: pre-wrap;">التحقق من nginx؛ عُثر على نطاقات N بقيمة ULIMIT على الخادم. يمكن حدوث مشكلة مع الحد الافتراضي لـ nginx للملفات المفتوحة</pre></li><li><p>تعرض تطبيقات الويب NodeJS وRuby خطأ 502 بوابة غير صالحة عند تنفيذ بعض مهام منصة Plesk مثل إنشاء النطاقات والاشتراكات والتغييرات على Apache أو Nginx وما إلى ذلك:</p><pre style="white-space: pre-wrap;">خطأ في الخادم<br>502 بوابة غير صالحة <br>تلقى خادم الويب استجابة غير صالحة أثناء العمل كبوابة أو خادم وكيل.</pre></li><li><p>بعد <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">تثبيت شهادة جديدة للنطاق</a>، يستمر عرض الشهادة القديمة في مستعرض الويب، ومع ذلك، تُحدد الشهادة الصحيحة في صفحة <strong>النطاقات &gt; example.com &gt; إعدادات الاستضافة</strong>.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>يفتح مضيف Nginx الافتراضي 4 ملفات سجل لكل مضيف افتراضي باستخدام استضافة فعلية:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>ونتيجة لهذه الحقيقة، يتجاوز خادم nginx العدد الأقصى للملفات المفتوحة نظرًا لوجود عدد كبير من النطاقات (أكثر من 100 عادة).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'يرجى زيادة حد الملفات المفتوحة',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>تحذير:</strong> يؤدي تنفيذ الأداة المساعدة <code>websrv_ulimits</code> بدون الخيار <strong>--no-restart</strong> إلى بدء إعادة إنشاء ملفات تكوين الويب لجميع النطاقات ويمكن أن يتسبب في تعطل ملحوظ في حالة وجود عدد كبير من مواقع الويب المستضافة.<br><br>نفِّذ الأمر أثناء الإطار الزمني للصيانة.</div><p>ومن الممارسات الجيدة تعيين قيمة لحد الملفات المفتوحة تزيد عن<strong>عدد النطاقات في منصة Plesk * 16</strong> على الأقل. وفي المثال الوارد أدناه، أوضحت الإجراءات كيفية تعيين الحد إلى 4096:</p><ol><li><p>اتصل بالخادم عبر <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>عيِّن حد الملفات المفتوحة على 4096 لكل من Apache وNginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>أعد تشغيل خدمات Apache وnginx في<strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">منصة Plesk</a> &gt;</strong> <strong>الأدوات المساعدة &amp; الإعدادات &gt; إدارة الخدمات</strong> لتطبيق التغييرات.</p></li><li><p>تأكد من تطبيق "الحد الأقصى للملفات المفتوحة" بشكل صحيح، بعد إعادة تشغيل خدمات الويب:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>الحد الأقصى للملفات المفتوحة 4096 4096 ملف</pre></li><li><p>في حالة عدم جدوى الحل المذكور أعلاه، عيِّن الحد الأقصى باستخدام الأداة المساعدة <code>ulimit</code>:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "النص الأساسي للاستجابة كبير جدًا"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "تم رفض الوصول مع ظهور الرمز 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>الأعراض</h4><ul><li><p>تم تثبيت ModSecurity وتمكينه في <strong>الأدوات والإعدادات > جدار حماية تطبيق الويب (ModSecurity) > وضع جدار حماية تطبيق الويب > تشغيل</strong>.</p></li><li>فشل تحميل موقع ويب مستضاف في منصة Plesk. لا يمكن إجراء أي عمليات على موقع الويب مثل إدارة WordPress أو الوصول إلى بريد الويب أو الوصول إلى ملف <code>robots.txt</code>. يمكن للمتصفح عرض أحد الأخطاء التالية: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 محظور</pre><hr><pre> 500 خطأ داخلي في الخادم</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>تظهر رسالة خطأ ModSecurity مثل الرسالة الواردة أدناه في ملف السجل <code>/var/log/modsec_audit.log</code> أو في صفحة السجلات في منصة Plesk (<strong>النطاقات</strong> &gt; <strong>example.com</strong> &gt; <strong>السجلات</strong>): <pre>ModSecurity: تم رفض الوصول باستخدام الرمز 403 (المرحلة 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>يتم تمكين جدار حماية تطبيق الويب ModSecurity مع مجموعة قواعد مقيدة للغاية مثل OWASP أو Comodo أو مجموعة قواعد مخصصة مثل Imunify360. يمكن أن تمنع مجموعات القواعد المقيدة بعض العمليات على موقع الويب.</p><p><Strong>ملاحظة:</strong> قد يشير خطأ ModSecurity إلى وجود هجوم على خادمك. لا تستخدم الحلول الموضحة أدناه سوى إذا كنت متأكدًا من أن ModSecurity يحظر الاستخدام الصحيح لموقعك على الويب.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'عطِّل مجموعة قواعد ModSecurity بواسطة المعرّف أو العلامة',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>ابحث عن معرّف القاعدة التي تحظر الاستخدام المشروع لموقعك على الويب. يمكنك العثور على المعرّفات داخل رسائل الخطأ في ملف السجل <code>/var/log/modsec_audit.log</code>. المعرّف هو رقم صحيح بين علامتي اقتباس مع البادئة <code>id</code> بين قوسين معقوفين، على سبيل المثال، <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">تعطيل مجموعات قواعد معينة في منصة Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'بدِّل إلى مجموعة قواعد ModSecurity أخرى',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>بدِّل إلى مجموعة قواعد ModSecurity أقل تقييدًا، على سبيل المثال، "مجموعة قواعد Atomic ModSecurity". للقيام بذلك، انتقل إلى <strong>الأدوات والإعدادات</strong> > <strong> جدار حماية تطبيق الويب (ModSecurity)</strong> > <strong>الإعدادات</strong>، حدد <strong>Atomic Standard</strong>، ثم انقر فوق <strong>موافق</strong> لتطبيق التغييرات.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "خطأ داخلي في الخادم 500: تم استنفاد حجم الذاكرة المسموح به البالغ XXX"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>الأعراض</h4><ul><li><p>لا يمكن الوصول إلى موقع ويب مستضاف في منصة Plesk:</p><pre>500 خطأ داخلي في الخادم</pre></li><li><p>يظهر الخطأ التالي في سجل موقع الويب:</p><pre>حصلت على خطأ "رسالة PHP: خطأ فادح في PHP: تم استنفاد حجم الذاكرة المسموح به وهو 4194304 بايت (حاول تخصيص 4000032 بايت) في /var/www/vhosts/example.com/httpdocs/somethingBig.php في السطر 3</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>لا يحتوي موقع الويب على ذاكرة كافية مخصصة للمعالجة.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'زيادة memory_limit "حد ذاكرة" الموقع',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "قيد open_basedir ساري المفعول"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>الأعراض</h4><ul><li><p>لا يمكن الوصول إلى موقع ويب مع وجود أحد الأخطاء التالية في متصفح الويب:</p><pre>404 الملف غير موجود</pre><hr><pre>500 خطأ في الخادم الداخلي</pre><hr><pre>خطأ 500 move_uploaded_file (): تقييد open_basedir ساري المفعول. الملف (/path/to/the/directory) ليس ضمن المسار (المسارات) المسموح بها:(/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>تظهر رسالة الخطأ التالية في صفحة سجلات النطاق (<strong>النطاقات</strong> > <strong>example.com</strong> > <strong>السجلات</strong>):</p><pre><...>تقييد open_basedir ساري المفعول. الملف (/path/to/the/directory) ليس ضمن المسار (المسارات) المسموح بها<...></pre><hr><pre>استثناء غير محدد: الجلسة: مسار الحفظ المكون "/path/to/the/directory" ليس دليلًا أو غير موجود أو لا يمكن إنشاؤه.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'يحاول البرنامج النصي لـ PHP الوصول إلى الدليل الذي لا يُسمح بالوصول إليه. يُحدَّد هذا القيد من خلال توجيه PHP <code>open_basedir</code> بشكل فردي لكل نطاق. افتراضيًا، يسمح <code>open_basedir</code> بالوصول إلى <code>tmp</code> وأدلة جذر مستندات النطاق، بالإضافة إلى مسار الجلسات الافتراضية للنظام.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'أضف المسار الإضافي إلى التوجيه open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'عطِّل التوجيه open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>انتقل إلى صفحة <strong>النطاقات &gt example.com &gt إعدادات PHP</strong> وعيِّن توجيه <code>open_basedir</code> إلى "لا شيء".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 محظور AH01797: تم رفض العميل بواسطة تكوين الخادم"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>الأعراض</h4><ul><li><p>يعرض موقع الويب خطأ مشابهًا للخطأ التالي:</p><pre>خطأ في الخادم 403<br>محظور</pre></li><li><p>يحتوي ملف السجل <code>/var/www/vhosts/system/example.com/logs/error_log</code> على أخطاء مثل الخطأ التالي:</p><pre>AH01797: تم رفض العميل بواسطة تكوين الخادم: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>لا يسمح تكوين Apache الحالي بالوصول إلى موقع الويب.</p><p>بالنسبة لملفات مثل .htaccess و.htpasswd، من المتوقع هذا نظرًا لأن هذه الملفات يجب عدم الوصول إليها عبر خادم الويب.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'تحقق من تكوين الخادم وملفات .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "لا يمكن الوصول إلى دليل موقع الويب في منصة Plesk: 403 محظور"',
    'problem-detail.apache-no-directory-index.description' => '<h4>الأعراض</h4><ul><li><p>لا يمكن الوصول إلى موقع معين لموقع ويب، على سبيل المثال، <code>http://example.com/some_folder</code>. حدث الخطأ التالي: </p><pre>خطأ في الخادم 403<br>محظور</pre></li><li><p>يظهر الخطأ التالي في الملف <code>/var/www/vhosts/example.com/logs/error_log<code/>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: لا يمكن تقديم الدليل /var/www/vhosts/example.com/httpdocs/some_folder/: لم يُعثر على DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) مطابق، وفهرس الدليل الذي تم إنشاؤه بواسطة الخادم محظور بواسطة توجيه الخيارات</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>لا يحتوي الدليل المطلوب على ملفات فهرس أو لم يتم تمكين تصفح الدليل.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'أضف ملف فهرس إلى الدليل',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'تمكين تصفح الدليل',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "لا يمكن الوصول إلى دليل موقع الويب في منصة Plesk: 403 محظور"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>الأعراض</h4><ul><li><p>لا يمكن الوصول إلى موقع معين لموقع ويب، على سبيل المثال، <code>http://example.com/some_folder</code>. حدث الخطأ التالي:</p><pre>خطأ في الخادم 403<br>محظور</pre></li><li><p>يظهر الخطأ التالي في <code>/var/www/vhosts/example.com/logs/error_log file</code>:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: لا يمكن تقديم الدليل /var/www/vhosts/example.com/httpdocs/some_folder/: لم يُعثر على DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) مطابق، وفهرس الدليل الذي تم إنشاؤه بواسطة الخادم محظور بواسطة توجيه الخيارات</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>لا يحتوي الدليل المطلوب على ملفات فهرس أو لم يتم تمكين تصفح الدليل.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'أضف ملف فهرس إلى الدليل',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'تمكين تصفح الدليل',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "وصل الخادم إلى إعداد MaxRequestWorkers"',
    'problem-detail.apache-reached-max-request-workers.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'حد النص الأساسي لطلب PHP "ينوي العميل إرسال نص أساسي كبير للغاية"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'حد النص الأساسي لطلب PHP "ينوي العميل إرسال نص أساسي كبير للغايى"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'جلسات PHP "خطأ الخادم الداخلي 503" أو "فشلت قراءة بيانات الجلسة"',
    'problem-detail.php-failed-to-read-session-data.description' => 'سيكون جاهزًا قريبًا.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 ممنوع: pcfg_openfile: يتعذر فحص ملف htaccess، تأكد من أنه قابل للقراءة"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>الأعراض</h4><ul><li><p>لا يعمل موقع الويب المستضاف في منصة Plesk:</p><pre>ليس لديك إذن للوصول / على هذا الخادم. <br> بالإضافة إلى ذلك، تمت مصادفة الخطأ 403 محظور أثناء محاولة استخدام ErrorDocument لمعالجة الطلب.</pre><p>بدلاً من الخطأ الوارد أعلاه، يمكنك أيضًا مشاهدة الصفحة الفارغة.</p></li><li><p>يحتوي سجل أخطاء النطاق في <strong>النطاقات &gt example.com &gt السجلات</strong> على ما يلي:</p><pre>(13) تم رفض الإذن: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: يتعذر التحقق من ملف htaccess، تأكد من أنه قابل للقراءة وأن "/var/www/vhosts/example.com/httpdocs/" قابل للتنفيذ</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'أذونات غير صحيحة لملفات أو مجلدات النطاق.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'أذونات الإصلاح لمحتوى موقع الويب',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">اقرأ مقالة قاعدة المعارف واتبع التعليمات</a>.</p></li></ol>',
];