<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Soubory protokolů",
    'action-log.fromDate' => "Od:",
    'action-log.toDate' => "Komu:",
    'action-log.clearLog' => "Vymazat protokol",
    'action-log.downloadLog' => "Stáhnout",
    'action-log.loggedActions' => "Protokolované akce",
    'action-log.storeLogsInDb' => "Uložit záznamy do databáze",
    'action-log.storeNumber' => "Položky",
    'action-log.dontRemoveRecs' => "Neodstraňovat záznamy",
    'action-log.confirmCleanLog' => "Opravdu chcete odstranit vybrané záznamy protokolu akcí?",
    'action-log.incorrectDate' => "Je zadáno neplatné datum.",
    'action-log.incorrectNumPeriods' => "Byl zadán neplatný interval rotace.",
    'action-log.incorrectNumRecords' => "Byl zadán neplatný počet záznamů.",
    'action-log.yes' => "Ano",
    'action-log.no' => "Ne",
    'action-log.mixed' => "(smíšené)",
    'action-log.period' => "Období",
    'action-log.invalidDatePeriod' => "Neplatné období dat",
    'action-log.submitDone' => "Změny v nastavení protokolu akcí byly uloženy.",
    'action-log.clearDone' => "Protokol akcí smazán.",
    'action-log.periodDay' => "dny",
    'action-log.periodWeek' => "týdny",
    'action-log.periodMonth' => "měsíce",

    'admin-info.adminInfoSection' => 'Informace pro správce',
    'admin-info.description-admin' => 'Popis správce',
    'admin-info.description-reseller' => 'Popis prodejce',
    'admin-info.description-owner' => 'Popis vlastníka',
    'admin-info.description' => 'Popis',
    'admin-info.descriptionSuccess' => 'Popis byl aktualizován.',
    'admin-info.longDescription' => 'Zadaný popis je příliš dlouhý. Nesmí být delší než %%max%% symbolů.',
    'admin-info.add' => 'Přidat popis',
    'admin-info.edit' => 'Upravit',
    'admin-info.remove' => 'Odstranit',
    'admin-info.confirmOnRemove' => 'Chcete odebrat tento popis?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% zákazníka %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% prodejce %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% předplatného %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% z %%name%%',
    'admin-info.popupHint-admin' => 'Tento popis je viditelný pouze pro správce.',
    'admin-info.popupHint-reseller' => 'Tento popis je viditelný pro prodejce a správce.',
    'admin-info.popupHint-owner' => 'Tento popis je viditelný pro svého autora a pro jeho poskytovatele hostingu.',
    'admin-info.customerDescriptionHint' => 'Zákazníci nemohou vidět tento popis.',
    'admin-info.subscriptionDescriptionHint' => "Tuto informace uvidí pouze poskytovatel hostingu (správce nebo prodejce Plesk).",

    'apache-settings.formGeneralHint' => 'Zde můžete zadat nastavení webového serveru Apache pro tento web. Vlastní konfigurace Apache je užitečná například tehdy, když chcete použít na svém webu nový typ indexových souborů nebo přiřadit určitý typ MIME k určitým příponám názvu souborů. Výchozí hodnota znamená, že Apache použije odpovídající direktivu ze své konfigurace pro celý server. Pokud je Apache spuštěno s nginx jako front-end server, můžete na této stránce zadat také nastavení nginx.',
    'apache-settings.general' => 'Obecné nastavení Apache',
    'apache-settings.example' => "Například: %%example%%",
    'apache-settings.settingOn' => 'Zapnout',
    'apache-settings.settingOff' => 'Vypnuto (výchozí)',
    'apache-settings.settingDefault' => 'Výchozí',
    'apache-settings.settingCustom' => 'Zadejte vlastní hodnotu',
    'apache-settings.mimeTypes' => 'Typy MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Typy MIME přidružují přípony souborů k typům souborů. Obvykle se toto používá k vytvoření vlastní přípony souborů pro běžné typy souborů.',
    'apache-settings.handlers' => 'Obslužné podprocesy',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Obslužné rutiny Apache definují, jakým způsobem webový server zpracovává soubory s určitými předponami, když jsou vyžádány. Například řetězec „php-script .script“ znamená, že Apache zpracuje soubory .script jako skripty php.",
    'apache-settings.deny' => 'Odepřít přístup na web',
    'apache-settings.allow' => 'Kromě',
    'apache-settings.denyExample' => "10.1.0.0/16 192.168.1.110 Zadaní hostitelé a sítě mají zakázán přístup na web. Chcete-li všechna spojení odmítnout, použijte '*'.",
    'apache-settings.allowExample' => "192.168.0.0/16 10.1.1.21 Zadaní hostitelé a sítě mají povolen přístup na web.",
    'apache-settings.directoryIndex' => 'Indexové soubory',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "Apache bude hledat zadané soubory, když bude vyžádána stránka indexu webu.",
    'apache-settings.expires' => 'Vyprší',
    'apache-settings.expiresStaticOnly' => 'odpověď se záhlavím Vyprší pouze pro statické soubory',
    'apache-settings.expiresFullDescription' => 'Webový server přidá na webové stránky záhlaví "Vyprší". Časové razítko vypršení se získá přidáním výše specifikovaného časového intervalu k času, při němž je webová stránka vyžadována.',
    'apache-settings.expiresStaticOnlyDescription' => 'Záhlaví "Vyprší" bude přidáno pouze ke statickým souborům. Soubory, které budou zpracovány jako statické, budou určeny nastavením položek "Zpracování inteligentních statických souborů" a "Zpracovat statické soubory přímo prostřednictvím nginx".',
    'apache-settings.expiresUnitDays' => 'dny',
    'apache-settings.expiresUnitHours' => 'hodiny',
    'apache-settings.expiresUnitMinutes' => 'minuty',
    'apache-settings.expiresUnitSeconds' => 'sekundy',
    'apache-settings.headers' => 'Další záhlaví',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Webový server přidá zadaná záhlaví odpovědi HTTP.",
    'apache-settings.restrictFollowSymLinks' => 'Omezit schopnost sledovat symbolické odkazy',
    'apache-settings.restrictFollowSymLinksDescription' => "Tuto možnost vyberte, chcete-li zakázat uživatelům, aby používali direktivu FollowSymLink v .htaccess a zvýšili úroveň zabezpečení serveru.",
    'apache-settings.nginx' => 'Nastavení nginx',
    'apache-settings.nginxProxyMode' => 'Režim Proxy',
    'apache-settings.nginxProxyModeDescription' => 'Požadavky proxy serveru Nginx na Apache. Vypnout a zastavit používání Apache.',
    'apache-settings.nginxTransparentMode' => 'Zpracování inteligentních statických souborů',
    'apache-settings.nginxTransparentModeDescription' => 'Jestliže bude vypnuto, Apache zpracuje všechny požadavky na statické soubory. nginx projde pouze požadavky a odpovědi bez úprav. Tuto možnost vypněte pouze při vyhledávání závad.',
    'apache-settings.nginxServeStatic' => 'Zpracovat statické soubory přímo prostřednictvím nginx',
    'apache-settings.nginxStaticExtensions' => 'Zadat přípony souborů oddělené mezerou nebo symbolem "|" . Žádost pro tyto soubory bude zpracována prostřednictvím nginx a nikdy nedosáhne Apache. Upozornění: pravidla Apache pro přepis nelze použít.',
    'apache-settings.nginxServePhp' => 'Zpracovat PHP prostřednictvím nginx',
    'apache-settings.nginxServePhpDescription' => 'Soubory PHP (.PHP) budou zpracovány prostřednictvím nginx a PHP-FPM. Je-li vypnuto, soubory PHP bude zpracovávat Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Maximální přípustná velikost těla požadavku HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Požadavky s textem přesahujícím limit budou zahozeny s chybou HTTP 413 Payload Too Large (konfiguruje hodnotu nařízení nginx „client_max_body_size“).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Volbu lze globálně zakázat prostřednictvím prázdné/nulové hodnoty nařízení „clientMaxBodySize“ v souboru panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Povolit ukládání do mezipaměti nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'Ukládání do mezipaměti může snížit dobu odezvy a zátěž serveru, ale mělo by se využívat s mírou.',
    'apache-settings.nginxCacheSize' => 'Velikost mezipaměti',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => 'Časový limit mezipaměti',
    'apache-settings.nginxCacheTimeoutDays' => 'dnů',
    'apache-settings.nginxCacheTimeoutHours' => 'hodiny',
    'apache-settings.nginxCacheTimeoutMinutes' => 'minuty',
    'apache-settings.nginxCacheTimeoutSeconds' => 'sekundy',
    'apache-settings.nginxCacheKey' => 'Klíč mezipaměti',
    'apache-settings.nginxCacheCookies' => 'Žádosti mezipaměti se soubory cookie',
    'apache-settings.nginxCacheBypassLocations' => 'Zakázat ukládání do mezipaměti pro umístění',
    'apache-settings.nginxCacheBypass' => 'Přeskočit mezipaměť, když',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'V případě přijetí požadavku hlaviček HTTP no-cache',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'V případě přijetí požadavku hlaviček ověření HTTP',
    'apache-settings.nginxCacheBypassGetNocache' => 'V případě přijetí požadavku na parametr GET nocích',
    'apache-settings.nginxCacheUseStale' => 'Návrat zastaralých záznamů uložených v mezipaměti',
    'apache-settings.nginxCacheUseStale5xx' => 'Odesílání vrací chybu klienta 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'Odesílání vrací chybu klienta 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Probíhá aktualizace mezipaměti',
    'apache-settings.additional' => 'Další direktivy Apache',
    'apache-settings.additionalSettingsDescription' => 'Pokud nelze nalézt konkrétní nastavení, přidejte je do níže uvedeného pole. Tato nastavení nahradí direktivy Apache celého serveru. Direktivy z prvního pole se použijí, když návštěvník přistupuje k webu prostřednictvím HTTP. Druhé pole obsahuje direktivy pro HTTPS. Obecně platí, že byste měli přidat své direktivy do obou polí. Použijte stejný syntax jako používáte pro httpd.include. Pokud chcete například nastavit vlastní chybovou stránku, přidejte řádek: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Další direktivy pro HTTP',
    'apache-settings.additionalSslSettings' => 'Další direktivy pro HTTPS',
    'apache-settings.additionalSettingsError' => 'Neplatná konfigurace Apache: %%error%%',
    'apache-settings.rollbackFailed' => 'Nelze použít aktuální konfigurační soubor Apache a vrátit se nazpět k předchozí verzi souboru, protože soubory obsahují neplatnou konfiguraci.',
    'apache-settings.additionalNginx' => 'Další direktivy nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'Zde můžete zadat nastavení pro reverzní proxy server, který běží před Apache. Vaše direktivy nahradí konfiguraci nginx celého serveru. Například můžete změnit časový limit připojení nebo zabalit požadavky prostřednictvím gzip. Použijte stejný syntax jako používáte pro nginx.conf. Pokud chcete například zabalit všechny požadavky odeslané serverem proxy pomocí gzip, přidejte řádek: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Další direktivy nginx',
    'apache-settings.additionalNginxSettingsError' => 'Neplatná konfigurace nginx: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Nelze použít aktuální konfigurační soubor nginx a vrátit se nazpět k předchozí verzi souboru, protože oba obsahují neplatnou konfiguraci.',
    'apache-settings.clearCache' => 'Vyčistit mezipaměť',
    'apache-settings.clearCacheHint' => 'Vyčistit mezipaměť nginx pro web %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Mezipaměť byla úspěšně vyčištěna',

    'backup.backup-password-protection.securitySettingsSection' => 'Nastavení zabezpečení zálohy',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Získat heslo z nastavení vzdáleného úložiště',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Zadat heslo ručně',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Poskytnout heslo',
    'backup.backup-password-protection.backupPassword' => 'Heslo',
    'backup.backup-password-protection.inputPasswordType' => 'Typ hesla',
    'backup.backup-password-protection.confirmBackupPassword' => 'Zopakovat heslo',
    'backup.backup-password-protection.backupPasswordHint' => 'Pokud jste heslo zapomněli, tuto možnost vymažte. Všimněte si, že v tomto případě nebudou některá citlivá data obnovena správně. Například uživatelská hesla budou nahrazena náhodnými, informace o již nainstalovaných aplikacích APS budou ztraceny atd.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Pokud jste pro tuto zálohu použili ochranu heslem, zadejte heslo do níže uvedeného pole. Pamatujte si, že pokud zadáte nesprávné heslo, prostředí Plesk zálohu neobnoví. Místo toho bude soubor zálohy zkopírován na místní úložiště.',

    'backup.conflict-database.dbMappingLegend' => 'Mapování databázových serverů',
    'backup.conflict-database.serverType' => 'Typ serveru',
    'backup.conflict-database.hostName' => 'Název hostitele',
    'backup.conflict-database.port' => 'Port',
    'backup.conflict-database.destinationDbServer' => 'Server cílové databáze',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Databáze nebude obnovena: neexistuje vhodný databázový server.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Nahrát soubor mapování IP',
    'backup.conflict-ip.ipMappingLegend' => 'Mapování IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Uložit aktuální mapování IP do souboru',
    'backup.conflict-ip.ipAddressNotFound' => 'Žádné volné IP adresy tohoto typu.',
    'backup.conflict-ip.sharedIp' => 'Sdílený',
    'backup.conflict-ip.dedicatedIp' => 'vyhrazený',
    'backup.conflict-ip.fileNotFound' => 'Soubor nesmí být prázdný.',
    'backup.conflict-ip.invalidIpToMap' => 'Neplatná hodnota pro starou IP adresu: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Neplatná hodnota pro novou IP adresu: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'IP adresa %%ip%% nebyla v databázi nalezena.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Nahrát soubor mapování IP',
    'backup.conflict-ip.ipMappingFileHint' => 'Soubor mapování IP je ve formátu prostého textu. Každý řádek tohoto souboru obsahuje IP mapování ve formátu: <stará IP adresa> <nová IP adresa>',
    'backup.conflict-ip.oldIp' => 'Staré IP adresy',
    'backup.conflict-ip.newIp' => 'Nové IP adresy',

    'backup.copy-to-server.ignoreBackupSign' => 'Nahrát soubory zálohy bez platného podpisu',
    'backup.copy-to-server.wrongPassword' => 'Zadané heslo je nesprávné. Během obnovení zálohy vás Plesk znovu vyzve k zadání hesla.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Nahraný soubor zálohy %%fileName%% byl upraven, poškozen, vytvořen na jiném serveru nebo ve starší verzi Plesk, která nepodporuje podepisování záloh. Před obnovením dat z tohoto souboru zálohy se ujistěte, že můžete zdroji tohoto souboru důvěřovat.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Nelze nahrát soubor zálohy %%fileName%%. Soubor obsahuje upravená nebo poškozená data nebo byl vytvořen na jiném serveru nebo ve starší verzi Plesk. Chcete-li obnovit data z tohoto souboru, kontaktujte svého poskytovatele hostitelských služeb.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Nelze nahrát soubor zálohy %%fileName%%. Soubor byl upraven, poškozen, vytvořen na jiném serveru nebo ve starší verzi Plesk, která nepodporuje podepisování záloh. Pokud této záloze důvěřujete, vyberte možnost "Nahrát soubory zálohy bez platných podpisů" a nahrávání zopakujte.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Vybranou zálohu %%fileName%% nelze přesunout na úložiště serveru. Chyba: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Následující části přírůstkové zálohy nebyly zkopírovány:%%endl%%%%missedParts%%%%endl%%Zkopírujte chybějící části.",

    'backup.ftp-settings.isActive' => 'Použít úložiště FTP',
    'backup.ftp-settings.host' => 'Název hostitele nebo IP adresa FTP serveru',
    'backup.ftp-settings.directory' => 'Adresář pro ukládání záložních souborů',
    'backup.ftp-settings.directoryHint' => 'Například, /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'Přihlašovací jméno FTP',
    'backup.ftp-settings.ftpPassword' => 'Heslo FTP',
    'backup.ftp-settings.usePassiveMode' => 'Použít pasivní režim',
    'backup.ftp-settings.useFtps' => 'Použít FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Použití místního FTP serveru Plesk jako vzdáleného úložiště je zakázáno. Zadejte vzdálené umístění.',
    'backup.ftp-settings.warningHostIsLocal' => 'Nastavení úložiště FTP(S) bylo nakonfigurováno tak, aby umožnilo ukládání záloh na serveru, kde jsou umístěny soubory vašeho předplatného. Tato konfigurace se nedoporučuje kvůli nebezpečí ztráty dat a nadměrnému využití místa na disku.',
    'backup.ftp-settings.enterFtpLogin' => 'Zadejte správné uživatelské jméno.',
    'backup.ftp-settings.enterFtpPassword' => 'Zadejte správné heslo.',

    'backup.remote-settings.isActive' => 'Použít úložiště',
    'backup.remote-settings.initError' => 'Nelze inicializovat nastavení stránky %%extName%% : %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Nastavení zabezpečení zálohy',

    'backup.restore.detailsSection' => 'Podrobnosti',
    'backup.restore.contentInfoSection' => 'Obsah zálohy',
    'backup.restore.restorationOptionsSection' => 'Možnosti obnovení',
    'backup.restore.emailNotification' => 'Až se obnovení dokončí, odešlete oznámení na',
    'backup.restore.comments' => 'Komentáře',
    'backup.restore.creationDate' => 'Datum vytvoření',
    'backup.restore.systemNotes' => 'Poznámky k systému',
    'backup.restore.ownerAdmin' => 'Vytvořil správce.',
    'backup.restore.ownerReseller' => 'Vytvořil prodejce.',
    'backup.restore.ownerCustomer' => 'Vytvořil zákazník.',
    'backup.restore.ownerServiceUser' => 'Vytvořeno dalším uživatelem.',
    'backup.restore.partOfParentBackup' => 'Část %%type%% zálohy.',
    'backup.restore.server' => 'server',
    'backup.restore.reseller' => 'prodejce',
    'backup.restore.client' => 'zákazník',
    'backup.restore.incremental' => 'Přírůstková.',
    'backup.restore.multiVolume' => 'Větší počet svazků.',
    'backup.restore.backupSize' => 'Velikost zálohy',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (toto přidání) + %%base%% (výchozí záloha) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (toto přidání) + %%prev%% (předchozí přidání) + %%base%% (výchozí záloha) = %%total%%',
    'backup.restore.download' => 'Stáhnout',
    'backup.restore.downloadHint' => 'Stáhnout soubor zálohy na místní počítač.',
    'backup.restore.downloadDisabled' => 'Stahování souboru zálohy je dočasně nedostupné. Zkuste akci zopakovat později nebo kontaktujte svého poskytovatele služeb.',
    'backup.restore.copy' => 'Kopírovat na úložiště serveru',
    'backup.restore.copyHint' => 'Kopírovat vybrané záložní soubory na úložiště serveru.',
    'backup.restore.contentInfo' => 'Obsah zálohy',
    'backup.restore.restoreButton' => 'Obnovit',
    'backup.restore.mail' => 'Pošta',
    'backup.restore.domainConfiguration' => 'Konfigurace domény',
    'backup.restore.virtualHost' => 'Obsah virtuálního hostitele',
    'backup.restore.database' => 'Databáze',
    'backup.restore.serverConfiguration' => 'Nastavení serveru',
    'backup.restore.serverConfigurationLicense' => 'Licenční klíč',
    'backup.restore.serverPersonalConfiguration' => 'Konfigurace účtu správce:',
    'backup.restore.serverPersonalDomains' => 'Domény správce',
    'backup.restore.serverPersonalClients' => 'Zákazníci správce',
    'backup.restore.resellers' => 'Distributoři',
    'backup.restore.resellerPersonalConfiguration' => 'Konfigurace účtu prodejce',
    'backup.restore.resellerPersonalDomains' => 'Domény prodejce',
    'backup.restore.resellerPersonalClients' => 'Zákazníci prodejce',
    'backup.restore.clientPersonalConfiguration' => 'Konfigurace účtu zákazníka',
    'backup.restore.clientPersonalDomains' => 'Domény zákazníka',
    'backup.restore.restoreModifiedSection' => 'Obnovit soubor zálohy bez ohledu na porušený podpis',
    'backup.restore.restoreModifiedDump' => 'Obnovte tuto zálohu bez ohledu na skutečnost, že nemá platný podpis',
    'backup.restore.resolutionPolicy' => 'Zásady řešení',
    'backup.restore.resolutionPolicyDescription' => 'Konflikty časování nastanou, když obnovený objekt již existuje v systému s novějším datem změny, nebo když obnovený objekt není momentálně v systému přítomen.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Zadané heslo je nesprávné. Soubor zálohy bude zkopírován na místní úložiště serveru.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Zálohu nelze obnovit. Zadané heslo je nesprávné.',
    'backup.restore.serverContentAndConfiguration' => 'Konfigurace a obsah serveru',
    'backup.restore.serverConfigurationOnly' => 'Konfigurace serveru',
    'backup.restore.resellerContentAndConfiguration' => 'Konfigurace a obsah účtu prodejce',
    'backup.restore.resellerConfigurationOnly' => 'Konfigurace účtu prodejce',
    'backup.restore.clientContentAndConfiguration' => 'Konfigurace a obsah účtu zákazníka',
    'backup.restore.clientConfigurationOnly' => 'Konfigurace účtu zákazníka',
    'backup.restore.domainContentAndConfiguration' => 'Konfigurace a obsah domény',
    'backup.restore.domainConfigurationOnly' => 'Konfigurace domény',
    'backup.restore.restoreType' => 'Co chcete obnovit?',
    'backup.restore.restoreTypeFull' => 'Všechny objekty (celý systém)',
    'backup.restore.restoreTypeGranular' => 'Vybrané objekty',
    'backup.restore.restoreObjectType' => 'Typ objektu, který se má obnovit',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Předplacená služba',
    'backup.restore.restoreObjectTypeCustomers' => 'Zákazník',
    'backup.restore.restoreObjectTypeResellers' => 'Prodejce',
    'backup.restore.restoreObjectTypeMailUsers' => 'Poštovní účet',
    'backup.restore.restoreObjectTypeDatabases' => 'Databáze',
    'backup.restore.restoreObjectTypeCertificates' => 'Certifikáty SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Weby',
    'backup.restore.restoreObjectTypeDnsZones' => 'Zóna DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Seznamy adresátů',
    'backup.restore.restoreObjectTypeWebContent' => 'Soubory po domény',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Vybrané soubory',
    'backup.restore.restoreSubscriptionLookup' => 'Předplacená služba',
    'backup.restore.restoreComponents' => 'Součásti, které se mají obnovit',
    'backup.restore.errorLog' => 'Protokol chyb',
    'backup.restore.backupDetailsLogDoesntExist' => 'Protokol zálohování není k dispozici',
    'backup.restore.dumpFailedSection' => 'Protokol chyb',
    'backup.restore.dumpFailed' => 'Nelze obnovit data: soubor zálohy je neplatný.',
    'backup.restore.granularNotSupported' => 'Objekty k obnovení lze vybrat pouze tehdy, pokud obnovujete ze zálohy vytvořené v prostředí Plesk 12.0 nebo novějším.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'V režimu zobrazení Power User (Zkušený uživatel) není podporováno obnovení všech dat ze záloh. Vybrat objekty k obnovení. Náhled rozhraní lze změnit v nabídce %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Předvolby rozhraní',
    'backup.restore.contentRestoreType' => 'Obnovit',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Pouze konfigurace vybraných objektů',
    'backup.restore.contentRestoreTypeFull' => 'Konfigurace a obsah vybraných objektů',
    'backup.restore.errorWrongFormat' => 'Zálohu nelze obnovit: soubor obsahuje chybné formátování.',
    'backup.restore.errorContentError' => 'Některá data nelze obnovit: Záloha obsahuje chyby obsahu.',
    'backup.restore.warningSignError' => 'Nelze ověřit podpis zálohy. Soubor zálohy může být upraven, poškozen, vytvořen na jiném serveru nebo v dřívější verzi Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Tuto zálohu může obnovit pouze správce prostředí Plesk.',
    'backup.restore.warningPartial' => "Následující části přírůstkové zálohy nebyly nalezeny:%%endl%%%%missedParts%%%%endl%%Všechny soubory nemusely být obnoveny. Odešlete chybějící části a zkuste obnovení znovu.",
    'backup.restore.warningDeprecatedBackupVersion' => 'Soubor zálohy, který se pokoušíte obnovit, byl vytvořen v nepodporované verzi Plesk a nelze jej obnovit. Použít rozšíření Plesk Migrator k převodu vašich dat ze staré verze prostředí Plesk.',
    'backup.restore.encryptionKeyError' => 'Hesla pro jeden či více účtů v této záloze nelze obnovit a budou vynulována. Tato záloha byla pravděpodobně vytvořena na jiném serveru Plesk a zašifrována jeho šifrovacím klíčem.',
    'backup.restore.errorCorruptedContent' => 'Následující soubory se nepodařilo najít, nebo byly poškozeny:',
    'backup.restore.statusSection' => 'Stav zálohování',
    'backup.restore.statusDetails' => 'Podrobnosti o stavu',
    'backup.restore.restoreBlocked' => 'Zálohu nelze obnovit.',
    'backup.restore.restoreBlockedDescription' => 'Zálohu typu %%backupType%% nelze nyní obnovit. Chcete-li ji obnovit, přihlaste se jako vlastník zálohy a ve správě zálohování klikněte na název této zálohy.',

    'backup.schedule.scheduleSection' => 'Rozvrh',
    'backup.schedule.backupEnable' => 'Aktivovat tuto úlohu zálohy',
    'backup.schedule.backupPeriod' => 'Spustit tuto úlohu zálohy',
    'backup.schedule.on' => 'den',
    'backup.schedule.at' => 'v',
    'backup.schedule.every' => 'každých',
    'backup.schedule.hours' => '{period, plural,one {# hodinu} other {# hodin}}',
    'backup.schedule.retainHours' => 'hodiny',
    'backup.schedule.useIncremental' => 'Použít přírůstkové zálohování',
    'backup.schedule.useIncrementalDisableHint' => 'Vybraný zálohovaný obsah umožňuje pouze vytvoření plné zálohy.',
    'backup.schedule.fullBackupPeriod' => 'Provést úplné zálohování',
    'backup.schedule.hourly' => 'Po hodinách',
    'backup.schedule.daily' => 'Denně',
    'backup.schedule.weekly' => 'Týdně',
    'backup.schedule.monthly' => 'Měsíčně',
    'backup.schedule.yearly' => 'Ročně',
    'backup.schedule.days' => 'dny',
    'backup.schedule.weeks' => 'týdny',
    'backup.schedule.months' => 'měsíce',
    'backup.schedule.years' => 'roky',
    'backup.schedule.backupTimeDescription' => 'Časová zóna: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Výchozí časové pásmo systému',
    'backup.schedule.first' => 'první',
    'backup.schedule.last' => 'poslední',
    'backup.schedule.dayOfMonth' => 'dnů',
    'backup.schedule.email' => 'Pokud se během této úlohy zálohování objeví chyby, odešlete upozornění e-mailem na',
    'backup.schedule.invalidFields' => 'Některá pole jsou prázdná nebo obsahují neplatnou hodnotu: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Maximální počet úplných záložních souborů, které lze uložit (včetně plánovaných i ručních záloh)',
    'backup.schedule.retainDumpFilesFor' => 'Zachovat plnou zálohu',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Pokud nechcete odebrat plné zálohy automaticky, ponechte toto pole prázdné.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Limit zadaný poskytovatelem hostingu pro úložiště serveru je %%max%%. Váš limit pro něj musí být nižší nebo roven %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'Poskytovatel hostingu stanovil pro úložiště na serveru limit {max, plural, one {# plné zálohy} few {# plných záloh} other {# plných záloh}} (včetně všech naplánovaných a manuálních záloh).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Ukládání naplánovaných záloh předplacené služby do vzdáleného úložiště prostředí Cloud je prémiovou funkcí, kterou lze zakoupit v online obchodě Plesk.',
    'backup.schedule.backupHourlyWarning' => 'Povolení zálohování po hodinách může způsobit zvýšenou spotřebu prostředků serveru.',
    'backup.schedule.titleHourly' => 'Nastavení zálohování po hodinách',
    'backup.schedule.titleDaily' => 'Nastavení každodenních záloh',
    'backup.schedule.titleWeekly' => 'Nastavení týdenních záloh',
    'backup.schedule.titleMonthly' => 'Nastavení měsíčních záloh',
    'backup.schedule.titleCustom' => 'Nastavení pro vlastní zálohování',

    'backup.secure-backup.hint' => 'K zašifrování uživatelských hesel v databázi platformy Plesk v záloze můžete použít heslo. Upozorňujeme, že obnovení heslem chráněné zálohy bez zadání hesla zapříčiní, že platforma Plesk vygeneruje uživatelská hesla náhodně.',
    'backup.secure-backup.hintAdmin' => 'Hesla k databázi Plesk obsažená v zálohách můžete zašifrovat pomocí klíče nebo hesla. Klíč je unikátní pro každou instalaci platformy Plesk. Zálohy zašifrované klíčem lze obnovit pouze v místě instalace platformy Plesk, kde byly vytvořeny, a nelze je obnovit v jiné instalaci platformy Plesk. Upozorňujeme, že platforma Plesk nechrání všechna citlivá data v záloze. Doporučujeme proto, abyste zálohy ukládali na vzdálené cloudové úložiště a povolili šifrování záloh na straně cloudového úložiště.',
    'backup.secure-backup.usePasswordProtection' => 'Použít ochranu heslem (doporučeno)',
    'backup.secure-backup.backupPasswordSource' => 'Typ hesla',
    'backup.secure-backup.pleskKey' => 'Šifrovací klíč Plesk',
    'backup.secure-backup.userPassword' => 'Zadané heslo',
    'backup.secure-backup.password' => 'Heslo',
    'backup.secure-backup.passwordConfirmation' => 'Zopakovat heslo',

    'backup.subform.settingsSection' => 'Nastavení zálohování',
    'backup.subform.prefix' => 'Přidat předponu k názvu zálohy',
    'backup.subform.comment' => 'Komentáře',
    'backup.subform.splitSize' => 'Vytvořit vícesvazkovou zálohu, velikost svazku (MB)',
    'backup.subform.repository' => 'Uložit do',
    'backup.subform.repositoryDescription' => 'Nastavení úložiště FTP(S) není zadáno. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Úložiště serveru i %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Vzdálené úložiště',
    'backup.subform.remoteRepository' => 'vzdálené úložiště',
    'backup.subform.remoteRepositoryText' => 'Vybrat vzdálené úložiště prostředí cloud',
    'backup.subform.configureRemoteRepositories' => 'Pro ukládání záloh do cloudu si <a href="%%url%%">nakonfigurujte vzdálené úložiště</a>.',
    'backup.subform.configureFtpRepository' => 'Pro ukládání záloh na vzdálené úložiště si <a href="%%url%%"> nastavte FTP úložiště</a>.',
    'backup.subform.configureRemoteDesc' => '%%link%% aby se zálohy ukládaly do cloudu.',
    'backup.subform.configureRemoteLink' => 'Nakonfigurujte vzdálené úložiště',
    'backup.subform.configureFtpDesc' => '%%link%% aby se zálohy ukládaly na vzdálené úložiště.',
    'backup.subform.configureFtpLink' => 'Nakonfigurovat FTP úložiště',
    'backup.subform.repositoryConfigure' => 'Konfigurovat',
    'backup.subform.email' => 'Až se zálohování dokončí, odešlete oznámení na',
    'backup.subform.contentSection' => 'Obsah zálohy',
    'backup.subform.domainConfiguration' => 'Konfigurace',
    'backup.subform.domainConfigurationVhost' => 'Uživatelské soubory a databáze',
    'backup.subform.domainConfigurationFile' => 'Soubory uživatelů',
    'backup.subform.domainConfigurationDatabase' => 'Databáze',
    'backup.subform.domainConfigurationMail' => 'E-mailové zprávy',
    'backup.subform.content' => 'Zálohovat',
    'backup.subform.backupAll' => 'Veškerá konfigurace a obsah',
    'backup.subform.backupConfiguration' => 'Pouze konfigurace',
    'backup.subform.backupVhost' => 'Veškerá konfigurace a obsah kromě e-mailových zpráv',
    'backup.subform.backupMailFile' => 'Veškerá konfigurace a obsah kromě databází uživatelů',
    'backup.subform.backupMailDatabase' => 'Veškerá konfigurace a obsah kromě souborů uživatelů',
    'backup.subform.backupMail' => 'Pouze konfigurace a e-mailové zprávy',
    'backup.subform.backupDatabase' => 'Jen konfigurace a databáze uživatelů',
    'backup.subform.backupFile' => 'Jen konfigurace a soubory uživatelů',
    'backup.subform.mssqlNativeBackup' => 'Pokud je to možné, použijte nativní funkci zálohování MS SQL',
    'backup.subform.mssqlNativeBackupAdmin' => 'Použijte nativní funkci zálohování MS SQL (u vzdálené databáze se ujistěte, že jste pod položkou Nástroje a nastavení> Databázové servery nakonfigurovali nastavení zálohování vzdáleného serveru MS SQL)',
    'backup.subform.localRepository' => 'Úložiště serveru',
    'backup.subform.localRepositoryPath' => 'Úložiště serveru na %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Úložiště FTP(S)  na %%uri%% <a href="%%link%%">Změnit nastavení</a>',
    'backup.subform.ftpRepositoryText' => 'Úložiště FTP(S)  na %%uri%%',
    'backup.subform.type' => 'Typ',
    'backup.subform.typeFullBackup' => 'Úplné',
    'backup.subform.typeIncremental' => 'Přírůstková',
    'backup.subform.typeIncrementalDescription' => 'Zálohovat data hostování webu a pošty, která se od poslední zálohy změnila (databáze se vždy zálohují v plném rozsahu).',
    'backup.subform.incrementalNotAvailable' => 'Chcete-li vytvořit přírůstkovou zálohu, nejprve vytvořte úplnou zálohu.',
    'backup.subform.excludeLogs' => 'Vyloučit soubory protokolu',
    'backup.subform.excludeFiles' => 'Vyjmout specifické soubory ze zálohy',
    'backup.subform.excludeFilesDescription' => 'Lze vyjmout pouze soubory v rámci webových prostorů. Zadejte cestu nebo cesty relativní ke kořenovému adresáři webu, jednotlivé soubory oddělte čárkami. Použití masky je povoleno (např. /somedir/log*).',

    'backup.upload.uploadHint' => 'Zde můžete nahrát soubory zálohy na úložiště Plesk. Maximální velikost souboru je omezena na dva gigabajty.',
    'backup.upload.backupFile' => 'Soubor zálohy',
    'backup.upload.removeLink' => 'Odebrat',
    'backup.upload.addFileLink' => 'Nahrát další soubory',
    'backup.upload.backupSecuritySettings' => 'Nastavení zabezpečení zálohy',
    'backup.upload.signatureHint' => 'U záložních souborů Plesk kontroluje platnou strukturu a podpis. Soubory, které jsou upraveny, poškozeny nebo vytvořeny na jiném serveru, jsou považovány za nedůvěryhodné. Níže uvedená možnost slouží k obnovení dat z těchto souborů. Tuto možnost vyberte, pouze pokud důvěřujete zdroji záloh, protože nahráním takového souboru může dojít k ohrožení zabezpečení nebo narušení provozu serveru. Poznámka: Záložní soubory vytvořené ve verzi Plesk starší než 11.5 jsou považovány za nedůvěryhodné, protože nejsou opatřeny podpisem. Nezapomeňte tyto soubory obnovit, pokud věříte jejich zdroji.',
    'backup.upload.ignoreSign' => 'Nahrát soubory zálohy bez platného podpisu',
    'backup.upload.passwordHint' => 'Pokud jste pro tuto zálohu použili ochranu heslem, zadejte heslo do níže uvedeného pole. Pamatujte si, že pokud zadáte nesprávné heslo, prostředí Plesk vás bude varovat, ale zálohu přesto nahraje na server. Během obnovení zálohy budete znovu vyzvání k zadání hesla.',
    'backup.upload.alreadyExistsWarning' => 'Soubor zálohy %%fileName%% již existuje na místním úložišti serveru.',
    'backup.upload.incorrectPasswordWarning' => 'Zadané heslo je nesprávné. Během obnovení zálohy vás Plesk znovu vyzve k zadání hesla.',
    'backup.upload.deprecatedDumpError' => 'Soubor zálohy, který se pokoušíte nahrát, byl vytvořen v nepodporované verzi Plesk a nelze jej importovat. Použít rozšíření Plesk Migrator k převodu vašich dat ze staré verze prostředí Plesk.',
    'backup.upload.mailFormatWarning' => 'Soubor zálohy %%fileName%% byl nahrán na úložiště. Důležité upozornění: soubor zálohy %%fileName%% obsahuje e-mailový obsah, který nebude obnoven, protože jeho formát (Plesk 8.3 - 8.6) není podporován. Chcete-li obnovit tento obsah e-mailu, zálohujte ho prostřednictvím nástroje Plesk Backup, vyberte možnost Zálohovat obsah poštovní schránky a vyberte možnost s výpisem obnoveným pro jakýkoli e-mailový server.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Nahraný soubor zálohy (%%fileName%%) byl upraven, poškozen, vytvořen na jiném serveru nebo ve starší verzi Plesk, která nepodporuje podepisování záloh. Před obnovením dat z tohoto souboru zálohy se ujistěte, že můžete zdroji tohoto souboru důvěřovat.',
    'backup.upload.corruptedSignatureAdminError' => 'Nelze nahrát soubor zálohy (%%fileName%%). Soubor byl upraven, poškozen, vytvořen na jiném serveru nebo ve starší verzi Plesk, která nepodporuje podepisování záloh. Pokud této záloze důvěřujete, vyberte možnost "Nahrát soubory zálohy bez platných podpisů" a nahrávání zopakujte.',
    'backup.upload.corruptedSignatureUserWarning' => 'Nahraný soubor zálohy (%%fileName%%) obsahuje upravená nebo poškozená data nebo byl vytvořen na jiném serveru nebo ve starší verzi Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Nelze nahrát soubor zálohy (%%fileName%%). Soubor obsahuje upravená nebo poškozená data nebo byl vytvořen na jiném serveru nebo ve starší verzi Plesk. Chcete-li obnovit data z tohoto souboru, kontaktujte svého poskytovatele hostitelských služeb.',
    'backup.upload.uploadError' => 'Na úložiště serveru nelze nahrát %%fileName%%: %%error%%',
    'backup.upload.fileNotSelected' => 'K nahrání nebyly vybrány žádné soubory. Vybrat alespoň jeden soubor.',
    'backup.upload.missedPartsWarning' => "Následující části přírůstkové zálohy nebyly odeslány:%%endl%%%%missedParts%%%%endl%%Odešlete chybějící části.",
    'backup.upload.unknownType' => 'Neznámý typ objektu',
    'backup.upload.storageLink' => 'jiné úložiště',
    'backup.upload.anotherStorage' => 'Výpis byl nahrán na %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Prodejce %%name%% nebyl nalezen. Nejprve ho vytvořte, aby bylo možno obnovit nahraný výpis.',
    'backup.upload.clientNotFound' => 'Zákazník %%name%% nebyl nalezen. Nejprve ho vytvořte, aby bylo možno obnovit nahraný výpis.',
    'backup.upload.domainNotFound' => 'Doména %%name%% nebyla nalezena. Nejprve ho vytvořte, aby bylo možno obnovit nahraný výpis.',

    'backup.web-content-dynamic.addButtonTitle' => 'Přidat soubory',
    'backup.web-content-dynamic.noItems' => 'Nejsou vybrány žádné soubory',
    'backup.web-content-dynamic.hint' => 'K výběru souborů a složek použijte zaškrtávací políčka.',
    'backup.web-content-dynamic.title' => 'Výběr souborů',
    'backup.web-content-dynamic.columnName' => 'Jméno',
    'backup.web-content-dynamic.columnChangeDate' => 'Změněno',
    'backup.web-content-dynamic.columnSize' => 'Velikost',
    'backup.web-content-dynamic.columnPermissions' => 'Oprávnění',
    'backup.web-content-dynamic.columnUser' => 'Uživatel',
    'backup.web-content-dynamic.columnGroup' => 'Skupina',
    'backup.web-content-dynamic.waitButtonTitle' => 'Čekejte prosím',
    'backup.web-content-dynamic.loadingTitle' => 'Čekejte prosím. Načítání...',

    'backup.invalidFields' => 'Některá pole jsou prázdná nebo obsahují neplatnou hodnotu.',
    'backup.notEnoughDiskSpace' => 'K vytvoření zálohy není dostatek místa v umístění %%path%%. Je vyžadováno nejméně %%required%% GB volného místa (k dispozici je %%available%% GB)',

    'change-subscriptions-owner.ownerSection' => 'Nový vlastník',
    'change-subscriptions-owner.subscriptionsSection' => 'Vybraná předplatná',
    'change-subscriptions-owner.owner' => 'Vlastník',
    'change-subscriptions-owner.subscriptionName' => 'Předplacená služba',
    'change-subscriptions-owner.ownerName' => 'Vlastník',
    'change-subscriptions-owner.currentIpAddress' => 'Aktuální IP adresa',
    'change-subscriptions-owner.newIpAddress' => 'Nová IP adresa',
    'change-subscriptions-owner.noIpAddress' => 'No available IP addresses',
    'change-subscriptions-owner.submit' => 'Znovu přiřadit',
    'change-subscriptions-owner.warningCustom' => "Předplatné bude odhlášeno ze současného plánu služeb a přejde do stavu „Vlastní“.",
    'change-subscriptions-owner.warningEmptyPool' => "The IP pool of the new owner's provider is empty. Make sure that the provider has at least one IP address in the pool.",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, Procesor, I/O disku',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Nastavit limity spotřeby systémových prostředků podle předplacené služby. Prostředí Plesk využívá funkci jádra Linux s názvem skupiny ovládacích prvků (cgroups), aby bylo zajištěno, že nedojde k překročení limitů.',
    'cgroups-settings.cpuSettings' => 'Procesor (CPU)',
    'cgroups-settings.cpuSettingsDescription' => 'Limit individuálních předplacených služeb vzhledem k zadané úrovni využití procesoru.',
    'cgroups-settings.cpuPeriodLimit' => 'Období kontroly využití procesoru',
    'cgroups-settings.percentUsageDescription' => 'Celkové množství času procesoru se rovná %%total%%%%units%% pro váš server',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Limit individuálního předplatného vzhledem k zadané úrovni využití paměti RAM. Pamatujte si, že pokud předplacená služba překročí tento limit, nejnáročnější proces se zastaví.',
    'cgroups-settings.ramPeriodLimit' => 'Období kontroly využití RAM',
    'cgroups-settings.diskSettings' => 'I/O disku',
    'cgroups-settings.diskReadSettings' => 'Čtení z disku',
    'cgroups-settings.diskReadSettingsDescription' => 'Povolit individuálním odběratelům použití šířky pásma čtení z disku pouze v zadaném limitu.',
    'cgroups-settings.diskReadPeriodLimit' => 'Období kontroly využití čtení z disku',
    'cgroups-settings.diskWriteSettings' => 'Zápis na disk',
    'cgroups-settings.diskWriteSettingsDescription' => 'Povolit individuálním odběratelům použití šířky pásma zápisu na disk pouze v zadaném limitu.',
    'cgroups-settings.diskWritePeriodLimit' => 'Období kontroly využití zápisu na disk',
    'cgroups-settings.limit' => 'Limit',
    'cgroups-settings.threshold' => 'Oznámit při překročení',
    'cgroups-settings.limitNotificationEnabled' => 'Oznámení zapnuto',
    'cgroups-settings.periodFiveMinutes' => '5 minut',
    'cgroups-settings.periodHour' => '1 hodina',
    'cgroups-settings.periodDay' => '1 den (24 hodin)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/s',

    'custom-button.privateLabel' => 'Zobrazit pouze pro mě',
    'custom-button.textLabel' => 'Popisek tlačítka',
    'custom-button.tooltipLabel' => 'Text popisu',
    'custom-button.iconLabel' => 'Obrázek na pozadí',
    'custom-button.priorityLabel' => 'Priorita',
    'custom-button.urlLabel' => 'Adresa URL',
    'custom-button.urlParamsLabel' => 'Přidat parametry do adresy URL',
    'custom-button.placeLabel' => 'Umístění',
    'custom-button.internalLabel' => 'Otevřít adresu URL v prostředí Plesk',
    'custom-button.internalDescription' => 'Určete, zda chcete otevřít adresu URL na stránce Plesk nebo v novém okně prohlížeče.',
    'custom-button.noFrameLabel' => 'Nepoužívat rámečky',
    'custom-button.noFrameDescription' => 'Pokud přidáte uživatelské tlačítko, které vede na rozšíření Plesk nebo na aplikaci na panelu zákazníka, můžete specifikovat, jak se má toto rozšíření/aplikace zobrazovat: v rámečku nebo jako součást grafického rozhraní (GUI) Plesk.',
    'custom-button.urlParamLabel_dom_id' => 'Zahrnout ID předplatného, ID domény a ID aliasu domény',
    'custom-button.urlParamLabel_dom_name' => 'Zahrnout primární název domény',
    'custom-button.urlParamLabel_ftp_user' => 'Zahrnout přihlašovací jméno FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Zahrnout heslo FTP',
    'custom-button.urlParamLabel_cl_id' => 'Zahrnout ID zákazníka',
    'custom-button.urlParamLabel_cname' => 'Zahrnout název společnosti zákazníka',
    'custom-button.urlParamLabel_pname' => 'Zahrnout název kontaktu zákazníka',
    'custom-button.urlParamLabel_email' => 'Zahrnout e-mail zákazníka',
    'custom-button.buttonPlace_navigation' => 'Obecný přístup',
    'custom-button.buttonPlace_admin' => 'Domovská stránka správce',
    'custom-button.buttonPlace_admin-settings' => 'Stránka Nástroje a nastavení správce',
    'custom-button.buttonPlace_reseller' => "Domovská stránka prodejce",
    'custom-button.buttonPlace_reseller-settings' => 'Stránka Nástroje a pomůcky prodejce',
    'custom-button.buttonPlace_client' => 'Domovská stránka zákazníka',
    'custom-button.buttonPlace_domain' => "Stránka Weby a domény předplacené služby",
    'custom-button.buttonPlace_domain_powerUser' => "Stránka Weby a domény webového prostoru",
    'custom-button.buttonPlace_domain-properties' => 'Nástroje webu',

    'database-server-change-password.adminPassword' => 'Heslo správce',
    'database-server-change-password.success' => 'Heslo správce bylo úspěšně aktualizováno.',

    'database-server-create.general' => 'Obecné',
    'database-server-create.type' => 'Typ databázového serveru',
    'database-server-create.unixSocket' => '(místní připojení)',
    'database-server-create.host' => 'Název hostitele nebo IP adresa',
    'database-server-create.port' => 'Číslo portu',
    'database-server-create.portDescription' => 'Ponechat prázdné pro výchozí číslo portu',
    'database-server-create.version' => 'Verze databázového serveru',
    'database-server-create.default' => 'Použít tento server jako výchozí pro %%type%%',
    'database-server-create.externalConnections' => 'Povolit místní server MariaDB/MySQL pro přijetí externího připojení',
    'database-server-create.externalConnectionsDescription' => 'Změna tohoto nastavení způsobí restart místního serveru MariaDB/MySQL. Chcete-li povolit vzdálený přístup k dalším serverům MariaDB/MySQL registrovaným v prostředí Plesk, změňte jejich konfiguraci ručně.',
    'database-server-create.authentication' => 'Ověřování',
    'database-server-create.authenticationAddDescription' => 'Zadejte pověření správce databáze, která Plesk použije k přístupu na databázový server. Účet správce s těmito pověřeními musí být přítomen na databázovém serveru.',
    'database-server-create.authenticationEditDescription' => 'Zde lze změnit pověření, která Plesk použije k přístupu na databázový server. Tato pověření musí odpovídat pověřením správce databáze. Například pokud jste změnili pověření správce na databázovém serveru, musíte je změnit rovněž v prostředí Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Zde lze změnit pověření, která Plesk použije k přístupu na databázový server. Pokud změníte přihlašovací jméno nebo heslo, účet uživatele databáze s oprávněním správce bude aktualizován na databázovém serveru i v prostředí Plesk.',
    'database-server-create.adminLogin' => 'Uživatelské jméno',
    'database-server-create.adminPassword' => 'Heslo',
    'database-server-create.createSuccess' => 'Databázový server byl úspěšně vytvořen.',
    'database-server-create.createError' => 'Databázový server byl vytvořen s chybou: %%error%%',
    'database-server-create.updateSuccess' => 'Databázový server byl úspěšně aktualizován.',
    'database-server-create.updateError' => 'Databázový server byl aktualizován s chybou: %%error%%.',
    'database-server-create.backupSettings' => 'Záloha',
    'database-server-create.backupTempDir' => 'Dočasná složka',
    'database-server-create.backupTempDirDescription' => 'Cesta k fyzické složce na vzdáleném serveru, kde je umístěn server MS SQL. Server MS SQL musí mít přístup k této složce ke čtení a zápis dočasných záložních souborů. Například C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Dočasný síťový adresář',
    'database-server-create.backupNetworkTempDirDescription' => 'Cesta ke sdílení sítě namapována na výše zadanou fyzickou složku. Plesk bude přistupovat ke sdílené složce kvůli stahování a nahrávání souborů zálohy. Například \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => 'Uživatelské jméno',
    'database-server-create.backupNetworkUserDescription' => 'Uživatelské jméno uživatele sítě vytvořené na vzdáleném serveru. Například ServerName\\UserName. Uživatel musí mít přístup do výše zadané sdílené složky.',
    'database-server-create.backupNetworkPassword' => 'Heslo',

    'domain.connection-info.title' => 'Informace o připojení',
    'domain.connection-info.systemUserCredentials' => 'Pověření uživatele systému',
    'domain.connection-info.systemUserCredentialsHint' => 'Přístup prostřednictvím FTP je vždy povolen. Přístup prostřednictvím SSH nebo vzdálené plochy je pouze v případě, že %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'je uděleno oprávnění',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Váš přístup prostřednictvím SSH nebo vzdálené plochy je povolen a nemůžete spravovat jeho stav.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Váš přístup prostřednictvím SSH nebo vzdálené plochy je zakázán a nemůžete spravovat jeho stav.',
    'domain.connection-info.ipAddress' => 'IP adresa',
    'domain.connection-info.username' => 'Uživatelské jméno',
    'domain.connection-info.password' => 'Heslo',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Změna hesla uživatele systému',
    'domain.connection-info.changePasswordTooltip' => 'Změnit heslo',
    'domain.connection-info.newPassword' => 'Nové heslo',
    'domain.connection-info.manageAccess' => 'Spravovat přístup',
    'domain.connection-info.additionalFtpAccounts' => 'Další účty FTP',
    'domain.connection-info.database' => 'Databáze',
    'domain.connection-info.databaseHint' => '1 z %%number%% databází patřících k předplatnému.',
    'domain.connection-info.databaseNotCreatedHint' => 'Databáze není vytvořena.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'Server MS SQL',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Hostitel',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Název databáze',
    'domain.connection-info.addDatabase' => 'Přidat databázi',
    'domain.connection-info.manageDatabases' => 'Spravovat databáze',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Změna hesla uživatele databáze',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Až zde změníte heslo, nezapomeňte si jej aktualizovat konfiguračních souborech své aplikace.',
    'domain.connection-info.buttonSave' => 'Uložit',
    'domain.connection-info.buttonSaving' => 'Ukládání...',
    'domain.connection-info.buttonCancel' => 'Zrušit',

    'domain.move.title' => 'Přesunout doménu %%name%%',
    'domain.move.hint' => 'Doména se přesune na novou předplacenou službu se svým obsahem, konfiguračními soubory, soubory protokolů a aplikacemi APS.',
    'domain.move.hintMain' => 'Doména se přesune na novou předplacenou službu se svým obsahem, konfiguračními soubory, soubory protokolů, databázemi, uživateli databází, dalšími uživateli FTP, naplánovanými úlohami, uživateli smb a aplikacemi APS.',
    'domain.move.hintSubdomains' => 'Subdoména(y) %%subdomains%% bude přesunuta společně s nadřazenou doménou.',
    'domain.move.hintAliases' => 'Alias(y) domény %%aliases%% bude přesunut společně s nadřazenou doménou.',
    'domain.move.hintSubdomainsAndAliases' => 'Subdoména(y) %%subdomains%% a alias(y) domény %%aliases%% budou přesunuty společně s nadřazenou doménou.',
    'domain.move.labelDatabases' => 'Až přesunete doménu, otevřete záložku "Databáze" a přesuňte přidružené databáze.',
    'domain.move.hintDatabases' => 'V případě potřeby přesuňte databáze samostatně.',

    'domain.move.Form.submitButton' => 'Přesunout',
    'domain.move.Form.cancelButton' => 'Zrušit',

    'domain.move.selectTarget' => 'Dostupné předplatné',
    'domain.move.nothingFound' => 'Nic nebylo nalezeno',
    'domain.move.targetIsRequred' => 'Vybrat předplatné, na které se přesune doména.',
    'domain.move.selectNewSubscription' => 'Vytvořit nové předplatné',
    'domain.move.ipv4Address' => 'Adresa IPv4',
    'domain.move.ipv4AddressHint' => 'IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.',
    'domain.move.ipv6Address' => 'Adresa IPv6',
    'domain.move.ipv6AddressHint' => 'IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.',
    'domain.move.ipAddressIsNotSelected' => 'Je nutno vybrat alespoň jednu IP adresu.',
    'domain.move.username' => 'Uživatelské jméno',
    'domain.move.usernameHint' => 'Účet uživatele systému přidružený k webovému prostoru. Použito k přístupu k hostovaným souborům prostřednictvím FTP a SSH.',
    'domain.move.usernameIsRequred' => 'Musíte zadat jméno uživatele.',
    'domain.move.password' => 'Heslo',
    'domain.move.passwordIsRequred' => 'Musíte zadat heslo.',
    'domain.move.noAvailableSubscriptions' => 'Žádné dostupné předplatné',
    'domain.move.noWebHosting' => 'Momentálně nebude vytvořen žádný systémový uživatel, protože doména nemá žádný webhosting.',

    'domain.rename.title' => 'Změnit doménový název',
    'domain.rename.titleAlias' => 'Změnit název doménového aliasu',
    'domain.rename.hint' => 'Nyní měníte doménový název %%domainName%%',
    'domain.rename.hintAlias' => 'Nyní měníte doménový alias %%domainName%%',
    'domain.rename.name' => 'Nový název domény',
    'domain.rename.nameAlias' => 'Nový název doménového aliasu',
    'domain.rename.domainNameIsRequired' => 'Toto povinné pole je prázdné. Musíte zadat hodnotu.',
    'domain.rename.submitButton' => 'Změnit',
    'domain.rename.submitButtonProgress' => 'Změna',
    'domain.rename.successMessage' => 'Doménový název %%oldName%% byl změněn na %%newName%%.',
    'domain.rename.successMessageAlias' => 'Název doménového aliasu %%oldName%% byl změněn na %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Zrušit',

    'domain.outgoing-messages.hint' => 'Zde můžete změnit limit počtu odchozích zpráv pro tuto doménu. Odeslat větší počet zpráv, než je zadaný limit, nebude možné.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'Výchozí (%%domainOutgoingMessages%% zpráv za hodinu)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'zpráv za hodinu',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Limit odchozích zpráv',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Vlastní hodnota pro tuto doménu',

    'domain.tech-domain-name.title' => 'Vybrat doménový název',
    'domain.tech-domain-name.techDomainTitle' => 'Dočasný doménový název',
    'domain.tech-domain-name.customDomainTitle' => 'Registrovaný doménový název',
    'domain.tech-domain-name.techDomainText' => 'Zatím nemám registrován žádný doménový název',
    'domain.tech-domain-name.customDomainText' => 'Registrovaný doménový název už mám',
    'domain.tech-domain-name.techDomain' => 'Váš dočasný doménový název',
    'domain.tech-domain-name.customDomain' => 'Registrovaný doménový název',
    'domain.tech-domain-name.domainName' => 'Název domény',
    'domain.tech-domain-name.techDomainDesc' => 'Dočasné doménové názvy slouží k přistupování na web než zaregistrujete a zakoupíte řádný název domény. Jsou poskytovány zdarma při dodržení následujících podmínek:',
    'domain.tech-domain-name.techDomainRandom' => 'Názvy se generují náhodně',
    'domain.tech-domain-name.techDomainDns' => 'Názvy jsou hostovány v zóně DNS .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Na registrovaný doménový název můžete přejít kdykoli později přejmenováním domény v nastavení domény.',
    'domain.tech-domain-name.error' => 'Došlo k neočekávané chybě.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Musíte vybrat IP adresu.',
    'domain.tech-domain-name.generating' => 'Generuje se...',

    'get-password.label' => 'Resetovat heslo',
    'get-password.text' => 'Zadejte svou e-mailovou adresu nebo uživatelské jméno registrované pro prostředí Plesk a zašleme vám zprávu o resetování hesla.',
    'get-password.emailLabel' => 'E-mailová adresa',
    'get-password.loginLabel' => 'Uživatelské jméno',
    'get-password.send' => 'Odeslat',
    'get-password.cancel' => 'Zrušit',
    'get-password.errorInvalidEmail' => 'E-mailová adresa nebyla rozpoznána. Znovu jej zkontrolujte a zkuste to znovu.',
    'get-password.messageSend' => "E-mail pro obnovení hesla byl zaslán na příslušnou e-mailovou adresu.\nPokud e-mail nedorazí, obraťte se na svého správce platformy Plesk.",

    'iis-settings.formGeneralHint' => 'Zde můžete zadat nastavení webového serveru IIS pro váš web změnou výchozích hodnot. Vlastní konfigurace IIS je užitečná například tehdy, když chcete použít na svém webu nový typ indexových souborů nebo přiřadit určitý typ MIME k určitým příponám názvu souborů. Výchozí hodnoty jsou definovány vaším poskytovatelem hostingu.',
    'iis-settings.formGeneralHint_powerUser' => 'Zde můžete zadat nastavení webového serveru IIS pro tento web. Vlastní konfigurace IIS je užitečná například tehdy, když chcete použít na svém webu nový typ indexových souborů nebo přiřadit určitý typ MIME k určitým příponám názvu souborů. Výchozí hodnoty znamenají, že IIS použije odpovídající direktivy ze své výchozí konfigurace.',
    'iis-settings.virtualDirectoryLoadError' => 'Nelze získat vlastnosti zadaného virtuálního adresáře: %%errorMessage%%',
    'iis-settings.general' => 'Běžná nastavení',
    'iis-settings.example' => "Například: %%example%%",
    'iis-settings.settingOn' => 'Zapnout',
    'iis-settings.settingOff' => 'Vypnuto (výchozí)',
    'iis-settings.settingDefault' => 'Výchozí',
    'iis-settings.settingCustom' => 'Zadejte vlastní hodnotu',
    'iis-settings.mimeTypes' => 'Typy MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Typy MIME přidružují přípony souborů k typům souborů. Obvykle se toto používá k vytvoření vlastní přípony souborů pro běžné typy souborů.',
    'iis-settings.documents' => 'Výchozí dokumenty',
    'iis-settings.documentsOff' => 'Zakázáno',
    'iis-settings.documentsCustom' => 'Zadat hodnoty',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Když prohlížeče neposkytnou název dokumentu na vašem webu, IIS vyhledá zadané výchozí dokumenty a nabídne první, který nalezne. Pokud nezadáte výchozí dokumenty, ale zapnete Procházení adresářů, pak se výpis adresáře zobrazí v prohlížeči namísto na stránce indexu.',
    'iis-settings.expires' => 'Vyprší',
    'iis-settings.expiresFullDescription' => 'Webový server přidá na webové stránky záhlaví "Vyprší". Časové razítko vypršení se získá přidáním výše specifikovaného časového intervalu k času, při němž je webová stránka vyžadována.',
    'iis-settings.expiresUnitDays' => 'dny',
    'iis-settings.expiresUnitHours' => 'hodiny',
    'iis-settings.expiresUnitMinutes' => 'minuty',
    'iis-settings.expiresUnitSeconds' => 'sekundy',
    'iis-settings.headers' => 'Další záhlaví',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Webový server přidá zadaná záhlaví odpovědi HTTP.',
    'iis-settings.directoryBrowsing' => 'Procházení adresářů',
    'iis-settings.directoryBrowsingDescription' => 'Umožní uživatelům prohlížet výpis adresářů v prohlížeči, například když není dostupná výchozí stránka indexu.',
    'iis-settings.securityTabDirectory' => 'Nastavení zabezpečení adresáře',
    'iis-settings.allowAnonymous' => 'Anonymní ověřování',
    'iis-settings.allowAnonymousDescription' => 'Anonymní ověřování umožňuje uživatelům získat přístup k veřejnému obsahu vašeho webu. Obsah vašeho webu chráněný heslem a obsah chráněný na úrovni souborového systému nebude k dispozici anonymním uživatelům.',
    'iis-settings.allowWindows' => 'Ověřování systému Windows',
    'iis-settings.allowWindowsDescription' => 'Ověřování systému Windows (dříve s názvem NTLM) chrání obsah vašeho webu na úrovni systému souborů.',
    'iis-settings.requireSsl' => 'Požadovat protokol SSL/TLS',
    'iis-settings.requireSslDescription' => 'Pokud jste zapnuli podporu SSL/TLS pro váš web, toto možnost donutí webové klienty (prohlížeče), aby použili pouze zabezpečené připojení HTTPS.',
    'iis-settings.securityTabIpDeny' => 'Nastavení omezení přístupu',
    'iis-settings.deny' => 'Odepřít přístup na web',
    'iis-settings.denyOff' => 'Výchozí',
    'iis-settings.denyCustom' => 'Zadejte vlastní hodnotu',
    'iis-settings.allow' => 'Kromě',
    'iis-settings.denyExample' => "10.1.0.0/16 192.168.1.110 Zadaní hostitelé a sítě mají zakázán přístup na web. Chcete-li všechna spojení odmítnout, použijte '*'.",
    'iis-settings.allowExample' => "192.168.0.0/16 10.1.1.21 Zadaní hostitelé a sítě mají povolen přístup na web.",
    'iis-settings.dynamicIpSecurity' => 'Ochrana před útoky DoS prostřednictvím IIS omezení dynamických IP adres',
    'iis-settings.isDenyByConcurrentRequests' => 'Odmítnout IP adresy založené na počtu souběžných žádostí z jedinečné IP adresy',
    'iis-settings.maxConcurrentRequests' => 'Maximální počet souběžných žádostí',
    'iis-settings.isDenyByRequestRate' => 'Odmítnout IP adresy založené na počtu žádostí v časovém intervalu',
    'iis-settings.maxRequests' => 'Maximální počet žádostí',
    'iis-settings.requestInterval' => 'Časové období (v milisekundách)',

    'ip-addresses-selector.ipAddress' => 'IP adresa',
    'ip-addresses-selector.ipv4Address' => 'Adresa IPv4',
    'ip-addresses-selector.ipv4AddressHint' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.",
    'ip-addresses-selector.ipv6Address' => 'Adresa IPv6',
    'ip-addresses-selector.ipv6AddressHint' => "IP adresa, na níž je web hostován, je síťovou adresou virtuálního hostitele webu.",
    'ip-addresses-selector.noIpAddressHint' => 'Žádné',
    'ip-addresses-selector.shared' => 'Sdílený',
    'ip-addresses-selector.exclusive' => 'vyhrazený',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'Server FTP nepodporuje adresy IPv6. Přidělte alespoň jednu adresu IPv4, jinak uživatel nebude moci nahrát soubory na server prostřednictvím FTP.',

    'license-key-revert.description' => 'Licenční klíč s následujícími vlastnostmi bude obnoven:',
    'license-key-revert.submitButton' => 'Vrátit změny',

    'license-key-upload.description' => 'Nainstalujte svůj licenční klíč zadáním aktivačního kódu.',
    'license-key-upload.descriptionWithFileUpload' => 'Nainstalujte svůj licenční klíč zadáním aktivačního kódu nebo nahráním souboru s licenčním klíčem.',
    'license-key-upload.type' => 'Vyberte jednu z následujících položek:',
    'license-key-upload.code' => 'Zadat aktivační kód',
    'license-key-upload.codeDescription' => 'Vložte přijatý aktivační kód.',
    'license-key-upload.file' => 'Nahrát soubor s licenčním klíčem',
    'license-key-upload.fileDescription' => 'Zadejte cestu k souboru, který obsahuje licenční klíč.',
    'license-key-upload.submitButton' => 'Instalovat',

    'log-rotation.customLogsDescription' => 'Pamatujte si, že vaše vlastní protokoly nejsou otočeny.',
    'log-rotation.logRotation' => 'Rotace souborů protokolu',
    'log-rotation.logRotationCondition' => 'Podmínka rotace souboru protokolu',
    'log-rotation.logRotationBySize' => 'Podle velikosti',
    'log-rotation.logRotationByTime' => 'Podle času',
    'log-rotation.logRotationDaily' => 'Denně',
    'log-rotation.logRotationWeekly' => 'Týdně',
    'log-rotation.logRotationMonthly' => 'Měsíčně',
    'log-rotation.logRotationSizeDescription' => 'Hodnota musí být v rozmezí %%min%% a %%max%% kB.',
    'log-rotation.maximumNumberOfFiles' => 'Maximální počet souborů protokolu',
    'log-rotation.compress' => 'Komprimovat soubory protokolu',
    'log-rotation.sendLogToEmail' => 'Až Plesk obnoví data ze souborů protokolu webových a FTP serverů, zašlete soubory protokolu e-mailem na tuto adresu',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => 'Interval nemůže být delší než limit %%max%% pro celý server.',

    'login.loginLabel' => 'Uživatelské jméno',
    'login.passwdLabel' => 'Heslo',
    'login.localeLabel' => 'Jazyk rozhraní',
    'login.defaultLocale' => 'Výchozí',
    'login.loginButtonLabel' => 'Přihlásit se',
    'login.enterUsername' => 'Zadejte své uživatelské jméno.',
    'login.enterPassword' => 'Zadejte své heslo.',
    'login.whatUsernamePassword' => 'Jaké uživatelské jméno a heslo použít?',
    'login.forgotPasswordLabel' => 'Zapomněli jste heslo?',
    'login.cookies' => 'Zásady pro soubory cookie na platformě Plesk',
    'login.avoidSSLWarningsMsg' => 'Abyste se vyhnuli varováním SSL během přihlašování do platformy Plesk, použijte %%link%%',
    'login.digitalOceanMsg' => 'Používáte Plesk na DigitalOcean poprvé? K přihlášení použijte uživatelské jméno „root“ a heslo zadané při vytváření tohoto dropletu. %%link%%',
    'login.amazonLightsailMsg' => 'Používáte platformu Plesk na Lightsailu poprvé? Abyste se přihlásili, přistupte k serveru pomocí SSH a použijte příkaz „plesk login“. %%link%%',
    'login.readGuide' => 'Přečtěte si kompletní příručku.',
    'login.mobileApplicationMessage' => 'Kvůli lepším výsledkům vám doporučujeme nainstalovat aplikaci %%name%%.',
    'login.mobileApplicationInstall' => 'Nainstalovat',
    'login.mobileApplicationHide' => 'Storno',

    'force-reset-password.saveButton' => 'Uložit',
    'force-reset-password.title' => 'Změnit heslo',
    'force-reset-password.passwordLabel' => 'Nové heslo',

    'panel-access.title' => 'Úprava adresy URL Plesk',
    'panel-access.hint' => 'Vyberte přizpůsobenou adresu URL pro přihlašování do Plesk. Tím nepřijdete o možnost přihlašovat se do Plesk prostřednictvím portu %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Více podrobností',
    'panel-access.proxyEnabled' => 'Všechny domény a subdomény, které se převádí na IP adresu serveru, ale nepoužívají se k hostingu',
    'panel-access.proxyDomain' => 'Zadaná doména nebo subdoména se převádí na IP adresu serveru, ale nepoužívá se k hostingu',
    'panel-access.proxyDisabled' => 'Žádné přizpůsobené adresy URL. Pouze https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Uložit',
    'panel-access.Form.cancelButton' => 'Zrušit',

    'panel-access.domainNameIsRequired' => 'Musíte zadat název domény.',
    'panel-access.successMessage' => 'Byl použit vybraný způsob přihlašování.',
    'panel-access.notSupported' => 'Váš Plesk nepodporuje vybraný způsob přihlašování.',
    'panel-access.notViaDomainName' => 'Abyste použili tento způsob přihlašování, zvolte první možnost („Všechny domény a subdomény...“), přihlaste se do Plesk přes https://%%domainName%% a pak vyberte druhou možnost.',
    'panel-access.notViaPort' => 'Abyste použili tento způsob přihlašování, nejdříve se přihlaste do Plesk přes https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Nastavení výkonu a zabezpečení',
    'php-settings.settings' => 'Běžná nastavení',
    'php-settings.fastCgiSettings' => 'Nastavení FastCGI',
    'php-settings.fpmSettings' => 'Nastavení PHP-FPM',
    'php-settings.enableFastcgi' => 'Povolit nastavení FastCGI',
    'php-settings.plainTextEditing' => 'Další direktivy',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Můžete stanovit jakékoli parametry PHP zadáním do níže uvedeného pole. Tyto direktivy se zahrnou do konfigurace PHP. Použijte stejný syntax jako byste použili pro php.ini. Chcete-li například automaticky nahrát rozšíření mSQL, přidejte řádek: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Pokud nelze nalézt konkrétní parametry PHP, přidejte je do níže uvedeného pole. Tyto další direktivy se sloučí s direktivami hlavního plánu služeb. Použijte stejný syntax jako používáte pro php.ini. Pokud chcete například automaticky nahrát rozšíření mSQL, přidejte řádek: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Můžete stanovit jakékoli parametry PHP zadáním do níže uvedeného pole. Tyto direktivy se zahrnou do konfigurace PHP. Použijte stejný syntax jako byste použili pro php.ini. Chcete-li například automaticky nahrát rozšíření mSQL, přidejte řádek: extension=msql.so. Chcete-li upravit nastavení fondu PHP-FPM, přidejte oddělovač [php-fpm-pool-settings] a zadejte požadované nastavení níže.',
    'php-settings.additionalConfigurationDirectives' => 'Další direktivy týkající se konfigurace:',
    'php-settings.defaultValue' => 'Výchozí',
    'php-settings.predefinedValue' => 'Vybrat hodnotu',
    'php-settings.customValue' => 'Zadejte vlastní hodnotu',
    'php-settings.phpSettingDescription_memory_limit' => 'Maximální velikost paměti v bajtech, které má skript povoleno alokovat.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Maximální doba v sekundách povolená pro spuštění skriptu než bude zrušen.',
    'php-settings.phpSettingDescription_max_input_time' => 'Maximální doba v sekundách povolená k analýze vstupních dat.',
    'php-settings.phpSettingDescription_post_max_size' => 'Maximum velikost dat v bajtech, které lze odeslat prostřednictvím metody POST. Obvykle musí být větší než hodnota upload_max_filesize a menší než hodnota memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Maximum velikost nahraného souboru v bajtech.',
    'php-settings.phpSettingDescription_safe_mode' => 'Nouzový režim PHP stanovil na spuštění skriptů řadu omezení, především z bezpečnostních důvodů.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'K souborům v zadaném adresáři lze získat přístup pomocí skriptů PHP, pokud platí direktiva safe_mode. Adresář musí být také v include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Programy v zadaném adresáři lze spouštět pomocí skriptů PHP, pokud platí direktiva safe_mode.',
    'php-settings.phpSettingDescription_include_path' => 'Seznam adresářů, v nichž skripty vyhledávají soubory (podobné systémové proměnné PATH). Chcete-li adresáře oddělit, v systému Linux použijte dvojtečku (:), v systému Windows středník (;).',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Adresář pro ukládání souborů relace PHP.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Další parametry pro funkci ().',
    'php-settings.phpSettingDescription_register_globals' => 'Registrovat obsah proměnných EGPCS (Prostředí, GET, POST, Cookie, Server) jako globální proměnné.',
    'php-settings.phpSettingDescription_open_basedir' => 'K souborům v zadaném adresáři lze získat přístup pomocí skriptů PHP. Chcete-li adresáře oddělit, v systému Linux použijte dvojtečku (:), v systému Windows středník (;).',
    'php-settings.phpSettingDescription_error_reporting' => 'Úroveň zasílání zpráv o chybách.',
    'php-settings.phpSettingDescription_display_errors' => 'Určuje, zda mají být chyby zobrazeny jako součást výstupu.',
    'php-settings.phpSettingDescription_log_errors' => 'Povolit protokolování chyb PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Povolit souborovým funkcím PHP obnovit data ze vzdálených umístění prostřednictvím FTP nebo HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Umožňuje nahrávání souborů přes HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Povoluje krátkou formu ( ) otevřeného tagu PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Nastaví stav magic_quotes pro operace GPC (Get/Post/Cookie). Když je zapnut stav magic_quotes, všechny jednoduché uvozovky, dvojité uvozovky, zpětné lomítko a zvláštní znaky NULL budou automaticky uvozeny zpětným lomítkem.',
    'php-settings.phpSettingDescription_disable_functions' => 'Tato direktiva umožňuje zakázat určité funkce. Přejde na seznam názvů funkcí oddělených čárkou',
    'php-settings.phpSupport' => 'Podpora PHP',
    'php-settings.phpRunAs' => 'Spustit PHP jako',
    'php-settings.phpVersion' => 'Verze PHP',
    'php-settings.phpHandlerOutdated' => '(Zastaralé)',
    'php-settings.phpHandlerDeprecated' => '(Nepoužívané)',
    'php-settings.phpServedByApache' => 'obsluhováno prostřednictvím Apache',
    'php-settings.phpServedByNginx' => 'obsluhováno prostřednictvím nginx',
    'php-settings.phpSettingsPhpVersion' => 'Vaše verze PHP je %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP je vypnuto.',
    'php-settings.phpHandlerTypeHint' => 'Níže jsou uvedeny podrobnosti ke konfiguraci PHP webu. Pokud vám poskytovatel hostingu zaručí odpovídající oprávnění, můžete změnit konfiguraci PHP.',
    'php-settings.fpmDedicatedHandlerHint' => 'Používání této obslužné rutiny zvyšuje stabilitu webu, ale také způsobuje vyšší spotřebu paměti.',
    'php-settings.phpHandlerChangeHint' => 'Změnili jste nastavení obslužného programu PHP. Pokud tyto změny uložíte, skripty PHP na vašem webu se mohou kvůli nastavení serveru zastavit na dobu %%interval%% sekund.',
    'php-settings.phpHandlerOutdatedHint' => 'Abyste zkontrolovali, jestli je verze PHP k dispozici, %%link%% a podívejte se u komponent produktu do kategorie "Web Hosting".',
    'php-settings.phpHandlerOutdatedHintLink' => 'Otevřít instalační program Plesk',
    'php-settings.phpHandlerTypeHelpLink' => 'Naučte se, jak vybrat nejvhodnější nastavení PHP',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Podporu PHP nelze povolit, protože aktuální konfigurace nezahrnuje žádné verze PHP dostupné pro tuto doménu.',
    'php-settings.phpHandlersNotAvailableHint' => 'Podporu PHP nelze povolit, protože aktuální konfigurace Plesk nezahrnuje žádné dostupné verze PHP.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Zjistěte, jak povolit další verze PHP.',
    'php-settings.phpSupportEditable' => '(Verze PHP %%version%%, spuštěno PHP jako %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(verze: %%version%%; obslužná rutina: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(neregistrováno) %%link%%',
    'php-settings.showPhpInfo' => 'Zobrazit stránku phpinfo()',
    'php-settings.phpSettingsFormError' => 'Nelze načíst nastavení PHP, protože chybí požadovaná data.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Nelze načíst nastavení PHP, protože tato verze PHP není nainstalována. Abyste mohli pokračovat, nainstalujte vybranou verzi PHP, nebo vyberte pro danou doménu verzi jinou.',
    'php-settings.showPhpInfoTitle' => 'Zobrazit phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Některé z vašich nastavení PHP byly změněny, ale změny dosud nebyly uloženy. Chcete-li vidět nové hodnoty na stránce phpinfo(), použijte nejprve změny. Jinak uvidíte aktuální hodnoty.',
    'php-settings.showPhpInfoButton' => 'Zobrazit phpinfo()',
    'php-settings.onState' => 'Zapnout',
    'php-settings.offState' => 'Vypnout',
    'php-settings.description' => 'Tato stránka zobrazuje konfiguraci PHP pro web: Tato nastavení jsou pro každý web specifická a neovlivňují ostatní weby v předplatném. Pokud vám poskytovatel hostingu zaručí odpovídající oprávnění, můžete změnit konfiguraci PHP. Vlastní konfiguraci PHP lze použít například k omezení spotřeby systémových prostředků PHP skripty nebo ke splnění požadavků určité webové aplikace. Pokud nastavíte hodnotu parametru na výchozí hodnotu, PHP použije hodnotu parametru z konfigurace PHP pro celý server.',
    'php-settings.availableVariables' => 'V hodnotách parametru můžete použít následující zástupné symboly.',
    'php-settings.variableDocroot' => '{DOCROOT} pro adresář kořene dokumentu webu. Aktuální hodnota je %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'Adresář kořene dokumentu HTTPS je stejný jako pro http.',
    'php-settings.variableDocrootHttpsDifferent' => 'Adresář kořene dokumentu HTTPS je %%DOCROOT%%.',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} pro adresář kořene dokumentu primárního webového serveru předplacené služby.',
    'php-settings.variableTmp' => '{TMP} pro adresář k ukládání dočasných souborů.',
    'php-settings.note' => 'Poznámka: níže uvedená nastavení se dají přepsat pomocí parametrů uvedených v souborech .htaccess, php.ini, nebo .user.ini.',

    'pmm.agent.sync.check' => 'Agent Migrace a přenos zjišťuje aktualizace.',
    'pmm.agent.sync.updating' => 'Synchronizace a stahování agenta Migrace a přenos',
    'pmm.agent.sync.done' => 'Agent Migrace a přenos byl úspěšně synchronizován.',
    'pmm.agent.sync.downloadLink' => 'Kliknutím stáhněte soubor agenta Migrace a přenos, který by se měl nainstalovat na hostitele zdroje před zahájením migrace.',
    'pmm.agent.sync.error' => 'Aktualizace agenta Migrace a přenos se nezdařila. Opakujte akci později.',

    'restore-password.title' => 'Změnit heslo',
    'restore-password.passwordLabel' => 'Nové heslo',
    'restore-password.buttonRestore' => 'Uložit',
    'restore-password.buttonCancel' => 'Zrušit',
    'restore-password.isEmpty' => 'Požadované pole je prázdné. Musíte zadat hodnotu.',
    'restore-password.errorInvalidSecret' => 'Neplatný zabezpečovací klíč',
    'restore-password.errorNotFoundSecret' => 'Požádejte o nový tajný kód',
    'restore-password.restoreSuccess' => 'Vaše heslo byl aktualizováno. K přihlášení do prostředí Plesk nebo ke své emailové adrese použijte nové heslo.',

    'scheduler.settings.schedulerNotification' => 'Upozornění plánovače',
    'scheduler.settings.notificationOff' => "Vypnuto",
    'scheduler.settings.notificationDefault' => "Odeslat na výchozí e-mailovou adresu (%%email%%)",
    'scheduler.settings.notificationCustom' => "Odeslat na e-mailovou adresu, kterou určím",
    'scheduler.settings.crontabSecureShell' => 'Prostředí Crontab',
    'scheduler.settings.schedulerTimezoneSelector' => 'Zobrazit plány úlohy pomocí časového pásma',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Použít systémové výchozí časové pásmo (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Použít systémové výchozí časové pásmo',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Použít časové pásmo, které určím',

    'scheduler.task.active' => 'Aktivní',
    'scheduler.task.subscription' => 'Předplacená služba',
    'scheduler.task.subscription_powerUser' => 'Webový prostor',
    'scheduler.task.type' => 'Typ úlohy',
    'scheduler.task.typeCommand' => 'Spuštění příkazu',
    'scheduler.task.typeUrl' => 'Načíst adresu URL',
    'scheduler.task.typeScript' => 'Spustit script PHP',
    'scheduler.task.command' => 'Příkaz',
    'scheduler.task.arguments' => 's argumenty',
    'scheduler.task.url' => 'Adresa URL',
    'scheduler.task.urlDescription' => 'Zadejte absolutní adresu URL, například http://priklad.cz. Pokud je stavový kód odezvy 2xx nebo 3xx, úloha se považuje za úspěšně provedenou.',
    'scheduler.task.script' => 'Cesta skriptu',
    'scheduler.task.scriptRelativePathDescription' => 'Příklad: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Zadejte úplnou cestu ke skriptu. Příklad: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Použít verzi PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Cesta skriptu',
    'scheduler.task.run' => 'Spustit',
    'scheduler.task.on' => 'den',
    'scheduler.task.at' => 'v',
    'scheduler.task.sysUser' => 'Systémový uživatel',
    'scheduler.task.hourly' => 'Každou hodinu',
    'scheduler.task.daily' => 'Denně',
    'scheduler.task.weekly' => 'Týdně',
    'scheduler.task.monthly' => 'Měsíčně',
    'scheduler.task.yearly' => 'Ročně',
    'scheduler.task.cronStyle' => 'Style Cron',
    'scheduler.task.cronStyleHint' => 'Použijte formát UNIX crontab "minuta hodina den v měsíci měsíc den v týdnu". Například "0 22 * * 1-5". Plesk použije výchozí časové pásmo systému, aby se spustila úloha.',
    'scheduler.task.cronStyleWinHint' => 'Použijte formát "minuta hodina den-v-měsíci měsíc den-v-týdnu", například "0 22 * * 6,7". Plesk použije výchozí časové pásmo systému, aby se spustila úloha.',
    'scheduler.task.notify' => 'Oznámit',
    'scheduler.task.notifyIgnore' => 'Neupozorňovat',
    'scheduler.task.notifyErrors' => 'Pouze chyby',
    'scheduler.task.notifyAlways' => 'Pokaždé',
    'scheduler.task.notifyErrorsHint' => 'Oznámení obsahují standardní chybový proud příkazu. Je-li proud prázdný, žádné oznámení nebude odesláno.',
    'scheduler.task.notifyErrorsHintWin' => 'Oznámení obsahují výstup příkazu a odesílají se pouze pokud je ukončovací kód příkazu nenulový.',
    'scheduler.task.notifyAlwaysHint' => 'Oznámení obsahují výstup příkazu. Je-li výstup prázdný, žádné oznámení nebude odesláno.',
    'scheduler.task.notifyAlwaysHintWin' => 'Oznámení obsahují výstup příkazu a odesílají se bez ohledu na ukončovací kód příkazu.',
    'scheduler.task.emailType' => 'Odeslat oznámení pro',
    'scheduler.task.emailTypeDefault' => 'Výchozí uživatel systému (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Vlastník předplacené služby (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Správce (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Ostatní uživatelé',
    'scheduler.task.emailTypeCustomDescription' => 'Můžete zadat několik adres oddělených čárkami.',
    'scheduler.task.minute' => 'minutou',
    'scheduler.task.shortMinute' => 'min.',
    'scheduler.task.dayOfMonth' => 'dnů',
    'scheduler.task.description' => 'Popis',
    'scheduler.task.scheduleTimezoneHint' => 'Časové pásmo pro spuštění úlohy je %%timezone%%',
    'scheduler.task.runTaskNow' => 'Spustit',
    'scheduler.task.runningTask' => 'Spuštění úlohy "%%task%%"...',

    'server-settings.submitDone' => "Nastavení serveru se změnilo.",
    'server-settings.systemSettings' => "Nastavení systému",
    'server-settings.fullHostName' => "Úplný název hostitele",
    'server-settings.trafficStatisticsPeriod' => "Uchovat statistiky webu a přenosu po dobu",
    'server-settings.trafficStatisticsPeriodUnit' => "měsíce",
    'server-settings.diskSpaceUsageCalculation' => "Zahrnout do kalkulace využití místa na disku",
    'server-settings.includeLogs' => "soubory protokolů",
    'server-settings.includeLogsAndStats' => "soubory protokolu a statistické zprávy",
    'server-settings.includeMysqlDatabases' => "Databáze MariaDB/MySQL",
    'server-settings.includeMssqlDatabases' => "Databáze Microsoft SQL",
    'server-settings.includePgsqlDatabases' => "databáze PostgreSQL",
    'server-settings.includeDatabases' => "databáze",
    'server-settings.includeRemoteDatabases' => "vzdálené databáze",
    'server-settings.includeMailboxes' => "poštovní schránky",
    'server-settings.includeMailLists' => "seznamy adresátů",
    'server-settings.includeDomainDumps' => "záložní soubory domény",
    'server-settings.includeAdminDumps' => "soubory zálohy, které vytvořil správce",
    'server-settings.calculatingDiskSpaceUsage' => "Při kalkulaci místa na disku, zahrnuji",
    'server-settings.typeByte' => "velikost souboru",
    'server-settings.typeBlock' => "velikost využitého místa na disku",
    'server-settings.trafficCalculation' => "Zahrnout do kalkulace přenosu dat",
    'server-settings.inboundAndOutbound' => "příchozí a odchozí přenos dat",
    'server-settings.onlyInbound' => "pouze příchozí přenos dat",
    'server-settings.onlyOutbound' => "pouze odchozí přenos dat",
    'server-settings.forbidCreateDnsSubZone' => "Zakázat uživatelům vytváření subzón DNS v subzónách DNS jiných uživatelů",
    'server-settings.webDeployIncludePassword' => "Zařadit uživatelská hesla do souboru s nastavením publikování Web Deploy",
    'server-settings.forbidSysUserRename' => "Zákazníci mohou měnit jména svých uživatelů systému",
    'server-settings.alwaysAllowSysUserRename' => "vždy",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "pouze pokud je uděleno oprávnění pro Správu hostování",
    'server-settings.neverAllowSysUserRename' => "nikdy",
    'server-settings.forbidSubscriptionRename' => "Zakázat zákazníkům a distributorům měnit název hlavní domény",
    'server-settings.preferredDomain' => "Upřednostňovaná doména pro weby",
    'server-settings.preferredDomainNone' => "žádná",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Logování IP",
    'server-settings.disableIpLogging' => "Vypnout logování IP v protokolech IIS, FTP a e-mailu",
    'server-settings.disableIpLoggingDescription' => "V případě výběru nebudou IIS a MailEnable zapisovat IP adresy do souborů protokolu",
    'server-settings.anonymizeIps' => "Anonymizovat IP adresy",
    'server-settings.logrotateAnonymizeIps' => "Anonymizovat IP adresy během rotace souborů protokolu a shromažďování webových statistik",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Post-rotační skript nahrazuje před archivací poslední oktet IPv4 adresy v rotovaných souborech protokolu hodnotou "0". V adresách IPv6 skript nahrazuje poslední sekci adresy (dva oktety za poslední dvojtečkou) hodnotou "0000" (v plném tvaru) nebo "0" (ve zkráceném tvaru)',
    'server-settings.logrotate' => "Rotace souborů protokolu",
    'server-settings.logrotateForce' => "Vynutit denní rotaci souborů protokolu pro všechny domény",
    'server-settings.allowToStoreLogs' => "Povolit ukládání protokolů webu pro",
    'server-settings.logrotatePeriod' => "dny",
    'server-settings.configureUpdatePolicy' => "Konfigurovat zásady aktualizace",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Výchozí hodnota pro celý server (%%default%% zpráv za hodinu)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Vlastní hodnota pro plán',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Vlastní hodnota pro předplatné',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'zprávy',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Odchozí zprávy z poštovní schránky (za hodinu)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Odchozí zprávy z domény (za hodinu)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Odchozí zprávy z předplatného (za hodinu)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Procentuální poměr zpráv (nad hodinový limit), které musí být odeslány další hodinu',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Pokud je limit odchozích e-mailových zpráv z poštovní schránky 100 za hodinu a procentuální podíl 10%, potom má uživatel povoleno odeslat 110 zpráv za hodinu; 100 zpráv bude odesláno během hodiny, 10 zpráv bude zařazeno do fronty, a jejich odeslání bude naplánováno na další hodinu.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Zásady použití aplikace Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Výchozí nastavení pro celý server (aplikace Sendmail je povolena)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Výchozí nastavení pro celý server (aplikace Sendmail není povolena)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Vlastní nastavení pro plán',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Vlastní nastavení pro předplatné',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Umožňuje použití aplikace Sendmail pro skripty a uživatele na tomto předplatném',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Skripty a uživatelé budou moci odesílat e-mailové zprávy (jménem uživatele systému předplacených služeb) prostřednictvím aplikace Sendmail, i když budou překročeny limity pro poštovní schránku a doménu. Maximální počet zpráv, které lze odeslat prostřednictvím aplikace Sendmail, bude dán jejich limitem pro celý odběr.',

    'setup.hint' => 'Vítejte na platformě Plesk, ovládací panel, který vám pomůže se správou vašeho serveru. Plesk poskytuje prostředí připravené na tvoru kódu a poskytne vám sadu výkonných rozšíření pro výboj webů a aplikací. Dokončete proces nastavení, abyste mohli začít s používáním prostředí Plesk (zabere to jenom minutu).',
    'setup.contactInfoSection' => 'Kontaktní údaje',
    'setup.contactInfoSectionHint' => 'Zadejte své jméno a e-mailovou adresu, abyste se mohli sami identifikovat jako vlastníci serveru a mohli přijímat důležitá oznámení týkající se serveru. Pokud jste správcem podnikového serveru, nezadávejte své jméno a příjmení ani e-mailovou adresu. Namísto toho použijte název své funkce a podnikovou e-mailovou adresu, aby nedošlo k možnému porušení zákona na ochranu dat.',
    'setup.contactName' => 'Vaše kontaktní osoba',
    'setup.emptyContactName' => 'Zadejte jméno kontaktu.',
    'setup.contactNameTooLong' => 'Jméno kontaktu je příliš dlouhé (je povoleno maximálně %max% symbolů).',
    'setup.email' => 'E-mail',
    'setup.emptyEmail' => 'Zadejte e-mailovou adresu.',
    'setup.passwordSection' => 'Heslo',
    'setup.passwordSectionHint' => 'Při příštím přihlášení do prostředí Plesk použijte přihlašovací jméno \'admin\' a níže zadané heslo.',
    'setup.password' => 'Heslo',
    'setup.licenseSection' => 'Licence',
    'setup.licenseSectionHint' => 'Chcete-li začít používat platformu Plesk, musíte si nainstalovat licenci.',
    'setup.licenseType' => 'Zvolte typ vaší licence',
    'setup.licenseTypePaid' => 'Pokračujte se zaplacenou licencí',
    'setup.onlineStoreLink' => 'Online úložiště',
    'setup.licenseTypeTrial' => 'Pokračujte s plně funkční zkušební licencí',
    'setup.activationCodeHint' => 'Pokud jste již zakoupili licenci Plesk, vložte sem aktivační kód, který jste obdrželi. Pokud ne, můžete si v našem %%onlineStoreLink%% zakoupit novou licenci.',
    'setup.privacyPolicyLink' => 'Zásady ochrany osobních údajů ve společnosti WebPros',
    'setup.trialLicenseAgreement' => 'Kvůli vystavení zkušební licence bude společnost WebPros International GmbH používat a zpracovávat informace poskytnuté ve svém interním systému na základě dokumentu %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Potvrzuji přečtení a souhlasím s %%link%%',
    'setup.eula' => 'Licenční smlouva s koncovým uživatelem (EULA)',
    'setup.invalidEulaAgreementValue' => 'Musíte přijmout Licenční smlouvu s koncovým uživatelem',
    'setup.sendButton' => 'Vstoupit na platformu Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Obnovit heslo správce při příštím přihlášení',

    'spam-filter.add.titleBlack' => 'Přidat adresy na černou listinu',
    'spam-filter.add.titleWhite' => 'Přidat adresy na bílou listinu',
    'spam-filter.add.fileDescription' => 'Nahrajte textový soubor s kódováním UTF-8 (třeba ve formátu .txt nebo .csv).',
    'spam-filter.add.listDescription' => 'Pravidla formátování: <ul><li>Jednotlivé adresy oddělujte čárkou, středníkem, novým řádkem, bílým znakem, nebo tabulátorem.</li><li>Vlevo od znaku @ používejte jen znaky ze sady ASCII.</li><li>Můžete používat znaky „*“ a „?“ jako zástupné znaky (např. <nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>).</li><li>Nepoužívejte zástupné znaky v částech názvů domény, které nejsou zapsané v sadě ASCII.</li></ul>',
    'spam-filter.add.fromFile' => 'Ze souboru',
    'spam-filter.add.fromList' => 'Ze seznamu',
    'spam-filter.add.success' => 'Byly přidány adresy',

    'ssl-certificate.add.name' => 'Název certifikátu',
    'ssl-certificate.add.longName' => 'Zadaný název certifikátu je příliš dlouhý (je povoleno maximálně %max% symbolů).',
    'ssl-certificate.add.certificateNameUsed' => 'Certifikát s názvem %%name%% již existuje.',
    'ssl-certificate.add.certificateAdded' => 'Byl vydán certifikát SSL/TLS. Aby byla zaručena činnost, přiřaďte certifikát do zabezpečení domény, pošty nebo webového rozhraní pošty.',
    'ssl-certificate.add.certificateUpdated' => 'Certifikát SSL/TLS byl úspěšně aktualizován.',
    'ssl-certificate.add.settings' => 'Nastavení',
    'ssl-certificate.add.settingsHint' => 'Tento formulář použijte k vygenerování žádosti o certifikát, k zakoupení certifikátu od poskytovatele nebo k vygenerování certifikátu podepsaného svým držitelem.',
    'ssl-certificate.add.settingsHint2' => 'Požadavek je soubor CSR, který obsahuje informace o vaší doméně, které jste zadali do formuláře. Požadavek můžete odeslat certifikační autoritě, aby pro vás vydala certifikát. Poté ho můžete nahrát prostřednictvím jednoho z nahraných formulářů níže.',
    'ssl-certificate.add.settingsHint3' => 'Certifikát podepsaný svým držitelem je certifikát identity podepsaný svým vlastním tvůrcem. Pokud používáte takový certifikát, znamená to, že sami ověřujete identitu svých webů. I když certifikáty podepsané svým držitelem povolují využití SSL/TLS, jsou méně důvěryhodné a jsou považovány za méně bezpečné.',
    'ssl-certificate.add.bits' => 'Bity',
    'ssl-certificate.add.country' => 'Země',
    'ssl-certificate.add.state' => 'Země/oblast nebo kraj',
    'ssl-certificate.add.longState' => 'Zadaný název státu nebo oblasti je příliš dlouhý.',
    'ssl-certificate.add.city' => 'Umístění (město)',
    'ssl-certificate.add.longCity' => 'Zadaný název města je příliš dlouhý.',
    'ssl-certificate.add.shortCity' => 'Zadaný název města je příliš krátký.',
    'ssl-certificate.add.companyName' => 'Název organizace (společnost)',
    'ssl-certificate.add.longCompanyName' => 'Zadaný název společnosti je příliš dlouhý.',
    'ssl-certificate.add.companyUnitName' => 'Oddělení organizace nebo Název divize',
    'ssl-certificate.add.longCompanyUnitName' => 'Zadaný název oddělení organizace je příliš dlouhý (je povoleno maximálně %max% symbolů).',
    'ssl-certificate.add.domainName' => 'Název domény',
    'ssl-certificate.add.email' => 'E-mail',
    'ssl-certificate.add.request' => 'Požadavek',
    'ssl-certificate.add.buyCertificate' => 'Zakoupit  certifikát SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Podepsaný držitelem',
    'ssl-certificate.add.invalidCertificateParams' => 'Některá pole jsou prázdná nebo obsahují nesprávnou hodnotu. Hodnoty musí být omezeny na 64 znaků. Pokud používáte mezinárodní název domény, ověřte si, aby žádná část názvu domény nepřekročila po konverzi do formátu ASCII 63 znaků. Zkontrolovat pole:',
    'ssl-certificate.add.unableCreateCsr' => 'Nelze vytvořit CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Nelze vytvořit certifikát podepsaný svým držitelem: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Nelze nastavit data certifikátu: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Nelze uložit certifikát do databáze: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Nahrát soubory certifikátu',
    'ssl-certificate.add.uploadFilesHint' => 'Tento formulář použijte, chcete-li nahrát součásti certifikátu jako základní soubory.',
    'ssl-certificate.add.csr' => 'Zástupce oddělení služeb zákazníkům',
    'ssl-certificate.add.privateKey' => "Privátní klíč (*.key)",
    'ssl-certificate.add.certificate' => "Certifikát CA (*.crt)",
    'ssl-certificate.add.caCertificate' => "Certifikát CA (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Nahrát certifikát",
    'ssl-certificate.add.fileNotUploaded' => 'Nelze nahrát soubor certifikátu: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Nelze nastavit privátní klíč: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Nelze zadat certifikát: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Nelze zadat certifikát CA: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Nelze zkontrolovat, zda certifikát CA podepíše certifikát: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Odebrat',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Opravdu chcete odebrat certifikát CA?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Nelze smazat certifikát CA: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'Součást CA certifikátu byla odebrána.',
    'ssl-certificate.add.rename' => 'Přejmenovat',
    'ssl-certificate.add.unableRenameCertificate' => 'Nelze přejmenovat certifikát: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Certifikát byl přejmenován na %%name%%.',
    'ssl-certificate.add.uploadText' => "Nahrát certifikát jako text",
    'ssl-certificate.add.uploadTextHint' => 'Tento formulář použijte, chcete-li nahrát součásti certifikátu jako text. Kopírovat obsah souboru a vložit ho do odpovídajícího pole.',
    'ssl-certificate.add.sendText' => "Nahrát certifikát",
    'ssl-certificate.add.componentIsMissing' => 'Součást chybí.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Sem nahrát certifikát',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Pokud jste na tomto serveru vytvořili žádost o podpis certifikátu a přijali soubor certifikátu, nahrajte ho sem. Pokud chcete nahrát certifikát a privátní klíč vygenerovaný na jiném serveru nebo vygenerovat certifikát podepsaný svým držitelem, klikněte na tlačítko <b>Přidat certifikát SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Po přidání certifikátu SSL/TLS na doménu musíte zapnout podporu SSL/TLS a v nastavení hostování webu vybrat certifikát: <b>Weby a domény</b>> <b>Nastavení hostování</b> této domény> <b> Zabezpečení</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Certifikát CA (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Nahrát certifikát',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Nelze nahrát soubor certifikátu.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Neplatný formát certifikátu.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Nelze najít odpovídající privátní klíč pro certifikát.',

    'ssl-certificate.secure.certificate' => 'Vybrat certifikát',
    'ssl-certificate.secure.serverPool' => 'Fond serverů',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Datum",
    'system-time.dateAndTime' => "Datum a čas",
    'system-time.daylight' => "Automaticky nastavit hodiny při přechodu na letní čas",
    'system-time.dayMonthYear' => "Den-Měsíc-Rok",
    'system-time.domainNameOrIp' => "Název domény nebo IP",
    'system-time.hoursMinutesSeconds' => "Hodiny:Minuty:Sekundy",
    'system-time.networkTime' => "Čas sítě",
    'system-time.submitDone' => "Nastavení systémového času se změnilo.",
    'system-time.synchronizedSystemTime' => "Synchronizovat systémový čas",
    'system-time.title' => "Systémový datum a čas",
    'system-time.timezone' => "Časové pásmo",
    'system-time.time' => "Čas",
    'system-time.updateSystemTime' => "Aktualizovat systémový čas",
    'system-time.yourTimezone' => "Vaše časové pásmo",

    'web-app-firewall.pageHint' => 'Firewall pro webové aplikace chrání webové aplikace před útoky tím, že kontroluje a filtruje příchozí požadavky HTTP na základě uživatelem definovaných pravidel.',
    'web-app-firewall.webSitePageHint' => 'Zde můžete konfigurovat webovou aplikační bránu firewall (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Režim webová aplikační brána firewall',
    'web-app-firewall.ruleEngineOn' => 'Zapnout',
    'web-app-firewall.ruleEngineOnDescription' => 'Každý příchozí požadavek HTTP a související odezva budou zkontrolovány proti sadě pravidel. Pokud bude kontrola úspěšná, požadavek HTTP bude předán na obsah webu. Pokud kontrola selže, událost se zaznamená, odešle se upozornění a odpověď HTTP bude opatřena kódem chyby.',
    'web-app-firewall.ruleEngineOff' => 'Vypnout',
    'web-app-firewall.ruleEngineOffDescription' => 'Příchozí požadavek HTTP a související odpovědi se nekontrolují.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Pouze zjišťování',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Každý příchozí požadavek HTTP a související odezva budou zkontrolovány proti sadě pravidel. Pokud bude kontrola úspěšná, požadavek HTTP bude předán na obsah webu. Pokud kontrola selže, událost se zaznamená a ModSecurity neprovede žádné další akce. Ostatní služby (například Fail2ban) stále mohou provádět své vlastní akce na požadavcích HTTP, které neprošly kontrolou.',
    'web-app-firewall.ruleSetsSection' => 'Sady pravidel',
    'web-app-firewall.ruleSetsSectionHint' => 'Vyberte, jakou sadu pravidel (balíček souborů obsahujících bezpečnostní pravidla) použijete ke kontrole příchozích požadavků HTTP.',
    'web-app-firewall.ruleSet' => 'Sada pravidel',
    'web-app-firewall.ruleSetCrs' => 'OWASP (zdarma)',
    'web-app-firewall.ruleSetCrsDescription' => 'Sada pravidel OWASP ModSecurity Core je velmi přísná a proto může docházet k blokování některých funkcí (např. sdílení souborů, webového rozhraní pošty) a některých funkcí webových aplikací (např. zásuvných modulů WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Použít změny?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Pravidla OWASP jsou možná velmi přísná a proto blokují některé funkce, např. sdílení souborů, webového rozhraní pošty a některých webových aplikací.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard (zdarma, lze upgradovat na Atomic Advanced)',
    'web-app-firewall.ruleSetTortixDescription' => 'Startovací verze pravidel zabezpečení ModSecurity od Atomicorp. Poskytují základní ochranu a každý měsíc se aktualizují.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Aktualizace této sady pravidel od Atomic Advanced:',
    'web-app-firewall.ruleSetTortixBuy' => 'Koupit %%linkPleskStore%% z webu Plesk a %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Rozšířená pravidla zabezpečení ModSecurity od Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'nainstalovat zakoupený licenční klíč',
    'web-app-firewall.ruleSetTortixSelect' => 'Vyberte toto pravidlo, jehož název se změní na „Atomic Advanced“ (zakoupeno u společnosti Plesk)”',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced (zakoupeno u Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Rozšířená pravidla zabezpečení ModSecurity od Atomicorp zahrnují pravidla Atomic Standard plus řadu pokročilých funkcí.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced (zakoupeno u Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Rozšířená pravidla zabezpečení ModSecurity od Atomicorp zahrnují pravidla Atomic Standard plus řadu pokročilých funkcí.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Přepnutí na jiný účet Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Je aktivována sada pravidel.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Pokud již máte účet Atomicorp se zakoupenými pravidly Atomic Advanced, zadejte pověření účtu, aby se tato sada pravidel aktivovala.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Pokud již máte účet Atomicorp se zakoupenými pravidly Atomic Advanced, zadejte níže přihlašovací údaje k účtu a přepněte jej.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Uživatelské jméno',
    'web-app-firewall.ruleSetAtomicPassword' => 'Heslo',
    'web-app-firewall.ruleSetComodo' => 'Comodo (předplatné zdarma)',
    'web-app-firewall.ruleSetComodoDescription' => 'Bezplatná pravidla Free ModSecurity od Comodo. Poskytují základní ochranu.',
    'web-app-firewall.ruleSetComodoInstall' => 'Přepnutí na jiný účet Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Je aktivována sada pravidel.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Jak povolit tuto sadu pravidel:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Jak přepnout na jiný účet:',
    'web-app-firewall.ruleSetComodoRegister' => 'Registrace na webu Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Zadejte své přihlašovací jméno a heslo z tohoto webu.',
    'web-app-firewall.ruleSetComodoLogin' => 'Uživatelské jméno',
    'web-app-firewall.ruleSetComodoPassword' => 'Heslo',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (zdarma)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Bezplatná pravidla Free ModSecurity od Comodo. Poskytují základní ochranu.',
    'web-app-firewall.ruleSetCustom' => 'Vlastní sada pravidel',
    'web-app-firewall.ruleSetCustomDescription' => 'Nahrát vlastní sadu pravidel brány firewall pro webovou aplikaci. Podporované formáty: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Vybrat jiný soubor',
    'web-app-firewall.ruleSetError' => 'Instalace sady pravidel ModSecurity se nezdařila: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'Sada pravidel OWASP chybí. Přeinstalujte ModSecurity pomocí instalátoru platformy Plesk.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Chybí vlastní sada rpavidel. Přeinstalujte sadu pravidel.',
    'web-app-firewall.ruleSetAuthError' => 'Zadané přihlašovací jméno nebo heslo je neplatné.',
    'web-app-firewall.ruleSetInvalid' => 'Vybranou sadu pravidel nelze spustit na serveru %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Vybranou sadu pravidel nelze spustit na vybraném webovém serveru.',
    'web-app-firewall.webServer' => 'Spustit pravidla na systému',
    'web-app-firewall.webServerHint' => 'Vyberte požadovanou kombinaci verze webového serveru a ModSecurity, abyste viděli kompatibilní sady pravidel.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Reverzní proxy server (nginx) je vypnutý a nelze jej použít ke zpracování požadavků. Vyberte <a href="%%serverUrl%%">jiný webový server</a>, nebo zapněte reverzní proxy server na <a href="%%servicesUrl%%">stránce správy služeb</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Výběr odlišné verze ModSecurity může vést k tomu, že některá nastavení nemusí být dále platná (například nebudete moct používat regulární výrazy k vypnutí bezpečnostních pravidel s ModSecurity 3). Po aplikaci změn se ujistěte, že vaše nastavení funguje dle očekávání. Případně můžete resetovat nastavení, které obnovuje výchozí hodnoty bezpečnostních pravidel.',
    'web-app-firewall.nginxResetCustomizations' => 'Uveďte nastavení serveru a domén vypínající pravidla zabezpečení do výchozích hodnot.',
    'web-app-firewall.ruleSetUpdate' => 'Aktualizovat sady pravidel',
    'web-app-firewall.ruleSetUpdateDaily' => 'Denně',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Týdně',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Měsíčně',
    'web-app-firewall.currentRuleSet' => 'Sada pravidel',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => 'Sada pravidel %%ruleSet%% běžící na serveru %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Změnit sadu pravidel',
    'web-app-firewall.ruleSetRollbackFailed' => 'Nelze použít aktuální sadu pravidel ModSecurity a vrátit se nazpět k předchozí verzi, protože sada obsahuje neplatná pravidla.',
    'web-app-firewall.configurationSection' => 'Konfigurace',
    'web-app-firewall.configurationSectionHint' => 'Nakonfigurujte firewall webové aplikace pomocí předem definované sady parametrů, nebo svých vlastních směrnic ModSecurity.',
    'web-app-firewall.configPreset' => 'Předem definované sady hodnot',
    'web-app-firewall.configPresetFast' => 'Rychlé',
    'web-app-firewall.configPresetFastDescription' => 'Požadavek HTTP URI a části hlaviček budou analyzovány.',
    'web-app-firewall.configPresetTradeOff' => 'Navzájem',
    'web-app-firewall.configPresetTradeOffDescription' => 'Požadavek HTTP URI, hlavičky a data požadavku POST budou analyzovány.',
    'web-app-firewall.configPresetThrough' => 'Důkladně',
    'web-app-firewall.configPresetThroughDescription' => 'Úplné hlavičky požadavků HTTP, data požadavku POST a obsah těla odpovědi HTTP budou analyzovány.',
    'web-app-firewall.configCustom' => 'Vlastní direktivy',
    'web-app-firewall.configCustomDescription' => "Vložit sem direktivu ModSecurity Přepíše dříve zadané direktivy (sady pravidel, konkrétní pravidla, předem definované sady hodnot atd.). Například: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Neplatná konfigurace ModSecurity: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Nelze použít aktuální konfigurační soubor ModSecurity a vrátit se nazpět k předchozí verzi souboru, protože soubory obsahují neplatnou konfiguraci.',
    'web-app-firewall.rulesSection' => 'Vypnout pravidla zabezpečení',
    'web-app-firewall.rulesSectionHint' => 'Zde můžete vypnout pravidla zabezpečení. To se hodí, pokud zjistíte, že pravidlo zabezpečení je pro některé weby příliš omezující. Chcete-li pravidla zabezpečení vypnout, zadejte jejich ID (například 340003, 340005-340007), identifikátory (například CVE-2011-4898) nebo regulární výrazy použité v pravidlech zpráv (například XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Zde můžete vypnout pravidla zabezpečení. To se hodí, pokud zjistíte, že pravidlo zabezpečení je pro některé weby příliš omezující. Chcete-li pravidla zabezpečení vypnout, zadejte jejich ID (například 340003, 340005-340007), identifikátory (například CVE-2011-4898) nebo zprávy pravidel (například Nalezen uživatelský agent související s bezpečnostním skenerem).',
    'web-app-firewall.filterById' => 'ID pravidla zabezpečení',
    'web-app-firewall.filterByIdInvalid' => 'Následující hodnoty nejsou platné: %%values%%. ID pravidla by mělo být tvořeno číslicemi nebo rozsahem číslic, například 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Následující rozsahy nejsou platné: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Tagy',
    'web-app-firewall.filterByTagActive' => 'Aktivní:',
    'web-app-firewall.filterByTagDeactivated' => 'Deaktivováno:',
    'web-app-firewall.filterByTagInvalid' => 'Následující vybrané hodnoty nejsou platné: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Regulární výrazy ve zprávách pravidel',
    'web-app-firewall.filterByRegexpInvalid' => 'Následující hodnoty nejsou platné: %%values%%. Nesmí obsahovat žádné znaky \', ".',
    'web-app-firewall.filterByRegexpNginx' => 'Zprávy pravidel',
    'web-app-firewall.filterByRegexpNginxHint' => 'Podporovány jsou pouze přesné shody.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Následující hodnoty nejsou platné: %%values%%. Zpráva pravidla musí být tvořena písmeny, číslicemi, mezerami nebo znaky -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Protokol auditu ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Protokol auditu ModSecurity je nejužitečnějším prvkem informace v systému. Až ModSecurity zjistí, že proběhla nějaká událost, vygeneruje záznam do souboru protokolu auditu.',
    'web-app-firewall.auditLogHint2' => 'Pokud změníte režim webové aplikační brány firewall z vypnuto na zapnuto nebo Pouze detekce, web může přestat pracovat tak, jak očekáváte. V tomto případě analyzujte protokol auditu ModSecurity, abyste zjistili, co se děje. Příliš omezující pravidla zabezpečení lze vypnout nebo přizpůsobit web.',
    'web-app-firewall.auditLogHint3' => 'Jak zjistit, proč nelze dokončit požadavek HTTP pro web:',
    'web-app-firewall.auditLogPoint1' => 'Klikněte dole na odkaz na soubor protokolu ModSecurity a otevřete protokol auditu v novém okně prohlížeče.',
    'web-app-firewall.auditLogPoint2' => 'Chcete-li vyhledat události webu (název domény), který má problémy, použít funkci Vyhledat (Ctrl+F ve většině webových prohlížečů). Například your_domain.tld. Prohlížeč zvýrazní položky jako HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'Ve třech rádcích nad zvýrazněnou položkou vyhledejte řetězec ve tvaru --eece5138-B--. Osm symbolů mezi pomlčkami (v našem příkladu eece5138) představuje ID události spuštěné požadavkem HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Hledat další položky se stejným ID události. Hledat položku s písmenem H za ID události (v našem příkladu eece5138-H--). Tento záznam obsahuje ID a popis pravidla zabezpečení spouštěného při kontrole požadavku HTTP. ID pravidla zabezpečení je celé číslo v uvozovkách s ID předpony v hranatých závorkách (například [id "340003"]).',
    'web-app-firewall.auditLogPoint5' => 'Vyhledat ID pravidla zabezpečení v události prostřednictvím podřetězce (například [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Vypnout pravidla zabezpečení s tímto ID v sekci Pravidla zabezpečení níže: do pole ID pravidla zabezpečení zadejte ID pravidla zabezpečení (pouze číslice).',
    'web-app-firewall.auditLogViewLink' => 'Soubor protokolu ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Archív protokolů',
    'web-app-firewall.errorLogSection' => 'Protokol chyb',
    'web-app-firewall.errorLogSectionHint' => 'Pokud změníte režim webové aplikační brány firewall z vypnuto na zapnuto nebo Pouze detekce, web může přestat pracovat tak, jak očekáváte. V tomto případě analyzujte protokol chyb, abyste zjistili, co se děje. Příliš omezující pravidla zabezpečení lze vypnout nebo přizpůsobit web.',
    'web-app-firewall.errorLogViewLink' => 'Soubor protokolu chyb',
    'web-app-firewall.notificationStateEnabled' => 'Oznámení uživatelského rozhraní platformy Plesk k aktualizacím sady pravidel jsou zapnuta. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Oznámení uživatelského rozhraní platformy Plesk k aktualizacím sady pravidel jsou vypnuta. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Spravujte je na stránce oznámení',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Výběr možností „Vyvážené“ nebo „Vyčerpávající“ může, mimo jiné nechtěné důsledky, způsobit nefunkčnost webů WordPressu kvůli následujícím <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">problémům s ModSecurity</a>.',

    'ProtectedDirectory.pathLabel' => 'Název adresáře',
    'ProtectedDirectory.realmLabel' => 'Název chráněné oblasti',
    'ProtectedDirectory.locationLabel' => 'Umístění adresáře',
    'ProtectedDirectory.isNonSslLabel' => 'bez SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Název sestavy',
    'SummaryReport.Layout.isDefault' => 'Používat jako výchozí',
    'SummaryReport.Layout.sections' => 'Oddíly',
    'SummaryReport.Layout.general' => 'Obecné',
    'SummaryReport.Layout.resellers' => 'Distributoři',
    'SummaryReport.Layout.clients' => 'Zákazníci',
    'SummaryReport.Layout.personalClients' => 'Vlastní zákazníci',
    'SummaryReport.Layout.domains' => 'Domény',
    'SummaryReport.Layout.personalDomains' => 'Osobní domény',
    'SummaryReport.Layout.type.full' => 'Úplné',
    'SummaryReport.Layout.type.summary' => 'Souhrn',

    'SummaryReport.Schedule.enable' => 'Povolit',
    'SummaryReport.Schedule.period' => 'Frekvence doručení',
    'SummaryReport.Schedule.daily' => 'Denně',
    'SummaryReport.Schedule.weekly' => 'Týdně',
    'SummaryReport.Schedule.monthly' => 'Měsíčně',
    'SummaryReport.Schedule.email' => 'Doručit (komu)',
    'SummaryReport.Schedule.isEmpty' => 'Zadejte platnou e-mailovou adresu.',

    'MassMailForm.name' => 'Název šablony',
    'MassMailForm.fromEmail' => 'Od (e-mailová adresa):',
    'MassMailForm.sendToAdmins' => 'Odeslat správci Plesk',
    'MassMailForm.sendToResellers' => 'Odeslat prodejcům',
    'MassMailForm.sendToClients' => 'Odeslat zákazníkům',
    'MassMailForm.subject' => 'Předmět',
    'MassMailForm.body' => 'Text zprávy',
    'MassMailForm.bodyDescription' => '
Můžete použít <name> proměnnou v textu zprávy (ale ne v hlavičce). Bude nahrazeno kontaktním jménem zákazníka nebo prodejce.',
    'MassMailForm.sendToResellersMode' => 'Adresáti',
    'MassMailForm.sendToResellersModeAll' => 'Všichni prodejci',
    'MassMailForm.sendToResellersModeSelect' => 'Vybraní prodejci',
    'MassMailForm.sendToResellersModeExcept' => 'Všem kromě vybraných prodejců',
    'MassMailForm.sendToClientsMode' => 'Adresáti',
    'MassMailForm.sendToClientsModeAll' => 'Všichni odběratelé',
    'MassMailForm.sendToClientsModeSelect' => 'Vybraní zákazníci',
    'MassMailForm.sendToClientsModeExcept' => 'Všem kromě vybraných zákazníků',

    'VirtualDirectory.DirectorySection.title' => 'Virtuální adresář',
    'VirtualDirectory.DirectorySection.name' => 'Jméno',
    'VirtualDirectory.DirectorySection.accessSource' => 'Přístup ke zdroji skriptu',
    'VirtualDirectory.DirectorySection.accessRead' => 'Oprávnění ke čtení',
    'VirtualDirectory.DirectorySection.accessWrite' => 'Oprávnění k zápisu',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => 'Procházení adresářů',
    'VirtualDirectory.DirectorySection.log' => 'Protokolovat návštěvy',
    'VirtualDirectory.Path.path' => 'Cesta',
    'VirtualDirectory.Path.autoPathLabel' => 'Vytvořit fyzický adresář se stejným názvem jako u virtuálního adresáře',
    'VirtualDirectory.ApplicationSettingsSection.title' => 'Nastavení aplikace',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => 'Vytvořit aplikaci',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => 'Povolit používání nadřazených cest',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'Povolit spuštění aplikace v prostředí MTA (vícenásobný objekt)',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => 'Oprávnění ke spouštění',
    'VirtualDirectory.SecuritySection.title' => 'Zabezpečení adresáře',
    'VirtualDirectory.SecuritySection.authAnonymous' => 'Přepnutí na anonymní ověřování',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Přepnutí na ověřování Windows',
    'VirtualDirectory.SecuritySection.requireSSL' => 'Požadovat protokol SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => 'Žádný',
    'VirtualDirectory.scriptExecuteOption.script' => 'Pouze skripty',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => 'Skripty a spustitelné soubory',
    'VirtualDirectory.AspSection.title' => 'Nastavení ASP',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'Maximální velikosti mezipaměti ASP (kB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'Maximální velikost obsahu entity požadavku ASP (kB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'Povolit ladění skriptů ASP na straně serveru',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'Povolit ladění skriptů ASP na straně klienta',
    'VirtualDirectory.AspSection.definedByIis' => 'Definováno IIS',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'Definováno IIS (%%size%% kB)',
    'VirtualDirectory.AspSection.definedByParent' => 'Definováno nadřazeným adresářem',
    'VirtualDirectory.AspSection.definedByParentWithSize' => 'Definováno nadřazeným adresářem (%%size%% kB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => 'Ano',
    'VirtualDirectory.CheckboxField.false' => 'Ne',
    'VirtualDirectory.DocumentsSection.title' => 'Doklady',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => 'Použít výchozí dokumenty',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => 'Výchozí pořadí vyhledávání dokumentů',
    'VirtualDirectory.DefaultDocsField.remove' => 'Odebrat',
    'VirtualDirectory.NewDefaultDoc.add' => 'Přidat',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => 'Kliknutím přidejte soubor do seznamu.',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => 'Zadejte název souboru, který chcete přidat na seznam.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => 'Fyzický adresář se stejným názvem už existuje. Pokud budete pokračovat, adresář se znepřístupní. Chcete pokračovat?',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => 'Pokračovat',

    'VirtualDirectoryMimeType.extension' => 'Rozšíření',
    'VirtualDirectoryMimeType.content' => 'Obsah',
    'VirtualDirectoryMimeType.custom' => 'Vlastní',
];