<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installation de %%name%% sous %%path%%...',
    'aps-install.queueNoPath' => 'Installation de %%name%%...',
    'aps-install.done' => '%%name%% a bien été installé sous %%path%%. Vous pouvez voir vos identifiants d\'accès pour la connexion à l\'application ci-dessous. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% a bien été installé. Vous pouvez voir vos identifiants d\'accès pour la connexion à l\'application ci-dessous. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% a bien été installé sous %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% a bien été installé. %%additionalMessage%%',
    'aps-install.error' => 'L\'installation de %%name%% sous %%path%% a échoué. %%errorMessage%%',
    'aps-install.errorNoPath' => 'L\'installation de %%name%% a échoué. %%errorMessage%%',

    'aps-update.queueDownload' => 'Téléchargement de %%packageName%%...',
    'aps-update.errorDownload' => 'Échec du téléchargement de %%packageName%% :',
    'aps-update.queueInstall' => 'Mise à jour d\'une installation de %%name%% pour %%domainName%% en cours...',
    'aps-update.doneInstall' => 'L\'installation de %%name%% pour %%domainName%% a bien été mise à jour.',
    'aps-update.errorInstall' => 'Échec de la mise à jour de l\'installation de %%name%% pour %%domainName%% :',
    'aps-update.queueInstallMulti' => 'Mise à jour de %%instances%% installations de %%name%% en cours...',
    'aps-update.doneInstallMulti' => '%%successes%% installations de  %%name%% ont bien été mises à jour.',
    'aps-update.errorInstallMulti' => 'Échec de la mise à jour de %%failures%% installations de %%name%% :',
    'aps-update.incorrectUpdateInformation' => 'Les informations relatives à la mise à jour sont incorrectes.',

    'common.hideCompletedTasks' => 'Masquer les tâches terminées',
    'common.progressBarHide' => 'Masquer',
    'common.progressBarShow' => 'Afficher',
    'common.close' => 'Fermer',
    'common.refresh' => 'Actualiser la page',
    'common.taskInProgress' => '%%count%% tâches en cours...',
    'common.percentCompleted' => '%%percent%%% terminés',
    'common.allTasksCompleted' => 'Les %%num%% tâches ont bien été terminées.',
    'common.minimize' => 'Réduire',
    'common.statusDone' => 'Terminé',
    'common.statusError' => 'Échec',
    'common.statusNotStarted' => 'En file d\'attente',
    'common.statusCanceled' => 'Annulé',
    'common.progressDialogLink' => 'progression détaillée',

    'database-check.queue' => 'Vérification des tables de bases de données %%database%%...',
    'database-check.done' => 'La base de données %%database%% n\'a aucune erreur.',
    'database-check.error' => 'Impossible de vérifier les erreurs de la base de données %%database%%.',
    'database-check.done-with-errors' => "La base de données %%database%% a %%number%% problèmes. \n %%link%%",
    'database-check.info-link-title' => 'Voir les détails et résoudre les problèmes',

    'database-download.queue' => 'Préparation d\'un dump de %%database%% pour l\'export...',
    'database-download.done' => 'Le dump de %%database%% est prêt. Vous pouvez le %%downloadLink%%.',
    'database-download.downloadLink' => 'télécharger',
    'database-download.error' => 'Impossible d\'exporter le dump de %%database%% :',

    'database-repair.queue' => 'Réparation des tables de bases de données %%database%%...',
    'database-repair.done' => 'La base de données %%database%% n\'a aucune erreur.',
    'database-repair.error' => 'Impossible de réparer la base de données %%database%%.',
    'database-repair.done-with-errors' => "La base de données %%database%% a %%number%% problèmes. \n %%link%%",
    'database-repair.info-link-title' => 'Voir les détails',

    'database-upload.queue' => 'Importation d\'un dump de %%database%%...',
    'database-upload.done' => 'Le dump de %%database%% a été importé.',
    'database-upload.error' => 'Impossible d\'importer le dump de %%database%% :',
    'database-upload.done-with-errors' => "Le dump de %%database%% a été importé avec des erreurs.",
    'database-upload.orphanedUsersSuccess' => 'La base de données %%database%% a bien été importée. Toutefois, certains utilisateurs sont devenus orphelins (ils n\'ont pas de logins associés sur le serveur de base de données). Pour accéder à vos bases de données, affectez des noms d\'utilisateurs à ces utilisateurs. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Toutefois, certains utilisateurs sont devenus orphelins (ils n\'ont pas de noms d\'utilisateurs associés sur le serveur de base de données) : %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Afficher les utilisateurs',

    'domain-app-scan.queue' => 'Analyse des applications en cours...',
    'domain-app-scan.done' => 'Analyse des applications terminée.',
    'domain-app-scan.error' => 'Analyse des applications terminée avec des erreurs.',

    'domain-move.queue' => 'Déplacement de %%domainName%% vers %%webspaceName%%',
    'domain-move.done' => '%%domainName%% a été déplacé vers %%webspaceName%%',
    'domain-move.error' => '%%domainName%% n\'a pas été déplacé vers %%webspaceName%%',

    'domain-split.queue' => 'Déplacement de %%domainName%% vers un nouvel abonnement',
    'domain-split.done' => '%%domainName%% a été déplacé vers un nouvel abonnement',
    'domain-split.error' => '%%domainName%% n\'a pas été déplacé vers un nouvel abonnement',

    'file-manager-import-file.done' => 'Le fichier %%fileName%% a été importé dans <a href="%%listUrl%%">le %%fileDir%% dossier</a>.',
    'file-manager-import-file.error' => 'Impossible d\'importer le fichier %%fileName%% : %%errorMessage%%.<br><a href="%%url%%">Télécharger sur mon ordinateur</a>.',
    'file-manager-import-file.queue' => 'Importation du fichier %%fileName%% depuis %%host%%.',
    'file-manager-import-file.progress' => 'Importation du fichier %%fileName%% depuis %%host%% (%%value%% Mo).',
    'file-manager-import-file.errors.auth' => 'Une erreur d\'authentification s\'est produite. Vérifiez si votre identifiant et votre mot de passe sont exacts.',
    'file-manager-import-file.errors.resolve' => 'Impossible de résoudre le nom d\'hôte %%host%%. Vérifiez si vous avez fourni l\'URL correcte.',
    'file-manager-import-file.errors.connect' => 'Impossible de se connecter au serveur %%host%%. Vérifiez si vous avez fourni l\'URL correcte.',
    'file-manager-import-file.errors.notFound' => 'Le fichier distant n\'a pas été trouvé ou n\'est pas accessible. Vérifiez si vous avez fourni l\'URL correcte et si le fichier est accessible.',
    'file-manager-import-file.errors.maxSize' => 'La limite de l\'espace disque ou l\'espace libre %%diskSpaceLimit%% a été dépassé.',
    'file-manager-import-file.errors.lowSpeedTime' => 'Impossible d\'importer le fichier. La vitesse de transfert était trop lente : moins de %%lowSpeedLimit%% octets ont été transférés lors des dernières %%lowSpeedTime%% secondes. Le site web sur lequel ce fichier est hébergé semble surchargé pour le moment. Essayez à nouveau ultérieurement.',
    'file-manager-import-file.errors.certificate' => 'Impossible d\'importer le fichier. Le certificat SSL/TLS sur le serveur %%host%% n\'est pas fiable. Vérifiez si le site Web sur lequel le fichier est hébergé est sécurisé par un certificat de confiance.',
    'file-manager-import-file.errors.redirects' => 'Le nombre maximum de redirections (%%maxRedirects%%) a été dépassé. Vérifiez si le serveur %%host%% fonctionne correctement.',

    'force-log-rotation.queue' => 'Application des paramètres globaux de rotation des journaux',
    'force-log-rotation.done' => 'Les paramètres de la rotation globale des journaux ont été changés.',
    'force-log-rotation.error' => 'L\'application de la rotation globale des journaux s\'est terminée avec des erreurs.',
    'force-log-rotation.systemLogRotationError' => 'Journaux système : %%error%%',
    'force-log-rotation.planLogRotationError' => 'Packs de services %%name%% : %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domaine %%name%% : %%error%%',

    'initial-setup.queue' => 'Initialisation de Plesk...',
    'initial-setup.done' => 'Plesk a été initialisé.',
    'initial-setup.doneWithErrors' => 'Une erreur s\'est produite pendant l\'initialisation de Plesk.',
    'initial-setup.error' => 'L\'initialisation de Plesk a échoué.',
    'initial-setup.step.setupPanel' => 'Configuration de Plesk Panel',
    'initial-setup.step.requestLicense' => 'Demander la licence',
    'initial-setup.step.configureServer' => 'Configuration du serveur Web',
    'initial-setup.step.secureServer' => 'Sécurisation du serveur',

    'ip-update.queue' => 'Mise à jour de l\'adresse IP en cours',
    'ip-update.done' => 'L\'adresse IP est mise à jour.',
    'ip-update.error' => 'La mise à jour des adresses IP a terminé avec des erreurs.',
    'ip-update.updating' => 'Mise à jour de l\'adresse IP en cours',
    'ip-update.updatingWebServer' => 'Mise à jour de l\'adresse IP : mise à jour du serveur Web',
    'ip-update.updatingFtpServer' => 'Mise à jour de l\'adresse IP : mise à jour du serveur FTP',
    'ip-update.updatingDnsZones' => 'Mise à jour de l\'adresse IP : mise à jour des zones DNS',
    'ip-update.restartingDnsService' => 'Mise à jour de l\'adresse IP : redémarrage du serveur DNS',

    'ip-reload-public.queue' => 'Mise à jour des adresses IP publiques à l\'aide des métadonnées du cloud',
    'ip-reload-public.done' => 'Les adresses IP publiques ont été mises à jour.',

    'logrotate_anonymize_ips.queue' => 'Rendre les adresses IP anonymes dans les fichiers journaux',
    'logrotate_anonymize_ips.queueRevert' => 'Désanonymiser les adresses IP dans les journaux',
    'logrotate_anonymize_ips.done' => 'Les adresses IP ont été rendues anonymes.',
    'logrotate_anonymize_ips.doneRevert' => 'Les adresses IP ne sont plus anonymes.',
    'logrotate_anonymize_ips.error' => 'Le processus pour rendre les adresses IP anonymes s\'est terminé avec des erreurs.',
    'logrotate_anonymize_ips.errorRevert' => 'Le processus de désanonymisation des adresses IP s\'est terminé avec des erreurs.',

    'panel-components-install.queue' => 'Installation des composants sélectionnés',
    'panel-components-install.done' => 'Les composants sélectionnés ont été installés avec succès.',
    'panel-components-install.error' => 'Impossible d\'installer les composants. La notification ainsi que la description de l\'erreur vous ont été envoyés à votre adresse mail.',

    'panel-update.queue' => 'Plesk installe les mises à jour. Cela risque de prendre quelques minutes. %%warning%%',
    'panel-update.warning' => 'Ne procédez à aucune opération de gestion dans Plesk jusqu\'à la fin de la mise à jour.',
    'panel-update.done' => 'La mise à jour de Plesk est terminée. Pour en savoir plus : %%changelog%%.',
    'panel-update.changelog' => 'Journal des modifications de Plesk',
    'panel-update.error' => 'Impossible de mettre Plesk à jour. %%errorDetails%%',
    'panel-update.support' => 'Vous pouvez envoyer le journal de mise à jour à l\'assistance Plesk pour essayer de résoudre le problème. %%failedLog%% Copiez le journal sur votre ordinateur avant de fermer ce message.',
    'panel-update.failedLog' => 'Consultez le journal de mise à jour à partir du %%date%%.',

    'pum-update-packages.queue' => 'Mise à jour de %%count%% pack(s)...',
    'pum-update-packages.done' => '%%count%% packs ont bien été mis à jour.',
    'pum-update-packages.error' => 'Échec de la mise à jour.',

    'scheduler-run-task.queue' => 'Exécution de la tâche "%%task%%"...',
    'scheduler-run-task.done' => 'La tâche "%%task%%" s\'est bien exécutée en %%seconds%% secondes.',
    'scheduler-run-task.error' => 'La tâche "%%task%%" a terminé avec une erreur en %%seconds%% secondes.',
    'scheduler-run-task.popupSeeDetails' => 'Voir les détails',
    'scheduler-run-task.popupTitle' => 'Exécuter la tâche planifiée',
    'scheduler-run-task.popupDone' => 'La tâche "%%task%%" s\'est bien exécutée en %%seconds%% secondes, résultat :',
    'scheduler-run-task.popupError' => 'La tâche "%%task%%" a terminé avec une erreur en %%seconds%% secondes, résultat :',
    'scheduler-run-task.popupClose' => 'Fermer',

    'sdk.queue' => 'La tâche "%%name%%" est en cours d\'exécution.',
    'sdk.error' => 'La tâche "%%name%%" a échoué.',
    'sdk.done' => 'La tâche "%%name%%" est finie.',
    'sdk.canceled' => 'La tâche "%%name%%" a été annulée.',

    'sync-php-settings.queue' => 'Application des paramètres PHP %%version%% globaux aux domaines',
    'sync-php-settings.done' => 'Les paramètres PHP %%version%% globaux ont bien été appliqués aux domaines.',
    'sync-php-settings.error' => 'Une erreur s\'est produite lors de l\'application de paramètres PHP %%version%% globaux aux domaines.',

    'sync-service-plan.queue' => 'Synchronisation du pack de services %%name%% avec les abonnements',
    'sync-service-plan.done' => 'Le pack de services %%name%% a bien été synchronisé avec les abonnements.',
    'sync-service-plan.doneWithErrors' => 'La synchronisation du pack de services %%name%% a été terminée. Certains abonnements n\'ont pas été synchronisés avec le pack.',
    'sync-service-plan.error' => 'Une erreur s\'est produite pendant la synchronisation du pack de services %%name%% avec les abonnements.',

    'domain-create.queue' => 'Création du domaine %%domainName%%',
    'domain-create.done' => 'Domaine %%domainName%% créé',
    'domain-create.error' => 'Échec de la création du domaine %%domainName%%',
    'domain-create.warning' => 'Le domaine %%domainName%% a été créé mais rencontre quelques problèmes :<br> %%problems%%',
    'domain-create.refreshUrl' => 'Afficher',
    'domain-create.steps.createCustomer' => 'Création du client',
    'domain-create.steps.createSubscription' => 'Création d\'un abonnement',
    'domain-create.steps.createDomain' => 'Ajout d\'un domaine',
    'domain-create.steps.configureDns' => 'Configuration de la zone DNS',
    'domain-create.steps.createHosting' => 'Création d\'un hébergement physique',
    'domain-create.steps.configurePhp' => 'Configuration PHP',
    'domain-create.steps.configureMail' => 'Configuration de la messagerie',

    'domain-delete.queue' => 'Suppression des domaines en cours',
    'domain-delete.done' => 'Domaines supprimés',
    'domain-delete.error' => 'Échec de la suppression des domaines',
    'domain-delete.step.domains' => 'Suppression des domaines…',

    'domain-resolve-checking.warning' => 'Un problème de résolution du domaine %%domainName%% a été détecté : <br> %%errors%%',

    'customer-create.queue' => 'Création du client %%customerName%% en cours',
    'customer-create.done' => 'Client %%customerName%% créé',
    'customer-create.error' => 'Échec de la création du client %%customerName%%',
    'customer-create.warning' => 'Le client %%customerName%% a été créé mais rencontre quelques problèmes :<br> %%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Vous pouvez essayer de le synchroniser manuellement.',

    'customer-delete.queue' => 'Suppression des clients en cours',
    'customer-delete.done' => 'Clients supprimés',
    'customer-delete.error' => 'Échec de la suppression des clients',

    'reseller-delete.queue' => 'Suppression des revendeurs en cours',
    'reseller-delete.done' => 'Revendeurs supprimés',
    'reseller-delete.error' => 'Échec de la suppression des revendeurs',

    'subscription-create.queue' => 'Création de l\'abonnement %%subscriptionName%% en cours',
    'subscription-create.done' => 'Abonnement %%subscriptionName%% créé',
    'subscription-create.error' => 'Échec de la création de l\'abonnement %%subscriptionName%%',
    'subscription-create.warning' => 'L\'abonnement %%subscriptionName%% été créé mais rencontre quelques problèmes :<br> %%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Vous pouvez essayer de le synchroniser manuellement.',

    'subscription-delete.queue' => 'Suppression des abonnements en cours',
    'subscription-delete.done' => 'Abonnements supprimés',
    'subscription-delete.error' => 'Échec de la suppression des abonnements',

    'websites-diagnostic.queue' => 'Exécution du diagnostic des sites web',
    'websites-diagnostic.done' => 'Diagnostic des sites web terminé',
    'websites-diagnostic.error' => 'Le diagnostic des sites web s\'est terminé avec des erreurs.',

    'install-php-extension.queue' => 'Installation du package %%extensionName%% sur le gestionnaire PHP %%phpHandlerName%%',
    'install-php-extension.done' => 'Le package %%extensionName%% a été installé sur le gestionnaire PHP %%phpHandlerName%%',
    'install-php-extension.error' => 'Échec de l\'installation du package %%extensionName%% sur le gestionnaire PHP %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Vérification des prérequis',
    'install-php-extension.step.dependencies' => 'Résolution des dépendances',
    'install-php-extension.step.process' => 'Installation du package',
    'install-php-extension.step.enable' => 'Activation de l\'extension',
    'install-php-extension.step.sync' => 'Synchronisation des sites',
    'install-php-extension.errorReason' => 'La liste des packages disponibles est fournie par PECL. En cas d\'échec de l\'installation, voici la liste des raisons les plus fréquentes :',
    'install-php-extension.errorReasonDependencies' => '- Le package inclut des dépendances externes sur d\'autres librairies.',
    'install-php-extension.errorReasonRequirements' => '- Le package n\'est pas conforme aux prérequis de l\'installation (OS, version de PHP, etc.).',
    'install-php-extension.errorReasonOutdated' => '- Le package est obsolète.',
    'install-php-extension.errorOutput' => 'Pour identifier les causes de l\'échec de l\'installation, examinez les résultats de l\'utilitaire.',

    'uninstall-php-extension.queue' => 'Désinstallation du package %%extensionName%% du gestionnaire PHP %%phpHandlerName%%',
    'uninstall-php-extension.done' => 'Le package %%extensionName%% a été désinstallé du gestionnaire PHP %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Échec de la désinstallation du package %%extensionName%% du gestionnaire %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Vérification des prérequis',
    'uninstall-php-extension.step.process' => 'Désinstallation du package',
    'uninstall-php-extension.step.sync' => 'Synchronisation des sites web',

    'upgrade-database-server.queue' => 'Mise à niveau du serveur de bases de données',
    'upgrade-database-server.error' => 'Échec de la mise à niveau du serveur de bases de données',
    'upgrade-database-server.done' => 'Le serveur de bases de données a été mis à niveau.',
    'upgrade-database-server.step.validate' => 'Vérification du système',
    'upgrade-database-server.step.dump' => 'Création d\'un dump de base de données',
    'upgrade-database-server.step.disableService' => 'Désactivation de l\'ancien service du système',
    'upgrade-database-server.step.configureRepo' => 'Configuration d\'un nouveau dépôt',
    'upgrade-database-server.step.upgradePackages' => 'Mise à niveau du serveur de bases de données',
    'upgrade-database-server.step.updateConfiguration' => 'Mise à jour de la configuration serveur',
    'upgrade-database-server.step.startService' => 'Démarrage d\'un nouveau service du système',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Mise à niveau de la structure de toutes les tables',
    'upgrade-database-server.step.sync' => 'Synchronisation des composants système',
    'upgrade-database-server.step.validateInstallation' => 'Validation de l\'installation',

    'update-spam-filter-individual-settings.queue' => 'Mise à jour des paramètres du filtre antispam',
    'update-spam-filter-individual-settings.done' => 'Les paramètres du filtre antispam ont été mis à jour.',
    'update-spam-filter-individual-settings.error' => 'Impossible de mettre à jour les paramètres du filtre antispam',
    'update-spam-filter-individual-settings.mailNameError' => 'Adresse e-mail %%name%% : %%error%%',

    'update-default-cert.queue' => 'Mise à jour du certificat par défaut',
    'update-default-cert.done' => 'Le certificat par défaut a été mis à jour.',
    'update-default-cert.error' => 'La mise à jour du certificat par défaut s\'est terminée avec des erreurs.',
    'update-default-cert.step.updating' => 'Mise à jour du certificat par défaut en cours…',

    'smarthost-attach-server-domains.queue' => 'Association des domaines à l\'hôte intelligent',
    'smarthost-attach-server-domains.done' => 'Des domaines ont été associés à l\'hôte intelligent.',
    'smarthost-attach-server-domains.doneWithErrors' => 'L\'association des domaines à l\'hôte intelligent a terminé avec des erreurs.',
    'smarthost-attach-server-domains.error' => 'Impossible d\'associer les domaines à l\'hôte intelligent',
];