<?php
// Copyright 1999-2024. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "로그 파일",
    'action-log.fromDate' => "소스:",
    'action-log.toDate' => "대상:",
    'action-log.clearLog' => "로그 지우기",
    'action-log.downloadLog' => "다운로드",
    'action-log.loggedActions' => "로그에 기록된 동작",
    'action-log.storeLogsInDb' => "데이터베이스에 레코드 저장",
    'action-log.storeNumber' => "항목",
    'action-log.dontRemoveRecs' => "레코드 제거 안 함",
    'action-log.confirmCleanLog' => "선택한 동작 로그 레코드를 삭제하시겠습니까?",
    'action-log.incorrectDate' => "잘못된 날짜가 지정됨.",
    'action-log.incorrectNumPeriods' => "잘못된 순환 기간이 지정됨.",
    'action-log.incorrectNumRecords' => "잘못된 레코드 수가 지정됨.",
    'action-log.yes' => "예",
    'action-log.no' => "아니오",
    'action-log.mixed' => "(혼합)",
    'action-log.period' => "기간",
    'action-log.invalidDatePeriod' => "잘못된 기간",
    'action-log.submitDone' => "동작 로그 설정의 변경 사항이 저장되었습니다.",
    'action-log.clearDone' => "작업 로그를 지웠습니다.",
    'action-log.periodDay' => "일",
    'action-log.periodWeek' => "주",
    'action-log.periodMonth' => "개월",

    'admin-info.adminInfoSection' => '관리자를 위한 정보',
    'admin-info.description-admin' => '관리자의 설명',
    'admin-info.description-reseller' => '리셀러의 설명',
    'admin-info.description-owner' => '소유자의 설명',
    'admin-info.description' => '설명',
    'admin-info.descriptionSuccess' => '설명이 업데이트되었습니다.',
    'admin-info.longDescription' => '지정한 설명이 너무 깁니다. 길이는 %%max%% 기호를 초과할 수 없습니다.',
    'admin-info.add' => '설명 추가',
    'admin-info.edit' => '편집',
    'admin-info.remove' => '제거',
    'admin-info.confirmOnRemove' => '이 설명을 제거하시겠습니까?',
    'admin-info.popupTitle-customer' => '고객 %%name%%의 %%descriptionType%%',
    'admin-info.popupTitle-reseller' => '리셀러 %%name%%의 %%descriptionType%%',
    'admin-info.popupTitle-subscription' => '구독 %%name%%의 %%descriptionType%%',
    'admin-info.popupTitle-site' => '%%name%%의 %%descriptionType%%',
    'admin-info.popupHint-admin' => '이 설명은 관리자에게만 표시됩니다.',
    'admin-info.popupHint-reseller' => '이 설명은 리셀러와 관리자에게 표시됩니다.',
    'admin-info.popupHint-owner' => '이 설명은 작성자와 작성자의 호스팅 공급자에게 표시됩니다.',
    'admin-info.customerDescriptionHint' => '고객이 이 설명을 볼 수 없습니다.',
    'admin-info.subscriptionDescriptionHint' => "이 정보는 호스팅 공급자(Plesk 관리자 또는 리셀러)에게만 표시됩니다.",

    'apache-settings.formGeneralHint' => '여기서 이 웹 사이트에 대한 Apache 웹 서버 설정을 지정할 수 있습니다. 예를 들어 웹 사이트에서 새로운 유형의 인덱스 파일을 사용하거나 특정 MIME 유형을 특정 파일 이름 확장자와 연결시키려는 경우에 사용자 지정 Apache 구성이 유용합니다. 기본값에서는 Apache가 서버 전체 구성으로부터 해당 지시문을 사용합니다. Apache가 프런트 엔드 서버로 nginx를 이용하여 실행되는 경우, 이 페이지에서 nginx 설정도 지정할 수 있습니다.',
    'apache-settings.general' => '일반 Apache 설정',
    'apache-settings.example' => "예:\n%%example%%",
    'apache-settings.settingOn' => '켜기',
    'apache-settings.settingOff' => '꺼짐(기본값)',
    'apache-settings.settingDefault' => '기본값',
    'apache-settings.settingCustom' => '사용자 지정 값 입력',
    'apache-settings.mimeTypes' => 'MIME 유형',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'MIME 유형은 파일 확장자를 파일 유형과 연결시킵니다. 일반적으로 이 기능은 일반적인 파일 유형에 대해 사용자 지정 파일 확장자를 만들 때 사용됩니다.',
    'apache-settings.handlers' => '처리기',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Apache 처리기는 요청 시 웹 서버가 특정 확장자를 가진 파일을 처리하는 방식을 정의합니다. 예를 들어 문자열 'php-script .script'는 Apache가 .script 파일을 php 스크립트로 처리한다는 것을 의미합니다.",
    'apache-settings.deny' => '사이트 액세스 거부',
    'apache-settings.allow' => '제외',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n지정된 호스트 및 네트워크의 사이트 액세스가 금지되어 있습니다. 모든 연결을 거부하려면 '*'를 사용하십시오.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n지정된 호스트 및 네트워크의 사이트 액세스가 허용됩니다.",
    'apache-settings.directoryIndex' => '인덱스 파일',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "사이트의 인덱스 페이지가 요청되는 경우 Apache가 지정 파일을 찾습니다.",
    'apache-settings.expires' => '만료',
    'apache-settings.expiresStaticOnly' => '정적 파일만 만료 헤더가 있는 응답',
    'apache-settings.expiresFullDescription' => '웹 서버에서 "만료" 응답 헤더를 웹 페이지에 추가합니다. 만료 타임스탬프는 위에 지정된 시간을 웹 페이지를 요청하는 시간에 추가하여 얻을 수 있습니다.',
    'apache-settings.expiresStaticOnlyDescription' => '"만료" 헤더가 정적 파일에만 추가됩니다. 정적으로 처리되는 파일은 "스마트 정적 파일 처리" 및 "nginx에서 직접 정적 파일 처리"에 의해 결정됩니다.',
    'apache-settings.expiresUnitDays' => '일',
    'apache-settings.expiresUnitHours' => '시간',
    'apache-settings.expiresUnitMinutes' => '분',
    'apache-settings.expiresUnitSeconds' => '초',
    'apache-settings.headers' => '추가 헤더',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "웹 서버가 지정된 HTTP 응답 헤더를 추가합니다.",
    'apache-settings.restrictFollowSymLinks' => '기호 링크를 따르는 권한을 제한합니다',
    'apache-settings.restrictFollowSymLinksDescription' => "사용자가 .htaccess에서 FollowSymLink 지시문을 사용하지 못하게 하고 서버 보안을 개선하려면 이 옵션을 선택하십시오.",
    'apache-settings.nginx' => 'nginx 설정',
    'apache-settings.nginxProxyMode' => '프록시 모드',
    'apache-settings.nginxProxyModeDescription' => 'Nginx는 Apache에 대한 요청을 프록시합니다. Apache 사용을 중지하려면 해제하십시오.',
    'apache-settings.nginxTransparentMode' => '지능적 정적 파일 처리',
    'apache-settings.nginxTransparentModeDescription' => '해제된 경우, Apache가 정적 파일에 대한 모든 요청을 처리합니다. nginx는 수정 없이 요청과 응답을 전달만 합니다. 문제 해결을 위해서만 이 옵션을 해제하십시오.',
    'apache-settings.nginxServeStatic' => 'nginx가 직접 정적 파일 제공',
    'apache-settings.nginxStaticExtensions' => '공백 또는 "|" 기호로 구분하여 파일 확장자를 지정하십시오. 이러한 파일에 대한 요청은 nginx에 의해 처리되며 절대 Apache까지 전달되지 않습니다. 주의: Apache 다시 쓰기 규칙은 적용되지 않습니다.',
    'apache-settings.nginxServePhp' => 'nginx로 PHP 처리',
    'apache-settings.nginxServePhpDescription' => 'PHP 파일(.php)은 nginx 및 PHP-FPM에 의해 처리됩니다. 이 설정이 해제되면 Apache가 PHP 파일을 처리합니다.',
    'apache-settings.nginxClientMaxBodySize' => 'HTTP 요청의 본문 최대 크기',
    'apache-settings.nginxClientMaxBodySizeDescription' => '본문이 제한보다 긴 요청은 HTTP 413 Payload Too Large 코드와 함께 취소됩니다("client_max_body_size" nginx 지시문 값 구성).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'panel.ini에서 "clientMaxBodySize" 지시문을 비워놓거나 0으로 설정하면 옵션이 전역에서 비활성화됩니다.',
    'apache-settings.nginxCacheEnabled' => 'nginx 캐싱 활성화',
    'apache-settings.nginxCacheEnabledDescription' => '캐싱을 하면 웹 사이트 응답 시간과 서버 로드를 줄일 수 있기 때문에 주의해서 사용해야 합니다.',
    'apache-settings.nginxCacheSize' => '캐시 크기',
    'apache-settings.nginxCacheSizeGb' => 'GB',
    'apache-settings.nginxCacheSizeMb' => 'MB',
    'apache-settings.nginxCacheSizeKb' => 'KB',
    'apache-settings.nginxCacheSizeBytes' => 'B',
    'apache-settings.nginxCacheTimeout' => '캐시 시간 초과',
    'apache-settings.nginxCacheTimeoutDays' => '일',
    'apache-settings.nginxCacheTimeoutHours' => '시간',
    'apache-settings.nginxCacheTimeoutMinutes' => '분',
    'apache-settings.nginxCacheTimeoutSeconds' => '초',
    'apache-settings.nginxCacheKey' => '캐시 키',
    'apache-settings.nginxCacheCookies' => '쿠키와 함께 캐시 요청',
    'apache-settings.nginxCacheBypassLocations' => '위치 캐시 비활성화',
    'apache-settings.nginxCacheBypass' => '다음 경우에 캐시 무시',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'HTTP no-cache 헤더를 요청에 의해 수신했습니다',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'HTTP 인증 헤더를 요청에 의해 수신했습니다',
    'apache-settings.nginxCacheBypassGetNocache' => 'GET nocache 매개 변수를 요청에 의해 수신했습니다',
    'apache-settings.nginxCacheUseStale' => '부실 캐시 레코드 반환',
    'apache-settings.nginxCacheUseStale5xx' => '업스트림이 5xx 클라이언트 오류 반환',
    'apache-settings.nginxCacheUseStale4xx' => '업스트림이 4xx 클라이언트 오류 반환',
    'apache-settings.nginxCacheUseStaleUpdating' => '캐시 업데이트 중',
    'apache-settings.additional' => '추가 Apache 지시문',
    'apache-settings.additionalSettingsDescription' => '특정 설정을 찾을 수 없는 경우, 아래 필드에 해당 설정을 추가하십시오. 이러한 설정은 서버 전체 Apache 지시문을 무시합니다. 첫 번째 필드의 지시문은 방문자가 HTTP를 통해 사이트에 액세스할 때 사용됩니다. 두 번째 필드에는 HTTPS에 대한 지시문이 포함됩니다. 일반적으로, 두 필드 모두에 지시문을 추가해야 합니다. httpd.include에 사용하는 동일 구문을 사용하십시오. 예를 들어 사용자 지정 오류 페이지를 설정하려면 다음 라인을 추가합니다. ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'HTTP에 대한 추가 지시문',
    'apache-settings.additionalSslSettings' => 'HTTPS에 대한 추가 지시문',
    'apache-settings.additionalSettingsError' => '잘못된 Apache 구성: %%error%%',
    'apache-settings.rollbackFailed' => '잘못된 구성을 포함하고 있어 현재 Apache 구성 파일을 사용하고 이전 파일 버전으로 롤백할 수 없수 없습니다.',
    'apache-settings.additionalNginx' => '추가 nginx 지시문',
    'apache-settings.additionalNginxSettingsDescription' => '여기서 Apache 전방에서 실행되는 nginx 리버스 프록시 서버에 대한 설정을 지정할 수 있습니다. 사용자의 지시문이 서버 전체 nginx 구성을 무시합니다. 예를 들어 연결 시간 초과를 변경하거나 gzip으로 요청을 묶어야 할 수 있습니다. nginx.conf에 사용하는 동일 구문을 사용하십시오. 예를 들어 프록시를 이용한 모든 요청을 gzip으로 묶으려면 다음 라인을 추가합니다. \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => '추가 nginx 지시문',
    'apache-settings.additionalNginxSettingsError' => '잘못된 nginx 구성: %%error%%',
    'apache-settings.nginxRollbackFailed' => '둘 모두 잘못된 구성을 포함하고 있어 현재 nginx 구성 파일을 사용하고 이전 파일 버전으로 롤백할 수 없습니다.',
    'apache-settings.clearCache' => '캐시 지우기',
    'apache-settings.clearCacheHint' => '%%website%%의 nginx 설정 지우기',
    'apache-settings.cacheHasClearedSuccessfuly' => '캐시를 지웠습니다',

    'backup.backup-password-protection.securitySettingsSection' => '백업 보안 설정',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => '원격 저장소 설정에서 암호 가져오기',
    'backup.backup-password-protection.backupPasswordManualInput' => '수동으로 암호 입력',
    'backup.backup-password-protection.providePasswordCheckbox' => '암호 제공',
    'backup.backup-password-protection.backupPassword' => '암호',
    'backup.backup-password-protection.inputPasswordType' => '암호 유형',
    'backup.backup-password-protection.confirmBackupPassword' => '암호 반복',
    'backup.backup-password-protection.backupPasswordHint' => '암호를 잊어버린 경우, 이 옵션을 선택 취소하십시오. 이 경우 일부 민감한 데이터가 올바르게 복원되지 않습니다. 예를 들어 사용자 암호가 무작위 암호로 대체되고, 이미 설치된 APS 응용 프로그램에 관한 정보가 소실됩니다.',
    'backup.backup-password-protection.backupPasswordFtpHint' => '이 백업에 대한 암호 보호를 사용하는 경우, 아래 필드에 암호를 입력합니다. 잘못된 암호를 입력하면, Plesk에서 백업을 복원할 수 없습니다. 대신 백업이 로컬 스토리지에 복사됩니다.',

    'backup.conflict-database.dbMappingLegend' => '데이터베이스 서버 매핑',
    'backup.conflict-database.serverType' => '서버 유형',
    'backup.conflict-database.hostName' => '호스트 이름',
    'backup.conflict-database.port' => '포트',
    'backup.conflict-database.destinationDbServer' => '대상 데이터베이스 서버',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => '데이터베이스를 복원할 수 없습니다. 해당 데이터베이스 서버가 없습니다.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'IP 매핑 파일 업로드',
    'backup.conflict-ip.ipMappingLegend' => 'IP 매핑',
    'backup.conflict-ip.buttonSaveCurrentMapping' => '현재 IP 매핑을 파일로 저장',
    'backup.conflict-ip.ipAddressNotFound' => '이 유형으로 무료의 IP 주소가 없습니다.',
    'backup.conflict-ip.sharedIp' => '공유',
    'backup.conflict-ip.dedicatedIp' => '전용',
    'backup.conflict-ip.fileNotFound' => '파일은 비어 있지 않아야 합니다.',
    'backup.conflict-ip.invalidIpToMap' => '이전 IP 주소에 잘못된 값: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => '새 IP 주소에 잘못된 값: %%ip%%',
    'backup.conflict-ip.ipNotFound' => '데이터베이스에서 IP 주소 %%ip%%를 찾지 못했습니다.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'IP 매핑 파일 업로드',
    'backup.conflict-ip.ipMappingFileHint' => 'IP 매핑 파일은 일반 텍스트 파일입니다. 이 파일의 각 라인에는 다음 형식의 IP 매핑이 포함됩니다. <old IP address> <new IP address>',
    'backup.conflict-ip.oldIp' => '이전 IP 주소',
    'backup.conflict-ip.newIp' => '새 IP 주소',

    'backup.copy-to-server.ignoreBackupSign' => '서명이 유효하지 않은 백업 파일을 업로드합니다.',
    'backup.copy-to-server.wrongPassword' => '잘못된 암호를 지정했습니다. 백업 복원 중, Plesk가 암호를 다시 입력하라는 메시지를 표시합니다.',
    'backup.copy-to-server.corruptedSignatureUploaded' => '업로드된 백업 파일(%%fileName%%)이 백업 서명을 지원하지 않는 다른 서버 또는 기존의 Plesk 버전에서 수정, 손상 및 생성되었습니다. 이 백업 파일에서 데이터를 복원하기 전에 이 파일의 소스를 신뢰할 수 있는지 확인하십시오.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => '백업 파일 %%fileName%%를 업로드할 수 없습니다. 파일에 수정 또는 손상된 데이터가 포함되어 있거나, 다른 서버 또는 기존의 Plesk 버전에서 생성되었습니다. 이 파일에서 데이터를 복원하려면 호스팅 공급자에 문의하십시오.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => '%%fileName%% 백업 파일을 업로드할 수 없습니다. 파일이 백업 서명을 지원하지 않는 다른 서버 또는 기존의 Plesk 버전에서 수정, 손상 및 생성되었습니다. 이 백업을 신뢰하면 "서명이 유효하지 않은 백업 파일 업로드" 옵션을 선택하고 다시 업로드하십시오.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "선택한 백업 %%fileName%%을(를) 서버 스토리지로 이동할 수 없습니다. 오류: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "증분 백업의 다음 부분이 복사되지 않음:%%endl%%%%missedParts%%%%endl%%누락된 부분을 복사해 주십시오.",

    'backup.ftp-settings.isActive' => 'FTP 스토리지 사용',
    'backup.ftp-settings.host' => 'FTP 서버 호스트 이름 또는 IP',
    'backup.ftp-settings.directory' => '백업 파일을 저장할 디렉터리',
    'backup.ftp-settings.directoryHint' => '예: /myfolder/mybackups/',
    'backup.ftp-settings.ftpLogin' => 'FTP 사용자 이름',
    'backup.ftp-settings.ftpPassword' => 'FTP 암호',
    'backup.ftp-settings.usePassiveMode' => '수동 모드 사용',
    'backup.ftp-settings.useFtps' => 'FTPS 사용',
    'backup.ftp-settings.errorHostIsLocal' => '로컬 Plesk의 FTP 서버를 원격 스토리지로 사용하는 것은 금지되어 있습니다. 원격 위치를 지정하십시오.',
    'backup.ftp-settings.warningHostIsLocal' => '구독 파일이 위치한 서버에 백업을 저장하도록 FTP 스토리지 설정이 구성되었습니다. 데이터를 잃거나 디스크 공간을 초과 사용할 위험이 있으므로 이 설정은 권장되지 않습니다.',
    'backup.ftp-settings.enterFtpLogin' => '올바른 사용자 이름을 입력하십시오.',
    'backup.ftp-settings.enterFtpPassword' => '올바른 암호를 입력하십시오.',

    'backup.remote-settings.isActive' => '저장소 사용',
    'backup.remote-settings.initError' => '%%extName%% 설정 페이지를 초기화할 수 없음: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => '백업 보안 설정',

    'backup.restore.detailsSection' => '세부 정보',
    'backup.restore.contentInfoSection' => '백업 내용',
    'backup.restore.restorationOptionsSection' => '복원 옵션',
    'backup.restore.emailNotification' => '복원 작업이 완료되면 알림을 다음으로 보냅니다.',
    'backup.restore.comments' => '주석',
    'backup.restore.creationDate' => '만든 날짜',
    'backup.restore.systemNotes' => '시스템 알림',
    'backup.restore.ownerAdmin' => '관리자에 의해 만들어졌습니다.',
    'backup.restore.ownerReseller' => '리셀러에 의해 만들어졌습니다.',
    'backup.restore.ownerCustomer' => '고객에 의해 만들어졌습니다.',
    'backup.restore.ownerServiceUser' => '보조 사용자에 의해 만들어졌습니다.',
    'backup.restore.partOfParentBackup' => '%%type%% 백업의 일부.',
    'backup.restore.server' => '서버',
    'backup.restore.reseller' => '리셀러',
    'backup.restore.client' => '고객',
    'backup.restore.incremental' => '증분',
    'backup.restore.multiVolume' => '다중 볼륨',
    'backup.restore.backupSize' => '크기',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (이번 추가 사항) + %%base%% (1차 백업) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (이번 추가 사항) + %%prev%% (기존 추가 사항) + %%base%% (1차 백업) = %%total%%',
    'backup.restore.download' => '다운로드',
    'backup.restore.downloadHint' => '백업 파일을 로컬 컴퓨터로 다운로드합니다.',
    'backup.restore.downloadDisabled' => '백업 파일을 일시적으로 다운로드할 수 없습니다. 나중에 다시 시도하거나 서비스 공급자에게 문의하십시오.',
    'backup.restore.copy' => '서버 스토리지에 복사',
    'backup.restore.copyHint' => '선택한 백업 파일을 서버 스토리지에 복사합니다.',
    'backup.restore.contentInfo' => '백업 포함 내용',
    'backup.restore.restoreButton' => '복원',
    'backup.restore.mail' => '메일',
    'backup.restore.domainConfiguration' => '도메인 구성',
    'backup.restore.virtualHost' => '가상 호스트 내용',
    'backup.restore.database' => '데이터베이스',
    'backup.restore.serverConfiguration' => '서버 설정',
    'backup.restore.serverConfigurationLicense' => '라이선스 키',
    'backup.restore.serverPersonalConfiguration' => '관리자 계정 구성',
    'backup.restore.serverPersonalDomains' => '관리자의 도메인',
    'backup.restore.serverPersonalClients' => '관리자의 고객',
    'backup.restore.resellers' => '리셀러',
    'backup.restore.resellerPersonalConfiguration' => '리셀러 계정 구성',
    'backup.restore.resellerPersonalDomains' => '리셀러 도메인',
    'backup.restore.resellerPersonalClients' => '리셀러의 고객',
    'backup.restore.clientPersonalConfiguration' => '고객 계정 구성',
    'backup.restore.clientPersonalDomains' => '고객 도메인',
    'backup.restore.restoreModifiedSection' => '서명이 손상되었지만 백업 파일을 복원합니다.',
    'backup.restore.restoreModifiedDump' => '서명이 유효하지 않지만 이 백업 복원',
    'backup.restore.resolutionPolicy' => '해결 정책',
    'backup.restore.resolutionPolicyDescription' => '복원된 개체가 최근 날짜에 수정된 시스템에 이미 있거나 시스템에 현재 없는 경우 타이밍 충돌이 발생합니다.',
    'backup.restore.backupRestoreFtpWrongPassword' => '잘못된 암호를 지정했습니다. 백업 파일이 서버의 로컬 스토리지에 복사됩니다.',
    'backup.restore.backupRestoreLocalWrongPassword' => '백업을 복원할 수 없습니다. 잘못된 암호를 지정했습니다.',
    'backup.restore.serverContentAndConfiguration' => '서버 구성 및 내용',
    'backup.restore.serverConfigurationOnly' => '서버 구성',
    'backup.restore.resellerContentAndConfiguration' => '리셀러 계정 구성 및 내용',
    'backup.restore.resellerConfigurationOnly' => '리셀러 계정 구성',
    'backup.restore.clientContentAndConfiguration' => '고객 계정 구성 및 내용',
    'backup.restore.clientConfigurationOnly' => '고객 계정 구성',
    'backup.restore.domainContentAndConfiguration' => '도메인 구성 및 내용',
    'backup.restore.domainConfigurationOnly' => '도메인 구성',
    'backup.restore.restoreType' => '복원하시겠습니까?',
    'backup.restore.restoreTypeFull' => '모든 개체(전체 시스템)',
    'backup.restore.restoreTypeGranular' => '선택한 개체',
    'backup.restore.restoreObjectType' => '복원할 개체 유형',
    'backup.restore.restoreObjectTypeSubscriptions' => '구독',
    'backup.restore.restoreObjectTypeCustomers' => '고객',
    'backup.restore.restoreObjectTypeResellers' => '리셀러',
    'backup.restore.restoreObjectTypeMailUsers' => '메일 계정',
    'backup.restore.restoreObjectTypeDatabases' => '데이터베이스',
    'backup.restore.restoreObjectTypeCertificates' => 'SSL/TLS 인증서',
    'backup.restore.restoreObjectTypeSites' => '사이트',
    'backup.restore.restoreObjectTypeDnsZones' => 'DNS 영역',
    'backup.restore.restoreObjectTypeMailLists' => '메일링 리스트',
    'backup.restore.restoreObjectTypeWebContent' => '도메인의 파일',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => '선택한 파일',
    'backup.restore.restoreSubscriptionLookup' => '구독',
    'backup.restore.restoreComponents' => '복원할 구성 요소',
    'backup.restore.errorLog' => '오류 로그',
    'backup.restore.backupDetailsLogDoesntExist' => '백업 로그 사용할 수 없습니다.',
    'backup.restore.dumpFailedSection' => '오류 로그',
    'backup.restore.dumpFailed' => '데이터를 복원할 수 없음: 백업 파일이 유효하지 않습니다.',
    'backup.restore.granularNotSupported' => 'Plesk 12.0 이상에서 만들어진 백업에서 복원할 때만 복원할 개체를 선택할 수 있습니다.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => '리셀러 고급 사용자 보기에서는 백업으로부터 모든 데이터의 복원이 지원되지 않습니다. 복원할 개체를 선택하십시오. %%interfaceLink%%에서 인터페이스 보기를 변경할 수 있습니다.',
    'backup.restore.interfaceLink' => '인터페이스 기본 설정',
    'backup.restore.contentRestoreType' => '복원',
    'backup.restore.contentRestoreTypeSettingsOnly' => '선택한 개체의 구성만',
    'backup.restore.contentRestoreTypeFull' => '선택한 개체의 구성과 내용',
    'backup.restore.errorWrongFormat' => '백업을 복원할 수 없습니다. 파일에 올바르지 않은 서식이 존재합니다.',
    'backup.restore.errorContentError' => '모든 데이터가 복원되지 않습니다: 백업에 콘텐츠 오류가 존재합니다.',
    'backup.restore.warningSignError' => '백업 서명을 확인할 수 없습니다. 백업 파일이 다른 서버 또는 기존 Plesk 버전에서 수정, 손상 및 생성되었을 수 있습니다.',
    'backup.restore.warningSignErrorNotAdmin' => '이 백업은 Plesk 관리자만 복원할 수 있습니다.',
    'backup.restore.warningPartial' => "증분 백업의 다음 부분을 찾을 수 없음:%%endl%%%%missedParts%%%%endl%%복원되지 않은 파일이 있을 수 있습니다. 누락된 부분을 업로드하고 복원을 다시 시도하십시오.",
    'backup.restore.warningDeprecatedBackupVersion' => '복원하려면 백업이 지원되지 않는 Plesk 버전에서 생성되었기 때문에 복원할 수 없습니다. Plesk Migrator 확장을 사용하여 기존 Plesk 버전에서 데이터를 전송합니다.',
    'backup.restore.encryptionKeyError' => '이 백업에서 하나 이상의 계정에 대한 암호를 복원할 수 없으며 초기화됩니다. 이 백업은 다른 Plesk 서버에서 생성되고 해당 암호화 키로 암호화되었을 수 있습니다.',
    'backup.restore.errorCorruptedContent' => '다음 파일이 없거나 손상되었습니다: ',
    'backup.restore.statusSection' => '백업 상태',
    'backup.restore.statusDetails' => '상태 세부 정보',
    'backup.restore.restoreBlocked' => '백업을 복원할 수 없습니다.',
    'backup.restore.restoreBlockedDescription' => '지금은 %%backupType%% 유형의 백업을 복원할 수 없습니다. 이를 복원하려면 백업 소유자로 로그인하고 Backup Manager에서 이 백업 이름을 클릭하십시오.',

    'backup.schedule.scheduleSection' => '예약',
    'backup.schedule.backupEnable' => '이 백업 작업 활성화',
    'backup.schedule.backupPeriod' => '이 백업 작업 실행',
    'backup.schedule.on' => '의',
    'backup.schedule.at' => '시간:',
    'backup.schedule.every' => '반복 단위',
    'backup.schedule.hours' => '{period, plural, other {시간}}',
    'backup.schedule.retainHours' => '시간',
    'backup.schedule.useIncremental' => '증분 백업 사용',
    'backup.schedule.useIncrementalDisableHint' => '선택한 백업 콘텐츠는 전체 백업 생성만 허용됩니다.',
    'backup.schedule.fullBackupPeriod' => '전체 백업 실행',
    'backup.schedule.hourly' => '일정 시간별',
    'backup.schedule.daily' => '매일',
    'backup.schedule.weekly' => '주간',
    'backup.schedule.monthly' => '매월',
    'backup.schedule.yearly' => '매년',
    'backup.schedule.days' => '일',
    'backup.schedule.weeks' => '주',
    'backup.schedule.months' => '개월',
    'backup.schedule.years' => '년',
    'backup.schedule.backupTimeDescription' => '시간대: %%timezone%%.',
    'backup.schedule.systemTimeZone' => '기본 시스템 시간대',
    'backup.schedule.first' => '최초',
    'backup.schedule.last' => '마지막',
    'backup.schedule.dayOfMonth' => '일',
    'backup.schedule.email' => '이 백업 작업을 실행하는 중 오류가 발생하면 다음 주소로 알림 이메일을 보냅니다.',
    'backup.schedule.invalidFields' => '일부 필드가 비어 있거나 잘못된 값이 입력되었습니다: %%fields%%.',
    'backup.schedule.maxDumpFiles' => '저장할 전체 백업 파일의 최대 수(예정된 백업과 수동 백업 모두 포함)',
    'backup.schedule.retainDumpFilesFor' => '전체 백업 유지 기간',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => '전체 백업을 자동으로 제거하지 않으려면 이 필드를 빈 칸으로 남겨두십시오.',
    'backup.schedule.maxDumpFilesLimitedDescription' => '서버 저장소의 호스팅 공급자가 지정하는 제한은 %%max%%입니다. 이 제한은 %%max%%보다 낮거나 같아야 합니다.',
    'backup.schedule.retainLimitedDescription' => '서버 저장소의 호스팅 공급자가 지정하는 제한은 {max, plural, other {전체 백업 #개}}입니다(모든 예약 및 수동 백업 포함).',
    'backup.schedule.backupToCloudIsNotAllowed' => '예정된 구독 백업을 원격 클라우드 스토리지에 저장하는 것은 Plesk 온라인 스토어에서 구입할 수 있는 프리미엄 기능입니다.',
    'backup.schedule.backupHourlyWarning' => '일정 시간별 백업을 활성화하면 서버 리소스 소비가 증가할 수 있습니다.',
    'backup.schedule.titleHourly' => '일정 시간별 백업 설정',
    'backup.schedule.titleDaily' => '일일 백업 설정',
    'backup.schedule.titleWeekly' => '주간 백업 설정',
    'backup.schedule.titleMonthly' => '월간 백업 설정',
    'backup.schedule.titleCustom' => '사용자 지정 백업 설정',

    'backup.secure-backup.hint' => '백업에서 비밀번호를 사용하여 Plesk 데이터베이스에 포함된 사용자의 비밀번호를 암호화할 수 있습니다. 암호를 제공하지 않고 암호로 보호된 백업을 복원하면 Plesk에서 사용자 암호가 무작위로 생성됩니다.',
    'backup.secure-backup.hintAdmin' => 'Plesk 암호화 키 또는 비밀번호로 백업에 포함된 Plesk 데이터베이스 비밀번호를 암호화할 수 있습니다. 키는 각 Plesk 설치마다 고유합니다. 키로 암호화된 백업은 생성된 Plesk 설치에서만 복원할 수 있으며 다른 Plesk 설치에서는 복원할 수 없습니다. Plesk는 백업에서 모든 중요한 데이터를 보호하지 않습니다. 원격 클라우드 스토리지에 백업을 저장하고 클라우드 스토리지에서 백업 암호화를 활성화하는 것이 좋습니다.',
    'backup.secure-backup.usePasswordProtection' => '암호 보호 사용(권장)',
    'backup.secure-backup.backupPasswordSource' => '암호 유형',
    'backup.secure-backup.pleskKey' => 'Plesk의 암호화 키',
    'backup.secure-backup.userPassword' => '지정 암호',
    'backup.secure-backup.password' => '암호',
    'backup.secure-backup.passwordConfirmation' => '암호 반복',

    'backup.subform.settingsSection' => '백업 설정',
    'backup.subform.prefix' => '백업 이름에 접두어 추가',
    'backup.subform.comment' => '주석',
    'backup.subform.splitSize' => '다중 볼륨 백업 만들기, 볼륨 크기(MB)',
    'backup.subform.repository' => '다음 위치에 저장',
    'backup.subform.repositoryDescription' => 'FTP 스토리지 설정이 지정되지 않았습니다. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => '서버 저장소 및 %%name%% 모두',
    'backup.subform.remoteRepositoryOption' => '원격 저장소',
    'backup.subform.remoteRepository' => '원격 저장소',
    'backup.subform.remoteRepositoryText' => '원격 클라우드 저장소 선택',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">원격 저장소를 구성</a>하여 백업을 클라우드에 보관합니다.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">FTP 저장소를 구성</a>하여 백업을 사이트 외부에 보관합니다.',
    'backup.subform.configureRemoteDesc' => '%%link%% 백업을 클라우드에 보관합니다.',
    'backup.subform.configureRemoteLink' => '원격 저장소를 구성하여',
    'backup.subform.configureFtpDesc' => '%%link%% 백업을 사이트 외부에 보관하세요.',
    'backup.subform.configureFtpLink' => 'FTP 저장소를 구성하여',
    'backup.subform.repositoryConfigure' => '구성',
    'backup.subform.email' => '백업 작업이 완료되면 알림 이메일을 다음으로 보냅니다.',
    'backup.subform.contentSection' => '백업 내용',
    'backup.subform.domainConfiguration' => '구성',
    'backup.subform.domainConfigurationVhost' => '사용자 파일 및 데이터베이스',
    'backup.subform.domainConfigurationFile' => '사용자 파일',
    'backup.subform.domainConfigurationDatabase' => '데이터베이스',
    'backup.subform.domainConfigurationMail' => '메일 메시지',
    'backup.subform.content' => '백업',
    'backup.subform.backupAll' => '모든 구성 및 내용',
    'backup.subform.backupConfiguration' => '구성만',
    'backup.subform.backupVhost' => '메일 메시지 외의 모든 구성 및 내용',
    'backup.subform.backupMailFile' => '사용자 데이터베이스 외의 모든 구성 및 콘텐츠',
    'backup.subform.backupMailDatabase' => '사용자 파일 외의 모든 구성 및 콘텐츠',
    'backup.subform.backupMail' => '구성 및 메일 메시지만',
    'backup.subform.backupDatabase' => '구성 및 사용자 데이터베이스만',
    'backup.subform.backupFile' => '구성 및 사용자 파일만',
    'backup.subform.mssqlNativeBackup' => '가능하면 기본 MS SQL 백업 기능을 사용하십시오',
    'backup.subform.mssqlNativeBackupAdmin' => '원시 MS SQL 백업 기능 사용(원격 데이터베이스의 경우, 도구 & 설정> 데이터베이스 서버에서 원격 MS SQL 서버의 백업 설정이 구성되어 있는지 확인하십시오)',
    'backup.subform.localRepository' => '서버 스토리지',
    'backup.subform.localRepositoryPath' => '%%path%%의 서버 스토리지',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'FTP 스토리지%%uri%% <a href="%%link%%">변경 사항 저장</a>',
    'backup.subform.ftpRepositoryText' => 'FTP 스토리지 %%uri%%',
    'backup.subform.type' => '유형',
    'backup.subform.typeFullBackup' => '전체',
    'backup.subform.typeIncremental' => '증분',
    'backup.subform.typeIncrementalDescription' => '마지막 백업 이후 변경된 웹 및 메일 호스팅 데이터를 백업합니다(데이터베이스는 항상 전체 백업됩니다).',
    'backup.subform.incrementalNotAvailable' => '증분 백업을 생성하려면 먼저 전체 백업을 생성하십시오.',
    'backup.subform.excludeLogs' => '로그 파일 제외',
    'backup.subform.excludeFiles' => '백업에서 특정 파일 제외',
    'backup.subform.excludeFilesDescription' => '웹 공간에 있는 파일만 제외할 수 있습니다. 웹 공간 루트에 관련된 경로 또는 경로들을 지정합니다. 개별 파일은 쉼표로 구분합니다. 마스크 기호를 사용할 수 있습니다(예: /somedir/log*).',

    'backup.upload.uploadHint' => '여기서는 백업 파일을 Plesk 스토리지에 업로드할 수 있습니다. 최대 파일 크기가 2 GB로 제한됩니다.',
    'backup.upload.backupFile' => '백업 파일',
    'backup.upload.removeLink' => '제거',
    'backup.upload.addFileLink' => '추가 파일 업로드',
    'backup.upload.backupSecuritySettings' => '백업 보안 설정',
    'backup.upload.signatureHint' => 'Plesk가 백업 파일의 구조 및 서명이 유효한지 확인합니다. 파일이 신뢰되지 않는 다른 서버에서 수정, 손상 또는 생성되었습니다. 아래 옵션은 해당 파일에서 데이터를 복원합니다. 해당 파일의 업로드는 보안을 손상시키거나 서버 작동을 중단시키므로 이 옵션은 백업 소스를 신뢰하는 경우에만 선택하십시오. 참고: 11.5 이전의 Plesk 버전에서 생성된 백업 파일은 서명이 누락되어 있으므로 신뢰되지 않는 것으로 간주됩니다. 소스를 신뢰하는 경우 해당 파일을 복원하십시오.',
    'backup.upload.ignoreSign' => '서명이 유효하지 않은 백업 파일을 업로드합니다.',
    'backup.upload.passwordHint' => '이 백업에 대한 암호 보호를 사용하는 경우, 아래 필드에 암호를 입력합니다. 잘못된 암호를 제공하더라도 Plesk가 경고만 표시하고 백업을 서버로 업로드합니다. 백업 복원 중, 암호를 다시 입력하라는 메시지가 표시됩니다.',
    'backup.upload.alreadyExistsWarning' => '백업 파일 %%fileName%%이(가) 서버의 로컬 스토리지에 이미 존재합니다.',
    'backup.upload.incorrectPasswordWarning' => '잘못된 암호를 지정했습니다. 백업 복원 중, Plesk가 암호를 다시 입력하라는 메시지를 표시합니다.',
    'backup.upload.deprecatedDumpError' => '업로드하려면 백업이 지원되지 않는 Plesk 버전에서 생성되었기 때문에 가져올 수 없습니다. Plesk Migrator 확장을 사용하여 기존 Plesk 버전에서 데이터를 전송합니다.',
    'backup.upload.mailFormatWarning' => '백업 파일 %%fileName%%이(가) 스토리지에 업로드되었습니다. 중요: 지원되지 않는 형식 때문에 복원되지 않을 메일 콘텐츠가 백업 파일 %%fileName%%에 포함되어 있습니다(Plesk 8.3 - 8.6). 이 메일 콘텐츠를 복원하려면 Plesk 백업 도구를 사용하여 백업하고 사서함 내용 백업 옵션을 선택하고, 메일 서버로 복원된 덤프와 함께 이 옵션을 선택하십시오.',
    'backup.upload.corruptedSignatureAdminWarning' => '업로드된 백업 파일(%%fileName%%)이 백업 서명을 지원하지 않는 다른 서버 또는 기존의 Plesk 버전에서 수정, 손상 및 생성되었습니다. 이 백업 파일에서 데이터를 복원하기 전에 이 파일의 소스를 신뢰할 수 있는지 확인하십시오.',
    'backup.upload.corruptedSignatureAdminError' => '백업 파일(%%fileName%%)을 업로드할 수 없습니다. 파일이 백업 서명을 지원하지 않는 다른 서버 또는 기존의 Plesk 버전에서 수정, 손상 및 생성되었습니다. 이 백업을 신뢰하면 "서명이 유효하지 않은 백업 파일 업로드" 옵션을 선택하고 다시 업로드하십시오.',
    'backup.upload.corruptedSignatureUserWarning' => '업로드된 백업 파일(%%fileName%%)에 수정 또는 손상된 데이터가 포함되어 있거나, 다른 서버 또는 기존의 Plesk 버전에서 생성되었습니다.',
    'backup.upload.corruptedSignatureUserError' => '백업 파일(%%fileName%%)을 업로드할 수 없습니다. 파일에 수정 또는 손상된 데이터가 포함되어 있거나, 다른 서버 또는 기존의 Plesk 버전에서 생성되었습니다. 이 파일에서 데이터를 복원하려면 호스팅 공급자에 문의하십시오.',
    'backup.upload.uploadError' => '%%fileName%%을(를) 서버 스토리지로 업로드할 수 없음: %%error%%',
    'backup.upload.fileNotSelected' => '업로드할 파일이 선택되지 않았습니다. 파일을 하나 이상 선택하십시오.',
    'backup.upload.missedPartsWarning' => "증분 백업의 다음 부분이 업로드되지 않음:%%endl%%%%missedParts%%%%endl%%누락된 부분을 업로드해 주십시오.",
    'backup.upload.unknownType' => '알 수 없는 개체 유형',
    'backup.upload.storageLink' => '다른 저장소',
    'backup.upload.anotherStorage' => '덤프가 %%storageLink%%(으)로 업로드되었습니다.덤프가 %%storageLink%%(으)로 업로드되었습니다.',
    'backup.upload.resellerNotFound' => '리셀러 %%name%%을(를) 찾을 수 없습니다. 업로드된 덤프를 복원하려면 먼저 생성하십시오.',
    'backup.upload.clientNotFound' => '고객 %%name%%을(를) 찾을 수 없습니다. 업로드된 덤프를 복원하려면 먼저 생성하십시오.',
    'backup.upload.domainNotFound' => '도메인 %%name%%을(를) 찾을 수 없습니다. 업로드된 덤프를 복원하려면 먼저 생성하십시오.',

    'backup.web-content-dynamic.addButtonTitle' => '파일 추가',
    'backup.web-content-dynamic.noItems' => '선택한 파일 없음',
    'backup.web-content-dynamic.hint' => '확인란을 사용하여 파일과 폴더를 선택합니다.',
    'backup.web-content-dynamic.title' => '파일 선택',
    'backup.web-content-dynamic.columnName' => '이름',
    'backup.web-content-dynamic.columnChangeDate' => '수정됨',
    'backup.web-content-dynamic.columnSize' => '크기',
    'backup.web-content-dynamic.columnPermissions' => '권한',
    'backup.web-content-dynamic.columnUser' => '사용자',
    'backup.web-content-dynamic.columnGroup' => '그룹',
    'backup.web-content-dynamic.waitButtonTitle' => '기다려 주십시오.',
    'backup.web-content-dynamic.loadingTitle' => '기다려 주십시오. 로딩 중...',

    'backup.invalidFields' => '일부 필드가 비어 있거나 잘못된 값이 입력되었습니다.',
    'backup.notEnoughDiskSpace' => '%%path%%에 백업을 생성할 수 있는 디스크 공간이 부족합니다. %%required%%GB 이상의 공간이 필요합니다. (%%available%%GB 사용 가능)',

    'change-subscriptions-owner.ownerSection' => '새 소유자',
    'change-subscriptions-owner.subscriptionsSection' => '선택한 구독',
    'change-subscriptions-owner.owner' => '소유자',
    'change-subscriptions-owner.subscriptionName' => '구독',
    'change-subscriptions-owner.ownerName' => '소유자',
    'change-subscriptions-owner.currentIpAddress' => '현재 IP 주소',
    'change-subscriptions-owner.newIpAddress' => '새 IP 주소',
    'change-subscriptions-owner.noIpAddress' => '이용 가능한 IP 주소 없음',
    'change-subscriptions-owner.submit' => '다시 할당',
    'change-subscriptions-owner.warningCustom' => "구독이 현재 서비스 플랜에서 연결 해제되고 '사용자 지정'이 됩니다.",
    'change-subscriptions-owner.warningEmptyPool' => "새 소유자의 공급자 IP 풀이 비어 있습니다. 풀에 하나 이상의 공급자용 IP 주소가 있는지 확인하십시오.",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, CPU, 디스크I/O',
    'cgroups-settings.cgroupsSettingsTabDescription' => '구독별로 시스템 리소스 사용에 대한 제한을 설정합니다. Plesk는 제어 그룹(cgroup)이라는 Linux 커널 기능을 사용하여 제한을 초과하지 않도록 합니다.',
    'cgroups-settings.cpuSettings' => 'CPU',
    'cgroups-settings.cpuSettingsDescription' => '개별 구독을 지정된 CPU 사용량으로 제한합니다.',
    'cgroups-settings.cpuPeriodLimit' => 'CPU 사용량 확인 간격',
    'cgroups-settings.percentUsageDescription' => '총 CPU 시간이 서버의 %%total%%%%units%%와(과) 같습니다.',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => '개별 구독을 지정된 RAM 사용량으로 제한합니다. 구독이 이 제한을 초과하면 가장 많은 RAM을 사용하는 프로세스가 중지됩니다.',
    'cgroups-settings.ramPeriodLimit' => 'RAM 사용량 확인 간격',
    'cgroups-settings.diskSettings' => '디스크 I/O',
    'cgroups-settings.diskReadSettings' => '디스크 읽기',
    'cgroups-settings.diskReadSettingsDescription' => '개별 구독이 지정된 제한 내에서만 디스크 읽기 대역폭을 사용하도록 허용합니다.',
    'cgroups-settings.diskReadPeriodLimit' => '디스크 읽기 사용량 확인 간격',
    'cgroups-settings.diskWriteSettings' => '디스크 쓰기',
    'cgroups-settings.diskWriteSettingsDescription' => '개별 구독이 지정된 제한 내에서만 디스크 쓰기 대역폭을 사용하도록 허용합니다.',
    'cgroups-settings.diskWritePeriodLimit' => '디스크 쓰기 사용량 확인 간격',
    'cgroups-settings.limit' => '제한',
    'cgroups-settings.threshold' => '초과할 때 알림',
    'cgroups-settings.limitNotificationEnabled' => '알림 활성화',
    'cgroups-settings.periodFiveMinutes' => '5분',
    'cgroups-settings.periodHour' => '1시간',
    'cgroups-settings.periodDay' => '1일(24시간)',
    'cgroups-settings.mb' => 'MB',
    'cgroups-settings.mbs' => 'MB/초',

    'custom-button.privateLabel' => '나에게만 표시',
    'custom-button.textLabel' => '버튼 레이블',
    'custom-button.tooltipLabel' => '도구 설명 텍스트',
    'custom-button.iconLabel' => '백그라운드 이미지',
    'custom-button.priorityLabel' => '우선 순위',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'URL에 매개 변수 추가',
    'custom-button.placeLabel' => '위치',
    'custom-button.internalLabel' => 'Plesk에서 URL 열기',
    'custom-button.internalDescription' => 'Plesk 페이지와 새 브라우저 창 중 어디서 URL을 열지 지정합니다.',
    'custom-button.noFrameLabel' => '프레임을 사용하지 않음',
    'custom-button.noFrameDescription' => '고객 패널의 Plesk 확장 또는 응용 프로그램으로 이어지는 사용자 지정 버튼을 추가하는 경우, 이 확장/응용 프로그램이 표시되는 방식을 지정할 수 있습니다. 즉, 프레임으로 표시하거나 Plesk GUI의 일부로 표시합니다.',
    'custom-button.urlParamLabel_dom_id' => '구독 ID, 도메인 ID 및 도메인 별칭 ID를 포함합니다.',
    'custom-button.urlParamLabel_dom_name' => '기본 도메인 이름 포함',
    'custom-button.urlParamLabel_ftp_user' => 'FTP 사용자 이름 포함',
    'custom-button.urlParamLabel_ftp_pass' => 'FTP 암호 포함',
    'custom-button.urlParamLabel_cl_id' => '고객 ID 포함',
    'custom-button.urlParamLabel_cname' => '고객 회사명 포함',
    'custom-button.urlParamLabel_pname' => '고객 연락처 이름 포함',
    'custom-button.urlParamLabel_email' => '고객 이메일 포함',
    'custom-button.buttonPlace_navigation' => '일반 액세스',
    'custom-button.buttonPlace_admin' => '관리자 홈 페이지',
    'custom-button.buttonPlace_admin-settings' => '관리자 도구 및 설정 페이지',
    'custom-button.buttonPlace_reseller' => "리셀러 홈 페이지",
    'custom-button.buttonPlace_reseller-settings' => '리셀러 도구 및 유틸리티 페이지',
    'custom-button.buttonPlace_client' => '고객 홈 페이지',
    'custom-button.buttonPlace_domain' => "구독 웹 사이트 및 도메인 페이지",
    'custom-button.buttonPlace_domain_powerUser' => "웹 공간 웹 사이트 및 도메인 페이지",
    'custom-button.buttonPlace_domain-properties' => '웹 사이트 도구',

    'database-server-change-password.adminPassword' => '관리자의 암호',
    'database-server-change-password.success' => '관리자 비밀번호가 업데이트되었습니다.',

    'database-server-create.general' => '일반',
    'database-server-create.type' => '데이터베이스 서버 유형',
    'database-server-create.unixSocket' => '(로컬 연결)',
    'database-server-create.host' => '호스트 이름 또는 IP 주소',
    'database-server-create.port' => '포트 번호',
    'database-server-create.portDescription' => '기본 포트 번호를 비워 둠',
    'database-server-create.version' => '데이터베이스 서버 버전',
    'database-server-create.default' => '이 서버를 다음에 대한 기본값으로 사용 %%type%%',
    'database-server-create.externalConnections' => '로컬 MariaDB/MySQL 서버에서 외부 연결을 수락하도록 허용',
    'database-server-create.externalConnectionsDescription' => '이 설정을 변경하면 로컬 MariaDB/MySQL 서버가 다시 시작합니다. Plesk에 등록된 다른 로컬 MariaDB/MySQL 서버로의 원격 액세스를 활성화하려면 구성을 수동으로 변경하십시오.',
    'database-server-create.authentication' => '인증',
    'database-server-create.authenticationAddDescription' => 'Plesk가 데이터베이스 서버에 액세스하는 데 사용할 데이터베이스 관리자의 자격 증명을 지정합니다. 이러한 자격 증명을 갖는 관리자 계정이 데이터베이스 서버에 있어야 합니다.',
    'database-server-create.authenticationEditDescription' => 'Plesk가 데이터베이스 서버에 액세스하는 데 사용하는 자격 증명을 여기서 변경할 수 있습니다. 이러한 자격 증명은 데이터베이스 관리자의 자격 증명과 일치해야 합니다. 예를 들어, 데이터베이스 서버에서 관리자의 자격 증명을 변경한 후에는 Plesk에서도 마찬가지로 자격 증명을 변경해야 합니다.',
    'database-server-create.authenticationChangeDescription' => 'Plesk가 데이터베이스 서버에 액세스하는 데 사용하는 자격 증명을 여기서 변경할 수 있습니다. 아래에서 사용자 이름 또는 암호를 변경하면 관리자 권한을 갖는 데이터베이스 사용자 계정이 데이터베이스 서버와 Plesk에서 모두 업데이트됩니다.',
    'database-server-create.adminLogin' => '사용자 이름',
    'database-server-create.adminPassword' => '암호',
    'database-server-create.createSuccess' => '데이터베이스 서버가 생성되었습니다.',
    'database-server-create.createError' => '데이터베이스 서버가 생성되었으나 오류가 발생했습니다: %%error%%',
    'database-server-create.updateSuccess' => '데이터베이스 서버가 업데이트되었습니다.',
    'database-server-create.updateError' => '데이터베이스 서버가 업데이트되었으나 오류가 발생했습니다: %%error%%',
    'database-server-create.backupSettings' => '백업',
    'database-server-create.backupTempDir' => '임시 디렉터리',
    'database-server-create.backupTempDirDescription' => 'MS SQL 서버가 위치하는 원격 서버상의 실제 폴더에 대한 경로. 임시 백업 파일을 읽고 쓰려면 MS SQL 서버가 이 폴더에 액세스할 수 있어야 합니다. 예: C:\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => '임시 네트워크 디렉터리',
    'database-server-create.backupNetworkTempDirDescription' => '위에 지정된 실제 폴더로 네트워크 공유 경로가 매핑되었습니다. Plesk는 백업 파일을 다운로드 및 업로드할 때 공유 폴더에 액세스합니다. 예: \\\\ServerName\\DirectoryPath',
    'database-server-create.backupNetworkUser' => '사용자 이름',
    'database-server-create.backupNetworkUserDescription' => '원격 서버에서 생성된 네트워크 사용자의 사용자 이름. 예: ServerName\\UserName. 사용자는 위에 지정된 공유 폴더에 액세스할 수 있어야 합니다.',
    'database-server-create.backupNetworkPassword' => '암호',

    'domain.connection-info.title' => '연결 정보',
    'domain.connection-info.systemUserCredentials' => '시스템 사용자 자격 증명',
    'domain.connection-info.systemUserCredentialsHint' => 'FTP를 통한 액세스는 항상 활성화되어 있으며, SSH 또는 원격 데스크톱을 통한 액세스는 %%details%%의 경우에만 가능합니다.',
    'domain.connection-info.systemUserCredentialsHintDetails' => '권한이 부여되었습니다',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'SSH 또는 원격 데스크톱 액세스가 활성화되어 있으며 해당 상태를 관리할 수 없습니다.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'SSH 또는 원격 데스크톱 액세스가 비활성화되어 있으며 해당 상태를 관리할 수 없습니다.',
    'domain.connection-info.ipAddress' => 'IP 주소',
    'domain.connection-info.username' => '사용자 이름',
    'domain.connection-info.password' => '암호',
    'domain.connection-info.changeSystemUserPasswordTitle' => '시스템 사용자 암호 변경',
    'domain.connection-info.changePasswordTooltip' => '암호 변경',
    'domain.connection-info.newPassword' => '새 암호',
    'domain.connection-info.manageAccess' => '액세스 관리',
    'domain.connection-info.additionalFtpAccounts' => '추가 FTP 계정',
    'domain.connection-info.database' => '데이터베이스',
    'domain.connection-info.databaseHint' => '구독에 속한 %%number%% 데이터베이스 중 1',
    'domain.connection-info.databaseNotCreatedHint' => '데이터베이스가 만들어지지 않았습니다.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL 서버',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => '호스트',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => '데이터베이스 이름',
    'domain.connection-info.addDatabase' => '데이터베이스 추가',
    'domain.connection-info.manageDatabases' => '데이터베이스를 관리',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => '데이터베이스 사용자 암호 변경',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => '여기에서 변경한 후 애플리케이션의 구성 파일에서 암호를 업데이트하는 것을 잊지 마십시오.',
    'domain.connection-info.buttonSave' => '저장',
    'domain.connection-info.buttonSaving' => '저장 중...',
    'domain.connection-info.buttonCancel' => '취소',

    'domain.move.title' => '%%name%% 도메인 이동',
    'domain.move.hint' => '도메인이 내용, 구성 파일, 로그 파일, APS 애플리케이션과 함께 새 구독으로 이동합니다.',
    'domain.move.hintMain' => '도메인이 내용, 구성 파일, 로그 파일, 데이터베이스, 데이터베이스 사용자, 추가 FTP 사용자, 예정된 작업, SMB 사용자, APS 애플리케이션과 함께 새 구독으로 이동합니다.',
    'domain.move.hintSubdomains' => '%%subdomains%% 하위 도메인이 부모 도메인과 함께 이동합니다.',
    'domain.move.hintAliases' => '%%aliases%% 도메인 별칭이 부모 도메인과 함께 이동합니다.',
    'domain.move.hintSubdomainsAndAliases' => '%%subdomains%% 하위 도메인과 %%aliases%% 도메인 별칭이 부모 도메인과 함께 이동합니다.',
    'domain.move.labelDatabases' => '도메인을 이동한 후 "데이터베이스" 탭을 열고 관련 데이터베이스를 이동합니다.',
    'domain.move.hintDatabases' => '필요한 경우, 데이터베이스를 별도로 이동하십시오.',

    'domain.move.Form.submitButton' => '이동',
    'domain.move.Form.cancelButton' => '취소',

    'domain.move.selectTarget' => '사용할 수 있는 구독',
    'domain.move.nothingFound' => '찾지 못함',
    'domain.move.targetIsRequred' => '도메인을 이동할 하위 도메인을 선택합니다.',
    'domain.move.selectNewSubscription' => '새 구독 생성',
    'domain.move.ipv4Address' => 'IPv4 주소',
    'domain.move.ipv4AddressHint' => '웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.',
    'domain.move.ipv6Address' => 'IPv6 주소',
    'domain.move.ipv6AddressHint' => '웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.',
    'domain.move.ipAddressIsNotSelected' => 'IP 주소를 하나 이상 선택해야 합니다.',
    'domain.move.username' => '사용자 이름',
    'domain.move.usernameHint' => '시스템 사용자 계정이 웹 공간과 연결되어 있습니다. FTP 및 SSH를 통해 호스팅된 파일에 액세스하는 데 사용됩니다.',
    'domain.move.usernameIsRequred' => '사용자 이름을 입력해야 합니다.',
    'domain.move.password' => '암호',
    'domain.move.passwordIsRequred' => '암호를 입력해야 합니다.',
    'domain.move.noAvailableSubscriptions' => '사용할 수 있는 구독 없음',
    'domain.move.noWebHosting' => '도메인에 웹 호스팅이 없기 때문에 지금은 시스템 사용자가 지금 생성되지 않습니다.',

    'domain.rename.title' => '도메인 이름 변경',
    'domain.rename.titleAlias' => '도메인 별칭 이름 변경',
    'domain.rename.hint' => '이제 도메인 이름 %%domainName%%을(를) 변경합니다.',
    'domain.rename.hintAlias' => '이제 도메인 별칭 이름 %%domainName%%을(를) 변경합니다.',
    'domain.rename.name' => '새로운 도메인 이름',
    'domain.rename.nameAlias' => '새로운 도메인 별칭 이름',
    'domain.rename.domainNameIsRequired' => '이 필수 필드가 비어 있습니다. 값을 지정해야 합니다.',
    'domain.rename.submitButton' => '변경',
    'domain.rename.submitButtonProgress' => '변경 중',
    'domain.rename.successMessage' => '%%oldName%% 도메인 이름이 %%newName%%(으)로 변경되었습니다.',
    'domain.rename.successMessageAlias' => '%%oldName%% 도메인 별칭 이름이 %%newName%%(으)로 변경되었습니다.',

    'domain.rename.Form.cancelButton' => '취소',

    'domain.outgoing-messages.hint' => '여기서 이 도메인에 대해 발신 메시지의 수 제한을 변경할 수 있습니다. 지정된 제한 이상의 메시지를 보낼 수 없게 됩니다.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => '기본값(시간당 %%domainOutgoingMessages%% 메시지)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => '시간당 메시지 수',
    'domain.outgoing-messages.domainOutgoingMessages' => '발신 메시지에 대한 제한',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => '이 도메인에 대한 사용자 지정 값',

    'domain.tech-domain-name.title' => '도메인 이름 선택',
    'domain.tech-domain-name.techDomainTitle' => '임시 도메인 이름',
    'domain.tech-domain-name.customDomainTitle' => '도메인 이름 등록',
    'domain.tech-domain-name.techDomainText' => '아직 등록된 도메인 이름이 없습니다.',
    'domain.tech-domain-name.customDomainText' => '이미 등록된 도메인 이름이 있습니다.',
    'domain.tech-domain-name.techDomain' => '임시 도메인 이름',
    'domain.tech-domain-name.customDomain' => '도메인 이름 등록',
    'domain.tech-domain-name.domainName' => '도메인 이름',
    'domain.tech-domain-name.techDomainDesc' => '임시 도메인 이름은 적절한 도메인 이름을 등록하고 구매하기에 앞서 사이트에 액세스하는 데 사용됩니다. 다음 조건에서 무료로 제공됩니다.',
    'domain.tech-domain-name.techDomainRandom' => '이름은 무작위로 생성됩니다.',
    'domain.tech-domain-name.techDomainDns' => '.plesk.page DNS 영역에서 호스팅됩니다.',
    'domain.tech-domain-name.techDomainSwitch' => '도메인 설정에서 도메인 이름을 변경하여 나중에 언제든지 등록된 도메인 이름으로 전환할 수 있습니다.',
    'domain.tech-domain-name.error' => '예상치 못한 오류가 발생했습니다.',
    'domain.tech-domain-name.errorNoIpAddress' => 'IP 주소를 선택해야 합니다.',
    'domain.tech-domain-name.generating' => '생성 중...',

    'get-password.label' => '암호 재설정',
    'get-password.text' => '이메일 주소 또는 Plesk에 등록된 사용자 이름을 입력하면 암호 재설정 이메일을 보내드립니다.',
    'get-password.emailLabel' => '이메일 주소',
    'get-password.loginLabel' => '사용자 이름',
    'get-password.send' => '보내기',
    'get-password.cancel' => '취소',
    'get-password.errorInvalidEmail' => '이메일 주소를 알 수 없습니다. 다시 확인한 후 시도하십시오.',
    'get-password.messageSend' => "비밀번호 재설정 이메일이 관련 이메일 주소로 전송되었습니다.\n이메일이 도착하지 않으면 Plesk 관리자에게 문의하십시오.",

    'iis-settings.formGeneralHint' => '여기서 기본값을 변경하여 해당 웹 사이트에 대한 IIS 웹 서버 설정을 지정할 수 있습니다. 예를 들어 웹 사이트에서 새로운 유형의 인덱스 파일을 사용하거나 특정 MIME 유형을 특정 파일 이름 확장자와 연결시키려는 경우에 사용자 지정 IIS 구성이 유용합니다. 기본값은 호스팅 공급자가 정의합니다.',
    'iis-settings.formGeneralHint_powerUser' => '여기서 이 웹 사이트에 대한 IIS 웹 서버 설정을 지정할 수 있습니다. 예를 들어 웹 사이트에서 새로운 유형의 인덱스 파일을 사용하거나 특정 MIME 유형을 특정 파일 이름 확장자와 연결시키려는 경우에 사용자 지정 IIS 구성이 유용합니다. 기본값에서 IIS는 기본 구성의 해당 지시문을 사용합니다.',
    'iis-settings.virtualDirectoryLoadError' => '지정된 가상 디렉터리의 속성을 가져올 수 없음: %%errorMessage%%',
    'iis-settings.general' => '일반 설정',
    'iis-settings.example' => "예:\n%%example%%",
    'iis-settings.settingOn' => '켜기',
    'iis-settings.settingOff' => '꺼짐(기본값)',
    'iis-settings.settingDefault' => '기본값',
    'iis-settings.settingCustom' => '사용자 지정 값 입력',
    'iis-settings.mimeTypes' => 'MIME 유형',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'MIME 유형은 파일 확장자를 파일 유형과 연결시킵니다. 일반적으로 이 기능은 일반적인 파일 유형에 대해 사용자 지정 파일 확장자를 만들 때 사용됩니다.',
    'iis-settings.documents' => '기본 문서',
    'iis-settings.documentsOff' => '비활성화됨',
    'iis-settings.documentsCustom' => '값 입력',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => '브라우저가 사이트 내에서 문서 이름을 제공하지 않는 경우, IIS가 지정된 기본 문서를 찾고 발견된 첫 문서를 서비스합니다. 기본 문서를 지정하지 않으면서 디렉터리 탐색의 사용을 설정하는 경우, 디렉터리 목록이 인덱스 페이지 대신 브라우저에 표시됩니다.',
    'iis-settings.expires' => '만료',
    'iis-settings.expiresFullDescription' => '웹 서버에서 "만료" 응답 헤더를 웹 페이지에 추가합니다. 만료 타임스탬프는 위에 지정된 시간을 웹 페이지를 요청하는 시간에 추가하여 얻을 수 있습니다.',
    'iis-settings.expiresUnitDays' => '일',
    'iis-settings.expiresUnitHours' => '시간',
    'iis-settings.expiresUnitMinutes' => '분',
    'iis-settings.expiresUnitSeconds' => '초',
    'iis-settings.headers' => '추가 헤더',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => '웹 서버가 지정된 HTTP 응답 헤더를 추가합니다.',
    'iis-settings.directoryBrowsing' => '디렉터리 탐색',
    'iis-settings.directoryBrowsingDescription' => '예를 들어 기본 인덱스 페이지를 이용할 수 없을 때 사용자가 웹 브라우저에서 사이트의 디렉터리 목록을 볼 수 있도록 허용합니다.',
    'iis-settings.securityTabDirectory' => '디렉터리 보안 설정',
    'iis-settings.allowAnonymous' => '익명 인증',
    'iis-settings.allowAnonymousDescription' => '익명 인증을  통해 사용자는 사이트의 공용 콘텐츠에 액세스할 수 있습니다. 암호로 보호된 사이트 콘텐츠와 파일, 시스템 수준에서 보호된 콘텐츠는 익명 사용자에게 제공되지 않습니다.',
    'iis-settings.allowWindows' => 'Windows 인증',
    'iis-settings.allowWindowsDescription' => 'Windows 인증(이전 명칭 NTLM)이 파일 시스템 수준에서 사이트 내용을 보호합니다.',
    'iis-settings.requireSsl' => 'SSL/TLS 필요',
    'iis-settings.requireSslDescription' => '사이트에 SSL/TLS 지원을 사용하도록 설정한 경우, 이 옵션으로 웹 클라이언트(브라우저)는 보안 HTTPS 연결만 사용합니다.',
    'iis-settings.securityTabIpDeny' => '액세스 제한 설정',
    'iis-settings.deny' => '사이트 액세스 거부',
    'iis-settings.denyOff' => '기본값',
    'iis-settings.denyCustom' => '사용자 지정 값 입력',
    'iis-settings.allow' => '제외',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\n지정된 호스트 및 네트워크의 사이트 액세스가 금지되어 있습니다. 모든 연결을 거부하려면 '*'를 사용하십시오.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\n지정된 호스트 및 네트워크의 사이트 액세스가 허용됩니다.",
    'iis-settings.dynamicIpSecurity' => 'IIS 동적 IP 제한을 통한 DoS 공격 방지',
    'iis-settings.isDenyByConcurrentRequests' => '고유 IP 주소로부터 동시 요청 수에 근거하여 IP 주소 거부',
    'iis-settings.maxConcurrentRequests' => '최대 동시 요청 수',
    'iis-settings.isDenyByRequestRate' => '일정 기간 동안 요청 수에 근거하여 IP 주소 거부',
    'iis-settings.maxRequests' => '최대 요청 수',
    'iis-settings.requestInterval' => '기간(ms)',

    'ip-addresses-selector.ipAddress' => 'IP 주소',
    'ip-addresses-selector.ipv4Address' => 'IPv4 주소',
    'ip-addresses-selector.ipv4AddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'ip-addresses-selector.ipv6Address' => 'IPv6 주소',
    'ip-addresses-selector.ipv6AddressHint' => "웹 사이트의 호스팅에 이용된 IP 주소가 웹 사이트 가상 호스트의 네트워크 주소입니다.",
    'ip-addresses-selector.noIpAddressHint' => '없음',
    'ip-addresses-selector.shared' => '공유',
    'ip-addresses-selector.exclusive' => '전용',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'FTP 서버가 IPv6을 지원하지 않습니다. IPv4 주소를 하나 이상 할당하십시오. 그렇지 않으면 사용자가 FTP를 통해 서버에 파일을 업로드할 수 없습니다.',

    'license-key-revert.description' => '다음 속성을 가진 라이선스 키가 복원됨:',
    'license-key-revert.submitButton' => '롤백',

    'license-key-upload.description' => '인증 코드를 입력하여 라이선스 키를 설치할 수 있습니다.',
    'license-key-upload.descriptionWithFileUpload' => '활성화 코드를 입력하거나 라이선스 키 파일을 업로드하여 라이선스 키를 설치할 수 있습니다.',
    'license-key-upload.type' => '다음 중 한 가지 선택:',
    'license-key-upload.code' => '활성화 코드 입력',
    'license-key-upload.codeDescription' => '받은 활성화 코드를 붙여 넣습니다.',
    'license-key-upload.file' => '라이선스 키 파일을 업로드합니다.',
    'license-key-upload.fileDescription' => '라이선스 키가 포함된 파일의 경로를 지정합니다.',
    'license-key-upload.submitButton' => '설치',

    'log-rotation.customLogsDescription' => '사용자 지정 로그는 순환되지 않습니다.',
    'log-rotation.logRotation' => '로그 순환',
    'log-rotation.logRotationCondition' => '로그 순환 조건',
    'log-rotation.logRotationBySize' => '크기 기준',
    'log-rotation.logRotationByTime' => '시간 기준',
    'log-rotation.logRotationDaily' => '매일',
    'log-rotation.logRotationWeekly' => '주간',
    'log-rotation.logRotationMonthly' => '매월',
    'log-rotation.logRotationSizeDescription' => '크기 값은 %%min%%~%%max%%KB 사이여야 합니다.',
    'log-rotation.maximumNumberOfFiles' => '로그 파일 최대 수',
    'log-rotation.compress' => '로그 파일 압축',
    'log-rotation.sendLogToEmail' => 'Plesk가 웹 및 FTP 서버의 로그 파일에서 데이터를 검색하면 이 주소에 로그 파일을 이메일로 보내기',
    'log-rotation.kb' => 'KB',
    'log-rotation.logRotationPeriodGreater' => '기간은 서버 전체의 제한값 %%max%%보다 길 수 없습니다.',

    'login.loginLabel' => '사용자 이름',
    'login.passwdLabel' => '암호',
    'login.localeLabel' => '인터페이스 언어',
    'login.defaultLocale' => '기본값',
    'login.loginButtonLabel' => '로그인',
    'login.enterUsername' => '사용자 이름을 입력하십시오.',
    'login.enterPassword' => '암호를 입력하십시오.',
    'login.whatUsernamePassword' => '사용할 사용자 이름과 암호는 무엇입니까?',
    'login.forgotPasswordLabel' => '암호를 잊으셨습니까?',
    'login.cookies' => 'Plesk의 쿠키 정책',
    'login.avoidSSLWarningsMsg' => 'Plesk 로그인 시 SSL 경고를 방지하려면 %%link%%를 사용하십시오.',
    'login.digitalOceanMsg' => 'DigitalOcean에서 Plesk 사용이 처음입니까? "루트"를 써서 이 물방울을 생성할 때 입력한 암호를 사용하여 로그인하십시오. %%link%%',
    'login.amazonLightsailMsg' => 'Lightsail에서 Plesk 사용이 처음입니까? Plesk에 로그인하려면 SSH를 통해 서버에 액세스하여 "plesk login" 명령을 사용합니다. %%link%%',
    'login.readGuide' => '전체 가이드를 읽으십시오.',
    'login.mobileApplicationMessage' => '더 나은 경험을 위해서는 %%name%% 응용 프로그램을 설치하는 것이 좋습니다.',
    'login.mobileApplicationInstall' => '지금 설치',
    'login.mobileApplicationHide' => '괜찮습니다.',

    'force-reset-password.saveButton' => '저장',
    'force-reset-password.title' => '암호 변경',
    'force-reset-password.passwordLabel' => '새 암호',

    'panel-access.title' => '맞춤화 Plesk URL',
    'panel-access.hint' => 'Plesk에 로그인할 사용자 지정 URL을 선택합니다. 이 방법은 %%httpsPort%% 포트를 통해 로그인할 가능성을 없애지 않습니다. %%link%%',
    'panel-access.details' => '자세한 내용',
    'panel-access.proxyEnabled' => '서버 IP 주소로 확인되지만 호스팅에 사용되지 않는 모든 도메인과 하위 도메인',
    'panel-access.proxyDomain' => '서버 IP 주소로 확인되지만 호스팅에 사용되지 않는 지정한 도메인 또는 하위 도메인',
    'panel-access.proxyDisabled' => '사용자 지정 URL 없음. https://만 해당<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => '저장',
    'panel-access.Form.cancelButton' => '취소',

    'panel-access.domainNameIsRequired' => '도메인 이름을 입력해야 합니다.',
    'panel-access.successMessage' => '선택한 로그인 방법이 적용되었습니다.',
    'panel-access.notSupported' => '귀하의 Plesk는 선택한 로그인 방법을 지원하지 않습니다.',
    'panel-access.notViaDomainName' => '이 로그인 방법을 적용하려면, 첫 번째 옵션("모든 도메인 및 하위 도메인...")을 선택하여 https://%%domainName%% 링크를 통해 Plesk로 로그인한 다음 두 번째 옵션을 선택하십시오.',
    'panel-access.notViaPort' => '이 로그인 방법을 적용하려면, https:// 링크를 통해 Plesk로 로그인하십시오.<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => '성능 및 보안 설정',
    'php-settings.settings' => '일반 설정',
    'php-settings.fastCgiSettings' => 'FastCGI 설정',
    'php-settings.fpmSettings' => 'PHP-FPM 설정',
    'php-settings.enableFastcgi' => 'FastCGI 설정 활성화',
    'php-settings.plainTextEditing' => '추가 지시문',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'PHP 매개 변수를 아래 필드에 입력하여 정의할 수 있습니다. 지시문이 PHP 구성에 포함됩니다. php.ini에서 사용하는 동일한 구문을 사용합니다. 예를 들어, mSQL 확장을 자동으로 로드하려면 extension=msql.so 라인을 추가합니다.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => '특정 PHP 매개 변수를 찾을 수 없는 경우, 아래 필드에 해당 매개 변수를 추가하십시오. 이러한 추가 지시문은 주 서비스 플랜의 지시문과 병합됩니다. php.ini에 대해 사용하는 동일 구문을 사용하십시오. 예를 들어, mSQL 확장을 자동으로 로드하려면 다음 라인을 추가하십시오. extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'PHP 매개 변수를 아래 필드에 입력하여 정의할 수 있습니다. 지시문이 PHP 구성에 포함됩니다. php.ini에서 사용하는 동일한 구문을 사용합니다. 예를 들어, mSQL 확장을 자동으로 로드하려면 extension=msql.so 라인을 추가합니다. PHP-FPM 풀 설정을 사용자 정의하려면 [php-fpm-pool-settings] 구분 기호를 추가하고 원하는 설정을 아래에 입력합니다.',
    'php-settings.additionalConfigurationDirectives' => '추가 구성 지시문',
    'php-settings.defaultValue' => '기본값',
    'php-settings.predefinedValue' => '값 선택',
    'php-settings.customValue' => '사용자 지정 값 입력',
    'php-settings.phpSettingDescription_memory_limit' => '스크립트가 할당할 수 있는 최대 허용 메모리(바이트).',
    'php-settings.phpSettingDescription_max_execution_time' => '스크립트가 종료되기 전에 실행이 허용되는 최대 시간(초).',
    'php-settings.phpSettingDescription_max_input_time' => '스크립트가 입력 데이터를 구문 분석하는 데 허용되는 최대 시간(초).',
    'php-settings.phpSettingDescription_post_max_size' => 'POST 메서드로 게시할 수 있는 최대 데이터 크기(바이트). 대개 upload_max_filesize보다 크고 memory_limit보다 작아야 합니다.',
    'php-settings.phpSettingDescription_upload_max_filesize' => '업로드 파일의 최대 크기(바이트).',
    'php-settings.phpSettingDescription_safe_mode' => 'PHP 안전 모드에서는 주로 보안상의 이유로 다양한 제한을 스크립트에 적용합니다.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => '지정된 디렉터리의 파일은 safe_mode 지시문이 활성화된 경우 PHP 스크립트로 액세스할 수 있습니다. 이 디렉터리는 또한 include_path에 있어야 합니다.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => '지정된 디렉터리의 프로그램은 safe_mode 지시문이 활성화된 경우 PHP 스크립트로 실행됩니다.',
    'php-settings.phpSettingDescription_include_path' => '스크립트가 파일을 찾는 디렉터리 목록(시스템의 PATH 변수와 유사함). 디렉터리를 구분하려면 Linux에서는 콜론(:), Windows에서는 세미콜론(;)을 사용하십시오.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'PHP 세션 파일을 저장하는 디렉터리.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'mail() 함수에 대한 추가 매개 변수.',
    'php-settings.phpSettingDescription_register_globals' => 'EGPCS(Environment, GET, POST, Cookie, Server) 변수의 내용을 전역 변수로 등록합니다.',
    'php-settings.phpSettingDescription_open_basedir' => '지정된 디렉터리의 파일은 PHP 스크립트로 액세스할 수 있습니다. 디렉터리를 구분하려면 Linux에서는 콜론(:), Windows에서는 세미콜론(;)을 사용하십시오.',
    'php-settings.phpSettingDescription_error_reporting' => '오류 보고 수준.',
    'php-settings.phpSettingDescription_display_errors' => '오류를 출력과 함께 화면에 표시할지 여부를 지정합니다.',
    'php-settings.phpSettingDescription_log_errors' => 'PHP 오류를 로깅할 수 있습니다.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'PHP 파일 기능이 FTP 또는 HTTP를 통해 원격 위치의 데이터를 검색하도록 허용합니다.',
    'php-settings.phpSettingDescription_file_uploads' => 'HTTP를 통한 파일 업로드를 허용합니다.',
    'php-settings.phpSettingDescription_short_open_tag' => 'PHP의 열려 있는 태그의 약식 ()를 허용합니다.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'GPC(Get/Post/Cookie) 작업의 magic_quotes 상태를 설정합니다. magic_quotes가 설정되면 작은 따옴표, 큰 따옴표, 백슬래시 및 NULL 특수 문자가 모두 백슬래시로 자동 이스케이프 처리됩니다.',
    'php-settings.phpSettingDescription_disable_functions' => '이 지시문을 사용하면 특정 기능을 비활성화할 수 있습니다. 콤마로 분리된 기능 이름 목록입니다.',
    'php-settings.phpSupport' => 'PHP 지원',
    'php-settings.phpRunAs' => 'PHP를 다음으로 실행',
    'php-settings.phpVersion' => 'PHP 버전',
    'php-settings.phpHandlerOutdated' => '(기한 초과)',
    'php-settings.phpHandlerDeprecated' => '(사용되지 않음)',
    'php-settings.phpServedByApache' => 'Apache에 의해 서비스됨',
    'php-settings.phpServedByNginx' => 'nginx에 의해 서비스됨',
    'php-settings.phpSettingsPhpVersion' => '해당 PHP 버전은 %%version%%입니다.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP가 해제되었습니다.',
    'php-settings.phpHandlerTypeHint' => '다음은 웹 사이트의 PHP 구성에 관한 세부 정보입니다. 호스팅 공급자가 해당 권한을 부여한 경우 PHP 구성을 변경할 수 있습니다.',
    'php-settings.fpmDedicatedHandlerHint' => '이 처리기를 사용하면 웹사이트의 안정성이 향상되지만 추가 메모리 소비가 발생합니다.',
    'php-settings.phpHandlerChangeHint' => 'PHP 처리기 설정을 변경했습니다. 이러한 변경 사항을 저장하면 서버 구성으로 인해 웹사이트의 PHP 스크립트가 %%interval%%초간 중지될 수 있습니다.',
    'php-settings.phpHandlerOutdatedHint' => '새 PHP 버전을 이용할 수 있는지 확인하려면, %%link%% 제품 구성 요소의 "웹 호스팅" 카테고리를 확인하십시오.',
    'php-settings.phpHandlerOutdatedHintLink' => 'plesk 설치 프로그램을 열고',
    'php-settings.phpHandlerTypeHelpLink' => '가장 적합한 PHP 설정 선택 방법 알아보기',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'PHP 지원은 이 도메인에 사용할 수 있는 PHP 버전이 현재 호스팅 구성에 없기 때문에 활성화할 수 없습니다.',
    'php-settings.phpHandlersNotAvailableHint' => '현재 Plesk 구성에 사용할 수 있는 PHP 버전이 없기 때문에 PHP 지원을 활성화할 수 없습니다.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => '다른 PHP 버전을 활성화하는 방법을 확인하십시오.',
    'php-settings.phpSupportEditable' => '(PHP 버전 %%version%%, PHP를 %%handler%%로 실행) %%link%%',
    'php-settings.phpSupportReadonly' => '(버전: %%version%%; 처리기: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(등록되지 않음) %%link%%',
    'php-settings.showPhpInfo' => 'phpinfo() 페이지 보기',
    'php-settings.phpSettingsFormError' => '필요한 데이터가 없어 PHP 설정을 검색할 수 없습니다.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => '해당 PHP 버전이 설치되지 않아 PHP 설정을 가져올 수 없습니다. 계속하려면 선택한 PHP 버전을 설치하거나 도메인에서 사용할 다른 버전을 선택하십시오.',
    'php-settings.showPhpInfoTitle' => 'phpinfo() 보기',
    'php-settings.showPhpInfoDescription' => '일부 PHP 설정이 변경되었지만 변경 사항은 아직 저장되지 않았습니다. phpinfo() 페이지에서 새 값을 보려면 먼저 변경 사항을 적용하십시오. 그렇지 않으면 현재 값이 표시됩니다.',
    'php-settings.showPhpInfoButton' => 'phpinfo() 보기',
    'php-settings.onState' => '켜기',
    'php-settings.offState' => '끄기',
    'php-settings.description' => '이 페이지는 웹 사이트에 대한 PHP 구성을 표시합니다. 이 설정은 웹 사이트에 한해 유효하며 구독 상의 다른 웹 사이트에 영향을 미치지 않습니다. 호스팅 공급자가 해당 권한을 부여한 경우 PHP 구성을 변경할 수 있습니다. PHP 스크립트를 통해 시스템 리소스 사용을 제한하거나 특정 웹 응용 프로그램의 요구 사항을 충족하려는 경우 사용자 지정 PHP 구성이 유용할 수 있습니다. 매개 변수를 기본값으로 설정하면 PHP가 서버 전체 PHP 구성의 매개 변수 값을 사용합니다.',
    'php-settings.availableVariables' => '매개 변수 값으로 다음 자리 표시자를 사용할 수 있습니다.',
    'php-settings.variableDocroot' => '{DOCROOT} - 이 웹 사이트의 문서 루트 디렉터리. %%DOCROOT%%은(는) 현재 값입니다. %%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'HTTPS 문서 루트 디렉터리는 http의 경우와 같습니다.',
    'php-settings.variableDocrootHttpsDifferent' => 'HTTPS 문서 루트 디렉터리는 %%DOCROOT%%입니다.',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} - 구독의 기본 웹 사이트의 문서 루트 디렉터리.',
    'php-settings.variableTmp' => '{TMP} - 임시 파일을 저장하는 디렉터리.',
    'php-settings.note' => '참고: 아래 설정은 .htaccess, php.ini, 또는 .user.ini 파일에서 지정한 매개 변수에 따라 덮어씌워질 수 있습니다.',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent가 업데이트를 확인합니다.',
    'pmm.agent.sync.updating' => 'Migration & Transfer Agent 동기화 및 다운로드.',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent가 동기화되었습니다.',
    'pmm.agent.sync.downloadLink' => '마이그레이션을 시작하기 전에 원본 호스트에 설치할 Migration & Transfer Agent 파일을 다운로드하려면 클릭합니다.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent를 업데이트하지 못했습니다. 나중에 다시 시도하십시오.',

    'restore-password.title' => '암호 변경',
    'restore-password.passwordLabel' => '새 암호',
    'restore-password.buttonRestore' => '저장',
    'restore-password.buttonCancel' => '취소',
    'restore-password.isEmpty' => '필수 필드가 비어 있습니다. 값을 지정해야 합니다.',
    'restore-password.errorInvalidSecret' => '잘못된 비밀 코드',
    'restore-password.errorNotFoundSecret' => '새 비밀 코드를 요청하십시오.',
    'restore-password.restoreSuccess' => '암호가 업데이트되었습니다. 새 암호를 사용하여 Plesk 또는 이메일 주소에 로그인하십시오.',

    'scheduler.settings.schedulerNotification' => '스케줄러 알림',
    'scheduler.settings.notificationOff' => "꺼짐",
    'scheduler.settings.notificationDefault' => "기본 이메일로 보내기(%%email%%)",
    'scheduler.settings.notificationCustom' => "사용자가 지정하는 이메일로 보내기",
    'scheduler.settings.crontabSecureShell' => 'Crontab shell',
    'scheduler.settings.schedulerTimezoneSelector' => '시간대를 사용하여 작업 일정 보기',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => '시스템 기본 시간대(%%timezone%%) 사용',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => '시스템 기본 시간대 사용',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => '내가 지정한 시간대 사용',

    'scheduler.task.active' => '활성',
    'scheduler.task.subscription' => '구독',
    'scheduler.task.subscription_powerUser' => '웹 공간',
    'scheduler.task.type' => '작업 유형',
    'scheduler.task.typeCommand' => '명령 실행',
    'scheduler.task.typeUrl' => 'URL 가져오기',
    'scheduler.task.typeScript' => 'PHP 스크립트 실행',
    'scheduler.task.command' => '명령',
    'scheduler.task.arguments' => '인수',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => '절대 URL(예: http://example.com)을 지정하십시오. 응답 상태 코드가 2xx 또는 3xx인 경우, 작업이 성공적으로 수행된 것으로 간주됩니다.',
    'scheduler.task.script' => '스크립트 경로',
    'scheduler.task.scriptRelativePathDescription' => '예: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => '스크립트에 대한 전체 경로를 지정하십시오. 예: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'PHP 버전을 사용하십시오',
    'scheduler.task.scriptPathPopupTitle' => '스크립트 경로',
    'scheduler.task.run' => '실행',
    'scheduler.task.on' => '의',
    'scheduler.task.at' => '시간:',
    'scheduler.task.sysUser' => '시스템 사용자',
    'scheduler.task.hourly' => '매시간',
    'scheduler.task.daily' => '매일',
    'scheduler.task.weekly' => '매주',
    'scheduler.task.monthly' => '매월',
    'scheduler.task.yearly' => '매년',
    'scheduler.task.cronStyle' => 'Cron 스타일',
    'scheduler.task.cronStyleHint' => '분 시 일 요일의 UNIX crontab 형식을 사용하십시오(예: "0 22 * * 1-5"). Plesk는 기본 시스템 시간대를 사용하여 작업을 실행합니다.',
    'scheduler.task.cronStyleWinHint' => '분 시 일 요일의 형식을 사용하십시오(예: "0 22 * * 6,7"). Plesk는 기본 시스템 시간대를 사용하여 작업을 실행합니다.',
    'scheduler.task.notify' => '알림',
    'scheduler.task.notifyIgnore' => '알림 없음',
    'scheduler.task.notifyErrors' => '오류인 경우에만 전송됩니다.',
    'scheduler.task.notifyAlways' => '항상',
    'scheduler.task.notifyErrorsHint' => '알림이 명령의 표준 오류 스트림을 포함합니다. 스트림이 비어 있는 경우 알림이 전송되지 않습니다.',
    'scheduler.task.notifyErrorsHintWin' => '알림이 명령 출력을 포함하며 종료 코드가 0이 아닌 경우에만 전송됩니다.',
    'scheduler.task.notifyAlwaysHint' => '알림이 명령 출력을 포함합니다. 출력이 비어 있는 경우 알림이 전송되지 않습니다.',
    'scheduler.task.notifyAlwaysHintWin' => '알림이 명령 출력을 포함하며 명령 종료 코드에 관계 없이 전송됩니다.',
    'scheduler.task.emailType' => '알림 발신 대상',
    'scheduler.task.emailTypeDefault' => '기본 시스템 사용자(%%email%%)',
    'scheduler.task.emailTypeOwner' => '구독 소유자(%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => '관리자(%%email%%)',
    'scheduler.task.emailTypeCustom' => '다른 사용자',
    'scheduler.task.emailTypeCustomDescription' => '쉼표를 사용하여 여러 개의 주소를 구분할 수 있습니다.',
    'scheduler.task.minute' => '분',
    'scheduler.task.shortMinute' => '최소',
    'scheduler.task.dayOfMonth' => '일',
    'scheduler.task.description' => '설명',
    'scheduler.task.scheduleTimezoneHint' => '작업 실행을 위한 시간대 %%timezone%%',
    'scheduler.task.runTaskNow' => '지금 실행',
    'scheduler.task.runningTask' => '작업 "%%task%%" 실행 중...',

    'server-settings.submitDone' => "서버 설정이 변경되었습니다.",
    'server-settings.systemSettings' => "시스템 설정",
    'server-settings.fullHostName' => "전체 호스트 이름",
    'server-settings.trafficStatisticsPeriod' => "다음에 대한 웹 및 트래픽 통계 유지",
    'server-settings.trafficStatisticsPeriodUnit' => "개월",
    'server-settings.diskSpaceUsageCalculation' => "디스크 공간 사용 계산에 포함",
    'server-settings.includeLogs' => "로그 파일",
    'server-settings.includeLogsAndStats' => "로그 파일 및 통계 보고서",
    'server-settings.includeMysqlDatabases' => "MariaDB/MySQL 데이터베이스",
    'server-settings.includeMssqlDatabases' => "Microsoft SQL 데이터베이스",
    'server-settings.includePgsqlDatabases' => "PostgreSQL 데이터베이스",
    'server-settings.includeDatabases' => "데이터베이스",
    'server-settings.includeRemoteDatabases' => "원격 데이터베이스",
    'server-settings.includeMailboxes' => "사서함",
    'server-settings.includeMailLists' => "메일링 리스트",
    'server-settings.includeDomainDumps' => "도메인 백업 파일",
    'server-settings.includeAdminDumps' => "관리자가 만든 백업 파일",
    'server-settings.calculatingDiskSpaceUsage' => "디스크 공간 사용량을 계산할 때 다음을 계산",
    'server-settings.typeByte' => "파일 크기",
    'server-settings.typeBlock' => "사용 중인 디스크 공간 양",
    'server-settings.trafficCalculation' => "트래픽 계산에 포함",
    'server-settings.inboundAndOutbound' => "인바운드 및 아웃바운드 트래픽",
    'server-settings.onlyInbound' => "인바운드 트래픽만",
    'server-settings.onlyOutbound' => "아웃바운드 트래픽만",
    'server-settings.forbidCreateDnsSubZone' => "사용자가 다른 사용자의 DNS 상위 영역에서 DNS 하위 영역을 만들지 못하게 금지",
    'server-settings.webDeployIncludePassword' => "웹 배포 게시 설정이 있는 파일에 사용자 암호 포함",
    'server-settings.forbidSysUserRename' => "고객이 해당 시스템 사용자의 이름을 변경할 수 있습니다.",
    'server-settings.alwaysAllowSysUserRename' => "항상",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "호스팅 관리 권한이 부여된 경우에만",
    'server-settings.neverAllowSysUserRename' => "없음",
    'server-settings.forbidSubscriptionRename' => "고객 및 리셀러가 기본 도메인 이름을 변경하지 못하도록 금지",
    'server-settings.preferredDomain' => "웹 사이트의 즐겨 찾기 도메인",
    'server-settings.preferredDomainNone' => "없음",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "IP 로깅",
    'server-settings.disableIpLogging' => "IIS, FTP 및 메일 로그에서 IP 로깅 비활성화",
    'server-settings.disableIpLoggingDescription' => "선택하면 IIS 및 MailEnable이 로그 파일에 IP 주소를 더 이상 쓰지 않습니다.",
    'server-settings.anonymizeIps' => "IP 주소 익명화",
    'server-settings.logrotateAnonymizeIps' => "로그 순환 및 웹 통계 수집 중 IP 주소 익명화",
    'server-settings.logrotateAnonymizeIpsDescription' => '후순환 스크립트는 보관하기 전에 순환된 로그 파일에 있는 IPv4 주소의 마지막 옥텟을 “0”으로 바꿉니다. IPv6 주소에서는 스크립트가 주소의 마지막 섹션(마지막 콜론 뒤에 있는 2개의 옥텟)을 "0000"(정식) 또는 "0"(약식)으로 바꿉니다.',
    'server-settings.logrotate' => "로그 순환",
    'server-settings.logrotateForce' => "모든 도메인에 일일 로그 순화 강제 적용",
    'server-settings.allowToStoreLogs' => "웹 사이트 로그 저장 허용:",
    'server-settings.logrotatePeriod' => "일",
    'server-settings.configureUpdatePolicy' => "업데이트 정책 구성",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => '기본 서버 전체 값(시간당 %%default%% 메시지)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => '플랜에 대한 사용자 지정 값',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => '구독에 대한 사용자 지정 값',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => '메시지',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => '사서함에서 발신되는 메시지(시간당)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => '도메인에서 발신되는 메시지(시간당)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => '구독에서 발신되는 메시지(시간당)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => '시간당 제한을 초과하여 다음 시간에 보내져야 하는 메시지의 비율(%)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => '시간당 사서함에서 발신되는 이메일 메시지에 대한 제한이 100이고 비율이 10%이면 사용자가 시간당 110개의 메시지를 제출할 수 있습니다. 그러면 시간당 100개의 메시지가 보내지고 10개의 메시지가 메일 대기열에 배치되어 다음 시간에 보내질 때까지 대기합니다.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Sendmail 사용 정책',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => '기본 서버 전체 설정(Sendmail이 허용됨)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => '기본 서버 전체 설정(Sendmail이 허용 안 됨)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => '플랜에 대한 사용자 지정 설정',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => '구독에 대한 사용자 지정 설정',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => '이 구독의 스크립트 및 사용자에 대해 Sendmail 사용을 허가',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => '사서함과 도메인에 대한 제한이 초과되더라도 Sendmail을 이용하여 스크립트 및 사용자가 이메일 메시지를 보낼 수 있습니다(구독의 시스템 사용자를 대신하여). Sendmail을 통해 보낼 수 있는 최대 메시지 수는 전체 구독에 대한 제한으로 정의됩니다.',

    'setup.hint' => '서버를 관리하는 Plesk에 오신 것을 환영합니다. Plesk는 바로 코딩할 수 있는 환경을 제공하고, 웹사이트 및 앱 개발을 도와주는 강력한 확장 제품군을 선사합니다.  Plesk를 사용하려면 설정 과정을 완료하십시오(1분 정도 소요됩니다).',
    'setup.contactInfoSection' => '연락처 정보',
    'setup.contactInfoSectionHint' => '서버 소유자임을 확인하고 서버에 대한 중요한 알림을 수신하려면 이름과 이메일 주소를 입력하십시오. 회사 서버 관리자인 경우 개인 이름이나 이메일 주소를 입력하지 마십시오. 데이터 보호법을 가능한 위반하지 않으려면 직책과 회사 이메일 주소를 사용하십시오.',
    'setup.contactName' => '고객 담당자 이름',
    'setup.emptyContactName' => '연락처 이름을 입력하십시오.',
    'setup.contactNameTooLong' => '연락처 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'setup.email' => '이메일',
    'setup.emptyEmail' => '이메일 주소를 입력하십시오.',
    'setup.passwordSection' => '암호',
    'setup.passwordSectionHint' => '다음에 Plesk에 로그인할 때 아래에 입력한 \'admin\' 사용자 이름과 암호를 사용하십시오.',
    'setup.password' => '암호',
    'setup.licenseSection' => '라이선스',
    'setup.licenseSectionHint' => 'Plesk를 사용하려면 라이선스를 설치해야 합니다.',
    'setup.licenseType' => '라이선스 유형 선택',
    'setup.licenseTypePaid' => '유료 라이선스로 진행',
    'setup.onlineStoreLink' => '온라인 스토어',
    'setup.licenseTypeTrial' => '정식판 라이선스로 진행',
    'setup.activationCodeHint' => 'Plesk 라이선스를 이미 구입하셨다면 수신한 활성화 코드를 여기에 붙여넣으십시오. 그렇지 않다면, 신규 라이선스를 %%onlineStoreLink%%에서 구입하실 수 있습니다.',
    'setup.privacyPolicyLink' => 'WebPros 개인정보 보호정책',
    'setup.trialLicenseAgreement' => 'WebPros International GmbH는 평가판 라이선스 발행을 위해 %%privacyPolicyLink%%에 따라 제공된 정보를 내부 시스템에서 이용하고 처리합니다.',
    'setup.eulaAgreementLabel' => '본인은 %%link%%의 내용을 읽었고 이에 동의합니다',
    'setup.eula' => '최종 사용자 라이선스 계약',
    'setup.invalidEulaAgreementValue' => '최종 사용자 라이선스 계약에 동의해야 합니다',
    'setup.sendButton' => 'Plesk 입장 >>',
    'setup.resetPasswordOnFirstLogin' => '다음 로그인 시 관리자 비밀번호 재설정',

    'spam-filter.add.titleBlack' => '차단 목록에 주소 추가',
    'spam-filter.add.titleWhite' => '허용 목록에 주소 추가',
    'spam-filter.add.fileDescription' => 'UTF-8 인코딩 텍스트 파일을 업로드하십시오(*.txt 또는 *.csv 파일 등).',
    'spam-filter.add.listDescription' => '형식 규칙: <ul><li>쉼표, 쌍반점, 새줄 문자, 공백 또는 탭으로 개별 주소를 구분하십시오.</li><li>@ 표시 왼쪽에 ASCII가 아닌 문자를 사용하지 마십시오.</li><li>"*" 및 "?" 와일드카드 문자를 사용할 수 있습니다(예: <nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>).</li><li>도메인 이름에서 ASCII가 아닌 부분에 와일드카드를 사용하지 마십시오.</li></ul>',
    'spam-filter.add.fromFile' => '파일에서',
    'spam-filter.add.fromList' => '목록에서',
    'spam-filter.add.success' => '주소가 추가되었습니다',

    'ssl-certificate.add.name' => '인증서 이름',
    'ssl-certificate.add.longName' => '지정한 인증서 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'ssl-certificate.add.certificateNameUsed' => '%%name%% 이름의 인증서가 이미 있습니다.',
    'ssl-certificate.add.certificateAdded' => 'SSL/TLS 인증서가 발행되었습니다. 인증서가 정상적으로 실행되도록 하려면 인증서를 안전한 도메인, 메일 또는 웹메일로 할당하십시오.',
    'ssl-certificate.add.certificateUpdated' => 'SSL/TLS 인증서가 업데이트되었습니다.',
    'ssl-certificate.add.settings' => '설정',
    'ssl-certificate.add.settingsHint' => '인증서 요청을 생성하거나, 공급자에게 인증서를 구입하거나, 자체 서명된 인증서를 생성하려면 이 양식을 사용합니다.',
    'ssl-certificate.add.settingsHint2' => '요청은 양식에서 사용자가 지정한 도메인 정보를 포함한 CSR 파일입니다. 인증서 발급을 위해 인증 기관에 요청을 제출할 수 있습니다. 그런 다음 아래 업로드 양식 중 하나를 사용하여 업로드합니다.',
    'ssl-certificate.add.settingsHint3' => '자체 서명된 인증서는 이를 소유한 생성자가 서명한 ID 인증서입니다. 이러한 인증서를 사용하는 경우, 자신이 자신의 사이트 ID를 입증한다는 의미입니다. 자체 서명된 인증서에 SSL/TLS를 사용할 수 있지만 신뢰 수준이 낮으며 보안 수준도 낮습니다.',
    'ssl-certificate.add.bits' => '비트',
    'ssl-certificate.add.country' => '국가',
    'ssl-certificate.add.state' => '주 또는 지방',
    'ssl-certificate.add.longState' => '지정한 주 또는 지방 이름이 너무 깁니다.',
    'ssl-certificate.add.city' => '위치(도시)',
    'ssl-certificate.add.longCity' => '지정한 도시 이름이 너무 깁니다.',
    'ssl-certificate.add.shortCity' => '지정한 도시 이름이 너무 짧습니다.',
    'ssl-certificate.add.companyName' => '조직 이름(회사)',
    'ssl-certificate.add.longCompanyName' => '지정한 회사 이름이 너무 깁니다.',
    'ssl-certificate.add.companyUnitName' => '조직 부서 또는 사업부 이름',
    'ssl-certificate.add.longCompanyUnitName' => '지정한 조직 부서 이름이 너무 깁니다(최대 %max%개 기호가 허용됨).',
    'ssl-certificate.add.domainName' => '도메인 이름',
    'ssl-certificate.add.email' => '이메일',
    'ssl-certificate.add.request' => '요청',
    'ssl-certificate.add.buyCertificate' => 'SSL/TLS 인증서 구매',
    'ssl-certificate.add.selfSigned' => '자체 서명',
    'ssl-certificate.add.invalidCertificateParams' => '일부 필드가 비어 있거나 부적합한 값이 입력되었습니다. 값은 64자로 제한됩니다. 다국어 도메인 이름을 사용하는 경우, 점 사이에서 도메인 이름의 어떤 부분도 ASCII 형식으로 변환 시 63기호를 초과하지 않도록 하십시오. 필드 확인:',
    'ssl-certificate.add.unableCreateCsr' => 'CSR을 생성할 수 없음: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => '자체 서명된 인증서를 만들 수 없음: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => '인증서 데이터를 설정할 수 없음: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => '데이터베이스에 인증서를 저장할 수 없음: %%error%%',
    'ssl-certificate.add.uploadFiles' => '인증서 파일 업로드',
    'ssl-certificate.add.uploadFilesHint' => '인증서의 구성 요소를 구성 파일로 업로드하는 데 이 양식을 사용합니다.',
    'ssl-certificate.add.csr' => 'CSR',
    'ssl-certificate.add.privateKey' => "개인 키(*.key)",
    'ssl-certificate.add.certificate' => "인증서(*.crt)",
    'ssl-certificate.add.caCertificate' => "CA 인증서(*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "인증서 업로드",
    'ssl-certificate.add.fileNotUploaded' => '인증서 파일을 업로드할 수 없음: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => '개인 키를 설정할 수 없음: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => '인증서를 설정할 수 없음: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'CA 인증서를 설정할 수 없음: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'CA 인증서가 인증서에 서명하는지 확인할 수 없음: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => '제거',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'CA 인증서를 제거하시겠습니까?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'CA 인증서를 삭제할 수 없음: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => '인증서의 CA 부분이 제거되었습니다.',
    'ssl-certificate.add.rename' => '이름 바꾸기',
    'ssl-certificate.add.unableRenameCertificate' => '인증서 이름을 바꿀 수 없음: %%error%%',
    'ssl-certificate.add.certificateRenamed' => '인증서 이름이 %%name%%(으)로 바뀌었습니다.',
    'ssl-certificate.add.uploadText' => "인증서를 텍스트로 업로드",
    'ssl-certificate.add.uploadTextHint' => '인증서의 구성 요소를 텍스트로 업로드하는 데 이 양식을 사용합니다. 파일 내용을 복사하여 해당 필드에 붙여 넣습니다.',
    'ssl-certificate.add.sendText' => "인증서 업로드",
    'ssl-certificate.add.componentIsMissing' => '구성 요소가 없습니다.',

    'ssl-certificate.find-private-key.findPrivateKey' => '여기에 인증서 업로드',
    'ssl-certificate.find-private-key.formGeneralHint' => '이 서버에서 인증서 서명 요청을 생성하고 인증서 파일을 수신한 경우 여기에 업로드하십시오. 다른 서버에서 생성된 인증서 및 개인 키 쌍의 업로드나 자체 서명된 인증서 생성을 원하는 경우 <b>SSL/TLS 인증서 추가</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'SSL/TLS 인증서를 도메인에 추가한 후에는 SSL/TLS 지원을 활성화하고 웹 사이트 호스팅 설정에서 해당 인증서를 선택해야 합니다. <b>웹 사이트 및 도메인</b> > <b>이 도메인의 </b>>호스팅 설정 <b>보안</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => '인증서(*.crt)',
    'ssl-certificate.find-private-key.sendFile' => '인증서 업로드',
    'ssl-certificate.find-private-key.fileNotUploaded' => '인증서 파일을 업로드할 수 없습니다.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => '잘못된 인증서 형식.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => '인증서에 해당하는 개인 키를 찾을 수 없음.',

    'ssl-certificate.secure.certificate' => '인증서 선택',
    'ssl-certificate.secure.serverPool' => '서버 풀',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "날짜",
    'system-time.dateAndTime' => "날짜 및 시간",
    'system-time.daylight' => "일광 절약 변경으로 시계 자동 조정",
    'system-time.dayMonthYear' => "일-월-년",
    'system-time.domainNameOrIp' => "도메인 이름 또는 IP",
    'system-time.hoursMinutesSeconds' => "시간:분:초",
    'system-time.networkTime' => "네트워크 시간",
    'system-time.submitDone' => "시스템 시간 설정이 변경되었습니다.",
    'system-time.synchronizedSystemTime' => "시스템 시간 동기화",
    'system-time.title' => "시스템 날짜 및 시간",
    'system-time.timezone' => "시간대",
    'system-time.time' => "시간",
    'system-time.updateSystemTime' => "시스템 시간 업데이트",
    'system-time.yourTimezone' => "사용자의 시간대",

    'web-app-firewall.pageHint' => '웹 응용 프로그램 방화벽은 사용자 정의 규칙을 기반으로 들어오는 HTTP 요청을 확인하고 필터링하여 공격으로부터 웹 응용 프로그램을 보호합니다.',
    'web-app-firewall.webSitePageHint' => '여기서 웹 응용 프로그램 방화벽을 구성할 수 있습니다(ModSecurity).',
    'web-app-firewall.ruleEngine' => '웹 응용 프로그램 방화벽 모드',
    'web-app-firewall.ruleEngineOn' => '켜기',
    'web-app-firewall.ruleEngineOnDescription' => '규칙 집합과 대조하여 들어오는 각 HTTP 요청 및 관련 응답이 검사됩니다. 검사에 성공하면 HTTP 요청이 웹 사이트 콘텐츠로 전달됩니다. 검사에 실패하면 이벤트가 기록되고 알림이 보내지며 HTTP 응답에 오류 코드가 제공됩니다.',
    'web-app-firewall.ruleEngineOff' => '끄기',
    'web-app-firewall.ruleEngineOffDescription' => '들어오는 HTTP 요청 및 관련 응답이 검사되지 않습니다.',
    'web-app-firewall.ruleEngineDetectionOnly' => '감지만',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => '규칙 집합과 대조하여 들어오는 각 HTTP 요청 및 관련 응답이 검사됩니다. 검사에 성공하면 HTTP 요청이 웹 사이트 콘텐츠로 전달됩니다. 검사에 실패하면 이벤트가 기록되고 ModSecurity는 다른 작업을 수행하지 않습니다. 다른 서비스(예: Fail2ban)는 검사에 실패한 HTTP 요청에 대해 자체 작업을 계속 수행할 수 있습니다.',
    'web-app-firewall.ruleSetsSection' => '규칙 집합',
    'web-app-firewall.ruleSetsSectionHint' => '들어오는 HTTP 요청을 확인하는 데 사용할 규칙 집합(보안 규칙이 포함된 파일 패키지)을 선택합니다.',
    'web-app-firewall.ruleSet' => '규칙 집합',
    'web-app-firewall.ruleSetCrs' => 'OWASP(무료)',
    'web-app-firewall.ruleSetCrsDescription' => 'OWASP ModSecurity 핵심 규칙 모음은 매우 제한적이며, 일부 기능(예: 파일 공유, 웹 메일)과 일부 웹 애플리케이션의 기능(예: WordPress 플러그인)을 차단할 수 있습니다.',
    'web-app-firewall.ruleSetCrsConfirmTitle' => '변경 사항을 적용하시겠습니까?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'OWASP 규칙이 너무 제한적일 수 있어서 파일 공유, 웹메일 및 일부 웹 응용 프로그램 등 일부 기능이 차단될 수 있습니다.',
    'web-app-firewall.ruleSetTortix' => 'Atomic Standard(무료, Atomic Advanced로 업그레이드 가능)',
    'web-app-firewall.ruleSetTortixDescription' => 'Atomicorp ModSecurity 규칙의 시작 버전.  기본적인 보호 기능을 제공하고 매월 업데이트됩니다.',
    'web-app-firewall.ruleSetTortixHowTo' => '이 규칙 모음을 Atomic Advanced로 업그레이드하는 방법:',
    'web-app-firewall.ruleSetTortixBuy' => 'Plesk 웹 사이트 및 %%linkDocumentation%%에서 %%linkPleskStore%%을(를) 구입하십시오.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Atomicorp의 Advanced ModSecurity 규칙',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => '구입한 라이선스 키를 설치',
    'web-app-firewall.ruleSetTortixSelect' => '이 규칙 모음을 선택하면 이름이 "Atomic Advanced(Plesk에서 구입)"로 변경됩니다.',
    'web-app-firewall.ruleSetTortixPro' => 'Atomic Advanced(Plesk에서 구입)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Atomicorp의 Advanced ModSecurity 규칙에는 Atomic Standard 규칙과 몇 가지 고급 기능이 포함되어 있습니다.',
    'web-app-firewall.ruleSetAtomic' => 'Atomic Advanced(Atomicorp에서 구입)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Atomicorp의 Advanced ModSecurity 규칙에는 Atomic Standard 규칙과 몇 가지 고급 기능이 포함되어 있습니다.',
    'web-app-firewall.ruleSetAtomicInstall' => '다른 Atomicorp 계정으로 전환합니다.',
    'web-app-firewall.ruleSetAtomicInstalled' => '규칙 집합이 활성화되었습니다.',
    'web-app-firewall.ruleSetAtomicHowTo' => '구입한 Atomic Advanced 규칙이 포함된 Atomicorp 계정을 이미 가지고 있다면 아래에 계정 자격 증명을 입력하여 이 규칙 모음을 활성화하십시오.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => '구입한 Atomic Advanced 규칙이 포함된 Atomicorp 계정을 이미 가지고 있다면 아래에 계정 자격 증명을 입력하여 해당 계정으로 전환하십시오.',
    'web-app-firewall.ruleSetAtomicLogin' => '사용자 이름',
    'web-app-firewall.ruleSetAtomicPassword' => '암호',
    'web-app-firewall.ruleSetComodo' => 'Comodo(무료 구독)',
    'web-app-firewall.ruleSetComodoDescription' => 'Comodo의 무료 ModSecurity 규칙. 기본적인 보호 기능을 제공합니다.',
    'web-app-firewall.ruleSetComodoInstall' => '다른 Comodo 계정으로 전환합니다.',
    'web-app-firewall.ruleSetComodoInstalled' => '규칙 집합이 활성화되었습니다.',
    'web-app-firewall.ruleSetComodoHowTo' => '이 규칙 집합을 사용하려면:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => '다른 계정으로 전환:',
    'web-app-firewall.ruleSetComodoRegister' => 'Comodo 웹 사이트에서 등록하십시오.',
    'web-app-firewall.ruleSetComodoCredentials' => '해당 웹 사이트에서 사용자 이름과 암호를 입력하십시오.',
    'web-app-firewall.ruleSetComodoLogin' => '사용자 이름',
    'web-app-firewall.ruleSetComodoPassword' => '암호',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo(무료 )',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Comodo의 무료 ModSecurity 규칙. 기본적인 보호 기능을 제공합니다.',
    'web-app-firewall.ruleSetCustom' => '사용자 지정 규칙 집합',
    'web-app-firewall.ruleSetCustomDescription' => '사용자 지정 웹 응용 프로그램 방화벽 규칙 집합을 업로드하십시오. 지원 형식: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => '다른 파일 선택',
    'web-app-firewall.ruleSetError' => 'ModSecurity 규칙 집합을 설치하지 못함: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'OWASP 규칙 집합이 없습니다. Plesk 설치 프로그램을 이용하여 ModSecurity를 재설치하십시오.',
    'web-app-firewall.ruleSetCustomMissingError' => '사용자 정의 규칙 세트가 없습니다. 규칙 세트를 재설치하십시오.',
    'web-app-firewall.ruleSetAuthError' => '지정된 사용자 이름 또는 암호가 잘못되었습니다.',
    'web-app-firewall.ruleSetInvalid' => '선택한 규칙 집합은 %%webServer%%에서 실행할 수 없습니다.',
    'web-app-firewall.ruleSetSelectedInvalid' => '선택한 규칙 집합은 선택한 웹 서버에서 실행할 수 없습니다.',
    'web-app-firewall.webServer' => '규칙 실행',
    'web-app-firewall.webServerHint' => '호환되는 규칙 세트를 보려면 웹 서버 및 ModSecurity 버전의 원하는 조합을 선택하십시오.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => '리버스 프록시 서버(nginx)가 꺼져 있으며 요청을 처리하는 데 사용할 수 없습니다. <a href="%%serverUrl%%">다른 웹 서버</a>를 선택하거나 <a href="%%servicesUrl%%">서비스 관리 페이지</a>에서 역방향 프록시 서버를 켭니다.',
    'web-app-firewall.nginxIsIncompatible' => '다른 ModSecurity 버전을 선택하면 일부 설정이 더 이상 유효하지 않을 수 있습니다(예: ModSecurity 3으로 정규식을 사용하여 보안 규칙을 끌 수 없음). 변경 사항을 적용한 후 설정이 예상대로 작동하는지 확인하십시오. 또는 보안 규칙 해제를 기본값으로 서버 및 도메인 설정을 재설정할 수 있습니다.',
    'web-app-firewall.nginxResetCustomizations' => '보안 규칙 해제를 기본값으로 서버 및 도메인 설정을 재설정할 수 있습니다.',
    'web-app-firewall.ruleSetUpdate' => '규칙 집합 업데이트',
    'web-app-firewall.ruleSetUpdateDaily' => '매일',
    'web-app-firewall.ruleSetUpdateWeekly' => '주간',
    'web-app-firewall.ruleSetUpdateMonthly' => '매월',
    'web-app-firewall.currentRuleSet' => '규칙 집합',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%webServer%%에서 실행 중인 %%ruleSet%%',
    'web-app-firewall.changeRuleSetLink' => '규칙 집합 변경',
    'web-app-firewall.ruleSetRollbackFailed' => '잘못된 규칙이 포함되어 있어 현재 ModSecurity 규칙 집합을 사용하거나 이전 버전으로 롤백할 수 없습니다.',
    'web-app-firewall.configurationSection' => '구성',
    'web-app-firewall.configurationSectionHint' => '사전 정의된 매개 변수 세트 또는 사용자 정의 ModSecurity 지시문을 사용하여 웹 응용 프로그램 방화벽을 구성하십시오.',
    'web-app-firewall.configPreset' => '사전 정의된 값 집합',
    'web-app-firewall.configPresetFast' => '고속',
    'web-app-firewall.configPresetFastDescription' => 'HTTP 요청 URI 및 헤더의 일부가 분석됩니다.',
    'web-app-firewall.configPresetTradeOff' => '균형 조정',
    'web-app-firewall.configPresetTradeOffDescription' => 'HTTP 요청 URI, 헤더 및 요청 POST 데이터가 분석됩니다.',
    'web-app-firewall.configPresetThrough' => '상세',
    'web-app-firewall.configPresetThroughDescription' => '전체 HTTP 요청 헤더, 요청 POST 데이터 및 HTTP 응답 본문 내용이 분석됩니다.',
    'web-app-firewall.configCustom' => '사용자 지정 지시문',
    'web-app-firewall.configCustomDescription' => "여기에 ModSecurity 지시문을 배치합니다. 이 지시문이 이전에 지정된 지시문(규칙 집합, 특정 규칙, 사전 정의된 값 집합 등)을 재정의합니다. \n예: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => '잘못된 ModSecurity 구성: %%error%%',
    'web-app-firewall.configRollbackFailed' => '잘못된 구성을 포함하고 있어 현재 ModSecurity 구성 파일을 사용하고 이전 파일 버전으로 롤백할 수 없습니다.',
    'web-app-firewall.rulesSection' => '보안 규칙 사용 해제',
    'web-app-firewall.rulesSectionHint' => '여기서 보안 규칙의 사용을 해제할 수 있습니다. 보안 규칙이 일부 웹 사이트에 지나치게 제한적이라고 생각되는 경우 유용한 옵션입니다. 보안 규칙을 비활성화하려면 해당 ID(예: 340003 또는 340005-340007), 태그(예: CVE-2011-4898) 또는 규칙 메시지에 사용된 정규식(예: XSS)을 지정합니다.',
    'web-app-firewall.rulesSectionNginxHint' => '여기서 보안 규칙의 사용을 해제할 수 있습니다. 보안 규칙이 일부 웹 사이트에 지나치게 제한적이라고 생각되는 경우 유용한 옵션입니다. 보안 규칙을 비활성화하려면 해당 ID(예: 340003 또는 340005-340007), 태그(예: CVE-2011-4898) 또는 규칙 메시지(예: 보안 스캐너와 연결된 Found User-Agent)을 지정합니다.',
    'web-app-firewall.filterById' => '보안 규칙 ID',
    'web-app-firewall.filterByIdInvalid' => '다음 값이 유효하지 않습니다: %%values%%. 규칙 ID는 913100, 913105-913107과 같은 숫자 또는 숫자 범위로 구성되어야 합니다.',
    'web-app-firewall.filterByIdInvalidRanges' => '다음 범위가 유효하지 않습니다: %%ranges%%.',
    'web-app-firewall.filterByTag' => '태그',
    'web-app-firewall.filterByTagActive' => '활성:',
    'web-app-firewall.filterByTagDeactivated' => '비활성화됨:',
    'web-app-firewall.filterByTagInvalid' => '선택한 다음 값이 유효하지 않습니다: %%values%%.',
    'web-app-firewall.filterByRegexp' => '규칙 메시지의 정규식',
    'web-app-firewall.filterByRegexpInvalid' => '다음 값이 유효하지 않습니다: %%values%%. \', "와 같은 문자를 포함할 수 없습니다.',
    'web-app-firewall.filterByRegexpNginx' => '규칙 메시지',
    'web-app-firewall.filterByRegexpNginxHint' => '엄격한 일치에만 지원됩니다.',
    'web-app-firewall.filterByRegexpNginxInvalid' => '다음 값이 유효하지 않습니다: %%values%%. 규칙 메시지는 문자, 숫자, 공백 또는 -:;.,!?#&$%*()/와 같은 문자로 구성되어야 합니다.',
    'web-app-firewall.auditLogSection' => 'ModSecurity 감사 로그',
    'web-app-firewall.auditLogHint1' => 'ModSecurity 감사 로그 파일은 시스템에서 가장 유용한 정보를 담고 있습니다. 이벤트 발생이 감지되면 ModSecurity가 감사 로그 파일에 항목을 생성합니다.',
    'web-app-firewall.auditLogHint2' => '웹 응용 프로그램 방화벽 모드를 켜짐에서 꺼짐으로, 혹은 감지 전용으로 변경하면 웹 사이트가 더 이상 정상적으로 작동하지 않을 수 있습니다. 이 경우 ModSecurity 감사 로그를 분석하여 발생한 문제를 확인하십시오. 너무 제한적인 보안 규칙을 해제하거나 웹 사이트를 조정할 수 있습니다.',
    'web-app-firewall.auditLogHint3' => '웹 사이트에 대해 HTTP 요청을 완료할 수 없는 이유를 확인하려면:',
    'web-app-firewall.auditLogPoint1' => '아래에서 ModSecurity 로그 파일 링크를 클릭하여 새 브라우저 창에 감사 로그를 엽니다.',
    'web-app-firewall.auditLogPoint2' => '검색(대부분의 웹 브라우저에서 Ctrl+F)을 사용하여 문제가 발생한 웹 사이트(도메인 이름)의 이벤트를 확인하십시오. (예: your_domain.tld). 브라우저가 HOST와 같은 항목을 강조 표시합니다: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => '강조 표시된 항목 위로 3개 라인에서 --eece5138-B—와 같은 문자열을 찾습니다. 하이픈 사이의 8개 기호(여기 예에서는 eece5138)는 HTTP 요청에 의해 트리거된 이벤트의 ID입니다.',
    'web-app-firewall.auditLogPoint4' => '계속해서 동일 이벤트 ID를 가진 다른 항목을 검색합니다. 이벤트 ID 다음에 문자 H가 있는 항목을 찾습니다(예: eece5138-H--). 이 항목에는 HTTP 요청을 확인하는 동안 트리거된 보안 규칙의 ID와 설명이 포함되어 있습니다. 보안 규칙 ID는 인용부호 안의 정수이며 꺾쇠 괄호에 접두어 id가 놓입니다(예: [id "340003"]).',
    'web-app-firewall.auditLogPoint5' => '하위 문자열을 이용하여 이벤트에서 보안 규칙 ID를 찾습니다(예: [id "3).',
    'web-app-firewall.auditLogPoint6' => '아래의 보안 규칙 섹션에서 이 ID를 포함한 보안 규칙을 해제합니다. 보안 규칙 ID 필드에 보안 규칙 ID(숫자만)를 입력하고 \'확인\'을 클릭합니다.',
    'web-app-firewall.auditLogViewLink' => 'ModSecurity 로그 파일',
    'web-app-firewall.auditLogListLink' => '로그 아카이브',
    'web-app-firewall.errorLogSection' => '오류 로그',
    'web-app-firewall.errorLogSectionHint' => '웹 응용 프로그램 방화벽 모드를 켜짐에서 꺼짐으로, 혹은 감지 전용으로 변경하면 웹 사이트가 더 이상 정상적으로 작동하지 않을 수 있습니다. 이 경우 오류 로그를 분석하여 발생한 문제를 확인하십시오. 너무 제한적인 보안 규칙을 해제하거나 웹 사이트를 조정할 수 있습니다.',
    'web-app-firewall.errorLogViewLink' => '오류 로그 파일',
    'web-app-firewall.notificationStateEnabled' => '규칙 집합 업데이트에 대한 Plesk UI 알림이 켜져 있습니다. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => '규칙 집합 업데이트에 대한 Plesk UI 알림이 꺼져 있습니다. %%notificationLink%%',
    'web-app-firewall.notificationLink' => '알림 페이지에서 관리',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => '"균형 조정" 또는 "상세" 옵션을 선택하면 다음과 같은 <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">ModSecurity 문제</a>로 인해 WordPress 사이트가 오작동하는 등 부작용이 발생할 수 있습니다.',

    'ProtectedDirectory.pathLabel' => '디렉터리 이름',
    'ProtectedDirectory.realmLabel' => '보호된 영역의 제목',
    'ProtectedDirectory.locationLabel' => '디렉터리 위치',
    'ProtectedDirectory.isNonSslLabel' => 'SSL/TLS가 아님',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => '보고서 이름',
    'SummaryReport.Layout.isDefault' => '기본 보고서로 사용',
    'SummaryReport.Layout.sections' => '섹션',
    'SummaryReport.Layout.general' => '일반',
    'SummaryReport.Layout.resellers' => '리셀러',
    'SummaryReport.Layout.clients' => '고객',
    'SummaryReport.Layout.personalClients' => '자체 고객',
    'SummaryReport.Layout.domains' => '도메인',
    'SummaryReport.Layout.personalDomains' => '개인 도메인',
    'SummaryReport.Layout.type.full' => '전체',
    'SummaryReport.Layout.type.summary' => '요약',

    'SummaryReport.Schedule.enable' => '활성화',
    'SummaryReport.Schedule.period' => '배달 빈도',
    'SummaryReport.Schedule.daily' => '매일',
    'SummaryReport.Schedule.weekly' => '주간',
    'SummaryReport.Schedule.monthly' => '매월',
    'SummaryReport.Schedule.email' => '배달 대상',
    'SummaryReport.Schedule.isEmpty' => '유효한 이메일 주소를 입력하십시오.',

    'MassMailForm.name' => '템플릿 이름',
    'MassMailForm.fromEmail' => '발신자(이메일 주소)',
    'MassMailForm.sendToAdmins' => 'Plesk 관리자에게 보내기',
    'MassMailForm.sendToResellers' => '리셀러에게 보내기',
    'MassMailForm.sendToClients' => '고객에게 보내기',
    'MassMailForm.subject' => '제목',
    'MassMailForm.body' => '메시지 텍스트',
    'MassMailForm.bodyDescription' => '
머리글이 아닌 메시지 텍스트에 <name> 변수를 사용할 수 있습니다. 고객의 또는 리셀러의 담당자 이름으로 교체될 것입니다.',
    'MassMailForm.sendToResellersMode' => '보낼 대상',
    'MassMailForm.sendToResellersModeAll' => '모든 리셀러',
    'MassMailForm.sendToResellersModeSelect' => '선택한 리셀러',
    'MassMailForm.sendToResellersModeExcept' => '선택한 리셀러를 제외하고 전부',
    'MassMailForm.sendToClientsMode' => '보낼 대상',
    'MassMailForm.sendToClientsModeAll' => '모든 고객',
    'MassMailForm.sendToClientsModeSelect' => '선택한 고객',
    'MassMailForm.sendToClientsModeExcept' => '선택한 고객을 제외하고 전부',

    'VirtualDirectory.DirectorySection.title' => '가상 디렉터리',
    'VirtualDirectory.DirectorySection.name' => '이름',
    'VirtualDirectory.DirectorySection.accessSource' => '스크립트 소스 액세스',
    'VirtualDirectory.DirectorySection.accessRead' => '읽기 권한',
    'VirtualDirectory.DirectorySection.accessWrite' => '쓰기 권한',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => '디렉터리 탐색',
    'VirtualDirectory.DirectorySection.log' => '방문 기록',
    'VirtualDirectory.Path.path' => '경로',
    'VirtualDirectory.Path.autoPathLabel' => '가상 디렉터리와 이름이 같은 실제 디렉터리 생성',
    'VirtualDirectory.ApplicationSettingsSection.title' => '응용 프로그램 설정',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => '응용 프로그램 생성',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => '상위 경로를 사용하도록 허용',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'MTA(Multi-Threaded Apartment) 모드로 응용 프로그램 실행 허용',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => '권한 실행',
    'VirtualDirectory.SecuritySection.title' => '디렉터리 보안',
    'VirtualDirectory.SecuritySection.authAnonymous' => '익명 인증을 활성화합니다',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Windows 인증을 활성화합니다',
    'VirtualDirectory.SecuritySection.requireSSL' => 'SSL/TLS 필요',
    'VirtualDirectory.scriptExecuteOption.none' => '없음',
    'VirtualDirectory.scriptExecuteOption.script' => '스크립트만',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => '스크립트와 실행 파일',
    'VirtualDirectory.AspSection.title' => 'ASP 설정',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'ASP 버퍼의 최대 크기(KB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'ASP 요청의 엔터티 본문 최대 크기(KB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'ASP 서버측 스크립트 디버깅 활성화',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'ASP 클라이언트측 스크립트 디버깅 활성화',
    'VirtualDirectory.AspSection.definedByIis' => 'IIS에 의해 정의됨',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'IIS에 의해 정의됨(%%size%%KB)',
    'VirtualDirectory.AspSection.definedByParent' => '상위 디렉터리에 의해 정의됨',
    'VirtualDirectory.AspSection.definedByParentWithSize' => '상위 디렉터리에 의해 정의됨(%%size%%KB)',
    'VirtualDirectory.AspSection.kbytes' => 'KB',
    'VirtualDirectory.CheckboxField.true' => '예',
    'VirtualDirectory.CheckboxField.false' => '아니오',
    'VirtualDirectory.DocumentsSection.title' => '문서',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => '기본 문서 사용',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => '기본 문서 검색 순서',
    'VirtualDirectory.DefaultDocsField.remove' => '제거',
    'VirtualDirectory.NewDefaultDoc.add' => '추가',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => '파일을 목록에 추가하려면 클릭합니다.',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => '목록에 추가할 파일 이름 입력.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => '같은 이름을 가진 실제 디렉터리가 이미 존재합니다. 계속할 경우, 해당 디렉터리에 액세스하지 못하게 됩니다. 진행하시겠습니까?',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => '진행',

    'VirtualDirectoryMimeType.extension' => '확장명',
    'VirtualDirectoryMimeType.content' => '내용',
    'VirtualDirectoryMimeType.custom' => '사용자 지정',
];