<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Якщо ваш сайт розміщається на виділеній ІР-адресі (не спільній з іншими користувачами чи сайтами), то ви можете встановити каталог в межах сайту, де інші користувачі зможуть анонімно вивантажувати або завантажувати файли через FTP. Одразу після увімкнення анонімного FTP користувачі зможуть увійти до каталогу за адресою на зразок ftp://ftp.your-domain.com з «анонімним» ім’ям користувача та будь-яким паролем.',
    'anonymous-ftp.displayLogin' => 'Показати повідомлення входу',
    'anonymous-ftp.loginText' => 'Текст повідомлення',
    'anonymous-ftp.incomingDir' => 'Дозволити вивантажування до вхідного каталогу',
    'anonymous-ftp.incomingSubDir' => 'Дозволити створення каталогів у вхідному каталозі',
    'anonymous-ftp.incomingReadable' => 'Дозволити завантажування з вхідного каталогу',
    'anonymous-ftp.quota' => 'Обмежити дисковий простір у вхідному каталозі',
    'anonymous-ftp.maxConnections' => 'Обмежити кількість одночасних з’єднань',
    'anonymous-ftp.bandwidth' => 'Обмежити пропускну здатність завантаження для цього віртуального FTP-домену',
    'anonymous-ftp.unlimited' => 'Необмежений',

    'aps.catalog.loading' => 'Завантаження…',
    'aps.catalog.searchName' => 'Застосунок',
    'aps.catalog.searchVendor' => 'Продавець',
    'aps.catalog.searchPackager' => 'Пакувальник',
    'aps.catalog.searchLicenseType' => 'Тип ліцензії',
    'aps.catalog.searchLicenseTypeAny' => 'Будь-який',
    'aps.catalog.searchLicenseTypeFreeware' => 'Безкоштовно',
    'aps.catalog.searchLicenseTypeCommercial' => 'Комерційний',
    'aps.catalog.showSearch' => 'Показати пошук',
    'aps.catalog.hideSearch' => 'Сховати пошук',
    'aps.catalog.buttonSearch' => 'Пошук',
    'aps.catalog.buttonResetSearch' => 'Скинути параметри пошуку',
    'aps.catalog.showCategories' => 'Виберіть нижченаведену категорію або пошукайте застосунок, використовуючи поле пошуку',
    'aps.catalog.searchResults' => 'Пошук результатів',
    'aps.catalog.buttonInstall' => 'Встановити',
    'aps.catalog.buttonInstallTooltip' => 'Встановіть найновішу версію застосунка з оптимальними параметрами за замовчуванням.',
    'aps.catalog.buttonAdvancedInstall' => 'Встановити (Користувацький)',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Встановіть найновішу версію застосунка, налаштовуючи всі параметри.',
    'aps.catalog.buttonInstallOldVersion' => 'Встановити версію',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Встановіть вибрану версію застосунка, налаштовуючи всі параметри.',
    'aps.catalog.buttonInstallDescription' => 'Встановіть застосунок на сайті, якщо ви вже маєте код активації або бажаєте його протестувати.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Встановіть цей безкоштовний застосунок на сайті.',
    'aps.catalog.version' => 'Версія',
    'aps.catalog.moreVersions' => 'Інші версії',
    'aps.catalog.release' => 'Позбавляти',
    'aps.catalog.overview' => 'Огляд',
    'aps.catalog.noApplicationsInCategory' => 'У цій категорії немає доступних застосунків. Виберіть іншу категорію.',
    'aps.catalog.noCategoriesSelected' => 'Виберіть категорію для перегляду всіх застосунків, доступних у цій категорії.',
    'aps.catalog.noSearchResults' => 'За заданими параметрами пошуку не знайдено жодного застосунку.',
    'aps.catalog.connectionFailed' => 'Не вдалося підключитись до Каталогу застосунків. %%retryLink%%.',
    'aps.catalog.retry' => 'Повторити',
    'aps.catalog.categoriesError' => 'На даний момент неможливо отримати список категорій.',
    'aps.catalog.applicationsError' => 'На даний момент неможливо завантажити список застосунків.',
    'aps.catalog.detailsError' => 'На даний момент неможливо завантажити відомості про застосунок.',
    'aps.catalog.searchError' => 'На даний момент неможливо отримати результати пошуку.',
    'aps.catalog.changelogEntry' => 'версія %%version%% (Випуск %%release%%) — %%description%%',
    'aps.catalog.changelog' => 'Історія змін',
    'aps.catalog.officialApplicationSite' => 'Інформація про постачальника',
    'aps.catalog.returnToCategories' => '<< Повернутися до списку застосунків',
    'aps.catalog.buttonUninstall' => 'Видалити',
    'aps.catalog.gotoHome' => 'Головна сторінка',
    'aps.catalog.all' => 'Усі',
    'aps.catalog.buttonDetails' => 'Дізнатися більше',
    'aps.catalog.buttonBuy' => 'Придбати зараз',
    'aps.catalog.buttonBuyTooltip' => 'Придбати застосунок',
    'aps.catalog.buttonBuyDescription' => 'Відвідайте наш магазин та придбайте код активації програми.',
    'aps.catalog.buttonDownload' => 'Завантажити',
    'aps.catalog.buttonDownloadDescription' => 'Завантажте застосунок, якщо ви вже маєте код активації або бажаєте його протестувати.',
    'aps.catalog.marketplaceMoreInfo' => 'Для отримання додаткової інформації перейдіть до %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'сайт постачальника застосунка',

    'aps.configure.installedAt' => "Встановлено до",
    'aps.configure.otherSettings' => "Інше",
    'aps.configure.globalSettings' => 'Параметри програмного пакету',
    'aps.configure.passwordConfirmation' => 'Підтвердіть пароль',
    'aps.configure.databaseParams' => 'Параметри бази даних',
    'aps.configure.noInstallationUrlAvailable' => 'Порожньо (зовнішній застосунок)',
    'aps.configure.updateSettingsSection' => 'Параметри оновлення',
    'aps.configure.forceUpdates' => 'Автоматичне оновлення застосунка при наявності доступних оновлень',
    'aps.configure.forceUpdatesHint' => 'Цей застосунок буде отримувати автоматичні оновлення до новішої версії. Попередження: цю опцію слід використовувати обачно, оскільки оновлення можуть сильно вплинути на функціональність застосунка. Наприклад, розширення застосунка можуть перестати працювати з іншою версією.',

    'aps.install.showAllSettings' => 'Показати всі параметри',
    'aps.install.showLessSettings' => 'Показати мінімальний набір параметрів',
    'aps.install.install' => 'Встановити',
    'aps.install.otherSettings' => 'Інші налаштування',
    'aps.install.globalSettings' => 'Параметри програмного пакету',
    'aps.install.passwordConfirmation' => 'Підтвердіть пароль',
    'aps.install.provisionsSectionLabel' => 'Шлях установки',
    'aps.install.context' => 'Зазначте розташування, за яким необхідно встановити цей веб-застосунок',
    'aps.install.registerAsWebmailSection' => 'Реєстрація веб-пошти',
    'aps.install.registerAsWebmailDescription' => "Виберіть цю опцію, якщо застосунок є поштовим веб-клієнтом. Після цього застосунок буде відображатись серед доступних поштових веб-послуг у меню Налаштування пошти для підписок та сервісних планів. Адміністратор може змінювати URL відкритого доступу до веб-пошти в меню Управління сервером>Параметри>Веб-пошта.",
    'aps.install.registerAsWebmailLabel' => 'Зареєструвати в якості поштового веб-сервісу',
    'aps.install.addItem' => 'Додати',
    'aps.install.removeItem' => 'Видалити',
    'aps.install.updateSettingsSection' => 'Параметри оновлення',
    'aps.install.forceUpdates' => 'Автоматичне оновлення застосунка при наявності доступних оновлень',
    'aps.install.forceUpdatesHint' => 'Цей застосунок буде отримувати автоматичні оновлення до новішої версії. Попередження: цю опцію слід використовувати обачно, оскільки оновлення можуть сильно вплинути на функціональність застосунка. Наприклад, розширення застосунка можуть перестати працювати з іншою версією.',

    'aps.invalid-requirements.requirementsLegend' => 'Вимоги',
    'aps.invalid-requirements.domainLegend' => 'Веб-сайт',
    'aps.invalid-requirements.context' => 'Вибрати інший веб-сайт',
    'aps.invalid-requirements.backToApplicationList' => 'Повернутися до списку застосунків',

    'aps.license.title' => 'Установка %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Для установки цього застосунку необхідно прочитати ліцензійну угоду кінцевого користувача та погодитись з його положеннями.',
    'aps.license.licenseAgree' => 'Я погоджуюсь з положеннями Ліцензійної угоди',

    'aps.services-list-customization.settings' => 'Налаштування',

    'asp-dot-net.change-version.title' => 'Вибір версії ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'Версія платформи ASP.NET',
    'asp-dot-net.change-version.success' => 'Версію ASP.NET змінено.',

    'asp-dot-net.settings.casSettingsSection' => "Безпека коду доступу",
    'asp-dot-net.settings.clientScriptsSection' => "Налаштування бібліотеки скриптів",
    'asp-dot-net.settings.connStringsSection' => "Менеджер рядків з’єднання",
    'asp-dot-net.settings.customErrorsSection' => "Налаштування користувацьких помилок",
    'asp-dot-net.settings.frameworkVersionSection' => "Версія платформи",
    'asp-dot-net.settings.globalizationSection' => "Налаштування глобалізації",
    'asp-dot-net.settings.otherSection' => "Налаштування сеансу",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Компіляція та налагоджування",
    'asp-dot-net.settings.authMode' => "Режим автентифікації",
    'asp-dot-net.settings.connStrings' => "Рядки з’єднання",
    'asp-dot-net.settings.connStringsInvalid' => "Деякі поля порожні або заповнені непідходящими значеннями.",
    'asp-dot-net.settings.connStringName' => "Ім’я",
    'asp-dot-net.settings.connStringValue' => "Параметри з’єднання",
    'asp-dot-net.settings.connStringsDescription' => "Параметри імені / підключення",
    'asp-dot-net.settings.culture' => "Культура",
    'asp-dot-net.settings.customErrMode' => "Режим користувацьких помилок",
    'asp-dot-net.settings.customErrorRedirect' => "URL-адреса переспрямовування",
    'asp-dot-net.settings.customErrorStatus' => "Код статусу",
    'asp-dot-net.settings.customErrorStatusInvalid' => "Код статусу повинен бути цілим числом.",
    'asp-dot-net.settings.customErrors' => "Користувацькі помилки",
    'asp-dot-net.settings.customErrorsDescription' => "Код стану / URL для переспрямовування",
    'asp-dot-net.settings.customErrorsInvalid' => "Деякі поля порожні або заповнені непідходящими значеннями.",
    'asp-dot-net.settings.debugMode' => "Увімкнути налагодження",
    'asp-dot-net.settings.defLanguage' => "Мова веб-сторінки за замовчуванням",
    'asp-dot-net.settings.tempDirectory' => "Тимчасова директорія",
    'asp-dot-net.settings.fileEnc' => "Кодування файлів",
    'asp-dot-net.settings.fileEncInvalid' => "Вказане значення для Параметру кодування файлу невірне.",
    'asp-dot-net.settings.pathToLib' => "Шлях до бібліотеки скриптів Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Встановити",
    'asp-dot-net.settings.reqEnc' => "Кодування запитів",
    'asp-dot-net.settings.reqEncInvalid' => "Вказане значення для Параметру кодування запиту невірне.",
    'asp-dot-net.settings.resEnc' => "Кодування відповідей",
    'asp-dot-net.settings.resEncInvalid' => "Вказане значення для Параметру кодування відповіді невірне.",
    'asp-dot-net.settings.sessTimeout' => "Час очікування сеансу (в хвилинах)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "Вказане значення для Параметру часового ліміту сеансу невірне. Введіть додатне ціле число, менше або рівне %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "Це ім'я рядка підключення вже використовується.",
    'asp-dot-net.settings.customErrorInvalidCode' => "Код стану має бути між 100 та 999",
    'asp-dot-net.settings.customErrorDuplicate' => "Цей код стану вже використовується.",
    'asp-dot-net.settings.trustLevel' => "Рівень безпеки CAS",
    'asp-dot-net.settings.uiCulture' => "Культура UI",
    'asp-dot-net.settings.version' => "Версія",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Дозволити перепризначити рівень довіри CAS на веб-сайті',
    'asp-dot-net.settings.updateSuccess' => 'Оновлено',

    'database.clone.formDescription' => 'Скопіюйте вміст бази даних до нової або вже існучої бази даних. При копіюванні до існуючої бази даних таблиці вихідної бази даних додаються до списку таблиць цільової бази даних. Застереження: якщо імена таблиць співпадають, то таблиця вихідної бази даних замістить таблицю з цільової бази даних.',
    'database.clone.copyData' => 'Зробити повну копію',
    'database.clone.copyDataHint' => 'Якщо вибрана ця опція, весь вміст бази даних, в тому числі структура та дані, буде скопійований. Якщо не вибрана — буде скопійована лише структура бази даних (таблиця).',
    'database.clone.server' => 'Сервер цільової бази даних',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Інше…',
    'database.clone.database' => 'Цільова база даних',
    'database.clone.newDatabase' => 'Створити базу даних з іменем',
    'database.clone.existingDatabase' => 'Копіювати в існуючу базу даних',
    'database.clone.externalDbHost' => 'Ім’я хосту або ІР-адреса',
    'database.clone.externalDbLogin' => 'Ім’я користувача',
    'database.clone.externalDbPassword' => 'Пароль',
    'database.clone.subscription' => 'Підписка цільової бази даних',
    'database.clone.subscription_powerUser' => 'Веб-простір цільової бази даних',
    'database.clone.cloneInProgress' => 'Клонування бази даних %%source%% у базу даних %%destination%%. На вашу електронну пошту буде надіслано повідомлення про хід виконання (%%email%%).',
    'database.clone.unableToClone' => 'Не вдалося копіювати базу даних "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'Не вдалося створити базу даних "%%destination%%" на зазначеному сервері.',
    'database.clone.databaseCloned' => 'База даних "%%source%%" була копійована.',
    'database.clone.emailSubjSuccess' => 'База даних "%%sourceDatabase%%" скопійована.',
    'database.clone.emailSubjFailure' => 'Не вдалось скопіювати базу даних "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'База даних "%%sourceDatabase%%" (%%sourceHost%%) скопійована в базу даних "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'Неможливо копіювати базу даних "%%sourceDatabase%%" (%%sourceHost%%) у базу даних "%%destDatabase%%" (%%destHost%%). Операція копіювання не завершилась успішно.',
    'database.clone.localServer' => 'локальний сервер',

    'database.repair-orphaned.formDescription' => 'Цього користувача було втрачено після процесу відновлення. Для вирішення цього питання надайте пароль цього користувача. Якщо цей користувач має бути sys користувачем без паролю, запустіть утиліту відновлення з порожнім полем для паролю.',
    'database.repair-orphaned.login' => 'Користувацьке ім’я бази даних',
    'database.repair-orphaned.pass' => 'Пароль',
    'database.repair-orphaned.pass2' => 'Підтвердіть пароль',
    'database.repair-orphaned.users' => 'Деякі користувачі вимагають вашої уваги. Є кілька втрачених користувачів, які слід відновити для належного функціонування.',
    'database.repair-orphaned.orphaned' => 'Користувача втрачено. %%gui begin:link%%Repair now%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Відновити',

    'database.repair.fixSelected' => 'Відновити вибране',
    'database.repair.fix' => 'Відновити',

    'database.user.password' => 'Пароль',
    'database.user.passwordConfirmation' => 'Підтвердіть пароль',
    'database.user.server' => 'Сервер бази даних',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'База даних',
    'database.user.anyDatabase' => 'Будь-який',
    'database.user.dataAccess' => 'Доступ до даних',
    'database.user.structureAccess' => 'Доступ до структури',
    'database.user.globalAccess' => 'Глобальні привілеї',
    'database.user.globalAccessHint' => 'Глобальні привілеї працюють для всіх баз даних у межах цього облікового запису хостингу.',
    'database.user.aclRadio' => 'Управління доступом',
    'database.user.aclLocalhost' => 'Дозволити тільки місцеві з’єднання',
    'database.user.aclAny' => 'Дозволити віддалені з’єднання з будь-якого хосту',
    'database.user.aclCustom' => 'Дозволити віддалені з’єднання з',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nВказані хости мають права доступу до бази даних від імені цього користувача.",
    'database.user.remoteAccess' => 'Віддалений доступ',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nВказані IP-адреси мають право доступу до бази даних через правило мережевого екрана. Ваші зміни в цьому переліку будуть попередньо модеровані вашим хостинг-провайдером.",
    'database.user.example' => "Наприклад: %%example%%",
    'database.user.denied' => 'Використовувати системні правила мережевого екрану',
    'database.user.allowed' => 'Дозволити віддалені з’єднання з',
    'database.user.default' => 'Використовуйте дані користувача за замовчуванням для доступу до %%webadmin%%',
    'database.user.remoteAccessHint' => 'Зверніться до свого хостинг-провайдера й переконайтеся, що зазначений вище параметр відповідає поточним правилам брандмауера для вхідного доступу до MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Роль',
    'database.user.roleReadWrite' => 'Читати та записати',
    'database.user.roleWriteOnly' => 'Лише записати',
    'database.user.roleReadOnly' => 'Лише читати',
    'database.user.roleCustom' => 'Користувацький',

    'database.generalSection' => 'Загальні дані',
    'database.name' => 'Ім’я бази даних',
    'database.server' => 'Сервер бази даних',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Пов\'язаний сайт',
    'database.noDomainRelations' => 'Пов’язані сайти відсутні',
    'database.userSection' => 'Користувачі',
    'database.userSectionDescription' => 'Створити для бази даних користувача за замовчуванням. Plesk виконуватиме доступ до бази даних від імені цього користувача. Якщо базі даних не назначено жодного користувача, вона недоступна.',
    'database.createUser' => 'Створити нового користувача бази даних',
    'database.username' => 'Ім\'я користувача бази даних',
    'database.password' => 'Пароль',
    'database.passwordConfirmation' => 'Підтвердіть пароль',
    'database.allDbAccess' => 'Користувач має доступ до всіх баз даних у межах вибраної підписки',
    'database.aclRadio' => 'Управління доступом',
    'database.aclLocalhost' => 'Дозволити тільки місцеві з’єднання',
    'database.aclAny' => 'Дозволити віддалені з’єднання з будь-якого хосту',
    'database.aclCustom' => 'Дозволити віддалені з’єднання з',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nВказані хости мають права доступу до бази даних від імені цього користувача.",
    'database.remoteAccess' => 'Віддалений доступ',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nВказані IP-адреси мають право доступу до бази даних через правило мережевого екрана. Ваші зміни в цьому переліку будуть попередньо модеровані вашим хостинг-провайдером.",
    'database.example' => "Наприклад: %%example%%",
    'database.denied' => 'Використовувати системні правила мережевого екрану',
    'database.allowed' => 'Дозволити віддалені з’єднання з',

    'deployment-section.deploymentDisabledHint' => 'Вивантажити файли зі сховища Git',
    'deployment-section.deploymentEnabledHint' => 'Увімкнути підтримку Git',
    'deployment-section.deploymentSectionLegend' => 'Ваші файли для копіювання до хостингу',
    'deployment-section.deploymentSectionDescriptionHint' => 'Якщо ви залишите підтримку Git вимкненою, кореневі каталоги (корінь веб-сайту/застосунку) будуть створені порожніми, і сайт показуватиме в оглядачі сторінку за замовчуванням.  Вам потрібно вивантажити файли вашого сайта до кореню документа за допомогою FTP або Файлового менеджера. Також ви можете увімкнути Git зараз або пізніше (в секції Веб-сайти та домени) та вивантажити файли зі сховища Git.',

    'dns-zone.add-acl-record.description' => 'Додати IP-адресу DNS-серверу, якому дозволено отримувати копію зони DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'IP-адреса',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'IP-адреса/маска',

    'dns-zone.record.add-title' => "Додати запис ресурсу до шаблону зони",
    'dns-zone.record.add-ns-title' => "Додати сервер імен",
    'dns-zone.record.edit-title' => "Редагувати запис ресурсу",
    'dns-zone.record.edit-success' => "DNS-запис оновлено.",
    'dns-zone.record.add-success' => "DNS-запис створено.",
    'dns-zone.record.type' => "Тип запису",
    'dns-zone.record.domainName' => "Доменне ім’я",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Ім’я серверу",
    'dns-zone.record.optionOff' => 'Вимкнути',
    'dns-zone.record.optionOn' => 'Увімкнути',
    'dns-zone.record.protocol' => "Протокол",
    'dns-zone.record.priority' => "Пріоритетність",
    'dns-zone.record.priorityLow' => "низький (%%priority%%)",
    'dns-zone.record.priorityHigh' => "дуже високий (%%priority%%)",
    'dns-zone.record.weightLow' => "низька (%%weight%%)",
    'dns-zone.record.weightHigh' => "дуже висока (%%weight%%)",
    'dns-zone.record.ipAddress' => "IP-адреса",
    'dns-zone.record.ipAddressDescription' => "Приклад: 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Наприклад, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "IPv6-адреса",
    'dns-zone.record.ipAddressV6Description' => "Наприклад, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Наприклад, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Наприклад, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Наприклад, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Наприклад, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Канонічне ім'я",
    'dns-zone.record.mailDomain' => "Домен електронної пошти",
    'dns-zone.record.mxServer' => "Сервер обміну електронної пошти",
    'dns-zone.record.mxServerPriority' => "Вказати пріоритет сервера обміну електронною поштою",
    'dns-zone.record.txtRecord' => "TXT запис",
    'dns-zone.record.txtRecordString' => "Введіть рядок запису",
    'dns-zone.record.txtSpfSyntax' => "Запис SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Для запису TXT були зазначені некоректні значення.",
    'dns-zone.record.quotedTxtRecord' => "Значення запису TXT має бути одним рядком без лапок.",
    'dns-zone.record.dsRecord' => "DS-запис",
    'dns-zone.record.dsRecordDescription' => "Наприклад, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "Для запису DS було зазначено некоректне значення.",
    'dns-zone.record.serviceName' => "Ім’я сервісу",
    'dns-zone.record.serviceNameDescription' => 'Наприклад, SIP (без символу підкреслення).',
    'dns-zone.record.protocolNameDescription' => 'Наприклад, tcp (без символу підкреслення).',
    'dns-zone.record.portDescription' => 'Наприклад, 25 (без символу підкреслення).',
    'dns-zone.record.srvWeight' => "Відносна вага для записів з однаковим пріоритетом",
    'dns-zone.record.targetHost' => "Хост призначення",
    'dns-zone.record.targetHostDescription' => "Наприклад: example.com",
    'dns-zone.record.targetPort' => "Цільовий порт",
    'dns-zone.record.targetPortDescription' => 'Приклад: 8443.',
    'dns-zone.record.retrieveDataError' => "Дані запису не знайдено.",
    'dns-zone.record.unknownTypeError' => "Невідомий тип DNS запису.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'За наявності запису NULL MX неможливо встановити інший запис NULL MX',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'За наявності запису NULL MX неможливо встановити запис іншого типу',
    'dns-zone.record.masterShouldBeRemote' => "Вам потрібно мати два різних авторитетних сервери імен на окремих вузлах.",
    'dns-zone.record.caaTag' => "Тег",
    'dns-zone.record.caaRecord' => "Значення",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Порт',
    'dns-zone.record.tlsaProtocol' => 'Протокол',
    'dns-zone.record.tlsaUsage' => 'Використання',
    'dns-zone.record.tlsaSelector' => 'Селектор',
    'dns-zone.record.tlsaMatching' => 'Тип, що збігається',
    'dns-zone.record.tlsaCertData' => 'Дані прив\'язування сертифіката',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Докладніше див. %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, розділ 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, розділ 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, розділ 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, розділ 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "псевдонім (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Наприклад, example.com. Порожнє значення означає, що ім\'я хоста збігається з іменем домену.',
    'dns-zone.record.httpsProtocols' => 'Протоколи',
    'dns-zone.record.httpsProtocolsDescription' => 'Розділений комами список протоколів, що підтримуються цільовим об\'єктом. Наприклад, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Примусово використовувати лише вказані протоколи. Наведений вище список протоколів не повинен бути порожнім.',
    'dns-zone.record.httpsIpv4hint' => 'Підказка щодо адрес протоколу IPv4',
    'dns-zone.record.httpsIpv4hintDescription' => 'Список адрес протоколу IPv4, розділених комами, які можуть використовуватися клієнтом для доступу до служби.',
    'dns-zone.record.httpsIpv6hint' => 'Підказка щодо адрес протоколу IPv6',
    'dns-zone.record.httpsIpv6hintDescription' => 'Список адрес протоколу IPv6, розділених комами, які можуть використовуватися клієнтом для доступу до служби.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Секунди",
    'dns-zone.record.invalidValue' => 'Недійсне значення. Воно може бути від 1 секунди до 2147483647 секунд.',
    'dns-zone.record.ttlDefaultValue' => 'Стандартне значення: %%value%% сек.',
    'dns-zone.record.invalidTTL' => 'Указане значення TTL недійсне.',
    'dns-zone.record.invalidIpAddress' => 'Вказана ІР-адреса невірна.',
    'dns-zone.record.invalidIpMaskPair' => 'Указана пара IP-адреса/маска мережі недійсна.',
    'dns-zone.record.invalidCName' => 'Указане канонічне ім’я недійсне.',
    'dns-zone.record.invalidPort' => 'Указаний порт недійсний.',
    'dns-zone.record.invalidTLSACertData' => 'Указані дані прив\'язування сертифіката неприпустимі.',
    'dns-zone.record.invalidTLSAProtocol' => 'Указаний протокол неприпустимий.',
    'dns-zone.record.invalidTLSAUsage' => 'Указане застосування неприпустиме.',
    'dns-zone.record.invalidTLSASelector' => 'Указаний селектор неприпустимий.',
    'dns-zone.record.invalidTLSAMatching' => 'Указаний тип, що збігається, неприпустимий.',

    'dns-zone.restore-default.formHint' => "Тут можна відновити конфігурацію первинної зони згідно з налаштуваннями шаблону DNS за замовчуванням, що використовуються на сервері. Виберіть ІР-адреси для відновлення зони та вкажіть, чи потрібен для домену www-псевдонім.",
    'dns-zone.restore-default.ipv4' => "IPv4-адреса",
    'dns-zone.restore-default.ipv4Hint' => "Приклад: 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "IPv6-адреса",
    'dns-zone.restore-default.ipv6Hint' => "Наприклад, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'Вказана ІР-адреса невірна.',
    'dns-zone.restore-default.customIpHint' => "Записи з цією IP-адресою будуть розглядатися як відкоректовані користувачем і не будуть синхронізовані с загально-серверним DNS-шаблоном.",
    'dns-zone.restore-default.wwwPrefix' => "префікс www",
    'dns-zone.restore-default.previewRecords' => "Відновити записи, що використовуються для попереднього перегляду сайту",

    'dns-zone.soa-record.soaMnameSection' => 'Основне ім\'я сервера',
    'dns-zone.soa-record.soaMname' => 'Ім\'я сервера',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Автовибір)',
    'dns-zone.soa-record.soaRecordSection' => 'Запис SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Оновити',
    'dns-zone.soa-record.retry' => 'Повторити',
    'dns-zone.soa-record.expire' => 'Спливає',
    'dns-zone.soa-record.minimum' => 'Мінімум',
    'dns-zone.soa-record.rnameType' => 'Електронна поштова адреса (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'Адреса електронної пошти особи, що відповідальна за DNS-зону домену. Сервер DNS повертає її у відповіді на запити SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Електронна пошта власника сайту',
    'dns-zone.soa-record.rnameTypeDomain' => 'Електронна поштова адреса домену',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Введіть тільки локальну частину (частина до @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Додаткова електронна пошта',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Заборонити змінювати електронну пошту RNAME на рівні доменів',
    'dns-zone.soa-record.invalidValue' => 'Значення невірне. Воно може бути від 1 секунди до 68 років.',
    'dns-zone.soa-record.advancedSection' => 'Розширені функціональні можливості DNS',
    'dns-zone.soa-record.serialNumberFormat' => 'Для серійного номера використовуйте формат, рекомендований IETF і RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Оберіть цей параметр, якщо в домені виникають проблеми при проходженні перевірки SOA в реєстрі. В реєстрах багатьох доменів потрібний цей формат серійного номеру.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Застосувати налаштування за замовчуванням',
    'dns-zone.soa-record.zoneDefaultsSection' => 'За замовчуванням для зони',
    'dns-zone.soa-record.unitSeconds' => 'секунди',
    'dns-zone.soa-record.unitMinutes' => 'хвилини',
    'dns-zone.soa-record.unitHours' => 'години',
    'dns-zone.soa-record.unitDays' => 'дні',
    'dns-zone.soa-record.unitWeeks' => 'тижні',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'Значення інтервалу оновлення менше години. Це може критично збільшити використання ресурсів та трафік сервера.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Встановлення мінімального TTL-значення, що є більшим за 3 години, може закрити доступ до ваших доменів деяким адміністраторам домену. Рекомендовано встановлювати таке значення тільки в разі, якщо на цьому наполягає реєстратор доменних імен.',
    'dns-zone.soa-record.success' => 'Властивості запису SOA оновлено.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'Стандартний запис SOA відновлено.',

    'domain-info-section.domainName' => 'Доменне ім’я',
    'domain-info-section.emptyDomainName' => 'Будь ласка, надайте доменне ім\'я.',
    'domain-info-section.ipAddress' => 'IP-адреса',
    'domain-info-section.shared' => 'спільна',
    'domain-info-section.exclusive' => 'виділена',
    'domain-info-section.ipAddressHint' => "IP-адреса, за якою розміщений сайт, є мережевою адресою віртуального вузла веб-сайту. Ця IP-адреса буде використовуватись для всіх сайтів, створених в межах підписки.",
    'domain-info-section.ipAddressHint_powerUser' => "IP-адреса, за якою розміщений сайт, є мережевою адресою віртуального вузла веб-сайту. Ця IP-адреса буде використовуватись для всіх сайтів, створених в межах веб-простору.",
    'domain-info-section.userName' => 'Ім’я користувача',
    'domain-info-section.userNameHint' => 'Обліковий запис системного користувача, пов\\\\’язаний з веб-простором, використовується для доступу до розміщених файлів через FTP і SSH.',
    'domain-info-section.emptyLogin' => 'Будь ласка, надайте ім\'я користувача.',
    'domain-info-section.password' => 'Пароль',
    'domain-info-section.emptyPassword' => 'Будь ласка, вкажіть пароль.',
    'domain-info-section.passwordConfirmation' => 'Повторіть пароль',

    'email-address.generalTab' => 'Загальні дані',
    'email-address.generalHint' => 'Якщо цей обліковий запис електронної пошти пов\'\\\\язаний з додатковим користувачем (доступ до розділу Панель замовника активовано), то зміни, які ви робите на цій сторінці, вплинуть на налаштування цього користувача. Зокрема, якщо ви зміните електронну адресу та пароль, то ім\\\\’я та пароль додаткового користувача також зміняться відповідно до нових значень.',
    'email-address.redirectTab' => 'Пересилання',
    'email-address.redirectHint' => 'Налаштуйте перенаправлення епоштових повідомлень на одну або більше епоштових адрес.',
    'email-address.aliasesTab' => 'Альтернативні імена електронної пошти',
    'email-address.autoResponderTab' => 'Автовідповідь',
    'email-address.antispamTab' => 'Спам-фільтр',
    'email-address.autoResponderHint' => 'Встановіть автоматичну відповідь на будь-яке повідомлення, що надходить на вашу адресу електронної пошти. Автовідповідач є стандартним засобом повідомити вашим кореспондентам, що ви не в офісі або знаходитесь у відпустці.',
    'email-address.antivirusTab' => 'Антивірус',
    'email-address.name' => 'Електронна адреса',
    'email-address.externalEmail' => 'Додаткова електронна пошта',
    'email-address.externalEmailHint' => 'Буде використовуватися для відновлення паролю, якщо ви втратите доступ до основної електронної пошти.',
    'email-address.user' => 'Призначено',
    'email-address.password' => 'Пароль',
    'email-address.passwordConfirmation' => 'Підтвердіть пароль',
    'email-address.clientConfigurationLink' => 'Посилання на конфігуратор пошти',
    'email-address.responderEnable' => 'Увімкнути авто-відповідь',
    'email-address.responderSubject' => 'Тема повідомлення авто-відповіді',
    'email-address.responderContentType' => 'Формат повідомлення',
    'email-address.responderContentTypeHint' => 'Формат "чистого тексту" підтримується всіма поштовими клієнтськими програмами, тобто всі одержувачі зможуть бачити це повідомлення так, як і ви. HTML-повідомлення виглядають краще, адже вони дозволяють вам форматувати текст, використовуючи різні шрифти. Але деякі поштові клієнти не підтримують HTML-повідомлення, і тому деякі одержувачі можуть і не побачити відформатований текст.',
    'email-address.responderContentTypeTextPlain' => 'Звичайний текст',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Кодування',
    'email-address.responderCodepageHint' => 'Кодування визначає, як будуть відображені символи тексту. Рекомендованим типом кодування виступає UTF-8.',
    'email-address.responderReplyTo' => 'Перенаправити до',
    'email-address.responderReplyToHint' => 'Коли відправляється автоматична відповідь, оригінальне повідомлення перенаправляється на вказану електронну адресу.',
    'email-address.responderForwardAddress' => 'Перенаправити до',
    'email-address.responderForwardAddressHint' => 'Коли відправляється автоматична відповідь, оригінальне повідомлення перенаправляється на вказану електронну адресу.',
    'email-address.responderMessage' => 'Текст повідомлення авто-відповіді',
    'email-address.responderReplyToEqualsEmail' => 'Вказана адреса перенаправлення співпадає з цією електронною адресою.',
    'email-address.responderForwardAddressEqualsEmail' => 'Вказана адреса перенаправлення співпадає з цією електронною адресою.',
    'email-address.responderReplyLimit' => 'Відправляти автовідповідь на унікальну електронну адресу не частіше, ніж (разів на день)',
    'email-address.buttonAddResponderAttachment' => 'Додати нове вкладення',
    'email-address.buttonRemoveResponderAttachment' => 'Видалити',
    'email-address.responderAttachment' => 'Прикріпити файл',
    'email-address.redirectEnable' => 'Включити перенаправлення пошти',
    'email-address.redirectRemoveEnable' => 'Не доставляти копії перенаправлених епошт до поштової скриньки Plesk',
    'email-address.redirectAddress' => 'Перенаправте всі вхідні повідомлення на таку електронну адресу',
    'email-address.redirectAddressHint' => 'Вкажіть електронні адреси. ви можете вводити кожну адресу в новому рядку або розділяти адреси пробілами, комами або крапкою з комою.',
    'email-address.role' => 'Роль користувача',
    'email-address.roleHint' => 'Ролі користувача надають користувачам адміністративні привілеї та доступ до застосунків, які ви обрали для певної ролі.',
    'email-address.errorRedirectAddress' => 'Вказана недійсна електронна адреса: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Вказані недійсні електронні адреси: %value%.',
    'email-address.mailAlias' => "Поштові псевдоніми",
    'email-address.mailAliasNone' => 'Немає',
    'email-address.mailAliasHint' => "Поштові псевдоніми – це альтернативні електронні адреси, пов’язані з вашою основною електронною адресою. Вся пошта, надіслана на поштові псевдоніми, буде отримуватися основною електронною адресою.",
    'email-address.buttonAddMailAlias' => 'Додати альтернативне ім’я електронної пошти',
    'email-address.buttonRemoveMailAlias' => 'Видалити',
    'email-address.emptyEmail' => 'Вкажіть електронну адресу, на яку будуть перенаправлені всі вхідні повідомлення.',
    'email-address.emailsIsEqual' => 'Додаткова електронна пошта співпадає з основною. Вкажіть іншу пошту у якості додаткової.',
    'email-address.emptyPassword' => 'Вам необхідно ввести пароль.',
    'email-address.emptyPasswordConfirmation' => 'Вам необхідно підтвердити пароль.',
    'email-address.emptyAlias' => "Вкажіть альтернативний електронна адреса для цієї електронної адреси",
    'email-address.aliasEqualsEmail' => 'Вказане альтернативне ім’я електронної пошти співпадає з її адресою.',
    'email-address.passwordHint' => 'Буде використовуватися для доступу до поштової скриньки та входу в Plesk (якщо відповідна опція ввімкнена).',
    'email-address.cyclicRedirect' => 'Неможливо вказати адресу електронної пошти для пересилання повідомлень на цю ж адресу.',
    'email-address.errorMailnameReserved' => 'Вказана адреса електронної пошти вже використовується.',
    'email-address.antivirusEnable' => 'Увімкнути захист від вірусів для цієї адреси електронної пошти',
    'email-address.antivirusHint' => 'Служба антивірусу блокує повідомлення електронної пошти, які містять віруси, та надсилає повідомлення про це відправнику та одержувачу.',
    'email-address.antivirusSettings' => 'Перевірити на віруси',
    'email-address.antivirusSettingOnlyIncomingMail' => 'тільки вхідна електронна пошта',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'тільки вихідна електронна пошта',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'вхідна та вихідна електронна пошта',
    'email-address.antispamHint' => 'Служба фільтрації спаму знаходить спам, який надсилається на вашу електрону пошту. ви можете визначити для спам-фільтру, що робити зі спамом: видаляти повідомлення, робити відповідну помітку в темі повідомлення або переміщати спам у спеціальну папку, яка доступна для поштових клієнтів через IMAP. Спам-фільтр використовує багато різних локальних та мережевих тестів для ідентифікації ознак спаму.',
    'email-address.antispamEnable' => 'Увімкнути фільтрацію спаму для цієї адреси електронної пошти',
    'email-address.antispamSettings' => 'Що робити з повідомленнями, визначеними як спам',
    'email-address.antispamSettingsMark' => 'Позначати спам шляхом додання до теми повідомлення такого тексту',
    'email-address.antispamSettingsMarkHint' => 'Залиште це поле порожнім, якщо ви не бажаєте додава текст. Введіть _SCORE_, якщо ви бажаєте включити оцінювання до теми повідомлення.',
    'email-address.antispamReportTextHint' => 'Введіть текст, який буде доданий до тіла повідомлень спаму.',
    'email-address.antispamSettingsDelete' => 'Видалити весь спам',
    'email-address.antispamSettingsDeleteHint' => 'Спам буде видалений з вашої поштової скриньки.',
    'email-address.antispamSettingsMove' => 'Перемістити спам у папку Спам',
    'email-address.antispamSettingsMoveHint' => 'Весь спам буде переміщений у папку на ім\'я Спам. Ця папка доступна через вашу програму поштового клієнту або веб-пошту. Якщо ви використовуєте поштовий обліковий запис IMAP, ви можете використовувати папку Спам для "навчання" спам-фільтру.',
    'email-address.antispamSettingsMoveWarning' => '"Перемістити спам до папки Спам" не працює, ящо ви не вимкнете опцію "Не доставляти копії перенаправлених епошт" у вкладці "Перенаправлення".',
    'email-address.antispamSettingsMoveJunk' => 'Перемістити спам до папки «Небажана пошта»',
    'email-address.antispamSettingsMoveJunkHint' => 'Перемістити всі спам-повідомлення до папки «Небажана пошта». Доступ до цієї папки є можливий з вашого поштового клієнта або веб-пошти. Якщо ви користуєтесь поштовим обліковим записом IMAP, ви можете використовувати папку «Небажана пошта» для "навчання" спам-фільтру.',
    'email-address.antispamShowAdvancedSection' => 'Показати додаткові параметри',
    'email-address.antispamHideAdvancedSection' => 'Приховати додаткові параметри',
    'email-address.antispamLearnMore' => 'Дізнайтесь, як "навчити" спам-фільтр.',
    'email-address.antispamFilterScoreTitle' => 'Чутливість фільтру',
    'email-address.antispamFilterScoreHint' => 'Спам-фільтр виконує багато різних перевірок вмісту та теми кожного повідомлення. В результаті кожне повідомлення набирає певну кількість балів. Чим більше балів, тим більше повідомлення схоже на спам. За замовчуванням чутливість фільтру спаму налаштована так, що всі повідомлення, які отримали 7 балів та більше, визначаються як спам. Якщо з поточними налаштуваннями ви отримуєте багато спаму, спробуйте збільшити чутливість фільтру, наприклад до 6. Якщо вам не доходять деякі потрібні повідомлення через те, що фільтр визначає їх як спам, спробуйте зменшити чутливість фільтру, наприклад до 8.',
    'email-address.antispamFilterScore' => 'Чутливість спам-фільтру',
    'email-address.antispamWhiteListTitle' => 'Білий список',
    'email-address.antispamWhiteListHint' => 'Електронні повідомлення від відправників з білого списку не перевіряються спам-фільтром.',
    'email-address.antispamWhiteListField' => 'Білий список',
    'email-address.antispamWhiteListFieldHint' => 'Введіть імена доменів — по одному домену в рядку. Адреси можуть містити символи підстановки "*" та "?". Наприклад, *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Чорний список',
    'email-address.antispamBlackListHint' => 'Електронні повідомлення від відправників з чорного списку класифікуються як спам.',
    'email-address.antispamBlackListField' => 'Чорний список',
    'email-address.antispamBlackListFieldHint' => 'Введіть імена доменів — по одному домену в рядку. Адреси можуть містити символи підстановки "*" та "?". Наприклад, *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Надійні мови',
    'email-address.antispamTrustedLanguagesHint' => 'Повідомлення електронної пошти, написані на цих мовах, завжди будуть проходити спам-фільтр.',
    'email-address.antispamTrustedLocalesTitle' => 'Надійні регіональні групи',
    'email-address.antispamTrustedLocalesHint' => 'Повідомлення електронної пошти, які використовують вказані регіональні групи, завжди будуть проходити фільтр. Регіональні групи містять найбільш поширені набори символів. Наприклад, західний набір символів містить кодування символів англійської та західноєвропейських мов.',
    'email-address.antispamTrustedNetworksTitle' => 'Довірені мережі',
    'email-address.antispamTrustedNetworksHint' => 'Проміжні вузли в надійних мережах не є відкритими ретрансляторами або відкритими проксі-серверами. Вважається, що вони не будуть використані спамерами.',
    'email-address.antispamIpAddressesField' => 'ІР-адреси',
    'email-address.antispamIpAddressesFieldHint' => 'Вкажіть мережеву IP-адресу та маску мережі.',
    'email-address.mailBoxQuotaDomainDefault' => 'Розмір за замовчуванням (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Розмір за замовчуванням',
    'email-address.mailBoxOutgoingMessages' => 'Максимальна кількість вихідних поштових повідомлень',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'За замовчуванням (%%domainOutgoingMessages%% повідомлень за годину)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Користувацьке значення для поштової скриньки',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'повідомлення',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'За замовчуванням',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Розмір за замовчуванням',
    'email-address.mailBoxQuotaDomainSpecific' => 'Інший розмір',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Розмір поштової скриньки',
    'email-address.mailBoxQuotaUnlimited' => 'Необмежений',
    'email-address.mailBoxLimitReached' => 'Досягнуто ліміту кількості поштових скриньок.',
    'email-address.postboxEnabled' => 'Поштова скринька',
    'email-address.postboxEnabledYes' => 'Увімк.',
    'email-address.postboxEnabledNo' => 'Вимк.',
    'email-address.description' => 'Опис у Plesk',
    'email-address.descriptionHint' => 'Опис видно кожному, хто має доступ до цього облікового запису електронної пошти.',
    'email-address.longDescription' => 'Зазначений опис занадто довгий. Він не може перевищувати %%max%% символів.',
    'email-address.loginAsUser' => 'Використовується, щоб увійти в Plesk',
    'email-address.loginAsUserDescription' => '(ім’я користувача: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'Розмір електронної пошти не може перевищувати розмір за замовчуванням.',
    'email-address.endDateEnable' => 'Вимкніть автовідповідач на',

    'failed-request.enable-tracing.description' => 'Трасування невдалих запитів є ресурсоємною операцією. Трасування автоматично зупинеться через %%days%% днів. Можете його зупинити вручну в будь-який час.',
    'failed-request.enable-tracing.statusCodes' => 'Коди стану',
    'failed-request.enable-tracing.statusCodesDescription' => 'Приклад: 401,3-999, 405',
    'failed-request.enable-tracing.provider' => 'Постачальник',

    'file-manager.show.buttonReload' => 'Перезавантажити',
    'file-manager.show.buttonSave' => 'Зберегти',
    'file-manager.show.buttonSaveAs' => 'Зберегти як',
    'file-manager.show.buttonReset' => 'Скинути',
    'file-manager.show.buttonTextCodeEditor' => 'Редагувати в Code Editor',
    'file-manager.show.buttonTextEdit' => 'Редагування в текстовому редакторі',
    'file-manager.show.buttonWysiwygEdit' => 'Редагування в HTML редакторі',
    'file-manager.show.eolLabel' => 'Тип розриву рядка:',
    'file-manager.show.saveAs' => 'Зберегти як:',
    'file-manager.show.saveCodepage' => 'Зберегти в такому кодуванні:',
    'file-manager.show.loadCodepage' => 'Переглянути початковий файл у такому кодуванні:',
    'file-manager.show.loadCodepageHint' => 'Попередження: будь-які незбережені зміни будуть втрачені при перезавантажені файлу.',
    'file-manager.show.fileExists' => "Файл або папка %%fileName%% вже існує. Не можна мати папку і файл з однаковим ім’ям.",
    'file-manager.show.popupTitle' => 'Зберегти як',
    'file-manager.show.popupFilename' => 'Назва файла:',

    'file-manager.permissions.filePermissions' => 'Дозволи файлу',
    'file-manager.permissions.directoryPermissions' => 'Дозволи директорії',
    'file-manager.permissions.buttonSubmit' => 'Зберегти',
    'file-manager.permissions.buttonApply' => 'Зберегти та продовжити',
    'file-manager.permissions.buttonCancel' => 'Скасувати',
    'file-manager.permissions.buttonAdvanced' => 'Додаткові параметри',

    'file-manager.unix-file-permissions.group' => 'Група',
    'file-manager.unix-file-permissions.owner' => 'Власник',
    'file-manager.unix-file-permissions.others' => 'Інші',
    'file-manager.unix-file-permissions.readMode' => 'Зчитати',
    'file-manager.unix-file-permissions.writeMode' => 'Записати',
    'file-manager.unix-file-permissions.execMode' => 'Виконати/шукати',
    'file-manager.unix-file-permissions.changeRecursive' => 'Змінювати дозволи рекурсивно',

    'file-manager.windows-permissions.allow' => 'Дозволити',
    'file-manager.windows-permissions.deny' => 'Скасувати',
    'file-manager.windows-permissions.inheritFromParent' => 'Дозволити спадкування дозволів від батьківського об\'єкту для переходу до цього об\'єкту і його дочірніх об\'єктів. Включити це разом із записами, вочевидь тут визначеними',
    'file-manager.windows-permissions.replaceOnChildren' => 'Замінити записи дозволів на всіх дочірніх об’єктах записами, відображеними тут',
    'file-manager.windows-permissions.buttonAdvanced' => 'Додаткові параметри',
    'file-manager.windows-permissions.applyTo' => 'Застосувати для:',
    'file-manager.windows-permissions.folderOnly' => 'Лише цієї папки',
    'file-manager.windows-permissions.subfolderOnly' => 'Лише вкладених папок',
    'file-manager.windows-permissions.filesOnly' => 'Лише файлів',
    'file-manager.windows-permissions.permissionsFor' => 'Дозволи для',
    'file-manager.windows-permissions.applyOnto1' => 'Лише цієї папки',
    'file-manager.windows-permissions.applyOnto2' => 'Лише вкладених папок',
    'file-manager.windows-permissions.applyOnto3' => 'Цієї папки та вкладених папок',
    'file-manager.windows-permissions.applyOnto4' => 'Лише файлів',
    'file-manager.windows-permissions.applyOnto5' => 'Ця папка і файли',
    'file-manager.windows-permissions.applyOnto6' => 'Лише підпапка і файли',
    'file-manager.windows-permissions.applyOnto7' => 'Ця папка, підпапка і файли',
    'file-manager.windows-permissions.notInherited' => '<не успадковано>',

    'file-manager.editor.titleTextEditor' => 'Текстовий редактор',
    'file-manager.editor.titleCodeEditor' => 'Редактор коду',
    'file-manager.editor.titleCodeViewer' => 'Переглянути',
    'file-manager.editor.buttonSubmit' => 'Зберегти',
    'file-manager.editor.buttonApply' => 'Зберегти та продовжити',
    'file-manager.editor.buttonSaveAs' => 'Зберегти як ...',
    'file-manager.editor.buttonCancel' => 'Скасувати',
    'file-manager.editor.exitConfirmationYes' => 'Так',
    'file-manager.editor.exitConfirmationNo' => 'Ні',
    'file-manager.editor.fileOverwrite' => 'Файл вже існує.',
    'file-manager.editor.fileOverwriteDescription' => 'Файл з такою назвою уже існує. Ви бажаєте переписати його?',
    'file-manager.editor.exitConfirmation' => 'Ви впевнені, що хочете закрити файл та проігнорувати незбережені зміни?',
    'file-manager.editor.buttonCodeEditor' => 'Редагувати в Редакторі коду',
    'file-manager.editor.buttonTextEditor' => 'Редагування в текстовому редакторі',
    'file-manager.editor.buttonHtmlEditor' => 'Редагування в HTML-редакторі',

    'file-manager.import-file.buttonSubmit' => 'Імпортувати',
    'file-manager.import-file.fieldUrl' => 'URL для файлу',
    'file-manager.import-file.fieldUrlDescription' => 'Зазначте джерельний URL, наприклад, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'Повний шаблон URL наступний: \'https://user:password@example.com/example.tgz\'. Ім\'я користувача та пароль необов\'язкові. Підтримувані протоколи: http, https, ftp, ftps. Використовуйте кодування URL для частин URL, що містять особливі символи або пробіли.',
    'file-manager.import-file.failure' => 'Не вдається імпортувати файл.',

    'file-manager.rotation-settings.title' => 'Налаштування обертання Кошика',
    'file-manager.rotation-settings.rotationBySize' => 'Обертання за розміром',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'МБ',
    'file-manager.rotation-settings.rotationBySizeHint' => 'Цей параметр видаляє нові файли, якщо перевищено зазначений ліміт розміру кошику.',
    'file-manager.rotation-settings.rotationByDate' => 'Обертання за датою',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Дні',
    'file-manager.rotation-settings.rotationByDateHint' => 'Опція видаляє файли, що зберігаються в кошику довше за вказану кількість днів.',
    'file-manager.rotation-settings.save' => 'Зберегти',
    'file-manager.rotation-settings.cancel' => 'Скасувати',

    'ftp-user.description' => 'Якщо ви працюєте на вашому веб-сайті разом з ще кимось або розміщаєте субдомени для інших користувачів, ви можете створити для них окремі облікові записи FTP.',
    'ftp-user.generalSection' => 'Загальні дані',
    'ftp-user.login' => 'Ім’я облікового запису FTP',
    'ftp-user.home' => 'Домашній каталог',
    'ftp-user.systemArea' => 'Створити обліковий запис FTP з доступом до файлів за межами домашнього каталогу',
    'ftp-user.password' => 'Пароль',
    'ftp-user.passwordConfirmation' => 'Підтвердіть пароль',
    'ftp-user.hardQuotaSection' => 'Квота жорсткого диску',
    'ftp-user.hardQuota' => 'Квота жорсткого диску',
    'ftp-user.hardQuotaUnlimited' => 'Необмежений',
    'ftp-user.permissionsSection' => 'Права доступу',
    'ftp-user.permissionRead' => 'Дозвіл на читання',
    'ftp-user.permissionWrite' => 'Написати дозвіл',
    'ftp-user.popupTitle' => 'Вибрати каталог',
    'ftp-user.limitMbUnits' => 'Мбайт',

    'mail-list.listName' => 'Адреси поштової розсилки',
    'mail-list.enabled' => 'Увімкнено',
    'mail-list.administratorEmail' => 'Адреса електронної пошти адміністратора розсилки',
    'mail-list.password' => 'Пароль',
    'mail-list.passwordConfirmation' => 'Підтвердіть пароль',
    'mail-list.subscribers' => 'Передплатники',
    'mail-list.subscribersHint' => 'Вкажіть електронні адреси. ви можете вводити кожну адресу в новий рядок або відділяти адреси пробілами, комами або крапкою з комою.',
    'mail-list.notify' => 'Сповістіть адміністратора про створення поштової розсилки',
    'mail-list.emptyPassword' => 'Надати пароль.',
    'mail-list.emptyPasswordConfirmation' => 'Будь ласка, підтвердіть пароль.',
    'mail-list.errorSubscribers' => 'Невірні поштові адреси: %value%.',
    'mail-list.errorMaillistReserved' => 'Вказаний список поштових адрес вже використовується.',

    'mail-settings.copyToClipboard' => 'Копіювати запис служби DNS у буфер обміну.',
    'mail-settings.copySuccess' => 'Запис служби DNS скопійовано в буфер обміну.',
    'mail-settings.hint' => 'Тут можна змінити налаштування поштового сервісу для цього домену.',
    'mail-settings.service' => 'Поштова служба на цьому домені',
    'mail-settings.nonExist' => 'Що робити з поштою для неіснуючих користувачів',
    'mail-settings.nonExistBounceWithMessage' => 'Недоставка з повідомленням',
    'mail-settings.nonExistBounce' => 'Повернути',
    'mail-settings.nonExistCatch' => 'Перенаправте на адресу',
    'mail-settings.nonExistCatchDescription' => 'Адреса повинна належати вибраному домену. Тільки адміністратор може зазначати зовнішню адресу або одну адресу для декількох доменів.',
    'mail-settings.nonExistExternal' => 'Перенаправити на зовнішній поштовий сервер з ІР-адресою',
    'mail-settings.nonExistReject' => 'Відмовити',
    'mail-settings.nonExistDiscard' => 'Відмовити',
    'mail-settings.webmail' => 'Поштовий веб-інтерфейс',
    'mail-settings.webmailNone' => 'Немає',
    'mail-settings.webmailComponentNotInstalled' => 'Компонент веб-пошти не встановлено.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Існує субдомен з ім’ям %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Сертифікат SSL/TLS для веб-пошти',
    'mail-settings.webmailCertificateNone' => 'Не вибрано',
    'mail-settings.mailCertificate' => 'Сертифікат SSL/TLS для веб-пошти',
    'mail-settings.mailCertificateNone' => 'Не вибрано',
    'mail-settings.serverCertificateNotSelected' => 'Сертифікат призначено, але пошта домену не захищена. Для забезпечення захисту електронної пошти для домену необхідно: %%certLink%%',
    'mail-settings.serverCertificatesList' => 'захистити поштовий сервер',
    'mail-settings.mailLists' => 'Включити списки поштової розсилки',
    'mail-settings.mailAutodiscovery' => 'Увімкнути автовиявлення пошти',
    'mail-settings.mailAutodiscoveryDescription' => 'Дізнайтеся, як це працює, у %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'базі знань',
    'mail-settings.domainKeys' => 'Використовуйте систему захисту від спаму DKIM для підписання вихідних повідомлень електронної пошти',
    'mail-settings.activeDkimSelector' => 'Активний селектор DKIM',
    'mail-settings.defaultDkimSelector' => ' (за замовчуванням Plesk)',
    'mail-settings.dkimSelectorName' => 'Ім’я селектора',
    'mail-settings.buttonCreateSelector' => 'Створити новий селектор DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Створити селектор DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Видалити селектор DKIM',
    'mail-settings.removeSelectorConfirmation' => "Видалити селектор '%%selector%%' і пов'язані з ним ключі й записи служби DNS?",
    'mail-settings.buttonConfirm' => 'ОК',
    'mail-settings.buttonCreate' => 'Створити',
    'mail-settings.buttonCancel' => 'Скасувати',
    'mail-settings.labelRemoveSelector' => 'Видалити',
    'mail-settings.labelActiveSelector' => 'Активне',
    'mail-settings.greyListing' => 'Включити захист від спаму сірим списком для всіх поштових облікових записів у цьому домені.',
    'mail-settings.howToConfigureExternalDns' => 'Як налаштувати зовнішній DNS',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Для вмикання підписування DKIM у разі використання зовнішнього сервера DNS, вам потрібно самостійно налаштувати записи DKIM DNS на DNS сервері.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Для цього, скористайтеся записами DKIM DNS внизу:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Якщо у вас є псевдоніми доменів, які ви використовуєте для надсилання пошти, додайте записи DKIM DNS і для них також. Використовуйте ті ж записи, що і для головного домена, але з псевдонімом домена.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Для перегляду записів DKIM DNS вам потрібно налаштувати, поставити прапорець "%%option%%", застосувати його, та відкрити це спливаюче вікно знову.',
    'mail-settings.mailServiceDisabled' => 'Вимкнено',
    'mail-settings.mailServiceDisabledIncoming' => 'Вимкнено для вхідної пошти',
    'mail-settings.mailServiceDisabledHint' => 'Plesk не надаватиме жодних поштових послуг у цьому домені.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Цей домен може тільки надсилати пошту та тільки за допомогою Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Увімкнено',
    'mail-settings.mailServiceEnabledHint' => 'Цей домен може надсилати та отримувати пошту.',
    'mail-settings.mailServiceNotConfigured' => 'Не налаштовано',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk не надаватиме жодних поштових послуг у цьому домені.',
    'mail-settings.warning' => 'Буде назавжди видалено поштові скриньки домену з усіма отриманими та надісланими електронними листами.',
    'mail-settings.show.title' => 'Видалити всі поштові скриньки й електронні листи %%domain%%',
    'mail-settings.show.checkbox' => 'Назавжди видалити всі поштові скриньки %%domain%% включно з отриманими й надісланими електронними листами.',

    'role.roleSection' => 'Загальні дані',
    'role.name' => 'Рольове ім’я користувача',
    'role.description' => 'Опис',
    'role.generalPermissionsSection' => 'Доступ до сервісів Plesk',
    'role.applicationsAccessSection' => 'Доступ до застосунків',
    'role.permissionAllow' => 'Забезпечено',
    'role.permissionDeny' => 'Відмовлено',
    'role.emptyRoleName' => 'Будь ласка, введіть рольове ім’я.',
    'role.installedAt' => 'Встановлено до',
    'role.noInstallationUrlAvailable' => 'Зовнішній застосунок',
    'role.invalidRoleName' => 'Вказане рольове ім’я користувача неправильне. Знак питання та лапки не можуть використовуватися в рольовому імені.',
    'role.longRoleName' => 'Вказане рольове ім’я користувача занадто довге.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'Деякі операції можуть бути недоступні з таких причин: дозвіл на виконання операції не надається поточною підпискою, або для виконання цієї операції недостатньо виділених ресурсів.',
    'role.servicesPermissionsDescription' => 'Визначити доступ до встановлених застосунків або сервісів Plesk для всіх користувачів з цією роллю. Якщо ви надаєте користувацький доступ до застосунку, застосунок стане для них доступним з розділу Панель замовника.',
    'role.emailActivation' => 'Активувати облікові записи цієї ролі за допомогою електронної пошти',

    'service.admin-access.adminAccess' => 'Адміністративний доступ',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Ці повноваження будуть використані для адміністративного доступу до цього застосунку.',
    'service.admin-access.login' => 'Адміністративне ім’я користувача',
    'service.admin-access.password' => 'Адміністративний пароль',
    'service.admin-access.passwordConfirmation' => 'Підтвердіть пароль',

    'service.info.service-entry-point.availableAt' => 'Доступний на',
    'service.info.service-entry-point.customize' => 'Налаштувати ярлик',
    'service.info.service-entry-point.displayNameLabel' => 'Ім’я ярлика',
    'service.info.service-entry-point.displayNameDescription' => 'Надайте ім’я для цього ярлика. Ім’я буде вказане під зображенням ярлика. Ярлики розміщаються на сторінках Мої сервіси тих користувачів, які отримали доступ до цього застосунку.',
    'service.info.service-entry-point.descriptionLabel' => 'Опис ярлика',
    'service.info.service-entry-point.descriptionDescription' => 'Надайте опис цього ярлика. Опис виводиться в якості підказки, коли курсор миші наводиться на ярлик.',
    'service.info.service-entry-point.iconLabel' => 'Натисніть, щоб вибрати зображення для ярлика',
    'service.info.service-entry-point.iconCurrent' => 'Поточне зображення',
    'service.info.service-entry-point.errorEmptyName' => 'вам необхідно надати ім’я ярлика',
    'service.info.service-entry-point.errorLongName' => 'Ім’я ярлика має бути від 1 до 255 знаків.',
    'service.info.service-entry-point.errorLongDescription' => 'Опис ярлика необхідно вмістити від 0 до 255 знаків.',
    'service.info.service-entry-point.hiddenLabel' => 'Сховати ярлик',
    'service.info.service-entry-point.hiddenDescription' => 'Не показувати ярлик користувачам.',

    'service.info.service-permission.assignedUser' => "Надати доступ адміністратора цьому користувачу",
    'service.info.service-permission.assignedUserNone' => 'Немає призначених користувачів',

    'shared-ssl.master-ssl.switchedOn' => 'Включити спільний SSL/TLS',
    'shared-ssl.master-ssl.domainName' => 'Доменне ім’я сайту, чий сертифікат SSL/TLS буде розділено між іншими сайтами',
    'shared-ssl.master-ssl.none' => 'Немає',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'Неможливо ввімкнути спільний SSL/TLS, оскільки немає доступних доменів з ввімкненою підтримкою SSL/TLS.',

    'user.email.email' => 'Електронна адреса',
    'user.email.emptyEmail' => 'Вам необхідно вказати електронну пошту.',
    'user.email.internalEmailHint' => 'Створіть нову електронну пошту у Plesk або скористайтеся додатковою.',
    'user.email.longInternalEmail' => 'Адреса електронної пошти занадто довга.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'Ім\'я користувача, зазначене в адресі електронної пошти, занадто довге для цього поштового серверу. Будь ласка, зазначте ім\'я користувача довжиною не більш ніж %%max%% символів.',
    'user.email.longInternalEmailFullAddressMailServer' => 'Адреса електронної пошти занадто довга для цього поштового серверу. Будь ласка, зазначте адресу довжиною не більш ніж %%max%% символів.',
    'user.email.externalEmail' => 'Додаткова електронна пошта',
    'user.email.externalEmailHint' => 'Буде використовуватися для відновлення паролю, якщо ви втратите доступ до основної електронної пошти.',
    'user.email.emailsIsEqual' => 'Додаткова електронна пошта співпадає з основною. Вкажіть іншу пошту у якості додаткової.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Зазначте внутрішню або зовнішню адресу електронної пошти.',

    'user.profileSection' => 'Загальна інформація',
    'user.contactName' => 'Ім’я контакту',
    'user.email' => 'Електронна адреса',
    'user.role' => 'Роль користувача',
    'user.accountSection' => 'Параметри Plesk',
    'user.login' => 'Ім’я користувача',
    'user.password' => 'Пароль',
    'user.oldPassword' => 'Старий пароль',
    'user.buttonBack' => 'Назад',
    'user.generalTab' => 'Загальні дані',
    'user.applicationsAccessSection' => 'Сервіси',
    'user.generalPermissionsSection' => 'Привілеї',
    'user.contactsTab' => 'Контактна інформація',
    'user.passwordConfirmation' => 'Підтвердіть пароль',
    'user.internalEmailPasswordChanged' => 'Зміна пароля також змінить внутрішній пароль епоштової адреси.',
    'user.emailName' => 'Електронна адреса',
    'user.emailType' => 'Тип електронної пошти',
    'user.companyName' => 'Назва компанії',
    'user.phone' => 'Номер телефону',
    'user.imNumber' => 'Програма для обміну миттєвими повідомленнями',
    'user.fax' => 'Факс',
    'user.address' => 'Адреса',
    'user.city' => 'Місто',
    'user.state' => 'Країна чи область',
    'user.zip' => 'Поштовий код або Індекс',
    'user.country' => 'Країна',
    'user.additionalInfo' => 'Додаткова інформація',
    'user.additionalInfoHint' => 'Тільки простий текст: всі HTML-теги будуть ігноруватися.',
    'user.language' => 'Мова Plesk',
    'user.buttonChangePassword' => 'Змінити пароль',
    'user.permissionAllow' => 'Забезпечено',
    'user.permissionDeny' => 'Відмовлено',
    'user.permissionInherited' => 'Визначений роллю',
    'user.emptyContactName' => 'вам необхідно вказати контактне ім’я.',
    'user.emptyLogin' => 'Вам необхідно вказати ім’я користувача.',
    'user.emptyPassword' => 'Вам необхідно ввести пароль.',
    'user.emptyPasswordConfirmation' => 'Вам необхідно підтвердити пароль.',
    'user.oldPasswordIsIncorrect' => 'Старий пароль невірний. Будь ласка, спробуйте ще раз.',
    'user.chooseDomainBoxTitle' => 'Оберіть інший домен:',
    'user.userIsActive' => 'Профіль користувача активний',
    'user.userIsActiveHint' => 'Користувачі з активним профілем мають доступ до Plesk.',
    'user.emailActivation' => 'Активувати обліковий запис через електронну пошту',
    'user.emailHint' => 'Для того, щоб надати користувачу електронну адресу, яка б знаходилася на цьому сервері, перейдіть на вкладку "Пошта" та створіть конкретну електронну адресу, після чого зв’яжіть її з користувачем.',
    'user.emailContactHint' => 'Якщо бажаєте використовувати електронну адресу, що знаходиться на цьому сервері, зверніться до вашого постачальника послуг.',
    'user.personalEmailHint' => "Електронну адреск цього користувача можна змінити  у вкладці \"Пошта\".",
    'user.externalMailRedirectHint' => 'Перенаправлення можна ввімкнути лише для електронних адрес, розміщених на цьому сервері. Для створення електронної адреси перейдіть на вкладку Пошта.',
    'user.externalMailRedirectHint2' => 'Перенаправлення можна ввімкнути лише для електронних адрес, розміщених на цьому сервері.',
    'user.externalMailAutoResponderHint' => 'Автовідповідь можна ввімкнути лише для електронних адрес, розміщених на цьому сервері. Для створення електронної адреси перейдіть на вкладку Пошта.',
    'user.externalMailAutoResponderHint2' => 'Автовідповідь можна ввімкнути лише для електронних адрес, розміщених на цьому сервері.',
    'user.roleHint' => 'Ролі користувача дають користувачам адміністративні привілеї та доступ до застосунків, які ви обрали для певної ролі.',
    'user.cannotManageMail' => "У вас немає дозволу на управління поштовими налаштуваннями та сервісами.",
    'user.longCompanyName' => 'Вказане ім’я компанії занадто довге.',
    'user.longPhone' => 'Вказаний номер телефону занадто довгий.',
    'user.longFax' => 'Вказаний номер факсу занадто довгий.',
    'user.longAddress' => 'Вказана адреса занадто довга.',
    'user.longCity' => 'Вказана назва міста занадто довга.',
    'user.phoneRegexNotMatch' => 'Вказаний номер телефону не є дійсним.',
    'user.faxRegexNotMatch' => 'Вказаний номер факсу не є дійсним.',
    'user.shortCity' => 'Вказана назва міста занадто коротка.',
    'user.limitSubscription' => 'Доступ до підписок',
    'user.limitSubscriptionHint' => 'Дозволити користувачам доступ лише до вказаної підписки. Значення "Всі" в полі надасть користувачам доступ до всіх підписок, доступних для вашого облікового запису хостингу.',
    'user.limitSubscriptionAll' => 'Усі',
    'user.deletedSubscription' => 'Видалена підписка',

    'web.add-domain-alias.title' => 'Додати псевдонім домену',
    'web.add-domain-alias.createdSuccessfully' => "Створено псевдонім домену %%name%%.",
    'web.add-domain-alias.domainAliasName' => 'Псевдонім домену',
    'web.add-domain-alias.domainAliasNameHint' => 'Наприклад: example.net',
    'web.add-domain-alias.forDomain' => 'для домену',
    'web.add-domain-alias.settingsSectionLegend' => 'Налаштування',
    'web.add-domain-alias.settingsDns' => 'Синхронізуйте зону DNS з основним доменом.',
    'web.add-domain-alias.settingsMail' => 'Поштовий сервіс',
    'web.add-domain-alias.settingsWeb' => 'Веб-сервіс',
    'web.add-domain-alias.settingsSeoRedirect' => 'Перенаправити за допомогою коду HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Коли відвідувачі відкриють URL псевдоніму, вони будуть перенаправлені на URL первинного домену. Plesk використовує переадресацію HTTP 301, яка є дружньою по відношенню до пошукових систем; це означає, що ранжування пошуковою системою не буде розділятися між URL.',
    'web.add-domain-alias.settingsTomcat' => 'Веб-застосунки Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Недійсний домен',

    'web.add-domain.formTitle' => 'Додавання нового домену',
    'web.add-domain.portalLink' => 'Портал сервісів',
    'web.add-domain.domainName' => 'Доменне ім’я',
    'web.add-domain.domainNameHint' => "Наприклад: example.com",
    'web.add-domain.assignToCustomer' => 'Призначити цей домен замовнику',
    'web.add-domain.customer' => 'Вибрати замовника',
    'web.add-domain.createNewCustomer' => 'Створіть нового замовника',
    'web.add-domain.selectExistingCustomer' => 'Вибрати існуючого замовника:',
    'web.add-domain.customerContactInfoHint' => 'Введіть контактну інформацію замовника. Можете зазначити всю іншу інформацію, напр., номер телефону та адресу, пізніше.',
    'web.add-domain.customerLoginInfoHint' => 'Дані входу для клієнтської панелі',
    'web.add-domain.target' => 'Веб-простір',
    'web.add-domain.createNewTarget' => 'Створити нову підписку',
    'web.add-domain.createNewTarget_powerUser' => 'Створити новий веб-простір',
    'web.add-domain.selectExistingTarget' => 'Обрати існуючу підписку:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Обрати існуючий веб-простір:',
    'web.add-domain.dns' => 'Активувати сервіс DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Активувати поштовий сервіс',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Працює, якщо налаштування підписки дозволяють подоменне керування поштовими дозволами. У іншому випадку, статус поштового сервісу буде взято з підписки.',
    'web.add-domain.hostingManagementOptions' => 'Тип хостингу',
    'web.add-domain.websiteHosting' => 'Хостинг веб-сайту',
    'web.add-domain.websiteForwarding' => 'Пересилання',
    'web.add-domain.websiteNoHosting' => 'Нема хостинга',
    'web.add-domain.hostingSettingsSectionLegend' => 'Параметри хостингу',
    'web.add-domain.domainCreatedSuccessfully' => 'Домен %%domainName%% успішно створено.',
    'web.add-domain.webspaceLegend' => 'Налаштування веб-простору',
    'web.add-domain.addWhmWebsiteTitle' => 'Додавання нового веб-сайту',
    'web.add-domain.addWhmWebsiteHint' => "Ви можете обрати розташування веб-сайту на сервері.",
    'web.add-domain.selectWhmDomain' => 'Обрати домен',
    'web.add-domain.customerLegend' => 'Інформація замовника',
    'web.add-domain.credentials' => 'Дані входу користувачів системи',
    'web.add-domain.credentialsHint' => 'для доступу до файлів, розміщених через FTP та SSH',
    'web.add-domain.credentialsHintWin' => 'для доступу до розміщених файлів через FTP та RDP',
    'web.add-domain.buttonAddDomain' => 'Додати домен',

    'web.add-subdomain.formTitle' => 'Додати новий субдомен',
    'web.add-subdomain.formGeneralHint' => 'Субдомени – це інтернет-адреси для різних відділів вашого веб-сайту. Вони використовують ім’я вашого основного домену та префікс. Наприклад, якщо ім’я вашого домену - "domain.com", то ім’я субдомену для цього сайту може виглядати так: store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'ви також можете створити wildcard-субдомен, якщо введете астерікс (*) замість імені. Відвідувачі сайту будуть переспрямовані на цей субдомен, незважаючи на те, яке ім’я субдомену вони ввели в оглядачі.',
    'web.add-subdomain.subdomainName' => 'Ім’я субдомену',
    'web.add-subdomain.subdomainNameHint' => 'Введіть "*" для того, щоб створити wildcard-субдомен.',
    'web.add-subdomain.forDomain' => 'Батьківський домен',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'Субдомен створено.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Параметри хостингу',

    'web.setupService.formTitle' => 'Сервіс установки  %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'Сервіс \'%%serviceReference%%\' успішно оновлено',

    'web.site-copy.subdomainsGroup' => 'Субдомени %%siteName%%:',
    'web.site-copy.destinationTypeSection' => 'Місце призначення копіювання',
    'web.site-copy.destinationType' => 'Виберіть, куди необхідно скопіювати файли',
    'web.site-copy.destinationTypeSite' => 'Веб-сайт у Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Скопіюйте файли сайту в інший ваш сайт, розміщений під цим обліковим записом. Якщо ви маєте FTP-доступ до іншого облікового запису цього серверу, скористайтесь опцією Сховище FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Скопіюйте файли сайту до іншого сайту, розміщеного на цьому сервері.',
    'web.site-copy.destinationTypeSiteSelect' => 'Ім’я сайту',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Неможливо скопіювати файли сайту %%source%% у %%destination%%, тому що %%destination%% знаходиться серед цих файлів — його кореневий каталог документів є вкладеним каталогом кореневого каталогу документів %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Неможливо видалити файли сайту %%destination%%, тому що файли %%source%% знаходяться серед цих файлів ‒ кореневий каталог документів %%source%% є вкладеним каталогом %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Сховище FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Скопіюйте файли веб-сайту в обліковий запис FTP цього або зовнішнього серверу.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Скопіюйте файли веб-сайту в обліковий запис FTP зовнішнього серверу.',
    'web.site-copy.destinationTypeFtpHost' => "Ім’я вузла серверу",
    'web.site-copy.destinationTypeFtpPort' => "Порт",
    'web.site-copy.destinationTypeFtpFolder' => 'Каталог',
    'web.site-copy.destinationTypeFtpUser' => 'Ім’я користувача',
    'web.site-copy.destinationTypeFtpPassword' => 'Пароль',
    'web.site-copy.destinationTypeFtpMode' => 'Метод підключення через FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Активний режим',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'В активному режимі Plesk надсилає свою ІР-адресу та номер порту, на якому він чекає сигналів від зовнішнього серверу, а сервер ініціює TCP-з’єднання. Цей режим рекомендується тоді, коли сервер, яким управляє Plesk, не захищений мережевим екраном.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Пасивний режим',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'Пасивний режим можна використовувати, коли сервер, яким управляє Plesk, знаходиться за мережевим екраном, і не може прийняти вхідні TCP-з’єднання.',
    'web.site-copy.existingFiles' => 'Що робити з існуючими файлами',
    'web.site-copy.existingFilesKeep' => 'Зберегти існуючі файли на цільовому сайті',
    'web.site-copy.existingFilesKeepDescription' => 'Перезаписати існуючі файли, імена яких співпадають з іменами файлів на цільовому сайті',
    'web.site-copy.existingFilesDelete' => 'Видалити всі існуючі файли',
    'web.site-copy.existingFilesDeleteDescription' => 'Видалити всі файли на цільовому сайті перед копіюванням.',
    'web.site-copy.emptyLogin' => 'Вкажіть ім’я користувача облікового запису FTP.',
    'web.site-copy.emptyHost' => 'Вкажіть ім’я вузла серверу.',
    'web.site-copy.emptyPort' => 'Вкажіть порт вузла серверу.',
    'web.site-copy.copyInProgress' => 'Копіювання веб-сайту %%sourceName%% у %%destinationName%%. На вашу електронну пошту (%%email%%) надіслано повідомлення про хід виконання.',
    'web.site-copy.unableToCopy' => 'Копіювання файлів веб-сайту не завершилось успішно',
    'web.site-copy.siteCopied' => 'Файли веб-сайту скопійовані',
    'web.site-copy.emailSubjSuccess' => 'Файли веб-сайту "%%source%%" скопійовані.',
    'web.site-copy.emailSubjFailure' => 'Копіювання файлів веб-сайту "%%source%%" не завершилось успішно.',
    'web.site-copy.emailBodySuccess' => 'Файли веб-сайту "%%source%%" скопійовані в "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'Копіювання файлів веб-сайту "%%source%%" в "%%destination%%" не вдалося: %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Параметри переспрямовування',
    'web._shared.forwardDestination' => 'Цільова адреса',
    'web._shared.forwardDestinationHint' => 'URL цільового веб-сайту.',
    'web._shared.forwardingTypeOptions' => 'Тип переспрямування',
    'web._shared.forwardingFrame' => 'Переадресація фрейму',
    'web._shared.forwardingFrameHint' => 'Переспрямувати відвідувачів на інший сайт, але сховати цільову адресу, щоб користувачі про переспрямування не знали.',
    'web._shared.forwardingHttpCode301' => 'Переміщений назавжди (код 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Переспрямувати відвідувачів веб-сайту на інший сайт та показати їм цільову адресу. Таке переспрямування збереже рейтинг пошукової системи сайту.',
    'web._shared.forwardingHttpCode302' => 'Переміщений тимчасово (код 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Переспрямувати відвідувачів веб-сайту на тимчасову копію сайту, коли ви не бажаєте, щоб системи пошуку індексували цей тимчасовий сайт.',
    'web._shared.documentRoot' => 'Кореневий каталог документів',
    'web._shared.documentRootHint' => 'Шлях до домашнього каталогу веб-сайту.',
    'web._shared.documentRootHintDisabledDueApplications' => 'Неможливо змінити кореневий каталог документів, тому що на цьому сайті є встановлені веб-застосунки.',
    'web._shared.ipAddress' => 'ІР-адреса',
    'web._shared.shared' => 'спільна',
    'web._shared.exclusive' => 'виділена',
    'web._shared.ipAddressHint' => "IP-адреса, на якій розміщений сайт, це мережева адреса віртуального вузла веб-сайту.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (інше сховище)',
    'web._shared.certificate' => 'Сертифікат',
    'web._shared.sameCertificatesHint' => 'Вибраний сертифікат буде використаний для всіх інших сайтів, розміщених на цій виділеній IP-адресі.',
    'web._shared.differentCertificatesHint' => 'Ця підписка пов’язана з двома виділеними IP-адресами, які мають два різних сертифікати. Усі сертифікати сайтів, розміщених на цих двух IP-адресах, будуть замінені на вибраний сертифікат.',
    'web._shared.differentIpTypesCertificateHint' => 'Ця підписка пов’язана з однією спільною та однією виділеною IP-адресами. Вибраний сертифікат буде використаний для всіх інших сайтів, розміщених на виділеній IP-адресі.',
    'web._shared.certificateNotSelected' => 'Не вибрано',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'У вашому сховищі немає жодного сертифікату SSL/TLS. Щоб додати сертифікат, перейдіть за посиланням %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'ця сторінка',
    'web._shared.seoRedirectDirection' => 'Домен, якому надається перевага',
    'web._shared.seoRedirectDirectionHint' => 'Виберіть URL-адресу (з префіксом www. або без нього), на яку будуть переспрямовуватися відвідувачі вебсайту через SEO-безпечне перенспрямовування протоколу HTTP 301.',
    'web._shared.seoRedirectDirectionNone' => 'Відсутня',
    'web._shared.limitMbUnits' => 'Мбайт',

    'web-user.settings.allowScripts' => 'Дозволити веб-користувачам користуватися скриптами',

    'web-user.name' => 'Ім’я користувача для зв’язку с сервером по FTP',
    'web-user.longName' => 'Дане ім’я користувача занадто довге (доступно максимум %max% символів)',
    'web-user.password' => 'Пароль',
    'web-user.passwordConfirmation' => 'Підтвердіть пароль',
    'web-user.hardDiskQuota' => 'Квота жорсткого диску',
    'web-user.hardDiskQuotaUnlimited' => 'Необмежений',
    'web-user.hardDiskQuotaIsNotSupported' => '(квота жорсткого диску не підтримується через налаштування файлової системи серверу)',
    'web-user.megabytes' => 'МБ',

    'web-user.__asp_win_support' => 'Підтримка Microsoft ASP',
    'web-user.__asp_dot_net_support' => 'Підтримка Microsoft ASP.NET',
    'web-user.__ssi_support' => 'Підтримка SSI',
    'web-user.__php_support' => 'Підтримка PHP',
    'web-user.__cgi_support' => 'Підтримка CGI',
    'web-user.__perl_unix_support' => 'Підтримка Perl',
    'web-user.__perl_win_support' => 'Підтримка Perl',
    'web-user.__python_unix_support' => 'Підтримка Python',
    'web-user.__python_win_support' => 'Підтримка Python',
    'web-user.__fastcgi_unix_support' => 'Підтримка FastCGI',
    'web-user.__webstat_support' => 'Веб-статистика',
    'web-user.__apache_errdocs' => 'Персоналізовані документи помилок',
    'web-user.__hosting_write_modify' => 'Додаткові права запису/ модифікування',
    'web-user.__hosting_webdeploy' => 'Публікування Web Deploy',


    'requiredFields' => 'Поля обов\'язкові для заповнення',
];