<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'anonymous-ftp.description' => 'Si el seu lloc s\'allotja en una adreça IP dedicada (no compartida amb altres usuaris o llocs), pot crear un directori al lloc on els altres usuaris puguin carregar o descarregar arxius a través d\'FTP de forma anònima. Un cop activat l\'FTP anònim, els usuaris podran accedir al directori en una adreça com ftp://ftp.your-domain.com amb el nom d\'usuari "anonymous" i qualsevol contrasenya.',
    'anonymous-ftp.displayLogin' => 'Mostrar missatge de benvinguda',
    'anonymous-ftp.loginText' => 'Text del missatge',
    'anonymous-ftp.incomingDir' => 'Permetre la càrrega al directori entrant',
    'anonymous-ftp.incomingSubDir' => 'Permetre la creació de directoris al directori entrant',
    'anonymous-ftp.incomingReadable' => 'Permetre la descàrrega des del directori entrant',
    'anonymous-ftp.quota' => 'Limitar l\'espai en disc al directori entrant',
    'anonymous-ftp.maxConnections' => 'Limitar el número de connexions simultànies',
    'anonymous-ftp.bandwidth' => 'Limitar l\'amplada de banda de descàrrega per aquest domini FTP virtual',
    'anonymous-ftp.unlimited' => 'Il·limitats',

    'aps.catalog.loading' => 'Carregant...',
    'aps.catalog.searchName' => 'Aplicació',
    'aps.catalog.searchVendor' => 'Proveïdor',
    'aps.catalog.searchPackager' => 'Empaquetador',
    'aps.catalog.searchLicenseType' => 'Tipus de llicència',
    'aps.catalog.searchLicenseTypeAny' => 'Qualsevol',
    'aps.catalog.searchLicenseTypeFreeware' => 'Gratuïta',
    'aps.catalog.searchLicenseTypeCommercial' => 'Comercial',
    'aps.catalog.showSearch' => 'Mostrar la cerca',
    'aps.catalog.hideSearch' => 'Amagar la cerca',
    'aps.catalog.buttonSearch' => 'Buscar',
    'aps.catalog.buttonResetSearch' => 'Restablir cerca',
    'aps.catalog.showCategories' => 'Seleccioni una de les categories que pot veure a continuació o busqui aplicacions mitjançant el quadre de cerca',
    'aps.catalog.searchResults' => 'Resultats de la cerca',
    'aps.catalog.buttonInstall' => 'Instal·lar',
    'aps.catalog.buttonInstallTooltip' => 'Instal·li ràpidament la versió més recent de l\'aplicació amb els paràmetres predeterminats òptims.',
    'aps.catalog.buttonAdvancedInstall' => 'Instal·lació personalitzada',
    'aps.catalog.buttonAdvancedInstallTooltip' => 'Instal·li la versió més recent de l\'aplicació, personalitzant tots els paràmetres.',
    'aps.catalog.buttonInstallOldVersion' => 'Versió a instal·lar',
    'aps.catalog.buttonInstallOldVersionTooltip' => 'Instal·li la versió seleccionada de l\'aplicació, personalitzant tots els paràmetres.',
    'aps.catalog.buttonInstallDescription' => 'Instal·li l\'aplicació en un lloc si ja disposa d\'un codi d\'activació o si desitja provar-la.',
    'aps.catalog.buttonInstallDescriptionFree' => 'Instal·li aquesta aplicació gratuïta en un lloc.',
    'aps.catalog.version' => 'Versió',
    'aps.catalog.moreVersions' => 'Altres versions',
    'aps.catalog.release' => 'Build',
    'aps.catalog.overview' => 'Informació general',
    'aps.catalog.noApplicationsInCategory' => 'En aquesta categoria no hi ha cap aplicació disponible. Seleccioni una altra categoria.',
    'aps.catalog.noCategoriesSelected' => 'Seleccioni una categoria per veure totes les aplicacions disponibles en aquesta categoria.',
    'aps.catalog.noSearchResults' => 'No s\'ha trobat cap aplicació que respongui als seus criteris de cerca.',
    'aps.catalog.connectionFailed' => 'Error de connexió al catàleg d\'aplicacions. %%retryLink%%.',
    'aps.catalog.retry' => 'Tornar a provar',
    'aps.catalog.categoriesError' => 'En aquest moment no s\'ha pogut carregar la llista de categories.',
    'aps.catalog.applicationsError' => 'En aquest moment no s\'ha pogut carregar la llista d\'aplicacions.',
    'aps.catalog.detailsError' => 'En aquest moment no s\'han pogut carregar els detalls de l\'aplicació.',
    'aps.catalog.searchError' => 'En aquest moment no s\'han pogut carregar els resultats de la cerca.',
    'aps.catalog.changelogEntry' => 'v%%version%% (Versió %%release%%) - %%description%%',
    'aps.catalog.changelog' => 'Historial de canvis',
    'aps.catalog.officialApplicationSite' => 'Informació del proveïdor',
    'aps.catalog.returnToCategories' => '<< Tornar a la llista d\'aplicacions',
    'aps.catalog.buttonUninstall' => 'Eliminar',
    'aps.catalog.gotoHome' => 'Inici',
    'aps.catalog.all' => 'Totes',
    'aps.catalog.buttonDetails' => 'Més informació',
    'aps.catalog.buttonBuy' => 'Comprar',
    'aps.catalog.buttonBuyTooltip' => 'Comprar l\'aplicació',
    'aps.catalog.buttonBuyDescription' => 'Visiti la nostra botiga per adquirir un codi d\'activació per l\'aplicació.',
    'aps.catalog.buttonDownload' => 'Descarregar',
    'aps.catalog.buttonDownloadDescription' => 'Descarregui l\'aplicació si ja disposa d\'un codi d\'activació o si desitja provar-la.',
    'aps.catalog.marketplaceMoreInfo' => 'Si desitja més informació, visiti %%link%%.',
    'aps.catalog.marketplaceMoreInfoLink' => 'el lloc web del proveïdor de l\'aplicació',

    'aps.configure.installedAt' => "Instal·lat a",
    'aps.configure.otherSettings' => "Altres",
    'aps.configure.globalSettings' => 'Configuració del paquet',
    'aps.configure.passwordConfirmation' => 'Confirmi la contrasenya',
    'aps.configure.databaseParams' => 'Paràmetres de la base de dades',
    'aps.configure.noInstallationUrlAvailable' => 'Cap (aplicació externa)',
    'aps.configure.updateSettingsSection' => 'Configuració d\'actualització',
    'aps.configure.forceUpdates' => 'Actualitzar aquesta aplicació automàticament quan hi hagi actualitzacions disponibles',
    'aps.configure.forceUpdatesHint' => 'L\'aplicació s\'actualitzarà automàticament a les versions més recents. Important! Utilitzi aquesta opció amb atenció, ja que les actualitzacions poden afectar la funcionalitat de l\'aplicació de forma significativa. Per exemple, les extensions de l\'aplicació poden deixar de funcionar si s\'utilitza una altra versió de l\'aplicació.',

    'aps.install.showAllSettings' => 'Mostrar totes les opcions',
    'aps.install.showLessSettings' => 'Mostrar les opcions mínimes',
    'aps.install.install' => 'Instal·lar',
    'aps.install.otherSettings' => 'Altres opcions',
    'aps.install.globalSettings' => 'Configuració del paquet',
    'aps.install.passwordConfirmation' => 'Confirmi la contrasenya',
    'aps.install.provisionsSectionLabel' => 'Ruta d\'instal·lació',
    'aps.install.context' => 'Indiqui l\'ubicació on s\'hauria d\'instal·lar aquesta aplicació web',
    'aps.install.registerAsWebmailSection' => 'Registre de webmail',
    'aps.install.registerAsWebmailDescription' => "Seleccioni aquesta opció si l'aplicació és un client de webmail. Això farà que l'aplicació es mostri junt amb els serveis de webmail disponibles a la configuració de correu de les subscripcions i els plans de serveis. L'administrador pot configurar l'URL d'accés públic del webmail a Gestió del servidor> Configuració> Webmail.",
    'aps.install.registerAsWebmailLabel' => 'Registrar com a servei de webmail',
    'aps.install.addItem' => 'Afegir',
    'aps.install.removeItem' => 'Eliminar',
    'aps.install.updateSettingsSection' => 'Configuració d\'actualització',
    'aps.install.forceUpdates' => 'Actualitzar aquesta aplicació automàticament quan hi hagi actualitzacions disponibles',
    'aps.install.forceUpdatesHint' => 'L\'aplicació s\'actualitzarà automàticament a les versions més recents. Important! Utilitzi aquesta opció amb atenció, ja que les actualitzacions poden afectar la funcionalitat de l\'aplicació de forma significativa. Per exemple, les extensions de l\'aplicació poden deixar de funcionar si s\'utilitza una altra versió de l\'aplicació.',

    'aps.invalid-requirements.requirementsLegend' => 'Requisits',
    'aps.invalid-requirements.domainLegend' => 'Lloc web',
    'aps.invalid-requirements.context' => 'Seleccioni un altre lloc web',
    'aps.invalid-requirements.backToApplicationList' => 'Tornar a la llista d\'aplicacions',

    'aps.license.title' => 'Instal·lació de %%packageName%%',
    'aps.license.doYouAcceptLicense' => 'Per instal·lar aquesta aplicació ha de llegir el contracte de llicència de l\'usuari final i acceptar les seves condicions.',
    'aps.license.licenseAgree' => 'Accepto les condicions del contracte de llicència',

    'aps.services-list-customization.settings' => 'Configuració',

    'asp-dot-net.change-version.title' => 'Selecció de la versió d\'ASP.NET',
    'asp-dot-net.change-version.frameworkVersion' => 'La versió del framework ASP.NET',
    'asp-dot-net.change-version.success' => 'La versió d\'ASP.NET ha estat canviada.',

    'asp-dot-net.settings.casSettingsSection' => "Seguretat d'accés de codi",
    'asp-dot-net.settings.clientScriptsSection' => "Configuració de la llibreria d'scripts",
    'asp-dot-net.settings.connStringsSection' => "Administrador de cadenes de connexió",
    'asp-dot-net.settings.customErrorsSection' => "Configuració d'errors personalitzats",
    'asp-dot-net.settings.frameworkVersionSection' => "Versió del framework",
    'asp-dot-net.settings.globalizationSection' => "Configuració de globalització",
    'asp-dot-net.settings.otherSection' => "Configuració de la sessió",
    'asp-dot-net.settings.pageAndRuntimeSection' => "Compilació i depuració",
    'asp-dot-net.settings.authMode' => "Mode d'autenticació",
    'asp-dot-net.settings.connStrings' => "Cadenes de connexió",
    'asp-dot-net.settings.connStringsInvalid' => "Alguns camps estan buits o contenen valors que no són correctes.",
    'asp-dot-net.settings.connStringName' => "Nom",
    'asp-dot-net.settings.connStringValue' => "Paràmetres de connexió",
    'asp-dot-net.settings.connStringsDescription' => "Nom / Paràmetres de connexió",
    'asp-dot-net.settings.culture' => "Cultura",
    'asp-dot-net.settings.customErrMode' => "Mode d'error personalitzat",
    'asp-dot-net.settings.customErrorRedirect' => "URL de redirecció",
    'asp-dot-net.settings.customErrorStatus' => "Codi d'estat",
    'asp-dot-net.settings.customErrorStatusInvalid' => "El codi d'estat ha de ser un número enter.",
    'asp-dot-net.settings.customErrors' => "Errors personalitzats",
    'asp-dot-net.settings.customErrorsDescription' => "Codi d'estat / URL de redireccionament",
    'asp-dot-net.settings.customErrorsInvalid' => "Alguns camps estan buits o contenen valors que no són correctes.",
    'asp-dot-net.settings.debugMode' => "Activar depuració",
    'asp-dot-net.settings.defLanguage' => "Idioma predeterminat de la pàgina web",
    'asp-dot-net.settings.tempDirectory' => "Directori temporal",
    'asp-dot-net.settings.fileEnc' => "Codificació d'arxius",
    'asp-dot-net.settings.fileEncInvalid' => "El valor especificat pel paràmetre Codificació d'arxius no és vàlid.",
    'asp-dot-net.settings.pathToLib' => "Ruta a la llibreria d'scripts de Microsoft",
    'asp-dot-net.settings.pathToLibInstall' => "Instal·lar",
    'asp-dot-net.settings.reqEnc' => "Codificació de les peticions",
    'asp-dot-net.settings.reqEncInvalid' => "El valor especificat pel paràmetre Codificació de les peticions no és vàlid.",
    'asp-dot-net.settings.resEnc' => "Codificació de les respostes",
    'asp-dot-net.settings.resEncInvalid' => "El valor especificat pel paràmetre Codificació de les respostes no és vàlid.",
    'asp-dot-net.settings.sessTimeout' => "Temps d'espera de la sessió (minuts)",
    'asp-dot-net.settings.sessTimeoutInvalid' => "El valor especificat pel paràmetre Temps d'espera de la sessió no és vàlid. Indiqui un número enter positiu igual o inferior a %%max%%.",
    'asp-dot-net.settings.connStringDuplicate' => "El nom de la cadena de connexió ja s'està utilitzant.",
    'asp-dot-net.settings.customErrorInvalidCode' => "El codi d'estat ha d'estar entre 100 i 999",
    'asp-dot-net.settings.customErrorDuplicate' => "El codi d'estat ja s'està utilitzant.",
    'asp-dot-net.settings.trustLevel' => "Nivell de seguretat CAS",
    'asp-dot-net.settings.uiCulture' => "Cultura de la interfície",
    'asp-dot-net.settings.version' => "Versió",
    'asp-dot-net.settings.trustLevelAllowOverride' => 'Permetre invalidar el nivell de confiança de CAS al lloc web',
    'asp-dot-net.settings.updateSuccess' => 'Actualització efectuada correctament',

    'database.clone.formDescription' => 'Copiï el contingut de la base de dades a una base de dades nova o a una d\'existent. Si es copia a una base de dades existent, les taules de la base de dades d\'origen s\'afegiran a la llista de taules de la base de dades de destí. Important! Si hi ha alguna coincidència de noms de taules, la taula de la base de dades d\'origen substituirà la present a la base de dades de destí.',
    'database.clone.copyData' => 'Crear una còpia completa',
    'database.clone.copyDataHint' => 'Si es selecciona, es copiarà tota la base de dades, incloent la seva estructura i les seves dades. Si no es selecciona, només es copiarà l\'estructura de les taules.',
    'database.clone.server' => 'Servidor de base de dades de destí',
    'database.clone.versionCut' => 'v%%version%%',
    'database.clone.externalServer' => 'Un altre...',
    'database.clone.database' => 'Base de dades de destí',
    'database.clone.newDatabase' => 'Crear base de dades anomenada',
    'database.clone.existingDatabase' => 'Copiar a base de dades existent',
    'database.clone.externalDbHost' => 'Nom del host o adreça IP',
    'database.clone.externalDbLogin' => 'Nom d\'usuari',
    'database.clone.externalDbPassword' => 'Contrasenya',
    'database.clone.subscription' => 'Subscripció de destí',
    'database.clone.subscription_powerUser' => 'Espai web de destí',
    'database.clone.cloneInProgress' => 'En aquest moment s\'està clonant la base de dades %%source%% a la base de dades %%destination%%. L\'informarem del progrés de l\'operació per correu electrònic (%%email%%).',
    'database.clone.unableToClone' => 'No ha estat possible copiar la base de dades "%%source%%".',
    'database.clone.unableToCreateExternalDatabase' => 'No ha estat possible crear una base de dades "%%destination%%" al servidor especificat.',
    'database.clone.databaseCloned' => 'La base de dades "%%source%%" ha estat copiada.',
    'database.clone.emailSubjSuccess' => 'La base de dades "%%sourceDatabase%%" ha estat copiada.',
    'database.clone.emailSubjFailure' => 'No s\'ha pogut copiar la base de dades "%%sourceDatabase%%".',
    'database.clone.emailBodySuccess' => 'La base de dades "%%sourceDatabase%%" (%%sourceHost%%) s\'ha copiat a la base de dades "%%destDatabase%%" (%%destHost%%).',
    'database.clone.emailBodyFailure' => 'No ha estat possible copiar la base de dades "%%sourceDatabase%%" (%%sourceHost%%) a la base de dades "%%destDatabase%%" (%%destHost%%). El procés de còpia no s\'ha pogut completar.',
    'database.clone.localServer' => 'servidor local',

    'database.repair-orphaned.formDescription' => 'Aquest usuari ha esdevingut orfe un cop completada la restauració. Per tal de resoldre l\'incidència, proporcioni una contrasenya per aquest usuari. Si l\'usuari és un usuari del sistema sense contrasenya, executi l\'utilitat de reparació sense especificar cap contrasenya.',
    'database.repair-orphaned.login' => 'Nom d\'usuari de la base de dades',
    'database.repair-orphaned.pass' => 'Contrasenya',
    'database.repair-orphaned.pass2' => 'Confirmi la contrasenya',
    'database.repair-orphaned.users' => 'Alguns usuaris requereixen la seva atenció. Hi ha alguns usuaris orfes que haurien de ser reparats.',
    'database.repair-orphaned.orphaned' => 'L\'usuari és orfe. %%gui begin:link%%Reparar ara%%gui end:link%%.',
    'database.repair-orphaned.repair' => 'Reparar',

    'database.repair.fixSelected' => 'Reparar els seleccionats',
    'database.repair.fix' => 'Reparar',

    'database.user.password' => 'Contrasenya',
    'database.user.passwordConfirmation' => 'Confirmi la contrasenya',
    'database.user.server' => 'Servidor de base de dades',
    'database.user.versionCut' => 'v%%version%%',
    'database.user.database' => 'Base de dades',
    'database.user.anyDatabase' => 'Qualsevol',
    'database.user.dataAccess' => 'Accés a les dades',
    'database.user.structureAccess' => 'Accés a l\'estructura',
    'database.user.globalAccess' => 'Privilegis globals',
    'database.user.globalAccessHint' => 'Els privilegis globals s\'apliquen a totes les bases de dades dins d\'aquest compte de hosting.',
    'database.user.aclRadio' => 'Control d\'accés',
    'database.user.aclLocalhost' => 'Permetre únicament connexions locals',
    'database.user.aclAny' => 'Permetre connexions remotes des de qualsevol host',
    'database.user.aclCustom' => 'Permetre connexions remotes des de',
    'database.user.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nEls hosts especificats poden accedir a la base de dades en nom d'aquest usuari.",
    'database.user.remoteAccess' => 'Accés remot',
    'database.user.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nLes adreces IP indicades poden accedir al servidor de base de dades mitjançant una regla de firewall. Els canvis que es duguin a terme en aquesta llista seran moderats prèviament pel seu proveïdor de hosting.",
    'database.user.example' => "Per exemple:\n%%example%%",
    'database.user.denied' => 'Utilitzar les regles de firewall del sistema',
    'database.user.allowed' => 'Permetre connexions remotes des de',
    'database.user.default' => 'Utilitzar les credencials d\'aquest usuari de forma predeterminada per a accedir a %%webadmin%%',
    'database.user.remoteAccessHint' => 'Posi\'s en contacte amb el seu proveïdor de hosting i comprovi que l\'opció que ha especificat a sobre complirà les regles de firewall vigents per l\'accés entrant a MariaDB/MySQL.',
    'database.user.phpMyAdmin' => 'phpMyAdmin',
    'database.user.webAdmin' => 'Web Admin',
    'database.user.role' => 'Rol',
    'database.user.roleReadWrite' => 'Lectura i escriptura',
    'database.user.roleWriteOnly' => 'Només escriptura',
    'database.user.roleReadOnly' => 'Només lectura',
    'database.user.roleCustom' => 'Personalitzat',

    'database.generalSection' => 'General',
    'database.name' => 'Nom de la base de dades',
    'database.server' => 'Servidor de base de dades',
    'database.versionCut' => 'v%%version%%',
    'database.relatedDomain' => 'Lloc relacionat',
    'database.noDomainRelations' => 'No hi ha cap lloc relacionat',
    'database.userSection' => 'Usuaris',
    'database.userSectionDescription' => 'Creï un usuari predeterminat de la base de dades. Plesk accedirà a la base de dades en nom d\'aquest usuari. Si no s\'ha assignat cap usuari a la base de dades, no serà possible accedir a aquesta.',
    'database.createUser' => 'Crear un usuari de la base de dades',
    'database.username' => 'Nom d\'usuari de la base de dades',
    'database.password' => 'Contrasenya',
    'database.passwordConfirmation' => 'Confirmi la contrasenya',
    'database.allDbAccess' => 'L\'usuari té accés a totes les bases de dades presents a la subscripció seleccionada',
    'database.aclRadio' => 'Control d\'accés',
    'database.aclLocalhost' => 'Permetre únicament connexions locals',
    'database.aclAny' => 'Permetre connexions remotes des de qualsevol host',
    'database.aclCustom' => 'Permetre connexions remotes des de',
    'database.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nEls hosts especificats poden accedir a la base de dades en nom d'aquest usuari.",
    'database.remoteAccess' => 'Accés remot',
    'database.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nLes adreces IP indicades poden accedir al servidor de base de dades mitjançant una regla de firewall. Els canvis que es duguin a terme en aquesta llista seran moderats prèviament pel seu proveïdor de hosting.",
    'database.example' => "Per exemple:\n%%example%%",
    'database.denied' => 'Utilitzar les regles de firewall del sistema',
    'database.allowed' => 'Permetre connexions remotes des de',

    'deployment-section.deploymentDisabledHint' => 'Carregar arxius des d\'un repositori Git',
    'deployment-section.deploymentEnabledHint' => 'Activar el suport de Git',
    'deployment-section.deploymentSectionLegend' => 'Els seus arxius a copiar al hosting',
    'deployment-section.deploymentSectionDescriptionHint' => 'Si deixa desactivat el suport de Git, els directoris arrel (arrel d\'aplicacions/lloc web i l\'arrel del document) es crearan buits i el lloc mostrarà la pàgina predeterminada al navegador. Haurà de carregar els arxius del seu lloc a l\'arrel del document mitjançant FTP o bé l\'administrador d\'arxius. També pot activar Git ara o més endavant (a Llocs web i dominis) i carregar arxius des d\'un repositori Git.',

    'dns-zone.add-acl-record.description' => 'Afegeixi una adreça IP d\'un servidor DNS que pugui rebre una còpia de la zona DNS.',
    'dns-zone.add-acl-record.ipAddress' => 'Adreça IP',
    'dns-zone.add-acl-record.ipAddressWithMask' => 'Adreça IP/màscara',

    'dns-zone.record.add-title' => "Addició d'un registre de recursos a la plantilla de zona",
    'dns-zone.record.add-ns-title' => "Addició d'un servidor de noms",
    'dns-zone.record.edit-title' => "Edició d'un registre de recursos",
    'dns-zone.record.edit-success' => "El registre DNS va ser actualitzat.",
    'dns-zone.record.add-success' => "El registre DNS va ser creat.",
    'dns-zone.record.type' => "Tipus de registre",
    'dns-zone.record.domainName' => "Nom del domini",
    'dns-zone.record.domainNamePostfix' => ".<domain>",
    'dns-zone.record.nameServer' => "Servidor de noms",
    'dns-zone.record.optionOff' => 'Desactivat',
    'dns-zone.record.optionOn' => 'Activat',
    'dns-zone.record.protocol' => "Protocol",
    'dns-zone.record.priority' => "Prioritat",
    'dns-zone.record.priorityLow' => "baixa (%%priority%%)",
    'dns-zone.record.priorityHigh' => "molt elevada (%%priority%%)",
    'dns-zone.record.weightLow' => "baix (%%weight%%)",
    'dns-zone.record.weightHigh' => "molt elevat (%%weight%%)",
    'dns-zone.record.ipAddress' => "Adreça IP",
    'dns-zone.record.ipAddressDescription' => "Per exemple, 123.123.123.123",
    'dns-zone.record.ipAddressDescriptionExt' => "Per exemple, <ip>, 123.123.123.123",
    'dns-zone.record.ipAddressV6' => "Adreça IPv6",
    'dns-zone.record.ipAddressV6Description' => "Per exemple, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressV6DescriptionExt' => "Per exemple, <ipv6>, 2002:7b7b:7b7b::1",
    'dns-zone.record.ipAddressWithMaskDescription' => "Per exemple, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.ipAddressWithMaskDescriptionExt' => "Per exemple, <ipv6>, <ip>, 2002:7b7b:7b7b::1/48, 123.123.123.123/16",
    'dns-zone.record.masterIpAddressDescription' => "Per exemple, 2002:7b7b:7b7b::1, 123.123.123.123",
    'dns-zone.record.canonicalName' => "Nom canònic",
    'dns-zone.record.mailDomain' => "Domini de correu",
    'dns-zone.record.mxServer' => "Servidor d'intercanvi de correu",
    'dns-zone.record.mxServerPriority' => "Especifiqui la prioritat del servidor d'intercanvi de correu",
    'dns-zone.record.txtRecord' => "Registre TXT",
    'dns-zone.record.txtRecordString' => "Introduir la cadena de registre",
    'dns-zone.record.txtSpfSyntax' => "Registre SPF",
    'dns-zone.record.txtRecordDescription' => "",
    'dns-zone.record.invalidTxtRecord' => "Els valors especificats pel registre TXT no són correctes.",
    'dns-zone.record.quotedTxtRecord' => "El valor del registre del TXT ha d'estar format per una sola línia i no pot contenir cometes.",
    'dns-zone.record.dsRecord' => "Registre DS",
    'dns-zone.record.dsRecordDescription' => "Per exemple, 60485 5 1 2BB183AF5F22588179A53B0A98631FAD1A292118",
    'dns-zone.record.invalidDSRecord' => "S'ha especificat un valor pel registre DS que no és correcte.",
    'dns-zone.record.serviceName' => "Nom del servei",
    'dns-zone.record.serviceNameDescription' => 'Per exemple, SIP (sense el caràcter de guió baix).',
    'dns-zone.record.protocolNameDescription' => 'Per exemple, tcp (sense el caràcter de guió baix).',
    'dns-zone.record.portDescription' => 'Per exemple, 25 (sense el caràcter de guió baix).',
    'dns-zone.record.srvWeight' => "Pes relatiu dels registres amb la mateixa prioritat",
    'dns-zone.record.targetHost' => "Host de destí",
    'dns-zone.record.targetHostDescription' => "Per exemple, example.com",
    'dns-zone.record.targetPort' => "Port de destí",
    'dns-zone.record.targetPortDescription' => 'Per exemple, 8443.',
    'dns-zone.record.retrieveDataError' => "No s'han trobat dades de registres.",
    'dns-zone.record.unknownTypeError' => "Tipus de registre DNS desconegut.",
    'dns-zone.record.nullMxRecordMustBeTheOnly' => 'No és possible configurar cap registre NULL MX si existeixen d\'altres registres MX.',
    'dns-zone.record.cannotHaveMxNullRecordAndMxRecord' => 'No és possible configurar cap registre MX que no sigui NULL si existeix un registre MX NULL',
    'dns-zone.record.masterShouldBeRemote' => "És necessari disposar de dos servidors de noms autoritatius diferents en hosts diferents.",
    'dns-zone.record.caaTag' => "Etiqueta",
    'dns-zone.record.caaRecord' => "Valor",
    'dns-zone.record.caaRecordDescription' => "",
    'dns-zone.record.tlsaPort' => 'Port',
    'dns-zone.record.tlsaProtocol' => 'Protocol',
    'dns-zone.record.tlsaUsage' => 'Ús',
    'dns-zone.record.tlsaSelector' => 'Selector',
    'dns-zone.record.tlsaMatching' => 'Tipus de coincidència',
    'dns-zone.record.tlsaCertData' => 'Dades d\'associació del certificat',
    'dns-zone.record.tlsaSeeLinkForDetails' => 'Per més informació, visiti %%link%%',
    'dns-zone.record.tlsaRfc6698Section211' => 'RFC6698, secció 2.1.1',
    'dns-zone.record.tlsaRfc6698Section212' => 'RFC6698, secció 2.1.2',
    'dns-zone.record.tlsaRfc6698Section213' => 'RFC6698, secció 2.1.3',
    'dns-zone.record.tlsaRfc6698Section214' => 'RFC6698, secció 2.1.4',

    'dns-zone.record.httpsPriorityAlias' => "àlies (%%priority%%)",
    'dns-zone.record.httpsTargetHostDescription' => 'Per exemple, example.com. Un valor en blanc significa que el host és el mateix que el nom de domini.',
    'dns-zone.record.httpsProtocols' => 'Protocols',
    'dns-zone.record.httpsProtocolsDescription' => 'Llista separada per comes de protocols suportats pel destí. Per exemple, h3,h3-29,h2,http/1.1.',
    'dns-zone.record.httpsForceProtocols' => 'Forçar l\'ús de només els protocols especificats. La llista de protocols anterior no pot estar buida.',
    'dns-zone.record.httpsIpv4hint' => 'Suggeriment d\'adreces IPv4',
    'dns-zone.record.httpsIpv4hintDescription' => 'Llista d\'adreces IPv4 separades per comes que pot fer servir un client per accedir al servei.',
    'dns-zone.record.httpsIpv6hint' => 'Suggeriment d\'adreces IPv6',
    'dns-zone.record.httpsIpv6hintDescription' => 'Llista d\'adreces IPv6 separades per comes que pot fer servir un client per accedir al servei.',

    'dns-zone.record.ttl' => "TTL",
    'dns-zone.record.ttl-seconds' => "Segons",
    'dns-zone.record.invalidValue' => 'El valor no és vàlid. Ha d\'estar entre 1 segon i 2147483647 segons.',
    'dns-zone.record.ttlDefaultValue' => 'Valor predeterminat: %%value%% segons',
    'dns-zone.record.invalidTTL' => 'El valor TTL indicat no és vàlid.',
    'dns-zone.record.invalidIpAddress' => 'L\'adreça IP especificada no és vàlida.',
    'dns-zone.record.invalidIpMaskPair' => 'El parell de màscara de xarxa/adreça IP indicat no és vàlid.',
    'dns-zone.record.invalidCName' => 'El nom canònic indicat no és vàlid.',
    'dns-zone.record.invalidPort' => 'El port especificat no és vàlid.',
    'dns-zone.record.invalidTLSACertData' => 'Les dades d\'associació del certificat indicades no són vàlides.',
    'dns-zone.record.invalidTLSAProtocol' => 'El protocol indicat no és vàlid.',
    'dns-zone.record.invalidTLSAUsage' => 'L\'ús indicat no és vàlid.',
    'dns-zone.record.invalidTLSASelector' => 'El selector indicat no és vàlid.',
    'dns-zone.record.invalidTLSAMatching' => 'El tipus de coincidència indicat no és vàlid.',

    'dns-zone.restore-default.formHint' => "Aquí pot restaurar la configuració original de la zona conforme a la configuració de la plantilla DNS predeterminada utilitzada al servidor. Seleccioni les adreces IP a utilitzar per a la restauració de la zona i indiqui si es necessita un àlies www pel domini.",
    'dns-zone.restore-default.ipv4' => "Adreça IPv4",
    'dns-zone.restore-default.ipv4Hint' => "Per exemple, 123.123.123.123",
    'dns-zone.restore-default.ipv6' => "Adreça IPv6",
    'dns-zone.restore-default.ipv6Hint' => "Per exemple, 2002:7b7b:7b7b::1",
    'dns-zone.restore-default.invalidIpAddress' => 'L\'adreça IP especificada no és vàlida.',
    'dns-zone.restore-default.customIpHint' => "Els registres amb aquesta adreça IP es consideraran registres modificats per l'usuari i no es sincronitzaran amb la plantilla DNS a nivell del servidor.",
    'dns-zone.restore-default.wwwPrefix' => "prefix www",
    'dns-zone.restore-default.previewRecords' => "Restaurar els registres utilitzats per a previsualitzar el lloc",

    'dns-zone.soa-record.soaMnameSection' => 'Servidor de noms principal',
    'dns-zone.soa-record.soaMname' => 'Servidor de noms',
    'dns-zone.soa-record.soaMnameAutoselect' => '(Selecció automàtica)',
    'dns-zone.soa-record.soaRecordSection' => 'Registre SOA',
    'dns-zone.soa-record.ttl' => 'TTL',
    'dns-zone.soa-record.refresh' => 'Actualitzar',
    'dns-zone.soa-record.retry' => 'Tornar a provar',
    'dns-zone.soa-record.expire' => 'Caducitat',
    'dns-zone.soa-record.minimum' => 'Mínim',
    'dns-zone.soa-record.rnameType' => 'Email (RNAME)',
    'dns-zone.soa-record.rnameTypeHint' => 'L\'adreça de correu de la persona responsable de la zona DNS del domini. Tornat pel servidor DNS en resposta a consultes SOA.',
    'dns-zone.soa-record.rnameTypeOwner' => 'Adreça de correu del propietari del lloc web',
    'dns-zone.soa-record.rnameTypeDomain' => 'Adreça de correu del domini',
    'dns-zone.soa-record.rnameTypeDomainHint' => 'Introdueixi únicament la part local (abans de @<domain>)',
    'dns-zone.soa-record.rnameTypeExternal' => 'Adreça de correu externa',
    'dns-zone.soa-record.rnameEnforceEmail' => 'Prohibir la modificació de l\'adreça de correu RNAME de forma individualitzada pels dominis',
    'dns-zone.soa-record.invalidValue' => 'El valor no és vàlid. Aquest ha d\'estar entre 1 segon i 68 anys.',
    'dns-zone.soa-record.advancedSection' => 'Funcions DNS avançades',
    'dns-zone.soa-record.serialNumberFormat' => 'Utilitzar el format de número de sèrie recomanat per IETF i RIPE',
    'dns-zone.soa-record.serialNumberFormatHint' => 'Seleccioni l\'opció si el seu domini presenta incidències en passar la comprovació SOA del registrador. Molts registradors de domini requereixen aquest format de número de sèrie.',
    'dns-zone.soa-record.restoreDefaultButton' => 'Utilitzar configuració per defecte',
    'dns-zone.soa-record.zoneDefaultsSection' => 'Valors predeterminats de zona',
    'dns-zone.soa-record.unitSeconds' => 'segons',
    'dns-zone.soa-record.unitMinutes' => 'minuts',
    'dns-zone.soa-record.unitHours' => 'hores',
    'dns-zone.soa-record.unitDays' => 'dies',
    'dns-zone.soa-record.unitWeeks' => 'setmanes',
    'dns-zone.soa-record.refreshValueIsSmallWarning' => 'El valor Interval d\'actualització és inferior a una hora, el que pot augmentar significativament el trànsit del servidor i l\'ús dels recursos.',
    'dns-zone.soa-record.minimumValueIsBigWarning' => 'Establir un valor de TTL mínim a més de 3 hores pot fer que alguns administradors de domini ja no puguin accedir als seus dominis. Per aquest motiu li recomanem establir aquest valor únicament si així li insisteix el seu registrador de noms de domini.',
    'dns-zone.soa-record.success' => 'Les propietats del registre SOA han estat actualitzades.',
    'dns-zone.soa-record.restoreDefaultSuccess' => 'El registre SOA predeterminat ha estat restaurat.',

    'domain-info-section.domainName' => 'Nom del domini',
    'domain-info-section.emptyDomainName' => 'Indiqui un nom de domini.',
    'domain-info-section.ipAddress' => 'Adreça IP',
    'domain-info-section.shared' => 'compartida',
    'domain-info-section.exclusive' => 'dedicada',
    'domain-info-section.ipAddressHint' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web. Aquesta adreça IP es farà servir per tots els llocs web creats a la subscripció.",
    'domain-info-section.ipAddressHint_powerUser' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web. Aquesta adreça IP es farà servir per tots els llocs web creats a l'espai web.",
    'domain-info-section.userName' => 'Nom d\'usuari',
    'domain-info-section.userNameHint' => 'Compte d\'usuari del sistema associat amb l\'espai web, utilitzat per a accedir als arxius allotjats mitjançant FTP i SSH.',
    'domain-info-section.emptyLogin' => 'Indiqui un nom d\'usuari.',
    'domain-info-section.password' => 'Contrasenya',
    'domain-info-section.emptyPassword' => 'Indiqui una contrasenya.',
    'domain-info-section.passwordConfirmation' => 'Confirmi la contrasenya',

    'email-address.generalTab' => 'General',
    'email-address.generalHint' => 'Si aquest compte de correu està associat amb un usuari addicional (s\'ha activat l\'accés al panell del client), els canvis que realitzi aquí afectaran a la configuració d\'aquest usuari. Concretament, si canvia l\'adreça de correu i la contrasenya, també es canviaran les credencials de l\'usuari addicional.',
    'email-address.redirectTab' => 'Reenviament',
    'email-address.redirectHint' => 'Configuri el reenviament de correus electrònics a una o més adreces.',
    'email-address.aliasesTab' => 'Àlies de correu',
    'email-address.autoResponderTab' => 'Resposta automàtica',
    'email-address.antispamTab' => 'Filtre antispam',
    'email-address.autoResponderHint' => 'Configuri una resposta automàtica que s\'enviarà cada vegada que la seva adreça de correu rebi un correu. Establir una resposta automàtica resulta útil per a notificar que no es troba a l\'oficina o que està de vacances.',
    'email-address.antivirusTab' => 'Antivirus',
    'email-address.name' => 'Adreça de correu',
    'email-address.externalEmail' => 'Adreça de correu externa',
    'email-address.externalEmailHint' => 'S\'emprarà per a restablir la seva contrasenya en cap que no pugui accedir a l\'adreça de correu electrònic principal.',
    'email-address.user' => 'Assignada a',
    'email-address.password' => 'Contrasenya',
    'email-address.passwordConfirmation' => 'Confirmi la contrasenya',
    'email-address.clientConfigurationLink' => 'Enllaç al configurador de correu',
    'email-address.responderEnable' => 'Activar resposta automàtica',
    'email-address.responderSubject' => 'Assumpte de la resposta automàtica',
    'email-address.responderContentType' => 'Format del correu',
    'email-address.responderContentTypeHint' => 'El format de text sense format és suportat per tots els programes de correu, motiu pel que tots els destinataris veuran el correu igual que el veu vostè. Els missatges HTML tenen una millor aparença, ja que li permeten introduir text amb format amb diferent estils de font. De totes maneres, alguns clients de correu no suporten els missatges HTML i és possible que alguns destinataris no vegin el text amb format.',
    'email-address.responderContentTypeTextPlain' => 'Text sense format',
    'email-address.responderContentTypeTextHtml' => 'HTML',
    'email-address.responderCodepage' => 'Codificació',
    'email-address.responderCodepageHint' => 'La codificació defineix la forma en que es mostren els caràcters del text. La codificació recomanada és UTF-8.',
    'email-address.responderReplyTo' => 'Reenviar a',
    'email-address.responderReplyToHint' => 'Quan s\'envia la resposta automàtica, el correu original es reenviarà a l\'adreça de correu especificada.',
    'email-address.responderForwardAddress' => 'Reenviar a',
    'email-address.responderForwardAddressHint' => 'Quan s\'envia la resposta automàtica, el correu original es reenviarà a l\'adreça de correu especificada.',
    'email-address.responderMessage' => 'Text de la resposta automàtica',
    'email-address.responderReplyToEqualsEmail' => 'L\'adreça de reenviament especificada és la mateixa que aquesta adreça de correu.',
    'email-address.responderForwardAddressEqualsEmail' => 'L\'adreça de reenviament especificada és la mateixa que aquesta adreça de correu.',
    'email-address.responderReplyLimit' => 'Enviar la resposta automàtica a una adreça de correu única no més de (vegades al dia)',
    'email-address.buttonAddResponderAttachment' => 'Afegir un adjunt',
    'email-address.buttonRemoveResponderAttachment' => 'Eliminar',
    'email-address.responderAttachment' => 'Adjuntar un arxiu',
    'email-address.redirectEnable' => 'Activar reenviament de correu',
    'email-address.redirectRemoveEnable' => 'No entregar copies de correus reenviats a la bústia de correu Plesk',
    'email-address.redirectAddress' => 'Reenviar correus entrants a la següent adreça de correu',
    'email-address.redirectAddressHint' => 'Especifiqui adreces de correu. Pot introduir una adreça per línia o separar-les amb espai, coma o punt i coma.',
    'email-address.role' => 'Rol d\'usuari',
    'email-address.roleHint' => 'Els rols d\'usuari concedeixen als usuaris privilegis administratius i accés a les aplicacions que seleccioni pel rol.',
    'email-address.errorRedirectAddress' => 'Ha indicat una adreça de correu que no és vàlida: %value%.',
    'email-address.errorRedirectAddressMultiple' => 'Ha indicat adreces de correu que no són vàlides: %value%.',
    'email-address.mailAlias' => "Àlies de correu",
    'email-address.mailAliasNone' => 'Cap',
    'email-address.mailAliasHint' => "Els àlies de correu són adreces de correu alternatives associades amb l'adreça de correu principal. Tots els correus enviats als àlies de correu també es rebran a l'adreça de correu principal.",
    'email-address.buttonAddMailAlias' => 'Afegir àlies de correu',
    'email-address.buttonRemoveMailAlias' => 'Eliminar',
    'email-address.emptyEmail' => 'Especifiqui l\'adreça de correu a la que s\'han de reenviar tots els correus entrants.',
    'email-address.emailsIsEqual' => 'L\'adreça de correu externa coincideix amb l\'adreça de correu principal. Indiqui una altra adreça de correu externa.',
    'email-address.emptyPassword' => 'Indiqui una contrasenya.',
    'email-address.emptyPasswordConfirmation' => 'Confirmi la contrasenya.',
    'email-address.emptyAlias' => "Especifiqui l'àlies de correu per aquesta adreça de correu.",
    'email-address.aliasEqualsEmail' => 'L\'àlies de correu indicat és el mateix que l\'adreça de correu.',
    'email-address.passwordHint' => 'S\'utilitzarà per a accedir a la bústia i per a accedir a Plesk (si s\'ha activat l\'opció corresponent).',
    'email-address.cyclicRedirect' => 'L\'adreça de correu no es pot configurar per reenviar correus a ella mateixa.',
    'email-address.errorMailnameReserved' => 'L\'adreça de correu especificada ja s\'està utilitzant.',
    'email-address.antivirusEnable' => 'Activar protecció antivirus per aquesta adreça de correu',
    'email-address.antivirusHint' => 'El servei d\'antivirus bloqueja aquells correus que contenen virus i envia una notificació tant al remitent com al destinatari.',
    'email-address.antivirusSettings' => 'Cerca de virus',
    'email-address.antivirusSettingOnlyIncomingMail' => 'només correu entrant',
    'email-address.antivirusSettingOnlyOutgoingMail' => 'només correu sortint',
    'email-address.antivirusSettingOnlyIncomingAndOutgoingMail' => 'correu entrant i sortint',
    'email-address.antispamHint' => 'El servei de filtració d\'spam detecta els correus spam enviats a l\'adreça de correu. Pot configurar-lo per tal que elimini correus spam, els marqui com spam canviant el seu assumpte o bé moure\'ls a la carpeta especial d\'spam a la que els clients de correu poden accedir-hi mitjançant IMAP. El filtre antispam efectua vàries comprovacions locals i de xarxa per tal d\'identificar firmes spam.',
    'email-address.antispamEnable' => 'Activar la filtració d\'spam per aquesta adreça de correu',
    'email-address.antispamSettings' => 'Accions a realitzar amb els correus classificats com spam',
    'email-address.antispamSettingsMark' => 'Marcar els correus spam afegint el següent text a l\'assumpte del correu',
    'email-address.antispamSettingsMarkHint' => 'Si no desitja afegir cap text, deixi aquest camp en blanc. Si desitja incloure la puntuació a l\'assumpte del correu, introdueixi _SCORE_ .',
    'email-address.antispamReportTextHint' => 'Introdueixi el text que desitja que s\'afegeixi al cos dels correus spam.',
    'email-address.antispamSettingsDelete' => 'Eliminar tots els correus spam',
    'email-address.antispamSettingsDeleteHint' => 'Els correus spam s\'eliminaran de la seva bústia de correu.',
    'email-address.antispamSettingsMove' => 'Moure l\'spam a la carpeta Spam',
    'email-address.antispamSettingsMoveHint' => 'Mogui tots els correus spam a la carpeta anomenada Spam. Pot accedir a aquesta carpeta utilitzant el seu client de correu o a través de webmail. Si està utilitzant un compte de correu IMAP, pot fer servir la carpeta Spam per a entrenar el filtre antispam.',
    'email-address.antispamSettingsMoveWarning' => '"Moure l\'spam a la carpeta Spam" no funciona a menys que desactivi l\'opció "No entregar copies de correus reenviats" a la pestanya "Reenviament".',
    'email-address.antispamSettingsMoveJunk' => 'Moure l\'spam a la carpeta "Correu brossa"',
    'email-address.antispamSettingsMoveJunkHint' => 'Mogui tots els missatges spam a la carpeta denominada "Correu brossa". Pot accedir a aquesta carpeta utilitzant el seu client de correu o a través de webmail. Si està utilitzant un compte de correu IMAP, pot fer servir la carpeta "Correu brossa" per a entrenar el filtre antispam.',
    'email-address.antispamShowAdvancedSection' => 'Mostrar opcions avançades',
    'email-address.antispamHideAdvancedSection' => 'Amagar opcions avançades',
    'email-address.antispamLearnMore' => 'Descobreixi com entrenar el filtre antispam.',
    'email-address.antispamFilterScoreTitle' => 'Sensibilitat del filtre',
    'email-address.antispamFilterScoreHint' => 'El filtre antispam realitza vàries comprovacions pel que fa al contingut i a la línia d\'assumpte dels correus. Com a resultat, cada correu obté una puntuació. Com més elevada sigui aquesta puntuació, més probable serà que el correu sigui un correu spam. Per defecte, la sensibilitat del filtre es configura de tal manera que tots els correus que obtinguin una puntuació de 7 punts o més es classifiquen com spam. Si amb la configuració predeterminada rep una gran quantitat de correus spam, intenti establir un valor inferior, com per exemple 6. Si pel contrari perd correus perquè el filtre antispam creu que són spam, intenti reduir la sensibilitat del filtre establint un valor superior, com per exemple 8.',
    'email-address.antispamFilterScore' => 'Sensibilitat del filtre antispam',
    'email-address.antispamWhiteListTitle' => 'Llista blanca',
    'email-address.antispamWhiteListHint' => 'Els correus procedents de remitents presents a la llista blanca no són analitzats pel filtre antispam.',
    'email-address.antispamWhiteListField' => 'Llista blanca',
    'email-address.antispamWhiteListFieldHint' => 'Indiqui els noms de domini escrivint un nom de domini per línia. Les adreces poden incloure els wildcards "*" i "?" − per exemple *@domain.com, user?@*.com.',
    'email-address.antispamBlackListTitle' => 'Llista negra',
    'email-address.antispamBlackListHint' => 'Els correus procedents de remitents presents a la llista negra es classifiquen com spam.',
    'email-address.antispamBlackListField' => 'Llista negra',
    'email-address.antispamBlackListFieldHint' => 'Indiqui els noms de domini escrivint un domini per línia. Les adreces poden incloure els wildcards "*" i "?" − per exemple *@domain.com, user?@*.com.',
    'email-address.antispamTrustedLanguagesTitle' => 'Idiomes de confiança',
    'email-address.antispamTrustedLanguagesHint' => 'Els correus escrits en aquests idiomes sempre passaran el filtre.',
    'email-address.antispamTrustedLocalesTitle' => 'Grups d\'idiomes',
    'email-address.antispamTrustedLocalesHint' => 'El correus que utilitzin els grups d\'idiomes especificats sempre passaran el filtre. Els grups d\'idiomes inclouen els conjunts de caràcters utilitzats amb més freqüència. Per exemple, el conjunt de caràcters occidental inclou lletres utilitzades en anglès i en d\'altres idiomes europeus.',
    'email-address.antispamTrustedNetworksTitle' => 'Xarxes de confiança',
    'email-address.antispamTrustedNetworksHint' => 'Els hosts de retransmissió a xarxes de confiança no es consideren potencialment gestionats per spammers i no són trameses obertes ni proxies oberts.',
    'email-address.antispamIpAddressesField' => 'Adreces IP',
    'email-address.antispamIpAddressesFieldHint' => 'Especifiqui l\'adreça IP de la xarxa i la màscara.',
    'email-address.mailBoxQuotaDomainDefault' => 'Tamany predeterminat (%%domainMboxQuota%%)',
    'email-address.mailBoxQuotaDomainDefaultNew' => 'Tamany predeterminat',
    'email-address.mailBoxOutgoingMessages' => 'El número màxim de correus sortints',
    'email-address.mailBoxOutgoingMessagesDomainDefault' => 'Predeterminat (%%domainOutgoingMessages%% correus/hora)',
    'email-address.mailBoxOutgoingMessagesDomainSpecific' => 'Valor personalitzat per la bústia de correu',
    'email-address.mailBoxOutgoingMessagesDomainSpecificHint' => 'correus',
    'email-address.mailBoxOutgoingMessagesDomainDefaultNew' => 'Predeterminat',
    'email-address.mailBoxQuotaDomainDefaultReadonly' => 'Tamany predeterminat',
    'email-address.mailBoxQuotaDomainSpecific' => 'Un altre tamany',
    'email-address.mailBoxQuotaDomainSpecificReadonly' => 'Tamany de la bústia de correu',
    'email-address.mailBoxQuotaUnlimited' => 'Il·limitats',
    'email-address.mailBoxLimitReached' => 'S\'ha assolit el límit de número de bústies de correu.',
    'email-address.postboxEnabled' => 'Bústia de correu',
    'email-address.postboxEnabledYes' => 'Sí',
    'email-address.postboxEnabledNo' => 'No',
    'email-address.description' => 'Descripció a Plesk',
    'email-address.descriptionHint' => 'La descripció pot veure-la tothom que tingui accés a aquest compte de correu.',
    'email-address.longDescription' => 'La descripció indicada és massa llarga. Aquesta no pot tenir més de %%max%% símbols.',
    'email-address.loginAsUser' => 'Pot utilitzar-se per a accedir a Plesk',
    'email-address.loginAsUserDescription' => '(nom d\'usuari: %%username%%)',
    'email-address.maxCustomSizeDesc' => 'El tamany de la bústia de correu no por ser superior al tamany predeterminat.',
    'email-address.endDateEnable' => 'Desactivar resposta automàtica el dia',

    'failed-request.enable-tracing.description' => 'El seguiment de les peticions fallides es una operació que consumeix una elevada quantitat de recursos. El seguiment s\'aturarà d\'aquí a %%days%% dies. Pot aturar-lo manualment en qualsevol moment.',
    'failed-request.enable-tracing.statusCodes' => 'Codis d\'estat',
    'failed-request.enable-tracing.statusCodesDescription' => 'Exemple: 401.3-999, 405',
    'failed-request.enable-tracing.provider' => 'Proveïdor',

    'file-manager.show.buttonReload' => 'Tornar a carregar',
    'file-manager.show.buttonSave' => 'Desar',
    'file-manager.show.buttonSaveAs' => 'Desar com a',
    'file-manager.show.buttonReset' => 'Restablir',
    'file-manager.show.buttonTextCodeEditor' => 'Editar en un editor de codi',
    'file-manager.show.buttonTextEdit' => 'Editar en un editor de text',
    'file-manager.show.buttonWysiwygEdit' => 'Editar en un editor d\'HTML',
    'file-manager.show.eolLabel' => 'Tipus de salt de línia:',
    'file-manager.show.saveAs' => 'Desar com a:',
    'file-manager.show.saveCodepage' => 'Desar en la següent codificació:',
    'file-manager.show.loadCodepage' => 'Veure l\'arxiu original en la següent codificació:',
    'file-manager.show.loadCodepageHint' => 'Important! Els canvis que no es desin es perdran quan es torni a carregar l\'arxiu.',
    'file-manager.show.fileExists' => "L'arxiu o la carpeta %%fileName%% ja existeix. No pot tenir una carpeta o un arxiu amb el mateix nom.",
    'file-manager.show.popupTitle' => 'Desar com a',
    'file-manager.show.popupFilename' => 'Nom de l\'arxiu:',

    'file-manager.permissions.filePermissions' => 'Permisos d\'arxius',
    'file-manager.permissions.directoryPermissions' => 'Permisos de directori',
    'file-manager.permissions.buttonSubmit' => 'Desar',
    'file-manager.permissions.buttonApply' => 'Desar i reprendre',
    'file-manager.permissions.buttonCancel' => 'Cancel·lar',
    'file-manager.permissions.buttonAdvanced' => 'Avançat',

    'file-manager.unix-file-permissions.group' => 'Grup',
    'file-manager.unix-file-permissions.owner' => 'Propietari',
    'file-manager.unix-file-permissions.others' => 'Altres',
    'file-manager.unix-file-permissions.readMode' => 'Llegir',
    'file-manager.unix-file-permissions.writeMode' => 'Escriure',
    'file-manager.unix-file-permissions.execMode' => 'Execució/cerca',
    'file-manager.unix-file-permissions.changeRecursive' => 'Canviar permisos de forma recursiva',

    'file-manager.windows-permissions.allow' => 'Permetre',
    'file-manager.windows-permissions.deny' => 'Denegar',
    'file-manager.windows-permissions.inheritFromParent' => 'Permeti permisos que es poden heretar de l\'element principal per tal de propagar aquest objecte i tots els objectes secundaris. Incloure\'ls amb les entrades definides explícitament aquí.',
    'file-manager.windows-permissions.replaceOnChildren' => 'Substitueixi les entrades de permisos sobre tots els objectes secundaris per les entrades mostrades aquí.',
    'file-manager.windows-permissions.buttonAdvanced' => 'Avançat',
    'file-manager.windows-permissions.applyTo' => 'Aplicar a:',
    'file-manager.windows-permissions.folderOnly' => 'Només aquesta carpeta',
    'file-manager.windows-permissions.subfolderOnly' => 'Només a les subcarpetes',
    'file-manager.windows-permissions.filesOnly' => 'Només als arxius',
    'file-manager.windows-permissions.permissionsFor' => 'Permisos per',
    'file-manager.windows-permissions.applyOnto1' => 'Només aquesta carpeta',
    'file-manager.windows-permissions.applyOnto2' => 'Només a les subcarpetes',
    'file-manager.windows-permissions.applyOnto3' => 'A aquesta carpeta i subcarpetes',
    'file-manager.windows-permissions.applyOnto4' => 'Només als arxius',
    'file-manager.windows-permissions.applyOnto5' => 'A aquesta carpeta i arxius',
    'file-manager.windows-permissions.applyOnto6' => 'Només a subcarpeta i arxius',
    'file-manager.windows-permissions.applyOnto7' => 'A aquesta carpeta, subcarpetes i arxius',
    'file-manager.windows-permissions.notInherited' => '<no heretat>',

    'file-manager.editor.titleTextEditor' => 'Editor de text',
    'file-manager.editor.titleCodeEditor' => 'Editor de codi',
    'file-manager.editor.titleCodeViewer' => 'Veure',
    'file-manager.editor.buttonSubmit' => 'Desar',
    'file-manager.editor.buttonApply' => 'Desar i reprendre',
    'file-manager.editor.buttonSaveAs' => 'Desar com a ...',
    'file-manager.editor.buttonCancel' => 'Cancel·lar',
    'file-manager.editor.exitConfirmationYes' => 'Sí',
    'file-manager.editor.exitConfirmationNo' => 'No',
    'file-manager.editor.fileOverwrite' => 'L\'arxiu ja existeix.',
    'file-manager.editor.fileOverwriteDescription' => 'Ja existeix un arxiu amb aquest nom. Desitja sobreescriure\'l?',
    'file-manager.editor.exitConfirmation' => 'Està segur que desitja tancar l\'arxiu i descartar els canvis no desats?',
    'file-manager.editor.buttonCodeEditor' => 'Editar en un editor de codi',
    'file-manager.editor.buttonTextEditor' => 'Editar en un editor de text',
    'file-manager.editor.buttonHtmlEditor' => 'Editar en un editor d\'HTML',

    'file-manager.import-file.buttonSubmit' => 'Importar',
    'file-manager.import-file.fieldUrl' => 'URL per l\'arxiu',
    'file-manager.import-file.fieldUrlDescription' => 'Indiqui l\'URL d\'origen. Per exemple, \'https://example.com/example.tgz\'.',
    'file-manager.import-file.fieldUrlFullDescription' => 'El patró d\'URL completa és el següent: \'https://user:password@example.com/example.tgz\'. El nom d\'usuari i la contrasenya són opcionals. Protocols suportats: http, https, ftp i ftps. Utilitzi la codificació d\'URL per aquelles parts de l\'URL que inclouen caràcters especials o espais.',
    'file-manager.import-file.failure' => 'No ha estat possible importar l\'arxiu.',

    'file-manager.rotation-settings.title' => 'Configuració de rotació de la paperera de reciclatge',
    'file-manager.rotation-settings.rotationBySize' => 'Rotació per tamany',
    'file-manager.rotation-settings.rotationBySizeUnits' => 'MB',
    'file-manager.rotation-settings.rotationBySizeHint' => 'L\'opció elimina els arxius nous sempre que s\'excedeixi el límit indicat per la paperera de reciclatge.',
    'file-manager.rotation-settings.rotationByDate' => 'Rotació per data',
    'file-manager.rotation-settings.rotationByDateUnits' => 'Dies',
    'file-manager.rotation-settings.rotationByDateHint' => 'Aquesta opció elimina els arxius de la paperera de reciclatge que faci més dies que són allà que el número de dies indicat.',
    'file-manager.rotation-settings.save' => 'Desar',
    'file-manager.rotation-settings.cancel' => 'Cancel·lar',

    'ftp-user.description' => 'Si gestiona el seu lloc web amb una tercera persona o allotja subdominis d\'altres usuaris, pot ser que desitgi crear diferents comptes FTP per ells.',
    'ftp-user.generalSection' => 'General',
    'ftp-user.login' => 'Nom del compte FTP',
    'ftp-user.home' => 'Directori principal',
    'ftp-user.systemArea' => 'Creï un compte FTP amb accés als arxius que no es trobin al directori inicial',
    'ftp-user.password' => 'Contrasenya',
    'ftp-user.passwordConfirmation' => 'Confirmi la contrasenya',
    'ftp-user.hardQuotaSection' => 'Quota de disc dur',
    'ftp-user.hardQuota' => 'Quota de disc dur',
    'ftp-user.hardQuotaUnlimited' => 'Il·limitats',
    'ftp-user.permissionsSection' => 'Permisos',
    'ftp-user.permissionRead' => 'Permís de lectura',
    'ftp-user.permissionWrite' => 'Permís d\'escriptura',
    'ftp-user.popupTitle' => 'Selecció de directori',
    'ftp-user.limitMbUnits' => 'MB',

    'mail-list.listName' => 'Adreça de la llista de correu',
    'mail-list.enabled' => 'Activada',
    'mail-list.administratorEmail' => 'Correu de l\'administrador de la llista de correu',
    'mail-list.password' => 'Contrasenya',
    'mail-list.passwordConfirmation' => 'Confirmi la contrasenya',
    'mail-list.subscribers' => 'Subscriptors',
    'mail-list.subscribersHint' => 'Especifiqui adreces de correu. Pot introduir una adreça per línia o separar-les amb espai, coma o punt i coma.',
    'mail-list.notify' => 'Notificar a l\'administrador quan es creïn llistes de correu',
    'mail-list.emptyPassword' => 'Indiqui una contrasenya',
    'mail-list.emptyPasswordConfirmation' => 'Confirmi la contrasenya.',
    'mail-list.errorSubscribers' => 'Adreces de correu no vàlides: %value%.',
    'mail-list.errorMaillistReserved' => 'L\'adreça de la llista de correu especificada ja s\'està utilitzant.',

    'mail-settings.copyToClipboard' => 'Copiï el registre DNS al porta-retalls.',
    'mail-settings.copySuccess' => 'El registre DNS ha estat copiat al porta-retalls.',
    'mail-settings.hint' => 'Aquí pot canviar la configuració del servei de correu per aquest domini.',
    'mail-settings.service' => 'Servei de correu en aquest domini',
    'mail-settings.nonExist' => 'Accions a realitzar amb els correus per usuaris de correu inexistents',
    'mail-settings.nonExistBounceWithMessage' => 'Tornar amb un missatge',
    'mail-settings.nonExistBounce' => 'Tornar',
    'mail-settings.nonExistCatch' => 'Reenviar a l\'adreça',
    'mail-settings.nonExistCatchDescription' => 'L\'adreça hauria de pertànyer al domini seleccionat. L\'administrador és l\'únic que pot especificar una adreça externa o una adreça per varis dominis.',
    'mail-settings.nonExistExternal' => 'Redireccionar a un servidor de correu extern amb l\'adreça IP',
    'mail-settings.nonExistReject' => 'Rebutjar',
    'mail-settings.nonExistDiscard' => 'Rebutjar',
    'mail-settings.webmail' => 'Webmail',
    'mail-settings.webmailNone' => 'Cap',
    'mail-settings.webmailComponentNotInstalled' => 'El component de webmail no s\'ha instal·lat.',
    'mail-settings.webmailSubdomainAlreadyExists' => 'Existeix un subdomini anomenat %%subdomain%%.',
    'mail-settings.webmailCertificate' => 'Certificat SSL/TLS pel webmail',
    'mail-settings.webmailCertificateNone' => 'No seleccionat',
    'mail-settings.mailCertificate' => 'Certificat SSL/TLS pel correu',
    'mail-settings.mailCertificateNone' => 'No seleccionat',
    'mail-settings.serverCertificateNotSelected' => 'El certificat has estat assignat, si bé no s\'ha protegit el correu pel domini. Si desitja protegir-lo, %%certLink%%.',
    'mail-settings.serverCertificatesList' => 'protegeixi el servidor de correu',
    'mail-settings.mailLists' => 'Activar llistes de correu',
    'mail-settings.mailAutodiscovery' => 'Activar detecció automàtica de correu',
    'mail-settings.mailAutodiscoveryDescription' => 'Descobreixi com funciona a la %%link%%',
    'mail-settings.mailAutodiscoveryDescriptionLink' => 'base de coneixement',
    'mail-settings.domainKeys' => 'Utilitzar el sistema de protecció antispam DKIM per a signar els correus sortints',
    'mail-settings.activeDkimSelector' => 'Selector DKIM actiu',
    'mail-settings.defaultDkimSelector' => ' (Plesk predeterminat)',
    'mail-settings.dkimSelectorName' => 'Nom del selector',
    'mail-settings.buttonCreateSelector' => 'Crear nou selector DKIM',
    'mail-settings.createSelectorDialogTitle' => 'Crear selector DKIM',
    'mail-settings.removeSelectorDialogTitle' => 'Eliminar selector DKIM',
    'mail-settings.removeSelectorConfirmation' => "Vols eliminar el selector '%%selector%%' així com els seus registres DNS i claus associades?",
    'mail-settings.buttonConfirm' => 'ACCEPTAR',
    'mail-settings.buttonCreate' => 'Crear',
    'mail-settings.buttonCancel' => 'Cancel·lar',
    'mail-settings.labelRemoveSelector' => 'Eliminar',
    'mail-settings.labelActiveSelector' => 'Actiu',
    'mail-settings.greyListing' => 'Activar la protecció antispam greylisting per tots els comptes de correu sota aquest domini',
    'mail-settings.howToConfigureExternalDns' => 'Com configurar un DNS extern',
    'mail-settings.howToConfigureExternalDnsAlways' => 'Per activar la signatura amb DKIM si empra un servidor DNS extern, cal que configuri registres DNS de DKIM al servidor DNS.',
    'mail-settings.howToConfigureExternalDnsEnabled' => 'Per això, empri els registres DNS de DKIM que es mostren a continuació:',
    'mail-settings.howToConfigureExternalDnsEnabledAliases' => 'Si disposa d\'àlies de domini que utilitza per enviar correu, afegeixi també els registres DNS de DKIM per aquests. Empre els mateixos registres que pel domini principal però amb el nom de l\'àlies de domini.',
    'mail-settings.howToConfigureExternalDnsDisabled' => 'Si desitja veure els registres DNS de DKIM que cal que configuri, seleccioni la casella "%%option%%", apliqui-la i torni a obrir aquest pop-up.',
    'mail-settings.mailServiceDisabled' => 'Desactivat',
    'mail-settings.mailServiceDisabledIncoming' => 'Desactivat pel correu entrant',
    'mail-settings.mailServiceDisabledHint' => 'Plesk no proporcionarà cap servei de correu en aquest domini.',
    'mail-settings.mailServiceDisabledIncomingHint' => 'Aquest domini només pot enviar correu i només mitjançant Sendmail.',
    'mail-settings.mailServiceEnabled' => 'Activat',
    'mail-settings.mailServiceEnabledHint' => 'Aquest domini pot enviar i rebre correu.',
    'mail-settings.mailServiceNotConfigured' => 'No configurat',
    'mail-settings.mailServiceNotConfiguredHint' => 'Plesk no proporcionarà cap servei de correu en aquest domini.',
    'mail-settings.warning' => 'Això eliminarà les bústies de correu del domini de forma permanent amb tots els correus enviats i rebuts.',
    'mail-settings.show.title' => 'Elimini totes les bústies de correu i emails de %%domain%%',
    'mail-settings.show.checkbox' => 'Eliminar totes les bústies de correu de %%domain%% de forma permanent, incloent-hi els emails enviats i rebuts.',

    'role.roleSection' => 'General',
    'role.name' => 'Nom del rol d\'usuari',
    'role.description' => 'Descripció',
    'role.generalPermissionsSection' => 'Accés als serveis de Plesk',
    'role.applicationsAccessSection' => 'Accés a aplicacions',
    'role.permissionAllow' => 'Concedit',
    'role.permissionDeny' => 'Denegat',
    'role.emptyRoleName' => 'Indiqui un nom pel rol.',
    'role.installedAt' => 'Instal·lat a',
    'role.noInstallationUrlAvailable' => 'Aplicació externa',
    'role.invalidRoleName' => 'El nom del rol d\'usuari indicat no és vàlid. Al nom del rol no es poden fer servir interrogants ni cometes.',
    'role.longRoleName' => 'El nom del rol d\'usuari indicat és massa llarg.',
    'role.somePermissionsAreNotAllowedForSomeSubscriptions' => 'És possible que algunes operacions no estiguin disponibles pels següents motius: la subscripció seleccionada no concedeix un permís per l\'operació o la quantitat de recursos assignats no és suficient per a completar una operació.',
    'role.servicesPermissionsDescription' => 'Defineixi l\'accés a les aplicacions instal·lades o als serveis de Plesk per tots els usuaris que tinguin aquest rol. Si concedeix accés a una aplicació a un usuari, l\'aplicació estarà a la seva disposició al panell del client.',
    'role.emailActivation' => 'Activar comptes d\'aquest rol per email',

    'service.admin-access.adminAccess' => 'Accés administratiu',
    'service.admin-access.customCredentialsDescriptionNoEntryPoints' => 'Aquestes credencials es faran servir per l\'accés administratiu a aquesta aplicació.',
    'service.admin-access.login' => 'Nom d\'usuari administratiu',
    'service.admin-access.password' => 'Contrasenya administrativa',
    'service.admin-access.passwordConfirmation' => 'Confirmi la contrasenya',

    'service.info.service-entry-point.availableAt' => 'Disponible a',
    'service.info.service-entry-point.customize' => 'Personalitzar accés directe',
    'service.info.service-entry-point.displayNameLabel' => 'Nom de l\'accés directe',
    'service.info.service-entry-point.displayNameDescription' => 'Proporcioni un nom per aquest accés directe. El nom es mostrarà sota l\'icona de l\'accés directe. Els accessos directes s\'afegeixen a les pàgines Els meus serveis d\'aquells usuaris a qui s\'hagi concedit accés a aquesta aplicació.',
    'service.info.service-entry-point.descriptionLabel' => 'Descripció de l\'accés directe',
    'service.info.service-entry-point.descriptionDescription' => 'Proporcioni una descripció per aquest accés directe. La descripció es mostrarà quan es passi el cursor del ratolí sobre l\'accés directe.',
    'service.info.service-entry-point.iconLabel' => 'Faci clic per a seleccionar l\'icona de l\'accés directe',
    'service.info.service-entry-point.iconCurrent' => 'Icona actual',
    'service.info.service-entry-point.errorEmptyName' => 'Indiqui un nom per l\'accés directe',
    'service.info.service-entry-point.errorLongName' => 'El nom de l\'accés directe hauria de tenir entre 1 i 255 caràcters.',
    'service.info.service-entry-point.errorLongDescription' => 'La descripció de l\'accés directe hauria de tenir entre 0 i 255 caràcters.',
    'service.info.service-entry-point.hiddenLabel' => 'Amagar accés directe',
    'service.info.service-entry-point.hiddenDescription' => 'No mostri aquest accés directe als usuaris.',

    'service.info.service-permission.assignedUser' => "Concedir accés d'administrador a aquest usuari",
    'service.info.service-permission.assignedUserNone' => 'Cap usuari assignat',

    'shared-ssl.master-ssl.switchedOn' => 'Activar SSL/TLS compartit',
    'shared-ssl.master-ssl.domainName' => 'El nom de domini d\'un lloc el certificat SSL/TLS del qual es compartirà amb altres llocs',
    'shared-ssl.master-ssl.none' => 'Cap',
    'shared-ssl.master-ssl.noDomainsWithSslWarning' => 'SSL/TLS compartit no pot activar-se perquè no hi ha cap domini que tingui activat el suport per a SSL/TLS.',

    'user.email.email' => 'Adreça de correu',
    'user.email.emptyEmail' => 'Indiqui una adreça de correu.',
    'user.email.internalEmailHint' => 'Crei una nova adreça de correu a Plesk o bé utilitzi una adreça de correu externa.',
    'user.email.longInternalEmail' => 'L\'adreça de correu és massa llarga.',
    'user.email.longInternalEmailMailboxAddressMailServer' => 'La part del nom d\'usuari de l\'adreça de correu és massa llarga per aquest servidor de correu. Indiqui un nom d\'usuari que tingui menys de %%max%% símbols.',
    'user.email.longInternalEmailFullAddressMailServer' => 'L\'adreça de correu és massa llarga per aquest servidor de correu. Indiqui una adreça que tingui menys de %%max%% símbols.',
    'user.email.externalEmail' => 'Adreça de correu externa',
    'user.email.externalEmailHint' => 'S\'emprarà per a restablir la seva contrasenya en cap que no pugui accedir a l\'adreça de correu electrònic principal.',
    'user.email.emailsIsEqual' => 'L\'adreça de correu externa coincideix amb l\'adreça de correu principal. Indiqui una altra adreça de correu externa.',
    'user.email.atLeastOneEmailShouldBeSet' => 'Indiqui una adreça de correu interna o externa.',

    'user.profileSection' => 'Informació general',
    'user.contactName' => 'Nom de contacte',
    'user.email' => 'Adreça de correu',
    'user.role' => 'Rol d\'usuari',
    'user.accountSection' => 'Preferències de Plesk',
    'user.login' => 'Nom d\'usuari',
    'user.password' => 'Contrasenya',
    'user.oldPassword' => 'Contrasenya anterior',
    'user.buttonBack' => 'Enrere',
    'user.generalTab' => 'General',
    'user.applicationsAccessSection' => 'Serveis',
    'user.generalPermissionsSection' => 'Privilegis',
    'user.contactsTab' => 'Detalls de contacte',
    'user.passwordConfirmation' => 'Confirmi la contrasenya',
    'user.internalEmailPasswordChanged' => 'Si canvia la contrasenya, també es canviarà la contrasenya de l\'adreça de correu interna.',
    'user.emailName' => 'Adreça de correu',
    'user.emailType' => 'Tipus de correu',
    'user.companyName' => 'Nom de l\'empresa',
    'user.phone' => 'Número de telèfon',
    'user.imNumber' => 'Missatgeria instantània',
    'user.fax' => 'Número de fax',
    'user.address' => 'Adreça',
    'user.city' => 'Ciutat',
    'user.state' => 'Estat o província',
    'user.zip' => 'Codi postal',
    'user.country' => 'País',
    'user.additionalInfo' => 'Informació addicional',
    'user.additionalInfoHint' => 'Només text sense format. S\'ignoraran totes les etiquetes HTML.',
    'user.language' => 'Idioma de Plesk',
    'user.buttonChangePassword' => 'Canviar contrasenya',
    'user.permissionAllow' => 'Concedit',
    'user.permissionDeny' => 'Denegat',
    'user.permissionInherited' => 'Definit pel rol',
    'user.emptyContactName' => 'Indiqui un nom de contacte.',
    'user.emptyLogin' => 'Indiqui un nom d\'usuari.',
    'user.emptyPassword' => 'Indiqui una contrasenya.',
    'user.emptyPasswordConfirmation' => 'Confirmi la contrasenya.',
    'user.oldPasswordIsIncorrect' => 'La contrasenya anterior no és correcta. Torni-ho a provar.',
    'user.chooseDomainBoxTitle' => 'Seleccionar un altre domini:',
    'user.userIsActive' => 'L\'usuari està actiu',
    'user.userIsActiveHint' => 'Els usuaris actius poden accedir a Plesk.',
    'user.emailActivation' => 'Activar compte per email',
    'user.emailHint' => 'Per proporcionar a l\'usuari una adreça de correu allotjada en aquest servidor, vagi a la pestanya Correu, creï l\'adreça de correu especificada i associï-la amb aquest usuari.',
    'user.emailContactHint' => 'Si desitja utilitzar una adreça de correu allotjada en aquest servidor, posi\'s en contacte amb el seu proveïdor de serveis.',
    'user.personalEmailHint' => "L'adreça de correu d'aquest usuari es pot modificar a la pestanya Correu.",
    'user.externalMailRedirectHint' => 'El reenviament només es pot activar en el cas d\'adreces de correu allotjades en aquest servidor. Per tal de crear una adreça de correu, vagi a la pestanya Correu.',
    'user.externalMailRedirectHint2' => 'El reenviament només es pot activar en el cas d\'adreces de correu allotjades en aquest servidor.',
    'user.externalMailAutoResponderHint' => 'Les respostes automàtiques només es poden activar en el cas d\'adreces de correu allotjades en aquest servidor. Per tal de crear una adreça de correu, vagi a la pestanya Correu.',
    'user.externalMailAutoResponderHint2' => 'Les respostes automàtiques només es poden activar en el cas d\'adreces de correu allotjades en aquest servidor.',
    'user.roleHint' => 'Els rols d\'usuari concedeixen als usuaris privilegis administratius i accés a les aplicacions que seleccioni pel rol.',
    'user.cannotManageMail' => "No disposa del permís necessari per a gestionar els serveis i la configuració del correu.",
    'user.longCompanyName' => 'El nom de l\'empresa indicat és massa llarg.',
    'user.longPhone' => 'El número de telèfon indicat és massa llarg.',
    'user.longFax' => 'El número de fax indicat és massa llarg.',
    'user.longAddress' => 'L\'adreça indicada és massa llarga.',
    'user.longCity' => 'El nom de la ciutat indicat és massa llarg.',
    'user.phoneRegexNotMatch' => 'El número de telèfon indicat no és vàlid.',
    'user.faxRegexNotMatch' => 'El número de fax indicat no és vàlid.',
    'user.shortCity' => 'El nom de la ciutat indicat és massa curt.',
    'user.limitSubscription' => 'Accés a subscripcions',
    'user.limitSubscriptionHint' => 'Permeti als usuaris accedir únicament a la subscripció especificada. El valor "Totes" permet accedir a totes les subscripcions del seu compte de hosting.',
    'user.limitSubscriptionAll' => 'Totes',
    'user.deletedSubscription' => 'Subscripció eliminada',

    'web.add-domain-alias.title' => 'Addició d\'un àlies de domini',
    'web.add-domain-alias.createdSuccessfully' => "L'àlies de domini %%name%% s'ha creat.",
    'web.add-domain-alias.domainAliasName' => 'Nom de l\'àlies de domini',
    'web.add-domain-alias.domainAliasNameHint' => 'Per exemple, example.net',
    'web.add-domain-alias.forDomain' => 'Pel domini',
    'web.add-domain-alias.settingsSectionLegend' => 'Configuració',
    'web.add-domain-alias.settingsDns' => 'Sincronitzar la zona DNS amb el domini principal',
    'web.add-domain-alias.settingsMail' => 'Servei de correu',
    'web.add-domain-alias.settingsWeb' => 'Servei web',
    'web.add-domain-alias.settingsSeoRedirect' => 'Redireccionament amb el codi HTTP 301',
    'web.add-domain-alias.settingsSeoRedirectHint' => 'Quan els visitants obrin l\'URL de l\'àlies, se\'ls redireccionarà a l\'URL del domini principal. Plesk utilitza el redireccionament HTTP 301 compatible amb els navegadors, el que significa que el posicionament als buscadors no es dividirà entre les diferents URLs.',
    'web.add-domain-alias.settingsTomcat' => 'Aplicacions web en Java',
    'web.add-domain-alias.invalidDomainGuid' => 'Domini no vàlid',

    'web.add-domain.formTitle' => 'Afegint domini nou',
    'web.add-domain.portalLink' => 'Portal de serveis',
    'web.add-domain.domainName' => 'Nom del domini',
    'web.add-domain.domainNameHint' => "Per exemple, example.com",
    'web.add-domain.assignToCustomer' => 'Assignar aquest domini a un client',
    'web.add-domain.customer' => 'Seleccioni un client',
    'web.add-domain.createNewCustomer' => 'Crear un client nou',
    'web.add-domain.selectExistingCustomer' => 'Seleccioni un client existent:',
    'web.add-domain.customerContactInfoHint' => 'Introdueixi la informació de contacte del client. També pot especificar tota la informació més tard, com per exemple el número de telèfon i l\'adreça.',
    'web.add-domain.customerLoginInfoHint' => 'Credencials pel panell del client',
    'web.add-domain.target' => 'Espai web',
    'web.add-domain.createNewTarget' => 'Crear una subscripció nova',
    'web.add-domain.createNewTarget_powerUser' => 'Crear un espai web nou',
    'web.add-domain.selectExistingTarget' => 'Seleccioni una subscripció existent:',
    'web.add-domain.selectExistingTarget_powerUser' => 'Seleccioni un espai web existent:',
    'web.add-domain.dns' => 'Activar el servei de DNS',
    'web.add-domain.dnsHint' => '',
    'web.add-domain.mail' => 'Activar el servei de correu',
    'web.add-domain.mailHint' => '',
    'web.add-domain.mailHintNoPermission' => 'Funciona si la configuració de la subscripció permet la gestió del permís de correu per domini. Si no ho permet, l\'estat actual del servei de correu s\'obtindrà de la subscripció.',
    'web.add-domain.hostingManagementOptions' => 'Tipus de hosting',
    'web.add-domain.websiteHosting' => 'Hosting de llocs web',
    'web.add-domain.websiteForwarding' => 'Redireccionament',
    'web.add-domain.websiteNoHosting' => 'Sense hosting',
    'web.add-domain.hostingSettingsSectionLegend' => 'Configuració de hosting',
    'web.add-domain.domainCreatedSuccessfully' => 'El domini %%domainName%% s\'ha creat correctament.',
    'web.add-domain.webspaceLegend' => 'Configuració de l\'espai web',
    'web.add-domain.addWhmWebsiteTitle' => 'Addició d\'un lloc web nou',
    'web.add-domain.addWhmWebsiteHint' => "Pot triar allotjar un lloc web al servidor.",
    'web.add-domain.selectWhmDomain' => 'Seleccioni un domini',
    'web.add-domain.customerLegend' => 'Informació del client',
    'web.add-domain.credentials' => 'Credencials de l\'usuari del sistema',
    'web.add-domain.credentialsHint' => 'per accedir als arxius allotjats a través de FTP i SSH',
    'web.add-domain.credentialsHintWin' => 'per accedir als arxius allotjats a través de FTP i RDP',
    'web.add-domain.buttonAddDomain' => 'Afegir domini',

    'web.add-subdomain.formTitle' => 'Addició d\'un subdomini',
    'web.add-subdomain.formGeneralHint' => 'Els subdominis són les adreces d\'Internet per les diferents seccions del seu lloc web. Aquestes fan servir el nom del seu domini principal i un prefix. Per exemple, si el seu domini és domain.com, el subdomini pot ser store.domain.com.',
    'web.add-subdomain.formGeneralHintAdditional' => 'També pot crear un subdomini wildcard indicant el símbol * enlloc del nom. Els visitants del lloc seran redireccionats a aquest subdomini sigui quin sigui el nom de subdomini que hagin introduït al navegador.',
    'web.add-subdomain.subdomainName' => 'Nom del subdomini',
    'web.add-subdomain.subdomainNameHint' => 'Indiqui * per a crear un subdomini wildcard.',
    'web.add-subdomain.forDomain' => 'Domini principal',
    'web.add-subdomain.subdomainCreatedSuccessfully' => 'El subdomini s\'ha creat.',
    'web.add-subdomain.hostingSettingsSectionLegend' => 'Configuració de hosting',

    'web.setupService.formTitle' => 'Servei de configuració: %%serviceReference%%',
    'web.setupService.successfullyUpdated' => 'El servei \'%%serviceReference%%\' s\'ha actualitzat correctament.',

    'web.site-copy.subdomainsGroup' => '%%siteName%% subdominis:',
    'web.site-copy.destinationTypeSection' => 'Destí de la còpia',
    'web.site-copy.destinationType' => 'Seleccioni on s\'han de copiar els arxius del lloc',
    'web.site-copy.destinationTypeSite' => 'Lloc web a Plesk',
    'web.site-copy.destinationTypeSiteDescription' => 'Copiï els arxius del lloc a un altre dels seus llocs allotjats sota aquest compte. Si disposa d\'accés FTP a un altre compte d\'aquest servidor, utilitzi l\'opció Emmagatzematge FTP.',
    'web.site-copy.destinationTypeSiteDescription_powerUser' => 'Copiï els arxius del lloc a un altre lloc allotjat en aquest servidor.',
    'web.site-copy.destinationTypeSiteSelect' => 'Nom del lloc',
    'web.site-copy.destinationSiteRootIsSubDirOfSourceRoot' => "Els arxius del lloc %%source%% no es poden copiar a %%destination%% perquè %%destination%% també forma part d'aquests arxius — la seva arrel del document és un subdirectori de l'arrel del document %%source%%.",
    'web.site-copy.unableToDeleteSourceRootIsSubdirOfDestinationRoot' => "Els arxius del lloc %%destination%% no es poden eliminar perquè els arxius de %%source%% formen part d'ells — l'arrel del document de %%source%% és un subdirectori de %%destination%%.",
    'web.site-copy.destinationTypeFtp' => 'Emmagatzematge FTP',
    'web.site-copy.destinationTypeFtpDescription' => 'Copiï els arxius del lloc web a un compte FTP d\'aquest servidor o bé d\'un servidor extern.',
    'web.site-copy.destinationTypeFtpDescription_powerUser' => 'Copiï els arxius del lloc web a un compte FTP d\'un servidor extern.',
    'web.site-copy.destinationTypeFtpHost' => "Nom del host del servidor",
    'web.site-copy.destinationTypeFtpPort' => "Port",
    'web.site-copy.destinationTypeFtpFolder' => 'Directori',
    'web.site-copy.destinationTypeFtpUser' => 'Nom d\'usuari',
    'web.site-copy.destinationTypeFtpPassword' => 'Contrasenya',
    'web.site-copy.destinationTypeFtpMode' => 'Mètode de connexió FTP',
    'web.site-copy.destinationTypeFtpModeActive' => 'Mode actiu',
    'web.site-copy.destinationTypeFtpModeActiveDescription' => 'En mode actiu, Plesk envia la seva adreça IP i el número de port on s\'escoltarà a un servidor extern i el servidor inicia la connexió TCP. Aquest mode es recomana en el cas que el servidor gestionat per Plesk no estigui protegit per un firewall.',
    'web.site-copy.destinationTypeFtpModePassive' => 'Mode passiu',
    'web.site-copy.destinationTypeFtpModePassiveDescription' => 'El mode passiu es pot fer servir en cas que el servidor gestionat per Plesk es trobi darrera d\'un firewall i no es puguin acceptar connexions TCP entrants.',
    'web.site-copy.existingFiles' => 'Accions a realitzar amb els arxius existents',
    'web.site-copy.existingFilesKeep' => 'Conservar els arxius existents al lloc de destí',
    'web.site-copy.existingFilesKeepDescription' => 'Sobreescrigui els arxius existents pels noms d\'arxius coincidents al lloc de destí.',
    'web.site-copy.existingFilesDelete' => 'Eliminar tots els arxius existents',
    'web.site-copy.existingFilesDeleteDescription' => 'Elimini tots els arxius presents al lloc de destí abans d\'efectuar la còpia.',
    'web.site-copy.emptyLogin' => 'Indiqui un nom d\'usuari pel compte FTP.',
    'web.site-copy.emptyHost' => 'Indiqui el nom del host del servidor.',
    'web.site-copy.emptyPort' => 'Indiqui un port pel host del servidor.',
    'web.site-copy.copyInProgress' => 'Copiant el lloc web %%sourceName%% a %%destinationName%%. L\'informarem del progrés de l\'operació per correu electrònic (%%email%%).',
    'web.site-copy.unableToCopy' => 'No s\'han pogut copiar els arxius del lloc web.',
    'web.site-copy.siteCopied' => 'Els arxius del lloc web s\'han copiat.',
    'web.site-copy.emailSubjSuccess' => 'Els arxius del lloc web "%%source%%" s\'han copiat.',
    'web.site-copy.emailSubjFailure' => 'Error al copiar els arxius del lloc web "%%source%%".',
    'web.site-copy.emailBodySuccess' => 'Els arxius del lloc web "%%source%%" s\'han copiat a "%%destination%%".',
    'web.site-copy.emailBodyFailure' => 'No s\'han pogut copiar els arxius del lloc web "%%source%%" a "%%destination%%": %%message%%',

    'web._shared.forwardingSettingsSectionLegend' => 'Configuració de redireccionament',
    'web._shared.forwardDestination' => 'Adreça de destí',
    'web._shared.forwardDestinationHint' => 'URL del lloc web de destí.',
    'web._shared.forwardingTypeOptions' => 'Tipus de redireccionament',
    'web._shared.forwardingFrame' => 'Redireccionament per marcs',
    'web._shared.forwardingFrameHint' => 'Redireccioni els visitants del lloc web a un altre lloc sense mostrar l\'adreça de destí perquè així no siguin conscients d\'aquest redireccionament.',
    'web._shared.forwardingHttpCode301' => 'Mogut de forma permanent (codi 301)',
    'web._shared.forwardingHttpCode301Hint' => 'Redireccioni els visitants del lloc web a un altre lloc i mostri l\'adreça de destí. Aquest redireccionament preservarà el posicionament del lloc a les cerques dels buscadors.',
    'web._shared.forwardingHttpCode302' => 'Mogut de forma temporal (codi 302)',
    'web._shared.forwardingHttpCode302Hint' => 'Redireccioni els visitants del lloc web a una còpia temporal del lloc quan no desitgi que els buscadors indexin aquest lloc temporal.',
    'web._shared.documentRoot' => 'Arrel del document',
    'web._shared.documentRootHint' => 'La ruta al directori inicial del lloc web.',
    'web._shared.documentRootHintDisabledDueApplications' => 'No és possible modificar l\'arrel del document perquè en aquest lloc web s\'han instal·lat aplicacions web.',
    'web._shared.ipAddress' => 'Adreça IP',
    'web._shared.shared' => 'compartida',
    'web._shared.exclusive' => 'dedicada',
    'web._shared.ipAddressHint' => "L'adreça IP on s'allotja el lloc web és una adreça de xarxa del host virtual del lloc web.",
    'web._shared.certificateFromDomainRepository' => '%%name%% (%%repositoryName%%)',
    'web._shared.certificateFromOtherRepository' => '%%name%% (un altre repositori)',
    'web._shared.certificate' => 'Certificat',
    'web._shared.sameCertificatesHint' => 'El certificat seleccionat també es farà servir per tots els llocs allotjats a la mateixa adreça IP dedicada.',
    'web._shared.differentCertificatesHint' => 'Aquesta subscripció està associada amb dues adreces IP dedicades que tenen dos certificats diferents. El certificat seleccionat substituirà els certificats instal·lats als llocs allotjats en aquestes dues adreces IP.',
    'web._shared.differentIpTypesCertificateHint' => 'Aquesta subscripció està associada amb una adreça IP compartida i una de dedicada. El certificat seleccionat també es farà servir per tots els altres llocs allotjats a l\'adreça IP dedicada.',
    'web._shared.certificateNotSelected' => 'No seleccionat',
    'web._shared.sslCertificatesRepositoryIsEmptyHint' => 'Al seu repositori no hi ha cap certificat SSL/TLS. Si desitja afegir un certificat, vagi a %%link%%.',
    'web._shared.sslCertificatesRepositoryLink' => 'aquesta pàgina',
    'web._shared.seoRedirectDirection' => 'Domini preferit',
    'web._shared.seoRedirectDirectionHint' => 'Seleccioni l\'URL (amb o sense el prefix www.) a la que es redireccionaran els visitants del lloc a través d\'un redireccionament HTTP 301 respectuós amb el SEO.',
    'web._shared.seoRedirectDirectionNone' => 'Cap',
    'web._shared.limitMbUnits' => 'MB',

    'web-user.settings.allowScripts' => 'Permetre als usuaris web utilitzar scripts',

    'web-user.name' => 'Nom d\'usuari per a connectar-se al servidor mitjançant FTP',
    'web-user.longName' => 'Aquest nom d\'usuari és massa llarg. La longitud màxima permesa és de %max% símbols.',
    'web-user.password' => 'Contrasenya',
    'web-user.passwordConfirmation' => 'Confirmi la contrasenya',
    'web-user.hardDiskQuota' => 'Quota de disc dur',
    'web-user.hardDiskQuotaUnlimited' => 'Il·limitada',
    'web-user.hardDiskQuotaIsNotSupported' => '(no es suporta la quota de disc dur degut a la configuració del sistema d\'arxius del servidor)',
    'web-user.megabytes' => 'MB',

    'web-user.__asp_win_support' => 'Suport de Microsoft ASP',
    'web-user.__asp_dot_net_support' => 'Suport de Microsoft ASP.NET',
    'web-user.__ssi_support' => 'Suport per SSI',
    'web-user.__php_support' => 'Suport de PHP',
    'web-user.__cgi_support' => 'Suport per CGI',
    'web-user.__perl_unix_support' => 'Suport per Perl',
    'web-user.__perl_win_support' => 'Suport per Perl',
    'web-user.__python_unix_support' => 'Suport per Python',
    'web-user.__python_win_support' => 'Suport per Python',
    'web-user.__fastcgi_unix_support' => 'Suport de FastCGI',
    'web-user.__webstat_support' => 'Estadístiques web',
    'web-user.__apache_errdocs' => 'Documents d\'error personalitzats',
    'web-user.__hosting_write_modify' => 'Permisos d\'escriptura/modificació addicionals',
    'web-user.__hosting_webdeploy' => 'Publicació Web Deploy',


    'requiredFields' => 'Camps obligatoris',
];