<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'access-network.subnetOrIpAddressLabel' => 'Подсеть или IP-адрес',
    'access-network.subnetOrIpAddressHint' => 'Например, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'admin.announcement-settings.announcementLegend' => 'Информационные сообщения',
    'admin.announcement-settings.getConsentLoading' => 'Получение данных об информационных сообщениях...',
    'admin.announcement-settings.getConsentWarning' => 'Не удалось получить состояние подписки.',
    'admin.announcement-settings.sendAnnounceConsent' => 'Я хочу получать информационные сообщения от WebPros. Они могут содержать информацию, относящуюся к безопасности, техническим деталям и продукту в целом. Я разрешаю и уполномочиваю WebPros собирать, обрабатывать и использовать мои персональные данные (адрес электронной почты), включая трансграничную передачу данных, в соответствии с действующими законами о защите данных, чтобы отправлять мне информационные сообщения либо напрямую, либо через стороннюю службу. Снятие этой галочки отменяет мое разрешение и означает требование того, чтобы WebPros прекратил отправлять мне письма и безвозвратно удалил мои персональные данные из всех своих систем.',
    'admin.announcement-settings.sendAnnouncePersonalizedConsent' => 'Указанные здесь компании WebPros могут использовать мое имя и адрес электронной почты (%%adminEmail%%) в целях создания для меня персонализированного маркетингового контента, включая информационные сообщения и индивидуальные предложения, относящиеся к продуктам WebPros. Разрешение на использование персональных данных запрашивают следующие компании: WebPros International LLC и WebPros International GmbH. Информация будет обрабатываться в соответствии с %%privacyPolicy%% до тех пор, пока мое согласие не будет аннулировано, и может передаваться в другие подразделения группы WebPros. Я могу изменить и аннулировать свое согласие в любое время, сняв галочку, нажав на ссылку в любом полученном сообщении или отправив письмо на адрес privacy@plesk.com.',
    'admin.announcement-settings.privacyPolicy' => 'Политикой конфиденциальности WebPros',
    'admin.announcement-settings.noConsent' => 'Отменить подписку на новостную рассылку WebPros.',
    'admin.announcement-settings.reportConsentError' => 'Не удалось сохранить настройки получения информации от Plesk: %%error%%.',
    'admin.announcement-settings.profileUpdateError' => 'К сожалению, в настоящий момент мы не можем обновить ваш профиль. Пожалуйста, повторите попытку позже.',
    'admin.announcement-settings.invalidConsentType' => "Неизвестный тип подтверждения согласия: '%%type%%'",
    'admin.announcement-settings.retry' => 'Повторить',
    'admin.announcement-settings.consentGivenInfo' => 'Надеемся, наша основная новостная рассылка была вам полезна. Предлагаем вам другой вариант ― подписаться на персонализированную рассылку, содержащую действительно нужную информацию и советы, подходящие именно вам. Чтобы получать такую рассылку, выберите первый из предложенных ниже вариантов и нажмите "ОК".',

    'admin.personal-info.title' => 'Изменение сведений об администраторе',
    'admin.personal-info.pleskSettingsSectionLegend' => 'Настройки Plesk',
    'admin.personal-info.settingsSectionLegend' => 'Настройки',

    'admin-alias.login' => 'Имя пользователя',
    'admin-alias.password' => 'Пароль',
    'admin-alias.passwordConfirmation' => 'Подтверждение пароля',
    'admin-alias.email' => 'Электронная почта',
    'admin-alias.contact' => 'Контактное имя',
    'admin-alias.comments' => 'Комментарии',
    'admin-alias.emptyLogin' => 'Пожалуйста, укажите имя пользователя.',
    'admin-alias.loginTooLong' => 'Длина имени пользователя превышает 20 символов.',
    'admin-alias.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'admin-alias.emptyContactName' => 'Пожалуйста, укажите контактное имя.',
    'admin-alias.contactNameTooLong' => 'Длина контактного имени превышает 255 символов.',
    'admin-alias.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'admin-alias.commentsTooLong' => 'Длина комментария превышает 255 символов.',
    'admin-alias.emailActivation' => 'Активировать учетную запись по электронной почте',
    'admin-alias.simplePanel' => 'Включить Ограниченный режим',
    'admin-alias.simplePanelHint' => 'Выберите эту опцию, чтобы ограничить количество операций, которые дополнительный администратор сможет выполнять в Plesk. Чтобы изменить набор доступных операций, перейдите по ссылке %%link%%.',
    'admin-alias.simplePanelLink' => 'Инструменты и настройки > Настройки Ограниченного режима',
    'admin-alias.lockPowerUser' => 'Принудительно включить режим Power User для дополнительного администратора',
    'admin-alias.lockPowerUserHint' => 'Возможность включить Ограниченный режим для дополнительного администратора Plesk (без доступа к клиентам, реселлерам и тарифным планам).',

    'admin-info.plesk-settings.multiplyLogin' => 'Разрешить несколько сеансов для этой учетной записи',
    'admin-info.plesk-settings.adminLanguage' => 'Язык интерфейса администратора',
    'admin-info.plesk-settings.password' => 'Пароль',
    'admin-info.plesk-settings.passwordConfirmation' => 'Подтверждение пароля',
    'admin-info.plesk-settings.oldPassword' => 'Старый пароль',
    'admin-info.plesk-settings.oldPasswordIsIncorrect' => 'Неверный старый пароль. Пожалуйста, попробуйте еще раз.',

    'admin-panel.form.contact-info.login' => 'Логин',
    'admin-panel.form.contact-info.contactName' => 'Контактное имя',
    'admin-panel.form.contact-info.emptyLogin' => 'Укажите имя пользователя.',
    'admin-panel.form.contact-info.emptyContactName' => 'Пожалуйста, укажите контактное имя.',
    'admin-panel.form.contact-info.loginTooLong' => 'Слишком длинное имя пользователя (число символов не должно превышать %max%).',
    'admin-panel.form.contact-info.contactNameTooLong' => 'Контактное имя слишком длинное (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.email' => 'Электронная почта',
    'admin-panel.form.contact-info.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'admin-panel.form.contact-info.companyName' => 'Название компании',
    'admin-panel.form.contact-info.longCompanyName' => 'Слишком длинное название компании (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.phone' => 'Номер телефона',
    'admin-panel.form.contact-info.longPhone' => 'Слишком длинный номер телефона (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.fax' => 'Факс',
    'admin-panel.form.contact-info.imNumber' => 'Программа для мгновенного обмена сообщениями',
    'admin-panel.form.contact-info.longFax' => 'Слишком длинный номер факса (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.phoneRegexNotMatch' => 'Недопустимый номер телефона.',
    'admin-panel.form.contact-info.faxRegexNotMatch' => 'Неверный номер факса.',
    'admin-panel.form.contact-info.address' => 'Адрес',
    'admin-panel.form.contact-info.longAddress' => 'Слишком длинный адрес (максимальная длина — %max% символов).',
    'admin-panel.form.contact-info.city' => 'Город',
    'admin-panel.form.contact-info.longCity' => 'Слишком длинное название города',
    'admin-panel.form.contact-info.shortCity' => 'Слишком короткое название города',
    'admin-panel.form.contact-info.state' => 'Область/регион',
    'admin-panel.form.contact-info.postalCode' => 'Почтовый индекс',
    'admin-panel.form.contact-info.country' => 'Страна',
    'admin-panel.form.contact-info.additionalInfo' => 'Дополнительная информация',
    'admin-panel.form.contact-info.additionalInfoHint' => 'Только текст: все HTML-теги будут опущены.',
    'admin-panel.form.contact-info.duplicateEmail' => 'Пользователь с таким адресом электронной почты уже существует в системе.',

    'admin-panel.form.domain-info-section.domainInfoSection' => 'Подписка',
    'admin-panel.form.domain-info-section.domainInfoSectionForCustomerHint' => 'Свойства сайта, входящего в подписку.',
    'admin-panel.form.domain-info-section.domainInfoSectionForResellerHint' => 'Свойства сайта, входящего в подписку.',
    'admin-panel.form.domain-info-section.domainInfoSectionOwnHint' => 'Свойства сайта, входящего в подписку.',
    'admin-panel.form.domain-info-section.createSubscription' => 'Создать подписку для клиента',
    'admin-panel.form.domain-info-section.createSubscriptionHint' => 'Снимите этот флажок, если пока не хотите создавать подписку или сайт для этого клиента. Без подписки клиент не сможет войти в Панель клиента.',
    'admin-panel.form.domain-info-section.domainName' => 'Имя домена',
    'admin-panel.form.domain-info-section.emptyDomainName' => 'Необходимо указать имя домена.',
    'admin-panel.form.domain-info-section.shared' => 'общий',
    'admin-panel.form.domain-info-section.exclusive' => 'выделенный',
    'admin-panel.form.domain-info-section.userName' => 'Имя пользователя',
    'admin-panel.form.domain-info-section.userNameHint' => 'Системная учетная запись пользователя, служащая для управления файлами и папками сайтов, созданных в рамках этой подписки.',
    'admin-panel.form.domain-info-section.emptyLogin' => 'Необходимо указать имя пользователя.',
    'admin-panel.form.domain-info-section.password' => 'Пароль',
    'admin-panel.form.domain-info-section.emptyPassword' => 'Вы должны указать пароль.',
    'admin-panel.form.domain-info-section.passwordConfirmation' => 'Подтвердите пароль',
    'admin-panel.form.domain-info-section.ipv4AddressHint' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта.",
    'admin-panel.form.domain-info-section.ipv4Address' => 'IPv4-адрес',
    'admin-panel.form.domain-info-section.ipv6AddressHint' => "IP-адрес, на котором размещен сайт, является сетевым адресом виртуального сервера сайта.",
    'admin-panel.form.domain-info-section.ipv6Address' => 'IPv6-адрес',
    'admin-panel.form.domain-info-section.noIpAddressHint' => 'Нет',
    'admin-panel.form.domain-info-section.subscriptionSettings' => 'Настройки дополнительной подписки',
    'admin-panel.form.domain-info-section.credentials' => 'Учетные данные системного пользователя',
    'admin-panel.form.domain-info-section.credentialsHint' => 'для доступа к размещенным файлам по FTP и SSH',
    'admin-panel.form.domain-info-section.credentialsHintWin' => 'для доступа к размещенным файлам по FTP и RDP',

    'admin-panel.form.login-info.userName' => 'Имя пользователя',
    'admin-panel.form.login-info.emptyUserName' => 'Пожалуйста, укажите имя пользователя.',
    'admin-panel.form.login-info.password' => 'Пароль',
    'admin-panel.form.login-info.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'admin-panel.form.login-info.passwordConfirmation' => 'Повторите пароль',
    'admin-panel.form.login-info.internalEmailPasswordChanged' => 'Смена пароля приведет также к смене пароля внутреннего почтового адреса',
    'admin-panel.form.login-info.emailActivation' => 'Активировать учетную запись по электронной почте',
    'admin-panel.form.login-info.emailActivationHint' => 'Созданная учетная запись неактивна до тех пор, пока пользователь не активирует ее с помощью ссылки, отправленной по электронной почте, либо администратор не активирует ее вручную.',

    'admin-panel.form.subscription-info-section.subscription' => 'Подписка',
    'admin-panel.form.subscription-info-section.servicePlan' => 'Тарифный план',
    'admin-panel.form.subscription-info-section.oldServicePlan' => 'Текущий тарифный план',
    'admin-panel.form.subscription-info-section.newServicePlan' => 'Новый тарифный план',
    'admin-panel.form.subscription-info-section.adminPlan' => 'Упрощенный план',
    'admin-panel.form.subscription-info-section.none' => 'нет',
    'admin-panel.form.subscription-info-section.addonPlans' => 'Дополнения',
    'admin-panel.form.subscription-info-section.customizeSubscription' => 'После изменения связи плана перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionOnCreateSubscription' => 'После создания подписки перейти к настройке ее параметров.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionForCustomer' => "После создания клиента перейти к настройке параметров подписки.",
    'admin-panel.form.subscription-info-section.customizeSubscriptionForSelf' => 'После создания подписки перейти к настройке ее параметров. Учтите, что это приведет к блокировке синхронизации подписки.',
    'admin-panel.form.subscription-info-section.customizeSubscriptionHint' => 'Учтите, что это приведет к блокировке синхронизации подписки.',
    'admin-panel.form.subscription-info-section.buttonOk' => 'Добавить подписку',

    'admin-panel.form.subscription.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'app.configure.otherSettings' => 'Другое',
    'app.configure.passwordConfirmation' => 'Подтверждение пароля',

    'app.update-settings.description' => '',
    'app.update-settings.forceUpdates' => 'Принудительно обновлять все приложения',
    'app.update-settings.forceUpdatesHint' => 'Эта опция позволяет включить автоматическую установку обновлений для всех приложений клиентов. Сами клиенты отключить эту возможность не смогут. Предупреждение: пожалуйста, учтите, что обновления могут серьезно повлиять на работу приложений. Например, после перехода на новую версию приложения могут перестать работать некоторые из его расширений.',
    'app.update-settings.suggestUpdates' => 'Опция "Автоматически обновлять это приложение" включена по умолчанию',
    'app.update-settings.suggestUpdatesHint' => 'В настройках вновь устанавливаемых приложений будет включена опция "Автоматически обновлять это приложение".',

    'backup.server-settings.rotation' => 'Максимальное количество хранимых полных резервных копий (включая созданные по расписанию и вручную)',
    'backup.server-settings.rotationDescription' => 'Пользователи могут хранить не больше указанного здесь количества полных резервных копий. Если количество полных резервных копий в хранилище превышает это ограничение, сохраняются только недавно созданные резервные копии. Ограничение не распространяется на инкрементные резервные копии.',
    'backup.server-settings.maxProcesses' => 'Максимальное число одновременно запущенных плановых процессов резервного копирования',
    'backup.server-settings.niceScheduled' => 'Запускать запланированные процессы резервного копирования с низким приоритетом',
    'backup.server-settings.niceScheduledPriority' => 'Приоритет',
    'backup.server-settings.niceScheduledPriorityDescription' => 'Введите значение от 1 до 19 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.niceScheduledIoPriority' => 'Приоритет ввода-вывода процесса',
    'backup.server-settings.niceScheduledIoPriorityDescription' => 'Введите значение от 0 до 7 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.niceAlways' => 'Запускать все процессы резервного копирования с низким приоритетом',
    'backup.server-settings.niceAlwaysPriority' => 'Приоритет',
    'backup.server-settings.niceAlwaysPriorityDescription' => 'Введите значение от 1 до 19 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.niceAlwaysIoPriority' => 'Приоритет ввода-вывода процесса',
    'backup.server-settings.niceAlwaysIoPriorityDescription' => 'Введите значение от 0 до 7 включительно. Чем больше число, тем ниже приоритет.',
    'backup.server-settings.compressionLevel' => 'Уровень сжатия',
    'backup.server-settings.compressionLevelNoCompression' => 'Без сжатия',
    'backup.server-settings.compressionLevelFastest' => 'Самый быстрый',
    'backup.server-settings.compressionLevelFast' => 'Быстрый',
    'backup.server-settings.compressionLevelNormal' => 'Обычный',
    'backup.server-settings.compressionLevelMaximum' => 'Максимальный',
    'backup.server-settings.freeSpaceRequired' => 'Выполнять резервное копирование, только если на сервере свободно указанное количество места (в мегабайтах)',
    'backup.server-settings.checkBackupDiskSpace' => 'Запускать резервное копирование, только если на сервере достаточно свободного места',
    'backup.server-settings.mssqlNativeBackupEnabled' => 'Используйте собственную функциональность резервного копирования MS SQL (для удаленных баз данных нужно сначала настроить удаленный сервер MSSQL на странице Инструменты и настройки > Серверы баз данных)',
    'backup.server-settings.localFtpRestriction' => 'Разрешить добавление FTP-хранилищ резервных копий на локальном сервере',
    'backup.server-settings.backupSecuritySettings' => 'Настройки безопасности резервного копирования',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailed' => 'Сохранить резервные копии в хранилище сервера, если не удается загрузить их в удаленное хранилище',
    'backup.server-settings.keepLocalBackupIfExportToFtpFailedDescription' => 'Запланированные и созданные вручную резервные копии, которые должны быть сохранены в удаленном хранилище, будут сохранены в локальном хранилище сервера, если не удастся загрузить их в удаленное хранилище. Пользователям нужно обладать правами для сохранения резервных копий в хранилище сервера.',
    'backup.server-settings.AllowScheduleHourly' => 'Разрешить клиентам и реселлерам планировать почасовое резервное копирование',

    'change-current-subscription.hint' => 'Здесь вы можете изменить тарифный план подписки. Учтите, что выбор пункта \'нет\' в качестве нового плана удаляет связь между подпиской и тарифным планом и делает ее \'Персональной\'.',
    'change-current-subscription.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'change-password.oldPassword' => 'Старый пароль',
    'change-password.password' => 'Новый пароль',
    'change-password.passwordConfirmation' => 'Подтверждение пароля',
    'change-password.oldPasswordIsIncorrect' => 'Неверный старый пароль. Пожалуйста, попробуйте еще раз.',
    'change-password.unableToFindAdditionalAdminAccount' => 'Не удается найти дополнительную учетную запись администратора.',
    'change-password.warningAboutAdminPasswordSyntax' => "Пароль должен быть длиной от %%min%% до %%max%% символов и не должен содержать имени пользователя.\nПароль не должен содержать кавычки, пробелы и национальные символы.",
    'change-password.warningAboutWinAdminPasswordSyntax' => "Пароль не должен содержать кавычки, пробелы, двоеточия и национальные символы. Пароль должен быть длиной от %%min%% до %%max%% символов и не должен содержать имени пользователя.",

    'change-reseller-oversell-policy.oversellPolicy' => 'Продажа сверх запасов',
    'change-reseller-oversell-policy.oversellPolicyAllowed' => 'Продажа сверх запасов разрешена',
    'change-reseller-oversell-policy.oversellPolicyAllowedHint' => 'Продажа сверх запасов позволяет реселлеру продавать больше ресурсов, чем доступно в его плане. Если продажа сверх запасов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов.',
    'change-reseller-oversell-policy.oversellPolicyNotAllowed' => 'Продажа сверх запасов запрещена',
    'change-reseller-oversell-policy.oversellPolicyNotAllowedHint' => 'Если продажа сверх запасов запрещена, реселлер может продавать только столько ресурсов, сколько изначально было доступно в его плане, независимо от того, сколько ресурсов используется фактически.',

    'change-reseller-subscription.hint' => 'Здесь вы можете изменить тарифный план для выбранного реселлера. Учтите, что выбор пункта \'нет\' в качестве нового плана удаляет связь между подпиской и тарифными планами и делает ее \'Персональной\'.',
    'change-reseller-subscription.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',
    'change-reseller-subscription.servicePlan' => 'Новый план',
    'change-reseller-subscription.oldSubscription' => 'Текущий план',
    'change-reseller-subscription.none' => 'нет',
    'change-reseller-subscription.infoSubscriptionChanged' => 'Связь подписки с тарифным планом обновлена.',
    'change-reseller-subscription.customizeSubscription' => 'После изменения привязки к тарифному плану перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.',

    'change-subscription.hint' => 'Здесь вы можете изменить тарифный план для выбранных подписок.',
    'change-subscription.selectPlanLegend' => 'Тарифный план',
    'change-subscription.selectPlanDescription' => 'Чтобы переключиться на другой тарифный план, выберите новый план из списка. Учтите, что выбор пункта \'нет\' в качестве нового плана удаляет связь между подпиской и тарифными планами и делает ее \'Персональной\'.',
    'change-subscription.servicePlan' => 'Новый тарифный план',
    'change-subscription.selectAddonPlansLegend' => 'Дополнительные планы',
    'change-subscription.selectAddonPlansDescription' => 'Добавить или удалить дополнительные планы.',
    'change-subscription.noChange' => 'без изменения',
    'change-subscription.none' => 'нет',
    'change-subscription.add' => 'добавить',
    'change-subscription.del' => 'Удалить',
    'change-subscription.separator' => '-------',

    'control-panel-access.network.subnetOrIpAddressLabel' => 'Подсеть или IP-адрес',
    'control-panel-access.network.subnetOrIpAddressHint' => 'Например, 2002:7b7b:7b7b::/48, 2002:7b7b:7b7b::1/48, 2002:7b7b:7b7b::1, 123.123.*.*, 123.123.0.0/16, 123.123.123.123/16, 123.123.123.123/32, 123.123.0.0/255.255.0.0, 123.123.123.123/255.255.0.0, 123.123.123.123/255.255.255.255, 123.123.123.123',

    'control-panel-access.settings.accessPolicyLabel' => 'Доступ к Plesk с правами администратора',
    'control-panel-access.settings.policyAllow' => 'Разрешить доступ из всех сетей, кроме указанных ниже.',
    'control-panel-access.settings.policyDeny' => 'Запретить доступ из всех сетей, кроме указанных ниже.',

    'create-subscription.title' => 'Добавление подписки',
    'create-subscription.titleOwn' => 'Добавление вашей личной подписки',
    'create-subscription.poolIsEmpty' => 'Не удалось создать подписку, так как в Plesk нет общих IP-адресов, и нет свободных выделенных IP-адресов.',
    'create-subscription.infoNewSubscriptionCreated' => 'Подписка %%name%% создана.',
    'create-subscription.createBeforeAppInstall' => 'Для установки приложения у вас должна быть подписка.',

    'customer.hint' => 'Здесь вы можете подписать нового клиента на свои услуги хостинга. Это означает, что в Plesk будет создана учетная запись и подписка на один из ваших хостинг-планов (и, возможно, дополнительных планов). Подписка также может предоставлять полностью индивидуальный набор ресурсов и услуг без привязки к планам ‒ в этом случае выберите \'нет\' в поле "Тарифный план".',
    'customer.contactInfoSection' => 'Контактная информация',
    'customer.additionalInfoSection' => 'Дополнительная информация о клиенте',
    'customer.accessToPanelSection' => 'Доступ к Plesk',
    'customer.contactInfoSectionHint' => 'Введите контактные данные клиента.',
    'customer.accessToPanelSectionHint' => 'Учетные данные, которые клиент будет использовать для входа в Панель клиента.',
    'customer.unableCreateSubscription' => 'Подписка не может быть создана: %%reason%%',
    'customer.poolIsEmpty' => 'IP-пул пуст',
    'customer.buttonOk' => 'Добавить клиента',

    'database-settings.dbPrefixRadio' => 'Добавлять префикс и подчеркивание в начало имен баз данных',
    'database-settings.dbPrefixNone' => 'Нет',
    'database-settings.dbPrefixUsername' => 'Имя пользователя',
    'database-settings.dbPrefixExternalId' => 'Внешний ID подписки',
    'database-settings.dbPrefixCustom' => 'Настраиваемый префикс',
    'database-settings.dbUserPrefixRadio' => 'Добавлять префикс и подчеркивание в начало имен пользователей базы данных',
    'database-settings.dbUserPrefixHint' => 'Имена пользователей баз данных будут иметь вид <префикс>_<имя_пользователя_базы_данных>. В связи с ограничением базы данных на длину имен пользователей <префикс> может быть сокращен.',
    'database-settings.grantAlterDatabase' => 'Предоставлять право ALTER DATABASE всем пользователям баз данных Microsoft SQL Server',
    'database-settings.grantAlterDatabaseHint' => 'Эта опция распространяется на новых и существующих пользователей.',
    'database-settings.aclRadio' => 'Стандартные настройки удаленного доступа для пользователей баз данных MariaDB/MySQL',
    'database-settings.aclLocalhost' => 'Разрешить только локальные подключения',
    'database-settings.aclAny' => 'Разрешить удаленные подключения с любого компьютера',
    'database-settings.aclCustom' => 'Разрешить удаленные подключения с указанных компьютеров',
    'database-settings.aclDescription' => 'Эта настройка изменяет только права пользователей. Чтобы включить удаленный доступ к локальному серверу MariaDB/MySQL, выберите соответствующую опцию в %%serverLink%%',
    'database-settings.aclDescriptionLink' => 'Настройках локального сервера MariaDB/MySQL',
    'database-settings.example' => "Например:",
    'database-settings.aclExampleDescription' => "Указанным компьютерам разрешено подключаться к базе данных от лица этого пользователя.",
    'database-settings.dbPrefixAlphaNumeric' => 'Значение префикса может содержать только буквенно-цифровые значения и символ подчеркивания.',

    'dns.add-acl-record.description' => 'Добавить IP-адрес сервера DNS, которому разрешено получить копию зоны DNS.',
    'dns.add-acl-record.ipAddress' => 'IP-адрес',
    'dns.add-acl-record.ipAddressWithMask' => 'IP-адрес/маска',

    'dns.settings.recursion' => 'Рекурсивные DNS-запросы',
    'dns.settings.recursionOn' => 'Разрешить для всех запросов',
    'dns.settings.recursionLocal' => 'Разрешить только для локальных запросов',
    'dns.settings.recursionLocalnets' => 'Разрешить только для запросов от локальной(ых) сети(ей)',
    'dns.settings.recursionOff' => 'Запретить для всех запросов',
    'dns.settings.customConfiguration' => 'Дополнительные настройки DNS',
    'dns.settings.customConfigurationPlaceholder' => 'Настройки, указанные здесь, переопределяют общесерверные.',
    'dns.settings.customConfigurationHint' => 'Если вы не можете найти определенные настройки, добавьте их в поле выше, используя синтаксис named.conf.',
    'dns.settings.customConfigurationExample' => 'Например, чтобы скрыть имя хоста DNS-сервера, добавьте следующую строку: ',
    'dns.settings.restoreDefaultButton' => 'Использовать настройки по умолчанию',

    'dns.template.synchronize-done' => 'Шаблон зоны DNS успешно применен.',
    'dns.template.synchronize-error' => 'Шаблон зоны DNS не был применен к некоторым зонам DNS.',
    'dns.template.synchronize-progress' => 'Выполняется применение шаблона зоны DNS.',

    'domain-restriction.name' => 'Имя домена',
    'domain-restriction.nameDescription' => 'Можно использовать подстановочный символ *. Например, *.example.com',
    'domain-restriction.domainAlreadyExists' => 'Указанное имя домена уже есть в списке.',

    'event-handler.eventLabel' => 'Событие',
    'event-handler.priorityLabel' => 'Приоритет',
    'event-handler.userLabel' => 'Пользователь',
    'event-handler.commandLabel' => 'Команда',
    'event-handler.commandHint' => 'Рекомендуется ввести полный путь к файлу скрипта в поле \'Команда\'. Мы не рекомендуем вводить системные команды, так как не все из них поддерживаются. Например, команды с операторами перенаправления вывода > или < работать не будут.',
    'event-handler.priorityHighestText' => 'высший',
    'event-handler.priorityHighText' => 'высокий',
    'event-handler.priorityNormalText' => 'нормальный',
    'event-handler.priorityLowText' => 'низкий',
    'event-handler.priorityLowestText' => 'низший',
    'event-handler.priorityCustomText' => 'другой',
    'event-handler.priorityHighestOption' => 'высший (%%value%%)',
    'event-handler.priorityHighOption' => 'высокий (%%value%%)',
    'event-handler.priorityNormalOption' => 'нормальный (%%value%%)',
    'event-handler.priorityLowOption' => 'низкий (%%value%%)',
    'event-handler.priorityLowestOption' => 'низший (%%value%%)',

    'extension.upload.fileUpload' => 'Путь к файлу пакета расширения',

    'external-webmail.hint' => 'После регистрации дополнительной веб-почты в Plesk она станет доступна вашим клиентам: она появится в качестве варианта для выбора на вкладке \'Почта\' в свойствах планов хостинга и подписок. Имя веб-почты будет отображаться в списке опций веб-почты, а при нажатии на значок веб-почты рядом с почтовым ящиком в Панели клиента будет открываться соответствующий URL-адрес.',
    'external-webmail.name' => 'Имя почтовой веб-службы',
    'external-webmail.url' => 'URL почтовой веб-службы',
    'external-webmail.enabled' => 'Доступна',

    'ftp-settings.generalSection' => 'Общие',
    'ftp-settings.portRange' => 'Порт или диапазон портов для соединений в режиме пассивного FTP',
    'ftp-settings.hintPortRange' => '(значение по умолчанию: %%defaultPortRange%%)',

    'health.upload.hint' => 'Загрузите вашу конфигурацию проверки состояния сервера. Конфигурация будет применена сразу после загрузки.',
    'health.upload.selectFile' => 'Конфигурационный файл',

    'install-local-package.selectUploadType' => 'Выберите один из вариантов:',
    'install-local-package.uploadAsFile' => 'Загрузить APS-пакет',
    'install-local-package.downloadFromCatalog' => 'Выбрать приложение из каталога',
    'install-local-package.formInfo' => "Загрузите файл с новым приложением или выберите подходящее приложение из каталога.",
    'install-local-package.invalidFileExtension' => 'Загружаемое приложение должно быть ZIP-архивом и иметь расширение .zip.',
    'install-local-package.packagesNotSelected' => 'Не выбрано ни одного пакета.',
    'install-local-package.fileNotUploaded' => 'Файл не может быть загружен.',
    'install-local-package.visible' => 'Разрешить доступ для клиентов',
    'install-local-package.isCommercial' => 'Это платное приложение, для которого необходимо купить лицензию.',
    'install-local-package.visibleDescription' => 'Разрешить клиентам устанавливать это приложение.',

    'ip-address.addTitle' => 'Добавить IP-адрес',
    'ip-address.editTitle' => 'IP-адрес %%address%% в интерфейсе %%interface%%',
    'ip-address.generalSection' => 'Общие',
    'ip-address.interface' => 'Интерфейс',
    'ip-address.addressAndSubnetPrefixLength' => 'IP-адрес и маска подсети',
    'ip-address.addressHintIPv4' => 'Например: 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.addressHintIPv6' => 'Например: 2002:7b7b:7b7b::1/64, 123.123.123.123/16, 123.123.123.123/255.255.0.0',
    'ip-address.publicIp' => 'Внешний IP-адрес',
    'ip-address.hintPublicIp' => 'Можно использовать внешний IP-адрес, если ваш сервер Plesk работает под управлением NAT',
    'ip-address.distributionType' => 'Тип IP-адреса',
    'ip-address.distributionTypeShared' => 'Общий',
    'ip-address.distributionTypeExclusive' => 'Выделенный',
    'ip-address.certificate' => 'SSL/TLS-сертификат',
    'ip-address.defaultSite' => 'Сайт по умолчанию',
    'ip-address.ftpOverSslNotSupportedByServer' => 'Установленный FTP-сервер не поддерживает FTPS.',
    'ip-address.ftpOverSslIpv6NotSupportedByServer' => 'Установленный FTP-сервер не поддерживает IPv6-адреса.',
    'ip-address.interfaceDHCPEnabled' => 'Невозможно добавить IP-адрес. Этот сетевой интерфейс получает IP-адреса автоматически.',
    'ip-address.accessDomainOnAnyDomainWinWarning' => 'Примечание: Настраиваемый URL-адрес Plesk включен для всех неизвестных доменов. Вместо сайта по умолчанию по адресу "https://%%ip%%/" будет отображаться интерфейс Plesk',
    'ip-address.ipAddressInterfaceNotAvailableWarning' => 'Сетевой адаптер %%interface%% не существует. Назначьте этот IP-адрес другому сетевому адаптеру или удалите его из списка.',
    'ip-address.none' => 'нет',

    'ip-ban.filter.name' => 'Имя',
    'ip-ban.filter.content' => 'Содержимое',
    'ip-ban.filter.filterExistsError' => 'Фильтр с таким именем уже существует.',

    'ip-ban.jail.name' => 'Имя',
    'ip-ban.jail.filter' => 'Фильтр',
    'ip-ban.jail.filterDescription' => 'Выберите фильтр.',
    'ip-ban.jail.action' => 'Действие',
    'ip-ban.jail.actionDescription' => 'Выберите действие и нажмите Добавить.',
    'ip-ban.jail.logPath' => 'Путь к журналу',
    'ip-ban.jail.banTime' => 'Период блокировки IP-адреса',
    'ip-ban.jail.maxRetry' => 'Максимальное количество неудачных попыток входа',
    'ip-ban.jail.timeUnit' => 'секунд',
    'ip-ban.jail.addAction' => 'Добавить',
    'ip-ban.jail.chooseAction' => 'Выберите:',
    'ip-ban.jail.apache-auth-filter-description' => 'Ошибки авторизации Apache (при записи журналов в файл)',
    'ip-ban.jail.apache-auth[logging=all]-filter-description' => 'Ошибки авторизации Apache (при любой записи журналов)',
    'ip-ban.jail.apache-auth[logging=syslog]-filter-description' => 'Ошибки авторизации Apache (при записи журналов в syslog)',
    'ip-ban.jail.apache-badbots-filter-description' => 'спам-боты и нежелательные поисковые роботы',
    'ip-ban.jail.plesk-courierlogin-filter-description' => 'Ошибки IMAP- и POP3-аутентификации Courier',
    'ip-ban.jail.plesk-dovecot-filter-description' => 'Ошибки IMAP-, POP3- и Sieve-аутентификации Dovecot',
    'ip-ban.jail.plesk-dovecot[mode=aggressive]-filter-description' => 'Ошибки IMAP-, POP3- и Sieve-аутентификации Dovecot (режим aggressive)',
    'ip-ban.jail.plesk-horde-filter-description' => 'ошибки аутентификации Horde',
    'ip-ban.jail.plesk-modsecurity-filter-description' => 'Нарушения безопасности и контроля доступа брандмауэра для веб-приложений (ModSecurity)',
    'ip-ban.jail.plesk-panel-filter-description' => 'ошибки аутентификации Plesk',
    'ip-ban.jail.plesk-qmail-filter-description' => 'ошибки SMTP-аутентификации QMail',
    'ip-ban.jail.plesk-roundcube-filter-description' => 'ошибки аутентификации Roundcube',
    'ip-ban.jail.plesk-wordpress-filter-description' => 'Ошибки аутентификации WordPress',
    'ip-ban.jail.plesk-manual-filter-description' => 'Фиктивный фильтр для блокирования вручную',
    'ip-ban.jail.postfix-filter-description' => 'Ошибки SMTP-клиента Postfix (включая RBL)',
    'ip-ban.jail.postfix[mode=aggressive]-filter-description' => 'Ошибки SMTP-клиента Postfix, ошибки аутентификации и DDoS-атаки',
    'ip-ban.jail.postfix[mode=auth]-filter-description' => 'Ошибки SMTP- и SASL-аутентификации Postfix',
    'ip-ban.jail.postfix[mode=ddos]-filter-description' => 'DDoS-атаки SMTP-клиента Postfix',
    'ip-ban.jail.postfix[mode=extra]-filter-description' => 'Ошибки SMTP-клиента Postfix и ошибки аутентификации',
    'ip-ban.jail.postfix[mode=normal]-filter-description' => 'Ошибки SMTP-клиента Postfix (включая RBL)',
    'ip-ban.jail.postfix[mode=rbl]-filter-description' => 'Ошибки SMTP-клиента Postfix (только RBL)',
    'ip-ban.jail.proftpd-filter-description' => 'Ошибки входа по ProFTPD',
    'ip-ban.jail.recidive-filter-description' => 'повторно заблокированные адреса',
    'ip-ban.jail.sshd-filter-description' => 'ошибки входа по SSH',
    'ip-ban.jail.sshd[mode=aggressive]-filter-description' => 'Ошибки входа по SSH, ошибки согласования и DDoS-атаки',
    'ip-ban.jail.sshd[mode=ddos]-filter-description' => 'Ошибки входа по SSH и DDoS-атаки',
    'ip-ban.jail.sshd[mode=extra]-filter-description' => 'Ошибки входа по SSH и согласования',
    'ip-ban.jail.firewallcmd-allports-action-description' => 'Блокировка через брандмауэр firewalld на всех портах',
    'ip-ban.jail.firewallcmd-multiport-action-description' => 'Блокировка через брандмауэр firewalld на нескольких портах',
    'ip-ban.jail.firewallcmd-new-action-description' => 'Блокировка через брандмауэр firewalld на одном порту',
    'ip-ban.jail.iptables-action-description' => 'блокировать через iptables, на одном порту',
    'ip-ban.jail.iptables-allports-action-description' => 'блокировать через iptables, на всех портах',
    'ip-ban.jail.iptables-multiport-action-description' => 'блокировать через iptables, на нескольких портах',
    'ip-ban.jail.sendmail-action-description' => 'Отправлять уведомление через Sendmail',
    'ip-ban.jail.jailExistsError' => 'Джейл с таким именем уже существует.',
    'ip-ban.jail.invalidInteger' => 'Недопустимое значение. Укажите целое положительное число.',

    'ip-ban.settings.pageHint' => 'Здесь вы можете настроить блокировку IP-адресов, чтобы защитить свой сервер и размещаемые вами сайты от вредоносного трафика.',
    'ip-ban.settings.detectionEnabled' => 'Включить обнаружение атак',
    'ip-ban.settings.banPeriod' => 'Период блокировки IP-адреса',
    'ip-ban.settings.banTimeWindow' => 'Интервал обнаружения последующих атак',
    'ip-ban.settings.maxRetries' => 'Допустимое количество неудачных попыток входа перед блокировкой IP-адреса',
    'ip-ban.settings.timeUnit' => 'секунд',
    'ip-ban.settings.invalidInteger' => 'Недопустимое значение. Введите положительное целое число.',

    'ip-ban.trusted-ip.ipAddress' => 'IP-адрес',
    'ip-ban.trusted-ip.hintIpAddress' => 'IP-адрес, маска CIDR или имя хоста DNS.',
    'ip-ban.trusted-ip.ipAddressDescription' => 'Описание',
    'ip-ban.trusted-ip.hintIpAddressDescription' => 'Пояснение, почему IP-адрес был добавлен в список доверенных.',

    'login-info.hint' => 'Здесь вы можете изменить имя пользователя и пароль клиента для входа в Панель клиента.',
    'login-info.resellerHint' => 'Здесь вы можете изменить имя пользователя и/или пароль, которые данный реселлер использует для входа в Plesk.',
    'login-info.myProfileHint' => 'Здесь вы можете изменить свой пароль для входа в Plesk.',

    'firewall-rule.titleEdit' => 'Редактирование правила брандмауэра',
    'firewall-rule.titleNew' => 'Добавление правила',
    'firewall-rule.isEnabled' => 'Включить правило',
    'firewall-rule.name' => 'Имя правила',
    'firewall-rule.profiles' => 'Профили',
    'firewall-rule.profilesHint' => 'Нужно выбрать хотя бы один профиль.',
    'firewall-rule.profileDomain' => 'Домен',
    'firewall-rule.profilePrivate' => 'Частный',
    'firewall-rule.profilePublic' => 'Общий',
    'firewall-rule.action' => 'Действие',
    'firewall-rule.actionAllow' => 'Разрешить',
    'firewall-rule.actionBlock' => 'Запретить',
    'firewall-rule.port' => 'Разрешить подключения к следующему порту или диапазону портов',
    'firewall-rule.portHint' => 'Пример: 1000 или 1000-1051',
    'firewall-rule.protocolTcp' => 'Протокол TCP',
    'firewall-rule.protocolUdp' => 'Протокол UDP',
    'firewall-rule.remoteAddresses' => 'Удаленные адреса',
    'firewall-rule.remoteAddressesHint' => 'Пример: 192.168.0.1 или 192.168.0.0/16',
    'firewall-rule.newRule' => 'Создать правило',
    'firewall-rule.successNew' => 'Добавлено правило брандмауэра.',
    'firewall-rule.successEdit' => 'Правило брандмауэра обновлено.',

    'mail.lists-server-settings.email' => "Адрес электронной почты администратора рассылки",
    'mail.lists-server-settings.emptyEmail' => 'Пожалуйста, укажите адрес электронной почты.',
    'mail.lists-server-settings.newPassword' => 'Новый пароль',
    'mail.lists-server-settings.emptyPassword' => 'Пожалуйста, укажите пароль.',
    'mail.lists-server-settings.passwordConfirmation' => 'Подтверждение пароля',
    'mail.lists-server-settings.mailingListSoftwareWasConfigured' => 'Программа почтовых рассылок настроена.',

    'mail.outgoing-messages.hint' => 'Здесь вы можете настроить ограничение исходящих сообщений для почтового ящика.',
    'mail.outgoing-messages.mailBoxOutgoingMessages' => 'Максимальное количество исходящих сообщений',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainDefault' => 'По умолчанию (%%domainOutgoingMessages%% сообщений в час)',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecific' => 'Отдельное значение',
    'mail.outgoing-messages.mailBoxOutgoingMessagesDomainSpecificHint' => 'сообщений в час',

    'mail-gate-settings.host' => 'Имя хоста или IP адрес',
    'mail-gate-settings.port' => 'Порт',
    'mail-gate-settings.login' => 'Имя пользователя',
    'mail-gate-settings.password' => 'Пароль',
    'mail-gate-settings.encryption' => 'Сервер SMTP требует зашифрованное соединение',
    'mail-gate-settings.allowUsers' => 'Разрешить скриптам пользователей отправлять почту через этот сервер SMTP (используя указанное имя пользователя и пароль)',
    'mail-gate-settings.useDefaultSettings' => 'Использовать почтовый сервер, установленный в Plesk, и почтового пользователя по умолчанию, созданного Plesk',

    'mail-gate.hint' => 'Здесь вы можете указать сервер SMTP, который следует использовать, если почтовый сервер Plesk не установлен или ему запрещено отправлять почту. Этот сервер будет выступать как SMTP-релей для отправки сообщений от Plesk и пользовательских скриптов.',
    'mail-gate.enableMailGate' => 'Разрешить Plesk отправлять уведомления через этот сервер SMTP',
    'mail-gate.notifications' => 'Отправка уведомлений через внешний сервер SMTP',
    'mail-gate.smtpSettings' => 'Настройки внешнего сервера SMTP',

    'optimization-settings.apacheModulesSection' => 'Модули Apache',
    'optimization-settings.apacheSettingsSection' => 'Общие настройки',
    'optimization-settings.additionalPageHint' => 'Включение/выключение модулей следует выполнять, только если вы полностью осознаете связанные с этим последствия. Учтите, что некоторые изменения могут снизить производительность Apache или даже привести к его неработоспособности. ',
    'optimization-settings.pageHint' => 'На этой странице вы можете оптимизировать работу Plesk, отключив неиспользуемые модули Apache. Это поможет улучшить использование памяти и увеличить количество обслуживаемых клиентов. Пожалуйста, помните, что некоторые модули взаимосвязаны и могут быть отключены/включены только одновременно друг с другом.',
    'optimization-settings.advancedUsersOnlyWarning' => 'Эта функция предназначена только для опытных пользователей. ',
    'optimization-settings.apacheRestartInterval' => 'Интервал перезапуска Apache (в секундах)',
    'optimization-settings.apacheRestartIntervalHint' => 'Это интервал, с которым Plesk будет проверять наличие изменений в настройках доменов и субдоменов. В случае обнаружения изменений, требующих перезапуска веб-сервера, будет происходить перезапуск Apache.',
    'optimization-settings.gracefulRestart' => 'Мягкий перезапуск Apache',
    'optimization-settings.gracefulRestartHint' => 'Выберите эту опцию, если хотите избежать простоя всех сайтов на сервере при каждом изменении настроек хостинга.',
    'optimization-settings.pipedLog' => 'Перенаправление журналов',
    'optimization-settings.mpmMode' => 'Режим MPM',
    'optimization-settings.moduleDeprecated' => '(Не рекомендуется)',

    'personal-info.contactInfoSection' => 'Контакты',
    'personal-info.hint' => 'Здесь вы можете изменить контактную информацию пользователя.',
    'personal-info.hintMyProfile' => 'Здесь вы можете изменить свою контактную информацию.',

    'php-handler.extension.title' => 'Установить пакет PECL',
    'php-handler.extension.description' => "Вы можете установить бета-версию расширения, уточнив дополнительные параметры, включающие название пакета — например, \"msgpack-beta\".",
    'php-handler.extension.name' => 'Название пакета',

    'php-handler.ini.formHint' => 'Этот файл php.ini используется только этим обработчиком.',
    'php-handler.ini.formHintSharedIni' => 'Этот файл php.ini используется также следующими обработчиками PHP: %%handlers%%. Настройки действуют для всех сайтов, использующих эти обработчики.',
    'php-handler.ini.incorrectTextForIniFile' => "Указанные настройки не верны и их нельзя сохранить в файле php.ini. Ошибка: %%message%%.",

    'plan-item-custom.planItemName' => 'Название услуги',
    'plan-item-custom.buttonLabel' => 'Это имя также будет использоваться как название персональной кнопки.',
    'plan-item-custom.planItemDescription' => 'Описание услуги',
    'plan-item-custom.buttonTooltip' => 'Этоn текст также будет использоваться как всплывающая подсказка для персональной кнопки.',
    'plan-item-custom.url' => 'URL персональной кнопки',
    'plan-item-custom.backgroundImage' => 'Фоновое изображение для персональной кнопки',
    'plan-item-custom.emptyItemName' => 'Пожалуйста, укажите название услуги.',
    'plan-item-custom.emptyItemDescription' => 'Пожалуйста, укажите текст для всплывающей подсказки.',
    'plan-item-custom.emptyUrl' => 'Пожалуйста, укажите URL.',
    'plan-item-custom.longItemName' => 'Слишком длинное название услуги. Максимальная длина — %max% символов.',
    'plan-item-custom.longItemDescription' => 'Слишком длинный текст. Максимальная длина — %max% символов.',
    'plan-item-custom.longUrl' => 'Слишком длинный URL. Максимальная длина — %max% символов.',
    'plan-item-custom.useCustomButton' => 'Использовать персональную кнопку для услуги',
    'plan-item-custom.useCustomButtonHint' => 'Поместить персональную кнопку на домашнюю страницу пользователя и страницы сайтов.',
    'plan-item-custom.openCustomButtonInSameWindow' => 'Открывать ссылку в Plesk',
    'plan-item-custom.openCustomButtonInSameWindowDescription' => 'Укажите, где следует открывать ссылку: на странице Plesk или в новом окне браузера.',
    'plan-item-custom.openCustomButtonWithoutFrame' => 'Не использовать фреймы',
    'plan-item-custom.openCustomButtonWithoutFrameDescription' => 'Если персональная кнопка ведет на какое-либо расширение Plesk или приложение в Панели клиента, вы можете указать, как его следует показывать: во фрейме или как часть интерфейса Plesk.',
    'plan-item-custom.includeDomId' => 'Включить ID подписки',
    'plan-item-custom.includeDomIdDescription' => '&dom_id=<dom_id>',
    'plan-item-custom.includeDomName' => 'Включить основное имя домена',
    'plan-item-custom.includeDomNameDescription' => '&dom_name=<dom_name>',
    'plan-item-custom.includeFtpUser' => 'Включить имя пользователя FTP',
    'plan-item-custom.includeFtpUserDescription' => '&ftp_user=<ftp_user>',
    'plan-item-custom.includeFtpPass' => 'Включить пароль FTP',
    'plan-item-custom.includeFtpPassDescription' => '&ftp_pass=<ftp_pass>',
    'plan-item-custom.includeClId' => 'Включить ID клиента',
    'plan-item-custom.includeClIdDescription' => '&cl_id=<cl_id>',
    'plan-item-custom.includeCname' => "Включить название компании клиента",
    'plan-item-custom.includeCnameDescription' => '&cname=<cname>',
    'plan-item-custom.includePname' => "Включить контактное имя клиента",
    'plan-item-custom.includePnameDescription' => '&pname=<pname>',
    'plan-item-custom.includeEmail' => "Включить адрес электронной почты клиента",
    'plan-item-custom.includeEmailDescription' => '&email=<email>',
    'plan-item-custom.fileNotUploaded' => 'Файл не может быть загружен.',

    'preview-domain-settings.previewType' => 'Выбрать способ просмотра сайтов',
    'preview-domain-settings.previewQuick' => 'Быстрый просмотр по умолчанию',
    'preview-domain-settings.previewDisabled' => 'Отключить быстрый просмотр',
    'preview-domain-settings.previewQuickDescription' => 'Рекомендуемая опция, которая работает без дополнительной настройки.',
    'preview-domain-settings.previewZoneTypeInternal' => 'Быстрый предпросмотр на домене из Plesk',
    'preview-domain-settings.previewZoneDomainIdDescription' => 'Выберите для предпросмотра один из своих сайтов, зарегистрированных в Plesk.',
    'preview-domain-settings.previewZoneDomainCreate' => 'Чтобы использовать эту функцию, %%link%% хотя бы один домен.',
    'preview-domain-settings.subscriptionCreateLink' => 'создайте',
    'preview-domain-settings.previewZoneTypeExternal' => 'Быстрый просмотр на внешнем домене',
    'preview-domain-settings.previewZoneDomainNameDescription' => 'Укажите внешнее имя домена (зону DNS). Если вы используете эту опцию, добавьте следующую A-запись DNS в зону внешнего домена: *.<Plesk_IP>.external.dom. <Plesk_IP> — это IP-адрес сервера Plesk, в котором вместо точек (.) для IPv4 и двоеточий (:) для IPv6 подставляются дефисы (-). Например, *.192-0-2-12.external.dom. Если Plesk имеет несколько IP-адресов, нужно добавить отдельную запись для каждого из них.',
    'preview-domain-settings.sitePreviewProtection' => 'Требовать авторизацию',
    'preview-domain-settings.sitePreviewProtectionDescription' => 'Требовать логин и пароль пользователя FTP для доступа к предпросмотру.',
    'preview-domain-settings.nginxNotInstalled' => 'Быстрый просмотр по умолчанию недоступен, потому что не установлен веб-сервер nginx.',
    'preview-domain-settings.nginxDisabled' => 'Быстрый просмотр по умолчанию недоступен, потому что отключен веб-сервер nginx.',

    'reseller-preferences.settingsSection' => 'Настройки',
    'reseller-preferences.multiLogin' => 'Разрешить несколько сеансов',
    'reseller-preferences.language' => 'Язык интерфейса',
    'reseller-preferences.interfaceView' => 'Режим интерфейса',
    'reseller-preferences.serviceProviderView' => 'Service Provider',
    'reseller-preferences.serviceProviderViewHint' => 'Этот способ просмотра предназначен для системных администраторов, предоставляющих и продающих услуги веб-хостинга клиентам с тарифными планами.',
    'reseller-preferences.powerUserView' => 'Power User',
    'reseller-preferences.powerUserViewHint' => 'Этот способ просмотра предназначен для управления веб-сайтами, их файлами, базами данных, учетными записями электронной почты, веб-приложениями и прочими службами.',

    'reseller.hint' => 'Здесь вы можете подписать нового реселлера на ваши услуги хостинга.',
    'reseller.contactInfoSection' => 'Контактная информация',
    'reseller.contactInfoSectionHint' => 'Введите контактные данные реселлера.',
    'reseller.accessToPanelSection' => 'Доступ к Plesk',
    'reseller.accessToPanelSectionHint' => 'Учетные данные, которые реселлер будет использовать для доступа в Plesk и управления своими услугами.',
    'reseller.subscription' => 'Подписка',
    'reseller.subscriptionSectionHint' => 'Выберите тарифный план для этого реселлера.',
    'reseller.servicePlan' => 'Тарифный план',
    'reseller.none' => 'нет',
    'reseller.customizeSubscription' => 'После создания реселлера перейти к настройке параметров подписки. Учтите, что это приведет к блокировке синхронизации подписки.',
    'reseller.subscriptionNotSynchronized' => 'Не удалось синхронизировать подписку с тарифным планом. Следующие настройки подписки конфликтуют с тарифным планом: %%problems%%.',

    'security-policy.encryptionSection' => 'Режим повышенной безопасности',
    'security-policy.encryptionSectionHint' => 'Режим повышенной безопасности обеспечивает усиленную защиту конфиденциальных данных в Plesk. В этом режиме Plesk использует ряд механизмов защиты, которые абсолютно прозрачны для пользователей. Мы рекомендуем вам включить этот режим для усиления безопасности Plesk.',
    'security-policy.encryptionEnable' => 'Режим повышенной безопасности',
    'security-policy.securePassword' => 'Режим повышенной безопасности',
    'security-policy.strengthSection' => 'Надежность паролей',
    'security-policy.strengthSectionHint' => 'Большинство паролей, которые пользователи могут устанавливать или изменять в Plesk, проверяются на соответствие минимальным требованиям к надежности паролей, установленным здесь. Надежные пароли имеют длину не менее 9–12 символов и включают цифры, буквы верхнего и нижнего регистра, специальные символы и не включают словарные слова. Их сложнее угадать, но и запомнить тоже. <a href="%%link%%" target="_blank">Подробнее о надежности пароля</a>.',
    'security-policy.passwordStrength' => 'Минимальная надежность паролей',
    'security-policy.secureFtpSection' => 'Безопасность FTP-соединений',
    'security-policy.ftpOverSsl' => 'Политика использования FTPS',
    'security-policy.ftpOverSslHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS. Здесь вы можете указать разрешенные виды соединений.',
    'security-policy.ftpOverSslWithCustomOptionHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS. Здесь вы можете указать разрешенные виды соединений. Выбранный вариант будет применен ко всем IP-адресам на сервере. Чтобы установить индивидуальные настройки для отдельных IP-адресов, выберите соответствующий вариант, а затем внесите необходимые изменения в FTPS-политику на странице "Инструменты и настройки" > "IP-адреса".',
    'security-policy.ftpOverSslCustomHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS.',
    'security-policy.ftpOverSslCustomDisabledHint' => 'FTPS позволяет защитить обмен данными между FTP-сервером и внешними FTP-клиентами с помощью протокола SSL/TLS. Если вы хотите настроить FTPS отдельно для каждого IP-адреса, сначала включите опцию "Использовать отдельную политику FTPS для каждого IP-адреса" в разделе "Инструменты и настройки" > "Политика безопасности" > "Безопасность FTP-соединений".',
    'security-policy.ftpOverSslOptionRequired' => 'Разрешить только безопасные соединения (FTPS)',
    'security-policy.ftpOverSslOptionEnabled' => 'Разрешить и безопасные соединения (FTPS), и небезопасные (FTP)',
    'security-policy.ftpOverSslOptionDisabled' => 'Разрешить только небезопасные соединения (FTP). Не использовать FTPS',
    'security-policy.ftpOverSslOptionCustom' => 'Использовать отдельную политику FTPS для каждого IP-адреса',
    'security-policy.prohibitWebConfigHandlersSection' => 'Политика пользовательских обработчиков',
    'security-policy.prohibitWebConfigHandlersSectionHint' => 'Используйте эту опцию, чтобы запретить клиентам переопределять определенные на уровне сервера обработчики IIS через файл web.config.',
    'security-policy.prohibitWebConfigHandlers' => 'Отключить возможность обходить обработчики через web.config',

    'server-mail-antivirus.used' => 'Используемый антивирус',
    'server-mail-antivirus.policy' => 'Использовать серверные настройки',
    'server-mail-antivirus.policyOff' => 'Сканирование отключено',
    'server-mail-antivirus.policyAny' => 'Сканировать исходящую и входящую почту',
    'server-mail-antivirus.policyFrom' => 'Сканировать только исходящую почту',
    'server-mail-antivirus.policyTo' => 'Сканировать только входящую почту',
    'server-mail-antivirus.allowPersonalSettings' => 'Разрешить персональные настройки',
    'server-mail-antivirus.allowPersonalSettingsDesc' => 'Разрешить переопределение глобальных настроек для каждого почтового адреса',
    'server-mail-antivirus.incoming' => 'для входящей почты',
    'server-mail-antivirus.outgoing' => 'для исходящей почты',
    'server-mail-antivirus.success' => 'Настройки антивируса изменены.',

    'server-mail-black-list.title' => 'Добавить домен в черный список',
    'server-mail-black-list.domainName' => 'Имя домена',
    'server-mail-black-list.emailAddress' => 'Почтовые адреса',
    'server-mail-black-list.emailAddressHint' => 'Не допускается использование не-ASCII символов в адресе до знака "@". В адресах можно использовать подстановочные знаки "*" и "?" (например, *@domain.com, user?@*.com). Не допускается использование подстановочных знаков в не-ASCII метках доменов.',
    'server-mail-black-list.action' => 'Что делать с почтой, удовлетворяющей критерию:',
    'server-mail-black-list.actionDelete' => 'Удалять с сервера',
    'server-mail-black-list.actionSpam' => 'Помечать как спам',
    'server-mail-black-list.success' => 'Домен был добавлен в черный список.',

    'server-mail-white-list.title' => 'Добавить сеть в белый список',
    'server-mail-white-list.descEmailAddress' => 'Адреса электронной почты, указанные здесь, не будут распознаваться SpamAssassin как спам.',
    'server-mail-white-list.descIpAddress' => 'Указанные здесь записи IP будут добавлены в исключения почтового сервера.',
    'server-mail-white-list.ipAddress' => 'IP-адрес/маска',
    'server-mail-white-list.ipAddressHint' => 'IP-адрес может содержать подстановочный знак или маску CIDR.',
    'server-mail-white-list.emailAddress' => 'Почтовые адреса',
    'server-mail-white-list.emailAddressHint' => 'Не допускается использование не-ASCII символов в адресе до знака "@". В адресах можно использовать подстановочные знаки "*" и "?" (например, *@domain.com, user?@*.com). Не допускается использование подстановочных знаков в не-ASCII метках доменов.',
    'server-mail-white-list.emailAddressOrIp' => 'Электронная почта или IP-адреса',
    'server-mail-white-list.wildcardPattern' => 'IP-адреса могут содержать подстановочные знаки (например, 123.123.*.123).',
    'server-mail-white-list.cidrPattern' => 'IP-адреса могут содержать маски CIDR (например, 10.0.0.0/8).',
    'server-mail-white-list.success' => 'Сеть была добавлена в белый список.',

    'server-mail-settings.general.title' => 'Общие параметры',
    'server-mail-settings.general.mailUiEnabled' => 'Включить функции управления почтой в Plesk',
    'server-mail-settings.general.serverName' => 'Установленный почтовый сервер',
    'server-mail-settings.general.changeServerName' => 'установить другой почтовый сервер',
    'server-mail-settings.general.imapServerName' => 'Установленный сервер IMAP/POP3',
    'server-mail-settings.general.changeImapServerName' => 'установить другой сервер IMAP/POP3',
    'server-mail-settings.general.changeServerHint' => 'Вы можете %%serverChangeLink%%',
    'server-mail-settings.general.maxMessageSize' => 'Максимальный размер сообщения',
    'server-mail-settings.general.kbytes' => 'Кбайт',
    'server-mail-settings.general.maxConnections' => 'Максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS)',
    'server-mail-settings.general.maxConnectionsHintCourier-IMAP' => 'Максимальное количество запущенных серверов (IMAP или POP3).',
    'server-mail-settings.general.maxConnectionsHintDovecot' => 'Максимальное количество одновременно подключенных пользователей почты.',
    'server-mail-settings.general.maxConnectionsPerIpCourier-IMAP' => 'Максимальное количество подключений на один IP-адрес',
    'server-mail-settings.general.maxConnectionsPerIpDovecot' => 'Максимальное количество подключений на один IP-адрес пользователя',
    'server-mail-settings.general.maxConnectionsPerIpHintCourier-IMAP' => 'Максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS), разрешенное с одного и того же IP-адреса.',
    'server-mail-settings.general.maxConnectionsPerIpHintDovecot' => 'Максимальное количество подключений (IMAP, POP3, IMAP over SSL/TLS или POP3 over SSL/TLS), которое может установить один пользователь почты с каждого IP-адреса.',
    'server-mail-settings.general.messageSubmission' => 'Включите службу SMTP на порту 587',
    'server-mail-settings.general.messageSubmissionOnAllIp' => 'Включить службу SMTP на порту 587 на всех IP-адресах',
    'server-mail-settings.general.messageSubmissionBindTo' => 'Вкл.',
    'server-mail-settings.general.messageSubmissionAllIpAddresses' => 'всех IP-адресах',
    'server-mail-settings.general.outgoingEmailMode' => 'Режим отправки сообщений',
    'server-mail-settings.general.outgoingEmailModeDomainIp' => 'Отправлять с IP-адресов доменов',
    'server-mail-settings.general.outgoingEmailModeDomainName' => 'Отправлять с IP-адресов доменов и использовать имена доменов в приветствии SMTP-сервера',
    'server-mail-settings.general.outgoingEmailModeExplicitIp' => 'Отправлять с указанных IP-адресов',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV4' => 'IPv4',
    'server-mail-settings.general.outgoingEmailModeExplicitIpV6' => 'IPv6',
    'server-mail-settings.general.outgoingEmailModeExplicitIpNone' => 'Нет',
    'server-mail-settings.general.subaddressing' => 'Включить почтовую субадресацию',
    'server-mail-settings.general.subaddressingHint' => 'Эта опция включает возможность настройки адресов электронной почты %%verpStyleLink%% для списков рассылки',
    'server-mail-settings.general.verpStyleLink' => 'VERP',
    'server-mail-settings.general.mboxQuotaWarning' => 'Включить предупреждение о квоте почтового ящика',
    'server-mail-settings.general.mboxQuotaWarningHint' => 'Отправлять предупреждение пользователям почты, когда использование квоты почтового ящика превышает 95%',
    'server-mail-settings.general.mboxQuotaWarningChange' => 'Изменить предупреждение о квоте почтового ящика по умолчанию',
    'server-mail-settings.general.fixSender' => 'Исправлять некорректные адреса отправителей для исходящей почты',
    'server-mail-settings.general.fixSenderHint' => 'Эта опция позволяет автоматически задавать действительные почтовые заголовки и адреса отправителей конверта для исходящей почты, чтобы снизить риск попадания писем в спам',
    'server-mail-settings.general.maxMessageSizeHint' => 'Для писем с прикрепляемыми файлами значение должно быть на 35–40% выше, чем размер прикрепляемых файлов. %%kbLink%%.',
    'server-mail-settings.general.maxMessageSizeHintLink' => 'Смотрите дополнительную информацию в статье базы знаний',

    'server-mail-settings.autodiscover.title' => 'Автообнаружение почты',
    'server-mail-settings.autodiscover.description' => 'Читайте о том, как это работает, в %%link%%',
    'server-mail-settings.autodiscover.link' => 'базе знаний',
    'server-mail-settings.autodiscover.enabled' => 'Включить автообнаружение почты',
    'server-mail-settings.autodiscover.enabledHint' => 'Включение этой функции приведет к изменению настроек всех доменов, на которых включено автообнаружение',
    'server-mail-settings.autodiscover.customServer' => 'Персональное имя домена',
    'server-mail-settings.autodiscover.customServerHint' => 'Укажите персональное имя домена, которое будет использоваться как сервер входящих и исходящих сообщений для конфигурации автообнаружения почты.',
    'server-mail-settings.autodiscover.customServerCertHint' => 'Примечание: Домен должен быть защищен действительным SSL/TLS-сертификатом.',
    'server-mail-settings.autodiscover.reconfigureDns' => 'Изменить DNS-записи автообнаружения',
    'server-mail-settings.autodiscover.reconfigureDnsHint' => 'Включение этой функции приведет к изменению DNS-записей автообнаружения всех доменов, на которых включено автообнаружение',

    'server-mail-settings.relay.title' => 'Параметры ретрансляции',
    'server-mail-settings.relay.type' => "Ретрансляция почты",
    'server-mail-settings.relay.open' => "Открытая",
    'server-mail-settings.relay.openSpamWarning' => "Установка открытой ретрансляции почты делает ваш почтовый сервер уязвимым для спама.",
    'server-mail-settings.relay.openSpamChange' => "Эту настройку следует использовать только для временного тестирования почтового сервера или в случаях, когда ваш сервер Plesk находится во внутренней сети без подключения к Интернету.",
    'server-mail-settings.relay.closed' => "Закрытая",
    'server-mail-settings.relay.auth' => "Требуется авторизация: ",
    'server-mail-settings.relay.notSupported' => "не поддерживается почтовым сервером",
    'server-mail-settings.relay.change' => 'Чтобы включить отправку уведомлений Plesk при закрытой ретрансляции, вы можете %%changeLink%%',
    'server-mail-settings.relay.changeLink' => 'изменить настройки SMTP',
    'server-mail-settings.relay.pop3' => "POP3 перед SMTP",
    'server-mail-settings.relay.lockTime' => "время блокирования",
    'server-mail-settings.relay.min' => "мин",
    'server-mail-settings.relay.smtp' => "SMTP",
    'server-mail-settings.relay.noRelayNetworks' => 'Не ограничивать ретрансляцию со следующих сетей:',
    'server-mail-settings.relay.noRelayNetworksHint' => "IP-адрес/маска",

    'server-mail-settings.outgoing.title' => 'Ограничения на исходящую почту',
    'server-mail-settings.outgoing.description' => 'Эти ограничения используются по умолчанию. Их можно перезаписать для конкретного тарифного плана или подписки. Эти ограничения не являются общими для всего сервера, а служат шаблоном для планов и подписок, для которых индивидуальные ограничения не установлены. Имейте в виду, что включение ограничений на почтовые сообщения может отрицательно сказаться на быстродействии почтового сервера. %%link%%',
    'server-mail-settings.outgoing.learnMore' => 'Читать больше об ограничении исходящей почты',
    'server-mail-settings.outgoing.enabled' => 'Включить ограничения на исходящие почтовые сообщения',
    'server-mail-settings.outgoing.countRecipients' => 'Учитывать количество получателей, а не сообщений',
    'server-mail-settings.outgoing.countRecipientsHint' => 'Включает режим, в котором при ограничении исходящей почты и подсчете статистики учитывается количество получателей, а не сообщений. Например, одно сообщение, отправленное 10 получателям, будет учитываться как 10 сообщений.',
    'server-mail-settings.outgoing.mailboxLimit' => 'Стандартное ограничение на исходящие сообщения для одного почтового ящика (в час)',
    'server-mail-settings.outgoing.domainLimit' => 'Стандартное ограничение на исходящие сообщения для одного домена (в час)',
    'server-mail-settings.outgoing.subscriptionLimit' => 'Стандартное ограничение на исходящие сообщения для одной подписки (в час)',
    'server-mail-settings.outgoing.unlimited' => 'Без ограничений',
    'server-mail-settings.outgoing.sendmail' => 'Разрешить пользователям и скриптам использовать Sendmail',
    'server-mail-settings.outgoing.sendmailHint' => 'Это позволит скриптам и пользователям отправлять сообщения (от лица системного пользователя), даже если превышены ограничения, установленные для почтового ящика и домена. Максимальное количество сообщений, которое можно отправить через Sendmail, определяется на уровне подписки. Этот параметр не является глобальным для всего сервера, а просто используется как установка по умолчанию для тарифных планов и подписок.',
    'server-mail-settings.outgoing.reportPeriod' => 'Показать отчеты на основе статистики за период',
    'server-mail-settings.outgoing.reportPeriodHint' => 'Период, за который следует создавать отчеты о попытках превышения ограничений и показывать соответствующую сводку на домашней странице.',
    'server-mail-settings.outgoing.notificationPeriod' => 'Период отправки уведомлений',
    'server-mail-settings.outgoing.notificationPeriodHint' => 'Период, за который следует отправлять почтовые уведомления со статистикой о попытках превышения ограничений.',
    'server-mail-settings.outgoing.periodP1D' => '1 день',
    'server-mail-settings.outgoing.periodP1W' => '1 неделя',
    'server-mail-settings.outgoing.periodP2W' => '2 недели',
    'server-mail-settings.outgoing.periodP1M' => '1 месяц',
    'server-mail-settings.outgoing.periodPT15M' => '15 минут',
    'server-mail-settings.outgoing.periodPT1H' => '1 час',
    'server-mail-settings.outgoing.periodPT6H' => '6 часов',
    'server-mail-settings.outgoing.periodPT12H' => '12 часов',
    'server-mail-settings.outgoing.whiteListNotEmpty' => 'Ограничения на исходящую почту не будут работать для отправителей, чьи IP-адреса находятся в белом списке почтового сервера. Например, если белый список содержит запись localhost (127.0.0.0 / 8, ::1 / 128), то вся почта с локального сервера будет успешно отправляться независимо от ограничений. Отправители могут использовать локальные IP-адреса (сайты и пользовательские скрипты на локальном сервере) или внешние (клиенты, которые отправляют почту из почтовых клиентов, установленных на их компьютерах или мобильных устройствах). Чтобы ограничения работали для всех отправителей (и локальных, и внешних), удалите из белого списка все IP-адреса и сети. Учтите, что удаление из белого списка записи localhost (127.0.0.0 / 8, ::1 / 128) может нарушить работу сайтов и скриптов, отправляющих почту с этого сервера. Подробнее об ограничении исходящей почты смотрите в Руководстве администратора, раздел Защита от исходящего спама.',
    'server-mail-settings.outgoing.relayIsOpen' => 'Почтовый релей открыт: ограничения на исходящую почту не будут работать.',
    'server-mail-settings.outgoing.domainLimitExceedsSubscriptionLimit' => 'Ограничение на исходящую почту для домена (%%value%%) не может быть больше ограничения для подписки (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsDomainLimit' => 'Ограничение на исходящую почту для почтового адреса (%%value%%) не может быть больше ограничения для домена (%%highLevelLimitValue%%).',
    'server-mail-settings.outgoing.mailboxLimitExceedsSubscriptionLimit' => 'Ограничение на исходящую почту для почтового адреса (%%value%%) не может быть больше ограничения для подписки (%%highLevelLimitValue%%).',

    'server-mail-settings.mailman.title' => 'Настройки Mailman',
    'server-mail-settings.mailman.secureLinks' => 'Использовать безопасные ссылки в списках рассылки',
    'server-mail-settings.mailman.secureLinksHint' => 'Включить или отключить создание безопасных (HTTPS) ссылок в списках рассылки.',
    'server-mail-settings.mailman.noLocalhost' => 'Для использования списков рассылки необходимо, чтобы в белом списке почтового сервера присутствовала запись localhost (127.0.0.0/8, ::1/128). Однако для использования контроля исходящей почты записи localhost в белом списке быть не должно. В качестве компромисса, если вы активировали контроль исходящей почты, можно использовать перенаправление почты вместо рассылок.',
    'server-mail-settings.mailman.noLocalhostIpv4' => 'Для использования списков рассылки необходимо, чтобы в белом списке почтового сервера присутствовала запись localhost. Однако для использования контроля исходящей почты записи localhost в белом списке быть не должно. В качестве компромисса, если вы активировали контроль исходящей почты, можно использовать перенаправление почты вместо рассылок. Обратите внимание, что сейчас в белом списке нет IPv4-адресов localhost (127.0.0.0/8), поэтому для IPv4-адресов будет работать контроль исходящей почты.',
    'server-mail-settings.mailman.noLocalhostIpv6' => 'Для использования списков рассылки необходимо, чтобы в белом списке почтового сервера присутствовала запись localhost. Однако для использования контроля исходящей почты записи localhost в белом списке быть не должно. В качестве компромисса, если вы активировали контроль исходящей почты, можно использовать перенаправление почты вместо рассылок. Обратите внимание, что сейчас в белом списке нет IPv6-адресов localhost (::1/128), поэтому для IPv6-адресов будет работать контроль исходящей почты.',

    'server-mail-settings.spam-filter.dmarc' => 'DMARC',
    'server-mail-settings.spam-filter.dmarcEnabled' => 'Включить проверку DMARC для входящей почты',
    'server-mail-settings.spam-filter.dmarcHint' => 'Эта опция доступна, когда DKIM и SPF включены для входящей почты.',
    'server-mail-settings.spam-filter.dkim' => 'Защита от спама DKIM',
    'server-mail-settings.spam-filter.singOutgoing' => 'Разрешить подпись исходящей почты',
    'server-mail-settings.spam-filter.verifyIncoming' => 'Проверять входящую почту',
    'server-mail-settings.spam-filter.verifyIncomingHint' => 'Эту опцию нельзя отключить, когда проверка DMARC включена для входящей почты.',
    'server-mail-settings.spam-filter.spf' => 'Защита от спама на основе политик SPF',
    'server-mail-settings.spam-filter.spfEnabled' => 'Включить защиту от спама на основе политик SPF для проверки входящих сообщений',
    'server-mail-settings.spam-filter.spfEnabledHint' => 'Эту опцию нельзя отключить, когда проверка DMARC включена для входящей почты.',
    'server-mail-settings.spam-filter.ignoreErrors' => 'Продолжать проверку SPF при проблемах с поиском в DNS',
    'server-mail-settings.spam-filter.ignoreErrorsHint' => 'Сначала SPF выполняет поиск в DNS. Эта опция позволяет продолжать проверку, даже если поиск в DNS закончился неудачей. Эта опция сбрасывается, если она не играет никакой роли при текущем режиме проверки.',
    'server-mail-settings.spam-filter.behavior' => 'Режим проверки SPF',
    'server-mail-settings.spam-filter.behaviorHint' => 'Затем SPF применяет предположения и локальные правила. В зависимости от выбранного режима и результатов проверки сообщение может быть отклонено.',
    'server-mail-settings.spam-filter.behaviorCreateHeadersNoBlock' => 'Создавать только заголовки Received-SPF, не блокировать',
    'server-mail-settings.spam-filter.behaviorUseTmpErrors' => 'Использовать временные сообщения об ошибках при проблемах с поиском в DNS',
    'server-mail-settings.spam-filter.behaviorRejectIfFail' => 'Отклонять почтовые сообщения, когда SPF возвращает результат "fail"',
    'server-mail-settings.spam-filter.behaviorRejectIfSoftfail' => 'Отклонять почтовые сообщения, когда SPF возвращает результат "softfail"',
    'server-mail-settings.spam-filter.behaviorRejectIfNeutral' => 'Отклонять почтовые сообщения, когда SPF возвращает результат "neutral"',
    'server-mail-settings.spam-filter.behaviorRejectIfNoPass' => 'Отклонять почтовые сообщения, когда SPF не возвращает результат "pass"',
    'server-mail-settings.spam-filter.localRules' => 'Локальные правила SPF',
    'server-mail-settings.spam-filter.guessRules' => 'Предположения SPF',
    'server-mail-settings.spam-filter.explanationText' => 'Поясняющий текст SPF',
    'server-mail-settings.spam-filter.rbl' => "Защита от спама на основе черных списков DNS",
    'server-mail-settings.spam-filter.rblEnabled' => "Включить защиту от спама на основе черных списков DNS",
    'server-mail-settings.spam-filter.rblServer' => "Зоны DNS для службы DNSBL",
    'server-mail-settings.spam-filter.rblServerHint' => "В качестве разделителя используйте точку с запятой, например: 'dnsbl.example.net'",

    'server-mail-settings.auto-reply-headers.title' => 'Дополнительные заголовки автоответчика',
    'server-mail-settings.auto-reply-headers.description' => 'Настройте дополнительные заголовки для сообщений автоответчика, отправляемых с сервера Plesk.',
    'server-mail-settings.auto-reply-headers.extra' => 'Дополнительные заголовки',

    'server-mail-settings.pop3-names.title' => "Форматы почтовых имен для учетных записей POP3/IMAP",
    'server-mail-settings.pop3-names.disabled' => "Для почтовых учетных записей POP3/IMAP разрешено использование только полных имен",
    'server-mail-settings.pop3-names.enabled' => "Для почтовых учетных записей POP3/IMAP разрешено использование как кратких (webmaster), так и полных (webmaster@domain.com) имен.",

    'server-mail-settings.success' => 'Настройки почтового сервера были изменены.',

    'server-mail-spam-filter.general' => 'Общие',
    'server-mail-spam-filter.isEnabled' => 'Включить антиспам SpamAssassin для всего сервера',
    'server-mail-spam-filter.notInstalled' => '(SpamAssassin не установлен.)',
    'server-mail-spam-filter.greylistingSpamProtection' => 'Включить антиспам на основе серого списка для всего сервера',
    'server-mail-spam-filter.isUserSettingsEnabled' => 'Применять индивидуальные настройки антиспама',
    'server-mail-spam-filter.isUserSettingsEnabledHint' => "Антиспам отключен: почтовый сервер не поддерживает настройку антиспама на уровне почтовых ящиков.",
    'server-mail-spam-filter.settings' => 'Настройки SpamAssassin',
    'server-mail-spam-filter.maxChildrenTitle' => 'Максимум процессов',
    'server-mail-spam-filter.maxChildrenDescription' => 'Максимальное количество рабочих процессов spamd.',
    'server-mail-spam-filter.requiredHitsTitle' => 'Требуемый балл',
    'server-mail-spam-filter.requiredHitsDescription' => 'Балл, после получения которого письмо считается спамом.',
    'server-mail-spam-filter.maxMailLimit' => 'Не фильтровать, если размер почты превышает это значение',
    'server-mail-spam-filter.maxMailLimitText' => 'предельный размер',
    'server-mail-spam-filter.kbytes' => "Кбайт",
    'server-mail-spam-filter.maxThreadsLimit' => 'Количество потоков, которое может создать антиспам',
    'server-mail-spam-filter.tagTitle' => 'Тег спама',
    'server-mail-spam-filter.tagDescription' => 'Этот текст будет добавляться в начале темы каждого сообщения, сочтенного спамом.',
    'server-mail-spam-filter.alarmMessage' => 'Текст сообщения об обнаружении спама',
    'server-mail-spam-filter.languages' => 'Надежные языки',
    'server-mail-spam-filter.locales' => 'Надежные группы локалей',
    'server-mail-spam-filter.success' => 'Настройки антиспама были изменены.',
    'server-mail-spam-filter.personalSettingsWarning' => 'Персональная настройка антиспама отключена администратором сервера. Указанные ниже настройки антиспама не будут применены',

    'service-plan.admin-plan.subscription_section' => 'Общее',
    'service-plan.admin-plan.tools_section' => 'Инструменты и ресурсы',
    'service-plan.admin-plan.apps_section' => 'Приложения и базы данных',
    'service-plan.admin-plan.panel_section' => 'Plesk',
    'service-plan.admin-plan.appearance_section' => 'Интерфейс Plesk',
    'service-plan.admin-plan.statistics_section' => 'Статистика',
    'service-plan.admin-plan.general_section' => 'Общие',
    'service-plan.admin-plan.mail_section' => 'Почта',
    'service-plan.admin-plan.server_section' => 'Сервер',
    'service-plan.admin-plan.modules_section' => 'Расширения',
    'service-plan.admin-plan.troubleshooting_section' => 'Поддержка и устранение неисправностей',
    'service-plan.admin-plan.simplePanel' => 'Ограниченный режим',
    'service-plan.admin-plan.enabled' => 'Включить Ограниченный режим',
    'service-plan.admin-plan.enabledDescription' => 'Выберите эту опцию, чтобы ограничить набор операций, доступных администратору в Plesk.',
    'service-plan.admin-plan.aliasEnabledDescription' => 'Выберите эту опцию, чтобы ограничить набор операций, доступных дополнительному администратору в Plesk.',

    'service-plan.applications-subscription.useFilterLabel' => 'Предоставлять только выбранные мной приложения',
    'service-plan.applications-subscription.useFilterDescription' => 'Используйте эту опцию, чтобы выбрать приложения, которые должны быть доступны подписчику.',
    'service-plan.applications-subscription.applications' => 'Приложения',
    'service-plan.applications-subscription.isCommercial' => 'Это платное приложение, для которого необходимо купить лицензию.',

    'service-plan.applications.useFilterLabel' => 'Предоставлять только выбранные мной приложения',
    'service-plan.applications.useFilterDescription' => 'Используйте эту опцию, чтобы выбрать приложения, которые должны быть доступны подписчикам.',
    'service-plan.applications.applications' => 'Приложения',
    'service-plan.applications.isCommercial' => 'Это платное приложение, для которого необходимо купить лицензию.',

    'service-plan.dns.dnsZoneType' => 'Зона DNS домена',
    'service-plan.dns.dnsZoneTypeMaster' => 'Первичный',
    'service-plan.dns.dnsZoneTypeSlave' => 'Вторичный',

    'service-plan.extras.groupOtherServices' => 'Другие службы',
    'service-plan.extras.none' => 'Нет',

    'service-plan.hosting.enablePhysicalHosting' => 'Включить хостинг',
    'service-plan.hosting.sectionCoreHosting' => 'Основные параметры',
    'service-plan.hosting.sectionScripting' => 'Скрипты',
    'service-plan.hosting.defaultDatabaseServer' => 'Сервер баз данных по умолчанию',
    'service-plan.hosting.versionCut' => 'версия %%version%%',
    'service-plan.hosting.sectionAdvanced' => 'Дополнительно',
    'service-plan.hosting.phpSettingsHelpLink' => 'Узнайте, как выбрать оптимальные настройки PHP',
    'service-plan.hosting.unpaidWebsiteStatusLabelSubscription' => 'Статус сайтов в случае приостановки этой подписки',
    'service-plan.hosting.unpaidWebsiteStatusLabel' => 'Статус сайтов в приостановленных подписках',
    'service-plan.hosting.unpaidWebsiteStatusDescription' => 'Выбранный статус будет применен ко всем сайтам в подписках данного плана в случае приостановки подписки (например, из-за истечения ее срока).',
    'service-plan.hosting.unpaidWebsiteStatusDescriptionSubscription' => 'Выбранный статус будет применен к сайтам в случае приостановки подписки (например, из-за истечения ее срока).',
    'service-plan.hosting.unpaidWebsiteStatusDisabled' => 'Отключен',
    'service-plan.hosting.unpaidWebsiteStatusDisabledHint' => 'Посетители сайта будут перенаправляться на страницу по умолчанию, определенную в настройках веб-сервера.',
    'service-plan.hosting.unpaidWebsiteStatusSuspended' => 'Приостановлен',
    'service-plan.hosting.unpaidWebsiteStatusSuspendedHint' => 'Посетители сайта будут перенаправляться на специально настроенную страницу ошибки с HTTP-кодом 503.',
    'service-plan.hosting.unpaidWebsiteStatusActive' => 'Активен',
    'service-plan.hosting.unpaidWebsiteStatusActiveHint' => 'Сайт будет по-прежнему доступен в Интернете.',

    'service-plan.ip.sharedIpAddresses' => 'Выделить общие IP-адреса',
    'service-plan.ip.allocateExclusiveIp' => 'Предоставить выделенные IP-адреса',
    'service-plan.ip.allocateExclusiveIpV4' => 'Предоставить выделенные IPv4-адреса',
    'service-plan.ip.allocateExclusiveIpV6' => 'Предоставить выделенные IPv6-адреса',

    'service-plan.mail.mailService' => 'Почтовая служба',
    'service-plan.mail.mailServiceDisabled' => 'Отключено',
    'service-plan.mail.mailServiceDisabledIncoming' => 'Отключено для входящих писем',
    'service-plan.mail.mailServiceDisabledHint' => 'Plesk не будет предоставлять почтовые сервисы на домены.',
    'service-plan.mail.mailServiceDisabledIncomingHint' => 'Домены могут только отправлять письма и только с помощью Sendmail.',
    'service-plan.mail.mailServiceEnabled' => 'Включено',
    'service-plan.mail.mailServiceEnabledHint' => 'Домены могут отправлять и получать письма.',
    'service-plan.mail.mailServiceNotConfigured' => 'Не настроено',
    'service-plan.mail.mailServiceNotConfiguredHint' => 'Plesk не будет предоставлять почтовые сервисы на домены.',
    'service-plan.mail.webMail' => 'Веб-почта',
    'service-plan.mail.mailingLists' => 'Включить списки рассылки',
    'service-plan.mail.mailToNonExistentUser' => 'Действия с почтой, отправленной на несуществующий почтовый ящик',
    'service-plan.mail.mailToNonExistentUserBounce' => 'Возвращать с уведомлением',
    'service-plan.mail.mailToNonExistentUserRedirect' => 'Перенаправлять на адрес',
    'service-plan.mail.mailToNonExistentUserReject' => 'Отклонять',
    'service-plan.mail.mailAutodiscovery' => 'Включить автообнаружение почты',
    'service-plan.mail.mailAutodiscoveryDescription' => 'О том, как это сделать, читайте в <a href="%%link%%" target="_blank">статье базы знаний</a>',
    'service-plan.mail.bounceMessage' => 'Этот адрес больше не принимает почту.',
    'service-plan.mail.mailToNonExistentUserexternalMailServer' => 'Перенаправлять на внешний почтовый сервер с IP-адресом',
    'service-plan.mail.webmailDisabled' => '%%webmail%% — отключен',
    'service-plan.mail.notConfiguredConfirm' => 'Безвозвратное удаление всех почтовых ящиков затронутых доменов вместе с отправленными и полученными письмами.',
    'service-plan.mail.notConfiguredConfirmError' => 'Пожалуйста, подтвердите',

    'service-plan.misc.manualSubscriptionUpdateWarning' => 'Примечание. Изменение параметра "Сохранять веб-статистику и статистику по трафику" в свойствах тарифного плана не приводит к его изменению в подписках. Единственный способ изменить этот параметр для каждого домена — изменить его в базе данных Plesk. Более подробную информацию смотрите в <a href="https://support.plesk.com/hc/en-us/articles/12377479274007-How-to-configure-a-storage-period-for-statistics" target="_blank">этой статье базы знаний</a>.',
    'service-plan.misc.retainEnabled' => 'Хранить веб-статистику и статистику трафика в течение',
    'service-plan.misc.logRotation' => 'Ротация журналов',
    'service-plan.misc.logRotationCondition' => 'Условие ротации журналов',
    'service-plan.misc.logRotationBySize' => 'по объему',
    'service-plan.misc.logRotationByTime' => 'по времени',
    'service-plan.misc.logRotationDaily' => 'Ежедневно',
    'service-plan.misc.logRotationWeekly' => 'Еженедельно',
    'service-plan.misc.logRotationMonthly' => 'Ежемесячно',
    'service-plan.misc.logRotationSizeDescription' => 'Размер должен находиться в диапазоне от %%min%% до %%max%% Кб.',
    'service-plan.misc.maximumNumberOfFiles' => 'Максимальное количество журналов',
    'service-plan.misc.compress' => 'Архивировать журналы',
    'service-plan.misc.sendLogToEmail' => 'После того как Plesk получит данные из журналов веб- и FTP-серверов, отправлять журналы на этот адрес',
    'service-plan.misc.kb' => 'Кб',
    'service-plan.misc.months' => 'месяцев',
    'service-plan.misc.logRotationPeriodGreater' => 'Периодичность ротации журналов не может превышать серверное ограничение %%max%%.',

    'service-plan.performance.iisAppPoolAddonsHint' => 'Если выключено, все сайты подписки используют один и тот же пул приложений IIS, выделенный для обслуживания этой подписки.',

    'service-plan.permissions-subscription.permissionsTabDescription' => 'Выберите услуги и права, входящие в подписку.',
    'service-plan.permissions-subscription.showMorePermissions' => 'Показать дополнительные права',
    'service-plan.permissions-subscription.hideMorePermissions' => 'Скрыть дополнительные права',
    'service-plan.permissions-subscription.noShellManagement' => 'Запрещено',
    'service-plan.permissions-subscription.systemAccessLabel' => 'Управление доступом к серверу по SSH',
    'service-plan.permissions-subscription.systemAccessLabel_hint' => 'Позволяет клиентам включать SSH для своих системных пользователей. При этом параметр хостинга "SSH-доступ к серверу под системным пользователем подписки" используется в качестве шаблона.',

    'service-plan.permissions.permissionsTabDescription' => 'Выберите услуги и права, предоставляемые планом.',
    'service-plan.permissions.permissionsAddonTabDescription' => 'Выберите услуги и права, которые будут добавлены в подписки с этим дополнительным планом. Права, которые не выбраны в дополнении, никоим образом не будут менять параметры подписки.',
    'service-plan.permissions.permissionsBehaviorDescription' => 'Права позволяют клиентам изменять отдельные настройки подписок. Когда создается новая подписка, Plesk применяет к настройкам заранее установленные планом значения, а клиент после этого может их изменять. Дальнейшее обновление плана или добавление дополнительного плана не перезаписывает изменения, внесенные клиентом.',
    'service-plan.permissions.showMorePermissions' => 'Показать дополнительные права',
    'service-plan.permissions.hideMorePermissions' => 'Скрыть дополнительные права',
    'service-plan.permissions.noShellManagement' => 'Запрещено',
    'service-plan.permissions.systemAccessLabel' => 'Управление доступом к серверу по SSH',
    'service-plan.permissions.systemAccessLabel_hint' => 'Выберите эту опцию, чтобы параметр хостинга "SSH-доступ к серверу под системным пользователем подписки" использовался в качестве шаблона.',

    'service-plan.resources-subscription.overusePolicy' => 'Перерасход',
    'service-plan.resources-subscription.overusePolicyNotAllowed' => 'Перерасход запрещен',
    'service-plan.resources-subscription.overusePolicyNotAllowedHint' => 'Запретить перерасход ресурсов. В случае превышения ограничений действие подписки автоматически приостанавливается.',
    'service-plan.resources-subscription.overusePolicySoftAllowed' => 'Перерасход дискового пространства и трафика разрешен',
    'service-plan.resources-subscription.overusePolicySoftAllowedHint' => 'Разрешить перерасход дискового пространства и трафика. Запретить перерасход других ресурсов.',
    'service-plan.resources-subscription.overusePolicyAllowed' => 'Перерасход разрешен (не рекомендуется)',
    'service-plan.resources-subscription.overusePolicyAllowedHint' => 'Разрешить подписчику использовать больше ресурсов, чем было изначально включено в подписку.',
    'service-plan.resources-subscription.overuseNotify' => 'Отправлять уведомления о перерасходе',
    'service-plan.resources-subscription.oversellPolicy' => 'Продажа сверх запасов',
    'service-plan.resources-subscription.oversellPolicyAllowed' => 'Продажа сверх запасов разрешена',
    'service-plan.resources-subscription.oversellPolicyAllowedHint' => 'Продажа сверх запасов позволяет реселлеру продавать больше ресурсов, чем доступно в его подписке. Если продажа сверх запасов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов.',
    'service-plan.resources-subscription.oversellPolicyNotAllowed' => 'Продажа сверх запасов запрещена',
    'service-plan.resources-subscription.oversellPolicyNotAllowedHint' => 'Если продажа сверх запасов запрещена, реселлер может продавать только столько ресурсов, сколько изначально было доступно в его подписке, независимо от того, сколько ресурсов используется фактически.',
    'service-plan.resources-subscription.mainGroupTitle' => 'Определите ограничения на расход ресурсов, входящих в подписку.',
    'service-plan.resources-subscription.additionalGroupTitle' => 'Показать больше ресурсов',
    'service-plan.resources-subscription.hideMoreResources' => 'Показать меньше ресурсов',

    'service-plan.resources.overusePolicy' => 'Перерасход',
    'service-plan.resources.overusePolicyNotAllowed' => 'Перерасход запрещен',
    'service-plan.resources.overusePolicyNotAllowedHint' => 'Запретить перерасход ресурсов. В случае превышения ограничений действие подписки автоматически приостанавливается.',
    'service-plan.resources.overusePolicySoftAllowed' => 'Перерасход дискового пространства и трафика разрешен',
    'service-plan.resources.overusePolicySoftAllowedHint' => 'Разрешить перерасход дискового пространства и трафика. Запретить перерасход других ресурсов.',
    'service-plan.resources.overusePolicyAllowed' => 'Перерасход разрешен (не рекомендуется)',
    'service-plan.resources.overusePolicyAllowedHint' => 'Разрешить клиентам использовать больше ресурсов, чем было изначально включено в план.',
    'service-plan.resources.overuseNotify' => 'Отправлять уведомления о перерасходе',
    'service-plan.resources.oversellPolicy' => 'Продажа сверх запасов',
    'service-plan.resources.oversellPolicyAllowed' => 'Продажа сверх запасов разрешена',
    'service-plan.resources.oversellPolicyAllowedHint' => 'Продажа сверх запасов позволяет реселлеру продавать больше ресурсов, чем доступно в его плане. Если продажа сверх имеющихся объемов разрешена, то реселлер руководствуется фактическим использованием ресурсов вместо изначально выделенного объема ресурсов.',
    'service-plan.resources.oversellPolicyNotAllowed' => 'Продажа сверх запасов запрещена',
    'service-plan.resources.oversellPolicyNotAllowedHint' => 'Если продажа сверх запасов запрещена, реселлер может продавать только столько ресурсов, сколько изначально было доступно в его плане, независимо от того, сколько ресурсов используется фактически.',
    'service-plan.resources.mainGroupTitle' => 'Укажите ресурсы, входящие в план.',
    'service-plan.resources.additionalGroupTitle' => 'Показать больше ресурсов',
    'service-plan.resources.hideMoreResources' => 'Показать меньше ресурсов',
    'service-plan.resources.allowSitebuilderUpsell' => 'Разрешить клиенту создавать пробные сайты в Presence Builder.',
    'service-plan.resources.allowSitebuilderUpsellDescription' => 'Этот параметр позволяет клиенту создавать больше сайтов Presence Builder, чем включает тарифный план. Для публикации этих сайтов клиенту нужно будет их купить.',

    'service-plan.servicePlanName' => 'Название тарифного плана',
    'service-plan.resellerPlanName' => 'Название плана реселлера',
    'service-plan.addonPlanName' => 'Название дополнительного плана',
    'service-plan.adminPlanPermissionsTab' => 'Администрирование',
    'service-plan.adminPlanPermissionsTabDescription' => 'Выберите функции, доступные администратору в Ограниченном режиме.',
    'service-plan.hostingPermissionsTab' => 'Хостинг',
    'service-plan.hostingPermissionsTabDescription' => 'Выберите инструменты и настройки хостинга, которые будут доступны администратору в режиме Power User, когда включен Ограниченный режим.',
    'service-plan.resourcesTab' => 'Ресурсы',
    'service-plan.resourcesTabDescription' => 'Определить ресурсы, входящие в план, и политику перерасхода ресурсов.',
    'service-plan.subscriptionResourcesTabDescription' => 'Определите ресурсы, входящие в эту подписку, и политику перерасхода ресурсов.',
    'service-plan.hostingTab' => 'Параметры хостинга',
    'service-plan.hostingTabDescription' => 'Укажите параметры услуги хостинга, входящей в план. Обратите внимание, что указанные для дополнительного плана настройки хостинга не применяются к подпискам, в которых "Управление настройками хостинга" разрешено тарифным или дополнительным планом.',
    'service-plan.secureSettingsDescription' => 'Если вы хотите обеспечить своим клиентам максимальную безопасность, %%link%%. Учтите, что некоторые права позволяют подписчикам менять эти настройки. %%helpLink%%.',
    'service-plan.secureSettingsLink' => 'примените шаблон безопасных настроек',
    'service-plan.secureSettingsHelpLink' => 'Подробнее о настройках безопасности хостинга',
    'service-plan.mailTab' => 'Почта',
    'service-plan.mailTabDescription' => 'Настройте параметры почты для данного плана.',
    'service-plan.dnsTab' => 'DNS',
    'service-plan.dnsTabDescription' => 'Укажите параметры службы DNS, входящей в план.',
    'service-plan.performanceTab' => 'Производительность',
    'service-plan.performanceTabDescription' => 'Настройте параметры производительности для всех услуг, входящих в этот план.',
    'service-plan.permissionsTab' => 'Права',
    'service-plan.miscTab' => 'Журналы и статистика',
    'service-plan.miscTabDescription' => 'Укажите, как хранить статистику и журналы подписок плана. Обратите внимание, что в подписках эти настройки не синхронизируются.',
    'service-plan.miscTabAdminPlanDescription' => 'Укажите, как хранить статистику и журналы подписок.',
    'service-plan.extrasTab' => 'Дополнительные услуги',
    'service-plan.extrasTabDescription' => 'Выберите услуги, которые должны быть включены в план помимо веб-хостинга, DNS и почты.',
    'service-plan.ipTab' => 'IP-адреса',
    'service-plan.ipTabDescription' => 'Укажите параметры ресурсов IP, входящих в план.',
    'service-plan.applicationsTab' => 'Приложения',
    'service-plan.applicationsTabDescription' => 'Выберите приложения, которые будут доступны в этом плане. Вы можете предоставить все приложения, доступные в каталоге и загруженные вами на сервер, или выбрать отдельные приложения. Если вы хотите предоставить все доступные приложения, вам не нужно ничего делать на этой вкладке — просто откройте вкладку Права и выберите опцию Доступ к каталогу приложений. Если вы хотите выбрать приложения вручную, вы можете сделать это на этой вкладке.',
    'service-plan.applicationsTabDescription-addon' => 'Выберите приложения, которые будут включены в эту дополнительную услугу.',
    'service-plan.applicationsTabDescription-subscription' => 'Выберите приложения, которые будут доступны в этой подписке. Вы можете предоставить все приложения, доступные в каталоге и загруженные вами на сервер, или выбрать отдельные приложения. Если вы хотите предоставить все доступные приложения, вам не нужно ничего делать на этой вкладке — просто откройте вкладку Права и выберите опцию Доступ к каталогу приложений. Если вы хотите выбрать приложения вручную, вы можете сделать это на этой вкладке.',
    'service-plan.planSyncSubsriptionWarning' => 'Некоторые подписки не были синхронизированы с планом. Они были помечены как \'Несинхронизированные\' в списке подписок. Чтобы повторить попытку синхронизации, откройте страницу подписки и нажмите кнопку Синхронизировать.',
    'service-plan.planSyncResellerWarning' => 'Некоторые реселлеры не были синхронизированы с планом. Они были помечены как \'Несинхронизированные\' в списке реселлеров. Чтобы повторить попытку синхронизации, откройте страницу реселлера и нажмите Синхронизировать.',
    'service-plan.planSyncAdminWarning' => 'Невозможно применить изменения к подпискам, так как Plesk не предоставляет некоторые из услуг или ресурсов, затрагиваемых этими изменениями. Причина: %%reason%%',
    'service-plan.duplicateName' => 'План с таким именем уже существует.',
    'service-plan.phpSettingsTab' => 'Настройки PHP',
    'service-plan.phpHandlerNotFound' => 'Не удалось получить информацию о версии PHP плана. Переустановите его или выберите другую версию PHP для тарифного плана.',
    'service-plan.phpHandlerNotRegistered' => "Версия PHP %%fullVersion%% не установлена. PHP-скрипты для доменов, использующих этот тарифный план, будут недоступны. Установите PHP <nobr>версию %%fullVersion%%</nobr> или выберите другую версию PHP для тарифного плана.",

    'service-plan.phpSettingsTabDescription' => 'Здесь вы можете указать индивидуальные настройки PHP для отдельных подписок, которые будут действовать вместо глобальных настроек из файла php.ini. Это может пригодиться, если вы, например, захотите ограничить потребление системных ресурсов PHP-скриптами клиентов. Клиенты (если им разрешено) могут указать собственные настройки на уровне домена. Параметры, для которых вы оставите значение по умолчанию, будут взяты из глобальных настроек PHP. Поддерживаемые замещающие символы: {DOCROOT} и {WEBSPACEROOT} служат для обозначения корневой папки того домена или подписки, для которых предназначена индивидуальная конфигурация PHP; {TMP} служит для обозначения папки, в которой будут храниться временные файлы. Примечание: настройки ниже могут быть перезаписаны параметрами, указанными в файлах .htaccess, php.ini или .user.ini.',
    'service-plan.phpSettingsTabDescriptionAddon' => 'Здесь вы можете указать индивидуальные настройки PHP для отдельных подписок, которые будут действовать вместо настроек из основного тарифного плана. Это может пригодиться, если вы, например, захотите отменить некоторые ограничения, заданные в основном тарифном плане. Параметры, для которых вы оставите значение по умолчанию, будут взяты из настроек PHP тарифного плана. Поддерживаемые замещающие символы: {DOCROOT} и {WEBSPACEROOT} служат для обозначения корневой папки того домена или подписки, для которых предназначена индивидуальная конфигурация PHP; {TMP} служит для обозначения папки, в которой будут храниться временные файлы.',
    'service-plan.phpSettingsPhpVersion' => 'Ваша текущая версия PHP — %%version%%.',
    'service-plan.phpSettingsTabAdminPlanDescription' => 'Здесь вы можете указать индивидуальные настройки PHP, которые будут действовать для отдельных веб-пространств вместо глобальных настроек из файла php.ini. Параметры, для которых вы оставите значение по умолчанию, будут взяты из глобальных настроек PHP.',
    'service-plan.webServerSettingsTab' => 'Веб-сервер',
    'service-plan.webServerSettingsTabDescription' => 'Здесь вы можете указать настройки веб-сервера Apache для этого тарифного плана. Если Apache работает в связке с nginx, то на этой странице также можно указать настройки nginx. Указанные здесь настройки будут применены только ко вновь создаваемым доменам. Уже существующие домены останутся без изменений.',
    'service-plan.servicesTab' => 'Услуги',
    'service-plan.servicesTabDescription' => 'Здесь вы можете указать услуги, закрепленные за этим тарифным планом.',
    'service-plan.servicePropertiesTab' => 'Свойства %%serviceName%%',
    'service-plan.servicePropertiesTabDescription' => 'Здесь вы можете указать свойства услуги %%serviceName%%, закрепленной за этим тарифным планом.',
    'service-plan.longTaskWarning' => 'У вас %%subscriptionsCount%% подписок на этом плане. Обратите внимание, что синхронизация может занять много времени и она будет выполнена в фоновом режиме.',
    'service-plan.hostingParametersTab' => 'Параметры хостинга',
    'service-plan.adminInfoSection' => 'Информация для администратора',
    'service-plan.descriptionInPanel' => 'Описание',
    'service-plan.longDescription' => 'Слишком длинное описание.',
    'service-plan.conflictPermissions' => 'Невозможно предоставить следующие права, потому что они конфликтуют с планом реселлера: %%permissions%%.',

    'services.change-startup-type.startupTypeLabel' => 'Тип запуска',
    'services.change-startup-type.autoStartupTypeLabel' => 'Автоматически',
    'services.change-startup-type.manualStartupTypeLabel' => 'Вручную',
    'services.change-startup-type.disabledStartupTypeLabel' => 'Отключить',
    'services.change-startup-type.autoActionError' => 'Невозможно установить тип запуска \'авто\': %%error%%',
    'services.change-startup-type.manualActionError' => 'Невозможно установить тип запуска \'вручную\': %%error%%',
    'services.change-startup-type.disableActionError' => 'Невозможно установить тип запуска \'выключено\': %%error%%',

    'sessions.settings.restoreDefaultButton' => 'Восстановить значения по умолчанию',
    'sessions.settings.restoreDefaultButtonDescription' => 'Восстановить значения по умолчанию для параметров сеанса.',
    'sessions.settings.restoreDefaultButtonDescriptionDisable' => 'Параметры сеанса имеют значения по умолчанию.',
    'sessions.settings.idleTime' => 'Время простоя сеанса',
    'sessions.settings.disableCheckSessionIp' => 'Разрешить изменение IP-адреса во время одного сеанса',
    'sessions.settings.minuteShortTitle' => 'мин',

    'settings-ui.controls.title' => 'Элементы управления',

    'settings-ui.interface-views.description' => "Интерфейс Plesk имеет несколько режимов просмотра. От выбранного режима зависит расположение и даже состав функций и настроек. Каждый из режимов предназначен для определенного типа пользователей.",
    'settings-ui.interface-views.panelSimpleLink' => 'Инструменты и настройки > Настройки Ограниченного режима',
    'settings-ui.interface-views.useCustomView' => 'Включить Ограниченный режим',
    'settings-ui.interface-views.useCustomViewHint' => 'Выберите эту опцию, чтобы ограничить набор операций, доступных администратору в Plesk. Настроить список таких операций можно на странице %%customViewSettingsLink%%.',
    'settings-ui.interface-views.powerUserViewHint' => 'Этот способ просмотра предназначен для управления веб-сайтами, их файлами, базами данных, учетными записями электронной почты, веб-приложениями и прочими службами.',
    'settings-ui.interface-views.selectUiModeTitle' => "Режим интерфейса",
    'settings-ui.interface-views.uiModeTitlePowerUser' => "Режим Power User (для разработчиков и веб-агентств)",
    'settings-ui.interface-views.uiModeTitleServiceProvider' => "Режим Service Provider (для провайдеров хостинга)",
    'settings-ui.interface-views.uiModeHintServiceProvider' => 'Этот способ просмотра предназначен для системных администраторов, предоставляющих и продающих услуги веб-хостинга клиентам с тарифными планами.',
    'settings-ui.interface-views.visibilityMailBounce' => 'Скрыть кнопку возврата',
    'settings-ui.interface-views.visibilityMailBounceHint' => 'Скрывает кнопку, с помощью которой можно выбрать, что делать с письмами, отправленными на несуществующие адреса',

    'settings-ui.branding.description' => 'Меняйте внешний вид Plesk, изменив отображение страницы в строке заголовка браузера и/или заменив логотип Plesk в левом верхнем углу окна.',
    'settings-ui.branding.buttonDefault' => 'По умолчанию',
    'settings-ui.branding.sectionTitle' => 'Настраиваемый заголовок',
    'settings-ui.branding.enableCustomTitle' => 'Включить настраиваемый заголовок на страницах Plesk',
    'settings-ui.branding.customTitle' => 'Текст заголовка',
    'settings-ui.branding.sectionLogo' => 'Настраиваемый логотип',
    'settings-ui.branding.enableCustomLogo' => 'Включить настраиваемый логотип панели',
    'settings-ui.branding.logo' => 'Файл логотипа',
    'settings-ui.branding.logoUrl' => 'URL логотипа',
    'settings-ui.branding.logoUrlEnabled' => 'Персональный',
    'settings-ui.branding.logoUrlDisabled' => 'По умолчанию',
    'settings-ui.branding.sectionFavicon' => 'Настраиваемый значок сайта',
    'settings-ui.branding.enableCustomFavicon' => 'Включить настраиваемый значок сайта',
    'settings-ui.branding.sectionFaviconDesc' => 'Один и тот же значок сайта должен быть загружен в обоих форматах для лучшей поддержки в разных браузерах.',
    'settings-ui.branding.faviconSvg' => 'Файл SVG значка сайта',
    'settings-ui.branding.faviconSvgHint' => 'Допустимый формат: SVG',
    'settings-ui.branding.faviconIco' => 'Файл ICO значка сайта',
    'settings-ui.branding.faviconIcoHint' => 'Допустимый формат: ICO',
    'settings-ui.branding.show' => 'Показать',
    'settings-ui.branding.updateSuccess' => 'Настройки фирменного стиля Plesk были изменены.',
    'settings-ui.branding.sectionBackground' => 'Персональный фон страницы входа',
    'settings-ui.branding.enableCustomBackground' => 'Включить фоновое изображение',
    'settings-ui.branding.backgroundFile' => 'Фоновое изображение',
    'settings-ui.branding.backgroundColor' => 'Цвет фона',
    'settings-ui.branding.backgroundResetColor' => 'Сбросить',
    'settings-ui.branding.backgroundFit' => 'Положение фона',
    'settings-ui.branding.background.fit.fill' => 'Заполнить экран',
    'settings-ui.branding.background.fit.fit' => 'По размеру экрана',
    'settings-ui.branding.background.fit.center' => 'По центру',
    'settings-ui.branding.background.fit.tile' => 'Замостить',

    'sitebuilder.trial.description' => 'На этой странице вы можете настроить пробный режим (бывший сценарий привлечения клиентов). Этот режим позволит клиентам создавать сайты в Presence Builder, используя все доступные функции программы. Однако для публикации таких пробных сайтов клиентам нужно будет купить дополнительный тарифный план или подписку на хостинг. Пробный режим также можно сделать доступным для существующих клиентов — с помощью хостинг-плана или дополнительного плана. %%link%%',
    'sitebuilder.trial.descriptionLink' => 'Более подробная информация содержится в документации.',
    'sitebuilder.trial.lifetimeLabel' => 'Время жизни пробных сайтов',
    'sitebuilder.trial.lifetimeUnits' => 'дней',
    'sitebuilder.trial.lifetimeDescription' => 'Это количество времени, в течение которого пробные сайты, не купленные клиентами, будут храниться на сервере.',
    'sitebuilder.trial.signupLabel' => 'Включить общий доступ к пробному режиму',
    'sitebuilder.trial.signupDescription' => 'Включить открытый доступ к пробной версии Presence Builder.',
    'sitebuilder.trial.signupLinkLabel' => 'URL пробной версии',
    'sitebuilder.trial.signupLinkDescription' => 'URL-адрес пробной версии Presence Builder. Чтобы сделать этот адрес доступным для потенциальных клиентов, опубликуйте его на своем сайте или распространите любым другим способом.',
    'sitebuilder.trial.promotionLabel' => 'Показывать уведомление о пробном режиме в редакторе Presence Builder',
    'sitebuilder.trial.promotionDescription' => 'Включить показ уведомления о том, что Presence Builder работает в пробном режиме.',

    'update-settings.policyHintForPum' => 'Настроить автоматическую установку обновлений можно здесь. Вы можете настроить получение уведомлений по электронной почте, когда появятся доступные обновления для установки вручную, или когда обновления будут установлены автоматически.',
    'update-settings.policyHint' => 'Вы можете настроить получение уведомлений по электронной почте, когда появятся доступные обновления для установки вручную, или когда обновления будут установлены автоматически.',
    'update-settings.branchDisabledDescription' => 'Не сообщать о доступных обновлениях',
    'update-settings.automaticPatchesInstallation' => 'Устанавливать обновления Plesk автоматически (рекомендуется)',
    'update-settings.automaticPatchesThirdParty' => 'Автоматически устанавливать обновления для сторонних компонентов, поставляемых с Plesk',
    'update-settings.automaticSystemPackageUpdates' => 'Автоматически устанавливать обновления системных пакетов',
    'update-settings.automaticSystemPackageUpdatesHint' => 'Обратите внимание на то, что будут автоматически установлены обновления для сторонних компонентов, поставляемых с Plesk',
    'update-settings.installerProxyMode' => 'Доступ к установщику Plesk с использованием имени хоста и порта Plesk',
    'update-settings.installerProxyModeHint' => 'Получите доступ к веб-интерфейсу установщика Plesk без открытия дополнительного TCP-порта 8447 в брандмауэре.',
    'update-settings.automaticPatchesNotification' => 'Уведомлять о доступных и установленных обновлениях системных пакетов',
    'update-settings.systemPackageUpdatesNotificationsEmail' => 'Электронная почта',
    'update-settings.systemPackageUpdatesNotificationsPeriod' => 'Частота уведомлений по электронной почте',
    'update-settings.daily' => 'Ежедневно',
    'update-settings.weekly' => 'Еженедельно',
    'update-settings.generalSection' => 'Общие',
    'update-settings.notificationsSection' => 'Уведомления',
    'update-settings.safeUpdatesSection' => 'Безопасные обновления',
    'update-settings.safeUpdatesSectionHint' => 'Plesk следит за тем, чтобы обновления системных пакетов устанавливались из того же репозитория, откуда изначально были установлены пакеты. Такие обновления считаются безопасными. Если вы отключите безопасные обновления, ваш менеджер системных пакетов сможет устанавливать обновления из любого репозитория в системе.',
    'update-settings.safeUpdatesSectionWarn' => 'Если вы не опытный пользователь, мы рекомендуем оставить включенными безопасные обновления. Беспорядочное обновление системных пакетов из разных репозиториев может негативно сказаться на работе сервера.',
    'update-settings.allowSafeUpdates' => 'Включить безопасные обновления для системных пакетов',

    'requiredFields' => 'Обязательные поля',

    'ip-ban.banned-ip.ipAddress' => 'IP-адрес',
    'ip-ban.banned-ip.hintIpAddress' => 'IP-адрес или маска CIDR.',
    'ip-ban.banned-ip.banType' => 'Заблокировать IP-адрес: ',
    'ip-ban.banned-ip.banType_plesk-one-week-ban' => 'На одну неделю',
    'ip-ban.banned-ip.banType_plesk-permanent-ban' => 'Навсегда',

    'server-mail-smarthost.settings.title' => 'Настройки промежуточного узла',
    'server-mail-smarthost.settings.useSmarthost' => 'Отправлять почту пользователям через промежуточный узел',
    'server-mail-smarthost.configuration.title' => 'Конфигурация промежуточного узла',
    'server-mail-smarthost.configuration.hostnameOrIP' => 'Имя хоста или IP-адрес',
    'server-mail-smarthost.configuration.hostnameOrIP.unixHint' => 'Чтобы отключить поиск записей MX и SRV, укажите имя хоста или IP-адрес в квадратных скобках, например [example.com]',
    'server-mail-smarthost.configuration.checkConnection' => 'Проверить подключение',
    'server-mail-smarthost.configuration.port' => 'Порт',
    'server-mail-smarthost.configuration.username' => 'Имя пользователя',
    'server-mail-smarthost.configuration.password' => 'Пароль',
    'server-mail-smarthost.configuration.encryption' => 'Зашифрованное соединение',
    'server-mail-smarthost.configuration.encryption.Unix.on' => 'Требуется',
    'server-mail-smarthost.configuration.encryption.Unix.off' => 'Не требуется',
    'server-mail-smarthost.configuration.encryption.Windows.off' => 'Нет',
    'server-mail-smarthost.configuration.encryption.Windows.tls' => 'TLS',
    'server-mail-smarthost.configuration.encryption.Windows.ssl' => 'SSL',
    'server-mail-smarthost.configuration.authRequired' => 'Требуется аутентификация',
    'server-mail-smarthost.configuration.checkConnection.success' => 'Подключение к промежуточному узлу установлено.',
    'server-mail-smarthost.success' => 'Конфигурация промежуточного узла изменена.',
    'server-mail-smarthost.settings.noteTitle' => 'Примечание.',
    'server-mail-smarthost.settings.note' => '%%title%% При настройке отправки почты через промежуточный узел вам потребуется вручную обновить запись SPF и другие связанные с ним записи DNS в шаблоне DNS и зонах DNS существующих доменов. Это необходимо, чтобы предотвратить ошибки проверки для почты, отправляемой через промежуточный узел. %%link%%',
    'server-mail-smarthost.settings.noteLinkTitle' => 'Посмотреть подробности.',
];