<?php
/**
 * Copyright 2008-2017 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/licenses/bsd.
 *
 * @author   Gunnar Wrobel <wrobel@pardus.de>
 * @category Horde
 * @license  http://www.horde.org/licenses/bsd BSD
 * @package  Controller
 */

/**
 *
 *
 * @author    Gunnar Wrobel <wrobel@pardus.de>
 * @category  Horde
 * @copyright 2008-2017 Horde LLC
 * @license   http://www.horde.org/licenses/bsd BSD
 * @package   Controller
 */
class Horde_Controller_Request_Mock extends Horde_Controller_Request_Http
{
    /**
     * Request variables.
     *
     * @var array
     */
    protected $_vars;

    /**
     * Constructor.
     *
     * @param array $vars  The request variables.
     */
    public function __construct($vars = array())
    {
        $this->setVars($vars);
        $server = $this->getServerVars();
        if (!empty($server['REDIRECT_URL'])) {
            $this->setPath($server['REDIRECT_URL']);
        } else if (!empty($server['REQUEST_URI'])) {
            $this->setPath($server['REQUEST_URI']);
        }
    } 

    /**
     * Set the request variables GET, POST, COOKIE, SERVER, REQUEST etc.
     *
     * @param array $vars  The request variables.
     */
    public function setVars($vars)
    {
        foreach ($vars as $key => $sub) {
            $this->_vars[Horde_String::upper($key)] = $sub;
        }
    }

    /**
     * Gets the request variables GET, POST, COOKIE, SERVER, REQUEST etc.
     *
     * @param string $name  The name of the superglobal whose vars to return
     */
    protected function getVars($name)
    {
        if (isset($this->_vars[$name])) {
            return $this->_vars[$name];
        }
    }

    public function getGetVars()
    {
        return $this->getVars('GET');
    }

    public function getFileVars()
    {
        return $this->getVars('FILES');
    }

    public function getServerVars()
    {
        return $this->getVars('SERVER');
    }

    public function getPostVars()
    {
        return $this->getVars('POST');
    }

    public function getCookieVars()
    {
        return $this->getVars('COOKIE');
    }

    public function getRequestVars()
    {
        return $this->getVars('REQUEST');
    }
    
    /**
     * The request body if it is not form-encoded
     * @returns Horde_Stream
     */
    public function getRequestBody()
    {
        return new Horde_Stream_String(array('string' => $this->getVars('REQUEST')));
    }
}
