<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'aps-install.queue' => 'Installerer %%name%% på %%path%%...',
    'aps-install.queueNoPath' => 'installerer %%name%%...',
    'aps-install.done' => '%%name%% ble vellykket installert på %%path%%. Under ser du påloggingsdetaljer for å logge på programmet. %%additionalMessage%%',
    'aps-install.doneNoPath' => '%%name%% ble vellykket installert. Under ser du påloggingsdetaljer for å logge på programmet. %%additionalMessage%%',
    'aps-install.doneAdvanced' => '%%name%% ble vellykket installert på %%path%%. %%additionalMessage%%',
    'aps-install.doneAdvancedNoPath' => '%%name%% ble vellykket installert. %%additionalMessage%%',
    'aps-install.error' => 'Installasjon av %%name%% på %%path%% gikk galt. %%errorMessage%%',
    'aps-install.errorNoPath' => 'Installasjon av %%name%% gikk galt. %%errorMessage%%',

    'aps-update.queueDownload' => 'Laster ned %%packageName%%…',
    'aps-update.errorDownload' => 'Nedlasting av %%packageName%% mislyktes:',
    'aps-update.queueInstall' => 'Oppdaterer en installasjon av %%name%% for %%domainName%%…',
    'aps-update.doneInstall' => 'Installasjon av %%name%% for %%domainName%% ble oppdatert.',
    'aps-update.errorInstall' => 'Oppdatering av en installasjon av %%name%% for %%domainName%% mislyktes:',
    'aps-update.queueInstallMulti' => 'Oppdaterer %%instances%% installasjoner av %%name%%…',
    'aps-update.doneInstallMulti' => '%%successes%% installasjoner av %%name%% ble oppdatert.',
    'aps-update.errorInstallMulti' => 'Oppdatering av %%failures%% installasjoner av %%name%% mislyktes:',
    'aps-update.incorrectUpdateInformation' => 'Oppdateringsinformasjonen er feil.',

    'common.hideCompletedTasks' => 'Skjul fullførte',
    'common.progressBarHide' => 'Skjul',
    'common.progressBarShow' => 'Vis',
    'common.close' => 'Lukk',
    'common.refresh' => 'Oppdater side',
    'common.taskInProgress' => '%%count%% oppgaver pågår ...',
    'common.percentCompleted' => '%%percent%%% fullført',
    'common.allTasksCompleted' => 'Alle %%num%% oppgavene ble fullført.',
    'common.minimize' => 'Minimer',
    'common.statusDone' => 'Fullført',
    'common.statusError' => 'Mislykket',
    'common.statusNotStarted' => 'I kø',
    'common.statusCanceled' => 'Kansellert',
    'common.progressDialogLink' => 'detaljert fremdrift',
    'common.progressLabel' => '%%count%% pågår',
    'common.successLabel' => '{count, plural, one {# fullført} other {# fullførte}}',
    'common.successLabelTooltip' => 'Lukk alle varsler om fullførte oppgaver',
    'common.warningLabel' => '{count, plural, one {# advarsel} other {# advarsler}}',
    'common.warningLabelTooltip' => 'Lukk alle varsler om advarsler',
    'common.errorLabel' => '{count, plural, one {# feil} other {# feil}}',
    'common.errorLabelTooltip' => 'Lukk alle varsler om feil',

    'database-check.queue' => 'Kontrollerer %%database%% databasetabeller …',
    'database-check.done' => '%%database%%-databasen har ingen feil.',
    'database-check.error' => 'Kunne ikke kontrollere databasen %%database%% for feil.',
    'database-check.done-with-errors' => "%%database%%-databasen har %%number%% problemer. \n %%link%%",
    'database-check.info-link-title' => 'Se detaljer og løs',

    'database-download.queue' => 'Forbereder en dump av %%database%% for eksport...',
    'database-download.done' => 'Dump av %%database%% er klar. Du kan %%downloadLink%% den.',
    'database-download.downloadLink' => 'last ned',
    'database-download.error' => 'Kunne ikke eksportere en dump av %%database%%:',

    'database-repair.queue' => 'Reparerer %%database%% databasetabeller…',
    'database-repair.done' => '%%database%%-databasen har ingen feil.',
    'database-repair.error' => 'Kunne ikke reparere databasen %%database%%.',
    'database-repair.done-with-errors' => "%%database%%-databasen har %%number%% problemer. \n %%link%%",
    'database-repair.info-link-title' => 'Vis detaljer',

    'database-upload.queue' => 'Importerer en dump av %%database%%...',
    'database-upload.done' => 'Dump av %%database%% ble importert.',
    'database-upload.error' => 'Kunne ikke importere en dump av %%database%%:',
    'database-upload.done-with-errors' => "Dump av %%database%% ble importert med feil.",
    'database-upload.orphanedUsersSuccess' => 'Databasen %%database%% ble importert. Noen brukere ble imidlertid gjort frittstående (har ingen pålogginger tilknyttet databaseserveren). For å få tilgang til databasene dine, tildel pålogginger til disse brukerne. %%viewUsersLink%%.',
    'database-upload.orphanedUsersError' => 'Følgende brukere ble imidlertid gjort frittstående (har ingen pålogginger tilknyttet databaseserveren): %%orphanedUsers%%.',
    'database-upload.orphanedUsersLink' => 'Vis brukere',

    'domain-app-scan.queue' => 'Søker etter applikasjoner ...',
    'domain-app-scan.done' => 'Søk etter applikasjoner ble fullført.',
    'domain-app-scan.error' => 'Søk etter applikasjoner ble fullført med feil.',

    'domain-move.queue' => 'Flytter %%domainName%% til %%webspaceName%%',
    'domain-move.done' => '%%domainName%% ble flyttet til %%webspaceName%%',
    'domain-move.error' => '%%domainName%% ble ikke flyttet til %%webspaceName%%',

    'domain-split.queue' => 'Flytter %%domainName%% til et nytt abonnement',
    'domain-split.done' => '%%domainName%% ble flyttet til et nytt abonnement',
    'domain-split.error' => '%%domainName%% ble ikke flyttet til et nytt abonnement',

    'file-manager-import-file.done' => 'Filen %%fileName%% er importert til <a href="%%listUrl%%">mappen %%fileDir%%</a>.',
    'file-manager-import-file.error' => 'Kunne ikke importere filen %%fileName%%: %%errorMessage%%.<br><a href="%%url%%">Last ned til datamaskinen</a>',
    'file-manager-import-file.queue' => 'Importerer filen %%fileName%% fra %%host%%.',
    'file-manager-import-file.progress' => 'Importerer filen %%fileName%% fra %%host%% (%%value%% MB).',
    'file-manager-import-file.errors.auth' => 'Det oppstod en godkjenningsfeil. Sørg for at du har skrevet inn riktig brukernavn og passord',
    'file-manager-import-file.errors.resolve' => 'Kunne ikke løse verstnavnet %%host%%. Sørg for at du har skrevet inn riktig nettadresse',
    'file-manager-import-file.errors.connect' => 'Kunne ikke koble til %%host%%-serveren. Sørg for at du har skrevet inn riktig nettadresse',
    'file-manager-import-file.errors.notFound' => 'Fant ikke den eksterne filen, eller den er ikke tilgjengelig. Sørg for at du skriver inn riktig nettadresse, og at filen er tilgjengelig',
    'file-manager-import-file.errors.maxSize' => 'Diskplassen eller den ledige plassen på %%diskSpaceLimit%% er overskredet',
    'file-manager-import-file.errors.lowSpeedTime' => 'Kunne ikke importere filen fordi overføringshastigheten var for langsom: mindre enn %%lowSpeedLimit%% bytes ble overført i løpet av de siste %%lowSpeedTime%% sekundene. Det kan være at nettsiden som er vert for filen for øyeblikket opplever mye trafikk. Prøv å importere filen senere',
    'file-manager-import-file.errors.certificate' => 'Kunne ikke importere filen fordi SSL/TLS-sertifikatet for %%host%%-serveren ikke er klarert. Sørg for at nettsiden som er vert for filen er sikret med et klarert sertifikat',
    'file-manager-import-file.errors.redirects' => 'Maksimalt antall omdirigeringer (%%maxRedirects%%) er overskredet. Sørg for at %%host%%-serveren fungerer som den skal',

    'force-log-rotation.queue' => 'Bruker globale innstillinger for loggrotasjon',
    'force-log-rotation.done' => 'Globale innstillinger for loggrotasjon ble tatt i bruk.',
    'force-log-rotation.error' => 'Global loggrotasjon fullført med feil',
    'force-log-rotation.systemLogRotationError' => 'Systemlogger: %%error%%',
    'force-log-rotation.planLogRotationError' => 'Tjenesteplan %%name%%: %%error%%',
    'force-log-rotation.domainLogRotationError' => 'Domene %%name%%: %%error%%',

    'initial-setup.queue' => 'Starter Plesk ...',
    'initial-setup.done' => 'Plesk er blitt initialisert.',
    'initial-setup.doneWithErrors' => 'Det oppstod en feil under initialisering av Plesk.',
    'initial-setup.error' => 'Oppstart av Plesk mislyktes.',
    'initial-setup.step.setupPanel' => 'Konfigurering av Plesk-panelet',
    'initial-setup.step.requestLicense' => 'Be om lisens',
    'initial-setup.step.configureServer' => 'Konfigurere webserver',
    'initial-setup.step.secureServer' => 'Sikre serveren',

    'ip-update.queue' => 'Oppdaterer IP-adresse',
    'ip-update.done' => 'IP-adresse oppdatert.',
    'ip-update.error' => 'Oppdatering av IP-adresse ble fullført med feil',
    'ip-update.updating' => 'Oppdaterer IP-adresse',
    'ip-update.updatingWebServer' => 'Oppdaterer IP-adresse: oppdaterer webserver',
    'ip-update.updatingFtpServer' => 'Oppdaterer IP-adresse: oppdaterer FTP-server',
    'ip-update.updatingDnsZones' => 'Oppdaterer IP-adresse: oppdaterer DNS-soner',
    'ip-update.restartingDnsService' => 'Oppdaterer IP-adresse: starter DNS-server om igjen',

    'ip-reload-public.queue' => 'Oppdatering av offentlige IP-adresser bruker nettsky-metadata',
    'ip-reload-public.done' => 'Offentlige IP-adresser ble oppdatert',

    'logrotate_anonymize_ips.queue' => 'Anonymiser IP-adresser i logger',
    'logrotate_anonymize_ips.queueRevert' => 'De-anonymiser IP-adresser i logger',
    'logrotate_anonymize_ips.done' => 'IP-adressene ble anonymisert.',
    'logrotate_anonymize_ips.doneRevert' => 'IP-adressene ble av-anonymiserte.',
    'logrotate_anonymize_ips.error' => 'Anonymisering av IP-adressene ble fullført med feil',
    'logrotate_anonymize_ips.errorRevert' => 'Av-anonymisering av IP-adressene ble fullført med feil',

    'nginx_http3_configure.queue' => 'Konfigurerer støtte for Nginx HTTP/3',
    'nginx_http3_configure.done' => 'Støtte for Nginx HTTP/3 ble konfigurert.',
    'nginx_http3_configure.error' => 'Støtte for Nginx HTTP/3 ble ikke konfigurert.',

    'panel-components-install.queue' => 'Installerer valgte komponenter',
    'panel-components-install.done' => 'De valgte komponentene ble vellykket installert.',
    'panel-components-install.error' => 'Kan ikke installere komponentene. Varslingen med feilbeskrivelsen ble sendt til e-postadressen din.',

    'panel-update.queue' => 'Plesk installerer oppdateringer. Dette kan ta litt tid. %%warning%%',
    'panel-update.warning' => 'Ikke utfør noen som helst administrasjonsoperasjon i Plesk før oppdateringen er fullført.',
    'panel-update.done' => 'Plesk ble oppdatert. Se mer info i%%changelog%%.',
    'panel-update.changelog' => 'Plesk-endringslogg',
    'panel-update.error' => 'Oppdateringen av Plesk gikk feil. %%errorDetails%%',
    'panel-update.support' => 'For å løse dette problemet kan de sende oppdateringsloggen til Plesk kundestøtte. %%failedLog%% Kopier loggen til din datamaskin før du lukker denne beskjeden..',
    'panel-update.failedLog' => 'Se oppdateringsloggen fra %%date%%.',

    'pum-update-packages.queue' => 'Oppdaterer %%count%% pakke(r) ...',
    'pum-update-packages.done' => '%%count%% pakker ble oppdatert.',
    'pum-update-packages.error' => 'Oppdatering mislyktes.',

    'scheduler-run-task.queue' => 'Kjører oppgaven "%%task%%"...',
    'scheduler-run-task.done' => 'Oppgave "%%task%%" fullført med på %%seconds%% sekunder.',
    'scheduler-run-task.error' => 'Oppgave "%%task%%" fullført med feil på %%seconds%% sekunder.',
    'scheduler-run-task.popupSeeDetails' => 'Vis detaljer',
    'scheduler-run-task.popupTitle' => 'Kjør planlagt oppgave',
    'scheduler-run-task.popupDone' => 'Oppgave &quot;%%task%%&quot; fullført med på %%seconds%% sekunder, utdata:',
    'scheduler-run-task.popupError' => 'Oppgave "%%task%%" fullført med feil på %%seconds%% sekunder, utdata:',
    'scheduler-run-task.popupClose' => 'Lukk',

    'sdk.queue' => 'Oppgaven "%%name%%" pågår ...',
    'sdk.error' => 'Oppgaven "%%name%%" mislyktes.',
    'sdk.done' => 'Oppgaven "%%name%%" ble fullført.',
    'sdk.canceled' => 'Oppgaven "%%name%%" ble avbrutt.',

    'sync-php-settings.queue' => 'Bruker globale PHP %%version%%-innstillinger på domener',
    'sync-php-settings.done' => 'Globale PHP %%version%%-innstillinger ble aktivert på domener',
    'sync-php-settings.error' => 'Det oppstod en feil under aktivering av globale PHP %%version%%-innstillinger på domener',

    'sync-service-plan.queue' => 'Synkroniserer serviceplan %%name%% med abonnementer',
    'sync-service-plan.done' => 'Serviceplan %%name%% ble synkronisert med abonnementer',
    'sync-service-plan.doneWithErrors' => 'Synkroniseringen av serviceplan %%name%% ble gjennomført. Noen abonnementer ble ikke synkronisert med planen',
    'sync-service-plan.error' => 'Det oppstod en feil under synkronisering av serviceplan %%name%% med abonnementer',

    'domain-create.queue' => 'Slik oppretter du domenet %%domainName%%',
    'domain-create.done' => 'Domenet %%domainName%% opprettet',
    'domain-create.error' => 'Opprettelse av domenet %%domainName%% mislyktes',
    'domain-create.warning' => 'Domenet %%domainName%% ble opprettet med få problemer:<br> %%problems%%',
    'domain-create.refreshUrl' => 'Vis',
    'domain-create.steps.createCustomer' => 'Oppretter kunde',
    'domain-create.steps.createSubscription' => 'Slik oppretter du et abonnement',
    'domain-create.steps.createDomain' => 'Slik legger du til et domene',
    'domain-create.steps.configureDns' => 'Slik konfigurerer du DNS-sonen',
    'domain-create.steps.createHosting' => 'Slik oppretter du fysisk hosting',
    'domain-create.steps.configurePhp' => 'Slik konfigurerer du PHP',
    'domain-create.steps.configureMail' => 'Konfigurering av e-post',

    'domain-delete.queue' => 'Sletting av domener behandles',
    'domain-delete.done' => 'Domener slettet',
    'domain-delete.error' => 'Sletting av domener mislyktes',
    'domain-delete.step.domains' => 'Sletter domener …',

    'domain-resolve-checking.warning' => 'Domenet %%domainName%% løser problemer som oppdages:<br>%%errors%%',

    'customer-create.queue' => 'Oppretting av kunden %%customerName%% behandles',
    'customer-create.done' => 'Kunden %%customerName%% er opprettet',
    'customer-create.error' => 'Oppretting av kunden %%customerName%% mislyktes',
    'customer-create.warning' => 'Kunden %%customerName%% ble opprettet med et par problemer:<br>%%problems%%',
    'customer-create.warnings.notSynchronizedLink' => 'Du kan prøve å synkronisere den manuelt.',

    'customer-delete.queue' => 'Sletting av kunder behandles',
    'customer-delete.done' => 'Kunder slettet',
    'customer-delete.error' => 'Sletting av kunder mislyktes',

    'reseller-delete.queue' => 'Sletting av forhandlere behandles',
    'reseller-delete.done' => 'Forhandlere slettet',
    'reseller-delete.error' => 'Sletting av forhandlere mislyktes',

    'subscription-create.queue' => 'Oppretting av abonnementet %%subscriptionName%% behandles',
    'subscription-create.done' => 'Abonnementet %%subscriptionName%% er opprettet',
    'subscription-create.error' => 'Oppretting av abonnementet %%subscriptionName%% mislyktes',
    'subscription-create.warning' => 'Abonnementet %%subscriptionName%% ble opprettet med et par problemer:<br>%%problems%%',
    'subscription-create.warnings.notSynchronizedLink' => 'Du kan prøve å synkronisere den manuelt.',

    'subscription-delete.queue' => 'Sletting av abonnementer behandles',
    'subscription-delete.done' => 'Abonnementer slettet',
    'subscription-delete.error' => 'Sletting av abonnementer mislyktes',

    'websites-diagnostic.queue' => 'Kjører nettsidediagnostikk',
    'websites-diagnostic.done' => 'Nettsidedianogstikken er fullført',
    'websites-diagnostic.error' => 'Nettsidedianogstikken er fullført med feil',

    'install-php-extension.queue' => 'Installerer %%extensionName%%-pakken på PHP-behandleren %%phpHandlerName%%',
    'install-php-extension.done' => '%%extensionName%%-pakken ble installert på PHP-behandleren %%phpHandlerName%%',
    'install-php-extension.error' => 'Kunne ikke installere %%extensionName%%-pakken på PHP-behandleren %%phpHandlerName%%',
    'install-php-extension.step.validate' => 'Sjekker krav',
    'install-php-extension.step.dependencies' => 'Løser avhengigheter',
    'install-php-extension.step.process' => 'Installerer pakke',
    'install-php-extension.step.enable' => 'Aktiverer utvidelse',
    'install-php-extension.step.sync' => 'Synkroniserer nettsider',
    'install-php-extension.errorReason' => 'Listen over tilgjengelige pakker leveres av PECL. Den vanligste grunnen til mislykket installasjon er følgende:',
    'install-php-extension.errorReasonDependencies' => '- Pakken har eksterne avhengigheter til ytterligere bibliotek.',
    'install-php-extension.errorReasonRequirements' => '- Pakken oppfyller ikke installasjonskravene (OS, PHP-versjon osv.).',
    'install-php-extension.errorReasonOutdated' => '- Pakken er utdatert.',
    'install-php-extension.errorOutput' => 'For å identifisere årsaken til den mislykkede installasjonen, kan du undersøke verktøyets utdata.',

    'uninstall-php-extension.queue' => 'Avinstallerer %%extensionName%%-pakken fra PHP-behandleren %%phpHandlerName%%',
    'uninstall-php-extension.done' => '%%extensionName%%-pakken ble avinstallert fra PHP-behandleren %%phpHandlerName%%',
    'uninstall-php-extension.error' => 'Kunne ikke avinstallere %%extensionName%%-pakken fra PHP-behandleren %%phpHandlerName%%',
    'uninstall-php-extension.step.validate' => 'Sjekker krav',
    'uninstall-php-extension.step.process' => 'Avinstallerer pakke',
    'uninstall-php-extension.step.sync' => 'Synkroniserer nettsider',

    'upgrade-database-server.queue' => 'Oppgraderer databaseserveren',
    'upgrade-database-server.error' => 'Kunne ikke oppgradere databaseserveren',
    'upgrade-database-server.done' => 'Databaseserveren ble oppgradert',
    'upgrade-database-server.step.validate' => 'Kontrollerer systemet',
    'upgrade-database-server.step.dump' => 'Oppretter en dump av databaser',
    'upgrade-database-server.step.disableService' => 'Deaktiverer gammel systemtjeneste',
    'upgrade-database-server.step.configureRepo' => 'Konfigurerer ny katalog',
    'upgrade-database-server.step.upgradePackages' => 'Oppgraderer databaseserveren',
    'upgrade-database-server.step.updateConfiguration' => 'Oppdaterer serverkonfigurasjon',
    'upgrade-database-server.step.startService' => 'Starter ny systemtjeneste',
    'upgrade-database-server.step.upgradeTablesStructure' => 'Oppgraderer strukturen av alle tabeller',
    'upgrade-database-server.step.sync' => 'Synkroniserer systemkomponenter',
    'upgrade-database-server.step.validateInstallation' => 'Validerer installasjon',

    'update-spam-filter-individual-settings.queue' => 'Oppdaterer innstillinger for søppelpostfilter',
    'update-spam-filter-individual-settings.done' => 'Innstillinger for søppelpostfilter ble oppdatert',
    'update-spam-filter-individual-settings.error' => 'Kunne ikke oppdatere innstillinger for søppelpost',
    'update-spam-filter-individual-settings.mailNameError' => 'E-postadresse %%name%%: %%error%%',

    'update-default-cert.queue' => 'Oppdaterer standardsertifikatet',
    'update-default-cert.done' => 'Standardsertifikatet ble oppdatert.',
    'update-default-cert.error' => 'Oppdatering av standardsertifikat er fullført med feil.',
    'update-default-cert.step.updating' => 'Oppdaterer standardsertifikatet …',

    'smarthost-attach-server-domains.queue' => 'Legger til domener i smartverten',
    'smarthost-attach-server-domains.done' => 'Domenene ble lagt til i smartverten',
    'smarthost-attach-server-domains.doneWithErrors' => 'Domener ble lagt til i smartverten, men flere feil oppstod',
    'smarthost-attach-server-domains.error' => 'Kunne ikke legge til domener i smartverten',
];