CREATE TABLE "event_cache" (
  "id" INTEGER PRIMARY KEY NOT NULL,
  "type" varchar(30) NOT NULL,
  "class" varchar(30) NOT NULL,
  "obj_id" varchar(255) NOT NULL,
  "user" varchar(255) NOT NULL,
  "host" varchar(255) NOT NULL,
  "time" INTEGER NOT NULL
);
CREATE TABLE "history_size" (
  "uid" varchar(64) PRIMARY KEY NOT NULL,
  "size" INTEGER NOT NULL
);
CREATE TABLE "subscription" (
  "id" INTEGER PRIMARY KEY AUTOINCREMENT,
  "uid" varchar(64) NOT NULL,
  "type" varchar(30) NOT NULL,
  "class" varchar(30) NOT NULL,
  CONSTRAINT noduplicate UNIQUE ("uid","type","class") ON CONFLICT IGNORE
);
CREATE TABLE "device_uid" (
  "id" INTEGER PRIMARY KEY AUTOINCREMENT,
  "uid" varchar(64) NOT NULL,
  "server_tag" varchar(255),
  CONSTRAINT noduplicate UNIQUE ("uid") ON CONFLICT IGNORE
);
CREATE TABLE "push_subscription" (
  "id" INTEGER PRIMARY KEY AUTOINCREMENT,
  "uid" varchar(64) NOT NULL,
  "token" varchar(255) NOT NULL,
  "platform" varchar(20) NOT NULL,
  CONSTRAINT noduplicate UNIQUE ("uid","platform") ON CONFLICT REPLACE
);
CREATE TABLE "push_queue" (
  "id" INTEGER PRIMARY KEY AUTOINCREMENT,
  "receivers" TEXT NOT NULL,
  "event_data" TEXT NOT NULL,
  "status" INTEGER NOT NULL DEFAULT 0
);
CREATE TABLE "cp_access_descriptions" (
  "id" INTEGER PRIMARY KEY AUTOINCREMENT,
  "description" TEXT NOT NULL
);