from parallels.common import messages
from parallels.common.actions.base.common_action import CommonAction
from parallels.common import MigrationError


class SetDNSForwardingNotSupported(CommonAction):
	def get_description(self):
		return messages.CHECK_IF_SOURCE_PANEL_SUPPORTS_DNS_1

	def get_failure_message(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return messages.FAILED_CHECK_IF_SOURCE_PANEL_SUPPORTS_2

	def run(self, global_context):
		"""
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		raise MigrationError(
			messages.DNS_FORWARDING_IS_NOT_SUPPORTED_FOR_1)
