from contextlib import contextmanager


class TargetConnections(object):
	"""Base interface for target connections"""

	@property
	def main_node_ip(self):
		"""IP address of the main node"""
		raise NotImplementedError()

	@property
	def panel_admin_password(self):
		"""Panel's password of admin user"""
		raise NotImplementedError()

	@contextmanager
	def main_node_runner(self):
		"""Runner object (see common.run_command module) of the main node"""
		raise NotImplementedError()

	def check_connections(self):
		"""Check connections to all nodes"""
		raise NotImplementedError()

	@property
	def unix_session_dir(self):
		"""Session directory path to put temporary files on target Unix nodes 
		(including main node if it is based on Unix)
		"""
		raise NotImplementedError()

	@property
	def windows_session_dir(self):
		"""Session directory path to put temporary files on target Windows nodes 
		(including main node, if it is based on Windows)
		"""
		raise NotImplementedError()

	@property
	def is_windows(self):
		"""Return if main node is located on Windows server or not"""
		raise NotImplementedError()
