from parallels.common.utils.restore_hosting_utils import get_restore_hosting_utils


class TargetPanelBase(object):
	@property
	def name(self):
		raise NotImplementedError()

	def has_custom_subscriptions_feature(self):
		"""Whether subscriptions not assigned to plan are allowed

		:rtype: bool
		"""
		raise NotImplementedError()

	def has_admin_subscriptions_feature(self):
		"""Whether subscriptions assigned directly to admin are allowed

		:rtype: bool
		"""
		raise NotImplementedError()

	def has_reseller_subscriptions_feature(self):
		"""Whether subscriptions assigned directly to reseller are allowed

		:rtype: bool
		"""
		raise NotImplementedError()

	def has_dns_forwarding(self):
		"""Whether panel should support DNS forwarding migration feature

		:rtype: bool
		"""
		raise NotImplementedError()

	def is_test_dns_forwarding(self):
		"""Whether to test DNS forwarding feature on post-migration checks

		:rtype: bool
		"""
		return self.has_dns_forwarding()

	def is_transfer_resource_limits_by_default(self):
		"""Whether resource limits should be transferred by default

		:rtype: bool
		"""
		raise NotImplementedError()

	def get_subscription_nodes(self, global_context, subscription_target_services, subscription_name):
		raise NotImplementedError()

	def get_subscription_plesk_node(self, global_context, subscription_name):
		raise NotImplementedError()

	def use_source_plans(self):
		"""Return True if target panel supports migration of plans (service templates), False otherwise"""
		raise NotImplementedError()

	def get_service_nodes(self, conn):
		"""Return all service nodes of the panel

		Return list of service nodes to check services during service checks
		List consists of parallels.common.hosting_check.entity_source.service.TargetServiceInfo
		"""
		raise NotImplementedError()

	def get_connections(self, config):
		"""Get target panel connections"""
		raise NotImplementedError()

	def get_import_api(self, global_context):
		raise NotImplementedError()

	def get_converter_class(self):
		raise NotImplementedError()

	def get_hosting_check_messages_panel_id(self):
		raise NotImplementedError()

	@staticmethod
	def extend_workflow(workflow):
		"""Extend shared hosting workflow with target-panel specific actions

		By default does nothing, override in child target panels.

		:type workflow parallels.common.workflow.base_workflow.BaseWorkflow
		"""
		pass

	def check_version(self, global_context):
		"""Check that target panel version is ok for migration purposes. Raise MigrationError othewise.

		Raised exception should contain information about supported versions for migration.
		By default, does nothing, override when adding new panel.

		:type global_context: parallels.common.global_context.GlobalMigrationContext
		:rtype: None
		"""
		pass

	@staticmethod
	def get_restore_hosting_utils(plesk_server):
		return get_restore_hosting_utils(plesk_server)
