import os
import zipfile


def zip_directory(directory, archive):
	"""Pack directory contents to zip file

	For example if we have directory '/root/test' passed as the first argument, which contains files:
	/root/test/a.txt
	/root/test/b/c.txt

	Then we will get zip file with contents:
	a.txt
	b/c.txt

	:param str directory: name of a directory to pack contents of
	:param str archive: name of ZIP file to pack contents to
	:rtype: None
	"""
	with zipfile.ZipFile(archive, 'w') as zfp:
		for root, dirs, files in os.walk(directory):
			for filename in files:
				zfp.write(
					os.path.join(root, filename),
					os.path.relpath(os.path.join(root, filename), directory)
				)