from parallels.common.utils.config_utils import ConfigSection
from parallels.common.migrator_config import read_ssh_auth
from parallels.common.migrator_config import read_copy_mail_content_settings

# This is the ID used for naming config file sections and migration dump files
PANEL_ID = 'confixx'

class ConfixxConfig(object):
	def __init__(self, config):
		self.ip = config['ip']
		self.id = PANEL_ID
		self.is_windows = False
		self.ssh_auth = read_ssh_auth(config)
		self.pmm_agent_name = "ConfixxX"
		self.agent_script_name = 'Confixx.pl'
		self.session_dir = config.get('session-dir', '/tmp')
		self.mail_settings = read_copy_mail_content_settings(
			config, is_windows=False
		)

def init(config):
	confixx_section = ConfigSection(config, PANEL_ID)
	return ConfixxConfig(confixx_section)

