from parallels.common.global_context import GlobalMigrationContext
from parallels.common.global_context import SourceInfo
from parallels.common.plesk_backup import plesk_backup_xml
from parallels.utils import cached


class CustomPanelGlobalMigrationContext(GlobalMigrationContext):
	def __init__(self):
		super(CustomPanelGlobalMigrationContext, self).__init__()
		self.source_has_dns_forwarding = False

	def get_source_plesks_info(self):
		return self.get_sources_info()

	@property
	def _sources_info(self):
		"""Information about source servers we have

		:rtype list[parallels.common.global_context.SourceInfo]
		"""
		return [
			SourceBackupInfo(self, source_id, backup_path)
			for source_id, backup_path in self.conn.get_source_backup_paths().iteritems()
		]


class SourceBackupInfo(SourceInfo):
	def __init__(self, global_context, source_id, backup_path):
		super(SourceBackupInfo, self).__init__(source_id)
		self._global_context = global_context
		self._backup_path = backup_path
		self._ip = None

	@cached
	def load_raw_backup(self):
		return plesk_backup_xml.load_backup(self._backup_path, self._global_context.migration_list_data)

	@property
	def is_windows(self):
		return self.load_raw_backup().is_windows