from parallels.common import checking
from parallels.common.converter.business_objects.clients import ClientsConverter
from parallels.common.target_data_model import Model
from parallels.expand_migrator.converter.plesk.client import ExpandToPleskClientsConverter
from parallels.expand_migrator.converter.plesk.subscription import ExpandToPleskSubscriptionConverter
from parallels.target_panel_plesk.converter.ip_mapping import IPMapper
from parallels.utils import group_by_id


class ExpandToPleskClientsAndSubscriptionsConverter(object):
	@staticmethod
	def convert(global_context, converted_resellers, expand_objects, report):
		"""Convert clients and subscriptions

		:type global_context: parallels.expand_migrator.global_context.ExpandGlobalMigrationContext
		:type converted_resellers: list[parallels.common.target_data_model.Reseller]
		:type expand_objects: parallels.expand_migrator.expand_data.model.Model
		:type report: parallels.common.checking.Report

		:rtype: parallels.common.target_data_model.Model
		"""
		resellers = group_by_id(converted_resellers, lambda r: r.login)
		target_model = Model(plans={}, resellers=resellers, clients={})
		clients_converter = ExpandToPleskClientsConverter()

		admin_fake_client = ClientsConverter.create_fake_client(None)
		target_model.clients[None] = admin_fake_client
		converted_clients = clients_converter.convert_clients(
			global_context.get_source_plesks_info(),
			expand_objects,
			global_context.target_existing_objects.customers,
			global_context.migration_list_data.customers_mapping,
			report, global_context.password_holder
		)

		for reseller in target_model.resellers.values():
			reseller_fake_client = ClientsConverter.create_fake_client(reseller.login)
			reseller.clients.append(reseller_fake_client)

		ClientsConverter().assign_clients_to_resellers(
			target_model.clients, target_model.resellers.values(), converted_clients,
			global_context.migration_list_data.customers_mapping, report
		)

		ip_mapper = IPMapper(global_context.target_existing_objects)
		ip_mapper.set_ip_mapping(global_context.ip_mapping)
		subscriptions_converter = ExpandToPleskSubscriptionConverter(ip_mapper)
		plain_report = checking.PlainReport(report, *global_context.migrator._extract_source_objects_info())

		sources_info = global_context.get_source_plesks_info()
		subscriptions_converter.convert(
			sources_info,
			global_context.target_existing_objects,
			global_context.migration_list_data.subscriptions_mapping,
			target_model, plain_report
		)

		return target_model