from parallels.expand_migrator.actions.fetch.fetch_expand_data import FetchExpandData
from parallels.expand_migrator.actions.hosting_settings.restore_centralized_mail_hosting_settings import \
	RestoreCentralizedMailHostingSettings
from parallels.plesks_migrator.workflow import FromPleskWorkflow

from parallels.expand_migrator.actions.hosting_settings.convert.dns \
	import ExpandDNS
from parallels.expand_migrator.actions.fetch.fetch_backup_cmail import \
	FetchCentralizedMailBackupAction
from parallels.common.actions.backup.create_converted \
	import CreateConverted
from parallels.common.actions.backup.save_converted \
	import SaveConverted
from parallels.common.actions.backup.remove_content \
	import RemoveContent
from parallels.common.actions.hosting_settings.convert.remap_databases \
	import RemapDatabases
from parallels.common.actions.hosting_settings.convert.remove_subscription_to_plan_relation \
	import RemoveSubscriptionToPlanRelation
from parallels.common.actions.hosting_settings.convert.remove_subscription_default_db_server \
	import RemoveSubscriptionDefaultDBServer
from parallels.common.actions.hosting_settings.convert.remove_subscription_limits_and_permissions \
	import RemoveSubscriptionLimitsAndPermissions
from parallels.common.actions.hosting_settings.convert.remove_maillists \
	import RemoveMaillists
from parallels.common.actions.hosting_settings.convert.remove_domain_keys \
	import RemoveDomainKeys
from parallels.common.actions.hosting_settings.convert.change_webmail_to_horde \
	import ChangeWebmailToHorde
from parallels.common.actions.hosting_settings.convert.remove_disabled_mailsystem_without_resource \
	import RemoveDisabledMailsystemWithoutResource
from parallels.common.actions.hosting_settings.convert.change_catch_all_redirect \
	import ChangeCatchAllRedirect
from parallels.common.actions.hosting_settings.convert.change_subscription_ips \
	import ChangeSubscriptionIPs
from parallels.common.actions.hosting_settings.convert.remove_subscription_external_id \
	import RemoveSubscriptionExternalId
from parallels.common.actions.hosting_settings.convert.change_sysuser_password \
	import ChangeSysuserPassword
from parallels.common.actions.hosting_settings.convert.change_smartermail_password \
	import ChangeSmartermailPassword
from parallels.common.actions.hosting_settings.convert.remove_smartermail_unsupported_features \
	import RemoveSmartermailUnsupportedFeatures
from parallels.common.actions.hosting_settings.convert.change_sysuser_login \
	import ChangeSysuserLogin
from parallels.common.actions.hosting_settings.check.catch_all_redirect \
	import CatchAllRedirect
from parallels.common.actions.hosting_settings.check.email_empty_password \
	import EmailEmptyPassword
from parallels.common.actions.hosting_settings.check.maillists \
	import Maillists

from parallels.expand_migrator.utils.backup_adapter \
	import CentralizedMailBackup
from parallels.expand_migrator.utils.backup_adapter \
	import CentralizedMailBackupRaw


class FromExpandWorkflow(FromPleskWorkflow):
	def __init__(self):
		super(FromExpandWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-expand', FetchExpandData()
		)
		self.get_shared_action('fetch-source').insert_action(
			'fetch-centralized-mail', FetchCentralizedMailBackupAction()
		)
		self.get_shared_action('fetch-source-shallow').insert_action(
			'fetch-expand', FetchExpandData()
		)
		
		convert_hosting = self.get_shared_action('convert-hosting')
		convert_hosting.replace(
			'convert-dns', ExpandDNS()
		)
		cmail_backup = CentralizedMailBackup()
		convert_hosting.insert_actions([
			('cmail-create-converted-backup', CreateConverted(cmail_backup)),
			('cmail-remap-databases', RemapDatabases(cmail_backup)),
			('cmail-remove-subscription-to-plan-relation', RemoveSubscriptionToPlanRelation(cmail_backup)),
			('cmail-remove-subscription-default-db-server', RemoveSubscriptionDefaultDBServer(cmail_backup)),
			('cmail-remove-subscription-limits-and-permissions', RemoveSubscriptionLimitsAndPermissions(cmail_backup)),
			('cmail-remove-maillists', RemoveMaillists(cmail_backup)),
			('cmail-remove-domain-keys', RemoveDomainKeys(cmail_backup)),
			('cmail-change-webmail-to-horde', ChangeWebmailToHorde(cmail_backup)),
			('cmail-remove-disabled-mailsystem-without-resource', RemoveDisabledMailsystemWithoutResource(cmail_backup)),
			('cmail-change-catch-all-redirect', ChangeCatchAllRedirect(cmail_backup)),
			('cmail-change-subscription-ips', ChangeSubscriptionIPs(cmail_backup)),
			('cmail-remove-subscription-external-id', RemoveSubscriptionExternalId(cmail_backup)),
			('cmail-change-sysuser-password', ChangeSysuserPassword(cmail_backup)),
			('cmail-change-smartermail-password', ChangeSmartermailPassword(cmail_backup)),
			('cmail-remove-smartermail-unsupported-features', RemoveSmartermailUnsupportedFeatures(cmail_backup)),
			('cmail-restore-sysuser-logins', ChangeSysuserLogin(cmail_backup)),
			('cmail-backup-remove-content', RemoveContent(cmail_backup)),
			('cmail-check-catch-all-redirect', CatchAllRedirect(cmail_backup)),
			('cmail-check-email-empty-password', EmailEmptyPassword(cmail_backup)),
			('cmail-check-maillists', Maillists(cmail_backup)),
		], before='cleanup-backup-xml-for-ppa')
		convert_hosting.insert_action(
			'cmail-save-backup', SaveConverted(cmail_backup),
			after='cleanup-backup-xml-for-ppa'
		)

		self.get_path('check/check-data').insert_action(
			'check-cmail-catch-all-redirect',
			CatchAllRedirect(CentralizedMailBackupRaw())
		)
		self.get_path('check/check-data').insert_action(
			'check-,mail-email-empty-password',
			EmailEmptyPassword(CentralizedMailBackupRaw())
		)
		self.get_path('check/check-data').insert_action(
			'check-cmail-maillists',
			Maillists(CentralizedMailBackupRaw())
		)

		self.get_path('transfer-accounts/restore-hosting').insert_action(
			'restore-centralized-mail-hosting-settings',
			RestoreCentralizedMailHostingSettings(),
			before='restore-hosting-settings'
		)
