from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import DNSExternalIssueType

MESSAGES = {}

MESSAGES[DNSExternalIssueType.NOT_REGISTERED] = format_message("""
External DNS servers have no information about the domain. It is possible that the domain name is not registered. Checking by external DNS will be skipped.
""")

MESSAGES[DNSExternalIssueType.SERVED_BY_UNKNOWN_DNS_SERVERS] = format_message("""
The domain is served by DNS servers for which IP addresses could not be determined: {dns_servers_list}. Checking by external DNS will be skipped.
""")

MESSAGES[DNSExternalIssueType.DIFFERENT_RECORDS] = format_message("""
The external DNS server at {external_dns_server_ip} returned DNS records different from those returned by the target DNS server at {target_dns_server_ip}. {difference}
""")

MESSAGES[DNSExternalIssueType.NOT_SERVED_BY_SOURCE_OR_TARGET] = format_message("""
This domain is not served by the target DNS servers and source panel's DNS servers. Checking by external DNS servers will be skipped.
""")

MESSAGES[DNSExternalIssueType.DNS_SERVER_TIMEOUT] = format_message("""
The DNS query to the external DNS server at {external_dns_server_ip} was timed out.
""")

MESSAGES[DNSExternalIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred: {reason}
Unable to check whether the DNS zone is resolved by the external DNS server at {external_dns_server_ip}
""")

MESSAGES['dns_external_log_checking'] = format_message("""
Checking the DNS records of the domain through the external DNS server at {server_ip}
""")

MESSAGES['dns_external_difference_full'] = format_message("""
Here is the difference:
{difference}
""")

MESSAGES['dns_external_difference_example'] = format_message("""
Here is an example of differing records:
{difference}
All information about the differences is saved to the file {filename}
""")

MESSAGES['dns_external_difference_file'] = format_message("""
The external DNS server at {external_dns_server_ip} returned DNS records different from those returned by the target DNS server at {target_dns_server_ip}:
{difference}
""")
