from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import FTPAuthIssueType

MESSAGES = {}

MESSAGES[FTPAuthIssueType.WEB_IP_NOT_DEFINED] = format_message("""
The domain does not have a web service IP address. FTP access verification will be skipped.
""")

MESSAGES[FTPAuthIssueType.CHECK_FAILED] = format_message("""
Failed to log in over FTP to the web server at {server_ip} as the user {login}: {reason}
""")

MESSAGES[FTPAuthIssueType.INACTIVE_USER_CAN_CONNECT] = format_message("""
Logged over FTP to the web server at {server_ip} as the inactive user {login}
""")

MESSAGES[FTPAuthIssueType.ENCRYPTED_PASSWORD] = format_message("""
Cannot check FTP access for user '{login}' to server '{server_ip}'. User password is encrypted.
""")

MESSAGES[FTPAuthIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred while checking if it is possible to log in over FTP to the web server at {server_ip} as the user {login}: {reason}
""")

MESSAGES['ftp_log_checking'] = format_message("""
Check login by FTP for user '{user}' to server '{server_ip}'
""")

