from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import RDPAuthIssueType

MESSAGES = {}

MESSAGES[RDPAuthIssueType.ACTIVE_USER_NOT_CONFIGURED] = format_message("""
Windows user '{login}' at server '{server_ip}' is not configured on the system
to have RPD access: {reason}
""")

MESSAGES[RDPAuthIssueType.INACTIVE_USER_CONFIGURED] = format_message("""
Windows user {login} at server {server_ip} that should not have RDP access,
actually has RDP access configured: {reason}
""")

MESSAGES[RDPAuthIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred while checking if it is possible to log in over
RDP to the web server at {server_ip} as the user {login}: {error_message}
""")

MESSAGES['rdp_auth_user_not_in_group'] = format_message("""
User does not belong to "Remote Desktop Users" group
""")

MESSAGES['rdp_auth_user_in_group'] = format_message("""
User belongs to "Remote Desktop Users" group
""")

MESSAGES['rdp_log_checking'] = format_message("""
Check login by RDP for user '{user}' to server '{server_ip}'
""")

MESSAGES[RDPAuthIssueType.WEB_IP_NOT_DEFINED] = format_message("""
The domain does not have a web service IP address. RDP access verification will be skipped.
""")
