from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import SSHAuthIssueType

MESSAGES = {}

MESSAGES[SSHAuthIssueType.CHECK_FAILED] = format_message("""
Failed to log in over SSH to the web server at {server_ip} as the user
{login}: {error_message}
""")

MESSAGES[SSHAuthIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred while checking if it is possible to log in over
SSH to the web server at {server_ip} as the user {login}: {error_message}
""")

MESSAGES[SSHAuthIssueType.INACTIVE_USER_CAN_CONNECT] = format_message("""
Logged in over SSH to the web server at {server_ip} as the inactive user
{login}
""")

MESSAGES[SSHAuthIssueType.ENCRYPTED_PASSWORD] = format_message("""
Cannot check SSH access for user '{login}' to server '{server_ip}'. User password is encrypted.
""")

MESSAGES[SSHAuthIssueType.INTERNAL_ERROR] = format_message("""
An internal error occurred while checking if it is possible to log in over
SSH to the web server at {server_ip} as the inactive user {login}:
{error_message}
""")

MESSAGES['ssh_log_checking'] = format_message("""
Check login by SSH for user '{user}' to server '{server_ip}'
""")
