from parallels.hosting_check.messages.utils import format_message
from parallels.hosting_check import FTPAuthIssueType

MESSAGES = {}

MESSAGES[FTPAuthIssueType.WEB_IP_NOT_DEFINED] = format_message("""
Make sure that:
1. The webspace is present in PPA.
2. There are no failed tasks related to the webspace in the PPA task manager.
3. The Web service for webspace is enabled in PPA.
""")

MESSAGES[FTPAuthIssueType.CHECK_FAILED] = format_message("""
Make sure that:
1. The proper username and password are specified for the subscription in PPA.
2. The FTP service is operating properly on the PPA web service node.

Ignore this warning if you have changed login or password of the system user after transfer.
""")

MESSAGES[FTPAuthIssueType.INTERNAL_ERROR] = format_message("""
u"Check whether it is possible to log in to the PPA web server over FTP."
""")
