from parallels.hosting_check import ServiceInfo, ProcessInfo

#LinuxWebServiceFull includes service which are stopped by default on Plesk and PPA.
LinuxWebServiceFull = ServiceInfo(type='web', processes=[
		ProcessInfo(names=['nginx', 'httpd'], ports=[80, 443])
	], is_windows=False, check_connection=True)
LinuxWebServiceBase = ServiceInfo(type='web', processes=[
		ProcessInfo(names=['httpd', 'apache2'], ports=[80, 443])
	], is_windows=False, check_connection=True)
LinuxFTPService = ServiceInfo(type='ftp', processes=[
		ProcessInfo(names=['xinetd'], ports=[21])
	], is_windows=False, check_connection=True)
LinuxDNSService = ServiceInfo(type='dns', processes=[
		ProcessInfo(names=['named'], ports=[53])
	], is_windows=False, check_connection=True)
#LinuxMailServiceFull includes ports which are disabled by default on Plesk and PPA.
LinuxMailServiceFull = ServiceInfo(type='mail', processes=[
		ProcessInfo(names=['couriertcpd'], ports=[110, 143, 993, 995]),
		ProcessInfo(names=['master', 'qmail-send'], ports=[25, 465, 587]),
		ProcessInfo(names=['xinetd'], ports=[106])
	], is_windows=False, check_connection=True)
LinuxMailServiceBase = ServiceInfo(type='mail', processes=[
		ProcessInfo(names=['couriertcpd', 'dovecot'], ports=[110, 143]),
		ProcessInfo(names=['master', 'qmail-send'], ports=[25])
	], is_windows=False, check_connection=True)
LinuxMysqlService = ServiceInfo(type='mysql', processes=[
		ProcessInfo(names=['mysqld'], ports=[3306])
	], is_windows=False, check_connection=False)
LinuxPostgresqlService = ServiceInfo(type='postgresql', processes=[
		ProcessInfo(names=['postmaster', 'postgres'], ports=[5432])
	], is_windows=False, check_connection=False)
LinuxPleskService = ServiceInfo(type='plesk', processes=[
		ProcessInfo(names=['sw-cp-server'], ports=[8443])
	], is_windows=False, check_connection=True)

# WindowsWebServiceFull includes ports which are disabled by default on Plesk and PPA.
WindowsWebServiceFull = ServiceInfo(type='web', processes=[
		ProcessInfo(names=['w3wp', 'System'], ports=[80, 443])
	], is_windows=True, check_connection=True)
WindowsWebServiceBase = ServiceInfo(type='web', processes=[
		ProcessInfo(names=['w3wp', 'System'], ports=[80])
	], is_windows=True, check_connection=True)
# WindowsFTPServiceFull includes ports which are disabled by default on Plesk and PPA.
WindowsFTPServiceFull = ServiceInfo(type='ftp', processes=[
		ProcessInfo(names=['svchost'], ports=[21])
	], is_windows=True, check_connection=True)
WindowsFTPServiceBase = ServiceInfo(type='ftp', processes=[
		ProcessInfo(names=['svchost'], ports=[])
	], is_windows=True, check_connection=True)
WindowsDNSService = ServiceInfo(type='dns', processes=[
		ProcessInfo(names=['dns', 'named'], ports=[53])
	], is_windows=True, check_connection=True)
# WindowsMailServiceFull includes ports which are disabled by default on Plesk and PPA.
WindowsMailServiceFull = ServiceInfo(type='mail', processes=[
		ProcessInfo(names=['MEPOPS', 'MEPIMAPS', 'MailService', 'pop3', 'im'], ports=[110, 143, 993, 995]),
		ProcessInfo(names=['MESMTPC', 'MailService', 'smtp'], ports=[25, 465, 587]),
		ProcessInfo(names=['PopPassD'], ports=[106])
	],is_windows=True, check_connection=True)
WindowsMailServiceBase = ServiceInfo(type='mail', processes=[
		ProcessInfo(names=['MEPOPS', 'MEPIMAPS', 'MailService', 'pop3', 'im'], ports=[110, 143]),
		ProcessInfo(names=['MESMTPC', 'MailService', 'smtp'], ports=[25])
	],is_windows=True, check_connection=True)
WindowsMysqlService = ServiceInfo(type='mysql', processes=[
		ProcessInfo(names=['mysqld'], ports=[3306])
	], is_windows=True, check_connection=False)
# WindowsMssqlServiceFull includes ports which are disabled by default on Plesk and PPA.
WindowsMssqlServiceFull = ServiceInfo(type='mssql', processes=[
		ProcessInfo(names=['sqlservr'], ports=[1433])
	], is_windows=True, check_connection=False)
WindowsMssqlServiceBase = ServiceInfo(type='mssql', processes=[
		ProcessInfo(names=['sqlservr'], ports=[])
	], is_windows=True, check_connection=False)
WindowsPleskService = ServiceInfo(type='plesk', processes=[
		ProcessInfo(names=['w3wp', 'System'], ports=[8443])
	], is_windows=True, check_connection=True)
