
def list_security_files(subscription, include_subdomains=False):
	security_files = [u".Security"]
	for webuser in subscription.raw_backup.get_phosting_webuser_names():
		security_files.append(u".Web.%s.Security" % (webuser,))

	if include_subdomains:
		for site in subscription.raw_backup.iter_sites():
			if site.parent_domain_name is not None:
				security_files.append(
					ur'subdomains\%s\.Security' % (
						site.short_name.encode('idna')
					)
				)

	return security_files
