# Copyright 1999-2012. Parallels IP Holdings GmbH. All Rights Reserved.

package StopWatchPacker;

use strict;
eval{require warnings;1;};

use StopWatch;
use Packer;

use vars qw|@ISA $AUTOLOAD|;

sub new {
  my $self = {};
  bless( $self, shift );
  $self->_init(@_);
  return $self;
}

sub _init {
  my $self = shift;
  $self->{packer} = Packer->new(@_);
  $self->{packer}->startCollectStorageStatistics();
  $self->{stopWatch} = StopWatch->new();
  $self->{statistics}->{totalTime} = 0;
}

sub AUTOLOAD {
  my $self = shift or return;
  my $type = ref($self) or die "$self is not an object";

  my $method = $StopWatchPacker::AUTOLOAD;
  $method =~ s/.*:://;

  $self->{stopWatch}->createMarker("packer");

  my $ret = $self->{packer}->$method(@_);

  $self->{statistics}->{totalTime} += $self->{stopWatch}->getDiff("packer");
  $self->{stopWatch}->releaseMarker("packer");

  return $ret;
}

sub DESTROY { }

sub getStatistics {
  my $self = shift(@_);

  $self->{statistics}->{tarTime} = $self->{packer}->getStorageStatistics()->{packTime};

  return $self->{statistics};
}

1;