from parallels.common.actions.base.compound_action import CompoundAction
from parallels.common.actions.hosting_settings.remove_imported_backups import RemoveImportedBackups
from parallels.common.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.common.actions.base.legacy_action \
	import LegacyAction
from parallels.common.actions.base.entry_point_action \
	import EntryPointAction
from parallels.plesks_migrator.actions.aps.import_backups_for_aps_restoration import ImportBackupsForApsRestore

from parallels.plesks_migrator.actions.content.web.copy_unix_content \
	import CopyUnixWebContent
from parallels.common.actions.content.web.fix_unix_vhost_permissions \
	import FixUnixVhostPermissions
from parallels.plesks_migrator.actions.content.web.fix_unix_vhost_structure \
	import FixUnixVhostStructure
from parallels.plesks_migrator.actions.content.web.fix_unix_permissions_old_plesk \
	import FixUnixPermissionsOldPlesks
from parallels.plesks_migrator.actions.content.web.fix_unix_permissions \
	import FixUnixPermissions
from parallels.plesks_migrator.actions.content.web.copy_windows_content \
	import CopyWindowsWebContent
from parallels.plesks_migrator.actions.content.web.fix_security_files \
	import FixSecurityFiles
from parallels.plesks_migrator.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.plesks_migrator.actions.aps.restore_applications \
	import RestoreApplications as ActionApsRestoreApplications
from parallels.plesks_migrator.actions.content.web.fix_permissions_for_clients_iis_pools \
	import FixPermissionsForClientsIISPools
from parallels.plesks_migrator.actions.content.web.fix_permissions_for_iis6_domains \
	import FixPermissionsForIIS6Domains
from parallels.plesks_migrator.actions.fetch.fetch_applications \
	import FetchApplicationsAction
from parallels.plesks_migrator.actions.fetch.fetch_shallow_backup import FetchShallowBackupAction
from parallels.plesks_migrator.actions.fetch.merge_applications \
	import MergeApplications as FetchMergeApplicationsAction
from parallels.plesks_migrator.actions.fetch.fetch_backup import FetchBackupAction
from parallels.plesks_migrator.actions.content.web.restore_dedicated_application_pool \
	import RestoreDedicatedApplicationPool
from parallels.plesks_migrator.actions.aps.transfer_packages \
	import TransferPackages as ActionApsTransferPackages
from parallels.plesks_migrator.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.plesks_migrator.actions.hosting_settings.transfer_error_documents \
	import TransferErrorDocuments
from parallels.plesks_migrator.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.common.actions.dns.forwarding.check_target_panel_supports_forwarding \
	import CheckTargetPanelSupportsForwarding
from parallels.plesks_migrator.actions.wpb.transfer \
	import Transfer as TransferWPBSites


class FromPleskWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromPleskWorkflow, self).__init__()

		self.get_shared_action('copy-web-files').insert_action(
			'copy-files-linux', CopyUnixWebContent()
		)
		self.get_shared_action('copy-web-files').insert_action(
			'copy-files-windows', CopyWindowsWebContent()
		)

		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-permissions', FixUnixVhostPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-unix-vhost-structure', FixUnixVhostStructure()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions-old-plesks', FixUnixPermissionsOldPlesks()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixUnixPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-security-files', FixSecurityFiles()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'reset-permissions', ResetPermissions()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions-for-client-iis-pools', 
			FixPermissionsForClientsIISPools()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions-for-iis6-domains', 
			FixPermissionsForIIS6Domains()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-wpb-sites', TransferWPBSites()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'restore-aps', ActionApsRestoreApplications()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-error-documents', TransferErrorDocuments()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)

		self.get_shared_action('fetch-source').insert_action(
			'fetch-configuration', FetchBackupAction()
		)
		self.get_shared_action('fetch-source').insert_action(
			'fetch-applications', FetchApplicationsAction()
		)
		self.get_shared_action('fetch-source').insert_action(
			'merge-applications', FetchMergeApplicationsAction()
		)
		self.replace_shared_action('fetch-source-shallow', CompoundAction())
		self.get_shared_action('fetch-source-shallow').insert_action(
			'fetch-shallow-backup', FetchShallowBackupAction()
		)

		self.get_path('transfer-accounts/restore-hosting').insert_action(
			'restore-dedicated-app-pool', RestoreDedicatedApplicationPool()
		)
		self.get_path('transfer-accounts/restore-hosting').insert_action(
			'transfer-aps-packages', ActionApsTransferPackages(),
			after='windows-refresh-components'
		)

		# Import backups for APS applications restoration when running
		# 'copy-content' and 'copy-web-content' as separate actions
		self.get_path('copy-content').insert_action(
			'import-backups', ImportBackupsForApsRestore(),
			before='copy-content'
		)
		self.get_path('copy-content').insert_action(
			'remove-imported-backups', RemoveImportedBackups(),
			after='copy-content'
		)
		self.get_path('copy-web-content').insert_action(
			'import-backups', ImportBackupsForApsRestore(),
			before='copy-web-content'
		)
		self.get_path('copy-web-content').insert_action(
			'remove-imported-backups', RemoveImportedBackups(),
			after='copy-web-content'
		)

		self.replace_entry_point('set-dns-forwarding', EntryPointAction())
		self.replace_entry_point('undo-dns-forwarding', EntryPointAction())

		self.get_path('set-dns-forwarding').insert_action(
			'check-target-panel-supports-forwarding', CheckTargetPanelSupportsForwarding()
		)
		self.get_path('set-dns-forwarding').insert_actions(
			self.get_shared_action('post-migration-prepare').get_all_actions()
		)
		self.get_path('set-dns-forwarding').insert_action(
			'forward-dns', LegacyAction(
				description='Forward DNS',
				function=lambda ctx: ctx.migrator._forward_dns(ctx.dns_forwarding_report)
			)
		)
		self.get_path('set-dns-forwarding').insert_action(
			'cleanup',
			self.get_shared_action('cleanup')
		)
		self.get_path('set-dns-forwarding').insert_action(
			'print-report', LegacyAction(
				description='Print DNS forwarding report',
				function=lambda ctx: ctx.migrator._print_dns_forwarding_report(ctx.dns_forwarding_report)
			)
		)
		self.get_path('set-dns-forwarding').register_overall_shutdown('cleanup')

		self.get_path('undo-dns-forwarding').insert_action(
			'check-target-panel-supports-forwarding', CheckTargetPanelSupportsForwarding()
		)
		self.get_path('undo-dns-forwarding').insert_actions(
			self.get_shared_action('post-migration-prepare').get_all_actions()
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'forward-dns', LegacyAction(
				description='Undo DNS forwarding',
				function=lambda ctx: ctx.migrator._undo_dns_forwarding(ctx.dns_forwarding_report)
			)
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'cleanup',
			self.get_shared_action('cleanup')
		)
		self.get_path('undo-dns-forwarding').insert_action(
			'print-report', LegacyAction(
				description='Print DNS forwarding report',
				function=lambda ctx: ctx.migrator._print_dns_forwarding_report(ctx.dns_forwarding_report)
			)
		)
		self.get_path('undo-dns-forwarding').register_overall_shutdown('cleanup')

		# Set up low DNS timings
		self.replace_entry_point('set-low-dns-timings', EntryPointAction())
		self.get_path('set-low-dns-timings').insert_action(
			'set-low-dns-timings', LegacyAction(
				description="Set low DNS timings",
				function=lambda ctx: ctx.migrator.set_low_dns_timings(ctx.options)
			)
		)

		# Transfer APS packages
		self.add_entry_point('transfer-aps-packages', EntryPointAction())
		self.get_path('transfer-aps-packages').insert_actions(
			self.get_shared_action('post-migration-prepare').get_all_actions()
		)
		self.get_path('transfer-aps-packages').insert_action(
			'transfer-aps-packages', ActionApsTransferPackages()
		)
		self.get_path('transfer-aps-packages').insert_action(
			'cleanup', self.get_shared_action('cleanup')
		)
		self.get_path('transfer-aps-packages').register_overall_shutdown('cleanup')

		# Restore APS applications
		self.add_entry_point('restore-aps-applications', EntryPointAction())
		self.get_path('restore-aps-applications').insert_actions(
			self.get_shared_action('post-migration-prepare').get_all_actions()
		)
		self.get_path('restore-aps-applications').insert_action(
			'import-backups', ImportBackupsForApsRestore()
		)
		self.get_path('restore-aps-applications').insert_action(
			'restore-applications', ActionApsRestoreApplications()
		)
		self.get_path('restore-aps-applications').insert_action(
			'cleanup', self.get_shared_action('cleanup')
		)
		self.get_path('restore-aps-applications').register_overall_shutdown('cleanup')