from parallels.common.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.common.actions.base.legacy_action \
	import LegacyAction

from parallels.ppcpl_migrator.actions.content.web.copy_unix_content \
	import PPCPLCopyUnixWebContent
from parallels.ppcpl_migrator.actions.content.web.fix_permissions \
	import FixPermissions

class FromPPCPLWorkflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromPPCPLWorkflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description='Fetch data from source PPCPL',
				function=lambda ctx: ctx.migrator._fetch_source(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		self.get_shared_action('copy-web-files').insert_action(
			'copy-files', PPCPLCopyUnixWebContent()
		)
		self.get_shared_action('sync-web-content-assets').insert_action(
			'fix-permissions', FixPermissions()
		)
		self.get_path('check/check-data').insert_action(
			'check-additional', LegacyAction(
				description='Check additional',
				function=lambda ctx: ctx.migrator._check_additional(
					ctx.pre_check_report, ctx.target_existing_objects
				)
			)
		)
