from parallels.plesks_migrator.actions.dns.forwarding.add_source_dns_acl import AddSourceToTargetDNSACL
from parallels.plesks_migrator.actions.dns.forwarding.add_source_dns_axfr import AddSourceToTargetDNSAXFR
from parallels.source_target_combination.combination import SourceTargetCombination


class ExpandToPleskCombination(SourceTargetCombination):
	@staticmethod
	def extend_workflow(workflow):
		"""
		Extend workflow with actions, actual for combination of specific source and target panels
		:type workflow parallels.common.workflow.base_workflow.BaseWorkflow
		:rtype None
		"""
		# DNS forwarding
		workflow.get_path('set-dns-forwarding').insert_action(
			'add-source-to-target-dns-acl', AddSourceToTargetDNSACL(), before='forward-dns'
		)
		workflow.get_path('set-dns-forwarding').insert_action(
			'add-source-to-target-dns-axfr', AddSourceToTargetDNSAXFR(), before='forward-dns'
		)