from parallels.plesks_migrator.actions.dns.forwarding.add_source_dns_acl import AddSourceToTargetDNSACL
from parallels.plesks_migrator.actions.dns.forwarding.add_source_dns_axfr import AddSourceToTargetDNSAXFR
from parallels.source_target_combination.combination import SourceTargetCombination
from parallels.source_target_combination.\
	plesk_to_plesk.actions.fetch.fetch_capability_info import FetchCapabilityInfoAction
from parallels.source_target_combination.\
	plesk_to_plesk.actions.hosting_settings.check.check_capability import CheckCapabilityAction


class PleskToPleskCombination(SourceTargetCombination):
	@staticmethod
	def extend_workflow(workflow):
		"""
		Extend workflow with actions, actual for combination of specific source and target panels
		:type workflow parallels.common.workflow.base_workflow.BaseWorkflow
		:rtype None
		"""
		# Capability checks
		workflow.get_shared_action('fetch-source').insert_action(
			'fetch-capability-info', FetchCapabilityInfoAction()
		)
		workflow.get_path('check/check-data').insert_action(
			'check-capability',
			CheckCapabilityAction(),
			after='check-maillists'
		)
		workflow.get_shared_action('convert-hosting').insert_action('check-capability', CheckCapabilityAction())

		# DNS forwarding
		workflow.get_path('set-dns-forwarding').insert_action(
			'add-source-to-target-dns-acl', AddSourceToTargetDNSACL(), before='forward-dns'
		)
		workflow.get_path('set-dns-forwarding').insert_action(
			'add-source-to-target-dns-axfr', AddSourceToTargetDNSAXFR(), before='forward-dns'
		)