from contextlib import contextmanager
from parallels.plesk_api.operator import IpAddressInfo

from parallels.target_panel_plesk.connections.target_server import PleskTargetServer
from parallels.utils import cached


class PPAMoveWebspacesTargetServer(PleskTargetServer):

	def description(self):
		return 'target PPA web service node'

	@contextmanager
	def runner(self):
		with self.conn.main_node_runner() as runner:
			yield runner

	@property
	def plesk_version(self):
		return 12, 1

	@cached
	def get_all_ips(self, global_context):
		ips = []
		if global_context.webspace_ipv4 is not None:
			ips.append(IpAddressInfo(
				ip_address=global_context.webspace_ipv4,
				ip_type=global_context.webspace_ipv4_type,
				public_ip_address=global_context.webspace_ipv4
			))
		if global_context.webspace_ipv6 is not None:
			ips.append(IpAddressInfo(
				ip_address=global_context.webspace_ipv6,
				ip_type=global_context.webspace_ipv6_type,
				public_ip_address=global_context.webspace_ipv6
			))
		return ips