import logging
from parallels.common.actions.base.subscription_action import SubscriptionAction


logger = logging.getLogger(__name__)


class CheckPVPSConnections(SubscriptionAction):
	def get_description(self):
		return "Check connections to Plesk in VPS"

	def get_failure_message(self, global_context, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return "Error while checking connection to Plesk in VPS"

	def filter_subscription(self, global_context, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		return True

	def run(self, global_context, subscription):
		"""
		:type subscription: parallels.common.migrated_subscription.MigratedSubscription
		:type global_context: parallels.common.global_context.GlobalMigrationContext
		"""
		logger.debug(u"Check connections to target nodes")
		subscription.panel_target_server.check_connections()
