"""Model with high-level objects that represents our expectations after migration

It includes objects already existing on target panel, and objects that should
be created on target panel.

Actually most of the objects are reused from parallels.common.target_data_model,
only new PVPSSubscription object is added which is used instead of
parallels.common.target_data_model.Subscription
"""

from parallels.common.utils.yaml_utils import pretty_yaml
from parallels.utils import mutable_namedtuple


PVPSSubscription = pretty_yaml(
	mutable_namedtuple('PVPSSubscription', (
		'name', 'plan_name', 'plan_id',
		'source', 'is_windows', 'mail_is_windows', 'sysuser_login',
		'target_subscription'
	)),
	prefix='target'
)