from parallels.target_panel_pvps.utils.poa_aps2 import POAAPS2


def set_pvps_password(poa_api, subscription_id, password):
	"""
	:type poa_api: parallels.poa_api.Client
	"""
	aps = POAAPS2(poa_api, subscription_id)
	panel_resource = _get_panel_resource(aps, subscription_id)
	environment_id = panel_resource[0][u'environment'][u'aps'][u'id']
	aps.put_resource(environment_id, 'password', {"password": password})


def get_panel_aps_status(poa_api, subscription_id):
	"""
	:type poa_api: parallels.poa_api.Client
	"""
	aps = POAAPS2(poa_api, subscription_id)
	panel_resource = _get_panel_resource(aps, subscription_id)
	return panel_resource[0][u'aps'][u'status']


def _get_panel_resource(aps, subscription_id):
	"""
	:type aps: parallels.target_panel_pvps.utils.poa_aps2.POAAPS2
	:return: list
	"""
	panel_resource = aps.get_resource(
		'http://www.parallels.com/aps/plesk/panel',
		'eq(subscription.subscriptionId,%s),select(environment.aps.id)' % subscription_id
	)
	return panel_resource
