from parallels.common.actions.base.compound_action import CompoundAction
from parallels.common.actions.restore.plesk.import_clients import ImportClients
from parallels.target_panel_pvps.actions.check_pvps_connections import CheckPVPSConnections
from parallels.target_panel_pvps.actions.convert import Convert
from parallels.target_panel_pvps.actions.create_plesk_subscription import CreatePleskSubscription
from parallels.target_panel_pvps.actions.create_pvps_subscription import CreatePVPSSubscription
from parallels.target_panel_pvps.actions.fetch_target import FetchTarget
from parallels.common.actions.apache_restart_interval.restore import RestoreApacheRestartInterval
from parallels.common.actions.apache_restart_interval.set import SetApacheRestartInterval


def extend_workflow_with_pvps_actions(workflow):
	"""Extend shared hosting workflow with PVPS-specific actions

	:type workflow parallels.common.workflow.base_workflow.BaseWorkflow
	:rtype None
	"""

	workflow.replace_shared_action('fetch-target', FetchTarget())

	workflow.replace_shared_action('convert', Convert())
	workflow.replace_shared_action('convert-silent', Convert())

	workflow.get_path('transfer-accounts').replace(
		'restore', CompoundAction("Create clients and subscriptions")
	)
	workflow.get_path('transfer-accounts/restore').insert_action(
		'import-ppa-customers', ImportClients()
	)
	workflow.get_path('transfer-accounts/restore').insert_action(
		'create-pvps-subscription', CreatePVPSSubscription()
	)
	workflow.get_path('transfer-accounts').replace(
		'set-apache-restart-interval', CompoundAction()  # Apache restart interval will be set later
	)

	workflow.get_path('transfer-accounts/restore').insert_action(
		'check-pvps-connections', CheckPVPSConnections()
	)
	workflow.get_path('transfer-accounts/restore').insert_action(
		# Set Apache restart interval after create PVPS subscription.
		'set-pvps-apache-restart-interval', SetApacheRestartInterval()
	)
	workflow.get_path('transfer-accounts/restore').insert_action(
		'create-plesk-subscription', CreatePleskSubscription()
	)
	workflow.get_path('transfer-accounts').insert_action(
		'check-plesk-infrastructure', workflow.get_shared_action_pointer('check-infrastructure'),
		after='restore'
	)

	# TODO: Implement infrastructure pre-checks for PVPS
	workflow.get_path('transfer-accounts').replace('check-connections', CompoundAction())
	workflow.get_path('transfer-accounts').replace('check-target-licenses', CompoundAction())

	workflow.get_path('transfer-accounts').replace('restore-apache-restart-interval', RestoreApacheRestartInterval())

	# TODO: clarify if need to modify
	workflow.get_path('transfer-accounts').replace('sync-subscription-plan', CompoundAction())

	workflow.get_path('check/check-data').replace('check-conflicts', Convert())
