from parallels.common.workflow.shared_hosting_workflow import SharedHostingWorkflow
from parallels.common.actions.base.legacy_action \
	import LegacyAction
from parallels.helm3_migrator.actions.hosting_settings.convert.dns \
	import DNS as ActionHostingSettingsConvertDNS
from parallels.helm3_migrator.actions.replace_db_server_ip \
	import ReplaceDbServerIp
from parallels.helm3_migrator.actions.content.web.copy_windows_content \
	import CopyWindowsWebContent
from parallels.plesks_migrator.actions.content.web.reset_permissions \
	import ResetPermissions
from parallels.helm3_migrator.actions.hosting_settings.transfer_virtual_directories \
	import TransferVirtualDirectories
from parallels.helm3_migrator.actions.hosting_settings.transfer_mime_types \
	import TransferMIMETypes
from parallels.helm3_migrator.actions.hosting_settings.convert.ftp_user_login \
	import FTPUserLogin

from parallels.common.utils.backup_adapter import SubscriptionBackup

class FromHelm3Workflow(SharedHostingWorkflow):
	def __init__(self):
		super(FromHelm3Workflow, self).__init__()

		self.get_shared_action('fetch-source').insert_action(
			'fetch-data', LegacyAction(
				description='Fetch data from source Helm',
				function=lambda ctx: ctx.migrator._fetch_data(
					ctx.options, ctx.options.reload_source_data
				)
			)
		)
		self.get_shared_action('fetch-source').insert_action(
			'replace-db-server-ip',
			ReplaceDbServerIp()
		)

		self.get_path('transfer-accounts/restore-hosting/convert-hosting').replace(
			'convert-dns', ActionHostingSettingsConvertDNS()
		)
		self.get_path('transfer-accounts/restore-hosting/convert-hosting').insert_action(
			'change-ftp-logins', FTPUserLogin(SubscriptionBackup()),
			before='save-backup'
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'copy-files', CopyWindowsWebContent()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'reset-permissions', ResetPermissions()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'transfer-virtual-directories', TransferVirtualDirectories()
		)
		self.get_path('transfer-accounts/copy-content/web').insert_action(
			'transfer-mime-types', TransferMIMETypes()
		)
